%{
/* scanner.l
   
   Lexical analyzer for definition of numeric specifications

   Copyright (C) 2007, 2008, 2009 Eloy Paris

   This is part of Network Expect.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#ifdef HAVE_INTTYPES_H
#include <inttypes.h>
#endif

#include <dnet.h>

#include "numbers.h"
#include "parser.h"
#include "xstrdup.h"
%}

%option noyywrap

/*
 * We don't use unput, so don't generate code for it.
 */
%option nounput

NUMBER		([0-9]+|(0X|0x)[0-9A-Fa-f]+)
IPSTRING	[0-9]+\.[0-9]+\.[0-9]+\.[0-9]+
HOSTNAME	[0-9A-Za-z\-]+\.([0-9A-Za-z\-]+\.)*[0-9A-Za-z\-]+
%%

{NUMBER}	{
		    numspeclval.number = strtoul(yytext, NULL, 0);
		    return NUMBER;
		}

{IPSTRING}	{
		    numspeclval.string = xstrdup(yytext);
		    return IPSTRING;
		}

{HOSTNAME}	{
		    numspeclval.string = xstrdup(yytext);
		    return HOSTNAME;
		}

"+"		return '+';
"-"		return '-';
"*"		return '*';
"/"		return '/';
"%"		return '%';
"("		return '(';
")"		return ')';
"<"		return '<';
">"		return '>';
"++"		return OP_INCR;
"--"		return OP_DECR;
"+="		return OP_ADD;
"-="		return OP_SUB;
"*="		return OP_MUL;
"/="		return OP_DIV;
"%="		return OP_MOD;
"<<="		return OP_SHL;
">>="		return OP_SHR;
".."		return OP_RANGE;

","		return ',';

random		return RANDOM;

[^+\-*/%=., \t()<>]+	{
		    numspeclval.string = xstrdup(yytext);
		    return STRING;
		}

[ \t\r]+        ;       /* whitespace */

%%
