let ocamlc_spec = Some [
  "-a",
  false,
  " Build a library";

  "-alert",
  true,
  "<list>  Enable or disable alerts according to <list>:\n        +<alertname>  enable alert <alertname>\n        -<alertname>  disable alert <alertname>\n        ++<alertname> treat <alertname> as fatal error";

  "--",
  true,
  "<alertname> treat <alertname> as non-fatal\n        @<alertname>  enable <alertname> and treat it as fatal error\n    <alertname> can be 'all' to refer to all alert names";

  "-absname",
  false,
  " Show absolute filenames in error messages";

  "-annot",
  false,
  " (deprecated) Save information in <filename>.annot";

  "-bin-annot",
  false,
  " Save typedtree in <filename>.cmt";

  "-c",
  false,
  " Compile only (do not link)";

  "-cc",
  true,
  "<command>  Use <command> as the C compiler and linker";

  "-cclib",
  true,
  "<opt>  Pass option <opt> to the C linker";

  "-ccopt",
  true,
  "<opt>  Pass option <opt> to the C compiler and linker";

  "-cmi-file",
  true,
  "<file>  Use the <file> interface file to type-check";

  "-color",
  true,
  "{auto|always|never}  Enable or disable colors in compiler messages\n    The following settings are supported:\n      auto    use heuristics to enable colors only if supported\n      always  enable colors\n      never   disable colors\n    The default setting is 'auto', and the current heuristic\n    checks that the TERM environment variable exists and is\n    not empty or \"dumb\", and that isatty(stderr) holds.\n  If the option is not specified, these setting can alternatively\n  be set through the OCAML_COLOR environment variable.";

  "-error-style",
  true,
  "{contextual|short}  Control the way error messages and warnings are printed\n    The following settings are supported:\n      short       only print the error and its location\n      contextual  like \"short\", but also display the source code\n                  snippet corresponding to the location of the error\n    The default setting is 'contextual'.\n  If the option is not specified, these setting can alternatively\n  be set through the OCAML_ERROR_STYLE environment variable.";

  "-compat-32",
  false,
  " Check that generated bytecode can run on 32-bit platforms";

  "-config",
  false,
  " Print configuration values and exit";

  "-config-var",
  false,
  " Print the value of a configuration variable, without a newline, and exit\n    (print nothing and exit with error value if the variable does not exist)";

  "-custom",
  false,
  " Link in custom mode";

  "-dllib",
  true,
  "<lib>  Use the dynamically-loaded library <lib>";

  "-dllpath",
  true,
  "<dir>  Add <dir> to the run-time search path for shared libraries";

  "-dtypes",
  false,
  " (deprecated) same as -annot";

  "-for-pack",
  true,
  "<ident>  Generate code that can later be `packed' with\n     ocamlc -pack -o <ident>.cmo";

  "-g",
  false,
  " Save debugging information";

  "-stop-after",
  true,
  "{parsing|typing} Stop after the given compilation pass.";

  "-i",
  false,
  " Print inferred interface";

  "-I",
  true,
  "<dir>  Add <dir> to the list of include directories";

  "-impl",
  true,
  "<file>  Compile <file> as a .ml file";

  "-intf",
  true,
  "<file>  Compile <file> as a .mli file";

  "-intf-suffix",
  true,
  "<string>  Suffix for interface files (default: .mli)";

  "-intf_suffix",
  true,
  "<string>  (deprecated) same as -intf-suffix";

  "-keep-docs",
  false,
  " Keep documentation strings in .cmi files";

  "-no-keep-docs",
  false,
  " Do not keep documentation strings in .cmi files (default)";

  "-keep-locs",
  false,
  " Keep locations in .cmi files (default)";

  "-no-keep-locs",
  false,
  " Do not keep locations in .cmi files";

  "-labels",
  false,
  " Use commuting label mode";

  "-linkall",
  false,
  " Link all modules, even unused ones";

  "-make-runtime",
  false,
  " Build a runtime system with given C objects and libraries";

  "-make_runtime",
  false,
  " (deprecated) same as -make-runtime";

  "-modern",
  false,
  " (deprecated) same as -labels";

  "-alias-deps",
  false,
  " Do record dependencies for module aliases";

  "-no-alias-deps",
  false,
  " Do not record dependencies for module aliases";

  "-app-funct",
  false,
  " Activate applicative functors";

  "-no-app-funct",
  false,
  " Deactivate applicative functors";

  "-no-check-prims",
  false,
  " Do not check runtime for primitives";

  "-noassert",
  false,
  " Do not compile assertion checks";

  "-noautolink",
  false,
  " Do not automatically link C libraries specified in .cma files";

  "-nolabels",
  false,
  " Ignore non-optional labels in types";

  "-nostdlib",
  false,
  " Do not add default directory to the list of include directories";

  "-nocwd",
  false,
  " Do not implicitly add the current directory to the load path";

  "-nopervasives",
  false,
  " (undocumented)";

  "-o",
  true,
  "<file>  Set output file name to <file>";

  "-opaque",
  false,
  " Does not generate cross-module optimization information\n     (reduces necessary recompilation on module change)";

  "-open",
  true,
  "<module>  Opens the module <module> before typing";

  "-output-obj",
  false,
  " Output an object file instead of an executable";

  "-output-complete-obj",
  false,
  " Output an object file, including runtime, instead of an executable";

  "-output-complete-exe",
  false,
  " Output a self-contained executable, including runtime and C stubs";

  "-pack",
  false,
  " Package the given .cmo files into one .cmo";

  "-pp",
  true,
  "<command>  Pipe sources through preprocessor <command>";

  "-ppx",
  true,
  "<command>  Pipe abstract syntax trees through preprocessor <command>";

  "-plugin",
  true,
  "<plugin>  (no longer supported)";

  "-principal",
  false,
  " Check principality of type inference";

  "-no-principal",
  false,
  " Do not check principality of type inference (default)";

  "-rectypes",
  false,
  " Allow arbitrary recursive types";

  "-no-rectypes",
  false,
  " Do not allow arbitrary recursive types (default)";

  "-runtime-variant",
  true,
  "<str>  Use the <str> variant of the run-time system";

  "-with-runtime",
  false,
  "Include the runtime system in the generated program (default)";

  "-without-runtime",
  false,
  "Do not include the runtime system in the generated program.";

  "-safe-string",
  false,
  " (default unconditionally since 5.0)";

  "-short-paths",
  false,
  " Shorten paths in types";

  "-strict-sequence",
  false,
  " Left-hand part of a sequence must have type unit";

  "-no-strict-sequence",
  false,
  " Left-hand part of a sequence need not have type unit (default)";

  "-strict-formats",
  false,
  " Reject invalid formats accepted by legacy implementations\n     (Warning: Invalid formats may behave differently from\n      previous OCaml versions, and will become always-rejected\n      in future OCaml versions. You should always use this flag\n      to detect invalid formats so you can fix them.)";

  "-no-strict-formats",
  false,
  " Accept invalid formats accepted by legacy implementations (default)\n     (Warning: Invalid formats may behave differently from\n      previous OCaml versions, and will become always-rejected\n      in future OCaml versions. You should never use this flag\n      and instead fix invalid formats.)";

  "-thread",
  false,
  " (deprecated) same as -I +threads";

  "-unboxed-types",
  false,
  " unannotated unboxable types will be unboxed";

  "-no-unboxed-types",
  false,
  " unannotated unboxable types will not be unboxed (default)";

  "-unsafe",
  false,
  " Do not compile bounds checking on array and string access";

  "-unsafe-string",
  false,
  " (option not available)";

  "-use-runtime",
  true,
  "<file>  Generate bytecode for the given runtime system";

  "-use_runtime",
  true,
  "<file>  (deprecated) same as -use-runtime";

  "-v",
  false,
  " Print compiler version and location of standard library and exit";

  "-verbose",
  false,
  " Print calls to external commands";

  "-version",
  false,
  " Print version and exit";

  "--version",
  false,
  " Print version and exit";

  "-vmthread",
  false,
  "  (no longer supported)";

  "-vnum",
  false,
  " Print version number and exit";

  "-w",
  true,
  "<list>  Enable or disable warnings according to <list>:\n        +<spec>   enable warnings in <spec>\n        -<spec>   disable warnings in <spec>\n        @<spec>   enable warnings in <spec> and treat them as errors\n     <spec> can be:\n        <num>             a single warning number\n        <num1>..<num2>    a range of consecutive warning numbers\n        <letter>          a predefined set\n     default setting is \"+a-4-7-9-27-29-30-32..42-44-45-48-50-60-66..70\"";

  "-warn-error",
  true,
  "<list>  Enable or disable error status for warnings according\n     to <list>.  See option -w for the syntax of <list>.\n     Default setting is \"-a+31\"";

  "-warn-help",
  false,
  " Show description of warning numbers";

  "-where",
  false,
  " Print location of standard library and exit";

  "-",
  true,
  "<file>  Treat <file> as a file name (even if it starts with `-')";

  "-match-context-rows",
  true,
  "<n>  (advanced, see manual section 13.2.)";

  "-use-prims",
  true,
  "<file>  (undocumented)";

  "-dno-unique-ids",
  false,
  " (undocumented)";

  "-dunique-ids",
  false,
  " (undocumented)";

  "-dno-locations",
  false,
  " (undocumented)";

  "-dlocations",
  false,
  " (undocumented)";

  "-dsource",
  false,
  " (undocumented)";

  "-dparsetree",
  false,
  " (undocumented)";

  "-dtypedtree",
  false,
  " (undocumented)";

  "-dshape",
  false,
  " (undocumented)";

  "-drawlambda",
  false,
  " (undocumented)";

  "-dlambda",
  false,
  " (undocumented)";

  "-dinstr",
  false,
  " (undocumented)";

  "-dcamlprimc",
  false,
  " (undocumented)";

  "-dtimings",
  false,
  " Print timings information for each pass";

  "-dprofile",
  false,
  " Print performance information for each pass\n    The columns are: time alloc top-heap absolute-top-heap.";

  "-dump-into-file",
  false,
  " dump output like -dlambda into <target>.dump";

  "-dump-dir",
  true,
  "<dir> dump output like -dlambda into <dir>/<target>.dump";

  "-args",
  true,
  "<file> Read additional newline-terminated command line arguments\n      from <file>";

  "-args0",
  true,
  "<file> Read additional null character terminated command line arguments\nfrom <file>";

  "-depend",
  true,
  "<options> Compute dependencies (use 'ocamlc -depend -help' for details)";

];;

let ocamlcp_spec = Some [
  "-P",
  true,
  "[afilmt]  Profile constructs specified by argument (default fm):\n      a  Everything\n      f  Function calls and method calls\n      i  if ... then ... else\n      l  while and for loops\n      m  match ... with\n      t  try ... with";

  "-p",
  true,
  "[afilmt]  Same as option -P";

  "-a",
  false,
  " Build a library";

  "-alert",
  true,
  "<list>  Enable or disable alerts according to <list>:\n        +<alertname>  enable alert <alertname>\n        -<alertname>  disable alert <alertname>\n        ++<alertname> treat <alertname> as fatal error";

  "--",
  true,
  "<alertname> treat <alertname> as non-fatal\n        @<alertname>  enable <alertname> and treat it as fatal error\n    <alertname> can be 'all' to refer to all alert names";

  "-absname",
  false,
  " Show absolute filenames in error messages";

  "-annot",
  false,
  " (deprecated) Save information in <filename>.annot";

  "-bin-annot",
  false,
  " Save typedtree in <filename>.cmt";

  "-c",
  false,
  " Compile only (do not link)";

  "-cc",
  true,
  "<command>  Use <command> as the C compiler and linker";

  "-cclib",
  true,
  "<opt>  Pass option <opt> to the C linker";

  "-ccopt",
  true,
  "<opt>  Pass option <opt> to the C compiler and linker";

  "-cmi-file",
  true,
  "<file>  Use the <file> interface file to type-check";

  "-color",
  true,
  "{auto|always|never}  Enable or disable colors in compiler messages\n    The following settings are supported:\n      auto    use heuristics to enable colors only if supported\n      always  enable colors\n      never   disable colors\n    The default setting is 'auto', and the current heuristic\n    checks that the TERM environment variable exists and is\n    not empty or \"dumb\", and that isatty(stderr) holds.\n  If the option is not specified, these setting can alternatively\n  be set through the OCAML_COLOR environment variable.";

  "-error-style",
  true,
  "{contextual|short}  Control the way error messages and warnings are printed\n    The following settings are supported:\n      short       only print the error and its location\n      contextual  like \"short\", but also display the source code\n                  snippet corresponding to the location of the error\n    The default setting is 'contextual'.\n  If the option is not specified, these setting can alternatively\n  be set through the OCAML_ERROR_STYLE environment variable.";

  "-compat-32",
  false,
  " Check that generated bytecode can run on 32-bit platforms";

  "-config",
  false,
  " Print configuration values and exit";

  "-config-var",
  false,
  " Print the value of a configuration variable, without a newline, and exit\n    (print nothing and exit with error value if the variable does not exist)";

  "-custom",
  false,
  " Link in custom mode";

  "-dllib",
  true,
  "<lib>  Use the dynamically-loaded library <lib>";

  "-dllpath",
  true,
  "<dir>  Add <dir> to the run-time search path for shared libraries";

  "-dtypes",
  false,
  " (deprecated) same as -annot";

  "-for-pack",
  true,
  "<ident>  Generate code that can later be `packed' with\n     ocamlc -pack -o <ident>.cmo";

  "-g",
  false,
  " Save debugging information";

  "-stop-after",
  true,
  "{parsing|typing} Stop after the given compilation pass.";

  "-i",
  false,
  " Print inferred interface";

  "-I",
  true,
  "<dir>  Add <dir> to the list of include directories";

  "-impl",
  true,
  "<file>  Compile <file> as a .ml file";

  "-intf",
  true,
  "<file>  Compile <file> as a .mli file";

  "-intf-suffix",
  true,
  "<string>  Suffix for interface files (default: .mli)";

  "-intf_suffix",
  true,
  "<string>  (deprecated) same as -intf-suffix";

  "-keep-docs",
  false,
  " Keep documentation strings in .cmi files";

  "-no-keep-docs",
  false,
  " Do not keep documentation strings in .cmi files (default)";

  "-keep-locs",
  false,
  " Keep locations in .cmi files (default)";

  "-no-keep-locs",
  false,
  " Do not keep locations in .cmi files";

  "-labels",
  false,
  " Use commuting label mode";

  "-linkall",
  false,
  " Link all modules, even unused ones";

  "-make-runtime",
  false,
  " Build a runtime system with given C objects and libraries";

  "-make_runtime",
  false,
  " (deprecated) same as -make-runtime";

  "-modern",
  false,
  " (deprecated) same as -labels";

  "-alias-deps",
  false,
  " Do record dependencies for module aliases";

  "-no-alias-deps",
  false,
  " Do not record dependencies for module aliases";

  "-app-funct",
  false,
  " Activate applicative functors";

  "-no-app-funct",
  false,
  " Deactivate applicative functors";

  "-no-check-prims",
  false,
  " Do not check runtime for primitives";

  "-noassert",
  false,
  " Do not compile assertion checks";

  "-noautolink",
  false,
  " Do not automatically link C libraries specified in .cma files";

  "-nolabels",
  false,
  " Ignore non-optional labels in types";

  "-nostdlib",
  false,
  " Do not add default directory to the list of include directories";

  "-nocwd",
  false,
  " Do not implicitly add the current directory to the load path";

  "-nopervasives",
  false,
  " (undocumented)";

  "-o",
  true,
  "<file>  Set output file name to <file>";

  "-opaque",
  false,
  " Does not generate cross-module optimization information\n     (reduces necessary recompilation on module change)";

  "-open",
  true,
  "<module>  Opens the module <module> before typing";

  "-output-obj",
  false,
  " Output an object file instead of an executable";

  "-output-complete-obj",
  false,
  " Output an object file, including runtime, instead of an executable";

  "-output-complete-exe",
  false,
  " Output a self-contained executable, including runtime and C stubs";

  "-pack",
  false,
  " Package the given .cmo files into one .cmo";

  "-pp",
  true,
  "<command>  Pipe sources through preprocessor <command>";

  "-ppx",
  true,
  "<command>  Pipe abstract syntax trees through preprocessor <command>";

  "-plugin",
  true,
  "<plugin>  (no longer supported)";

  "-principal",
  false,
  " Check principality of type inference";

  "-no-principal",
  false,
  " Do not check principality of type inference (default)";

  "-rectypes",
  false,
  " Allow arbitrary recursive types";

  "-no-rectypes",
  false,
  " Do not allow arbitrary recursive types (default)";

  "-runtime-variant",
  true,
  "<str>  Use the <str> variant of the run-time system";

  "-with-runtime",
  false,
  "Include the runtime system in the generated program (default)";

  "-without-runtime",
  false,
  "Do not include the runtime system in the generated program.";

  "-safe-string",
  false,
  " (default unconditionally since 5.0)";

  "-short-paths",
  false,
  " Shorten paths in types";

  "-strict-sequence",
  false,
  " Left-hand part of a sequence must have type unit";

  "-no-strict-sequence",
  false,
  " Left-hand part of a sequence need not have type unit (default)";

  "-strict-formats",
  false,
  " Reject invalid formats accepted by legacy implementations\n     (Warning: Invalid formats may behave differently from\n      previous OCaml versions, and will become always-rejected\n      in future OCaml versions. You should always use this flag\n      to detect invalid formats so you can fix them.)";

  "-no-strict-formats",
  false,
  " Accept invalid formats accepted by legacy implementations (default)\n     (Warning: Invalid formats may behave differently from\n      previous OCaml versions, and will become always-rejected\n      in future OCaml versions. You should never use this flag\n      and instead fix invalid formats.)";

  "-thread",
  false,
  " (deprecated) same as -I +threads";

  "-unboxed-types",
  false,
  " unannotated unboxable types will be unboxed";

  "-no-unboxed-types",
  false,
  " unannotated unboxable types will not be unboxed (default)";

  "-unsafe",
  false,
  " Do not compile bounds checking on array and string access";

  "-unsafe-string",
  false,
  " (option not available)";

  "-use-runtime",
  true,
  "<file>  Generate bytecode for the given runtime system";

  "-use_runtime",
  true,
  "<file>  (deprecated) same as -use-runtime";

  "-v",
  false,
  " Print compiler version and location of standard library and exit";

  "-verbose",
  false,
  " Print calls to external commands";

  "-version",
  false,
  " Print version and exit";

  "--version",
  false,
  " Print version and exit";

  "-vmthread",
  false,
  "  (no longer supported)";

  "-vnum",
  false,
  " Print version number and exit";

  "-w",
  true,
  "<list>  Enable or disable warnings according to <list>:\n        +<spec>   enable warnings in <spec>\n        -<spec>   disable warnings in <spec>\n        @<spec>   enable warnings in <spec> and treat them as errors\n     <spec> can be:\n        <num>             a single warning number\n        <num1>..<num2>    a range of consecutive warning numbers\n        <letter>          a predefined set\n     default setting is \"+a-4-7-9-27-29-30-32..42-44-45-48-50-60-66..70\"";

  "-warn-error",
  true,
  "<list>  Enable or disable error status for warnings according\n     to <list>.  See option -w for the syntax of <list>.\n     Default setting is \"-a+31\"";

  "-warn-help",
  false,
  " Show description of warning numbers";

  "-where",
  false,
  " Print location of standard library and exit";

  "-",
  true,
  "<file>  Treat <file> as a file name (even if it starts with `-')";

  "-match-context-rows",
  true,
  "<n>  (advanced, see manual section 13.2.)";

  "-use-prims",
  true,
  "<file>  (undocumented)";

  "-dno-unique-ids",
  false,
  " (undocumented)";

  "-dunique-ids",
  false,
  " (undocumented)";

  "-dno-locations",
  false,
  " (undocumented)";

  "-dlocations",
  false,
  " (undocumented)";

  "-dsource",
  false,
  " (undocumented)";

  "-dparsetree",
  false,
  " (undocumented)";

  "-dtypedtree",
  false,
  " (undocumented)";

  "-dshape",
  false,
  " (undocumented)";

  "-drawlambda",
  false,
  " (undocumented)";

  "-dlambda",
  false,
  " (undocumented)";

  "-dinstr",
  false,
  " (undocumented)";

  "-dcamlprimc",
  false,
  " (undocumented)";

  "-dtimings",
  false,
  " Print timings information for each pass";

  "-dprofile",
  false,
  " Print performance information for each pass\n    The columns are: time alloc top-heap absolute-top-heap.";

  "-dump-into-file",
  false,
  " dump output like -dlambda into <target>.dump";

  "-dump-dir",
  true,
  "<dir> dump output like -dlambda into <dir>/<target>.dump";

  "-args",
  true,
  "<file> Read additional newline-terminated command line arguments\n      from <file>";

  "-args0",
  true,
  "<file> Read additional null character terminated command line arguments\nfrom <file>";

];;

let ocamloptp_spec = Some [
  "-P",
  true,
  "[afilmt]  Profile constructs specified by argument (default fm):\n      a  Everything\n      f  Function calls and method calls\n      i  if ... then ... else\n      l  while and for loops\n      m  match ... with\n      t  try ... with";

  "-a",
  false,
  " Build a library";

  "-alert",
  true,
  "<list>  Enable or disable alerts according to <list>:\n        +<alertname>  enable alert <alertname>\n        -<alertname>  disable alert <alertname>\n        ++<alertname> treat <alertname> as fatal error";

  "--",
  true,
  "<alertname> treat <alertname> as non-fatal\n        @<alertname>  enable <alertname> and treat it as fatal error\n    <alertname> can be 'all' to refer to all alert names";

  "-absname",
  false,
  " Show absolute filenames in error messages";

  "-afl-instrument",
  false,
  "Enable instrumentation for afl-fuzz";

  "-afl-inst-ratio",
  false,
  "Configure percentage of branches instrumented\n     (advanced, see afl-fuzz docs for AFL_INST_RATIO)";

  "-annot",
  false,
  " (deprecated) Save information in <filename>.annot";

  "-bin-annot",
  false,
  " Save typedtree in <filename>.cmt";

  "-inline-branch-factor",
  true,
  "<n>|<round>=<n>[,...]  Estimate the probability of a branch being cold as 1/(1+n) (used for inlining) (default 0.10)";

  "-c",
  false,
  " Compile only (do not link)";

  "-cc",
  true,
  "<command>  Use <command> as the C compiler and linker";

  "-cclib",
  true,
  "<opt>  Pass option <opt> to the C linker";

  "-ccopt",
  true,
  "<opt>  Pass option <opt> to the C compiler and linker";

  "-cmi-file",
  true,
  "<file>  Use the <file> interface file to type-check";

  "-clambda-checks",
  false,
  " Instrument clambda code with closure and field access checks (for debugging the compiler)";

  "-Oclassic",
  false,
  " Make inlining decisions at function definition time rather than at the call site (replicates previous behaviour of the compiler)";

  "-color",
  true,
  "{auto|always|never}  Enable or disable colors in compiler messages\n    The following settings are supported:\n      auto    use heuristics to enable colors only if supported\n      always  enable colors\n      never   disable colors\n    The default setting is 'auto', and the current heuristic\n    checks that the TERM environment variable exists and is\n    not empty or \"dumb\", and that isatty(stderr) holds.\n  If the option is not specified, these setting can alternatively\n  be set through the OCAML_COLOR environment variable.";

  "-error-style",
  true,
  "{contextual|short}  Control the way error messages and warnings are printed\n    The following settings are supported:\n      short       only print the error and its location\n      contextual  like \"short\", but also display the source code\n                  snippet corresponding to the location of the error\n    The default setting is 'contextual'.\n  If the option is not specified, these setting can alternatively\n  be set through the OCAML_ERROR_STYLE environment variable.";

  "-compact",
  false,
  " Optimize code size rather than speed";

  "-config",
  false,
  " Print configuration values and exit";

  "-config-var",
  false,
  " Print the value of a configuration variable, without a newline, and exit\n    (print nothing and exit with error value if the variable does not exist)";

  "-dtypes",
  false,
  " (deprecated) same as -annot";

  "-for-pack",
  true,
  "<ident>  Generate code that can later be `packed' with\n     ocamlopt -pack -o <ident>.cmx";

  "-g",
  false,
  " Record debugging information for exception backtrace";

  "-function-sections",
  false,
  " Generate each function in a separate section if target supports it";

  "-stop-after",
  true,
  "{parsing|typing|scheduling|emit} Stop after the given compilation pass.";

  "-save-ir-after",
  true,
  "{scheduling} Save intermediate representation after the given compilation pass(may be specified more than once).";

  "-i",
  false,
  " Print inferred interface";

  "-I",
  true,
  "<dir>  Add <dir> to the list of include directories";

  "-impl",
  true,
  "<file>  Compile <file> as a .ml file";

  "-inline",
  true,
  "<n>|<round>=<n>[,...]  Aggressiveness of inlining (default 1.25, higher numbers mean more aggressive)";

  "-inline-toplevel",
  true,
  "<n>|<round>=<n>[,...]  Aggressiveness of inlining at toplevel (higher numbers mean more aggressive)";

  "-inline-alloc-cost",
  true,
  "<n>|<round>=<n>[,...]  The cost of not removing an allocation during inlining (default 7, higher numbers more costly)";

  "-inline-branch-cost",
  true,
  "<n>|<round>=<n>[,...]  The cost of not removing a conditional during inlining (default 5, higher numbers more costly)";

  "-inline-call-cost",
  true,
  "<n>|<round>=<n>[,...]  The cost of not removing a call during inlining (default 5, higher numbers more costly)";

  "-inline-prim-cost",
  true,
  "<n>|<round>=<n>[,...]  The cost of not removing a primitive during inlining (default 3, higher numbers more costly)";

  "-inline-indirect-cost",
  true,
  "<n>|<round>=<n>[,...]  The cost of not removing an indirect call during inlining (default 4, higher numbers more costly)";

  "-inline-lifting-benefit",
  true,
  "<n>|<round>=<n>[,...]  The benefit of lifting definitions to toplevel during inlining (default 1300, higher numbers more beneficial)";

  "-inlining-report",
  false,
  " Emit `.<round>.inlining' file(s) (one per round) showing the inliner's decisions";

  "-insn-sched",
  false,
  " Run the instruction scheduling pass (default)";

  "-intf",
  true,
  "<file>  Compile <file> as a .mli file";

  "-intf-suffix",
  true,
  "<string>  Suffix for interface files (default: .mli)";

  "-keep-docs",
  false,
  " Keep documentation strings in .cmi files";

  "-no-keep-docs",
  false,
  " Do not keep documentation strings in .cmi files (default)";

  "-keep-locs",
  false,
  " Keep locations in .cmi files (default)";

  "-no-keep-locs",
  false,
  " Do not keep locations in .cmi files";

  "-labels",
  false,
  " Use commuting label mode";

  "-linkall",
  false,
  " Link all modules, even unused ones";

  "-inline-max-depth",
  true,
  "<n>|<round>=<n>[,...]  Maximum depth of search for inlining opportunities inside inlined functions (default 1)";

  "-alias-deps",
  false,
  " Do record dependencies for module aliases";

  "-no-alias-deps",
  false,
  " Do not record dependencies for module aliases";

  "-linscan",
  false,
  " Use the linear scan register allocator";

  "-app-funct",
  false,
  " Activate applicative functors";

  "-no-app-funct",
  false,
  " Deactivate applicative functors";

  "-no-float-const-prop",
  false,
  " Deactivate constant propagation for floating-point operations";

  "-noassert",
  false,
  " Do not compile assertion checks";

  "-noautolink",
  false,
  " Do not automatically link C libraries specified in .cmxa files";

  "-nodynlink",
  false,
  " Enable optimizations for code that will not be dynlinked";

  "-no-insn-sched",
  false,
  " Do not run the instruction scheduling pass";

  "-nolabels",
  false,
  " Ignore non-optional labels in types";

  "-nostdlib",
  false,
  " Do not add default directory to the list of include directories";

  "-nocwd",
  false,
  " Do not implicitly add the current directory to the load path";

  "-nopervasives",
  false,
  " (undocumented)";

  "-no-unbox-free-vars-of-closures",
  false,
  " Do not unbox variables that will appear inside function closures";

  "-no-unbox-specialised-args",
  false,
  " Do not unbox arguments to which functions have been specialised";

  "-o",
  true,
  "<file>  Set output file name to <file>";

  "-O2",
  false,
  " Apply increased optimization for speed";

  "-O3",
  false,
  " Apply aggressive optimization for speed (may significantly increase code size and compilation time)";

  "-opaque",
  false,
  " Does not generate cross-module optimization information\n     (reduces necessary recompilation on module change)";

  "-open",
  true,
  "<module>  Opens the module <module> before typing";

  "-output-obj",
  false,
  " Output an object file instead of an executable";

  "-output-complete-obj",
  false,
  " Output an object file, including runtime, instead of an executable";

  "-p",
  false,
  " (no longer supported)";

  "-pack",
  false,
  " Package the given .cmx files into one .cmx";

  "-plugin",
  true,
  "<plugin>  (no longer supported)";

  "-pp",
  true,
  "<command>  Pipe sources through preprocessor <command>";

  "-ppx",
  true,
  "<command>  Pipe abstract syntax trees through preprocessor <command>";

  "-principal",
  false,
  " Check principality of type inference";

  "-no-principal",
  false,
  " Do not check principality of type inference (default)";

  "-rectypes",
  false,
  " Allow arbitrary recursive types";

  "-no-rectypes",
  false,
  " Do not allow arbitrary recursive types (default)";

  "-remove-unused-arguments",
  false,
  " Remove unused function arguments";

  "-rounds",
  true,
  "<n>  Repeat tree optimization and inlining phases this many times (default 1).  Rounds are numbered starting from zero.";

  "-runtime-variant",
  true,
  "<str>  Use the <str> variant of the run-time system";

  "-with-runtime",
  false,
  "Include the runtime system in the generated program (default)";

  "-without-runtime",
  false,
  "Do not include the runtime system in the generated program.";

  "-S",
  false,
  " Keep intermediate assembly file";

  "-safe-string",
  false,
  " (default unconditionally since 5.0)";

  "-shared",
  false,
  " Produce a dynlinkable plugin";

  "-short-paths",
  false,
  " Shorten paths in types";

  "-strict-sequence",
  false,
  " Left-hand part of a sequence must have type unit";

  "-no-strict-sequence",
  false,
  " Left-hand part of a sequence need not have type unit (default)";

  "-strict-formats",
  false,
  " Reject invalid formats accepted by legacy implementations\n     (Warning: Invalid formats may behave differently from\n      previous OCaml versions, and will become always-rejected\n      in future OCaml versions. You should always use this flag\n      to detect invalid formats so you can fix them.)";

  "-no-strict-formats",
  false,
  " Accept invalid formats accepted by legacy implementations (default)\n     (Warning: Invalid formats may behave differently from\n      previous OCaml versions, and will become always-rejected\n      in future OCaml versions. You should never use this flag\n      and instead fix invalid formats.)";

  "-thread",
  false,
  " (deprecated) same as -I +threads";

  "-unbox-closures",
  false,
  " Pass free variables via specialised arguments rather than closures";

  "-unbox-closures-factor",
  true,
  "<n > 0>  Scale the size threshold above which unbox-closures will slow down indirect calls rather than duplicating a function (default 10)";

  "-inline-max-unroll",
  true,
  "<n>|<round>=<n>[,...]  Unroll recursive functions at most this many times (default 0)";

  "-unboxed-types",
  false,
  " unannotated unboxable types will be unboxed";

  "-no-unboxed-types",
  false,
  " unannotated unboxable types will not be unboxed (default)";

  "-unsafe",
  false,
  " Do not compile bounds checking on array and string access";

  "-unsafe-string",
  false,
  " (option not available)";

  "-v",
  false,
  " Print compiler version and location of standard library and exit";

  "-verbose",
  false,
  " Print calls to external commands";

  "-version",
  false,
  " Print version and exit";

  "--version",
  false,
  " Print version and exit";

  "-vnum",
  false,
  " Print version number and exit";

  "-w",
  true,
  "<list>  Enable or disable warnings according to <list>:\n        +<spec>   enable warnings in <spec>\n        -<spec>   disable warnings in <spec>\n        @<spec>   enable warnings in <spec> and treat them as errors\n     <spec> can be:\n        <num>             a single warning number\n        <num1>..<num2>    a range of consecutive warning numbers\n        <letter>          a predefined set\n     default setting is \"+a-4-7-9-27-29-30-32..42-44-45-48-50-60-66..70\"";

  "-warn-error",
  true,
  "<list>  Enable or disable error status for warnings according\n     to <list>.  See option -w for the syntax of <list>.\n     Default setting is \"-a+31\"";

  "-warn-help",
  false,
  " Show description of warning numbers";

  "-where",
  false,
  " Print location of standard library and exit";

  "-",
  true,
  "<file>  Treat <file> as a file name (even if it starts with `-')";

  "-match-context-rows",
  true,
  "<n>  (advanced, see manual section 13.2.)";

  "-dno-unique-ids",
  false,
  " (undocumented)";

  "-dunique-ids",
  false,
  " (undocumented)";

  "-dno-locations",
  false,
  " (undocumented)";

  "-dlocations",
  false,
  " (undocumented)";

  "-dsource",
  false,
  " (undocumented)";

  "-dparsetree",
  false,
  " (undocumented)";

  "-dtypedtree",
  false,
  " (undocumented)";

  "-dshape",
  false,
  " (undocumented)";

  "-drawlambda",
  false,
  " (undocumented)";

  "-dlambda",
  false,
  " (undocumented)";

  "-drawclambda",
  false,
  " (undocumented)";

  "-dclambda",
  false,
  " (undocumented)";

  "-dcmm-invariants",
  false,
  " Extra sanity checks on Cmm";

  "-dflambda",
  false,
  " Print Flambda terms";

  "-drawflambda",
  false,
  " Print Flambda terms after closure conversion";

  "-dflambda-invariants",
  false,
  " Check Flambda invariants around each pass";

  "-dflambda-no-invariants",
  false,
  " Do not Check Flambda invariants around each pass";

  "-dflambda-let",
  true,
  "<stamp>  Print when the given Flambda [Let] is created";

  "-dflambda-verbose",
  false,
  " Print Flambda terms including around each pass";

  "-dcmm",
  false,
  " (undocumented)";

  "-dsel",
  false,
  " (undocumented)";

  "-dcombine",
  false,
  " (undocumented)";

  "-dcse",
  false,
  " (undocumented)";

  "-dlive",
  false,
  " (undocumented)";

  "-dspill",
  false,
  " (undocumented)";

  "-dsplit",
  false,
  " (undocumented)";

  "-dinterf",
  false,
  " (undocumented)";

  "-dprefer",
  false,
  " (undocumented)";

  "-dalloc",
  false,
  " (undocumented)";

  "-dreload",
  false,
  " (undocumented)";

  "-dscheduling",
  false,
  " (undocumented)";

  "-dlinear",
  false,
  " (undocumented)";

  "-dinterval",
  false,
  " (undocumented)";

  "-dstartup",
  false,
  " (undocumented)";

  "-dtimings",
  false,
  " Print timings information for each pass";

  "-dprofile",
  false,
  " Print performance information for each pass\n    The columns are: time alloc top-heap absolute-top-heap.";

  "-dump-into-file",
  false,
  " dump output like -dlambda into <target>.dump";

  "-dump-dir",
  true,
  "<dir> dump output like -dlambda into <dir>/<target>.dump";

  "-dump-pass",
  false,
  " Record transformations performed by these passes: ";

  "-args",
  true,
  "<file> Read additional newline-terminated command line arguments\n      from <file>";

  "-args0",
  true,
  "<file> Read additional null character terminated command line arguments\nfrom <file>";

];;

let ocamlmklib_spec = Some [
  "-args",
  true,
  "<file>   Read additional newline-terminated command line arguments\n                 from <file>";

  "-args0",
  true,
  "<file>  Read additional null character terminated command line\n                 arguments from <file>";

  "-cclib",
  true,
  "<lib>   C library passed to ocamlc -a or ocamlopt -a only";

  "-ccopt",
  true,
  "<opt>   C option passed to ocamlc -a or ocamlopt -a only";

  "-custom",
  false,
  "       Disable dynamic loading";

  "-g",
  false,
  "            Build with debug information";

  "-dllpath",
  true,
  "<dir> Add <dir> to the run-time search path for DLLs";

  "-F",
  true,
  "<dir>        Specify a framework directory (MacOSX)";

  "-framework",
  true,
  "<name>    Use framework <name> (MacOSX)";

  "-h",
  false,
  "            Same as -help";

  "-I",
  true,
  "<dir>       Add <dir> to the path searched for OCaml object files";

  "-failsafe",
  false,
  "     fall back to static linking if DLL construction failed";

  "-ldopt",
  true,
  "<opt>   C option passed to the shared linker only";

  "-linkall",
  false,
  "      Build OCaml archive with link-all behavior";

  "-l",
  true,
  "<lib>        Specify a dependent C library";

  "-L",
  true,
  "<dir>        Add <dir> to the path searched for C libraries";

  "-ocamlc",
  true,
  "<cmd>  Use <cmd> in place of \"ocamlc\"";

  "-ocamlcflags",
  true,
  "<opt>    Pass <opt> to ocamlc";

  "-ocamlopt",
  true,
  "<cmd> Use <cmd> in place of \"ocamlopt\"";

  "-ocamloptflags",
  true,
  "<opt>  Pass <opt> to ocamlopt";

  "-o",
  true,
  "<name>      Generated OCaml library is named <name>.cma or <name>.cmxa";

  "-oc",
  true,
  "<name>     Generated C library is named dll<name>.so or lib<name>.a";

  "-rpath",
  true,
  "<dir>   Same as -dllpath <dir>";

  "-R",
  true,
  "<dir>        Same as -rpath";

  "-verbose",
  false,
  "      Print commands before executing them";

  "-v",
  false,
  "            same as -verbose";

  "-version",
  false,
  "      Print version and exit";

  "-vnum",
  false,
  "         Print version number and exit";

  "-Wl,-rpath,",
  true,
  "<dir>     Same as -dllpath <dir>";

  "-Wl,-rpath",
  false,
  "-Wl,<dir> Same as -dllpath <dir>";

  "-Wl,-R",
  true,
  "<dir>          Same as -dllpath <dir>";

];;

let ocamlmktop_spec = Some [
  "-a",
  false,
  " Build a library";

  "-alert",
  true,
  "<list>  Enable or disable alerts according to <list>:\n        +<alertname>  enable alert <alertname>\n        -<alertname>  disable alert <alertname>\n        ++<alertname> treat <alertname> as fatal error";

  "--",
  true,
  "<alertname> treat <alertname> as non-fatal\n        @<alertname>  enable <alertname> and treat it as fatal error\n    <alertname> can be 'all' to refer to all alert names";

  "-absname",
  false,
  " Show absolute filenames in error messages";

  "-annot",
  false,
  " (deprecated) Save information in <filename>.annot";

  "-bin-annot",
  false,
  " Save typedtree in <filename>.cmt";

  "-c",
  false,
  " Compile only (do not link)";

  "-cc",
  true,
  "<command>  Use <command> as the C compiler and linker";

  "-cclib",
  true,
  "<opt>  Pass option <opt> to the C linker";

  "-ccopt",
  true,
  "<opt>  Pass option <opt> to the C compiler and linker";

  "-cmi-file",
  true,
  "<file>  Use the <file> interface file to type-check";

  "-color",
  true,
  "{auto|always|never}  Enable or disable colors in compiler messages\n    The following settings are supported:\n      auto    use heuristics to enable colors only if supported\n      always  enable colors\n      never   disable colors\n    The default setting is 'auto', and the current heuristic\n    checks that the TERM environment variable exists and is\n    not empty or \"dumb\", and that isatty(stderr) holds.\n  If the option is not specified, these setting can alternatively\n  be set through the OCAML_COLOR environment variable.";

  "-error-style",
  true,
  "{contextual|short}  Control the way error messages and warnings are printed\n    The following settings are supported:\n      short       only print the error and its location\n      contextual  like \"short\", but also display the source code\n                  snippet corresponding to the location of the error\n    The default setting is 'contextual'.\n  If the option is not specified, these setting can alternatively\n  be set through the OCAML_ERROR_STYLE environment variable.";

  "-compat-32",
  false,
  " Check that generated bytecode can run on 32-bit platforms";

  "-config",
  false,
  " Print configuration values and exit";

  "-config-var",
  false,
  " Print the value of a configuration variable, without a newline, and exit\n    (print nothing and exit with error value if the variable does not exist)";

  "-custom",
  false,
  " Link in custom mode";

  "-dllib",
  true,
  "<lib>  Use the dynamically-loaded library <lib>";

  "-dllpath",
  true,
  "<dir>  Add <dir> to the run-time search path for shared libraries";

  "-dtypes",
  false,
  " (deprecated) same as -annot";

  "-for-pack",
  true,
  "<ident>  Generate code that can later be `packed' with\n     ocamlc -pack -o <ident>.cmo";

  "-g",
  false,
  " Save debugging information";

  "-stop-after",
  true,
  "{parsing|typing} Stop after the given compilation pass.";

  "-i",
  false,
  " Print inferred interface";

  "-I",
  true,
  "<dir>  Add <dir> to the list of include directories";

  "-impl",
  true,
  "<file>  Compile <file> as a .ml file";

  "-intf",
  true,
  "<file>  Compile <file> as a .mli file";

  "-intf-suffix",
  true,
  "<string>  Suffix for interface files (default: .mli)";

  "-intf_suffix",
  true,
  "<string>  (deprecated) same as -intf-suffix";

  "-keep-docs",
  false,
  " Keep documentation strings in .cmi files";

  "-no-keep-docs",
  false,
  " Do not keep documentation strings in .cmi files (default)";

  "-keep-locs",
  false,
  " Keep locations in .cmi files (default)";

  "-no-keep-locs",
  false,
  " Do not keep locations in .cmi files";

  "-labels",
  false,
  " Use commuting label mode";

  "-linkall",
  false,
  " Link all modules, even unused ones";

  "-make-runtime",
  false,
  " Build a runtime system with given C objects and libraries";

  "-make_runtime",
  false,
  " (deprecated) same as -make-runtime";

  "-modern",
  false,
  " (deprecated) same as -labels";

  "-alias-deps",
  false,
  " Do record dependencies for module aliases";

  "-no-alias-deps",
  false,
  " Do not record dependencies for module aliases";

  "-app-funct",
  false,
  " Activate applicative functors";

  "-no-app-funct",
  false,
  " Deactivate applicative functors";

  "-no-check-prims",
  false,
  " Do not check runtime for primitives";

  "-noassert",
  false,
  " Do not compile assertion checks";

  "-noautolink",
  false,
  " Do not automatically link C libraries specified in .cma files";

  "-nolabels",
  false,
  " Ignore non-optional labels in types";

  "-nostdlib",
  false,
  " Do not add default directory to the list of include directories";

  "-nocwd",
  false,
  " Do not implicitly add the current directory to the load path";

  "-nopervasives",
  false,
  " (undocumented)";

  "-o",
  true,
  "<file>  Set output file name to <file>";

  "-opaque",
  false,
  " Does not generate cross-module optimization information\n     (reduces necessary recompilation on module change)";

  "-open",
  true,
  "<module>  Opens the module <module> before typing";

  "-output-obj",
  false,
  " Output an object file instead of an executable";

  "-output-complete-obj",
  false,
  " Output an object file, including runtime, instead of an executable";

  "-output-complete-exe",
  false,
  " Output a self-contained executable, including runtime and C stubs";

  "-pack",
  false,
  " Package the given .cmo files into one .cmo";

  "-pp",
  true,
  "<command>  Pipe sources through preprocessor <command>";

  "-ppx",
  true,
  "<command>  Pipe abstract syntax trees through preprocessor <command>";

  "-plugin",
  true,
  "<plugin>  (no longer supported)";

  "-principal",
  false,
  " Check principality of type inference";

  "-no-principal",
  false,
  " Do not check principality of type inference (default)";

  "-rectypes",
  false,
  " Allow arbitrary recursive types";

  "-no-rectypes",
  false,
  " Do not allow arbitrary recursive types (default)";

  "-runtime-variant",
  true,
  "<str>  Use the <str> variant of the run-time system";

  "-with-runtime",
  false,
  "Include the runtime system in the generated program (default)";

  "-without-runtime",
  false,
  "Do not include the runtime system in the generated program.";

  "-safe-string",
  false,
  " (default unconditionally since 5.0)";

  "-short-paths",
  false,
  " Shorten paths in types";

  "-strict-sequence",
  false,
  " Left-hand part of a sequence must have type unit";

  "-no-strict-sequence",
  false,
  " Left-hand part of a sequence need not have type unit (default)";

  "-strict-formats",
  false,
  " Reject invalid formats accepted by legacy implementations\n     (Warning: Invalid formats may behave differently from\n      previous OCaml versions, and will become always-rejected\n      in future OCaml versions. You should always use this flag\n      to detect invalid formats so you can fix them.)";

  "-no-strict-formats",
  false,
  " Accept invalid formats accepted by legacy implementations (default)\n     (Warning: Invalid formats may behave differently from\n      previous OCaml versions, and will become always-rejected\n      in future OCaml versions. You should never use this flag\n      and instead fix invalid formats.)";

  "-thread",
  false,
  " (deprecated) same as -I +threads";

  "-unboxed-types",
  false,
  " unannotated unboxable types will be unboxed";

  "-no-unboxed-types",
  false,
  " unannotated unboxable types will not be unboxed (default)";

  "-unsafe",
  false,
  " Do not compile bounds checking on array and string access";

  "-unsafe-string",
  false,
  " (option not available)";

  "-use-runtime",
  true,
  "<file>  Generate bytecode for the given runtime system";

  "-use_runtime",
  true,
  "<file>  (deprecated) same as -use-runtime";

  "-v",
  false,
  " Print compiler version and location of standard library and exit";

  "-verbose",
  false,
  " Print calls to external commands";

  "-version",
  false,
  " Print version and exit";

  "--version",
  false,
  " Print version and exit";

  "-vmthread",
  false,
  "  (no longer supported)";

  "-vnum",
  false,
  " Print version number and exit";

  "-w",
  true,
  "<list>  Enable or disable warnings according to <list>:\n        +<spec>   enable warnings in <spec>\n        -<spec>   disable warnings in <spec>\n        @<spec>   enable warnings in <spec> and treat them as errors\n     <spec> can be:\n        <num>             a single warning number\n        <num1>..<num2>    a range of consecutive warning numbers\n        <letter>          a predefined set\n     default setting is \"+a-4-7-9-27-29-30-32..42-44-45-48-50-60-66..70\"";

  "-warn-error",
  true,
  "<list>  Enable or disable error status for warnings according\n     to <list>.  See option -w for the syntax of <list>.\n     Default setting is \"-a+31\"";

  "-warn-help",
  false,
  " Show description of warning numbers";

  "-where",
  false,
  " Print location of standard library and exit";

  "-",
  true,
  "<file>  Treat <file> as a file name (even if it starts with `-')";

  "-match-context-rows",
  true,
  "<n>  (advanced, see manual section 13.2.)";

  "-use-prims",
  true,
  "<file>  (undocumented)";

  "-dno-unique-ids",
  false,
  " (undocumented)";

  "-dunique-ids",
  false,
  " (undocumented)";

  "-dno-locations",
  false,
  " (undocumented)";

  "-dlocations",
  false,
  " (undocumented)";

  "-dsource",
  false,
  " (undocumented)";

  "-dparsetree",
  false,
  " (undocumented)";

  "-dtypedtree",
  false,
  " (undocumented)";

  "-dshape",
  false,
  " (undocumented)";

  "-drawlambda",
  false,
  " (undocumented)";

  "-dlambda",
  false,
  " (undocumented)";

  "-dinstr",
  false,
  " (undocumented)";

  "-dcamlprimc",
  false,
  " (undocumented)";

  "-dtimings",
  false,
  " Print timings information for each pass";

  "-dprofile",
  false,
  " Print performance information for each pass\n    The columns are: time alloc top-heap absolute-top-heap.";

  "-dump-into-file",
  false,
  " dump output like -dlambda into <target>.dump";

  "-dump-dir",
  true,
  "<dir> dump output like -dlambda into <dir>/<target>.dump";

  "-args",
  true,
  "<file> Read additional newline-terminated command line arguments\n      from <file>";

  "-args0",
  true,
  "<file> Read additional null character terminated command line arguments\nfrom <file>";

  "-depend",
  true,
  "<options> Compute dependencies (use 'ocamlc -depend -help' for details)";

];;

let ocamlopt_spec = Some [
  "-fPIC",
  false,
  " Generate position-independent machine code (default)";

  "-fno-PIC",
  false,
  " Generate position-dependent machine code";

  "-a",
  false,
  " Build a library";

  "-alert",
  true,
  "<list>  Enable or disable alerts according to <list>:\n        +<alertname>  enable alert <alertname>\n        -<alertname>  disable alert <alertname>\n        ++<alertname> treat <alertname> as fatal error";

  "--",
  true,
  "<alertname> treat <alertname> as non-fatal\n        @<alertname>  enable <alertname> and treat it as fatal error\n    <alertname> can be 'all' to refer to all alert names";

  "-absname",
  false,
  " Show absolute filenames in error messages";

  "-afl-instrument",
  false,
  "Enable instrumentation for afl-fuzz";

  "-afl-inst-ratio",
  false,
  "Configure percentage of branches instrumented\n     (advanced, see afl-fuzz docs for AFL_INST_RATIO)";

  "-annot",
  false,
  " (deprecated) Save information in <filename>.annot";

  "-bin-annot",
  false,
  " Save typedtree in <filename>.cmt";

  "-inline-branch-factor",
  true,
  "<n>|<round>=<n>[,...]  Estimate the probability of a branch being cold as 1/(1+n) (used for inlining) (default 0.10)";

  "-c",
  false,
  " Compile only (do not link)";

  "-cc",
  true,
  "<command>  Use <command> as the C compiler and linker";

  "-cclib",
  true,
  "<opt>  Pass option <opt> to the C linker";

  "-ccopt",
  true,
  "<opt>  Pass option <opt> to the C compiler and linker";

  "-cmi-file",
  true,
  "<file>  Use the <file> interface file to type-check";

  "-clambda-checks",
  false,
  " Instrument clambda code with closure and field access checks (for debugging the compiler)";

  "-Oclassic",
  false,
  " Make inlining decisions at function definition time rather than at the call site (replicates previous behaviour of the compiler)";

  "-color",
  true,
  "{auto|always|never}  Enable or disable colors in compiler messages\n    The following settings are supported:\n      auto    use heuristics to enable colors only if supported\n      always  enable colors\n      never   disable colors\n    The default setting is 'auto', and the current heuristic\n    checks that the TERM environment variable exists and is\n    not empty or \"dumb\", and that isatty(stderr) holds.\n  If the option is not specified, these setting can alternatively\n  be set through the OCAML_COLOR environment variable.";

  "-error-style",
  true,
  "{contextual|short}  Control the way error messages and warnings are printed\n    The following settings are supported:\n      short       only print the error and its location\n      contextual  like \"short\", but also display the source code\n                  snippet corresponding to the location of the error\n    The default setting is 'contextual'.\n  If the option is not specified, these setting can alternatively\n  be set through the OCAML_ERROR_STYLE environment variable.";

  "-compact",
  false,
  " Optimize code size rather than speed";

  "-config",
  false,
  " Print configuration values and exit";

  "-config-var",
  false,
  " Print the value of a configuration variable, without a newline, and exit\n    (print nothing and exit with error value if the variable does not exist)";

  "-dtypes",
  false,
  " (deprecated) same as -annot";

  "-for-pack",
  true,
  "<ident>  Generate code that can later be `packed' with\n     ocamlopt -pack -o <ident>.cmx";

  "-g",
  false,
  " Record debugging information for exception backtrace";

  "-function-sections",
  false,
  " Generate each function in a separate section if target supports it";

  "-stop-after",
  true,
  "{parsing|typing|scheduling|emit} Stop after the given compilation pass.";

  "-save-ir-after",
  true,
  "{scheduling} Save intermediate representation after the given compilation pass(may be specified more than once).";

  "-i",
  false,
  " Print inferred interface";

  "-I",
  true,
  "<dir>  Add <dir> to the list of include directories";

  "-impl",
  true,
  "<file>  Compile <file> as a .ml file";

  "-inline",
  true,
  "<n>|<round>=<n>[,...]  Aggressiveness of inlining (default 1.25, higher numbers mean more aggressive)";

  "-inline-toplevel",
  true,
  "<n>|<round>=<n>[,...]  Aggressiveness of inlining at toplevel (higher numbers mean more aggressive)";

  "-inline-alloc-cost",
  true,
  "<n>|<round>=<n>[,...]  The cost of not removing an allocation during inlining (default 7, higher numbers more costly)";

  "-inline-branch-cost",
  true,
  "<n>|<round>=<n>[,...]  The cost of not removing a conditional during inlining (default 5, higher numbers more costly)";

  "-inline-call-cost",
  true,
  "<n>|<round>=<n>[,...]  The cost of not removing a call during inlining (default 5, higher numbers more costly)";

  "-inline-prim-cost",
  true,
  "<n>|<round>=<n>[,...]  The cost of not removing a primitive during inlining (default 3, higher numbers more costly)";

  "-inline-indirect-cost",
  true,
  "<n>|<round>=<n>[,...]  The cost of not removing an indirect call during inlining (default 4, higher numbers more costly)";

  "-inline-lifting-benefit",
  true,
  "<n>|<round>=<n>[,...]  The benefit of lifting definitions to toplevel during inlining (default 1300, higher numbers more beneficial)";

  "-inlining-report",
  false,
  " Emit `.<round>.inlining' file(s) (one per round) showing the inliner's decisions";

  "-insn-sched",
  false,
  " Run the instruction scheduling pass (default)";

  "-intf",
  true,
  "<file>  Compile <file> as a .mli file";

  "-intf-suffix",
  true,
  "<string>  Suffix for interface files (default: .mli)";

  "-keep-docs",
  false,
  " Keep documentation strings in .cmi files";

  "-no-keep-docs",
  false,
  " Do not keep documentation strings in .cmi files (default)";

  "-keep-locs",
  false,
  " Keep locations in .cmi files (default)";

  "-no-keep-locs",
  false,
  " Do not keep locations in .cmi files";

  "-labels",
  false,
  " Use commuting label mode";

  "-linkall",
  false,
  " Link all modules, even unused ones";

  "-inline-max-depth",
  true,
  "<n>|<round>=<n>[,...]  Maximum depth of search for inlining opportunities inside inlined functions (default 1)";

  "-alias-deps",
  false,
  " Do record dependencies for module aliases";

  "-no-alias-deps",
  false,
  " Do not record dependencies for module aliases";

  "-linscan",
  false,
  " Use the linear scan register allocator";

  "-app-funct",
  false,
  " Activate applicative functors";

  "-no-app-funct",
  false,
  " Deactivate applicative functors";

  "-no-float-const-prop",
  false,
  " Deactivate constant propagation for floating-point operations";

  "-noassert",
  false,
  " Do not compile assertion checks";

  "-noautolink",
  false,
  " Do not automatically link C libraries specified in .cmxa files";

  "-nodynlink",
  false,
  " Enable optimizations for code that will not be dynlinked";

  "-no-insn-sched",
  false,
  " Do not run the instruction scheduling pass";

  "-nolabels",
  false,
  " Ignore non-optional labels in types";

  "-nostdlib",
  false,
  " Do not add default directory to the list of include directories";

  "-nocwd",
  false,
  " Do not implicitly add the current directory to the load path";

  "-nopervasives",
  false,
  " (undocumented)";

  "-no-unbox-free-vars-of-closures",
  false,
  " Do not unbox variables that will appear inside function closures";

  "-no-unbox-specialised-args",
  false,
  " Do not unbox arguments to which functions have been specialised";

  "-o",
  true,
  "<file>  Set output file name to <file>";

  "-O2",
  false,
  " Apply increased optimization for speed";

  "-O3",
  false,
  " Apply aggressive optimization for speed (may significantly increase code size and compilation time)";

  "-opaque",
  false,
  " Does not generate cross-module optimization information\n     (reduces necessary recompilation on module change)";

  "-open",
  true,
  "<module>  Opens the module <module> before typing";

  "-output-obj",
  false,
  " Output an object file instead of an executable";

  "-output-complete-obj",
  false,
  " Output an object file, including runtime, instead of an executable";

  "-p",
  false,
  " (no longer supported)";

  "-pack",
  false,
  " Package the given .cmx files into one .cmx";

  "-plugin",
  true,
  "<plugin>  (no longer supported)";

  "-pp",
  true,
  "<command>  Pipe sources through preprocessor <command>";

  "-ppx",
  true,
  "<command>  Pipe abstract syntax trees through preprocessor <command>";

  "-principal",
  false,
  " Check principality of type inference";

  "-no-principal",
  false,
  " Do not check principality of type inference (default)";

  "-rectypes",
  false,
  " Allow arbitrary recursive types";

  "-no-rectypes",
  false,
  " Do not allow arbitrary recursive types (default)";

  "-remove-unused-arguments",
  false,
  " Remove unused function arguments";

  "-rounds",
  true,
  "<n>  Repeat tree optimization and inlining phases this many times (default 1).  Rounds are numbered starting from zero.";

  "-runtime-variant",
  true,
  "<str>  Use the <str> variant of the run-time system";

  "-with-runtime",
  false,
  "Include the runtime system in the generated program (default)";

  "-without-runtime",
  false,
  "Do not include the runtime system in the generated program.";

  "-S",
  false,
  " Keep intermediate assembly file";

  "-safe-string",
  false,
  " (default unconditionally since 5.0)";

  "-shared",
  false,
  " Produce a dynlinkable plugin";

  "-short-paths",
  false,
  " Shorten paths in types";

  "-strict-sequence",
  false,
  " Left-hand part of a sequence must have type unit";

  "-no-strict-sequence",
  false,
  " Left-hand part of a sequence need not have type unit (default)";

  "-strict-formats",
  false,
  " Reject invalid formats accepted by legacy implementations\n     (Warning: Invalid formats may behave differently from\n      previous OCaml versions, and will become always-rejected\n      in future OCaml versions. You should always use this flag\n      to detect invalid formats so you can fix them.)";

  "-no-strict-formats",
  false,
  " Accept invalid formats accepted by legacy implementations (default)\n     (Warning: Invalid formats may behave differently from\n      previous OCaml versions, and will become always-rejected\n      in future OCaml versions. You should never use this flag\n      and instead fix invalid formats.)";

  "-thread",
  false,
  " (deprecated) same as -I +threads";

  "-unbox-closures",
  false,
  " Pass free variables via specialised arguments rather than closures";

  "-unbox-closures-factor",
  true,
  "<n > 0>  Scale the size threshold above which unbox-closures will slow down indirect calls rather than duplicating a function (default 10)";

  "-inline-max-unroll",
  true,
  "<n>|<round>=<n>[,...]  Unroll recursive functions at most this many times (default 0)";

  "-unboxed-types",
  false,
  " unannotated unboxable types will be unboxed";

  "-no-unboxed-types",
  false,
  " unannotated unboxable types will not be unboxed (default)";

  "-unsafe",
  false,
  " Do not compile bounds checking on array and string access";

  "-unsafe-string",
  false,
  " (option not available)";

  "-v",
  false,
  " Print compiler version and location of standard library and exit";

  "-verbose",
  false,
  " Print calls to external commands";

  "-version",
  false,
  " Print version and exit";

  "--version",
  false,
  " Print version and exit";

  "-vnum",
  false,
  " Print version number and exit";

  "-w",
  true,
  "<list>  Enable or disable warnings according to <list>:\n        +<spec>   enable warnings in <spec>\n        -<spec>   disable warnings in <spec>\n        @<spec>   enable warnings in <spec> and treat them as errors\n     <spec> can be:\n        <num>             a single warning number\n        <num1>..<num2>    a range of consecutive warning numbers\n        <letter>          a predefined set\n     default setting is \"+a-4-7-9-27-29-30-32..42-44-45-48-50-60-66..70\"";

  "-warn-error",
  true,
  "<list>  Enable or disable error status for warnings according\n     to <list>.  See option -w for the syntax of <list>.\n     Default setting is \"-a+31\"";

  "-warn-help",
  false,
  " Show description of warning numbers";

  "-where",
  false,
  " Print location of standard library and exit";

  "-",
  true,
  "<file>  Treat <file> as a file name (even if it starts with `-')";

  "-match-context-rows",
  true,
  "<n>  (advanced, see manual section 13.2.)";

  "-dno-unique-ids",
  false,
  " (undocumented)";

  "-dunique-ids",
  false,
  " (undocumented)";

  "-dno-locations",
  false,
  " (undocumented)";

  "-dlocations",
  false,
  " (undocumented)";

  "-dsource",
  false,
  " (undocumented)";

  "-dparsetree",
  false,
  " (undocumented)";

  "-dtypedtree",
  false,
  " (undocumented)";

  "-dshape",
  false,
  " (undocumented)";

  "-drawlambda",
  false,
  " (undocumented)";

  "-dlambda",
  false,
  " (undocumented)";

  "-drawclambda",
  false,
  " (undocumented)";

  "-dclambda",
  false,
  " (undocumented)";

  "-dcmm-invariants",
  false,
  " Extra sanity checks on Cmm";

  "-dflambda",
  false,
  " Print Flambda terms";

  "-drawflambda",
  false,
  " Print Flambda terms after closure conversion";

  "-dflambda-invariants",
  false,
  " Check Flambda invariants around each pass";

  "-dflambda-no-invariants",
  false,
  " Do not Check Flambda invariants around each pass";

  "-dflambda-let",
  true,
  "<stamp>  Print when the given Flambda [Let] is created";

  "-dflambda-verbose",
  false,
  " Print Flambda terms including around each pass";

  "-dcmm",
  false,
  " (undocumented)";

  "-dsel",
  false,
  " (undocumented)";

  "-dcombine",
  false,
  " (undocumented)";

  "-dcse",
  false,
  " (undocumented)";

  "-dlive",
  false,
  " (undocumented)";

  "-dspill",
  false,
  " (undocumented)";

  "-dsplit",
  false,
  " (undocumented)";

  "-dinterf",
  false,
  " (undocumented)";

  "-dprefer",
  false,
  " (undocumented)";

  "-dalloc",
  false,
  " (undocumented)";

  "-dreload",
  false,
  " (undocumented)";

  "-dscheduling",
  false,
  " (undocumented)";

  "-dlinear",
  false,
  " (undocumented)";

  "-dinterval",
  false,
  " (undocumented)";

  "-dstartup",
  false,
  " (undocumented)";

  "-dtimings",
  false,
  " Print timings information for each pass";

  "-dprofile",
  false,
  " Print performance information for each pass\n    The columns are: time alloc top-heap absolute-top-heap.";

  "-dump-into-file",
  false,
  " dump output like -dlambda into <target>.dump";

  "-dump-dir",
  true,
  "<dir> dump output like -dlambda into <dir>/<target>.dump";

  "-dump-pass",
  false,
  " Record transformations performed by these passes:\n     unbox-closures unbox-specialised-args unbox-free-vars-of-closures\n     remove-free-vars-equal-to-args remove-unused-arguments unused-arguments";

  "-args",
  true,
  "<file> Read additional newline-terminated command line arguments\n      from <file>";

  "-args0",
  true,
  "<file> Read additional null character terminated command line arguments\nfrom <file>";

  "-depend",
  true,
  "<options> Compute dependencies (use 'ocamlopt -depend -help' for details)";

];;

let ocamldep_spec = Some [
  "-absname",
  false,
  " Show absolute filenames in error messages";

  "-all",
  false,
  " Generate dependencies on all files";

  "-allow-approx",
  false,
  " Fallback to a lexer-based approximation on unparsable files";

  "-as-map",
  false,
  " Omit delayed dependencies for module aliases (-no-alias-deps -w -49)";

  "-debug-map",
  false,
  " Dump the delayed dependency map for each map file";

  "-I",
  true,
  "<dir>  Add <dir> to the list of include directories";

  "-nocwd",
  false,
  " Do not add current working directory to the list of include directories";

  "-impl",
  true,
  "<f>  Process <f> as a .ml file";

  "-intf",
  true,
  "<f>  Process <f> as a .mli file";

  "-map",
  true,
  "<f>  Read <f> and propagate delayed dependencies to following files";

  "-ml-synonym",
  true,
  "<e>  Consider <e> as a synonym of the .ml extension";

  "-mli-synonym",
  true,
  "<e>  Consider <e> as a synonym of the .mli extension";

  "-modules",
  false,
  " Print module dependencies in raw form (not suitable for make)";

  "-native",
  false,
  " Generate dependencies for native-code only (no .cmo files)";

  "-bytecode",
  false,
  " Generate dependencies for bytecode-code only (no .cmx files)";

  "-one-line",
  false,
  " Output one line per file, regardless of the length";

  "-open",
  true,
  "<module>  Opens the module <module> before typing";

  "-plugin",
  true,
  "<plugin>  (no longer supported)";

  "-pp",
  true,
  "<cmd>  Pipe sources through preprocessor <cmd>";

  "-ppx",
  true,
  "<cmd>  Pipe abstract syntax trees through preprocessor <cmd>";

  "-shared",
  false,
  " Generate dependencies for native plugin files (.cmxs targets)";

  "-slash",
  false,
  " (Windows) Use forward slash / instead of backslash \\ in file paths";

  "-no-slash",
  false,
  " (Windows) Preserve any backslash \\ in file paths";

  "-sort",
  false,
  " Sort files according to their dependencies";

  "-version",
  false,
  " Print version and exit";

  "-vnum",
  false,
  " Print version number and exit";

  "-args",
  true,
  "<file> Read additional newline separated command line arguments \n      from <file>";

  "-args0",
  true,
  "<file> Read additional NUL separated command line arguments from \n      <file>";

];;

let ocamldoc_spec = Some [
  "-absname",
  false,
  " Show absolute filenames in error messages";

  "-alert",
  true,
  "<list>  Enable or disable alerts according to <list>:\n        +<alertname>  enable alert <alertname>\n        -<alertname>  disable alert <alertname>\n        ++<alertname> treat <alertname> as fatal error";

  "--",
  true,
  "<alertname> treat <alertname> as non-fatal\n        @<alertname>  enable <alertname> and treat it as fatal error\n    <alertname> can be 'all' to refer to all alert names";

  "-I",
  true,
  "<dir>  Add <dir> to the list of include directories";

  "-impl",
  true,
  "<file>  Compile <file> as a .ml file";

  "-intf",
  true,
  "<file>  Compile <file> as a .mli file";

  "-intf-suffix",
  true,
  "<string>  Suffix for interface files (default: .mli)";

  "-intf_suffix",
  true,
  "<string>  (deprecated) same as -intf-suffix";

  "-labels",
  false,
  " Use commuting label mode";

  "-modern",
  false,
  " (deprecated) same as -labels";

  "-alias-deps",
  false,
  " Do record dependencies for module aliases";

  "-no-alias-deps",
  false,
  " Do not record dependencies for module aliases";

  "-app-funct",
  false,
  " Activate applicative functors";

  "-no-app-funct",
  false,
  " Deactivate applicative functors";

  "-noassert",
  false,
  " Do not compile assertion checks";

  "-nolabels",
  false,
  " Ignore non-optional labels in types";

  "-nostdlib",
  false,
  " Do not add default directory to the list of include directories";

  "-nocwd",
  false,
  " Do not implicitly add the current directory to the load path";

  "-open",
  true,
  "<module>  Opens the module <module> before typing";

  "-pp",
  true,
  "<command>  Pipe sources through preprocessor <command>";

  "-ppx",
  true,
  "<command>  Pipe abstract syntax trees through preprocessor <command>";

  "-principal",
  false,
  " Check principality of type inference";

  "-no-principal",
  false,
  " Do not check principality of type inference (default)";

  "-rectypes",
  false,
  " Allow arbitrary recursive types";

  "-no-rectypes",
  false,
  " Do not allow arbitrary recursive types (default)";

  "-safe-string",
  false,
  " (default unconditionally since 5.0)";

  "-short-paths",
  false,
  " Shorten paths in types";

  "-strict-sequence",
  false,
  " Left-hand part of a sequence must have type unit";

  "-no-strict-sequence",
  false,
  " Left-hand part of a sequence need not have type unit (default)";

  "-strict-formats",
  false,
  " Reject invalid formats accepted by legacy implementations\n     (Warning: Invalid formats may behave differently from\n      previous OCaml versions, and will become always-rejected\n      in future OCaml versions. You should always use this flag\n      to detect invalid formats so you can fix them.)";

  "-no-strict-formats",
  false,
  " Accept invalid formats accepted by legacy implementations (default)\n     (Warning: Invalid formats may behave differently from\n      previous OCaml versions, and will become always-rejected\n      in future OCaml versions. You should never use this flag\n      and instead fix invalid formats.)";

  "-thread",
  false,
  " (deprecated) same as -I +threads";

  "-unboxed-types",
  false,
  " unannotated unboxable types will be unboxed";

  "-no-unboxed-types",
  false,
  " unannotated unboxable types will not be unboxed (default)";

  "-unsafe-string",
  false,
  " (option not available)";

  "-v",
  false,
  " Print compiler version and location of standard library and exit";

  "-verbose",
  false,
  " Print calls to external commands";

  "-version",
  false,
  " Print version and exit";

  "--version",
  false,
  " Print version and exit";

  "-vmthread",
  false,
  "  (no longer supported)";

  "-vnum",
  false,
  " Print version number and exit";

  "-w",
  true,
  "<list>  Enable or disable warnings according to <list>:\n        +<spec>   enable warnings in <spec>\n        -<spec>   disable warnings in <spec>\n        @<spec>   enable warnings in <spec> and treat them as errors\n     <spec> can be:\n        <num>             a single warning number\n        <num1>..<num2>    a range of consecutive warning numbers\n        <letter>          a predefined set\n     default setting is \"+a-4-7-9-27-29-30-32..42-44-45-48-50-60-66..70\"";

  "-",
  true,
  "<file>  Treat <file> as a file name (even if it starts with `-')";

  "-initially-opened-module",
  true,
  "<module> Name of the module that is initially opened";

  "-lib",
  true,
  "<module> Name of the library namespace for a prefixed library.Note: very experimental.";

  "-text",
  true,
  "<file> Consider <file> as a .txt file";

  "-warn-error",
  false,
  " Treat ocamldoc warnings as errors";

  "-show-missed-crossref",
  false,
  " Show missed cross-reference opportunities";

  "-hide-warnings",
  false,
  " do not print ocamldoc warnings";

  "-o",
  true,
  "<file> Set the output file name, used by texi, latex and dot generators\n\t\t(default is ocamldoc.out)\n\t\tor the prefix of index files for the HTML generator\n\t\t(default is index)";

  "-d",
  true,
  "<dir> Generate files in directory <dir>, rather than in current\n\t\tdirectory (for man and HTML generators)";

  "-sort",
  false,
  " Sort the list of top modules before generating the documentation";

  "-no-stop",
  false,
  " Do not stop at (**/**) comments";

  "-no-custom-tags",
  false,
  " Do not allow custom @-tags";

  "-stars",
  false,
  " Remove beginning blanks of comment lines, until the first '*'";

  "-inv-merge-ml-mli",
  false,
  " Inverse implementations and interfaces when merging";

  "-no-module-constraint-filter",
  false,
  "Do not filter module elements using module type constraints";

  "-keep-code",
  false,
  " Always keep code when available\n";

  "-dump",
  true,
  "<file> Dump collected information into <file>";

  "-load",
  true,
  "<file> Load information from <file> ; may be used several times\n";

  "-t",
  true,
  "<title> Use <title> as title for the generated documentation";

  "-intro",
  true,
  "<file> Use content of <file> as ocamldoc text to use as introduction\n\t\t(HTML, LaTeX and TeXinfo only)";

  "-hide",
  true,
  "<M1,M2.M3,...> Hide the given complete module names in generated doc";

  "-m",
  true,
  "<options> specify merge options between .mli and .ml\n\t\t<options> can be one or more of the following characters:\n\t\td  merge description\n\t\ta  merge @author\n\t\tv  merge @version\n\t\tl  merge @see\n\t\ts  merge @since\n\t\tb  merge @before\n\t\to  merge @deprecated\n\t\tp  merge @param\n\t\te  merge @raise\n\t\tr  merge @return\n\t\tc  merge custom @-tags\n\t\tA  merge all\n\n *** choosing a generator ***\n";

  "-html",
  false,
  " Generate HTML documentation";

  "-latex",
  false,
  " Generate LaTeX documentation";

  "-texi",
  false,
  " Generate TeXinfo documentation";

  "-man",
  false,
  " Generate man pages";

  "-dot",
  false,
  " Generate dot code of top modules dependencies";

  "-customdir",
  false,
  "Display custom generators standard directory and exit";

  "-i",
  true,
  "<dir> Add the given directory to the search path for custom\n\t\tgenerators";

  "-g",
  true,
  "<file.cm[o|a|xs]> Load file defining a new documentation generator\n\n *** HTML options ***\n";

  "-all-params",
  false,
  " Display the complete list of parameters for functions and\n\t\tmethods (HTML only)";

  "-css-style",
  true,
  "<file> Use content of <file> as CSS style definition (HTML only)";

  "-index-only",
  false,
  " Generate index files only (HTML only)";

  "-colorize-code",
  false,
  " Colorize code even in documentation pages (HTML only)";

  "-short-functors",
  false,
  " Use short form to display functor types (HTML only)";

  "-charset",
  true,
  "<s> Add information about character encoding being s\n\t\t(default is iso-8859-1)";

  "-nonavbar",
  false,
  " Do not include the navigation bar (HTML only)\n\n *** LaTeX options ***\n";

  "-noheader",
  false,
  " Suppress header in generated documentation\n\t\t(LaTeX and TeXinfo only)";

  "-notrailer",
  false,
  " Suppress trailer in generated documentation\n\t\t(LaTeX and TeXinfo only)";

  "-sepfiles",
  false,
  " Generate one file per toplevel module (LaTeX only)";

  "-latextitle",
  false,
  "n,style Associate {n } to the given sectioning style\n\t\t(e.g. 'section') in the latex output (LaTeX only)\n\t\tDefault sectioning is:\n\t\t 0 -> section\n\t\t 1 -> section\n\t\t 2 -> subsection\n\t\t 3 -> subsubsection\n\t\t 4 -> paragraph\n\t\t 5 -> subparagraph";

  "-latex-value-prefix",
  true,
  "<string>\n\t\tUse <string> as prefix for the LaTeX labels of values.\n\t\t(default is \"val:\")";

  "-latex-type-prefix",
  true,
  "<string>\n\t\tUse <string> as prefix for the LaTeX labels of types.\n\t\t(default is \"type:\")";

  "-latex-exception-prefix",
  true,
  "<string>\n\t\tUse <string> as prefix for the LaTeX labels of exceptions.\n\t\t(default is \"exception:\")";

  "-latex-attribute-prefix",
  true,
  "<string>\n\t\tUse <string> as prefix for the LaTeX labels of attributes.\n\t\t(default is \"val:\")";

  "-latex-method-prefix",
  true,
  "<string>\n\t\tUse <string> as prefix for the LaTeX labels of methods.\n\t\t(default is \"method:\")";

  "-latex-module-prefix",
  true,
  "<string>\n\t\tUse <string> as prefix for the LaTeX labels of modules.\n\t\t(default is \"module:\")";

  "-latex-module-type-prefix",
  true,
  "<string>\n\t\tUse <string> as prefix for the LaTeX labels of module types.\n\t\t(default is \"moduletype:\")";

  "-latex-class-prefix",
  true,
  "<string>\n\t\tUse <string> as prefix for the LaTeX labels of classes.\n\t\t(default is \"class:\")";

  "-latex-class-type-prefix",
  true,
  "<string>\n\t\tUse <string> as prefix for the LaTeX labels of class types.\n\t\t(default is \"classtype:\")";

  "-notoc",
  false,
  " Do not generate table of contents (LaTeX only)\n\n *** texinfo options ***\n";

  "-noindex",
  false,
  " Do not build index for Info files (TeXinfo only)";

  "-esc8",
  false,
  " Escape accentuated characters in Info files (TeXinfo only)";

  "-texinfotitle",
  false,
  "n,style Associate {n } to the given sectioning style\n\t\t(e.g. 'section') in the texInfo output (TeXinfo only)\n\t\tDefault sectioning is:\n\t\t 0 -> @chapter , @majorheading  \n\t\t 1 -> @chapter , @majorheading  \n\t\t 2 -> @section , @heading  \n\t\t 3 -> @subsection , @subheading  \n\t\t 4 -> @subsubsection , @subsubheading  ";

  "-info-section",
  false,
  " Specify section of Info directory (TeXinfo only)";

  "-info-entry",
  false,
  " Specify Info directory entry (TeXinfo only)\n\n *** dot options ***\n";

  "-dot-colors",
  true,
  " <c1,c2,...,cn>\n\t\tUse colors c1,c1,...,cn in the dot output\n\t\t(default list is darkturquoise,darkgoldenrod2,cyan,green,\n\t\tmagenta,yellow,burlywood1,aquamarine,floralwhite,lightpink,\n\t\tlightblue,mediumturquoise,salmon,slategray3)";

  "-dot-include-all",
  false,
  " Include all modules in the dot output, not only the\n\t\tmodules given on the command line";

  "-dot-types",
  false,
  " Generate dependency graph for types instead of modules";

  "-dot-reduce",
  false,
  " Perform a transitive reduction on the selected dependency graph\n\t\tbefore the dot output\n\n *** man pages options ***\n";

  "-man-mini",
  false,
  " Generate man pages only for modules, module types, classes\n\t\tand class types (man only)";

  "-man-suffix",
  true,
  "<suffix> Use <suffix> for man page files (default is 3o) (man only)\n";

  "-man-section",
  true,
  "<section> Use <section> in man page files (default is 3) (man only)\n";

];;

