/*
 * Decompiled with CFR 0.152.
 */
package org.scidac.cmcs.tools.bse;

import com.sourceforge.knecs.util.converters.FormatException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Vector;
import org.jdom.Document;
import org.jdom.Element;
import org.scidac.cmcs.tools.bse.MolproInputToBasisXml;
import org.scidac.cmcs.tools.pertable.PerTable;

public class MolproIntInputToBasisXml
extends MolproInputToBasisXml {
    protected PerTable mPertable = PerTable.getPerTable();
    protected static final int MAXLINES = 100;

    @Override
    public Vector convert(String title, String xmlFileName, String harmonicType, String description, InputStream inputStream) throws IOException, FormatException {
        Vector<Document> ret = new Vector<Document>();
        boolean hasBasisSet = false;
        boolean hasEcp = false;
        boolean hasSo = false;
        Object EcpDoc = null;
        BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));
        String line = null;
        int lineCnt = 0;
        while ((line = reader.readLine()) != null) {
            int spacePos;
            if (++lineCnt > 100 && !hasBasisSet && !hasEcp) {
                throw new FormatException("Expected to find basis data within first 100 lines.");
            }
            if ((line = line.trim().toUpperCase()).length() == 0 || line.startsWith("!")) continue;
            if (!hasEcp && line.startsWith("ECP")) {
                if (!hasBasisSet) {
                    throw new FormatException("Found ECP block but did not find orbital data.");
                }
                Document ecpDoc = this.loadECPs(reader, line, title, xmlFileName);
                ret.add(ecpDoc);
                hasEcp = true;
                break;
            }
            if (hasBasisSet || (spacePos = line.indexOf(" ")) < 0) continue;
            String element = line.substring(0, spacePos);
            if (!this.mPertable.isValid(element = this.mPertable.formatSymbol(element))) continue;
            Document basisDoc = this.loadInternalBasisSet(reader, line, title, xmlFileName, harmonicType, description);
            this.convertToSharedSP(basisDoc);
            ret.add(basisDoc);
            hasBasisSet = true;
        }
        if (ret.size() == 0) {
            throw new FormatException("Unable to detect start of basis set data.");
        }
        for (Document doc : ret) {
            String docType = doc.getRootElement().getName().toLowerCase();
            if (!docType.equals("basisset")) continue;
            if (ret.size() == 2) {
                doc.getRootElement().addContent(this.createEcpLink(xmlFileName));
            }
            if (ret.size() != 3) continue;
            doc.getRootElement().addContent(this.createSoLink(xmlFileName));
        }
        return ret;
    }

    protected Document loadInternalBasisSet(BufferedReader reader, String firstLine, String name, String xmlFileName, String harmonicType, String description) throws IOException, FormatException {
        Element bsroot = this.createBasisRoot();
        bsroot.addContent(this.createBasisMime());
        bsroot.addContent(this.createTitle(name));
        bsroot.addContent(this.createHarmonicType(harmonicType));
        boolean segmented = false;
        Element contrType = this.createContractionType("segmented");
        bsroot.addContent(contrType);
        bsroot.addContent(this.createRefLink(xmlFileName + "-BS-REF.xml"));
        bsroot.addContent(this.createDescription(description));
        String line = firstLine;
        String maxShell = this.getMinimumShell();
        String lastElement = "";
        Element contractions = null;
        while ((line = line.trim().toUpperCase()).length() != 0) {
            Vector meta = this.tokenize(line, ":");
            if (meta.size() < 2) {
                throw new FormatException("Expecting line like: U s name 12 8 1.7... but found " + line);
            }
            Vector meta1 = this.tokenize((String)meta.get(0), " ");
            String element = (String)meta1.get(0);
            if (!this.mPertable.isValid(element = this.mPertable.formatSymbol(element))) {
                throw new FormatException("Unrecognized element: " + element);
            }
            String shell = (String)meta1.get(1);
            if (!this.isValidShell(shell)) {
                throw new FormatException("Unrecognized shell type " + shell);
            }
            Vector meta2 = this.tokenize((String)meta.get(1), " ");
            int numExp = Integer.parseInt((String)meta2.get(0));
            meta2.remove(0);
            int numCont = Integer.parseInt((String)meta2.get(0));
            meta2.remove(0);
            while (line.endsWith(";")) {
                line = reader.readLine();
                line = line.trim().toUpperCase();
                meta2.addAll(this.tokenize(line, " "));
            }
            Vector<Integer> contrNums = new Vector<Integer>();
            Vector<Integer> numExps = new Vector<Integer>();
            for (int idx = 0; idx < meta2.size(); ++idx) {
                String tmp = (String)meta2.get(idx);
                int dotPos = tmp.indexOf(".");
                int lnum = Integer.parseInt(tmp.substring(0, dotPos));
                int lnumExp = Integer.parseInt(tmp.substring(dotPos + 1));
                contrNums.add(new Integer(lnum));
                numExps.add(new Integer(lnumExp));
            }
            reader.readLine();
            Vector exponents = new Vector();
            Vector coeffs = new Vector();
            this.getData(reader, numExp, contrNums, numExps, exponents, coeffs);
            if (!element.equals(lastElement)) {
                contractions = this.createContractions(element);
                bsroot.addContent(contractions);
                lastElement = element;
                maxShell = this.getMinimumShell();
            }
            segmented = this.buildContractedSets(exponents, coeffs, contrNums, numExps, contractions, shell);
            line = reader.readLine();
            if (line != null) continue;
        }
        if (!segmented) {
            contrType.setText("general");
        }
        return new Document(bsroot);
    }

    protected void getData(BufferedReader reader, int numExp, Vector contrNums, Vector numExps, Vector exponents, Vector coeffs) throws IOException {
        String line;
        Vector data = new Vector();
        while ((line = reader.readLine()) != null) {
            if ((line = line.trim()).length() == 0) {
                reader.reset();
                break;
            }
            int spacePos = line.indexOf(" ");
            if (spacePos >= 0) {
                String element = line.substring(0, spacePos);
                if (this.mPertable.isValid(element = this.mPertable.formatSymbol(element))) {
                    reader.reset();
                    break;
                }
            }
            data.addAll(this.tokenize(line, " "));
            reader.mark(512);
        }
        for (int idx = 0; idx < numExp; ++idx) {
            exponents.add(data.get(0));
            data.remove(0);
        }
        int pos = 0;
        for (int idx = 0; idx < numExps.size(); ++idx) {
            Vector row = new Vector();
            coeffs.add(row);
            int lnum = (Integer)contrNums.get(idx);
            int lnumExp = (Integer)numExps.get(idx);
            int size = lnumExp - lnum + 1;
            row.addAll(data.subList(pos, pos + (lnumExp - lnum) + 1));
            pos += size;
        }
        data = null;
    }

    @Override
    protected Document loadECPs(BufferedReader reader, String firstLine, String name, String xmlFileName) throws IOException, FormatException {
        Element root = this.createEcpRoot();
        root.addContent(this.createEcpMime());
        root.addContent(this.createTitle(name));
        root.addContent(this.createEcpType("type"));
        if (xmlFileName.endsWith("-ECP")) {
            root.addContent(this.createRefLink(xmlFileName + "-REF.xml"));
        } else {
            root.addContent(this.createRefLink(xmlFileName + "-ECP-REF.xml"));
        }
        String line = firstLine;
        while ((line = line.trim().toUpperCase()).length() != 0) {
            if (!line.startsWith("!")) {
                Vector columns = this.tokenize(line, ", ");
                String element = (String)columns.get(1);
                if (!this.mPertable.isValid(element = this.mPertable.formatSymbol(element))) {
                    throw new FormatException("Unrecognized element: " + element);
                }
                if (columns.size() < 4) {
                    throw new FormatException("Missing nelec: " + line);
                }
                String nElectrons = (String)columns.get(2);
                Element potentials = this.createPotentials(element, nElectrons);
                root.addContent(potentials);
                while ((line = reader.readLine()) != null && (line = line.trim().toUpperCase()).length() != 0 && !line.startsWith("ECP")) {
                    String desc = "";
                    String shell = "?";
                    int numLines = Integer.parseInt(line.substring(0, line.indexOf(";")));
                    int exPos = line.indexOf("!");
                    if (exPos > 0) {
                        desc = line.substring(exPos + 1).trim();
                        shell = desc.substring(0, 1);
                    }
                    Element potential = this.createPotential(desc, shell);
                    potentials.addContent(potential);
                    Vector matrix = new Vector();
                    int numCol = 0;
                    for (int idx = 0; idx < numLines; ++idx) {
                        line = reader.readLine();
                        if (line == null) {
                            throw new FormatException("Unable to read more ECP data.");
                        }
                        Vector lineData = this.tokenize(line, ", ");
                        numCol = lineData.size();
                        matrix.addAll(lineData);
                    }
                    Element matrixEl = this.createMatrix(matrix, numLines, numCol);
                    potential.addContent(matrixEl);
                    reader.mark(80);
                }
                reader.reset();
            }
            if ((line = reader.readLine()) != null) continue;
        }
        return root != null ? new Document(root) : null;
    }
}

