  PROGRAM gen_grids
!
!****	gen_grids 
!
!	Purpose:
!	--------
!	This program creates the auxiliary files grids.nc, masks.nc, 
!       areas.nc, maskr.nc for the grids ORCA2, AT42REGU and BT42REDU
!       
!***	History:
!       -------
!       Version   Programmer      Date        Description
!       -------   ----------      ----        -----------
!         1.0   Sophie Valcke      ?           creation
!         2.0   Damien Declat  2002/07/02     SCRIP test
!*----------------------------------------------------------------
!
!** + Declarations
!
!
!** ++ modules and includes
!
!
  IMPLICIT NONE
  INCLUDE 'netcdf.inc'

!
!** ++ Variables
!
  REAL(kind=8), PARAMETER    :: dp_4pir2=12.566371*6371229.**2 
  REAL(kind=8), PARAMETER    :: pi=3.14159265359
! degre -> radian conversion factor 
  REAL(kind=8), PARAMETER :: dp_conv = pi/180
  INTEGER,  PARAMETER          :: jpc=4
!
!** +++ For Auxilary files
!
  INTEGER, DIMENSION(2):: ivardim
  INTEGER, DIMENSION(3):: ivardimc
  INTEGER :: ificid, kstatus
  INTEGER :: ijpiodimid, ijpjodimid, ijpiadimid, ijpjadimid
  INTEGER :: ijpibdimid, ijpjbdimid, ijpcdimid
  INTEGER :: itorcid, itorcid2, itorcid3, itorcid4 
  INTEGER :: iforcid, iforcid2, iuorcid, iuorcid2, ivorcid, ivorcid2
  INTEGER :: iat42id, iat42id2, iat42id3, iat42id4 
  INTEGER :: ibt42id, ibt42id2, ibt42id3, ibt42id4 

!
!** +++ For the ORCA grid
!
  INTEGER, PARAMETER   :: jpio=182, jpjo=149, jptoto=jpio*jpjo

  REAL(kind=8), DIMENSION(jpio,jpjo,1,1)  :: rl_Field, rl_Fieldsrf
  REAL(kind=8), DIMENSION(jpio,jpjo)      :: rl_Field2
  REAL(kind=8), DIMENSION(jpio,jpjo,jpc)  :: rl_Fieldoc  
  REAL(kind=8), DIMENSION(jpc, jptoto)    :: rl_Fieldoc2D

  CHARACTER(len=8)     :: cl_fldnam, cbid
  CHARACTER(len=27)    :: cl_NamFileIn

  INTEGER, DIMENSION(jpio,jpjo)  ::  imasko

  INTEGER, DIMENSION(4)  :: il_Field_start
  INTEGER, DIMENSION(4)  :: il_Field_count

  INTEGER              :: il_status, il_isoncid, il_orcancid
  INTEGER              :: il_Varid, il_tini, il_tfin
  INTEGER              :: il_Dimid, ib1, ib2

!
!** +++ For the AT42REGU grid
!
  INTEGER ,PARAMETER   :: jpia=128, jpja=64, jptota=jpia*jpja
  REAL(kind=8), DIMENSION(jptota) :: zlat_aor, zlat_afin
  REAL(kind=8) :: zbid, zsurf_CA
  CHARACTER(len=9), PARAMETER  :: cficat='at42_regu'
  CHARACTER(len=8)  :: clident
  INTEGER, DIMENSION(jpia,jpja)  ::  imaska, imaskbuf
  LOGICAL           :: ll_var
  INTEGER              :: il_at42ncid
  REAL(kind=8), DIMENSION(jpia,jpja,jpc)  :: rl_Fieldac
  REAL(kind=8), DIMENSION(jpc, jptota)    :: rl_Fieldac2D
!
!** +++ For the BT42REDU grid
!
  INTEGER,  PARAMETER          :: jpib=6232, jpjb=1, jptotb=jpib*jpjb 
  REAL(kind=8), DIMENSION(jpib, jpjb) :: zfld_b
  REAL(kind=8), DIMENSION(jptotb) :: zlon_bor, zlat_bor, zsur_bor
  REAL(kind=8) :: dl_surface
  REAL(kind=4)  :: zmaskbuf
  CHARACTER(len=9), PARAMETER  :: cficbt='bt42_redu'
  INTEGER, DIMENSION(jpib,jpjb)  ::  imaskb
  INTEGER, DIMENSION(jptota)     ::  imaskbglo
  INTEGER, DIMENSION(jptotb)     ::  imaskbred
  INTEGER, DIMENSION(jpja)       :: ninip
  INTEGER              :: il_bt42ncid
  INTEGER  :: nc, jbou, ncfin, ibou, j, nctrg, ncfintrg, ncsrc, ncfinsrc
  INTEGER  :: ninipja, npt, nptp1, nptm1, jint, ja, ibouc, ij
  REAL(kind=8), DIMENSION(jpib,jpjb,jpc)  :: rl_Fieldbc  
  REAL(kind=8), DIMENSION(jpc, jptotb)    :: rl_Fieldbc2D
  
  INTEGER, DIMENSION(2)  :: il_Field_startc
  INTEGER, DIMENSION(2)  :: il_Field_countc
!*V Number of point for the jpja latitude circles for reduced atm
  DATA ninip /20,30,40,48,48,54,54,64,72,80,80,90,96,100,&
                  108,108,120,120,120,128,128,128,128,128,&
                  128,128,128,128,128,128,128,128,&
                  128,128,128,128,128,128,128,128,&
                  128,128,128,128,128,120,120,120,108,108,&
                  100,96,90,80,80,72,64,54,54,48,48,40,30,20/ 
!
! For the LMDZ grid
  INTEGER ,PARAMETER   :: jpiz=96, jpjz=72, jptotz=jpiz*jpjz
  INTEGER              :: ijpizdimid, ijpjzdimid, ilmdzid, ilmdzid2
  REAL(kind=4) :: alon(128,64),alat(128,64)
  REAL(kind=4) :: alon2(jpiz,jpjz),alat2(jpiz,jpjz)
  REAL(kind=8) :: alon2dbl(jpiz,jpjz),alat2dbl(jpiz,jpjz)
  INTEGER, DIMENSION(jpiz,jpjz)  ::  imaskz
!
!
!*----------------------------------------------------------------
!
!** + Creation and initialisation of the "grids.nc" auxilary file 
!

  cl_NamFileIn="grids.nc"
  call hdlerr(NF_OPEN(cl_NamFileIn, NF_WRITE, il_isoncid))
!  write(*,*) '1.18 il_isoncid', il_isoncid

!
  cl_fldnam="at42.lat" 
!  write(*,*) '1.19 cl_fldnam ', cl_fldnam
  call hdlerr(NF_INQ_VARID(il_isoncid, cl_fldnam,il_Varid))
!  write(*,*) '1.20 il_Varid', il_Varid
  call hdlerr(NF_GET_VAR_DOUBLE (il_isoncid, il_Varid, zlat_aor))
  DO ibou=1, jptota 
    zlat_afin(ibou) = zlat_aor(jptota-ibou+1)
  ENDDO
  call hdlerr(NF_PUT_VAR_DOUBLE (il_isoncid, il_Varid, zlat_afin))
  call hdlerr(NF_CLOSE(il_isoncid))
END PROGRAM gen_grids
!
SUBROUTINE hdlerr(istatus)

  INTEGER                 :: istatus
  INCLUDE 'netcdf.inc'

  IF (istatus .ne. NF_NOERR) THEN
      print *, NF_STRERROR(istatus)
      stop 'stopped'
  ENDIF

  RETURN

END SUBROUTINE hdlerr


