// Created on: 1996-12-02
// Created by: Laurent PAINNOT
// Copyright (c) 1996-1999 Matra Datavision
// Copyright (c) 1999-2014 OPEN CASCADE SAS
//
// This file is part of Open CASCADE Technology software library.
//
// This library is free software; you can redistribute it and/or modify it under
// the terms of the GNU Lesser General Public License version 2.1 as published
// by the Free Software Foundation, with special exception defined in the file
// OCCT_LGPL_EXCEPTION.txt. Consult the file LICENSE_LGPL_21.txt included in OCCT
// distribution for complete text of the license and disclaimer of any warranty.
//
// Alternatively, this file may be used under the terms of Open CASCADE
// commercial license or contractual agreement.

#ifndef OCCT_DEBUG
#define No_Standard_OutOfRange
#define No_Standard_RangeError
#endif

#include <AppCont_ContMatrices.hxx>
#include <math_Matrix.hxx>
#include <Standard_DimensionError.hxx>

static const Standard_Real VBMatrix[] = {
0.5, 0.5, 

0.788675134594813, 0.211324865405187, 0.211324865405187, 0.788675134594813, 

0.887298334620741, 0.5, 0.112701665379259, 0.112701665379259, 0.5, 0.887298334620741, 

0.930568155797026, 0.669990521792428, 0.330009478207572, 0.0694318442029735, 0.0694318442029735, 0.330009478207572, 0.669990521792428, 0.930568155797026, 

0.953089922969332, 0.769234655052841, 0.5, 0.230765344947159, 0.0469100770306681, 0.046910077030668, 0.230765344947159, 0.5, 0.769234655052841, 0.953089922969332, 

0.966234757101576, 0.830604693233133, 0.619309593041598, 0.380690406958402, 0.169395306766867, 0.033765242898424, 0.033765242898424, 0.169395306766867, 0.380690406958402, 0.619309593041598, 0.830604693233133, 0.966234757101576, 

0.974553956171379, 0.870765592799697, 0.702922575688699, 0.5, 0.297077424311301, 0.129234407200303, 0.025446043828621, 0.025446043828621, 0.129234407200303, 0.297077424311301, 0.5, 0.702922575688699, 0.870765592799697, 0.974553956171379, 

0.980144928248768, 0.898333238706813, 0.762766204958164, 0.591717321247825, 0.408282678752175, 0.237233795041836, 0.101666761293187, 0.019855071751232, 0.019855071751232, 0.101666761293187, 0.237233795041836, 0.408282678752175, 0.591717321247825, 0.762766204958164, 0.898333238706813, 0.980144928248768, 

0.984080119753813, 0.918015553663318, 0.806685716350295, 0.662126711701905, 0.5, 0.337873288298095, 0.193314283649705, 0.081984446336682, 0.0159198802461871, 0.015919880246187, 0.081984446336682, 0.193314283649705, 0.337873288298095, 0.5, 0.662126711701905, 0.806685716350295, 0.918015553663318, 0.984080119753813, 

0.986953264258586, 0.932531683344493, 0.839704784149512, 0.716697697064623, 0.574437169490815, 0.425562830509185, 0.283302302935377, 0.160295215850488, 0.0674683166555075, 0.013046735741414, 0.013046735741414, 0.0674683166555075, 0.160295215850488, 0.283302302935377, 0.425562830509185, 0.574437169490815, 0.716697697064623, 0.839704784149512, 0.932531683344493, 0.986953264258586, 

0.989114329073028, 0.943531299884047, 0.865076002787025, 0.759548064603406, 0.634771577976172, 0.5, 0.365228422023828, 0.240451935396594, 0.134923997212975, 0.0564687001159525, 0.0108856709269716, 0.0108856709269715, 0.0564687001159525, 0.134923997212975, 0.240451935396594, 0.365228422023827, 0.5, 0.634771577976172, 0.759548064603406, 0.865076002787025, 0.943531299884047, 0.989114329073028, 

0.99078031712336, 0.952058628185237, 0.884951337097152, 0.793658977143308, 0.68391574949909, 0.562616704255735, 0.437383295744265, 0.31608425050091, 0.206341022856692, 0.115048662902848, 0.0479413718147625, 0.00921968287664043, 0.00921968287664049, 0.0479413718147625, 0.115048662902847, 0.206341022856691, 0.31608425050091, 0.437383295744265, 0.562616704255735, 0.68391574949909, 0.793658977143308, 0.884951337097152, 0.952058628185237, 0.99078031712336, 

0.992091527359294, 0.958799199611489, 0.900789045366655, 0.82117466972017, 0.724246375518223, 0.615229157977567, 0.5, 0.384770842022433, 0.275753624481777, 0.17882533027983, 0.0992109546333451, 0.0412008003885109, 0.00790847264070593, 0.00790847264070599, 0.041200800388511, 0.099210954633345, 0.17882533027983, 0.275753624481777, 0.384770842022433, 0.5, 0.615229157977567, 0.724246375518223, 0.82117466972017, 0.900789045366655, 0.958799199611489, 0.992091527359294, 

0.993141904348406, 0.964217441831787, 0.913600657534883, 0.843646452405842, 0.757624318179077, 0.659556184463945, 0.554027474353672, 0.445972525646328, 0.340443815536055, 0.242375681820923, 0.156353547594158, 0.0863993424651175, 0.035782558168213, 0.00685809565159401, 0.00685809565159401, 0.035782558168213, 0.0863993424651175, 0.156353547594157, 0.242375681820923, 0.340443815536055, 0.445972525646328, 0.554027474353672, 0.659556184463945, 0.757624318179077, 0.843646452405842, 0.913600657534883, 0.964217441831787, 0.993141904348406, 

0.993996259010242, 0.968636696200353, 0.924103291705213, 0.862208865680085, 0.78548608630427, 0.697075673538782, 0.600597046998718, 0.5, 0.399402953001282, 0.302924326461218, 0.21451391369573, 0.137791134319915, 0.0758967082947866, 0.031363303799647, 0.00600374098975753, 0.00600374098975748, 0.031363303799647, 0.0758967082947865, 0.137791134319915, 0.21451391369573, 0.302924326461218, 0.399402953001282, 0.5, 0.600597046998718, 0.697075673538782, 0.78548608630427, 0.862208865680085, 0.924103291705213, 0.968636696200353, 0.993996259010242, 

0.994700467495825, 0.972287511536617, 0.932815601193916, 0.877702204177502, 0.808938122201322, 0.729008388828614, 0.64080177538963, 0.547506254918819, 0.452493745081181, 0.35919822461037, 0.270991611171386, 0.191061877798678, 0.122297795822498, 0.0671843988060841, 0.0277124884633835, 0.00529953250417492, 0.00529953250417498, 0.0277124884633835, 0.067184398806084, 0.122297795822499, 0.191061877798678, 0.270991611171386, 0.35919822461037, 0.452493745081181, 0.547506254918819, 0.64080177538963, 0.729008388828614, 0.808938122201322, 0.877702204177502, 0.932815601193916, 0.972287511536617, 0.994700467495825, 

0.995287737657208, 0.975337760884384, 0.940119576863493, 0.890757001948401, 0.828835579608346, 0.756345268543239, 0.675615881726938, 0.589242090747924, 0.5, 0.410757909252076, 0.324384118273062, 0.243654731456761, 0.171164420391654, 0.109242998051599, 0.059880423136507, 0.0246622391156159, 0.00471226234279154, 0.00471226234279148, 0.024662239115616, 0.059880423136507, 0.109242998051599, 0.171164420391655, 0.243654731456761, 0.324384118273062, 0.410757909252076, 0.5, 0.589242090747924, 0.675615881726938, 0.756345268543239, 0.828835579608346, 0.890757001948401, 0.940119576863493, 0.975337760884384, 0.995287737657208, 

0.995782584210466, 0.977911974785699, 0.946301233248778, 0.901852479486261, 0.845843521530177, 0.779885415536974, 0.705875580731422, 0.625943112845753, 0.542387506520868, 0.457612493479132, 0.374056887154247, 0.294124419268578, 0.220114584463026, 0.154156478469823, 0.0981475205137385, 0.053698766751222, 0.022088025214301, 0.0042174157895345, 0.0042174157895345, 0.022088025214301, 0.053698766751222, 0.0981475205137385, 0.154156478469823, 0.220114584463026, 0.294124419268578, 0.374056887154247, 0.457612493479132, 0.542387506520868, 0.625943112845753, 0.705875580731422, 0.779885415536974, 0.845843521530177, 0.901852479486261, 0.946301233248778, 0.977911974785699, 0.995782584210466, 

0.996203421921792, 0.980104076067415, 0.951577951807409, 0.911357328268572, 0.860483088667614, 0.800272652330841, 0.73228537068798, 0.658282049981815, 0.580179322820113, 0.5, 0.419820677179887, 0.341717950018185, 0.26771462931202, 0.199727347669159, 0.139516911332386, 0.0886426717314285, 0.048422048192591, 0.019895923932585, 0.00379657807820799, 0.00379657807820799, 0.019895923932585, 0.048422048192591, 0.0886426717314285, 0.139516911332385, 0.19972734766916, 0.26771462931202, 0.341717950018185, 0.419820677179887, 0.5, 0.580179322820113, 0.658282049981815, 0.73228537068798, 0.800272652330841, 0.860483088667614, 0.911357328268572, 0.951577951807409, 0.980104076067415, 0.996203421921792, 

0.996564299592547, 0.981985963638957, 0.956117214125663, 0.919558485911109, 0.873165953230076, 0.818026840363258, 0.755433500975414, 0.68685304435771, 0.613892925570823, 0.538263260566749, 0.461736739433251, 0.386107074429177, 0.31314695564229, 0.244566499024586, 0.181973159636742, 0.126834046769924, 0.0804415140888906, 0.043882785874337, 0.018014036361043, 0.00343570040745256, 0.0034357004074525, 0.018014036361043, 0.043882785874337, 0.0804415140888905, 0.126834046769924, 0.181973159636742, 0.244566499024586, 0.31314695564229, 0.386107074429177, 0.461736739433251, 0.538263260566749, 0.613892925570823, 0.68685304435771, 0.755433500975414, 0.818026840363258, 0.873165953230076, 0.919558485911109, 0.956117214125663, 0.981985963638957, 0.996564299592547, 

0.996876085310195, 0.983613419283153, 0.960049667075201, 0.926681682291658, 0.884219981737839, 0.833569402098706, 0.77580941794361, 0.712171060103719, 0.644010658401201, 0.572780927080447, 0.5, 0.427219072919553, 0.355989341598799, 0.287828939896281, 0.22419058205639, 0.166430597901294, 0.115780018262161, 0.0733183177083415, 0.0399503329247994, 0.0163865807168471, 0.00312391468980544, 0.0031239146898055, 0.016386580716847, 0.0399503329247995, 0.0733183177083415, 0.115780018262161, 0.166430597901294, 0.22419058205639, 0.287828939896281, 0.355989341598799, 0.427219072919553, 0.5, 0.572780927080447, 0.644010658401201, 0.712171060103719, 0.77580941794361, 0.833569402098706, 0.884219981737839, 0.926681682291658, 0.960049667075201, 0.983613419283153, 0.996876085310195, 

0.9971472927412, 0.985030248917715, 0.963478386093587, 0.93290628886015, 0.893908402989604, 0.847243631593341, 0.793820201753456, 0.734677918993379, 0.670967910446042, 0.60393021334411, 0.534869636659861, 0.465130363340139, 0.39606978665589, 0.329032089553958, 0.265322081006621, 0.206179798246544, 0.152756368406659, 0.106091597010396, 0.06709371113985, 0.0365216139064131, 0.0149697510822855, 0.00285270725880049, 0.00285270725880049, 0.0149697510822855, 0.036521613906413, 0.06709371113985, 0.106091597010396, 0.152756368406659, 0.206179798246544, 0.265322081006621, 0.329032089553958, 0.396069786655889, 0.465130363340139, 0.534869636659861, 0.60393021334411, 0.670967910446042, 0.734677918993379, 0.793820201753456, 0.847243631593341, 0.893908402989604, 0.93290628886015, 0.963478386093587, 0.985030248917715, 0.9971472927412, 

0.997384667498776, 0.986271235609057, 0.966485543413008, 0.938376179135221, 0.90244420080942, 0.859330681565975, 0.809804937881823, 0.754750738923004, 0.695150519015145, 0.632067840485173, 0.566628412149233, 0.5, 0.433371587850767, 0.367932159514827, 0.304849480984855, 0.245249261076996, 0.190195062118177, 0.140669318434025, 0.09755579919058, 0.061623820864779, 0.033514456586992, 0.0137287643909425, 0.00261533250122392, 0.00261533250122398, 0.0137287643909425, 0.033514456586992, 0.061623820864779, 0.09755579919058, 0.140669318434025, 0.190195062118177, 0.245249261076996, 0.304849480984855, 0.367932159514827, 0.433371587850767, 0.5, 0.566628412149233, 0.632067840485173, 0.695150519015145, 0.754750738923004, 0.809804937881823, 0.859330681565975, 0.90244420080942, 0.938376179135221, 0.966485543413008, 0.986271235609057, 0.997384667498776, 

0.997593609998511, 0.987364277985655, 0.969137276001367, 0.9432077635022, 0.910000992986951, 0.870062095789277, 0.824046825968488, 0.77271073569442, 0.716896753813023, 0.657521339848081, 0.595559433736808, 0.532028446431303, 0.467971553568697, 0.404440566263192, 0.342478660151919, 0.283103246186977, 0.22728926430558, 0.175953174031512, 0.129937904210723, 0.0899990070130485, 0.0567922364977995, 0.0308627239986334, 0.0126357220143455, 0.00240639000148946, 0.00240639000148951, 0.0126357220143455, 0.0308627239986335, 0.0567922364977995, 0.0899990070130485, 0.129937904210723, 0.175953174031512, 0.22728926430558, 0.283103246186977, 0.342478660151919, 0.404440566263192, 0.467971553568697, 0.532028446431303, 0.595559433736808, 0.657521339848081, 0.716896753813023, 0.77271073569442, 0.824046825968488, 0.870062095789277, 0.910000992986951, 0.9432077635022, 0.969137276001367, 0.987364277985655, 0.997593609998511, 

0.25, 0.5, 0.25, 

0.622008467928146, 0.0446581987385204, 0.333333333333333, 0.333333333333333, 0.0446581987385204, 0.622008467928146, 

0.787298334620741, 0.25, 0.0127016653792584, 0.2, 0.5, 0.2, 0.0127016653792584, 0.25, 0.787298334620741, 

0.865957092583479, 0.44888729929169, 0.108906255706834, 0.00482078098942599, 0.129222126427095, 0.442206445001476, 0.442206445001476, 0.129222126427095, 0.00482078098942598, 0.108906255706834, 0.44888729929169, 0.865957092583479, 

0.908380401265687, 0.591721954534264, 0.25, 0.0532526444285811, 0.00220055532702321, 0.0894190434072896, 0.355025401037155, 0.5, 0.355025401037155, 0.0894190434072897, 0.00220055532702321, 0.0532526444285811, 0.25, 0.591721954534264, 0.908380401265687, 

0.933609605831142, 0.689904156420906, 0.38354437203335, 0.144925185950153, 0.0286947699546411, 0.00114009162798957, 0.0652503025408688, 0.281401073624453, 0.471530442016496, 0.471530442016496, 0.281401073624453, 0.0652503025408688, 0.00114009162798957, 0.0286947699546411, 0.144925185950153, 0.38354437203335, 0.689904156420906, 0.933609605831142, 

0.949755413489286, 0.758232717603808, 0.494100147412834, 0.25, 0.088254996035437, 0.0167015320044137, 0.000647501146528103, 0.0495970853641858, 0.225065750391779, 0.417644856551729, 0.5, 0.417644856551729, 0.225065750391779, 0.0495970853641859, 0.0006475011465281, 0.0167015320044137, 0.088254996035437, 0.25, 0.494100147412834, 0.758232717603808, 0.949755413489286, 

0.960684080371783, 0.807002607765473, 0.581812283426281, 0.350129388264702, 0.166694745769052, 0.0562798735099516, 0.0103361303518458, 0.000394223874246572, 0.0389216957539709, 0.182661261882682, 0.361907843063768, 0.483175865966247, 0.483175865966247, 0.361907843063768, 0.182661261882682, 0.0389216957539709, 0.000394223874246572, 0.0103361303518458, 0.0562798735099516, 0.166694745769052, 0.350129388264702, 0.581812283426281, 0.807002607765473, 0.960684080371783, 

0.968413682094679, 0.842752556767768, 0.650741844963589, 0.438411782349177, 0.25, 0.114158358945368, 0.0373704122629986, 0.00672144944113229, 0.000253442587052937, 0.0313328753182682, 0.150525993791099, 0.311887742773413, 0.447429858705455, 0.5, 0.447429858705455, 0.311887742773413, 0.150525993791099, 0.0313328753182683, 0.000253442587052935, 0.00672144944113229, 0.0373704122629986, 0.114158358945368, 0.25, 0.438411782349177, 0.650741844963589, 0.842752556767768, 0.968413682094679, 

0.974076745830678, 0.869615340441313, 0.705104124523579, 0.513655588977735, 0.32997806169262, 0.181103722710989, 0.0802601948484878, 0.0256945562245545, 0.00455197375232782, 0.00017021731350629, 0.0257530368558155, 0.125832685806359, 0.269201319251867, 0.406084216173777, 0.488918215596391, 0.488918215596391, 0.406084216173777, 0.269201319251867, 0.125832685806359, 0.0257530368558155, 0.00017021731350629, 0.00455197375232783, 0.0256945562245545, 0.0802601948484878, 0.181103722710989, 0.32997806169262, 0.513655588977735, 0.705104124523579, 0.869615340441313, 0.974076745830678, 

0.978347155977587, 0.89025131386088, 0.748356490597976, 0.57691326244278, 0.40293495620636, 0.25, 0.133391800254015, 0.0578171332359678, 0.018204485023927, 0.00318871409278537, 0.000118497831530314, 0.0215343461908824, 0.106559972046334, 0.233439024378097, 0.365269604321252, 0.463673243539625, 0.5, 0.463673243539625, 0.365269604321252, 0.233439024378097, 0.106559972046334, 0.0215343461908825, 0.000118497831530313, 0.00318871409278537, 0.018204485023927, 0.0578171332359678, 0.133391800254015, 0.25, 0.40293495620636, 0.57691326244278, 0.748356490597976, 0.89025131386088, 0.978347155977587, 

0.981645636799065, 0.906415631501956, 0.783138869030038, 0.629894572000163, 0.467740752412902, 0.316537555907585, 0.191304147396116, 0.0999092534147221, 0.0425766177135457, 0.013236194835733, 0.00229837513148131, 8.50025523458168e-05, 0.0182693606485893, 0.0912859933665624, 0.203624936134229, 0.327528810286292, 0.432349994172376, 0.4921582966963, 0.4921582966963, 0.432349994172376, 0.327528810286292, 0.203624936134229, 0.0912859933665625, 0.0182693606485892, 8.50025523458178e-05, 0.0022983751314813, 0.013236194835733, 0.0425766177135457, 0.099909253414722, 0.191304147396116, 0.316537555907585, 0.467740752412902, 0.629894572000163, 0.783138869030038, 0.906415631501956, 0.981645636799065, 

0.984245598658097, 0.919295905175632, 0.81142090425257, 0.67432783819003, 0.524532812451284, 0.378506916825787, 0.25, 0.148048600870652, 0.0760400614148366, 0.0319784987496903, 0.00984281351925965, 0.00169750595265392, 6.25439395087943e-05, 0.0156918574023944, 0.0790065888717141, 0.178736282228171, 0.293693663060279, 0.39942712613388, 0.473444482303562, 0.5, 0.473444482303562, 0.39942712613388, 0.293693663060279, 0.178736282228171, 0.079006588871714, 0.0156918574023943, 6.25439395087951e-05, 0.00169750595265393, 0.00984281351925964, 0.0319784987496903, 0.0760400614148366, 0.148048600870652, 0.25, 0.378506916825787, 0.524532812451284, 0.67432783819003, 0.81142090425257, 0.919295905175632, 0.984245598658097, 

0.986330842172778, 0.929715275132636, 0.83466616144817, 0.711739336656963, 0.573994607496311, 0.435014360464637, 0.306946442338709, 0.198891493631365, 0.115901991536747, 0.0587459711381573, 0.0244464318452785, 0.00746484637840465, 0.00128039146906154, 4.70334759664127e-05, 0.0136221243512552, 0.0690043333983029, 0.157868992173426, 0.263814231497758, 0.367259421365531, 0.449083647998615, 0.494162064029927, 0.494162064029927, 0.449083647998615, 0.367259421365531, 0.263814231497758, 0.157868992173426, 0.0690043333983028, 0.0136221243512552, 4.70334759664127e-05, 0.00128039146906155, 0.00746484637840465, 0.0244464318452785, 0.0587459711381573, 0.115901991536747, 0.198891493631365, 0.306946442338709, 0.435014360464637, 0.573994607496311, 0.711739336656963, 0.83466616144817, 0.929715275132636, 0.986330842172778, 

0.988028562926357, 0.938257049225935, 0.853966893740411, 0.743404128057339, 0.616988391777598, 0.485914494639546, 0.36071681286358, 0.25, 0.159522718866145, 0.0917631475619829, 0.0460162191690593, 0.0189863966971688, 0.00576031032998392, 0.000983656825228953, 3.60449058720948e-05, 0.0119353921677708, 0.0607592939488361, 0.140272795929605, 0.237609475245492, 0.336995389053342, 0.422322357798471, 0.479760468270276, 0.5, 0.479760468270276, 0.422322357798471, 0.336995389053342, 0.237609475245492, 0.140272795929605, 0.0607592939488361, 0.0119353921677709, 3.60449058720941e-05, 0.000983656825228953, 0.00576031032998392, 0.0189863966971689, 0.0460162191690593, 0.0917631475619829, 0.159522718866145, 0.25, 0.36071681286358, 0.485914494639546, 0.616988391777598, 0.743404128057339, 0.853966893740411, 0.938257049225935, 0.988028562926357, 

0.989429020036413, 0.945343005090066, 0.870144945830767, 0.770361159218045, 0.654380885550601, 0.531453230982491, 0.410626915342501, 0.299763099175231, 0.204750589337593, 0.129023364563242, 0.0734364533252639, 0.036504641147957, 0.0149567508630415, 0.00451374344293495, 0.000767982016833162, 2.80850447628065e-05, 0.0105428949188243, 0.0538890128931006, 0.125341310726298, 0.214682089918914, 0.309114473301442, 0.395110315692245, 0.460349720094257, 0.495486311487176, 0.495486311487176, 0.460349720094257, 0.395110315692245, 0.309114473301442, 0.214682089918914, 0.125341310726298, 0.0538890128931006, 0.0105428949188242, 2.80850447628071e-05, 0.000767982016833162, 0.00451374344293494, 0.0149567508630415, 0.036504641147957, 0.0734364533252639, 0.129023364563242, 0.204750589337593, 0.29976309917523, 0.410626915342501, 0.531453230982491, 0.654380885550601, 0.770361159218045, 0.870144945830767, 0.945343005090066, 0.989429020036413, 

0.990597680730804, 0.951283747806964, 0.883824818801993, 0.793448036520103, 0.686968418024702, 0.572058165247744, 0.456456819641668, 0.347206241508985, 0.25, 0.168722060013137, 0.105225056187792, 0.0593676281612665, 0.029297258808011, 0.0119340326233018, 0.00358566507500712, 0.000608226038195817, 2.22054163872912e-05, 0.00938011385280839, 0.0481080261548403, 0.112589516123, 0.194617930856595, 0.283734323167287, 0.36857420659099, 0.43831812417054, 0.484071698477879, 0.5, 0.484071698477879, 0.43831812417054, 0.36857420659099, 0.283734323167287, 0.194617930856595, 0.112589516123, 0.0481080261548402, 0.0093801138528085, 2.22054163872907e-05, 0.000608226038195819, 0.00358566507500712, 0.0119340326233018, 0.029297258808011, 0.0593676281612665, 0.105225056187792, 0.168722060013137, 0.25, 0.347206241508985, 0.456456819641668, 0.572058165247744, 0.686968418024702, 0.793448036520103, 0.883824818801993, 0.951283747806964, 0.990597680730804, 

0.991582955016873, 0.956311830429266, 0.895486024048158, 0.813337894755518, 0.71545126291457, 0.608221261367279, 0.498260335472922, 0.391804780519031, 0.294184207229924, 0.209409194188189, 0.139918554827525, 0.0865091740100785, 0.0484504302933306, 0.0237642198542172, 0.00963293578299473, 0.00288355755060214, 0.000487880857867596, 1.77865959418149e-05, 0.00839925838718536, 0.0432002887128668, 0.10163041840124, 0.177029169461488, 0.260784517231213, 0.343328308339391, 0.415230490517, 0.468276664653444, 0.496406598581887, 0.496406598581887, 0.468276664653444, 0.415230490517, 0.343328308339391, 0.260784517231213, 0.177029169461488, 0.10163041840124, 0.0432002887128668, 0.00839925838718536, 1.77865959418149e-05, 0.000487880857867596, 0.00288355755060214, 0.00963293578299472, 0.0237642198542172, 0.0484504302933306, 0.0865091740100785, 0.139918554827525, 0.209409194188189, 0.294184207229924, 0.391804780519031, 0.498260335472922, 0.608221261367279, 0.71545126291457, 0.813337894755518, 0.895486024048158, 0.956311830429266, 0.991582955016873, 

0.992421257848688, 0.960603999923961, 0.905500598365984, 0.830572179788829, 0.740431145882958, 0.640436318068638, 0.536241864123633, 0.433335257328261, 0.336608046628004, 0.25, 0.176249400987779, 0.116771157364631, 0.071671122747672, 0.0398910134069573, 0.0194649685477287, 0.00785752325168579, 0.0023446947511656, 0.000395847789131208, 1.44140051039295e-05, 0.00756432814620812, 0.0390001522869076, 0.0921547068828508, 0.161570296959485, 0.240103885569314, 0.319672668524404, 0.392087013128695, 0.449893585307108, 0.487142552384216, 0.5, 0.487142552384216, 0.449893585307108, 0.392087013128695, 0.319672668524404, 0.240103885569314, 0.161570296959485, 0.0921547068828508, 0.0390001522869076, 0.00756432814620812, 1.44140051039295e-05, 0.000395847789131208, 0.0023446947511656, 0.00785752325168579, 0.0194649685477287, 0.0398910134069573, 0.071671122747672, 0.116771157364631, 0.176249400987779, 0.25, 0.336608046628004, 0.433335257328261, 0.536241864123633, 0.640436318068638, 0.740431145882958, 0.830572179788829, 0.905500598365984, 0.960603999923961, 0.992421257848688, 

0.993140403222385, 0.964296432783931, 0.914160127147419, 0.845587809011132, 0.762418781880186, 0.669167911554694, 0.57067977439597, 0.471767104543454, 0.376864524065903, 0.289727337675948, 0.21320081654245, 0.149078672924258, 0.0980610158280343, 0.0598127724451431, 0.0331142308281793, 0.0160868754200354, 0.00647083718891318, 0.00192569889609291, 0.000324505506016981, 1.18040372897697e-05, 0.00684779274032547, 0.035379061710052, 0.0839141739564882, 0.147941353799955, 0.221494342699778, 0.297717857617126, 0.369507453158887, 0.430171879628511, 0.474056803009838, 0.497071845781602, 0.497071845781602, 0.474056803009838, 0.430171879628511, 0.369507453158887, 0.297717857617126, 0.221494342699778, 0.147941353799955, 0.0839141739564882, 0.0353790617100521, 0.00684779274032558, 1.18040372897693e-05, 0.000324505506016979, 0.00192569889609291, 0.00647083718891317, 0.0160868754200354, 0.0331142308281794, 0.0598127724451431, 0.0980610158280343, 0.149078672924258, 0.21320081654245, 0.289727337675948, 0.376864524065903, 0.471767104543454, 0.57067977439597, 0.669167911554694, 0.762418781880186, 0.845587809011132, 0.914160127147419, 0.964296432783931, 0.993140403222385, 

0.993761929463378, 0.967495358593896, 0.921695363251203, 0.858738940294898, 0.781844976104464, 0.694837948115194, 0.601880252970003, 0.507187618849256, 0.414749728134348, 0.328077990427137, 0.25, 0.182516136266242, 0.126728411331947, 0.0828454986418167, 0.0502614170827829, 0.0276991439177822, 0.0134050126287863, 0.00537557571158131, 0.00159602910080231, 0.000268520027589744, 9.75884298918222e-06, 0.00622831169363263, 0.0322361213785145, 0.0767086076479944, 0.13588548399352, 0.204750011266749, 0.277462907967024, 0.347858329947214, 0.409966882508928, 0.458521860533705, 0.489405873306621, 0.5, 0.489405873306621, 0.458521860533705, 0.409966882508928, 0.347858329947214, 0.277462907967024, 0.204750011266749, 0.13588548399352, 0.0767086076479942, 0.0322361213785146, 0.00622831169363252, 9.75884298918257e-06, 0.000268520027589742, 0.00159602910080232, 0.00537557571158131, 0.0134050126287863, 0.0276991439177822, 0.0502614170827829, 0.0828454986418167, 0.126728411331947, 0.182516136266242, 0.25, 0.328077990427137, 0.414749728134348, 0.507187618849256, 0.601880252970003, 0.694837948115194, 0.781844976104464, 0.858738940294898, 0.921695363251203, 0.967495358593896, 0.993761929463378, 

0.994302723421103, 0.970284591282895, 0.928290600469503, 0.870314143794818, 0.799072232935424, 0.717821771275474, 0.630150512711898, 0.539751644656441, 0.450197936848328, 0.364731702589863, 0.286085528220652, 0.21634625490093, 0.156871275901642, 0.108262115956244, 0.0703958066696842, 0.0425101092049856, 0.0233345080887908, 0.0112554269562163, 0.00450156607451763, 0.0013338282823291, 0.000224093447465588, 8.13793870441301e-06, 0.00568913864019216, 0.0294913152696398, 0.0703755712481678, 0.125184290130665, 0.189672340108359, 0.258843720635735, 0.327339378083117, 0.389852548673875, 0.441539947195428, 0.478397021508495, 0.497568216878419, 0.497568216878419, 0.478397021508495, 0.441539947195428, 0.389852548673875, 0.327339378083117, 0.258843720635735, 0.189672340108359, 0.125184290130665, 0.0703755712481679, 0.0294913152696398, 0.00568913864019216, 8.13793870441301e-06, 0.000224093447465588, 0.0013338282823291, 0.00450156607451763, 0.0112554269562163, 0.0233345080887908, 0.0425101092049856, 0.0703958066696842, 0.108262115956244, 0.156871275901642, 0.21634625490093, 0.286085528220652, 0.364731702589863, 0.450197936848328, 0.539751644656441, 0.630150512711898, 0.717821771275474, 0.799072232935424, 0.870314143794818, 0.928290600469503, 0.970284591282895, 0.994302723421103, 

0.994776174961644, 0.972730950189817, 0.934094305626337, 0.880549853568416, 0.814405535574553, 0.738449220280643, 0.655784037417783, 0.56964867790482, 0.483234244087026, 0.399509754975589, 0.321067757454761, 0.25, 0.187810933156295, 0.135374074005244, 0.0929332060567352, 0.0601472000588126, 0.0361741616541372, 0.0197878571486931, 0.00951713395571277, 0.00379749529797437, 0.00112321880032137, 0.000188478971702011, 6.83996409195817e-06, 0.00521698507426404, 0.027080570838481, 0.0647824755733412, 0.115652651133609, 0.176077330469734, 0.241762922570664, 0.30804180092808, 0.370204122036367, 0.423832549856239, 0.465116171019166, 0.491121309388944, 0.5, 0.491121309388944, 0.465116171019166, 0.423832549856239, 0.370204122036367, 0.30804180092808, 0.241762922570664, 0.176077330469734, 0.115652651133609, 0.0647824755733413, 0.027080570838481, 0.00521698507426393, 6.83996409195846e-06, 0.000188478971702011, 0.00112321880032137, 0.00379749529797437, 0.00951713395571277, 0.0197878571486931, 0.0361741616541372, 0.0601472000588126, 0.0929332060567352, 0.135374074005244, 0.187810933156295, 0.25, 0.321067757454761, 0.399509754975589, 0.483234244087026, 0.56964867790482, 0.655784037417783, 0.738449220280643, 0.814405535574553, 0.880549853568416, 0.934094305626337, 0.972730950189817, 0.994776174961644, 

0.99519301070986, 0.974888217442133, 0.939227059735349, 0.889640885130823, 0.828101807237238, 0.757008050529229, 0.67905317138874, 0.597081881057412, 0.513940955627649, 0.432334312355616, 0.354691039112907, 0.283054267812106, 0.2189973749495, 0.163572171639291, 0.117291632659453, 0.0801474480016044, 0.0516604096685718, 0.0309595194517636, 0.016883858950675, 0.00809982126333476, 0.00322535812642199, 0.000952507732615824, 0.000159661470823815, 5.79071283926842e-06, 0.00480119857730049, 0.0249521210870433, 0.0598204325320353, 0.107133756742755, 0.163798371499428, 0.226108090520096, 0.289987309159497, 0.351257709274016, 0.405911596370746, 0.45037405498493, 0.481736789247801, 0.497948357238394, 0.497948357238394, 0.481736789247801, 0.45037405498493, 0.405911596370746, 0.351257709274016, 0.289987309159497, 0.226108090520096, 0.163798371499428, 0.107133756742755, 0.0598204325320352, 0.0249521210870433, 0.00480119857730037, 5.79071283926869e-06, 0.000159661470823815, 0.000952507732615828, 0.00322535812642199, 0.00809982126333476, 0.016883858950675, 0.0309595194517636, 0.0516604096685718, 0.0801474480016044, 0.117291632659453, 0.163572171639291, 0.2189973749495, 0.283054267812106, 0.354691039112907, 0.432334312355616, 0.513940955627649, 0.597081881057412, 0.67905317138874, 0.757008050529229, 0.828101807237238, 0.889640885130823, 0.939227059735349, 0.974888217442133, 0.99519301070986, 

0.125, 0.375, 0.375, 0.125, 

0.490562612162344, 0.00943738783765592, 0.394337567297406, 0.105662432702593, 0.105662432702593, 0.394337567297406, 0.00943738783765592, 0.490562612162344, 

0.698568501158667, 0.125, 0.00143149884133249, 0.266189500386223, 0.375, 0.0338104996137776, 0.0338104996137776, 0.375, 0.266189500386223, 0.00143149884133249, 0.125, 0.698568501158667, 

0.805832094644763, 0.300750235878433, 0.0359400966193527, 0.000334715714594482, 0.180374993816148, 0.44441119023977, 0.218898477262444, 0.0134581958244945, 0.0134581958244945, 0.218898477262444, 0.44441119023977, 0.180374993816148, 0.000334715714594481, 0.0359400966193527, 0.300750235878433, 0.805832094644763, 

0.865768206669165, 0.455173033583358, 0.125, 0.0122888648609099, 0.000103228219900906, 0.127836583789568, 0.409646762852719, 0.375, 0.122891338703014, 0.00629198132136692, 0.0062919813213669, 0.122891338703014, 0.375, 0.409646762852719, 0.127836583789568, 0.000103228219900906, 0.0122888648609099, 0.125, 0.455173033583358, 0.865768206669165, 

0.902086050717951, 0.57303763020425, 0.23753270895737, 0.0551716280178859, 0.00486075935907112, 3.84954707455275e-05, 0.0945706653395711, 0.350599578649969, 0.438034989227942, 0.269260673796802, 0.07150203178671, 0.00330478847173213, 0.00330478847173213, 0.07150203178671, 0.269260673796802, 0.438034989227942, 0.350599578649969, 0.0945706653395711, 3.84954707455275e-05, 0.00486075935907113, 0.0551716280178859, 0.23753270895737, 0.57303763020425, 0.902086050717951, 

0.925587895611168, 0.660242961824405, 0.347314148267595, 0.125, 0.0262185669048118, 0.0021584125879273, 1.64763425536365e-05, 0.0725025536343552, 0.293969267338208, 0.440357997435717, 0.375, 0.186109287391876, 0.0436293582494593, 0.0018930744119234, 0.00189307441192339, 0.0436293582494593, 0.186109287391876, 0.375, 0.440357997435717, 0.293969267338208, 0.0725025536343554, 1.64763425536364e-05, 0.0021584125879273, 0.0262185669048118, 0.125, 0.347314148267595, 0.660242961824405, 0.925587895611168, 

0.941609629025734, 0.724957266278801, 0.443786747427108, 0.207177623714129, 0.0680585773365012, 0.0133514879772403, 0.00105084089717636, 7.82734330921435e-06, 0.0572233540381443, 0.246136024460014, 0.414076607997518, 0.428855293651718, 0.295908505297651, 0.128785156598134, 0.0278558683640082, 0.00115918959281207, 0.00115918959281207, 0.0278558683640082, 0.128785156598134, 0.295908505297652, 0.428855293651718, 0.414076607997518, 0.246136024460014, 0.0572233540381443, 7.82734330921435e-06, 0.00105084089717636, 0.0133514879772403, 0.0680585773365012, 0.207177623714129, 0.443786747427108, 0.724957266278801, 0.941609629025734, 

0.952996652246962, 0.77365995500234, 0.524944151363565, 0.290284151818232, 0.125, 0.0385710601235858, 0.00722423447631573, 0.000551054311011232, 4.0347756351666e-06, 0.0462510895431489, 0.207277805296286, 0.377393080800071, 0.444382891592836, 0.375, 0.226761896465347, 0.0904385333600487, 0.0185111853903632, 0.000748223434253312, 0.000748223434253307, 0.0185111853903632, 0.0904385333600486, 0.226761896465347, 0.375, 0.444382891592836, 0.377393080800071, 0.207277805296286, 0.0462510895431491, 4.03477563516656e-06, 0.000551054311011232, 0.00722423447631572, 0.0385710601235858, 0.125, 0.290284151818232, 0.524944151363565, 0.77365995500234, 0.952996652246962, 

0.961368223935969, 0.810943857283931, 0.592079306686002, 0.368135777704715, 0.189551663752774, 0.0770710128526389, 0.0227378980346186, 0.00411871443619747, 0.000307114006529612, 2.22078030792999e-06, 0.0381255656841281, 0.176014449472144, 0.339074453512729, 0.436559433819058, 0.421279193819537, 0.31209812957505, 0.172566890441608, 0.0647275253650712, 0.0127345792373946, 0.00050398959959508, 0.00050398959959508, 0.0127345792373947, 0.0647275253650712, 0.172566890441608, 0.31209812957505, 0.421279193819537, 0.436559433819058, 0.339074453512729, 0.176014449472144, 0.0381255656841281, 2.22078030792999e-06, 0.000307114006529613, 0.00411871443619747, 0.0227378980346186, 0.0770710128526389, 0.189551663752774, 0.368135777704715, 0.592079306686002, 0.810943857283931, 0.961368223935969, 

0.967697190785277, 0.839979979390638, 0.647385241546223, 0.43819335193245, 0.255771657972871, 0.125, 0.0487184767176915, 0.0139022415856712, 0.00245622188663198, 0.000180062539861009, 1.28992839959871e-06, 0.0319498955769315, 0.150814003410728, 0.30291374715526, 0.416159731530989, 0.441489894700467, 0.375, 0.254019970608971, 0.13174467495089, 0.0472447894118851, 0.0090259546587731, 0.000351623709392146, 0.000351623709392142, 0.0090259546587731, 0.0472447894118851, 0.13174467495089, 0.254019970608971, 0.375, 0.441489894700467, 0.416159731530989, 0.30291374715526, 0.150814003410728, 0.0319498955769316, 1.28992839959869e-06, 0.000180062539861009, 0.00245622188663198, 0.0139022415856712, 0.0487184767176915, 0.125, 0.255771657972871, 0.43819335193245, 0.647385241546223, 0.839979979390638, 0.967697190785277, 

0.97259517533054, 0.862960822693408, 0.693039789280884, 0.499921481721771, 0.319895267257738, 0.178089316477891, 0.0836732384776598, 0.0315797414836979, 0.00878530284879135, 0.00152280651777266, 0.000110187256748149, 7.83696576333459e-07, 0.0271513844055756, 0.130364426425644, 0.270297239247462, 0.389919270835174, 0.443536455465491, 0.415344718289082, 0.322892726755367, 0.204988535793072, 0.101373944594263, 0.0351401649538812, 0.00656456362419948, 0.00025265656730845, 0.000252656567308453, 0.00656456362419946, 0.0351401649538811, 0.101373944594263, 0.204988535793072, 0.322892726755368, 0.415344718289082, 0.443536455465492, 0.389919270835174, 0.270297239247462, 0.130364426425644, 0.0271513844055754, 7.83696576333474e-07, 0.000110187256748149, 0.00152280651777266, 0.00878530284879134, 0.0315797414836979, 0.0836732384776598, 0.178089316477891, 0.319895267257738, 0.499921481721771, 0.693039789280884, 0.862960822693408, 0.97259517533054, 

0.976461719269374, 0.881420178088515, 0.73091906173222, 0.553740939808814, 0.379890988258222, 0.232868491727414, 0.125, 0.0569647848172437, 0.0209683225409581, 0.00571856560076649, 0.000976514925523745, 6.99386039136033e-05, 4.94627034447266e-07, 0.0233516381661685, 0.11362718126135, 0.241505527561048, 0.361760695143648, 0.433925472579184, 0.436915275295118, 0.375, 0.273251448160224, 0.165215216621636, 0.0787797994467713, 0.0265988957812077, 0.00488270204622096, 0.000186147937423041, 0.000186147937423044, 0.00488270204622097, 0.0265988957812077, 0.0787797994467714, 0.165215216621636, 0.273251448160224, 0.375, 0.436915275295118, 0.433925472579184, 0.361760695143648, 0.241505527561049, 0.11362718126135, 0.0233516381661684, 4.94627034447277e-07, 6.99386039136036e-05, 0.000976514925523743, 0.0057185656007665, 0.0209683225409581, 0.0569647848172437, 0.125, 0.232868491727414, 0.379890988258222, 0.553740939808814, 0.73091906173222, 0.881420178088515, 0.976461719269374, 

0.97956649091304, 0.896447684220326, 0.762551553921164, 0.600456366408335, 0.43487227314286, 0.28691641177508, 0.17005676221076, 0.0887001417443503, 0.0394581162269978, 0.0142385948088432, 0.00382228634502808, 0.000644957818697276, 4.58156822197784e-05, 3.22560077004606e-07, 0.0202930537792146, 0.0998027727369291, 0.216343822581016, 0.333848910745886, 0.417367003060355, 0.444293846068674, 0.410669040383847, 0.330574055661043, 0.229331625929249, 0.133522128987943, 0.0618724365007512, 0.0204596656791221, 0.0037037273605253, 0.000140132747668224, 0.000140132747668224, 0.00370372736052531, 0.0204596656791221, 0.0618724365007512, 0.133522128987942, 0.229331625929249, 0.330574055661043, 0.410669040383847, 0.444293846068674, 0.417367003060355, 0.333848910745886, 0.216343822581016, 0.099802772736929, 0.0202930537792146, 3.22560077004606e-07, 4.58156822197786e-05, 0.000644957818697276, 0.00382228634502807, 0.0142385948088431, 0.0394581162269978, 0.0887001417443503, 0.17005676221076, 0.28691641177508, 0.43487227314286, 0.600456366408335, 0.762551553921164, 0.896447684220326, 0.97956649091304, 

0.982096695344065, 0.908830208348901, 0.78915361751279, 0.640969629994211, 0.484635797152551, 0.338719173633118, 0.216645452608655, 0.125, 0.0637138449859316, 0.0277972896691751, 0.0098711192674354, 0.00261615713755078, 0.000437188592802236, 3.0850727844252e-05, 2.16404278856247e-07, 0.0177956027468764, 0.0882805226311001, 0.194439828682863, 0.307303494189384, 0.397057783875142, 0.441585963019283, 0.432214080764774, 0.375, 0.287426621640639, 0.191897573678423, 0.108435299704872, 0.0491107186788542, 0.0159693652115451, 0.0028584182921541, 0.000107485504779716, 0.000107485504779714, 0.0028584182921541, 0.015969365211545, 0.0491107186788542, 0.108435299704872, 0.191897573678423, 0.287426621640639, 0.375, 0.432214080764774, 0.441585963019283, 0.397057783875142, 0.307303494189384, 0.194439828682863, 0.0882805226311001, 0.0177956027468766, 2.16404278856241e-07, 3.0850727844252e-05, 0.000437188592802235, 0.00261615713755079, 0.0098711192674354, 0.0277972896691751, 0.0637138449859316, 0.125, 0.216645452608655, 0.338719173633118, 0.484635797152551, 0.640969629994211, 0.78915361751279, 0.908830208348901, 0.982096695344065, 

0.984185508784156, 0.919145197967567, 0.811684780770974, 0.676147687458413, 0.529353644761741, 0.387433863656307, 0.263130456374242, 0.164122171792289, 0.0926483609769465, 0.0463449634843732, 0.0199006628053256, 0.00697464528609555, 0.00182917766321623, 0.000303253139578489, 2.1282692781575e-05, 1.48837607601701e-07, 0.0157305337567709, 0.0785934213674962, 0.175380495179378, 0.282640415278895, 0.375081722366579, 0.432058101978553, 0.442489376904778, 0.406922782148825, 0.33630668508194, 0.248035203236607, 0.160607371559815, 0.0885899875855843, 0.0393827195994759, 0.0126314709100694, 0.00224009797215476, 8.38086214656144e-05, 8.38086214656161e-05, 0.00224009797215476, 0.0126314709100694, 0.0393827195994759, 0.0885899875855843, 0.160607371559815, 0.248035203236607, 0.33630668508194, 0.406922782148825, 0.442489376904778, 0.432058101978553, 0.375081722366579, 0.282640415278895, 0.175380495179378, 0.0785934213674962, 0.0157305337567707, 1.48837607601705e-07, 2.1282692781575e-05, 0.000303253139578488, 0.00182917766321623, 0.00697464528609555, 0.0199006628053256, 0.0463449634843732, 0.0926483609769465, 0.164122171792289, 0.263130456374242, 0.387433863656307, 0.529353644761741, 0.676147687458413, 0.811684780770974, 0.919145197967567, 0.984185508784156, 

0.98592972458304, 0.927822960551749, 0.830901014673583, 0.706769394212492, 0.569383866926132, 0.432673486616657, 0.308389476672479, 0.204588531667483, 0.125, 0.0693039206156993, 0.0341333370717103, 0.0144652034968583, 0.0050146483229375, 0.00130370950261508, 0.000214711141917221, 1.5000215990329e-05, 1.04637747447839e-07, 0.0140038684432931, 0.0703823617656441, 0.15877141238523, 0.260035926922833, 0.35275365329571, 0.41815403589326, 0.444202028907566, 0.427853129524506, 0.375, 0.298254418192312, 0.213275157348245, 0.134707273993225, 0.0728478314552206, 0.03189096936206, 0.0101128617992697, 0.00177967746661646, 6.63023359195301e-05, 6.63023359195286e-05, 0.00177967746661647, 0.0101128617992697, 0.0318909693620601, 0.0728478314552206, 0.134707273993225, 0.213275157348245, 0.298254418192312, 0.375, 0.427853129524506, 0.444202028907566, 0.41815403589326, 0.35275365329571, 0.260035926922833, 0.15877141238523, 0.0703823617656439, 0.0140038684432932, 1.04637747447835e-07, 1.50002159903291e-05, 0.000214711141917221, 0.00130370950261508, 0.0050146483229375, 0.0144652034968583, 0.0341333370717103, 0.0693039206156993, 0.125, 0.204588531667483, 0.308389476672479, 0.432673486616657, 0.569383866926132, 0.706769394212492, 0.830901014673583, 0.927822960551749, 0.98592972458304, 

0.987401037405751, 0.93518879060601, 0.847399528913817, 0.7335107970454, 0.605159815706872, 0.474342891159843, 0.351709803657381, 0.245247503945929, 0.159561838617257, 0.095828263509913, 0.0523374990739049, 0.0254444605671187, 0.0106646463310713, 0.00366340844630878, 0.000945448762369001, 0.000154843484323509, 1.07763246901542e-05, 7.50134705670802e-08, 0.0125457528333643, 0.0633691194697678, 0.144259485403024, 0.239481293130354, 0.330874341623094, 0.401635110622308, 0.43965159544662, 0.439671829719305, 0.403867105838002, 0.340742792034828, 0.262743167260861, 0.183194140328879, 0.113357351886778, 0.0603024342237251, 0.0260624610618772, 0.0081861421988359, 0.00143131359953232, 5.31347474137434e-05, 5.31347474137434e-05, 0.00143131359953232, 0.0081861421988359, 0.0260624610618772, 0.0603024342237251, 0.113357351886778, 0.183194140328879, 0.262743167260861, 0.340742792034828, 0.403867105838002, 0.439671829719305, 0.43965159544662, 0.401635110622308, 0.330874341623094, 0.239481293130354, 0.144259485403024, 0.0633691194697678, 0.0125457528333643, 7.50134705670802e-08, 1.07763246901542e-05, 0.000154843484323509, 0.000945448762368999, 0.00366340844630878, 0.0106646463310713, 0.0254444605671187, 0.0523374990739049, 0.095828263509913, 0.159561838617257, 0.245247503945929, 0.351709803657381, 0.474342891159843, 0.605159815706872, 0.7335107970454, 0.847399528913817, 0.93518879060601, 0.987401037405751, 

0.988653453056792, 0.941491895812137, 0.861654404753486, 0.756948042706551, 0.637128479355068, 0.512523670909787, 0.392682072248188, 0.285256821523445, 0.195293028548436, 0.125, 0.073993142875239, 0.0399028005158925, 0.0191874080587693, 0.00796732630360646, 0.00271569229096114, 0.00069651185422125, 0.000113534922237856, 7.87575750143646e-06, 5.47238957967567e-08, 0.0113034143756878, 0.057336312335472, 0.131538580837493, 0.220872411246834, 0.309907999583667, 0.383737941476554, 0.430679375626334, 0.444235307414448, 0.423945054238704, 0.375, 0.306768774337621, 0.230605070546215, 0.157451144066708, 0.0957710613100525, 0.0502478287703028, 0.0214830341923936, 0.00669347948678325, 0.00116391609488932, 4.30778436243982e-05, 4.30778436243982e-05, 0.00116391609488932, 0.00669347948678325, 0.0214830341923936, 0.0502478287703027, 0.0957710613100526, 0.157451144066708, 0.230605070546215, 0.306768774337621, 0.375, 0.423945054238704, 0.444235307414448, 0.430679375626334, 0.383737941476554, 0.309907999583668, 0.220872411246834, 0.131538580837493, 0.057336312335472, 0.0113034143756878, 5.47238957967567e-08, 7.87575750143646e-06, 0.000113534922237856, 0.00069651185422125, 0.00271569229096114, 0.00796732630360647, 0.0191874080587693, 0.0399028005158925, 0.073993142875239, 0.125, 0.195293028548436, 0.285256821523445, 0.392682072248188, 0.512523670909787, 0.637128479355068, 0.756948042706551, 0.861654404753486, 0.941491895812137, 0.988653453056792, 

0.989728270334376, 0.946925561780937, 0.874044234032952, 0.777567445359169, 0.665718122440926, 0.547397312361567, 0.431110619907807, 0.324034671983494, 0.231354465222673, 0.155949581452779, 0.0984426498748178, 0.0575603302625696, 0.0307075085737394, 0.0146282003538629, 0.00602590121274422, 0.00204036350940672, 0.000520523940898876, 8.45050323156925e-05, 5.84565398474856e-06, 4.05551357260468e-08, 0.0102363986640261, 0.0521126130089813, 0.120347679343401, 0.204061090955889, 0.290101978317781, 0.365311797579384, 0.41870746346449, 0.443197297679882, 0.436530176529691, 0.401333268669506, 0.344274500002897, 0.274555027985066, 0.202060521762885, 0.135553716273841, 0.0812649888463054, 0.042139535731886, 0.0178509397440429, 0.00552358159133166, 0.000955979556096696, 3.52904464621309e-05, 3.52904464621297e-05, 0.000955979556096691, 0.00552358159133166, 0.0178509397440429, 0.042139535731886, 0.0812649888463054, 0.13555371627384, 0.202060521762885, 0.274555027985066, 0.344274500002897, 0.401333268669506, 0.436530176529691, 0.443197297679882, 0.41870746346449, 0.365311797579384, 0.290101978317781, 0.204061090955889, 0.120347679343401, 0.0521126130089815, 0.0102363986640262, 4.05551357260449e-08, 5.84565398474851e-06, 8.45050323156925e-05, 0.000520523940898875, 0.00204036350940672, 0.00602590121274422, 0.0146282003538629, 0.0307075085737394, 0.0575603302625696, 0.0984426498748178, 0.155949581452779, 0.231354465222673, 0.324034671983494, 0.431110619907807, 0.547397312361567, 0.665718122440926, 0.777567445359169, 0.874044234032952, 0.946925561780937, 0.989728270334376, 

0.990657501973758, 0.951641417807122, 0.884873326634074, 0.795777645841832, 0.691322950492911, 0.579195652965874, 0.466944368728411, 0.361204344187356, 0.26710324548752, 0.187916815511546, 0.125, 0.0779743745285226, 0.0451139637119216, 0.0238453320492528, 0.0112681363507681, 0.00460998508359048, 0.00155203260696538, 0.000394128167886962, 6.37618939347207e-05, 4.40012510618934e-06, 3.04857929694112e-08, 0.0093132824688603, 0.0475618223603211, 0.110466109851389, 0.188883883359198, 0.271566076834661, 0.34692688544796, 0.404807652724777, 0.4379498239857, 0.442939447940483, 0.420483524746774, 0.375, 0.313625285213158, 0.244843342860076, 0.177000499777692, 0.116979842196045, 0.0692674765025752, 0.0355589400654629, 0.014944342631083, 0.00459680162060278, 0.000792359707450664, 2.91850715886384e-05, 2.91850715886395e-05, 0.000792359707450659, 0.00459680162060279, 0.014944342631083, 0.0355589400654629, 0.0692674765025752, 0.116979842196045, 0.177000499777691, 0.244843342860076, 0.313625285213158, 0.375, 0.420483524746774, 0.442939447940483, 0.4379498239857, 0.404807652724777, 0.34692688544796, 0.271566076834661, 0.188883883359198, 0.110466109851389, 0.0475618223603213, 0.00931328246886014, 3.04857929694128e-08, 4.4001251061893e-06, 6.3761893934721e-05, 0.000394128167886962, 0.00155203260696538, 0.00460998508359048, 0.0112681363507681, 0.0238453320492528, 0.0451139637119216, 0.0779743745285226, 0.125, 0.187916815511546, 0.26710324548752, 0.361204344187356, 0.466944368728411, 0.579195652965874, 0.691322950492911, 0.795777645841832, 0.884873326634074, 0.951641417807122, 0.990657501973758, 

0.991466268824555, 0.955759672472413, 0.894387929566203, 0.811921538030122, 0.714297383616642, 0.608169924332197, 0.500226207136002, 0.396543615069448, 0.302068368974242, 0.220272494958456, 0.153018462533024, 0.100629212149348, 0.0621319727788005, 0.0356217102326158, 0.0186775619197404, 0.00876472573932248, 0.00356449471419948, 0.00119410622081884, 0.000302026773880634, 4.87135615446777e-05, 3.35462312773106e-06, 2.32151568137525e-08, 0.00850936378964544, 0.0435747564314461, 0.101708012709898, 0.175177817294086, 0.254324547956347, 0.328955540829829, 0.389772916727686, 0.42962408876098, 0.444388703622258, 0.433377622894219, 0.399201197062882, 0.347151128254746, 0.284217909368524, 0.217921217170884, 0.155154734249831, 0.101236150396989, 0.0593100401237739, 0.0301839622061922, 0.012598617901911, 0.00385534416235328, 0.000662216473013569, 2.43441706427978e-05, 2.43441706427978e-05, 0.000662216473013569, 0.00385534416235327, 0.012598617901911, 0.0301839622061923, 0.0593100401237739, 0.101236150396989, 0.155154734249831, 0.217921217170884, 0.284217909368524, 0.347151128254746, 0.399201197062882, 0.433377622894219, 0.444388703622258, 0.42962408876098, 0.389772916727686, 0.328955540829829, 0.254324547956347, 0.175177817294086, 0.101708012709899, 0.0435747564314461, 0.00850936378964544, 2.32151568137525e-08, 3.35462312773106e-06, 4.87135615446774e-05, 0.000302026773880635, 0.00119410622081884, 0.00356449471419948, 0.00876472573932248, 0.0186775619197404, 0.0356217102326158, 0.0621319727788004, 0.100629212149348, 0.153018462533024, 0.220272494958456, 0.302068368974242, 0.396543615069448, 0.500226207136002, 0.608169924332197, 0.714297383616642, 0.811921538030122, 0.894387929566203, 0.955759672472413, 0.991466268824555, 

0.992174504499824, 0.959376556158883, 0.902788642572267, 0.826287007129609, 0.734955552686345, 0.634572071765628, 0.531057151684999, 0.429942760575175, 0.335920535582988, 0.252517268080181, 0.181926113598906, 0.125, 0.0813919223176779, 0.0498084753910697, 0.0283306396326543, 0.014751056370274, 0.0068801469228816, 0.00278354437837652, 0.000928451609053365, 0.000234016169977213, 3.7644067721064e-05, 2.58758339514403e-06, 1.78887803969028e-08, 0.00780501138546137, 0.0400631820928009, 0.0939169891622109, 0.162788539316422, 0.238349948664623, 0.311631445545046, 0.374180657198353, 0.419117751988935, 0.441941125512115, 0.440977460686225, 0.417424931567564, 0.375, 0.319257032515852, 0.256696795842524, 0.193807699272243, 0.136188431065616, 0.0878820441937668, 0.0510129383109499, 0.0257660470399782, 0.0106904373839915, 0.00325672419780093, 0.000557674164920601, 2.04662259346838e-05, 2.04662259346847e-05, 0.000557674164920601, 0.00325672419780092, 0.0106904373839915, 0.0257660470399782, 0.0510129383109498, 0.0878820441937668, 0.136188431065616, 0.193807699272243, 0.256696795842524, 0.319257032515852, 0.375, 0.417424931567564, 0.440977460686225, 0.441941125512115, 0.419117751988935, 0.374180657198353, 0.311631445545046, 0.238349948664623, 0.162788539316422, 0.0939169891622111, 0.0400631820928009, 0.00780501138546121, 1.78887803969039e-08, 2.58758339514403e-06, 3.76440677210638e-05, 0.000234016169977213, 0.000928451609053365, 0.00278354437837651, 0.0068801469228816, 0.014751056370274, 0.0283306396326543, 0.0498084753910697, 0.0813919223176779, 0.125, 0.181926113598906, 0.252517268080181, 0.335920535582988, 0.429942760575175, 0.531057151684999, 0.634572071765628, 0.734955552686345, 0.826287007129609, 0.902788642572267, 0.959376556158883, 0.992174504499824, 

0.992798188199336, 0.962569800931473, 0.910239954218689, 0.839116189584362, 0.753573466880175, 0.658644010972816, 0.559571610546727, 0.461371579581681, 0.368442602741025, 0.284269036322364, 0.211239594405603, 0.150592922359824, 0.102484541782584, 0.0661552217226951, 0.0401698812002406, 0.0226900027028562, 0.0117418565072945, 0.00544742571402813, 0.00219385324704017, 0.000728975870683305, 0.000183175301505857, 2.93969832582863e-05, 2.01743796173126e-06, 1.39347134779122e-08, 0.00718446753157336, 0.0369552495319788, 0.0869613165499804, 0.151574086639384, 0.223585021071187, 0.295092118669239, 0.358444682526039, 0.407130904427193, 0.436495058659875, 0.444195828099757, 0.430354334121913, 0.397384036356843, 0.349538499500748, 0.292250849749789, 0.231365254377638, 0.172372335896245, 0.119755659483832, 0.0765362812132063, 0.0440700171109045, 0.0221125361779544, 0.0091265484747484, 0.00276933224807261, 0.000472932098586252, 1.73303343773715e-05, 1.73303343773723e-05, 0.000472932098586252, 0.00276933224807262, 0.00912654847474841, 0.0221125361779544, 0.0440700171109046, 0.0765362812132063, 0.119755659483832, 0.172372335896245, 0.231365254377638, 0.292250849749789, 0.349538499500748, 0.397384036356843, 0.430354334121913, 0.444195828099757, 0.436495058659875, 0.407130904427193, 0.358444682526039, 0.295092118669239, 0.223585021071187, 0.151574086639384, 0.0869613165499802, 0.0369552495319788, 0.00718446753157319, 1.39347134779131e-08, 2.01743796173126e-06, 2.93969832582865e-05, 0.000183175301505857, 0.000728975870683305, 0.00219385324704017, 0.00544742571402813, 0.0117418565072946, 0.0226900027028562, 0.0401698812002406, 0.0661552217226951, 0.102484541782584, 0.150592922359824, 0.211239594405603, 0.284269036322364, 0.368442602741025, 0.461371579581681, 0.559571610546727, 0.658644010972816, 0.753573466880175, 0.839116189584362, 0.910239954218689, 0.962569800931473, 0.992798188199336, 

0.0625, 0.25, 0.375, 0.25, 0.0625, 

0.38689453417432, 0.00199435471456919, 0.414672311952097, 0.0297721324923469, 0.166666666666667, 0.166666666666667, 0.0297721324923469, 0.414672311952097, 0.00199435471456919, 0.38689453417432, 

0.619838667696593, 0.0625, 0.00016133230340665, 0.314919333848297, 0.25, 0.00508066615170335, 0.0600000000000002, 0.375, 0.0600000000000002, 0.00508066615170335, 0.25, 0.314919333848297, 0.00016133230340665, 0.0625, 0.619838667696593, 

0.749881686195632, 0.201499807465387, 0.0118605725320823, 2.3239929348011e-05, 0.223801633796524, 0.397001713652184, 0.0963180963490815, 0.00124590314098588, 0.0250475369375102, 0.293319810001265, 0.293319810001265, 0.0250475369375102, 0.00124590314098588, 0.0963180963490815, 0.397001713652184, 0.223801633796524, 2.3239929348011e-05, 0.0118605725320823, 0.201499807465387, 0.749881686195632, 

0.825154953403611, 0.35013487147785, 0.0625, 0.00283584413863688, 4.84244374729024e-06, 0.162453013062215, 0.420152648422032, 0.25, 0.037812082889092, 0.000393543104614463, 0.0119936479858121, 0.189064553072389, 0.375, 0.189064553072389, 0.0119936479858121, 0.000393543104614461, 0.037812082889092, 0.25, 0.420152648422032, 0.162453013062215, 4.84244374729021e-06, 0.00283584413863688, 0.0625, 0.35013487147785, 0.825154953403611, 

0.87162689610018, 0.475967745046842, 0.147106285318457, 0.0210033095226865, 0.000823389822749775, 1.29980892021191e-06, 0.121836618471087, 0.388279540629631, 0.36170569455565, 0.136673273980797, 0.0161494781452854, 0.000148782647301262, 0.00638640297251237, 0.118779846355492, 0.333511436622409, 0.333511436622409, 0.118779846355492, 0.00638640297251237, 0.000148782647301262, 0.0161494781452854, 0.136673273980797, 0.36170569455565, 0.388279540629631, 0.121836618471087, 1.29980892021191e-06, 0.000823389822749776, 0.0210033095226865, 0.147106285318457, 0.475967745046842, 0.87162689610018, 

0.902035345452205, 0.574916854044856, 0.244134955673384, 0.0625, 0.00778894432521501, 0.000278941171294456, 4.19257734755207e-07, 0.0942102006358513, 0.341304431118197, 0.412716770376842, 0.25, 0.073718490318387, 0.00751788566653136, 6.42283392755251e-05, 0.00368980631493349, 0.0759818879991215, 0.261640839306171, 0.375, 0.261640839306171, 0.0759818879991215, 0.00368980631493351, 6.42283392755246e-05, 0.00751788566653136, 0.073718490318387, 0.25, 0.412716770376842, 0.341304431118197, 0.0942102006358515, 4.19257734755204e-07, 0.000278941171294456, 0.00778894432521501, 0.0625, 0.244134955673384, 0.574916854044856, 0.902035345452205, 

0.922913902279778, 0.651253208940273, 0.338505533145703, 0.122590588526614, 0.0277871382670088, 0.00316742416229615, 0.000106835590650347, 1.55412463025977e-07, 0.0747829069838277, 0.294816229354112, 0.421124857125621, 0.338348140750059, 0.16108575627797, 0.0407362552597765, 0.00377602122610407, 3.06877233847535e-05, 0.00227234760054701, 0.0500477048888603, 0.196465930306603, 0.350188376178348, 0.350188376178348, 0.196465930306603, 0.0500477048888603, 0.00227234760054701, 3.06877233847535e-05, 0.00377602122610407, 0.0407362552597765, 0.16108575627797, 0.338348140750059, 0.421124857125621, 0.294816229354112, 0.0747829069838277, 1.55412463025977e-07, 0.000106835590650347, 0.00316742416229615, 0.0277871382670088, 0.122590588526614, 0.338505533145703, 0.651253208940273, 0.922913902279778, 

0.937825059668174, 0.71023187193861, 0.423464948786615, 0.192204890902582, 0.0625, 0.0130321309170995, 0.00139654771270648, 4.51778825896976e-05, 6.42331449320857e-08, 0.0606863703151551, 0.253712332254917, 0.405916810307799, 0.392317043662598, 0.25, 0.102155716825945, 0.023310747054437, 0.00202350571368614, 1.58821699609381e-05, 0.00147262361356521, 0.0339871122101972, 0.145910946138442, 0.300290217691775, 0.375, 0.300290217691775, 0.145910946138442, 0.0339871122101972, 0.00147262361356522, 1.58821699609379e-05, 0.00202350571368614, 0.023310747054437, 0.102155716825945, 0.25, 0.392317043662598, 0.4059168103078, 0.253712332254917, 0.0606863703151553, 6.42331449320848e-08, 4.51778825896976e-05, 0.00139654771270648, 0.0130321309170995, 0.0625, 0.192204890902582, 0.423464948786615, 0.71023187193861, 0.937825059668174, 

0.948825506768084, 0.756230840330861, 0.497171826420162, 0.263842064088064, 0.108885521198418, 0.0327985583797788, 0.00644169887711723, 0.000660210219576795, 2.07204650418815e-05, 2.89739338172986e-08, 0.0501708686715405, 0.218852067812284, 0.37962992106336, 0.417174854466607, 0.322664570217423, 0.177089817891441, 0.0651847966300056, 0.0138340168664827, 0.00114557416595092, 8.76722549645076e-06, 0.000994828360945484, 0.0237507972258629, 0.108704025430418, 0.247356585938207, 0.358561532312939, 0.358561532312939, 0.247356585938207, 0.108704025430418, 0.0237507972258629, 0.000994828360945484, 8.76722549645076e-06, 0.00114557416595093, 0.0138340168664827, 0.0651847966300056, 0.177089817891441, 0.322664570217423, 0.417174854466607, 0.37962992106336, 0.218852067812284, 0.0501708686715405, 2.89739338172986e-08, 2.07204650418815e-05, 0.000660210219576795, 0.00644169887711723, 0.0327985583797788, 0.108885521198418, 0.263842064088064, 0.497171826420162, 0.756230840330861, 0.948825506768084, 

0.957163157609433, 0.792547401831024, 0.560037437020119, 0.332828912382372, 0.162356578933021, 0.0625, 0.0177933723750071, 0.00334282089562565, 0.000331403274986382, 1.01678975655281e-05, 1.40417360773867e-08, 0.0421361327033732, 0.189730310238456, 0.349391218104416, 0.421457758200314, 0.373660316159399, 0.25, 0.123700417370738, 0.0422376827601822, 0.00849927444658239, 0.000679578569181923, 5.10354665408531e-06, 0.000695592098803157, 0.0170325414637733, 0.0817406671538966, 0.200132825761506, 0.322489315161834, 0.375, 0.322489315161835, 0.200132825761506, 0.0817406671538966, 0.0170325414637733, 0.000695592098803164, 5.10354665408523e-06, 0.000679578569181923, 0.0084992744465824, 0.0422376827601822, 0.123700417370738, 0.25, 0.373660316159399, 0.421457758200314, 0.349391218104416, 0.189730310238456, 0.0421361327033734, 1.40417360773864e-08, 1.01678975655281e-05, 0.000331403274986383, 0.00334282089562565, 0.017793372375007, 0.0625, 0.162356578933021, 0.332828912382372, 0.560037437020119, 0.792547401831024, 0.957163157609433, 

0.963628156246642, 0.82158929703109, 0.613306488185647, 0.396767171835268, 0.218781411467788, 0.100196024299947, 0.0365972768109547, 0.00998185891788715, 0.00181276837592541, 0.000175196853729486, 5.28252824501172e-06, 7.22543390530333e-09, 0.0358680763355925, 0.165486102649272, 0.318933204380947, 0.412617239546012, 0.404455423159802, 0.311573168711773, 0.18830384666682, 0.086391530263243, 0.0278901378914638, 0.00539043865617271, 0.00041961891401255, 3.10588456971262e-06, 0.000500654307762337, 0.0124996988773801, 0.0621946719235032, 0.16091268235133, 0.28038977619128, 0.363329683510505, 0.363329683510505, 0.28038977619128, 0.16091268235133, 0.0621946719235033, 0.0124996988773801, 0.000500654307762331, 3.10588456971268e-06, 0.000419618914012548, 0.0053904386561727, 0.0278901378914637, 0.086391530263243, 0.18830384666682, 0.311573168711773, 0.404455423159802, 0.412617239546012, 0.318933204380948, 0.165486102649272, 0.0358680763355923, 7.2254339053035e-09, 5.2825282450117e-06, 0.000175196853729486, 0.00181276837592541, 0.00998185891788714, 0.0365972768109547, 0.100196024299947, 0.218781411467788, 0.396767171835268, 0.613306488185647, 0.82158929703109, 0.963628156246642, 

0.968739398477836, 0.845104961272685, 0.658403883858058, 0.45471803335804, 0.275134671338053, 0.143267486084963, 0.0625, 0.0219183882197575, 0.00578209093997213, 0.00102262438228394, 9.68809779749206e-05, 2.8815264592955e-06, 3.91174436927972e-09, 0.0308892831661543, 0.145260867263323, 0.29006071149665, 0.396091625803099, 0.419025267680675, 0.358404022569804, 0.25, 0.140185586389945, 0.0607449264039438, 0.0187837648739302, 0.0035185357901953, 0.000268228309817231, 1.96286116031195e-06, 0.000369351583105619, 0.00936306162771609, 0.0479199878771224, 0.129383951582647, 0.239313043637356, 0.336224516735531, 0.375, 0.336224516735531, 0.239313043637356, 0.129383951582647, 0.0479199878771225, 0.00936306162771607, 0.000369351583105614, 1.96286116031199e-06, 0.000268228309817232, 0.00351853579019529, 0.0187837648739302, 0.0607449264039438, 0.140185586389945, 0.25, 0.358404022569804, 0.419025267680675, 0.396091625803099, 0.29006071149665, 0.145260867263323, 0.0308892831661541, 3.91174436927983e-09, 2.88152645929552e-06, 9.68809779749204e-05, 0.00102262438228394, 0.00578209093997213, 0.0219183882197575, 0.0625, 0.143267486084963, 0.275134671338053, 0.45471803335804, 0.658403883858058, 0.845104961272685, 0.968739398477836, 

0.972848530221262, 0.864370492814952, 0.696667601066622, 0.506572883344894, 0.329469809434844, 0.189237493810458, 0.0942161184643902, 0.0395578262389152, 0.0134332716421843, 0.00345108912496521, 0.000597628029965846, 5.57239314531811e-05, 1.63940231404558e-06, 2.21214786148312e-09, 0.0268718427671117, 0.128308765621495, 0.263535811418169, 0.375533932253762, 0.421609854832061, 0.390715671858488, 0.303362574985478, 0.19656926202174, 0.104099378339254, 0.0431500227355117, 0.0128986332602489, 0.00235693554897638, 0.000176705119622931, 1.28139171657249e-06, 0.00027834340776159, 0.00714239704161622, 0.0373839280347797, 0.104396923111129, 0.202319223872617, 0.302514184349616, 0.366294218289476, 0.366294218289476, 0.302514184349616, 0.202319223872617, 0.104396923111129, 0.0373839280347797, 0.0071423970416162, 0.00027834340776159, 1.28139171657249e-06, 0.000176705119622932, 0.00235693554897638, 0.0128986332602489, 0.0431500227355117, 0.104099378339254, 0.19656926202174, 0.303362574985478, 0.390715671858488, 0.421609854832061, 0.375533932253762, 0.263535811418169, 0.128308765621494, 0.0268718427671117, 2.21214786148312e-09, 1.63940231404559e-06, 5.57239314531811e-05, 0.000597628029965845, 0.00345108912496521, 0.0134332716421843, 0.0395578262389152, 0.0942161184643902, 0.189237493810458, 0.329469809434844, 0.506572883344894, 0.696667601066622, 0.864370492814952, 0.972848530221262, 

0.976200441158322, 0.880326290422158, 0.729259455604646, 0.552649697612692, 0.380674675588307, 0.236112896100805, 0.130116619082459, 0.0625, 0.025447497834447, 0.00842047525048224, 0.0021174924266149, 0.000360483259542264, 3.31811750977195e-05, 9.67580749819504e-07, 1.29923523932817e-09, 0.0235850167429701, 0.114015671706972, 0.239576647632575, 0.353279729526074, 0.415844486256976, 0.410425110129251, 0.346115334104785, 0.25, 0.153065388605938, 0.0775072576747713, 0.031014507363282, 0.00902269551203407, 0.00161602967081806, 0.00011953258837773, 8.60420174467677e-07, 0.000213680379297726, 0.00553753770174161, 0.029514685916863, 0.0846873940896574, 0.17034883836482, 0.26753426084469, 0.345255160372371, 0.375, 0.345255160372371, 0.26753426084469, 0.17034883836482, 0.0846873940896573, 0.029514685916863, 0.00553753770174161, 0.00021368037929773, 8.60420174467653e-07, 0.00011953258837773, 0.00161602967081806, 0.00902269551203409, 0.031014507363282, 0.0775072576747713, 0.153065388605938, 0.25, 0.346115334104785, 0.410425110129251, 0.415844486256976, 0.353279729526074, 0.239576647632575, 0.114015671706972, 0.0235850167429703, 1.29923523932812e-09, 9.67580749819504e-07, 3.31811750977194e-05, 0.000360483259542265, 0.0021174924266149, 0.00842047525048224, 0.025447497834447, 0.0625, 0.130116619082459, 0.236112896100805, 0.380674675588307, 0.552649697612692, 0.729259455604646, 0.880326290422158, 0.976200441158322, 

0.978969785690217, 0.893673397272717, 0.757152226754828, 0.593456315631769, 0.428214343373989, 0.282442536721729, 0.168614463603698, 0.0898579156271391, 0.0419228038340917, 0.0166470286032193, 0.00539291267699367, 0.00133258882534111, 0.000223704396379093, 2.03738798686383e-05, 5.89796378179132e-07, 7.88769739328845e-10, 0.0208628923757585, 0.101887202779402, 0.218130216064584, 0.330765487306574, 0.40455720555101, 0.419965307738311, 0.378063971082177, 0.297057024660599, 0.202902228571419, 0.118791739524615, 0.0580310005133277, 0.0225682258430177, 0.00642189306734854, 0.0011315170388394, 8.27715856135834e-05, 5.92195351449487e-07, 0.000166728949904058, 0.00435603856588915, 0.0235656662618796, 0.069132599597929, 0.143327636406642, 0.234168242349638, 0.317882797186291, 0.368260027306751, 0.368260027306751, 0.317882797186291, 0.234168242349638, 0.143327636406642, 0.0691325995979289, 0.0235656662618797, 0.00435603856588915, 0.000166728949904055, 5.92195351449506e-07, 8.27715856135834e-05, 0.0011315170388394, 0.00642189306734855, 0.0225682258430177, 0.0580310005133277, 0.118791739524616, 0.202902228571419, 0.297057024660599, 0.378063971082177, 0.419965307738311, 0.40455720555101, 0.330765487306574, 0.218130216064584, 0.101887202779402, 0.0208628923757583, 7.88769739328878e-10, 5.89796378179132e-07, 2.03738798686382e-05, 0.000223704396379094, 0.00133258882534111, 0.00539291267699367, 0.0166470286032193, 0.0419228038340917, 0.089857915627139, 0.168614463603698, 0.282442536721729, 0.428214343373989, 0.593456315631769, 0.757152226754828, 0.893673397272717, 0.978969785690217, 

0.981283765069248, 0.904940768841663, 0.781146310330376, 0.629559786657607, 0.471925607363362, 0.327250544426615, 0.208352828197386, 0.120552174142795, 0.0625, 0.0284671335350765, 0.011072312449724, 0.00352451527349441, 0.000858329373663579, 0.000142421134654031, 1.28569940301258e-05, 3.69938913539379e-07, 4.93080516932981e-10, 0.0185838380551658, 0.0915287668403439, 0.199018817372829, 0.308838430219542, 0.389833038251081, 0.421691768760169, 0.400146593900373, 0.336145430098749, 0.25, 0.163347148322491, 0.0922440984879453, 0.0437627528934554, 0.0166252757970957, 0.00464515347184419, 0.000807416591548383, 5.85211083071584e-05, 4.16578667723622e-07, 0.000131979803837472, 0.0034715732707722, 0.0190145987112168, 0.0568142085163538, 0.120757749214798, 0.203770418646267, 0.288184166964572, 0.351488113900887, 0.375, 0.351488113900887, 0.288184166964572, 0.203770418646266, 0.120757749214798, 0.0568142085163538, 0.0190145987112168, 0.00347157327077219, 0.000131979803837475, 4.16578667723608e-07, 5.85211083071588e-05, 0.000807416591548383, 0.0046451534718442, 0.0166252757970957, 0.0437627528934555, 0.0922440984879453, 0.163347148322491, 0.25, 0.336145430098749, 0.400146593900373, 0.421691768760169, 0.389833038251081, 0.308838430219541, 0.199018817372829, 0.0915287668403437, 0.018583838055166, 4.93080516932958e-10, 3.69938913539382e-07, 1.28569940301258e-05, 0.000142421134654031, 0.00085832937366358, 0.00352451527349441, 0.011072312449724, 0.0284671335350765, 0.0625, 0.120552174142795, 0.208352828197386, 0.327250544426615, 0.471925607363362, 0.629559786657607, 0.781146310330376, 0.904940768841663, 0.981283765069248, 

0.983236756679994, 0.914532317018973, 0.801895219265578, 0.661518531045338, 0.511870509606053, 0.369933102779203, 0.248263361905588, 0.153510986037566, 0.086544347783499, 0.0438522106105466, 0.0195772019850231, 0.00748383718790605, 0.00234744419560889, 0.000564738145279569, 9.27934517993002e-05, 8.31490414763463e-06, 2.38027731473621e-07, 3.16362995197385e-10, 0.016657122903031, 0.0826258943481487, 0.182017238592954, 0.287969064000248, 0.373157224403275, 0.417639153522556, 0.413785767007172, 0.366946071633453, 0.292069963335031, 0.207904211597465, 0.131041188355527, 0.0718424935168508, 0.0332688085418495, 0.0123946812041168, 0.0034106212422788, 0.000586114320703499, 4.21531878347225e-05, 2.98788430287531e-07, 0.000105821312182055, 0.00279939741731256, 0.0154931129166166, 0.0470089902603361, 0.102012846641275, 0.176811490960782, 0.258624540382482, 0.328924551988431, 0.369629266673458, 0.369629266673458, 0.328924551988431, 0.258624540382483, 0.176811490960782, 0.102012846641275, 0.0470089902603361, 0.0154931129166166, 0.00279939741731256, 0.000105821312182055, 2.98788430287531e-07, 4.21531878347225e-05, 0.000586114320703499, 0.0034106212422788, 0.0123946812041168, 0.0332688085418495, 0.0718424935168508, 0.131041188355527, 0.207904211597465, 0.292069963335031, 0.366946071633453, 0.413785767007172, 0.417639153522556, 0.373157224403275, 0.287969064000248, 0.182017238592954, 0.0826258943481487, 0.016657122903031, 3.16362995197385e-10, 2.38027731473621e-07, 8.31490414763463e-06, 9.27934517993e-05, 0.000564738145279569, 0.00234744419560889, 0.00748383718790605, 0.0195772019850231, 0.0438522106105466, 0.086544347783499, 0.153510986037566, 0.248263361905588, 0.369933102779203, 0.511870509606053, 0.661518531045338, 0.801895219265578, 0.914532317018973, 0.983236756679994, 

0.984899953029972, 0.922760044669914, 0.819931333641154, 0.689850145839167, 0.54823828179355, 0.410158677501314, 0.287555336838789, 0.18777944524375, 0.113304977054721, 0.0625, 0.031063851348551, 0.0136355031922754, 0.00513674983591187, 0.00159129295063405, 0.000378885000564069, 6.17406716507828e-05, 5.49759347614354e-06, 1.56695472160065e-07, 2.07763543136105e-10, 0.0150140001072802, 0.0749274045688941, 0.166892284449326, 0.268391587469536, 0.355560790246075, 0.409459973633892, 0.420506941637598, 0.389909505118779, 0.327952205974863, 0.25, 0.171717166106752, 0.105069189294469, 0.0562026328914296, 0.0255041334118897, 0.00934722916158829, 0.00253908473028187, 0.00043214931504685, 3.08762481171056e-05, 2.18064529014483e-07, 8.58285904552746e-05, 0.00228151781760297, 0.0127387350009962, 0.0391574412893644, 0.086474813798223, 0.153285922502271, 0.230598338796272, 0.303606357150727, 0.355961799515113, 0.375, 0.355961799515113, 0.303606357150727, 0.230598338796272, 0.153285922502271, 0.0864748137982231, 0.0391574412893644, 0.0127387350009962, 0.00228151781760297, 8.58285904552746e-05, 2.18064529014483e-07, 3.08762481171056e-05, 0.00043214931504685, 0.00253908473028187, 0.00934722916158828, 0.0255041334118897, 0.0562026328914296, 0.105069189294469, 0.171717166106752, 0.25, 0.327952205974863, 0.389909505118779, 0.420506941637598, 0.409459973633892, 0.355560790246075, 0.268391587469536, 0.166892284449326, 0.0749274045688941, 0.0150140001072802, 2.07763543136105e-10, 1.56695472160065e-07, 5.49759347614354e-06, 6.17406716507828e-05, 0.000378885000564068, 0.00159129295063405, 0.00513674983591187, 0.0136355031922754, 0.031063851348551, 0.0625, 0.113304977054721, 0.18777944524375, 0.287555336838789, 0.410158677501314, 0.54823828179355, 0.689850145839167, 0.819931333641154, 0.922760044669914, 0.984899953029972, 

0.986327860512721, 0.929867610279814, 0.835688738066185, 0.715018742748247, 0.581282398963667, 0.447785693854471, 0.325675404904635, 0.222564200929315, 0.14202686949942, 0.0839419301967926, 0.0454545881743675, 0.022224450720858, 0.009615962825226, 0.00357756774757447, 0.00109655228334194, 0.000258787560779739, 4.18717339254218e-05, 3.70831623841347e-06, 1.05303823435337e-07, 1.39335296338273e-10, 0.0136016392866203, 0.0682318060044914, 0.153421983867068, 0.250194810443689, 0.337742893909035, 0.398446474028381, 0.421740860012686, 0.405881884216716, 0.357310382893013, 0.288030605023946, 0.211952246801801, 0.141343518166847, 0.0843661829940535, 0.0442025304251537, 0.0197173957176091, 0.00712630379450791, 0.00191460882789382, 0.000323186864309116, 2.29614006452529e-05, 1.61663201718834e-07, 7.03383981216812e-05, 0.0018775170112255, 0.0105623828861997, 0.032829966246245, 0.0735896157720102, 0.132953884116197, 0.20480363690995, 0.27757176903469, 0.337094778719863, 0.370620629803093, 0.370620629803093, 0.337094778719863, 0.27757176903469, 0.20480363690995, 0.132953884116197, 0.0735896157720102, 0.0328299662462451, 0.0105623828861997, 0.00187751701122551, 7.03383981216835e-05, 1.61663201718826e-07, 2.29614006452527e-05, 0.000323186864309116, 0.00191460882789381, 0.00712630379450791, 0.0197173957176091, 0.0442025304251537, 0.0843661829940535, 0.141343518166847, 0.211952246801801, 0.288030605023946, 0.357310382893013, 0.405881884216716, 0.421740860012686, 0.39844647402838, 0.337742893909035, 0.250194810443689, 0.153421983867068, 0.0682318060044916, 0.0136016392866205, 1.39335296338264e-10, 1.05303823435335e-07, 3.70831623841347e-06, 4.18717339254217e-05, 0.000258787560779739, 0.00109655228334194, 0.00357756774757447, 0.009615962825226, 0.022224450720858, 0.0454545881743675, 0.0839419301967926, 0.14202686949942, 0.222564200929315, 0.325675404904635, 0.447785693854471, 0.581282398963667, 0.715018742748247, 0.835688738066185, 0.929867610279814, 0.986327860512721, 

0.987562772450777, 0.936047268900731, 0.849522342638768, 0.737432567578805, 0.61128156665979, 0.482799774140933, 0.362259838915235, 0.257239280713978, 0.172017336987515, 0.107635167802709, 0.0625, 0.0333121399975574, 0.0160600902387191, 0.00686337664521125, 0.00252621004716946, 0.000767242573778011, 0.000179694363577921, 2.88968142309429e-05, 2.54730889060784e-06, 7.21030052167969e-08, 9.5235016487511e-11, 0.0123789180919274, 0.0623765956255645, 0.141403935981224, 0.23338031305211, 0.320165535332481, 0.385583515299763, 0.418738119252704, 0.415860253893511, 0.380343634000019, 0.321126590835349, 0.25, 0.178648938123861, 0.11621549389281, 0.0679278216161664, 0.0349677052143945, 0.0153709700392499, 0.00548935297354984, 0.00146092541462408, 0.000244858340176451, 1.73120884038902e-05, 1.21562231811695e-07, 5.81877998295614e-05, 0.00155875128229548, 0.00882631573094091, 0.0276972971402299, 0.062883850670601, 0.115478497946276, 0.181508126570497, 0.252109267131133, 0.315363444880936, 0.359277163240525, 0.375, 0.359277163240525, 0.315363444880936, 0.252109267131133, 0.181508126570497, 0.115478497946276, 0.062883850670601, 0.0276972971402299, 0.00882631573094088, 0.00155875128229549, 5.81877998295593e-05, 1.21562231811701e-07, 1.731208840389e-05, 0.000244858340176453, 0.00146092541462408, 0.00548935297354984, 0.0153709700392499, 0.0349677052143945, 0.0679278216161664, 0.11621549389281, 0.178648938123861, 0.25, 0.321126590835349, 0.380343634000019, 0.415860253893511, 0.418738119252704, 0.385583515299763, 0.320165535332481, 0.23338031305211, 0.141403935981224, 0.0623765956255647, 0.0123789180919271, 9.52350164875178e-11, 7.2103005216796e-08, 2.54730889060786e-06, 2.88968142309429e-05, 0.000179694363577921, 0.000767242573778011, 0.00252621004716946, 0.00686337664521124, 0.0160600902387191, 0.0333121399975574, 0.0625, 0.107635167802709, 0.172017336987515, 0.257239280713978, 0.362259838915235, 0.482799774140933, 0.61128156665979, 0.737432567578805, 0.849522342638768, 0.936047268900731, 0.987562772450777, 

0.988637905802623, 0.941452188081014, 0.86172343892003, 0.757446708889307, 0.638516433448405, 0.515268095317059, 0.397089668671067, 0.291331837909333, 0.202678182342491, 0.1330292148741, 0.0818449294572894, 0.046805702009658, 0.024608597203009, 0.0117206857513232, 0.00495556959667556, 0.0018071093846198, 0.000544499267745842, 0.000126684635966719, 2.0264097123248e-05, 1.77909788674101e-06, 5.0217873197012e-08, 6.62260463567833e-11, 0.0113134520877266, 0.0572299375655949, 0.130657962584692, 0.217899316563263, 0.303123800672948, 0.371607316060555, 0.412546153859739, 0.420847108640458, 0.397560746527003, 0.348973120337425, 0.28469413230294, 0.215294040558759, 0.150093502303166, 0.0956040979251705, 0.0548879692922594, 0.0278304654188107, 0.0120799817858145, 0.00426968633940849, 0.00112705070702954, 0.000187737854631747, 1.32176210181362e-05, 9.25957230695827e-08, 4.85494477009912e-05, 0.00130460651449993, 0.00742908154275892, 0.0235066597432777, 0.0539633949032718, 0.100500107568826, 0.160726602665763, 0.227977514561274, 0.292436287454013, 0.3432955652823, 0.371361195671353, 0.371361195671353, 0.3432955652823, 0.292436287454013, 0.227977514561274, 0.160726602665763, 0.100500107568826, 0.0539633949032717, 0.0235066597432776, 0.00742908154275894, 0.00130460651449993, 4.85494477009912e-05, 9.25957230695827e-08, 1.32176210181362e-05, 0.000187737854631746, 0.00112705070702955, 0.0042696863394085, 0.0120799817858145, 0.0278304654188107, 0.0548879692922594, 0.0956040979251705, 0.150093502303166, 0.215294040558759, 0.28469413230294, 0.348973120337425, 0.397560746527003, 0.420847108640458, 0.412546153859739, 0.371607316060555, 0.303123800672948, 0.217899316563263, 0.130657962584692, 0.0572299375655949, 0.0113134520877266, 6.62260463567833e-11, 5.0217873197012e-08, 1.779097886741e-06, 2.02640971232481e-05, 0.00012668463596672, 0.000544499267745842, 0.0018071093846198, 0.00495556959667556, 0.0117206857513232, 0.024608597203009, 0.046805702009658, 0.0818449294572894, 0.1330292148741, 0.202678182342491, 0.291331837909333, 0.397089668671067, 0.515268095317059, 0.638516433448405, 0.757446708889307, 0.86172343892003, 0.941452188081014, 0.988637905802623, 

0.98957963827132, 0.946205501457184, 0.872532171803549, 0.775368044619359, 0.663256376374474, 0.54530725093309, 0.430052703731969, 0.32449961623871, 0.23351533465836, 0.159608044320656, 0.103084504877029, 0.0625, 0.0352729466130383, 0.0183261399127774, 0.0086365807879836, 0.00361768567491482, 0.00130856997137965, 0.000391559290537087, 9.0575838730981e-05, 1.44209705381375e-05, 1.26162047339539e-06, 3.55243227738474e-08, 4.67851087792772e-11, 0.0103794649140167, 0.0526842188067965, 0.121025883074871, 0.203675850040998, 0.286796705247483, 0.357059283330152, 0.404017791812122, 0.421772577345862, 0.409620803698513, 0.371636895038103, 0.315366434887508, 0.25, 0.184475902818558, 0.125929341913169, 0.0787762353786826, 0.0445334827814369, 0.0222863078060078, 0.00956794035135772, 0.00335150308128954, 0.000878380797756304, 0.000145529788990674, 1.02082362894807e-05, 7.1367981152494e-08, 4.08253998976406e-05, 0.00110003597540698, 0.00629515371211583, 0.0200633035713485, 0.0465048394580221, 0.0876739660948632, 0.142334626678522, 0.205576637959076, 0.269451045476462, 0.324499578815295, 0.361800210803866, 0.375, 0.361800210803866, 0.324499578815295, 0.269451045476462, 0.205576637959076, 0.142334626678522, 0.0876739660948632, 0.0465048394580221, 0.0200633035713485, 0.00629515371211585, 0.00110003597540698, 4.08253998976389e-05, 7.13679811524985e-08, 1.02082362894807e-05, 0.000145529788990674, 0.000878380797756304, 0.00335150308128954, 0.00956794035135771, 0.0222863078060078, 0.0445334827814368, 0.0787762353786826, 0.125929341913169, 0.184475902818558, 0.25, 0.315366434887508, 0.371636895038103, 0.409620803698513, 0.421772577345863, 0.404017791812122, 0.357059283330152, 0.286796705247483, 0.203675850040998, 0.121025883074871, 0.0526842188067965, 0.0103794649140165, 4.67851087792812e-11, 3.55243227738474e-08, 1.26162047339538e-06, 1.44209705381375e-05, 9.0575838730981e-05, 0.000391559290537086, 0.00130856997137965, 0.00361768567491482, 0.0086365807879836, 0.0183261399127774, 0.0352729466130383, 0.0625, 0.103084504877029, 0.159608044320656, 0.23351533465836, 0.32449961623871, 0.430052703731969, 0.54530725093309, 0.663256376374474, 0.775368044619359, 0.872532171803549, 0.946205501457184, 0.98957963827132, 

0.990409128565756, 0.950407036507499, 0.882147469739109, 0.791460904496354, 0.685752603149579, 0.573061188566064, 0.461113209573105, 0.356506772687057, 0.264135305871462, 0.186912957640004, 0.125805733226994, 0.0801197185266472, 0.0479598502347719, 0.0267558553347938, 0.0137573270919201, 0.00642361342116988, 0.00266879792712466, 0.000958491844684126, 0.000285064693066289, 6.56071044979699e-05, 1.04029350436764e-05, 9.07270980692938e-07, 2.5491785265624e-08, 3.35323551868682e-11, 0.00955623853431914, 0.0486510576958959, 0.112369937918321, 0.19062114035203, 0.271283454922385, 0.342331289627009, 0.393833603894487, 0.419459227578494, 0.417229187478252, 0.389424314729441, 0.341735444714437, 0.281892815332709, 0.218098766191249, 0.157597465551605, 0.105650216433282, 0.0650655571267452, 0.0362922343206795, 0.017955735477376, 0.00763515421589551, 0.00265347506474134, 0.000691089465848724, 0.000113958849110374, 7.96778470586254e-06, 5.56047244909011e-08, 3.45772616680083e-05, 0.000933912520113709, 0.00536772622247969, 0.0172164627507237, 0.0402448597587967, 0.0766873028979659, 0.126138959210348, 0.185072967486644, 0.247146336102371, 0.304255184105354, 0.348105501172171, 0.371928849714623, 0.371928849714623, 0.348105501172171, 0.304255184105354, 0.247146336102371, 0.185072967486644, 0.126138959210348, 0.0766873028979658, 0.0402448597587967, 0.0172164627507237, 0.00536772622247967, 0.000933912520113709, 3.45772616680067e-05, 5.5604724490905e-08, 7.96778470586254e-06, 0.000113958849110374, 0.000691089465848724, 0.00265347506474134, 0.00763515421589552, 0.017955735477376, 0.0362922343206796, 0.0650655571267452, 0.105650216433282, 0.157597465551605, 0.218098766191248, 0.281892815332709, 0.341735444714437, 0.389424314729441, 0.417229187478252, 0.419459227578494, 0.393833603894487, 0.342331289627008, 0.271283454922385, 0.19062114035203, 0.112369937918321, 0.0486510576958959, 0.00955623853431892, 3.35323551868712e-11, 2.5491785265624e-08, 9.07270980692945e-07, 1.04029350436764e-05, 6.56071044979699e-05, 0.000285064693066289, 0.000958491844684126, 0.00266879792712467, 0.00642361342116988, 0.0137573270919201, 0.0267558553347938, 0.0479598502347719, 0.0801197185266472, 0.125805733226994, 0.186912957640004, 0.264135305871462, 0.356506772687057, 0.461113209573105, 0.573061188566064, 0.685752603149579, 0.791460904496354, 0.882147469739109, 0.950407036507499, 0.990409128565756, 

0.03125, 0.15625, 0.3125, 0.3125, 0.15625, 0.03125, 

0.305134098813929, 0.000421456741626533, 0.408802176801953, 0.00786448986471326, 0.219076426276337, 0.0587013515014408, 0.0587013515014408, 0.219076426276337, 0.00786448986471326, 0.408802176801953, 0.000421456741626533, 0.305134098813929, 

0.549981817580726, 0.03125, 1.81824192734013e-05, 0.349284250579334, 0.15625, 0.000715749420666245, 0.0887298334620744, 0.3125, 0.0112701665379259, 0.0112701665379259, 0.3125, 0.0887298334620744, 0.000715749420666245, 0.15625, 0.349284250579334, 1.81824192734013e-05, 0.03125, 0.549981817580726, 

0.697816017789034, 0.135002961144809, 0.00391410135255554, 1.61359115377922e-06, 0.260328342032991, 0.332484231602893, 0.0397323558976338, 0.000108131690971159, 0.0388474004253279, 0.327535820924673, 0.161330529077436, 0.00289849447052239, 0.00289849447052239, 0.161330529077436, 0.327535820924673, 0.038847400425328, 0.000108131690971159, 0.0397323558976338, 0.332484231602893, 0.260328342032991, 1.61359115377921e-06, 0.00391410135255554, 0.135002961144809, 0.697816017789034, 

0.78644687097721, 0.269335877083235, 0.03125, 0.000654414550868918, 2.27159409202062e-07, 0.193540412132003, 0.403994971973075, 0.15625, 0.0109071479388398, 2.30764216904409e-05, 0.0190517083915316, 0.242391677108931, 0.3125, 0.0727159113450503, 0.000937704918155274, 0.000937704918155271, 0.0727159113450503, 0.3125, 0.242391677108931, 0.0190517083915316, 2.30764216904408e-05, 0.0109071479388398, 0.15625, 0.403994971973075, 0.193540412132004, 2.27159409202061e-07, 0.000654414550868918, 0.03125, 0.269335877083235, 0.78644687097721, 

0.842196202236558, 0.395341042863498, 0.0911043336944349, 0.0079957584496648, 0.000139478371613415, 4.38883639124933e-08, 0.14715346931811, 0.40313351091672, 0.280009758120111, 0.0650377553651086, 0.0034195572556818, 6.27960278149708e-06, 0.0102846075414971, 0.164431829740637, 0.344244720148905, 0.211607674221776, 0.0335345808518499, 0.000359397412690162, 0.000359397412690162, 0.0335345808518499, 0.211607674221776, 0.344244720148905, 0.164431829740637, 0.0102846075414971, 6.27960278149708e-06, 0.0034195572556818, 0.0650377553651086, 0.280009758120111, 0.40313351091672, 0.14715346931811, 4.38883639124933e-08, 0.000139478371613415, 0.0079957584496648, 0.0911043336944349, 0.395341042863498, 0.842196202236558, 

0.879082114516863, 0.500617815222906, 0.171607971857582, 0.03125, 0.002313919518239, 3.60487969159972e-05, 1.06684506940694e-08, 0.11476615467671, 0.37149519410975, 0.362634919079014, 0.15625, 0.02737512403488, 0.00121446187189229, 2.04294642030569e-06, 0.00599319223620762, 0.110270689575992, 0.306522087784078, 0.3125, 0.129545977726207, 0.0163657904225438, 0.000156484955348201, 0.0001564849553482, 0.0163657904225438, 0.129545977726207, 0.3125, 0.306522087784078, 0.110270689575992, 0.00599319223620765, 2.04294642030567e-06, 0.00121446187189229, 0.02737512403488, 0.15625, 0.362634919079014, 0.37149519410975, 0.114766154676711, 1.06684506940693e-08, 3.60487969159972e-05, 0.002313919518239, 0.03125, 0.171607971857582, 0.500617815222906, 0.879082114516863, 

0.904589380529803, 0.585042404405521, 0.258200580874888, 0.0725389746531626, 0.0113450072465114, 0.000751420054528723, 1.08616284922655e-05, 3.08572560441647e-09, 0.0916226087498726, 0.331054022673763, 0.401524761354074, 0.250258069367259, 0.0822106551024868, 0.0120800205388372, 0.00047986981079041, 7.61633687107802e-07, 0.00371204995982402, 0.0749325280377545, 0.249762620105905, 0.34535421314063, 0.238293080489951, 0.077680597071767, 0.00848031344367935, 7.51960410876682e-05, 7.51960410876682e-05, 0.00848031344367935, 0.077680597071767, 0.238293080489951, 0.34535421314063, 0.249762620105905, 0.0749325280377545, 0.00371204995982402, 7.61633687107802e-07, 0.00047986981079041, 0.0120800205388372, 0.0822106551024869, 0.250258069367259, 0.401524761354074, 0.331054022673762, 0.0916226087498726, 3.08572560441647e-09, 1.08616284922655e-05, 0.000751420054528723, 0.0113450072465114, 0.0725389746531626, 0.258200580874888, 0.585042404405521, 0.904589380529803, 

0.922894997026383, 0.652003905147058, 0.341603125561172, 0.12726399238635, 0.03125, 0.00440320892649167, 0.000269972620664487, 3.70388369077998e-06, 1.02258397515478e-09, 0.0746503132089526, 0.291139833957761, 0.409309116127218, 0.324704492581161, 0.15625, 0.043144609953039, 0.00563287546020995, 0.000207369994494588, 3.16052804784654e-07, 0.00241529936998257, 0.0520011627217691, 0.196173793515064, 0.331383623994174, 0.3125, 0.169100072158785, 0.0470111167156726, 0.00464402429522616, 3.90733192927759e-05, 3.90733192927754e-05, 0.00464402429522616, 0.0470111167156726, 0.169100072158785, 0.3125, 0.331383623994174, 0.196173793515064, 0.0520011627217691, 0.00241529936998259, 3.1605280478465e-07, 0.000207369994494588, 0.00563287546020995, 0.043144609953039, 0.15625, 0.324704492581161, 0.409309116127218, 0.291139833957761, 0.0746503132089528, 1.02258397515476e-09, 3.70388369077998e-06, 0.000269972620664486, 0.00440320892649167, 0.03125, 0.12726399238635, 0.341603125561172, 0.652003905147058, 0.922894997026383, 

0.936446431116567, 0.705209218530758, 0.417477561189361, 0.189094999720692, 0.0625478905957517, 0.0139578473407194, 0.00182494812670354, 0.00010582853965376, 1.39797489669503e-06, 3.78015257903514e-10, 0.0618953782575821, 0.255108109000515, 0.398471326154006, 0.373735321836858, 0.231688153013334, 0.0942035551952969, 0.0230837537520685, 0.00277190839961517, 9.66124507259321e-05, 1.42979592796975e-07, 0.00163641516368694, 0.0369139515296794, 0.152132150350388, 0.295466492492801, 0.34328511951689, 0.254317434338008, 0.116794484070877, 0.0290412253669764, 0.00267071051342544, 2.16321045555329e-05, 2.16321045555329e-05, 0.00267071051342545, 0.0290412253669764, 0.116794484070877, 0.254317434338008, 0.34328511951689, 0.295466492492801, 0.152132150350388, 0.0369139515296794, 0.00163641516368694, 1.42979592796975e-07, 9.66124507259325e-05, 0.00277190839961517, 0.0230837537520685, 0.0942035551952969, 0.231688153013334, 0.373735321836858, 0.398471326154006, 0.255108109000515, 0.0618953782575821, 3.78015257903514e-10, 1.39797489669504e-06, 0.00010582853965376, 0.00182494812670354, 0.0139578473407194, 0.0625478905957517, 0.189094999720692, 0.417477561189361, 0.705209218530758, 0.936446431116567, 

0.946743794452276, 0.74779328026935, 0.484474947428454, 0.252799556244087, 0.103059341804127, 0.03125, 0.00649864531500619, 0.000803787754037363, 4.47142545506336e-05, 5.74167958437527e-07, 1.52853718181816e-10, 0.0520968157857863, 0.223770607808367, 0.377812447958322, 0.400146780691424, 0.296486185644472, 0.15625, 0.0564736353000043, 0.0126951657079414, 0.00143344510217874, 4.79686480354526e-05, 6.94444117960244e-08, 0.00114670018686031, 0.026784559979405, 0.117853149344396, 0.253350834117938, 0.341178419109555, 0.3125, 0.196303772826836, 0.0802038754845725, 0.0183812959120985, 0.0016030091268839, 1.26199778116212e-05, 1.2619977811621e-05, 0.0016030091268839, 0.0183812959120985, 0.0802038754845726, 0.196303772826836, 0.3125, 0.341178419109555, 0.253350834117938, 0.117853149344396, 0.0267845599794049, 0.00114670018686032, 6.9444411796023e-08, 4.79686480354526e-05, 0.00143344510217875, 0.0126951657079414, 0.0564736353000043, 0.15625, 0.296486185644472, 0.400146780691424, 0.377812447958322, 0.223770607808367, 0.0520968157857866, 1.52853718181812e-10, 5.74167958437527e-07, 4.47142545506337e-05, 0.000803787754037364, 0.00649864531500619, 0.03125, 0.103059341804127, 0.252799556244087, 0.484474947428454, 0.74779328026935, 0.946743794452276, 

0.954743810235046, 0.782201179063093, 0.542746396770247, 0.314897827762822, 0.149628053000461, 0.0563719569711638, 0.0160070375468406, 0.00315510839466618, 0.000374048480890713, 2.01561637663631e-05, 2.53251650716092e-07, 6.66162092530223e-11, 0.0444217300579791, 0.196940589839984, 0.352800457076999, 0.409346720362229, 0.345766792336634, 0.219120336643917, 0.102951196320571, 0.0341337526161048, 0.0071935994751735, 0.000775203449815615, 2.51463829714782e-05, 3.57940884802515e-08, 0.000826730723023241, 0.0198340769432118, 0.0917320967983715, 0.212849658140572, 0.319604973226236, 0.340692248491599, 0.264857224025909, 0.147711320425898, 0.0553381457783124, 0.0119256897408005, 0.000998754519088418, 7.69312324732106e-06, 7.6931232473212e-06, 0.000998754519088415, 0.0119256897408005, 0.0553381457783123, 0.147711320425898, 0.264857224025909, 0.340692248491599, 0.319604973226236, 0.212849658140572, 0.0917320967983715, 0.0198340769432118, 0.000826730723023231, 3.57940884802524e-08, 2.5146382971478e-05, 0.000775203449815614, 0.00719359947517349, 0.0341337526161048, 0.102951196320571, 0.219120336643917, 0.345766792336634, 0.40934672036223, 0.352800457076999, 0.196940589839984, 0.0444217300579788, 6.66162092530243e-11, 2.53251650716091e-07, 2.01561637663631e-05, 0.000374048480890713, 0.00315510839466618, 0.0160070375468406, 0.0563719569711638, 0.149628053000461, 0.314897827762822, 0.542746396770247, 0.782201179063093, 0.954743810235046, 

0.961078149449, 0.810285960455949, 0.593083006006198, 0.373402930858594, 0.199265288495983, 0.0881423348296147, 0.03125, 0.00843355669109067, 0.00159443253378056, 0.000182871142914133, 9.61165431070395e-06, 1.18721196463647e-07, 3.09359233218841e-11, 0.0383062451441797, 0.174095004083681, 0.3266043892593, 0.406575512497231, 0.379346914210353, 0.275625756276742, 0.15625, 0.0674241576433343, 0.0209382920309579, 0.00419876619684904, 0.000436346618321083, 1.38140263141593e-05, 1.94040422297892e-08, 0.000610717627026378, 0.0149621599909454, 0.0719430002230247, 0.177078039513285, 0.288869340780982, 0.344758543871026, 0.3125, 0.215615650688193, 0.109985731947944, 0.0385618797911274, 0.00792364623884607, 0.00064294272191476, 4.86834481632029e-06, 4.86834481632039e-06, 0.000642942721914762, 0.00792364623884606, 0.0385618797911274, 0.109985731947944, 0.215615650688193, 0.3125, 0.344758543871026, 0.288869340780982, 0.177078039513285, 0.0719430002230248, 0.0149621599909454, 0.00061071762702637, 1.94040422297897e-08, 1.38140263141593e-05, 0.000436346618321082, 0.00419876619684905, 0.0209382920309579, 0.0674241576433343, 0.15625, 0.275625756276742, 0.379346914210353, 0.406575512497231, 0.3266043892593, 0.174095004083681, 0.0383062451441794, 3.09359233218852e-11, 1.18721196463647e-07, 9.61165431070392e-06, 0.000182871142914133, 0.00159443253378056, 0.00843355669109067, 0.03125, 0.0881423348296147, 0.199265288495983, 0.373402930858594, 0.593083006006198, 0.810285960455949, 0.961078149449, 

0.966176641946492, 0.833441105376914, 0.636475978417715, 0.427368415918919, 0.249614339733664, 0.124812759375145, 0.0521983181562325, 0.0176417036768476, 0.0045732742529975, 0.000836460079688217, 9.34412626268675e-05, 4.81451103712612e-06, 5.86620086634389e-08, 1.51711216295204e-11, 0.0333594413738503, 0.15464693719019, 0.300958113244535, 0.396022337129878, 0.3992773485059, 0.322123672176564, 0.210089001540789, 0.109580612810338, 0.0442999869459339, 0.013073145226385, 0.00252093383669489, 0.000254547102080275, 7.9037015269107e-06, 1.0984883699268e-08, 0.000460724170078617, 0.0114780396733569, 0.0569233020563524, 0.146790156374649, 0.255469940068353, 0.332541835293092, 0.338228434382118, 0.272261929433675, 0.171648471956268, 0.0817287663860094, 0.0272047154772325, 0.0053832446682804, 0.000425955396003506, 3.18150952403269e-06, 3.18150952403269e-06, 0.000425955396003508, 0.0053832446682804, 0.0272047154772325, 0.0817287663860093, 0.171648471956268, 0.272261929433675, 0.338228434382118, 0.332541835293092, 0.255469940068353, 0.146790156374649, 0.0569233020563524, 0.0114780396733568, 0.000460724170078617, 1.0984883699268e-08, 7.90370152691075e-06, 0.000254547102080275, 0.00252093383669489, 0.013073145226385, 0.0442999869459338, 0.109580612810338, 0.210089001540789, 0.322123672176564, 0.3992773485059, 0.396022337129878, 0.300958113244535, 0.15464693719019, 0.0333594413738503, 1.51711216295204e-11, 5.86620086634393e-08, 4.81451103712612e-06, 9.34412626268674e-05, 0.000836460079688216, 0.0045732742529975, 0.0176417036768476, 0.0521983181562325, 0.124812759375145, 0.249614339733664, 0.427368415918919, 0.636475978417715, 0.833441105376914, 0.966176641946492, 

0.970339586555521, 0.852716349532832, 0.673911063431405, 0.476499468897082, 0.299014661083007, 0.164588556080661, 0.0781476571863817, 0.03125, 0.0101638057815719, 0.00255076679373569, 0.000454231587654232, 4.96713972356689e-05, 2.51834196726985e-06, 3.03465290072794e-08, 7.80027186169198e-12, 0.0293042730140078, 0.138049704446632, 0.276741960866203, 0.380751143578055, 0.408300072526502, 0.357621700100721, 0.259844809480385, 0.15625, 0.0764184602643757, 0.0293485422837327, 0.00831630419480335, 0.00155405931153298, 0.000153314165652248, 4.68617110406112e-06, 6.4571748373324e-09, 0.000353995829409715, 0.00893977037416649, 0.045457697349031, 0.121697036659076, 0.223011070589436, 0.310819375121687, 0.345598716301191, 0.3125, 0.229826550986094, 0.135071059619463, 0.0609036600185984, 0.0194486201570192, 0.00373344584574066, 0.000289459128736202, 2.13813608649453e-06, 2.13813608649447e-06, 0.000289459128736202, 0.00373344584574066, 0.0194486201570193, 0.0609036600185984, 0.135071059619463, 0.229826550986094, 0.3125, 0.345598716301191, 0.310819375121687, 0.223011070589436, 0.121697036659076, 0.045457697349031, 0.00893977037416649, 0.000353995829409722, 6.45717483733216e-09, 4.68617110406112e-06, 0.000153314165652248, 0.00155405931153298, 0.00831630419480335, 0.0293485422837327, 0.0764184602643757, 0.15625, 0.259844809480385, 0.357621700100721, 0.408300072526502, 0.380751143578054, 0.276741960866203, 0.138049704446632, 0.029304273014008, 7.80027186169162e-12, 3.03465290072794e-08, 2.51834196726984e-06, 4.9671397235669e-05, 0.000454231587654232, 0.00255076679373569, 0.0101638057815719, 0.03125, 0.0781476571863817, 0.164588556080661, 0.299014661083007, 0.476499468897082, 0.673911063431405, 0.852716349532832, 0.970339586555521, 

0.973781703490346, 0.868907483560764, 0.706283409595617, 0.520877916313063, 0.346398906828627, 0.205902978632174, 0.10804844763362, 0.0491977708598261, 0.0189698065111919, 0.00597958311931442, 0.00146143409524511, 0.000254606923303208, 2.73585545929656e-05, 1.36880687032184e-06, 1.63447253260345e-08, 4.18011087188279e-12, 0.0259404109993526, 0.123829568559764, 0.254344085796055, 0.362891996593532, 0.409077182726811, 0.382697790447774, 0.302830079850391, 0.203300723836565, 0.114764986614499, 0.0533372274195243, 0.0196573929087428, 0.00538990951018953, 0.000981729208930638, 9.50253649915821e-05, 2.86725826426549e-06, 3.92294814228481e-09, 0.000276408940691091, 0.00705886982897649, 0.0366373685693507, 0.101129725079372, 0.193238648423905, 0.28451768845023, 0.339499768004661, 0.336041113978369, 0.27772559819955, 0.19030489397249, 0.105762715465834, 0.0456407455871653, 0.0140912742505101, 0.00263874186711534, 0.000201194447505428, 1.47264248233915e-06, 1.47264248233919e-06, 0.000201194447505428, 0.00263874186711533, 0.0140912742505101, 0.0456407455871653, 0.105762715465834, 0.19030489397249, 0.27772559819955, 0.336041113978368, 0.339499768004661, 0.28451768845023, 0.193238648423905, 0.101129725079371, 0.0366373685693508, 0.00705886982897649, 0.000276408940691085, 3.92294814228497e-09, 2.86725826426549e-06, 9.50253649915818e-05, 0.00098172920893064, 0.00538990951018953, 0.0196573929087428, 0.0533372274195243, 0.114764986614499, 0.203300723836565, 0.302830079850391, 0.382697790447774, 0.409077182726811, 0.362891996593532, 0.254344085796055, 0.123829568559764, 0.0259404109993523, 4.18011087188301e-12, 1.63447253260345e-08, 1.36880687032183e-06, 2.73585545929657e-05, 0.000254606923303208, 0.00146143409524511, 0.00597958311931443, 0.0189698065111919, 0.0491977708598261, 0.10804844763362, 0.205902978632174, 0.346398906828627, 0.520877916313063, 0.706283409595617, 0.868907483560764, 0.973781703490346, 

0.97665969853552, 0.882622903215021, 0.734370938736272, 0.560784788110404, 0.391148734311032, 0.247514400905269, 0.140766479732878, 0.0710344151361086, 0.03125, 0.0116931002532677, 0.00359168231124755, 0.000858764822478534, 0.000146915449748258, 1.55585117355168e-05, 7.69882242787479e-07, 9.12352194387934e-09, 2.32352475190747e-12, 0.0231203326686423, 0.111589328133212, 0.233876857970521, 0.343874992736012, 0.403884365261647, 0.398680717606729, 0.337931742322539, 0.247588795033434, 0.15625, 0.0838701664090441, 0.037403150692382, 0.0133287522550794, 0.0035570696195766, 0.000634313114592569, 6.04355589366917e-05, 1.8040769579775e-06, 2.45378496090537e-09, 0.000218929800629732, 0.00564326083443507, 0.0297933274910305, 0.0843460900768311, 0.16681386510441, 0.256867986686964, 0.324503000105854, 0.345185985180005, 0.3125, 0.24062753798814, 0.155803944835099, 0.0827493777234798, 0.034449050253586, 0.0103442574504253, 0.00189767036099757, 0.000142694616851941, 1.03653909938724e-06, 1.03653909938721e-06, 0.000142694616851942, 0.00189767036099757, 0.0103442574504253, 0.034449050253586, 0.0827493777234799, 0.155803944835099, 0.24062753798814, 0.3125, 0.345185985180005, 0.324503000105854, 0.256867986686964, 0.16681386510441, 0.084346090076831, 0.0297933274910305, 0.00564326083443504, 0.000218929800629737, 2.45378496090525e-09, 1.80407695797751e-06, 6.04355589366917e-05, 0.00063431311459257, 0.00355706961957661, 0.0133287522550794, 0.037403150692382, 0.0838701664090441, 0.15625, 0.247588795033434, 0.337931742322539, 0.398680717606729, 0.403884365261647, 0.343874992736011, 0.233876857970521, 0.111589328133212, 0.0231203326686426, 2.32352475190734e-12, 9.12352194387944e-09, 7.69882242787479e-07, 1.55585117355169e-05, 0.000146915449748259, 0.000858764822478534, 0.00359168231124755, 0.0116931002532677, 0.03125, 0.0710344151361086, 0.140766479732878, 0.247514400905269, 0.391148734311032, 0.560784788110404, 0.734370938736272, 0.882622903215021, 0.97665969853552, 

0.979090038457521, 0.894332104141364, 0.758834434927316, 0.596592127449347, 0.43296235441263, 0.288505431581841, 0.175243044759442, 0.0960891444563751, 0.0469405729977668, 0.0200673194420643, 0.0073229872337077, 0.00220117926679346, 0.000516706703666593, 8.70580437338779e-05, 9.10744721401243e-06, 4.465000983826e-07, 5.25756253449221e-09, 1.33423429116988e-12, 0.0207335911123645, 0.101001064388041, 0.215303921691312, 0.324632017979952, 0.394540775967116, 0.407138355986811, 0.365101585730731, 0.287109207905955, 0.198018873928661, 0.118924455842412, 0.0612710737565772, 0.0264132896055629, 0.00915368745971148, 0.00238840050772845, 0.000418430022926439, 3.93420202462602e-05, 1.16385084469564e-06, 1.57514380453108e-09, 0.000175625032848649, 0.00456260709429019, 0.0244352530997614, 0.070658624040716, 0.143811509073956, 0.229821171832769, 0.30426124605647, 0.343146763271722, 0.334137160480256, 0.28191161730884, 0.205060823375663, 0.126779654581001, 0.0648646464352009, 0.0262099019948352, 0.00768969305984413, 0.00138660176126623, 0.000103055267897415, 7.43820788109766e-07, 7.43820788109766e-07, 0.000103055267897415, 0.00138660176126623, 0.00768969305984412, 0.0262099019948352, 0.0648646464352009, 0.126779654581001, 0.205060823375663, 0.28191161730884, 0.334137160480256, 0.343146763271722, 0.30426124605647, 0.229821171832769, 0.143811509073956, 0.0706586240407161, 0.0244352530997614, 0.00456260709429019, 0.000175625032848649, 1.57514380453108e-09, 1.16385084469564e-06, 3.93420202462602e-05, 0.000418430022926438, 0.00238840050772845, 0.00915368745971148, 0.0264132896055629, 0.0612710737565772, 0.118924455842412, 0.198018873928661, 0.287109207905955, 0.365101585730731, 0.407138355986811, 0.394540775967116, 0.324632017979952, 0.215303921691312, 0.101001064388041, 0.0207335911123645, 1.33423429116988e-12, 5.25756253449221e-09, 4.465000983826e-07, 9.1074472140124e-06, 8.70580437338779e-05, 0.000516706703666593, 0.00220117926679346, 0.0073229872337077, 0.0200673194420643, 0.0469405729977668, 0.0960891444563751, 0.175243044759442, 0.288505431581841, 0.43296235441263, 0.596592127449347, 0.758834434927316, 0.894332104141364, 0.979090038457521, 

0.98116070345907, 0.904400881013132, 0.780228579088967, 0.628699985817667, 0.47174977004354, 0.328238772720487, 0.2105725664303, 0.123611838159504, 0.0657372048597563, 0.03125, 0.013041247108964, 0.00465949619833076, 0.00137518307818972, 0.000317824720394769, 5.2860865028868e-05, 5.47285808961825e-06, 2.66204736245096e-07, 3.11760119467715e-09, 7.88790513321357e-13, 0.0186962478545084, 0.0917958182839067, 0.198513772760937, 0.305750800107497, 0.38244255875005, 0.409599523904138, 0.384913852042446, 0.320838035421231, 0.237838860974822, 0.15625, 0.0901130211979348, 0.0448800349697231, 0.0188078337886107, 0.00636734115119639, 0.001630120677676, 0.000281339067805823, 2.61569436994922e-05, 7.67889354826942e-07, 1.03487376311392e-09, 0.000142504559183781, 0.00372687485442184, 0.0202031656014422, 0.0594773684588477, 0.124016858115086, 0.204450886276453, 0.281439650009101, 0.333097691954486, 0.344202792987512, 0.3125, 0.249066872871011, 0.172912903296725, 0.102890914651352, 0.0510256512273314, 0.0201078315486187, 0.00578503369009302, 0.00102805940021814, 7.56548415831101e-05, 5.43091575009979e-07, 5.43091575009979e-07, 7.56548415831101e-05, 0.00102805940021814, 0.00578503369009303, 0.0201078315486187, 0.0510256512273314, 0.102890914651352, 0.172912903296725, 0.24906687287101, 0.3125, 0.344202792987512, 0.333097691954486, 0.281439650009101, 0.204450886276453, 0.124016858115086, 0.0594773684588477, 0.0202031656014422, 0.00372687485442184, 0.000142504559183781, 1.03487376311392e-09, 7.67889354826942e-07, 2.61569436994922e-05, 0.000281339067805823, 0.001630120677676, 0.0063673411511964, 0.0188078337886107, 0.0448800349697231, 0.0901130211979348, 0.15625, 0.237838860974822, 0.320838035421231, 0.384913852042446, 0.409599523904138, 0.38244255875005, 0.305750800107497, 0.198513772760937, 0.0917958182839066, 0.0186962478545084, 7.88790513321357e-13, 3.11760119467715e-09, 2.66204736245096e-07, 5.47285808961825e-06, 5.28608650288679e-05, 0.000317824720394769, 0.00137518307818972, 0.00465949619833076, 0.013041247108964, 0.03125, 0.0657372048597563, 0.123611838159504, 0.2105725664303, 0.328238772720487, 0.47174977004354, 0.628699985817667, 0.780228579088967, 0.904400881013132, 0.98116070345907, 

0.982939133480475, 0.913116941337277, 0.799016388116032, 0.657501552479643, 0.507555999986976, 0.366300716303642, 0.246026111308694, 0.152868898973341, 0.0871892904266643, 0.045182857045992, 0.0209880533359137, 0.00858101764862591, 0.00301120948428896, 0.000874953219047563, 0.000199543083706618, 3.28230735874121e-05, 3.36822567448809e-06, 1.62731247444625e-07, 1.89694690432101e-09, 4.78714334401927e-13, 0.0169436351612265, 0.0837533447126836, 0.183361749750767, 0.287585951343019, 0.368631994883458, 0.407424887754146, 0.398246467979707, 0.348476509779869, 0.274187895363778, 0.193795365754003, 0.122332674192269, 0.0682171653611605, 0.0330237667046852, 0.0135130726426345, 0.00448504599817663, 0.00112982243596163, 0.000192517541254668, 1.77279249548442e-05, 5.17034382655079e-07, 6.94282910019355e-10, 0.000116827894097658, 0.00307282558586135, 0.0168314601661363, 0.0503151234231832, 0.10709324500567, 0.181266409562659, 0.257859214072302, 0.317751690982053, 0.344900166504976, 0.332485781051858, 0.285215268619964, 0.216924464694795, 0.144867924075763, 0.0834801807776153, 0.0403233972976695, 0.0155561146143465, 0.00440148698722521, 0.000772511310863102, 5.63694328478221e-05, 4.02769438477047e-07, 4.02769438477027e-07, 5.63694328478216e-05, 0.000772511310863102, 0.0044014869872252, 0.0155561146143465, 0.0403233972976695, 0.0834801807776153, 0.144867924075763, 0.216924464694795, 0.285215268619964, 0.332485781051858, 0.344900166504976, 0.317751690982053, 0.257859214072302, 0.181266409562659, 0.10709324500567, 0.0503151234231833, 0.0168314601661363, 0.00307282558586137, 0.000116827894097662, 6.9428291001931e-10, 5.17034382655072e-07, 1.77279249548442e-05, 0.000192517541254668, 0.00112982243596163, 0.00448504599817663, 0.0135130726426345, 0.0330237667046852, 0.0682171653611605, 0.122332674192269, 0.193795365754003, 0.274187895363778, 0.348476509779869, 0.398246467979706, 0.407424887754146, 0.368631994883458, 0.28758595134302, 0.183361749750767, 0.0837533447126838, 0.0169436351612268, 4.78714334401888e-13, 1.89694690432098e-09, 1.62731247444625e-07, 3.36822567448808e-06, 3.28230735874121e-05, 0.000199543083706618, 0.000874953219047563, 0.00301120948428896, 0.00858101764862591, 0.0209880533359137, 0.045182857045992, 0.0871892904266643, 0.152868898973341, 0.246026111308694, 0.366300716303642, 0.507555999986976, 0.657501552479643, 0.799016388116032, 0.913116941337277, 0.982939133480475, 

0.984477710598813, 0.920708654774105, 0.815583642223294, 0.683365252300584, 0.540507375708598, 0.402447119064048, 0.281044594773174, 0.183198371246392, 0.110780998449751, 0.0616513712004949, 0.03125, 0.0142315815667228, 0.00571722095009891, 0.00197547842390004, 0.000566352500871622, 0.000127692640289202, 2.08050166966591e-05, 2.11866580654319e-06, 1.01765838242085e-07, 1.18152171491229e-09, 2.97506066989199e-13, 0.0154253092598201, 0.0766930706331301, 0.169693502077372, 0.270336576391104, 0.353870954755965, 0.401763275384426, 0.406076220710303, 0.37020454733793, 0.306181692688822, 0.229918983011068, 0.15625, 0.0954027921541729, 0.0517143464431009, 0.024439491106556, 0.0097992877314892, 0.00319774966744404, 0.00079444673440631, 0.000133890742121998, 1.22277152618288e-05, 3.54607417509423e-07, 4.74687552102609e-10, 9.66767101781773e-05, 0.0025553477976511, 0.0141228357983174, 0.042777629848067, 0.092671928819273, 0.160432237480556, 0.234692856711154, 0.299241540057918, 0.338495699622404, 0.342978511066235, 0.3125, 0.255816761001306, 0.187110041845823, 0.120940571827304, 0.0678206875730078, 0.0320319257632366, 0.012134488965062, 0.0033845320523162, 0.000587690419917471, 4.25710061747066e-05, 3.02956204425031e-07, 3.02956204425048e-07, 4.25710061747062e-05, 0.000587690419917474, 0.0033845320523162, 0.012134488965062, 0.0320319257632366, 0.0678206875730078, 0.120940571827304, 0.187110041845823, 0.255816761001306, 0.3125, 0.342978511066235, 0.338495699622404, 0.299241540057918, 0.234692856711154, 0.160432237480556, 0.092671928819273, 0.042777629848067, 0.0141228357983173, 0.00255534779765112, 9.66767101781738e-05, 4.74687552102643e-10, 3.54607417509418e-07, 1.22277152618289e-05, 0.000133890742121998, 0.00079444673440631, 0.00319774966744404, 0.0097992877314892, 0.024439491106556, 0.0517143464431009, 0.0954027921541729, 0.15625, 0.229918983011068, 0.306181692688822, 0.37020454733793, 0.406076220710303, 0.401763275384426, 0.353870954755965, 0.270336576391104, 0.169693502077372, 0.0766930706331304, 0.0154253092598198, 2.97506066989225e-13, 1.18152171491227e-09, 1.01765838242086e-07, 2.11866580654319e-06, 2.08050166966591e-05, 0.000127692640289202, 0.000566352500871622, 0.00197547842390004, 0.00571722095009891, 0.0142315815667228, 0.03125, 0.0616513712004949, 0.110780998449751, 0.183198371246392, 0.281044594773174, 0.402447119064048, 0.540507375708598, 0.683365252300584, 0.815583642223294, 0.920708654774105, 0.984477710598813, 

0.985817611272415, 0.927358883169568, 0.830251908189687, 0.706626798199257, 0.570775205306482, 0.436557612320609, 0.31521780089868, 0.214035068411745, 0.135990556499343, 0.0803403621199148, 0.0437763676812723, 0.0217707531821425, 0.00974672184409651, 0.00385648172376317, 0.0013148220379631, 0.000372589448330347, 8.31757307409397e-05, 1.34401753463899e-05, 1.35959347889707e-06, 6.49755261212705e-08, 7.51749061641046e-10, 1.88923523163654e-13, 0.0141014726510423, 0.070466524557229, 0.157357653651719, 0.254099553450246, 0.338706140709618, 0.393552414982249, 0.409359338861938, 0.38648384748794, 0.33343812921574, 0.263444263770927, 0.190342808880085, 0.125174744137578, 0.0743093767945626, 0.0393210201378001, 0.0182037377935623, 0.00717259968144727, 0.00230661768502451, 0.000566222303101648, 9.45225182217549e-05, 8.57061180309869e-06, 2.47330620676855e-07, 3.30185614168098e-10, 8.0684917231873e-05, 0.00214179479952924, 0.0119295991582917, 0.0365491845076658, 0.080397220263135, 0.141913460186889, 0.212646706925472, 0.279150076625265, 0.327025607886028, 0.34554427330171, 0.331049712997181, 0.287885613121742, 0.226615002168789, 0.160368204537326, 0.100812447643524, 0.0552309641841323, 0.0255867190944873, 0.00954177124231793, 0.00262858173113035, 0.000452203412973169, 3.25493913039868e-05, 2.30828936445621e-07, 2.30828936445621e-07, 3.25493913039868e-05, 0.000452203412973167, 0.00262858173113036, 0.00954177124231795, 0.0255867190944873, 0.0552309641841323, 0.100812447643524, 0.160368204537326, 0.226615002168789, 0.287885613121742, 0.331049712997181, 0.34554427330171, 0.327025607886028, 0.279150076625265, 0.212646706925472, 0.141913460186889, 0.080397220263135, 0.0365491845076657, 0.0119295991582917, 0.00214179479952924, 8.0684917231873e-05, 3.30185614168098e-10, 2.47330620676855e-07, 8.57061180309864e-06, 9.45225182217552e-05, 0.000566222303101649, 0.00230661768502451, 0.00717259968144727, 0.0182037377935623, 0.0393210201378001, 0.0743093767945626, 0.125174744137578, 0.190342808880085, 0.263444263770927, 0.33343812921574, 0.38648384748794, 0.409359338861938, 0.393552414982249, 0.338706140709617, 0.254099553450246, 0.157357653651719, 0.070466524557229, 0.0141014726510423, 1.88923523163654e-13, 7.51749061641046e-10, 6.497552612127e-08, 1.35959347889707e-06, 1.344017534639e-05, 8.31757307409397e-05, 0.000372589448330347, 0.0013148220379631, 0.00385648172376317, 0.0097467218440965, 0.0217707531821425, 0.0437763676812723, 0.0803403621199148, 0.135990556499343, 0.214035068411745, 0.31521780089868, 0.436557612320609, 0.570775205306482, 0.706626798199257, 0.830251908189687, 0.927358883169568, 0.985817611272415, 

0.986991558480799, 0.933215269062265, 0.843289730210885, 0.727586903133462, 0.598551870509014, 0.4685992516072, 0.348258803031577, 0.244916325136397, 0.162328306085754, 0.100883111897818, 0.058410609315661, 0.03125, 0.0152862928818678, 0.00674277623367906, 0.00263285717070057, 0.000887234738581694, 0.000248883546992533, 5.50803785263624e-05, 8.83619833475794e-06, 8.8867530513844e-07, 4.228252458487e-08, 4.87705057509945e-10, 1.2235861556374e-13, 0.0129403989526022, 0.0649511619745965, 0.146212207963319, 0.238905707429487, 0.3235225293273, 0.383539996629448, 0.408969503501959, 0.397916455511562, 0.355935142863028, 0.293624662114185, 0.223369477806842, 0.15625, 0.0999332686558529, 0.0579168183954917, 0.0300186180864152, 0.0136522546816656, 0.00529843212193558, 0.00168239456005362, 0.000408698201981115, 6.76614761649952e-05, 6.09668974405258e-06, 1.75183088581687e-07, 2.33313750818567e-10, 6.78643798373548e-05, 0.00180822306779843, 0.0101402917605378, 0.0313782102435201, 0.0699467044641086, 0.125568215066485, 0.192105472526388, 0.258598532341532, 0.312181723520226, 0.341842913366886, 0.341677131605087, 0.3125, 0.261323219734689, 0.198989717991939, 0.136903352273876, 0.0840291975902609, 0.0451189052711483, 0.0205550617582871, 0.00756136129926161, 0.00206062904206077, 0.000351631092988581, 2.51702245465384e-05, 1.77953325379598e-07, 1.77953325379609e-07, 2.51702245465384e-05, 0.000351631092988579, 0.00206062904206077, 0.00756136129926161, 0.020555061758287, 0.0451189052711484, 0.0840291975902608, 0.136903352273876, 0.198989717991939, 0.261323219734689, 0.3125, 0.341677131605087, 0.341842913366886, 0.312181723520226, 0.258598532341532, 0.192105472526388, 0.125568215066485, 0.0699467044641086, 0.0313782102435201, 0.0101402917605378, 0.00180822306779843, 6.78643798373519e-05, 2.33313750818587e-10, 1.75183088581687e-07, 6.09668974405254e-06, 6.76614761649952e-05, 0.000408698201981115, 0.00168239456005362, 0.00529843212193559, 0.0136522546816656, 0.0300186180864152, 0.0579168183954917, 0.0999332686558529, 0.15625, 0.223369477806842, 0.293624662114185, 0.355935142863028, 0.397916455511562, 0.408969503501959, 0.383539996629448, 0.3235225293273, 0.238905707429487, 0.14621220796332, 0.0649511619745964, 0.012940398952602, 1.22358615563753e-13, 4.87705057509945e-10, 4.22825245848697e-08, 8.8867530513844e-07, 8.83619833475794e-06, 5.50803785263623e-05, 0.000248883546992534, 0.000887234738581693, 0.00263285717070057, 0.00674277623367906, 0.0152862928818678, 0.03125, 0.058410609315661, 0.100883111897818, 0.162328306085754, 0.244916325136397, 0.348258803031577, 0.4685992516072, 0.598551870509014, 0.727586903133462, 0.843289730210885, 0.933215269062265, 0.986991558480799, 

0.988025817941392, 0.938397957393713, 0.854921995854458, 0.746512069629435, 0.624035549809504, 0.498598818739284, 0.379978876760859, 0.27547661060306, 0.189357743346661, 0.122899258342423, 0.0749247912415125, 0.0426259693762454, 0.0224438456232883, 0.0108211532824601, 0.0047115909497125, 0.00181854581178343, 0.000606589117436422, 0.000168649682355491, 3.70407087815065e-05, 5.9045742578186e-06, 5.90805947271715e-07, 2.80008538690956e-08, 3.22107112265813e-10, 8.06919242480726e-14, 0.0119165531218229, 0.0600453955689333, 0.136127369423255, 0.224744174334596, 0.308585266700376, 0.372311849133901, 0.405671664061228, 0.40515081041999, 0.373887812624005, 0.320068496487904, 0.254404709927408, 0.187468745752009, 0.127580023057418, 0.0796735102616688, 0.0452286807110382, 0.0230253380469322, 0.0103110440484412, 0.00394921081164317, 0.00124011992142391, 0.000298512651200756, 4.90606454820233e-05, 4.39635063411921e-06, 1.25848390766791e-07, 1.672583163131e-10, 5.74900921520859e-05, 0.00153685310187306, 0.00867010594929178, 0.0270645022108818, 0.0610381039052094, 0.111204525799719, 0.17324068161376, 0.238346448106257, 0.29529734344762, 0.333423793847795, 0.345529191931276, 0.329794546827754, 0.290086869363285, 0.234646643355675, 0.173668179661128, 0.116613216722999, 0.0701084977048164, 0.0369909170701537, 0.016607645696891, 0.00603666235945183, 0.00162960237365776, 0.000276104421507695, 1.96677649831228e-05, 1.38677294594627e-07, 1.38677294594636e-07, 1.96677649831228e-05, 0.000276104421507697, 0.00162960237365776, 0.00603666235945183, 0.016607645696891, 0.0369909170701537, 0.0701084977048165, 0.116613216722999, 0.173668179661128, 0.234646643355675, 0.290086869363285, 0.329794546827754, 0.345529191931276, 0.333423793847795, 0.29529734344762, 0.238346448106257, 0.17324068161376, 0.111204525799719, 0.0610381039052094, 0.0270645022108818, 0.00867010594929175, 0.00153685310187306, 5.74900921520832e-05, 1.67258316313116e-10, 1.25848390766791e-07, 4.39635063411925e-06, 4.90606454820233e-05, 0.000298512651200756, 0.00124011992142391, 0.00394921081164317, 0.0103110440484412, 0.0230253380469322, 0.0452286807110382, 0.0796735102616688, 0.127580023057418, 0.187468745752009, 0.254404709927408, 0.320068496487904, 0.373887812624005, 0.405150810419989, 0.405671664061228, 0.372311849133901, 0.308585266700376, 0.224744174334596, 0.136127369423255, 0.0600453955689333, 0.0119165531218226, 8.06919242480819e-14, 3.22107112265813e-10, 2.80008538690959e-08, 5.90805947271715e-07, 5.9045742578186e-06, 3.70407087815066e-05, 0.000168649682355491, 0.000606589117436422, 0.00181854581178343, 0.0047115909497125, 0.0108211532824601, 0.0224438456232883, 0.0426259693762454, 0.0749247912415125, 0.122899258342423, 0.189357743346661, 0.27547661060306, 0.379978876760859, 0.498598818739284, 0.624035549809504, 0.746512069629435, 0.854921995854458, 0.938397957393713, 0.988025817941392, 

0.015625, 0.09375, 0.234375, 0.3125, 0.234375, 0.09375, 0.015625, 

0.240651676451543, 8.90642891983359e-05, 0.38689453417432, 0.00199435471456919, 0.259170194970061, 0.0186075828077168, 0.0925925925925925, 0.0925925925925925, 0.0186075828077168, 0.259170194970061, 0.00199435471456919, 0.38689453417432, 8.90642891983359e-05, 0.240651676451543, 

0.487997950811067, 0.015625, 2.04918893273626e-06, 0.371903200617956, 0.09375, 9.67993820439904e-05, 0.118094750193112, 0.234375, 0.00190524980688876, 0.0200000000000001, 0.3125, 0.0200000000000001, 0.00190524980688876, 0.234375, 0.118094750193112, 9.67993820439904e-05, 0.09375, 0.371903200617956, 2.04918893273626e-06, 0.015625, 0.487997950811067, 

0.649365364759566, 0.0904507043809332, 0.00129169054500841, 1.12034609596495e-07, 0.290703918176805, 0.267313540583252, 0.0157344648452828, 9.00933926509632e-06, 0.0542252306569591, 0.329168843350549, 0.0798609055796943, 0.000301871724750737, 0.00539449330804379, 0.21617985071528, 0.21617985071528, 0.0053944933080438, 0.000301871724750736, 0.0798609055796944, 0.329168843350549, 0.0542252306569591, 9.00933926509629e-06, 0.0157344648452828, 0.267313540583252, 0.290703918176806, 1.12034609596494e-07, 0.00129169054500841, 0.0904507043809332, 0.649365364759566, 

0.749554587679141, 0.207182490501477, 0.015625, 0.000151016199569706, 1.06560653839098e-08, 0.221353699788412, 0.372920319490549, 0.09375, 0.00302039010779528, 1.29902006290891e-06, 0.0272369869249785, 0.279684117192853, 0.234375, 0.0251704685470313, 6.59817149140504e-05, 0.00178743421642514, 0.111871197960726, 0.3125, 0.111871197960726, 0.00178743421642515, 6.598171491405e-05, 0.0251704685470313, 0.234375, 0.279684117192853, 0.0272369869249786, 1.29902006290891e-06, 0.00302039010779528, 0.09375, 0.372920319490549, 0.221353699788413, 1.06560653839097e-08, 0.000151016199569706, 0.015625, 0.207182490501477, 0.749554587679141, 

0.81375924289991, 0.328372125630103, 0.0564217878246265, 0.00304390853814397, 2.36269815467975e-05, 1.48190126791976e-09, 0.170621756019885, 0.401813503400374, 0.208095275218851, 0.029711099469125, 0.000695108340399703, 2.54438775867441e-07, 0.0149060179046153, 0.204866774249226, 0.319791086313206, 0.120835517422513, 0.00852090091604614, 1.82027114048226e-05, 0.000694524543507226, 0.055707960482305, 0.262101325213535, 0.262101325213535, 0.0557079604823049, 0.000694524543507226, 1.82027114048226e-05, 0.00852090091604616, 0.120835517422513, 0.319791086313206, 0.204866774249226, 0.0149060179046153, 2.54438775867441e-07, 0.000695108340399704, 0.029711099469125, 0.208095275218851, 0.401813503400373, 0.170621756019885, 1.48190126791976e-09, 2.36269815467976e-05, 0.00304390853814397, 0.0564217878246265, 0.328372125630103, 0.81375924289991, 

0.85671295250191, 0.435920768638663, 0.120627117586845, 0.015625, 0.000687413250542091, 4.65874489972301e-06, 2.71469863944772e-10, 0.134214972089717, 0.388182279505458, 0.30588512562442, 0.09375, 0.00975903760618147, 0.000188340312097645, 6.23818849807477e-08, 0.0087610338058376, 0.144029883565605, 0.323191943175992, 0.234375, 0.0577277780891864, 0.00317253483543277, 5.9728845484652e-06, 0.00030500606463178, 0.0285015343978439, 0.182121584666833, 0.3125, 0.182121584666833, 0.0285015343978439, 0.000305006064631782, 5.97288454846515e-06, 0.00317253483543277, 0.0577277780891864, 0.234375, 0.323191943175992, 0.144029883565605, 0.00876103380583764, 6.2381884980747e-08, 0.000188340312097645, 0.00975903760618147, 0.09375, 0.30588512562442, 0.388182279505458, 0.134214972089718, 2.71469863944768e-10, 4.65874489972301e-06, 0.000687413250542091, 0.015625, 0.120627117586845, 0.435920768638663, 0.85671295250191, 

0.886628693473981, 0.525563037930433, 0.196946677191932, 0.0429225677678332, 0.00463196994906852, 0.000178262231206392, 1.10426659117843e-06, 6.12673032803027e-11, 0.107764122334931, 0.356876198850528, 0.367523422097736, 0.177698441311976, 0.0402782237846574, 0.00343894693993399, 5.85441714065222e-05, 1.8146749806817e-08, 0.00545752041229134, 0.100971570894968, 0.285765728817883, 0.306528104821836, 0.145936405845817, 0.0276426942666765, 0.00129324900385492, 2.23953418680636e-06, 0.000147406036592928, 0.0152362948822188, 0.118504268454632, 0.282004286518812, 0.282004286518812, 0.118504268454632, 0.0152362948822188, 0.000147406036592928, 2.23953418680636e-06, 0.00129324900385492, 0.0276426942666765, 0.145936405845817, 0.306528104821836, 0.285765728817883, 0.100971570894968, 0.00545752041229134, 1.8146749806817e-08, 5.85441714065222e-05, 0.00343894693993399, 0.0402782237846574, 0.177698441311976, 0.367523422097736, 0.356876198850528, 0.107764122334931, 6.12673032803027e-11, 1.10426659117843e-06, 0.000178262231206392, 0.00463196994906852, 0.0429225677678332, 0.196946677191932, 0.525563037930433, 0.886628693473981, 

0.908202619193918, 0.598549725974222, 0.275566362050813, 0.0842648887968301, 0.015625, 0.00148772667905727, 5.21895637687888e-05, 3.03660853684063e-07, 1.62794144261341e-11, 0.0881542669947908, 0.320725075037017, 0.396220581062149, 0.257994621537119, 0.09375, 0.0174928934846064, 0.00130669834137419, 2.04013370225755e-05, 6.03782736437188e-09, 0.00356527213988063, 0.0716068142807417, 0.237375895726281, 0.329126923900684, 0.234375, 0.0857015961476009, 0.0136318805271944, 0.000571106640927325, 9.33063845943033e-07, 7.69025534576269e-05, 0.00852657306921589, 0.0758463927284193, 0.223931349454102, 0.3125, 0.223931349454102, 0.0758463927284194, 0.00852657306921589, 7.69025534576277e-05, 9.3306384594302e-07, 0.000571106640927325, 0.0136318805271944, 0.0857015961476009, 0.234375, 0.329126923900684, 0.237375895726281, 0.0716068142807417, 0.00356527213988066, 6.03782736437178e-09, 2.04013370225755e-05, 0.00130669834137419, 0.0174928934846064, 0.09375, 0.257994621537119, 0.396220581062149, 0.320725075037017, 0.0881542669947911, 1.62794144261337e-11, 3.03660853684063e-07, 5.21895637687887e-05, 0.00148772667905727, 0.015625, 0.0842648887968301, 0.275566362050813, 0.598549725974222, 0.908202619193918, 

0.924228861993799, 0.657629939666541, 0.350557905405777, 0.135523950826256, 0.0359298332314448, 0.00593994102213164, 0.000517012007032715, 1.69638086069414e-05, 9.43190130066706e-08, 4.93186517608961e-12, 0.0733054147366087, 0.285475673185297, 0.401517934701504, 0.321426293366619, 0.159708344185841, 0.0481074379115265, 0.00784761671802496, 0.000533188386280913, 7.82193530213016e-06, 2.23850035636455e-09, 0.00242259793122461, 0.0516351440383035, 0.19161914170826, 0.317640232094028, 0.295793598575398, 0.162342070807074, 0.049632219461143, 0.00698275423314323, 0.000270282513922471, 4.23342527500015e-07, 4.26997524077325e-05, 0.00498104434162094, 0.0487721117564285, 0.167412675526897, 0.292178774266583, 0.292178774266583, 0.167412675526897, 0.0487721117564285, 0.00498104434162092, 4.26997524077325e-05, 4.23342527500015e-07, 0.000270282513922472, 0.00698275423314323, 0.049632219461143, 0.162342070807074, 0.295793598575398, 0.317640232094028, 0.19161914170826, 0.0516351440383034, 0.00242259793122461, 2.23850035636455e-09, 7.82193530213019e-06, 0.000533188386280913, 0.00784761671802496, 0.0481074379115265, 0.159708344185841, 0.321426293366619, 0.401517934701504, 0.285475673185297, 0.0733054147366087, 4.93186517608961e-12, 9.43190130066711e-08, 1.69638086069414e-05, 0.000517012007032715, 0.00593994102213164, 0.0359298332314448, 0.135523950826256, 0.350557905405777, 0.657629939666541, 0.924228861993799, 

0.936437853053716, 0.705566365777096, 0.419107650971861, 0.192013413677796, 0.0654191410221913, 0.015625, 0.00237348997369225, 0.000193272321106365, 6.03302595636996e-06, 3.24225182611974e-08, 1.6639152760913e-12, 0.061835648391359, 0.253361486953526, 0.392203778739559, 0.364716855397745, 0.225841204691613, 0.09375, 0.0247509320478836, 0.00366309259758599, 0.000232087371565582, 3.25047264105798e-06, 9.07138817434349e-10, 0.00170132637896137, 0.0379081060412853, 0.152927897026068, 0.288648203579908, 0.324855545204382, 0.234375, 0.107543575780304, 0.0289277656298593, 0.00372011687762228, 0.000135779762503713, 2.06065388344487e-07, 2.49652017721161e-05, 0.00302497857042952, 0.0318024359873673, 0.121837396795999, 0.249216111279933, 0.3125, 0.249216111279934, 0.121837396795999, 0.0318024359873673, 0.00302497857042952, 2.49652017721165e-05, 2.06065388344483e-07, 0.000135779762503713, 0.00372011687762229, 0.0289277656298594, 0.107543575780304, 0.234375, 0.324855545204382, 0.288648203579908, 0.152927897026068, 0.0379081060412853, 0.00170132637896139, 9.07138817434326e-10, 3.25047264105798e-06, 0.000232087371565582, 0.00366309259758599, 0.0247509320478836, 0.09375, 0.225841204691613, 0.364716855397745, 0.392203778739559, 0.253361486953526, 0.0618356483913593, 1.66391527609125e-12, 3.24225182611974e-08, 6.03302595636998e-06, 0.000193272321106366, 0.00237348997369225, 0.015625, 0.0654191410221913, 0.192013413677796, 0.419107650971861, 0.705566365777096, 0.936437853053716, 

0.945941375076244, 0.744701381503684, 0.480304149526492, 0.249921487886891, 0.1023329820139, 0.0317158046435623, 0.00700121083733933, 0.000997280072177191, 7.71815461449814e-05, 2.3189396905709e-06, 1.21412315496825e-08, 6.14180323756786e-13, 0.0528146109528153, 0.224998785356456, 0.374653483462532, 0.389858039255586, 0.283770425919367, 0.147936913965609, 0.0540349602570074, 0.012946969934934, 0.00178120160847439, 0.000107023344454753, 1.44666251499846e-06, 3.96012173575593e-10, 0.00122866279189889, 0.0283248061288119, 0.121767662574666, 0.253395062947723, 0.327874312211486, 0.287518725017728, 0.173766188319194, 0.0700338330109796, 0.0171277944043345, 0.00205805198830996, 7.18224926269383e-05, 1.06392235006816e-07, 1.52443901813e-05, 0.00190174571467425, 0.0211073101638544, 0.0878392323508453, 0.202044196837156, 0.298026196959559, 0.298026196959559, 0.202044196837156, 0.0878392323508454, 0.0211073101638545, 0.00190174571467425, 1.52443901812997e-05, 1.06392235006818e-07, 7.1822492626938e-05, 0.00205805198830996, 0.0171277944043345, 0.0700338330109795, 0.173766188319194, 0.287518725017728, 0.327874312211487, 0.253395062947724, 0.121767662574666, 0.028324806128812, 0.00122866279189887, 3.96012173575605e-10, 1.44666251499845e-06, 0.000107023344454753, 0.00178120160847439, 0.012946969934934, 0.0540349602570074, 0.147936913965609, 0.283770425919367, 0.389858039255586, 0.374653483462532, 0.224998785356456, 0.052814610952815, 6.14180323756808e-13, 1.21412315496825e-08, 2.3189396905709e-06, 7.71815461449813e-05, 0.000997280072177189, 0.00700121083733933, 0.0317158046435623, 0.1023329820139, 0.249921487886891, 0.480304149526492, 0.744701381503684, 0.945941375076244, 

0.953477489198502, 0.77690153034159, 0.534242674803509, 0.306629028420349, 0.144317162959809, 0.0542277344394006, 0.015625, 0.00324498670927488, 0.000439670550181651, 3.27019925302698e-05, 9.53581399770645e-07, 4.89140831738389e-09, 2.44655903206097e-13, 0.0456039615029865, 0.200306580686151, 0.353041987216133, 0.400643414629467, 0.329688753217045, 0.203487602341284, 0.09375, 0.0311314198908948, 0.00692857190159343, 0.000901014902303179, 5.19484374655998e-05, 6.82978728877576e-07, 1.84147604512068e-10, 0.000908831675072765, 0.0215185605356662, 0.0972081997375672, 0.218118000918025, 0.313818859588447, 0.318158262977015, 0.234375, 0.124443923202766, 0.04549344633889, 0.0103437613347892, 0.00117916876129925, 3.97346321202839e-05, 5.77517576780873e-08, 9.65968728906999e-06, 0.00123290593433581, 0.0142750674626265, 0.0633320778025359, 0.159313535444034, 0.265306070439365, 0.3125, 0.265306070439365, 0.159313535444034, 0.0633320778025359, 0.0142750674626265, 0.00123290593433581, 9.65968728906979e-06, 5.77517576780889e-08, 3.97346321202841e-05, 0.00117916876129925, 0.0103437613347892, 0.04549344633889, 0.124443923202766, 0.234375, 0.318158262977015, 0.313818859588447, 0.218118000918025, 0.0972081997375673, 0.0215185605356662, 0.000908831675072752, 1.84147604512075e-10, 6.82978728877581e-07, 5.19484374655997e-05, 0.00090101490230318, 0.00692857190159343, 0.0311314198908948, 0.09375, 0.203487602341284, 0.329688753217045, 0.400643414629467, 0.353041987216133, 0.20030658068615, 0.0456039615029862, 2.44655903206107e-13, 4.89140831738393e-09, 9.53581399770642e-07, 3.27019925302699e-05, 0.000439670550181651, 0.00324498670927488, 0.015625, 0.0542277344394006, 0.144317162959809, 0.306629028420349, 0.534242674803509, 0.77690153034159, 0.953477489198502, 

0.959550510119687, 0.803618450543985, 0.581484872387582, 0.3605478479603, 0.189113893948438, 0.082321027345887, 0.0289193023736069, 0.00786771514546783, 0.00155694293618327, 0.000202737582130415, 1.46098729033881e-05, 4.15970587898748e-07, 2.09907673726371e-09, 1.04045003277217e-13, 0.0397567909608296, 0.178935928997575, 0.329946636180797, 0.40092340775171, 0.363002674711358, 0.254950392175547, 0.139674094695753, 0.0586439311882786, 0.0180979879008854, 0.00380233498534681, 0.000472988338340877, 2.63912426953643e-05, 3.39377591557051e-07, 9.04024597574588e-11, 0.000686346719476824, 0.0166009890766319, 0.0780077492816105, 0.185758492010357, 0.290325358739303, 0.328995036090824, 0.281081767882982, 0.182132010460318, 0.0876549910855881, 0.0297135982157879, 0.00638033066423249, 0.000697663199502414, 2.28626606018395e-05, 3.27286449484103e-08, 6.31938085480084e-06, 0.000821427244537897, 0.00983627173722424, 0.045902323402155, 0.123839401817635, 0.226423622465085, 0.301681178253593, 0.301681178253593, 0.226423622465085, 0.123839401817635, 0.0459023234021551, 0.00983627173722424, 0.000821427244537893, 6.31938085480084e-06, 3.27286449484103e-08, 2.28626606018396e-05, 0.000697663199502414, 0.00638033066423248, 0.0297135982157879, 0.0876549910855881, 0.182132010460317, 0.281081767882983, 0.328995036090824, 0.290325358739303, 0.185758492010357, 0.0780077492816105, 0.0166009890766318, 0.000686346719476824, 9.04024597574588e-11, 3.39377591557054e-07, 2.63912426953643e-05, 0.000472988338340876, 0.00380233498534681, 0.0180979879008854, 0.0586439311882785, 0.139674094695753, 0.254950392175547, 0.363002674711359, 0.40092340775171, 0.329946636180797, 0.178935928997575, 0.0397567909608296, 1.04045003277217e-13, 2.09907673726373e-09, 4.15970587898748e-07, 1.46098729033881e-05, 0.000202737582130415, 0.00155694293618327, 0.00786771514546783, 0.0289193023736069, 0.082321027345887, 0.189113893948438, 0.3605478479603, 0.581484872387582, 0.803618450543985, 0.959550510119687, 

0.964513919005733, 0.825972347607508, 0.622763432033523, 0.410842066574916, 0.234871855881689, 0.114730678586702, 0.046935252136009, 0.015625, 0.00405945404289132, 0.000772689312952027, 9.74389955919345e-05, 6.8442781683579e-06, 1.91133865676399e-07, 9.51767408520104e-10, 4.68308119072925e-14, 0.0349540052987262, 0.160464011551945, 0.306885788387296, 0.393944413932996, 0.384856831207909, 0.299147264963753, 0.187274430302237, 0.09375, 0.0366261104320834, 0.010668464884702, 0.00214075555237378, 0.000256962714403866, 1.39632486095607e-05, 1.76368569592556e-07, 4.65206462987081e-11, 0.000527805795207727, 0.0129890844600336, 0.0630114116303683, 0.157392395901675, 0.262758139559731, 0.32499693789278, 0.311348352685565, 0.234375, 0.137690104712919, 0.0613744646394433, 0.0195970237034756, 0.00401977114858926, 0.000425034375432843, 1.3617591888202e-05, 1.92552228962504e-08, 4.2505985424606e-06, 0.000560761468288135, 0.00690017919090419, 0.0335375454492528, 0.0956779550992293, 0.188309499719668, 0.276066295688297, 0.3125, 0.276066295688297, 0.188309499719668, 0.0956779550992293, 0.0335375454492528, 0.0069001791909042, 0.000560761468288135, 4.25059854246072e-06, 1.92552228962497e-08, 1.3617591888202e-05, 0.000425034375432842, 0.00401977114858927, 0.0195970237034756, 0.0613744646394432, 0.137690104712919, 0.234375, 0.311348352685565, 0.32499693789278, 0.262758139559731, 0.157392395901675, 0.0630114116303684, 0.0129890844600336, 0.000527805795207737, 4.6520646298706e-11, 1.76368569592556e-07, 1.39632486095607e-05, 0.000256962714403866, 0.00214075555237378, 0.010668464884702, 0.0366261104320834, 0.09375, 0.187274430302237, 0.299147264963753, 0.384856831207909, 0.393944413932995, 0.306885788387297, 0.160464011551945, 0.0349540052987265, 4.68308119072899e-14, 9.51767408520104e-10, 1.91133865676398e-07, 6.84427816835792e-06, 9.74389955919345e-05, 0.000772689312952027, 0.00405945404289132, 0.015625, 0.046935252136009, 0.114730678586702, 0.234871855881689, 0.410842066574916, 0.622763432033523, 0.825972347607508, 0.964513919005733, 

0.968621115700728, 0.844827894946839, 0.658832183335224, 0.45717569525536, 0.28021528122254, 0.150104998707654, 0.0692376370717168, 0.0269360872738176, 0.00858371879171459, 0.00214785564036788, 0.000396036380091269, 4.86456768668548e-05, 3.34589092360918e-06, 9.19624666642103e-08, 4.52953012034904e-10, 2.21526334365978e-14, 0.0309635267377078, 0.144477531683551, 0.284707357562356, 0.382213326346221, 0.39710175363652, 0.334787879547122, 0.232864863371416, 0.133570101516051, 0.0623165263168637, 0.0229903648736792, 0.00639238629092303, 0.00123576747861812, 0.000144075982016138, 7.66106642194578e-06, 9.53506338839978e-08, 2.49477494306772e-11, 0.000412416153788181, 0.0102948764704147, 0.0512638634822729, 0.133142673915044, 0.234477164089132, 0.311123672475516, 0.326328081122631, 0.275976917719567, 0.188503644051338, 0.102535770074375, 0.0429912129989208, 0.0130803098340233, 0.00258499767175157, 0.000265923428919882, 8.36339820808646e-06, 1.17064750532777e-08, 2.92967633127402e-06, 0.000391237697400073, 0.00492291916233749, 0.0247358849386848, 0.0738410780622995, 0.154203813599773, 0.243895427845814, 0.304113004330648, 0.304113004330648, 0.243895427845814, 0.154203813599773, 0.0738410780622995, 0.0247358849386847, 0.0049229191623375, 0.000391237697400073, 2.92967633127393e-06, 1.17064750532782e-08, 8.36339820808646e-06, 0.000265923428919881, 0.00258499767175157, 0.0130803098340233, 0.0429912129989208, 0.102535770074375, 0.188503644051338, 0.275976917719567, 0.326328081122631, 0.311123672475516, 0.234477164089132, 0.133142673915044, 0.051263863482273, 0.0102948764704147, 0.000412416153788172, 2.49477494306785e-11, 9.53506338839979e-08, 7.66106642194575e-06, 0.000144075982016139, 0.00123576747861812, 0.00639238629092303, 0.0229903648736793, 0.0623165263168636, 0.133570101516051, 0.232864863371416, 0.334787879547123, 0.39710175363652, 0.382213326346221, 0.284707357562357, 0.144477531683551, 0.0309635267377075, 2.21526334365992e-14, 4.52953012034904e-10, 9.19624666642099e-08, 3.34589092360919e-06, 4.86456768668548e-05, 0.000396036380091269, 0.00214785564036788, 0.00858371879171458, 0.0269360872738176, 0.0692376370717168, 0.150104998707654, 0.28021528122254, 0.45717569525536, 0.658832183335224, 0.844827894946839, 0.968621115700728, 

0.972057421816389, 0.860855446127013, 0.69039649618559, 0.499522976595493, 0.324197987915755, 0.187206346021014, 0.0951040693223257, 0.0418564672898566, 0.015625, 0.00480303341270715, 0.00116508469965099, 0.00020924211220552, 2.51466978027399e-05, 1.69965846720885e-06, 4.61008744633972e-08, 2.25006479756521e-10, 1.09490581909576e-14, 0.0276136603147861, 0.130604742528048, 0.263846655304091, 0.367570869089469, 0.401704478371663, 0.361848329305527, 0.273974462463315, 0.175067687077512, 0.09375, 0.0413404010433632, 0.0145595856695794, 0.00389713626163808, 0.000730612511673111, 8.3153119609848e-05, 4.34268820994449e-06, 5.33910927847369e-08, 1.38754541622991e-11, 0.000326847218961765, 0.00825612807951666, 0.0420139356513346, 0.112697805484362, 0.207391899855783, 0.29142132955637, 0.32885907080933, 0.305097167406522, 0.234375, 0.148259496618724, 0.0758104879031977, 0.0302434161111429, 0.00884467757954704, 0.00169505654475309, 0.000170449956285214, 5.27875314197065e-06, 7.32666624731036e-09, 2.06330931044467e-06, 0.000278350896181256, 0.00356807411361486, 0.0184284395078466, 0.057105197067776, 0.125174200632103, 0.210527239132601, 0.283575747151314, 0.3125, 0.283575747151314, 0.210527239132601, 0.125174200632102, 0.0571051970677759, 0.0184284395078466, 0.00356807411361486, 0.000278350896181254, 2.06330931044474e-06, 7.32666624731001e-09, 5.2787531419707e-06, 0.000170449956285214, 0.00169505654475309, 0.00884467757954705, 0.0302434161111429, 0.0758104879031977, 0.148259496618724, 0.234375, 0.305097167406523, 0.32885907080933, 0.29142132955637, 0.207391899855783, 0.112697805484362, 0.0420139356513346, 0.00825612807951662, 0.000326847218961773, 1.38754541622983e-11, 5.33910927847375e-08, 4.34268820994449e-06, 8.31531196098482e-05, 0.000730612511673112, 0.00389713626163808, 0.0145595856695794, 0.0413404010433632, 0.09375, 0.175067687077512, 0.273974462463315, 0.361848329305527, 0.401704478371663, 0.367570869089469, 0.263846655304091, 0.130604742528048, 0.0276136603147864, 1.09490581909569e-14, 2.25006479756524e-10, 4.61008744633972e-08, 1.69965846720886e-06, 2.51466978027399e-05, 0.000209242112205521, 0.00116508469965099, 0.00480303341270715, 0.015625, 0.0418564672898566, 0.0951040693223257, 0.187206346021014, 0.324197987915755, 0.499522976595493, 0.69039649618559, 0.860855446127013, 0.972057421816389, 

0.974960808669954, 0.874578074075131, 0.718085961603359, 0.538038089382177, 0.366218402546375, 0.225001178393878, 0.123699785988714, 0.0601463381917086, 0.0254599803429195, 0.00918305608732532, 0.00273921380931099, 0.000647420573551661, 0.000113734681366832, 1.34205614444865e-05, 8.93873362265076e-07, 2.39765046374449e-08, 1.16129173827628e-10, 5.62702076651821e-15, 0.0247753787254001, 0.1185241803974, 0.244490839943744, 0.351324228403018, 0.400463711197528, 0.381025519127778, 0.309259552624371, 0.215656837587999, 0.128883555929084, 0.0653055801284339, 0.0275026405463803, 0.00932255215945078, 0.00241783213379856, 0.000441824893736348, 4.92814431104841e-05, 2.53514156247093e-06, 3.08486001639875e-08, 7.97164362242016e-12, 0.000262326523593114, 0.00669274217062284, 0.0346846652145753, 0.095585482932311, 0.182463049907526, 0.26885127014099, 0.322155875631265, 0.322185529747869, 0.271847731963274, 0.19350941720615, 0.115056619903781, 0.0559334884180619, 0.021416482044638, 0.00606063928884449, 0.00113208646100311, 0.000111688206832603, 3.41443103367697e-06, 4.70550230453718e-09, 1.48136757314682e-06, 0.000201557961083261, 0.00262428591342232, 0.0138699375050174, 0.0443389516045444, 0.101173983477551, 0.178981324604586, 0.256712820212951, 0.305810678342814, 0.305810678342814, 0.256712820212951, 0.178981324604586, 0.101173983477551, 0.0443389516045444, 0.0138699375050175, 0.00262428591342232, 0.000201557961083261, 1.48136757314682e-06, 4.70550230453718e-09, 3.41443103367696e-06, 0.000111688206832603, 0.0011320864610031, 0.00606063928884449, 0.021416482044638, 0.0559334884180619, 0.115056619903781, 0.19350941720615, 0.271847731963274, 0.322185529747869, 0.322155875631265, 0.26885127014099, 0.182463049907526, 0.0955854829323111, 0.0346846652145753, 0.00669274217062284, 0.000262326523593114, 7.97164362242016e-12, 3.08486001639875e-08, 2.53514156247093e-06, 4.9281443110484e-05, 0.000441824893736348, 0.00241783213379857, 0.00932255215945078, 0.0275026405463803, 0.0653055801284339, 0.128883555929084, 0.215656837587999, 0.309259552624371, 0.381025519127778, 0.400463711197528, 0.351324228403018, 0.244490839943744, 0.1185241803974, 0.0247753787254001, 5.62702076651821e-15, 1.16129173827628e-10, 2.39765046374449e-08, 8.93873362265073e-07, 1.34205614444865e-05, 0.000113734681366832, 0.000647420573551661, 0.00273921380931099, 0.00918305608732532, 0.0254599803429195, 0.0601463381917086, 0.123699785988714, 0.225001178393878, 0.366218402546375, 0.538038089382177, 0.718085961603359, 0.874578074075131, 0.974960808669954, 

0.977435650241118, 0.886406989879932, 0.742448313231084, 0.572970339357278, 0.405932699205302, 0.262680513242844, 0.154199209865131, 0.0813714542256584, 0.0381393669996204, 0.015625, 0.00547498519255554, 0.00159223348901111, 0.000368156628013724, 6.34782884281394e-05, 7.37498461918577e-06, 4.85128763070724e-07, 1.2890178567556e-08, 6.20275562214327e-11, 2.99470477117429e-15, 0.022350319307711, 0.107963346799201, 0.226681595147296, 0.334377878762335, 0.394902425029427, 0.393349556865857, 0.33824013939101, 0.253442303603072, 0.165587027160815, 0.09375, 0.0453975714984511, 0.0184035762559179, 0.006042158701056, 0.00152607859179978, 0.000272915282458093, 2.99263759592852e-05, 1.51988734606524e-06, 1.83334418307343e-08, 4.71477485130109e-12, 0.000212945294247509, 0.005479087853718, 0.0288373304145694, 0.0813077034166513, 0.160071613676584, 0.245424679547772, 0.309141207649815, 0.328908347256015, 0.299549015022429, 0.234375, 0.156845134847677, 0.0886311642693745, 0.0413181046131922, 0.0152868269740897, 0.00420807382688278, 0.000769201263519256, 7.46711127333135e-05, 2.25783445990399e-06, 3.0928343522135e-09, 1.08205937088367e-06, 0.000148299237219682, 0.00195655731679186, 0.0105444656954937, 0.034604897994727, 0.0816688664892098, 0.150691023151782, 0.227650920900951, 0.289006899278452, 0.3125, 0.289006899278452, 0.227650920900952, 0.150691023151782, 0.0816688664892097, 0.0346048979947271, 0.0105444656954937, 0.00195655731679186, 0.000148299237219682, 1.08205937088367e-06, 3.0928343522135e-09, 2.25783445990399e-06, 7.46711127333135e-05, 0.000769201263519256, 0.00420807382688277, 0.0152868269740897, 0.0413181046131922, 0.0886311642693745, 0.156845134847677, 0.234375, 0.299549015022429, 0.328908347256015, 0.309141207649815, 0.245424679547772, 0.160071613676584, 0.0813077034166513, 0.0288373304145694, 0.005479087853718, 0.000212945294247509, 4.71477485130109e-12, 1.83334418307343e-08, 1.51988734606524e-06, 2.99263759592852e-05, 0.000272915282458093, 0.00152607859179978, 0.006042158701056, 0.0184035762559179, 0.0453975714984511, 0.09375, 0.165587027160815, 0.253442303603072, 0.33824013939101, 0.393349556865857, 0.394902425029427, 0.334377878762335, 0.226681595147296, 0.107963346799201, 0.022350319307711, 2.99470477117429e-15, 6.20275562214327e-11, 1.2890178567556e-08, 4.85128763070724e-07, 7.37498461918576e-06, 6.34782884281395e-05, 0.000368156628013724, 0.00159223348901111, 0.00547498519255554, 0.015625, 0.0381393669996204, 0.0813714542256584, 0.154199209865131, 0.262680513242844, 0.405932699205302, 0.572970339357278, 0.742448313231084, 0.886406989879932, 0.977435650241118, 

0.979562049099076, 0.896668019554143, 0.76395332304625, 0.604611132082384, 0.443180618546272, 0.299643817580666, 0.185856366597293, 0.10499846864745, 0.0535248885784691, 0.0243202719552969, 0.00969095531437596, 0.00331319161993609, 0.000942951082806277, 0.000213984245592755, 3.63114854257522e-05, 4.1630832505185e-06, 2.70945173048897e-07, 7.14110048667623e-09, 3.41716705094067e-11, 1.64471903375808e-15, 0.0202625062883993, 0.0986935306988044, 0.210378390418692, 0.317342522383551, 0.386252288644223, 0.399941392337855, 0.361018468268403, 0.287222581955343, 0.201986411089171, 0.12517551054417, 0.0677825881292264, 0.0316069561721389, 0.0124095504088961, 0.00396581384072885, 0.000979389589685194, 0.000171959942021362, 1.85836830086352e-05, 9.33540881747693e-07, 1.11766514028696e-08, 2.86241769220901e-12, 0.000174639762681458, 0.00452620739103975, 0.02413927320557, 0.0694015480701794, 0.140265263039817, 0.222421182417801, 0.292193233268112, 0.32737307445125, 0.317597658368405, 0.268447320901583, 0.197541552253742, 0.125634105653134, 0.0680474240918155, 0.0306246833260814, 0.0110066640203169, 0.0029595674528315, 0.000531093416242418, 5.08499226601634e-05, 1.52316151945806e-06, 2.07569268582754e-09, 8.02771286706285e-07, 0.000110707983669699, 0.00147722272484599, 0.00809484941946051, 0.0271661392915844, 0.0659712425682498, 0.126127450453789, 0.199005949362439, 0.266336788518745, 0.307041800901606, 0.307041800901606, 0.266336788518745, 0.199005949362439, 0.126127450453789, 0.0659712425682498, 0.0271661392915844, 0.00809484941946053, 0.00147722272484599, 0.0001107079836697, 8.02771286706324e-07, 2.07569268582741e-09, 1.52316151945804e-06, 5.08499226601634e-05, 0.000531093416242416, 0.0029595674528315, 0.0110066640203169, 0.0306246833260814, 0.0680474240918155, 0.125634105653134, 0.197541552253742, 0.268447320901583, 0.317597658368405, 0.32737307445125, 0.292193233268112, 0.222421182417801, 0.140265263039817, 0.0694015480701795, 0.02413927320557, 0.00452620739103978, 0.000174639762681463, 2.86241769220878e-12, 1.11766514028695e-08, 9.33540881747693e-07, 1.85836830086351e-05, 0.000171959942021362, 0.000979389589685195, 0.00396581384072885, 0.0124095504088961, 0.0316069561721389, 0.0677825881292264, 0.12517551054417, 0.201986411089172, 0.287222581955343, 0.361018468268403, 0.399941392337855, 0.386252288644223, 0.317342522383552, 0.210378390418692, 0.0986935306988047, 0.0202625062883996, 1.64471903375792e-15, 3.41716705094061e-11, 7.14110048667623e-09, 2.70945173048896e-07, 4.1630832505185e-06, 3.63114854257523e-05, 0.000213984245592755, 0.000942951082806277, 0.00331319161993609, 0.00969095531437596, 0.0243202719552969, 0.0535248885784691, 0.10499846864745, 0.185856366597293, 0.299643817580666, 0.443180618546272, 0.604611132082384, 0.76395332304625, 0.896668019554143, 0.979562049099076, 

0.981402286216887, 0.905621388085949, 0.783000804188452, 0.633262061621569, 0.477927421878223, 0.335467604414565, 0.218037043487174, 0.130468578259818, 0.0713441437499665, 0.0353127295520003, 0.015625, 0.00608000308311431, 0.00203526972180058, 0.000568599860539125, 0.000126970896819501, 2.12519624709268e-05, 2.40880521308376e-06, 1.55337012721933e-07, 4.06557911814258e-09, 1.93611009501178e-11, 9.293835729738e-16, 0.0184525462915543, 0.090523600128933, 0.195497028209047, 0.300619144074091, 0.375479722982245, 0.401877087896897, 0.378045307716001, 0.316378757919445, 0.236621128198707, 0.158031849890968, 0.09375, 0.048909470901651, 0.02209170736979, 0.00844127138016552, 0.00263628962431273, 0.000638644066909652, 0.000110377268901452, 1.17799727629276e-05, 5.86201554743653e-07, 6.97296368377302e-09, 1.77946010049735e-12, 0.000144562050574634, 0.00377021157705791, 0.0203379357094985, 0.0594618689880849, 0.122913556812282, 0.200597106411037, 0.273115392840906, 0.319666747215176, 0.326992257569699, 0.294677324305785, 0.234375, 0.163934699208391, 0.0999137709048275, 0.0522152948692543, 0.0228071391336858, 0.00799663883505801, 0.0021073970309653, 0.000372222294458676, 3.52176418986272e-05, 1.04638984331884e-06, 1.41961400605658e-09, 6.04019590175353e-07, 8.37468258916539e-05, 0.00112842398397011, 0.00627276771202083, 0.0214591152221702, 0.0534016664130626, 0.105231856301101, 0.172260750495602, 0.241001722485209, 0.293053923058091, 0.3125, 0.293053923058091, 0.241001722485209, 0.172260750495602, 0.105231856301101, 0.0534016664130626, 0.0214591152221702, 0.00627276771202082, 0.00112842398397011, 8.37468258916548e-05, 6.04019590175321e-07, 1.41961400605668e-09, 1.04638984331882e-06, 3.52176418986274e-05, 0.000372222294458676, 0.0021073970309653, 0.007996638835058, 0.0228071391336858, 0.0522152948692542, 0.0999137709048275, 0.163934699208391, 0.234375, 0.294677324305785, 0.326992257569699, 0.319666747215176, 0.273115392840906, 0.200597106411037, 0.122913556812282, 0.059461868988085, 0.0203379357094984, 0.00377021157705793, 0.000144562050574629, 1.77946010049751e-12, 6.9729636837729e-09, 5.86201554743658e-07, 1.17799727629276e-05, 0.000110377268901452, 0.000638644066909652, 0.00263628962431273, 0.00844127138016551, 0.02209170736979, 0.048909470901651, 0.09375, 0.158031849890968, 0.236621128198707, 0.316378757919445, 0.378045307716001, 0.401877087896897, 0.375479722982245, 0.300619144074091, 0.195497028209047, 0.0905236001289333, 0.018452546291554, 9.29383572973899e-16, 1.93611009501174e-11, 4.06557911814261e-09, 1.55337012721933e-07, 2.40880521308376e-06, 2.12519624709268e-05, 0.000126970896819501, 0.000568599860539124, 0.00203526972180058, 0.00608000308311431, 0.015625, 0.0353127295520003, 0.0713441437499665, 0.130468578259818, 0.218037043487174, 0.335467604414565, 0.477927421878223, 0.633262061621569, 0.783000804188452, 0.905621388085949, 0.981402286216887, 

0.983005362216885, 0.913476551524573, 0.79992976855372, 0.659216583917199, 0.51022075224158, 0.369870656862231, 0.250226258305671, 0.157246838652346, 0.0912452995347586, 0.0485199720352232, 0.0234146498759706, 0.0101262383377984, 0.0038603820413856, 0.00126890623989645, 0.000348851319265737, 7.6820417285542e-05, 1.2705622567556e-05, 1.42588966659826e-06, 9.12201721407436e-08, 2.3730110783671e-09, 1.12534963291082e-11, 5.38943505887117e-16, 0.0168734943331811, 0.0832939898699682, 0.181932837815798, 0.284461285692348, 0.363326718389408, 0.400121732750269, 0.389949255558054, 0.340729378556393, 0.268471541787507, 0.190922340508149, 0.12217030683181, 0.0698670890660645, 0.0353180388162654, 0.0155254529032003, 0.00579582431218419, 0.00177461418626883, 0.000422820649040302, 7.20857140787499e-05, 7.61023984053795e-06, 3.7561509025742e-07, 4.44297339187163e-09, 1.1303074779466e-12, 0.000120682120174215, 0.00316459899676643, 0.0172408664156614, 0.0511454461198671, 0.107801626155334, 0.180352913071076, 0.253204877690679, 0.307628096072838, 0.329135533178452, 0.313026940042406, 0.26560265956073, 0.200856509747572, 0.134633033343024, 0.0791494281553994, 0.0401216526002263, 0.0170812635786697, 0.00586280143247278, 0.00151845262410807, 0.00026454195506392, 2.47727976836525e-05, 7.30884428550886e-07, 9.87731073809429e-10, 4.60340898126162e-07, 6.41242700365725e-05, 0.000871376429034798, 0.00490444085550882, 0.0170589389858251, 0.0433563696123443, 0.0876869102633715, 0.148129358486746, 0.215203838200786, 0.273719293213546, 0.307962546580055, 0.307962546580055, 0.273719293213546, 0.215203838200786, 0.148129358486746, 0.0876869102633716, 0.0433563696123443, 0.0170589389858251, 0.00490444085550881, 0.000871376429034801, 6.41242700365724e-05, 4.60340898126162e-07, 9.87731073809429e-10, 7.30884428550886e-07, 2.47727976836524e-05, 0.000264541955063921, 0.00151845262410807, 0.00586280143247278, 0.0170812635786697, 0.0401216526002263, 0.0791494281553994, 0.134633033343024, 0.200856509747572, 0.26560265956073, 0.313026940042406, 0.329135533178452, 0.307628096072838, 0.253204877690679, 0.180352913071076, 0.107801626155334, 0.051145446119867, 0.0172408664156615, 0.00316459899676643, 0.000120682120174215, 1.1303074779466e-12, 4.44297339187163e-09, 3.75615090257418e-07, 7.61023984053798e-06, 7.20857140787501e-05, 0.000422820649040302, 0.00177461418626883, 0.00579582431218419, 0.0155254529032003, 0.0353180388162654, 0.0698670890660645, 0.12217030683181, 0.190922340508149, 0.268471541787507, 0.340729378556393, 0.389949255558054, 0.400121732750269, 0.363326718389408, 0.284461285692348, 0.181932837815799, 0.0832939898699682, 0.0168734943331811, 5.38943505887117e-16, 1.12534963291082e-11, 2.37301107836708e-09, 9.12201721407441e-08, 1.42588966659826e-06, 1.2705622567556e-05, 7.6820417285542e-05, 0.000348851319265737, 0.00126890623989645, 0.0038603820413856, 0.0101262383377984, 0.0234146498759706, 0.0485199720352232, 0.0912452995347586, 0.157246838652346, 0.250226258305671, 0.369870656862231, 0.51022075224158, 0.659216583917199, 0.79992976855372, 0.913476551524573, 0.983005362216885, 

0.984410247379471, 0.920403376507279, 0.815027333157476, 0.682750218151206, 0.540159664424491, 0.402681714264921, 0.282021698355784, 0.184850777371003, 0.112842606226361, 0.0637649706786781, 0.0330971108092022, 0.015625, 0.00662464501856691, 0.00248088422078279, 0.00080262514199532, 0.000217593664039002, 4.73364216804371e-05, 7.74811930639151e-06, 8.62022390353783e-07, 5.47635678108041e-08, 1.41707583458805e-09, 6.69558782682509e-12, 3.20008464088613e-16, 0.0154878666079712, 0.0768713553299151, 0.169574382320453, 0.269020109893535, 0.350353236507141, 0.395505224053674, 0.397422628054756, 0.360393286592369, 0.296914199156356, 0.222708847314842, 0.151880991038753, 0.09375, 0.0519698871798051, 0.0255713520773776, 0.0109813921722315, 0.00401784644725615, 0.00120928275187258, 0.000283993555319825, 4.78450556664249e-05, 5.00347042396582e-06, 2.45192692501692e-07, 2.88605681809872e-09, 7.3223164259791e-13, 0.000101530337878636, 0.00267509759900154, 0.0147006680888247, 0.044166847554624, 0.0946844967140477, 0.161856929754158, 0.233351940368985, 0.292766150053764, 0.325519930698192, 0.324101868055451, 0.290405955823643, 0.234375, 0.169875088018046, 0.109822074993031, 0.0626023738286668, 0.0309121479268566, 0.0128720894861253, 0.0043371997918613, 0.00110648196677728, 0.000190475752435071, 1.76770875009035e-05, 5.18334123699816e-07, 6.98110673349207e-10, 3.54975836528086e-07, 4.96493369281438e-05, 0.000679692735975953, 0.00386729041420811, 0.0136474133094868, 0.035327190460759, 0.0730750245607963, 0.126842197944713, 0.190336872776197, 0.251550002659837, 0.296146322111984, 0.3125, 0.296146322111984, 0.251550002659837, 0.190336872776197, 0.126842197944713, 0.0730750245607962, 0.035327190460759, 0.0136474133094868, 0.00386729041420811, 0.000679692735975956, 4.96493369281438e-05, 3.54975836528063e-07, 6.98110673349266e-10, 5.18334123699816e-07, 1.76770875009034e-05, 0.000190475752435071, 0.00110648196677728, 0.00433719979186129, 0.0128720894861253, 0.0309121479268565, 0.0626023738286668, 0.109822074993031, 0.169875088018046, 0.234375, 0.290405955823643, 0.324101868055451, 0.325519930698192, 0.292766150053764, 0.233351940368985, 0.161856929754158, 0.0946844967140477, 0.044166847554624, 0.0147006680888248, 0.00267509759900154, 0.000101530337878632, 7.32231642597988e-13, 2.88605681809872e-09, 2.4519269250169e-07, 5.00347042396582e-06, 4.78450556664249e-05, 0.000283993555319825, 0.00120928275187258, 0.00401784644725615, 0.0109813921722315, 0.0255713520773776, 0.0519698871798051, 0.09375, 0.151880991038753, 0.222708847314842, 0.296914199156356, 0.360393286592369, 0.397422628054756, 0.395505224053674, 0.350353236507141, 0.269020109893535, 0.169574382320454, 0.0768713553299151, 0.0154878666079709, 3.20008464088654e-16, 6.69558782682509e-12, 1.41707583458804e-09, 5.47635678108041e-08, 8.62022390353783e-07, 7.74811930639149e-06, 4.73364216804372e-05, 0.000217593664039002, 0.00080262514199532, 0.00248088422078279, 0.00662464501856691, 0.015625, 0.0330971108092022, 0.0637649706786781, 0.112842606226361, 0.184850777371003, 0.282021698355784, 0.402681714264921, 0.540159664424491, 0.682750218151206, 0.815027333157476, 0.920403376507279, 0.984410247379471, 

0.985648242491884, 0.926540621665256, 0.828536774256041, 0.704115979622578, 0.567872969985807, 0.433811933190359, 0.313120387329857, 0.212863734445695, 0.13574995151458, 0.0808088850116454, 0.0446221662446437, 0.0226782282648721, 0.0105030813043862, 0.00437651336117894, 0.00161361935564144, 0.000514836222655621, 0.000137871194237895, 2.96744469098549e-05, 4.81299206954868e-06, 5.31405820038482e-07, 3.35531910817617e-08, 8.64182624687966e-10, 4.07005592943438e-12, 1.94176239711507e-16, 0.014265452697046, 0.0711440143707394, 0.158311329590502, 0.25437654004114, 0.336975478942183, 0.388721313293548, 0.401150936586012, 0.375677256944185, 0.321646750992481, 0.252542239984665, 0.181815749981213, 0.11968644666824, 0.0716445859134123, 0.0386678395276867, 0.0185878295644263, 0.00782225753476684, 0.00281230753919116, 0.000833851412673816, 0.000193366300271747, 3.22390106266807e-05, 3.34351653713972e-06, 1.62820027466446e-07, 1.90822233801827e-09, 4.82986488050167e-13, 8.60276228537196e-05, 0.00227615077995136, 0.0126037842935098, 0.0382911729009392, 0.0833171027456719, 0.145132264167834, 0.214137650718655, 0.276259288899507, 0.317546560390812, 0.328849889502049, 0.308674754829191, 0.263190120585428, 0.203628604388724, 0.14235093196579, 0.0892164682220487, 0.0495203703038796, 0.0239023632973457, 0.00976300390324498, 0.00323694401359236, 0.000814940427035567, 0.000138823145103221, 1.27820018336915e-05, 3.72774616455327e-07, 5.00567482719176e-10, 2.7668716587898e-07, 3.88384971443051e-05, 0.000535166173903805, 0.00307410722051123, 0.0109867374828562, 0.0288993660423255, 0.0609644956026475, 0.108347177679839, 0.167199273040824, 0.228381068359525, 0.279492044090297, 0.308668932874937, 0.308668932874937, 0.279492044090297, 0.228381068359525, 0.167199273040824, 0.108347177679839, 0.0609644956026475, 0.0288993660423254, 0.0109867374828562, 0.00307410722051123, 0.000535166173903802, 3.88384971443051e-05, 2.76687165878961e-07, 5.00567482719222e-10, 3.72774616455327e-07, 1.27820018336916e-05, 0.000138823145103221, 0.000814940427035567, 0.00323694401359237, 0.00976300390324498, 0.0239023632973458, 0.0495203703038796, 0.0892164682220487, 0.14235093196579, 0.203628604388724, 0.263190120585428, 0.308674754829191, 0.328849889502049, 0.317546560390812, 0.276259288899507, 0.214137650718655, 0.145132264167834, 0.0833171027456719, 0.0382911729009392, 0.0126037842935098, 0.00227615077995136, 8.60276228537156e-05, 4.82986488050222e-13, 1.90822233801827e-09, 1.62820027466448e-07, 3.34351653713972e-06, 3.22390106266807e-05, 0.000193366300271748, 0.000833851412673816, 0.00281230753919116, 0.00782225753476684, 0.0185878295644263, 0.0386678395276867, 0.0716445859134123, 0.11968644666824, 0.181815749981213, 0.252542239984665, 0.321646750992481, 0.375677256944185, 0.401150936586012, 0.388721313293548, 0.336975478942183, 0.25437654004114, 0.158311329590502, 0.0711440143707394, 0.0142654526970456, 1.94176239711533e-16, 4.07005592943438e-12, 8.64182624687975e-10, 3.35531910817617e-08, 5.31405820038482e-07, 4.81299206954869e-06, 2.96744469098549e-05, 0.000137871194237896, 0.000514836222655621, 0.00161361935564144, 0.00437651336117894, 0.0105030813043862, 0.0226782282648721, 0.0446221662446437, 0.0808088850116454, 0.13574995151458, 0.212863734445695, 0.313120387329857, 0.433811933190359, 0.567872969985807, 0.704115979622578, 0.828536774256041, 0.926540621665256, 0.985648242491884, 

0.0078125, 0.0546875, 0.1640625, 0.2734375, 0.2734375, 0.1640625, 0.0546875, 0.0078125, 

0.189795993315888, 1.8821498927247e-05, 0.355989781949584, 0.000491699531897622, 0.286161523761367, 0.00550514290529928, 0.12779458199453, 0.0342424550425071, 0.0342424550425071, 0.12779458199453, 0.00550514290529928, 0.286161523761367, 0.000491699531897622, 0.355989781949584, 1.8821498927247e-05, 0.189795993315888, 

0.432999769052994, 0.0078125, 2.30947005396121e-07, 0.384987272306509, 0.0546875, 1.27276934913809e-05, 0.146699385243321, 0.1640625, 0.000300614756679824, 0.0310554417117261, 0.2734375, 0.00394455828827407, 0.00394455828827407, 0.2734375, 0.0310554417117261, 0.000300614756679824, 0.1640625, 0.146699385243321, 1.27276934913809e-05, 0.0546875, 0.384987272306509, 2.30947005396121e-07, 0.0078125, 0.432999769052994, 

0.604278729922773, 0.0606011146246741, 0.000426270122763878, 7.77876955884479e-09, 0.315606443857553, 0.208947128293814, 0.00605794295571169, 7.2979088026355e-07, 0.0706443820461607, 0.308756007159942, 0.0368967980913548, 2.93433147870465e-05, 0.00878490145596999, 0.253467289218044, 0.124847449533696, 0.000655461833106641, 0.000655461833106639, 0.124847449533696, 0.253467289218044, 0.00878490145597001, 2.93433147870464e-05, 0.0368967980913548, 0.308756007159942, 0.0706443820461608, 7.29790880263547e-07, 0.00605794295571169, 0.208947128293814, 0.315606443857553, 7.77876955884475e-09, 0.000426270122763878, 0.0606011146246741, 0.604278729922773, 

0.714392924232422, 0.159371951613892, 0.0078125, 3.48493053863121e-05, 4.99876848003043e-10, 0.246131644127034, 0.334673772213092, 0.0546875, 0.000813168259283756, 7.10933197513471e-08, 0.0363430168783423, 0.301199801577644, 0.1640625, 0.0081318605994322, 4.33329026092715e-06, 0.00298127469437943, 0.150596604153917, 0.2734375, 0.0451779922773527, 0.000146735184364572, 0.000146735184364572, 0.0451779922773527, 0.2734375, 0.150596604153917, 0.00298127469437944, 4.33329026092713e-06, 0.0081318605994322, 0.1640625, 0.301199801577644, 0.0363430168783424, 7.10933197513466e-08, 0.000813168259283756, 0.0546875, 0.334673772213092, 0.246131644127034, 4.99876848003039e-10, 3.48493053863121e-05, 0.0078125, 0.159371951613892, 0.714392924232422, 

0.786282464402557, 0.272747428675303, 0.0349425544563488, 0.00115878678013018, 4.00229978709488e-06, 5.00367562627932e-11, 0.192337449481471, 0.389372878683597, 0.150354633577943, 0.0131958523060965, 0.000137372772317918, 1.00230515815988e-08, 0.0201637976251847, 0.238228625850516, 0.277269562532147, 0.0644012912236479, 0.00202076087444521, 8.60466560791248e-07, 0.00117437906879438, 0.0809747634973347, 0.284063263843902, 0.174614055279785, 0.016514167346699, 4.10388823432674e-05, 4.10388823432674e-05, 0.016514167346699, 0.174614055279785, 0.284063263843902, 0.0809747634973346, 0.00117437906879438, 8.60466560791248e-07, 0.00202076087444521, 0.0644012912236479, 0.277269562532147, 0.238228625850516, 0.0201637976251847, 1.00230515815988e-08, 0.000137372772317919, 0.0131958523060965, 0.150354633577943, 0.389372878683597, 0.192337449481471, 5.00367562627932e-11, 4.00229978709489e-06, 0.00115878678013018, 0.0349425544563488, 0.272747428675303, 0.786282464402557, 

0.834912997163999, 0.379584806517345, 0.0847915241920486, 0.0078125, 0.000204214957908504, 6.02070135413138e-07, 6.90783405608846e-12, 0.152599687365376, 0.394351734849226, 0.250849153763575, 0.0546875, 0.00338238804843511, 2.83967233501691e-05, 1.85193420922078e-09, 0.0119533402178823, 0.175582773721426, 0.318050478394745, 0.1640625, 0.0240094674763298, 0.000574000922291251, 2.12780794804954e-07, 0.000520178517150538, 0.0434317721173692, 0.224030403419406, 0.2734375, 0.0946823697475519, 0.00644591307885771, 1.35820959550772e-05, 1.35820959550771e-05, 0.00644591307885771, 0.0946823697475519, 0.2734375, 0.224030403419406, 0.0434317721173692, 0.000520178517150542, 2.12780794804952e-07, 0.000574000922291251, 0.0240094674763298, 0.1640625, 0.318050478394745, 0.175582773721426, 0.0119533402178824, 1.85193420922076e-09, 2.83967233501691e-05, 0.00338238804843511, 0.0546875, 0.250849153763575, 0.394351734849226, 0.152599687365376, 6.90783405608835e-12, 6.02070135413138e-07, 0.000204214957908504, 0.0078125, 0.0847915241920486, 0.379584806517345, 0.834912997163999, 

0.869024617148354, 0.472130746008638, 0.150224269540811, 0.0253980268206605, 0.00189115309870527, 4.22898256217175e-05, 1.12267207929378e-07, 1.2164667026349e-12, 0.123228534279389, 0.374026043452567, 0.327056853557849, 0.122671786630209, 0.0191857179525427, 0.000951806839092721, 6.94399568274334e-06, 4.20355856043675e-10, 0.00748882533409007, 0.126988565619147, 0.305161416668529, 0.253929184701289, 0.0834166293886726, 0.00918089377249079, 0.000184072612874598, 6.22525567557284e-08, 0.000252838738529668, 0.0239527227230124, 0.158184339460846, 0.292016936748802, 0.201490564659119, 0.0491981303347605, 0.00271079332087049, 5.1218255079553e-06, 5.1218255079553e-06, 0.00271079332087049, 0.0491981303347605, 0.201490564659119, 0.292016936748802, 0.158184339460846, 0.0239527227230124, 0.000252838738529668, 6.22525567557284e-08, 0.000184072612874598, 0.00918089377249079, 0.0834166293886727, 0.253929184701289, 0.305161416668529, 0.126988565619147, 0.00748882533409007, 4.20355856043675e-10, 6.94399568274333e-06, 0.000951806839092721, 0.0191857179525427, 0.122671786630209, 0.327056853557849, 0.374026043452567, 0.123228534279389, 1.2164667026349e-12, 1.12267207929378e-07, 4.22898256217175e-05, 0.00189115309870527, 0.0253980268206605, 0.150224269540811, 0.472130746008638, 0.869024617148354, 

0.893744142257077, 0.549477958085253, 0.222295448173005, 0.0557940337309718, 0.0078125, 0.000502663105141885, 1.0088988133954e-05, 2.48954669634121e-08, 2.59166328142104e-13, 0.101209338557884, 0.343502375222785, 0.372896397144658, 0.199295985461008, 0.0546875, 0.00689544501740769, 0.000294704029443844, 1.95135770704456e-06, 1.12141736685944e-10, 0.00491191880811613, 0.0920306369612021, 0.268082842283547, 0.305093218996892, 0.1640625, 0.0405387921438994, 0.00368933210647813, 6.55506064578806e-05, 2.07959705652438e-08, 0.000132436979527922, 0.0136981717197272, 0.107072352888744, 0.259474124106776, 0.2734375, 0.132405737437903, 0.02565883438599, 0.00122333115140062, 2.14248902292501e-06, 2.14248902292498e-06, 0.00122333115140062, 0.02565883438599, 0.132405737437903, 0.2734375, 0.259474124106776, 0.107072352888744, 0.0136981717197272, 0.000132436979527923, 2.07959705652434e-08, 6.55506064578806e-05, 0.00368933210647812, 0.0405387921438994, 0.1640625, 0.305093218996892, 0.268082842283547, 0.0920306369612021, 0.00491191880811617, 1.12141736685941e-10, 1.95135770704456e-06, 0.000294704029443843, 0.00689544501740769, 0.0546875, 0.199295985461008, 0.372896397144658, 0.343502375222785, 0.101209338557884, 2.59166328142098e-13, 2.48954669634121e-08, 1.0088988133954e-05, 0.000502663105141885, 0.0078125, 0.0557940337309718, 0.222295448173005, 0.549477958085253, 0.893744142257077, 

0.912170692266778, 0.613260754654977, 0.294365150290663, 0.0971297034542767, 0.0206394317017482, 0.00252781811443596, 0.000146470692237609, 2.71921736229605e-06, 6.36354503616898e-09, 6.43447416647235e-14, 0.0844071880891463, 0.310584295080952, 0.393349285805798, 0.268759731603853, 0.107032810707876, 0.0238848603538697, 0.00259378920356574, 9.97121387125178e-05, 6.15688275793512e-07, 3.40726430409742e-11, 0.00334738731069152, 0.0674119709056842, 0.225264914037869, 0.318712831971607, 0.237880772526816, 0.0967214516287335, 0.0196852909023901, 0.00156702293584564, 2.5529708730075e-05, 7.73253331815299e-09, 7.37496550382288e-05, 0.00812871791323433, 0.0716698072561585, 0.20997248826672, 0.293717109131236, 0.217595745835285, 0.0829996939053501, 0.0136813883175915, 0.000588109684602307, 9.74911675303113e-07, 9.74911675303113e-07, 0.000588109684602309, 0.0136813883175915, 0.0829996939053501, 0.217595745835285, 0.293717109131236, 0.20997248826672, 0.0716698072561585, 0.00812871791323431, 7.37496550382288e-05, 7.73253331815299e-09, 2.55297087300751e-05, 0.00156702293584564, 0.0196852909023901, 0.0967214516287335, 0.237880772526816, 0.318712831971607, 0.225264914037869, 0.0674119709056841, 0.00334738731069152, 3.40726430409742e-11, 6.15688275793515e-07, 9.97121387125178e-05, 0.00259378920356574, 0.0238848603538697, 0.107032810707876, 0.268759731603853, 0.393349285805798, 0.310584295080951, 0.0844071880891463, 6.43447416647235e-14, 6.36354503616902e-09, 2.71921736229605e-06, 0.000146470692237609, 0.00252781811443596, 0.0206394317017482, 0.0971297034542767, 0.294365150290663, 0.613260754654977, 0.912170692266778, 

0.926244098741814, 0.665723950256127, 0.362559971440197, 0.145843416736863, 0.0415262113765022, 0.0078125, 0.000866865997780997, 4.64727036686175e-05, 8.13999977323069e-07, 1.83085746069555e-09, 1.8112834145891e-14, 0.0713562801833172, 0.278896908646785, 0.395833756721649, 0.323189978586531, 0.167250507519824, 0.0546875, 0.0105463678313788, 0.00102759732206423, 3.65331818533283e-05, 2.14141625603513e-07, 1.15206170936179e-11, 0.00235592881980487, 0.0500744783969867, 0.185211955423512, 0.306939058132516, 0.288692693861173, 0.1640625, 0.0549891586734564, 0.00973803212535825, 0.000702706254919552, 1.07342293668924e-05, 3.14042400973937e-09, 4.32135179017489e-05, 0.00499478343468782, 0.0481451673549734, 0.161947378132257, 0.276841782374935, 0.2734375, 0.159286412364948, 0.0512680662607414, 0.0075090956229194, 0.000298929063563843, 4.75585199454238e-07, 4.75585199454228e-07, 0.000298929063563843, 0.00750909562291941, 0.0512680662607414, 0.159286412364948, 0.2734375, 0.276841782374935, 0.161947378132257, 0.0481451673549733, 0.00499478343468782, 4.32135179017496e-05, 3.14042400973929e-09, 1.07342293668924e-05, 0.000702706254919553, 0.00973803212535826, 0.0549891586734564, 0.1640625, 0.288692693861174, 0.306939058132516, 0.185211955423511, 0.0500744783969867, 0.0023559288198049, 1.15206170936175e-11, 2.14141625603513e-07, 3.65331818533283e-05, 0.00102759732206424, 0.0105463678313788, 0.0546875, 0.167250507519824, 0.323189978586531, 0.395833756721648, 0.278896908646785, 0.0713562801833176, 1.81128341458903e-14, 1.83085746069555e-09, 8.13999977323072e-07, 4.64727036686176e-05, 0.000866865997780996, 0.0078125, 0.0415262113765022, 0.145843416736863, 0.362559971440197, 0.665723950256127, 0.926244098741814, 

0.937220095578147, 0.708999375682048, 0.42504579933678, 0.198352432442444, 0.0699871380925131, 0.0178438414813797, 0.00306221267023594, 0.000315224524153621, 1.59257191772164e-05, 2.66790910752525e-07, 5.82067296012457e-10, 5.66254781410992e-15, 0.0610489564866734, 0.249914040751448, 0.386808451327986, 0.360983388111131, 0.226420907449706, 0.0971037421352778, 0.0275729871697237, 0.00477438883616499, 0.000428790788774355, 1.43650414587286e-05, 8.09141497756906e-08, 4.25962443159873e-12, 0.00170426887483335, 0.0377536264932533, 0.150861838134904, 0.281552973061156, 0.313933768368664, 0.226467972473799, 0.106403399390355, 0.0309912282637739, 0.0049478332633373, 0.000331486581215451, 4.82057635316753e-06, 1.37326373421978e-09, 2.64317230418161e-05, 0.00316850347847235, 0.0326881491160478, 0.122000191776094, 0.241817114545694, 0.293430404251701, 0.228115440427528, 0.111760229919329, 0.031718464837885, 0.00424964367069749, 0.000159551522207577, 2.4595977545887e-07, 2.45959775458876e-07, 0.000159551522207576, 0.00424964367069749, 0.031718464837885, 0.111760229919329, 0.228115440427528, 0.293430404251701, 0.241817114545695, 0.122000191776094, 0.0326881491160478, 0.00316850347847236, 2.64317230418156e-05, 1.37326373421982e-09, 4.8205763531675e-06, 0.00033148658121545, 0.0049478332633373, 0.0309912282637739, 0.106403399390355, 0.226467972473799, 0.313933768368664, 0.281552973061156, 0.150861838134904, 0.0377536264932534, 0.00170426887483333, 4.25962443159889e-12, 8.09141497756901e-08, 1.43650414587286e-05, 0.000428790788774354, 0.00477438883616498, 0.0275729871697237, 0.0971037421352778, 0.226420907449706, 0.360983388111132, 0.386808451327986, 0.249914040751448, 0.061048956486673, 5.66254781411016e-15, 5.82067296012452e-10, 2.66790910752525e-07, 1.59257191772164e-05, 0.00031522452415362, 0.00306221267023594, 0.0178438414813797, 0.0699871380925131, 0.198352432442444, 0.42504579933678, 0.708999375682048, 0.937220095578147, 

0.945936938561647, 0.744892565468458, 0.481239949030381, 0.251795991139697, 0.104521182198714, 0.0333624833981836, 0.0078125, 0.0012485762684793, 0.000121240747790487, 5.84794461503403e-06, 9.46057209918471e-08, 2.01529937703236e-10, 1.93485451689262e-15, 0.0527838544579877, 0.224062754111928, 0.371019080411895, 0.383831260964566, 0.278571865327661, 0.146056757288519, 0.0546875, 0.0139748730855691, 0.00222900861673815, 0.00018797833540665, 6.01282975145158e-06, 3.28291486577646e-08, 1.69904734082443e-12, 0.00126230188648962, 0.0288847700657434, 0.12258971402078, 0.250758168309437, 0.318195040276673, 0.274036336328936, 0.1640625, 0.0670353503614245, 0.0175629758053626, 0.00258961715184117, 0.000163781041875245, 2.29193810509822e-06, 6.39419473769765e-10, 1.67707643537466e-05, 0.00206869114031551, 0.0225029426863568, 0.0910117216263317, 0.201918938578588, 0.285642053064808, 0.2734375, 0.17864357020408, 0.0768797484484723, 0.0198194145281061, 0.00247842537323951, 8.88942447721653e-05, 1.33688402125921e-07, 1.33688402125925e-07, 8.88942447721658e-05, 0.0024784253732395, 0.0198194145281062, 0.0768797484484723, 0.17864357020408, 0.2734375, 0.285642053064808, 0.201918938578588, 0.0910117216263317, 0.0225029426863568, 0.0020686911403155, 1.67707643537462e-05, 6.39419473769788e-10, 2.29193810509824e-06, 0.000163781041875244, 0.00258961715184118, 0.0175629758053626, 0.0670353503614245, 0.1640625, 0.274036336328936, 0.318195040276673, 0.250758168309436, 0.12258971402078, 0.0288847700657433, 0.00126230188648961, 1.6990473408245e-12, 3.28291486577648e-08, 6.01282975145156e-06, 0.000187978335406651, 0.00222900861673815, 0.0139748730855691, 0.0546875, 0.146056757288519, 0.278571865327661, 0.383831260964566, 0.371019080411895, 0.224062754111928, 0.0527838544579874, 1.93485451689271e-15, 2.01529937703238e-10, 9.46057209918468e-08, 5.84794461503404e-06, 0.000121240747790487, 0.0012485762684793, 0.0078125, 0.0333624833981836, 0.104521182198714, 0.251795991139697, 0.481239949030381, 0.744892565468458, 0.945936938561647, 

0.952969820938751, 0.774862926592346, 0.531244961759882, 0.304174912854268, 0.143277284960876, 0.0542953426974053, 0.0160220880541196, 0.00350878479449016, 0.000530051593766141, 4.91386596995848e-05, 2.28430545834448e-06, 3.59395852792802e-08, 7.51103354506816e-11, 7.13550584545569e-16, 0.0460648242665565, 0.201288667661476, 0.351679374393899, 0.394610545742223, 0.320856262912937, 0.196179792539372, 0.0902805002364112, 0.0305125124568437, 0.00718823939691991, 0.00107519245701581, 8.62789721153054e-05, 2.66021701833628e-06, 1.41677648126912e-08, 7.23320168848703e-13, 0.000954295563234292, 0.0224097485070864, 0.0997751034510938, 0.219400289904316, 0.307940572750945, 0.303786994996299, 0.218017830725903, 0.113716221788444, 0.0417782394623391, 0.0100825950776664, 0.00139662226784715, 8.43886983787661e-05, 1.1453182760116e-06, 3.1423864864456e-10, 1.09830733887696e-05, 0.00138606033366371, 0.0157262425719347, 0.0677693315169741, 0.164191549140133, 0.261343425884759, 0.292494407183787, 0.235447654760001, 0.13489791342914, 0.0525274040407279, 0.0125597344367972, 0.00148723296820769, 5.14373442776061e-05, 7.58431071318831e-08, 7.58431071318831e-08, 5.14373442776064e-05, 0.00148723296820769, 0.0125597344367972, 0.0525274040407278, 0.13489791342914, 0.235447654760001, 0.292494407183787, 0.261343425884759, 0.164191549140133, 0.0677693315169742, 0.0157262425719347, 0.00138606033366371, 1.09830733887696e-05, 3.1423864864456e-10, 1.14531827601161e-06, 8.43886983787661e-05, 0.00139662226784715, 0.0100825950776664, 0.0417782394623391, 0.113716221788444, 0.218017830725903, 0.303786994996299, 0.307940572750945, 0.219400289904316, 0.0997751034510938, 0.0224097485070863, 0.000954295563234292, 7.23320168848703e-13, 1.41677648126914e-08, 2.66021701833628e-06, 8.62789721153052e-05, 0.00107519245701581, 0.00718823939691991, 0.0305125124568437, 0.0902805002364112, 0.196179792539372, 0.320856262912937, 0.394610545742223, 0.351679374393899, 0.201288667661475, 0.0460648242665565, 7.13550584545569e-16, 7.51103354506824e-11, 3.59395852792802e-08, 2.28430545834448e-06, 4.91386596995847e-05, 0.000530051593766141, 0.00350878479449015, 0.0160220880541196, 0.0542953426974053, 0.143277284960876, 0.304174912854268, 0.531244961759882, 0.774862926592346, 0.952969820938751, 

0.958723227255006, 0.800067125939386, 0.575497737495814, 0.35423167219522, 0.184488574859528, 0.079975965051387, 0.0281891738330272, 0.0078125, 0.00162135793230379, 0.000234066389689774, 2.09020202910069e-05, 9.43080852419066e-07, 1.45064312484966e-08, 2.98505703800188e-11, 2.81160065031437e-16, 0.0405348422550844, 0.181336551676853, 0.330859861763959, 0.39627276065787, 0.352682967155124, 0.243282994747208, 0.131222548120872, 0.0546875, 0.0170666727741127, 0.00377036046283577, 0.000535758827106493, 4.13083812115719e-05, 1.23639204099532e-06, 6.45341786698059e-09, 3.25847562895827e-13, 0.00073449178028857, 0.0176143854012481, 0.0815206740636618, 0.189987166791876, 0.28895000776231, 0.317166443131511, 0.261792861695211, 0.1640625, 0.0769913681899537, 0.0260285457079497, 0.00588536795198876, 0.000775444356778815, 4.51621940104766e-05, 5.97929739973003e-07, 1.61844719356791e-10, 7.3938883370804e-06, 0.000950554737998388, 0.0111588370314232, 0.0506036457841155, 0.131518979368856, 0.229715449863967, 0.290158053440965, 0.2734375, 0.192957964013554, 0.0998261746454514, 0.0359174420547951, 0.00808705875207693, 0.000916476552659172, 3.07778315058496e-05, 4.46591122256563e-08, 4.46591122256547e-08, 3.07778315058496e-05, 0.00091647655265917, 0.00808705875207694, 0.0359174420547951, 0.0998261746454514, 0.192957964013554, 0.2734375, 0.290158053440965, 0.229715449863967, 0.131518979368856, 0.0506036457841154, 0.0111588370314232, 0.000950554737998388, 7.3938883370806e-06, 1.61844719356784e-10, 5.97929739973003e-07, 4.51621940104764e-05, 0.000775444356778817, 0.00588536795198876, 0.0260285457079497, 0.0769913681899537, 0.1640625, 0.261792861695211, 0.317166443131511, 0.28895000776231, 0.189987166791875, 0.0815206740636619, 0.017614385401248, 0.000734491780288583, 3.25847562895809e-13, 6.45341786698059e-09, 1.23639204099531e-06, 4.1308381211572e-05, 0.000535758827106493, 0.00377036046283577, 0.0170666727741127, 0.0546875, 0.131222548120872, 0.243282994747208, 0.352682967155124, 0.396272760657869, 0.330859861763959, 0.181336551676853, 0.0405348422550848, 2.81160065031419e-16, 2.98505703800188e-11, 1.45064312484965e-08, 9.43080852419068e-07, 2.09020202910069e-05, 0.000234066389689774, 0.00162135793230379, 0.0078125, 0.0281891738330272, 0.079975965051387, 0.184488574859528, 0.35423167219522, 0.575497737495814, 0.800067125939386, 0.958723227255006, 

0.963487876613842, 0.82141561165458, 0.614568939183748, 0.401264115422011, 0.226676823404277, 0.109427803262988, 0.044367600759339, 0.0147476762654543, 0.00388407906278665, 0.000771505932739513, 0.000107322536723417, 9.29433436896899e-06, 4.09195085019907e-07, 6.17844303555952e-09, 1.25524551204721e-11, 1.17398600950322e-16, 0.0359326736082037, 0.163885983045812, 0.309842709060337, 0.391381058833441, 0.374769204727842, 0.284740368112662, 0.174090254186645, 0.0853188770585429, 0.0328974781024956, 0.00963444795339857, 0.00202099690357497, 0.000275459397485201, 2.05568708701249e-05, 6.00488165400556e-07, 3.08280389840102e-09, 1.54246643849532e-13, 0.000574322757366307, 0.0140134117549949, 0.066947624287235, 0.163603465711448, 0.265548523544295, 0.317536474076944, 0.292756259240022, 0.211538724130551, 0.119415407801536, 0.0515629331976816, 0.0163103613075057, 0.00349880798270781, 0.00044259532444611, 2.50122679806086e-05, 3.24478806898789e-07, 8.68543830758214e-11, 5.09976322857701e-06, 0.000665692172642758, 0.00803630764657857, 0.0379937962826882, 0.104532510300816, 0.196727778981297, 0.273505090552769, 0.291381601128071, 0.240816156450563, 0.153311908177405, 0.0731288948183056, 0.024689376308208, 0.00529400236001014, 0.000578800887512043, 1.89737978073704e-05, 2.71703511525217e-08, 2.71703511525228e-08, 1.89737978073704e-05, 0.000578800887512041, 0.00529400236001015, 0.024689376308208, 0.0731288948183056, 0.153311908177405, 0.240816156450563, 0.291381601128071, 0.273505090552769, 0.196727778981297, 0.104532510300816, 0.0379937962826881, 0.00803630764657859, 0.000665692172642758, 5.09976322857685e-06, 8.6854383075826e-11, 3.24478806898789e-07, 2.50122679806085e-05, 0.000442595324446111, 0.0034988079827078, 0.0163103613075057, 0.0515629331976817, 0.119415407801536, 0.21153872413055, 0.292756259240022, 0.317536474076944, 0.265548523544295, 0.163603465711448, 0.0669476242872351, 0.0140134117549949, 0.000574322757366295, 1.54246643849542e-13, 3.08280389840102e-09, 6.00488165400553e-07, 2.0556870870125e-05, 0.000275459397485201, 0.00202099690357497, 0.00963444795339858, 0.0328974781024956, 0.0853188770585428, 0.174090254186645, 0.284740368112662, 0.374769204727842, 0.391381058833441, 0.309842709060338, 0.163885983045812, 0.0359326736082033, 1.17398600950331e-16, 1.25524551204721e-11, 6.17844303555948e-09, 4.09195085019908e-07, 9.29433436896899e-06, 0.000107322536723417, 0.000771505932739514, 0.00388407906278664, 0.0147476762654543, 0.044367600759339, 0.109427803262988, 0.226676823404277, 0.401264115422011, 0.614568939183748, 0.82141561165458, 0.963487876613842, 

0.967476832232532, 0.839624823270648, 0.649055261862035, 0.444953589036542, 0.268706827222014, 0.141592634054263, 0.0642538196510229, 0.0246635922971972, 0.0078125, 0.00197288396267145, 0.000377934973009722, 5.09828306588816e-05, 4.30421995417006e-06, 1.85675786621681e-07, 2.76053986983122e-09, 5.54916360631833e-12, 5.1594834602283e-17, 0.0320641270869944, 0.148614359994553, 0.289388640264885, 0.381985712912654, 0.388438124856186, 0.319295983767263, 0.215951747699119, 0.120350124948616, 0.0546875, 0.0198110461502499, 0.00551004808648888, 0.00110781497082647, 0.000145897344939989, 1.05978787641102e-05, 3.03382342154962e-07, 1.53620121305142e-09, 7.62822434944875e-14, 0.000455429840768007, 0.0112735188645107, 0.0552973727696637, 0.14054090307518, 0.240651299732262, 0.308581201267556, 0.311055375524245, 0.251686529925444, 0.1640625, 0.0852582652010214, 0.0344284055840612, 0.0103165320032539, 0.00211945175603592, 0.000259242282342137, 1.42892617083408e-05, 1.82260221107425e-07, 4.83352428375634e-11, 3.59377629743918e-06, 0.000475100744687779, 0.00587022857034107, 0.0287267076715445, 0.0828289334430581, 0.165681100185602, 0.248912206014693, 0.292415840739479, 0.2734375, 0.203841716775321, 0.119510462467359, 0.053373750920577, 0.0171051614255499, 0.00352306146718697, 0.000373901128484931, 1.20133236294192e-05, 1.70149958389949e-08, 1.70149958389941e-08, 1.20133236294193e-05, 0.000373901128484931, 0.00352306146718698, 0.0171051614255499, 0.053373750920577, 0.119510462467359, 0.203841716775321, 0.2734375, 0.292415840739479, 0.248912206014693, 0.165681100185602, 0.082828933443058, 0.0287267076715445, 0.00587022857034108, 0.000475100744687776, 3.5937762974393e-06, 4.83352428375605e-11, 1.82260221107427e-07, 1.42892617083408e-05, 0.000259242282342138, 0.00211945175603593, 0.0103165320032539, 0.0344284055840612, 0.0852582652010214, 0.1640625, 0.251686529925444, 0.311055375524245, 0.308581201267556, 0.240651299732261, 0.140540903075179, 0.0552973727696637, 0.0112735188645106, 0.000455429840768018, 7.62822434944821e-14, 1.53620121305144e-09, 3.03382342154962e-07, 1.05978787641102e-05, 0.000145897344939989, 0.00110781497082647, 0.00551004808648888, 0.0198110461502499, 0.0546875, 0.120350124948616, 0.215951747699119, 0.319295983767263, 0.388438124856186, 0.381985712912654, 0.289388640264885, 0.148614359994552, 0.0320641270869948, 5.15948346022787e-17, 5.54916360631841e-12, 2.76053986983122e-09, 1.85675786621682e-07, 4.30421995417007e-06, 5.09828306588817e-05, 0.000377934973009722, 0.00197288396267145, 0.0078125, 0.0246635922971972, 0.0642538196510229, 0.141592634054263, 0.268706827222014, 0.444953589036542, 0.649055261862035, 0.839624823270648, 0.967476832232532, 

0.970848993561292, 0.855260371523085, 0.679525631043893, 0.485230984967367, 0.309763463258982, 0.175475137508019, 0.0873166582711359, 0.0376481861539915, 0.0138091752542664, 0.00420228119387966, 0.0010246217907608, 0.000190422200218412, 2.50346621280949e-05, 2.06886649136993e-06, 8.7731454159596e-08, 1.28750873003575e-09, 2.56506411962059e-12, 2.37314862287524e-17, 0.0287827057606339, 0.135223917864324, 0.26992231391626, 0.369649730903669, 0.395184575011754, 0.346682286201018, 0.254681894023045, 0.15748706426402, 0.0815556356205716, 0.0348654242541196, 0.0120021441298514, 0.00319898861333274, 0.00062090013467116, 7.9461864671816e-05, 5.64299335673836e-06, 1.58822971351864e-07, 7.94948767956052e-10, 3.92230249620262e-14, 0.000365708256998698, 0.00916287779792744, 0.045950998054323, 0.120685606699555, 0.216069264156086, 0.293542458344168, 0.318362752116162, 0.282337738765935, 0.206425538890078, 0.12397325768716, 0.0602528095227768, 0.0230319667180795, 0.0065997120642815, 0.00130800153406177, 0.000155556070816479, 8.39652655459267e-06, 1.05585254270088e-07, 2.77830836035845e-11, 2.58146005276901e-06, 0.000344935401574243, 0.00434588874347064, 0.021890115676134, 0.0656316761907518, 0.138082199755362, 0.221092456279348, 0.281203338135137, 0.290268809764174, 0.24489987733575, 0.168044097237528, 0.0921248617786786, 0.0389722713303529, 0.0119614891172009, 0.00238227495764645, 0.00024661160501842, 7.79103032146277e-06, 1.09332002379141e-08, 1.09332002379141e-08, 7.79103032146277e-06, 0.00024661160501842, 0.00238227495764644, 0.0119614891172009, 0.0389722713303529, 0.0921248617786786, 0.168044097237528, 0.24489987733575, 0.290268809764174, 0.281203338135137, 0.221092456279348, 0.138082199755362, 0.0656316761907518, 0.0218901156761341, 0.00434588874347064, 0.000344935401574243, 2.58146005276901e-06, 2.77830836035845e-11, 1.05585254270088e-07, 8.39652655459267e-06, 0.000155556070816479, 0.00130800153406177, 0.0065997120642815, 0.0230319667180795, 0.0602528095227768, 0.12397325768716, 0.206425538890078, 0.282337738765935, 0.318362752116162, 0.293542458344168, 0.216069264156086, 0.120685606699555, 0.045950998054323, 0.00916287779792744, 0.000365708256998698, 3.92230249620262e-14, 7.94948767956052e-10, 1.58822971351864e-07, 5.64299335673834e-06, 7.9461864671816e-05, 0.00062090013467116, 0.00319898861333274, 0.0120021441298514, 0.0348654242541196, 0.0815556356205716, 0.15748706426402, 0.254681894023045, 0.346682286201018, 0.395184575011754, 0.36964973090367, 0.26992231391626, 0.135223917864324, 0.0287827057606339, 2.37314862287524e-17, 2.56506411962059e-12, 1.28750873003575e-09, 8.77314541595956e-08, 2.06886649136993e-06, 2.50346621280949e-05, 0.000190422200218412, 0.0010246217907608, 0.00420228119387966, 0.0138091752542664, 0.0376481861539915, 0.0873166582711359, 0.175475137508019, 0.309763463258982, 0.485230984967367, 0.679525631043893, 0.855260371523085, 0.970848993561292, 

0.973724739478554, 0.868771103835969, 0.706497445227301, 0.522180717653786, 0.34929822280336, 0.210216031048477, 0.112917825555881, 0.0535653676976678, 0.0221276721186275, 0.0078125, 0.00229851199108852, 0.00054409476381518, 9.85609151974571e-05, 1.26783501823302e-05, 1.02893507519265e-06, 4.30031096923521e-08, 6.24168847809301e-10, 1.23409554030576e-12, 1.13696304849452e-17, 0.0259763753379508, 0.123451202307739, 0.251656076026484, 0.355527351924447, 0.396441334813594, 0.367251375360567, 0.28896969016475, 0.194642605695934, 0.11208186416695, 0.0546875, 0.0222353124102691, 0.00733697107637154, 0.00188716998971387, 0.000355599567720664, 4.44223468079519e-05, 3.0948795736486e-06, 8.5862068038227e-08, 4.25554224767889e-10, 2.08833459848254e-14, 0.000296991563136116, 0.00751810687398467, 0.0384173549360853, 0.103740519894834, 0.192834483162211, 0.274969322948799, 0.316931417374285, 0.303120245522948, 0.243309002562003, 0.1640625, 0.0921855630137715, 0.042401603666598, 0.0154860454845544, 0.00427447636813722, 0.000821936448179471, 9.54576771365523e-05, 5.06201950711366e-06, 6.28903837332664e-08, 1.64390619415994e-11, 1.8864146839945e-06, 0.000254360202034222, 0.00325817940718655, 0.0168171081474633, 0.0521096266416783, 0.114375380696803, 0.193110455559094, 0.262252401059121, 0.293432697448997, 0.2734375, 0.212329376288294, 0.136136710517544, 0.0705988349565245, 0.028545135659314, 0.00844894484909402, 0.00163570681965068, 0.000165795897199209, 5.16346310022053e-06, 7.18921505192884e-09, 7.18921505192884e-09, 5.16346310022053e-06, 0.000165795897199209, 0.00163570681965068, 0.00844894484909401, 0.028545135659314, 0.0705988349565245, 0.136136710517544, 0.212329376288294, 0.2734375, 0.293432697448997, 0.262252401059121, 0.193110455559094, 0.114375380696803, 0.0521096266416784, 0.0168171081474633, 0.00325817940718655, 0.000254360202034222, 1.8864146839945e-06, 1.64390619415994e-11, 6.28903837332664e-08, 5.06201950711366e-06, 9.54576771365523e-05, 0.000821936448179469, 0.00427447636813723, 0.0154860454845544, 0.0424016036665979, 0.0921855630137715, 0.1640625, 0.243309002562002, 0.303120245522948, 0.316931417374285, 0.274969322948799, 0.192834483162211, 0.103740519894834, 0.0384173549360853, 0.00751810687398467, 0.000296991563136116, 2.08833459848254e-14, 4.25554224767889e-10, 8.5862068038227e-08, 3.0948795736486e-06, 4.44223468079518e-05, 0.000355599567720665, 0.00188716998971387, 0.00733697107637153, 0.0222353124102691, 0.0546875, 0.11208186416695, 0.194642605695934, 0.28896969016475, 0.367251375360567, 0.396441334813594, 0.355527351924447, 0.251656076026484, 0.123451202307739, 0.0259763753379508, 1.13696304849452e-17, 1.23409554030576e-12, 6.24168847809301e-10, 4.30031096923521e-08, 1.02893507519265e-06, 1.26783501823302e-05, 9.85609151974571e-05, 0.00054409476381518, 0.00229851199108852, 0.0078125, 0.0221276721186275, 0.0535653676976678, 0.112917825555881, 0.210216031048477, 0.34929822280336, 0.522180717653786, 0.706497445227301, 0.868771103835969, 0.973724739478554, 

0.976196567367861, 0.88051540924611, 0.730428922953023, 0.555975297182679, 0.38697022724605, 0.245116685329897, 0.140402125697163, 0.0721185178433988, 0.0328585504402887, 0.0130907088805282, 0.00447467010885329, 0.00127924672339679, 0.000295282260900386, 5.23333777910373e-05, 6.60771573402766e-06, 5.28020695703352e-07, 2.17952399551297e-08, 3.13371383563937e-10, 6.15569715074035e-13, 5.65076185442762e-18, 0.0235583721185029, 0.113068272156229, 0.234670800652588, 0.340450844297936, 0.393472739101553, 0.381689925755387, 0.318179686300911, 0.230159655628361, 0.144664366967263, 0.0786069415233813, 0.0365139964386586, 0.0142376142757751, 0.00453368175334123, 0.00113155607461202, 0.000207926387842072, 2.5445437883706e-05, 1.74404953165637e-06, 4.77941037217861e-08, 2.34892705560329e-10, 1.14734779033256e-14, 0.000243655653888718, 0.00622254097712791, 0.032311964507659, 0.0893462954486217, 0.171464792950121, 0.254725095916331, 0.309025580036677, 0.314800069958618, 0.272959337910312, 0.202293462334452, 0.127697069136316, 0.067911503775161, 0.0298323811711126, 0.0104856802187149, 0.00280408440037196, 0.000525523483423647, 5.9810741935254e-05, 3.12401077495157e-06, 3.84136017933627e-08, 9.98404148902157e-12, 1.40002310887155e-06, 0.000190248950546227, 0.00247169663356501, 0.0130264530827157, 0.0415109588427052, 0.0944409324476511, 0.166741577564465, 0.239203723788553, 0.286128973009092, 0.289221311546274, 0.248101840031537, 0.179960406898712, 0.109056687595715, 0.0539814607296651, 0.0210087420467862, 0.00602978491756742, 0.00113953340134022, 0.000113443134915462, 3.49002087574654e-06, 4.82664286444923e-09, 4.82664286444892e-09, 3.4900208757465e-06, 0.000113443134915462, 0.00113953340134021, 0.00602978491756742, 0.0210087420467862, 0.0539814607296651, 0.109056687595715, 0.179960406898712, 0.248101840031537, 0.289221311546273, 0.286128973009092, 0.239203723788553, 0.166741577564465, 0.094440932447651, 0.0415109588427052, 0.0130264530827157, 0.00247169663356501, 0.000190248950546229, 1.40002310887162e-06, 9.98404148902077e-12, 3.84136017933621e-08, 3.12401077495157e-06, 5.98107419352538e-05, 0.000525523483423647, 0.00280408440037197, 0.0104856802187149, 0.0298323811711126, 0.067911503775161, 0.127697069136316, 0.202293462334452, 0.272959337910312, 0.314800069958618, 0.309025580036677, 0.254725095916331, 0.171464792950121, 0.0893462954486219, 0.032311964507659, 0.00622254097712795, 0.000243655653888726, 1.14734779033245e-14, 2.34892705560325e-10, 4.77941037217861e-08, 1.74404953165636e-06, 2.5445437883706e-05, 0.000207926387842072, 0.00113155607461202, 0.00453368175334123, 0.0142376142757751, 0.0365139964386586, 0.0786069415233813, 0.144664366967263, 0.230159655628361, 0.318179686300911, 0.381689925755387, 0.393472739101553, 0.340450844297936, 0.234670800652588, 0.11306827215623, 0.0235583721185033, 5.65076185442698e-18, 6.15569715074022e-13, 3.13371383563937e-10, 2.17952399551296e-08, 5.28020695703352e-07, 6.60771573402767e-06, 5.23333777910373e-05, 0.000295282260900386, 0.00127924672339679, 0.00447467010885329, 0.0130907088805282, 0.0328585504402887, 0.0721185178433988, 0.140402125697163, 0.245116685329897, 0.38697022724605, 0.555975297182679, 0.730428922953023, 0.88051540924611, 0.976196567367861, 

0.978336469198365, 0.890781350111176, 0.751719661380738, 0.586832352594959, 0.422592976245175, 0.279635530435334, 0.16915519179793, 0.0929159456895194, 0.0459463889894858, 0.0202264579705358, 0.0078125, 0.00259749328051612, 0.000724534328239758, 0.000163659495084149, 2.84656792621858e-05, 3.5369768206122e-06, 2.78891511560826e-07, 1.13890484506114e-08, 1.62421239301908e-10, 3.17262243486129e-13, 2.90331499607672e-18, 0.0214607191296514, 0.103880265823414, 0.218967999654001, 0.325007963186267, 0.387341119431338, 0.390824517854616, 0.342172961824708, 0.262868427992087, 0.177784283323365, 0.105603901070251, 0.0546875, 0.0243775686181874, 0.00917514775492572, 0.00283458255818483, 0.000689536522901207, 0.000124004899552202, 1.49093959106605e-05, 1.00763574989925e-06, 2.73221051518847e-08, 1.33306870946422e-10, 6.48536180584406e-15, 0.000201754631485758, 0.0051918029810232, 0.0273355997696612, 0.0771431147005187, 0.152155672143844, 0.23409625407529, 0.296639691531881, 0.318720368741796, 0.29482109872538, 0.236299771407634, 0.1640625, 0.0980504423012164, 0.049795532529488, 0.0210407021560248, 0.00715840411639092, 0.00186323953552717, 0.000341592253423101, 3.82069974205487e-05, 1.96973912614713e-06, 2.40054522803663e-08, 6.20865426632319e-12, 1.05373219788318e-06, 0.000144155378096451, 0.00189585037272781, 0.0101725031380004, 0.0332055123222507, 0.0778994915002695, 0.142869764075645, 0.214688462265752, 0.271613436453665, 0.293747471034107, 0.2734375, 0.219096894317552, 0.150139577895451, 0.086767851101552, 0.041285984451282, 0.0155534247225901, 0.0043479393165472, 0.000804840358035996, 7.8891599219885e-05, 2.40156721394334e-06, 3.30208492368816e-09, 3.30208492368839e-09, 2.40156721394331e-06, 7.88915992198854e-05, 0.000804840358035996, 0.0043479393165472, 0.0155534247225901, 0.041285984451282, 0.0867678511015519, 0.150139577895451, 0.219096894317552, 0.2734375, 0.293747471034107, 0.271613436453665, 0.214688462265752, 0.142869764075645, 0.0778994915002695, 0.0332055123222507, 0.0101725031380004, 0.0018958503727278, 0.000144155378096453, 1.05373219788312e-06, 6.20865426632375e-12, 2.40054522803659e-08, 1.96973912614715e-06, 3.82069974205487e-05, 0.000341592253423101, 0.00186323953552717, 0.00715840411639092, 0.0210407021560248, 0.049795532529488, 0.0980504423012164, 0.1640625, 0.236299771407634, 0.29482109872538, 0.318720368741796, 0.296639691531881, 0.23409625407529, 0.152155672143844, 0.0771431147005187, 0.0273355997696611, 0.00519180298102323, 0.000201754631485751, 6.48536180584475e-15, 1.33306870946419e-10, 2.73221051518849e-08, 1.00763574989925e-06, 1.49093959106605e-05, 0.000124004899552202, 0.000689536522901207, 0.00283458255818483, 0.00917514775492572, 0.0243775686181874, 0.0546875, 0.105603901070251, 0.177784283323365, 0.262868427992088, 0.342172961824708, 0.390824517854616, 0.387341119431338, 0.325007963186267, 0.218967999654001, 0.103880265823414, 0.021460719129651, 2.90331499607708e-18, 3.17262243486122e-13, 1.6242123930191e-10, 1.13890484506114e-08, 2.78891511560826e-07, 3.5369768206122e-06, 2.84656792621858e-05, 0.000163659495084149, 0.000724534328239758, 0.00259749328051612, 0.0078125, 0.0202264579705358, 0.0459463889894858, 0.0929159456895194, 0.16915519179793, 0.279635530435334, 0.422592976245175, 0.586832352594959, 0.751719661380738, 0.890781350111176, 0.978336469198365, 

0.980201135684649, 0.899802034928746, 0.770715042394355, 0.61498729685726, 0.456090617808426, 0.313370558539771, 0.19863465885222, 0.115525780189393, 0.0612226679668602, 0.0293026770626826, 0.0125237852716783, 0.00471002091732903, 0.00152898069154182, 0.000417510871561184, 9.25579579894907e-05, 1.58388181371484e-05, 1.94086476176554e-06, 1.5127491189003e-07, 6.12029987973844e-09, 8.66661943997641e-11, 1.68462038852163e-13, 1.53744805132756e-18, 0.0196295857256514, 0.0957216161707918, 0.204503083115557, 0.309605009419575, 0.378910941032084, 0.395500688257218, 0.361141196174155, 0.292047409240671, 0.210158420975289, 0.134521064807784, 0.0762360522300465, 0.0379135219432858, 0.0163198094489065, 0.00595976757834684, 0.00179405352893373, 0.000426871194038755, 7.53533046405333e-05, 8.92230328295759e-06, 5.95699105827036e-07, 1.60044141877713e-08, 7.75952400317919e-11, 3.76184240485053e-15, 0.000168472989179581, 0.00436411603251342, 0.0232556830086233, 0.0667994716644947, 0.134910691266675, 0.213923999854287, 0.281398805930724, 0.316410597225363, 0.309175133330406, 0.26466499735517, 0.198887917221197, 0.130794245901368, 0.0746537075102097, 0.0364597824261607, 0.0149032245058435, 0.00493053606982463, 0.00125381235771946, 0.000225533089426752, 2.48487421244017e-05, 1.26663957333766e-06, 1.53176211514553e-08, 3.94479064559854e-12, 8.03298440532971e-07, 0.000110537604932635, 0.00146921662217127, 0.00800692150553196, 0.0266859755846531, 0.0642834640753651, 0.121813371393712, 0.190447895461017, 0.252691021865712, 0.289287864506997, 0.288259676939709, 0.250674779575387, 0.189720898616707, 0.123915694985664, 0.0687784818907889, 0.0316387215671883, 0.0115901827462374, 0.00316716764054091, 0.000575849991608476, 5.56921286396264e-05, 1.67986763136631e-06, 2.29813118781267e-09, 2.29813118781267e-09, 1.67986763136631e-06, 5.56921286396261e-05, 0.000575849991608478, 0.00316716764054091, 0.0115901827462374, 0.0316387215671883, 0.068778481890789, 0.123915694985664, 0.189720898616707, 0.250674779575387, 0.288259676939709, 0.289287864506998, 0.252691021865712, 0.190447895461017, 0.121813371393712, 0.0642834640753651, 0.026685975584653, 0.00800692150553194, 0.00146921662217128, 0.000110537604932635, 8.03298440532971e-07, 3.94479064559854e-12, 1.53176211514553e-08, 1.26663957333765e-06, 2.48487421244018e-05, 0.000225533089426753, 0.00125381235771946, 0.00493053606982463, 0.0149032245058435, 0.0364597824261607, 0.0746537075102096, 0.130794245901368, 0.198887917221197, 0.26466499735517, 0.309175133330406, 0.316410597225363, 0.281398805930724, 0.213923999854287, 0.134910691266675, 0.0667994716644946, 0.0232556830086233, 0.00436411603251342, 0.000168472989179581, 3.76184240485053e-15, 7.75952400317919e-11, 1.60044141877712e-08, 5.95699105827039e-07, 8.92230328295762e-06, 7.53533046405333e-05, 0.000426871194038755, 0.00179405352893373, 0.00595976757834684, 0.0163198094489064, 0.0379135219432858, 0.0762360522300465, 0.134521064807784, 0.210158420975289, 0.292047409240671, 0.361141196174155, 0.395500688257218, 0.378910941032084, 0.309605009419575, 0.204503083115557, 0.0957216161707918, 0.0196295857256514, 1.53744805132756e-18, 1.68462038852163e-13, 8.66661943997631e-11, 6.12029987973848e-09, 1.51274911890031e-07, 1.94086476176554e-06, 1.58388181371484e-05, 9.25579579894907e-05, 0.000417510871561184, 0.00152898069154182, 0.00471002091732903, 0.0125237852716783, 0.0293026770626826, 0.0612226679668602, 0.115525780189393, 0.19863465885222, 0.313370558539771, 0.456090617808426, 0.61498729685726, 0.770715042394355, 0.899802034928746, 0.980201135684649, 

0.981835687264961, 0.907767375406583, 0.787712134983158, 0.640676541012468, 0.487463956671044, 0.34603675197343, 0.228382563918332, 0.139516260811256, 0.0784425962852767, 0.0403037873154724, 0.0187537633445454, 0.0078125, 0.00287093293064401, 0.000912797088858873, 0.000244679857962669, 5.33646853206015e-05, 9.00315366196295e-06, 1.0899226619756e-06, 8.40952832111374e-08, 3.37474029268917e-09, 4.74925265387767e-11, 9.19221477333445e-14, 8.36928536797698e-19, 0.0180219208015663, 0.0884520077048747, 0.191206387220227, 0.294515739971171, 0.368869954274127, 0.396514736040439, 0.375473941062165, 0.317341615918227, 0.240800069587592, 0.16422828354244, 0.100403432252597, 0.0546875, 0.0262759846154603, 0.0109766099234674, 0.00390561698822856, 0.00114960285102881, 0.000268332876129319, 4.66073765109113e-05, 5.44548974999852e-06, 3.59721792626804e-07, 9.58708315634491e-09, 4.62256597536422e-11, 2.23420074886271e-15, 0.000141770723200571, 0.00369372054007889, 0.0198911764609069, 0.0580231647138582, 0.119626464952611, 0.194724076066543, 0.264557375005152, 0.30935165531861, 0.316799488284471, 0.286796114974627, 0.230373171877843, 0.1640625, 0.103066651282937, 0.0565699025004194, 0.0267180216381245, 0.0106136540123101, 0.00342749100316607, 0.000854155314086654, 0.000151121225582492, 1.64329811059999e-05, 8.29413174286887e-07, 9.96252188408458e-09, 2.5561081468461e-12, 6.19583049199914e-07, 8.56934975387588e-05, 0.00114959810574629, 0.00635070310435903, 0.0215530507450925, 0.0531260426487963, 0.103558902519045, 0.167534924594432, 0.231547357821663, 0.278244167171674, 0.293658610458761, 0.2734375, 0.224597453237212, 0.16196833748304, 0.101542169536682, 0.0544389218088151, 0.0243223904623489, 0.00869654065753194, 0.00232992254650951, 0.000417055120505166, 3.98641822116301e-05, 1.19284208549276e-06, 1.62466472423674e-09, 1.62466472423688e-09, 1.19284208549276e-06, 3.98641822116298e-05, 0.000417055120505166, 0.00232992254650951, 0.00869654065753193, 0.0243223904623489, 0.0544389218088151, 0.101542169536682, 0.16196833748304, 0.224597453237212, 0.2734375, 0.293658610458761, 0.278244167171674, 0.231547357821663, 0.167534924594433, 0.103558902519045, 0.0531260426487964, 0.0215530507450925, 0.00635070310435903, 0.00114959810574629, 8.56934975387588e-05, 6.19583049199874e-07, 2.55610814684637e-12, 9.96252188408458e-09, 8.2941317428688e-07, 1.64329811059999e-05, 0.000151121225582492, 0.000854155314086653, 0.00342749100316607, 0.0106136540123101, 0.0267180216381245, 0.0565699025004194, 0.103066651282937, 0.1640625, 0.230373171877843, 0.286796114974627, 0.316799488284471, 0.30935165531861, 0.264557375005152, 0.194724076066544, 0.119626464952611, 0.0580231647138582, 0.0198911764609069, 0.00369372054007889, 0.000141770723200565, 2.23420074886299e-15, 4.62256597536422e-11, 9.58708315634482e-09, 3.59721792626804e-07, 5.44548974999852e-06, 4.66073765109112e-05, 0.000268332876129319, 0.0011496028510288, 0.00390561698822856, 0.0109766099234674, 0.0262759846154603, 0.0546875, 0.100403432252597, 0.16422828354244, 0.240800069587592, 0.317341615918227, 0.375473941062165, 0.396514736040439, 0.368869954274127, 0.294515739971171, 0.191206387220227, 0.0884520077048747, 0.0180219208015659, 8.36928536797822e-19, 9.19221477333445e-14, 4.74925265387761e-11, 3.37474029268917e-09, 8.40952832111374e-08, 1.0899226619756e-06, 9.00315366196297e-06, 5.33646853206014e-05, 0.000244679857962669, 0.000912797088858873, 0.00287093293064401, 0.0078125, 0.0187537633445454, 0.0403037873154724, 0.0784425962852767, 0.139516260811256, 0.228382563918332, 0.34603675197343, 0.487463956671044, 0.640676541012468, 0.787712134983158, 0.907767375406583, 0.981835687264961, 

0.983276388416166, 0.914833111934895, 0.802965872469459, 0.664127658385973, 0.516764966577533, 0.377443319770002, 0.258025861325193, 0.164482092846195, 0.0973186995710779, 0.0531335663444866, 0.0265751520607697, 0.0120654625515744, 0.00491514327527196, 0.00177003954205364, 0.000552630194915283, 0.000145751805888448, 3.13366423072629e-05, 5.22131312141857e-06, 6.25390102499986e-07, 4.78259961244181e-08, 1.90556076317127e-09, 2.66710298301593e-11, 5.14280953071714e-14, 4.67263761768589e-19, 0.0166029785300273, 0.0819525681125272, 0.178996312506076, 0.279918248656237, 0.357756023857913, 0.394580293942502, 0.385661682032654, 0.338671491196503, 0.269018763604518, 0.193727230670111, 0.126329099287118, 0.0742893599930842, 0.0391155662037998, 0.0182453167338771, 0.00742692412508311, 0.00258359091737021, 0.000745741863514427, 0.000171171936519054, 2.93132137693409e-05, 3.38505876739845e-06, 2.21533412230133e-07, 5.86258116400465e-09, 2.81303948388905e-11, 1.35596283164817e-15, 0.000120148849579125, 0.00314634596000642, 0.0171007160485293, 0.0505631441752794, 0.1061461047239, 0.176783714699912, 0.247043231953079, 0.298855925715137, 0.31870733766013, 0.302716147935993, 0.25736782707289, 0.196034483359586, 0.133409352085544, 0.0806014881452719, 0.0427766311002428, 0.0196271286195733, 0.00760585079662577, 0.00240496413480119, 0.000588842409643092, 0.000102681360891187, 1.10377076432986e-05, 5.52282352640547e-07, 6.59438699854727e-09, 1.68638481968064e-12, 4.8303736013657e-07, 6.71085532091358e-05, 0.000907636603974112, 0.00507416314339264, 0.0174963985334008, 0.0440024252250925, 0.0879157984217301, 0.146511797906954, 0.209763078145012, 0.262789495611459, 0.29129471614663, 0.287386142433357, 0.252784490097784, 0.197816361011389, 0.136877374017709, 0.0828356496764302, 0.0430957630327638, 0.018772068882903, 0.00657146534897703, 0.00173039206159768, 0.000305524492502017, 2.8904200357546e-05, 8.58816793398183e-07, 1.16518015164528e-09, 1.16518015164538e-09, 8.58816793398183e-07, 2.89042003575462e-05, 0.000305524492502017, 0.00173039206159768, 0.00657146534897704, 0.018772068882903, 0.0430957630327638, 0.0828356496764302, 0.136877374017709, 0.197816361011389, 0.252784490097783, 0.287386142433357, 0.29129471614663, 0.262789495611459, 0.209763078145012, 0.146511797906954, 0.0879157984217301, 0.0440024252250925, 0.0174963985334007, 0.00507416314339264, 0.000907636603974107, 6.71085532091358e-05, 4.83037360136536e-07, 1.68638481968083e-12, 6.59438699854727e-09, 5.52282352640552e-07, 1.10377076432986e-05, 0.000102681360891187, 0.000588842409643094, 0.00240496413480119, 0.00760585079662578, 0.0196271286195733, 0.0427766311002428, 0.0806014881452719, 0.133409352085543, 0.196034483359586, 0.25736782707289, 0.302716147935993, 0.31870733766013, 0.298855925715137, 0.247043231953079, 0.176783714699912, 0.1061461047239, 0.0505631441752794, 0.0171007160485292, 0.00314634596000642, 0.00012014884957912, 1.35596283164835e-15, 2.81303948388905e-11, 5.86258116400471e-09, 2.21533412230133e-07, 3.38505876739845e-06, 2.93132137693409e-05, 0.000171171936519054, 0.000745741863514428, 0.00258359091737021, 0.00742692412508311, 0.0182453167338771, 0.0391155662037998, 0.0742893599930842, 0.126329099287118, 0.193727230670111, 0.269018763604518, 0.338671491196503, 0.385661682032654, 0.394580293942502, 0.357756023857913, 0.279918248656237, 0.178996312506076, 0.0819525681125272, 0.0166029785300269, 4.67263761768665e-19, 5.14280953071714e-14, 2.66710298301596e-11, 1.90556076317127e-09, 4.78259961244181e-08, 6.25390102499987e-07, 5.22131312141857e-06, 3.1336642307263e-05, 0.000145751805888448, 0.000552630194915283, 0.00177003954205364, 0.00491514327527195, 0.0120654625515744, 0.0265751520607697, 0.0531335663444866, 0.0973186995710779, 0.164482092846195, 0.258025861325193, 0.377443319770002, 0.516764966577533, 0.664127658385973, 0.802965872469459, 0.914833111934895, 0.983276388416166, 

0.00390625, 0.03125, 0.109375, 0.21875, 0.2734375, 0.21875, 0.109375, 0.03125, 0.00390625, 

0.149687380573964, 3.97745072752434e-06, 0.32086890193539, 0.000118752385597781, 0.300917971024471, 0.00155116477799825, 0.161261454648038, 0.0115780515248016, 0.0540123456790123, 0.0540123456790123, 0.0115780515248016, 0.161261454648038, 0.00155116477799825, 0.300917971024471, 0.000118752385597781, 0.32086890193539, 3.97745072752434e-06, 0.149687380573964, 

0.384199973971887, 0.00390625, 2.60281121224955e-08, 0.390398360648854, 0.03125, 1.63935114618901e-06, 0.173554826955047, 0.109375, 4.51730449538622e-05, 0.0440887067387617, 0.21875, 0.000711293261238472, 0.00700000000000005, 0.2734375, 0.00700000000000005, 0.000711293261238471, 0.21875, 0.0440887067387617, 4.51730449538622e-05, 0.109375, 0.173554826955047, 1.63935114618901e-06, 0.03125, 0.390398360648854, 2.60281121224955e-08, 0.00390625, 0.384199973971887, 

0.562322543291604, 0.0406021724085881, 0.000140673180788785, 5.40094316100545e-10, 0.335649493049349, 0.159991537728688, 0.00228477553580074, 5.7909401941954e-08, 0.0876525497574884, 0.275818131124848, 0.0162350574475442, 2.71648061425736e-06, 0.013079919274785, 0.271713090176816, 0.0659213466818577, 7.28158782036092e-05, 0.00121990381845877, 0.167293215715069, 0.167293215715069, 0.00121990381845877, 7.28158782036089e-05, 0.0659213466818577, 0.271713090176816, 0.013079919274785, 2.71648061425735e-06, 0.0162350574475442, 0.275818131124848, 0.0876525497574885, 5.79094019419536e-08, 0.00228477553580074, 0.159991537728688, 0.335649493049349, 5.40094316100541e-10, 0.000140673180788785, 0.0406021724085881, 0.562322543291604, 

0.680880697126515, 0.12259442822481, 0.00390625, 8.04201197864117e-06, 2.34492614456703e-11, 0.268097816847257, 0.294220187112653, 0.03125, 0.000214458347261367, 3.81142069245898e-09, 0.0461842175427365, 0.308924433958084, 0.109375, 0.00250206882172024, 2.71033306581782e-07, 0.00454627659010641, 0.185350602957548, 0.21875, 0.0166808239550454, 1.10133740826422e-05, 0.00027970365112584, 0.0695049546108987, 0.2734375, 0.0695049546108987, 0.000279703651125842, 1.10133740826421e-05, 0.0166808239550454, 0.21875, 0.185350602957548, 0.00454627659010643, 2.7103330658178e-07, 0.00250206882172024, 0.109375, 0.308924433958084, 0.0461842175427366, 3.81142069245895e-09, 0.000214458347261367, 0.03125, 0.294220187112653, 0.268097816847257, 2.34492614456701e-11, 8.04201197864117e-06, 0.00390625, 0.12259442822481, 0.680880697126515, 

0.759733446005233, 0.226545294324976, 0.0216402591801953, 0.000441139010905775, 6.77970800207906e-07, 1.68950322906245e-12, 0.21239214717859, 0.369617074802618, 0.106418362209228, 0.00574118215379526, 2.65946318950958e-05, 3.86778024269846e-10, 0.0259772828008209, 0.263831752925225, 0.228954266579475, 0.0326892716861027, 0.000456409877638838, 3.87384832414507e-08, 0.00181556139885074, 0.107612829750927, 0.281476966926776, 0.106358233224189, 0.00447587590990954, 2.21710052896043e-06, 7.93063890253343e-05, 0.0274334898060111, 0.216280319029333, 0.216280319029333, 0.0274334898060111, 7.93063890253343e-05, 2.21710052896043e-06, 0.00447587590990955, 0.106358233224189, 0.281476966926776, 0.107612829750926, 0.00181556139885074, 3.87384832414507e-08, 0.000456409877638839, 0.0326892716861027, 0.228954266579475, 0.263831752925225, 0.0259772828008209, 3.86778024269846e-10, 2.65946318950959e-05, 0.00574118215379526, 0.106418362209228, 0.369617074802618, 0.21239214717859, 1.68950322906245e-12, 6.77970800207907e-07, 0.000441139010905775, 0.0216402591801953, 0.226545294324976, 0.759733446005233, 

0.813667764445078, 0.330529389064834, 0.0596018765816454, 0.00390625, 6.06676537012991e-05, 7.7808177043123e-08, 1.75777048152068e-13, 0.169961861751363, 0.392443339620086, 0.201517180883226, 0.03125, 0.00114837843365764, 4.19409566696012e-06, 5.38564560634911e-11, 0.0155322333317329, 0.203855250726603, 0.29808648196301, 0.109375, 0.00951022767593871, 9.89075585663159e-05, 7.21923924066092e-09, 0.00081110725088707, 0.0605102284705957, 0.251961645126635, 0.21875, 0.0450047912516688, 0.00133285400897737, 5.5297697433189e-07, 2.64729706922393e-05, 0.0112257586464937, 0.133108750430518, 0.2734375, 0.133108750430518, 0.0112257586464937, 2.64729706922396e-05, 5.52976974331884e-07, 0.00133285400897737, 0.0450047912516688, 0.21875, 0.251961645126635, 0.0605102284705957, 0.000811107250887075, 7.21923924066082e-09, 9.89075585663159e-05, 0.00951022767593871, 0.109375, 0.29808648196301, 0.203855250726603, 0.0155322333317329, 5.38564560634903e-11, 4.19409566696012e-06, 0.00114837843365764, 0.03125, 0.201517180883226, 0.392443339620086, 0.169961861751364, 1.75777048152065e-13, 7.7808177043123e-08, 6.06676537012991e-05, 0.00390625, 0.0596018765816454, 0.330529389064834, 0.813667764445078, 

0.851770071021287, 0.424130742155003, 0.114585995970256, 0.0150284523953017, 0.000772125053069863, 1.00325758238975e-05, 1.14138434296086e-08, 2.41530336638006e-14, 0.13803636901654, 0.384000030829074, 0.285106188564433, 0.0829565954028709, 0.00895222436508324, 0.00025805799838256, 8.06826915998154e-07, 9.53850935176882e-12, 0.00978684555966569, 0.152104065908508, 0.310355754255881, 0.200339062610788, 0.0454100865323796, 0.00290402436203193, 2.49520885249798e-05, 1.64803864144351e-09, 0.000396509771575473, 0.034428043167376, 0.193052269270981, 0.276466367315195, 0.131624171971701, 0.0186743346692449, 0.000440956123948967, 1.62710740732389e-07, 1.00402625899951e-05, 0.00487039148680477, 0.0750533423329648, 0.238450914353611, 0.238450914353611, 0.0750533423329648, 0.00487039148680477, 1.00402625899951e-05, 1.62710740732389e-07, 0.000440956123948967, 0.0186743346692449, 0.131624171971701, 0.276466367315195, 0.193052269270981, 0.034428043167376, 0.000396509771575473, 1.64803864144351e-09, 2.49520885249798e-05, 0.00290402436203193, 0.0454100865323796, 0.200339062610788, 0.310355754255881, 0.152104065908508, 0.00978684555966569, 9.53850935176882e-12, 8.06826915998154e-07, 0.00025805799838256, 0.00895222436508325, 0.0829565954028709, 0.285106188564433, 0.384000030829074, 0.13803636901654, 2.41530336638006e-14, 1.14138434296086e-08, 1.00325758238975e-05, 0.000772125053069864, 0.0150284523953017, 0.114585995970256, 0.424130742155003, 0.851770071021287, 

0.879515842541613, 0.504429311917423, 0.179322562850851, 0.0369427200868735, 0.00390625, 0.00016983643624042, 1.95034551386569e-06, 2.0410410752885e-09, 4.12589690786632e-15, 0.11382639772371, 0.36038916934264, 0.343783082577237, 0.150810509152786, 0.03125, 0.00266261335121172, 6.51091409607065e-05, 1.82835407104989e-07, 2.0403234498739e-12, 0.00644496219854924, 0.112647408191901, 0.288344799558302, 0.269347159809281, 0.109375, 0.0182626333403897, 0.000950934124412902, 7.16550690331077e-06, 4.41425814669216e-10, 0.000208525757877873, 0.0201202155127369, 0.138197980306189, 0.274887597706482, 0.21875, 0.0715781790362857, 0.00793635070178253, 0.000160470603414393, 5.45730698779783e-08, 4.21676170850248e-06, 0.00224607404853326, 0.0413972303947519, 0.175338751080449, 0.2734375, 0.175338751080449, 0.0413972303947519, 0.00224607404853326, 4.21676170850254e-06, 5.45730698779773e-08, 0.000160470603414393, 0.00793635070178252, 0.0715781790362857, 0.21875, 0.274887597706482, 0.138197980306189, 0.0201202155127369, 0.000208525757877875, 4.41425814669207e-10, 7.16550690331077e-06, 0.0009509341244129, 0.0182626333403897, 0.109375, 0.269347159809281, 0.288344799558302, 0.112647408191901, 0.00644496219854928, 2.04032344987385e-12, 1.82835407104989e-07, 6.51091409607064e-05, 0.00266261335121172, 0.03125, 0.150810509152786, 0.343783082577237, 0.36038916934264, 0.113826397723711, 4.12589690786621e-15, 2.0410410752885e-09, 1.95034551386569e-06, 0.00016983643624042, 0.00390625, 0.0369427200868735, 0.179322562850851, 0.504429311917423, 0.879515842541613, 

0.900269842293711, 0.57188508386752, 0.24717982498596, 0.0696126347822499, 0.0118560567266512, 0.00107574543179176, 4.14954844234534e-05, 4.35877534033639e-07, 4.29337671551831e-10, 8.394888408492e-16, 0.0952067997845387, 0.33100536629966, 0.377482602437625, 0.220136549376214, 0.0702669998007756, 0.0116165814611536, 0.000839801662513245, 1.82667186260992e-05, 4.74736589169372e-08, 5.08042022590994e-13, 0.00440495311069968, 0.0838183982749969, 0.252208034691503, 0.30456100359866, 0.18219674352879, 0.0548814063014413, 0.00743585099546659, 0.000334915039658724, 2.29659529696477e-06, 1.34512425084828e-10, 0.000116459940444679, 0.0121284591984975, 0.0962903680513115, 0.240778878060299, 0.269955239680595, 0.148161058407073, 0.0376224070821072, 0.00350889774960427, 6.34860326862705e-05, 2.03510639982383e-08, 1.92438452060843e-06, 0.00109686182834678, 0.0229766544481776, 0.118971378958066, 0.249990168661728, 0.249990168661728, 0.118971378958066, 0.0229766544481776, 0.00109686182834678, 1.92438452060843e-06, 2.03510639982383e-08, 6.34860326862708e-05, 0.00350889774960427, 0.0376224070821072, 0.148161058407073, 0.269955239680595, 0.240778878060299, 0.0962903680513115, 0.0121284591984975, 0.000116459940444679, 1.34512425084828e-10, 2.29659529696478e-06, 0.000334915039658724, 0.00743585099546659, 0.0548814063014413, 0.18219674352879, 0.304561003598661, 0.252208034691503, 0.0838183982749968, 0.00440495311069968, 5.08042022590994e-13, 4.74736589169375e-08, 1.82667186260992e-05, 0.000839801662513245, 0.0116165814611536, 0.0702669998007756, 0.220136549376214, 0.377482602437625, 0.33100536629966, 0.0952067997845387, 8.394888408492e-16, 4.29337671551834e-10, 4.35877534033639e-07, 4.14954844234534e-05, 0.00107574543179176, 0.0118560567266512, 0.0696126347822499, 0.24717982498596, 0.57188508386752, 0.900269842293711, 

0.916161310284861, 0.628131384149106, 0.313641930864063, 0.110775084917633, 0.0263596587228344, 0.00390625, 0.000316604100475664, 1.11744515402315e-05, 1.098281306717e-07, 1.03386140903071e-10, 1.97170352066983e-16, 0.0806623076556215, 0.300740528856164, 0.391344324609069, 0.280546654553846, 0.121332421229342, 0.03125, 0.00440209517844266, 0.000282386017027088, 5.63337477321096e-06, 1.38197705583398e-08, 1.43325310350592e-13, 0.00310704393859348, 0.062995783590566, 0.213629890754853, 0.31084662340766, 0.244338555776599, 0.109375, 0.0267781382009658, 0.00312203822866213, 0.000126415915707075, 8.08197305459863e-07, 4.55808297882444e-11, 6.83889756260379e-05, 0.00754037521083249, 0.0666387662863243, 0.196810908204723, 0.281170072076598, 0.21875, 0.0930814800606188, 0.0197240092102977, 0.00162105151503799, 2.70082170341266e-05, 8.28330236639516e-09, 9.40816270950463e-07, 0.000564097855835028, 0.0129918768520413, 0.0778811210086107, 0.202220974654123, 0.2734375, 0.202220974654123, 0.0778811210086106, 0.0129918768520413, 0.000564097855835028, 9.40816270950482e-07, 8.28330236639495e-09, 2.70082170341266e-05, 0.00162105151503799, 0.0197240092102978, 0.0930814800606187, 0.21875, 0.281170072076598, 0.196810908204723, 0.0666387662863242, 0.00754037521083249, 6.8388975626039e-05, 4.5580829788243e-11, 8.08197305459863e-07, 0.000126415915707075, 0.00312203822866214, 0.0267781382009658, 0.109375, 0.244338555776599, 0.31084662340766, 0.213629890754853, 0.062995783590566, 0.00310704393859351, 1.43325310350587e-13, 1.38197705583398e-08, 5.63337477321097e-06, 0.000282386017027089, 0.00440209517844266, 0.03125, 0.121332421229342, 0.280546654553846, 0.391344324609069, 0.300740528856164, 0.0806623076556219, 1.97170352066975e-16, 1.03386140903071e-10, 1.098281306717e-07, 1.11744515402315e-05, 0.000316604100475664, 0.00390625, 0.0263596587228344, 0.110775084917633, 0.313641930864063, 0.628131384149106, 0.916161310284861, 

0.928579223511302, 0.675008972996041, 0.376144848450611, 0.157424188646157, 0.0478653060038374, 0.0100392432855156, 0.00133936066997764, 9.96375074566032e-05, 3.28612918475526e-06, 3.0693937556711e-08, 2.79051046593466e-11, 5.22068951199069e-17, 0.0691269765347617, 0.27192322148806, 0.391207607089348, 0.327425950370293, 0.176974656709406, 0.0624367855669128, 0.0137828160020664, 0.00172469613357614, 0.000101116719939689, 1.88877578556652e-06, 4.43329753082488e-09, 4.48827273519201e-14, 0.00225140807502781, 0.0479248877975795, 0.178007180499224, 0.2979427261485, 0.286272331315905, 0.169886219056916, 0.0620520926716624, 0.0130611188771435, 0.00136125463530851, 5.08494505854318e-05, 3.08140057744875e-07, 1.68814081806632e-11, 4.19008494999797e-05, 0.00482656172018327, 0.0462838740279641, 0.154922475866084, 0.264612053017961, 0.264142155149632, 0.159638213030955, 0.0565210376157768, 0.0104717127649491, 0.000782265315403673, 1.22385901596237e-05, 3.62827380822475e-09, 4.87384208657471e-07, 0.000303804806715623, 0.00752145569714038, 0.0503472887195836, 0.152869162818937, 0.256683114566362, 0.256683114566362, 0.152869162818937, 0.0503472887195837, 0.0075214556971404, 0.000303804806715624, 4.87384208657459e-07, 3.62827380822486e-09, 1.22385901596236e-05, 0.000782265315403671, 0.0104717127649491, 0.0565210376157768, 0.159638213030955, 0.264142155149632, 0.264612053017962, 0.154922475866084, 0.0462838740279642, 0.00482656172018328, 4.1900849499979e-05, 1.68814081806638e-11, 3.08140057744873e-07, 5.08494505854316e-05, 0.00136125463530851, 0.0130611188771435, 0.0620520926716624, 0.169886219056916, 0.286272331315905, 0.2979427261485, 0.178007180499224, 0.0479248877975796, 0.00225140807502779, 4.4882727351922e-14, 4.43329753082484e-09, 1.88877578556651e-06, 0.000101116719939689, 0.00172469613357614, 0.0137828160020664, 0.0624367855669128, 0.176974656709406, 0.327425950370293, 0.391207607089348, 0.271923221488061, 0.0691269765347612, 5.22068951199094e-17, 2.79051046593464e-11, 3.06939375567109e-08, 3.28612918475525e-06, 9.96375074566031e-05, 0.00133936066997764, 0.0100392432855156, 0.0478653060038374, 0.157424188646157, 0.376144848450611, 0.675008972996041, 0.928579223511302, 

0.938456022163199, 0.714202395567706, 0.433495674279375, 0.206768489861003, 0.0756990873722987, 0.0205255725691051, 0.00390625, 0.000480415742152006, 3.34325756381077e-05, 1.04576062724161e-06, 9.38592389337705e-09, 8.30319473562006e-12, 1.53017440105916e-17, 0.0598473311875837, 0.245521359206014, 0.381954198008051, 0.360220010229547, 0.230576758611325, 0.102695286632628, 0.03125, 0.00614528421061833, 0.000702465377219034, 3.84174719023393e-05, 6.81758376787761e-07, 1.54581394374093e-09, 1.53564221830562e-14, 0.00166975867540801, 0.0369262592266623, 0.147236628619399, 0.274555008054849, 0.307268806171007, 0.224793525939879, 0.109375, 0.0343909976051121, 0.00645740564668597, 0.000617452189968414, 2.16651646870492e-05, 1.25906245827965e-07, 6.74244188565703e-12, 2.6621013156306e-05, 0.00317353505532462, 0.0324326468166142, 0.119578432715467, 0.233982495062447, 0.281176511664073, 0.21875, 0.109978939086908, 0.0339197908542616, 0.0056707413583063, 0.000393419115626554, 5.86002245527266e-06, 1.69163371294806e-09, 2.65262262110664e-07, 0.000170463461475241, 0.00446507685194582, 0.0325504023583294, 0.111359758329118, 0.219813466549525, 0.2734375, 0.219813466549525, 0.111359758329118, 0.0325504023583294, 0.00446507685194582, 0.00017046346147524, 2.65262262110657e-07, 1.69163371294812e-09, 5.8600224552727e-06, 0.000393419115626553, 0.00567074135830631, 0.0339197908542616, 0.109978939086908, 0.21875, 0.281176511664073, 0.233982495062447, 0.119578432715467, 0.0324326468166143, 0.00317353505532461, 2.66210131563054e-05, 6.74244188565731e-12, 1.25906245827966e-07, 2.16651646870491e-05, 0.000617452189968415, 0.00645740564668597, 0.0343909976051121, 0.109375, 0.224793525939879, 0.307268806171007, 0.274555008054848, 0.1472366286194, 0.0369262592266621, 0.00166975867540799, 1.5356422183057e-14, 1.54581394374094e-09, 6.81758376787758e-07, 3.84174719023394e-05, 0.000702465377219034, 0.00614528421061833, 0.03125, 0.102695286632628, 0.230576758611325, 0.360220010229547, 0.381954198008051, 0.245521359206014, 0.0598473311875833, 1.53017440105924e-17, 8.30319473562015e-12, 9.385923893377e-09, 1.04576062724162e-06, 3.34325756381077e-05, 0.000480415742152006, 0.00390625, 0.0205255725691051, 0.0756990873722987, 0.206768489861003, 0.433495674279375, 0.714202395567706, 0.938456022163199, 

0.94643426275367, 0.747136348849164, 0.485345746375922, 0.25661608614036, 0.108550355329033, 0.035810829063663, 0.008876676978496, 0.00156482161674821, 0.000180452787012712, 1.19100161484532e-05, 3.57159262200858e-07, 3.10515653659882e-09, 2.687639947298e-12, 4.89359816106433e-18, 0.0522844654806429, 0.221812621945459, 0.367193723071683, 0.380470613711269, 0.277815437054743, 0.147876109069939, 0.0571632886049885, 0.0155517054219356, 0.00279679045402743, 0.000297829148409053, 1.5417169569149e-05, 2.62675429941451e-07, 5.79381564027068e-10, 5.66925589107604e-15, 0.00126366788397565, 0.0288104938367954, 0.121539466824707, 0.246795034979453, 0.311071021960145, 0.267152788412702, 0.161050490828185, 0.0676190808506004, 0.0189641909985836, 0.00325836780863157, 0.0002911557949692, 9.72150406855002e-06, 5.46432237766702e-08, 2.87343827977604e-12, 1.74524006734735e-05, 0.00213834167863958, 0.0229880088868362, 0.0914773697859371, 0.199032816748895, 0.27579307649806, 0.259279900279373, 0.168005096401316, 0.0734802565690704, 0.0203701845898472, 0.00314201445765401, 0.000205593520872943, 2.94489562181094e-06, 8.32222853159274e-10, 1.50645935697317e-07, 9.91935690279492e-05, 0.0027174740353242, 0.0211919508015269, 0.0795920773441467, 0.177945506146943, 0.260888939018358, 0.260888939018358, 0.177945506146943, 0.0795920773441467, 0.0211919508015269, 0.0027174740353242, 9.91935690279486e-05, 1.50645935697317e-07, 8.32222853159274e-10, 2.94489562181096e-06, 0.000205593520872943, 0.003142014457654, 0.0203701845898472, 0.0734802565690704, 0.168005096401316, 0.259279900279373, 0.27579307649806, 0.199032816748896, 0.0914773697859372, 0.0229880088868362, 0.00213834167863957, 1.74524006734735e-05, 2.87343827977604e-12, 5.46432237766707e-08, 9.72150406855002e-06, 0.000291155794969199, 0.00325836780863156, 0.0189641909985836, 0.0676190808506003, 0.161050490828185, 0.267152788412702, 0.311071021960146, 0.246795034979453, 0.121539466824707, 0.0288104938367953, 0.00126366788397565, 5.66925589107604e-15, 5.79381564027075e-10, 2.62675429941451e-07, 1.5417169569149e-05, 0.000297829148409052, 0.00279679045402743, 0.0155517054219356, 0.0571632886049885, 0.147876109069939, 0.277815437054743, 0.380470613711269, 0.367193723071683, 0.221812621945459, 0.0522844654806429, 4.89359816106433e-18, 2.68763994729803e-12, 3.10515653659882e-09, 3.57159262200857e-07, 1.19100161484531e-05, 0.000180452787012712, 0.00156482161674821, 0.008876676978496, 0.035810829063663, 0.108550355329033, 0.25661608614036, 0.485345746375922, 0.747136348849164, 0.94643426275367, 

0.952967301317703, 0.774974377608438, 0.531819353588785, 0.3054216882714, 0.144913208634263, 0.0557492997051097, 0.0169303345614497, 0.00390625, 0.000647575146034186, 7.0904403443984e-05, 4.48377417677146e-06, 1.29948180410215e-07, 1.10099038086552e-09, 9.36212507421273e-13, 1.68801220711213e-18, 0.0460474074984276, 0.200741986647579, 0.349427071256235, 0.390479871390557, 0.316602929802121, 0.193813322770219, 0.0900707141726205, 0.03125, 0.00779026229015681, 0.00130529588996632, 0.000131345968913884, 6.5050613760708e-06, 1.07243526941048e-07, 2.3131486298078e-10, 2.2357764225946e-15, 0.000973442775840815, 0.0227492534408862, 0.10044469765901, 0.218411492764528, 0.302621614313074, 0.294785349293064, 0.209642692879317, 0.109375, 0.041000773080902, 0.0105129062364609, 0.00168332441722738, 0.00014246581003004, 4.5702158196876e-06, 2.50040694474896e-08, 1.29556503410423e-12, 1.17591957545558e-05, 0.00147318752155576, 0.0164990688517443, 0.0698094592492785, 0.16529012540668, 0.256206483097903, 0.278828912095263, 0.21875, 0.123308769011406, 0.0483836427482773, 0.0123276657041819, 0.00178291999801676, 0.000111292085721896, 1.54447116769969e-06, 4.28994788216568e-10, 8.87819809660387e-08, 5.96250740520746e-05, 0.00169383799816597, 0.0139454675066329, 0.0564253019793627, 0.139172795855556, 0.231779966762851, 0.2734375, 0.231779966762851, 0.139172795855556, 0.0564253019793627, 0.0139454675066329, 0.00169383799816598, 5.96250740520746e-05, 8.8781980966042e-08, 4.28994788216548e-10, 1.54447116769969e-06, 0.000111292085721895, 0.00178291999801676, 0.0123276657041819, 0.0483836427482773, 0.123308769011406, 0.21875, 0.278828912095263, 0.256206483097903, 0.16529012540668, 0.0698094592492784, 0.0164990688517443, 0.00147318752155576, 1.17591957545561e-05, 1.29556503410416e-12, 2.50040694474896e-08, 4.57021581968758e-06, 0.00014246581003004, 0.00168332441722738, 0.0105129062364609, 0.041000773080902, 0.109375, 0.209642692879317, 0.294785349293064, 0.302621614313074, 0.218411492764528, 0.10044469765901, 0.0227492534408862, 0.000973442775840833, 2.23577642259445e-15, 2.3131486298078e-10, 1.07243526941048e-07, 6.50506137607082e-06, 0.000131345968913884, 0.00130529588996632, 0.00779026229015681, 0.03125, 0.0900707141726205, 0.193813322770219, 0.316602929802121, 0.390479871390557, 0.349427071256236, 0.200741986647579, 0.0460474074984281, 1.68801220711201e-18, 9.36212507421273e-13, 1.10099038086551e-09, 1.29948180410216e-07, 4.48377417677146e-06, 7.0904403443984e-05, 0.000647575146034186, 0.00390625, 0.0169303345614497, 0.0557492997051097, 0.144913208634263, 0.3054216882714, 0.531819353588785, 0.774974377608438, 0.952967301317703, 

0.958381841294348, 0.798652140992959, 0.573279494479795, 0.352190398563234, 0.183367523871216, 0.0797737865498052, 0.0284308373363627, 0.00807444500085405, 0.00175752148131173, 0.000277123561316401, 2.9083507141679e-05, 1.77579297742401e-06, 5.00436569593344e-08, 4.15094980901703e-10, 3.47859767713221e-13, 6.22157701680893e-19, 0.0408482825559487, 0.182107765292965, 0.330315557631623, 0.392589734870213, 0.346474396264484, 0.23723213370546, 0.12749410738381, 0.0533858501168022, 0.0170124606517993, 0.0039550589713849, 0.000625912236653902, 6.01483311323599e-05, 2.87321142448458e-06, 4.61067844372625e-08, 9.76367628220708e-11, 9.34211545989131e-16, 0.000761705486994343, 0.0181667536578693, 0.0832663845306687, 0.191460163288022, 0.286416431985675, 0.308649004481535, 0.250131640903244, 0.154425032825364, 0.0720463001286848, 0.0246950854137472, 0.00589329478601122, 0.000891318430977544, 7.21712434948037e-05, 2.2405789160718e-06, 1.19894869237268e-08, 6.13716834987168e-13, 8.11637898813371e-06, 0.00103559069758117, 0.0119942290379559, 0.0533555819878182, 0.135296532146772, 0.229465921908779, 0.280420076166905, 0.255253198697407, 0.174348487213393, 0.0881109843663233, 0.0317077072479928, 0.00754751775859906, 0.00103591171153335, 6.22182234494792e-05, 8.41297844549318e-07, 2.30384254532216e-10, 5.40527219868804e-08, 3.68959733090542e-05, 0.00107982899571223, 0.00929311508060361, 0.0399443554181672, 0.10662315557662, 0.196485085896906, 0.263696703884384, 0.263696703884384, 0.196485085896906, 0.10662315557662, 0.0399443554181672, 0.00929311508060359, 0.00107982899571224, 3.68959733090542e-05, 5.40527219868781e-08, 2.30384254532228e-10, 8.41297844549318e-07, 6.2218223449479e-05, 0.00103591171153335, 0.00754751775859906, 0.0317077072479928, 0.0881109843663234, 0.174348487213393, 0.255253198697407, 0.280420076166905, 0.229465921908779, 0.135296532146772, 0.0533555819878182, 0.011994229037956, 0.00103559069758117, 8.11637898813346e-06, 6.13716834987206e-13, 1.19894869237268e-08, 2.24057891607179e-06, 7.21712434948039e-05, 0.000891318430977544, 0.00589329478601122, 0.0246950854137472, 0.0720463001286848, 0.154425032825364, 0.250131640903244, 0.308649004481535, 0.286416431985674, 0.191460163288022, 0.0832663845306688, 0.0181667536578693, 0.000761705486994326, 9.34211545989199e-16, 9.76367628220708e-11, 4.61067844372622e-08, 2.87321142448459e-06, 6.01483311323599e-05, 0.000625912236653902, 0.0039550589713849, 0.0170124606517993, 0.0533858501168022, 0.12749410738381, 0.23723213370546, 0.346474396264484, 0.392589734870212, 0.330315557631623, 0.182107765292965, 0.0408482825559482, 6.22157701680946e-19, 3.47859767713221e-13, 4.15094980901701e-10, 5.00436569593346e-08, 1.77579297742401e-06, 2.9083507141679e-05, 0.000277123561316401, 0.00175752148131173, 0.00807444500085404, 0.0284308373363627, 0.0797737865498052, 0.183367523871216, 0.352190398563234, 0.573279494479795, 0.798652140992959, 0.958381841294348, 

0.96291782758848, 0.818917795111741, 0.61018955814276, 0.396345524976371, 0.222713778885278, 0.107092918827516, 0.0434109010178495, 0.0145328266905549, 0.00390625, 0.000810377691703877, 0.000122596102984312, 1.24222079130953e-05, 7.36729313693712e-07, 2.02837795961415e-08, 1.65302295490691e-10, 1.36854799750696e-13, 2.43128396178896e-19, 0.0364720371524205, 0.16565622527126, 0.3109256297542, 0.388864512481369, 0.367944386693893, 0.275997721813975, 0.166743349065387, 0.0810461248531386, 0.03125, 0.00930005016774062, 0.00204271096020328, 0.00030848498196629, 2.85399251238108e-05, 1.32313605620432e-06, 2.07619005947242e-08, 4.3298470452541e-11, 4.10813649648833e-16, 0.000604378314506097, 0.0146606515287996, 0.0693148569198388, 0.166917057965824, 0.265947145996121, 0.31119190872014, 0.280205269067622, 0.197739062808478, 0.109375, 0.0466940090139075, 0.0148907039852441, 0.00335156244642387, 0.000483699641826617, 3.77605388597257e-05, 1.14086271653831e-06, 5.99326020562179e-09, 3.03691126204179e-13, 5.72294636915894e-06, 0.000741413914429252, 0.00882994687942566, 0.040941625602165, 0.109842507293789, 0.20049938593987, 0.269070463262743, 0.275685954184228, 0.21875, 0.133967355841576, 0.0620276735870083, 0.0208076271158292, 0.00468447206577589, 0.000615791675192914, 3.58229724558322e-05, 4.74040735875223e-07, 1.28286598647761e-10, 3.38696334296785e-08, 2.34340963389945e-05, 0.000703023541400072, 0.00627638334038282, 0.0283547327688799, 0.0807379679463675, 0.161486332950958, 0.240224238748673, 0.2734375, 0.240224238748673, 0.161486332950958, 0.0807379679463675, 0.0283547327688799, 0.0062763833403828, 0.000703023541400072, 2.34340963389943e-05, 3.38696334296801e-08, 1.28286598647753e-10, 4.74040735875228e-07, 3.58229724558322e-05, 0.000615791675192916, 0.0046844720657759, 0.0208076271158292, 0.0620276735870083, 0.133967355841576, 0.21875, 0.275685954184228, 0.269070463262743, 0.20049938593987, 0.109842507293789, 0.040941625602165, 0.00882994687942566, 0.000741413914429247, 5.72294636915914e-06, 3.03691126204158e-13, 5.99326020562187e-09, 1.14086271653831e-06, 3.77605388597258e-05, 0.000483699641826618, 0.00335156244642388, 0.0148907039852441, 0.0466940090139074, 0.109375, 0.197739062808478, 0.280205269067622, 0.31119190872014, 0.265947145996121, 0.166917057965823, 0.0693148569198388, 0.0146606515287995, 0.000604378314506111, 4.10813649648799e-16, 4.32984704525417e-11, 2.07619005947242e-08, 1.32313605620432e-06, 2.85399251238109e-05, 0.000308484981966291, 0.00204271096020328, 0.00930005016774062, 0.03125, 0.0810461248531386, 0.166743349065387, 0.275997721813975, 0.367944386693892, 0.388864512481369, 0.3109256297542, 0.16565622527126, 0.0364720371524209, 2.43128396178873e-19, 1.36854799750699e-13, 1.65302295490691e-10, 2.02837795961416e-08, 7.36729313693714e-07, 1.24222079130954e-05, 0.000122596102984312, 0.000810377691703877, 0.00390625, 0.0145328266905549, 0.0434109010178495, 0.107092918827516, 0.222713778885278, 0.396345524976371, 0.61018955814276, 0.818917795111741, 0.96291782758848, 

0.966754519686593, 0.83636935887209, 0.64303594268099, 0.437606766916381, 0.262011418604361, 0.136850500531849, 0.0616346968646651, 0.0235656228342258, 0.00748992413327123, 0.00192301637543174, 0.000383266837562394, 5.60078190550855e-05, 5.51049425149786e-06, 3.18929172733807e-07, 8.61062469682906e-09, 6.91376309843516e-11, 5.66572009504783e-14, 1.00085544730261e-19, 0.0327557909975925, 0.151128101207955, 0.291917506903224, 0.38099374440789, 0.38201635723697, 0.308997095809359, 0.205455691251766, 0.112660506558125, 0.0505540089679615, 0.0182341185475834, 0.00513083962558723, 0.00107531504930661, 0.000156193343012776, 1.3999498549089e-05, 6.32966635702135e-07, 9.74696879241116e-09, 2.00672553493609e-11, 1.89051205472177e-16, 0.000485554550961691, 0.011947317229455, 0.0579779815037575, 0.145120818187063, 0.243681049717623, 0.305239309471316, 0.299632656710999, 0.235636484102641, 0.149283511094421, 0.0756422820999364, 0.0300506378298502, 0.00903235178075781, 0.00193692383813992, 0.000268849213765453, 2.0356590201996e-05, 6.01177494634018e-07, 3.10955967810144e-09, 1.56230420628952e-13, 4.11291673981186e-06, 0.000539706335563146, 0.0065800318040132, 0.0315866481580201, 0.088822604980982, 0.172301269975151, 0.249702025554433, 0.281627668503879, 0.251901081518033, 0.179310789632554, 0.100572883067704, 0.043353874353363, 0.0137253844951375, 0.00295030566330049, 0.000374103008439953, 2.11883824896458e-05, 2.75341558697365e-07, 7.37757621016341e-11, 2.17741807732012e-08, 1.52378836945538e-05, 0.000466737731924782, 0.00429692115474295, 0.0202350961552761, 0.0607878120417839, 0.130057380615653, 0.210372090640425, 0.265661267630807, 0.265661267630807, 0.210372090640425, 0.130057380615653, 0.0607878120417839, 0.0202350961552761, 0.00429692115474296, 0.000466737731924782, 1.52378836945538e-05, 2.17741807732012e-08, 7.37757621016341e-11, 2.75341558697365e-07, 2.11883824896458e-05, 0.000374103008439952, 0.00295030566330049, 0.0137253844951375, 0.043353874353363, 0.100572883067704, 0.179310789632554, 0.251901081518033, 0.281627668503879, 0.249702025554433, 0.172301269975151, 0.088822604980982, 0.0315866481580202, 0.0065800318040132, 0.000539706335563146, 4.11291673981186e-06, 1.56230420628952e-13, 3.10955967810144e-09, 6.01177494634018e-07, 2.03565902019959e-05, 0.000268849213765453, 0.00193692383813992, 0.00903235178075781, 0.0300506378298502, 0.0756422820999364, 0.149283511094421, 0.235636484102641, 0.299632656710999, 0.305239309471316, 0.243681049717623, 0.145120818187063, 0.0579779815037575, 0.011947317229455, 0.000485554550961691, 1.89051205472177e-16, 2.00672553493609e-11, 9.74696879241116e-09, 6.32966635702133e-07, 1.3999498549089e-05, 0.000156193343012776, 0.00107531504930661, 0.00513083962558723, 0.0182341185475834, 0.0505540089679615, 0.112660506558125, 0.205455691251766, 0.308997095809359, 0.38201635723697, 0.38099374440789, 0.291917506903224, 0.151128101207955, 0.0327557909975925, 1.00085544730261e-19, 5.66572009504783e-14, 6.91376309843516e-11, 8.61062469682902e-09, 3.18929172733807e-07, 5.51049425149786e-06, 5.60078190550855e-05, 0.000383266837562394, 0.00192301637543174, 0.00748992413327123, 0.0235656228342258, 0.0616346968646651, 0.136850500531849, 0.262011418604361, 0.437606766916381, 0.64303594268099, 0.83636935887209, 0.966754519686593, 

0.970027917478441, 0.851486100039221, 0.672287391886562, 0.475893223714319, 0.300565213623944, 0.168230140729627, 0.0826880717444693, 0.0352611200560505, 0.0128380178253708, 0.00390625, 0.000964962860604875, 0.000185926947306552, 2.63861988767406e-05, 2.53221325473761e-06, 1.43553843652434e-07, 3.81191053588978e-09, 3.0223534028936e-11, 2.45534709954659e-14, 4.31656898564682e-20, 0.0295745760009045, 0.138280030373987, 0.27368042672591, 0.37029995151573, 0.389864073435329, 0.3358871225508, 0.241838030491297, 0.146433981132939, 0.0743172343460537, 0.03125, 0.0106683930438692, 0.00286534253206903, 0.000577397730565732, 8.11690954207405e-05, 7.08304985232172e-06, 3.13529593251699e-07, 4.75156251024292e-09, 9.67633655448239e-12, 9.06117183607098e-17, 0.000394485348637467, 0.00982470292200377, 0.048742810565251, 0.126059577392731, 0.221241082230723, 0.293400572514468, 0.30944565393946, 0.26605148881845, 0.188217136456613, 0.109375, 0.0516018739875343, 0.0193191854432446, 0.0055277879018754, 0.00113830643691007, 0.000152898712748682, 1.12821647182135e-05, 3.26817803367058e-07, 1.66834972113087e-09, 8.32162429250392e-14, 3.00680442137414e-06, 0.000398879153284916, 0.00496065869905865, 0.0245222316007613, 0.0717431239711161, 0.146450382834528, 0.226259138452506, 0.276217677090962, 0.272389733918781, 0.21875, 0.142624420061655, 0.0744325722244388, 0.0302405454883942, 0.0091219907745458, 0.00188603310298123, 0.000231989476261046, 1.28450830789023e-05, 1.64370990513115e-07, 4.36710660250815e-11, 1.43238412713263e-08, 1.01214624622997e-05, 0.00031553544054979, 0.00298142679397504, 0.0145403483194615, 0.0456877828504458, 0.103396988052556, 0.179232705754539, 0.246378227499518, 0.2734375, 0.246378227499518, 0.17923270575454, 0.103396988052556, 0.0456877828504457, 0.0145403483194615, 0.00298142679397504, 0.00031553544054979, 1.01214624622997e-05, 1.43238412713263e-08, 4.36710660250815e-11, 1.64370990513115e-07, 1.28450830789023e-05, 0.000231989476261046, 0.00188603310298122, 0.00912199077454581, 0.0302405454883942, 0.0744325722244387, 0.142624420061655, 0.21875, 0.272389733918781, 0.276217677090962, 0.226259138452506, 0.146450382834528, 0.0717431239711162, 0.0245222316007613, 0.00496065869905865, 0.000398879153284916, 3.00680442137414e-06, 8.32162429250392e-14, 1.66834972113087e-09, 3.26817803367058e-07, 1.12821647182135e-05, 0.000152898712748681, 0.00113830643691007, 0.0055277879018754, 0.0193191854432445, 0.0516018739875343, 0.109375, 0.188217136456613, 0.26605148881845, 0.30944565393946, 0.293400572514468, 0.221241082230723, 0.126059577392731, 0.048742810565251, 0.00982470292200377, 0.000394485348637467, 9.06117183607098e-17, 9.67633655448239e-12, 4.75156251024292e-09, 3.13529593251699e-07, 7.0830498523217e-06, 8.11690954207407e-05, 0.000577397730565732, 0.00286534253206902, 0.0106683930438692, 0.03125, 0.0743172343460537, 0.146433981132939, 0.241838030491297, 0.3358871225508, 0.38986407343533, 0.37029995151573, 0.27368042672591, 0.138280030373987, 0.0295745760009045, 4.31656898564682e-20, 2.45534709954659e-14, 3.0223534028936e-11, 3.81191053588978e-09, 1.43553843652434e-07, 2.53221325473762e-06, 2.63861988767406e-05, 0.000185926947306552, 0.000964962860604875, 0.00390625, 0.0128380178253708, 0.0352611200560505, 0.0826880717444693, 0.168230140729627, 0.300565213623944, 0.475893223714319, 0.672287391886562, 0.851486100039221, 0.970027917478441, 

0.972842648423601, 0.864653772647492, 0.698375666930653, 0.511251802481283, 0.337889227344956, 0.20051202762073, 0.106064469359798, 0.0495348235353043, 0.0201716316598053, 0.00704624764516319, 0.00206611958610135, 0.000493926209843846, 9.24667410561284e-05, 1.2798990988485e-05, 1.20242691010243e-06, 6.69710016143271e-08, 1.75324210192132e-09, 1.3751609324081e-11, 1.10888952301006e-14, 1.94143248056743e-20, 0.0268313515540759, 0.126893092788945, 0.256426048178961, 0.357787957611164, 0.39264799920875, 0.356837261673332, 0.274701250698921, 0.180669554464756, 0.101495350243867, 0.0483556898829199, 0.0192684041820155, 0.00628256410842356, 0.00162252415875406, 0.000316275094420418, 4.32423105914018e-05, 3.6883975527122e-06, 1.60335982825667e-07, 2.39695819391885e-09, 4.83584655875148e-12, 4.50507802369755e-17, 0.000323758034745832, 0.00814726386361046, 0.0411920339839869, 0.109545525552668, 0.199622959175587, 0.277829287164886, 0.31126436775742, 0.288295181886796, 0.223423742015515, 0.145182851503305, 0.0786165711175802, 0.0349614827236179, 0.0124558924577257, 0.00341926146797662, 0.000680357464298382, 8.88723601003313e-05, 6.41502218673564e-06, 1.82787061208428e-07, 9.22645359285686e-10, 4.57362338824729e-14, 2.23234087824953e-06, 0.000298914878453499, 0.00378117071911674, 0.0191657367576546, 0.0579935295158162, 0.123608348113779, 0.2015394779163, 0.26287648944939, 0.281044083729802, 0.249083529885262, 0.183292375461683, 0.111174377953193, 0.0546412315408488, 0.0211232909806198, 0.00611684347239514, 0.00122365123559573, 0.000146665267453873, 7.96512127745399e-06, 1.00590980730396e-07, 2.65326381696259e-11, 9.62011993118581e-09, 6.85430302558e-06, 0.000216929868234106, 0.00209573521836309, 0.0105300057906402, 0.0343714297530784, 0.0815588077335555, 0.149811835765369, 0.220952841355931, 0.26708821073597, 0.26708821073597, 0.220952841355931, 0.149811835765369, 0.0815588077335555, 0.0343714297530784, 0.0105300057906402, 0.00209573521836309, 0.000216929868234106, 6.85430302558008e-06, 9.62011993118643e-09, 2.65326381696238e-11, 1.00590980730394e-07, 7.96512127745399e-06, 0.000146665267453872, 0.00122365123559573, 0.00611684347239515, 0.0211232909806198, 0.0546412315408488, 0.111174377953193, 0.183292375461683, 0.249083529885262, 0.281044083729802, 0.26287648944939, 0.2015394779163, 0.123608348113779, 0.0579935295158162, 0.0191657367576547, 0.00378117071911674, 0.000298914878453502, 2.23234087824964e-06, 4.57362338824684e-14, 9.22645359285669e-10, 1.82787061208428e-07, 6.41502218673562e-06, 8.88723601003313e-05, 0.000680357464298383, 0.00341926146797662, 0.0124558924577257, 0.0349614827236179, 0.0786165711175802, 0.145182851503305, 0.223423742015515, 0.288295181886796, 0.31126436775742, 0.277829287164885, 0.199622959175587, 0.109545525552668, 0.0411920339839869, 0.00814726386361051, 0.000323758034745843, 4.50507802369704e-17, 4.83584655875137e-12, 2.39695819391885e-09, 1.60335982825666e-07, 3.6883975527122e-06, 4.32423105914019e-05, 0.000316275094420418, 0.00162252415875406, 0.00628256410842356, 0.0192684041820155, 0.0483556898829199, 0.101495350243867, 0.180669554464756, 0.274701250698921, 0.356837261673332, 0.39264799920875, 0.357787957611165, 0.256426048178961, 0.126893092788945, 0.0268313515540764, 1.94143248056718e-20, 1.10888952301003e-14, 1.3751609324081e-11, 1.75324210192131e-09, 6.69710016143271e-08, 1.20242691010243e-06, 1.2798990988485e-05, 9.24667410561284e-05, 0.000493926209843846, 0.00206611958610135, 0.00704624764516319, 0.0201716316598053, 0.0495348235353043, 0.106064469359798, 0.20051202762073, 0.337889227344956, 0.511251802481283, 0.698375666930653, 0.864653772647492, 0.972842648423601, 

0.975280229530664, 0.876184489616517, 0.72168821064246, 0.543806791725869, 0.373665153738048, 0.233095621910536, 0.131232190890892, 0.0661720475422446, 0.0295899642242764, 0.0115853293479172, 0.00390625, 0.00110969867121686, 0.0002579264984758, 4.71059389740312e-05, 6.38173720241994e-06, 5.88661167017507e-07, 3.22900643016741e-08, 8.35025872697622e-10, 6.48878258416976e-12, 5.19884336129344e-15, 9.06970836537649e-21, 0.0244499173416097, 0.11677488395727, 0.240251605906224, 0.344204486952726, 0.391422580057019, 0.372319268198386, 0.303384007256306, 0.213951185178198, 0.130851398121675, 0.0691290289809489, 0.03125, 0.011902356874394, 0.00373286263811167, 0.000932428448880945, 0.000176671536478127, 2.35865252287576e-05, 1.97281157807321e-06, 8.44321806233103e-08, 1.24745965374191e-09, 2.49650720099869e-12, 2.31539623016907e-17, 0.000268165822971631, 0.00680896944321159, 0.0349913779442189, 0.0953161484105267, 0.179385447525785, 0.260180632724115, 0.306847821901761, 0.302644563844657, 0.253157239867596, 0.180464002847683, 0.109375, 0.0558520254123703, 0.023635571786312, 0.00807483066165601, 0.00213979571393139, 0.000413466759908156, 5.27327431193858e-05, 3.73503036741543e-06, 1.04922311819442e-07, 5.24489708582191e-10, 2.58604083553203e-14, 1.68070468542575e-06, 0.00022686906297201, 0.00291217683065876, 0.0150826757136631, 0.0469775639986817, 0.103895412085877, 0.177343533614827, 0.24463185562214, 0.27987511686582, 0.269204718058324, 0.21875, 0.149763795311836, 0.0855169431726772, 0.0399588777594208, 0.0148094862158464, 0.00414170524158949, 0.000805447189556164, 9.44152657199656e-05, 5.0427930460868e-06, 6.29655599971458e-08, 1.65046905601512e-11, 6.58353898417659e-09, 4.72442747789019e-06, 0.000151479707132162, 0.00149166163392204, 0.00768906964614919, 0.0259297178931932, 0.064060111132756, 0.123587105003828, 0.193382976825055, 0.250989044495309, 0.2734375, 0.250989044495309, 0.193382976825055, 0.123587105003828, 0.064060111132756, 0.0259297178931932, 0.00768906964614919, 0.00149166163392204, 0.000151479707132161, 4.72442747789025e-06, 6.58353898417612e-09, 1.65046905601527e-11, 6.29655599971447e-08, 5.04279304608684e-06, 9.44152657199656e-05, 0.000805447189556164, 0.00414170524158949, 0.0148094862158464, 0.0399588777594208, 0.0855169431726772, 0.149763795311836, 0.21875, 0.269204718058324, 0.27987511686582, 0.24463185562214, 0.177343533614827, 0.103895412085877, 0.0469775639986817, 0.0150826757136631, 0.00291217683065875, 0.000226869062972012, 1.68070468542566e-06, 2.58604083553231e-14, 5.2448970858218e-10, 1.04922311819443e-07, 3.73503036741543e-06, 5.27327431193858e-05, 0.000413466759908156, 0.00213979571393139, 0.008074830661656, 0.023635571786312, 0.0558520254123703, 0.109375, 0.180464002847683, 0.253157239867596, 0.302644563844657, 0.306847821901761, 0.260180632724115, 0.179385447525785, 0.0953161484105267, 0.0349913779442188, 0.00680896944321164, 0.000268165822971622, 2.31539623016936e-17, 2.49650720099863e-12, 1.24745965374192e-09, 8.44321806233103e-08, 1.97281157807321e-06, 2.35865252287576e-05, 0.000176671536478127, 0.000932428448880943, 0.00373286263811167, 0.011902356874394, 0.03125, 0.0691290289809489, 0.130851398121675, 0.213951185178198, 0.303384007256306, 0.372319268198386, 0.391422580057019, 0.344204486952726, 0.240251605906224, 0.11677488395727, 0.0244499173416093, 9.06970836537778e-21, 5.1988433612933e-15, 6.48878258416983e-12, 8.35025872697622e-10, 3.22900643016741e-08, 5.88661167017507e-07, 6.38173720241994e-06, 4.71059389740312e-05, 0.0002579264984758, 0.00110969867121686, 0.00390625, 0.0115853293479172, 0.0295899642242764, 0.0661720475422446, 0.131232190890892, 0.233095621910536, 0.373665153738048, 0.543806791725869, 0.72168821064246, 0.876184489616517, 0.975280229530664, 

0.977404908789797, 0.886332222442529, 0.742567285184163, 0.573725516807242, 0.407703235783672, 0.265501210051669, 0.157680204965298, 0.08487423977963, 0.041078445597656, 0.0176967720100195, 0.00669859247786867, 0.00219077374061691, 0.000605583056299944, 0.00013737447448127, 2.45576700274951e-05, 3.26564432798095e-06, 2.96479452575759e-07, 1.60489969900202e-08, 4.1063363222043e-10, 3.16518929060632e-12, 2.52183478843118e-15, 4.38588921605081e-21, 0.0223698151588167, 0.107758499889738, 0.225182057681531, 0.330094240400146, 0.387099056198032, 0.382954787904813, 0.327635631095374, 0.245212323278107, 0.161153778953633, 0.0928472404213051, 0.0466015423504767, 0.020153977413697, 0.00738718108193503, 0.00224109117663931, 0.000544002303695965, 0.000100585390473339, 1.31550824735183e-05, 1.08180731920008e-06, 4.56773299801441e-08, 6.68008040873262e-10, 1.32752163250985e-12, 1.22644972968921e-17, 0.000223989846747249, 0.00573171506908331, 0.0298751305768698, 0.08309019627779, 0.160797067435223, 0.241660995362026, 0.297840075862812, 0.309946505489309, 0.276595457563439, 0.213118917756569, 0.141838810693517, 0.0811151668252038, 0.0394241040088532, 0.0159952511951498, 0.00527220605279903, 0.00135543590949833, 0.000255370429904819, 3.19028875146301e-05, 2.22292576837764e-06, 6.16796286080289e-08, 3.05734634413383e-10, 1.5004443878863e-14, 1.28161098438509e-06, 0.000174212615202499, 0.00226489353592231, 0.0119515318830725, 0.0381677085073549, 0.0871420088873798, 0.15471666408964, 0.22386858162235, 0.271276107087539, 0.279535490767317, 0.24669015786949, 0.186554322086574, 0.120228345342853, 0.0652355840794623, 0.0291975199099846, 0.0104372243672023, 0.00283275876077558, 0.000537615796775412, 6.18174607949826e-05, 3.25434627168436e-06, 4.02355204683874e-08, 1.04894328338384e-11, 4.58315058458304e-09, 3.30944086214713e-06, 0.000107316324439647, 0.00107442815722323, 0.00566231553511256, 0.0196394170415053, 0.0502309126753737, 0.101060063894097, 0.166286909872, 0.229156365554849, 0.268156656542556, 0.268156656542556, 0.229156365554849, 0.166286909872, 0.101060063894097, 0.0502309126753737, 0.0196394170415053, 0.00566231553511255, 0.00107442815722322, 0.000107316324439647, 3.30944086214713e-06, 4.58315058458304e-09, 1.04894328338384e-11, 4.02355204683874e-08, 3.25434627168434e-06, 6.18174607949829e-05, 0.000537615796775413, 0.00283275876077558, 0.0104372243672023, 0.0291975199099846, 0.0652355840794623, 0.120228345342853, 0.186554322086574, 0.24669015786949, 0.279535490767317, 0.271276107087539, 0.22386858162235, 0.15471666408964, 0.0871420088873798, 0.0381677085073548, 0.0119515318830725, 0.00226489353592232, 0.000174212615202499, 1.28161098438509e-06, 1.5004443878863e-14, 3.05734634413383e-10, 6.16796286080284e-08, 2.22292576837765e-06, 3.19028875146302e-05, 0.000255370429904819, 0.00135543590949833, 0.00527220605279903, 0.0159952511951498, 0.0394241040088532, 0.0811151668252038, 0.141838810693517, 0.213118917756569, 0.276595457563439, 0.309946505489309, 0.297840075862812, 0.241660995362026, 0.160797067435223, 0.0830901962777899, 0.0298751305768699, 0.00573171506908331, 0.000223989846747249, 1.22644972968921e-17, 1.32752163250985e-12, 6.68008040873255e-10, 4.56773299801444e-08, 1.08180731920008e-06, 1.31550824735183e-05, 0.000100585390473339, 0.000544002303695965, 0.00224109117663931, 0.00738718108193502, 0.020153977413697, 0.0466015423504767, 0.0928472404213051, 0.161153778953633, 0.245212323278107, 0.327635631095374, 0.382954787904813, 0.387099056198032, 0.330094240400145, 0.225182057681531, 0.107758499889738, 0.0223698151588167, 4.38588921605081e-21, 2.52183478843118e-15, 3.16518929060628e-12, 4.10633632220432e-10, 1.60489969900203e-08, 2.96479452575759e-07, 3.26564432798095e-06, 2.45576700274951e-05, 0.00013737447448127, 0.000605583056299944, 0.00219077374061691, 0.00669859247786867, 0.0176967720100195, 0.041078445597656, 0.08487423977963, 0.157680204965298, 0.265501210051669, 0.407703235783672, 0.573725516807242, 0.742567285184163, 0.886332222442529, 0.977404908789797, 

0.979267860481196, 0.895304850987842, 0.761312390832218, 0.601195604616849, 0.439909020801398, 0.297359997920204, 0.184945327987176, 0.10530000093907, 0.0545294115206056, 0.0254747278118643, 0.0106264151457423, 0.00390625, 0.00124418076276625, 0.000335847404102693, 7.45905277073675e-05, 1.30876496424839e-05, 1.71235536999654e-06, 1.53318678005907e-07, 8.20398256182067e-09, 2.07964391261829e-10, 1.5916862188904e-12, 1.2619775085405e-15, 2.1888464034888e-21, 0.0205426142701251, 0.0997001953499298, 0.211197953207519, 0.315847491164948, 0.380439486957168, 0.389414032425809, 0.347497887449246, 0.273730078977488, 0.191305478117369, 0.118632476028865, 0.0650187855904253, 0.03125, 0.0130140173430221, 0.00461559747804944, 0.00136071464204241, 0.00032221628542494, 5.83263863357313e-05, 7.49283187175758e-06, 6.07130405194534e-07, 2.53342072114187e-08, 3.6720672255909e-10, 7.25281361798432e-13, 6.67791752315367e-18, 0.000188533260827283, 0.00485734709474422, 0.0256327126545915, 0.0725967408073652, 0.143941612746421, 0.223109830671423, 0.285653158176301, 0.3113111872517, 0.293631104939577, 0.241699468068733, 0.1740479794439, 0.109375, 0.0595548777612637, 0.0277518485206967, 0.0108599667057658, 0.00347065440512793, 0.000869189152342216, 0.000160204594492494, 1.96570025818132e-05, 1.35021744526725e-06, 3.70631090964228e-08, 1.82364154248274e-10, 8.91343028411979e-15, 9.88740213622614e-07, 0.000135227250721941, 0.00177771191990203, 0.00953495762222498, 0.0311206810474558, 0.0730445415012691, 0.134180016994472, 0.202315373012892, 0.257536425546103, 0.281390703794873, 0.266232499453116, 0.21875, 0.155734647898638, 0.0953493762930582, 0.0495281242901337, 0.0213617685559044, 0.00740159770375841, 0.00195733831524609, 0.000363675929723018, 4.11208480587987e-05, 2.13764224657219e-06, 2.6201996715729e-08, 6.79846153102135e-12, 3.24083137155998e-09, 2.35293167509086e-06, 7.70563116150444e-05, 0.000782709180936833, 0.00420525018086524, 0.0149464084210062, 0.0393927837949999, 0.0821756329227496, 0.141174183710696, 0.204749954599758, 0.254526596601126, 0.2734375, 0.254526596601126, 0.204749954599758, 0.141174183710696, 0.0821756329227497, 0.0393927837949998, 0.0149464084210063, 0.00420525018086524, 0.000782709180936833, 7.70563116150449e-05, 2.35293167509086e-06, 3.2408313715597e-09, 6.79846153102207e-12, 2.6201996715729e-08, 2.13764224657217e-06, 4.11208480587987e-05, 0.000363675929723018, 0.00195733831524609, 0.00740159770375842, 0.0213617685559044, 0.0495281242901337, 0.0953493762930582, 0.155734647898638, 0.21875, 0.266232499453116, 0.281390703794873, 0.257536425546103, 0.202315373012892, 0.134180016994471, 0.0730445415012692, 0.0311206810474558, 0.00953495762222498, 0.00177771191990203, 0.000135227250721941, 9.88740213622551e-07, 8.91343028412093e-15, 1.82364154248274e-10, 3.70631090964225e-08, 1.35021744526725e-06, 1.96570025818132e-05, 0.000160204594492493, 0.000869189152342218, 0.00347065440512793, 0.0108599667057658, 0.0277518485206967, 0.0595548777612637, 0.109375, 0.1740479794439, 0.241699468068733, 0.293631104939577, 0.3113111872517, 0.285653158176301, 0.223109830671424, 0.143941612746421, 0.0725967408073652, 0.0256327126545915, 0.00485734709474422, 0.000188533260827275, 6.67791752315466e-18, 7.25281361798432e-13, 3.67206722559086e-10, 2.53342072114187e-08, 6.07130405194534e-07, 7.49283187175756e-06, 5.83263863357314e-05, 0.00032221628542494, 0.00136071464204241, 0.00461559747804944, 0.0130140173430221, 0.03125, 0.0650187855904253, 0.118632476028865, 0.191305478117369, 0.273730078977488, 0.347497887449245, 0.389414032425809, 0.380439486957168, 0.315847491164948, 0.211197953207519, 0.0997001953499298, 0.0205426142701246, 2.18884640348917e-21, 1.2619775085405e-15, 1.59168621889038e-12, 2.07964391261829e-10, 8.20398256182067e-09, 1.53318678005906e-07, 1.71235536999654e-06, 1.30876496424839e-05, 7.45905277073675e-05, 0.000335847404102693, 0.00124418076276625, 0.00390625, 0.0106264151457423, 0.0254747278118643, 0.0545294115206056, 0.10530000093907, 0.184945327987176, 0.297359997920204, 0.439909020801398, 0.601195604616849, 0.761312390832218, 0.895304850987842, 0.979267860481196, 

0.980910241946381, 0.903273535042967, 0.778184158367112, 0.626410363346187, 0.470256632726424, 0.32839912584075, 0.21262539204281, 0.127097078971741, 0.0697674598078105, 0.0349364537337338, 0.0158270825127816, 0.00641916929678917, 0.00230014723454175, 0.000715875794696415, 0.00018926404871408, 4.12628093846338e-05, 7.1224823758249e-06, 9.18706616325978e-07, 8.12618792329773e-08, 4.30429216060754e-09, 1.0822105752295e-10, 8.23140632407526e-13, 6.49831116028683e-16, 1.12441884437828e-21, 0.018929171758283, 0.0924766151354235, 0.198253712818775, 0.301738360318288, 0.372066670808874, 0.392353551434014, 0.363203754259059, 0.29908011099563, 0.220409918106139, 0.145576900886023, 0.0859845563839051, 0.0451703460382816, 0.0209199683258416, 0.00843330997885779, 0.00290692916960963, 0.000835911972030511, 0.000193713279451504, 3.44208520407407e-05, 4.35302578613607e-06, 3.48173631710485e-07, 1.43787176451866e-08, 2.06783113582014e-10, 4.06226113529142e-13, 3.72911474339369e-18, 0.00015981296611841, 0.00414211947612643, 0.0220972551585927, 0.0635887335109394, 0.128790747600595, 0.205083745750959, 0.271433588223909, 0.307905576301308, 0.304640341046584, 0.265389769579365, 0.204370449804804, 0.139061228838351, 0.0832423756747535, 0.0434646820095063, 0.0195334444066987, 0.00740867176737405, 0.00230497097597744, 0.000564214763933625, 0.000102017264825887, 1.23216273586071e-05, 8.3580813716238e-07, 2.27265837584815e-08, 1.1109978795821e-10, 5.41079942499078e-15, 7.70999974180466e-07, 0.0001060169410976, 0.00140739914555936, 0.00765758411219946, 0.0254747840625442, 0.0612557476978479, 0.115914775427059, 0.181137982637751, 0.240605551667179, 0.276463522003917, 0.277573305918098, 0.244636164615526, 0.189273520878609, 0.128007937701713, 0.0750041274539168, 0.0375216661174474, 0.0156723268390472, 0.00528480816493593, 0.00136621189606314, 0.000249173707659285, 2.77622707744716e-05, 1.42729977285783e-06, 1.73628324202096e-08, 4.48620458696506e-12, 2.32475254755706e-09, 1.6959300462711e-06, 5.60242759990201e-05, 0.000576346146535945, 0.00314931698862125, 0.0114351658278751, 0.030938127559636, 0.0666011175167186, 0.118769216706051, 0.179999588718022, 0.235622799895638, 0.268977079097306, 0.268977079097306, 0.235622799895638, 0.179999588718022, 0.118769216706051, 0.0666011175167186, 0.030938127559636, 0.0114351658278751, 0.00314931698862125, 0.000576346146535945, 5.60242759990197e-05, 1.6959300462711e-06, 2.32475254755685e-09, 4.48620458696557e-12, 1.73628324202096e-08, 1.42729977285784e-06, 2.77622707744716e-05, 0.000249173707659285, 0.00136621189606314, 0.00528480816493593, 0.0156723268390472, 0.0375216661174474, 0.0750041274539168, 0.128007937701713, 0.189273520878609, 0.244636164615526, 0.277573305918098, 0.276463522003917, 0.240605551667179, 0.181137982637751, 0.115914775427059, 0.0612557476978478, 0.0254747840625442, 0.00765758411219946, 0.00140739914555936, 0.0001060169410976, 7.70999974180413e-07, 5.41079942499153e-15, 1.1109978795821e-10, 2.27265837584818e-08, 8.3580813716238e-07, 1.23216273586071e-05, 0.000102017264825887, 0.000564214763933625, 0.00230497097597744, 0.00740867176737405, 0.0195334444066987, 0.0434646820095063, 0.0832423756747535, 0.139061228838351, 0.204370449804804, 0.265389769579365, 0.304640341046584, 0.307905576301307, 0.271433588223909, 0.205083745750959, 0.128790747600595, 0.0635887335109394, 0.0220972551585926, 0.00414211947612643, 0.000159812966118403, 3.72911474339429e-18, 4.06226113529142e-13, 2.06783113582017e-10, 1.43787176451866e-08, 3.48173631710485e-07, 4.35302578613608e-06, 3.44208520407407e-05, 0.000193713279451505, 0.000835911972030511, 0.00290692916960963, 0.00843330997885779, 0.0209199683258416, 0.0451703460382816, 0.0859845563839051, 0.145576900886023, 0.220409918106139, 0.29908011099563, 0.363203754259059, 0.392353551434014, 0.372066670808874, 0.301738360318288, 0.198253712818774, 0.0924766151354235, 0.0189291717582826, 1.12441884437849e-21, 6.49831116028683e-16, 8.23140632407538e-13, 1.0822105752295e-10, 4.30429216060754e-09, 8.12618792329776e-08, 9.18706616325978e-07, 7.12248237582492e-06, 4.12628093846338e-05, 0.00018926404871408, 0.000715875794696415, 0.00230014723454175, 0.00641916929678917, 0.0158270825127816, 0.0349364537337338, 0.0697674598078105, 0.127097078971741, 0.21262539204281, 0.32839912584075, 0.470256632726424, 0.626410363346187, 0.778184158367112, 0.903273535042967, 0.980910241946381, 

0.001953125, 0.017578125, 0.0703125, 0.1640625, 0.24609375, 0.24609375, 0.1640625, 0.0703125, 0.017578125, 0.001953125, 

0.118054715021316, 8.40534239649844e-07, 0.284693989973831, 2.82322483908705e-05, 0.305134098813929, 0.000421456741626533, 0.190774349174245, 0.00367009527019952, 0.0766767491967178, 0.0205454730255043, 0.0205454730255043, 0.0766767491967178, 0.00367009527019952, 0.190774349174245, 0.000421456741626533, 0.305134098813929, 2.82322483908705e-05, 0.284693989973831, 8.40534239649844e-07, 0.118054715021316, 

0.340899997066588, 0.001953125, 2.93341158288331e-09, 0.389699792147695, 0.017578125, 2.0785230485651e-07, 0.197993454329062, 0.0703125, 6.5456709384245e-06, 0.0586797540973283, 0.1640625, 0.00012024590267193, 0.0111799590162214, 0.24609375, 0.00142004098377867, 0.00142004098377867, 0.24609375, 0.0111799590162214, 0.00012024590267193, 0.1640625, 0.0586797540973283, 6.5456709384245e-06, 0.0703125, 0.197993454329062, 2.0785230485651e-07, 0.017578125, 0.389699792147695, 2.93341158288331e-09, 0.001953125, 0.340899997066588, 

0.523279452073962, 0.0272030706779361, 4.64234829899064e-05, 3.74997444104046e-11, 0.351387820958782, 0.120591915575868, 0.000848247280189908, 4.52335114521126e-09, 0.104871434886943, 0.237594257475621, 0.00688850079034372, 2.42498904157948e-07, 0.018257634536266, 0.273067792598097, 0.0326320038318305, 7.58361106640354e-06, 0.00204336656386727, 0.20175276400069, 0.0993750242864341, 0.000152460309358515, 0.000152460309358515, 0.0993750242864341, 0.20175276400069, 0.00204336656386727, 7.5836110664035e-06, 0.0326320038318305, 0.273067792598097, 0.018257634536266, 2.42498904157946e-07, 0.00688850079034372, 0.237594257475621, 0.104871434886943, 4.52335114521123e-09, 0.000848247280189908, 0.120591915575868, 0.351387820958782, 3.74997444104043e-11, 4.64234829899064e-05, 0.0272030706779361, 0.523279452073962, 

0.648940531175615, 0.0943038827069123, 0.001953125, 1.85581766832031e-06, 1.10000666072867e-12, 0.287461493558098, 0.254614909661082, 0.017578125, 5.56757487928878e-05, 2.01143293064475e-10, 0.0565942015802643, 0.30553120336261, 0.0703125, 0.000742359567504601, 1.63468199438075e-08, 0.00649951560759269, 0.213867160694829, 0.1640625, 0.00577403414098331, 7.74957339876462e-07, 0.000479848916350383, 0.0962381156122405, 0.24609375, 0.0288708026873771, 2.36176556761302e-05, 2.36176556761301e-05, 0.0288708026873771, 0.24609375, 0.0962381156122405, 0.000479848916350385, 7.74957339876457e-07, 0.00577403414098331, 0.1640625, 0.213867160694829, 0.00649951560759272, 1.63468199438074e-08, 0.000742359567504601, 0.0703125, 0.30553120336261, 0.0565942015802645, 2.01143293064473e-10, 5.56757487928878e-05, 0.017578125, 0.254614909661082, 0.287461493558098, 1.10000666072866e-12, 1.85581766832031e-06, 0.001953125, 0.0943038827069123, 0.648940531175615, 

0.73408086166281, 0.188169584696206, 0.0134020201062015, 0.000167937389586946, 1.14845071680197e-07, 5.70464869069653e-14, 0.23087325908181, 0.345381386658926, 0.0741441516659445, 0.00245881459186946, 5.06813155674938e-06, 1.46921106793994e-11, 0.0322716259764131, 0.281751289976078, 0.18230602327775, 0.0160000613246008, 9.94033173009336e-05, 1.68173266649671e-09, 0.00263138779083231, 0.134075582164827, 0.261482078757008, 0.0607343386342396, 0.00113728855921434, 1.1229140683586e-07, 0.000137931461165695, 0.041015493692345, 0.241100057449734, 0.148204516803066, 0.00836478795847495, 4.82003907990717e-06, 4.82003907990717e-06, 0.00836478795847497, 0.148204516803066, 0.241100057449734, 0.041015493692345, 0.000137931461165695, 1.1229140683586e-07, 0.00113728855921434, 0.0607343386342396, 0.261482078757008, 0.134075582164826, 0.00263138779083231, 1.68173266649671e-09, 9.94033173009338e-05, 0.0160000613246008, 0.18230602327775, 0.281751289976078, 0.0322716259764131, 1.46921106793994e-11, 5.06813155674939e-06, 0.00245881459186946, 0.0741441516659445, 0.345381386658926, 0.23087325908181, 5.70464869069653e-14, 1.14845071680197e-07, 0.000167937389586946, 0.0134020201062015, 0.188169584696206, 0.73408086166281, 

0.792963138849073, 0.287813619406762, 0.0418955046026501, 0.001953125, 1.80229903005919e-05, 1.00554936355042e-08, 4.47283047134315e-15, 0.18634163036405, 0.384441926922649, 0.159357347810958, 0.017578125, 0.000383801970606365, 6.09774150668569e-07, 1.54173795912652e-12, 0.0194618564249364, 0.22822732059979, 0.269397922730685, 0.0703125, 0.0036324950690339, 1.64343338986463e-05, 2.36187100449204e-10, 0.00118570167034693, 0.0790353374469651, 0.265664292850764, 0.1640625, 0.0200548612000703, 0.000258375896602107, 2.11066144876013e-08, 4.64388089755155e-05, 0.0175950078883927, 0.168417262258783, 0.24609375, 0.0711784885161493, 0.00261135767529592, 1.21253827051535e-06, 1.21253827051534e-06, 0.00261135767529592, 0.0711784885161493, 0.24609375, 0.168417262258783, 0.0175950078883928, 4.64388089755159e-05, 2.1106614487601e-08, 0.000258375896602107, 0.0200548612000703, 0.1640625, 0.265664292850764, 0.0790353374469651, 0.00118570167034694, 2.361871004492e-10, 1.64343338986463e-05, 0.0036324950690339, 0.0703125, 0.269397922730685, 0.22822732059979, 0.0194618564249365, 1.5417379591265e-12, 6.09774150668569e-07, 0.000383801970606365, 0.017578125, 0.159357347810958, 0.384441926922649, 0.18634163036405, 4.47283047134306e-15, 1.00554936355042e-08, 1.80229903005919e-05, 0.001953125, 0.0418955046026501, 0.287813619406762, 0.792963138849073, 

0.834858115145607, 0.381010743235229, 0.087402325287584, 0.00889259559384836, 0.000315245284999029, 2.38006603674817e-06, 1.16040849539582e-09, 4.79560216404684e-16, 0.152207602881117, 0.388079990277973, 0.244653036144052, 0.0552227112130797, 0.00411191791263751, 6.88725880843439e-05, 9.22809144079149e-08, 2.13061261026564e-13, 0.0123332490499632, 0.175680177618941, 0.304365703963741, 0.1524138344606, 0.0238373379923246, 0.000885770640384145, 3.26159746436003e-06, 4.20710470388535e-11, 0.000582955562416167, 0.0463917832813303, 0.220880620185582, 0.245384907424297, 0.0806098042817147, 0.00664527492519944, 6.72458714914327e-05, 4.84595014790653e-09, 1.77136424205652e-05, 0.00787542220460056, 0.103046675581335, 0.253971965322744, 0.175239680513756, 0.0320493406180019, 0.000891282471648028, 3.58830241426015e-07, 3.58830241426015e-07, 0.000891282471648028, 0.0320493406180019, 0.175239680513756, 0.253971965322744, 0.103046675581335, 0.00787542220460056, 1.77136424205652e-05, 4.84595014790653e-09, 6.72458714914327e-05, 0.00664527492519944, 0.0806098042817148, 0.245384907424297, 0.220880620185582, 0.0463917832813303, 0.000582955562416167, 4.20710470388534e-11, 3.26159746436003e-06, 0.000885770640384145, 0.0238373379923246, 0.1524138344606, 0.304365703963741, 0.175680177618941, 0.0123332490499632, 2.13061261026564e-13, 9.22809144079149e-08, 6.88725880843439e-05, 0.00411191791263751, 0.0552227112130797, 0.244653036144052, 0.388079990277973, 0.152207602881117, 4.79560216404684e-16, 1.16040849539582e-09, 2.38006603674817e-06, 0.000315245284999029, 0.00889259559384836, 0.087402325287584, 0.381010743235229, 0.834858115145607, 

0.865514055653727, 0.463073954063879, 0.144656950071109, 0.0244607617724454, 0.001953125, 5.73831951853805e-05, 3.77029645882362e-07, 1.67333622507954e-10, 6.56837846813454e-17, 0.126016081990981, 0.37219822068189, 0.311990515017672, 0.112337624829852, 0.017578125, 0.00101207916949535, 1.415984281185e-05, 1.68633670750249e-08, 3.65419181086648e-14, 0.00815446179277346, 0.132958379314319, 0.299061811526877, 0.229296791868129, 0.0703125, 0.00793344340247131, 0.00023635176307578, 7.55305863672351e-07, 9.03528785199791e-12, 0.000307809079176318, 0.0277060061756257, 0.167223505112193, 0.273015631735544, 0.1640625, 0.0362765320820695, 0.00230131492606189, 1.97341403613635e-05, 1.30319510568632e-09, 7.46933646073754e-06, 0.00371147564021952, 0.0601101980206355, 0.20897364723627, 0.24609375, 0.106636104708539, 0.0144048166899179, 0.00033145764714034, 1.20834614566922e-07, 1.2083461456692e-07, 0.00033145764714034, 0.0144048166899178, 0.106636104708539, 0.24609375, 0.20897364723627, 0.0601101980206356, 0.00371147564021952, 7.46933646073765e-06, 1.30319510568629e-09, 1.97341403613635e-05, 0.00230131492606188, 0.0362765320820695, 0.1640625, 0.273015631735544, 0.167223505112193, 0.0277060061756257, 0.000307809079176321, 9.03528785199769e-12, 7.55305863672351e-07, 0.000236351763075779, 0.00793344340247132, 0.0703125, 0.229296791868129, 0.299061811526877, 0.132958379314319, 0.00815446179277351, 3.65419181086638e-14, 1.68633670750249e-08, 1.415984281185e-05, 0.00101207916949535, 0.017578125, 0.112337624829852, 0.311990515017672, 0.37219822068189, 0.126016081990981, 6.56837846813433e-17, 1.67333622507954e-10, 3.77029645882362e-07, 5.73831951853805e-05, 0.001953125, 0.0244607617724454, 0.144656950071109, 0.463073954063879, 0.865514055653727, 

0.88852425956534, 0.533300959938584, 0.20755808158595, 0.0498912150350392, 0.00681055966738008, 0.000457797270860624, 1.17557662985834e-05, 6.98690834023006e-08, 2.89666899763972e-11, 1.09525890644255e-17, 0.105710244555335, 0.347257115360417, 0.356595690600092, 0.177492777724896, 0.0454094735334404, 0.00556153344838018, 0.00026765746312383, 3.29407605568205e-06, 3.60333883417891e-09, 7.45682626606297e-15, 0.00558962080908566, 0.1004956869068, 0.272288948568944, 0.280643361293379, 0.134563604969729, 0.0300284827816705, 0.00270847762881428, 6.90239295947184e-05, 1.99218109789502e-07, 2.25636179659522e-12, 0.000172410777565855, 0.0169652587091248, 0.121283224080305, 0.25884850111143, 0.232608485657004, 0.0945777590804261, 0.0159877718524998, 0.000843689283255162, 6.42494363471879e-06, 3.9827243106243e-10, 3.41869965174573e-06, 0.00184114513293217, 0.0347284919949928, 0.153479723968527, 0.258486560795834, 0.191495742795276, 0.0606687581559915, 0.00662948601172686, 0.000133206158092031, 4.51924853494426e-08, 4.51924853494426e-08, 0.000133206158092031, 0.00662948601172686, 0.0606687581559915, 0.191495742795276, 0.258486560795834, 0.153479723968527, 0.0347284919949928, 0.00184114513293217, 3.41869965174573e-06, 3.9827243106243e-10, 6.42494363471883e-06, 0.000843689283255162, 0.0159877718524998, 0.0945777590804261, 0.232608485657004, 0.25884850111143, 0.121283224080305, 0.0169652587091248, 0.000172410777565855, 2.25636179659522e-12, 1.99218109789503e-07, 6.90239295947184e-05, 0.00270847762881428, 0.0300284827816705, 0.134563604969729, 0.280643361293379, 0.272288948568944, 0.1004956869068, 0.00558962080908566, 7.45682626606297e-15, 3.60333883417893e-09, 3.29407605568205e-06, 0.00026765746312383, 0.00556153344838018, 0.0454094735334404, 0.177492777724896, 0.356595690600092, 0.347257115360417, 0.105710244555335, 1.09525890644255e-17, 2.89666899763974e-11, 6.98690834023006e-08, 1.17557662985834e-05, 0.000457797270860624, 0.00681055966738008, 0.0498912150350392, 0.20755808158595, 0.533300959938584, 0.88852425956534, 

0.906188279745077, 0.592661621384172, 0.271324107858288, 0.0841390013554658, 0.0167323621624069, 0.001953125, 0.000115632816023, 2.68691849984411e-06, 1.48184503966547e-08, 5.83808098680115e-12, 2.14633156915631e-18, 0.0897572748580563, 0.319227864884406, 0.380860407051976, 0.239724752059501, 0.0866456690438467, 0.017578125, 0.00180874156007398, 7.63877973634863e-05, 8.55087122475406e-07, 8.77932539246432e-10, 1.75521618448044e-15, 0.00395128501807154, 0.0764209203151126, 0.237607832532905, 0.303560937254304, 0.199413219356654, 0.0703125, 0.0125744620626961, 0.000965185887167953, 2.19298379895477e-05, 5.86772373555435e-08, 6.37943031839741e-13, 0.00010146677361351, 0.0106718700364353, 0.0864713963544483, 0.224231016629604, 0.267718155497604, 0.1640625, 0.0509940031232733, 0.0071140142825945, 0.000328078125145613, 2.28767836254999e-06, 1.35253955623774e-10, 1.67503473831988e-06, 0.00095803916972009, 0.0202301296125573, 0.106478018516221, 0.231055428925939, 0.24609375, 0.132942325451482, 0.0337079992992782, 0.00315524872111706, 5.733697078296e-05, 1.84345493909534e-08, 1.8434549390953e-08, 5.733697078296e-05, 0.00315524872111706, 0.0337079992992782, 0.132942325451482, 0.24609375, 0.231055428925939, 0.106478018516221, 0.0202301296125573, 0.00095803916972009, 1.67503473831991e-06, 1.3525395562377e-10, 2.28767836254999e-06, 0.000328078125145614, 0.00711401428259451, 0.0509940031232732, 0.1640625, 0.267718155497605, 0.224231016629604, 0.0864713963544482, 0.0106718700364353, 0.000101466773613512, 6.37943031839718e-13, 5.86772373555435e-08, 2.19298379895477e-05, 0.000965185887167954, 0.0125744620626961, 0.0703125, 0.199413219356654, 0.303560937254304, 0.237607832532905, 0.0764209203151126, 0.00395128501807158, 1.75521618448037e-15, 8.77932539246432e-10, 8.55087122475409e-07, 7.63877973634864e-05, 0.00180874156007397, 0.017578125, 0.0866456690438467, 0.239724752059501, 0.380860407051976, 0.319227864884406, 0.0897572748580568, 2.14633156915621e-18, 5.83808098680115e-12, 1.48184503966548e-08, 2.68691849984411e-06, 0.000115632816023, 0.001953125, 0.0167323621624069, 0.0841390013554658, 0.271324107858288, 0.592661621384172, 0.906188279745077, 

0.920018017544691, 0.642648116843337, 0.332869886578574, 0.124941120538524, 0.0327358366306177, 0.00564824597051831, 0.00058581398402507, 3.14938468661993e-05, 6.78063257221626e-07, 3.53129647512309e-09, 1.3378089980036e-12, 4.81331016979569e-19, 0.0770508536995015, 0.291247705374337, 0.389474656848333, 0.292347612968695, 0.136165224358977, 0.0395189758349758, 0.00678192017357317, 0.000613292945313636, 2.34725933478027e-05, 2.44463769734291e-07, 2.39105660952087e-10, 4.65530076926346e-16, 0.00286797960842162, 0.058663675198922, 0.202535604508734, 0.304026324791538, 0.251725057756417, 0.122889631711204, 0.0348949913150061, 0.00530796081983809, 0.00036113486633739, 7.52163595611216e-06, 1.89934162449036e-08, 2.00110152775935e-13, 6.22718054329922e-05, 0.00689275459525359, 0.0614384643106245, 0.184433420598578, 0.271458525849408, 0.222916183177939, 0.104734631613306, 0.0267981147184749, 0.00324111588447162, 0.0001349978678587, 8.80102201996518e-07, 5.01773008521791e-11, 8.6920322546622e-07, 0.000520631977531963, 0.0119810200969825, 0.0719254398008224, 0.188189330516301, 0.259945574319763, 0.202084031899689, 0.0869751625577856, 0.0186996798944281, 0.00155760015787021, 2.62166745561584e-05, 8.08835011722743e-09, 8.08835011722767e-09, 2.62166745561583e-05, 0.00155760015787021, 0.0186996798944281, 0.0869751625577855, 0.202084031899689, 0.259945574319763, 0.188189330516301, 0.0719254398008225, 0.0119810200969825, 0.000520631977531965, 8.69203225466199e-07, 5.01773008521809e-11, 8.80102201996511e-07, 0.0001349978678587, 0.00324111588447161, 0.0267981147184748, 0.104734631613306, 0.222916183177939, 0.271458525849408, 0.184433420598578, 0.0614384643106246, 0.00689275459525361, 6.2271805432991e-05, 2.00110152775943e-13, 1.89934162449035e-08, 7.52163595611213e-06, 0.00036113486633739, 0.00530796081983808, 0.0348949913150061, 0.122889631711204, 0.251725057756417, 0.304026324791538, 0.202535604508734, 0.0586636751989222, 0.00286797960842158, 4.65530076926369e-16, 2.39105660952085e-10, 2.4446376973429e-07, 2.34725933478027e-05, 0.000613292945313635, 0.00678192017357317, 0.0395189758349758, 0.136165224358977, 0.292347612968695, 0.389474656848333, 0.291247705374338, 0.077050853699501, 4.81331016979595e-19, 1.33780899800359e-12, 3.53129647512308e-09, 6.78063257221625e-07, 3.14938468661992e-05, 0.00058581398402507, 0.00564824597051831, 0.0327358366306177, 0.124941120538524, 0.332869886578574, 0.642648116843337, 0.920018017544691, 

0.931034268387415, 0.684776685230924, 0.390488154604692, 0.169793046370148, 0.0548247896594246, 0.012627930728698, 0.001953125, 0.000184849969628659, 9.21915390796935e-06, 1.87008489560124e-07, 9.31186469577859e-10, 3.42098268889217e-13, 1.21013423862849e-19, 0.0667957839820509, 0.264831393031033, 0.387067677072141, 0.332778991417701, 0.187868679415866, 0.0710787765636639, 0.017578125, 0.00266009195271012, 0.000217920795571245, 7.72876923913341e-06, 7.60926368141927e-08, 7.16498682005776e-11, 1.36626575280558e-16, 0.00212985441592324, 0.045520544302933, 0.170523182747666, 0.289874080362162, 0.286120696087496, 0.177813683592171, 0.0703125, 0.017013411136942, 0.00228941101520067, 0.000141963546603993, 2.76354214828815e-06, 6.66956327403186e-09, 6.85573935226307e-14, 3.96157224031372e-05, 0.00456417430647637, 0.0438224594469777, 0.147292169986169, 0.254191460975531, 0.259481982771236, 0.1640625, 0.063475033495805, 0.0140302579045897, 0.00152110829449592, 5.85472290484752e-05, 3.62156423177821e-07, 2.00673584054183e-11, 4.7369599698267e-07, 0.000294192414765836, 0.00723976616691544, 0.0481132186305477, 0.145173422427208, 0.24342417708731, 0.24609375, 0.152240062701835, 0.055274142565204, 0.0104775056144453, 0.000797372166587034, 1.26418158895968e-05, 3.77607481652501e-09, 3.77607481652514e-09, 1.26418158895968e-05, 0.000797372166587031, 0.0104775056144453, 0.055274142565204, 0.152240062701835, 0.24609375, 0.24342417708731, 0.145173422427208, 0.0481132186305476, 0.00723976616691545, 0.000294192414765835, 4.73695996982657e-07, 2.00673584054191e-11, 3.62156423177824e-07, 5.8547229048475e-05, 0.00152110829449593, 0.0140302579045897, 0.063475033495805, 0.1640625, 0.259481982771236, 0.254191460975531, 0.147292169986169, 0.0438224594469778, 0.00456417430647635, 3.96157224031364e-05, 6.85573935226341e-14, 6.66956327403192e-09, 2.76354214828814e-06, 0.000141963546603994, 0.00228941101520067, 0.017013411136942, 0.0703125, 0.177813683592171, 0.286120696087496, 0.289874080362161, 0.170523182747666, 0.0455205443029329, 0.00212985441592321, 1.36626575280566e-16, 7.16498682005784e-11, 7.60926368141923e-08, 7.72876923913343e-06, 0.000217920795571246, 0.00266009195271012, 0.017578125, 0.0710787765636639, 0.187868679415866, 0.3327789914177, 0.387067677072141, 0.264831393031032, 0.0667957839820504, 1.21013423862857e-19, 3.42098268889221e-13, 9.31186469577855e-10, 1.87008489560124e-07, 9.21915390796935e-06, 0.000184849969628659, 0.001953125, 0.012627930728698, 0.0548247896594246, 0.169793046370148, 0.390488154604692, 0.684776685230924, 0.931034268387415, 

0.93994352605176, 0.720401898986882, 0.443412193020801, 0.216493250702587, 0.0822403889442549, 0.0236192537797201, 0.00491792292704952, 0.000697867448607169, 6.14340353347228e-05, 2.88669828447954e-06, 5.58431177012161e-08, 2.682834830134e-10, 9.61706327494035e-14, 3.35607642690437e-20, 0.0584166303171948, 0.240610048760533, 0.377401980196092, 0.361105518939959, 0.236789697463, 0.109724177555486, 0.0356287864630183, 0.00780258751326935, 0.0010711687651019, 8.12098607757627e-05, 2.71184530049678e-06, 2.55318574822688e-08, 2.33232238309374e-11, 4.37403365711576e-17, 0.00161357339411421, 0.0357166037124326, 0.142763833038203, 0.267695685940874, 0.303010676894345, 0.226545780592781, 0.114719652870375, 0.0387723243456328, 0.00830088198271583, 0.00101539172473769, 5.85298818591834e-05, 1.07991200480745e-06, 2.51392414279806e-09, 2.53366901635575e-14, 2.59990656604573e-05, 0.00309273951471022, 0.0315027900516469, 0.115761837742985, 0.226188153126965, 0.27285154385495, 0.215472282453679, 0.112388485745325, 0.0375238483694139, 0.00740585606817343, 0.000736897660569505, 2.6644717527766e-05, 1.58063848330148e-07, 8.56119589561316e-12, 2.69303024629406e-07, 0.000172159504873729, 0.00446883491791109, 0.0321813254038812, 0.108541607994568, 0.21125710633821, 0.26017135194807, 0.209428738284974, 0.109044804726288, 0.0347241312248962, 0.00596418603886725, 0.000422618345672472, 6.38891937657939e-06, 1.85965962576495e-09, 1.85965962576495e-09, 6.38891937657944e-06, 0.000422618345672472, 0.00596418603886724, 0.0347241312248961, 0.109044804726288, 0.209428738284974, 0.26017135194807, 0.21125710633821, 0.108541607994568, 0.0321813254038812, 0.00446883491791109, 0.000172159504873728, 2.69303024629406e-07, 8.56119589561317e-12, 1.5806384833015e-07, 2.6644717527766e-05, 0.000736897660569503, 0.00740585606817342, 0.0375238483694139, 0.112388485745325, 0.215472282453679, 0.27285154385495, 0.226188153126965, 0.115761837742985, 0.0315027900516469, 0.00309273951471021, 2.59990656604573e-05, 2.53366901635575e-14, 2.51392414279809e-09, 1.07991200480745e-06, 5.85298818591833e-05, 0.00101539172473768, 0.00830088198271583, 0.0387723243456328, 0.114719652870375, 0.226545780592781, 0.303010676894345, 0.267695685940874, 0.142763833038203, 0.0357166037124324, 0.00161357339411421, 4.37403365711576e-17, 2.33232238309377e-11, 2.55318574822688e-08, 2.71184530049677e-06, 8.12098607757625e-05, 0.0010711687651019, 0.00780258751326935, 0.0356287864630183, 0.109724177555486, 0.236789697463, 0.361105518939959, 0.377401980196092, 0.240610048760533, 0.0584166303171948, 3.35607642690437e-20, 9.61706327494049e-14, 2.682834830134e-10, 5.58431177012159e-08, 2.88669828447953e-06, 6.14340353347228e-05, 0.000697867448607168, 0.00491792292704952, 0.0236192537797201, 0.0822403889442549, 0.216493250702587, 0.443412193020801, 0.720401898986882, 0.93994352605176, 

0.947245932468883, 0.750668620766563, 0.491456015243935, 0.263337287398581, 0.113827309103921, 0.0388614806412547, 0.010168308942307, 0.001953125, 0.000258643425616291, 2.14786686564033e-05, 9.61831946787098e-07, 1.79057071815325e-08, 8.35615457719164e-11, 2.93627172912827e-14, 1.01343880790502e-20, 0.0514923196393769, 0.218751811576882, 0.363270045103649, 0.378759607855378, 0.279773095773075, 0.151990371574695, 0.0608582305722841, 0.017578125, 0.00350038548376106, 0.000444831613088226, 3.16974800698593e-05, 1.00838225905815e-06, 9.15685951584244e-09, 8.16164811116992e-12, 1.51009003712977e-17, 0.00124405518541669, 0.0283316936065772, 0.119341640238462, 0.242120989835997, 0.305620801017244, 0.264198466167207, 0.161885291487656, 0.0703125, 0.0210546383706614, 0.00409450505249555, 0.000464266939833039, 2.5239247156086e-05, 4.45968433171348e-07, 1.00827029096883e-09, 1.00005903001905e-14, 1.75328948834964e-05, 0.00214047524064504, 0.0228702657539518, 0.0902855020095908, 0.194749640565652, 0.267892960155709, 0.25119573183342, 0.1640625, 0.0738748297111628, 0.0219848735868932, 0.00396668372540505, 0.000368505853392585, 1.26700544483296e-05, 7.26595776635417e-08, 3.86336039161224e-12, 1.5884812250597e-07, 0.000103959062532905, 0.00281750628549698, 0.0216430302964904, 0.0797783213165511, 0.174625146736717, 0.250571454464212, 0.24609375, 0.166632485708919, 0.0758858858032842, 0.0217872222463018, 0.00345881121544883, 0.000231402111201771, 3.366070760829e-06, 9.59443232899859e-10, 9.59443232899814e-10, 3.366070760829e-06, 0.00023140211120177, 0.00345881121544884, 0.0217872222463018, 0.0758858858032842, 0.166632485708919, 0.24609375, 0.250571454464212, 0.174625146736717, 0.0797783213165511, 0.0216430302964904, 0.00281750628549698, 0.000103959062532905, 1.58848122505976e-07, 3.86336039161202e-12, 7.26595776635416e-08, 1.26700544483296e-05, 0.000368505853392586, 0.00396668372540505, 0.0219848735868932, 0.0738748297111628, 0.1640625, 0.25119573183342, 0.267892960155709, 0.194749640565652, 0.0902855020095907, 0.0228702657539518, 0.00214047524064504, 1.75328948834969e-05, 1.00005903001899e-14, 1.00827029096883e-09, 4.45968433171346e-07, 2.52392471560861e-05, 0.000464266939833039, 0.00409450505249555, 0.0210546383706614, 0.0703125, 0.161885291487656, 0.264198466167207, 0.305620801017244, 0.242120989835997, 0.119341640238463, 0.0283316936065772, 0.00124405518541671, 1.51009003712966e-17, 8.16164811116991e-12, 9.15685951584239e-09, 1.00838225905815e-06, 3.16974800698593e-05, 0.000444831613088226, 0.00350038548376106, 0.017578125, 0.0608582305722841, 0.151990371574695, 0.279773095773075, 0.378759607855377, 0.36327004510365, 0.218751811576882, 0.0514923196393774, 1.01343880790493e-20, 2.93627172912827e-14, 8.35615457719158e-11, 1.79057071815326e-08, 9.61831946787098e-07, 2.14786686564033e-05, 0.000258643425616291, 0.001953125, 0.010168308942307, 0.0388614806412547, 0.113827309103921, 0.263337287398581, 0.491456015243935, 0.750668620766563, 0.947245932468883, 

0.953302865574998, 0.776519502749435, 0.534764056295314, 0.309118289109104, 0.148332980433088, 0.0581557596034312, 0.018218531040955, 0.00442080914296558, 0.000795267477139372, 9.95422912225544e-05, 7.88138645883811e-06, 3.39286340848336e-07, 6.12022894102384e-09, 2.78879067393039e-11, 9.6400597996279e-15, 3.29714496278066e-21, 0.0457107814741542, 0.199193744191715, 0.346638943660327, 0.387648985087177, 0.315310890943157, 0.194562242517366, 0.0919107566586694, 0.0328827227209963, 0.00866028603755126, 0.00159823143084462, 0.000190819086145568, 1.2928559729181e-05, 3.95310852164795e-07, 3.48486366746159e-09, 3.04397737122234e-12, 5.56974501046301e-18, 0.000974145605152381, 0.0227099670514823, 0.0998642347009965, 0.216057866567247, 0.29789121941755, 0.289295631605108, 0.206080456592469, 0.108705434641625, 0.0419149287828918, 0.0114048396478536, 0.00205332872036029, 0.000218953251178895, 1.13482080015214e-05, 1.93541075297835e-07, 4.27189523214429e-10, 4.18167297690924e-15, 1.21100489608048e-05, 0.0015103378534825, 0.0167826059563476, 0.0702454678738222, 0.164169783982741, 0.250923873032687, 0.269540523993972, 0.2096290843123, 0.11833739989264, 0.0474739637295832, 0.0128887840105263, 0.00216306437351521, 0.000190034578480861, 6.2701409058538e-06, 3.49716852170135e-08, 1.83139326801538e-12, 9.67792820935891e-08, 6.45722893338871e-05, 0.00181310640087947, 0.0146818576618577, 0.0581625213561258, 0.139912514745722, 0.226634385384579, 0.259876070600716, 0.214777996391175, 0.127038769229853, 0.0520091652921943, 0.0137373183965751, 0.00204574948322875, 0.000130585791402548, 1.84046262241045e-06, 5.15617482795463e-10, 5.1561748279549e-10, 1.84046262241045e-06, 0.000130585791402547, 0.00204574948322876, 0.0137373183965751, 0.0520091652921943, 0.127038769229853, 0.214777996391175, 0.259876070600716, 0.226634385384579, 0.139912514745722, 0.0581625213561258, 0.0146818576618577, 0.00181310640087948, 6.45722893338871e-05, 9.67792820935851e-08, 1.8313932680155e-12, 3.49716852170135e-08, 6.27014090585377e-06, 0.000190034578480862, 0.00216306437351521, 0.0128887840105263, 0.0474739637295832, 0.11833739989264, 0.2096290843123, 0.269540523993972, 0.250923873032687, 0.164169783982741, 0.0702454678738221, 0.0167826059563476, 0.0015103378534825, 1.21100489608045e-05, 4.18167297690954e-15, 4.27189523214429e-10, 1.93541075297834e-07, 1.13482080015215e-05, 0.000218953251178895, 0.00205332872036029, 0.0114048396478536, 0.0419149287828918, 0.108705434641625, 0.206080456592469, 0.289295631605108, 0.29789121941755, 0.216057866567247, 0.0998642347009966, 0.0227099670514823, 0.000974145605152361, 5.56974501046348e-18, 3.04397737122234e-12, 3.48486366746157e-09, 3.95310852164797e-07, 1.2928559729181e-05, 0.000190819086145568, 0.00159823143084462, 0.00866028603755125, 0.0328827227209962, 0.0919107566586694, 0.194562242517366, 0.315310890943157, 0.387648985087177, 0.346638943660327, 0.199193744191715, 0.0457107814741537, 3.29714496278097e-21, 9.6400597996279e-15, 2.78879067393037e-11, 6.12022894102386e-09, 3.39286340848336e-07, 7.88138645883811e-06, 9.95422912225545e-05, 0.000795267477139371, 0.00442080914296557, 0.018218531040955, 0.0581557596034312, 0.148332980433088, 0.309118289109104, 0.534764056295314, 0.776519502749435, 0.953302865574998, 

0.958380306170332, 0.798721448632662, 0.573651149207693, 0.353047551563617, 0.184593104009144, 0.0809992224496767, 0.0293290941677352, 0.00856335318361979, 0.001953125, 0.000332869046348808, 3.97682287702796e-05, 3.0267297331653e-06, 1.26101845963926e-07, 2.21586089490036e-09, 9.89837139941849e-12, 3.37514579557141e-15, 1.14568478577711e-21, 0.04083769276333, 0.181767118311709, 0.3288456804156, 0.389681760714785, 0.343086073885203, 0.234843267400552, 0.126736261651028, 0.0537252615624158, 0.017578125, 0.00429757780819562, 0.000745450867926293, 8.45593036193704e-05, 5.49564720956808e-06, 1.6261126831117e-07, 1.39863531682145e-09, 1.20131688559612e-12, 2.17784440253807e-18, 0.000773396132572093, 0.0183845404738358, 0.0837826122314988, 0.191163263307023, 0.283405444581703, 0.302616678560679, 0.243400024190129, 0.149806515589461, 0.0703125, 0.0246599145220503, 0.00621039584920958, 0.00104994520437082, 0.000106447074218876, 5.30366717967475e-06, 8.78340114089731e-08, 1.9003784949405e-10, 1.83995004580959e-15, 8.54396751674061e-06, 0.00108469348078193, 0.0124518088860192, 0.0547035595144176, 0.136562067297722, 0.227470142852168, 0.2726824174259, 0.243668652050026, 0.1640625, 0.0825422264902717, 0.0301811883075765, 0.00760481519573969, 0.00120272241896914, 0.000100906393159936, 3.217642122994e-06, 1.75363589680459e-08, 9.06780161838982e-13, 6.06780554967066e-08, 4.11410862929229e-05, 0.001189667149679, 0.0100633183332449, 0.0423025404644418, 0.109918404086455, 0.196384916202321, 0.254790418839474, 0.24609375, 0.177613210908137, 0.094290483109404, 0.0354099382170062, 0.00873597851954204, 0.00123417167944415, 7.57752248411315e-05, 1.04028711726718e-06, 2.87284676714703e-10, 2.87284676714686e-10, 1.04028711726719e-06, 7.57752248411315e-05, 0.00123417167944416, 0.00873597851954206, 0.0354099382170062, 0.094290483109404, 0.177613210908137, 0.24609375, 0.254790418839474, 0.196384916202321, 0.109918404086455, 0.0423025404644418, 0.0100633183332449, 0.001189667149679, 4.11410862929225e-05, 6.06780554967095e-08, 9.06780161838918e-13, 1.75363589680462e-08, 3.217642122994e-06, 0.000100906393159936, 0.00120272241896914, 0.0076048151957397, 0.0301811883075765, 0.0825422264902717, 0.1640625, 0.243668652050026, 0.2726824174259, 0.227470142852168, 0.136562067297722, 0.0547035595144175, 0.0124518088860192, 0.00108469348078192, 8.54396751674091e-06, 1.83995004580944e-15, 1.90037849494053e-10, 8.78340114089731e-08, 5.30366717967477e-06, 0.000106447074218877, 0.00104994520437083, 0.00621039584920958, 0.0246599145220503, 0.0703125, 0.149806515589461, 0.243400024190129, 0.302616678560679, 0.283405444581703, 0.191163263307023, 0.0837826122314988, 0.0183845404738357, 0.000773396132572111, 2.17784440253786e-18, 1.20131688559614e-12, 1.39863531682145e-09, 1.62611268311171e-07, 5.49564720956809e-06, 8.45593036193705e-05, 0.000745450867926293, 0.00429757780819562, 0.017578125, 0.0537252615624158, 0.126736261651028, 0.234843267400552, 0.343086073885203, 0.389681760714785, 0.3288456804156, 0.181767118311709, 0.0408376927633305, 1.14568478577699e-21, 3.37514579557147e-15, 9.89837139941849e-12, 2.21586089490037e-09, 1.26101845963926e-07, 3.02672973316531e-06, 3.97682287702796e-05, 0.000332869046348808, 0.001953125, 0.00856335318361979, 0.0293290941677352, 0.0809992224496767, 0.184593104009144, 0.353047551563617, 0.573651149207693, 0.798721448632662, 0.958380306170332, 

0.962677313910663, 0.817895611384855, 0.608505705582312, 0.394656747783505, 0.22162066099343, 0.106727709473724, 0.0435064274425506, 0.0147507393130043, 0.00406244127467545, 0.000879996318562521, 0.000143363600208042, 1.64732672540766e-05, 1.21294015235435e-06, 4.91649981499378e-08, 8.45111464068134e-10, 3.71260551996076e-12, 1.25144568316588e-15, 4.22102356649563e-22, 0.0366948519833707, 0.166263727385119, 0.310772133888108, 0.386550172195887, 0.363516818498379, 0.271105119523125, 0.163154424799031, 0.079333951690994, 0.030847345727362, 0.00938718051182295, 0.00215912913618917, 0.00035581096620908, 3.86779868922917e-05, 2.42787757125483e-06, 6.98896190948483e-08, 5.88825229179518e-10, 4.98651797405812e-13, 8.96970981362501e-19, 0.000621651555683724, 0.0150215458953183, 0.070540245512075, 0.168271161051957, 0.265006333572846, 0.306066453049615, 0.271932911436825, 0.189636472747589, 0.104103657446379, 0.0445048114168335, 0.0144522617703858, 0.00341567385704345, 0.000548158095988327, 5.3286233185881e-05, 2.56879138428022e-06, 4.15060586491322e-08, 8.83080418825007e-11, 8.47142540699347e-16, 6.14335628971851e-06, 0.000791677932622364, 0.0093400383164308, 0.0427297454399559, 0.112695037482896, 0.201562871298179, 0.264387843447072, 0.264424349230215, 0.204941999241714, 0.123082286327198, 0.0564299693586503, 0.0191271496758387, 0.00453173595711367, 0.000682213097195969, 5.50759240426674e-05, 1.70668501372075e-06, 9.1226269365785e-09, 4.66714595958558e-13, 3.90282299989274e-08, 2.68223560835327e-05, 0.000795014084383486, 0.00697534019561142, 0.0308083049828649, 0.0853335504968222, 0.165247792326867, 0.237025730288406, 0.259364434553004, 0.21882584718245, 0.141644032864359, 0.0688554927813087, 0.0240845111783888, 0.00561486809663214, 0.000759117882925893, 4.51138330811218e-05, 6.05834566664204e-07, 1.65295392834739e-10, 1.65295392834739e-10, 6.05834566664204e-07, 4.51138330811218e-05, 0.000759117882925891, 0.00561486809663214, 0.0240845111783888, 0.0688554927813087, 0.141644032864359, 0.21882584718245, 0.259364434553004, 0.237025730288406, 0.165247792326867, 0.0853335504968222, 0.0308083049828649, 0.00697534019561144, 0.000795014084383486, 2.68223560835327e-05, 3.90282299989274e-08, 4.66714595958558e-13, 9.1226269365785e-09, 1.70668501372075e-06, 5.50759240426672e-05, 0.000682213097195969, 0.00453173595711367, 0.0191271496758387, 0.0564299693586503, 0.123082286327198, 0.204941999241714, 0.264424349230215, 0.264387843447072, 0.201562871298179, 0.112695037482896, 0.042729745439956, 0.0093400383164308, 0.000791677932622364, 6.14335628971851e-06, 8.47142540699347e-16, 8.83080418825007e-11, 4.15060586491322e-08, 2.56879138428021e-06, 5.3286233185881e-05, 0.000548158095988326, 0.00341567385704345, 0.0144522617703858, 0.0445048114168335, 0.104103657446379, 0.189636472747589, 0.271932911436825, 0.306066453049615, 0.265006333572846, 0.168271161051957, 0.070540245512075, 0.0150215458953183, 0.000621651555683724, 8.96970981362501e-19, 4.98651797405812e-13, 5.88825229179518e-10, 6.9889619094848e-08, 2.42787757125483e-06, 3.86779868922916e-05, 0.00035581096620908, 0.00215912913618917, 0.00938718051182295, 0.030847345727362, 0.079333951690994, 0.163154424799031, 0.271105119523125, 0.363516818498379, 0.386550172195887, 0.310772133888108, 0.166263727385119, 0.0366948519833707, 4.22102356649563e-22, 1.25144568316588e-15, 3.71260551996076e-12, 8.45111464068129e-10, 4.91649981499378e-08, 1.21294015235435e-06, 1.64732672540766e-05, 0.000143363600208042, 0.000879996318562521, 0.00406244127467545, 0.0147507393130043, 0.0435064274425506, 0.106727709473724, 0.22162066099343, 0.394656747783505, 0.608505705582312, 0.817895611384855, 0.962677313910663, 

0.966345130751693, 0.834544997363187, 0.63973385939736, 0.4337087769054, 0.258631283365172, 0.134629980923689, 0.0605512652688731, 0.0232117623951518, 0.00744835248827616, 0.001953125, 0.00040511136159258, 6.3534575286734e-05, 7.06397145123984e-06, 5.05752237101432e-07, 2.00281888762798e-08, 3.37897934302451e-10, 1.46348542129955e-12, 4.88513991206721e-16, 1.63881911839792e-22, 0.0331450805407356, 0.152469924084304, 0.292981792402822, 0.379660021280277, 0.377405372328941, 0.302401438253441, 0.199231258280367, 0.108444218948088, 0.0485069880338517, 0.017578125, 0.00503866349111065, 0.00110153134817836, 0.000173900046829507, 1.82381491587256e-05, 1.11173089298539e-06, 3.12661134142859e-08, 2.58840437468728e-10, 2.16584613038332e-13, 3.87016271501656e-19, 0.000505269841127986, 0.0123804403457237, 0.059634750655309, 0.147709696699677, 0.244766841143218, 0.301886298464837, 0.291346104089369, 0.225176039305873, 0.140399602421835, 0.0703125, 0.0278531147329687, 0.00848791600159717, 0.00190268960022777, 0.00029230833275843, 2.74268007635062e-05, 1.2858187159755e-06, 2.03466695462182e-08, 4.26771760430174e-11, 4.06204667537187e-16, 4.49308328043373e-06, 0.000586414625989298, 0.00708068016669876, 0.0335227732122794, 0.0926006173579943, 0.175800354458783, 0.248529385609854, 0.27274370807498, 0.237052337052224, 0.1640625, 0.0898150209190093, 0.0381524189926736, 0.0121437546384281, 0.00273286653429386, 0.000394700269797864, 3.08462504840309e-05, 9.32977847826665e-07, 4.90546908595889e-09, 2.48700917884197e-13, 2.56850274412078e-08, 1.78561559071138e-05, 0.000540461822833831, 0.00489086128329377, 0.0225211028980197, 0.0658128296895151, 0.136288983103356, 0.212374211342194, 0.257298395738922, 0.24609375, 0.18618241376021, 0.110244659015977, 0.0498255953912449, 0.0164251794412873, 0.00365152407701096, 0.000475706945861307, 2.75019701557902e-05, 3.62476525025571e-07, 9.78868471796072e-11, 9.78868471796072e-11, 3.62476525025571e-07, 2.75019701557902e-05, 0.000475706945861307, 0.00365152407701096, 0.0164251794412873, 0.0498255953912449, 0.110244659015977, 0.18618241376021, 0.24609375, 0.257298395738922, 0.212374211342194, 0.136288983103356, 0.065812829689515, 0.0225211028980198, 0.00489086128329377, 0.000540461822833831, 1.78561559071138e-05, 2.56850274412078e-08, 2.48700917884197e-13, 4.90546908595889e-09, 9.32977847826665e-07, 3.08462504840309e-05, 0.000394700269797863, 0.00273286653429387, 0.0121437546384281, 0.0381524189926735, 0.0898150209190093, 0.1640625, 0.237052337052224, 0.27274370807498, 0.248529385609854, 0.175800354458783, 0.0926006173579944, 0.0335227732122794, 0.00708068016669876, 0.000586414625989298, 4.49308328043373e-06, 4.06204667537187e-16, 4.26771760430174e-11, 2.03466695462182e-08, 1.2858187159755e-06, 2.74268007635061e-05, 0.00029230833275843, 0.00190268960022777, 0.00848791600159716, 0.0278531147329687, 0.0703125, 0.140399602421835, 0.225176039305873, 0.291346104089369, 0.301886298464837, 0.244766841143218, 0.147709696699677, 0.059634750655309, 0.0123804403457237, 0.000505269841127986, 3.87016271501656e-19, 2.16584613038332e-13, 2.58840437468728e-10, 3.12661134142859e-08, 1.11173089298539e-06, 1.82381491587256e-05, 0.000173900046829507, 0.00110153134817836, 0.00503866349111065, 0.017578125, 0.0485069880338517, 0.108444218948088, 0.199231258280367, 0.302401438253441, 0.377405372328941, 0.379660021280277, 0.292981792402822, 0.152469924084304, 0.0331450805407356, 1.63881911839792e-22, 4.88513991206721e-16, 1.46348542129955e-12, 3.37897934302451e-10, 2.00281888762797e-08, 5.05752237101434e-07, 7.06397145123984e-06, 6.35345752867339e-05, 0.00040511136159258, 0.001953125, 0.00744835248827616, 0.0232117623951518, 0.0605512652688731, 0.134629980923689, 0.258631283365172, 0.4337087769054, 0.63973385939736, 0.834544997363187, 0.966345130751693, 

0.969500252540025, 0.849077868147307, 0.667728997078888, 0.470125933409015, 0.295033369280832, 0.164024220409416, 0.0801246534175718, 0.0340231443469457, 0.0123832219731749, 0.00379273623224631, 0.000954003320965617, 0.000190708403866699, 2.89556784598906e-05, 3.13020441710102e-06, 2.18809424063584e-07, 8.49420315098025e-09, 1.4103344924294e-10, 6.03458927396183e-13, 1.99755761878828e-16, 6.67018036452716e-23, 0.0300815629521852, 0.140183140501664, 0.275820028665886, 0.370132821650419, 0.385702722577114, 0.328390264901827, 0.233458343480037, 0.139605112695227, 0.0700956871796734, 0.0292816027162519, 0.0100090463862216, 0.00272896025379432, 0.000571599563366141, 8.70190791424562e-05, 8.85255737434961e-06, 5.26291186170121e-07, 1.45098778741054e-08, 1.18333353570163e-10, 9.80022552139957e-14, 1.74128607018262e-19, 0.00041483018460078, 0.0102863555435936, 0.050637102141779, 0.129514522648562, 0.22410510613092, 0.292206617922687, 0.302322254224997, 0.254592544310493, 0.17634632737871, 0.100474193608132, 0.0466716332741835, 0.0173556974727287, 0.00501496046092873, 0.00107516160832206, 0.00015918016816391, 1.44926242425244e-05, 6.63472411219081e-07, 1.03129784583542e-08, 2.13693004935257e-11, 2.02031996638317e-16, 3.33700683567683e-06, 0.000440295322446271, 0.00542286362114314, 0.0264360238113597, 0.0759569632212813, 0.151672419675054, 0.228374510080601, 0.270836275602571, 0.258796462162889, 0.201108769424274, 0.126949235712979, 0.0643878207344867, 0.0256661029643434, 0.00774907398451173, 0.00166965200051269, 0.000232800957068437, 1.76969642673624e-05, 5.24297567222459e-07, 2.7180743767055e-09, 1.36737293655263e-13, 1.72567225461933e-08, 1.21154928509657e-05, 0.000373338686297954, 0.00346887198768339, 0.0165499965786646, 0.0506101537434212, 0.110902060190773, 0.18521768785727, 0.244154495147721, 0.258774788105428, 0.221983991219318, 0.153560619292955, 0.0844436165203947, 0.0359037937296271, 0.01125841981212, 0.00240401384448774, 0.00030345140537017, 1.71350765234378e-05, 2.22252595078333e-07, 5.94933299411754e-11, 5.94933299411706e-11, 2.22252595078329e-07, 1.71350765234378e-05, 0.000303451405370169, 0.00240401384448774, 0.01125841981212, 0.0359037937296271, 0.0844436165203947, 0.153560619292955, 0.221983991219318, 0.258774788105428, 0.244154495147721, 0.18521768785727, 0.110902060190773, 0.0506101537434211, 0.0165499965786646, 0.0034688719876834, 0.000373338686297954, 1.21154928509658e-05, 1.72567225461944e-08, 1.36737293655249e-13, 2.71807437670545e-09, 5.24297567222459e-07, 1.76969642673623e-05, 0.000232800957068437, 0.00166965200051269, 0.00774907398451173, 0.0256661029643434, 0.0643878207344867, 0.126949235712979, 0.201108769424274, 0.258796462162889, 0.270836275602571, 0.228374510080601, 0.151672419675054, 0.0759569632212813, 0.0264360238113597, 0.00542286362114314, 0.000440295322446275, 3.337006835677e-06, 2.02031996638294e-16, 2.13693004935252e-11, 1.03129784583542e-08, 6.63472411219078e-07, 1.44926242425244e-05, 0.00015918016816391, 0.00107516160832206, 0.00501496046092873, 0.0173556974727287, 0.0466716332741835, 0.100474193608132, 0.17634632737871, 0.254592544310493, 0.302322254224997, 0.292206617922687, 0.22410510613092, 0.129514522648563, 0.050637102141779, 0.0102863555435937, 0.000414830184600794, 1.74128607018239e-19, 9.80022552139933e-14, 1.18333353570163e-10, 1.45098778741053e-08, 5.26291186170121e-07, 8.85255737434963e-06, 8.70190791424562e-05, 0.000571599563366141, 0.00272896025379432, 0.0100090463862216, 0.0292816027162519, 0.0700956871796734, 0.139605112695227, 0.233458343480037, 0.328390264901827, 0.385702722577114, 0.37013282165042, 0.275820028665886, 0.140183140501665, 0.0300815629521857, 6.67018036452619e-23, 1.99755761878823e-16, 6.03458927396183e-13, 1.41033449242939e-10, 8.49420315098025e-09, 2.18809424063585e-07, 3.13020441710102e-06, 2.89556784598906e-05, 0.000190708403866699, 0.000954003320965617, 0.00379273623224631, 0.0123832219731749, 0.0340231443469457, 0.0801246534175718, 0.164024220409416, 0.295033369280832, 0.470125933409015, 0.667728997078888, 0.849077868147307, 0.969500252540025, 

0.972233537294956, 0.861826821754566, 0.692856526359391, 0.503935792598157, 0.330402195414323, 0.194301378187792, 0.101811169630528, 0.0471258172473941, 0.0190562523421442, 0.00663585568443234, 0.001953125, 0.000474084437537328, 9.18190843732838e-05, 1.35584524777143e-05, 1.43072537794144e-06, 9.79712299879971e-08, 3.73854423453418e-09, 6.12226922291294e-11, 2.59229024514222e-13, 8.51912663740795e-17, 2.83329951948509e-23, 0.0274202301213695, 0.129219010757554, 0.259485158547622, 0.3588389921494, 0.389366624913519, 0.349148193504701, 0.264789191343279, 0.171416072653655, 0.0948034069391898, 0.0445452629713639, 0.017578125, 0.00572052810311582, 0.00149496672692265, 0.000301927378466852, 4.45591064203065e-05, 4.41620943326559e-06, 2.56963680604259e-07, 6.96422862421643e-09, 5.60659820368998e-11, 4.60228688542743e-14, 8.13723783316347e-20, 0.000343707551765931, 0.00861093477749811, 0.0431915923875212, 0.113564222689665, 0.203935110602507, 0.278843932873933, 0.306071267280261, 0.277116042687271, 0.209617663790779, 0.132899578528814, 0.0703125, 0.0306784935223099, 0.0108180149638119, 0.00298821850609684, 0.000616785488470345, 8.84745257963467e-05, 7.84979737891243e-06, 3.5208789830803e-07, 5.38930451369099e-09, 1.1050190929077e-11, 1.03867340844282e-16, 2.51318146105458e-06, 0.000334727182139195, 0.00419375159510709, 0.0209652589556953, 0.0623077511715038, 0.129906054799834, 0.206377175384674, 0.26132959193034, 0.270363837424305, 0.231292991975816, 0.1640625, 0.0959729246850546, 0.0456646804433749, 0.0172519821374087, 0.00498022100203002, 0.00103395971953299, 0.000139882035474028, 1.03835526728609e-05, 3.02191891593047e-07, 1.54768534691206e-09, 7.73388679373243e-14, 1.18133506260594e-08, 8.36461847822913e-06, 0.000261770476321586, 0.00248813192219903, 0.0122378922397782, 0.038905594993471, 0.0894571875563516, 0.158427287254306, 0.224173256811638, 0.258771127667505, 0.24609375, 0.19300915242405, 0.123916101473461, 0.0640295017525838, 0.0258510124826093, 0.00776789721427686, 0.00160243312329033, 0.000196859018860631, 1.08929965163057e-05, 1.3935098197321e-07, 3.70195454584342e-11, 3.70195454584375e-11, 1.39350981973208e-07, 1.08929965163058e-05, 0.000196859018860631, 0.00160243312329033, 0.00776789721427686, 0.0258510124826093, 0.0640295017525837, 0.123916101473461, 0.19300915242405, 0.24609375, 0.258771127667505, 0.224173256811638, 0.158427287254306, 0.0894571875563516, 0.038905594993471, 0.0122378922397782, 0.00248813192219903, 0.000261770476321585, 8.36461847822925e-06, 1.18133506260586e-08, 7.73388679373326e-14, 1.54768534691203e-09, 3.0219189159305e-07, 1.03835526728609e-05, 0.000139882035474028, 0.00103395971953299, 0.00498022100203002, 0.0172519821374087, 0.0456646804433749, 0.0959729246850546, 0.1640625, 0.231292991975816, 0.270363837424305, 0.26132959193034, 0.206377175384674, 0.129906054799834, 0.0623077511715038, 0.0209652589556953, 0.00419375159510707, 0.000334727182139198, 2.51318146105445e-06, 1.03867340844295e-16, 1.10501909290767e-11, 5.38930451369104e-09, 3.5208789830803e-07, 7.84979737891243e-06, 8.84745257963467e-05, 0.000616785488470345, 0.00298821850609684, 0.0108180149638119, 0.0306784935223099, 0.0703125, 0.132899578528814, 0.209617663790779, 0.277116042687271, 0.306071267280261, 0.278843932873933, 0.203935110602507, 0.113564222689665, 0.0431915923875211, 0.00861093477749817, 0.000343707551765919, 8.13723783316463e-20, 4.6022868854273e-14, 5.60659820369004e-11, 6.96422862421643e-09, 2.56963680604259e-07, 4.41620943326559e-06, 4.45591064203065e-05, 0.000301927378466852, 0.00149496672692265, 0.00572052810311582, 0.017578125, 0.0445452629713639, 0.0948034069391898, 0.171416072653655, 0.264789191343279, 0.349148193504701, 0.389366624913519, 0.3588389921494, 0.259485158547622, 0.129219010757555, 0.027420230121369, 2.83329951948554e-23, 8.5191266374077e-17, 2.59229024514226e-13, 6.12226922291294e-11, 3.73854423453418e-09, 9.79712299879971e-08, 1.43072537794144e-06, 1.35584524777143e-05, 9.18190843732838e-05, 0.000474084437537328, 0.001953125, 0.00663585568443234, 0.0190562523421442, 0.0471258172473941, 0.101811169630528, 0.194301378187792, 0.330402195414323, 0.503935792598157, 0.692856526359391, 0.861826821754566, 0.972233537294956, 

0.974616658711705, 0.873064049696355, 0.715447529495134, 0.535232142709016, 0.364449348393076, 0.224944209396603, 0.125169732118079, 0.0623552298574436, 0.0275623188070307, 0.0106876152955132, 0.0035828737247701, 0.00101899538596918, 0.000239853151911141, 4.52006103899493e-05, 6.51569211636894e-06, 6.73309888688083e-07, 4.5289124482667e-08, 1.70266372108628e-09, 2.75509343045049e-11, 1.15597821212238e-13, 3.77512390534628e-17, 1.25116580029229e-23, 0.025094250702827, 0.119413554715562, 0.244077801201264, 0.346440366884036, 0.389284986515362, 0.365013005895598, 0.29259425562497, 0.202671089299678, 0.121645141115628, 0.0630824104305571, 0.0280414687778872, 0.0105460051918296, 0.00329156913949924, 0.00082956477682189, 0.000162377801200136, 2.33310099536358e-05, 2.26071295283782e-06, 1.29116999420406e-07, 3.44774428124332e-09, 2.74463232245468e-11, 2.23567519443995e-14, 3.9360398022431e-20, 0.000287165403367117, 0.00725903064157441, 0.0370080547618342, 0.0996626142645101, 0.184805806829698, 0.263244521989266, 0.303983317429305, 0.292771097552771, 0.238611440828838, 0.165482940173645, 0.0975410654655965, 0.0485088775943182, 0.0200760383107107, 0.00676665118758931, 0.0017984991618313, 0.000359310217315484, 5.01550193194809e-05, 4.35166493871874e-06, 1.91757007785675e-07, 2.89625089103149e-09, 5.88442033851673e-12, 5.50327962439248e-17, 1.91693238514046e-06, 0.000257407043576286, 0.00327326395299634, 0.0167244888828465, 0.0511776530363735, 0.110745768111124, 0.18422582025339, 0.246706955511461, 0.273026344089694, 0.253229892864535, 0.197920612660827, 0.130158119422202, 0.0714282226349014, 0.0321969008144076, 0.0116201201141241, 0.00322791722142554, 0.000649082911302336, 8.55547776868799e-05, 6.22134428696635e-06, 1.78280967078347e-07, 9.03473589116944e-10, 4.48849217786865e-14, 8.226137155756e-09, 5.86781884119464e-06, 0.000186114526330692, 0.00180421341264355, 0.00911086458698825, 0.029950867829918, 0.0717737638216057, 0.133643875383096, 0.200831724812422, 0.249110014929661, 0.258171936215112, 0.224510045561488, 0.163371443069066, 0.0984847129571788, 0.0482642396262792, 0.018641878994067, 0.00540008284479155, 0.00108130337621436, 0.000129757270358261, 7.05485766067229e-06, 8.91747106701963e-08, 2.35338964934684e-11, 2.35338964934684e-11, 8.91747106701963e-08, 7.05485766067224e-06, 0.000129757270358262, 0.00108130337621436, 0.00540008284479155, 0.018641878994067, 0.0482642396262792, 0.0984847129571788, 0.163371443069066, 0.224510045561488, 0.258171936215112, 0.249110014929662, 0.200831724812422, 0.133643875383096, 0.0717737638216057, 0.029950867829918, 0.00911086458698823, 0.00180421341264354, 0.000186114526330693, 5.86781884119464e-06, 8.226137155756e-09, 4.48849217786865e-14, 9.03473589116944e-10, 1.78280967078345e-07, 6.22134428696638e-06, 8.55547776868801e-05, 0.000649082911302336, 0.00322791722142554, 0.0116201201141241, 0.0321969008144076, 0.0714282226349013, 0.130158119422202, 0.197920612660827, 0.253229892864535, 0.273026344089694, 0.246706955511461, 0.18422582025339, 0.110745768111124, 0.0511776530363734, 0.0167244888828464, 0.00327326395299636, 0.000257407043576285, 1.91693238514046e-06, 5.50327962439248e-17, 5.88442033851673e-12, 2.89625089103146e-09, 1.91757007785676e-07, 4.35166493871875e-06, 5.01550193194809e-05, 0.000359310217315484, 0.0017984991618313, 0.00676665118758931, 0.0200760383107107, 0.0485088775943182, 0.0975410654655965, 0.165482940173645, 0.238611440828838, 0.292771097552771, 0.303983317429305, 0.263244521989266, 0.184805806829698, 0.09966261426451, 0.0370080547618343, 0.00725903064157441, 0.000287165403367117, 3.9360398022431e-20, 2.23567519443995e-14, 2.74463232245464e-11, 3.44774428124334e-09, 1.29116999420406e-07, 2.26071295283782e-06, 2.33310099536358e-05, 0.000162377801200136, 0.00082956477682189, 0.00329156913949923, 0.0105460051918296, 0.0280414687778872, 0.0630824104305571, 0.121645141115628, 0.202671089299678, 0.29259425562497, 0.365013005895598, 0.389284986515361, 0.346440366884036, 0.244077801201264, 0.119413554715562, 0.025094250702827, 1.25116580029229e-23, 3.77512390534628e-17, 1.15597821212236e-13, 2.75509343045051e-11, 1.70266372108629e-09, 4.5289124482667e-08, 6.73309888688083e-07, 6.51569211636894e-06, 4.52006103899493e-05, 0.00023985315191114, 0.00101899538596918, 0.0035828737247701, 0.0106876152955132, 0.0275623188070307, 0.0623552298574436, 0.125169732118079, 0.224944209396603, 0.364449348393076, 0.535232142709016, 0.715447529495134, 0.873064049696355, 0.974616658711705, 

0.976706749418275, 0.883013421630562, 0.735797419760533, 0.564147634373248, 0.396993344705972, 0.255530569683225, 0.149769639842189, 0.0794752535173561, 0.0379061487201395, 0.0161017561949927, 0.0060212287408705, 0.001953125, 0.000539192592733389, 0.000123569060658953, 2.27388836579774e-05, 3.20973640405379e-06, 3.25681535964885e-07, 2.15672339382966e-08, 8.00346075363997e-10, 1.28155603933718e-11, 5.33444986831158e-14, 1.73253918814211e-17, 5.72456113923135e-24, 0.0230499995662848, 0.11062286421552, 0.229634739645169, 0.333431732192411, 0.386241084858833, 0.376464854132803, 0.316581193304889, 0.232422726795425, 0.149609365204196, 0.0843567445518452, 0.0414466776438459, 0.017578125, 0.00634489353029577, 0.00191050509099366, 0.000466664796444511, 8.89012191458712e-05, 1.24800645062849e-05, 1.18576299660849e-06, 6.66327283781101e-08, 1.75633947781612e-09, 1.38450754818655e-11, 1.12018690499317e-14, 1.96480965811461e-20, 0.000241765950423445, 0.00615942221260558, 0.0318518308531573, 0.087586781472624, 0.167013351871923, 0.246503729384927, 0.29741572030205, 0.302094448216995, 0.262437190711377, 0.19641916392251, 0.12679782458153, 0.0703125, 0.0331835039224164, 0.0131281682872478, 0.0042565567034128, 0.00109436840782875, 0.000212548480485652, 2.89746914364752e-05, 2.46555590986296e-06, 1.0697857454012e-07, 1.59704994958844e-09, 3.21895865189322e-12, 2.9972036467867e-17, 1.47923149380999e-06, 0.000200056121486318, 0.00257719930640744, 0.0134210656526396, 0.0421270172047741, 0.0941541234494396, 0.162989460490785, 0.229046515915445, 0.268539869825518, 0.266787021720342, 0.226282347641461, 0.1640625, 0.101236457464819, 0.0526231528918452, 0.0226479344760009, 0.00785843693045006, 0.00211162100256013, 0.000413006170125706, 5.32180439557594e-05, 3.80103566187481e-06, 1.07462877406895e-07, 5.39581559223739e-10, 2.6670356100601e-14, 5.81823993589731e-09, 4.177131894892e-06, 0.000134052860168403, 0.00132205617104682, 0.00683100654961429, 0.0231190332036961, 0.0574208475013835, 0.111639815405839, 0.176647152740454, 0.232948550957951, 0.25959960230732, 0.24609375, 0.198548271574707, 0.135601367321613, 0.0774663779387994, 0.0362763238551099, 0.0134861633296162, 0.00378450195411515, 0.000738443775943152, 8.68203546394848e-05, 4.64850073867707e-06, 5.81451202715547e-08, 1.52565329106471e-11, 1.52565329106488e-11, 5.81451202715547e-08, 4.64850073867704e-06, 8.68203546394848e-05, 0.000738443775943152, 0.00378450195411514, 0.0134861633296162, 0.0362763238551099, 0.0774663779387994, 0.135601367321613, 0.198548271574707, 0.24609375, 0.25959960230732, 0.232948550957951, 0.176647152740454, 0.11163981540584, 0.0574208475013834, 0.0231190332036961, 0.00683100654961429, 0.00132205617104682, 0.000134052860168404, 4.177131894892e-06, 5.81823993589682e-09, 2.66703561006044e-14, 5.39581559223739e-10, 1.07462877406894e-07, 3.80103566187481e-06, 5.32180439557594e-05, 0.000413006170125705, 0.00211162100256013, 0.00785843693045005, 0.0226479344760009, 0.0526231528918452, 0.101236457464819, 0.1640625, 0.226282347641461, 0.266787021720342, 0.268539869825518, 0.229046515915446, 0.162989460490785, 0.0941541234494397, 0.0421270172047741, 0.0134210656526396, 0.00257719930640745, 0.000200056121486318, 1.4792314938099e-06, 2.99720364678714e-17, 3.21895865189322e-12, 1.59704994958843e-09, 1.0697857454012e-07, 2.46555590986296e-06, 2.89746914364751e-05, 0.000212548480485652, 0.00109436840782874, 0.0042565567034128, 0.0131281682872478, 0.0331835039224164, 0.0703125, 0.12679782458153, 0.19641916392251, 0.262437190711377, 0.302094448216995, 0.29741572030205, 0.246503729384928, 0.167013351871923, 0.087586781472624, 0.0318518308531574, 0.00615942221260558, 0.000241765950423435, 1.96480965811495e-20, 1.12018690499317e-14, 1.38450754818654e-11, 1.75633947781612e-09, 6.66327283781101e-08, 1.18576299660849e-06, 1.24800645062849e-05, 8.8901219145871e-05, 0.000466664796444511, 0.00191050509099366, 0.00634489353029577, 0.017578125, 0.0414466776438459, 0.0843567445518452, 0.149609365204196, 0.232422726795425, 0.316581193304889, 0.376464854132803, 0.386241084858833, 0.333431732192411, 0.229634739645169, 0.11062286421552, 0.0230499995662844, 5.72456113923244e-24, 1.73253918814211e-17, 5.3344498683115e-14, 1.28155603933718e-11, 8.00346075363997e-10, 2.15672339382966e-08, 3.25681535964886e-07, 3.20973640405379e-06, 2.27388836579774e-05, 0.000123569060658953, 0.000539192592733389, 0.001953125, 0.0060212287408705, 0.0161017561949927, 0.0379061487201395, 0.0794752535173561, 0.149769639842189, 0.255530569683225, 0.396993344705972, 0.564147634373248, 0.735797419760533, 0.883013421630562, 0.976706749418275, 

0.978549789347802, 0.891860021751249, 0.754167275467319, 0.590835117846358, 0.427934002739746, 0.285727631684369, 0.175213279433183, 0.0982092773968659, 0.0500160654579999, 0.0229714638685451, 0.00942596829901793, 0.00341518066835026, 0.00107640347478525, 0.00028952921178113, 6.48188978185254e-05, 1.16816352835843e-05, 1.6188637792307e-06, 1.61649345146306e-07, 1.05589982797579e-08, 3.87382020348728e-10, 6.14611589288535e-12, 2.54043621500541e-14, 8.21108533841033e-18, 2.70579026459823e-24, 0.0212440733872058, 0.102721619625463, 0.216151946098138, 0.320177209498463, 0.380903669880102, 0.384043447407425, 0.336709013486643, 0.259990214173877, 0.177762549148296, 0.107684908786698, 0.0576100279238728, 0.0270358976559502, 0.0110136938378086, 0.00383711924623756, 0.00112000635805999, 0.000266230566909445, 4.95325673693478e-05, 6.81351544061705e-06, 6.36325928578974e-07, 3.52521912623293e-08, 9.18674474670583e-10, 7.17962643231725e-12, 5.77458027621246e-15, 1.00954174870232e-20, 0.000204979363450245, 0.00525828960755472, 0.0275339232919359, 0.077113783438445, 0.150685339119523, 0.229417191823365, 0.287580840219192, 0.305899642784826, 0.280794434884442, 0.224356418840312, 0.156490392032082, 0.0951229665484662, 0.0500850821150531, 0.0226014179199098, 0.00860115583100336, 0.00269668160649952, 0.000673579488054378, 0.000127639772420865, 1.70433123232964e-05, 1.42577257764786e-06, 6.10295315046572e-08, 9.01805505389795e-10, 1.80491918977629e-12, 1.67406346753235e-17, 1.15371697132717e-06, 0.00015701601075162, 0.00204594446126108, 0.0108340391764465, 0.0347731181895651, 0.0799444563316931, 0.143278804160278, 0.20995089573933, 0.258734008409388, 0.272670998110703, 0.247967101339555, 0.195230097901966, 0.13286193542247, 0.077657404215396, 0.0385309696144217, 0.0159337582202899, 0.00534322745580544, 0.00139481815615219, 0.000266284065723303, 3.36380793946429e-05, 2.36502217130961e-06, 6.60755384295351e-08, 3.29087885765152e-10, 1.61933367940633e-14, 4.17448491528723e-09, 3.01410134217117e-06, 9.77313856169503e-05, 0.000978505487779104, 0.00515858685637683, 0.0179087478226182, 0.0458900384704673, 0.0926341173259455, 0.15326147863707, 0.213036427342759, 0.252589286306389, 0.257586223531984, 0.226572518843166, 0.171531753505759, 0.11096283234968, 0.0605231114338218, 0.027247894204148, 0.00979859113687756, 0.00267455066755711, 0.000510183723141426, 5.89175759855966e-05, 3.11231118128581e-06, 3.8572741116824e-08, 1.00696703154803e-11, 1.00696703154814e-11, 3.8572741116824e-08, 3.11231118128584e-06, 5.89175759855966e-05, 0.000510183723141426, 0.00267455066755711, 0.00979859113687756, 0.027247894204148, 0.0605231114338218, 0.11096283234968, 0.171531753505759, 0.226572518843166, 0.257586223531985, 0.252589286306389, 0.213036427342759, 0.15326147863707, 0.0926341173259455, 0.0458900384704673, 0.0179087478226181, 0.00515858685637683, 0.000978505487779104, 9.77313856169496e-05, 3.01410134217116e-06, 4.17448491528684e-09, 1.61933367940655e-14, 3.29087885765152e-10, 6.60755384295358e-08, 2.36502217130961e-06, 3.36380793946429e-05, 0.000266284065723304, 0.00139481815615219, 0.00534322745580545, 0.0159337582202899, 0.0385309696144217, 0.077657404215396, 0.13286193542247, 0.195230097901966, 0.247967101339555, 0.272670998110703, 0.258734008409388, 0.209950895739329, 0.143278804160278, 0.079944456331693, 0.0347731181895651, 0.0108340391764465, 0.00204594446126107, 0.00015701601075162, 1.15371697132709e-06, 1.67406346753262e-17, 1.80491918977629e-12, 9.01805505389807e-10, 6.10295315046572e-08, 1.42577257764786e-06, 1.70433123232964e-05, 0.000127639772420865, 0.000673579488054379, 0.00269668160649952, 0.00860115583100336, 0.0226014179199098, 0.0500850821150531, 0.0951229665484662, 0.156490392032082, 0.224356418840312, 0.280794434884442, 0.305899642784826, 0.287580840219192, 0.229417191823364, 0.150685339119523, 0.077113783438445, 0.0275339232919358, 0.00525828960755472, 0.000204979363450235, 1.0095417487025e-20, 5.77458027621246e-15, 7.17962643231735e-12, 9.18674474670583e-10, 3.52521912623293e-08, 6.36325928578977e-07, 6.81351544061705e-06, 4.95325673693479e-05, 0.000266230566909445, 0.00112000635805999, 0.00383711924623756, 0.0110136938378085, 0.0270358976559502, 0.0576100279238728, 0.107684908786698, 0.177762549148296, 0.259990214173877, 0.336709013486643, 0.384043447407425, 0.380903669880102, 0.320177209498463, 0.216151946098137, 0.102721619625463, 0.0212440733872054, 2.70579026459879e-24, 8.21108533841033e-18, 2.54043621500545e-14, 6.14611589288535e-12, 3.87382020348728e-10, 1.0558998279758e-08, 1.61649345146306e-07, 1.61886377923071e-06, 1.16816352835843e-05, 6.48188978185254e-05, 0.00028952921178113, 0.00107640347478525, 0.00341518066835026, 0.00942596829901793, 0.0229714638685451, 0.0500160654579999, 0.0982092773968659, 0.175213279433183, 0.285727631684369, 0.427934002739746, 0.590835117846358, 0.754167275467319, 0.891860021751249, 0.978549789347802, 

0.0009765625, 0.009765625, 0.0439453125, 0.1171875, 0.205078125, 0.24609375, 0.205078125, 0.1171875, 0.0439453125, 0.009765625, 0.0009765625, 

0.0931068182589887, 1.77625785062455e-07, 0.249478967623273, 6.6290845458739e-06, 0.300814595564428, 0.00011133036149792, 0.214941407874622, 0.00110797484142732, 0.100788409155024, 0.00723628220300098, 0.0324074074074074, 0.0324074074074074, 0.00723628220300098, 0.100788409155024, 0.00110797484142732, 0.214941407874622, 0.00011133036149792, 0.300814595564428, 6.6290845458739e-06, 0.249478967623273, 1.77625785062455e-07, 0.0931068182589887, 

0.302479999669399, 0.0009765625, 3.30600370633756e-10, 0.384199973971888, 0.009765625, 2.60281121224955e-08, 0.219599077864981, 0.0439453125, 9.22135019731318e-07, 0.0743806401235915, 0.1171875, 1.93598764087981e-05, 0.0165332650270357, 0.205078125, 0.000266734972964427, 0.00252000000000002, 0.24609375, 0.00252000000000002, 0.000266734972964427, 0.205078125, 0.0165332650270357, 1.93598764087981e-05, 0.1171875, 0.0743806401235915, 9.22135019731318e-07, 0.0439453125, 0.219599077864981, 2.60281121224955e-08, 0.009765625, 0.384199973971888, 3.30600370633756e-10, 0.0009765625, 0.302479999669399, 

0.486947194682945, 0.0182257995178667, 1.53201893980771e-05, 2.60367641155454e-12, 0.363322573910166, 0.0897727116006939, 0.000311032935918293, 3.489606799885e-10, 0.121987522198163, 0.19898237567622, 0.00284158818931722, 2.10464326661081e-08, 0.0242713904280416, 0.26136118978215, 0.0153841007962998, 7.52205860083538e-07, 0.00316915309159211, 0.225287399376478, 0.0546578331860515, 1.76426674108627e-05, 0.000283749417823995, 0.133160648749606, 0.133160648749606, 0.000283749417823996, 1.76426674108626e-05, 0.0546578331860515, 0.225287399376478, 0.00316915309159212, 7.52205860083534e-07, 0.0153841007962998, 0.26136118978215, 0.0242713904280416, 2.10464326661079e-08, 0.00284158818931722, 0.19898237567622, 0.121987522198163, 3.48960679988498e-10, 0.000311032935918293, 0.0897727116006939, 0.363322573910167, 2.60367641155452e-12, 1.53201893980771e-05, 0.0182257995178667, 0.486947194682945, 

0.618498680869844, 0.0725418146841953, 0.0009765625, 4.28258404388968e-07, 5.16013971890298e-14, 0.304418503057707, 0.21762068022717, 0.009765625, 1.42755926393134e-05, 1.04840526353964e-11, 0.0674242040308062, 0.293781487283146, 0.0439453125, 0.000214138577087528, 9.5853822846309e-10, 0.00884946118539785, 0.23502004512031, 0.1171875, 0.00190349568611526, 5.19332978701235e-08, 0.000762231944535506, 0.123382822776529, 0.205078125, 0.0111039679017566, 1.84651007841844e-06, 4.5019499258158e-05, 0.0444168438926464, 0.24609375, 0.0444168438926464, 4.50194992581583e-05, 1.84651007841843e-06, 0.0111039679017566, 0.205078125, 0.123382822776529, 0.00076223194453551, 5.19332978701231e-08, 0.00190349568611526, 0.1171875, 0.23502004512031, 0.00884946118539788, 9.58538228463081e-10, 0.000214138577087528, 0.0439453125, 0.293781487283146, 0.0674242040308064, 1.04840526353963e-11, 1.42755926393134e-05, 0.009765625, 0.21762068022717, 0.304418503057708, 5.16013971890292e-14, 4.28258404388968e-07, 0.0009765625, 0.0725418146841953, 0.618498680869844, 

0.709294443061681, 0.156294540172398, 0.00829999961790695, 6.39321531853861e-05, 1.94542161479298e-08, 1.92618848691545e-15, 0.247864186011291, 0.318750445238079, 0.0510202048829451, 0.0010400523640156, 9.53908555322669e-07, 5.51202984200498e-13, 0.0389774583582405, 0.292529929723274, 0.141129836356469, 0.00761383732127709, 2.10480692847949e-05, 7.09801399680946e-11, 0.00363219763273559, 0.159091153991528, 0.231340513975248, 0.0330299715585972, 0.000275216206243659, 5.41649518174078e-09, 0.000222123619793501, 0.0567794359268929, 0.248859297435835, 0.0940333963580539, 0.00236159303710944, 2.71249650521603e-07, 9.31457857918842e-06, 0.0138956642724186, 0.183568957976467, 0.183568957976467, 0.0138956642724186, 9.31457857918842e-06, 2.71249650521603e-07, 0.00236159303710944, 0.0940333963580539, 0.248859297435835, 0.0567794359268928, 0.000222123619793501, 5.41649518174078e-09, 0.00027521620624366, 0.0330299715585972, 0.231340513975248, 0.159091153991528, 0.00363219763273559, 7.09801399680946e-11, 2.10480692847949e-05, 0.00761383732127709, 0.141129836356469, 0.292529929723274, 0.0389774583582405, 5.51202984200498e-13, 9.53908555322672e-07, 0.0010400523640156, 0.0510202048829451, 0.318750445238079, 0.247864186011291, 1.92618848691545e-15, 1.94542161479299e-08, 6.39321531853861e-05, 0.00829999961790695, 0.156294540172398, 0.709294443061681, 

0.772785364063438, 0.250618196918555, 0.0294492960050725, 0.0009765625, 5.35422353688742e-06, 1.29951575909081e-09, 1.13815840211789e-16, 0.201777747856344, 0.371954224882065, 0.124462085975776, 0.009765625, 0.000126687667637045, 8.75597787641342e-08, 4.35901463113136e-14, 0.0237082864667015, 0.248415622643954, 0.236707352163797, 0.0439453125, 0.00134891534866512, 2.65485174890424e-06, 7.5125341372317e-12, 0.00165075750525087, 0.098316074948758, 0.266773469998823, 0.1171875, 0.00851120930033936, 4.77015083317429e-05, 7.67256910464728e-10, 7.54285416782925e-05, 0.0255352124570861, 0.197307159628971, 0.205078125, 0.035242536724582, 0.000562462101924716, 5.14238366256899e-08, 2.36336793707985e-06, 0.00454776082828218, 0.1000659329628, 0.24609375, 0.1000659329628, 0.00454776082828218, 2.36336793707987e-06, 5.14238366256893e-08, 0.000562462101924716, 0.035242536724582, 0.205078125, 0.197307159628971, 0.0255352124570861, 7.54285416782932e-05, 7.67256910464717e-10, 4.77015083317429e-05, 0.00851120930033936, 0.1171875, 0.266773469998823, 0.098316074948758, 0.00165075750525088, 7.51253413723157e-12, 2.65485174890424e-06, 0.00134891534866512, 0.0439453125, 0.236707352163797, 0.248415622643954, 0.0237082864667016, 4.35901463113127e-14, 8.75597787641342e-08, 0.000126687667637045, 0.009765625, 0.124462085975776, 0.371954224882065, 0.201777747856344, 1.13815840211787e-16, 1.29951575909081e-09, 5.35422353688742e-06, 0.0009765625, 0.0294492960050725, 0.250618196918555, 0.772785364063438, 

0.818281947367293, 0.342274614952593, 0.0666675399641295, 0.00526190284373216, 0.000128709189423396, 5.64632098347949e-07, 1.17974973503993e-10, 9.52170250575136e-18, 0.165761677783144, 0.387361282826356, 0.207347853234545, 0.036306927501162, 0.00186536095575633, 1.81543393840022e-05, 1.04243352189183e-08, 4.70038513898933e-15, 0.015110464381438, 0.197274178671264, 0.290199841164804, 0.11273238231017, 0.0121654652622841, 0.000262668413193709, 4.14495063554442e-07, 1.04415457200737e-12, 0.000816258482709448, 0.0595361156064315, 0.24068610343966, 0.207426428708215, 0.0470165526083243, 0.00225211969943059, 9.76667137838826e-06, 1.37452411270825e-10, 2.8936561298882e-05, 0.0117912558920706, 0.13100086944455, 0.250466018321366, 0.119245543639719, 0.0126719778389951, 0.000151023003816402, 1.18743336500424e-08, 7.03411282471979e-07, 0.00160133733871637, 0.0488923078292098, 0.207384708659849, 0.207384708659849, 0.0488923078292098, 0.00160133733871637, 7.03411282471979e-07, 1.18743336500424e-08, 0.000151023003816402, 0.0126719778389951, 0.119245543639719, 0.250466018321366, 0.13100086944455, 0.0117912558920706, 2.8936561298882e-05, 1.37452411270825e-10, 9.76667137838826e-06, 0.00225211969943059, 0.0470165526083244, 0.207426428708215, 0.24068610343966, 0.0595361156064315, 0.000816258482709448, 1.04415457200737e-12, 4.14495063554442e-07, 0.000262668413193709, 0.0121654652622841, 0.11273238231017, 0.290199841164804, 0.197274178671264, 0.015110464381438, 4.70038513898933e-15, 1.04243352189183e-08, 1.81543393840022e-05, 0.00186536095575633, 0.036306927501162, 0.207347853234545, 0.387361282826356, 0.165761677783144, 9.52170250575136e-18, 1.17974973503993e-10, 5.64632098347949e-07, 0.000128709189423397, 0.00526190284373216, 0.0666675399641295, 0.342274614952593, 0.818281947367293, 

0.851735175536328, 0.425109092327014, 0.116692695393162, 0.016196123758113, 0.0009765625, 1.9388248850336e-05, 7.28852159084509e-08, 1.37187543948259e-11, 1.04567798624335e-18, 0.13778880117399, 0.379648617368653, 0.279642546779476, 0.0826463801433249, 0.009765625, 0.000379949463350445, 3.04144429973912e-06, 1.53614868113128e-09, 6.4638106695102e-16, 0.0100308046719505, 0.152572325250515, 0.301561114580719, 0.1897794135043, 0.0439453125, 0.00335062326239977, 5.71127147104239e-05, 7.74041663100339e-08, 1.79800875742044e-13, 0.000432726850710203, 0.0363350637130233, 0.192709732874338, 0.258244203548962, 0.1171875, 0.0175098159751717, 0.000635538637691468, 2.31127510208108e-06, 2.96381571713476e-11, 1.22507091979402e-05, 0.00567865394127341, 0.0808167302503907, 0.230611723128175, 0.205078125, 0.0600491522486233, 0.00464109469919465, 4.52906194747668e-05, 3.20612098916594e-09, 2.3782188394684e-07, 0.00060856655091096, 0.0232403197408021, 0.141213226718729, 0.24609375, 0.141213226718729, 0.0232403197408022, 0.00060856655091096, 2.37821883946844e-07, 3.20612098916587e-09, 4.52906194747668e-05, 0.00464109469919464, 0.0600491522486233, 0.205078125, 0.230611723128175, 0.0808167302503908, 0.00567865394127341, 1.22507091979404e-05, 2.96381571713469e-11, 2.31127510208108e-06, 0.000635538637691467, 0.0175098159751717, 0.1171875, 0.258244203548962, 0.192709732874338, 0.0363350637130233, 0.000432726850710207, 1.79800875742039e-13, 7.74041663100339e-08, 5.71127147104238e-05, 0.00335062326239977, 0.0439453125, 0.1897794135043, 0.301561114580719, 0.152572325250515, 0.0100308046719506, 6.46381066951e-16, 1.53614868113128e-09, 3.04144429973911e-06, 0.000379949463350445, 0.009765625, 0.0826463801433249, 0.279642546779476, 0.379648617368653, 0.13778880117399, 1.04567798624332e-18, 1.37187543948259e-11, 7.28852159084507e-08, 1.9388248850336e-05, 0.0009765625, 0.016196123758113, 0.116692695393162, 0.425109092327014, 0.851735175536328, 

0.876931918350956, 0.497320041900762, 0.174287514096617, 0.0357569189193685, 0.00391223861797812, 0.000194821502386827, 3.33043566515876e-06, 1.11996798052475e-08, 1.95433381178948e-12, 1.4289553520786e-19, 0.115923412143846, 0.359809180378225, 0.33270567489333, 0.141342961156707, 0.0289832104940196, 0.00262975768473797, 8.42533063342464e-05, 5.86694035970531e-07, 2.70123561646077e-10, 1.08096935292176e-16, 0.00689586812936851, 0.117144265100074, 0.285802915980478, 0.2514205634193, 0.096622920444114, 0.01597375766058, 0.000959147437115043, 1.38302571165428e-05, 1.68011381434872e-08, 3.67976951215e-14, 0.000243087685302831, 0.0226009160891357, 0.145488719281871, 0.265023035193131, 0.190884228714792, 0.0574982555106884, 0.00647053226374083, 0.000193199079671614, 6.19257330915707e-07, 7.42307880166008e-12, 5.62349463468357e-06, 0.0028615436168246, 0.0486028014574891, 0.183330941190596, 0.247473813891624, 0.135822450557361, 0.028645998169703, 0.00177112481871258, 1.49786587576945e-05, 9.82690689753169e-10, 8.92057418711813e-08, 0.000248437925674829, 0.0111336222409986, 0.0869623185083395, 0.220004544921719, 0.220004544921719, 0.0869623185083395, 0.0111336222409986, 0.000248437925674828, 8.92057418711813e-08, 9.82690689753169e-10, 1.49786587576946e-05, 0.00177112481871258, 0.028645998169703, 0.135822450557361, 0.247473813891624, 0.183330941190596, 0.0486028014574891, 0.00286154361682459, 5.62349463468356e-06, 7.42307880166008e-12, 6.1925733091571e-07, 0.000193199079671614, 0.00647053226374083, 0.0574982555106884, 0.190884228714792, 0.265023035193131, 0.145488719281871, 0.0226009160891356, 0.000243087685302831, 3.67976951215e-14, 1.68011381434873e-08, 1.38302571165428e-05, 0.000959147437115043, 0.01597375766058, 0.096622920444114, 0.2514205634193, 0.285802915980478, 0.117144265100074, 0.00689586812936851, 1.08096935292176e-16, 2.70123561646079e-10, 5.86694035970531e-07, 8.42533063342464e-05, 0.00262975768473797, 0.0289832104940195, 0.141342961156707, 0.33270567489333, 0.359809180378225, 0.115923412143846, 1.4289553520786e-19, 1.9543338117895e-12, 1.11996798052475e-08, 3.33043566515876e-06, 0.000194821502386827, 0.00391223861797812, 0.0357569189193685, 0.174287514096617, 0.497320041900762, 0.876931918350956, 

0.896323812333893, 0.559194790015995, 0.234715974685804, 0.0639076156372074, 0.0106212279330999, 0.0009765625, 4.22323909302519e-05, 6.46074753540428e-07, 1.99936456001886e-09, 3.29668844496318e-13, 2.33642591620061e-20, 0.0986446741118331, 0.33466831368177, 0.366081331724848, 0.202313857182584, 0.0611113422930709, 0.009765625, 0.000734004250927483, 2.04084374630368e-05, 1.28190858366359e-07, 5.50841214230483e-11, 2.1229673099943e-17, 0.00488534078703268, 0.0901319128540668, 0.256936042498068, 0.288211402975878, 0.158227304900415, 0.0439453125, 0.00574068867119621, 0.000290101018233766, 3.69857674972842e-06, 4.14178414982844e-09, 8.68054739345246e-15, 0.000143374628151332, 0.0143846334395307, 0.106863328448169, 0.243306049578672, 0.242771251454407, 0.1171875, 0.0266063704191303, 0.0024436835752698, 6.32365886325498e-05, 1.84546033452269e-07, 2.1033286464166e-12, 2.76133476894547e-06, 0.00150656657190972, 0.0291676661018242, 0.134791954811336, 0.244445698698799, 0.205078125, 0.0809238595747051, 0.0135085894497641, 0.00070953128275707, 5.3962403478335e-06, 3.34454063928206e-10, 3.64677539051921e-08, 0.00010819845314852, 0.00545905990292564, 0.0512056912588394, 0.168776019413319, 0.24609375, 0.168776019413319, 0.0512056912588394, 0.00545905990292563, 0.00010819845314852, 3.6467753905193e-08, 3.34454063928195e-10, 5.3962403478335e-06, 0.000709531282757072, 0.0135085894497641, 0.080923859574705, 0.205078125, 0.2444456986988, 0.134791954811335, 0.0291676661018241, 0.00150656657190972, 2.76133476894553e-06, 2.10332864641652e-12, 1.84546033452269e-07, 6.323658863255e-05, 0.0024436835752698, 0.0266063704191303, 0.1171875, 0.242771251454407, 0.243306049578671, 0.106863328448169, 0.0143846334395307, 0.000143374628151334, 8.6805473934521e-15, 4.14178414982844e-09, 3.69857674972843e-06, 0.000290101018233766, 0.0057406886711962, 0.0439453125, 0.158227304900415, 0.288211402975878, 0.256936042498068, 0.0901319128540668, 0.00488534078703272, 2.1229673099942e-17, 5.50841214230483e-11, 1.28190858366359e-07, 2.04084374630368e-05, 0.000734004250927482, 0.009765625, 0.0611113422930709, 0.202313857182584, 0.366081331724847, 0.33466831368177, 0.0986446741118336, 2.33642591620049e-20, 3.29668844496318e-13, 1.99936456001887e-09, 6.4607475354043e-07, 4.22323909302519e-05, 0.0009765625, 0.0106212279330999, 0.0639076156372074, 0.234715974685804, 0.559194790015995, 0.896323812333893, 

0.911535743182133, 0.611838684527693, 0.294573651207087, 0.099160641929744, 0.0223885542447087, 0.00317779753275875, 0.000256225251025963, 9.95470898209303e-06, 1.3991226605665e-07, 4.06270937776451e-10, 6.41363985904255e-14, 4.43771933524246e-21, 0.0848227436255752, 0.308094323156433, 0.382962353714874, 0.257804786087803, 0.10347282385909, 0.0247044843775957, 0.00329588732999106, 0.000215391378841062, 5.38150991164976e-06, 3.12502553734664e-08, 1.27367259941317e-11, 4.76893297644326e-18, 0.00355192218241913, 0.0698140726677376, 0.22404269252473, 0.301616527448364, 0.215198414428977, 0.0864246994756985, 0.0190781078829061, 0.0020972035217834, 9.31461721365896e-05, 1.08169269949086e-06, 1.13821303778684e-09, 2.30619018623774e-15, 8.8139541621063e-05, 0.00937472354910661, 0.0776715016298326, 0.209110342776155, 0.265221087377451, 0.179166240435485, 0.0654416833622706, 0.0121006600080379, 0.000955393095427062, 2.21876059883982e-05, 6.02761527155804e-08, 6.60884002089816e-13, 1.43531574562011e-06, 0.000826120277197413, 0.0176710329243542, 0.0951404516381722, 0.21450941171298, 0.243749537182748, 0.147313633149292, 0.0458191317821208, 0.00643085179418168, 0.000298666359167054, 2.09477223773903e-06, 1.24286705126791e-10, 1.60275561883032e-08, 4.99196224270298e-05, 0.00275680068473996, 0.0296823376358382, 0.118967366977026, 0.227391704020228, 0.227391704020228, 0.118967366977026, 0.0296823376358382, 0.00275680068473996, 4.99196224270301e-05, 1.60275561883027e-08, 1.24286705126795e-10, 2.09477223773901e-06, 0.000298666359167053, 0.00643085179418167, 0.0458191317821208, 0.147313633149292, 0.243749537182748, 0.21450941171298, 0.0951404516381723, 0.0176710329243542, 0.000826120277197417, 1.43531574562008e-06, 6.60884002089844e-13, 6.02761527155799e-08, 2.21876059883982e-05, 0.00095539309542706, 0.0121006600080379, 0.0654416833622706, 0.179166240435485, 0.265221087377452, 0.209110342776155, 0.0776715016298327, 0.00937472354910664, 8.81395416210614e-05, 2.30619018623785e-15, 1.13821303778683e-09, 1.08169269949085e-06, 9.31461721365894e-05, 0.00209720352178339, 0.0190781078829061, 0.0864246994756985, 0.215198414428977, 0.301616527448364, 0.224042692524731, 0.0698140726677377, 0.00355192218241908, 4.76893297644352e-18, 1.27367259941316e-11, 3.12502553734663e-08, 5.38150991164975e-06, 0.000215391378841062, 0.00329588732999106, 0.0247044843775957, 0.10347282385909, 0.257804786087803, 0.382962353714875, 0.308094323156434, 0.0848227436255747, 4.43771933524272e-21, 6.41363985904247e-14, 4.06270937776449e-10, 1.3991226605665e-07, 9.95470898209301e-06, 0.000256225251025963, 0.00317779753275875, 0.0223885542447087, 0.099160641929744, 0.294573651207087, 0.611838684527693, 0.911535743182133, 

0.923671209348314, 0.656563337712019, 0.351747452013348, 0.139429748773788, 0.0397066551993873, 0.0077690711892159, 0.0009765625, 7.11248784618402e-05, 2.54221510477788e-06, 3.34418549107212e-08, 9.23838985884738e-11, 1.40947224897598e-14, 9.57031351777494e-22, 0.0736305903910159, 0.282133475189055, 0.387407025913447, 0.303632975963602, 0.151181344600374, 0.0485885953948207, 0.009765625, 0.00113725091166819, 6.67693880319147e-05, 1.53566634649402e-06, 8.38802570989386e-09, 3.28003546399457e-12, 1.20056392511072e-18, 0.00264126315068278, 0.0545563268044144, 0.192006768750192, 0.297546565252295, 0.25902734637765, 0.136745203541627, 0.0439453125, 0.00818283066104375, 0.000789141731712612, 3.17333476364439e-05, 3.42717068376441e-07, 3.43489181414912e-10, 6.77730338739794e-16, 5.6146317923386e-05, 0.00625160953133838, 0.0563925591583743, 0.172789427201085, 0.262996063284587, 0.228058402529567, 0.1171875, 0.03489048869369, 0.00552699209943528, 0.000388589561649461, 8.29789497862333e-06, 2.13159064296664e-08, 2.2671736417213e-13, 7.83249641917534e-07, 0.000470119086348759, 0.0108691700902893, 0.0658489273635239, 0.175235541690802, 0.249602752501347, 0.205078125, 0.097629228525555, 0.0254034085874624, 0.00312273900335325, 0.000131846756408597, 8.68088221692636e-07, 4.97716406262445e-11, 7.49242366429878e-09, 2.42419259131625e-05, 0.00143652822548375, 0.0172077244248667, 0.0800641948254532, 0.187325051173004, 0.24609375, 0.187325051173004, 0.0800641948254532, 0.0172077244248667, 0.00143652822548375, 2.42419259131624e-05, 7.49242366429852e-09, 4.97716406262466e-11, 8.68088221692643e-07, 0.000131846756408597, 0.00312273900335326, 0.0254034085874624, 0.097629228525555, 0.205078125, 0.249602752501347, 0.175235541690802, 0.0658489273635238, 0.0108691700902893, 0.000470119086348756, 7.83249641917512e-07, 2.26717364172141e-13, 2.13159064296666e-08, 8.2978949786233e-06, 0.000388589561649462, 0.00552699209943528, 0.03489048869369, 0.1171875, 0.228058402529567, 0.262996063284586, 0.172789427201085, 0.0563925591583744, 0.00625160953133836, 5.61463179233848e-05, 6.77730338739832e-16, 3.43489181414916e-10, 3.42717068376439e-07, 3.1733347636444e-05, 0.000789141731712611, 0.00818283066104375, 0.0439453125, 0.136745203541627, 0.25902734637765, 0.297546565252295, 0.192006768750192, 0.0545563268044142, 0.00264126315068275, 1.20056392511079e-18, 3.28003546399461e-12, 8.38802570989381e-09, 1.53566634649403e-06, 6.67693880319147e-05, 0.00113725091166819, 0.009765625, 0.0485885953948207, 0.151181344600374, 0.303632975963602, 0.387407025913448, 0.282133475189055, 0.0736305903910154, 9.57031351777561e-22, 1.409472248976e-14, 9.23838985884733e-11, 3.34418549107213e-08, 2.54221510477788e-06, 7.11248784618402e-05, 0.0009765625, 0.0077690711892159, 0.0397066551993873, 0.139429748773788, 0.351747452013348, 0.656563337712019, 0.923671209348314, 

0.933497303443, 0.694624076131893, 0.405101671102788, 0.182643762925046, 0.0623073186006732, 0.0155782249028378, 0.00272466441833927, 0.000311229708621698, 2.09148373931298e-05, 6.99665464912018e-07, 8.73126956130323e-09, 2.31795165266093e-11, 3.44123126042938e-15, 2.301629314977e-22, 0.0644622260875951, 0.257778228549892, 0.383105219180129, 0.338494877775408, 0.199330703435817, 0.080410288768823, 0.0219325850871026, 0.00386637739985471, 0.000405191979415929, 2.18703281956752e-05, 4.71118481399128e-07, 2.45103966486791e-09, 9.27294014889742e-13, 3.3330601337546e-19, 0.00200313419179564, 0.0430482153281518, 0.163036414669878, 0.282300644710459, 0.286960321853823, 0.186774588317726, 0.0794472994231299, 0.0216142392670006, 0.00353247991813784, 0.000307632826998275, 1.14391933361878e-05, 1.16629608919439e-07, 1.12443296087683e-10, 2.17201805795598e-16, 3.68868022590083e-05, 0.0042601048330371, 0.0411156710076686, 0.139517233908357, 0.244808064704287, 0.257087033128668, 0.170539377772904, 0.0716031097734411, 0.0182496601606852, 0.00256428487713022, 0.000164595090634111, 3.28869439223968e-06, 8.07989835309304e-09, 8.38764290630702e-14, 4.45760197878723e-07, 0.000276665328960624, 0.00680455086569735, 0.0452494350178373, 0.137056269584908, 0.232226551662206, 0.240236795031616, 0.15566577225979, 0.0618727156423356, 0.0140271416354557, 0.00155420274281407, 6.08565786329956e-05, 3.81019798707458e-07, 2.12562059881725e-11, 3.69381180434409e-09, 1.23206149947099e-05, 0.00077220879698535, 0.0100633287863576, 0.0526156924872454, 0.143842350681772, 0.232058549858201, 0.232058549858201, 0.143842350681772, 0.0526156924872455, 0.0100633287863576, 0.00077220879698535, 1.23206149947098e-05, 3.69381180434409e-09, 2.12562059881725e-11, 3.81019798707462e-07, 6.08565786329956e-05, 0.00155420274281407, 0.0140271416354557, 0.0618727156423356, 0.15566577225979, 0.240236795031616, 0.232226551662206, 0.137056269584909, 0.0452494350178373, 0.00680455086569735, 0.000276665328960622, 4.45760197878723e-07, 8.38764290630702e-14, 8.07989835309313e-09, 3.28869439223968e-06, 0.00016459509063411, 0.00256428487713022, 0.0182496601606852, 0.071603109773441, 0.170539377772904, 0.257087033128668, 0.244808064704288, 0.139517233908357, 0.0411156710076686, 0.00426010483303708, 3.68868022590083e-05, 2.17201805795598e-16, 1.12443296087684e-10, 1.16629608919439e-07, 1.14391933361878e-05, 0.000307632826998274, 0.00353247991813784, 0.0216142392670006, 0.0794472994231299, 0.186774588317726, 0.286960321853823, 0.282300644710459, 0.163036414669878, 0.0430482153281517, 0.00200313419179564, 3.3330601337546e-19, 9.27294014889755e-13, 2.45103966486791e-09, 4.71118481399127e-07, 2.18703281956752e-05, 0.000405191979415929, 0.0038663773998547, 0.0219325850871026, 0.080410288768823, 0.199330703435817, 0.338494877775408, 0.383105219180129, 0.257778228549892, 0.0644622260875951, 2.301629314977e-22, 3.44123126042943e-15, 2.31795165266093e-11, 8.7312695613032e-09, 6.99665464912016e-07, 2.09148373931298e-05, 0.000311229708621698, 0.00272466441833927, 0.0155782249028378, 0.0623073186006732, 0.182643762925046, 0.405101671102788, 0.694624076131893, 0.933497303443, 

0.941558913236739, 0.727125172760599, 0.454156121415248, 0.227051743859201, 0.0894097675425855, 0.027089392792717, 0.00610705632372024, 0.0009765625, 0.000103302947965514, 6.50641123602467e-06, 2.06326335222884e-07, 2.46724770334361e-09, 6.34204626411259e-12, 9.20911822789648e-16, 6.08442411163037e-23, 0.0568701923214448, 0.235434480059637, 0.372998938286871, 0.362855435393799, 0.244175415613358, 0.117720878485378, 0.0406125261858676, 0.009765625, 0.00155340477650777, 0.000149722574203787, 7.55505611564214e-06, 1.54384594781889e-07, 7.72194995078038e-10, 2.8441805468493e-13, 1.00735438379339e-19, 0.00154573275038311, 0.0343038976160445, 0.137855003227328, 0.260948580004793, 0.300076108605264, 0.230207904689273, 0.121534785025016, 0.0439453125, 0.0105116059245203, 0.00155040648152409, 0.000124489647828907, 4.34718061877223e-06, 4.2309420101361e-08, 3.95283593097674e-11, 7.50511923837816e-17, 2.48966170340218e-05, 0.00296191837913866, 0.0301921255219998, 0.111207086107209, 0.21853304711011, 0.266773808052627, 0.215524878225477, 0.1171875, 0.0421511787701504, 0.00951393289092093, 0.00121558407189971, 7.25383422035608e-05, 1.3737363236342e-06, 3.25549201173672e-09, 3.31351644876116e-14, 2.63157399202891e-07, 0.000167830938119932, 0.00433944472137981, 0.0311013543363612, 0.104441268971437, 0.202878236297176, 0.250820792688966, 0.205078125, 0.110922511430144, 0.0383128014081213, 0.00778943718768813, 0.000794322534625231, 2.92710975544643e-05, 1.75951833138315e-07, 9.60041444117728e-12, 1.90736596847022e-09, 6.52099932189202e-06, 0.000427678905338183, 0.0059644353893474, 0.0342271198673778, 0.105796409916823, 0.200157957701666, 0.24609375, 0.200157957701666, 0.105796409916823, 0.0342271198673778, 0.00596443538934739, 0.000427678905338185, 6.52099932189202e-06, 1.90736596847031e-09, 9.60041444117674e-12, 1.75951833138315e-07, 2.92710975544641e-05, 0.000794322534625233, 0.00778943718768813, 0.0383128014081213, 0.110922511430144, 0.205078125, 0.250820792688966, 0.202878236297176, 0.104441268971437, 0.0311013543363611, 0.00433944472137982, 0.000167830938119932, 2.63157399202901e-07, 3.31351644876094e-14, 3.25549201173672e-09, 1.37373632363419e-06, 7.2538342203561e-05, 0.00121558407189971, 0.00951393289092093, 0.0421511787701504, 0.1171875, 0.215524878225477, 0.266773808052627, 0.21853304711011, 0.111207086107209, 0.0301921255219998, 0.00296191837913866, 2.48966170340225e-05, 7.50511923837761e-17, 3.95283593097674e-11, 4.23094201013608e-08, 4.34718061877224e-06, 0.000124489647828907, 0.00155040648152409, 0.0105116059245203, 0.0439453125, 0.121534785025016, 0.230207904689273, 0.300076108605264, 0.260948580004793, 0.137855003227328, 0.0343038976160445, 0.00154573275038313, 1.0073543837933e-19, 2.8441805468493e-13, 7.72194995078033e-10, 1.5438459478189e-07, 7.55505611564214e-06, 0.000149722574203787, 0.00155340477650777, 0.009765625, 0.0406125261858676, 0.117720878485378, 0.244175415613358, 0.362855435393799, 0.372998938286871, 0.235434480059637, 0.0568701923214453, 6.08442411162981e-23, 9.20911822789648e-16, 6.34204626411255e-12, 2.46724770334362e-09, 2.06326335222884e-07, 6.50641123602467e-06, 0.000103302947965514, 0.0009765625, 0.00610705632372024, 0.027089392792717, 0.0894097675425855, 0.227051743859201, 0.454156121415248, 0.727125172760599, 0.941558913236739, 

0.94825080605256, 0.755000214987899, 0.49883625467001, 0.271313803702638, 0.119992202652067, 0.0423960366096015, 0.011674467036035, 0.00242042065757596, 0.000359853559072057, 3.575541428079e-05, 2.13578961474489e-06, 6.48246853939254e-08, 7.48490509416279e-10, 1.87363224824027e-12, 2.67150045983515e-16, 1.74733269012327e-23, 0.0505205952243785, 0.21519287761536, 0.359278016253035, 0.378044854064652, 0.283407777810203, 0.157597229938297, 0.0654406400491995, 0.0200038848538962, 0.00435413918067315, 0.000637868769417644, 5.74559684409323e-05, 2.74461655454411e-06, 5.37173843160756e-08, 2.60142744910636e-10, 9.37290975364439e-14, 3.27967163587943e-20, 0.0012112288610676, 0.0276007716894553, 0.116443645162975, 0.237043082144952, 0.301219454569868, 0.263623677864495, 0.165070903071949, 0.0743961317624482, 0.0237078038747271, 0.0051207476918437, 0.000695543572743644, 5.22920241504567e-05, 1.73482603140164e-06, 1.62536759852101e-08, 1.47981059171977e-11, 2.77011398287005e-17, 1.72083876610142e-05, 0.00209783233306007, 0.0223643952353871, 0.0880780028376195, 0.18971885253885, 0.261322297711707, 0.246745780449698, 0.163961764105555, 0.0764956189437002, 0.024360804981262, 0.0049896462072179, 0.000590398772861767, 3.3201157254667e-05, 6.0179378169889e-07, 1.38450346160224e-09, 1.38650402168209e-14, 1.60443995237339e-07, 0.000104638050851113, 0.00281882322894154, 0.0214771647187215, 0.0784164680138645, 0.169995661586231, 0.242046194197959, 0.237139623596028, 0.161976166580125, 0.0760535006067494, 0.0234900791636845, 0.00437446308127993, 0.000416984421006486, 1.46222131466614e-05, 8.50063319847299e-08, 4.55421934965902e-12, 1.02576990237139e-09, 3.57891764643921e-06, 0.0002436249270291, 0.00359111766124973, 0.0222252810956142, 0.0758302355879672, 0.162813337731606, 0.235184592886199, 0.235184592886199, 0.162813337731606, 0.0758302355879672, 0.0222252810956142, 0.00359111766124972, 0.000243624927029101, 3.57891764643921e-06, 1.02576990237134e-09, 4.5542193496593e-12, 8.50063319847299e-08, 1.46222131466614e-05, 0.000416984421006487, 0.00437446308127993, 0.0234900791636845, 0.0760535006067495, 0.161976166580125, 0.237139623596028, 0.242046194197959, 0.169995661586231, 0.0784164680138646, 0.0214771647187214, 0.00281882322894155, 0.000104638050851113, 1.60443995237332e-07, 1.38650402168219e-14, 1.38450346160224e-09, 6.01793781698886e-07, 3.32011572546671e-05, 0.000590398772861767, 0.0049896462072179, 0.024360804981262, 0.0764956189437002, 0.163961764105555, 0.246745780449697, 0.261322297711707, 0.18971885253885, 0.0880780028376194, 0.0223643952353871, 0.00209783233306007, 1.72083876610136e-05, 2.77011398287028e-17, 1.47981059171977e-11, 1.625367598521e-08, 1.73482603140164e-06, 5.22920241504567e-05, 0.000695543572743644, 0.00512074769184371, 0.0237078038747271, 0.0743961317624481, 0.165070903071949, 0.263623677864495, 0.301219454569868, 0.237043082144952, 0.116443645162976, 0.0276007716894553, 0.00121122886106757, 3.27967163587973e-20, 9.37290975364439e-14, 2.60142744910634e-10, 5.37173843160758e-08, 2.74461655454411e-06, 5.74559684409323e-05, 0.000637868769417645, 0.00435413918067314, 0.0200038848538962, 0.0654406400491995, 0.157597229938296, 0.283407777810203, 0.378044854064652, 0.359278016253036, 0.21519287761536, 0.050520595224378, 1.74733269012345e-23, 2.67150045983515e-16, 1.87363224824026e-12, 7.48490509416283e-10, 6.48246853939254e-08, 2.13578961474489e-06, 3.575541428079e-05, 0.000359853559072057, 0.00242042065757595, 0.011674467036035, 0.0423960366096015, 0.119992202652067, 0.271313803702638, 0.49883625467001, 0.755000214987899, 0.94825080605256, 

0.953864166743492, 0.779023189279712, 0.539300675660393, 0.314479578576031, 0.152997332353123, 0.0612633786554942, 0.0198152018163868, 0.00504588813372901, 0.0009765625, 0.000136728593532969, 1.29001818249286e-05, 7.37477020326587e-07, 2.1584149374733e-08, 2.42067287424215e-10, 5.92718667759478e-13, 8.32386526604478e-17, 5.39876727272669e-24, 0.0451613942683943, 0.196982593529499, 0.343504735473002, 0.385679729875862, 0.315957716560216, 0.197358437941825, 0.0951389235134839, 0.0351746504989077, 0.009765625, 0.00196140452815839, 0.00026868046945351, 2.28925271283872e-05, 1.04517696589193e-06, 1.97379360747614e-08, 9.30565273165902e-11, 3.29190714291096e-14, 1.14028601850439e-20, 0.000962189608875641, 0.0224139206757991, 0.0984570924494935, 0.212850019132546, 0.293620644905046, 0.28610336626455, 0.205556152444465, 0.110340380566994, 0.0439453125, 0.0126615686642653, 0.00251819222709067, 0.00031978014601911, 2.27749397013267e-05, 7.24235629219425e-07, 6.57442221118261e-09, 5.85844860654962e-12, 1.08379091418576e-17, 1.21481515719335e-05, 0.00151134644398819, 0.0167231275730135, 0.069610826669955, 0.161696428858888, 0.245779951830131, 0.26318367411519, 0.205114037119551, 0.1171875, 0.0484355319687933, 0.0139861402251235, 0.00264707029185179, 0.000294090408192716, 1.5747595587664e-05, 2.75248245466757e-07, 6.17836968696035e-10, 6.10426572832036e-15, 1.00653540967926e-07, 6.68774249754844e-05, 0.00186404896227436, 0.0149399521136227, 0.0584364177412519, 0.13856044142769, 0.221134613863169, 0.250222065165851, 0.205078125, 0.121593385280291, 0.0509772253749751, 0.0143796649786086, 0.0024921478330856, 0.000224707690621428, 7.56242087791819e-06, 4.27596827248967e-08, 2.25626793957289e-12, 5.71861831901885e-10, 2.02926261526451e-06, 0.000142475544628761, 0.0021986941301426, 0.0144813796393814, 0.0535642784596821, 0.127408295768838, 0.209314359479926, 0.24609375, 0.209314359479926, 0.127408295768838, 0.0535642784596821, 0.0144813796393814, 0.00219869413014259, 0.000142475544628761, 2.02926261526449e-06, 5.71861831901918e-10, 2.25626793957273e-12, 4.27596827248973e-08, 7.56242087791819e-06, 0.000224707690621429, 0.0024921478330856, 0.0143796649786086, 0.0509772253749751, 0.121593385280291, 0.205078125, 0.250222065165851, 0.221134613863169, 0.13856044142769, 0.0584364177412518, 0.0149399521136227, 0.00186404896227436, 6.68774249754838e-05, 1.00653540967931e-07, 6.10426572831986e-15, 6.17836968696045e-10, 2.75248245466757e-07, 1.57475955876641e-05, 0.000294090408192717, 0.00264707029185179, 0.0139861402251235, 0.0484355319687933, 0.1171875, 0.205114037119551, 0.26318367411519, 0.245779951830131, 0.161696428858888, 0.0696108266699549, 0.0167231275730135, 0.00151134644398818, 1.21481515719339e-05, 1.08379091418566e-17, 5.85844860654973e-12, 6.57442221118261e-09, 7.24235629219428e-07, 2.27749397013268e-05, 0.00031978014601911, 0.00251819222709067, 0.0126615686642653, 0.0439453125, 0.110340380566994, 0.205556152444465, 0.28610336626455, 0.293620644905046, 0.212850019132545, 0.0984570924494935, 0.022413920675799, 0.000962189608875664, 1.14028601850427e-20, 3.29190714291103e-14, 9.30565273165902e-11, 1.97379360747615e-08, 1.04517696589193e-06, 2.28925271283872e-05, 0.00026868046945351, 0.00196140452815839, 0.009765625, 0.0351746504989077, 0.0951389235134839, 0.197358437941825, 0.315957716560216, 0.385679729875862, 0.343504735473002, 0.196982593529499, 0.0451613942683948, 5.39876727272605e-24, 8.32386526604497e-17, 5.92718667759478e-13, 2.42067287424217e-10, 2.15841493747331e-08, 7.37477020326589e-07, 1.29001818249286e-05, 0.000136728593532969, 0.0009765625, 0.00504588813372901, 0.0198152018163868, 0.0612633786554942, 0.152997332353123, 0.314479578576031, 0.539300675660393, 0.779023189279712, 0.953864166743492, 

0.958617303406749, 0.79982991249792, 0.575829699631459, 0.355922166534538, 0.187456400338528, 0.0832353840522244, 0.0307101247365599, 0.00923312368235811, 0.00220341739335867, 0.000402697309589852, 5.3626142025046e-05, 4.84519016456138e-06, 2.66985817613996e-07, 7.5791029787698e-09, 8.29455947560227e-11, 1.99362337855672e-13, 2.76419638040961e-17, 1.78018114373359e-24, 0.0406001050391349, 0.180656988869348, 0.326760059508523, 0.387345812489669, 0.341642606549017, 0.234923254214993, 0.127963027059908, 0.0551761563064615, 0.0185902388131678, 0.00477299008972669, 0.000897374581829956, 0.000116280770895153, 9.45954334740349e-06, 4.1585895171168e-07, 7.62165869312111e-09, 3.51324318210508e-11, 1.22380371936179e-14, 4.20322175505829e-21, 0.000773787240746493, 0.0183621870135309, 0.0834404016521852, 0.189694704775925, 0.280192363021321, 0.298370953648158, 0.239938502225569, 0.148377055075893, 0.0705806539775549, 0.0254574471553447, 0.00675746006271106, 0.00125579136201721, 0.000150821989398143, 1.02680225735716e-05, 3.15150631355197e-07, 2.78603020270286e-09, 2.43818781965778e-12, 4.46594040891474e-18, 8.73921028843073e-06, 0.00110598761497857, 0.0126264139677562, 0.0550513241040586, 0.136174810519298, 0.224565633770294, 0.2666070321879, 0.236449428956247, 0.158797114214449, 0.0804628456418592, 0.0301543124007233, 0.00803680255809892, 0.00142500168156604, 0.000150239383756746, 7.72223626398686e-06, 1.30924114956566e-07, 2.87858305422582e-10, 2.81189929457405e-15, 6.47727195424872e-08, 4.37165053434211e-05, 0.00125387134750373, 0.0104845464177872, 0.0434316752984702, 0.110917319147433, 0.194407302288855, 0.247274372402104, 0.234460048228998, 0.166895735944741, 0.0883048766953601, 0.0337534697129237, 0.00883558695004361, 0.00144261382141562, 0.000124175896644691, 4.03759533312787e-06, 2.23028153069567e-08, 1.16186566613089e-12, 3.29196546870121e-10, 1.18490575496006e-06, 8.53825517624902e-05, 0.00136922468987815, 0.00949859960756553, 0.0375663180167253, 0.097206821907109, 0.177322213694286, 0.237376811231211, 0.237376811231211, 0.177322213694286, 0.097206821907109, 0.0375663180167253, 0.00949859960756553, 0.00136922468987816, 8.53825517624902e-05, 1.18490575496006e-06, 3.29196546870121e-10, 1.16186566613089e-12, 2.23028153069567e-08, 4.03759533312787e-06, 0.000124175896644691, 0.00144261382141562, 0.00883558695004361, 0.0337534697129237, 0.0883048766953601, 0.166895735944741, 0.234460048228998, 0.247274372402104, 0.194407302288855, 0.110917319147433, 0.0434316752984702, 0.0104845464177873, 0.00125387134750373, 4.37165053434211e-05, 6.47727195424872e-08, 2.81189929457405e-15, 2.87858305422582e-10, 1.30924114956566e-07, 7.72223626398683e-06, 0.000150239383756746, 0.00142500168156604, 0.00803680255809892, 0.0301543124007233, 0.0804628456418593, 0.158797114214449, 0.236449428956247, 0.2666070321879, 0.224565633770294, 0.136174810519298, 0.0550513241040587, 0.0126264139677562, 0.00110598761497857, 8.73921028843073e-06, 4.46594040891474e-18, 2.43818781965778e-12, 2.78603020270286e-09, 3.15150631355195e-07, 1.02680225735716e-05, 0.000150821989398143, 0.00125579136201721, 0.00675746006271106, 0.0254574471553447, 0.0705806539775549, 0.148377055075893, 0.239938502225569, 0.298370953648158, 0.280192363021321, 0.189694704775925, 0.0834404016521852, 0.0183621870135309, 0.000773787240746493, 4.20322175505829e-21, 1.22380371936179e-14, 3.51324318210508e-11, 7.62165869312107e-09, 4.1585895171168e-07, 9.45954334740349e-06, 0.000116280770895153, 0.000897374581829956, 0.00477299008972669, 0.0185902388131678, 0.0551761563064615, 0.127963027059908, 0.234923254214993, 0.341642606549017, 0.387345812489669, 0.326760059508523, 0.180656988869348, 0.0406001050391349, 1.78018114373359e-24, 2.76419638040961e-17, 1.99362337855672e-13, 8.29455947560223e-11, 7.5791029787698e-09, 2.66985817613996e-07, 4.84519016456138e-06, 5.3626142025046e-05, 0.000402697309589852, 0.00220341739335867, 0.00923312368235811, 0.0307101247365599, 0.0832353840522244, 0.187456400338528, 0.355922166534538, 0.575829699631459, 0.79982991249792, 0.958617303406749, 

0.962676326012298, 0.81794095357733, 0.608756635627188, 0.395263672167135, 0.222547845536133, 0.107740691917051, 0.0443408057330429, 0.0152798865331713, 0.00432138010277356, 0.0009765625, 0.000170074126157063, 2.17109048222588e-05, 1.89112849853936e-06, 1.01012552894013e-07, 2.7942710516002e-09, 2.99521756691e-11, 7.08649615993212e-14, 9.71943720905241e-18, 6.22190473905769e-25, 0.0366880473939491, 0.166040437858573, 0.309772237701712, 0.384451047382647, 0.360834378290398, 0.26889289006638, 0.162104595358301, 0.0793187586198047, 0.031269723855026, 0.009765625, 0.00235037235435517, 0.000418236704644752, 5.17284295270048e-05, 4.04739684207419e-06, 1.72339178246796e-07, 3.07945758633351e-09, 1.39262045970023e-11, 4.78794553997668e-15, 1.63259721365886e-21, 0.000629189430906975, 0.0151676500579416, 0.0709338923564056, 0.168270393179474, 0.263272159337914, 0.301989185968494, 0.266685612289478, 0.185286680951319, 0.101821182821642, 0.0439453125, 0.014616641860955, 0.00362559156999042, 0.000636722301276013, 7.29774600042941e-05, 4.78312816281637e-06, 1.42473007932929e-07, 1.23153426665713e-09, 1.06137731026177e-12, 1.92773467004681e-18, 6.39432134135382e-06, 0.000821067664568085, 0.00962545590061507, 0.0436446071869945, 0.113830378909621, 0.200983165633474, 0.259992047525955, 0.256488981816057, 0.196475520548406, 0.1171875, 0.0538660041473489, 0.0186248091520161, 0.00464437253068985, 0.000779754549183316, 7.86676607775102e-05, 3.90613436543052e-06, 6.45381404429751e-08, 1.39426913982693e-10, 1.3488749326705e-15, 4.26458537151439e-08, 2.91681519790959e-05, 0.000857152590670526, 0.00742887045345802, 0.0322983803031486, 0.0877803462883769, 0.166337380854215, 0.233003552009351, 0.248798681670849, 0.205078125, 0.130272045039663, 0.0627876314656557, 0.022231734667363, 0.00546759587466385, 0.000849082268134016, 7.02798910705738e-05, 2.21950287379146e-06, 1.20196756154275e-08, 6.1939176357832e-13, 1.9503042424292e-10, 7.1052943931263e-07, 5.23405368630307e-05, 0.000867078022437926, 0.0062841494322611, 0.0262892438329779, 0.0729731091816542, 0.145144160273167, 0.216038373472826, 0.24609375, 0.216038373472826, 0.145144160273167, 0.0729731091816542, 0.0262892438329779, 0.00628414943226111, 0.000867078022437926, 5.23405368630307e-05, 7.1052943931263e-07, 1.9503042424292e-10, 6.1939176357832e-13, 1.20196756154275e-08, 2.21950287379146e-06, 7.02798910705738e-05, 0.000849082268134014, 0.00546759587466386, 0.022231734667363, 0.0627876314656557, 0.130272045039663, 0.205078125, 0.248798681670848, 0.233003552009352, 0.166337380854215, 0.0877803462883768, 0.0322983803031487, 0.00742887045345802, 0.000857152590670526, 2.91681519790959e-05, 4.26458537151439e-08, 1.3488749326705e-15, 1.39426913982693e-10, 6.45381404429751e-08, 3.90613436543052e-06, 7.866766077751e-05, 0.000779754549183317, 0.00464437253068985, 0.0186248091520161, 0.0538660041473489, 0.1171875, 0.196475520548406, 0.256488981816057, 0.259992047525955, 0.200983165633474, 0.113830378909621, 0.0436446071869945, 0.00962545590061507, 0.000821067664568085, 6.39432134135382e-06, 1.92773467004681e-18, 1.06137731026177e-12, 1.23153426665713e-09, 1.42473007932929e-07, 4.78312816281635e-06, 7.29774600042943e-05, 0.000636722301276013, 0.00362559156999041, 0.014616641860955, 0.0439453125, 0.101821182821642, 0.185286680951319, 0.266685612289478, 0.301989185968494, 0.263272159337914, 0.168270393179474, 0.0709338923564056, 0.0151676500579416, 0.000629189430906975, 1.63259721365886e-21, 4.78794553997668e-15, 1.39262045970023e-11, 3.07945758633351e-09, 1.72339178246795e-07, 4.0473968420742e-06, 5.17284295270048e-05, 0.000418236704644752, 0.00235037235435517, 0.009765625, 0.031269723855026, 0.0793187586198047, 0.162104595358301, 0.26889289006638, 0.360834378290398, 0.384451047382647, 0.309772237701712, 0.166040437858573, 0.0366880473939491, 6.22190473905769e-25, 9.71943720905241e-18, 7.08649615993212e-14, 2.99521756691e-11, 2.79427105160019e-09, 1.01012552894013e-07, 1.89112849853936e-06, 2.17109048222588e-05, 0.000170074126157063, 0.0009765625, 0.00432138010277356, 0.0152798865331713, 0.0443408057330429, 0.107740691917051, 0.222547845536133, 0.395263672167135, 0.608756635627188, 0.81794095357733, 0.962676326012298, 

0.966169340127348, 0.833782548557145, 0.638427188477989, 0.432308291513141, 0.257613093122779, 0.134176214764561, 0.0605288474456779, 0.0233689002733215, 0.00760197236510522, 0.00204149057083855, 0.000440498382831158, 7.36338638860294e-05, 9.06738255827176e-06, 7.65543135521692e-07, 3.98174422551463e-08, 1.07735415972467e-09, 1.13449441942808e-11, 2.64814588948838e-14, 3.59840755781307e-18, 2.2916741396188e-25, 0.0333091241267707, 0.152953195901625, 0.293018086008986, 0.37817641895874, 0.374202761580535, 0.29848005644855, 0.195958059718939, 0.106542440736242, 0.0478124960806966, 0.0175124566140777, 0.00513504938134459, 0.0011707453998067, 0.000198882959016188, 2.36466128157932e-05, 1.78991981808438e-06, 7.41684899125558e-08, 1.29688505048659e-09, 5.76977468501299e-12, 1.96157354321015e-15, 6.64726362313097e-22, 0.000516756190458155, 0.0126263209510109, 0.060518756288993, 0.148870222937765, 0.244601185773165, 0.298791070490661, 0.285480448664961, 0.218584580163046, 0.135322203535233, 0.0676019588179099, 0.0269375097150574, 0.00837644696984145, 0.00196302450125786, 0.000328685638041211, 3.62081476903683e-05, 2.29769772624411e-06, 6.67134066433374e-08, 5.65702781768258e-10, 4.81184195125533e-13, 8.67651766460899e-19, 4.75077411418832e-06, 0.000617662609283039, 0.0074069903686154, 0.0347278143278342, 0.0947471917079598, 0.177245871767192, 0.246459650976762, 0.265749600600185, 0.226961881835078, 0.15464208851268, 0.0837387516737918, 0.0355151329895186, 0.0114818028664081, 0.00270737699296362, 0.000434045500038717, 4.21815535384305e-05, 2.03367228634804e-06, 3.28680541097985e-08, 6.99478437914175e-11, 6.71126250750494e-16, 2.86623893625167e-08, 1.98287398703607e-05, 0.00059492590778089, 0.00531638445468933, 0.0240848225642736, 0.0690007735950492, 0.139631885992169, 0.212028887956103, 0.249807862195836, 0.232148268663495, 0.170830273853312, 0.0988180691045593, 0.0440721023946443, 0.014634775223593, 0.00341455037621397, 0.000508184673978839, 4.0683484167297e-05, 1.253224823364e-06, 6.67277721512876e-09, 3.40668763199343e-13, 1.18577857366502e-10, 4.36497857498504e-07, 3.27662832588388e-05, 0.000558082629739582, 0.00419820608020087, 0.0184193791727833, 0.0542458571909425, 0.116000710167216, 0.188539555660439, 0.238971653814661, 0.238971653814661, 0.188539555660439, 0.116000710167216, 0.0542458571909425, 0.0184193791727833, 0.00419820608020087, 0.000558082629739584, 3.27662832588388e-05, 4.36497857498511e-07, 1.18577857366512e-10, 3.4066876319931e-13, 6.67277721512864e-09, 1.253224823364e-06, 4.06834841672968e-05, 0.000508184673978839, 0.00341455037621397, 0.014634775223593, 0.0440721023946443, 0.0988180691045593, 0.170830273853312, 0.232148268663495, 0.249807862195836, 0.212028887956103, 0.139631885992169, 0.0690007735950491, 0.0240848225642736, 0.00531638445468934, 0.00059492590778089, 1.98287398703609e-05, 2.86623893625186e-08, 6.71126250750418e-16, 6.9947843791416e-11, 3.28680541097985e-08, 2.03367228634803e-06, 4.21815535384305e-05, 0.000434045500038718, 0.00270737699296362, 0.0114818028664081, 0.0355151329895186, 0.0837387516737918, 0.15464208851268, 0.226961881835078, 0.265749600600185, 0.246459650976762, 0.177245871767192, 0.0947471917079598, 0.0347278143278342, 0.0074069903686154, 0.000617662609283044, 4.75077411418855e-06, 8.67651766460786e-19, 4.81184195125521e-13, 5.65702781768258e-10, 6.6713406643337e-08, 2.29769772624411e-06, 3.62081476903684e-05, 0.000328685638041211, 0.00196302450125786, 0.00837644696984145, 0.0269375097150574, 0.06760195881791, 0.135322203535233, 0.218584580163046, 0.285480448664961, 0.298791070490661, 0.244601185773165, 0.148870222937765, 0.060518756288993, 0.012626320951011, 0.000516756190458171, 6.64726362313001e-22, 1.9615735432101e-15, 5.76977468501299e-12, 1.29688505048658e-09, 7.41684899125558e-08, 1.78991981808439e-06, 2.36466128157932e-05, 0.000198882959016188, 0.0011707453998067, 0.00513504938134459, 0.0175124566140777, 0.0478124960806966, 0.106542440736242, 0.195958059718939, 0.298480056448549, 0.374202761580535, 0.378176418958741, 0.293018086008986, 0.152953195901625, 0.0333091241267712, 2.29167413961843e-25, 3.59840755781296e-18, 2.64814588948838e-14, 1.13449441942807e-11, 1.07735415972467e-09, 3.98174422551464e-08, 7.65543135521692e-07, 9.06738255827176e-06, 7.36338638860294e-05, 0.000440498382831158, 0.00204149057083855, 0.00760197236510522, 0.0233689002733215, 0.0605288474456779, 0.134176214764561, 0.257613093122779, 0.432308291513141, 0.638427188477989, 0.833782548557145, 0.966169340127348, 

0.969196362665879, 0.847704426975941, 0.665176677462213, 0.466988068051841, 0.292148223195395, 0.161963683642952, 0.0789860642512177, 0.0335616432273308, 0.0122724296175237, 0.00380089157090121, 0.0009765625, 0.000202537913890285, 3.26866153922499e-05, 3.9025150032946e-06, 3.20755155243541e-07, 1.63054103840275e-08, 4.32848719748264e-10, 4.48874479981532e-12, 1.03562858331142e-14, 1.39599356280927e-18, 8.85098598953817e-26, 0.0303717462907727, 0.141223947786249, 0.276798488971778, 0.369477245463166, 0.382539722189285, 0.323376945448396, 0.228251053793098, 0.135641740200633, 0.0678382272462051, 0.0283496411353113, 0.009765625, 0.00271546523647043, 0.000591324689810339, 9.65593747441969e-05, 1.1099702226979e-05, 8.16658196039696e-07, 3.30569551478592e-08, 5.6733947429314e-10, 2.48872738681108e-12, 8.37952728112703e-16, 2.82444853349555e-22, 0.000428292298369966, 0.0105872887496489, 0.0518325923651094, 0.131547356162754, 0.225404374715816, 0.29054471300572, 0.296816214647453, 0.246692532365427, 0.168745012088026, 0.0951529297479188, 0.0439453125, 0.0163830469514622, 0.00481387253046671, 0.00107511970598538, 0.000172846872080127, 1.84060852841493e-05, 1.13606210485593e-06, 3.2268115486763e-08, 2.69130636943849e-10, 2.26343556994864e-13, 4.05590889818101e-19, 3.57904356652892e-06, 0.000470345925929926, 0.00575172831811236, 0.0277544591982057, 0.078705369432847, 0.154693874897857, 0.228727651874328, 0.265873389316432, 0.248738847067859, 0.189257449101598, 0.1171875, 0.0585735198704672, 0.0232230564647952, 0.00709374247102847, 0.00159502663602081, 0.000245832191896757, 2.31364923167589e-05, 1.08757801972873e-06, 1.7246666680453e-08, 3.6230386944937e-11, 3.45142893774758e-16, 1.96274112108381e-08, 1.37125849706167e-05, 0.000418854431071093, 0.0038428437923783, 0.0180349814212772, 0.0540508559283367, 0.115669547681609, 0.188045548522093, 0.240616611192008, 0.247031944011744, 0.205078125, 0.137428651939319, 0.0735213522950458, 0.030715906019222, 0.00965925589203863, 0.00215469296301316, 0.000309216227130743, 2.40556201476269e-05, 7.25298062291825e-07, 3.80581019012651e-09, 1.92743169779205e-13, 7.380779911314e-11, 2.74134991718263e-07, 2.09156353578614e-05, 0.00036485129354411, 0.00283380677402376, 0.0129501628729379, 0.0401109178947722, 0.091199916282101, 0.159606580192867, 0.221103922520918, 0.24609375, 0.221103922520918, 0.159606580192867, 0.0911999162821011, 0.0401109178947722, 0.0129501628729379, 0.00283380677402376, 0.00036485129354411, 2.09156353578613e-05, 2.74134991718268e-07, 7.38077991131334e-11, 1.92743169779226e-13, 3.80581019012643e-09, 7.25298062291831e-07, 2.40556201476269e-05, 0.000309216227130743, 0.00215469296301316, 0.00965925589203863, 0.030715906019222, 0.0735213522950458, 0.137428651939319, 0.205078125, 0.247031944011744, 0.240616611192008, 0.188045548522093, 0.115669547681609, 0.0540508559283367, 0.0180349814212772, 0.0038428437923783, 0.00041885443107109, 1.37125849706169e-05, 1.96274112108367e-08, 3.45142893774801e-16, 3.62303869449361e-11, 1.72466666804532e-08, 1.08757801972873e-06, 2.31364923167589e-05, 0.000245832191896758, 0.00159502663602081, 0.00709374247102846, 0.0232230564647952, 0.0585735198704672, 0.1171875, 0.189257449101598, 0.248738847067859, 0.265873389316432, 0.228727651874328, 0.154693874897857, 0.078705369432847, 0.0277544591982057, 0.00575172831811234, 0.000470345925929931, 3.57904356652873e-06, 4.05590889818158e-19, 2.26343556994858e-13, 2.69130636943852e-10, 3.2268115486763e-08, 1.13606210485593e-06, 1.84060852841493e-05, 0.000172846872080127, 0.00107511970598537, 0.00481387253046671, 0.0163830469514622, 0.0439453125, 0.0951529297479188, 0.168745012088026, 0.246692532365427, 0.296816214647453, 0.29054471300572, 0.225404374715816, 0.131547356162754, 0.0518325923651092, 0.010587288749649, 0.000428292298369951, 2.824448533496e-22, 8.37952728112677e-16, 2.48872738681111e-12, 5.67339474293141e-10, 3.30569551478592e-08, 8.16658196039696e-07, 1.1099702226979e-05, 9.65593747441968e-05, 0.000591324689810339, 0.00271546523647043, 0.009765625, 0.0283496411353113, 0.0678382272462051, 0.135641740200633, 0.228251053793098, 0.323376945448396, 0.382539722189285, 0.369477245463166, 0.276798488971778, 0.14122394778625, 0.0303717462907722, 8.85098598953974e-26, 1.39599356280923e-18, 1.03562858331143e-14, 4.48874479981532e-12, 4.32848719748264e-10, 1.63054103840275e-08, 3.20755155243541e-07, 3.9025150032946e-06, 3.26866153922499e-05, 0.000202537913890285, 0.0009765625, 0.00380089157090121, 0.0122724296175237, 0.0335616432273308, 0.0789860642512177, 0.161963683642952, 0.292148223195395, 0.466988068051841, 0.665176677462213, 0.847704426975941, 0.969196362665879, 

0.97183636269485, 0.859994498193509, 0.689318231052616, 0.499321431933334, 0.325784334992656, 0.190582548875071, 0.0993622620033997, 0.0458110105100205, 0.018493431457001, 0.00645457378555904, 0.00191637036736594, 0.000473965694117768, 9.49985867061881e-05, 1.48724512857194e-05, 1.72875699151345e-06, 1.38822897007112e-07, 6.9182021842893e-09, 1.80638313341707e-10, 1.84849442785943e-12, 4.2218189947359e-15, 5.65126651678194e-19, 3.56920976045675e-26, 0.0278029601685476, 0.130695515028466, 0.261292984425183, 0.359107107756817, 0.386650134004196, 0.34361660521532, 0.258074701146795, 0.165442193474232, 0.0906888735002966, 0.0423304150995412, 0.0166650335740415, 0.00545029691851408, 0.00144854565204952, 0.000303281591042299, 4.7869351248555e-05, 5.34486991680971e-06, 3.83709222983777e-07, 1.52202540774458e-08, 2.57024398766454e-10, 1.11376002217502e-12, 3.71861124017847e-16, 1.24759659053184e-22, 0.000357932755670569, 0.0089379559497142, 0.0445705760929939, 0.116219849514506, 0.206499329557926, 0.278790306009049, 0.30163512296427, 0.268865575864346, 0.200125774826806, 0.12492518420485, 0.0652146928062492, 0.0282036898258344, 0.00993939026327332, 0.0027830567244191, 0.000596476925382181, 9.26031351425354e-05, 9.57687326076212e-06, 5.77093853753522e-07, 1.60821116117676e-08, 1.32219696022946e-10, 1.10110384663917e-13, 1.96240571646416e-19, 2.73066276887248e-06, 0.000362219606010174, 0.00450531295813033, 0.0222891155096845, 0.0653544772778581, 0.13404092394009, 0.208917396859631, 0.258928789537646, 0.261702736557977, 0.218475976032549, 0.151231037401991, 0.0864864191121688, 0.0404150870003068, 0.0151340193601801, 0.00440439207175185, 0.000950759030671518, 0.000141645069036237, 1.29666328523864e-05, 5.96304394987537e-07, 9.30158378071045e-09, 1.93211067692853e-11, 1.82919345955359e-16, 1.36711173242998e-08, 9.63329842291002e-06, 0.000298862205762779, 0.00280527006516833, 0.013573797354682, 0.0422928033826532, 0.0949591061291199, 0.163642007087772, 0.224586071247775, 0.250741774104375, 0.230147216198583, 0.17404406510921, 0.107844154336717, 0.0540077181557039, 0.0213426141597444, 0.00640596474988869, 0.00137482840744242, 0.000191195336725523, 1.45098280261877e-05, 4.29424646079623e-07, 2.22487203594611e-09, 1.11892195591294e-13, 4.69335223522271e-11, 1.75679574897257e-07, 1.35944057460489e-05, 0.000242102747085099, 0.00193317234835809, 0.00915037160065219, 0.0295966002882675, 0.0709173422608651, 0.132160164127513, 0.197329900934073, 0.240167212991924, 0.240167212991924, 0.197329900934073, 0.132160164127513, 0.0709173422608651, 0.0295966002882675, 0.0091503716006522, 0.00193317234835809, 0.000242102747085098, 1.3594405746049e-05, 1.75679574897257e-07, 4.69335223522271e-11, 1.11892195591294e-13, 2.22487203594611e-09, 4.29424646079619e-07, 1.45098280261878e-05, 0.000191195336725524, 0.00137482840744242, 0.00640596474988869, 0.0213426141597444, 0.0540077181557039, 0.107844154336716, 0.17404406510921, 0.230147216198583, 0.250741774104375, 0.224586071247775, 0.163642007087772, 0.0949591061291199, 0.0422928033826532, 0.013573797354682, 0.00280527006516832, 0.000298862205762781, 9.63329842291002e-06, 1.36711173242998e-08, 1.82919345955359e-16, 1.93211067692853e-11, 9.30158378071035e-09, 5.96304394987541e-07, 1.29666328523864e-05, 0.000141645069036237, 0.000950759030671518, 0.00440439207175185, 0.0151340193601801, 0.0404150870003068, 0.0864864191121688, 0.151231037401991, 0.218475976032549, 0.261702736557977, 0.258928789537646, 0.208917396859631, 0.13404092394009, 0.065354477277858, 0.0222891155096844, 0.00450531295813035, 0.000362219606010174, 2.73066276887248e-06, 1.96240571646416e-19, 1.10110384663917e-13, 1.32219696022945e-10, 1.60821116117677e-08, 5.77093853753524e-07, 9.57687326076212e-06, 9.26031351425353e-05, 0.000596476925382181, 0.0027830567244191, 0.00993939026327331, 0.0282036898258344, 0.0652146928062492, 0.12492518420485, 0.200125774826806, 0.268865575864346, 0.30163512296427, 0.278790306009049, 0.206499329557926, 0.116219849514506, 0.044570576092994, 0.0089379559497142, 0.000357932755670569, 1.24759659053184e-22, 3.71861124017847e-16, 1.113760022175e-12, 2.57024398766456e-10, 1.52202540774458e-08, 3.83709222983777e-07, 5.34486991680971e-06, 4.7869351248555e-05, 0.000303281591042299, 0.00144854565204952, 0.00545029691851408, 0.0166650335740415, 0.0423304150995412, 0.0906888735002966, 0.165442193474232, 0.258074701146795, 0.34361660521532, 0.386650134004196, 0.359107107756817, 0.261292984425184, 0.130695515028466, 0.0278029601685476, 3.56920976045675e-26, 5.65126651678194e-19, 4.22181899473584e-15, 1.84849442785945e-12, 1.80638313341708e-10, 6.9182021842893e-09, 1.38822897007112e-07, 1.72875699151345e-06, 1.48724512857194e-05, 9.4998586706188e-05, 0.000473965694117768, 0.00191637036736594, 0.00645457378555904, 0.018493431457001, 0.0458110105100205, 0.0993622620033997, 0.190582548875071, 0.325784334992656, 0.499321431933334, 0.689318231052616, 0.859994498193509, 0.97183636269485, 

0.974152336512357, 0.870890738410956, 0.711137569079148, 0.529382701611342, 0.35826434168984, 0.219585258606828, 0.121284193888987, 0.0599840063183176, 0.0263504789566702, 0.0101774022661878, 0.00341179928062678, 0.0009765625, 0.000233670750070241, 4.54650313374672e-05, 6.93193688130939e-06, 7.87185481346128e-07, 6.19430199635846e-08, 3.03384809860736e-09, 7.80784010111789e-11, 7.897437979629e-13, 1.78781188527014e-15, 2.37856223120778e-19, 1.49716308026752e-26, 0.0255441290591844, 0.12122683219606, 0.246598506813851, 0.347649327619059, 0.387290030161325, 0.359453110763975, 0.284854459532021, 0.194912471990385, 0.115556697634692, 0.059243539288049, 0.0260942946024372, 0.009765625, 0.00305521842663148, 0.000781040293214856, 0.00015806946776668, 2.42255092270767e-05, 2.637385160013e-06, 1.85333858396893e-07, 7.22267674352819e-09, 1.20258165954089e-10, 5.15566867978456e-13, 1.70875356583003e-16, 5.70958950842867e-23, 0.000301417065094517, 0.00759357619533047, 0.0384804175635161, 0.102736686676291, 0.1884002885682, 0.26478527222613, 0.30106089863035, 0.285007510020393, 0.228041686664863, 0.155187795963005, 0.0898090625082619, 0.0439453125, 0.0179759847316372, 0.00603784413550146, 0.00162201137727249, 0.000335491304207511, 5.05320893113658e-05, 5.09481262025643e-06, 3.00661596544673e-07, 8.24053564228719e-09, 6.69053265034247e-11, 5.52404061450349e-14, 9.79835513778513e-20, 2.10766115943913e-06, 0.000281870854470666, 0.00355832267448117, 0.0179914404386384, 0.0543104033912101, 0.115585038680077, 0.188556671325903, 0.246961467335603, 0.266679471264955, 0.240896423840354, 0.183168581916403, 0.1171875, 0.0626757204570221, 0.0276596432628222, 0.00986315867198268, 0.00275325121487579, 0.00057374269678853, 8.29961378009e-05, 7.41675544209074e-06, 3.346204867543e-07, 5.14508562795235e-09, 1.05825544232573e-11, 9.96454987558822e-17, 9.6717055064884e-09, 6.86630839212856e-06, 0.000215933585676545, 0.00206764336398175, 0.0102743370773176, 0.0331114909334643, 0.0774994764066325, 0.140433721951308, 0.204660599850124, 0.245398812580237, 0.245160850749948, 0.205078125, 0.14340863286226, 0.0831535065196741, 0.0393593085140326, 0.0148279027000925, 0.0042750027870204, 0.000887272184162689, 0.00012006578786574, 8.917003302867e-06, 2.59653293668322e-07, 1.33043442781865e-09, 6.65015106286798e-14, 3.04332640085431e-11, 1.14693719229727e-07, 8.98541752495209e-06, 0.000162940305315529, 0.00133280860644742, 0.00650427728723505, 0.021842323314808, 0.0547591644701087, 0.10770158566076, 0.171418526819617, 0.225006183714702, 0.24609375, 0.225006183714702, 0.171418526819617, 0.10770158566076, 0.0547591644701088, 0.021842323314808, 0.00650427728723506, 0.00133280860644742, 0.000162940305315529, 8.98541752495216e-06, 1.14693719229727e-07, 3.04332640085399e-11, 6.65015106286882e-14, 1.33043442781865e-09, 2.59653293668319e-07, 8.917003302867e-06, 0.00012006578786574, 0.000887272184162687, 0.0042750027870204, 0.0148279027000925, 0.0393593085140326, 0.0831535065196741, 0.14340863286226, 0.205078125, 0.245160850749948, 0.245398812580237, 0.204660599850124, 0.140433721951309, 0.0774994764066324, 0.0331114909334644, 0.0102743370773176, 0.00206764336398175, 0.000215933585676546, 6.86630839212856e-06, 9.67170550648758e-09, 9.9645498755897e-17, 1.05825544232573e-11, 5.14508562795229e-09, 3.346204867543e-07, 7.41675544209074e-06, 8.29961378008998e-05, 0.000573742696788531, 0.00275325121487579, 0.00986315867198268, 0.0276596432628222, 0.0626757204570221, 0.1171875, 0.183168581916403, 0.240896423840354, 0.266679471264955, 0.246961467335603, 0.188556671325903, 0.115585038680077, 0.0543104033912101, 0.0179914404386384, 0.00355832267448119, 0.000281870854470666, 2.107661159439e-06, 9.79835513778679e-20, 5.52404061450348e-14, 6.69053265034238e-11, 8.24053564228719e-09, 3.00661596544673e-07, 5.09481262025641e-06, 5.05320893113659e-05, 0.00033549130420751, 0.00162201137727249, 0.00603784413550146, 0.0179759847316372, 0.0439453125, 0.0898090625082619, 0.155187795963005, 0.228041686664863, 0.285007510020393, 0.301060898630349, 0.264785272226131, 0.1884002885682, 0.102736686676291, 0.0384804175635163, 0.00759357619533047, 0.000301417065094504, 5.70958950842977e-23, 1.70875356583003e-16, 5.15566867978449e-13, 1.20258165954089e-10, 7.22267674352818e-09, 1.85333858396892e-07, 2.63738516001301e-06, 2.42255092270766e-05, 0.00015806946776668, 0.000781040293214856, 0.00305521842663148, 0.009765625, 0.0260942946024372, 0.059243539288049, 0.115556697634692, 0.194912471990385, 0.284854459532021, 0.359453110763975, 0.387290030161325, 0.347649327619059, 0.246598506813851, 0.12122683219606, 0.0255441290591838, 1.49716308026784e-26, 2.37856223120778e-19, 1.78781188527011e-15, 7.897437979629e-13, 7.80784010111789e-11, 3.03384809860735e-09, 6.19430199635848e-08, 7.87185481346126e-07, 6.93193688130939e-06, 4.54650313374672e-05, 0.000233670750070241, 0.0009765625, 0.00341179928062678, 0.0101774022661878, 0.0263504789566702, 0.0599840063183176, 0.121284193888987, 0.219585258606828, 0.35826434168984, 0.529382701611342, 0.711137569079148, 0.870890738410956, 0.974152336512357, 

0.976195016918756, 0.880590726440692, 0.730891618995769, 0.557280270102422, 0.38942036742605, 0.248600782048209, 0.144383946784444, 0.0758873629893497, 0.0358563549653398, 0.0151042277011176, 0.00561372434258422, 0.00181697326526461, 0.000503726206361996, 0.000117097358362496, 2.21990892774127e-05, 3.30710886955505e-06, 3.67950357392297e-07, 2.8442715358608e-08, 1.37201410703638e-09, 3.48639971660941e-11, 3.49051667331629e-13, 7.84047817398448e-16, 1.03752991772221e-19, 6.51118663885669e-27, 0.0235477242904622, 0.112692953105569, 0.232756564715493, 0.335548477439356, 0.385136353136963, 0.371268496361603, 0.308293326487388, 0.223219144075163, 0.141597104926601, 0.0786723616742755, 0.0381224395643371, 0.0159820740308565, 0.00572677268423251, 0.00172431853418634, 0.000426198085411127, 8.37452641402925e-05, 1.2509134218384e-05, 1.33206629787698e-06, 9.18698417272157e-08, 3.52518023182634e-09, 5.79706422555372e-11, 2.46203143326556e-13, 8.10733234663811e-17, 2.69927907795937e-23, 0.000255607628949408, 0.00648980915225342, 0.0333551892709716, 0.090917899015211, 0.171404760284176, 0.249509003409909, 0.29622509823997, 0.295464922531154, 0.251625773571773, 0.184398916399249, 0.116499161579847, 0.0632601551408966, 0.0292979921099965, 0.0114261628273492, 0.00368214040594987, 0.00095429914591591, 0.000191371732864011, 2.80732788626388e-05, 2.7682153551224e-06, 1.60397645268428e-07, 4.332504483203e-09, 3.47902180166167e-11, 2.85080714254636e-14, 5.03556198766077e-20, 1.64420096906118e-06, 0.000221474285839944, 0.00283257291719521, 0.0145982140875876, 0.0452051029739383, 0.0993666303181247, 0.168669205424053, 0.231759015866343, 0.264979386756745, 0.256124285736375, 0.210970209227347, 0.148382808119163, 0.0888222947568532, 0.0448682921934348, 0.0188514783541449, 0.00644414096588931, 0.00173494033921056, 0.000350603831102513, 4.94291334639949e-05, 4.32484820477707e-06, 1.91878426393649e-07, 2.91324443658834e-09, 5.94037577545306e-12, 5.56678339314074e-17, 6.94073246087618e-09, 4.96002665914737e-06, 0.000157858548061084, 0.00153822328783793, 0.00782386526952058, 0.0259695377725147, 0.0630259009086006, 0.119298961582224, 0.183121094199166, 0.233459995238099, 0.250719887201029, 0.22840533054638, 0.176715822731682, 0.115623999199979, 0.0633373369163007, 0.0285571488604185, 0.0103219230458951, 0.00287348868595108, 0.000579209180746267, 7.65267141282474e-05, 5.57676818208513e-06, 1.60090668309808e-07, 8.12324056805836e-10, 4.03859232757782e-14, 2.00908775230319e-11, 7.61706933654809e-08, 6.03251356059991e-06, 0.000111143030152691, 0.000928535389328956, 0.0046540503182187, 0.0161489958506138, 0.0421094807532219, 0.0867776442351414, 0.145920860399799, 0.204314707971543, 0.241086050408313, 0.241086050408313, 0.204314707971543, 0.145920860399799, 0.0867776442351414, 0.0421094807532218, 0.0161489958506138, 0.00465405031821869, 0.000928535389328956, 0.000111143030152691, 6.03251356059986e-06, 7.61706933654809e-08, 2.00908775230296e-11, 4.03859232757838e-14, 8.12324056805836e-10, 1.6009066830981e-07, 5.57676818208513e-06, 7.65267141282474e-05, 0.000579209180746269, 0.00287348868595108, 0.0103219230458951, 0.0285571488604185, 0.0633373369163007, 0.115623999199979, 0.176715822731682, 0.22840533054638, 0.250719887201029, 0.233459995238099, 0.183121094199166, 0.119298961582224, 0.0630259009086006, 0.0259695377725146, 0.00782386526952058, 0.00153822328783793, 0.000157858548061083, 4.96002665914737e-06, 6.94073246087554e-09, 5.56678339314164e-17, 5.94037577545306e-12, 2.91324443658838e-09, 1.91878426393649e-07, 4.32484820477707e-06, 4.94291334639951e-05, 0.000350603831102513, 0.00173494033921057, 0.00644414096588931, 0.0188514783541449, 0.0448682921934348, 0.0888222947568531, 0.148382808119163, 0.210970209227347, 0.256124285736375, 0.264979386756745, 0.231759015866342, 0.168669205424053, 0.0993666303181245, 0.0452051029739383, 0.0145982140875876, 0.00283257291719519, 0.000221474285839944, 1.64420096906106e-06, 5.0355619876617e-20, 2.85080714254636e-14, 3.47902180166172e-11, 4.332504483203e-09, 1.60397645268428e-07, 2.76821535512241e-06, 2.80732788626388e-05, 0.000191371732864011, 0.00095429914591591, 0.00368214040594987, 0.0114261628273492, 0.0292979921099965, 0.0632601551408966, 0.116499161579847, 0.184398916399249, 0.251625773571773, 0.295464922531154, 0.29622509823997, 0.249509003409909, 0.171404760284176, 0.090917899015211, 0.0333551892709715, 0.00648980915225342, 0.000255607628949396, 2.69927907795993e-23, 8.10733234663811e-17, 2.4620314332656e-13, 5.79706422555372e-11, 3.52518023182634e-09, 9.1869841727216e-08, 1.33206629787698e-06, 1.25091342183841e-05, 8.37452641402925e-05, 0.000426198085411127, 0.00172431853418634, 0.0057267726842325, 0.0159820740308565, 0.0381224395643371, 0.0786723616742755, 0.141597104926601, 0.223219144075163, 0.308293326487388, 0.371268496361603, 0.385136353136963, 0.335548477439356, 0.232756564715492, 0.112692953105569, 0.0235477242904616, 6.51118663885819e-27, 1.03752991772221e-19, 7.84047817398462e-16, 3.49051667331629e-13, 3.48639971660941e-11, 1.37201410703638e-09, 2.8442715358608e-08, 3.67950357392298e-07, 3.30710886955505e-06, 2.21990892774127e-05, 0.000117097358362496, 0.000503726206361995, 0.00181697326526461, 0.00561372434258422, 0.0151042277011176, 0.0358563549653398, 0.0758873629893497, 0.144383946784444, 0.248600782048209, 0.38942036742605, 0.557280270102422, 0.730891618995769, 0.880590726440692, 0.976195016918756, 

0.00048828125, 0.00537109375, 0.02685546875, 0.08056640625, 0.1611328125, 0.2255859375, 0.2255859375, 0.1611328125, 0.08056640625, 0.02685546875, 0.00537109375, 0.00048828125, 

0.0734310324221027, 3.75367451208139e-08, 0.216433644205746, 1.54097943935805e-06, 0.289966100899273, 2.87550678055162e-05, 0.233088547705085, 0.000321946122075824, 0.124911776245041, 0.00240303856977349, 0.0468580133979942, 0.0125555668489193, 0.0125555668489193, 0.0468580133979942, 0.00240303856977349, 0.124911776245041, 0.000321946122075824, 0.233088547705085, 2.87550678055162e-05, 0.289966100899273, 1.54097943935805e-06, 0.216433644205746, 3.75367451208139e-08, 0.0734310324221027, 

0.26838999996274, 0.00048828125, 3.72592123454244e-11, 0.374989996773247, 0.00537109375, 3.22675274117165e-09, 0.238149872979147, 0.02685546875, 1.27020852967867e-07, 0.0907469999008202, 0.08056640625, 3.00009918011123e-06, 0.0230527605382362, 0.1611328125, 4.72394617639724e-05, 0.00409931830594786, 0.2255859375, 0.000520681694052179, 0.000520681694052179, 0.2255859375, 0.00409931830594786, 4.72394617639724e-05, 0.1611328125, 0.0230527605382362, 3.00009918011123e-06, 0.08056640625, 0.0907469999008202, 1.27020852967867e-07, 0.02685546875, 0.238149872979147, 3.22675274117165e-09, 0.00537109375, 0.374989996773247, 3.72592123454244e-11, 0.00048828125, 0.26838999996274, 

0.453137552926644, 0.0122111129290597, 5.0558077093006e-06, 1.80778054962012e-13, 0.371906059319314, 0.0661615524768771, 0.000112908198576542, 2.66518819225178e-11, 0.138743859909347, 0.162942151419431, 0.0011461401546679, 1.78602433032416e-09, 0.0310560016652218, 0.240775589887845, 0.00698073623015944, 7.18121801180904e-08, 0.00463432034667064, 0.237192092125223, 0.0283448047295056, 1.92494175499355e-06, 0.00048408831616375, 0.16356334965294, 0.0805645063880055, 3.61189498469069e-05, 3.61189498469067e-05, 0.0805645063880055, 0.16356334965294, 0.000484088316163752, 1.92494175499354e-06, 0.0283448047295056, 0.237192092125223, 0.00463432034667066, 7.18121801180899e-08, 0.00698073623015944, 0.240775589887845, 0.0310560016652219, 1.78602433032415e-09, 0.0011461401546679, 0.162942151419431, 0.138743859909347, 2.66518819225176e-11, 0.000112908198576542, 0.0661615524768771, 0.371906059319314, 1.8077805496201e-13, 5.0558077093006e-06, 0.0122111129290597, 0.453137552926644, 

0.589484860106873, 0.0558016777955041, 0.00048828125, 9.88271984153399e-08, 2.42062551702749e-15, 0.31915202839268, 0.184141505775603, 0.00537109375, 3.62374326570991e-06, 5.40988488392026e-13, 0.0785416248539873, 0.27620621237142, 0.02685546875, 6.03970431876743e-05, 5.495734705272e-11, 0.0115972068843275, 0.24858014959061, 0.08056640625, 0.000603983653091248, 3.34976812987317e-09, 0.00114160449118903, 0.149144824899634, 0.1611328125, 0.00402664583063447, 1.36117032883093e-07, 7.86639903134722e-05, 0.0626394552488756, 0.2255859375, 0.0187914252209762, 3.87175832648424e-06, 3.87175832648421e-06, 0.0187914252209762, 0.2255859375, 0.0626394552488756, 7.86639903134727e-05, 1.36117032883092e-07, 0.00402664583063447, 0.1611328125, 0.149144824899634, 0.00114160449118903, 3.34976812987314e-09, 0.000603983653091248, 0.08056640625, 0.24858014959061, 0.0115972068843276, 5.49573470527195e-11, 6.03970431876743e-05, 0.02685546875, 0.27620621237142, 0.0785416248539875, 5.4098848839202e-13, 3.62374326570991e-06, 0.00537109375, 0.184141505775603, 0.319152028392681, 2.42062551702746e-15, 9.88271984153399e-08, 0.00048828125, 0.0558016777955041, 0.589484860106873, 

0.685344943905201, 0.129818978593909, 0.00514026938561138, 2.43383574138715e-05, 3.29545291228752e-09, 6.50382221288478e-17, 0.26344449072128, 0.291231177363389, 0.0347570325552513, 0.000435531753486661, 1.77746395592065e-07, 2.04726529126526e-14, 0.0460305694557027, 0.29697156199249, 0.106825964079942, 0.00354262923465249, 4.35776507631436e-06, 2.92925314853948e-12, 0.00482563894644039, 0.181695056341202, 0.196998174400562, 0.0172895158073918, 6.41029588153048e-05, 2.51472753770728e-10, 0.000337265597142093, 0.074110560794297, 0.242190064630808, 0.0562533901713586, 0.000628638649539453, 1.43924162422457e-08, 1.65001275467704e-05, 0.0211599739271486, 0.208424363875706, 0.128118725747816, 0.00431541057228553, 5.76599848408382e-07, 5.76599848408382e-07, 0.00431541057228554, 0.128118725747816, 0.208424363875706, 0.0211599739271485, 1.65001275467704e-05, 1.43924162422457e-08, 0.000628638649539454, 0.0562533901713586, 0.242190064630808, 0.0741105607942969, 0.000337265597142093, 2.51472753770728e-10, 6.4102958815305e-05, 0.0172895158073918, 0.196998174400562, 0.181695056341202, 0.00482563894644039, 2.92925314853948e-12, 4.35776507631437e-06, 0.00354262923465249, 0.106825964079942, 0.29697156199249, 0.0460305694557027, 2.04726529126526e-14, 1.77746395592066e-07, 0.000435531753486661, 0.0347570325552513, 0.291231177363389, 0.26344449072128, 6.50382221288478e-17, 3.29545291228753e-09, 2.43383574138715e-05, 0.00514026938561138, 0.129818978593909, 0.685344943905201, 

0.753121033819363, 0.218229702806177, 0.0207005750001045, 0.00048828125, 1.59061893752546e-06, 1.67942148773552e-10, 2.89616285842052e-18, 0.216307632684826, 0.356273435236161, 0.0962359310546485, 0.00537109375, 4.13996505929815e-05, 1.24473097134898e-08, 1.22011645088706e-15, 0.0282394497857612, 0.26438106067055, 0.203361817593523, 0.02685546875, 0.00048978391903884, 4.19342234635289e-07, 2.3364522245779e-13, 0.00221203435395502, 0.11771410101618, 0.257841505153353, 0.08056640625, 0.00347667118798892, 8.47642970874302e-06, 2.68450228358095e-11, 0.000115514431529856, 0.0349410040767241, 0.217944032190056, 0.1611328125, 0.0164524831999554, 0.000114226288494807, 2.05626645810638e-09, 4.22258755044455e-06, 0.00726006169817569, 0.128954106117658, 0.2255859375, 0.0545001043141428, 0.00107749982034165, 1.10253667535169e-07, 1.10253667535167e-07, 0.00107749982034165, 0.0545001043141428, 0.2255859375, 0.128954106117658, 0.00726006169817569, 4.2225875504446e-06, 2.05626645810635e-09, 0.000114226288494807, 0.0164524831999554, 0.1611328125, 0.217944032190056, 0.0349410040767241, 0.000115514431529857, 2.68450228358091e-11, 8.47642970874302e-06, 0.00347667118798892, 0.08056640625, 0.257841505153353, 0.11771410101618, 0.00221203435395504, 2.33645222457785e-13, 4.19342234635289e-07, 0.00048978391903884, 0.02685546875, 0.203361817593523, 0.26438106067055, 0.0282394497857614, 1.22011645088703e-15, 1.24473097134898e-08, 4.13996505929815e-05, 0.00537109375, 0.0962359310546485, 0.356273435236161, 0.216307632684826, 2.89616285842045e-18, 1.67942148773552e-10, 1.59061893752546e-06, 0.00048828125, 0.0207005750001045, 0.218229702806177, 0.753121033819363, 

0.802034900589577, 0.30747666337749, 0.0508517464523358, 0.00311355905535951, 5.25497326378054e-05, 1.33949815493519e-07, 1.19941334698004e-11, 1.89054086445579e-19, 0.17871751455487, 0.382777467326129, 0.17397372862973, 0.0236317816720992, 0.000837754024641501, 4.73750511139874e-06, 1.16578924037612e-09, 1.02659132612364e-16, 0.018101655032939, 0.216599718914313, 0.270544549641348, 0.0815291928958948, 0.00607071513345229, 7.61613410550185e-05, 5.150489750217e-08, 2.53388226013795e-14, 0.00110007096645559, 0.0735394983850297, 0.252432435346902, 0.168764489782938, 0.0263945605613514, 0.000734633491878545, 1.36530054052644e-06, 3.75255029622287e-12, 4.45688945398067e-05, 0.0166453211476272, 0.157021913765262, 0.232893699381714, 0.0765063985501891, 0.00472406218967703, 2.41277452095148e-05, 3.70489030402324e-10, 1.2639825018111e-06, 0.00263731335587725, 0.0683712335066433, 0.224974061172605, 0.155231238037118, 0.0212646641802413, 0.000298471765102764, 2.560484938753e-08, 2.560484938753e-08, 0.000298471765102764, 0.0212646641802413, 0.155231238037118, 0.224974061172605, 0.0683712335066433, 0.00263731335587725, 1.2639825018111e-06, 3.70489030402324e-10, 2.41277452095148e-05, 0.00472406218967703, 0.0765063985501891, 0.232893699381714, 0.157021913765262, 0.0166453211476272, 4.45688945398067e-05, 3.75255029622287e-12, 1.36530054052644e-06, 0.000734633491878545, 0.0263945605613514, 0.168764489782938, 0.252432435346902, 0.0735394983850298, 0.00110007096645559, 2.53388226013795e-14, 5.150489750217e-08, 7.61613410550185e-05, 0.0060707151334523, 0.0815291928958948, 0.270544549641348, 0.216599718914313, 0.018101655032939, 1.02659132612364e-16, 1.16578924037612e-09, 4.73750511139874e-06, 0.000837754024641503, 0.0236317816720992, 0.17397372862973, 0.382777467326129, 0.17871751455487, 1.89054086445579e-19, 1.19941334698004e-11, 1.33949815493519e-07, 5.25497326378055e-05, 0.00311355905535951, 0.0508517464523358, 0.30747666337749, 0.802034900589577, 

0.838175653540324, 0.390256758759895, 0.0941343305760793, 0.0107238861662764, 0.00048828125, 6.55077139340478e-06, 1.40897533019963e-08, 1.12472448348873e-12, 1.66470683170683e-20, 0.149154741956038, 0.383375669238317, 0.248142012987905, 0.0601946135102018, 0.00537109375, 0.000141212252026243, 6.46750088671001e-07, 1.38534329024709e-10, 1.13193400971892e-17, 0.0120646966767557, 0.171189049336007, 0.297323942347594, 0.153582023237278, 0.02685546875, 0.00138366078829624, 1.34941932052101e-05, 7.75614610109849e-09, 3.49849916774466e-15, 0.000585527100217932, 0.0458647112438666, 0.213752259753187, 0.235111779803934, 0.08056640625, 0.00813463626391044, 0.000168930707655924, 2.60546838166829e-07, 6.48774380217595e-13, 1.89446390171942e-05, 0.00819200272308077, 0.102447245898054, 0.239948000151779, 0.1611328125, 0.0318827214039012, 0.00140986983833969, 5.83491285438931e-06, 8.02073834607706e-11, 4.29065611396553e-07, 0.00102423485848842, 0.0343706622935846, 0.171418590669494, 0.2255859375, 0.0874723249815095, 0.00823659056455266, 9.1470484848342e-05, 6.94117583931999e-09, 6.94117583931984e-09, 9.1470484848342e-05, 0.00823659056455265, 0.0874723249815095, 0.2255859375, 0.171418590669494, 0.0343706622935846, 0.00102423485848842, 4.29065611396561e-07, 8.02073834607687e-11, 5.83491285438931e-06, 0.00140986983833969, 0.0318827214039012, 0.1611328125, 0.239948000151779, 0.102447245898054, 0.00819200272308077, 1.89446390171945e-05, 6.48774380217577e-13, 2.60546838166829e-07, 0.000168930707655923, 0.00813463626391044, 0.08056640625, 0.235111779803934, 0.213752259753188, 0.0458647112438666, 0.000585527100217938, 3.49849916774456e-15, 7.75614610109849e-09, 1.34941932052101e-05, 0.00138366078829624, 0.02685546875, 0.153582023237278, 0.297323942347595, 0.171189049336007, 0.0120646966767558, 1.13193400971888e-17, 1.38534329024709e-10, 6.46750088670999e-07, 0.000141212252026243, 0.00537109375, 0.0601946135102018, 0.248142012987905, 0.383375669238317, 0.149154741956038, 1.66470683170676e-20, 1.12472448348873e-12, 1.40897533019962e-08, 6.55077139340478e-06, 0.00048828125, 0.0107238861662764, 0.0941343305760793, 0.390256758759895, 0.838175653540324, 

0.86549081934902, 0.463766695834671, 0.146350059404454, 0.0256269014436379, 0.00224733527808401, 8.290878999979e-05, 9.4352009371759e-07, 1.7952550918385e-09, 1.31855612464378e-13, 1.86432028648487e-21, 0.125852089021298, 0.369086806726999, 0.307312001613783, 0.111430192233037, 0.0183139367388352, 0.00123103983625741, 2.62560712858529e-05, 1.03448671847499e-07, 2.00472601925761e-11, 1.55134336413513e-18, 0.00831832168466077, 0.133516458445242, 0.293321203844397, 0.220235325196703, 0.0678379740229315, 0.00830846808477181, 0.00033211282840909, 2.70957383860042e-06, 1.38544328809055e-09, 5.86776427286293e-16, 0.000329884753702203, 0.0289795966978778, 0.167980413728562, 0.261169423613991, 0.150770119559623, 0.0336450405011447, 0.00252053545086122, 4.25822212448558e-05, 5.74478433285147e-08, 1.33164552830308e-13, 8.72162717837964e-06, 0.00419332584936749, 0.0641331505680211, 0.206474499553127, 0.223391389846431, 0.0908301216521036, 0.0127528928235648, 0.000446133026607226, 1.58806197336116e-06, 2.01471375989046e-11, 1.61410146572347e-07, 0.00042473976789963, 0.0171397524112466, 0.114263771244933, 0.23169444477657, 0.171647220913248, 0.0451671460203559, 0.00327188836391756, 3.07297625042223e-05, 2.13371352481851e-09, 2.13371352481851e-09, 3.07297625042224e-05, 0.00327188836391756, 0.0451671460203559, 0.171647220913248, 0.23169444477657, 0.114263771244933, 0.0171397524112466, 0.000424739767899628, 1.61410146572347e-07, 2.01471375989046e-11, 1.58806197336117e-06, 0.000446133026607226, 0.0127528928235648, 0.0908301216521036, 0.223391389846431, 0.206474499553127, 0.0641331505680211, 0.00419332584936748, 8.72162717837964e-06, 1.33164552830308e-13, 5.74478433285151e-08, 4.25822212448558e-05, 0.00252053545086122, 0.0336450405011447, 0.150770119559623, 0.261169423613991, 0.167980413728562, 0.0289795966978777, 0.000329884753702203, 5.86776427286293e-16, 1.38544328809055e-09, 2.70957383860042e-06, 0.00033211282840909, 0.00830846808477181, 0.0678379740229315, 0.220235325196703, 0.293321203844397, 0.133516458445242, 0.00831832168466078, 1.55134336413513e-18, 2.00472601925763e-11, 1.03448671847499e-07, 2.62560712858529e-05, 0.00123103983625741, 0.0183139367388352, 0.111430192233037, 0.307312001613783, 0.369086806726999, 0.125852089021298, 1.86432028648487e-21, 1.31855612464379e-13, 1.7952550918385e-09, 9.4352009371759e-07, 8.290878999979e-05, 0.00224733527808401, 0.0256269014436379, 0.146350059404454, 0.463766695834671, 0.86549081934902, 

0.886566726268818, 0.527617787112179, 0.203047157171455, 0.0485409057706592, 0.0067420536151384, 0.00048828125, 1.54244694977493e-05, 1.55349924899673e-07, 2.69762258323706e-10, 1.86159711174352e-14, 2.54335636690079e-22, 0.107327946715829, 0.347347031941979, 0.34835699265783, 0.16903380853203, 0.0426709174975761, 0.00537109375, 0.000294887135757529, 5.39797311504831e-06, 1.90256253186467e-08, 3.42158160716771e-12, 2.54209158778476e-19, 0.00590597403593869, 0.103940565539841, 0.271662361197511, 0.267557171844063, 0.122757795124009, 0.02685546875, 0.00256258770131351, 8.52565404714609e-05, 6.0992159442174e-07, 2.85854759790927e-10, 1.15492156255794e-16, 0.000194994111303749, 0.0186619838453894, 0.127111738900382, 0.254103628712698, 0.211893399262825, 0.08056640625, 0.0133614286904456, 0.000807934112109426, 1.17316832990723e-05, 1.43289776033315e-08, 3.1482197307225e-14, 4.29200480866383e-06, 0.00223377426793059, 0.0396506754317028, 0.160884378915951, 0.243834142973968, 0.1611328125, 0.0464446612717173, 0.0051042616077731, 0.000150437252141367, 4.78843636787077e-07, 5.72118938303119e-12, 6.61297595506798e-08, 0.000187162483098554, 0.00865791981962936, 0.0713041701026069, 0.196412736973804, 0.2255859375, 0.113009965283947, 0.0225729305385987, 0.00135035666906764, 1.12013476737318e-05, 7.27789275505809e-10, 7.27789275505786e-10, 1.12013476737318e-05, 0.00135035666906764, 0.0225729305385987, 0.113009965283947, 0.2255859375, 0.196412736973804, 0.0713041701026068, 0.00865791981962934, 0.000187162483098554, 6.61297595506814e-08, 5.72118938303099e-12, 4.78843636787077e-07, 0.000150437252141368, 0.0051042616077731, 0.0464446612717172, 0.1611328125, 0.243834142973968, 0.160884378915951, 0.0396506754317027, 0.00223377426793059, 4.29200480866392e-06, 3.14821973072237e-14, 1.43289776033315e-08, 1.17316832990723e-05, 0.000807934112109427, 0.0133614286904455, 0.08056640625, 0.211893399262826, 0.254103628712698, 0.127111738900381, 0.0186619838453894, 0.000194994111303752, 1.15492156255789e-16, 2.85854759790927e-10, 6.09921594421742e-07, 8.5256540471461e-05, 0.00256258770131351, 0.02685546875, 0.122757795124009, 0.267557171844063, 0.271662361197511, 0.103940565539841, 0.00590597403593875, 2.54209158778463e-19, 3.42158160716771e-12, 1.90256253186468e-08, 5.39797311504832e-06, 0.000294887135757528, 0.00537109375, 0.0426709174975761, 0.16903380853203, 0.34835699265783, 0.347347031941979, 0.107327946715829, 2.54335636690064e-22, 1.86159711174352e-14, 2.69762258323707e-10, 1.55349924899674e-07, 1.54244694977493e-05, 0.00048828125, 0.0067420536151384, 0.0485409057706592, 0.203047157171455, 0.527617787112179, 0.886566726268818, 

0.903131672699272, 0.582506298662096, 0.260683346509302, 0.0786997336468345, 0.015311884856471, 0.00178788197467273, 0.000112068644746638, 3.14652672755955e-06, 2.88696400883268e-08, 4.67409281674666e-11, 3.0747869316834e-15, 4.0914364966471e-23, 0.0924447753114829, 0.32265624452157, 0.372793351675636, 0.225069991112005, 0.0778433632706149, 0.0152890711389462, 0.00158572266907258, 7.48900047998682e-05, 1.22146888565156e-06, 3.95483010569882e-09, 6.71677728246163e-13, 4.83648546730358e-20, 0.0043012133832491, 0.0812375547525309, 0.24232618705363, 0.292576367922893, 0.179883714871923, 0.0594293083820453, 0.0101987669695879, 0.000810202559626502, 2.34909600858159e-05, 1.52102254025571e-07, 6.66936043264938e-11, 2.59873070970728e-17, 0.000120074519122833, 0.0122722688574451, 0.0945113114297881, 0.228198163541989, 0.249409708290481, 0.138602639598092, 0.0393567613285586, 0.00525913856765962, 0.000271063084243381, 3.50989980272309e-06, 3.97336699223894e-09, 8.37806876158048e-15, 2.2347012122563e-06, 0.00123595204515291, 0.0245740066224636, 0.118657115550449, 0.23053857370703, 0.215501882001401, 0.101251106589127, 0.022758537886785, 0.00208520484393766, 5.3996116862649e-05, 1.57812685983368e-07, 1.80067486822383e-12, 2.91129432054257e-08, 8.71317466202388e-05, 0.00447266316213011, 0.0431890318333497, 0.149166702578715, 0.234546347000086, 0.182338443703665, 0.0689401368791668, 0.011228587165687, 0.00058147142655981, 4.38756116264915e-06, 2.70909806463426e-10, 2.70909806463436e-10, 4.38756116264912e-06, 0.000581471426559808, 0.011228587165687, 0.0689401368791667, 0.182338443703665, 0.234546347000086, 0.149166702578715, 0.0431890318333498, 0.00447266316213012, 8.71317466202393e-05, 2.91129432054249e-08, 1.80067486822391e-12, 1.57812685983367e-07, 5.39961168626488e-05, 0.00208520484393765, 0.022758537886785, 0.101251106589127, 0.215501882001401, 0.23053857370703, 0.11865711555045, 0.0245740066224637, 0.00123595204515291, 2.23470121225625e-06, 8.37806876158088e-15, 3.97336699223891e-09, 3.50989980272308e-06, 0.00027106308424338, 0.00525913856765961, 0.0393567613285586, 0.138602639598092, 0.249409708290481, 0.228198163541989, 0.0945113114297882, 0.0122722688574452, 0.000120074519122831, 2.59873070970742e-17, 6.66936043264931e-11, 1.52102254025571e-07, 2.34909600858158e-05, 0.0008102025596265, 0.0101987669695879, 0.0594293083820453, 0.179883714871923, 0.292576367922893, 0.24232618705363, 0.0812375547525311, 0.00430121338324905, 4.83648546730388e-20, 6.71677728246155e-13, 3.95483010569881e-09, 1.22146888565156e-06, 7.48900047998681e-05, 0.00158572266907258, 0.0152890711389462, 0.0778433632706149, 0.225069991112005, 0.372793351675636, 0.322656244521571, 0.0924447753114823, 4.09143649664738e-23, 3.07478693168336e-15, 4.67409281674664e-11, 2.88696400883267e-08, 3.14652672755955e-06, 0.000112068644746638, 0.00178788197467273, 0.015311884856471, 0.0786997336468345, 0.260683346509302, 0.582506298662096, 0.903131672699272, 

0.916366380860175, 0.629512402692532, 0.316850251509257, 0.114496177898481, 0.028757401112108, 0.00477975912600908, 0.00048828125, 2.73667793745054e-05, 7.01025029354821e-07, 5.98025074957988e-09, 9.16549477171262e-12, 5.80713847832048e-16, 7.56865626183012e-24, 0.0803531133695285, 0.297560285214362, 0.383869205545, 0.274269279628369, 0.120441794960071, 0.0328824326952751, 0.00537109375, 0.000481339089960683, 2.02530908296537e-05, 3.02077645772555e-07, 9.15402441984373e-10, 1.48654095061205e-13, 1.04440896506723e-20, 0.00320268030294508, 0.0639326874679965, 0.21139261479896, 0.298634969657963, 0.229288420501698, 0.102825111195138, 0.02685546875, 0.00384818456437162, 0.000265966180027262, 6.93577667685436e-06, 4.15571291944944e-08, 1.72969245766641e-11, 6.55088113985559e-18, 7.65906436682922e-05, 0.00824180254552984, 0.0698469743538251, 0.195099163617859, 0.261901675212957, 0.192923746067215, 0.08056640625, 0.0184591587307122, 0.00209562114286446, 9.55482779697313e-05, 1.13195786313013e-06, 1.20756955812469e-09, 2.46535859862634e-15, 1.22108695272707e-06, 0.00070832112012086, 0.0153855889778792, 0.0849725975672659, 0.199435823606699, 0.241313114821879, 0.1611328125, 0.059030526446223, 0.0110079859877181, 0.000877524738596554, 2.05552954649539e-05, 5.62036035653333e-08, 6.18542034276104e-13, 1.36274784006847e-08, 4.26124217980656e-05, 0.00237234962960556, 0.0259060036055803, 0.106308038670385, 0.211287694752332, 0.2255859375, 0.132141565731509, 0.040476318509612, 0.00564149117334199, 0.000261285450447978, 1.83110904273233e-06, 1.08631650529751e-10, 1.08631650529756e-10, 1.83110904273235e-06, 0.000261285450447977, 0.005641491173342, 0.040476318509612, 0.132141565731509, 0.2255859375, 0.211287694752332, 0.106308038670385, 0.0259060036055803, 0.00237234962960556, 4.26124217980653e-05, 1.36274784006842e-08, 6.18542034276134e-13, 5.62036035653338e-08, 2.05552954649538e-05, 0.000877524738596556, 0.0110079859877181, 0.059030526446223, 0.1611328125, 0.241313114821879, 0.199435823606699, 0.0849725975672657, 0.0153855889778792, 0.000708321120120856, 1.22108695272703e-06, 2.46535859862648e-15, 1.2075695581247e-09, 1.13195786313013e-06, 9.55482779697316e-05, 0.00209562114286445, 0.0184591587307122, 0.08056640625, 0.192923746067215, 0.261901675212957, 0.195099163617859, 0.0698469743538252, 0.00824180254552981, 7.65906436682906e-05, 6.550881139856e-18, 1.72969245766643e-11, 4.15571291944941e-08, 6.93577667685438e-06, 0.000265966180027262, 0.00384818456437162, 0.02685546875, 0.102825111195138, 0.229288420501698, 0.298634969657963, 0.21139261479896, 0.0639326874679964, 0.00320268030294504, 1.0444089650673e-20, 1.48654095061207e-13, 9.15402441984368e-10, 3.02077645772556e-07, 2.02530908296537e-05, 0.000481339089960683, 0.00537109375, 0.0328824326952751, 0.120441794960071, 0.274269279628369, 0.383869205545, 0.297560285214361, 0.0803531133695279, 7.56865626183071e-24, 5.80713847832056e-16, 9.16549477171256e-12, 5.9802507495799e-09, 7.01025029354821e-07, 2.73667793745054e-05, 0.00048828125, 0.00477975912600908, 0.028757401112108, 0.114496177898481, 0.316850251509257, 0.629512402692532, 0.916366380860175, 

0.927095289645483, 0.669768649722662, 0.370101153087987, 0.154086762645769, 0.0472055397724016, 0.0102747145776369, 0.00150953894615382, 0.000138799899210189, 7.12032704343328e-06, 1.69581894104603e-07, 1.36516497091064e-09, 2.00269498655837e-12, 1.23136057746587e-16, 1.57847939966251e-24, 0.0704221517726889, 0.273409690501538, 0.385005698162813, 0.314127003072049, 0.166119567110988, 0.0583386135772098, 0.0133663801940399, 0.00189672790352659, 0.000151739613846662, 5.83091927888156e-06, 8.10271504943185e-08, 2.3294503694056e-10, 3.64990472295107e-14, 2.51442897307842e-21, 0.00243148461832873, 0.0507318045167199, 0.182050214676648, 0.291086812404496, 0.265721033342052, 0.150563520342477, 0.0537973170088647, 0.0117814361815679, 0.0014698578175543, 9.1132208681806e-05, 2.18601589522361e-06, 1.23159929720707e-08, 4.91762184574603e-12, 1.82061092869964e-18, 5.03715149311475e-05, 0.00564804265306362, 0.0516495430929416, 0.16184192672486, 0.255024746771197, 0.233149596137562, 0.129914813524882, 0.0439079021009651, 0.0085428529138425, 0.000854590406281589, 3.53856612136845e-05, 3.90693920455063e-07, 3.975392201176e-10, 7.90944788464428e-16, 6.9567634997771e-07, 0.000419202984724798, 0.00976900908520531, 0.0599885397982626, 0.163172684394396, 0.240690148828711, 0.209153661825722, 0.109092747675033, 0.0331008596141993, 0.00534260259954493, 0.000381865176816435, 8.26252173774899e-06, 2.14246420307707e-08, 2.29078290346514e-13, 6.72554536439666e-09, 2.17795450986549e-05, 0.00129339918524673, 0.0155648013216743, 0.0730820349346437, 0.173932205296657, 0.235705822513543, 0.189734852226491, 0.0897787709532594, 0.0233800679586396, 0.00288463478664794, 0.000122316942559742, 8.08249058313329e-07, 4.64429435674945e-11, 4.64429435674945e-11, 8.08249058313337e-07, 0.000122316942559742, 0.00288463478664794, 0.0233800679586396, 0.0897787709532594, 0.189734852226491, 0.235705822513544, 0.173932205296657, 0.0730820349346438, 0.0155648013216744, 0.00129339918524673, 2.17795450986547e-05, 6.72554536439666e-09, 2.29078290346514e-13, 2.14246420307709e-08, 8.26252173774899e-06, 0.000381865176816434, 0.00534260259954492, 0.0331008596141993, 0.109092747675033, 0.209153661825722, 0.240690148828711, 0.163172684394396, 0.0599885397982627, 0.00976900908520531, 0.000419202984724795, 6.9567634997771e-07, 7.90944788464428e-16, 3.97539220117605e-10, 3.90693920455063e-07, 3.53856612136844e-05, 0.000854590406281588, 0.0085428529138425, 0.043907902100965, 0.129914813524882, 0.233149596137562, 0.255024746771197, 0.16184192672486, 0.0516495430929416, 0.00564804265306359, 5.03715149311475e-05, 1.82061092869964e-18, 4.91762184574609e-12, 1.23159929720707e-08, 2.18601589522361e-06, 9.11322086818058e-05, 0.0014698578175543, 0.0117814361815679, 0.0537973170088647, 0.150563520342477, 0.265721033342052, 0.291086812404497, 0.182050214676648, 0.0507318045167197, 0.00243148461832873, 2.51442897307842e-21, 3.64990472295113e-14, 2.3294503694056e-10, 8.10271504943182e-08, 5.83091927888154e-06, 0.000151739613846662, 0.00189672790352659, 0.0133663801940399, 0.0583386135772098, 0.166119567110988, 0.314127003072049, 0.385005698162813, 0.273409690501537, 0.0704221517726889, 1.57847939966251e-24, 1.23136057746589e-16, 2.00269498655837e-12, 1.36516497091064e-09, 1.69581894104603e-07, 7.12032704343328e-06, 0.000138799899210189, 0.00150953894615382, 0.0102747145776369, 0.0472055397724016, 0.154086762645769, 0.370101153087987, 0.669768649722662, 0.927095289645483, 

0.935906037395068, 0.704320125066937, 0.419687166747903, 0.195766026523527, 0.0702301283844, 0.0188833567267398, 0.00366787999388122, 0.00048828125, 4.12595024711641e-05, 1.97095024135248e-06, 4.42598696671581e-08, 3.39964859691922e-10, 4.81340435299394e-13, 2.88828372708384e-17, 3.65293064380643e-25, 0.0621816342583801, 0.250855524630276, 0.379158501340792, 0.344142890692415, 0.210976030740041, 0.0902663967257489, 0.0268309396282292, 0.00537109375, 0.000682477900437849, 4.98900709413941e-05, 1.78273112111298e-06, 2.34001112801686e-08, 6.44677641169452e-11, 9.8123188407069e-15, 6.65268428571154e-22, 0.00187788647604607, 0.0406120171766229, 0.15570165387383, 0.27499044120382, 0.288084632173267, 0.196132848040833, 0.089214195881126, 0.02685546875, 0.00513133676860347, 0.000574023803413857, 3.26391530304668e-05, 7.32114714899547e-07, 3.92473365234448e-09, 1.51523770656358e-12, 5.50718568943508e-19, 3.40273232665139e-05, 0.00394490639562797, 0.0383633835453784, 0.131840136406116, 0.236025168366167, 0.255697106404837, 0.177984957448347, 0.08056640625, 0.0231485447507642, 0.00396275235534675, 0.000358544582947924, 1.37433181241329e-05, 1.43360339414624e-07, 1.40391604349456e-10, 2.73535549700369e-16, 4.1105031053199e-07, 0.000255462751375381, 0.00630157809474269, 0.0421392139825932, 0.128915542820469, 0.22223375933505, 0.236723500223368, 0.1611328125, 0.0696186521163853, 0.0182378107393391, 0.00262576703182836, 0.000171993804811527, 3.4910542111648e-06, 8.67181982357707e-09, 9.05746312415311e-14, 3.47584350157521e-09, 1.15802119383174e-05, 0.000724569054395812, 0.0094280799643642, 0.0492890317885051, 0.135204856784716, 0.22039284360301, 0.2255859375, 0.146563412183377, 0.0587552280627923, 0.0134606879683542, 0.00150671824943937, 5.95089387241907e-05, 3.74953485151285e-07, 2.09941072868519e-11, 2.09941072868507e-11, 3.74953485151285e-07, 5.95089387241904e-05, 0.00150671824943937, 0.0134606879683542, 0.0587552280627923, 0.146563412183377, 0.2255859375, 0.22039284360301, 0.135204856784716, 0.0492890317885051, 0.00942807996436418, 0.000724569054395814, 1.15802119383174e-05, 3.47584350157537e-09, 9.05746312415253e-14, 8.67181982357707e-09, 3.49105421116478e-06, 0.000171993804811527, 0.00262576703182836, 0.0182378107393391, 0.0696186521163853, 0.1611328125, 0.236723500223368, 0.22223375933505, 0.128915542820469, 0.0421392139825931, 0.00630157809474271, 0.000255462751375381, 4.11050310532005e-07, 2.73535549700349e-16, 1.40391604349456e-10, 1.43360339414623e-07, 1.37433181241329e-05, 0.000358544582947924, 0.00396275235534675, 0.0231485447507642, 0.08056640625, 0.177984957448347, 0.255697106404837, 0.236025168366167, 0.131840136406116, 0.0383633835453784, 0.00394490639562797, 3.40273232665149e-05, 5.50718568943462e-19, 1.51523770656358e-12, 3.92473365234446e-09, 7.3211471489955e-07, 3.26391530304668e-05, 0.000574023803413857, 0.00513133676860347, 0.02685546875, 0.089214195881126, 0.196132848040833, 0.288084632173267, 0.27499044120382, 0.155701653873831, 0.0406120171766229, 0.0018778864760461, 6.65268428571092e-22, 9.8123188407069e-15, 6.44677641169447e-11, 2.34001112801687e-08, 1.78273112111298e-06, 4.98900709413941e-05, 0.000682477900437849, 0.00537109375, 0.0268309396282292, 0.0902663967257489, 0.210976030740041, 0.344142890692415, 0.379158501340792, 0.250855524630276, 0.0621816342583806, 3.65293064380606e-25, 2.88828372708384e-17, 4.8134043529939e-13, 3.39964859691923e-10, 4.42598696671581e-08, 1.97095024135248e-06, 4.12595024711641e-05, 0.00048828125, 0.00366787999388122, 0.0188833567267398, 0.0702301283844, 0.195766026523527, 0.419687166747903, 0.704320125066937, 0.935906037395068, 

0.943225520083775, 0.734077280240195, 0.465322240797327, 0.238132723533588, 0.097066267092164, 0.0309070663414845, 0.00748101920341895, 0.00132519544955756, 0.000162831484625307, 1.2843281329868e-05, 5.78781068822832e-07, 1.23855261190719e-08, 9.153873949567e-11, 1.25878856181714e-13, 7.40339256731053e-18, 9.26004638691567e-26, 0.0552781456566423, 0.230152282224746, 0.368654152599516, 0.364991881859558, 0.252185291158939, 0.126378672949287, 0.0461279261587768, 0.0120474772882024, 0.00216724281891425, 0.000252033462460141, 1.71270940051426e-05, 5.76830752023388e-07, 7.2264694691267e-09, 1.92252873126441e-11, 2.85721318757825e-15, 1.91187990810999e-22, 0.00147254545087023, 0.0327994157607488, 0.132758326394115, 0.254287288057798, 0.297816322161424, 0.234891399914195, 0.129283889476713, 0.0497839802554172, 0.0131115513991311, 0.00224811091949633, 0.000230372356399414, 1.22112372898756e-05, 2.59313266392782e-07, 1.33465866044528e-09, 5.0122397051255e-13, 1.79426000019313e-19, 2.35361379704827e-05, 0.00280458224575654, 0.0286850530818994, 0.10629610369143, 0.21102236693858, 0.261945952427229, 0.217408309500341, 0.123433875696058, 0.0475939600099396, 0.0120317421116046, 0.00185920936419512, 0.000155103710015381, 5.58308898262766e-06, 5.55928359644346e-08, 5.27560497848539e-11, 1.01032568038511e-16, 2.50790126823467e-07, 0.00015987442440211, 0.00413198073351561, 0.0296223004205937, 0.0996821106046788, 0.194744413852737, 0.243734277235987, 0.204027099898159, 0.115175032075297, 0.0429287294752613, 0.010003108341459, 0.0013133892053391, 8.0137004485079e-05, 1.54374722774308e-06, 3.70187241983645e-09, 3.79267954601805e-14, 1.87061196929194e-09, 6.37951770949326e-06, 0.000416638076749536, 0.00577854179235601, 0.0329612747839516, 0.101348276095877, 0.191273639105129, 0.236069232053838, 0.19510252157086, 0.107217480069483, 0.0376738224820633, 0.00778507389134111, 0.000805173919935158, 3.00076228038148e-05, 1.81831308978635e-07, 9.96618505560559e-12, 9.96618505560621e-12, 1.81831308978635e-07, 3.00076228038147e-05, 0.00080517391993516, 0.00778507389134111, 0.0376738224820633, 0.107217480069483, 0.19510252157086, 0.236069232053838, 0.191273639105128, 0.101348276095877, 0.0329612747839516, 0.00577854179235599, 0.000416638076749538, 6.37951770949326e-06, 1.87061196929184e-09, 3.79267954601833e-14, 3.70187241983645e-09, 1.54374722774307e-06, 8.01370044850793e-05, 0.0013133892053391, 0.010003108341459, 0.0429287294752614, 0.115175032075296, 0.204027099898159, 0.243734277235987, 0.194744413852737, 0.0996821106046788, 0.0296223004205937, 0.00413198073351562, 0.00015987442440211, 2.50790126823457e-07, 1.01032568038519e-16, 5.27560497848539e-11, 5.55928359644342e-08, 5.58308898262768e-06, 0.000155103710015381, 0.00185920936419512, 0.0120317421116046, 0.0475939600099396, 0.123433875696058, 0.217408309500341, 0.261945952427229, 0.21102236693858, 0.10629610369143, 0.0286850530818995, 0.00280458224575654, 2.3536137970482e-05, 1.7942600001933e-19, 5.0122397051255e-13, 1.33465866044527e-09, 2.59313266392783e-07, 1.22112372898756e-05, 0.000230372356399414, 0.00224811091949634, 0.0131115513991311, 0.0497839802554172, 0.129283889476713, 0.234891399914195, 0.297816322161424, 0.254287288057798, 0.132758326394115, 0.0327994157607488, 0.0014725454508702, 1.91187990811019e-22, 2.85721318757825e-15, 1.9225287312644e-11, 7.22646946912673e-09, 5.76830752023388e-07, 1.71270940051426e-05, 0.000252033462460142, 0.00216724281891425, 0.0120474772882024, 0.0461279261587768, 0.126378672949287, 0.252185291158939, 0.364991881859558, 0.368654152599516, 0.230152282224746, 0.0552781456566417, 9.26004638691674e-26, 7.40339256731053e-18, 1.25878856181713e-13, 9.15387394956704e-11, 1.23855261190719e-08, 5.78781068822832e-07, 1.28432813298681e-05, 0.000162831484625307, 0.00132519544955755, 0.00748101920341895, 0.0309070663414845, 0.097066267092164, 0.238132723533588, 0.465322240797327, 0.734077280240195, 0.943225520083775, 

0.949369308550409, 0.759810733109086, 0.507007123004045, 0.280124886586382, 0.126809632639431, 0.0463362665810559, 0.0133874650467754, 0.00297324967359862, 0.00048828125, 5.61623512145792e-05, 4.18461410684163e-06, 1.79689765343207e-07, 3.69443841737307e-09, 2.64441562084395e-11, 3.54922446263443e-14, 2.05285155557366e-18, 2.54404077167653e-26, 0.0494434401239189, 0.211337017876886, 0.355229079219833, 0.377901611886141, 0.288064696850607, 0.164198232818822, 0.0707051044657256, 0.0227990230614343, 0.00537109375, 0.000886228665502286, 9.58712448989563e-05, 6.13565980481718e-06, 1.9678682053096e-07, 2.37185444337353e-09, 6.12949065446448e-12, 8.93043812153615e-16, 5.91065955151091e-23, 0.00117046785657402, 0.0267191750278128, 0.113130649002345, 0.231730454886536, 0.29744395682815, 0.264480244585927, 0.169738556995534, 0.079465462436821, 0.02685546875, 0.00635658157735973, 0.000998386357499526, 9.52306001820435e-05, 4.7645392097508e-06, 9.66993761943203e-08, 4.81163446968923e-10, 1.76589673799335e-13, 6.24201980401657e-20, 1.66249961552765e-05, 0.00202685072782503, 0.0216173919744415, 0.0852587054930585, 0.184277160834052, 0.255604942545569, 0.24449022130977, 0.166185008101849, 0.08056640625, 0.0273560070368938, 0.00623821242683387, 0.000886835401523939, 6.92144946089456e-05, 2.36543251188827e-06, 2.26627244334295e-08, 2.09512092026173e-11, 3.95517395926909e-17, 1.574245122641e-07, 0.000102501265317475, 0.00275381687690404, 0.0209123623562593, 0.0761108576938379, 0.164684982441723, 0.234774661197232, 0.231693585875069, 0.1611328125, 0.0784856988403942, 0.0259854607654219, 0.00550577249954455, 0.000670319633312079, 3.85750228422995e-05, 7.11607226166722e-07, 1.65714924550886e-09, 1.67076272736956e-14, 1.04347295969791e-09, 3.62856350160054e-06, 0.000245564089337942, 0.00359058735120684, 0.0220049182593812, 0.0742739957225073, 0.157811624822848, 0.226117523139776, 0.2255859375, 0.157625469240088, 0.0757702507533546, 0.0239271814535765, 0.0045442777461514, 0.000440351887387922, 1.56410758147866e-05, 9.17512930510604e-08, 4.94039878887719e-12, 4.94039878887684e-12, 9.17512930510617e-08, 1.56410758147866e-05, 0.000440351887387924, 0.00454427774615141, 0.0239271814535766, 0.0757702507533546, 0.157625469240088, 0.2255859375, 0.226117523139776, 0.157811624822848, 0.0742739957225072, 0.0220049182593811, 0.00359058735120683, 0.000245564089337942, 3.6285635016005e-06, 1.04347295969797e-09, 1.67076272736942e-14, 1.65714924550889e-09, 7.11607226166722e-07, 3.85750228422997e-05, 0.00067031963331208, 0.00550577249954455, 0.0259854607654219, 0.0784856988403941, 0.1611328125, 0.231693585875069, 0.234774661197232, 0.164684982441722, 0.0761108576938378, 0.0209123623562593, 0.00275381687690404, 0.000102501265317474, 1.57424512264107e-07, 3.95517395926872e-17, 2.09512092026177e-11, 2.26627244334295e-08, 2.36543251188828e-06, 6.92144946089458e-05, 0.00088683540152394, 0.00623821242683387, 0.0273560070368938, 0.08056640625, 0.166185008101849, 0.24449022130977, 0.255604942545569, 0.184277160834052, 0.0852587054930583, 0.0216173919744415, 0.00202685072782501, 1.66249961552771e-05, 6.24201980401591e-20, 1.76589673799338e-13, 4.81163446968923e-10, 9.66993761943207e-08, 4.76453920975081e-06, 9.52306001820437e-05, 0.000998386357499526, 0.00635658157735973, 0.02685546875, 0.079465462436821, 0.169738556995534, 0.264480244585926, 0.29744395682815, 0.231730454886536, 0.113130649002345, 0.0267191750278127, 0.00117046785657405, 5.91065955151022e-23, 8.93043812153636e-16, 6.12949065446447e-12, 2.37185444337355e-09, 1.9678682053096e-07, 6.13565980481719e-06, 9.58712448989563e-05, 0.000886228665502286, 0.00537109375, 0.0227990230614343, 0.0707051044657256, 0.164198232818822, 0.288064696850607, 0.377901611886141, 0.355229079219833, 0.211337017876886, 0.0494434401239195, 2.5440407716762e-26, 2.05285155557371e-18, 3.54922446263443e-14, 2.64441562084397e-11, 3.69443841737308e-09, 1.79689765343208e-07, 4.18461410684163e-06, 5.61623512145792e-05, 0.00048828125, 0.00297324967359862, 0.0133874650467754, 0.0463362665810559, 0.126809632639431, 0.280124886586382, 0.507007123004045, 0.759810733109086, 0.949369308550409, 

0.954574415655241, 0.782163249223514, 0.544908354902523, 0.320989288393295, 0.158558781795711, 0.0649140620789487, 0.0216775271327536, 0.00577941017902508, 0.00119510606580852, 0.00018427931995875, 2.00592277559802e-05, 1.42508874339744e-06, 5.8767472301626e-08, 1.1683678251673e-09, 8.14090446284099e-12, 1.070551167949e-14, 6.1055639347767e-19, 7.50776406381361e-27, 0.0444717652665947, 0.194333296018468, 0.340134792018295, 0.384261659553671, 0.317873803970986, 0.201534541706033, 0.0993585736418691, 0.0379908485366634, 0.0110914246030517, 0.00240259788594212, 0.000369236056959723, 3.76211156328033e-05, 2.29040179843607e-06, 7.05180866896275e-08, 8.22851593224999e-10, 2.075225087938e-12, 2.97345481516803e-16, 1.94994071763675e-23, 0.000941751382268435, 0.0219469586890722, 0.0965063672053998, 0.209093670924822, 0.289665316164664, 0.284405189652292, 0.207003780620146, 0.113514617002221, 0.0467891904571644, 0.0142384560637862, 0.00308937991526614, 0.000451438661759323, 4.05754794185388e-05, 1.9346338009661e-06, 3.78048648460411e-08, 1.8285224957609e-10, 6.58224771573142e-14, 2.30202226169388e-20, 1.19657359318368e-05, 0.00148714298239679, 0.0164290377751462, 0.0682662380705897, 0.158376049250852, 0.240811261086371, 0.258763166299983, 0.203505350938277, 0.118428159879541, 0.0506286047115719, 0.0155092138174755, 0.00325025234211847, 0.000431287522870906, 3.18455147001975e-05, 1.04213772043093e-06, 9.66688732784889e-09, 8.74255457393991e-12, 1.63060541648366e-17, 1.01356429510848e-07, 6.71799763974657e-05, 0.001864562861037, 0.0148586651449818, 0.0577286304263636, 0.135932970695567, 0.21564300591676, 0.243225227753126, 0.199835744330653, 0.120015616091969, 0.051905931467038, 0.0156007023505351, 0.0030561795785648, 0.000349467275930656, 1.9151874285102e-05, 3.40707541474859e-07, 7.7412523076422e-10, 7.70011095174897e-15, 6.00981678285065e-10, 2.12434479907454e-06, 0.000148128959056416, 0.00226387091615744, 0.0147296030597254, 0.0537119431505579, 0.125795856752017, 0.203488300430253, 0.23604206404088, 0.199148756549673, 0.121602424675939, 0.052416650077683, 0.0151596398801052, 0.00268449622081144, 0.000246374348619178, 8.40571917481651e-06, 4.79824183522349e-08, 2.54532431015551e-12, 2.54532431015551e-12, 4.79824183522349e-08, 8.40571917481651e-06, 0.000246374348619178, 0.00268449622081144, 0.0151596398801052, 0.052416650077683, 0.121602424675939, 0.199148756549673, 0.23604206404088, 0.203488300430252, 0.125795856752017, 0.0537119431505579, 0.0147296030597254, 0.00226387091615744, 0.000148128959056416, 2.12434479907454e-06, 6.00981678285065e-10, 7.70011095174897e-15, 7.7412523076422e-10, 3.40707541474859e-07, 1.91518742851019e-05, 0.000349467275930656, 0.0030561795785648, 0.0156007023505351, 0.051905931467038, 0.120015616091969, 0.199835744330653, 0.243225227753126, 0.21564300591676, 0.135932970695567, 0.0577286304263636, 0.0148586651449818, 0.001864562861037, 6.71799763974657e-05, 1.01356429510848e-07, 1.63060541648366e-17, 8.74255457393991e-12, 9.66688732784888e-09, 1.04213772043093e-06, 3.18455147001975e-05, 0.000431287522870906, 0.00325025234211847, 0.0155092138174755, 0.0506286047115719, 0.118428159879541, 0.203505350938277, 0.258763166299983, 0.240811261086371, 0.158376049250852, 0.0682662380705898, 0.0164290377751462, 0.00148714298239679, 1.19657359318368e-05, 2.30202226169388e-20, 6.58224771573142e-14, 1.8285224957609e-10, 3.78048648460409e-08, 1.9346338009661e-06, 4.05754794185388e-05, 0.000451438661759323, 0.00308937991526614, 0.0142384560637862, 0.0467891904571644, 0.113514617002221, 0.207003780620146, 0.284405189652292, 0.289665316164664, 0.209093670924823, 0.0965063672053998, 0.0219469586890722, 0.000941751382268435, 1.94994071763675e-23, 2.97345481516803e-16, 2.075225087938e-12, 8.22851593224995e-10, 7.05180866896275e-08, 2.29040179843607e-06, 3.76211156328033e-05, 0.000369236056959723, 0.00240259788594212, 0.0110914246030517, 0.0379908485366634, 0.0993585736418691, 0.201534541706033, 0.317873803970986, 0.384261659553671, 0.340134792018295, 0.194333296018468, 0.0444717652665947, 7.50776406381361e-27, 6.1055639347767e-19, 1.070551167949e-14, 8.14090446284094e-12, 1.1683678251673e-09, 5.8767472301626e-08, 1.42508874339744e-06, 2.00592277559802e-05, 0.00018427931995875, 0.00119510606580852, 0.00577941017902508, 0.0216775271327536, 0.0649140620789487, 0.158558781795711, 0.320989288393295, 0.544908354902523, 0.782163249223514, 0.954574415655241, 

0.95902145017655, 0.801667262583609, 0.579279392479289, 0.360226444227865, 0.191498657503255, 0.0862219292844185, 0.0324701233628251, 0.0100584750305455, 0.00250717538167547, 0.00048828125, 7.14006348140359e-05, 7.41900588890221e-06, 5.06282764967861e-07, 2.01749692708119e-08, 3.89848066544757e-10, 2.65504087547811e-12, 3.43142658572844e-15, 1.93377183378843e-19, 2.36219471370049e-27, 0.0402036341932291, 0.179010600930926, 0.324249674626892, 0.385409507331974, 0.341541068361658, 0.23670638895896, 0.130577506072396, 0.0574355265288836, 0.019956251932079, 0.00537109375, 0.0010854084047733, 0.000157210888266923, 1.52333030692865e-05, 8.89213419855212e-07, 2.64486528356099e-08, 3.00268482729841e-10, 7.41768885149521e-13, 1.04786660282409e-16, 6.81811107111276e-24, 0.000766089700574676, 0.01816940356752, 0.0824989342249547, 0.187433223944691, 0.276883738788899, 0.295378950570291, 0.238687744108674, 0.149075539764508, 0.072202221542248, 0.02685546875, 0.00750000592508692, 0.00151424743421153, 0.000208339847052094, 1.7814615532132e-05, 8.15622216179329e-07, 1.54356743111851e-08, 7.28852808577651e-11, 2.58097671684597e-14, 8.94519411976819e-21, 8.7588116015458e-06, 0.00110650617655921, 0.0125941359652898, 0.0546917698239971, 0.134680034538989, 0.221156830173605, 0.261784012735397, 0.232157877527981, 0.156737672385942, 0.08056640625, 0.0310943357149076, 0.00875109345399696, 0.00170962889685577, 0.000214140173419349, 1.50912699484554e-05, 4.76094006153851e-07, 4.29696980183618e-09, 3.81428750278776e-12, 7.04152487447901e-18, 6.67604856314039e-08, 4.49237244438175e-05, 0.00128173179611192, 0.0106391301162407, 0.04367347292348, 0.110390045144844, 0.191410105225581, 0.241028944938195, 0.226832336736232, 0.1611328125, 0.0859428399753942, 0.0337160382600504, 0.00935276666568555, 0.00171604466341542, 0.000186153527241242, 9.78968149262624e-06, 1.68885946614509e-07, 3.75795438446831e-10, 3.69532301509492e-15, 3.56198289351036e-10, 1.27672013266637e-06, 9.13111849184754e-05, 0.00144873283487061, 0.00991357457405492, 0.0385706986316473, 0.0979680905634605, 0.1751672915071, 0.229791828245142, 0.2255859375, 0.166278523121706, 0.090930335660372, 0.0358159429362388, 0.00962624839547888, 0.0016073660517571, 0.000140910206265586, 4.64646599708089e-06, 2.5917172740115e-08, 1.35748842765117e-12, 1.35748842765117e-12, 2.5917172740115e-08, 4.64646599708089e-06, 0.000140910206265586, 0.00160736605175709, 0.0096262483954789, 0.0358159429362388, 0.090930335660372, 0.166278523121706, 0.2255859375, 0.229791828245142, 0.175167291507101, 0.0979680905634605, 0.0385706986316473, 0.00991357457405494, 0.00144873283487061, 9.13111849184754e-05, 1.27672013266637e-06, 3.56198289351036e-10, 3.69532301509492e-15, 3.75795438446831e-10, 1.68885946614509e-07, 9.78968149262624e-06, 0.000186153527241242, 0.00171604466341542, 0.00935276666568554, 0.0337160382600504, 0.0859428399753942, 0.1611328125, 0.226832336736232, 0.241028944938195, 0.191410105225581, 0.110390045144844, 0.0436734729234801, 0.0106391301162407, 0.00128173179611192, 4.49237244438175e-05, 6.67604856314039e-08, 7.04152487447901e-18, 3.81428750278776e-12, 4.29696980183618e-09, 4.76094006153851e-07, 1.50912699484553e-05, 0.000214140173419349, 0.00170962889685577, 0.00875109345399695, 0.0310943357149076, 0.08056640625, 0.156737672385942, 0.232157877527981, 0.261784012735397, 0.221156830173605, 0.134680034538989, 0.0546917698239971, 0.0125941359652898, 0.00110650617655921, 8.7588116015458e-06, 8.94519411976819e-21, 2.58097671684597e-14, 7.28852808577651e-11, 1.54356743111851e-08, 8.15622216179326e-07, 1.78146155321321e-05, 0.000208339847052094, 0.00151424743421152, 0.00750000592508692, 0.02685546875, 0.072202221542248, 0.149075539764508, 0.238687744108674, 0.295378950570291, 0.276883738788899, 0.187433223944691, 0.0824989342249547, 0.01816940356752, 0.000766089700574676, 6.81811107111276e-24, 1.04786660282409e-16, 7.41768885149521e-13, 3.00268482729841e-10, 2.64486528356098e-08, 8.89213419855214e-07, 1.52333030692865e-05, 0.000157210888266922, 0.0010854084047733, 0.00537109375, 0.019956251932079, 0.0574355265288836, 0.130577506072396, 0.23670638895896, 0.341541068361658, 0.385409507331974, 0.324249674626892, 0.179010600930926, 0.0402036341932291, 2.36219471370049e-27, 1.93377183378843e-19, 3.43142658572844e-15, 2.65504087547811e-12, 3.89848066544755e-10, 2.01749692708119e-08, 5.06282764967861e-07, 7.41900588890219e-06, 7.14006348140359e-05, 0.00048828125, 0.00250717538167547, 0.0100584750305455, 0.0324701233628251, 0.0862219292844185, 0.191498657503255, 0.360226444227865, 0.579279392479289, 0.801667262583609, 0.95902145017655, 

0.962849871731804, 0.818762759410233, 0.610411224869654, 0.397532757990642, 0.224938982021099, 0.109759745015756, 0.0457255191358952, 0.0160510002960226, 0.00466679705532299, 0.00109885937107583, 0.000203394287014079, 2.84305557639511e-05, 2.8394232437668e-06, 1.87226204506845e-07, 7.24570577582251e-09, 1.36645187882291e-10, 9.12604488241914e-13, 1.16208019032424e-15, 6.48218445882968e-20, 7.8735057752368e-28, 0.0365141523509801, 0.165217680616026, 0.308175599691681, 0.382530868747483, 0.359415222118474, 0.268581167236859, 0.16283661140761, 0.0804968997502879, 0.0322869284076045, 0.0103689431973899, 0.00260814505398787, 0.000497236389342861, 6.85075524595546e-05, 6.36148624116332e-06, 3.58289101272562e-07, 1.03477986902661e-08, 1.14755736766427e-10, 2.78513165750155e-13, 3.88694428454725e-17, 2.51218069722792e-24, 0.000629420942338276, 0.0151541743788028, 0.0707214745910223, 0.167315960535656, 0.261039078100572, 0.298734474282727, 0.263586271416115, 0.183498925297894, 0.101534086405808, 0.0444737953904778, 0.0152020463274559, 0.00395291775222255, 0.000751318512291261, 9.82489392810462e-05, 8.05311349310128e-06, 3.56187701067726e-07, 6.55908909384411e-09, 3.03411949388207e-11, 1.05943072734285e-14, 3.64343408923589e-21, 6.50987133173918e-06, 0.000833987017298266, 0.00973768261990724, 0.0439096024981698, 0.113753780199886, 0.199363835617578, 0.256002830856511, 0.250980018037489, 0.191579153745094, 0.11445246282757, 0.0531647299728426, 0.018854885632751, 0.00494380096773836, 0.000910433854974636, 0.000108603867718713, 7.35632855969188e-06, 2.24938557077371e-07, 1.98321994833382e-09, 1.73255912697334e-12, 3.17045950808892e-18, 4.4886150539537e-08, 3.05981409318237e-05, 0.000893858273877872, 0.00768228440520433, 0.0330472167971175, 0.0886984761246234, 0.165758378473072, 0.228851365575532, 0.240986867556278, 0.196360817754732, 0.123952107157242, 0.0599568444556741, 0.0216873559471456, 0.00562441902070069, 0.000976417389669045, 0.0001012866151113, 5.14272167330236e-06, 8.64207089052784e-08, 1.88891452172451e-10, 1.83925627054768e-15, 2.16645842184994e-10, 7.85830410240349e-07, 5.74354136889377e-05, 0.00094084763303047, 0.0067205061254373, 0.0276238353346353, 0.0751284193204711, 0.146071641697683, 0.212195682252051, 0.235821046203064, 0.202293652457148, 0.133460169792087, 0.0665963269422135, 0.0243223188629236, 0.00614502648213407, 0.000976205021597626, 8.230385482543e-05, 2.63610561893341e-06, 1.44156618402418e-08, 7.46896320259788e-13, 7.46896320259716e-13, 1.44156618402416e-08, 2.63610561893341e-06, 8.23038548254297e-05, 0.000976205021597626, 0.00614502648213408, 0.0243223188629236, 0.0665963269422135, 0.133460169792087, 0.202293652457148, 0.235821046203064, 0.212195682252051, 0.146071641697683, 0.0751284193204711, 0.0276238353346353, 0.0067205061254373, 0.000940847633030474, 5.74354136889377e-05, 7.85830410240361e-07, 2.16645842185012e-10, 1.83925627054747e-15, 1.88891452172447e-10, 8.64207089052783e-08, 5.14272167330234e-06, 0.0001012866151113, 0.000976417389669047, 0.00562441902070069, 0.0216873559471456, 0.0599568444556741, 0.123952107157242, 0.196360817754732, 0.240986867556278, 0.228851365575532, 0.165758378473072, 0.0886984761246233, 0.0330472167971175, 0.00768228440520435, 0.000893858273877873, 3.05981409318241e-05, 4.48861505395399e-08, 3.17045950808851e-18, 1.73255912697329e-12, 1.98321994833382e-09, 2.2493855707737e-07, 7.35632855969188e-06, 0.000108603867718714, 0.000910433854974636, 0.00494380096773836, 0.018854885632751, 0.0531647299728426, 0.11445246282757, 0.191579153745094, 0.250980018037489, 0.256002830856511, 0.199363835617578, 0.113753780199886, 0.0439096024981699, 0.00973768261990724, 0.000833987017298274, 6.50987133173949e-06, 3.64343408923536e-21, 1.05943072734282e-14, 3.03411949388207e-11, 6.55908909384407e-09, 3.56187701067726e-07, 8.05311349310131e-06, 9.82489392810462e-05, 0.000751318512291261, 0.00395291775222255, 0.0152020463274559, 0.0444737953904778, 0.101534086405808, 0.183498925297894, 0.263586271416115, 0.298734474282727, 0.261039078100572, 0.167315960535656, 0.0707214745910223, 0.0151541743788029, 0.000629420942338296, 2.51218069722751e-24, 3.88694428454713e-17, 2.78513165750155e-13, 1.14755736766427e-10, 1.03477986902662e-08, 3.58289101272563e-07, 6.36148624116332e-06, 6.85075524595546e-05, 0.000497236389342861, 0.00260814505398787, 0.0103689431973899, 0.0322869284076045, 0.0804968997502879, 0.16283661140761, 0.268581167236859, 0.359415222118474, 0.382530868747483, 0.308175599691681, 0.165217680616027, 0.0365141523509807, 7.8735057752354e-28, 6.48218445882946e-20, 1.16208019032424e-15, 9.12604488241907e-13, 1.36645187882291e-10, 7.24570577582254e-09, 1.87226204506845e-07, 2.8394232437668e-06, 2.84305557639511e-05, 0.000203394287014079, 0.00109885937107583, 0.00466679705532299, 0.0160510002960226, 0.0457255191358952, 0.109759745015756, 0.224938982021099, 0.397532757990642, 0.610411224869654, 0.818762759410233, 0.962849871731804, 

0.966168675911241, 0.833813449959271, 0.638602647743786, 0.432749288512411, 0.258323296578574, 0.13500797093596, 0.0612781325323938, 0.023901631036031, 0.00790357547816385, 0.00217707819771306, 0.00048828125, 8.65280598032676e-05, 1.16360866925802e-05, 1.12325675632762e-06, 7.19102849516372e-08, 2.71371919923967e-09, 5.0115232677207e-11, 3.29107217344525e-13, 4.13737066897295e-16, 2.28755611971731e-20, 2.76497251519804e-28, 0.0333045543010179, 0.152800747183368, 0.292314326902701, 0.376626574933724, 0.372074192785028, 0.296512839776918, 0.194787248907063, 0.106260134104298, 0.0480573955329587, 0.0178619471050697, 0.00537109375, 0.00127610839495719, 0.000231555815696367, 3.05718407166369e-05, 2.73729357321094e-06, 1.49508603032667e-07, 4.21006835778163e-09, 4.57560134071787e-11, 1.09368036428386e-13, 1.51042980177331e-17, 9.70566989082481e-25, 0.000521833094160348, 0.0127279769075314, 0.0608200548312718, 0.148991975378792, 0.243597508115925, 0.296009001081589, 0.281444551326725, 0.214728900581992, 0.132823272189335, 0.0666132907188633, 0.02685546875, 0.00855451682580143, 0.00209450671547503, 0.000378217357509899, 4.736189438233e-05, 3.74407706305499e-06, 1.60762911524317e-07, 2.89158704157638e-09, 1.3141160445319e-11, 4.5332185145312e-15, 1.54859385847714e-21, 4.90581154216448e-06, 0.000636128026118523, 0.00759267417825231, 0.0353643797937216, 0.09569018294355, 0.17730361110954, 0.243992466393818, 0.260352583593922, 0.220261894421426, 0.149054203585779, 0.08056640625, 0.034407621677957, 0.0113673457986195, 0.00280745351608335, 0.000491686181146808, 5.62567481860491e-05, 3.68327231656546e-06, 1.09641662326735e-07, 9.47388854124823e-10, 8.16326720104242e-13, 1.48252081442427e-18, 3.07467236255673e-08, 2.11952440702499e-05, 0.000631904518304361, 0.00559600320762242, 0.0250594000532292, 0.0708009337500252, 0.141016109866767, 0.210446653432344, 0.243508040593762, 0.222349577857836, 0.1611328125, 0.0922619362878709, 0.0411287136809477, 0.0138928847631616, 0.00340295088676361, 0.000563525031343985, 5.62588092379562e-05, 2.77155622960055e-06, 4.55335556629962e-08, 9.80009106583683e-11, 9.46177916251735e-16, 1.34891588049658e-10, 4.94345237006793e-07, 3.68134227302988e-05, 0.000619851852560864, 0.00459379905228907, 0.0197905757923055, 0.0570504510860664, 0.119074891943323, 0.18844528779115, 0.232180867824867, 0.2255859375, 0.173176323463482, 0.104166775895774, 0.0481249545738623, 0.0164862317210159, 0.00395138947474737, 0.000601513366754496, 4.90421856033385e-05, 1.53190875911382e-06, 8.2355811433566e-09, 4.22710324431499e-13, 4.22710324431544e-13, 8.23558114335643e-09, 1.53190875911383e-06, 4.90421856033385e-05, 0.000601513366754496, 0.00395138947474737, 0.0164862317210159, 0.0481249545738622, 0.104166775895774, 0.173176323463482, 0.2255859375, 0.232180867824867, 0.18844528779115, 0.119074891943323, 0.0570504510860665, 0.0197905757923055, 0.00459379905228907, 0.000619851852560864, 3.68134227302985e-05, 4.94345237006801e-07, 1.34891588049646e-10, 9.46177916251853e-16, 9.8000910658366e-11, 4.55335556629967e-08, 2.77155622960055e-06, 5.62588092379562e-05, 0.000563525031343985, 0.00340295088676361, 0.0138928847631616, 0.0411287136809477, 0.0922619362878709, 0.1611328125, 0.222349577857836, 0.243508040593762, 0.210446653432344, 0.141016109866767, 0.0708009337500251, 0.0250594000532292, 0.00559600320762242, 0.000631904518304357, 2.11952440702502e-05, 3.07467236255651e-08, 1.48252081442448e-18, 8.1632672010422e-13, 9.47388854124834e-10, 1.09641662326735e-07, 3.68327231656546e-06, 5.62567481860491e-05, 0.000491686181146808, 0.00280745351608335, 0.0113673457986195, 0.034407621677957, 0.08056640625, 0.149054203585779, 0.220261894421426, 0.260352583593922, 0.243992466393818, 0.17730361110954, 0.09569018294355, 0.0353643797937216, 0.00759267417825228, 0.00063612802611853, 4.90581154216422e-06, 1.54859385847739e-21, 4.53321851453106e-15, 1.31411604453192e-11, 2.89158704157638e-09, 1.60762911524317e-07, 3.74407706305499e-06, 4.736189438233e-05, 0.000378217357509898, 0.00209450671547503, 0.00855451682580143, 0.02685546875, 0.0666132907188633, 0.132823272189335, 0.214728900581992, 0.281444551326725, 0.296009001081589, 0.243597508115925, 0.148991975378792, 0.0608200548312716, 0.0127279769075315, 0.000521833094160329, 9.70566989082653e-25, 1.51042980177326e-17, 1.09368036428387e-13, 4.57560134071787e-11, 4.21006835778163e-09, 1.49508603032667e-07, 2.73729357321094e-06, 3.05718407166368e-05, 0.000231555815696367, 0.00127610839495719, 0.00537109375, 0.0178619471050697, 0.0480573955329587, 0.106260134104298, 0.194787248907063, 0.296512839776918, 0.372074192785028, 0.376626574933724, 0.292314326902701, 0.152800747183368, 0.0333045543010174, 2.76497251519858e-28, 2.28755611971722e-20, 4.13737066897301e-16, 3.29107217344525e-13, 5.0115232677207e-11, 2.71371919923967e-09, 7.19102849516372e-08, 1.12325675632761e-06, 1.16360866925802e-05, 8.65280598032676e-05, 0.00048828125, 0.00217707819771306, 0.00790357547816385, 0.023901631036031, 0.0612781325323938, 0.13500797093596, 0.258323296578574, 0.432749288512411, 0.638602647743786, 0.833813449959271, 0.966168675911241, 

0.969063998048624, 0.847120594623417, 0.66414321675946, 0.465820104013263, 0.291221354612316, 0.161469850827231, 0.0788757708702185, 0.0336563378684856, 0.0124084990616811, 0.00389811212335797, 0.00102500832209875, 0.000220455835515759, 3.76260699693309e-05, 4.89351372332969e-06, 4.58677402543094e-07, 2.86224768969271e-08, 1.05679944157505e-09, 1.9164207143686e-11, 1.24022351186423e-13, 1.54187643308506e-16, 8.45980530558801e-21, 1.01819105918365e-28, 0.0304960111084845, 0.14161293927101, 0.276925157224707, 0.368514607120785, 0.380192784183748, 0.320239678526244, 0.225351402464993, 0.133701399056883, 0.0669342563485193, 0.0281210782842117, 0.00980498249793917, 0.0027886084446221, 0.000631097684105429, 0.000109768313186286, 1.39708754786739e-05, 1.21220462121203e-06, 6.44754301698568e-08, 1.77621516817823e-09, 1.89691928434031e-11, 4.47439448657014e-14, 6.12333531009866e-18, 3.91493063485141e-25, 0.000436225384589262, 0.0107606363015098, 0.0524856282149701, 0.132516057058566, 0.225611816104338, 0.288692936053042, 0.292653843982409, 0.241425068823858, 0.164117522509034, 0.0922118916264178, 0.0426327721675325, 0.0160335908287169, 0.00481151266574524, 0.00111920718480121, 0.000193427054473683, 2.33357614363932e-05, 1.78802357556149e-06, 7.48303215850606e-08, 1.31878822899848e-09, 5.90196039763408e-12, 2.01461950554766e-15, 6.84220659475085e-22, 3.74395035763428e-06, 0.000490596244422732, 0.00596856102940066, 0.0285912770441581, 0.0803287600660469, 0.156152313874052, 0.228033918921764, 0.261565238364364, 0.241441940171186, 0.181423333871863, 0.111222223786983, 0.0553127568752421, 0.0220098929680998, 0.00684691976846641, 0.00160680089631361, 0.000269537544546783, 2.97511312294433e-05, 1.89151983234106e-06, 5.50113778894856e-08, 4.67099670891234e-10, 3.97694218584386e-13, 7.17496100725099e-19, 2.14218991307717e-08, 1.49114276825135e-05, 0.000452488576057087, 0.00411251356331618, 0.0190672923820159, 0.0563079130871436, 0.118455003520458, 0.188923694499798, 0.236798645192066, 0.237962266345785, 0.193440905281509, 0.12721213880798, 0.0671217033146442, 0.0279247137035625, 0.00889847640469035, 0.00207551224525311, 0.000330021677390766, 3.18752006793804e-05, 1.52981433043676e-06, 2.46451560551713e-08, 5.23376551783659e-11, 5.01593209175786e-16, 8.57993303792751e-11, 3.1725777488314e-07, 2.40128461981918e-05, 0.000414075154727679, 0.00316814484547815, 0.0142130891198361, 0.043073028555423, 0.0955192432933815, 0.162571253476213, 0.218484730145526, 0.23550660824277, 0.204799948909091, 0.143286754900275, 0.0797223807575611, 0.0344958841848712, 0.0111874053064008, 0.00256259214802626, 0.000376004459845019, 2.97798815950014e-05, 9.10231002897932e-07, 4.82144576183173e-09, 2.45460599808001e-13, 2.45460599808001e-13, 4.82144576183173e-09, 9.10231002897923e-07, 2.97798815950016e-05, 0.00037600445984502, 0.00256259214802626, 0.0111874053064008, 0.0344958841848712, 0.0797223807575611, 0.143286754900274, 0.204799948909091, 0.23550660824277, 0.218484730145526, 0.162571253476213, 0.0955192432933815, 0.043073028555423, 0.0142130891198361, 0.00316814484547814, 0.000414075154727678, 2.4012846198192e-05, 3.1725777488314e-07, 8.57993303792751e-11, 5.01593209175786e-16, 5.23376551783659e-11, 2.4645156055171e-08, 1.52981433043676e-06, 3.18752006793806e-05, 0.000330021677390766, 0.00207551224525311, 0.00889847640469035, 0.0279247137035625, 0.0671217033146442, 0.12721213880798, 0.193440905281509, 0.237962266345785, 0.236798645192066, 0.188923694499798, 0.118455003520458, 0.0563079130871436, 0.0190672923820159, 0.00411251356331617, 0.00045248857605709, 1.49114276825135e-05, 2.14218991307717e-08, 7.17496100725099e-19, 3.97694218584386e-13, 4.67099670891228e-10, 5.5011377889486e-08, 1.89151983234107e-06, 2.97511312294433e-05, 0.000269537544546783, 0.00160680089631361, 0.00684691976846641, 0.0220098929680997, 0.0553127568752421, 0.111222223786983, 0.181423333871863, 0.241441940171186, 0.261565238364364, 0.228033918921764, 0.156152313874052, 0.0803287600660468, 0.028591277044158, 0.00596856102940069, 0.000490596244422732, 3.74395035763428e-06, 6.84220659475085e-22, 2.01461950554766e-15, 5.901960397634e-12, 1.31878822899849e-09, 7.48303215850609e-08, 1.78802357556149e-06, 2.33357614363932e-05, 0.000193427054473683, 0.00111920718480121, 0.00481151266574523, 0.0160335908287169, 0.0426327721675325, 0.0922118916264178, 0.164117522509034, 0.241425068823858, 0.292653843982409, 0.288692936053042, 0.225611816104338, 0.132516057058566, 0.0524856282149703, 0.0107606363015098, 0.000436225384589262, 3.91493063485141e-25, 6.12333531009866e-18, 4.47439448657007e-14, 1.89691928434033e-11, 1.77621516817824e-09, 6.44754301698568e-08, 1.21220462121203e-06, 1.39708754786739e-05, 0.000109768313186286, 0.000631097684105428, 0.0027886084446221, 0.00980498249793917, 0.0281210782842117, 0.0669342563485193, 0.133701399056883, 0.225351402464993, 0.320239678526244, 0.380192784183748, 0.368514607120785, 0.276925157224708, 0.14161293927101, 0.0304960111084845, 1.01819105918365e-28, 8.45980530558801e-21, 1.54187643308503e-16, 1.24022351186424e-13, 1.91642071436861e-11, 1.05679944157505e-09, 2.86224768969271e-08, 4.58677402543094e-07, 4.89351372332969e-06, 3.76260699693309e-05, 0.000220455835515759, 0.00102500832209875, 0.00389811212335797, 0.0124084990616811, 0.0336563378684856, 0.0788757708702185, 0.161469850827231, 0.291221354612316, 0.465820104013263, 0.66414321675946, 0.847120594623417, 0.969063998048624, 

0.971604604245533, 0.858934484653058, 0.687304179892866, 0.496760116838332, 0.3233135775148, 0.188696349940446, 0.0982165390983178, 0.0452729730923123, 0.018317549123027, 0.0064328086721382, 0.00193322240895345, 0.00048828125, 0.00010126626399222, 1.67280471624036e-05, 2.11319736048694e-06, 1.93056657630677e-07, 1.17812565297614e-08, 4.2676934426346e-10, 7.61700081016815e-12, 4.8667030334736e-14, 5.99175438145944e-17, 3.26547204614462e-21, 3.91557926345616e-29, 0.0280250549350645, 0.131518791336877, 0.262167281049103, 0.358848432503111, 0.384458405925433, 0.339777995330198, 0.253744202697357, 0.161821365486058, 0.0883622281700758, 0.0411905295345452, 0.0162643455884066, 0.00537109375, 0.00145644934685823, 0.000316106825925699, 5.3006134729047e-05, 6.53541706086995e-06, 5.51779397772054e-07, 2.86778662977829e-08, 7.75075402211119e-10, 8.1518444439098e-12, 1.9006837756011e-14, 2.58049826182097e-18, 1.64257225110447e-25, 0.000367435150191696, 0.00915362039394014, 0.0454553822306642, 0.117829139389268, 0.207803136260126, 0.278102132550871, 0.297978513939328, 0.262911768516829, 0.193750696140428, 0.119886818411544, 0.0621968923713716, 0.02685546875, 0.00952145461218202, 0.00271518748305321, 0.000604351399071504, 0.000100563215444572, 1.17467213912112e-05, 8.75946889693995e-07, 3.58493450783494e-08, 6.2066069052794e-10, 2.74058358510145e-12, 9.26911969897413e-16, 3.13206136838025e-22, 2.89045477147252e-06, 0.000382251534391326, 0.00472871770756655, 0.0232137663119291, 0.0673916493030245, 0.136572933843198, 0.20995441982663, 0.256292231190951, 0.254900762683212, 0.209361463296388, 0.142709218749512, 0.08056640625, 0.0373475801794569, 0.0139931993810124, 0.00413432085278463, 0.000928445135760491, 0.000150044163301374, 1.60531389385249e-05, 9.94877818762088e-07, 2.83533152834692e-08, 2.37097779757253e-10, 1.99767419955436e-13, 3.58333403308274e-19, 1.51586455125836e-08, 1.06417810116789e-05, 0.000327951939690123, 0.00304892858239749, 0.0145703107197788, 0.0447129886838163, 0.0986220064929736, 0.166559572791005, 0.223567020612202, 0.243742238968196, 0.218295162771083, 0.1611328125, 0.097663070897897, 0.0480776202107363, 0.0188550446423831, 0.00571455056938745, 0.00127770408956571, 0.000196133101075425, 1.84063218282254e-05, 8.63499708007387e-07, 1.36747899173545e-08, 2.87024898240467e-11, 2.7330845477206e-16, 5.56483966574493e-11, 2.07385046332385e-07, 1.59211729222262e-05, 0.000280315385403373, 0.00220510656240848, 0.0102470958962786, 0.0324280390044284, 0.0757707863854716, 0.137259490813191, 0.198638253121046, 0.23374064377037, 0.2255859375, 0.178770693039916, 0.115629046048252, 0.0601934162315354, 0.0246210151430611, 0.00761622040605288, 0.00167741246365232, 0.000238375882745112, 1.84085076750971e-05, 5.52092540186012e-07, 2.88677225544736e-09, 1.45920691546415e-13, 1.45920691546433e-13, 2.88677225544736e-09, 5.52092540186007e-07, 1.84085076750971e-05, 0.000238375882745112, 0.00167741246365232, 0.00761622040605289, 0.0246210151430611, 0.0601934162315354, 0.115629046048252, 0.178770693039916, 0.2255859375, 0.23374064377037, 0.198638253121046, 0.13725949081319, 0.0757707863854717, 0.0324280390044284, 0.0102470958962786, 0.00220510656240848, 0.000280315385403373, 1.59211729222263e-05, 2.07385046332385e-07, 5.56483966574433e-11, 2.733084547721e-16, 2.87024898240467e-11, 1.36747899173543e-08, 8.63499708007387e-07, 1.84063218282254e-05, 0.000196133101075425, 0.00127770408956571, 0.00571455056938744, 0.0188550446423831, 0.0480776202107363, 0.097663070897897, 0.1611328125, 0.218295162771083, 0.243742238968196, 0.223567020612202, 0.166559572791005, 0.0986220064929735, 0.0447129886838164, 0.0145703107197788, 0.00304892858239749, 0.000327951939690125, 1.06417810116789e-05, 1.51586455125823e-08, 3.58333403308335e-19, 1.99767419955436e-13, 2.3709777975725e-10, 2.83533152834692e-08, 9.94877818762088e-07, 1.60531389385249e-05, 0.000150044163301374, 0.000928445135760489, 0.00413432085278463, 0.0139931993810124, 0.0373475801794569, 0.08056640625, 0.142709218749512, 0.209361463296388, 0.254900762683212, 0.256292231190952, 0.209954419826629, 0.136572933843198, 0.0673916493030245, 0.0232137663119291, 0.00472871770756657, 0.000382251534391326, 2.89045477147233e-06, 3.13206136838085e-22, 9.26911969897413e-16, 2.74058358510141e-12, 6.2066069052794e-10, 3.58493450783494e-08, 8.75946889693992e-07, 1.17467213912113e-05, 0.000100563215444572, 0.000604351399071504, 0.00271518748305321, 0.00952145461218202, 0.02685546875, 0.0621968923713716, 0.119886818411544, 0.193750696140428, 0.262911768516829, 0.297978513939328, 0.278102132550871, 0.207803136260126, 0.117829139389268, 0.0454553822306643, 0.00915362039394014, 0.000367435150191681, 1.64257225110482e-25, 2.58049826182097e-18, 1.90068377560107e-14, 8.1518444439098e-12, 7.75075402211119e-10, 2.86778662977828e-08, 5.51779397772056e-07, 6.53541706086994e-06, 5.3006134729047e-05, 0.000316106825925699, 0.00145644934685823, 0.00537109375, 0.0162643455884066, 0.0411905295345452, 0.0883622281700758, 0.161821365486058, 0.253744202697357, 0.339777995330198, 0.384458405925433, 0.358848432503111, 0.262167281049104, 0.131518791336877, 0.0280250549350639, 3.91557926345707e-29, 3.26547204614462e-21, 5.99175438145933e-17, 4.8667030334736e-14, 7.61700081016815e-12, 4.26769344263459e-10, 1.17812565297615e-08, 1.93056657630677e-07, 2.11319736048694e-06, 1.67280471624036e-05, 0.00010126626399222, 0.00048828125, 0.00193322240895345, 0.0064328086721382, 0.018317549123027, 0.0452729730923123, 0.0982165390983178, 0.188696349940446, 0.3233135775148, 0.496760116838332, 0.687304179892866, 0.858934484653058, 0.971604604245533, 

0.973845910990539, 0.869463826812977, 0.708334312685789, 0.525631077207208, 0.354372921047049, 0.216298117443718, 0.118979133068524, 0.0586389800854099, 0.0257053044782195, 0.00993135203540935, 0.00334330649062399, 0.000966681463525941, 0.000235729535364489, 4.73589219240518e-05, 7.60271435232113e-06, 9.36253256464779e-07, 8.36311660326704e-08, 5.00458604542191e-09, 1.78276637615853e-10, 3.1377251254542e-12, 1.98234248410491e-14, 2.41978513900993e-17, 1.31099396219046e-21, 1.56684544255765e-29, 0.025840165210389, 0.122395895904866, 0.248130369409789, 0.348141121847358, 0.385521910169011, 0.355329310649401, 0.279452950875119, 0.189732211943338, 0.111661555358323, 0.0569016323227907, 0.0249745963715625, 0.00935320981912534, 0.00294796338097257, 0.000767122800822886, 0.000160560124176007, 2.60794117439929e-05, 3.12751110495589e-06, 2.57819422445047e-07, 1.31311121636257e-08, 3.48988992447038e-10, 3.62151066739638e-12, 8.35834962609184e-15, 1.12686197591033e-18, 7.14507000287423e-26, 0.000311657545597199, 0.00783176255629703, 0.0395092588862638, 0.104811016679668, 0.190640391408244, 0.265330176741812, 0.29834854130504, 0.279044232696708, 0.220476300304694, 0.148189827594562, 0.0848004357460414, 0.0411353580740843, 0.0167574328584159, 0.00564813793391046, 0.00154128884888116, 0.000330201894051644, 5.31626826763328e-05, 6.03726752609817e-06, 4.39628568681557e-07, 1.76435463128097e-08, 3.00730979068473e-10, 1.3123255401656e-12, 4.40268969185544e-16, 1.48103095787622e-22, 2.25533602289709e-06, 0.000300679222704774, 0.00377458400143799, 0.0189325796834347, 0.0565629468172468, 0.118875815610896, 0.191113069631437, 0.246238684524107, 0.261198935515754, 0.231559877346895, 0.172762285221315, 0.108547827961035, 0.0571536724947393, 0.0249515165652158, 0.00887731494183936, 0.0025084911862034, 0.000542208305805708, 8.48235532513811e-05, 8.83123726273747e-06, 5.3519406037914e-07, 1.49836568345389e-08, 1.23627156107098e-10, 1.03208788319143e-13, 1.84192963593532e-19, 1.08806191240675e-08, 7.69584065029787e-06, 0.000240407519410849, 0.0022799293739964, 0.0111881395438369, 0.0355066021530517, 0.0816141756532721, 0.144859924584227, 0.20629544254954, 0.241222031081243, 0.234643504932574, 0.190957066405629, 0.129953965591868, 0.0734847704015141, 0.0340869355902198, 0.0127044052837888, 0.00368666932121763, 0.000794513429029149, 0.000118267642500511, 1.08229444423787e-05, 4.97698358913458e-07, 7.76416788840374e-09, 1.61296158058576e-11, 1.52718157384183e-16, 3.67446402331055e-11, 1.37881739707204e-07, 1.07182785591954e-05, 0.000192190109648492, 0.00154910823157361, 0.00742374008525988, 0.0243971360843404, 0.0596538210629755, 0.114052787668809, 0.175901146010079, 0.223082844936662, 0.235151834234155, 0.206839258181086, 0.151494119677834, 0.0916204313895538, 0.0450395600956165, 0.0175468936512646, 0.00520935630845157, 0.00110868549814107, 0.000153206648862814, 1.15721122981084e-05, 3.41329635237813e-07, 1.76453146284464e-09, 8.86352257863742e-14, 8.86352257863864e-14, 1.76453146284464e-09, 3.41329635237816e-07, 1.15721122981084e-05, 0.000153206648862814, 0.00110868549814108, 0.00520935630845157, 0.0175468936512646, 0.0450395600956165, 0.0916204313895539, 0.151494119677834, 0.206839258181086, 0.235151834234155, 0.223082844936662, 0.175901146010079, 0.114052787668809, 0.0596538210629755, 0.0243971360843404, 0.00742374008525986, 0.0015491082315736, 0.000192190109648492, 1.07182785591953e-05, 1.37881739707204e-07, 3.67446402331013e-11, 1.52718157384208e-16, 1.61296158058576e-11, 7.76416788840384e-09, 4.97698358913458e-07, 1.08229444423787e-05, 0.000118267642500511, 0.000794513429029149, 0.00368666932121764, 0.0127044052837888, 0.0340869355902198, 0.0734847704015141, 0.129953965591867, 0.190957066405629, 0.234643504932574, 0.241222031081243, 0.20629544254954, 0.144859924584227, 0.0816141756532721, 0.0355066021530517, 0.0111881395438369, 0.0022799293739964, 0.000240407519410848, 7.69584065029787e-06, 1.08806191240665e-08, 1.84192963593566e-19, 1.03208788319143e-13, 1.236271561071e-10, 1.49836568345389e-08, 5.3519406037914e-07, 8.8312372627375e-06, 8.48235532513811e-05, 0.000542208305805709, 0.0025084911862034, 0.00887731494183936, 0.0249515165652158, 0.0571536724947393, 0.108547827961035, 0.172762285221315, 0.231559877346895, 0.261198935515754, 0.246238684524107, 0.191113069631437, 0.118875815610895, 0.0565629468172468, 0.0189325796834347, 0.00377458400143797, 0.000300679222704774, 2.25533602289693e-06, 1.48103095787653e-22, 4.40268969185544e-16, 1.31232554016562e-12, 3.00730979068473e-10, 1.76435463128097e-08, 4.39628568681559e-07, 6.03726752609817e-06, 5.31626826763329e-05, 0.000330201894051644, 0.00154128884888116, 0.00564813793391046, 0.0167574328584159, 0.0411353580740843, 0.0848004357460414, 0.148189827594562, 0.220476300304694, 0.279044232696708, 0.29834854130504, 0.265330176741812, 0.190640391408244, 0.104811016679668, 0.0395092588862636, 0.00783176255629703, 0.000311657545597185, 7.14507000287587e-26, 1.12686197591033e-18, 8.35834962609199e-15, 3.62151066739638e-12, 3.48988992447038e-10, 1.31311121636258e-08, 2.57819422445047e-07, 3.1275111049559e-06, 2.60794117439929e-05, 0.000160560124176007, 0.000767122800822886, 0.00294796338097257, 0.00935320981912534, 0.0249745963715625, 0.0569016323227907, 0.111661555358323, 0.189732211943338, 0.279452950875119, 0.355329310649401, 0.385521910169011, 0.348141121847358, 0.248130369409789, 0.122395895904867, 0.0258401652103884, 1.56684544255805e-29, 1.31099396219046e-21, 2.41978513900997e-17, 1.98234248410491e-14, 3.1377251254542e-12, 1.78276637615854e-10, 5.00458604542191e-09, 8.36311660326706e-08, 9.36253256464779e-07, 7.60271435232113e-06, 4.73589219240518e-05, 0.000235729535364489, 0.000966681463525941, 0.00334330649062399, 0.00993135203540935, 0.0257053044782195, 0.0586389800854099, 0.118979133068524, 0.216298117443718, 0.354372921047049, 0.525631077207208, 0.708334312685789, 0.869463826812977, 0.973845910990539, 

0.000244140625, 0.0029296875, 0.01611328125, 0.0537109375, 0.120849609375, 0.193359375, 0.2255859375, 0.193359375, 0.120849609375, 0.0537109375, 0.01611328125, 0.0029296875, 0.000244140625, 

0.0579132293789379, 7.93244761040481e-09, 0.186213636517977, 3.55251570124909e-07, 0.2744268643856, 7.29199300046128e-06, 0.245108188978423, 9.07136278871939e-05, 0.147772217913803, 0.000761732703481285, 0.0633527143260148, 0.00454852024188633, 0.0198045267489712, 0.0198045267489712, 0.00454852024188633, 0.0633527143260148, 0.000761732703481285, 0.147772217913803, 9.07136278871938e-05, 0.245108188978423, 7.29199300046128e-06, 0.2744268643856, 3.55251570124909e-07, 0.186213636517977, 7.93244761040481e-09, 0.0579132293789379, 

0.2381419999958, 0.000244140625, 4.19917528204876e-12, 0.362975999603279, 0.0029296875, 3.96720444760508e-10, 0.253571982821446, 0.01611328125, 1.71785540008471e-08, 0.107359549178435, 0.0537109375, 4.50821565201979e-07, 0.0306820140509815, 0.120849609375, 7.98594901862925e-06, 0.00623540281019632, 0.193359375, 0.000100597189803727, 0.000924000000000009, 0.2255859375, 0.000924000000000009, 0.000100597189803727, 0.193359375, 0.00623540281019632, 7.98594901862924e-06, 0.120849609375, 0.0306820140509815, 4.50821565201979e-07, 0.0537109375, 0.107359549178435, 1.71785540008471e-08, 0.01611328125, 0.253571982821446, 3.96720444760508e-10, 0.0029296875, 0.362975999603279, 4.19917528204876e-12, 0.000244140625, 0.2381419999958, 

0.421675376949324, 0.00818132992300697, 1.66846446406411e-06, 1.2551753747439e-14, 0.377546111727832, 0.0483573960726327, 4.06481189428379e-05, 2.01871561457488e-12, 0.154932741412802, 0.131003636461783, 0.000453884537273641, 1.48808355654945e-10, 0.0385329682613798, 0.215089817471783, 0.00307161216109281, 6.6480694691135e-09, 0.0064688264075609, 0.238374680352024, 0.0140310813280195, 2.00478384048766e-07, 0.000772246579912095, 0.187861532537298, 0.0455778012259822, 4.29909479750649e-06, 6.72222890967225e-05, 0.107954911345698, 0.107954911345698, 6.72222890967229e-05, 4.29909479750647e-06, 0.0455778012259822, 0.187861532537298, 0.000772246579912098, 2.00478384048765e-07, 0.0140310813280195, 0.238374680352024, 0.00646882640756092, 6.64806946911345e-09, 0.00307161216109281, 0.215089817471783, 0.0385329682613799, 1.48808355654944e-10, 0.000453884537273641, 0.131003636461783, 0.154932741412803, 2.01871561457486e-12, 4.06481189428379e-05, 0.0483573960726327, 0.377546111727833, 1.25517537474389e-14, 1.66846446406411e-06, 0.00818132992300697, 0.421675376949324, 

0.561832079910847, 0.0429245843703944, 0.000244140625, 2.28058925324772e-08, 1.1355172946616e-16, 0.331833362352312, 0.154525121101316, 0.0029296875, 9.12255670594352e-07, 2.7684885450736e-14, 0.0898286774183675, 0.254960868596377, 0.01611328125, 1.67250534059905e-05, 3.09366406037311e-12, 0.0147375746880575, 0.254955287497755, 0.0537109375, 0.000185837994730729, 2.09517174676303e-10, 0.00163207760485319, 0.17209105190188, 0.120849609375, 0.0013938154711296, 9.57789074659783e-09, 0.000128526611088561, 0.0826018967161144, 0.193359375, 0.00743384523971537, 3.11356253724867e-07, 7.38026769028941e-06, 0.0289100309956177, 0.2255859375, 0.0289100309956177, 7.38026769028946e-06, 3.11356253724865e-07, 0.00743384523971537, 0.193359375, 0.0826018967161144, 0.000128526611088562, 9.57789074659774e-09, 0.0013938154711296, 0.120849609375, 0.17209105190188, 0.0016320776048532, 2.09517174676301e-10, 0.000185837994730729, 0.0537109375, 0.254955287497755, 0.0147375746880576, 3.09366406037307e-12, 1.67250534059905e-05, 0.01611328125, 0.254960868596377, 0.0898286774183677, 2.76848854507356e-14, 9.12255670594353e-07, 0.0029296875, 0.154525121101316, 0.331833362352312, 1.13551729466159e-16, 2.28058925324772e-08, 0.000244140625, 0.0429245843703944, 0.561832079910847, 

0.662204105405035, 0.107828252890832, 0.00318341814132717, 9.26537918858577e-06, 5.5823425701271e-10, 2.1960313678622e-18, 0.27769006200199, 0.263888708436918, 0.0234822149314105, 0.000180875738703429, 3.28466238632977e-08, 7.54106289131827e-16, 0.0533716033167337, 0.295999167777284, 0.0793900132087502, 0.00161837395805111, 8.85821942304254e-07, 1.1868833288569e-13, 0.00621693343369831, 0.201222355379015, 0.162670478957266, 0.00877593707843962, 1.44783204975766e-05, 1.13213848178723e-11, 0.000488816613499963, 0.0923348694208237, 0.224985945547836, 0.0321226889956864, 0.000159732655326367, 7.28945145471973e-10, 2.73308515410835e-05, 0.0301295548329948, 0.221278642237401, 0.0836118340181624, 0.0012531605103725, 3.33754867486345e-08, 1.11426162894336e-06, 0.0071688005491365, 0.158690311807777, 0.158690311807777, 0.00716880054913648, 1.11426162894336e-06, 3.33754867486345e-08, 0.0012531605103725, 0.0836118340181624, 0.221278642237401, 0.0301295548329948, 2.73308515410835e-05, 7.28945145471973e-10, 0.000159732655326368, 0.0321226889956864, 0.224985945547836, 0.0923348694208236, 0.000488816613499963, 1.13213848178723e-11, 1.44783204975766e-05, 0.00877593707843962, 0.162670478957266, 0.201222355379014, 0.00621693343369831, 1.1868833288569e-13, 8.85821942304257e-07, 0.00161837395805111, 0.0793900132087502, 0.295999167777284, 0.0533716033167337, 7.54106289131827e-16, 3.28466238632978e-08, 0.000180875738703429, 0.0234822149314105, 0.263888708436918, 0.27769006200199, 2.1960313678622e-18, 5.58234257012713e-10, 9.26537918858577e-06, 0.00318341814132717, 0.107828252890832, 0.662204105405035, 

0.733957082984539, 0.190026916530522, 0.0145509014973105, 0.000244140625, 4.72536977020843e-07, 2.17039040406951e-11, 7.3695887030193e-20, 0.229967410017886, 0.338433435307855, 0.0737960820335275, 0.0029296875, 1.34169835260554e-05, 1.75485893679429e-09, 3.3869603656684e-17, 0.03302504101058, 0.276256717223765, 0.17153713514349, 0.01611328125, 0.000174604494164584, 6.50321341285703e-08, 7.13441588521059e-15, 0.00287432910777849, 0.136668518602983, 0.241656819895795, 0.0537109375, 0.00137712069560675, 1.46059515811259e-06, 9.10799503547123e-13, 0.000168862569363464, 0.0456381361918279, 0.229796670694522, 0.120849609375, 0.00733149199885157, 2.21429500204757e-05, 7.84857696244476e-11, 7.05452469011272e-06, 0.0108373918772131, 0.155391004144899, 0.193359375, 0.0277555724817305, 0.000238714372354775, 4.80946226805621e-09, 2.14896295757603e-07, 0.00187649953960272, 0.0766187073996, 0.2255859375, 0.0766187073996, 0.00187649953960272, 2.14896295757606e-07, 4.80946226805613e-09, 0.000238714372354775, 0.0277555724817305, 0.193359375, 0.155391004144899, 0.0108373918772131, 7.05452469011279e-06, 7.84857696244462e-11, 2.21429500204757e-05, 0.00733149199885157, 0.120849609375, 0.229796670694522, 0.0456381361918279, 0.000168862569363466, 9.10799503547105e-13, 1.46059515811259e-06, 0.00137712069560675, 0.0537109375, 0.241656819895795, 0.136668518602983, 0.00287432910777851, 7.13441588521043e-15, 6.50321341285703e-08, 0.000174604494164584, 0.01611328125, 0.17153713514349, 0.276256717223765, 0.0330250410105801, 3.38696036566831e-17, 1.75485893679429e-09, 1.34169835260554e-05, 0.0029296875, 0.0737960820335275, 0.338433435307855, 0.229967410017887, 7.36958870301911e-20, 2.17039040406951e-11, 4.72536977020843e-07, 0.000244140625, 0.0145509014973105, 0.190026916530522, 0.733957082984539, 

0.786110440091379, 0.276216506838666, 0.038787993656943, 0.00184234682378424, 2.14551456090738e-05, 3.17774230746812e-08, 1.21940470439282e-12, 3.75368245124059e-21, 0.19109352597838, 0.375121878465898, 0.144765033544714, 0.0152545467789033, 0.000373135044344779, 1.22606870902605e-06, 1.29296745184891e-10, 2.22360484793206e-18, 0.0212906944481328, 0.233494472394336, 0.247634687282456, 0.0578906827486273, 0.00297428140395272, 2.16816527687491e-05, 6.28360334373979e-09, 6.03724969010555e-16, 0.00143763863798022, 0.088083967676131, 0.256729240957205, 0.133147829088155, 0.0143685891873001, 0.000232373188324244, 1.85074245529547e-07, 9.93428738421494e-14, 6.55259639112686e-05, 0.0224295678837945, 0.179656513886995, 0.206710853900466, 0.046854356012629, 0.00168106080190609, 3.67948456913785e-06, 1.10341294225238e-11, 2.12380463750629e-06, 0.00406146214023419, 0.0894021708174356, 0.228207512275368, 0.108648386900247, 0.00864805197217513, 5.2019413192215e-05, 8.71519065889538e-10, 5.01929265315222e-08, 0.000536254214814611, 0.032439934392945, 0.183706024690614, 0.183706024690613, 0.032439934392945, 0.000536254214814611, 5.01929265315222e-08, 8.71519065889539e-10, 5.2019413192215e-05, 0.00864805197217513, 0.108648386900247, 0.228207512275368, 0.0894021708174356, 0.00406146214023419, 2.12380463750629e-06, 1.10341294225238e-11, 3.67948456913785e-06, 0.00168106080190609, 0.0468543560126291, 0.206710853900466, 0.179656513886995, 0.0224295678837945, 6.55259639112686e-05, 9.93428738421494e-14, 1.85074245529547e-07, 0.000232373188324244, 0.0143685891873001, 0.133147829088155, 0.256729240957205, 0.088083967676131, 0.00143763863798022, 6.03724969010555e-16, 6.28360334373979e-09, 2.16816527687491e-05, 0.00297428140395273, 0.0578906827486273, 0.247634687282456, 0.233494472394336, 0.0212906944481328, 2.22360484793206e-18, 1.29296745184891e-10, 1.22606870902605e-06, 0.00037313504434478, 0.0152545467789033, 0.144765033544714, 0.375121878465898, 0.19109352597838, 3.75368245124059e-21, 1.21940470439282e-12, 3.17774230746812e-08, 2.14551456090738e-05, 0.00184234682378424, 0.038787993656943, 0.276216506838666, 0.786110440091379, 

0.824831997510693, 0.358261774463816, 0.07593681989392, 0.00710057148394215, 0.000244140625, 2.21333067157877e-06, 2.72375056637647e-09, 9.2209914060134e-14, 2.65019334057822e-22, 0.160123872355578, 0.383939811552936, 0.218370128185911, 0.0434797761880113, 0.0029296875, 5.20492886619121e-05, 1.36392032827438e-07, 1.23901748331431e-11, 1.96584587796125e-19, 0.0142471537805463, 0.18858505188875, 0.287816372904916, 0.122028912027149, 0.01611328125, 0.000561002424516941, 3.1303443514751e-06, 7.63060012565969e-10, 6.68348253502562e-17, 0.000768274105202087, 0.0561393577148619, 0.229907859707326, 0.207565052858614, 0.0537109375, 0.00366463507146181, 4.35422916492569e-05, 2.8481051029174e-08, 1.37712139198111e-14, 2.79645639490999e-05, 0.0112805788731606, 0.123964094918079, 0.238313970479918, 0.120849609375, 0.0161584798809423, 0.000408821966756944, 7.17558149684844e-07, 1.91533790933321e-12, 7.23831322706337e-07, 0.00161188033833688, 0.0475308382864017, 0.1945728475964, 0.193359375, 0.0506649635598553, 0.00272957246520414, 1.28556978110386e-05, 1.89433179650916e-10, 1.36613463023803e-08, 0.000167942655583806, 0.0132886799197005, 0.115835525809854, 0.2255859375, 0.115835525809854, 0.0132886799197005, 0.000167942655583806, 1.36613463023806e-08, 1.89433179650912e-10, 1.28556978110386e-05, 0.00272957246520414, 0.0506649635598553, 0.193359375, 0.1945728475964, 0.0475308382864018, 0.00161188033833688, 7.2383132270635e-07, 1.91533790933316e-12, 7.17558149684844e-07, 0.000408821966756943, 0.0161584798809423, 0.120849609375, 0.238313970479918, 0.123964094918079, 0.0112805788731606, 2.79645639491002e-05, 1.37712139198107e-14, 2.8481051029174e-08, 4.35422916492568e-05, 0.00366463507146181, 0.0537109375, 0.207565052858614, 0.229907859707326, 0.0561393577148619, 0.000768274105202095, 6.68348253502539e-17, 7.63060012565969e-10, 3.13034435147509e-06, 0.000561002424516941, 0.01611328125, 0.122028912027149, 0.287816372904916, 0.18858505188875, 0.0142471537805464, 1.96584587796118e-19, 1.23901748331431e-11, 1.36392032827437e-07, 5.20492886619121e-05, 0.0029296875, 0.0434797761880113, 0.218370128185912, 0.383939811552936, 0.160123872355578, 2.6501933405781e-22, 9.2209914060134e-14, 2.72375056637647e-09, 2.21333067157877e-06, 0.000244140625, 0.00710057148394215, 0.07593681989392, 0.358261774463816, 0.824831997510693, 

0.854198989342353, 0.432477137545819, 0.122890845042486, 0.0183667412475573, 0.00129095291603943, 3.52828993464022e-05, 2.67301415415996e-07, 2.87770802452941e-10, 8.89607621455251e-15, 2.43232941151254e-23, 0.135501960079999, 0.375474699466224, 0.281510572343625, 0.0871219223529665, 0.0114765883445349, 0.000571510687840654, 8.11462413961914e-06, 1.80898114726268e-08, 1.4755144349979e-12, 2.2079963908437e-20, 0.00985175368779472, 0.149409993297764, 0.295563861792762, 0.189410580456907, 0.0467623845380691, 0.00424293023442086, 0.000112905994947212, 5.21198067985548e-07, 1.12168231762968e-10, 9.18662038331437e-18, 0.000434107779327372, 0.036032522788422, 0.188071942735051, 0.24957269926379, 0.115477280964829, 0.0190907715576844, 0.000952097997145654, 9.10096846111653e-06, 5.16787904648562e-09, 2.31648364120079e-15, 1.29117576200223e-05, 0.00586561381968396, 0.0807793700318224, 0.221969697498446, 0.192486476508004, 0.0579808854986442, 0.00541938585900593, 0.000107269484697055, 1.60715802130952e-07, 3.94281570298222e-13, 2.73093036075488e-07, 0.000678999926987642, 0.0246725693123347, 0.140387282929993, 0.228160973218627, 0.125222875167218, 0.0219359254021461, 0.000899088088342055, 3.55420345265727e-06, 4.77222797248939e-11, 4.21175105662464e-09, 5.7312954313678e-05, 0.00549484062476939, 0.0647423790715412, 0.197201087464742, 0.197201087464742, 0.0647423790715412, 0.00549484062476939, 5.73129543136777e-05, 4.21175105662464e-09, 4.77222797248939e-11, 3.55420345265729e-06, 0.000899088088342055, 0.0219359254021461, 0.125222875167218, 0.228160973218627, 0.140387282929993, 0.0246725693123347, 0.000678999926987639, 2.73093036075488e-07, 3.94281570298222e-13, 1.60715802130953e-07, 0.000107269484697055, 0.00541938585900593, 0.0579808854986442, 0.192486476508004, 0.221969697498446, 0.0807793700318224, 0.00586561381968394, 1.29117576200223e-05, 2.31648364120079e-15, 5.16787904648566e-09, 9.10096846111654e-06, 0.000952097997145654, 0.0190907715576844, 0.115477280964829, 0.24957269926379, 0.188071942735051, 0.0360325227884219, 0.000434107779327372, 9.18662038331437e-18, 1.12168231762969e-10, 5.21198067985548e-07, 0.000112905994947212, 0.00424293023442086, 0.0467623845380691, 0.189410580456907, 0.295563861792762, 0.149409993297764, 0.00985175368779472, 2.2079963908437e-20, 1.47551443499791e-12, 1.80898114726268e-08, 8.11462413961914e-06, 0.000571510687840654, 0.0114765883445349, 0.0871219223529665, 0.281510572343625, 0.375474699466224, 0.135501960079999, 2.43232941151254e-23, 8.89607621455259e-15, 2.87770802452941e-10, 2.67301415415996e-07, 3.52828993464022e-05, 0.00129095291603943, 0.0183667412475573, 0.122890845042486, 0.432477137545819, 0.854198989342353, 

0.876915852631853, 0.497823896515899, 0.175651223103151, 0.0368691510322005, 0.00427966401208136, 0.000244140625, 5.63345465521764e-06, 3.7354190105842e-08, 3.63974021902337e-11, 1.05121969039768e-15, 2.76861404600999e-24, 0.115810483643577, 0.357526687155361, 0.328751208819649, 0.140061056861505, 0.0295486752366845, 0.0029296875, 0.00011749217811038, 1.41594881752598e-06, 2.80037827360167e-09, 2.1077701712445e-13, 3.01880427172882e-21, 0.00701002025529626, 0.117685412297387, 0.282010307438914, 0.243867038453903, 0.0935077911836918, 0.01611328125, 0.00112311583493808, 2.4600120193897e-05, 9.87516714070708e-08, 1.93702160488218e-11, 1.50865152917635e-18, 0.000257161959433865, 0.0234775545014071, 0.146615086660333, 0.257338559196576, 0.179338543217065, 0.0537109375, 0.00650663135546044, 0.00025902576123952, 2.11051413966339e-06, 1.0788516523343e-09, 4.56939786592589e-16, 6.3679251850496e-06, 0.00316145390800213, 0.0514512717153947, 0.183299127945797, 0.23216847555008, 0.120849609375, 0.0254443655215507, 0.00184099437353936, 3.04463930829743e-05, 4.05595165922423e-08, 9.34184774018416e-14, 1.12131244713825e-07, 0.000302731990230009, 0.0128395862914552, 0.0928439046850065, 0.213732382257395, 0.193359375, 0.0707562022176403, 0.00930463686099246, 0.000312335176206523, 1.0843295017414e-06, 1.35813849554319e-11, 1.4397336018969e-09, 2.11376442620986e-05, 0.00233632229922767, 0.0342904514060396, 0.143471027980647, 0.2255859375, 0.143471027980647, 0.0342904514060395, 0.00233632229922767, 2.11376442620986e-05, 1.43973360189695e-09, 1.35813849554314e-11, 1.0843295017414e-06, 0.000312335176206524, 0.00930463686099248, 0.0707562022176402, 0.193359375, 0.213732382257395, 0.0928439046850064, 0.0128395862914552, 0.000302731990230009, 1.12131244713828e-07, 9.34184774018378e-14, 4.05595165922423e-08, 3.04463930829744e-05, 0.00184099437353936, 0.0254443655215507, 0.120849609375, 0.23216847555008, 0.183299127945797, 0.0514512717153946, 0.00316145390800213, 6.36792518504973e-06, 4.56939786592568e-16, 1.0788516523343e-09, 2.1105141396634e-06, 0.000259025761239521, 0.00650663135546043, 0.0537109375, 0.179338543217065, 0.257338559196576, 0.146615086660333, 0.0234775545014071, 0.000257161959433869, 1.50865152917627e-18, 1.93702160488218e-11, 9.87516714070712e-08, 2.4600120193897e-05, 0.00112311583493808, 0.01611328125, 0.0935077911836918, 0.243867038453903, 0.282010307438913, 0.117685412297387, 0.00701002025529633, 3.01880427172865e-21, 2.1077701712445e-13, 2.80037827360168e-09, 1.41594881752598e-06, 0.00011749217811038, 0.0029296875, 0.0295486752366845, 0.140061056861504, 0.328751208819648, 0.357526687155361, 0.115810483643578, 2.76861404600982e-24, 1.05121969039768e-15, 3.63974021902339e-11, 3.73541901058421e-08, 5.63345465521763e-06, 0.000244140625, 0.00427966401208136, 0.0368691510322005, 0.175651223103151, 0.497823896515899, 0.876915852631853, 

0.894805085081134, 0.554580147613495, 0.230692076052367, 0.0624607501075975, 0.0104720392078571, 0.00100589226418861, 4.90169531888776e-05, 9.94567542361742e-07, 5.9569910653299e-09, 5.37748128850508e-12, 1.47409503543007e-16, 3.7721747008999e-25, 0.0999190514176459, 0.335113812583207, 0.359895245483218, 0.194867802470844, 0.0580781477833664, 0.00938387652580949, 0.00075662029869312, 2.58235102223737e-05, 2.74951788275963e-07, 4.96361362547539e-10, 3.51285291376847e-14, 4.86445769956573e-22, 0.00511386907184494, 0.0928114979217812, 0.257336259896117, 0.278647033082385, 0.147630366815174, 0.0401231059417248, 0.00535292437162334, 0.000307310722576154, 5.81657847839156e-06, 2.09989931401815e-08, 3.83685945921971e-12, 2.87513676303454e-19, 0.000158623293513274, 0.0155785592708528, 0.111517215227462, 0.241482028083622, 0.227433636770445, 0.103973547055765, 0.0229519866396072, 0.00221644116325216, 7.45752454152917e-05, 5.3841237230168e-07, 2.53984885775243e-10, 1.0299084946728e-16, 3.32114696363289e-06, 0.00176504821291652, 0.0326202000275752, 0.141259927437818, 0.236503442137942, 0.181867437918804, 0.0664283140465595, 0.0107904230856615, 0.000645394950545737, 9.3182715704905e-06, 1.13486349837225e-08, 2.49024768734401e-14, 4.94477676025133e-08, 0.00014220776770054, 0.00678529584979238, 0.0587611934205705, 0.174887069476165, 0.226216616133275, 0.13671735333941, 0.0373558139912256, 0.0039718597045772, 0.000114681445957573, 3.60592630386128e-07, 4.28177572073969e-12, 5.36824207919342e-10, 8.35443092318109e-06, 0.00102914783283578, 0.0178233380093672, 0.0942984907685703, 0.205173308511351, 0.205173308511351, 0.0942984907685704, 0.0178233380093672, 0.00102914783283579, 8.35443092318115e-06, 5.36824207919322e-10, 4.28177572073987e-12, 3.60592630386125e-07, 0.000114681445957572, 0.0039718597045772, 0.0373558139912255, 0.13671735333941, 0.226216616133275, 0.174887069476165, 0.0587611934205706, 0.00678529584979239, 0.000142207767700541, 4.94477676025118e-08, 2.49024768734413e-14, 1.13486349837224e-08, 9.31827157049046e-06, 0.000645394950545735, 0.0107904230856615, 0.0664283140465595, 0.181867437918804, 0.236503442137942, 0.141259927437818, 0.0326202000275752, 0.00176504821291653, 3.32114696363281e-06, 1.02990849467285e-16, 2.5398488577524e-10, 5.38412372301678e-07, 7.45752454152915e-05, 0.00221644116325216, 0.0229519866396072, 0.103973547055765, 0.227433636770445, 0.241482028083622, 0.111517215227462, 0.0155785592708529, 0.000158623293513272, 2.87513676303471e-19, 3.83685945921967e-12, 2.09989931401814e-08, 5.81657847839154e-06, 0.000307310722576154, 0.00535292437162334, 0.0401231059417248, 0.147630366815174, 0.278647033082385, 0.257336259896118, 0.0928114979217814, 0.00511386907184487, 4.86445769956605e-22, 3.51285291376843e-14, 4.96361362547536e-10, 2.74951788275962e-07, 2.58235102223737e-05, 0.00075662029869312, 0.00938387652580949, 0.0580781477833664, 0.194867802470844, 0.359895245483218, 0.335113812583208, 0.0999190514176453, 3.77217470090018e-25, 1.47409503543005e-16, 5.37748128850505e-12, 5.95699106532988e-09, 9.9456754236174e-07, 4.90169531888776e-05, 0.00100589226418861, 0.0104720392078571, 0.0624607501075975, 0.230692076052367, 0.554580147613495, 0.894805085081134, 

0.90911932240828, 0.603575987847105, 0.285415235581208, 0.0940213610700072, 0.020827443524768, 0.00294064718243016, 0.000244140625, 1.05299387433706e-05, 1.93310192697036e-07, 1.06942031544982e-09, 9.09317485988542e-13, 2.39258753273723e-17, 5.98565109735912e-26, 0.0869647014227455, 0.311236978145123, 0.377220191136586, 0.245697801941689, 0.0951594910480808, 0.022069343322947, 0.0029296875, 0.000202042087573618, 6.09257803989342e-06, 5.89299652095607e-08, 9.90741274286889e-11, 6.68145567005611e-15, 9.01055970102784e-23, 0.00381282239207078, 0.0735583314879919, 0.228504182018779, 0.294277767090925, 0.199273568995984, 0.0759132078954417, 0.01611328125, 0.0017768030581092, 8.80093657585083e-05, 1.48835106598275e-06, 4.94750695104845e-09, 8.55176564181921e-13, 6.21689571204773e-20, 0.000101313238211077, 0.0105363115786799, 0.0838898524665751, 0.213613988328769, 0.25290845202018, 0.158256418462415, 0.0537109375, 0.00947006139712251, 0.000770500167580688, 2.27819364874749e-05, 1.49736826941149e-07, 6.63371097593834e-11, 2.59962947023541e-17, 1.81714502995425e-06, 0.00101870658455969, 0.0207887550116813, 0.104666017113847, 0.216661008593466, 0.222694296661213, 0.120849609375, 0.034069838048611, 0.00455323805153682, 0.000235385476812375, 3.05896572877282e-06, 3.47345017741545e-09, 7.33758413279874e-15, 2.31766386181561e-08, 7.00401529945585e-05, 0.00366340552821999, 0.0364686067792834, 0.131988362906533, 0.222840600914569, 0.193359375, 0.0871615225931575, 0.0191339854880646, 0.00172944260973193, 4.44383639498528e-05, 1.29331128272935e-07, 1.47276074765017e-12, 2.15545080187253e-10, 3.51133176914627e-06, 0.00047072614295446, 0.00926529930199674, 0.0586296539498153, 0.162594688437667, 0.2255859375, 0.162594688437667, 0.0586296539498153, 0.00926529930199672, 0.000470726142954461, 3.51133176914624e-06, 2.15545080187244e-10, 1.47276074765024e-12, 1.29331128272936e-07, 4.44383639498527e-05, 0.00172944260973193, 0.0191339854880646, 0.0871615225931575, 0.193359375, 0.222840600914569, 0.131988362906533, 0.0364686067792833, 0.00366340552822, 7.0040152994558e-05, 2.31766386181553e-08, 7.33758413279915e-15, 3.47345017741548e-09, 3.0589657287728e-06, 0.000235385476812376, 0.00455323805153682, 0.034069838048611, 0.120849609375, 0.222694296661213, 0.216661008593466, 0.104666017113847, 0.0207887550116813, 0.00101870658455969, 1.8171450299542e-06, 2.59962947023557e-17, 6.63371097593842e-11, 1.49736826941149e-07, 2.2781936487475e-05, 0.000770500167580688, 0.00947006139712251, 0.0537109375, 0.158256418462415, 0.25290845202018, 0.213613988328769, 0.0838898524665752, 0.0105363115786799, 0.000101313238211074, 6.21689571204816e-20, 8.55176564181932e-13, 4.94750695104842e-09, 1.48835106598275e-06, 8.80093657585084e-05, 0.0017768030581092, 0.01611328125, 0.0759132078954417, 0.199273568995984, 0.294277767090925, 0.228504182018779, 0.0735583314879917, 0.00381282239207072, 9.01055970102854e-23, 6.6814556700562e-15, 9.90741274286883e-11, 5.89299652095609e-08, 6.09257803989342e-06, 0.000202042087573618, 0.0029296875, 0.022069343322947, 0.0951594910480808, 0.245697801941689, 0.377220191136586, 0.311236978145123, 0.0869647014227449, 5.98565109735962e-26, 2.39258753273727e-17, 9.09317485988536e-13, 1.06942031544983e-09, 1.93310192697036e-07, 1.05299387433706e-05, 0.000244140625, 0.00294064718243016, 0.020827443524768, 0.0940213610700072, 0.285415235581208, 0.603575987847105, 0.90911932240828, 

0.920737181470952, 0.645802614054716, 0.338124656815603, 0.129994750668804, 0.035764064884341, 0.00677675154328227, 0.000836326049776105, 6.1900941610224e-05, 2.42407130653098e-06, 4.11025272080868e-08, 2.13448386253154e-10, 1.7303152999683e-13, 4.40612314892168e-18, 1.08253627069562e-26, 0.0762972980943717, 0.28759242801536, 0.383717955268606, 0.289104143723578, 0.137297698656726, 0.0419755564122556, 0.00807855475653259, 0.000922787491199586, 5.63550688428276e-05, 1.5417524027582e-06, 1.38205990158899e-08, 2.19559614787384e-11, 1.42475921517198e-15, 1.88118484434666e-23, 0.00289777111708903, 0.0586997889247463, 0.199585434999543, 0.294689227952614, 0.241580060053934, 0.119166121195853, 0.0357662300033102, 0.00630503621956185, 0.000600484804444421, 2.65058774581193e-05, 4.10149608378516e-07, 1.2769124335103e-09, 2.11158107693618e-13, 1.49831086720314e-20, 6.6701416351512e-05, 0.00726125498439176, 0.0629160753747836, 0.182049823109272, 0.25761726652176, 0.205033677383734, 0.0959685013577582, 0.0261089573277321, 0.00387781525540246, 0.000276175909866826, 7.37689821963274e-06, 4.50075971099151e-08, 1.89666270240054e-11, 7.23250001922512e-18, 1.03635800254052e-06, 0.000606304244309391, 0.0133874596855617, 0.0759136781787164, 0.185435390639631, 0.238123014299286, 0.17381531251969, 0.0729785523154979, 0.016903474416872, 0.00194237542164441, 8.95589626468798e-05, 1.07081466786788e-06, 1.14994274954879e-09, 2.35656124035003e-15, 1.14504358816774e-08, 3.60003724444886e-05, 0.00202568630759399, 0.022510610429884, 0.094917817523141, 0.19665953431005, 0.223864288350229, 0.145056910715282, 0.0523965040070831, 0.00971444556427678, 0.000773182084124437, 1.8116748702009e-05, 4.95792324745715e-08, 5.46017398847074e-13, 9.2248866836334e-11, 1.55865567873967e-06, 0.000223497678300473, 0.00486722380848403, 0.0354266160922896, 0.118428287231588, 0.21023664195182, 0.21023664195182, 0.118428287231588, 0.0354266160922896, 0.00486722380848404, 0.000223497678300473, 1.55865567873966e-06, 9.2248866836334e-11, 5.46017398847074e-13, 4.95792324745721e-08, 1.8116748702009e-05, 0.000773182084124435, 0.00971444556427677, 0.0523965040070831, 0.145056910715282, 0.223864288350229, 0.19665953431005, 0.0949178175231411, 0.022510610429884, 0.00202568630759399, 3.60003724444883e-05, 1.14504358816774e-08, 2.35656124035003e-15, 1.1499427495488e-09, 1.07081466786788e-06, 8.95589626468796e-05, 0.00194237542164441, 0.016903474416872, 0.0729785523154979, 0.17381531251969, 0.238123014299286, 0.185435390639632, 0.0759136781787165, 0.0133874596855617, 0.000606304244309388, 1.03635800254052e-06, 7.23250001922512e-18, 1.89666270240056e-11, 4.50075971099151e-08, 7.37689821963271e-06, 0.000276175909866826, 0.00387781525540246, 0.0261089573277321, 0.0959685013577583, 0.205033677383734, 0.25761726652176, 0.182049823109272, 0.0629160753747836, 0.00726125498439173, 6.6701416351512e-05, 1.49831086720314e-20, 2.11158107693622e-13, 1.2769124335103e-09, 4.10149608378515e-07, 2.65058774581192e-05, 0.000600484804444421, 0.00630503621956184, 0.0357662300033102, 0.119166121195853, 0.241580060053934, 0.294689227952614, 0.199585434999543, 0.0586997889247461, 0.00289777111708903, 1.88118484434666e-23, 1.42475921517201e-15, 2.19559614787384e-11, 1.38205990158898e-08, 1.54175240275819e-06, 5.63550688428276e-05, 0.000922787491199584, 0.00807855475653259, 0.0419755564122556, 0.137297698656726, 0.289104143723578, 0.383717955268606, 0.287592428015359, 0.0762972980943717, 1.08253627069562e-26, 4.40612314892176e-18, 1.7303152999683e-13, 2.13448386253153e-10, 4.11025272080867e-08, 2.42407130653098e-06, 6.19009416102239e-05, 0.000836326049776105, 0.00677675154328227, 0.035764064884341, 0.129994750668804, 0.338124656815603, 0.645802614054716, 0.920737181470952, 

0.930287099955798, 0.682230319012258, 0.387834292278172, 0.168791203667547, 0.0551647886853087, 0.0131631286089652, 0.00220291789307073, 0.000244140625, 1.64791671263467e-05, 5.97048774350275e-07, 9.49435786196503e-09, 4.68441436458606e-11, 3.65321546084037e-14, 9.05861199921074e-19, 2.19312494389621e-27, 0.0674272492712432, 0.265077672656157, 0.382234493636772, 0.323697874271752, 0.180784076389095, 0.0686427374132948, 0.0175795452097258, 0.0029296875, 0.00029736402413781, 1.64868176040264e-05, 4.17186141662317e-07, 3.51744859255273e-09, 5.33769936829189e-12, 3.35723712851008e-16, 4.35719927324097e-24, 0.00223993455844287, 0.0472059481727952, 0.172661293042503, 0.284519035659854, 0.271543764300221, 0.164063324581372, 0.0642981391158833, 0.01611328125, 0.00245936526986914, 0.000208662928826219, 8.40186294753517e-06, 1.21054700421972e-07, 3.57449238176066e-10, 5.70274326235609e-14, 3.9676459754241e-21, 4.5097376041396e-05, 0.00509490813050763, 0.0472689720203117, 0.151564979282433, 0.247192647692329, 0.237653643558759, 0.142529653138226, 0.0537109375, 0.0123274628415167, 0.00160055211756803, 0.00010255040229675, 2.52494319152495e-06, 1.4507437148791e-08, 5.87085938417579e-12, 2.18964878918928e-18, 6.12873706400694e-07, 0.000371175893241752, 0.00873496359043378, 0.0544992058328731, 0.151892047790761, 0.232370621207304, 0.213263152784032, 0.120849609375, 0.0417088428588799, 0.00828701480151219, 0.000844895343676084, 3.55488321914674e-05, 3.97439284659091e-07, 4.07965379433974e-10, 8.15679939325431e-16, 5.92281503566427e-09, 1.92291741141114e-05, 0.00114784568268841, 0.0139353842256267, 0.0663700263039079, 0.161568028472435, 0.226915356081631, 0.193359375, 0.100350616505117, 0.0305115220919942, 0.00495000832650632, 0.000355907000041316, 7.74262725134096e-06, 2.01596229694906e-08, 2.16074027076754e-13, 4.17361282087785e-11, 7.26387410171497e-07, 0.000109984812321816, 0.00259821166549721, 0.021146366222451, 0.0819136803515913, 0.176051105110784, 0.2255859375, 0.176051105110784, 0.0819136803515913, 0.021146366222451, 0.00259821166549721, 0.000109984812321817, 7.26387410171497e-07, 4.17361282087808e-11, 2.1607402707674e-13, 2.01596229694906e-08, 7.74262725134092e-06, 0.000355907000041317, 0.00495000832650632, 0.0305115220919942, 0.100350616505117, 0.193359375, 0.226915356081631, 0.161568028472435, 0.0663700263039079, 0.0139353842256267, 0.00114784568268841, 1.92291741141114e-05, 5.92281503566454e-09, 8.1567993932537e-16, 4.07965379433974e-10, 3.97439284659089e-07, 3.55488321914676e-05, 0.000844895343676084, 0.00828701480151219, 0.0417088428588799, 0.120849609375, 0.213263152784032, 0.232370621207304, 0.151892047790761, 0.054499205832873, 0.0087349635904338, 0.000371175893241752, 6.12873706400717e-07, 2.1896487891891e-18, 5.87085938417579e-12, 1.45074371487909e-08, 2.52494319152496e-06, 0.00010255040229675, 0.00160055211756803, 0.0123274628415167, 0.0537109375, 0.142529653138226, 0.237653643558759, 0.247192647692329, 0.151564979282433, 0.0472689720203118, 0.00509490813050763, 4.50973760413973e-05, 3.96764597542373e-21, 5.70274326235609e-14, 3.57449238176063e-10, 1.21054700421972e-07, 8.40186294753517e-06, 0.000208662928826219, 0.00245936526986914, 0.01611328125, 0.0642981391158833, 0.164063324581372, 0.271543764300221, 0.284519035659854, 0.172661293042503, 0.0472059481727952, 0.00223993455844291, 4.35719927324052e-24, 3.35723712851008e-16, 5.33769936829184e-12, 3.51744859255275e-09, 4.17186141662317e-07, 1.64868176040264e-05, 0.00029736402413781, 0.0029296875, 0.0175795452097258, 0.0686427374132948, 0.180784076389095, 0.323697874271752, 0.382234493636772, 0.265077672656157, 0.0674272492712438, 2.19312494389596e-27, 9.05861199921074e-19, 3.65321546084034e-14, 4.68441436458609e-11, 9.49435786196503e-09, 5.97048774350275e-07, 1.64791671263467e-05, 0.000244140625, 0.00220291789307073, 0.0131631286089652, 0.0551647886853087, 0.168791203667547, 0.387834292278172, 0.682230319012258, 0.930287099955798, 

0.938226865781323, 0.713734172080307, 0.434059845798259, 0.209009616332222, 0.0785206038306271, 0.0225315106370247, 0.00479385038727478, 0.000725552797622719, 7.36802282952341e-05, 4.61328385186012e-06, 1.56844814355796e-07, 2.36640187783445e-09, 1.11949860726903e-11, 8.45709527496599e-15, 2.05166431111492e-19, 4.90739168176271e-28, 0.0599838516294157, 0.24411729791866, 0.375148739988819, 0.349477286416394, 0.222547959138442, 0.100506668453518, 0.0322460257937301, 0.00719571182321807, 0.00106981507596088, 9.87599697360951e-05, 5.06323505360443e-06, 1.2022949089485e-07, 9.64125041075756e-10, 1.40906113088098e-12, 8.63787136343884e-17, 1.10531669641177e-24, 0.00175768997806737, 0.038268554795848, 0.148606845658589, 0.267826215867178, 0.289097971692199, 0.205485361201374, 0.0994144150871455, 0.0327084487015151, 0.00711947399570066, 0.000969020941212325, 7.49147712360314e-05, 2.79972231221866e-06, 3.80561290888436e-08, 1.07601887656019e-10, 1.66681962004804e-14, 1.14104870303573e-21, 3.12152099230472e-05, 0.00363581372350187, 0.0356771533811619, 0.124395099340598, 0.227605383005031, 0.254614395652201, 0.185754174283035, 0.0901077586832853, 0.0287146256108554, 0.00576237387394425, 0.000671773521477553, 3.95125414521071e-05, 9.1039930194165e-07, 4.97996168292771e-09, 1.9493352280486e-12, 7.13900504400468e-19, 3.7419158459196e-07, 0.000233165859390415, 0.00578156413808406, 0.0389993375579449, 0.12095498905442, 0.212955467064234, 0.234278036364193, 0.167559170050783, 0.0781739724053941, 0.0231298851184391, 0.00406613766926086, 0.000376407911778902, 1.47008685185143e-05, 1.55573594106716e-07, 1.53882145091452e-10, 3.01491427980631e-16, 3.18976902918511e-09, 1.06332435404005e-05, 0.000666251139502963, 0.00869458091671316, 0.0457090829641571, 0.126657845943793, 0.21011740718366, 0.221570367674329, 0.151341721132081, 0.0660211345511246, 0.0175016397486842, 0.00254988143396759, 0.000168807421134567, 3.45607559601264e-06, 8.63828237546115e-09, 9.05419228196642e-14, 1.98267378679228e-11, 3.53584621852565e-07, 5.59831574122813e-05, 0.00141340584854666, 0.01259528610972, 0.0549290652573283, 0.137410303162654, 0.21363970182096, 0.21363970182096, 0.137410303162654, 0.0549290652573283, 0.01259528610972, 0.00141340584854665, 5.59831574122816e-05, 3.53584621852565e-07, 1.98267378679216e-11, 9.05419228196709e-14, 8.63828237546114e-09, 3.45607559601262e-06, 0.000168807421134567, 0.00254988143396759, 0.0175016397486842, 0.0660211345511247, 0.151341721132081, 0.221570367674329, 0.21011740718366, 0.126657845943793, 0.0457090829641571, 0.00869458091671314, 0.000666251139502966, 1.06332435404005e-05, 3.18976902918494e-09, 3.01491427980656e-16, 1.53882145091452e-10, 1.55573594106715e-07, 1.47008685185143e-05, 0.000376407911778902, 0.00406613766926086, 0.0231298851184392, 0.0781739724053941, 0.167559170050783, 0.234278036364193, 0.212955467064234, 0.12095498905442, 0.0389993375579448, 0.00578156413808408, 0.000233165859390415, 3.74191584591944e-07, 7.13900504400535e-19, 1.9493352280486e-12, 4.97996168292768e-09, 9.10399301941654e-07, 3.95125414521071e-05, 0.000671773521477553, 0.00576237387394426, 0.0287146256108554, 0.0901077586832852, 0.185754174283035, 0.254614395652201, 0.227605383005031, 0.124395099340598, 0.0356771533811619, 0.00363581372350187, 3.12152099230462e-05, 1.14104870303585e-21, 1.66681962004804e-14, 1.07601887656019e-10, 3.80561290888437e-08, 2.79972231221866e-06, 7.49147712360314e-05, 0.000969020941212326, 0.00711947399570066, 0.032708448701515, 0.0994144150871454, 0.205485361201374, 0.289097971692199, 0.267826215867178, 0.148606845658589, 0.038268554795848, 0.00175768997806733, 1.10531669641189e-24, 8.63787136343884e-17, 1.40906113088097e-12, 9.6412504107576e-10, 1.2022949089485e-07, 5.06323505360443e-06, 9.87599697360953e-05, 0.00106981507596088, 0.00719571182321805, 0.0322460257937301, 0.100506668453518, 0.222547959138442, 0.349477286416394, 0.37514873998882, 0.24411729791866, 0.0599838516294151, 4.90739168176333e-28, 2.05166431111492e-19, 8.45709527496591e-15, 1.11949860726904e-11, 2.36640187783445e-09, 1.56844814355796e-07, 4.61328385186013e-06, 7.3680228295234e-05, 0.000725552797622717, 0.00479385038727478, 0.0225315106370247, 0.0785206038306271, 0.209009616332222, 0.434059845798259, 0.713734172080307, 0.938226865781323, 

0.944895631308325, 0.741072099126538, 0.476647321945339, 0.249523204146821, 0.105104335368624, 0.0350462159905398, 0.00904478400166573, 0.00175196385398684, 0.000244140625, 2.30691299635813e-05, 1.35742235736084e-06, 4.37822615202276e-08, 6.32356410382323e-10, 2.88883890515475e-12, 2.12529062628991e-15, 5.06279159324218e-20, 1.19881875268977e-28, 0.053684126905009, 0.224863607790573, 0.364317612704463, 0.367220189274728, 0.260463567249682, 0.135480607086193, 0.0521121725413161, 0.0146554298353415, 0.0029296875, 0.000397118655011974, 3.39263009937695e-05, 1.63089004587575e-06, 3.6744984083889e-08, 2.82663807639417e-10, 4.00403448000652e-13, 2.40266836756949e-17, 3.03846310097956e-25, 0.00139794276596405, 0.0312722644131659, 0.127627605444452, 0.247698630305844, 0.295838561230391, 0.240046057938869, 0.137613677817115, 0.0561892742742277, 0.01611328125, 0.00313321939044786, 0.000388632813928005, 2.78440635765864e-05, 9.78623510724368e-07, 1.26764757182244e-08, 3.45747249627833e-11, 5.22611611270537e-15, 3.52968418385116e-22, 2.20622064159266e-05, 0.00263581873403166, 0.0270972445278723, 0.101259718526665, 0.203647289877962, 0.25776745188081, 0.220241968591752, 0.130564268833192, 0.0537109375, 0.0149822616746127, 0.00269810271690475, 0.000288108855472886, 1.5796078469922e-05, 3.44542585716533e-07, 1.80940470466642e-09, 6.88938308154987e-13, 2.48504230766046e-19, 2.35024029994688e-07, 0.000149960031903843, 0.00388337573561186, 0.0279417497941802, 0.0946250802767406, 0.186838060904885, 0.237926234597866, 0.204785419430864, 0.120849609375, 0.0483579323428026, 0.0126439061674659, 0.00201226127975782, 0.000172102307269512, 6.3210767178026e-06, 6.3917012714789e-08, 6.13035164145031e-11, 1.18096084258849e-16, 1.78038144233864e-09, 6.06698571579064e-06, 0.000395759327590723, 0.00548286998433404, 0.0312659300224259, 0.0963030604123185, 0.18277721151677, 0.228407935010783, 0.193359375, 0.110992985468462, 0.042134855969067, 0.00999423595129439, 0.00133340342831777, 8.24663320730347e-05, 1.60559012245647e-06, 3.87907256295806e-09, 3.99093517220553e-14, 9.83423666741129e-12, 1.78977001445339e-07, 2.9408963153374e-05, 0.000784493054023973, 0.00753291815926542, 0.0361944209639763, 0.102383169542798, 0.185759122100304, 0.2255859375, 0.185759122100304, 0.102383169542798, 0.0361944209639763, 0.00753291815926541, 0.000784493054023971, 2.9408963153374e-05, 1.78977001445336e-07, 9.83423666741199e-12, 3.9909351722052e-14, 3.87907256295812e-09, 1.60559012245647e-06, 8.24663320730351e-05, 0.00133340342831777, 0.00999423595129441, 0.042134855969067, 0.110992985468462, 0.193359375, 0.228407935010783, 0.18277721151677, 0.0963030604123185, 0.0312659300224259, 0.00548286998433402, 0.000395759327590723, 6.06698571579057e-06, 1.78038144233874e-09, 1.18096084258838e-16, 6.13035164145042e-11, 6.3917012714789e-08, 6.32107671780262e-06, 0.000172102307269513, 0.00201226127975783, 0.0126439061674659, 0.0483579323428026, 0.120849609375, 0.204785419430864, 0.237926234597866, 0.186838060904885, 0.0946250802767405, 0.0279417497941802, 0.00388337573561186, 0.000149960031903842, 2.35024029994699e-07, 2.4850423076602e-19, 6.88938308155001e-13, 1.80940470466642e-09, 3.44542585716535e-07, 1.5796078469922e-05, 0.000288108855472887, 0.00269810271690475, 0.0149822616746127, 0.0537109375, 0.130564268833192, 0.220241968591752, 0.25776745188081, 0.203647289877962, 0.101259718526664, 0.0270972445278723, 0.00263581873403165, 2.20622064159273e-05, 3.52968418385074e-22, 5.22611611270549e-15, 3.45747249627833e-11, 1.26764757182245e-08, 9.78623510724371e-07, 2.78440635765865e-05, 0.000388632813928005, 0.00313321939044786, 0.01611328125, 0.0561892742742277, 0.137613677817115, 0.240046057938869, 0.295838561230391, 0.247698630305844, 0.127627605444452, 0.0312722644131658, 0.00139794276596408, 3.03846310097917e-25, 2.40266836756955e-17, 4.00403448000652e-13, 2.82663807639419e-10, 3.67449840838891e-08, 1.63089004587576e-06, 3.39263009937695e-05, 0.000397118655011974, 0.0029296875, 0.0146554298353415, 0.0521121725413161, 0.135480607086193, 0.260463567249682, 0.367220189274727, 0.364317612704463, 0.224863607790573, 0.0536841269050096, 1.1988187526896e-28, 5.06279159324232e-20, 2.12529062628991e-15, 2.88883890515477e-12, 6.32356410382325e-10, 4.37822615202277e-08, 1.35742235736084e-06, 2.30691299635813e-05, 0.000244140625, 0.00175196385398684, 0.00904478400166573, 0.0350462159905398, 0.105104335368624, 0.249523204146821, 0.476647321945339, 0.741072099126538, 0.944895631308325, 

0.950548578442371, 0.764886807652965, 0.515647448251821, 0.289484985626024, 0.134115918363619, 0.0506255302786338, 0.0153016370536536, 0.00361758199787139, 0.000648210599061848, 8.43285191029626e-05, 7.50329229312004e-06, 4.19153399057962e-07, 1.29355777456148e-08, 1.80111469485238e-10, 7.99009587767071e-13, 5.74872774629418e-16, 1.34859850138874e-20, 3.16633627068272e-29, 0.0483100465544409, 0.207317298846583, 0.351130879808432, 0.378051633207255, 0.293314361185104, 0.171462381603778, 0.0765106809492001, 0.0259419381738443, 0.00656274560096008, 0.00119940961026945, 0.000150671225554322, 1.20712241320738e-05, 5.49982734672135e-07, 1.18590762681848e-08, 8.8102738500887e-11, 1.21567666858327e-13, 7.16484490156539e-18, 8.97132084132814e-26, 0.00112533555014285, 0.0257546324546049, 0.109588913163395, 0.226285974682123, 0.294013837307845, 0.26616415141542, 0.175342696630614, 0.0852644312638367, 0.0304534468130297, 0.00781883445917073, 0.00138672460120956, 0.000159334961070414, 1.07175057499197e-05, 3.57883600662749e-07, 4.45254449759512e-09, 1.17827283599072e-11, 1.74466624214221e-15, 1.16503020411932e-22, 1.58870285975793e-05, 0.00193905990760579, 0.0207290916102822, 0.0820881014255476, 0.17861514029917, 0.250406920557769, 0.243539467045202, 0.16984369712943, 0.0856452724518921, 0.0308910427245757, 0.00773510432369935, 0.00127463811013591, 0.000126576898507756, 6.54558986832192e-06, 1.36377644392181e-07, 6.92133237104668e-10, 2.57474354488783e-13, 9.1692547066382e-20, 1.51393450956987e-07, 9.85441550773534e-05, 0.00264665720230377, 0.0201004860042869, 0.0732440820794242, 0.159018212004131, 0.228325698048243, 0.228367734273614, 0.162582616621867, 0.0823809680044204, 0.0291236567241029, 0.00688282127854962, 0.00100906454697027, 8.08089668968681e-05, 2.81956346141039e-06, 2.74433622000611e-08, 2.564834642422e-11, 4.87118542636104e-17, 1.02590929485573e-09, 3.56129523015208e-06, 0.000240299342802761, 0.00350001874109729, 0.0213581816961939, 0.0718099904627506, 0.152222097323034, 0.218352171769721, 0.219473599798581, 0.156227929813653, 0.0779763847623267, 0.0264291715956048, 0.0057203277134031, 0.000709427115198586, 4.14531967459882e-05, 7.73788720019565e-07, 1.81686319955538e-09, 1.84023273173757e-14, 5.06917923844075e-12, 9.38451629716552e-08, 1.59086848429435e-05, 0.000444386634368036, 0.0045413274738912, 0.0236455640945735, 0.0739992666271605, 0.152232400462497, 0.216031594983416, 0.216031594983417, 0.152232400462497, 0.0739992666271605, 0.0236455640945735, 0.0045413274738912, 0.000444386634368037, 1.59086848429435e-05, 9.38451629716552e-08, 5.06917923844075e-12, 1.84023273173757e-14, 1.81686319955538e-09, 7.73788720019565e-07, 4.1453196745988e-05, 0.000709427115198586, 0.0057203277134031, 0.0264291715956048, 0.0779763847623266, 0.156227929813653, 0.219473599798581, 0.218352171769721, 0.152222097323034, 0.0718099904627506, 0.0213581816961939, 0.0035000187410973, 0.000240299342802761, 3.56129523015208e-06, 1.02590929485573e-09, 4.87118542636104e-17, 2.564834642422e-11, 2.74433622000612e-08, 2.81956346141037e-06, 8.08089668968681e-05, 0.00100906454697027, 0.00688282127854962, 0.0291236567241029, 0.0823809680044204, 0.162582616621867, 0.228367734273614, 0.228325698048243, 0.159018212004131, 0.0732440820794242, 0.0201004860042869, 0.00264665720230377, 9.85441550773535e-05, 1.51393450956987e-07, 9.1692547066382e-20, 2.57474354488783e-13, 6.92133237104668e-10, 1.3637764439218e-07, 6.54558986832192e-06, 0.000126576898507756, 0.00127463811013591, 0.00773510432369935, 0.0308910427245757, 0.0856452724518921, 0.16984369712943, 0.243539467045202, 0.250406920557769, 0.17861514029917, 0.0820881014255477, 0.0207290916102822, 0.00193905990760579, 1.58870285975793e-05, 1.16503020411932e-22, 1.74466624214221e-15, 1.17827283599072e-11, 4.45254449759509e-09, 3.57883600662749e-07, 1.07175057499197e-05, 0.000159334961070414, 0.00138672460120956, 0.00781883445917072, 0.0304534468130297, 0.0852644312638367, 0.175342696630614, 0.26616415141542, 0.294013837307845, 0.226285974682123, 0.109588913163395, 0.0257546324546049, 0.00112533555014285, 8.97132084132814e-26, 7.16484490156539e-18, 1.21567666858327e-13, 8.81027385008864e-11, 1.18590762681848e-08, 5.49982734672135e-07, 1.20712241320738e-05, 0.000150671225554322, 0.00119940961026945, 0.00656274560096008, 0.0259419381738443, 0.0765106809492001, 0.171462381603778, 0.293314361185104, 0.378051633207255, 0.351130879808432, 0.207317298846583, 0.0483100465544409, 3.16633627068272e-29, 1.34859850138874e-20, 5.74872774629418e-16, 7.99009587767066e-13, 1.80111469485238e-10, 1.29355777456148e-08, 4.19153399057962e-07, 7.50329229312004e-06, 8.43285191029626e-05, 0.000648210599061848, 0.00361758199787139, 0.0153016370536536, 0.0506255302786338, 0.134115918363619, 0.289484985626024, 0.515647448251821, 0.764886807652965, 0.950548578442371, 

0.955380450362278, 0.785717351708002, 0.551229497819682, 0.328295009783194, 0.164781356284102, 0.0690010520375238, 0.0237773963230308, 0.00662131356279842, 0.00145461131513173, 0.000244140625, 2.99754628587024e-05, 2.5352074835285e-06, 1.35539302750435e-07, 4.02949310176605e-09, 5.43903981332267e-11, 2.3534991675853e-13, 1.66156703503481e-16, 3.847417730803e-21, 8.96825666649406e-30, 0.0436919977712583, 0.191398930507286, 0.336598735915284, 0.383177213336044, 0.320607614629829, 0.206650526962737, 0.104312724477531, 0.0412459376129655, 0.0126307687985249, 0.0029296875, 0.000497102063464002, 5.86055808644844e-05, 4.44892154660911e-06, 1.9374571402855e-07, 4.02549202093836e-09, 2.90362915046349e-11, 3.91832385866996e-14, 2.27435718777648e-18, 2.82387174844079e-26, 0.00091581741745384, 0.0213694877954883, 0.0942050002272919, 0.204982370643598, 0.28590452970589, 0.283660435458705, 0.209745051807958, 0.117760502301991, 0.050268283200587, 0.01611328125, 0.00377838907958779, 0.000620934634846871, 6.69307499093689e-05, 4.26967909197425e-06, 1.36551710898498e-07, 1.64191129310355e-09, 4.23510549867028e-12, 6.16210997161685e-16, 4.07533534805123e-23, 1.1634077452571e-05, 0.00144598828511927, 0.0159790694755126, 0.0664583269667703, 0.154519856135961, 0.235981017418816, 0.255600803741503, 0.203767151384728, 0.121247942167035, 0.0537109375, 0.017405393435055, 0.00398720762068987, 0.000610256888510478, 5.70261984886139e-05, 2.80731649505565e-06, 5.6269659601062e-08, 2.77424105102159e-10, 1.01185032016633e-13, 3.5644931967471e-20, 9.97605363527478e-08, 6.60448881592724e-05, 0.00182950157596591, 0.0145440737967583, 0.0563704273110563, 0.132513201328479, 0.210250229787809, 0.237997541968303, 0.197405147281996, 0.120849609375, 0.0541208719158491, 0.0172820632154387, 0.00375580869141873, 0.000514111573658666, 3.89573477314909e-05, 1.30167528435916e-06, 1.22667051690287e-08, 1.12151961863259e-11, 2.10443735265102e-17, 6.08307350972899e-10, 2.14511761032625e-06, 0.000148953789123138, 0.00226339420416452, 0.014623651318662, 0.0529149862220604, 0.122983884880898, 0.197673400702382, 0.228549372515763, 0.193359375, 0.119669420875588, 0.0532671906794191, 0.0164373460913753, 0.00329592867434314, 0.000384436709008597, 2.14125551273283e-05, 3.85699543604376e-07, 8.83964738374273e-10, 8.83510423858538e-15, 2.70466923369066e-12, 5.080305328546e-08, 8.84294919329001e-06, 0.000256839098215955, 0.00276622260967082, 0.0154072466708908, 0.0524549820992064, 0.119715615528088, 0.192942721888559, 0.2255859375, 0.192942721888559, 0.119715615528088, 0.0524549820992064, 0.0154072466708908, 0.00276622260967083, 0.000256839098215955, 8.84294919329001e-06, 5.080305328546e-08, 2.70466923369066e-12, 8.83510423858538e-15, 8.83964738374273e-10, 3.85699543604376e-07, 2.14125551273283e-05, 0.000384436709008595, 0.00329592867434315, 0.0164373460913753, 0.053267190679419, 0.119669420875588, 0.193359375, 0.228549372515763, 0.197673400702382, 0.122983884880898, 0.0529149862220603, 0.014623651318662, 0.00226339420416452, 0.000148953789123138, 2.14511761032625e-06, 6.08307350972899e-10, 2.10443735265102e-17, 1.12151961863259e-11, 1.22667051690287e-08, 1.30167528435916e-06, 3.89573477314907e-05, 0.000514111573658667, 0.00375580869141873, 0.0172820632154387, 0.0541208719158491, 0.120849609375, 0.197405147281996, 0.237997541968303, 0.210250229787809, 0.132513201328478, 0.0563704273110564, 0.0145440737967583, 0.00182950157596591, 6.60448881592724e-05, 9.97605363527478e-08, 3.5644931967471e-20, 1.01185032016633e-13, 2.77424105102159e-10, 5.6269659601062e-08, 2.80731649505564e-06, 5.7026198488614e-05, 0.000610256888510478, 0.00398720762068986, 0.017405393435055, 0.0537109375, 0.121247942167035, 0.203767151384728, 0.255600803741503, 0.235981017418816, 0.154519856135961, 0.0664583269667703, 0.0159790694755126, 0.00144598828511927, 1.1634077452571e-05, 4.07533534805123e-23, 6.16210997161685e-16, 4.23510549867028e-12, 1.64191129310355e-09, 1.36551710898498e-07, 4.26967909197426e-06, 6.69307499093689e-05, 0.00062093463484687, 0.00377838907958779, 0.01611328125, 0.050268283200587, 0.117760502301991, 0.209745051807958, 0.283660435458704, 0.28590452970589, 0.204982370643598, 0.0942050002272919, 0.0213694877954882, 0.00091581741745384, 2.82387174844079e-26, 2.27435718777648e-18, 3.91832385866995e-14, 2.90362915046349e-11, 4.02549202093834e-09, 1.93745714028551e-07, 4.44892154660911e-06, 5.86055808644843e-05, 0.000497102063464002, 0.0029296875, 0.0126307687985249, 0.0412459376129655, 0.104312724477531, 0.206650526962737, 0.320607614629829, 0.383177213336044, 0.336598735915284, 0.191398930507286, 0.0436919977712583, 8.96825666649406e-30, 3.847417730803e-21, 1.66156703503481e-16, 2.3534991675853e-13, 5.43903981332265e-11, 4.02949310176607e-09, 1.35539302750435e-07, 2.5352074835285e-06, 2.99754628587024e-05, 0.000244140625, 0.00145461131513173, 0.00662131356279842, 0.0237773963230308, 0.0690010520375238, 0.164781356284102, 0.328295009783194, 0.551229497819682, 0.785717351708002, 0.955380450362278, 

0.95954180803518, 0.804013537291149, 0.583624679793408, 0.365554621037942, 0.196409060655056, 0.0897864174143157, 0.0345425890047475, 0.0110246784183096, 0.00286491369733753, 0.000591475627979603, 9.39146149052316e-05, 1.09772387104147e-05, 8.8915674456553e-07, 4.57892573619003e-08, 1.31852397382462e-09, 1.73312621507477e-11, 7.34112867984967e-14, 5.09953161608075e-17, 1.16770306540346e-21, 2.70510070000612e-30, 0.0396967643594946, 0.176990665429006, 0.321438540914962, 0.383737643432397, 0.34235905639252, 0.239679931217284, 0.134195161573771, 0.0603158625325556, 0.0216226002958255, 0.00608860491715472, 0.00131375606530617, 0.000209439804642436, 2.34031979904153e-05, 1.69724336573933e-06, 7.11261816239747e-08, 1.43176710877852e-09, 1.0070318417321e-11, 1.33330184899612e-14, 7.6384969827472e-19, 9.41574572188409e-27, 0.00075271012866027, 0.0178574238366257, 0.0811416231177925, 0.184628173606717, 0.273516522551984, 0.293247381726094, 0.238946279789917, 0.151244154572672, 0.0747972688185869, 0.0287263321399884, 0.00842321196474328, 0.00183149941052377, 0.000282327725810043, 2.88340789354136e-05, 1.75854060870351e-06, 5.4212073043315e-08, 6.33147669303299e-10, 1.59774739280614e-12, 2.29015483732324e-16, 1.50212975818972e-23, 8.65000715220301e-06, 0.00109195139312536, 0.0124138213047808, 0.053836596786901, 0.132434570562344, 0.217446624710596, 0.257857486364734, 0.22984851928267, 0.156812116227944, 0.0821407410952831, 0.0327308120940128, 0.00970667297381096, 0.00206418162979823, 0.000296882160672806, 2.63506519433934e-05, 1.24404389412652e-06, 2.41258641443654e-08, 1.16038955112595e-10, 4.16138441479395e-14, 1.45236653650039e-20, 6.7097902760759e-08, 4.50704173627463e-05, 0.00128194992396493, 0.0105964647239823, 0.0432835568343842, 0.108836601253892, 0.187829148248881, 0.23578088572646, 0.221910199722407, 0.158540721018322, 0.0858498627069991, 0.0347246427071783, 0.0101869942361691, 0.00206331670341009, 0.000266522636283505, 1.9269886917291e-05, 6.20532476907292e-07, 5.68857219599811e-09, 5.10404623158714e-12, 9.4787002771955e-18, 3.70116877674388e-10, 1.32287045598286e-06, 9.41399789630092e-05, 0.00148313901411866, 0.0100596293780675, 0.0387377806928685, 0.097293471137164, 0.171993860218941, 0.223312162579214, 0.21760080898204, 0.160125276846183, 0.0883369983621324, 0.0357504634952791, 0.0101972989242255, 0.0019169655171521, 0.000212256057199455, 1.1349680052874e-05, 1.98307985859071e-07, 4.45173011243344e-10, 4.39904912887092e-15, 1.48866041653575e-12, 2.83119551673659e-08, 5.04085192103124e-06, 0.00015136641625584, 0.00170477797646256, 0.0100535931942574, 0.0367477889809174, 0.0914837798066015, 0.163860508161686, 0.217774481927082, 0.217774481927082, 0.163860508161686, 0.0914837798066015, 0.0367477889809174, 0.0100535931942573, 0.00170477797646256, 0.00015136641625584, 5.04085192103123e-06, 2.83119551673665e-08, 1.48866041653589e-12, 4.39904912887042e-15, 4.45173011243334e-10, 1.98307985859071e-07, 1.13496800528739e-05, 0.000212256057199455, 0.0019169655171521, 0.0101972989242255, 0.0357504634952791, 0.0883369983621324, 0.160125276846183, 0.21760080898204, 0.223312162579214, 0.171993860218941, 0.097293471137164, 0.0387377806928685, 0.0100596293780675, 0.00148313901411866, 9.41399789630092e-05, 1.32287045598288e-06, 3.70116877674418e-10, 9.47870027719428e-18, 5.10404623158702e-12, 5.68857219599811e-09, 6.20532476907289e-07, 1.9269886917291e-05, 0.000266522636283505, 0.00206331670341009, 0.0101869942361691, 0.0347246427071783, 0.0858498627069991, 0.158540721018322, 0.221910199722407, 0.23578088572646, 0.187829148248881, 0.108836601253892, 0.0432835568343842, 0.0105964647239824, 0.00128194992396493, 4.50704173627468e-05, 6.70979027607633e-08, 1.45236653650018e-20, 4.16138441479384e-14, 1.16038955112596e-10, 2.41258641443653e-08, 1.24404389412652e-06, 2.63506519433935e-05, 0.000296882160672806, 0.00206418162979823, 0.00970667297381096, 0.0327308120940128, 0.0821407410952831, 0.156812116227944, 0.22984851928267, 0.257857486364734, 0.217446624710596, 0.132434570562344, 0.0538365967869011, 0.0124138213047808, 0.00109195139312537, 8.65000715220343e-06, 1.50212975818947e-23, 2.29015483732317e-16, 1.59774739280614e-12, 6.33147669303295e-10, 5.4212073043315e-08, 1.75854060870351e-06, 2.88340789354136e-05, 0.000282327725810043, 0.00183149941052377, 0.00842321196474328, 0.0287263321399884, 0.0747972688185869, 0.151244154572672, 0.238946279789917, 0.293247381726093, 0.273516522551984, 0.184628173606717, 0.0811416231177925, 0.0178574238366258, 0.000752710128660294, 9.41574572188242e-27, 7.63849698274694e-19, 1.33330184899612e-14, 1.00703184173209e-11, 1.43176710877852e-09, 7.1126181623975e-08, 1.69724336573933e-06, 2.34031979904153e-05, 0.000209439804642436, 0.00131375606530617, 0.00608860491715472, 0.0216226002958255, 0.0603158625325556, 0.134195161573771, 0.239679931217284, 0.34235905639252, 0.383737643432397, 0.321438540914962, 0.176990665429007, 0.0396967643594952, 2.70510070000559e-30, 1.16770306540342e-21, 5.09953161608075e-17, 7.34112867984961e-14, 1.73312621507477e-11, 1.31852397382462e-09, 4.57892573619003e-08, 8.8915674456553e-07, 1.09772387104147e-05, 9.39146149052316e-05, 0.000591475627979603, 0.00286491369733753, 0.0110246784183096, 0.0345425890047475, 0.0897864174143157, 0.196409060655056, 0.365554621037942, 0.583624679793408, 0.804013537291149, 0.95954180803518, 

0.963150447391732, 0.820150098558721, 0.613090259359763, 0.4010208386892, 0.228414620583165, 0.112538513611647, 0.0475401523326278, 0.0170220499131382, 0.00508998684741589, 0.00124698886841271, 0.000244140625, 3.69664374906796e-05, 4.14232284047819e-06, 3.23305801405112e-07, 1.61216086391484e-08, 4.51645908865679e-10, 5.80234255457948e-12, 2.41295875213741e-14, 1.6528933565877e-17, 3.74852230000651e-22, 8.63753825713546e-31, 0.0362187422341086, 0.163960216806603, 0.306148660608272, 0.380741397878541, 0.358904111944907, 0.269633487891747, 0.164855762397192, 0.082554973474714, 0.0337630635689756, 0.0111610719516041, 0.0029296875, 0.000594739467751056, 8.99251662252245e-05, 9.59941145907004e-06, 6.69464115749865e-07, 2.71448794844879e-08, 5.31754681471531e-10, 3.65973155787781e-12, 4.76649759997702e-15, 2.70008507606069e-19, 3.30760197232909e-27, 0.000624243518510249, 0.0150232906638887, 0.0700683280707095, 0.165681761270372, 0.258472541013176, 0.296092855256898, 0.262016800257824, 0.18350845051486, 0.102647523568386, 0.0457857868965959, 0.01611328125, 0.00438558329711232, 0.000894746479939465, 0.000130634281274936, 1.27417088026414e-05, 7.47754781031316e-07, 2.23357593985964e-08, 2.54407556874744e-10, 6.2999248177044e-13, 8.91407413145653e-17, 5.80521012364707e-24, 6.52064827389666e-06, 0.000834272083829711, 0.00971912575605548, 0.0436953639472627, 0.112814895753115, 0.197059820136695, 0.252388871114152, 0.247220767278434, 0.189134676862717, 0.113833873220134, 0.0537109375, 0.0195994563128313, 0.00539553859543524, 0.00107742182578981, 0.000146975214853849, 1.24837923154489e-05, 5.68599114768615e-07, 1.0718322976723e-08, 5.04646668420413e-11, 1.78357382537429e-14, 6.17502473349641e-21, 4.59760102259549e-08, 3.12718897387192e-05, 0.000909989583632125, 0.00777857049982359, 0.0332370333861413, 0.0885262380210579, 0.164102439174613, 0.224811024405289, 0.235232660323163, 0.191036396012036, 0.120849609375, 0.0591240883300005, 0.0219620755561292, 0.00599816144022298, 0.00114436431001926, 0.000140681711848387, 9.770468941467e-06, 3.04808760282579e-07, 2.72862106197988e-09, 2.4088497492418e-12, 4.43366863762245e-18, 2.30520339833518e-10, 8.33562186649015e-07, 6.05875101190663e-05, 0.000984694898576061, 0.00696330670992401, 0.0282802601663678, 0.0758747610008599, 0.145374329189164, 0.208047040907969, 0.227980753239549, 0.193359375, 0.126830105762889, 0.0635695919444679, 0.023745865127231, 0.00633609923220185, 0.00112736933626814, 0.000119388391864748, 6.16404093458919e-06, 1.04914739892023e-07, 2.31348025981297e-10, 2.26373312918397e-15, 8.42779626879039e-13, 1.62012562564014e-08, 2.94141698835364e-06, 9.0892990116323e-05, 0.00106374027633345, 0.00658751472384856, 0.0255803476711297, 0.0685463998326216, 0.134169027856335, 0.198384190203594, 0.2255859375, 0.198384190203594, 0.134169027856335, 0.0685463998326217, 0.0255803476711297, 0.00658751472384856, 0.00106374027633345, 9.0892990116323e-05, 2.94141698835361e-06, 1.62012562564017e-08, 8.42779626878949e-13, 2.26373312918425e-15, 2.31348025981292e-10, 1.04914739892024e-07, 6.16404093458919e-06, 0.000119388391864748, 0.00112736933626814, 0.00633609923220185, 0.023745865127231, 0.0635695919444679, 0.126830105762889, 0.193359375, 0.227980753239549, 0.208047040907969, 0.145374329189164, 0.0758747610008599, 0.0282802601663678, 0.00696330670992401, 0.000984694898576061, 6.05875101190658e-05, 8.3356218664903e-07, 2.30520339833498e-10, 4.43366863762308e-18, 2.40884974924174e-12, 2.72862106197991e-09, 3.04808760282579e-07, 9.770468941467e-06, 0.000140681711848387, 0.00114436431001926, 0.00599816144022297, 0.0219620755561292, 0.0591240883300005, 0.120849609375, 0.191036396012036, 0.235232660323163, 0.224811024405289, 0.164102439174613, 0.0885262380210579, 0.0332370333861413, 0.00777857049982359, 0.00090998958363212, 3.12718897387197e-05, 4.59760102259517e-08, 6.1750247334974e-21, 1.78357382537424e-14, 5.04646668420419e-11, 1.0718322976723e-08, 5.68599114768615e-07, 1.24837923154489e-05, 0.000146975214853849, 0.00107742182578981, 0.00539553859543524, 0.0195994563128313, 0.0537109375, 0.113833873220134, 0.189134676862717, 0.247220767278434, 0.252388871114152, 0.197059820136695, 0.112814895753115, 0.0436953639472627, 0.00971912575605544, 0.00083427208382972, 6.52064827389631e-06, 5.80521012364811e-24, 8.91407413145622e-17, 6.29992481770449e-13, 2.54407556874744e-10, 2.23357593985964e-08, 7.47754781031316e-07, 1.27417088026414e-05, 0.000130634281274936, 0.000894746479939465, 0.00438558329711232, 0.01611328125, 0.0457857868965959, 0.102647523568386, 0.18350845051486, 0.262016800257824, 0.296092855256898, 0.258472541013176, 0.165681761270372, 0.0700683280707094, 0.0150232906638888, 0.000624243518510226, 3.30760197232974e-27, 2.70008507606059e-19, 4.76649759997709e-15, 3.65973155787781e-12, 5.31754681471531e-10, 2.71448794844879e-08, 6.69464115749865e-07, 9.59941145907002e-06, 8.99251662252245e-05, 0.000594739467751056, 0.0029296875, 0.0111610719516041, 0.0337630635689756, 0.082554973474714, 0.164855762397192, 0.269633487891747, 0.358904111944907, 0.380741397878541, 0.306148660608272, 0.163960216806604, 0.036218742234108, 8.6375382571373e-31, 3.74852230000636e-22, 1.65289335658772e-17, 2.41295875213741e-14, 5.80234255457948e-12, 4.51645908865679e-10, 1.61216086391484e-08, 3.23305801405112e-07, 4.14232284047819e-06, 3.69664374906796e-05, 0.000244140625, 0.00124698886841271, 0.00508998684741589, 0.0170220499131382, 0.0475401523326278, 0.112538513611647, 0.228414620583165, 0.4010208386892, 0.613090259359763, 0.820150098558721, 0.963150447391732, 

0.966299542147149, 0.834439410185226, 0.639887634618408, 0.434566504511462, 0.260325216017964, 0.136804302807698, 0.0626131803456562, 0.0247265682661571, 0.00832570468718782, 0.00235418768629884, 0.000548245828814291, 0.000102540702873899, 1.49025495054525e-05, 1.61012304564814e-06, 1.21697242953445e-07, 5.9013765119248e-09, 1.61432844829189e-10, 2.03316134131169e-12, 8.3211198053869e-15, 5.63118157805298e-18, 1.26641179629251e-22, 2.90460102537897e-31, 0.0331734708177064, 0.152174213258283, 0.291066985692626, 0.375043194021609, 0.370753663132217, 0.295986576234392, 0.195151086294747, 0.107157235227943, 0.048993532493919, 0.0185270932447095, 0.00572114991941348, 0.00141498159170232, 0.000272682245566542, 3.94006881321786e-05, 4.04376191507578e-06, 2.72653204620028e-07, 1.07443991609503e-08, 2.05572549628492e-10, 1.38841477657243e-12, 1.78267754076543e-15, 9.99979695115051e-20, 1.21834374978993e-27, 0.000521977153521805, 0.012719462705507, 0.0606825220388009, 0.148350075605864, 0.242011557875296, 0.293511901868309, 0.278777440168848, 0.212843600587614, 0.132141109374562, 0.0668274568593678, 0.0273635704308609, 0.00894925191336987, 0.00228683375401659, 0.000441906094390736, 6.15845623391264e-05, 5.77363510186205e-06, 3.27758385633914e-07, 9.52664198611269e-09, 1.0617887578927e-10, 2.58658942719998e-13, 3.61900230282787e-17, 2.342257490287e-24, 4.97769328436329e-06, 0.000644336187682426, 0.0076674393972107, 0.0355639762147172, 0.0957420714997001, 0.176398737984474, 0.241357242033474, 0.256221606670051, 0.215999725454265, 0.146089376974445, 0.079319187233927, 0.0343035236036348, 0.0116232714829257, 0.00300380842456907, 0.000568426343430977, 7.40975954060328e-05, 6.05956635013291e-06, 2.675658130532e-07, 4.9212233300297e-09, 2.2745645114803e-11, 7.93784461209639e-15, 2.72907511293272e-21, 3.2041183085436e-08, 2.20323109827372e-05, 0.000653944444477902, 0.0057548846493605, 0.0255666193238155, 0.0715597811570907, 0.141047962189974, 0.208197100085478, 0.238326438241461, 0.215568903423087, 0.155198500084613, 0.0887553425175479, 0.0398773180677166, 0.0137821903501188, 0.00354144341622115, 0.000641893043976776, 7.56193694005309e-05, 5.07253641765349e-06, 1.5396138117589e-07, 1.35012131116539e-09, 1.17522250537594e-12, 2.1463478831712e-18, 1.46664977154346e-10, 5.35728865652948e-07, 3.96614713723669e-05, 0.000662217112982043, 0.00485491079873334, 0.0206433415577996, 0.0586152689451399, 0.120301506662749, 0.18699444727462, 0.226199193752945, 0.21594057254024, 0.163300585111075, 0.0972883790467997, 0.0449678083283598, 0.015690033905303, 0.00395420051824462, 0.000671061034696989, 6.83844233622675e-05, 3.42521618316679e-06, 5.69881804345464e-08, 1.23730016419477e-10, 1.20038954540881e-15, 4.89520745146359e-13, 9.49853983784074e-09, 1.75397579528888e-06, 5.55636776429752e-05, 0.000672227092434062, 0.00434227975557271, 0.0177615766748495, 0.0506867288135555, 0.106982318465369, 0.173070400912616, 0.219082548521927, 0.219082548521927, 0.173070400912616, 0.106982318465369, 0.0506867288135555, 0.0177615766748495, 0.0043422797555727, 0.000672227092434059, 5.55636776429749e-05, 1.75397579528889e-06, 9.49853983784074e-09, 4.89520745146359e-13, 1.20038954540881e-15, 1.23730016419477e-10, 5.69881804345458e-08, 3.42521618316681e-06, 6.83844233622677e-05, 0.000671061034696989, 0.00395420051824462, 0.015690033905303, 0.0449678083283598, 0.0972883790467995, 0.163300585111075, 0.21594057254024, 0.226199193752945, 0.18699444727462, 0.120301506662749, 0.0586152689451399, 0.0206433415577996, 0.00485491079873333, 0.00066221711298204, 3.96614713723672e-05, 5.35728865652948e-07, 1.46664977154346e-10, 2.1463478831712e-18, 1.17522250537594e-12, 1.35012131116538e-09, 1.53961381175891e-07, 5.07253641765352e-06, 7.56193694005309e-05, 0.000641893043976776, 0.00354144341622114, 0.0137821903501188, 0.0398773180677165, 0.0887553425175479, 0.155198500084613, 0.215568903423087, 0.238326438241461, 0.208197100085478, 0.141047962189974, 0.0715597811570907, 0.0255666193238155, 0.00575488464936048, 0.000653944444477906, 2.20323109827372e-05, 3.2041183085436e-08, 2.72907511293272e-21, 7.93784461209639e-15, 2.27456451148027e-11, 4.92122333002974e-09, 2.67565813053201e-07, 6.05956635013291e-06, 7.40975954060328e-05, 0.000568426343430977, 0.00300380842456907, 0.0116232714829256, 0.0343035236036348, 0.079319187233927, 0.146089376974445, 0.215999725454265, 0.256221606670051, 0.241357242033474, 0.176398737984474, 0.0957420714997, 0.0355639762147171, 0.00766743939721074, 0.000644336187682426, 4.97769328436329e-06, 2.342257490287e-24, 3.61900230282787e-17, 2.58658942719995e-13, 1.06178875789271e-10, 9.52664198611274e-09, 3.27758385633914e-07, 5.77363510186205e-06, 6.15845623391264e-05, 0.000441906094390736, 0.00228683375401659, 0.00894925191336987, 0.0273635704308609, 0.0668274568593678, 0.132141109374562, 0.212843600587614, 0.278777440168848, 0.293511901868309, 0.242011557875296, 0.148350075605864, 0.0606825220388011, 0.012719462705507, 0.000521977153521805, 1.21834374978993e-27, 9.99979695115051e-20, 1.7826775407654e-15, 1.38841477657245e-12, 2.05572549628493e-10, 1.07443991609503e-08, 2.72653204620028e-07, 4.04376191507578e-06, 3.94006881321786e-05, 0.000272682245566541, 0.00141498159170232, 0.00572114991941348, 0.0185270932447095, 0.048993532493919, 0.107157235227943, 0.195151086294747, 0.295986576234392, 0.370753663132217, 0.375043194021609, 0.291066985692627, 0.152174213258283, 0.0331734708177064, 2.90460102537897e-31, 1.26641179629251e-22, 5.63118157805287e-18, 8.32111980538698e-15, 2.0331613413117e-12, 1.61432844829189e-10, 5.9013765119248e-09, 1.21697242953445e-07, 1.61012304564814e-06, 1.49025495054525e-05, 0.000102540702873899, 0.000548245828814291, 0.00235418768629884, 0.00832570468718782, 0.0247265682661571, 0.0626131803456562, 0.136804302807698, 0.260325216017964, 0.434566504511462, 0.639887634618408, 0.834439410185226, 0.966299542147149, 

0.969063535145711, 0.847142375486, 0.664269553793788, 0.46614786038552, 0.291772463071178, 0.162152563003335, 0.0795362383434809, 0.034169809894664, 0.0127334537799576, 0.00406597148565268, 0.00109541874391661, 0.000244140625, 4.38859216220233e-05, 6.15478651692904e-06, 6.44207118563008e-07, 4.73470026299182e-08, 2.24073681750815e-09, 6.00333527860768e-11, 7.43082601471249e-13, 2.99904835936854e-15, 2.00810392097342e-18, 4.48308963467284e-23, 1.02405417088353e-31, 0.0304928291978664, 0.141505310004689, 0.276415513188931, 0.367347077433745, 0.378493373323463, 0.31852544324533, 0.224163609058043, 0.13323795837178, 0.0670091441168323, 0.0284020462378262, 0.0100536439804421, 0.0029296875, 0.00068856410844236, 0.000126879127745695, 1.76278829030872e-05, 1.74851586000911e-06, 1.14486236547039e-07, 4.4008318977286e-09, 8.24870185043628e-11, 5.48015783704409e-13, 6.94913278723452e-16, 3.86476937975747e-20, 4.68640646609679e-28, 0.000439769022121569, 0.0108335429954731, 0.0527183637554994, 0.132681669133071, 0.225036882273552, 0.28677803413187, 0.289565366364907, 0.238119421871557, 0.161623076377877, 0.0909319228992269, 0.0422910316380084, 0.01611328125, 0.0049515934847164, 0.00119880575295288, 0.000221083452407302, 2.95956651351696e-05, 2.68100208562361e-06, 1.4786262234919e-07, 4.19677381149272e-09, 4.58969798530846e-11, 1.10219003503087e-13, 1.52704272550392e-17, 9.82965827106328e-25, 3.84386036155383e-06, 0.000502671590850122, 0.00609364973765889, 0.0290443271135012, 0.0810896041286622, 0.15648174976392, 0.226696167874291, 0.257915667828795, 0.236259196635455, 0.176440863982085, 0.107817464025458, 0.0537109375, 0.0215805068330068, 0.00686473075570325, 0.00168046075492834, 0.000303600644661056, 3.80502119460996e-05, 3.01091215094535e-06, 1.29408134275089e-07, 2.32965282926814e-09, 1.05949376620622e-11, 3.65674645540619e-15, 1.24954799459508e-21, 2.267850092145e-08, 1.57435237612043e-05, 0.000475441212967138, 0.00429156293040948, 0.0197233386195835, 0.0576348645607734, 0.119796881762735, 0.188566440958066, 0.233119095619863, 0.231092445929473, 0.185538362191256, 0.120849609375, 0.0634866001641055, 0.0265339539427049, 0.00862192585976513, 0.0021022339567941, 0.000364519513025398, 4.13848644759477e-05, 2.69346515416731e-06, 7.98182269845543e-08, 6.87454729532119e-10, 5.91074580341643e-13, 1.07218872693698e-18, 9.51477558806229e-11, 3.50636410102429e-07, 2.63787145088746e-05, 0.000450927909098802, 0.00341140393613543, 0.0150953895439217, 0.0450178047627609, 0.0980366691655059, 0.163570296477504, 0.215233460036514, 0.22704701114459, 0.193359375, 0.132812809892384, 0.0729319621974393, 0.0314570257660952, 0.0103513470356593, 0.00248325859411706, 0.000404503659419504, 3.98656281410732e-05, 1.94469013604244e-06, 3.17195682343993e-08, 6.79402562491654e-11, 6.54224789489844e-16, 2.91078120838461e-13, 5.69428087860403e-09, 1.06717891743188e-06, 3.45482101914779e-05, 0.000430241865992304, 0.00288290399131521, 0.0123353057856359, 0.0371654587445196, 0.0836869690692931, 0.146170802866159, 0.202593107872052, 0.2255859375, 0.202593107872052, 0.146170802866159, 0.0836869690692931, 0.0371654587445197, 0.0123353057856358, 0.00288290399131522, 0.000430241865992305, 3.45482101914779e-05, 1.06717891743189e-06, 5.69428087860403e-09, 2.91078120838424e-13, 6.54224789489941e-16, 6.79402562491654e-11, 3.17195682343989e-08, 1.94469013604244e-06, 3.98656281410732e-05, 0.000404503659419503, 0.00248325859411707, 0.0103513470356593, 0.0314570257660952, 0.0729319621974393, 0.132812809892384, 0.193359375, 0.22704701114459, 0.215233460036514, 0.163570296477504, 0.098036669165506, 0.0450178047627608, 0.0150953895439217, 0.00341140393613543, 0.000450927909098802, 2.63787145088749e-05, 3.50636410102429e-07, 9.51477558806128e-11, 1.07218872693717e-18, 5.91074580341643e-13, 6.87454729532109e-10, 7.98182269845543e-08, 2.69346515416731e-06, 4.13848644759476e-05, 0.000364519513025399, 0.00210223395679409, 0.00862192585976513, 0.0265339539427049, 0.0634866001641055, 0.120849609375, 0.185538362191256, 0.231092445929473, 0.233119095619863, 0.188566440958066, 0.119796881762735, 0.0576348645607735, 0.0197233386195835, 0.00429156293040948, 0.000475441212967141, 1.57435237612043e-05, 2.26785009214481e-08, 1.24954799459532e-21, 3.65674645540619e-15, 1.0594937662062e-11, 2.32965282926814e-09, 1.29408134275089e-07, 3.01091215094534e-06, 3.80502119460997e-05, 0.000303600644661055, 0.00168046075492834, 0.00686473075570325, 0.0215805068330067, 0.0537109375, 0.107817464025458, 0.176440863982085, 0.236259196635455, 0.257915667828795, 0.22669616787429, 0.15648174976392, 0.0810896041286622, 0.0290443271135012, 0.00609364973765892, 0.000502671590850122, 3.84386036155358e-06, 9.82965827106537e-25, 1.52704272550392e-17, 1.10219003503085e-13, 4.58969798530846e-11, 4.19677381149272e-09, 1.4786262234919e-07, 2.68100208562362e-06, 2.95956651351696e-05, 0.000221083452407302, 0.00119880575295288, 0.0049515934847164, 0.01611328125, 0.0422910316380084, 0.0909319228992269, 0.161623076377877, 0.238119421871557, 0.289565366364907, 0.28677803413187, 0.225036882273552, 0.132681669133071, 0.0527183637554995, 0.0108335429954731, 0.000439769022121551, 4.68640646609788e-28, 3.86476937975747e-20, 6.94913278723439e-16, 5.48015783704409e-13, 8.24870185043628e-11, 4.40083189772858e-09, 1.1448623654704e-07, 1.7485158600091e-06, 1.76278829030872e-05, 0.000126879127745695, 0.00068856410844236, 0.0029296875, 0.0100536439804421, 0.0284020462378262, 0.0670091441168323, 0.13323795837178, 0.224163609058043, 0.31852544324533, 0.378493373323463, 0.367347077433745, 0.276415513188931, 0.141505310004689, 0.0304928291978658, 1.02405417088379e-31, 4.48308963467284e-23, 2.00810392097338e-18, 2.99904835936854e-15, 7.43082601471249e-13, 6.00333527860765e-11, 2.24073681750816e-09, 4.73470026299181e-08, 6.44207118563008e-07, 6.15478651692904e-06, 4.38859216220233e-05, 0.000244140625, 0.00109541874391661, 0.00406597148565268, 0.0127334537799576, 0.034169809894664, 0.0795362383434809, 0.162152563003335, 0.291772463071178, 0.46614786038552, 0.664269553793788, 0.847142375486, 0.969063535145711, 

0.97150245792734, 0.858477523595839, 0.686473186294606, 0.495779312759863, 0.322479710040501, 0.188192793378357, 0.0980443769615999, 0.0453109694421675, 0.0184280493362109, 0.00653007589682532, 0.00199113772036462, 0.000514302037233644, 0.000110314716886547, 1.91538692005778e-05, 2.6037674249007e-06, 2.65056336158308e-07, 1.90084662005835e-08, 8.80572799405798e-10, 2.31648926615385e-11, 2.82392145570771e-13, 1.12581663176922e-15, 7.46811608812582e-19, 1.6565355268724e-23, 3.77044120685004e-32, 0.0281214367583889, 0.131835638605654, 0.262333516694199, 0.358221173368138, 0.382718532078574, 0.337263888784339, 0.251217073283094, 0.159936127718908, 0.0873270617041032, 0.0408153136630083, 0.0162260252431125, 0.00542855311550756, 0.00150497782173531, 0.000338460632681688, 5.99873631290451e-05, 8.05436304367766e-06, 7.75472397985043e-07, 4.94881589521934e-08, 1.86134093945178e-09, 3.42639957586012e-11, 2.24371298511359e-13, 2.8141247737544e-16, 1.55331432830608e-20, 1.87569000162096e-28, 0.000373089091194703, 0.00927936309810396, 0.0459478746406397, 0.118630277559386, 0.208179534581908, 0.277024475582545, 0.295023802193696, 0.25874456920603, 0.189670492777368, 0.116925568790199, 0.0606044393922564, 0.0262622167794605, 0.00941040226629124, 0.00274120332518803, 0.000633430247846296, 0.000112177473723731, 1.44999684408176e-05, 1.27473166043322e-06, 6.85492978147697e-08, 1.90548197800992e-09, 2.04950218625658e-11, 4.86023291309861e-14, 6.67573956740517e-18, 4.27672570671562e-25, 2.99987840645545e-06, 0.000395839898174916, 0.00487745340958926, 0.0238098081873862, 0.0686297836932836, 0.137905788358767, 0.209981491241174, 0.253695033433399, 0.249670225294215, 0.203007414410917, 0.137186945009978, 0.0770007096981354, 0.0356617238793596, 0.0134552073183484, 0.004053721236037, 0.00094688266379414, 0.000164317502569272, 1.98999645696153e-05, 1.53001661534366e-06, 6.42225786578722e-08, 1.134607176732e-09, 5.08729439689244e-12, 1.73882341151749e-15, 5.90986807914915e-22, 1.6281654166496e-08, 1.1397897220761e-05, 0.000349481832738115, 0.00322567062868517, 0.0152718271418522, 0.0463394230254604, 0.10088085360167, 0.167902228347175, 0.221838799635279, 0.237912949616121, 0.209616229391495, 0.152391887062299, 0.0912221387556589, 0.0445803332293635, 0.0175110720444348, 0.0053949875650734, 0.00125691053663626, 0.000209695739472509, 2.30511744036892e-05, 1.46108137915721e-06, 4.23981043559697e-08, 3.59435055928286e-10, 3.05714012281515e-13, 5.51249170462787e-19, 6.28392313684118e-11, 2.33382007497273e-07, 1.78071142050556e-05, 0.00031075749169508, 0.00241661147824498, 0.0110727683265876, 0.0344646558051806, 0.0790202536466659, 0.140166982702449, 0.198272155209188, 0.227758444811785, 0.214469940073832, 0.165934095411428, 0.105034915796652, 0.0537909301454317, 0.0218585925769757, 0.0068369495123043, 0.00157131904651394, 0.000246960462955324, 2.36373364550573e-05, 1.12663909442275e-06, 1.80589068426837e-08, 3.82219355144079e-11, 3.65641579049299e-16, 1.76843869730549e-13, 3.48447066758914e-09, 6.61590545825835e-07, 2.18298123193904e-05, 0.000278836405194728, 0.00192925045616761, 0.00858550706263687, 0.0271173462048408, 0.064577428851428, 0.120484777609437, 0.180447504259575, 0.220088738382172, 0.220088738382172, 0.180447504259575, 0.120484777609437, 0.064577428851428, 0.0271173462048408, 0.00858550706263687, 0.0019292504561676, 0.000278836405194728, 2.18298123193904e-05, 6.61590545825827e-07, 3.48447066758914e-09, 1.76843869730524e-13, 3.65641579049358e-16, 3.82219355144079e-11, 1.80589068426839e-08, 1.12663909442275e-06, 2.36373364550573e-05, 0.000246960462955325, 0.00157131904651394, 0.00683694951230432, 0.0218585925769757, 0.0537909301454317, 0.105034915796652, 0.165934095411428, 0.214469940073832, 0.227758444811785, 0.198272155209188, 0.140166982702449, 0.0790202536466658, 0.0344646558051806, 0.0110727683265875, 0.00241661147824498, 0.00031075749169508, 1.78071142050555e-05, 2.33382007497273e-07, 6.28392313684046e-11, 5.51249170462889e-19, 3.05714012281515e-13, 3.59435055928291e-10, 4.23981043559697e-08, 1.46108137915721e-06, 2.30511744036892e-05, 0.000209695739472509, 0.00125691053663626, 0.0053949875650734, 0.0175110720444348, 0.0445803332293635, 0.0912221387556588, 0.152391887062299, 0.209616229391495, 0.237912949616121, 0.221838799635279, 0.167902228347174, 0.10088085360167, 0.0463394230254603, 0.0152718271418522, 0.00322567062868517, 0.000349481832738112, 1.1397897220761e-05, 1.62816541664945e-08, 5.90986807915038e-22, 1.73882341151749e-15, 5.08729439689253e-12, 1.134607176732e-09, 6.42225786578722e-08, 1.53001661534367e-06, 1.98999645696153e-05, 0.000164317502569273, 0.000946882663794141, 0.004053721236037, 0.0134552073183484, 0.0356617238793595, 0.0770007096981355, 0.137186945009978, 0.203007414410917, 0.249670225294215, 0.253695033433399, 0.209981491241174, 0.137905788358767, 0.0686297836932836, 0.0238098081873862, 0.00487745340958924, 0.000395839898174916, 2.99987840645524e-06, 4.27672570671661e-25, 6.67573956740517e-18, 4.8602329130987e-14, 2.04950218625658e-11, 1.90548197800992e-09, 6.854929781477e-08, 1.27473166043322e-06, 1.44999684408177e-05, 0.000112177473723731, 0.000633430247846296, 0.00274120332518803, 0.00941040226629123, 0.0262622167794605, 0.0606044393922564, 0.116925568790199, 0.189670492777368, 0.258744569206029, 0.295023802193696, 0.277024475582545, 0.208179534581908, 0.118630277559386, 0.0459478746406396, 0.00927936309810396, 0.000373089091194685, 1.87569000162143e-28, 1.55331432830608e-20, 2.81412477375446e-16, 2.24371298511359e-13, 3.42639957586012e-11, 1.86134093945178e-09, 4.94881589521934e-08, 7.75472397985045e-07, 8.05436304367766e-06, 5.99873631290451e-05, 0.000338460632681688, 0.0015049778217353, 0.00542855311550756, 0.0162260252431125, 0.0408153136630083, 0.0873270617041032, 0.159936127718908, 0.251217073283094, 0.337263888784338, 0.382718532078574, 0.358221173368138, 0.262333516694199, 0.131835638605654, 0.0281214367583883, 3.77044120685109e-32, 1.6565355268724e-23, 7.46811608812598e-19, 1.12581663176922e-15, 2.82392145570771e-13, 2.31648926615386e-11, 8.80572799405798e-10, 1.90084662005835e-08, 2.65056336158308e-07, 2.6037674249007e-06, 1.91538692005778e-05, 0.000110314716886547, 0.000514302037233644, 0.00199113772036462, 0.00653007589682532, 0.0184280493362109, 0.0453109694421675, 0.0980443769615999, 0.188192793378357, 0.322479710040501, 0.495779312759863, 0.686473186294606, 0.858477523595839, 0.97150245792734, 

0.0001220703125, 0.0015869140625, 0.009521484375, 0.034912109375, 0.0872802734375, 0.1571044921875, 0.20947265625, 0.20947265625, 0.1571044921875, 0.0872802734375, 0.034912109375, 0.009521484375, 0.0015869140625, 0.0001220703125, 

0.0456747239752542, 1.67632342360249e-09, 0.159100570247889, 8.13296144284301e-08, 0.255785215879518, 1.82115751924133e-06, 0.251303954112703, 2.49210587647807e-05, 0.168341728898117, 0.000232516643721428, 0.0811926545592767, 0.00156197507035277, 0.0290073416273297, 0.00777249376361669, 0.00777249376361669, 0.0290073416273297, 0.00156197507035277, 0.0811926545592767, 0.000232516643721428, 0.168341728898117, 2.49210587647807e-05, 0.251303954112703, 1.82115751924133e-06, 0.255785215879518, 8.13296144284301e-08, 0.159100570247889, 1.67632342360249e-09, 0.0456747239752542, 

0.211302999999526, 0.0001220703125, 4.73254047506313e-13, 0.348906999951563, 0.0015869140625, 4.84369760490518e-11, 0.265901997711939, 0.009521484375, 2.28806103464899e-09, 0.123837933949157, 0.034912109375, 6.60508435432911e-08, 0.0393236999570222, 0.0872802734375, 1.3000429780482e-06, 0.00899057660991212, 0.1571044921875, 1.84233900879493e-05, 0.00152260394220921, 0.20947265625, 0.000193396057790809, 0.000193396057790809, 0.20947265625, 0.00152260394220921, 1.84233900879493e-05, 0.1571044921875, 0.00899057660991212, 1.3000429780482e-06, 0.0872802734375, 0.0393236999570222, 6.60508435432911e-08, 0.034912109375, 0.123837933949157, 2.28806103464899e-09, 0.009521484375, 0.265901997711939, 4.84369760490518e-11, 0.0015869140625, 0.348906999951563, 4.73254047506313e-13, 0.0001220703125, 0.211302999999526, 

0.392397677872749, 0.00548141350407144, 5.50609087193674e-07, 8.71491410666274e-16, 0.380610087995483, 0.0350989134461618, 1.45321198993157e-05, 1.51843410378045e-13, 0.170389198258014, 0.103729593795142, 0.000177020053732552, 1.22105910324684e-11, 0.0466148191760909, 0.187340580752205, 0.00131775946449975, 6.00064040719044e-10, 0.0086950989092573, 0.230690454902781, 0.00668834086230226, 2.01060656728213e-08, 0.00116777062299521, 0.204531350090257, 0.0244417979007066, 4.85052880315713e-07, 0.000116173425815927, 0.134324853710468, 0.066162838788686, 8.66796822084312e-06, 8.66796822084306e-06, 0.066162838788686, 0.134324853710468, 0.000116173425815928, 4.8505288031571e-07, 0.0244417979007066, 0.204531350090257, 0.00116777062299521, 2.01060656728211e-08, 0.00668834086230226, 0.230690454902781, 0.00869509890925733, 6.00064040719039e-10, 0.00131775946449975, 0.187340580752205, 0.046614819176091, 1.22105910324683e-11, 0.000177020053732552, 0.103729593795142, 0.170389198258015, 1.51843410378044e-13, 1.45321198993157e-05, 0.0350989134461618, 0.380610087995483, 8.71491410666265e-16, 5.50609087193674e-07, 0.00548141350407144, 0.392397677872749, 

0.535476493763929, 0.0330190778514469, 0.0001220703125, 5.26280965708492e-09, 5.32672037622316e-18, 0.342622619909938, 0.128771584746317, 0.0015869140625, 2.28060077380099e-07, 1.40692511816918e-15, 0.101181135830401, 0.231783778680654, 0.009521484375, 4.56130139458269e-06, 1.71510204720769e-13, 0.0182601041014541, 0.254956575421904, 0.034912109375, 5.57504596458223e-05, 1.27770068443073e-11, 0.0022468574825515, 0.191213245812945, 0.0872802734375, 0.000464597333760313, 6.48988300587217e-10, 0.000199058304025598, 0.103252892481587, 0.1571044921875, 0.0027876450241684, 2.37343370000974e-08, 1.30632519910861e-05, 0.0413002529094647, 0.20947265625, 0.0123898046538254, 6.42959433737083e-07, 6.42959433737078e-07, 0.0123898046538254, 0.20947265625, 0.0413002529094647, 1.30632519910862e-05, 2.37343370000971e-08, 0.0027876450241684, 0.1571044921875, 0.103252892481587, 0.000199058304025599, 6.4898830058721e-10, 0.000464597333760313, 0.0872802734375, 0.191213245812945, 0.00224685748255151, 1.27770068443072e-11, 5.57504596458224e-05, 0.034912109375, 0.254956575421904, 0.0182601041014542, 1.71510204720766e-13, 4.56130139458269e-06, 0.009521484375, 0.231783778680654, 0.101181135830402, 1.40692511816916e-15, 2.28060077380099e-07, 0.0015869140625, 0.128771584746317, 0.342622619909938, 5.32672037622308e-18, 5.26280965708492e-09, 0.0001220703125, 0.0330190778514469, 0.535476493763929, 

0.6398446229377, 0.0895626529142541, 0.00197152139358657, 3.52724097392662e-06, 9.45622632144424e-11, 7.41495325484254e-20, 0.290673272075349, 0.237452799695512, 0.0157546577206278, 7.45957967905689e-05, 6.02773591937748e-09, 2.7584463859079e-17, 0.0609457705608415, 0.290559806666898, 0.0581064507304015, 0.000728117520828873, 1.7733663959517e-07, 4.7361840962024e-15, 0.007809122316094, 0.217277102589605, 0.130966404559779, 0.00434318957518226, 3.18832740480281e-06, 4.96950100818583e-13, 0.000682227869284508, 0.110779898507784, 0.201263045211669, 0.0176638215669731, 3.90837231051168e-05, 3.55521254060384e-11, 4.29130303877893e-05, 0.0406668431801296, 0.222689977043369, 0.0517241125682329, 0.000344954202259344, 1.83126355249626e-09, 1.99947115529514e-06, 0.0110582445646493, 0.182517088789877, 0.112193490281708, 0.00225524216946129, 6.98718698853798e-08, 6.98718698853798e-08, 0.00225524216946129, 0.112193490281708, 0.182517088789877, 0.0110582445646493, 1.99947115529514e-06, 1.83126355249626e-09, 0.000344954202259345, 0.0517241125682329, 0.222689977043369, 0.0406668431801295, 4.29130303877893e-05, 3.55521254060384e-11, 3.9083723105117e-05, 0.0176638215669731, 0.20126304521167, 0.110779898507784, 0.000682227869284508, 4.96950100818583e-13, 3.18832740480282e-06, 0.00434318957518226, 0.130966404559779, 0.217277102589605, 0.007809122316094, 4.7361840962024e-15, 1.77336639595171e-07, 0.000728117520828873, 0.0581064507304015, 0.290559806666897, 0.0609457705608415, 2.7584463859079e-17, 6.02773591937751e-09, 7.45957967905689e-05, 0.0157546577206278, 0.237452799695512, 0.290673272075349, 7.41495325484254e-20, 9.45622632144428e-11, 3.52724097392662e-06, 0.00197152139358657, 0.0895626529142541, 0.6398446229377, 

0.715280778882588, 0.165468900620599, 0.0102281571590821, 0.0001220703125, 1.40380068025201e-07, 2.8048911726315e-12, 1.8752687713594e-21, 0.242791953325368, 0.319254206829006, 0.0561956763969701, 0.0015869140625, 4.31803981694335e-06, 2.45687167284827e-10, 9.33668037364837e-19, 0.0380364451640523, 0.284292088527023, 0.142500474836108, 0.009521484375, 6.13021540177001e-05, 9.9324600854539e-09, 2.14550415544257e-16, 0.0036415454443213, 0.154708116703898, 0.220825844556059, 0.034912109375, 0.000531844909981632, 2.45386894243807e-07, 3.01291173122503e-14, 0.00023770598947684, 0.0574023936999505, 0.233320053271184, 0.0872802734375, 0.00314602998576785, 4.13346702825639e-06, 2.88477559324752e-12, 1.11718992866943e-05, 0.0153348454388417, 0.177495247917627, 0.1571044921875, 0.013399025222632, 5.01314294023754e-05, 1.98870404955718e-10, 3.88937779651843e-07, 0.00303455514883954, 0.100020178423779, 0.20947265625, 0.0422717067469068, 0.000450372567565513, 1.01553410408475e-08, 1.01553410408473e-08, 0.000450372567565513, 0.0422717067469068, 0.20947265625, 0.100020178423779, 0.00303455514883954, 3.88937779651849e-07, 1.98870404955715e-10, 5.01314294023754e-05, 0.013399025222632, 0.1571044921875, 0.177495247917627, 0.0153348454388417, 1.11718992866944e-05, 2.88477559324747e-12, 4.13346702825639e-06, 0.00314602998576785, 0.0872802734375, 0.233320053271184, 0.0574023936999505, 0.000237705989476842, 3.01291173122496e-14, 2.45386894243807e-07, 0.000531844909981632, 0.034912109375, 0.220825844556059, 0.154708116703898, 0.00364154544432132, 2.14550415544252e-16, 9.9324600854539e-09, 6.13021540177001e-05, 0.009521484375, 0.142500474836108, 0.284292088527023, 0.0380364451640525, 9.33668037364812e-19, 2.45687167284827e-10, 4.31803981694335e-06, 0.0015869140625, 0.0561956763969701, 0.319254206829006, 0.242791953325369, 1.87526877135934e-21, 2.8048911726315e-12, 1.40380068025201e-07, 0.0001220703125, 0.0102281571590821, 0.165468900620599, 0.715280778882588, 

0.770502160898972, 0.248134469172661, 0.0295861707196478, 0.00109014852737905, 8.75976432229061e-06, 7.5386786726566e-09, 1.23972927001293e-13, 7.45296344007225e-23, 0.20290762950129, 0.365066489658058, 0.119623698184838, 0.00977857785326746, 0.000165039956728181, 3.15103677226319e-07, 1.42406131060898e-11, 4.78289866189183e-20, 0.0246621418517282, 0.247893272079987, 0.223230528931612, 0.0404830869432664, 0.00143513804787198, 6.07882454531143e-06, 7.54985165065255e-10, 1.41664575918449e-17, 0.00183182248557201, 0.102867382748839, 0.254571705474733, 0.102421639785408, 0.00762637990826454, 7.16648053317709e-05, 2.44606688842998e-08, 2.56419785454231e-15, 9.27693595056825e-05, 0.0291044380753294, 0.197940769424085, 0.176676345072983, 0.0276319650880639, 0.000576050848724365, 5.4033962576028e-07, 3.1645384535063e-13, 3.38265905906988e-06, 0.00592888796227275, 0.110813551142835, 0.219430799009843, 0.0720837884743204, 0.00333386655725197, 8.59404855338991e-06, 2.81191195769307e-11, 9.13646358371213e-08, 0.000894650687477093, 0.0459533019139972, 0.201875211250174, 0.139293120318108, 0.0142922905300435, 0.000101249997178613, 1.85079914999143e-09, 1.85079914999143e-09, 0.000101249997178613, 0.0142922905300435, 0.139293120318109, 0.201875211250174, 0.0459533019139971, 0.000894650687477093, 9.13646358371212e-08, 2.81191195769307e-11, 8.59404855338991e-06, 0.00333386655725197, 0.0720837884743205, 0.219430799009843, 0.110813551142835, 0.00592888796227275, 3.38265905906988e-06, 3.1645384535063e-13, 5.4033962576028e-07, 0.000576050848724365, 0.027631965088064, 0.176676345072983, 0.197940769424085, 0.0291044380753294, 9.27693595056825e-05, 2.56419785454231e-15, 2.44606688842998e-08, 7.16648053317709e-05, 0.00762637990826455, 0.102421639785408, 0.254571705474733, 0.102867382748839, 0.00183182248557201, 1.41664575918449e-17, 7.54985165065255e-10, 6.07882454531143e-06, 0.00143513804787198, 0.0404830869432664, 0.223230528931612, 0.247893272079987, 0.0246621418517282, 4.78289866189183e-20, 1.42406131060898e-11, 3.15103677226319e-07, 0.000165039956728182, 0.00977857785326746, 0.119623698184838, 0.365066489658058, 0.20290762950129, 7.45296344007225e-23, 1.23972927001293e-13, 7.5386786726566e-09, 8.75976432229062e-06, 0.00109014852737905, 0.0295861707196478, 0.248134469172661, 0.770502160898972, 

0.811700770887099, 0.328889881240803, 0.0612571479534902, 0.00470147804786693, 0.0001220703125, 7.47825312097351e-07, 5.26539889579547e-10, 7.55977875097312e-15, 4.21907606112476e-24, 0.170705946106715, 0.381834611899172, 0.190835735225588, 0.0311882146689779, 0.0015869140625, 1.90515696732584e-05, 2.85637387983601e-08, 1.10045175901909e-12, 3.39040335395706e-21, 0.0165694936709675, 0.204601103699054, 0.274391421854899, 0.0954892572082059, 0.009521484375, 0.000224010958262878, 7.15165780588183e-07, 7.39334258613158e-11, 1.25745740055107e-18, 0.00098285625548633, 0.0669978446213856, 0.241102402453337, 0.178664675687558, 0.034912109375, 0.00160963699260952, 1.09425509942354e-05, 3.03550415962771e-09, 2.85006899382423e-16, 3.9750203190957e-05, 0.0149583010198371, 0.144444537915465, 0.227924732571601, 0.0872802734375, 0.00788597150072706, 0.000114156070374496, 8.49746554457464e-08, 4.40439279909301e-14, 1.15750052393692e-06, 0.00240456323451069, 0.0623064785391685, 0.209351804618906, 0.1571044921875, 0.0278172989891412, 0.00085745618689396, 1.71269680937825e-06, 4.90059949388267e-12, 2.49671672811687e-08, 0.000286323087048988, 0.0199081782349791, 0.14243876363366, 0.20947265625, 0.0726843557274982, 0.00477079875875037, 2.55704161780793e-05, 4.03904423251809e-10, 4.03904423251799e-10, 2.55704161780793e-05, 0.00477079875875035, 0.0726843557274982, 0.20947265625, 0.14243876363366, 0.0199081782349791, 0.000286323087048988, 2.49671672811693e-08, 4.90059949388254e-12, 1.71269680937825e-06, 0.000857456186893958, 0.0278172989891412, 0.1571044921875, 0.209351804618906, 0.0623064785391686, 0.00240456323451069, 1.15750052393694e-06, 4.40439279909288e-14, 8.49746554457464e-08, 0.000114156070374496, 0.00788597150072706, 0.0872802734375, 0.227924732571601, 0.144444537915465, 0.0149583010198371, 3.97502031909576e-05, 2.85006899382413e-16, 3.03550415962771e-09, 1.09425509942354e-05, 0.00160963699260952, 0.034912109375, 0.178664675687558, 0.241102402453337, 0.0669978446213856, 0.00098285625548634, 1.25745740055102e-18, 7.39334258613158e-11, 7.15165780588181e-07, 0.000224010958262878, 0.009521484375, 0.0954892572082059, 0.274391421854899, 0.204601103699054, 0.0165694936709676, 3.39040335395692e-21, 1.10045175901909e-12, 2.856373879836e-08, 1.90515696732584e-05, 0.0015869140625, 0.0311882146689779, 0.190835735225588, 0.381834611899172, 0.170705946106715, 4.21907606112457e-24, 7.55977875097312e-15, 5.26539889579545e-10, 7.47825312097351e-07, 0.0001220703125, 0.00470147804786693, 0.0612571479534902, 0.328889881240803, 0.811700770887099, 

0.843054480857821, 0.40329863308361, 0.103192030510352, 0.0131634011547062, 0.000741571339035607, 1.50150905144256e-05, 7.57271065652373e-08, 4.61282828946623e-11, 6.00203287034957e-16, 3.17339590680732e-25, 0.144878610298924, 0.379320558008714, 0.256084588917743, 0.0676434212070652, 0.00714196050104975, 0.000263481514815696, 2.49046601505986e-06, 3.14135275425762e-09, 1.07846348057728e-13, 3.12077408817781e-22, 0.0114910787264479, 0.164662198478172, 0.293311186727103, 0.160431968051891, 0.0317460612331785, 0.00213393038207007, 3.78022608171652e-05, 9.87356580465282e-08, 8.94376573913999e-12, 1.41647300951934e-19, 0.000556977316801354, 0.0436819098703467, 0.20530238310259, 0.232528632456328, 0.0862347751433117, 0.0105616196149001, 0.00035065102177498, 1.89649421510011e-06, 4.5326852992935e-10, 3.92893148908718e-17, 1.8406990810573e-05, 0.00790092438650464, 0.0979778561324406, 0.229789691466497, 0.159714225277415, 0.0356409585252239, 0.00221769093628593, 2.48369119608785e-05, 1.56624355762549e-08, 7.43034854667539e-15, 4.37986353026611e-07, 0.00102893203546993, 0.0336662210443453, 0.163499768856264, 0.212979233421464, 0.0865965769510718, 0.0100985595481008, 0.000234194218682762, 3.89668701503215e-07, 1.01175745539136e-12, 7.71977412807758e-09, 9.92571278466489e-05, 0.00856893878426476, 0.0861727545399658, 0.210376464078406, 0.155854126927543, 0.0340630923071823, 0.0016357652331641, 7.18121587875313e-06, 1.02049262796748e-10, 1.02049262796748e-10, 7.18121587875318e-06, 0.0016357652331641, 0.0340630923071823, 0.155854126927543, 0.210376464078406, 0.0861727545399658, 0.00856893878426476, 9.92571278466484e-05, 7.71977412807758e-09, 1.01175745539136e-12, 3.89668701503218e-07, 0.000234194218682762, 0.0100985595481008, 0.0865965769510718, 0.212979233421464, 0.163499768856264, 0.0336662210443453, 0.00102893203546993, 4.37986353026611e-07, 7.43034854667539e-15, 1.5662435576255e-08, 2.48369119608785e-05, 0.00221769093628593, 0.0356409585252239, 0.159714225277415, 0.229789691466497, 0.0979778561324406, 0.00790092438650462, 1.8406990810573e-05, 3.92893148908718e-17, 4.53268529929353e-10, 1.89649421510011e-06, 0.00035065102177498, 0.0105616196149001, 0.0862347751433117, 0.232528632456328, 0.20530238310259, 0.0436819098703466, 0.000556977316801354, 1.41647300951934e-19, 8.94376573914007e-12, 9.87356580465282e-08, 3.78022608171652e-05, 0.00213393038207007, 0.0317460612331785, 0.160431968051891, 0.293311186727103, 0.164662198478171, 0.0114910787264479, 3.12077408817781e-22, 1.07846348057729e-13, 3.14135275425762e-09, 2.49046601505986e-06, 0.000263481514815696, 0.00714196050104975, 0.0676434212070652, 0.256084588917744, 0.379320558008714, 0.144878610298924, 3.17339590680732e-25, 6.00203287034963e-16, 4.61282828946623e-11, 7.57271065652373e-08, 1.50150905144256e-05, 0.000741571339035607, 0.0131634011547062, 0.103192030510352, 0.40329863308361, 0.843054480857821, 

0.867370035229458, 0.469712428192987, 0.151951657966726, 0.0280038923100786, 0.00271660907815672, 0.0001220703125, 2.05749775426793e-06, 8.98188730612201e-09, 4.91088299167464e-12, 5.9361009453051e-17, 3.01382214286561e-26, 0.124095626231135, 0.365449088197846, 0.308094346773529, 0.115248363387585, 0.0203197141410203, 0.0015869140625, 4.64874397123463e-05, 3.6883993639636e-07, 4.09324749581268e-10, 1.28941628522802e-14, 3.56001857195574e-23, 0.0081943862964431, 0.131228937322769, 0.28831677668654, 0.218906689274268, 0.0701481041923273, 0.009521484375, 0.000484774519443393, 6.99062769554069e-06, 1.57465102809233e-08, 1.29268563419524e-12, 1.940862665192e-20, 0.000330671352659093, 0.0287973497718546, 0.164883151051313, 0.254099305961265, 0.147990713090798, 0.034912109375, 0.00308932871343925, 8.09682192899043e-05, 3.70186705067255e-07, 7.91977555528453e-11, 6.46632499537379e-18, 9.09798651232984e-06, 0.00430867769993663, 0.0642911540178017, 0.20110205248571, 0.212873482728467, 0.0872802734375, 0.0134232301216483, 0.00063941317580368, 5.93370419123788e-06, 3.30827348120437e-09, 1.46888849393748e-15, 1.80229758935263e-07, 0.000464160300919583, 0.0180492292279831, 0.114594038184795, 0.220465767518966, 0.1571044921875, 0.0419935361370649, 0.0036356416547557, 6.8479954471505e-05, 9.94998508736622e-08, 2.40244041955701e-13, 2.64468496627056e-09, 3.70389109389083e-05, 0.00375346466084213, 0.0483697425711212, 0.169132471532401, 0.20947265625, 0.0973137232888008, 0.0153125243258094, 0.000585419609152126, 2.21671411927481e-06, 2.91060086808282e-11, 2.91060086808272e-11, 2.21671411927481e-06, 0.000585419609152128, 0.0153125243258094, 0.0973137232888007, 0.20947265625, 0.169132471532401, 0.0483697425711211, 0.00375346466084212, 3.70389109389083e-05, 2.64468496627064e-09, 2.40244041955691e-13, 9.94998508736622e-08, 6.84799544715052e-05, 0.00363564165475571, 0.0419935361370648, 0.1571044921875, 0.220465767518966, 0.114594038184795, 0.018049229227983, 0.000464160300919583, 1.80229758935267e-07, 1.46888849393741e-15, 3.30827348120437e-09, 5.9337041912379e-06, 0.000639413175803681, 0.0134232301216483, 0.0872802734375, 0.212873482728467, 0.20110205248571, 0.0642911540178016, 0.00430867769993663, 9.09798651233002e-06, 6.46632499537347e-18, 7.91977555528453e-11, 3.70186705067257e-07, 8.09682192899045e-05, 0.00308932871343924, 0.034912109375, 0.147990713090798, 0.254099305961265, 0.164883151051313, 0.0287973497718546, 0.000330671352659098, 1.94086266519189e-20, 1.29268563419524e-12, 1.57465102809233e-08, 6.99062769554071e-06, 0.000484774519443392, 0.009521484375, 0.0701481041923273, 0.218906689274267, 0.28831677668654, 0.131228937322769, 0.00819438629644319, 3.56001857195552e-23, 1.28941628522802e-14, 4.0932474958127e-10, 3.68839936396361e-07, 4.64874397123463e-05, 0.0015869140625, 0.0203197141410203, 0.115248363387585, 0.308094346773529, 0.365449088197846, 0.124095626231136, 3.01382214286541e-26, 5.9361009453051e-17, 4.91088299167466e-12, 8.98188730612204e-09, 2.05749775426792e-06, 0.0001220703125, 0.00271660907815672, 0.0280038923100786, 0.151951657966726, 0.469712428192987, 0.867370035229458, 

0.886555265960281, 0.527992814555671, 0.20415126116026, 0.0495725350419996, 0.00716199254362546, 0.000565931790514132, 2.14391965330937e-05, 3.14367136199943e-07, 1.22917162956834e-09, 6.18672032027591e-13, 7.06701381838485e-18, 3.47782544975831e-27, 0.107247648571094, 0.345635329751718, 0.345030593597388, 0.167546795852772, 0.0430306066350116, 0.00571948615776816, 0.000358510836525191, 8.84260528010338e-06, 6.14616526649002e-08, 6.18645203342073e-11, 1.82445236642009e-15, 4.85861538032302e-24, 0.0059879427881353, 0.104427803280542, 0.269135534056586, 0.261359940943853, 0.119324320781812, 0.0266782804711527, 0.00276696692235413, 0.000114797184764809, 1.41841670780436e-06, 2.85516173455376e-09, 2.1738872519643e-13, 3.13274581243578e-21, 0.000204309088165304, 0.0192812122990637, 0.128293501342361, 0.249150693229541, 0.202209079999111, 0.076046430686581, 0.0130504602284027, 0.000910756787025702, 2.00043121444141e-05, 8.0526710580756e-08, 1.58292989975652e-11, 1.23440586266937e-18, 4.75298350488213e-06, 0.00242728688261238, 0.0416971961333478, 0.161939858197919, 0.233636619506167, 0.147797951214784, 0.0419678060077167, 0.00492654181300527, 0.000192358767238663, 1.54852343352857e-06, 7.85877631275626e-10, 3.31634246111985e-16, 7.9611796657673e-08, 0.000220008964880674, 0.00975756703166947, 0.0757840665820714, 0.194363034447547, 0.20681902640228, 0.0971715657071646, 0.0191873247593104, 0.00133178109038932, 2.14401639029239e-05, 2.80918712213825e-08, 6.41494982279426e-14, 9.87767595214812e-10, 1.47715435102711e-05, 0.00169138496565752, 0.0262704969684742, 0.119771271268294, 0.214377299752389, 0.166658844625835, 0.0553544973019082, 0.00682998790606484, 0.000219889581037509, 7.43828204208101e-07, 9.19164806396542e-12, 9.1916480639658e-12, 7.43828204208095e-07, 0.000219889581037508, 0.00682998790606483, 0.0553544973019081, 0.166658844625835, 0.214377299752389, 0.119771271268294, 0.0262704969684742, 0.00169138496565752, 1.47715435102712e-05, 9.87767595214776e-10, 6.41494982279457e-14, 2.80918712213822e-08, 2.14401639029238e-05, 0.00133178109038932, 0.0191873247593104, 0.0971715657071646, 0.20681902640228, 0.194363034447547, 0.0757840665820715, 0.0097575670316695, 0.000220008964880675, 7.96117966576706e-08, 3.31634246112003e-16, 7.85877631275617e-10, 1.54852343352856e-06, 0.000192358767238662, 0.00492654181300526, 0.0419678060077167, 0.147797951214784, 0.233636619506167, 0.161939858197919, 0.0416971961333478, 0.00242728688261239, 4.75298350488201e-06, 1.23440586266944e-18, 1.5829298997565e-11, 8.05267105807556e-08, 2.00043121444141e-05, 0.0009107567870257, 0.0130504602284027, 0.076046430686581, 0.202209079999111, 0.249150693229541, 0.128293501342361, 0.0192812122990638, 0.0002043090881653, 3.13274581243599e-21, 2.17388725196427e-13, 2.85516173455374e-09, 1.41841670780435e-06, 0.000114797184764809, 0.00276696692235413, 0.0266782804711527, 0.119324320781812, 0.261359940943853, 0.269135534056586, 0.104427803280542, 0.00598794278813523, 4.85861538032337e-24, 1.82445236642006e-15, 6.1864520334207e-11, 6.14616526649e-08, 8.84260528010337e-06, 0.000358510836525191, 0.00571948615776816, 0.0430306066350116, 0.167546795852772, 0.345030593597388, 0.345635329751718, 0.107247648571093, 3.47782544975858e-27, 7.06701381838474e-18, 6.18672032027587e-13, 1.22917162956834e-09, 3.14367136199943e-07, 2.14391965330937e-05, 0.000565931790514132, 0.00716199254362546, 0.0495725350419996, 0.20415126116026, 0.527992814555671, 0.886555265960281, 

0.901929577119877, 0.578708174052518, 0.257098917592295, 0.0772079601233041, 0.0150842004841237, 0.00180917188995561, 0.0001220703125, 4.05161339673134e-06, 5.33059862854782e-08, 1.91239441118274e-10, 9.02142558497167e-14, 9.85765213483465e-19, 4.7337357940276e-28, 0.0934666887492396, 0.32328157932963, 0.368112133855865, 0.218574212307142, 0.0746621595283756, 0.0147091788021691, 0.0015869140625, 8.42182295063104e-05, 1.82005468335025e-06, 1.14163513663101e-08, 1.06483419918047e-11, 2.98221431480555e-16, 7.71980786124449e-25, 0.00447042675240816, 0.0833508819655238, 0.243258439252618, 0.28559043877813, 0.170563734642271, 0.0551956587861411, 0.009521484375, 0.000807964192190656, 2.86814291592058e-05, 3.14546665664284e-07, 5.8009177633565e-10, 4.16401332664814e-14, 5.81054495850063e-22, 0.000130665606810106, 0.0131328692410443, 0.0982371781551104, 0.228038715207531, 0.238118438627602, 0.12657315199773, 0.034912109375, 0.00473694454710745, 0.000276208678036448, 5.29618351182286e-06, 1.93121936079792e-08, 3.55308462281122e-12, 2.67268281037285e-19, 2.60400716073429e-06, 0.00141083952809913, 0.027049075128593, 0.124148674049673, 0.22665637249658, 0.197900480008523, 0.0872802734375, 0.0189353381728795, 0.00181360384954612, 6.08008348047364e-05, 4.38364203538787e-07, 2.06712895160968e-10, 8.38197870800576e-17, 3.73641885593289e-08, 0.000109125969276755, 0.00536242779890384, 0.0486640312065907, 0.155337151849166, 0.222784307303814, 0.1571044921875, 0.0544979702152056, 0.00857393200481271, 0.000502560737063651, 7.16425532843951e-06, 8.65888724999042e-09, 1.89268431285326e-14, 3.97132260232971e-10, 6.25237245253741e-06, 0.000787474912604854, 0.0141299397463263, 0.0788585838319341, 0.185775558909814, 0.20947265625, 0.116186005331567, 0.0300250592177229, 0.00307704467166765, 8.67307814534285e-05, 2.68672261591372e-07, 3.16574582907066e-12, 3.16574582907082e-12, 2.68672261591375e-07, 8.67307814534281e-05, 0.00307704467166765, 0.0300250592177229, 0.116186005331567, 0.20947265625, 0.185775558909814, 0.0788585838319341, 0.0141299397463263, 0.000787474912604857, 6.25237245253736e-06, 3.97132260232954e-10, 1.89268431285337e-14, 8.65888724999051e-09, 7.16425532843947e-06, 0.000502560737063652, 0.00857393200481271, 0.0544979702152056, 0.1571044921875, 0.222784307303814, 0.155337151849166, 0.0486640312065907, 0.00536242779890386, 0.000109125969276754, 3.73641885593276e-08, 8.38197870800629e-17, 2.0671289516097e-10, 4.38364203538785e-07, 6.08008348047366e-05, 0.00181360384954612, 0.0189353381728795, 0.0872802734375, 0.197900480008523, 0.22665637249658, 0.124148674049672, 0.0270490751285931, 0.00141083952809913, 2.60400716073422e-06, 2.67268281037303e-19, 3.55308462281127e-12, 1.93121936079791e-08, 5.29618351182288e-06, 0.000276208678036448, 0.00473694454710745, 0.034912109375, 0.12657315199773, 0.238118438627602, 0.228038715207531, 0.0982371781551106, 0.0131328692410442, 0.000130665606810103, 5.81054495850108e-22, 4.1640133266482e-14, 5.80091776335646e-10, 3.14546665664285e-07, 2.86814291592058e-05, 0.000807964192190656, 0.009521484375, 0.0551956587861411, 0.170563734642271, 0.28559043877813, 0.243258439252618, 0.0833508819655235, 0.0044704267524081, 7.71980786124514e-25, 2.9822143148056e-16, 1.06483419918047e-11, 1.14163513663102e-08, 1.82005468335025e-06, 8.42182295063104e-05, 0.0015869140625, 0.0147091788021691, 0.0746621595283756, 0.218574212307141, 0.368112133855865, 0.323281579329629, 0.0934666887492389, 4.73373579402803e-28, 9.85765213483482e-19, 9.0214255849716e-14, 1.91239441118275e-10, 5.33059862854782e-08, 4.05161339673134e-06, 0.0001220703125, 0.00180917188995561, 0.0150842004841237, 0.0772079601233041, 0.257098917592295, 0.578708174052518, 0.901929577119877, 

0.914422677810445, 0.622694144452119, 0.308910908795491, 0.109669610233118, 0.0270957252733111, 0.00446964839094741, 0.000463347609093639, 2.76061192697975e-05, 8.25260084726878e-07, 9.96225305662309e-09, 3.33734124189286e-11, 1.49498104174594e-14, 1.576623578726e-19, 7.42413729075041e-29, 0.0820885475865892, 0.30041010483376, 0.379778724261451, 0.264226825663911, 0.112688414943389, 0.0299923409803533, 0.00484871972887206, 0.000445832690425544, 2.07845458834534e-05, 4.04823563969029e-07, 2.34097465984493e-09, 2.05506235453182e-12, 5.52299902836381e-17, 1.39764577342633e-25, 0.00340115209388099, 0.066890153097282, 0.215494363677235, 0.293815980219792, 0.21630455160839, 0.0928870707975419, 0.0234182875442295, 0.00332312255024404, 0.000241600672177659, 7.59244923411412e-06, 7.57880456442146e-08, 1.30383375484609e-10, 8.92955495691607e-15, 1.21438427418477e-22, 8.61171631554995e-05, 0.0091018573172001, 0.0747242181814915, 0.199661393655423, 0.253730237669618, 0.175800598924375, 0.0691199423521695, 0.0151370409338732, 0.00171623168794108, 8.70198217934316e-05, 1.49942546894478e-06, 5.05521483510106e-09, 8.82276765163654e-13, 6.44815300116018e-20, 1.48669525366527e-06, 0.000844435406272981, 0.017666699514318, 0.0925084409665764, 0.202930522021675, 0.226857954186197, 0.139097773532291, 0.0470115089804465, 0.00831232036020531, 0.000680022152583607, 2.02263555414444e-05, 1.33636653519471e-07, 5.94358459151083e-11, 2.33444212374526e-17, 1.84793500078662e-08, 5.64073039130516e-05, 0.00300733605668808, 0.0308603695248251, 0.116857076024026, 0.210775519642988, 0.201543820193071, 0.105123519855491, 0.0289868568354976, 0.00382613622162497, 0.000196445862907288, 2.54357216012144e-06, 2.88286662617965e-09, 6.08503926668266e-15, 1.70144399812807e-10, 2.7910684123232e-06, 0.000379205590869545, 0.00762582989831521, 0.0498458366014381, 0.145061631481124, 0.216314197834733, 0.17412528007579, 0.0748766162346834, 0.0159464504270997, 0.00141330003172656, 3.58615259741908e-05, 1.03577848193332e-07, 1.17492431181308e-12, 1.17492431181308e-12, 1.03577848193333e-07, 3.58615259741908e-05, 0.00141330003172656, 0.0159464504270997, 0.0748766162346834, 0.17412528007579, 0.216314197834734, 0.145061631481124, 0.0498458366014381, 0.00762582989831523, 0.000379205590869545, 2.79106841232318e-06, 1.70144399812807e-10, 6.08503926668266e-15, 2.88286662617969e-09, 2.54357216012144e-06, 0.000196445862907287, 0.00382613622162496, 0.0289868568354976, 0.105123519855491, 0.201543820193071, 0.210775519642988, 0.116857076024026, 0.0308603695248251, 0.00300733605668808, 5.64073039130512e-05, 1.84793500078662e-08, 2.33444212374526e-17, 5.94358459151092e-11, 1.33636653519471e-07, 2.02263555414444e-05, 0.000680022152583606, 0.00831232036020531, 0.0470115089804465, 0.139097773532291, 0.226857954186197, 0.202930522021676, 0.0925084409665766, 0.017666699514318, 0.000844435406272976, 1.48669525366527e-06, 6.44815300116018e-20, 8.82276765163668e-13, 5.05521483510106e-09, 1.49942546894478e-06, 8.70198217934314e-05, 0.00171623168794108, 0.0151370409338732, 0.0691199423521695, 0.175800598924375, 0.253730237669618, 0.199661393655423, 0.0747242181814915, 0.00910185731720006, 8.61171631554995e-05, 1.21438427418477e-22, 8.92955495691622e-15, 1.30383375484609e-10, 7.57880456442143e-08, 7.5924492341141e-06, 0.000241600672177659, 0.00332312255024404, 0.0234182875442295, 0.0928870707975419, 0.21630455160839, 0.293815980219792, 0.215494363677235, 0.0668901530972818, 0.00340115209388099, 1.39764577342633e-25, 5.52299902836391e-17, 2.05506235453182e-12, 2.34097465984492e-09, 4.04823563969028e-07, 2.07845458834534e-05, 0.000445832690425544, 0.00484871972887206, 0.0299923409803533, 0.112688414943389, 0.264226825663911, 0.379778724261451, 0.300410104833759, 0.0820885475865892, 7.42413729075041e-29, 1.57662357872603e-19, 1.49498104174594e-14, 3.33734124189285e-11, 9.96225305662306e-09, 8.25260084726878e-07, 2.76061192697974e-05, 0.000463347609093639, 0.00446964839094741, 0.0270957252733111, 0.109669610233118, 0.308910908795491, 0.622694144452119, 0.914422677810445, 

0.92470189716155, 0.660833322255746, 0.358398946130421, 0.145533272250972, 0.0433311739662252, 0.00917569674097203, 0.00132306598135892, 0.0001220703125, 6.58182801326452e-06, 1.80860597834553e-07, 2.03667186299795e-09, 6.45470768920817e-12, 2.77267028169406e-15, 2.84108000134374e-20, 1.31669541213293e-29, 0.072607636325214, 0.27816095783465, 0.382659499920768, 0.302353108415477, 0.153836991348086, 0.0518366142839114, 0.0114380748522536, 0.0015869140625, 0.000128665408470068, 5.41044629470438e-06, 9.69499179865721e-08, 5.25062667436482e-10, 4.38873296247226e-13, 1.14068551987993e-17, 2.83394538670734e-26, 0.00263130231179632, 0.0540391252571198, 0.188567209114411, 0.289917532273524, 0.252074548440602, 0.135158107482948, 0.0456385947496963, 0.009521484375, 0.00116087370607535, 7.47016366579454e-05, 2.13001041288563e-06, 1.97130398469739e-08, 3.20618061164139e-11, 2.11376300233876e-15, 2.81517585528638e-23, 5.82746099992236e-05, 0.00641564947267299, 0.0567858364313392, 0.169884869523112, 0.252416301018749, 0.215361345748468, 0.111283755419941, 0.034912109375, 0.00640071258048998, 0.000630300023834484, 2.85980345920718e-05, 4.5228922238964e-07, 1.43138674300277e-09, 2.39368410360188e-13, 1.70899094454773e-20, 8.79947136478268e-07, 0.000519327742467308, 0.0116595679876651, 0.0678740088601278, 0.172335352453197, 0.233970977194798, 0.185011984149382, 0.0872802734375, 0.0240624727837045, 0.00362604432250989, 0.000261793720984259, 7.07534231648199e-06, 4.3570703876064e-08, 1.84818719726709e-11, 7.07363379125148e-18, 9.56679098092234e-09, 3.02673859874007e-05, 0.00172368295733071, 0.0195247192172399, 0.0847156898402231, 0.183015856188353, 0.221462625769596, 0.1571044921875, 0.0651305404224197, 0.0150193587034139, 0.00172549919578615, 7.96913475281477e-05, 9.54914873136722e-07, 1.02744261697752e-09, 2.10803530142187e-15, 7.70446027094672e-11, 1.30669593070724e-06, 0.000188755036050603, 0.00416037353253807, 0.0308474705381697, 0.106042920105805, 0.196366437150739, 0.20947265625, 0.13058561519786, 0.0460824862614356, 0.00842435244638216, 0.00066487670338532, 1.55024725470565e-05, 4.23092596112596e-08, 4.65349678264405e-13, 4.65349678264375e-13, 4.23092596112596e-08, 1.55024725470564e-05, 0.000664876703385322, 0.00842435244638217, 0.0460824862614356, 0.13058561519786, 0.20947265625, 0.196366437150739, 0.106042920105805, 0.0308474705381697, 0.00416037353253806, 0.000188755036050604, 1.30669593070724e-06, 7.70446027094714e-11, 2.10803530142171e-15, 1.02744261697752e-09, 9.54914873136716e-07, 7.9691347528148e-05, 0.00172549919578615, 0.0150193587034139, 0.0651305404224198, 0.1571044921875, 0.221462625769596, 0.183015856188353, 0.0847156898402231, 0.0195247192172398, 0.00172368295733071, 3.02673859874007e-05, 9.56679098092278e-09, 7.07363379125089e-18, 1.84818719726709e-11, 4.35707038760637e-08, 7.07534231648201e-06, 0.000261793720984259, 0.00362604432250989, 0.0240624727837045, 0.0872802734375, 0.185011984149382, 0.233970977194798, 0.172335352453197, 0.0678740088601277, 0.0116595679876651, 0.000519327742467308, 8.799471364783e-07, 1.70899094454757e-20, 2.39368410360188e-13, 1.43138674300276e-09, 4.52289222389642e-07, 2.85980345920718e-05, 0.000630300023834484, 0.00640071258048998, 0.034912109375, 0.111283755419941, 0.215361345748468, 0.252416301018749, 0.169884869523112, 0.0567858364313393, 0.00641564947267299, 5.82746099992252e-05, 2.8151758552861e-23, 2.11376300233876e-15, 3.20618061164137e-11, 1.9713039846974e-08, 2.13001041288563e-06, 7.47016366579454e-05, 0.00116087370607535, 0.009521484375, 0.0456385947496963, 0.135158107482948, 0.252074548440602, 0.289917532273524, 0.188567209114411, 0.0540391252571198, 0.00263130231179637, 2.83394538670703e-26, 1.14068551987993e-17, 4.38873296247222e-13, 5.25062667436485e-10, 9.69499179865721e-08, 5.41044629470439e-06, 0.000128665408470068, 0.0015869140625, 0.0114380748522536, 0.0518366142839114, 0.153836991348086, 0.302353108415477, 0.382659499920768, 0.27816095783465, 0.0726076363252147, 1.31669541213278e-29, 2.84108000134374e-20, 2.77267028169403e-15, 6.45470768920821e-12, 2.03667186299795e-09, 1.80860597834553e-07, 6.58182801326452e-06, 0.0001220703125, 0.00132306598135892, 0.00917569674097203, 0.0433311739662252, 0.145533272250972, 0.358398946130421, 0.660833322255746, 0.92470189716155, 

0.933254702009825, 0.693954822070609, 0.404897796012441, 0.183448200949085, 0.0635183098168614, 0.0164256602673722, 0.00307190783911794, 0.000397244694972286, 3.33398424397469e-05, 1.65708336921185e-06, 4.25036289461543e-08, 4.52129186405369e-10, 1.36912212095359e-12, 5.68184861694365e-16, 5.68567235525078e-21, 2.60068817282191e-30, 0.0646381290294784, 0.257131550126075, 0.379106647215628, 0.332298399980778, 0.195029822178954, 0.0793760548054833, 0.0223852531260389, 0.00426800533445562, 0.000524425016121333, 3.84306062744276e-05, 1.48643541032535e-06, 2.48855449885781e-08, 1.27736231372577e-10, 1.02555835372531e-13, 2.59324986383114e-18, 6.34580024004484e-27, 0.00206626141433203, 0.0439731357148409, 0.163826926633557, 0.277811961821895, 0.276382801326153, 0.177037016114967, 0.0752876489030125, 0.0211640948441837, 0.00380724789701771, 0.000411356165638053, 2.39924153864767e-05, 6.32178420885054e-07, 5.50039537875695e-09, 8.54356233849118e-12, 5.45902139440538e-16, 7.14648372523621e-24, 4.0364719074466e-05, 0.00459557316092461, 0.0432642668641769, 0.141936408744158, 0.239354272470303, 0.241300839451077, 0.154741086066585, 0.0641349299445585, 0.0168911450256379, 0.00269078480458055, 0.000236658485605721, 9.81414247636898e-06, 1.44741776329547e-07, 4.34948451268283e-10, 7.02272090241329e-14, 4.91834060616229e-21, 5.3763456373846e-07, 0.00032746169906956, 0.00779008132833387, 0.0494430509965465, 0.141331813590592, 0.224244687241961, 0.216848351253403, 0.132512890859281, 0.0510946706711851, 0.0120007530788675, 0.00159161773078774, 0.000103880403528426, 2.5969432904865e-06, 1.50975043413444e-08, 6.15977146859761e-12, 2.30788078778611e-18, 5.15590520986796e-09, 1.68001760898706e-05, 0.00100992036801758, 0.012400785856873, 0.0600857070784257, 0.150043777331479, 0.218795862290777, 0.197130638585331, 0.111281921045891, 0.0385363457659803, 0.00770704602466031, 0.000791675844273979, 3.35477602252614e-05, 3.77315836863043e-07, 3.89005988594301e-10, 7.79723527331624e-16, 3.66259500771171e-11, 6.38459551040343e-07, 9.69836448996459e-05, 0.00230387751038115, 0.0189220703177727, 0.0743669631029123, 0.163526565843561, 0.217228278513938, 0.179531167724987, 0.0916639971727963, 0.0276441580892687, 0.00446917531456447, 0.000321019065491213, 6.98507600887666e-06, 1.81976038287067e-08, 1.95134534739497e-13, 1.95134534739511e-13, 1.81976038287067e-08, 6.98507600887662e-06, 0.000321019065491214, 0.00446917531456447, 0.0276441580892687, 0.0916639971727964, 0.179531167724987, 0.217228278513938, 0.163526565843561, 0.0743669631029123, 0.0189220703177727, 0.00230387751038115, 9.69836448996463e-05, 6.38459551040343e-07, 3.66259500771148e-11, 7.7972352733169e-16, 3.89005988594301e-10, 3.7731583686304e-07, 3.35477602252615e-05, 0.000791675844273979, 0.00770704602466031, 0.0385363457659804, 0.111281921045891, 0.197130638585331, 0.218795862290777, 0.150043777331479, 0.0600857070784257, 0.012400785856873, 0.00100992036801759, 1.68001760898706e-05, 5.15590520986769e-09, 2.30788078778633e-18, 6.15977146859761e-12, 1.50975043413443e-08, 2.59694329048651e-06, 0.000103880403528426, 0.00159161773078774, 0.0120007530788675, 0.0510946706711851, 0.132512890859281, 0.216848351253402, 0.224244687241961, 0.141331813590592, 0.0494430509965464, 0.0077900813283339, 0.00032746169906956, 5.37634563738438e-07, 4.91834060616281e-21, 7.02272090241329e-14, 4.34948451268279e-10, 1.44741776329547e-07, 9.81414247636898e-06, 0.000236658485605721, 0.00269078480458055, 0.0168911450256379, 0.0641349299445584, 0.154741086066585, 0.241300839451077, 0.239354272470303, 0.141936408744158, 0.043264266864177, 0.00459557316092461, 4.03647190744647e-05, 7.14648372523703e-24, 5.45902139440538e-16, 8.5435623384911e-12, 5.50039537875697e-09, 6.32178420885054e-07, 2.39924153864767e-05, 0.000411356165638054, 0.0038072478970177, 0.0211640948441837, 0.0752876489030124, 0.177037016114967, 0.276382801326153, 0.277811961821894, 0.163826926633557, 0.0439731357148409, 0.00206626141433199, 6.34580024004564e-27, 2.59324986383114e-18, 1.0255583537253e-13, 1.27736231372578e-10, 2.48855449885781e-08, 1.48643541032535e-06, 3.84306062744276e-05, 0.000524425016121333, 0.00426800533445561, 0.0223852531260389, 0.0793760548054833, 0.195029822178954, 0.332298399980778, 0.379106647215628, 0.257131550126075, 0.0646381290294777, 2.60068817282227e-30, 5.68567235525078e-21, 5.68184861694358e-16, 1.3691221209536e-12, 4.52129186405369e-10, 4.25036289461543e-08, 1.65708336921185e-06, 3.33398424397468e-05, 0.000397244694972285, 0.00307190783911794, 0.0164256602673722, 0.0635183098168614, 0.183448200949085, 0.404897796012441, 0.693954822070609, 0.933254702009825, 

0.940443035207042, 0.722795601815968, 0.44810547862037, 0.222264541242381, 0.0871142127246036, 0.0265070396447892, 0.00611079971831509, 0.00103233084423799, 0.0001220703125, 9.47582759210509e-06, 4.40326254516638e-07, 1.06677551732808e-08, 1.08236918464037e-10, 3.15585422887205e-13, 1.27263301990292e-16, 1.24859776865069e-21, 5.64914846413231e-31, 0.0578837493166713, 0.237594465037412, 0.371043963224607, 0.354362617757721, 0.233871594372268, 0.111009292494758, 0.0381417956835582, 0.00935522912673495, 0.0015869140625, 0.000176712930829191, 1.19222493369746e-05, 4.30488582510309e-07, 6.81355339493771e-09, 3.34522952694781e-11, 2.5974355215895e-14, 6.41931136129025e-19, 1.55112048549332e-27, 0.00164432898253073, 0.0360466604142529, 0.141800703231365, 0.260755523739406, 0.289783620889325, 0.214568191091705, 0.109878347417205, 0.0391289191693098, 0.009521484375, 0.00152099367260268, 0.000148987460437654, 8.01785380313055e-06, 1.97961076175652e-07, 1.63660097803934e-09, 2.44677628070887e-12, 1.52321857075243e-16, 1.96569429272376e-24, 2.85457165648641e-05, 0.00334205760479182, 0.0331170450776228, 0.117257144280836, 0.219427155404171, 0.253449550398847, 0.193438663344411, 0.100014151567517, 0.034912109375, 0.00800030722573087, 0.00113778817208329, 9.12588115537292e-05, 3.51484460049487e-06, 4.89305245261615e-08, 1.40852295142795e-10, 2.2087989679114e-14, 1.52232226726218e-21, 3.37879439601156e-07, 0.000211266873623355, 0.00527343202152777, 0.0359512245095703, 0.113285803592951, 0.204120342615516, 0.232189739562167, 0.174298494789081, 0.0872802734375, 0.0286915823781642, 0.00592436339973222, 0.000708206751402556, 4.25501435260092e-05, 9.97437092263329e-07, 5.52843455230887e-09, 2.18382952730592e-12, 8.03832944321494e-19, 2.87948670410717e-09, 9.61571042795477e-06, 0.000604599273840854, 0.00793634534764217, 0.0421107622522134, 0.118362341644773, 0.200666678742552, 0.218704799899901, 0.1571044921875, 0.0740857758105911, 0.0222103019158934, 0.00395710717484574, 0.000370875740553916, 1.46394127002128e-05, 1.56233050864295e-07, 1.55458249528557e-10, 3.05602919773229e-16, 1.81775195908305e-11, 3.24188480273353e-07, 5.1346177992096e-05, 0.00129775783586752, 0.0115951653789715, 0.0508401753669935, 0.128461719962932, 0.203277459323496, 0.20947265625, 0.141703767434213, 0.0616784520451206, 0.0163780349946769, 0.00239453977394994, 0.000159157835891292, 3.27046786416996e-06, 8.19737955370439e-09, 8.60627915047555e-14, 8.60627915047484e-14, 8.19737955370452e-09, 3.27046786416996e-06, 0.000159157835891292, 0.00239453977394995, 0.0163780349946769, 0.0616784520451206, 0.141703767434213, 0.20947265625, 0.203277459323496, 0.128461719962932, 0.0508401753669934, 0.0115951653789715, 0.00129775783586751, 5.1346177992096e-05, 3.24188480273349e-07, 1.81775195908318e-11, 3.056029197732e-16, 1.5545824952856e-10, 1.56233050864295e-07, 1.46394127002128e-05, 0.000370875740553917, 0.00395710717484574, 0.0222103019158934, 0.0740857758105911, 0.1571044921875, 0.218704799899901, 0.200666678742552, 0.118362341644772, 0.0421107622522134, 0.00793634534764215, 0.000604599273840854, 9.61571042795467e-06, 2.87948670410733e-09, 8.03832944321409e-19, 2.18382952730597e-12, 5.52843455230887e-09, 9.97437092263333e-07, 4.25501435260093e-05, 0.000708206751402558, 0.00592436339973222, 0.0286915823781642, 0.0872802734375, 0.174298494789081, 0.232189739562167, 0.204120342615515, 0.113285803592951, 0.0359512245095702, 0.00527343202152777, 0.000211266873623353, 3.37879439601172e-07, 1.522322267262e-21, 2.20879896791145e-14, 1.40852295142795e-10, 4.89305245261618e-08, 3.51484460049488e-06, 9.12588115537294e-05, 0.00113778817208329, 0.00800030722573087, 0.034912109375, 0.100014151567517, 0.193438663344411, 0.253449550398847, 0.21942715540417, 0.117257144280836, 0.0331170450776228, 0.0033420576047918, 2.85457165648651e-05, 1.9656942927235e-24, 1.52321857075246e-16, 2.44677628070887e-12, 1.63660097803935e-09, 1.97961076175653e-07, 8.01785380313057e-06, 0.000148987460437654, 0.00152099367260268, 0.009521484375, 0.0391289191693098, 0.109878347417205, 0.214568191091705, 0.289783620889325, 0.260755523739406, 0.141800703231365, 0.0360466604142527, 0.00164432898253077, 1.5511204854931e-27, 6.41931136129042e-19, 2.5974355215895e-14, 3.34522952694783e-11, 6.81355339493774e-09, 4.3048858251031e-07, 1.19222493369746e-05, 0.000176712930829191, 0.0015869140625, 0.00935522912673495, 0.0381417956835582, 0.111009292494758, 0.233871594372268, 0.35436261775772, 0.371043963224607, 0.237594465037412, 0.0578837493166719, 5.64914846413145e-31, 1.24859776865073e-21, 1.27263301990292e-16, 3.15585422887207e-13, 1.08236918464038e-10, 1.06677551732808e-08, 4.40326254516638e-07, 9.47582759210509e-06, 0.0001220703125, 0.00103233084423799, 0.00611079971831509, 0.0265070396447892, 0.0871142127246036, 0.222264541242381, 0.44810547862037, 0.722795601815968, 0.940443035207042, 

0.946539719858928, 0.747991968559441, 0.487957816202283, 0.261072752060874, 0.113441080681937, 0.039482112718132, 0.0108010519413892, 0.00226440053672237, 0.000351581330525553, 3.85897838981094e-05, 2.80665815857294e-06, 1.23283250082374e-07, 2.84730932026517e-09, 2.77653498678693e-11, 7.84208099060424e-14, 3.08699590364529e-17, 2.97878777026431e-22, 1.33537565829531e-31, 0.0521151615847515, 0.219632908215823, 0.359965216643985, 0.369359036346943, 0.268772889861864, 0.144864428286524, 0.0585076064594375, 0.0175913589949372, 0.00385618049097183, 0.000594603557663092, 6.10562437491124e-05, 3.84631193668264e-06, 1.31147489529545e-07, 1.98049955502579e-09, 9.36765411219338e-12, 7.07203660270855e-15, 1.71445381079193e-19, 4.0988772683297e-28, 0.001324333095357, 0.0297649932078466, 0.122559418890898, 0.241181397765499, 0.29390600853199, 0.245318910705417, 0.146273787413175, 0.0630744441603648, 0.0195207634604096, 0.00422854112077289, 0.000613025503608422, 5.53850852383838e-05, 2.7880028381916e-06, 6.52009984130463e-08, 5.16461875582605e-10, 7.47757614962877e-13, 4.55428195736999e-17, 5.80676528325331e-25, 2.05660343100201e-05, 0.00246509887451692, 0.025500754441418, 0.0962407651490347, 0.196404597050034, 0.253875316880289, 0.223481131551019, 0.138206240221955, 0.0603888035016268, 0.0183769652135725, 0.00376137975867724, 0.00048737285209772, 3.62198478429494e-05, 1.31175860869074e-06, 1.7400665945776e-08, 4.83167116380673e-11, 7.39323004417933e-15, 5.02717274514513e-22, 2.17757167082706e-07, 0.00013919751342652, 0.00361766162987208, 0.0261844167604428, 0.089487713347219, 0.179134199612028, 0.23280043901936, 0.206476415115761, 0.127375126714583, 0.0544534758209396, 0.0157356396553298, 0.00292414172769741, 0.000320825300542835, 1.79937705503194e-05, 3.99725679410147e-07, 2.128641241495e-09, 8.18308576978096e-13, 2.96743984779455e-19, 1.66007173929509e-09, 5.65927903338348e-06, 0.000369517792220076, 0.00512931344234883, 0.0293567293815087, 0.0910057919090912, 0.174606024690584, 0.222098561903026, 0.193439575130605, 0.116174260333802, 0.0473973561030739, 0.0126318802143737, 0.00204608228114559, 0.000177714526941282, 6.61135877672874e-06, 6.7521187485468e-08, 6.52127452644113e-11, 1.26116681912784e-16, 9.37448646063534e-12, 1.70434287484866e-07, 2.7958186445881e-05, 0.000744289349245683, 0.00713375449974177, 0.0342472567905048, 0.0970065112791287, 0.176964956297028, 0.217606699389451, 0.18359483415118, 0.105752358847609, 0.0404206981713122, 0.00966593367084593, 0.00130013938034189, 8.10001145806694e-05, 1.58651397672843e-06, 3.84958660535076e-09, 3.97035536117637e-14, 3.97035536117637e-14, 3.84958660535076e-09, 1.58651397672843e-06, 8.10001145806691e-05, 0.00130013938034189, 0.00966593367084593, 0.0404206981713122, 0.105752358847609, 0.18359483415118, 0.217606699389451, 0.176964956297028, 0.0970065112791286, 0.0342472567905048, 0.00713375449974177, 0.000744289349245685, 2.7958186445881e-05, 1.70434287484866e-07, 9.37448646063534e-12, 1.26116681912784e-16, 6.52127452644113e-11, 6.7521187485468e-08, 6.61135877672871e-06, 0.000177714526941282, 0.00204608228114559, 0.0126318802143737, 0.0473973561030739, 0.116174260333802, 0.193439575130605, 0.222098561903026, 0.174606024690584, 0.0910057919090911, 0.0293567293815087, 0.00512931344234884, 0.000369517792220076, 5.65927903338348e-06, 1.66007173929509e-09, 2.96743984779455e-19, 8.18308576978096e-13, 2.128641241495e-09, 3.99725679410145e-07, 1.79937705503194e-05, 0.000320825300542835, 0.00292414172769741, 0.0157356396553298, 0.0544534758209396, 0.127375126714583, 0.206476415115761, 0.23280043901936, 0.179134199612028, 0.0894877133472191, 0.0261844167604428, 0.00361766162987208, 0.00013919751342652, 2.17757167082706e-07, 5.02717274514513e-22, 7.39323004417933e-15, 4.83167116380673e-11, 1.74006659457759e-08, 1.31175860869074e-06, 3.62198478429494e-05, 0.00048737285209772, 0.00376137975867724, 0.0183769652135725, 0.0603888035016268, 0.138206240221955, 0.223481131551019, 0.253875316880289, 0.196404597050034, 0.0962407651490349, 0.025500754441418, 0.00246509887451692, 2.05660343100201e-05, 5.80676528325331e-25, 4.55428195736999e-17, 7.47757614962877e-13, 5.16461875582602e-10, 6.52009984130463e-08, 2.7880028381916e-06, 5.53850852383838e-05, 0.000613025503608421, 0.00422854112077289, 0.0195207634604096, 0.0630744441603648, 0.146273787413175, 0.245318910705417, 0.29390600853199, 0.241181397765499, 0.122559418890898, 0.0297649932078466, 0.001324333095357, 4.09887726832969e-28, 1.71445381079193e-19, 7.07203660270855e-15, 9.36765411219331e-12, 1.98049955502579e-09, 1.31147489529545e-07, 3.84631193668264e-06, 6.10562437491124e-05, 0.000594603557663092, 0.00385618049097183, 0.0175913589949372, 0.0585076064594375, 0.144864428286524, 0.268772889861864, 0.369359036346943, 0.359965216643985, 0.219632908215823, 0.0521151615847515, 1.33537565829531e-31, 2.97878777026431e-22, 3.08699590364529e-17, 7.84208099060418e-14, 2.77653498678693e-11, 2.84730932026517e-09, 1.23283250082374e-07, 2.80665815857294e-06, 3.85897838981094e-05, 0.000351581330525553, 0.00226440053672237, 0.0108010519413892, 0.039482112718132, 0.113441080681937, 0.261072752060874, 0.487957816202283, 0.747991968559441, 0.946539719858928, 

0.951753273888084, 0.770084779045908, 0.52453783651108, 0.299194062999917, 0.141791570410183, 0.0552196549276875, 0.0174118394804056, 0.00435869186569134, 0.000843935407779603, 0.0001220703125, 1.2584319116121e-05, 8.66325904142122e-07, 3.62858541930424e-08, 8.04799969666908e-10, 7.58838035368654e-12, 2.08620454132454e-14, 8.04564790456759e-18, 7.65479305089352e-23, 3.4048686659754e-32, 0.0471532941645207, 0.203223444607229, 0.346991597011831, 0.378312308182611, 0.298867216360951, 0.179158162427872, 0.0827522389541272, 0.0294140820623921, 0.00793878679557771, 0.0015869140625, 0.000226084868653558, 2.1695460532023e-05, 1.29029483124611e-06, 4.19210107172889e-08, 6.08426231134023e-10, 2.7883423274887e-12, 2.05544372278587e-15, 4.90213074038228e-20, 1.16144703737846e-28, 0.00107822052605457, 0.024752380653982, 0.105942201378358, 0.220778037588618, 0.290746196928183, 0.26827945069056, 0.181519275379189, 0.0916141021099234, 0.0344672764169455, 0.009521484375, 0.00187465420059466, 0.000250763512427011, 2.11762210654826e-05, 1.00782107688184e-06, 2.25151407492952e-08, 1.72005840815195e-10, 2.42358388476832e-13, 1.44891938761242e-17, 1.82854795426224e-25, 1.50668800999007e-05, 0.00184238471584846, 0.0197669292642856, 0.0787374682973254, 0.172850239988851, 0.245503901122332, 0.24332454811079, 0.174377135572242, 0.0914492136737435, 0.034912109375, 0.00949928727603333, 0.00177125053877073, 0.000212387105700496, 1.48065987833216e-05, 5.0916856447941e-07, 6.48426085379301e-09, 1.74634764031562e-11, 2.61712061015484e-15, 1.75927397498991e-22, 1.43551471103965e-07, 9.35001370164614e-05, 0.0025146526347021, 0.0191458918986899, 0.0700639324697447, 0.153178553805322, 0.22239124188291, 0.226300403069762, 0.165432777858506, 0.0872802734375, 0.0328193104738456, 0.00853029842031523, 0.00145236712340781, 0.000148318648129691, 7.85085719773235e-06, 1.66665741568969e-07, 8.57969650574128e-10, 3.22308552528671e-13, 1.15406210400533e-19, 9.84746530006496e-10, 3.41646258447771e-06, 0.000230329355047591, 0.00335198645392966, 0.0204480325632058, 0.0688129266044645, 0.146346362059067, 0.211452883592016, 0.21547438278788, 0.1571044921875, 0.0816395081282855, 0.0295788272035732, 0.00715084177555462, 0.00106971652487909, 8.7157561145958e-05, 3.08435740450968e-06, 3.03490880684411e-08, 2.85793546898956e-11, 5.45076399902056e-17, 5.00388709928571e-12, 9.24713764032488e-08, 1.56274030366775e-05, 0.000434705503783575, 0.00442053443949323, 0.0228985680085115, 0.0713366011631905, 0.146355190065806, 0.20789113006698, 0.20947265625, 0.150431067726059, 0.0759738102006438, 0.0260797941639071, 0.00571489009457136, 0.000716736121324015, 4.22813929031984e-05, 7.95216893718227e-07, 1.87715112689106e-09, 1.90700489969481e-14, 1.90700489969481e-14, 1.87715112689106e-09, 7.95216893718227e-07, 4.22813929031984e-05, 0.000716736121324013, 0.00571489009457137, 0.0260797941639071, 0.0759738102006437, 0.150431067726059, 0.20947265625, 0.20789113006698, 0.146355190065806, 0.0713366011631905, 0.0228985680085115, 0.00442053443949324, 0.000434705503783575, 1.56274030366775e-05, 9.24713764032488e-08, 5.00388709928571e-12, 5.45076399902056e-17, 2.85793546898956e-11, 3.03490880684411e-08, 3.08435740450968e-06, 8.71575611459577e-05, 0.00106971652487909, 0.00715084177555462, 0.0295788272035731, 0.0816395081282855, 0.1571044921875, 0.21547438278788, 0.211452883592016, 0.146346362059067, 0.0688129266044644, 0.0204480325632059, 0.00335198645392966, 0.000230329355047591, 3.41646258447771e-06, 9.84746530006496e-10, 1.15406210400533e-19, 3.22308552528671e-13, 8.57969650574128e-10, 1.66665741568969e-07, 7.85085719773232e-06, 0.000148318648129691, 0.00145236712340781, 0.00853029842031522, 0.0328193104738456, 0.0872802734375, 0.165432777858506, 0.226300403069762, 0.22239124188291, 0.153178553805322, 0.0700639324697449, 0.0191458918986899, 0.0025146526347021, 9.35001370164614e-05, 1.43551471103965e-07, 1.75927397498991e-22, 2.61712061015484e-15, 1.74634764031562e-11, 6.48426085379301e-09, 5.09168564479408e-07, 1.48065987833217e-05, 0.000212387105700496, 0.00177125053877073, 0.00949928727603333, 0.034912109375, 0.0914492136737435, 0.174377135572242, 0.24332454811079, 0.245503901122332, 0.172850239988851, 0.0787374682973254, 0.0197669292642856, 0.00184238471584846, 1.50668800999007e-05, 1.82854795426224e-25, 1.44891938761242e-17, 2.42358388476832e-13, 1.72005840815195e-10, 2.25151407492951e-08, 1.00782107688184e-06, 2.11762210654826e-05, 0.00025076351242701, 0.00187465420059466, 0.009521484375, 0.0344672764169455, 0.0916141021099234, 0.181519275379189, 0.26827945069056, 0.290746196928184, 0.220778037588618, 0.105942201378358, 0.024752380653982, 0.00107822052605457, 1.16144703737846e-28, 4.90213074038228e-20, 2.05544372278587e-15, 2.7883423274887e-12, 6.0842623113402e-10, 4.1921010717289e-08, 1.29029483124611e-06, 2.16954605320229e-05, 0.000226084868653558, 0.0015869140625, 0.00793878679557771, 0.0294140820623921, 0.0827522389541272, 0.179158162427872, 0.298867216360951, 0.378312308182611, 0.346991597011831, 0.203223444607229, 0.0471532941645207, 3.4048686659754e-32, 7.65479305089352e-23, 8.04564790456759e-18, 2.08620454132454e-14, 7.5883803536865e-12, 8.04799969666911e-10, 3.62858541930424e-08, 8.6632590414212e-07, 1.2584319116121e-05, 0.0001220703125, 0.000843935407779603, 0.00435869186569134, 0.0174118394804056, 0.0552196549276875, 0.141791570410183, 0.299194062999917, 0.52453783651108, 0.770084779045908, 0.951753273888084, 

0.956245109854345, 0.789530008195616, 0.558013602939055, 0.33614885383946, 0.171497704669896, 0.0734476993449692, 0.0260946289446113, 0.0075723339346807, 0.00175875025116646, 0.000318369600062066, 4.33638280714711e-05, 4.23838952378895e-06, 2.78436727649505e-07, 1.11985183659357e-08, 2.39935973573659e-10, 2.19819411420975e-12, 5.90531506128486e-15, 2.23781653967884e-18, 2.10350454790793e-23, 9.29391557721121e-33, 0.0428570763508443, 0.188285878241936, 0.332943999106584, 0.382274973580275, 0.323847627807084, 0.212403334901504, 0.109823480781772, 0.0448804782871758, 0.0143801248002239, 0.00355037836292797, 0.000657160228838887, 8.76050394261352e-05, 7.93936021990832e-06, 4.49679606947539e-07, 1.40216440032624e-08, 1.96729884474993e-10, 8.77577632583754e-13, 6.33847495074673e-16, 1.49066842590169e-20, 3.50454881975758e-29, 0.000886510231649, 0.0207240558369215, 0.0916865213077489, 0.200644840828931, 0.282248099708874, 0.283499543503321, 0.213327665538884, 0.122770236738556, 0.0542661531215223, 0.0182736617839378, 0.00459645305145675, 0.000835728493619022, 0.000104484625618249, 8.33400423562044e-06, 3.78190316536261e-07, 8.12610690021045e-09, 6.0191603917084e-11, 8.28615352142999e-14, 4.87558293323158e-18, 6.09920742630611e-26, 1.12063748148374e-05, 0.00139396522333264, 0.0154297887153551, 0.0643576692563604, 0.15032856545939, 0.231240327967563, 0.253232438780401, 0.205233801773537, 0.125145603434962, 0.0574773460655111, 0.0196469239918795, 0.00487215963566659, 0.000840309851243275, 9.43896598561839e-05, 6.23364481041558e-06, 2.05123257886927e-07, 2.52293735261832e-09, 6.61974640637419e-12, 9.74523292084889e-16, 6.48686519159231e-23, 9.65862075661956e-08, 6.39289693258181e-05, 0.00177044745214993, 0.0140747664165271, 0.0545909406791424, 0.128600710390529, 0.204955733734385, 0.233923183234833, 0.196775369153414, 0.123264043395892, 0.0572578293258429, 0.0193662880757191, 0.00460781566873607, 0.000728892872546161, 7.00555067899897e-05, 3.53033451119388e-06, 7.21017150876419e-08, 3.605772381e-10, 1.32808685250591e-13, 4.70397408064729e-20, 5.99373558821305e-10, 2.11094035666773e-06, 0.000146264388438936, 0.0022162287326053, 0.0142735545469425, 0.0514938845571671, 0.119435464725197, 0.191968573066097, 0.222770854802114, 0.190330596535032, 0.12014555025168, 0.0554247525023692, 0.0181921168103146, 0.00405261625828315, 0.000566858942115131, 4.37471038648075e-05, 1.4836013528012e-06, 1.41412486810151e-08, 1.30314645686755e-11, 2.45599491872567e-17, 2.75515653276704e-12, 5.16321790725535e-08, 8.95076983460471e-06, 0.00025849622045002, 0.00276445758988948, 0.0152733454249924, 0.051555234496926, 0.116695266386241, 0.186815212518812, 0.217694290747711, 0.186744032831156, 0.117497159781461, 0.0532031818260185, 0.0166906593247777, 0.00339761336434271, 0.000401558652112408, 2.26128383108254e-05, 4.10812304453301e-07, 9.47166238269011e-10, 9.49852651363732e-15, 9.49852651363624e-15, 9.47166238268991e-10, 4.10812304453301e-07, 2.26128383108253e-05, 0.000401558652112408, 0.00339761336434272, 0.0166906593247777, 0.0532031818260185, 0.117497159781461, 0.186744032831156, 0.217694290747711, 0.186815212518812, 0.116695266386241, 0.051555234496926, 0.0152733454249924, 0.00276445758988948, 0.000258496220450021, 8.95076983460471e-06, 5.16321790725544e-08, 2.75515653276731e-12, 2.45599491872535e-17, 1.30314645686752e-11, 1.41412486810151e-08, 1.4836013528012e-06, 4.37471038648075e-05, 0.000566858942115132, 0.00405261625828315, 0.0181921168103146, 0.0554247525023692, 0.12014555025168, 0.190330596535032, 0.222770854802114, 0.191968573066097, 0.119435464725197, 0.051493884557167, 0.0142735545469425, 0.00221622873260531, 0.000146264388438936, 2.11094035666776e-06, 5.99373558821353e-10, 4.70397408064661e-20, 1.32808685250588e-13, 3.605772381e-10, 7.21017150876414e-08, 3.53033451119388e-06, 7.00555067899899e-05, 0.000728892872546161, 0.00460781566873607, 0.0193662880757191, 0.0572578293258429, 0.123264043395892, 0.196775369153414, 0.233923183234833, 0.204955733734385, 0.128600710390529, 0.0545909406791424, 0.0140747664165271, 0.00177044745214993, 6.39289693258189e-05, 9.65862075662018e-08, 6.48686519159127e-23, 9.74523292084859e-16, 6.61974640637418e-12, 2.5229373526183e-09, 2.05123257886927e-07, 6.2336448104156e-06, 9.43896598561839e-05, 0.000840309851243275, 0.00487215963566659, 0.0196469239918795, 0.0574773460655111, 0.125145603434962, 0.205233801773538, 0.253232438780401, 0.231240327967563, 0.15032856545939, 0.0643576692563605, 0.0154297887153551, 0.00139396522333265, 1.1206374814838e-05, 6.09920742630503e-26, 4.87558293323141e-18, 8.28615352142999e-14, 6.01916039170836e-11, 8.12610690021045e-09, 3.78190316536262e-07, 8.33400423562044e-06, 0.000104484625618249, 0.000835728493619022, 0.00459645305145675, 0.0182736617839378, 0.0542661531215223, 0.122770236738556, 0.213327665538884, 0.28349954350332, 0.282248099708874, 0.200644840828931, 0.0916865213077489, 0.0207240558369216, 0.000886510231649028, 3.5045488197569e-29, 1.49066842590164e-20, 6.33847495074673e-16, 8.77577632583746e-13, 1.96729884474993e-10, 1.40216440032625e-08, 4.49679606947539e-07, 7.93936021990832e-06, 8.76050394261352e-05, 0.000657160228838887, 0.00355037836292797, 0.0143801248002239, 0.0448804782871758, 0.109823480781772, 0.212403334901504, 0.323847627807084, 0.382274973580275, 0.332943999106584, 0.188285878241937, 0.042857076350845, 9.29391557720926e-33, 2.10350454790785e-23, 2.23781653967884e-18, 5.9053150612848e-15, 2.19819411420975e-12, 2.3993597357366e-10, 1.11985183659357e-08, 2.78436727649505e-07, 4.23838952378895e-06, 4.33638280714711e-05, 0.000318369600062066, 0.00175875025116646, 0.0075723339346807, 0.0260946289446113, 0.0734476993449692, 0.171497704669896, 0.33614885383946, 0.558013602939055, 0.789530008195616, 0.956245109854345, 

0.960141647560633, 0.806710642768759, 0.588597099385389, 0.371618665430519, 0.201968771640702, 0.0938086615043379, 0.0368820979101265, 0.012122611331778, 0.00327800578085776, 0.000714251440108432, 0.0001220703125, 1.57927671539067e-05, 1.4746227806715e-06, 9.30567660807509e-08, 3.61431282449601e-09, 7.51676986521884e-11, 6.71795326932526e-13, 1.76914076406334e-15, 6.60336398848677e-19, 6.14254632379579e-24, 2.6982932645222e-33, 0.039114397804297, 0.174712925269513, 0.318411079666865, 0.382228252362844, 0.343796036252025, 0.243488077395022, 0.138554707492517, 0.0636927015576817, 0.0235557538652557, 0.00692558656795566, 0.0015869140625, 0.000275257714378047, 3.4680100777487e-05, 2.9932374592167e-06, 1.62594845590481e-07, 4.89421673277538e-09, 6.66971139594104e-11, 2.9068580784504e-13, 2.06291763171368e-16, 4.79322588779912e-21, 1.11937219218373e-29, 0.000735437695924169, 0.0174638576258454, 0.0794998159525826, 0.18144957203345, 0.270100510129749, 0.291689206926226, 0.240234210626646, 0.154451118239551, 0.0781253900068072, 0.0309934482776927, 0.009521484375, 0.00221426025411358, 0.000376432975799038, 4.44367497286551e-05, 3.37594767883124e-06, 1.47076416252519e-07, 3.05622274580849e-09, 2.20441402791356e-11, 2.97444838208224e-14, 1.72629594411265e-18, 2.14322504886081e-26, 8.45036182245682e-06, 0.00106678158208469, 0.012130096480272, 0.0526392013822944, 0.129679140581348, 0.21354194738373, 0.254547362152869, 0.228882518686038, 0.158346172104714, 0.0847624328670422, 0.034912109375, 0.0108852400224036, 0.00249698050180787, 0.000403147136519654, 4.28355966557315e-05, 2.70099052487647e-06, 8.55821406592864e-08, 1.0216042321004e-09, 2.62090431366223e-12, 3.7994679390137e-16, 2.50773256173458e-23, 6.62023340221121e-08, 4.44303172348351e-05, 0.00126191750650033, 0.0104119293728678, 0.0424505597442532, 0.106589546984932, 0.18389542573882, 0.231261196939814, 0.218822269542046, 0.158054005797829, 0.0872802734375, 0.0364851329606928, 0.0112930491806449, 0.00249375309251774, 0.000370580456635679, 3.38198487130178e-05, 1.63399177134978e-06, 3.22805390940989e-08, 1.57457906452479e-10, 5.7016282339911e-14, 2.000613706982e-20, 3.73425347681122e-10, 1.33234229796684e-06, 9.4521405742928e-05, 0.00148281042837928, 0.0100052792643115, 0.038307034281872, 0.0956545755241174, 0.168238508962085, 0.21772483166454, 0.212197419195202, 0.1571044921875, 0.0880493903287543, 0.0367739079207751, 0.0111064641780478, 0.00230830238410587, 0.000304896723122375, 2.24620340593846e-05, 7.34397806365327e-07, 6.81099052953322e-09, 6.16038003981685e-12, 1.14915274110927e-17, 1.56027273112724e-12, 2.95950071170771e-08, 5.2443976007396e-06, 0.000156425042409096, 0.0017467921857534, 0.0101978513179676, 0.0368558814697066, 0.0906597012937414, 0.160468813081214, 0.211028406425419, 0.20947265625, 0.157399375381254, 0.0887022386519802, 0.0366407555382701, 0.0106504784909629, 0.00203610459775115, 0.00022872547029444, 1.23762249497895e-05, 2.18233949060006e-07, 4.93040216239721e-10, 4.88943307668381e-15, 4.88943307668442e-15, 4.93040216239709e-10, 2.18233949060008e-07, 1.23762249497895e-05, 0.00022872547029444, 0.00203610459775115, 0.0106504784909629, 0.0366407555382701, 0.0887022386519802, 0.157399375381254, 0.20947265625, 0.211028406425419, 0.160468813081214, 0.0906597012937415, 0.0368558814697066, 0.0101978513179676, 0.0017467921857534, 0.000156425042409096, 5.24439760073956e-06, 2.95950071170777e-08, 1.56027273112708e-12, 1.14915274110943e-17, 6.16038003981669e-12, 6.8109905295333e-09, 7.34397806365328e-07, 2.24620340593846e-05, 0.000304896723122375, 0.00230830238410587, 0.0111064641780478, 0.0367739079207751, 0.0880493903287543, 0.1571044921875, 0.212197419195202, 0.21772483166454, 0.168238508962085, 0.0956545755241174, 0.038307034281872, 0.0100052792643115, 0.00148281042837928, 9.45214057429273e-05, 1.33234229796686e-06, 3.73425347681088e-10, 2.00061370698232e-20, 5.70162823399093e-14, 1.57457906452481e-10, 3.22805390940989e-08, 1.63399177134978e-06, 3.38198487130178e-05, 0.000370580456635679, 0.00249375309251774, 0.0112930491806449, 0.0364851329606928, 0.0872802734375, 0.158054005797829, 0.218822269542046, 0.231261196939815, 0.18389542573882, 0.106589546984932, 0.0424505597442532, 0.0104119293728678, 0.00126191750650032, 4.44303172348357e-05, 6.62023340221074e-08, 2.50773256173502e-23, 3.79946793901357e-16, 2.62090431366226e-12, 1.0216042321004e-09, 8.55821406592864e-08, 2.70099052487647e-06, 4.28355966557315e-05, 0.000403147136519653, 0.00249698050180787, 0.0108852400224036, 0.034912109375, 0.0847624328670422, 0.158346172104714, 0.228882518686039, 0.254547362152869, 0.21354194738373, 0.129679140581348, 0.0526392013822944, 0.0121300964802719, 0.0010667815820847, 8.45036182245637e-06, 2.14322504886122e-26, 1.72629594411259e-18, 2.97444838208229e-14, 2.20441402791356e-11, 3.05622274580849e-09, 1.47076416252519e-07, 3.37594767883124e-06, 4.4436749728655e-05, 0.000376432975799038, 0.00221426025411358, 0.009521484375, 0.0309934482776927, 0.0781253900068072, 0.154451118239551, 0.240234210626646, 0.291689206926226, 0.270100510129749, 0.18144957203345, 0.0794998159525823, 0.0174638576258455, 0.000735437695924143, 1.11937219218397e-29, 4.79322588779893e-21, 2.06291763171371e-16, 2.9068580784504e-13, 6.66971139594104e-11, 4.89421673277538e-09, 1.62594845590481e-07, 2.99323745921669e-06, 3.4680100777487e-05, 0.000275257714378047, 0.0015869140625, 0.00692558656795566, 0.0235557538652557, 0.0636927015576817, 0.138554707492517, 0.243488077395022, 0.343796036252025, 0.382228252362844, 0.318411079666864, 0.174712925269513, 0.0391143978042963, 2.69829326452282e-33, 6.14254632379552e-24, 6.60336398848689e-19, 1.76914076406334e-15, 6.71795326932526e-13, 7.51676986521884e-11, 3.61431282449601e-09, 9.30567660807507e-08, 1.4746227806715e-06, 1.57927671539067e-05, 0.0001220703125, 0.000714251440108432, 0.00327800578085776, 0.012122611331778, 0.0368820979101265, 0.0938086615043379, 0.201968771640702, 0.371618665430519, 0.588597099385389, 0.806710642768759, 0.960141647560633, 

0.96354297242909, 0.821948059921505, 0.616517905483387, 0.405409824986716, 0.232706898108542, 0.115906574328389, 0.0497036074544144, 0.018166063717628, 0.00558628067695323, 0.00142176507163854, 0.000293240047258184, 4.76947943848897e-05, 5.9024496032534e-06, 5.2978215014859e-07, 3.22889657531765e-08, 1.21674461860555e-09, 2.46598951176625e-11, 2.15701333679556e-13, 5.58294808582713e-16, 2.05659839430557e-19, 1.89578693581689e-24, 8.28597642901794e-34, 0.0358354063347639, 0.162387553428385, 0.303806478755278, 0.379036833821703, 0.359038132822488, 0.271670470231014, 0.167824447586144, 0.085286559130878, 0.0356125121330497, 0.012121493990584, 0.00331507516022939, 0.000712996810357117, 0.000117001298728588, 1.40444316414941e-05, 1.1623076036035e-06, 6.09002146131502e-08, 1.77804834624984e-09, 2.36269800992177e-11, 1.00916724958454e-13, 7.05317826020915e-17, 1.62169010501464e-21, 3.76520956363494e-30, 0.000615122306508303, 0.0148070656085243, 0.069096534470402, 0.163559758210242, 0.255670013424483, 0.29388992413746, 0.261535375398992, 0.18480267419636, 0.104782888412175, 0.0476971421471082, 0.0172970235148113, 0.00491939948392237, 0.00107042680381099, 0.000171837883010196, 1.93106068263716e-05, 1.40684454235128e-06, 5.91703044686778e-08, 1.19445969198989e-09, 8.4191956979701e-12, 1.11642133193628e-14, 6.40256661194695e-19, 7.89664311625274e-27, 6.45254139737858e-06, 0.000825097825941365, 0.00960363577666344, 0.0431312141878572, 0.111260034903177, 0.194288519591982, 0.249072530935371, 0.244712463826341, 0.188407549778457, 0.11469612518453, 0.0551530523127558, 0.0207422935168874, 0.0059847146534316, 0.00128485417132247, 0.000196060878439519, 1.98606554527809e-05, 1.20332855469514e-06, 3.69024297358587e-08, 4.29238077527614e-10, 1.07991996961566e-12, 1.54475825364827e-16, 1.01208280998174e-23, 4.61496807342533e-08, 3.13480451144728e-05, 0.000910088599276185, 0.00775488722818788, 0.0330116451160818, 0.0875745994695842, 0.161729709270363, 0.220939062111813, 0.230980233280219, 0.188050162205621, 0.119904727728373, 0.0596307179195947, 0.0228138456859294, 0.00655024195154332, 0.00135723342005188, 0.000191165546437655, 1.66852692511941e-05, 7.77332818083253e-07, 1.49208806287775e-08, 7.12235466990706e-11, 2.54118054259012e-14, 8.84419204678179e-21, 2.37650700477785e-10, 8.57527349065608e-07, 6.20960769454107e-05, 0.00100390307759911, 0.00705224903297314, 0.0284211519631842, 0.075611225007279, 0.14362214842098, 0.203884319523405, 0.221988856929908, 0.187687590308921, 0.123428598290354, 0.0626161047413903, 0.0240432593975309, 0.0067647327260816, 0.00132482393075184, 0.000166576875789231, 1.17893956133492e-05, 3.73442005925514e-07, 3.3821130249717e-09, 3.00983726421082e-12, 5.56458495056091e-18, 9.06516530703358e-13, 1.73760768272429e-08, 3.13841871291398e-06, 9.62663079956123e-05, 0.00111597468662471, 0.00683237075765338, 0.0261847827047644, 0.0691570665413173, 0.133308876397137, 0.19411311055817, 0.217621120091959, 0.189246470020191, 0.127303348279546, 0.065372572181405, 0.0249754298267144, 0.00680100254852755, 0.0012318630741245, 0.000132447056467114, 6.92337905562736e-06, 1.18964906908222e-07, 2.64068585889918e-10, 2.59342456845168e-15, 2.59342456845168e-15, 2.64068585889918e-10, 1.1896490690822e-07, 6.9233790556274e-06, 0.000132447056467114, 0.0012318630741245, 0.00680100254852755, 0.0249754298267144, 0.0653725721814051, 0.127303348279545, 0.189246470020191, 0.217621120091959, 0.19411311055817, 0.133308876397137, 0.0691570665413173, 0.0261847827047643, 0.00683237075765338, 0.00111597468662471, 9.62663079956118e-05, 3.13841871291401e-06, 1.73760768272429e-08, 9.06516530703358e-13, 5.56458495056091e-18, 3.00983726421082e-12, 3.38211302497166e-09, 3.73442005925517e-07, 1.17893956133493e-05, 0.000166576875789231, 0.00132482393075184, 0.0067647327260816, 0.0240432593975309, 0.0626161047413902, 0.123428598290354, 0.187687590308921, 0.221988856929908, 0.203884319523405, 0.14362214842098, 0.075611225007279, 0.0284211519631842, 0.00705224903297313, 0.00100390307759911, 6.20960769454112e-05, 8.57527349065608e-07, 2.37650700477785e-10, 8.84419204678179e-21, 2.54118054259012e-14, 7.12235466990696e-11, 1.49208806287776e-08, 7.77332818083257e-07, 1.66852692511941e-05, 0.000191165546437655, 0.00135723342005188, 0.00655024195154331, 0.0228138456859293, 0.0596307179195947, 0.119904727728373, 0.188050162205621, 0.230980233280219, 0.220939062111813, 0.161729709270363, 0.0875745994695842, 0.0330116451160817, 0.00775488722818785, 0.000910088599276191, 3.13480451144728e-05, 4.61496807342533e-08, 1.01208280998174e-23, 1.54475825364827e-16, 1.07991996961565e-12, 4.29238077527618e-10, 3.69024297358589e-08, 1.20332855469514e-06, 1.98606554527809e-05, 0.000196060878439519, 0.00128485417132247, 0.00598471465343159, 0.0207422935168874, 0.0551530523127558, 0.11469612518453, 0.188407549778457, 0.244712463826341, 0.249072530935371, 0.194288519591982, 0.111260034903177, 0.0431312141878571, 0.00960363577666348, 0.000825097825941365, 6.45254139737858e-06, 7.89664311625274e-27, 6.40256661194696e-19, 1.11642133193626e-14, 8.41919569797017e-12, 1.1944596919899e-09, 5.91703044686778e-08, 1.40684454235128e-06, 1.93106068263716e-05, 0.000171837883010196, 0.00107042680381099, 0.00491939948392237, 0.0172970235148113, 0.0476971421471082, 0.104782888412175, 0.18480267419636, 0.261535375398992, 0.29388992413746, 0.255670013424483, 0.163559758210241, 0.0690965344704022, 0.0148070656085243, 0.000615122306508303, 3.76520956363494e-30, 1.62169010501464e-21, 7.05317826020902e-17, 1.00916724958455e-13, 2.36269800992179e-11, 1.77804834624984e-09, 6.09002146131502e-08, 1.1623076036035e-06, 1.40444316414941e-05, 0.000117001298728588, 0.000712996810357117, 0.00331507516022939, 0.012121493990584, 0.0356125121330497, 0.085286559130878, 0.167824447586144, 0.271670470231014, 0.359038132822488, 0.379036833821702, 0.303806478755278, 0.162387553428385, 0.0358354063347639, 8.28597642901794e-34, 1.89578693581689e-24, 2.05659839430553e-19, 5.58294808582719e-16, 2.15701333679557e-13, 2.46598951176625e-11, 1.21674461860555e-09, 3.22889657531765e-08, 5.2978215014859e-07, 5.90244960325339e-06, 4.76947943848897e-05, 0.000293240047258184, 0.00142176507163854, 0.00558628067695323, 0.018166063717628, 0.0497036074544144, 0.115906574328389, 0.232706898108542, 0.405409824986716, 0.616517905483387, 0.821948059921505, 0.96354297242909, 

0.966529111786493, 0.83551215740737, 0.642006920671105, 0.437422048140622, 0.263308367254466, 0.139342672483326, 0.0644088385510964, 0.0257896892668562, 0.00885166700399291, 0.00256996981641078, 0.000620695383503974, 0.0001220703125, 1.90189115376306e-05, 2.26454389452645e-06, 1.96386205740682e-07, 1.1611817409198e-08, 4.2617707819645e-10, 8.4448508197268e-12, 7.2492017051143e-14, 1.84812818862536e-16, 6.73005116816321e-20, 6.15472813378999e-25, 2.67824215612562e-34, 0.0329475036698286, 0.151192835022198, 0.289414230594872, 0.373435559183665, 0.370033245617266, 0.296528576760123, 0.196656197300998, 0.108941568161501, 0.0504632280875413, 0.0194480217001447, 0.00617140368536422, 0.0015869140625, 0.000323271131097106, 5.05731540912338e-05, 5.82167186669025e-06, 4.64557407869362e-07, 2.35892766110522e-08, 6.7065052556255e-10, 8.71767759746138e-12, 3.6585062026578e-14, 2.52304443207932e-17, 5.74800505933542e-22, 1.32778870734563e-30, 0.000518367767160435, 0.0126275048972908, 0.06021545215882, 0.147142648217352, 0.240007452898908, 0.291243920533906, 0.27712627507129, 0.212397320447563, 0.132780068234162, 0.067925170345002, 0.0283202637606882, 0.009521484375, 0.0025360399182927, 0.000521275405799614, 7.96512076699252e-05, 8.57800864284303e-06, 6.02624877889443e-07, 2.45815041818606e-08, 4.8385955469359e-10, 3.34259222191919e-12, 4.36555364577768e-15, 2.47761206648634e-19, 3.03819747071884e-27, 4.98394960520611e-06, 0.000644501690317316, 0.00765625169149072, 0.035430856113017, 0.0951324958893956, 0.174810439280445, 0.238653578986533, 0.253060653135683, 0.21350641411221, 0.144979374631643, 0.0794201699755132, 0.034912109375, 0.0121580920666978, 0.00328348177486388, 0.000665973865641918, 9.67951838953106e-05, 9.40805115210768e-06, 5.50605848179668e-07, 1.64118681492586e-08, 1.86630741216329e-10, 4.61608651812192e-13, 6.52633936807914e-17, 4.24837852673478e-24, 3.26721620346494e-08, 2.24284444696051e-05, 0.000663732418664588, 0.00581692283633644, 0.025709973694663, 0.0715395885316263, 0.140128598125111, 0.205574287604373, 0.234076353784706, 0.210984371362669, 0.151856333143956, 0.0872802734375, 0.0397414170405274, 0.0141016705188759, 0.00379656278941231, 0.000744714135410154, 0.000100143060944555, 8.40894987012321e-06, 3.79546766020892e-07, 7.10479484208064e-09, 3.32795257721717e-11, 1.17212674958681e-14, 4.05041003611717e-21, 1.54210733401156e-10, 5.61961733842025e-07, 4.14288001183003e-05, 0.000687602513659047, 0.00500272776052375, 0.0210793885010835, 0.0592404159579109, 0.1202390288031, 0.184772211799172, 0.221068490963826, 0.209058342038144, 0.1571044921875, 0.0935306097537248, 0.0436052733170561, 0.0155831942144472, 0.00412532284392638, 0.000767493224165837, 9.24645378712424e-05, 6.31982522199741e-06, 1.94738759444096e-07, 1.7274791503936e-09, 1.51569562739571e-12, 2.78039995197115e-18, 5.39159873141755e-13, 1.0429910099228e-08, 1.91548127816139e-06, 6.02071181686735e-05, 0.000721071514261761, 0.00460082601038575, 0.0185513557087674, 0.0520940781211288, 0.108039359969029, 0.17158117546068, 0.213190734762421, 0.20947265625, 0.163053608428532, 0.0998788870050436, 0.0473792968739435, 0.0169274881186933, 0.00435706932169919, 0.000753138544913936, 7.7949094009662e-05, 3.95384361549983e-06, 6.64224256406737e-08, 1.45182961036664e-10, 1.4137798439587e-15, 1.41377984395891e-15, 1.45182961036664e-10, 6.64224256406729e-08, 3.95384361549983e-06, 7.7949094009662e-05, 0.000753138544913934, 0.0043570693216992, 0.0169274881186933, 0.0473792968739435, 0.0998788870050436, 0.163053608428532, 0.20947265625, 0.213190734762421, 0.17158117546068, 0.108039359969029, 0.0520940781211289, 0.0185513557087674, 0.00460082601038576, 0.000721071514261761, 6.02071181686735e-05, 1.91548127816141e-06, 1.0429910099228e-08, 5.39159873141687e-13, 2.78039995197162e-18, 1.51569562739571e-12, 1.72747915039358e-09, 1.94738759444096e-07, 6.31982522199741e-06, 9.24645378712421e-05, 0.000767493224165838, 0.00412532284392637, 0.0155831942144472, 0.0436052733170561, 0.0935306097537248, 0.1571044921875, 0.209058342038144, 0.221068490963826, 0.184772211799172, 0.120239028803101, 0.0592404159579108, 0.0210793885010835, 0.00500272776052375, 0.000687602513659047, 4.14288001183006e-05, 5.61961733842025e-07, 1.5421073340114e-10, 4.05041003611794e-21, 1.17212674958681e-14, 3.32795257721712e-11, 7.10479484208064e-09, 3.79546766020892e-07, 8.40894987012318e-06, 0.000100143060944555, 0.000744714135410153, 0.00379656278941231, 0.0141016705188759, 0.0397414170405274, 0.0872802734375, 0.151856333143956, 0.210984371362669, 0.234076353784706, 0.205574287604374, 0.140128598125111, 0.0715395885316264, 0.025709973694663, 0.00581692283633644, 0.000663732418664592, 2.24284444696051e-05, 3.26721620346466e-08, 4.24837852673569e-24, 6.52633936807914e-17, 4.61608651812184e-13, 1.86630741216329e-10, 1.64118681492586e-08, 5.50605848179666e-07, 9.40805115210771e-06, 9.67951838953104e-05, 0.000665973865641918, 0.00328348177486388, 0.0121580920666978, 0.034912109375, 0.0794201699755132, 0.144979374631643, 0.21350641411221, 0.253060653135684, 0.238653578986533, 0.174810439280445, 0.0951324958893956, 0.035430856113017, 0.00765625169149076, 0.000644501690317316, 4.9839496052058e-06, 3.03819747071955e-27, 2.47761206648634e-19, 4.3655536457776e-15, 3.34259222191919e-12, 4.8385955469359e-10, 2.45815041818605e-08, 6.02624877889445e-07, 8.57800864284301e-06, 7.96512076699252e-05, 0.000521275405799614, 0.0025360399182927, 0.009521484375, 0.0283202637606882, 0.067925170345002, 0.132780068234162, 0.212397320447563, 0.27712627507129, 0.291243920533906, 0.240007452898908, 0.147142648217352, 0.0602154521588202, 0.0126275048972908, 0.000518367767160413, 1.32778870734597e-30, 5.74800505933542e-22, 2.52304443207927e-17, 3.6585062026578e-14, 8.71767759746138e-12, 6.70650525562547e-10, 2.35892766110523e-08, 4.64557407869361e-07, 5.82167186669025e-06, 5.05731540912338e-05, 0.000323271131097106, 0.0015869140625, 0.00617140368536422, 0.0194480217001447, 0.0504632280875413, 0.108941568161501, 0.196656197300998, 0.296528576760124, 0.370033245617266, 0.373435559183665, 0.289414230594872, 0.151192835022198, 0.0329475036698279, 2.67824215612636e-34, 6.15472813378999e-25, 6.73005116816306e-20, 1.84812818862536e-16, 7.2492017051143e-14, 8.44485081972676e-12, 4.26177078196451e-10, 1.1611817409198e-08, 1.96386205740682e-07, 2.26454389452645e-06, 1.90189115376306e-05, 0.0001220703125, 0.000620695383503974, 0.00256996981641078, 0.00885166700399291, 0.0257896892668562, 0.0644088385510964, 0.139342672483326, 0.263308367254466, 0.437422048140622, 0.642006920671105, 0.83551215740737, 0.966529111786493, 

0.969164644126161, 0.847630040252118, 0.665286753813533, 0.467622896778888, 0.293456856355, 0.163739416219211, 0.0807931576392643, 0.0350122725326846, 0.0132110087482358, 0.00429366425299025, 0.00118584085323235, 0.00027362331386587, 5.16241494428885e-05, 7.74660170561281e-06, 8.91734779027203e-07, 7.50383091888437e-08, 4.3204202983081e-09, 1.54939579021264e-10, 3.00999760370667e-12, 2.54150126896537e-14, 6.39376444045934e-17, 2.30486405617581e-20, 2.09315224244469e-25, 9.07315202136778e-35, 0.0303915794153249, 0.14101728346837, 0.275423622253948, 0.36603340775267, 0.377297097911512, 0.317893903068889, 0.224265851190362, 0.133883059823277, 0.0678215276436762, 0.029073351369856, 0.0104688592727195, 0.00312882340378107, 0.000762977376767564, 0.000148294477434545, 2.22564243963555e-05, 2.47023435060303e-06, 1.9094459672958e-07, 9.43323186499894e-09, 2.62013635751814e-10, 3.34070272745453e-12, 1.38044268357401e-14, 9.40891858726071e-18, 2.12628520578233e-22, 4.88977847127728e-31, 0.000439862437578894, 0.0108279501265309, 0.0526261249886059, 0.132237180376877, 0.223887871041661, 0.28485185868487, 0.287315869197938, 0.236286471233241, 0.160696735214614, 0.0908594305904179, 0.0426560084439142, 0.0165126548281127, 0.0052044915806741, 0.0013102272478237, 0.00025637931396066, 3.75319536802866e-05, 3.8949030065253e-06, 2.65073641999263e-07, 1.05266342919257e-08, 2.0267175606618e-10, 1.37558687930939e-12, 1.7727275914168e-15, 9.96896602164258e-20, 1.21626463397086e-27, 3.89045738776821e-06, 0.000508089627837208, 0.00614499848455079, 0.0291948747087932, 0.0811891227021781, 0.155982579013172, 0.224944955780245, 0.254842738704245, 0.232684106248345, 0.173526219259329, 0.106213873072092, 0.0532565383412488, 0.0216952740247903, 0.00707438116712791, 0.00180480692281153, 0.000348485222641782, 4.85518855529502e-05, 4.55190050787998e-06, 2.58449298126941e-07, 7.51395879913367e-09, 8.3767942846984e-11, 2.04110091732412e-13, 2.85626760379622e-17, 1.84878816925221e-24, 2.34613515596807e-08, 1.62555994754565e-05, 0.000489227369788129, 0.00439468983702216, 0.0200739902477265, 0.0582373646330636, 0.120077457083203, 0.187402011897935, 0.229717966585335, 0.225958548687157, 0.180322888602197, 0.117110960665818, 0.0616624175459427, 0.0260434708668125, 0.00866257671009142, 0.0022061556007265, 0.00041265216946776, 5.32951335815498e-05, 4.32643075454955e-06, 1.89938483640251e-07, 3.47805346726156e-09, 1.60234315605694e-11, 5.57976939733695e-15, 1.91608515530034e-21, 1.01868025464312e-10, 3.74453718157004e-07, 2.80434995004659e-05, 0.000476301927941564, 0.00357356812290823, 0.0156552435266823, 0.0461507966145777, 0.0992221722863717, 0.163288539198122, 0.211848281365032, 0.220420996933934, 0.185419177163505, 0.126185209182016, 0.0690306188360827, 0.029936149237366, 0.0100558875878831, 0.00252519349021231, 0.000449277682181733, 5.21454780914026e-05, 3.45692231525629e-06, 1.0397457508445e-07, 9.05688968604518e-10, 7.84812847016732e-13, 1.42979888992371e-18, 3.27634012476837e-13, 6.38939203475177e-09, 1.19074811033268e-06, 3.82386614172549e-05, 0.000471234038986498, 0.00311734000536327, 0.013139025425121, 0.0389143198526139, 0.0859770769244775, 0.147125294466531, 0.199581967846955, 0.217459300608629, 0.191276927815405, 0.13553482577797, 0.0766321496652808, 0.0339524337996031, 0.0114464659563762, 0.00280548769120457, 0.000465553698947999, 4.66049992322824e-05, 2.30241860447002e-06, 3.79200462010087e-08, 8.17677764851947e-11, 7.90317022753583e-16, 7.90317022753711e-16, 8.17677764851947e-11, 3.79200462010092e-08, 2.30241860447002e-06, 4.66049992322824e-05, 0.000465553698948, 0.00280548769120457, 0.0114464659563763, 0.0339524337996031, 0.0766321496652808, 0.13553482577797, 0.191276927815405, 0.217459300608629, 0.199581967846955, 0.147125294466531, 0.0859770769244775, 0.0389143198526138, 0.013139025425121, 0.00311734000536326, 0.000471234038986498, 3.82386614172549e-05, 1.19074811033267e-06, 6.38939203475177e-09, 3.27634012476791e-13, 1.42979888992397e-18, 7.84812847016733e-13, 9.05688968604531e-10, 1.0397457508445e-07, 3.45692231525629e-06, 5.21454780914028e-05, 0.000449277682181733, 0.00252519349021232, 0.0100558875878831, 0.029936149237366, 0.0690306188360826, 0.126185209182016, 0.185419177163505, 0.220420996933934, 0.211848281365032, 0.163288539198122, 0.0992221722863716, 0.0461507966145777, 0.0156552435266823, 0.00357356812290823, 0.000476301927941564, 2.80434995004656e-05, 3.74453718157005e-07, 1.018680254643e-10, 1.91608515530074e-21, 5.57976939733695e-15, 1.60234315605697e-11, 3.47805346726156e-09, 1.89938483640251e-07, 4.32643075454957e-06, 5.32951335815498e-05, 0.000412652169467761, 0.0022061556007265, 0.00866257671009142, 0.0260434708668125, 0.0616624175459427, 0.117110960665818, 0.180322888602197, 0.225958548687157, 0.229717966585335, 0.187402011897934, 0.120077457083203, 0.0582373646330635, 0.0200739902477265, 0.00439468983702216, 0.000489227369788125, 1.62555994754565e-05, 2.34613515596785e-08, 1.84878816925264e-24, 2.85626760379622e-17, 2.04110091732415e-13, 8.3767942846984e-11, 7.51395879913367e-09, 2.58449298126942e-07, 4.55190050787998e-06, 4.85518855529503e-05, 0.000348485222641782, 0.00180480692281153, 0.00707438116712791, 0.0216952740247903, 0.0532565383412488, 0.106213873072092, 0.173526219259329, 0.232684106248345, 0.254842738704245, 0.224944955780245, 0.155982579013172, 0.0811891227021781, 0.0291948747087932, 0.00614499848455076, 0.000508089627837208, 3.89045738776794e-06, 1.21626463397116e-27, 9.96896602164258e-20, 1.77272759141683e-15, 1.37558687930939e-12, 2.0267175606618e-10, 1.05266342919257e-08, 2.65073641999263e-07, 3.89490300652531e-06, 3.75319536802866e-05, 0.00025637931396066, 0.0013102272478237, 0.0052044915806741, 0.0165126548281127, 0.0426560084439142, 0.0908594305904179, 0.160696735214614, 0.236286471233241, 0.287315869197938, 0.284851858684869, 0.223887871041661, 0.132237180376877, 0.0526261249886057, 0.0108279501265309, 0.000439862437578873, 4.88977847127863e-31, 2.12628520578233e-22, 9.40891858726091e-18, 1.38044268357401e-14, 3.34070272745453e-12, 2.62013635751815e-10, 9.43323186499894e-09, 1.9094459672958e-07, 2.47023435060303e-06, 2.22564243963555e-05, 0.000148294477434545, 0.000762977376767562, 0.00312882340378107, 0.0104688592727195, 0.029073351369856, 0.0678215276436762, 0.133883059823277, 0.224265851190362, 0.317893903068888, 0.377297097911512, 0.366033407752671, 0.275423622253948, 0.14101728346837, 0.0303915794153242, 9.0731520213705e-35, 2.09315224244469e-25, 2.30486405617586e-20, 6.39376444045934e-17, 2.54150126896537e-14, 3.00999760370668e-12, 1.54939579021264e-10, 4.32042029830811e-09, 7.50383091888437e-08, 8.91734779027203e-07, 7.74660170561281e-06, 5.16241494428884e-05, 0.00027362331386587, 0.00118584085323235, 0.00429366425299025, 0.0132110087482358, 0.0350122725326846, 0.0807931576392643, 0.163739416219211, 0.293456856355, 0.467622896778888, 0.665286753813533, 0.847630040252118, 0.969164644126161, 

6.103515625e-05, 0.0008544921875, 0.00555419921875, 0.022216796875, 0.06109619140625, 0.1221923828125, 0.18328857421875, 0.20947265625, 0.18328857421875, 0.1221923828125, 0.06109619140625, 0.022216796875, 0.00555419921875, 0.0008544921875, 6.103515625e-05, 

0.0360225190787645, 3.54248821868359e-10, 0.135130868550855, 1.85090444242779e-08, 0.235353346154666, 4.48998512241204e-07, 0.25225095615242, 6.70274104082805e-06, 0.185873709975304, 6.87911678144553e-05, 0.0996094209641187, 0.000513464266791089, 0.040035395858801, 0.00287441209730317, 0.0122599451303155, 0.0122599451303155, 0.00287441209730317, 0.040035395858801, 0.000513464266791089, 0.0996094209641187, 6.87911678144553e-05, 0.185873709975304, 6.70274104082805e-06, 0.252250956152421, 4.48998512241204e-07, 0.235353346154666, 1.85090444242779e-08, 0.135130868550855, 3.54248821868359e-10, 0.0360225190787645, 

0.187488799999946, 6.103515625e-05, 5.33365193014362e-14, 0.333398799994121, 0.0008544921875, 5.87884539486827e-12, 0.275256799699154, 0.00555419921875, 3.00846337276719e-10, 0.139848790525768, 0.022216796875, 9.47423281258841e-09, 0.0488485948761881, 0.06109619140625, 2.05123812166901e-07, 0.0124091701272859, 0.1221923828125, 3.22987271420117e-06, 0.00236425689886611, 0.18328857421875, 3.81431011339132e-05, 0.000343200000000004, 0.20947265625, 0.000343200000000004, 3.81431011339132e-05, 0.18328857421875, 0.00236425689886611, 3.22987271420117e-06, 0.1221923828125, 0.0124091701272859, 2.05123812166901e-07, 0.06109619140625, 0.0488485948761881, 9.47423281258841e-09, 0.022216796875, 0.139848790525768, 3.00846337276719e-10, 0.00555419921875, 0.275256799699154, 5.87884539486827e-12, 0.0008544921875, 0.333398799994121, 5.33365193014362e-14, 6.103515625e-05, 0.187488799999946, 

0.365152783437079, 0.00367249509375289, 1.81706217561132e-07, 6.05092558496104e-17, 0.38142852209937, 0.0253248577444598, 5.16464017485559e-06, 1.13537501674333e-14, 0.184985222322477, 0.0810808187841441, 6.81546781586485e-05, 9.89104496558002e-13, 0.0552087025808268, 0.159748162574084, 0.000553474871450649, 5.30263401652873e-11, 0.0113279350190444, 0.216384585553985, 0.00309010222925985, 1.95440170706211e-09, 0.00169040690783159, 0.213164102619815, 0.0125471499559266, 5.23881804697753e-08, 0.000189187758574763, 0.157493662947544, 0.0382101368344255, 1.05320778336533e-06, 1.61322704035543e-05, 0.0886569497666001, 0.0886569497666001, 1.61322704035544e-05, 1.05320778336533e-06, 0.0382101368344255, 0.157493662947544, 0.000189187758574764, 5.2388180469775e-08, 0.0125471499559266, 0.213164102619815, 0.0016904069078316, 1.9544017070621e-09, 0.00309010222925985, 0.216384585553985, 0.0113279350190445, 5.30263401652868e-11, 0.000553474871450649, 0.159748162574084, 0.0552087025808269, 9.89104496557992e-13, 6.81546781586485e-05, 0.0810808187841441, 0.184985222322477, 1.13537501674332e-14, 5.16464017485559e-06, 0.0253248577444598, 0.38142852209937, 6.05092558496097e-17, 1.81706217561132e-07, 0.00367249509375289, 0.365152783437079, 

0.510357250193351, 0.0253994189612207, 6.103515625e-05, 1.21447408590844e-09, 2.49876863169458e-19, 0.351669409988091, 0.106675224463167, 0.0008544921875, 5.66766979964708e-08, 7.10758091827518e-17, 0.112507174446971, 0.208012134213633, 0.00555419921875, 1.22802200468364e-06, 9.38648306749639e-15, 0.0221499360873215, 0.249609096988519, 0.022216796875, 1.63739851559847e-05, 7.62835023093601e-13, 0.00299804011495531, 0.205922997258237, 0.06109619140625, 0.00015009814958142, 4.26217276415682e-11, 0.000295120721233587, 0.123551093759772, 0.1221923828125, 0.00100067623536604, 1.73192378636107e-09, 2.17882942093482e-05, 0.0555967751507125, 0.18328857421875, 0.00500349070334389, 5.27822339873523e-08, 1.22559631434575e-06, 0.019061334218115, 0.20947265625, 0.019061334218115, 1.22559631434576e-06, 5.27822339873518e-08, 0.00500349070334389, 0.18328857421875, 0.0555967751507125, 2.17882942093483e-05, 1.73192378636105e-09, 0.00100067623536604, 0.1221923828125, 0.123551093759772, 0.000295120721233588, 4.26217276415677e-11, 0.00015009814958142, 0.06109619140625, 0.205922997258237, 0.00299804011495532, 7.62835023093591e-13, 1.63739851559847e-05, 0.022216796875, 0.249609096988519, 0.0221499360873216, 9.38648306749625e-15, 1.22802200468364e-06, 0.00555419921875, 0.208012134213633, 0.112507174446971, 7.10758091827507e-17, 5.66766979964708e-08, 0.0008544921875, 0.106675224463167, 0.351669409988091, 2.49876863169453e-19, 1.21447408590844e-09, 6.103515625e-05, 0.0253994189612207, 0.510357250193351, 

0.618240113826958, 0.0743911598489896, 0.0012209821119349, 1.34278680180447e-06, 1.60184035857797e-11, 2.50367697730218e-21, 0.302463127550387, 0.212400902913704, 0.0105075499431233, 3.05823584097101e-05, 1.09961403480128e-09, 1.00304197799572e-18, 0.0687025754499269, 0.28156372892951, 0.0419835294140928, 0.000323385247870867, 3.50466602094341e-08, 1.86571474156581e-16, 0.00960329415088601, 0.229690848727484, 0.103229319085503, 0.00210434077238461, 6.87384343939723e-07, 2.13559065523182e-14, 0.000922869191392459, 0.128820025063038, 0.174501788474093, 0.00941422638908022, 9.2688389709756e-06, 1.68059660984617e-12, 6.44996512117038e-05, 0.05254366569572, 0.214532949644489, 0.0306302476093643, 9.0896746752376e-05, 9.61847579172153e-11, 3.38092742061936e-06, 0.0160738022100557, 0.197810521967794, 0.0747442245784971, 0.000668548018476573, 4.12867115228212e-09, 1.35025258453866e-07, 0.00374642946066364, 0.138965009616562, 0.138965009616562, 0.00374642946066363, 1.35025258453866e-07, 4.12867115228212e-09, 0.000668548018476575, 0.0747442245784971, 0.197810521967794, 0.0160738022100556, 3.38092742061937e-06, 9.61847579172153e-11, 9.08967467523762e-05, 0.0306302476093643, 0.214532949644489, 0.0525436656957199, 6.44996512117038e-05, 1.68059660984617e-12, 9.26883897097563e-06, 0.00941422638908022, 0.174501788474093, 0.128820025063038, 0.000922869191392459, 2.13559065523182e-14, 6.87384343939726e-07, 0.00210434077238461, 0.103229319085503, 0.229690848727484, 0.00960329415088601, 1.86571474156581e-16, 3.50466602094342e-08, 0.000323385247870867, 0.0419835294140928, 0.281563728929509, 0.0687025754499269, 1.00304197799572e-18, 1.09961403480128e-09, 3.05823584097101e-05, 0.0105075499431233, 0.212400902913704, 0.302463127550387, 2.50367697730218e-21, 1.60184035857798e-11, 1.34278680180447e-06, 0.0012209821119349, 0.0743911598489896, 0.618240113826958, 

0.697079712833371, 0.14408462533881, 0.00718960257481076, 6.103515625e-05, 4.17037490335719e-08, 3.62488447956394e-13, 4.77181713464555e-23, 0.254814924689031, 0.299379853945045, 0.0425397641797981, 0.0008544921875, 1.3814684658828e-06, 3.41936381454514e-11, 2.55857084001812e-20, 0.0432466627988767, 0.288810397160246, 0.116861267610103, 0.00555419921875, 2.12467336903652e-05, 1.49755152304836e-09, 6.36936915695268e-18, 0.0045167595700706, 0.171454824485121, 0.197557145461426, 0.022216796875, 0.000201089783987806, 4.03612743065914e-08, 9.75757795912054e-16, 0.000324320237430402, 0.0699776411295626, 0.229608305927287, 0.06109619140625, 0.00130846027896925, 7.47860625510198e-07, 1.02768576654118e-13, 1.69362956743495e-05, 0.0207714201007362, 0.194079537304741, 0.1221923828125, 0.00619196340221148, 1.00779864280975e-05, 7.87183450778483e-12, 6.63321490762378e-07, 0.00462417587285961, 0.12303627251735, 0.18328857421875, 0.021976447082824, 0.000101856355630063, 4.52223193134998e-10, 1.97938555752547e-08, 0.000784337871553811, 0.0594274739705861, 0.20947265625, 0.0594274739705861, 0.000784337871553811, 1.9793855575255e-08, 4.52223193134991e-10, 0.000101856355630063, 0.021976447082824, 0.18328857421875, 0.12303627251735, 0.00462417587285961, 6.63321490762387e-07, 7.87183450778467e-12, 1.00779864280975e-05, 0.00619196340221148, 0.1221923828125, 0.194079537304741, 0.0207714201007362, 1.69362956743497e-05, 1.02768576654116e-13, 7.47860625510198e-07, 0.00130846027896925, 0.06109619140625, 0.229608305927287, 0.0699776411295626, 0.000324320237430405, 9.75757795912031e-16, 4.03612743065914e-08, 0.000201089783987806, 0.022216796875, 0.197557145461426, 0.171454824485121, 0.00451675957007063, 6.36936915695251e-18, 1.49755152304836e-09, 2.12467336903652e-05, 0.00555419921875, 0.116861267610103, 0.288810397160246, 0.0432466627988769, 2.55857084001804e-20, 3.41936381454514e-11, 1.3814684658828e-06, 0.0008544921875, 0.0425397641797981, 0.299379853945045, 0.254814924689031, 4.7718171346454e-23, 3.62488447956394e-13, 4.17037490335719e-08, 6.103515625e-05, 0.00718960257481076, 0.14408462533881, 0.697079712833371, 

0.755203785209844, 0.222907441326673, 0.0225673311590701, 0.000645059766382991, 3.57646004274254e-06, 1.78842935111527e-09, 1.26039259762581e-14, 1.47979123861944e-24, 0.214177259647798, 0.353178389843839, 0.0982637538480874, 0.00623124265394479, 7.2566259913673e-05, 8.05034905015786e-08, 1.55916601435049e-12, 1.02269780426944e-21, 0.0282012187983436, 0.259805893621451, 0.198651487281298, 0.0279469677222311, 0.000683599007658395, 1.68245305232397e-06, 8.95497126493507e-11, 3.28155370604677e-19, 0.00228512011469059, 0.1176116952208, 0.247136519222332, 0.0771332015129853, 0.00396291485943565, 2.16380356688241e-05, 3.16506525304045e-09, 6.47975139461908e-17, 0.000127298384102934, 0.0366036777637336, 0.211375541300151, 0.146359435088219, 0.0157943138154778, 0.000191322220571932, 7.69084116491881e-08, 8.79649932754605e-15, 5.15743841004326e-06, 0.00828507108345516, 0.131483071787134, 0.201974896027915, 0.0457808746156233, 0.00123029793528436, 1.35913412883041e-06, 8.68477768326672e-13, 1.56713522764838e-07, 0.001406465286787, 0.0613403449859136, 0.20904285364776, 0.099524194516646, 0.00593357506399473, 1.80140787646642e-05, 6.43085623603483e-11, 3.62810280014245e-09, 0.000181912475769038, 0.0218033524155216, 0.164844304045764, 0.164844304045764, 0.0218033524155216, 0.000181912475769038, 3.62810280014245e-09, 6.43085623603483e-11, 1.80140787646642e-05, 0.00593357506399473, 0.0995241945166462, 0.20904285364776, 0.0613403449859136, 0.001406465286787, 1.56713522764838e-07, 8.68477768326672e-13, 1.35913412883041e-06, 0.00123029793528436, 0.0457808746156234, 0.201974896027915, 0.131483071787134, 0.00828507108345516, 5.15743841004326e-06, 8.79649932754605e-15, 7.69084116491881e-08, 0.000191322220571932, 0.0157943138154779, 0.146359435088219, 0.211375541300151, 0.0366036777637336, 0.000127298384102934, 6.47975139461908e-17, 3.16506525304045e-09, 2.16380356688241e-05, 0.00396291485943566, 0.0771332015129853, 0.247136519222332, 0.1176116952208, 0.00228512011469059, 3.28155370604677e-19, 8.95497126493507e-11, 1.68245305232397e-06, 0.000683599007658396, 0.0279469677222311, 0.198651487281298, 0.259805893621451, 0.0282012187983436, 1.02269780426944e-21, 1.55916601435049e-12, 8.05034905015786e-08, 7.25662599136731e-05, 0.00623124265394479, 0.0982637538480874, 0.353178389843839, 0.214177259647798, 1.47979123861944e-24, 1.26039259762581e-14, 1.78842935111527e-09, 3.57646004274255e-06, 0.000645059766382991, 0.0225673311590701, 0.222907441326673, 0.755203785209844, 

0.798778591818839, 0.301926026421539, 0.0494152662784372, 0.00311297419997282, 6.103515625e-05, 2.52670197270881e-07, 1.01787681567065e-10, 6.19784275326344e-16, 6.71671856426609e-26, 0.180910506955644, 0.377493967469701, 0.165786343450741, 0.0222390538705175, 0.0008544921875, 6.93217160757057e-06, 5.94653091217474e-09, 9.71599226590548e-14, 5.81267242567495e-23, 0.0190233275353167, 0.219131494741148, 0.258238914149295, 0.0737636525244812, 0.00555419921875, 8.83018722636004e-05, 1.61293720659385e-07, 7.07162281584978e-12, 2.33549997700305e-20, 0.00123099365658153, 0.0782791716309913, 0.247537645392351, 0.150561923540369, 0.022216796875, 0.000692176982839029, 2.69226542677398e-06, 3.16736162756075e-10, 5.77471453682488e-18, 5.47643386029536e-05, 0.0192247341896237, 0.163129883757714, 0.211281075170438, 0.06109619140625, 0.00373024277132601, 3.08951985561955e-05, 9.75324011111777e-09, 9.81643682862212e-16, 1.77189172877258e-06, 0.00343377447629657, 0.0781849386478743, 0.215627100859607, 0.1221923828125, 0.0146202346593838, 0.000257846599936199, 2.18422555025854e-07, 1.2135971100888e-13, 4.29969626939405e-08, 0.000459985832746768, 0.0281043752862485, 0.16504689282137, 0.18328857421875, 0.0429766789855871, 0.00161396120284827, 3.66865872267714e-06, 1.12526925858796e-11, 7.9494862640545e-10, 4.69480795302418e-05, 0.00769707042853126, 0.0962525069000398, 0.20947265625, 0.0962525069000398, 0.00769707042853127, 4.69480795302418e-05, 7.94948626405469e-10, 1.12526925858793e-11, 3.66865872267714e-06, 0.00161396120284827, 0.0429766789855871, 0.18328857421875, 0.16504689282137, 0.0281043752862486, 0.000459985832746768, 4.29969626939414e-08, 1.21359711008876e-13, 2.18422555025854e-07, 0.000257846599936198, 0.0146202346593838, 0.1221923828125, 0.215627100859607, 0.0781849386478744, 0.00343377447629657, 1.77189172877261e-06, 9.81643682862178e-16, 9.75324011111777e-09, 3.08951985561954e-05, 0.00373024277132601, 0.06109619140625, 0.211281075170438, 0.163129883757714, 0.0192247341896237, 5.47643386029543e-05, 5.77471453682466e-18, 3.16736162756075e-10, 2.69226542677398e-06, 0.000692176982839029, 0.022216796875, 0.150561923540369, 0.247537645392351, 0.0782791716309913, 0.00123099365658154, 2.33549997700296e-20, 7.07162281584978e-12, 1.61293720659384e-07, 8.83018722636003e-05, 0.00555419921875, 0.0737636525244812, 0.258238914149295, 0.219131494741148, 0.0190233275353168, 5.81267242567468e-23, 9.71599226590548e-14, 5.94653091217472e-09, 6.93217160757057e-06, 0.0008544921875, 0.0222390538705175, 0.165786343450741, 0.377493967469701, 0.180910506955645, 6.71671856426576e-26, 6.19784275326344e-16, 1.01787681567064e-10, 2.52670197270881e-07, 6.103515625e-05, 0.00311297419997282, 0.0494152662784372, 0.301926026421539, 0.798778591818839, 

0.832055371830454, 0.376088753199992, 0.0866508417056446, 0.00943417929311573, 0.000425986140971128, 6.38986441967056e-06, 2.14536636845644e-08, 7.39414306341226e-12, 4.04947054273509e-17, 4.1402457799e-27, 0.153987526383138, 0.380938318370657, 0.231576643265897, 0.0522091060622664, 0.00441819277290271, 0.00012075316532657, 7.59828200329421e-07, 5.422779576375e-10, 7.83592014250648e-15, 4.38479082861165e-24, 0.0132313506020735, 0.17914483665173, 0.287343941195872, 0.134144759044725, 0.0212754704834807, 0.00105947502908717, 1.24943788032778e-05, 1.84646625551596e-08, 7.03990955477805e-13, 2.15604072133849e-21, 0.000699631648462836, 0.0518442462912141, 0.219409773276324, 0.212103481396592, 0.0630464038209102, 0.005720441666645, 0.000126433035266993, 3.86907753996493e-07, 3.89216096274087e-11, 6.52396574890337e-19, 2.54335755319419e-05, 0.0103150072453746, 0.115181464349172, 0.23056563975652, 0.128444102494088, 0.0212344540688766, 0.0008795877292282, 5.57373342936002e-06, 1.47940542827735e-09, 1.35718511537103e-16, 6.72423205720508e-07, 0.00149257379146377, 0.0439750684724893, 0.182279856593151, 0.190311625788588, 0.0573257757328737, 0.00445035916314419, 5.83958866317397e-05, 4.0896008756959e-08, 2.05335389076169e-14, 1.3333348481329e-08, 0.000161980728900856, 0.012591913061405, 0.10807967577489, 0.2114841059672, 0.11607001595319, 0.0168877668675188, 0.000458859346978836, 8.47882957038731e-07, 2.32996708755175e-12, 2.01435706064866e-10, 1.33934226637478e-05, 0.00274711978406668, 0.0488258796229144, 0.179056807051441, 0.179056807051441, 0.0488258796229144, 0.00274711978406668, 1.33934226637477e-05, 2.01435706064866e-10, 2.32996708755175e-12, 8.47882957038736e-07, 0.000458859346978836, 0.0168877668675188, 0.11607001595319, 0.2114841059672, 0.10807967577489, 0.012591913061405, 0.000161980728900855, 1.3333348481329e-08, 2.05335389076169e-14, 4.08960087569593e-08, 5.83958866317397e-05, 0.00445035916314419, 0.0573257757328737, 0.190311625788588, 0.182279856593151, 0.0439750684724893, 0.00149257379146376, 6.72423205720508e-07, 1.35718511537103e-16, 1.47940542827736e-09, 5.57373342936001e-06, 0.0008795877292282, 0.0212344540688766, 0.128444102494088, 0.23056563975652, 0.115181464349172, 0.0103150072453746, 2.54335755319419e-05, 6.52396574890337e-19, 3.89216096274091e-11, 3.86907753996493e-07, 0.000126433035266993, 0.005720441666645, 0.0630464038209102, 0.212103481396592, 0.219409773276324, 0.051844246291214, 0.000699631648462836, 2.15604072133849e-21, 7.03990955477812e-13, 1.84646625551596e-08, 1.24943788032778e-05, 0.00105947502908717, 0.0212754704834807, 0.134144759044725, 0.287343941195872, 0.17914483665173, 0.0132313506020735, 4.38479082861165e-24, 7.83592014250656e-15, 5.422779576375e-10, 7.59828200329421e-07, 0.00012075316532657, 0.00441819277290271, 0.0522091060622664, 0.231576643265897, 0.380938318370657, 0.153987526383138, 4.1402457799e-27, 4.04947054273513e-17, 7.39414306341226e-12, 2.14536636845644e-08, 6.38986441967056e-06, 0.000425986140971128, 0.00943417929311573, 0.0866508417056446, 0.376088753199992, 0.832055371830454, 

0.857928130454034, 0.443188377944622, 0.131449732890717, 0.0212703022054824, 0.00172442623128594, 6.103515625e-05, 7.51456658108843e-07, 2.15971218627114e-09, 6.62595963081957e-13, 3.35203904138456e-18, 3.28074760796553e-28, 0.13218666685593, 0.37133670347712, 0.287026951064134, 0.0942702614643467, 0.013890559856191, 0.0008544921875, 1.82845753462271e-05, 9.55104516779122e-08, 5.94760184002975e-11, 7.8412558576333e-16, 4.17342053350033e-25, 0.00945604905440013, 0.144455044783647, 0.290985245497836, 0.193981844194844, 0.0519493599219006, 0.00555419921875, 0.000206562338235948, 1.96106161886809e-06, 2.47867912746694e-09, 8.51623236584996e-14, 2.46488576690126e-22, 0.000416273165800634, 0.0345815283716681, 0.181537309212508, 0.245637173167206, 0.119560379876591, 0.022216796875, 0.00143603173779204, 2.47786827703842e-05, 6.35689981344407e-08, 5.6918836649438e-12, 8.95876367355328e-20, 1.2598528355082e-05, 0.00569152117940367, 0.0778634283451988, 0.213845344654611, 0.189176451157166, 0.06109619140625, 0.00686356321810926, 0.000215247389896108, 1.12083872286568e-06, 2.61539464356363e-10, 2.23857714827856e-17, 2.77305524359494e-07, 0.000681255201015239, 0.0242883745594472, 0.135395057650766, 0.217692849325377, 0.1221923828125, 0.0238579179043968, 0.00135986211245809, 1.43726942897347e-05, 8.74008681865951e-09, 4.06811624005937e-15, 4.57781764303891e-09, 6.11579006228358e-05, 0.0056823063594564, 0.0642935026217052, 0.187880850222856, 0.18328857421875, 0.0621980407965562, 0.00644337069240951, 0.00013822751899891, 2.19056188477223e-07, 5.54467256869879e-13, 5.75783404966602e-11, 4.18307830886137e-06, 0.00101286491087693, 0.0232611964317222, 0.123543971381537, 0.20947265625, 0.123543971381537, 0.0232611964317222, 0.00101286491087693, 4.18307830886137e-06, 5.75783404966623e-11, 5.54467256869856e-13, 2.19056188477223e-07, 0.00013822751899891, 0.00644337069240952, 0.0621980407965561, 0.18328857421875, 0.187880850222856, 0.0642935026217051, 0.00568230635945639, 6.11579006228358e-05, 4.57781764303905e-09, 4.06811624005918e-15, 8.74008681865951e-09, 1.43726942897348e-05, 0.00135986211245809, 0.0238579179043967, 0.1221923828125, 0.217692849325377, 0.135395057650766, 0.0242883745594471, 0.000681255201015239, 2.77305524359501e-07, 2.23857714827844e-17, 2.61539464356363e-10, 1.12083872286569e-06, 0.000215247389896109, 0.00686356321810924, 0.06109619140625, 0.189176451157166, 0.213845344654611, 0.0778634283451987, 0.00569152117940367, 1.25985283550823e-05, 8.95876367355278e-20, 5.6918836649438e-12, 6.3568998134441e-08, 2.47786827703843e-05, 0.00143603173779204, 0.022216796875, 0.119560379876591, 0.245637173167206, 0.181537309212507, 0.0345815283716681, 0.000416273165800641, 2.46488576690111e-22, 8.51623236584996e-14, 2.47867912746695e-09, 1.9610616188681e-06, 0.000206562338235948, 0.00555419921875, 0.0519493599219006, 0.193981844194844, 0.290985245497836, 0.144455044783647, 0.00945604905440023, 4.17342053350006e-25, 7.8412558576333e-16, 5.94760184002978e-11, 9.55104516779125e-08, 1.82845753462271e-05, 0.0008544921875, 0.013890559856191, 0.0942702614643467, 0.287026951064134, 0.37133670347712, 0.132186666855931, 3.2807476079653e-28, 3.35203904138456e-18, 6.62595963081961e-13, 2.15971218627114e-09, 7.51456658108842e-07, 6.103515625e-05, 0.00172442623128594, 0.0212703022054824, 0.131449732890717, 0.443188377944622, 0.857928130454034, 

0.878381507555512, 0.502680114717534, 0.180663931533842, 0.0393436874558342, 0.0048981994983805, 0.000318402678812608, 9.37714643775355e-06, 9.93665006278766e-08, 2.53628531311558e-10, 7.1177390060162e-14, 3.38802337087253e-19, 3.2064447747081e-29, 0.114432617666772, 0.354377797733909, 0.328822614769851, 0.143203866206315, 0.0316931026334294, 0.00346540756382134, 0.000168868701334762, 3.01000889800893e-06, 1.3657603375595e-08, 7.66492498754401e-12, 9.41949607381663e-17, 4.82406540281572e-26, 0.00692152516363609, 0.115991622991616, 0.277867159177687, 0.242002440628356, 0.0952090793277899, 0.0175112539395384, 0.00141192929700039, 4.23331791236656e-05, 3.41457146712934e-07, 3.83229629920415e-10, 1.21588993201425e-14, 3.36967434110781e-23, 0.000257632356753678, 0.0233632566760663, 0.144497188886652, 0.251669961891222, 0.176010513003963, 0.054453626440559, 0.00726479511631774, 0.000366387479074446, 5.25344938290193e-06, 1.17911695749025e-08, 9.65845120302771e-13, 1.44846934843893e-20, 6.5928275059489e-06, 0.00323528718754075, 0.0516599852599716, 0.17993503110253, 0.223702869235992, 0.116415034691496, 0.0256984242295356, 0.00218008318713523, 5.55681067024691e-05, 2.49417770701664e-07, 5.27464724106455e-11, 4.28058761226072e-18, 1.22698801772166e-07, 0.000325828896233164, 0.0134321786534304, 0.0935615407491133, 0.206776796145285, 0.181004194018403, 0.0661130083625357, 0.00943415070214429, 0.000427468334863318, 3.83703007247667e-06, 2.09496442275046e-09, 9.20014713889037e-16, 1.71265620965444e-09, 2.46109070384926e-05, 0.00261938842708312, 0.0364871775678298, 0.14334855282635, 0.211071437244382, 0.127564140772914, 0.0306191983851745, 0.00246628670861344, 4.42715039981073e-05, 6.24052528824334e-08, 1.48302140461032e-13, 1.82138079674047e-11, 1.41633611940769e-06, 0.000389183157505752, 0.0108413624308572, 0.0757156250207597, 0.187530099796912, 0.187530099796912, 0.0757156250207598, 0.0108413624308572, 0.000389183157505753, 1.41633611940771e-06, 1.82138079674039e-11, 1.4830214046104e-13, 6.24052528824328e-08, 4.42715039981072e-05, 0.00246628670861344, 0.0306191983851745, 0.127564140772914, 0.211071437244382, 0.14334855282635, 0.0364871775678299, 0.00261938842708313, 2.46109070384928e-05, 1.71265620965438e-09, 9.20014713889087e-16, 2.09496442275044e-09, 3.83703007247665e-06, 0.000427468334863317, 0.00943415070214427, 0.0661130083625357, 0.181004194018403, 0.206776796145285, 0.0935615407491135, 0.0134321786534305, 0.000325828896233166, 1.22698801772162e-07, 4.28058761226098e-18, 5.27464724106449e-11, 2.49417770701663e-07, 5.55681067024689e-05, 0.00218008318713523, 0.0256984242295356, 0.116415034691496, 0.223702869235992, 0.17993503110253, 0.0516599852599717, 0.00323528718754076, 6.59282750594874e-06, 1.44846934843903e-20, 9.65845120302759e-13, 1.17911695749025e-08, 5.25344938290191e-06, 0.000366387479074445, 0.00726479511631773, 0.054453626440559, 0.176010513003963, 0.251669961891223, 0.144497188886652, 0.0233632566760664, 0.000257632356753674, 3.36967434110805e-23, 1.21588993201423e-14, 3.83229629920413e-10, 3.41457146712933e-07, 4.23331791236655e-05, 0.00141192929700039, 0.0175112539395384, 0.0952090793277899, 0.242002440628356, 0.277867159177687, 0.115991622991616, 0.00692152516363601, 4.8240654028161e-26, 9.41949607381649e-17, 7.66492498754396e-12, 1.36576033755949e-08, 3.01000889800893e-06, 0.000168868701334762, 0.00346540756382134, 0.0316931026334294, 0.143203866206315, 0.328822614769851, 0.354377797733909, 0.114432617666772, 3.20644477470837e-29, 3.38802337087247e-19, 7.11773900601615e-14, 2.53628531311557e-10, 9.93665006278764e-08, 9.37714643775355e-06, 0.000318402678812608, 0.0048981994983805, 0.0393436874558342, 0.180663931533842, 0.502680114717534, 0.878381507555512, 

0.894796691735381, 0.55486493409018, 0.231591888542764, 0.0634012211540223, 0.0109246775282168, 0.00111305529849408, 6.103515625e-05, 1.55894269820969e-06, 1.46993189247965e-08, 3.41984562205055e-11, 8.95024244438722e-15, 4.06143157906701e-20, 3.74366200153977e-30, 0.0998603953829449, 0.333805359472724, 0.357098406693438, 0.193294345569945, 0.0582333213826963, 0.00974563228046152, 0.0008544921875, 3.48973897793032e-05, 5.40493343049544e-07, 2.19857378856876e-09, 1.13769618767461e-12, 1.32321125676991e-17, 6.57481884361709e-27, 0.0051742512555352, 0.0932362187346985, 0.255645293483706, 0.273606239945348, 0.144118527711103, 0.0396176417921838, 0.00555419921875, 0.000362694572978702, 9.22717605362969e-06, 6.56237299384739e-08, 6.71433687227481e-11, 2.00154128867384e-15, 5.36112918038763e-24, 0.000164986489097267, 0.0160259075669835, 0.112624875910726, 0.238330421183217, 0.219489984152853, 0.0991091738332565, 0.022216796875, 0.00231972127164159, 9.69379651951082e-05, 1.20538952001276e-06, 2.43852148134204e-09, 1.86314456755551e-13, 2.69014313057874e-21, 3.61677881788639e-06, 0.00189379653445038, 0.0341117147883907, 0.142726844972512, 0.229817078776259, 0.1704558039506, 0.06109619140625, 0.0102000724178617, 0.000700150968841022, 1.52218211113449e-05, 6.08867435542366e-08, 1.19234314237615e-11, 9.28041090021405e-19, 5.76624142832349e-08, 0.000162757609776814, 0.00751398078327899, 0.0621625973940599, 0.175003685437906, 0.213209736122664, 0.1221923828125, 0.0326188020483393, 0.00367778884104708, 0.000139798695230572, 1.10564628280013e-06, 5.54949243603187e-10, 2.32839321644118e-16, 6.89485213581809e-10, 1.04908469805401e-05, 0.00124136035585715, 0.0203055100576219, 0.0999478261578619, 0.20001544619157, 0.18328857421875, 0.0782337274296374, 0.0144891580829924, 0.000962943676969326, 1.50581263421586e-05, 1.93716463845729e-08, 4.38133749841099e-14, 6.28141922958836e-12, 5.15205498743238e-07, 0.000156252275658675, 0.00505358228394179, 0.0434910806263117, 0.142962036457835, 0.20947265625, 0.142962036457835, 0.0434910806263117, 0.00505358228394178, 0.000156252275658676, 5.15205498743233e-07, 6.28141922958805e-12, 4.38133749841124e-14, 1.93716463845731e-08, 1.50581263421586e-05, 0.000962943676969329, 0.0144891580829924, 0.0782337274296374, 0.18328857421875, 0.20001544619157, 0.0999478261578619, 0.0203055100576219, 0.00124136035585716, 1.04908469805401e-05, 6.8948521358178e-10, 2.32839321644133e-16, 5.54949243603194e-10, 1.10564628280012e-06, 0.000139798695230572, 0.00367778884104708, 0.0326188020483393, 0.1221923828125, 0.213209736122664, 0.175003685437906, 0.0621625973940598, 0.00751398078327901, 0.000162757609776813, 5.76624142832329e-08, 9.2804109002147e-19, 1.19234314237617e-11, 6.08867435542363e-08, 1.5221821111345e-05, 0.000700150968841022, 0.0102000724178617, 0.06109619140625, 0.1704558039506, 0.229817078776259, 0.142726844972512, 0.0341117147883908, 0.00189379653445037, 3.61677881788629e-06, 2.69014313057895e-21, 1.86314456755554e-13, 2.43852148134203e-09, 1.20538952001277e-06, 9.69379651951082e-05, 0.00231972127164159, 0.022216796875, 0.0991091738332565, 0.219489984152853, 0.238330421183217, 0.112624875910726, 0.0160259075669834, 0.000164986489097263, 5.36112918038809e-24, 2.00154128867387e-15, 6.71433687227477e-11, 6.56237299384741e-08, 9.22717605362969e-06, 0.000362694572978702, 0.00555419921875, 0.0396176417921838, 0.144118527711103, 0.273606239945348, 0.255645293483707, 0.0932362187346983, 0.00517425125553513, 6.57481884361769e-27, 1.32321125676994e-17, 1.1376961876746e-12, 2.19857378856877e-09, 5.40493343049544e-07, 3.48973897793032e-05, 0.0008544921875, 0.00974563228046152, 0.0582333213826963, 0.193294345569945, 0.357098406693438, 0.333805359472724, 0.0998603953829442, 3.74366200154013e-30, 4.06143157906709e-20, 8.95024244438715e-15, 3.41984562205057e-11, 1.46993189247965e-08, 1.55894269820969e-06, 6.103515625e-05, 0.00111305529849408, 0.0109246775282168, 0.0634012211540223, 0.231591888542764, 0.55486493409018, 0.894796691735381, 

0.908151479620035, 0.600412555007255, 0.282221209395259, 0.0925223776099018, 0.0205283803857599, 0.00294798423862868, 0.000256707305613961, 1.23115707340453e-05, 2.80954692054026e-07, 2.4146078770716e-09, 5.21805142702241e-12, 1.29165379004665e-15, 5.64156249151391e-21, 5.09154436705323e-31, 0.0877967746657507, 0.31194225222809, 0.373655791603252, 0.240061256725032, 0.0919428284257169, 0.0213032981324621, 0.00289296424871548, 0.00021412367950053, 7.62027549741992e-06, 1.05667032513721e-07, 3.94175053886687e-10, 1.91214192783778e-13, 2.1282911353352e-18, 1.03225105859118e-27, 0.00394079777874479, 0.0752460943537308, 0.229688424409013, 0.289189610934668, 0.19119051983656, 0.0714749490014689, 0.0151367704854538, 0.00172902491622537, 9.59600304509441e-05, 2.14692923644401e-06, 1.3824684768651e-08, 1.31425442286282e-11, 3.72776039605788e-16, 9.71642409517586e-25, 0.00010885198979879, 0.0111696703723928, 0.0868866661910427, 0.214382797287023, 0.244659161492912, 0.14757320104932, 0.0487382599312558, 0.00859180556957072, 0.000743629681691965, 2.68437128134232e-05, 2.98378807265064e-07, 5.55885575346995e-10, 4.01801523071852e-14, 5.62826091648157e-22, 2.0670990975752e-06, 0.00113990708612021, 0.022596431609853, 0.109262185254667, 0.215243137738155, 0.209475793349683, 0.10788958342164, 0.0293521779522367, 0.00396182928314086, 0.000230749166040097, 4.42744742132782e-06, 1.61645665906495e-08, 2.97747325922803e-12, 2.24137583288574e-19, 2.85485151123402e-08, 8.46049653239323e-05, 0.00427389542038448, 0.040499264197081, 0.137719186184382, 0.216250685021987, 0.173694599047134, 0.0729278692407769, 0.0153508384422931, 0.00144256369515391, 4.77789006733888e-05, 3.41853496673221e-07, 1.60465422043847e-10, 6.49161042982902e-17, 2.95710683177539e-10, 4.70959447788862e-06, 0.000606274335028809, 0.0112586325956371, 0.0660877314461528, 0.167433518300658, 0.209727015213131, 0.13589640913498, 0.0446097416193879, 0.00676380564106074, 0.000386705329106921, 5.42222146194018e-06, 6.48599066135342e-09, 1.41010507991454e-14, 2.33373313699857e-12, 1.99743135630834e-07, 6.552622742045e-05, 0.00238465111590235, 0.0241628372644157, 0.0987706706186377, 0.192940378283031, 0.192940378283031, 0.0987706706186377, 0.0241628372644158, 0.00238465111590236, 6.552622742045e-05, 1.99743135630832e-07, 2.33373313699857e-12, 1.41010507991454e-14, 6.4859906613535e-09, 5.42222146194018e-06, 0.00038670532910692, 0.00676380564106072, 0.0446097416193879, 0.13589640913498, 0.209727015213131, 0.167433518300658, 0.0660877314461529, 0.0112586325956371, 0.000606274335028809, 4.70959447788858e-06, 2.95710683177539e-10, 6.49161042982902e-17, 1.60465422043849e-10, 3.41853496673221e-07, 4.77789006733886e-05, 0.0014425636951539, 0.0153508384422931, 0.0729278692407768, 0.173694599047135, 0.216250685021987, 0.137719186184383, 0.040499264197081, 0.00427389542038448, 8.46049653239316e-05, 2.85485151123402e-08, 2.24137583288574e-19, 2.97747325922808e-12, 1.61645665906495e-08, 4.4274474213278e-06, 0.000230749166040096, 0.00396182928314086, 0.0293521779522366, 0.10788958342164, 0.209475793349683, 0.215243137738155, 0.109262185254667, 0.022596431609853, 0.0011399070861202, 2.0670990975752e-06, 5.62826091648157e-22, 4.01801523071859e-14, 5.55885575346995e-10, 2.98378807265063e-07, 2.68437128134231e-05, 0.000743629681691965, 0.0085918055695707, 0.0487382599312558, 0.14757320104932, 0.244659161492912, 0.214382797287024, 0.0868866661910427, 0.0111696703723927, 0.00010885198979879, 9.71642409517586e-25, 3.72776039605795e-16, 1.31425442286282e-11, 1.3824684768651e-08, 2.14692923644401e-06, 9.59600304509441e-05, 0.00172902491622537, 0.0151367704854538, 0.0714749490014689, 0.19119051983656, 0.289189610934668, 0.229688424409013, 0.0752460943537306, 0.00394079777874479, 1.03225105859118e-27, 2.12829113533524e-18, 1.91214192783778e-13, 3.94175053886685e-10, 1.05667032513721e-07, 7.62027549741992e-06, 0.000214123679500529, 0.00289296424871549, 0.0213032981324621, 0.0919428284257169, 0.240061256725032, 0.373655791603252, 0.31194225222809, 0.0877967746657507, 5.09154436705323e-31, 5.64156249151403e-21, 1.29165379004665e-15, 5.21805142702238e-12, 2.41460787707159e-09, 2.80954692054026e-07, 1.23115707340453e-05, 0.000256707305613961, 0.00294798423862868, 0.0205283803857599, 0.0925223776099018, 0.282221209395259, 0.600412555007255, 0.908151479620035, 

0.919150226478255, 0.640107406008909, 0.331197645862801, 0.125480077586222, 0.0340360342536997, 0.00639615498590068, 0.000794629521388627, 6.103515625e-05, 2.62880154464441e-06, 5.47870747824053e-08, 4.36894452245664e-10, 8.89401494199471e-13, 2.10436547567358e-16, 8.91056552012454e-22, 7.90509821684819e-32, 0.0777233895661342, 0.290162827455718, 0.380818203746672, 0.280744725306507, 0.130131955975357, 0.0389135845709989, 0.00739811043958409, 0.0008544921875, 5.53423705606815e-05, 1.76502932273007e-06, 2.2396883750532e-08, 7.79142867301218e-11, 3.58712722777738e-14, 3.8527640845995e-19, 1.83230643948252e-28, 0.00305142209662564, 0.0610683263803825, 0.203298175092008, 0.291631044416046, 0.231001225596779, 0.109918000275887, 0.0319788061084785, 0.00555419921875, 0.000540932450646046, 2.64004334651852e-05, 5.33069681527547e-07, 3.16899580830958e-09, 2.83894980392505e-12, 7.73436897366052e-17, 1.9718517788385e-25, 7.37224018802843e-05, 0.00790927901169573, 0.0667876088325528, 0.186424306278931, 0.252342990335695, 0.191065833816877, 0.0850648843980017, 0.022216796875, 0.00325368082576747, 0.000243005903876338, 7.80776986735607e-06, 7.93182027193064e-08, 1.38265962660898e-10, 9.55485258530112e-15, 1.30586132535162e-22, 1.22452982650064e-06, 0.000704255872192209, 0.0150845032201668, 0.0819302010638312, 0.18951383014246, 0.228333667123227, 0.15556471187529, 0.06109619140625, 0.0134548717608544, 0.00153778384776077, 7.8621753937022e-05, 1.36488722088565e-06, 4.62962220319222e-09, 8.11513591651081e-13, 5.94555711946987e-20, 1.4792329137864e-08, 4.56059345240437e-05, 0.00247778392512853, 0.0261868226806955, 0.103511326584032, 0.19845140189898, 0.206904131867691, 0.1221923828125, 0.0404651802726637, 0.00707735640750615, 0.00057577891088188, 1.70811840443783e-05, 1.12738726446595e-07, 5.01262143401763e-11, 1.96872634731147e-17, 1.34018582022746e-10, 2.21499885120273e-06, 0.000305251012745522, 0.00627744415251643, 0.0424029530844731, 0.129359894924354, 0.206389928994187, 0.18328857421875, 0.0912734905766504, 0.0244291356967065, 0.00316249642384487, 0.000160324701499111, 2.05902661431579e-06, 2.32217678477062e-09, 4.88921814144135e-15, 9.25111678652816e-13, 8.19646028970671e-08, 2.8651771820609e-05, 0.00114652517648595, 0.013234423265513, 0.0642459602980638, 0.156858669736691, 0.20947265625, 0.156858669736691, 0.0642459602980638, 0.013234423265513, 0.00114652517648594, 2.86517718206092e-05, 8.19646028970671e-08, 9.25111678652876e-13, 4.88921814144099e-15, 2.32217678477062e-09, 2.05902661431578e-06, 0.000160324701499111, 0.00316249642384487, 0.0244291356967065, 0.0912734905766504, 0.18328857421875, 0.206389928994187, 0.129359894924354, 0.0424029530844731, 0.00627744415251641, 0.000305251012745523, 2.21499885120273e-06, 1.34018582022754e-10, 1.96872634731131e-17, 5.01262143401763e-11, 1.12738726446594e-07, 1.70811840443783e-05, 0.00057577891088188, 0.00707735640750615, 0.0404651802726638, 0.1221923828125, 0.206904131867691, 0.19845140189898, 0.103511326584032, 0.0261868226806955, 0.00247778392512854, 4.56059345240437e-05, 1.47923291378647e-08, 5.94555711946932e-20, 8.11513591651081e-13, 4.62962220319218e-09, 1.36488722088565e-06, 7.8621753937022e-05, 0.00153778384776077, 0.0134548717608544, 0.06109619140625, 0.15556471187529, 0.228333667123227, 0.18951383014246, 0.081930201063831, 0.0150845032201669, 0.000704255872192209, 1.22452982650069e-06, 1.30586132535149e-22, 9.55485258530112e-15, 1.38265962660897e-10, 7.93182027193068e-08, 7.80776986735607e-06, 0.000243005903876338, 0.00325368082576747, 0.022216796875, 0.0850648843980017, 0.191065833816877, 0.252342990335695, 0.186424306278931, 0.0667876088325529, 0.00790927901169573, 7.37224018802863e-05, 1.97185177883828e-25, 7.73436897366052e-17, 2.83894980392502e-12, 3.1689958083096e-09, 5.33069681527547e-07, 2.64004334651852e-05, 0.000540932450646046, 0.00555419921875, 0.0319788061084785, 0.109918000275887, 0.231001225596779, 0.291631044416045, 0.203298175092008, 0.0610683263803825, 0.0030514220966257, 1.8323064394823e-28, 3.8527640845995e-19, 3.58712722777735e-14, 7.79142867301222e-11, 2.2396883750532e-08, 1.76502932273007e-06, 5.53423705606815e-05, 0.0008544921875, 0.00739811043958409, 0.0389135845709989, 0.130131955975357, 0.280744725306507, 0.380818203746672, 0.290162827455718, 0.077723389566135, 7.90509821684716e-32, 8.91056552012454e-22, 2.10436547567356e-16, 8.89401494199476e-13, 4.36894452245664e-10, 5.47870747824053e-08, 2.62880154464441e-06, 6.103515625e-05, 0.000794629521388627, 0.00639615498590068, 0.0340360342536997, 0.125480077586222, 0.331197645862801, 0.640107406008909, 0.919150226478255, 

0.92830888838185, 0.674723607069868, 0.377694981009437, 0.161012890325409, 0.0513823822686537, 0.0119744441269631, 0.0019684839971401, 0.000217493955230645, 1.50860701659776e-05, 5.95221404252266e-07, 1.15181268887491e-08, 8.63846513621983e-11, 1.67440617604449e-13, 3.81731583436539e-17, 1.57564129551466e-22, 1.3782431505093e-32, 0.0692413907916528, 0.269237010010375, 0.38083941004206, 0.314094348731462, 0.169902985674908, 0.0623170259657261, 0.0154479337876898, 0.00251651035638298, 0.00025555281183277, 1.48660675094341e-05, 4.33797028803672e-07, 5.12042349060439e-09, 1.6823541046888e-11, 7.42016384690995e-15, 7.73935151597904e-20, 3.62166803784355e-29, 0.00239786306060544, 0.0498802858150853, 0.178290365236005, 0.284475533110945, 0.260839348365772, 0.150571714861163, 0.0562852022622884, 0.0135187200247, 0.00200988183593633, 0.000172384805109671, 7.58536718505357e-06, 1.40916062231118e-07, 7.8480060280327e-10, 6.69659782602804e-13, 1.76496911982793e-17, 4.41851932578541e-26, 5.11010244610841e-05, 0.00568682340891618, 0.0513641966792451, 0.158553689391729, 0.246429012725624, 0.223885882425191, 0.126201552498238, 0.044690895840724, 0.00972762950900399, 0.00123012288587223, 8.1623136396677e-05, 2.38650171520578e-06, 2.25293093563193e-08, 3.71913184492143e-11, 2.47694455259606e-15, 3.31735166114042e-23, 7.48699492649584e-07, 0.000445741688716653, 0.010173393156695, 0.0607547847773012, 0.160060168650594, 0.228866761409494, 0.194539531862892, 0.101572291243964, 0.0323680264399718, 0.00603490887988328, 0.000603841074529163, 2.77866189504756e-05, 4.44640616423535e-07, 1.42004345370365e-09, 2.38983634064826e-13, 1.71229649508867e-20, 7.97779316851973e-09, 2.54093799614624e-05, 0.00146544140594491, 0.0169309732357277, 0.0756087407524717, 0.170151601458504, 0.218096319783743, 0.16789151191806, 0.0783290249993748, 0.0215322908610623, 0.00324884749714735, 0.00023529189197864, 6.38215998051512e-06, 3.94329252483569e-08, 1.67693928439437e-11, 6.42782027589935e-18, 6.37557369123275e-11, 1.08634093417115e-06, 0.000158318749790321, 0.0035387071457789, 0.0267868720542858, 0.0948747449190294, 0.183379199002865, 0.20813422215535, 0.142164278274685, 0.0576197038290273, 0.013109836145153, 0.00149430579867132, 6.87048672215038e-05, 8.21254231474564e-07, 8.82526550787453e-10, 1.80971316669327e-15, 3.88200825859944e-13, 3.5386605885085e-08, 1.30315757532109e-05, 0.000563518282729281, 0.00723057257350457, 0.0403056462983625, 0.117476904255276, 0.19658887456462, 0.19658887456462, 0.117476904255276, 0.0403056462983625, 0.00723057257350457, 0.000563518282729279, 1.3031575753211e-05, 3.5386605885085e-08, 3.88200825859916e-13, 1.80971316669343e-15, 8.82526550787453e-10, 8.21254231474559e-07, 6.87048672215041e-05, 0.00149430579867132, 0.013109836145153, 0.0576197038290273, 0.142164278274685, 0.20813422215535, 0.183379199002865, 0.0948747449190294, 0.0267868720542858, 0.00353870714577889, 0.000158318749790322, 1.08634093417115e-06, 6.37557369123235e-11, 6.42782027589995e-18, 1.67693928439437e-11, 3.94329252483566e-08, 6.38215998051515e-06, 0.00023529189197864, 0.00324884749714735, 0.0215322908610624, 0.0783290249993747, 0.16789151191806, 0.218096319783743, 0.170151601458504, 0.0756087407524717, 0.0169309732357276, 0.00146544140594492, 2.54093799614624e-05, 7.97779316851931e-09, 1.71229649508885e-20, 2.38983634064826e-13, 1.42004345370364e-09, 4.44640616423537e-07, 2.77866189504756e-05, 0.000603841074529163, 0.00603490887988329, 0.0323680264399718, 0.101572291243963, 0.194539531862892, 0.228866761409494, 0.160060168650594, 0.0607547847773011, 0.010173393156695, 0.000445741688716653, 7.48699492649553e-07, 3.3173516611408e-23, 2.47694455259606e-15, 3.7191318449214e-11, 2.25293093563195e-08, 2.38650171520578e-06, 8.1623136396677e-05, 0.00123012288587223, 0.00972762950900399, 0.0446908958407239, 0.126201552498238, 0.223885882425191, 0.246429012725624, 0.158553689391728, 0.0513641966792452, 0.00568682340891618, 5.11010244610825e-05, 4.41851932578596e-26, 1.76496911982793e-17, 6.69659782602797e-13, 7.84800602803274e-10, 1.40916062231118e-07, 7.58536718505357e-06, 0.000172384805109671, 0.00200988183593632, 0.0135187200247, 0.0562852022622884, 0.150571714861163, 0.260839348365772, 0.284475533110945, 0.178290365236005, 0.0498802858150853, 0.00239786306060539, 3.62166803784404e-29, 7.73935151597904e-20, 7.42016384690987e-15, 1.68235410468881e-11, 5.12042349060439e-09, 4.33797028803672e-07, 1.48660675094342e-05, 0.00025555281183277, 0.00251651035638297, 0.0154479337876898, 0.0623170259657261, 0.169902985674908, 0.314094348731462, 0.380839410042061, 0.269237010010375, 0.069241390791652, 1.3782431505095e-32, 1.57564129551466e-22, 3.81731583436535e-17, 1.6744061760445e-13, 8.63846513621983e-11, 1.15181268887491e-08, 5.95221404252267e-07, 1.50860701659776e-05, 0.000217493955230644, 0.0019684839971401, 0.0119744441269631, 0.0513823822686537, 0.161012890325409, 0.377694981009437, 0.674723607069868, 0.92830888838185, 

0.936011420906696, 0.704969843852267, 0.421272732950795, 0.1979836963965, 0.0722033589957216, 0.0200484740184243, 0.00412855333974618, 0.000608292785002365, 6.103515625e-05, 3.89227113016622e-06, 1.42834843823859e-07, 2.5992490219922e-09, 1.85263094138757e-11, 3.44754977375801e-14, 7.62058037292775e-18, 3.07932167296878e-23, 2.66202695763694e-33, 0.0620426002048534, 0.249560611491814, 0.375658439374046, 0.339931827842335, 0.208751952204349, 0.0904199187691077, 0.0277514492999648, 0.0059365328292988, 0.0008544921875, 7.81697904671442e-05, 4.1648797496989e-06, 1.1295908611804e-07, 1.25594852670226e-09, 3.93553895209475e-12, 1.6749981026431e-15, 1.7049263726894e-20, 7.87153947237832e-30, 0.00190934388515173, 0.0410172805650967, 0.155527886640952, 0.270981443328865, 0.28021347127761, 0.189335575464108, 0.0866081493351363, 0.0268991404967024, 0.00555419921875, 0.000728886877767901, 5.63840269857797e-05, 2.27918601780491e-06, 3.95312083409993e-08, 2.08585063697731e-10, 1.70932998844085e-13, 4.38269773867836e-18, 1.08066783918828e-26, 3.61597112031877e-05, 0.00414862633945999, 0.0396250685158924, 0.132933337468436, 0.231469679039743, 0.243975923238191, 0.166333023939746, 0.0750050608033028, 0.022216796875, 0.00418242296107426, 0.0004697387074326, 2.82999070100563e-05, 7.65693522122379e-07, 6.80313097605935e-09, 1.07345573145984e-11, 6.93304542063086e-16, 9.13001331914333e-24, 4.70802168258128e-07, 0.000288479183256386, 0.00694071935297591, 0.0448333269447261, 0.131453426555305, 0.216139637490938, 0.219619505871138, 0.143785613277228, 0.06109619140625, 0.0164994121471038, 0.00269047715685187, 0.000241581096160397, 1.01962989158955e-05, 1.52548225657402e-07, 4.63463000384637e-10, 7.54013763862257e-14, 5.30302039878999e-21, 4.45809436698085e-09, 1.45888796326218e-05, 0.000884170954325927, 0.0109967747373445, 0.0542933969496529, 0.139257684341568, 0.210892259031791, 0.200464558854971, 0.1221923828125, 0.0473376063646522, 0.0112072632055465, 0.00149981671160636, 9.87478040410348e-05, 2.48772740702252e-06, 1.45526907456956e-08, 5.96391992368413e-12, 2.2401262033026e-18, 3.16607591121102e-11, 5.53338216295067e-07, 8.44752074731021e-05, 0.00202297703848169, 0.0168183498306854, 0.0672922706587845, 0.151883861851602, 0.20961436148398, 0.18328857421875, 0.101860400677734, 0.0350131429954316, 0.00698352500723051, 0.000717255021897585, 3.0427038523296e-05, 3.42714749231479e-07, 3.53790035681108e-10, 7.09713290165913e-16, 1.7131448210645e-13, 1.59904276380592e-08, 6.14926172921822e-06, 0.000283541913470246, 0.00396935952287409, 0.0247748985525189, 0.0833418835240336, 0.166995648379586, 0.20947265625, 0.166995648379586, 0.0833418835240336, 0.0247748985525189, 0.00396935952287408, 0.000283541913470245, 6.14926172921822e-06, 1.59904276380589e-08, 1.71314482106464e-13, 7.09713290165846e-16, 3.53790035681114e-10, 3.42714749231479e-07, 3.04270385232961e-05, 0.000717255021897587, 0.00698352500723052, 0.0350131429954316, 0.101860400677734, 0.18328857421875, 0.20961436148398, 0.151883861851602, 0.0672922706587844, 0.0168183498306854, 0.00202297703848168, 8.44752074731021e-05, 5.53338216295059e-07, 3.16607591121125e-11, 2.24012620330236e-18, 5.96391992368425e-12, 1.45526907456956e-08, 2.48772740702253e-06, 9.8747804041035e-05, 0.00149981671160637, 0.0112072632055465, 0.0473376063646522, 0.1221923828125, 0.200464558854971, 0.210892259031791, 0.139257684341567, 0.0542933969496528, 0.0109967747373445, 0.000884170954325926, 1.45888796326217e-05, 4.45809436698111e-09, 5.30302039878937e-21, 7.54013763862274e-14, 4.63463000384637e-10, 1.52548225657403e-07, 1.01962989158955e-05, 0.000241581096160398, 0.00269047715685187, 0.0164994121471038, 0.06109619140625, 0.143785613277228, 0.219619505871138, 0.216139637490938, 0.131453426555305, 0.044833326944726, 0.00694071935297591, 0.000288479183256383, 4.7080216825815e-07, 9.13001331914215e-24, 6.93304542063103e-16, 1.07345573145984e-11, 6.80313097605939e-09, 7.65693522122382e-07, 2.82999070100564e-05, 0.000469738707432601, 0.00418242296107426, 0.022216796875, 0.0750050608033028, 0.166333023939746, 0.243975923238191, 0.231469679039742, 0.132933337468436, 0.0396250685158924, 0.00414862633945997, 3.61597112031889e-05, 1.08066783918813e-26, 4.38269773867848e-18, 1.70932998844085e-13, 2.08585063697732e-10, 3.95312083409994e-08, 2.27918601780491e-06, 5.63840269857797e-05, 0.000728886877767901, 0.00555419921875, 0.0268991404967024, 0.0866081493351363, 0.189335575464108, 0.28021347127761, 0.270981443328864, 0.155527886640952, 0.0410172805650965, 0.00190934388515177, 7.87153947237711e-30, 1.70492637268945e-20, 1.6749981026431e-15, 3.93553895209477e-12, 1.25594852670227e-09, 1.1295908611804e-07, 4.16487974969889e-06, 7.81697904671442e-05, 0.0008544921875, 0.0059365328292988, 0.0277514492999648, 0.0904199187691077, 0.208751952204349, 0.339931827842335, 0.375658439374046, 0.249560611491813, 0.0620426002048541, 2.6620269576365e-33, 3.07932167296888e-23, 7.62058037292775e-18, 3.44754977375804e-14, 1.85263094138758e-11, 2.59924902199221e-09, 1.42834843823859e-07, 3.89227113016622e-06, 6.103515625e-05, 0.000608292785002365, 0.00412855333974618, 0.0200484740184243, 0.0722033589957216, 0.1979836963965, 0.421272732950795, 0.704969843852267, 0.936011420906696, 

0.942547768298974, 0.731470303097805, 0.461755083245601, 0.235449108772402, 0.0959534031701987, 0.030791523883458, 0.00762419881163833, 0.0014173859206856, 0.000190693321203044, 1.76591672324347e-05, 1.04984981410186e-06, 3.62606143360211e-08, 6.26734307867869e-10, 4.28020855911331e-12, 7.69680804895729e-15, 1.65767872991826e-18, 6.57955393776494e-24, 5.63183438625465e-34, 0.0558873218393644, 0.231303316462898, 0.366838261393549, 0.35873100603862, 0.24482748516434, 0.121668243685436, 0.0444759438165118, 0.0118582046245149, 0.00225243213051513, 0.000293028633319445, 2.4595316822595e-05, 1.21831690044894e-06, 3.10880501735622e-08, 3.28791978322584e-10, 9.90136025999192e-13, 4.08971924291485e-16, 4.07818912324132e-21, 1.86164135347267e-30, 0.00153853913739171, 0.0339588005019295, 0.135307817449829, 0.253761715177574, 0.290031575464839, 0.223207414050334, 0.120459610408736, 0.0460611829052134, 0.0123524545884544, 0.00225753878706525, 0.000267524146896919, 1.90051237038604e-05, 7.15960100578662e-07, 1.17263490260837e-08, 5.91376946163589e-11, 4.68459387110652e-14, 1.17360943825328e-18, 2.85711341903321e-27, 2.60645620991546e-05, 0.00306809962889926, 0.0307126850248758, 0.110466328862033, 0.211435071289929, 0.25199192709061, 0.200772566293207, 0.110102674460849, 0.0416870777947603, 0.0107030367486792, 0.00179068909591829, 0.000182443236297016, 1.01468395092462e-05, 2.57365929823214e-07, 2.17360464092006e-09, 3.30215178164916e-12, 2.07838720257586e-16, 2.69839534517541e-24, 3.03574312395154e-07, 0.000190572081336262, 0.00479275672655462, 0.0330602736510297, 0.105969643627813, 0.195585809581834, 0.230059403122249, 0.180939486009508, 0.0967213483201027, 0.0348860271886362, 0.00824043414159503, 0.00120408608252523, 9.88656587998961e-05, 3.88339882340375e-06, 5.49249180476857e-08, 1.600275733337e-10, 2.53047486739193e-14, 1.75208987360156e-21, 2.57144304126893e-09, 8.60887492173231e-06, 0.000543939110532569, 0.00719581962718034, 0.0386263101165881, 0.110404139750011, 0.19172242300971, 0.216254990305115, 0.163207658160626, 0.0826976779213586, 0.0275789227517334, 0.0057794246725023, 0.000700579523920145, 4.26157598940867e-05, 1.00938206625304e-06, 5.64014032951861e-09, 2.24065451819083e-12, 8.27378977635272e-19, 1.63361631184806e-11, 2.91672028629658e-07, 4.62995160479888e-05, 0.00117466859137676, 0.0105595700486383, 0.0467406381628625, 0.119830423096797, 0.193847492316055, 0.20654752139714, 0.147026757230166, 0.0692254467795723, 0.0208052501581185, 0.00372332270345949, 0.000350743589688528, 1.39124307129875e-05, 1.49089226971814e-07, 1.4880209050634e-10, 2.93031189330043e-16, 7.90722144357217e-14, 7.52911367869428e-09, 3.00264026548908e-06, 0.000146100308346495, 0.0021994289438969, 0.015076641394881, 0.057063967590489, 0.132389921375707, 0.199159088610741, 0.199159088610741, 0.132389921375707, 0.057063967590489, 0.015076641394881, 0.0021994289438969, 0.000146100308346496, 3.00264026548908e-06, 7.52911367869428e-09, 7.90722144357217e-14, 2.93031189330043e-16, 1.4880209050634e-10, 1.49089226971814e-07, 1.39124307129874e-05, 0.000350743589688528, 0.00372332270345949, 0.0208052501581185, 0.0692254467795723, 0.147026757230166, 0.20654752139714, 0.193847492316055, 0.119830423096797, 0.0467406381628625, 0.0105595700486383, 0.00117466859137677, 4.62995160479888e-05, 2.91672028629658e-07, 1.63361631184806e-11, 8.27378977635272e-19, 2.24065451819083e-12, 5.64014032951861e-09, 1.00938206625304e-06, 4.26157598940867e-05, 0.000700579523920145, 0.0057794246725023, 0.0275789227517334, 0.0826976779213587, 0.163207658160626, 0.216254990305115, 0.19172242300971, 0.110404139750011, 0.0386263101165881, 0.00719581962718036, 0.000543939110532569, 8.60887492173231e-06, 2.57144304126893e-09, 1.75208987360156e-21, 2.53047486739193e-14, 1.600275733337e-10, 5.49249180476854e-08, 3.88339882340375e-06, 9.88656587998961e-05, 0.00120408608252523, 0.00824043414159503, 0.0348860271886362, 0.0967213483201027, 0.180939486009508, 0.230059403122249, 0.195585809581834, 0.105969643627813, 0.0330602736510298, 0.00479275672655462, 0.000190572081336261, 3.03574312395154e-07, 2.69839534517541e-24, 2.07838720257586e-16, 3.30215178164916e-12, 2.17360464092004e-09, 2.57365929823214e-07, 1.01468395092462e-05, 0.000182443236297016, 0.00179068909591829, 0.0107030367486792, 0.0416870777947603, 0.110102674460849, 0.200772566293207, 0.25199192709061, 0.211435071289929, 0.110466328862034, 0.0307126850248757, 0.00306809962889926, 2.60645620991546e-05, 2.85711341903321e-27, 1.17360943825328e-18, 4.68459387110652e-14, 5.91376946163585e-11, 1.17263490260837e-08, 7.15960100578662e-07, 1.90051237038604e-05, 0.000267524146896919, 0.00225753878706525, 0.0123524545884544, 0.0460611829052134, 0.120459610408736, 0.223207414050334, 0.290031575464839, 0.253761715177574, 0.135307817449829, 0.0339588005019295, 0.00153853913739171, 1.86164135347267e-30, 4.07818912324132e-21, 4.08971924291485e-16, 9.90136025999185e-13, 3.28791978322584e-10, 3.10880501735622e-08, 1.21831690044894e-06, 2.4595316822595e-05, 0.000293028633319445, 0.00225243213051513, 0.0118582046245149, 0.0444759438165118, 0.121668243685436, 0.24482748516434, 0.35873100603862, 0.366838261393549, 0.231303316462898, 0.0558873218393644, 5.63183438625465e-34, 6.57955393776494e-24, 1.65767872991826e-18, 7.69680804895723e-15, 4.28020855911331e-12, 6.26734307867869e-10, 3.62606143360211e-08, 1.04984981410186e-06, 1.76591672324347e-05, 0.000190693321203044, 0.0014173859206856, 0.00762419881163833, 0.030791523883458, 0.0959534031701987, 0.235449108772402, 0.461755083245601, 0.731470303097805, 0.942547768298974, 

0.948139868272578, 0.754763230860369, 0.499138640112703, 0.272672701889423, 0.122009248453586, 0.0441907797097743, 0.0127504353282685, 0.00286924861658636, 0.000489633873389485, 6.103515625e-05, 5.28315737317772e-06, 2.96039112011097e-07, 9.71425400456032e-09, 1.60740563345792e-10, 1.0587073889617e-12, 1.84926744321247e-15, 3.89586750575591e-19, 1.52299180260258e-24, 1.29268497364195e-34, 0.0505876786170866, 0.214501674597545, 0.355588749577277, 0.371299055546915, 0.27695250739236, 0.154404253050786, 0.0652596581299206, 0.0208522054874698, 0.00496022148146164, 0.0008544921875, 0.000102216264401206, 7.98401508983436e-06, 3.72002402638748e-07, 9.01683168849563e-09, 9.14154215061478e-11, 2.66178891580461e-13, 1.07184856155888e-16, 1.05034914188866e-21, 4.74871854273458e-31, 0.00125314814058219, 0.0283032273665633, 0.117614306830517, 0.234742296223332, 0.291879216476313, 0.250479492164995, 0.155077894834407, 0.070359238768191, 0.0233300679395433, 0.00555419921875, 0.000918188361967067, 9.99721256402375e-05, 6.61404820157089e-06, 2.34837669045801e-07, 3.6647833781482e-09, 1.77882334971479e-11, 1.36914044944878e-14, 3.36321882404483e-19, 8.09926259112144e-28, 1.9103225925899e-05, 0.0022982002523294, 0.0239397124436028, 0.0913283238535587, 0.189298719759602, 0.250052801229302, 0.226778372431921, 0.146095521440212, 0.0675270181875727, 0.022216796875, 0.00507563282157349, 0.000770341222098434, 7.23661721659685e-05, 3.76381434926539e-06, 9.04115233174515e-08, 7.31540989815651e-10, 1.07624019491393e-12, 6.62709505589615e-17, 8.50082673619264e-25, 2.00209053429949e-07, 0.000128295811563774, 0.0033500432050917, 0.0244282484433525, 0.0844043606220712, 0.171618450547582, 0.227995394199982, 0.208557290542264, 0.134372947842277, 0.06109619140625, 0.0192895152067896, 0.00408093852492688, 0.000544347896495322, 4.14726062811459e-05, 1.53345828655494e-06, 2.06831752662825e-08, 5.81625068750332e-11, 8.97767702150481e-15, 6.13408163894014e-22, 1.5260122312059e-09, 5.20876051854421e-06, 0.000340940966982479, 0.00475200042962676, 0.0273702896711429, 0.0856630495597369, 0.166704688872184, 0.216526547510807, 0.194465882319262, 0.1221923828125, 0.0533150389131885, 0.0157229585270289, 0.00297793215255124, 0.000332347002200843, 1.89154835805407e-05, 4.25297725860548e-07, 2.28599000785749e-09, 8.84508593037269e-13, 3.21910572793705e-19, 8.72355653963278e-12, 1.5860525263168e-07, 2.60237113039933e-05, 0.000693301081395724, 0.00665664147409921, 0.0320689210708119, 0.0914178114962133, 0.168600240448495, 0.211074736359494, 0.18328857421875, 0.110519627262883, 0.0454328256844607, 0.0122183992474673, 0.00199748472141661, 0.000174994417303091, 6.55888735506509e-06, 6.73855538145764e-08, 6.53583980535339e-11, 1.26701627451289e-16, 3.79952961339518e-14, 3.67960694172095e-09, 1.51342172593408e-06, 7.70669145434653e-05, 0.00123347862287307, 0.00914694050752375, 0.0381957034735659, 0.100024391047618, 0.174553990008823, 0.20947265625, 0.174553990008823, 0.100024391047618, 0.0381957034735659, 0.00914694050752374, 0.00123347862287307, 7.70669145434653e-05, 1.51342172593408e-06, 3.67960694172095e-09, 3.79952961339518e-14, 1.26701627451289e-16, 6.53583980535339e-11, 6.73855538145764e-08, 6.55888735506509e-06, 0.00017499441730309, 0.00199748472141661, 0.0122183992474673, 0.0454328256844606, 0.110519627262883, 0.18328857421875, 0.211074736359494, 0.168600240448495, 0.0914178114962133, 0.0320689210708119, 0.00665664147409923, 0.000693301081395724, 2.60237113039933e-05, 1.5860525263168e-07, 8.72355653963278e-12, 3.21910572793705e-19, 8.84508593037269e-13, 2.28599000785749e-09, 4.25297725860548e-07, 1.89154835805406e-05, 0.000332347002200844, 0.00297793215255124, 0.0157229585270289, 0.0533150389131885, 0.1221923828125, 0.194465882319262, 0.216526547510807, 0.166704688872184, 0.0856630495597368, 0.027370289671143, 0.00475200042962676, 0.000340940966982479, 5.20876051854421e-06, 1.5260122312059e-09, 6.13408163894014e-22, 8.97767702150481e-15, 5.81625068750332e-11, 2.06831752662825e-08, 1.53345828655494e-06, 4.14726062811461e-05, 0.000544347896495322, 0.00408093852492687, 0.0192895152067895, 0.06109619140625, 0.134372947842277, 0.208557290542264, 0.227995394199982, 0.171618450547582, 0.0844043606220713, 0.0244282484433525, 0.0033500432050917, 0.000128295811563774, 2.00209053429949e-07, 8.50082673619264e-25, 6.62709505589615e-17, 1.07624019491393e-12, 7.31540989815651e-10, 9.04115233174511e-08, 3.7638143492654e-06, 7.23661721659685e-05, 0.000770341222098433, 0.00507563282157349, 0.022216796875, 0.0675270181875727, 0.146095521440212, 0.226778372431921, 0.250052801229302, 0.189298719759603, 0.0913283238535587, 0.0239397124436028, 0.0022982002523294, 1.9103225925899e-05, 8.09926259112145e-28, 3.36321882404483e-19, 1.36914044944878e-14, 1.77882334971479e-11, 3.66478337814818e-09, 2.34837669045801e-07, 6.61404820157089e-06, 9.99721256402373e-05, 0.000918188361967067, 0.00555419921875, 0.0233300679395433, 0.070359238768191, 0.155077894834407, 0.250479492164995, 0.291879216476314, 0.234742296223332, 0.117614306830517, 0.0283032273665633, 0.00125314814058218, 4.74871854273458e-31, 1.05034914188866e-21, 1.07184856155888e-16, 2.66178891580461e-13, 9.14154215061473e-11, 9.01683168849567e-09, 3.72002402638748e-07, 7.98401508983434e-06, 0.000102216264401206, 0.0008544921875, 0.00496022148146164, 0.0208522054874698, 0.0652596581299206, 0.154404253050786, 0.27695250739236, 0.371299055546915, 0.355588749577277, 0.214501674597545, 0.0505876786170866, 1.29268497364195e-34, 1.52299180260258e-24, 3.89586750575591e-19, 1.84926744321247e-15, 1.0587073889617e-12, 1.60740563345792e-10, 9.71425400456032e-09, 2.96039112011096e-07, 5.28315737317772e-06, 6.103515625e-05, 0.000489633873389485, 0.00286924861658636, 0.0127504353282685, 0.0441907797097743, 0.122009248453586, 0.272672701889423, 0.499138640112703, 0.754763230860369, 0.948139868272578, 

0.952959738140794, 0.775307385919845, 0.533526411486313, 0.309108531077368, 0.149745956774859, 0.0600821894271157, 0.019712756900282, 0.00520108061592863, 0.001079684337037, 0.000171366658994739, 2.00226725830651e-05, 1.63647217932143e-06, 8.71916136024439e-08, 2.73878243101943e-09, 4.36619072217167e-11, 2.78805855091052e-13, 4.75032484701683e-16, 9.82016240367762e-20, 3.78926074116329e-25, 3.19311095354542e-35, 0.0459952039897145, 0.199116711860785, 0.342820680338386, 0.378564518669278, 0.304524470530507, 0.18711713884995, 0.089346208620609, 0.0331975464625289, 0.00950692279781247, 0.00205804117494257, 0.000326776176837683, 3.64268428225453e-05, 2.67743159665885e-06, 1.18436303088828e-07, 2.74783692892719e-09, 2.68714356276618e-11, 7.60239560721644e-14, 2.99546088189888e-17, 2.89185671669482e-22, 1.29667782547461e-31, 0.00103070852276573, 0.0237425205984481, 0.102273571546578, 0.215255443711615, 0.28752433620129, 0.270561941785855, 0.188014009438443, 0.0983792960037931, 0.0388658754157864, 0.0114753809033691, 0.00247607645242727, 0.000376460797636402, 3.81722161610757e-05, 2.37792127855539e-06, 8.02905679848104e-08, 1.20244485974515e-09, 5.64888771361721e-12, 4.24222750819929e-15, 1.02467082947267e-19, 2.44475576796472e-28, 1.42136566324073e-05, 0.00174217817850808, 0.0187761465831837, 0.0753208156885504, 0.167060453836256, 0.240750102538743, 0.243473068094353, 0.179410587431423, 0.0977785462372914, 0.0393755647115668, 0.0115458084304224, 0.00239422311300983, 0.000334906054907527, 2.93803346520071e-05, 1.44372587189664e-06, 3.31120527620015e-08, 2.5829860075859e-10, 3.69718254300602e-13, 2.23428520232916e-17, 2.83651777587099e-25, 1.34756112810909e-07, 8.78882907670023e-05, 0.00236985739998766, 0.0181195992537478, 0.0667337310581618, 0.147278365904929, 0.216762598471932, 0.224939190770968, 0.169118609869815, 0.0928879082724799, 0.0370132607879164, 0.010468445164056, 0.00202009282835576, 0.000249567889203624, 1.78475106887388e-05, 6.2687325750874e-07, 8.11995958207801e-09, 2.2152387222983e-11, 3.34938867923306e-15, 2.26260239317367e-22, 9.29155563530516e-10, 3.22453257828601e-06, 0.000217538066044491, 0.00317014745878014, 0.0193871717852751, 0.065525257283624, 0.140350857512415, 0.205106531515596, 0.212733813889929, 0.159363504963539, 0.0862954005365273, 0.0332887162839016, 0.00886169821574948, 0.001541764264722, 0.000160460397634494, 8.63119011632537e-06, 1.85644883081241e-07, 9.65311492234034e-10, 3.65165541343189e-13, 1.31258753779489e-19, 4.80495862060343e-12, 8.8728631462346e-08, 1.4976473957449e-05, 0.000415979187908838, 0.00422420293161994, 0.0218645113746205, 0.0681564647568372, 0.140266873214167, 0.20069794037004, 0.2050594678031, 0.15089651644913, 0.0793913480796758, 0.0291557252337766, 0.00714345820557769, 0.00108198026848356, 8.91297905100628e-05, 3.18326916524761e-06, 3.15482796840175e-08, 2.98590023482281e-11, 5.71096599729296e-17, 1.89317848444463e-14, 1.86020790242572e-09, 7.85569432124867e-07, 4.15876547185104e-05, 0.00070125468649903, 0.0055586778504185, 0.0252173664146096, 0.0730855348134351, 0.144261350329007, 0.201034904006164, 0.201034904006164, 0.144261350329007, 0.0730855348134351, 0.0252173664146096, 0.00555867785041849, 0.00070125468649903, 4.15876547185106e-05, 7.85569432124867e-07, 1.86020790242576e-09, 1.89317848444484e-14, 5.71096599729222e-17, 2.98590023482273e-11, 3.15482796840175e-08, 3.1832691652476e-06, 8.91297905100628e-05, 0.00108198026848357, 0.00714345820557769, 0.0291557252337766, 0.0793913480796758, 0.15089651644913, 0.2050594678031, 0.20069794037004, 0.140266873214167, 0.0681564647568372, 0.0218645113746205, 0.00422420293161994, 0.00041597918790884, 1.4976473957449e-05, 8.87286314623477e-08, 4.80495862060389e-12, 1.3125875377947e-19, 3.65165541343179e-13, 9.65311492234034e-10, 1.8564488308124e-07, 8.63119011632537e-06, 0.000160460397634494, 0.001541764264722, 0.00886169821574948, 0.0332887162839016, 0.0862954005365273, 0.159363504963539, 0.212733813889929, 0.205106531515596, 0.140350857512415, 0.0655252572836239, 0.0193871717852751, 0.00317014745878015, 0.000217538066044491, 3.22453257828606e-06, 9.29155563530591e-10, 2.2626023931733e-22, 3.34938867923296e-15, 2.2152387222983e-11, 8.11995958207795e-09, 6.26873257508739e-07, 1.78475106887388e-05, 0.000249567889203624, 0.00202009282835576, 0.010468445164056, 0.0370132607879164, 0.0928879082724799, 0.169118609869815, 0.224939190770968, 0.216762598471932, 0.147278365904929, 0.0667337310581618, 0.0181195992537479, 0.00236985739998766, 8.78882907670034e-05, 1.34756112810917e-07, 2.83651777587049e-25, 2.23428520232909e-17, 3.69718254300602e-13, 2.58298600758588e-10, 3.31120527620015e-08, 1.44372587189665e-06, 2.93803346520071e-05, 0.000334906054907527, 0.00239422311300983, 0.0115458084304224, 0.0393755647115668, 0.0977785462372914, 0.179410587431423, 0.243473068094353, 0.240750102538742, 0.167060453836256, 0.0753208156885505, 0.0187761465831837, 0.0017421781785081, 1.4213656632408e-05, 2.44475576796424e-28, 1.02467082947263e-19, 4.24222750819929e-15, 5.64888771361716e-12, 1.20244485974515e-09, 8.02905679848107e-08, 2.37792127855539e-06, 3.81722161610757e-05, 0.000376460797636402, 0.00247607645242727, 0.0114753809033691, 0.0388658754157864, 0.0983792960037931, 0.188014009438443, 0.270561941785855, 0.28752433620129, 0.215255443711616, 0.102273571546578, 0.0237425205984482, 0.00103070852276576, 1.29667782547433e-31, 2.8918567166947e-22, 2.99546088189888e-17, 7.60239560721637e-14, 2.68714356276618e-11, 2.7478369289272e-09, 1.18436303088828e-07, 2.67743159665885e-06, 3.64268428225453e-05, 0.000326776176837683, 0.00205804117494257, 0.00950692279781247, 0.0331975464625289, 0.089346208620609, 0.18711713884995, 0.304524470530507, 0.378564518669278, 0.342820680338386, 0.199116711860786, 0.0459952039897153, 3.1931109535447e-35, 3.78926074116313e-25, 9.82016240367762e-20, 4.75032484701679e-16, 2.78805855091052e-13, 4.36619072217168e-11, 2.73878243101943e-09, 8.71916136024439e-08, 1.63647217932143e-06, 2.00226725830651e-05, 0.000171366658994739, 0.001079684337037, 0.00520108061592863, 0.019712756900282, 0.0600821894271157, 0.149745956774859, 0.309108531077368, 0.533526411486313, 0.775307385919845, 0.952959738140794, 

0.957142246963524, 0.793491413705889, 0.565082449306372, 0.344372210052135, 0.178584823571755, 0.0781960298818508, 0.0286134789121945, 0.00863337296337772, 0.00211107066117314, 0.000409109602033853, 6.103515625e-05, 6.74697134232639e-06, 5.24949992797838e-07, 2.67844303311987e-08, 8.10294895857634e-10, 1.2510205029548e-11, 7.77804752206823e-14, 1.29710424610374e-16, 2.63806589763678e-20, 1.00655331141852e-25, 8.42923796644396e-36, 0.041991608359522, 0.185069206880177, 0.329205101106246, 0.381450375297386, 0.327375272965254, 0.218576842714819, 0.115760665971048, 0.0488493371576043, 0.0163370916755846, 0.00427198573304412, 0.0008544921875, 0.000126641141362125, 1.32954190302313e-05, 9.27812700493731e-07, 3.92562510009372e-08, 8.77204910716965e-10, 8.31620792396581e-12, 2.29520247523415e-14, 8.87538035821232e-18, 8.45864738971552e-23, 3.76580963717805e-32, 0.000855330293186174, 0.0200406321654373, 0.0890444004774527, 0.196170327106902, 0.278632979490026, 0.28366706411883, 0.217438623635801, 0.128328219379344, 0.0586991811654902, 0.0207111987109029, 0.00555419921875, 0.00110363658179252, 0.000156340481745906, 1.49218796613076e-05, 8.82998287627276e-07, 2.85576852097674e-08, 4.12824446210095e-10, 1.88561249402506e-12, 1.38635236987119e-15, 3.30027691342623e-20, 7.81112758264446e-29, 1.07214082347597e-05, 0.00133547359219605, 0.0148215392022411, 0.062083361061825, 0.14593712931206, 0.226548042513735, 0.251338488381144, 0.20745900760053, 0.129788428703139, 0.0617912971189546, 0.022216796875, 0.00591866819202663, 0.00113132529341189, 0.000147683980088493, 1.22224293507033e-05, 5.72125868339353e-07, 1.26110750289326e-08, 9.53302046598657e-11, 1.33262181684353e-13, 7.92403666265534e-18, 9.97047238435318e-26, 9.23937330097054e-08, 6.11831587572679e-05, 0.00169610487478882, 0.0135079619180115, 0.0525498864265545, 0.124389698930283, 0.199734924486897, 0.230576544499676, 0.197293423432866, 0.126742447957523, 0.06109619140625, 0.0218220025503393, 0.00562828719944487, 0.00100488403257543, 0.000116312907580626, 7.88012069913441e-06, 2.64857035977938e-07, 3.31345674953675e-09, 8.80669409818582e-12, 1.30802267783249e-15, 8.74964516701405e-23, 5.79069242503041e-10, 2.03857074300248e-06, 0.000141159268623299, 0.00213747840800686, 0.0137617944308001, 0.049671333697245, 0.115437343094902, 0.186378262432129, 0.218115507851999, 0.189066320318876, 0.1221923828125, 0.0585143671892613, 0.0203639633069158, 0.00497274059389881, 0.00080499946341865, 7.89353349981811e-05, 4.04546288782351e-06, 8.37585959644034e-08, 4.23268749870568e-10, 1.57029545196086e-13, 5.58421908921556e-20, 2.72194750138915e-12, 5.09425807522405e-08, 8.81104379855006e-06, 0.000253673387541359, 0.00270295997052667, 0.0148760794451671, 0.0500379949139205, 0.112989127263338, 0.180851345439261, 0.211527830977157, 0.18328857421875, 0.117677026649868, 0.0552598401881015, 0.0184559721912634, 0.00417853970111904, 0.00059302268478827, 4.63432184734954e-05, 1.58795698757249e-06, 1.52574081107717e-08, 1.41386757751119e-11, 2.6729800672878e-17, 9.74831780974268e-15, 9.69921945879291e-10, 4.19030860279134e-07, 2.29376419137818e-05, 0.000404487262333457, 0.0033944689843157, 0.0165254830377897, 0.0521889714293821, 0.114250374231844, 0.180310720305516, 0.20947265625, 0.180310720305516, 0.114250374231844, 0.0521889714293822, 0.0165254830377897, 0.0033944689843157, 0.000404487262333457, 2.29376419137818e-05, 4.1903086027913e-07, 9.69921945879314e-10, 9.74831780974147e-15, 2.67298006728818e-17, 1.41386757751115e-11, 1.52574081107718e-08, 1.58795698757249e-06, 4.63432184734954e-05, 0.00059302268478827, 0.00417853970111904, 0.0184559721912633, 0.0552598401881015, 0.117677026649868, 0.18328857421875, 0.211527830977157, 0.180851345439261, 0.112989127263338, 0.0500379949139205, 0.0148760794451671, 0.00270295997052667, 0.000253673387541359, 8.81104379854999e-06, 5.09425807522416e-08, 2.72194750138886e-12, 5.58421908921645e-20, 1.57029545196081e-13, 4.23268749870574e-10, 8.37585959644033e-08, 4.04546288782351e-06, 7.89353349981811e-05, 0.00080499946341865, 0.0049727405938988, 0.0203639633069158, 0.0585143671892613, 0.1221923828125, 0.189066320318876, 0.218115507851999, 0.186378262432129, 0.115437343094902, 0.049671333697245, 0.0137617944308001, 0.00213747840800686, 0.000141159268623298, 2.03857074300252e-06, 5.79069242502989e-10, 8.7496451670156e-23, 1.30802267783245e-15, 8.80669409818594e-12, 3.31345674953675e-09, 2.64857035977938e-07, 7.88012069913441e-06, 0.000116312907580626, 0.00100488403257543, 0.00562828719944487, 0.0218220025503393, 0.06109619140625, 0.126742447957522, 0.197293423432866, 0.230576544499676, 0.199734924486897, 0.124389698930283, 0.0525498864265545, 0.0135079619180115, 0.00169610487478881, 6.11831587572687e-05, 9.23937330096988e-08, 9.97047238435513e-26, 7.92403666265504e-18, 1.33262181684355e-13, 9.53302046598657e-11, 1.26110750289326e-08, 5.72125868339353e-07, 1.22224293507033e-05, 0.000147683980088493, 0.00113132529341189, 0.00591866819202663, 0.022216796875, 0.0617912971189546, 0.129788428703139, 0.207459007600531, 0.251338488381144, 0.226548042513735, 0.14593712931206, 0.062083361061825, 0.0148215392022411, 0.00133547359219607, 1.07214082347591e-05, 7.81112758264613e-29, 3.3002769134261e-20, 1.38635236987122e-15, 1.88561249402506e-12, 4.12824446210095e-10, 2.85576852097674e-08, 8.82998287627276e-07, 1.49218796613076e-05, 0.000156340481745906, 0.00110363658179252, 0.00555419921875, 0.0207111987109029, 0.0586991811654902, 0.128328219379344, 0.217438623635801, 0.28366706411883, 0.278632979490026, 0.196170327106902, 0.0890444004774525, 0.0200406321654374, 0.000855330293186144, 3.76580963717892e-32, 8.45864738971515e-23, 8.87538035821249e-18, 2.29520247523415e-14, 8.31620792396581e-12, 8.77204910716965e-10, 3.92562510009372e-08, 9.27812700493729e-07, 1.32954190302313e-05, 0.000126641141362125, 0.0008544921875, 0.00427198573304412, 0.0163370916755846, 0.0488493371576043, 0.115760665971048, 0.218576842714819, 0.327375272965254, 0.381450375297386, 0.329205101106246, 0.185069206880178, 0.0419916083595212, 8.42923796644606e-36, 1.00655331141847e-25, 2.63806589763683e-20, 1.29710424610374e-16, 7.77804752206823e-14, 1.2510205029548e-11, 8.10294895857634e-10, 2.67844303311986e-08, 5.24949992797838e-07, 6.74697134232639e-06, 6.103515625e-05, 0.000409109602033853, 0.00211107066117314, 0.00863337296337772, 0.0286134789121945, 0.0781960298818508, 0.178584823571755, 0.344372210052135, 0.565082449306372, 0.793491413705889, 0.957142246963524, 

0.960794266397475, 0.809643702061912, 0.594001676572932, 0.3782093752958, 0.208018651652871, 0.098201106959528, 0.0394557276973378, 0.013346205888368, 0.00374821507298041, 0.000858646883039867, 0.000156845197531105, 2.2184297041677e-05, 2.33778195510771e-06, 1.74315327871779e-07, 8.56697558718433e-09, 2.5086815998166e-10, 3.76695602346321e-12, 2.28840989673364e-14, 3.74580706179264e-17, 7.5110292517377e-21, 2.83794585342275e-26, 2.36374651053093e-36, 0.0384818844426053, 0.172261010034294, 0.315227204746366, 0.380806295672822, 0.34563545037939, 0.247876543164056, 0.143470316599072, 0.0674780096096391, 0.0257329184556195, 0.0078836546403814, 0.0019095278961791, 0.000357146962804978, 4.99053470740396e-05, 4.97653551187535e-06, 3.32107862323891e-07, 1.35222704207344e-08, 2.9250114731879e-10, 2.69944128597107e-12, 7.29171433150701e-15, 2.77408334250347e-18, 2.61437046819572e-23, 1.15672745494777e-32, 0.000715595466412723, 0.0170163087757899, 0.0776685204355699, 0.178016914878577, 0.266636502291379, 0.290495761050733, 0.242214075209043, 0.158398851453492, 0.0820236149698211, 0.0336067027716087, 0.0107935947964415, 0.00266952241426746, 0.000494624335118859, 6.59635406632691e-05, 5.97745212011918e-06, 3.38406744557278e-07, 1.05450809661768e-08, 1.47842492335712e-10, 6.59020931554385e-13, 4.75690936488368e-16, 1.11818966546698e-20, 2.6281279660873e-29, 8.1888980545229e-06, 0.00103440440328717, 0.0117764124529295, 0.0512112121334878, 0.12658072014874, 0.209503268438552, 0.251642117692459, 0.228817073769045, 0.160892352710867, 0.088159852266737, 0.0375450638833531, 0.0122791079345679, 0.00301682774397586, 0.000538055958061174, 6.62063567092574e-05, 5.21164755274352e-06, 2.33947763655789e-07, 4.98277525994332e-09, 3.66534961976429e-11, 5.01968984110727e-14, 2.9431368322899e-18, 3.6745876090536e-26, 6.44252408870439e-08, 4.323028175507e-05, 0.00122759097276591, 0.0101284162904088, 0.0413131417520867, 0.10387583036592, 0.179738034619538, 0.227246670527318, 0.216972454269715, 0.15899684441233, 0.0897867574154243, 0.0388304804890442, 0.012650224991077, 0.00301733571496041, 0.000504145593587858, 5.51802633146883e-05, 3.56829359137958e-06, 1.15455872110661e-07, 1.40153615680313e-09, 3.64167842302437e-12, 5.32571762488098e-16, 3.5321847190112e-23, 3.68624281821402e-10, 1.31396281038376e-06, 9.30661324415006e-05, 0.00145685165810842, 0.00980632282085556, 0.0374572177829958, 0.0933671167179399, 0.164136032858441, 0.212799744645183, 0.20854676535108, 0.156159722808596, 0.0893050491967767, 0.0385783179384482, 0.0123060060344005, 0.00279196238896954, 0.000424903003396056, 3.95821667205844e-05, 1.94562014641179e-06, 3.89753934469707e-08, 1.92142573911349e-10, 7.00879116675471e-14, 2.46930940366088e-20, 1.581878382728e-12, 2.99529322441167e-08, 5.29164754370748e-06, 0.000157163027235296, 0.00174576351232066, 0.0101301945729362, 0.0363755166067413, 0.0889142970279578, 0.15653046192017, 0.205153851476498, 0.203698126507922, 0.154042488882328, 0.088236767488905, 0.0376419295426381, 0.0115964327774027, 0.00245390133332687, 0.000329306126760662, 2.45901595448639e-05, 8.12901590322411e-07, 7.60338319740027e-09, 6.9178217489906e-12, 1.29469919102539e-17, 5.17205257472022e-15, 5.2023108978099e-10, 2.29240233019412e-07, 1.29177277223149e-05, 0.000236791073454384, 0.00208737628909396, 0.0107975464303958, 0.0366977936221114, 0.0877257963140808, 0.153764676571771, 0.202444381317722, 0.202444381317722, 0.153764676571771, 0.0877257963140808, 0.0366977936221114, 0.0107975464303958, 0.00208737628909396, 0.000236791073454383, 1.29177277223148e-05, 2.29240233019414e-07, 5.2023108978099e-10, 5.17205257472022e-15, 1.29469919102539e-17, 6.9178217489906e-12, 7.60338319740018e-09, 8.12901590322416e-07, 2.4590159544864e-05, 0.000329306126760662, 0.00245390133332687, 0.0115964327774027, 0.0376419295426381, 0.0882367674889049, 0.154042488882328, 0.203698126507922, 0.205153851476498, 0.15653046192017, 0.0889142970279578, 0.0363755166067413, 0.0101301945729362, 0.00174576351232066, 0.000157163027235295, 5.29164754370752e-06, 2.99529322441167e-08, 1.581878382728e-12, 2.46930940366088e-20, 7.00879116675471e-14, 1.92142573911346e-10, 3.8975393446971e-08, 1.94562014641179e-06, 3.95821667205844e-05, 0.000424903003396056, 0.00279196238896954, 0.0123060060344005, 0.0385783179384482, 0.0893050491967768, 0.156159722808596, 0.20854676535108, 0.212799744645183, 0.164136032858441, 0.0933671167179399, 0.0374572177829958, 0.00980632282085553, 0.00145685165810841, 9.30661324415013e-05, 1.31396281038376e-06, 3.68624281821402e-10, 3.5321847190112e-23, 5.32571762488098e-16, 3.64167842302432e-12, 1.40153615680314e-09, 1.15455872110662e-07, 3.56829359137958e-06, 5.51802633146883e-05, 0.000504145593587858, 0.00301733571496041, 0.012650224991077, 0.0388304804890442, 0.0897867574154243, 0.15899684441233, 0.216972454269715, 0.227246670527318, 0.179738034619538, 0.10387583036592, 0.0413131417520867, 0.0101284162904088, 0.00122759097276592, 4.323028175507e-05, 6.44252408870439e-08, 3.6745876090536e-26, 2.9431368322899e-18, 5.01968984110719e-14, 3.66534961976432e-11, 4.98277525994334e-09, 2.33947763655789e-07, 5.21164755274352e-06, 6.62063567092574e-05, 0.000538055958061174, 0.00301682774397585, 0.0122791079345679, 0.0375450638833531, 0.088159852266737, 0.160892352710867, 0.228817073769045, 0.251642117692459, 0.209503268438552, 0.12658072014874, 0.0512112121334876, 0.0117764124529296, 0.00103440440328717, 8.1888980545229e-06, 2.6281279660873e-29, 1.11818966546698e-20, 4.75690936488359e-16, 6.59020931554392e-13, 1.47842492335713e-10, 1.05450809661768e-08, 3.38406744557278e-07, 5.97745212011918e-06, 6.59635406632691e-05, 0.000494624335118859, 0.00266952241426746, 0.0107935947964415, 0.0336067027716087, 0.0820236149698211, 0.158398851453492, 0.242214075209043, 0.290495761050733, 0.266636502291379, 0.178016914878576, 0.0776685204355701, 0.0170163087757899, 0.000715595466412723, 1.15672745494777e-32, 2.61437046819572e-23, 2.77408334250341e-18, 7.29171433150709e-15, 2.69944128597109e-12, 2.9250114731879e-10, 1.35222704207344e-08, 3.32107862323891e-07, 4.97653551187535e-06, 4.99053470740395e-05, 0.000357146962804978, 0.0019095278961791, 0.0078836546403814, 0.0257329184556195, 0.0674780096096391, 0.143470316599072, 0.247876543164056, 0.34563545037939, 0.380806295672822, 0.315227204746366, 0.172261010034294, 0.0384818844426053, 2.36374651053093e-36, 2.83794585342275e-26, 7.51102925173754e-21, 3.74580706179268e-17, 2.28840989673366e-14, 3.76695602346321e-12, 2.5086815998166e-10, 8.56697558718433e-09, 1.74315327871779e-07, 2.33778195510771e-06, 2.2184297041677e-05, 0.000156845197531105, 0.000858646883039867, 0.00374821507298041, 0.013346205888368, 0.0394557276973378, 0.098201106959528, 0.208018651652871, 0.3782093752958, 0.594001676572932, 0.809643702061912, 0.960794266397475, 

0.964001316787059, 0.824041607852556, 0.620490407599725, 0.4104664302037, 0.23762110905339, 0.119741433716321, 0.052158595501911, 0.0194647870307544, 0.00615324091197491, 0.00162439527197084, 0.000351703639583216, 6.103515625e-05, 8.24225589225623e-06, 8.33198525429233e-07, 5.98682328926317e-08, 2.84778963936682e-09, 8.10567758609169e-11, 1.18793140908799e-12, 7.0720166583614e-15, 1.13888720430998e-17, 2.25554007703641e-21, 8.4496812439108e-27, 7.00449375706336e-37, 0.035389129992081, 0.160587693767394, 0.301231182999322, 0.377378651116915, 0.359621614815066, 0.27441734273807, 0.171503402688596, 0.0885486313054255, 0.037777965288252, 0.0132380436221592, 0.00376588441489061, 0.0008544921875, 0.000150873179035241, 2.0038835167361e-05, 1.9112516198727e-06, 1.22696388777637e-07, 4.83168423269746e-09, 1.01596871748943e-10, 9.15880005498942e-13, 2.42793525547211e-15, 9.10629602464339e-19, 8.49832384989123e-24, 3.73973272731597e-33, 0.000603180740273292, 0.0145298356673288, 0.0678969246685066, 0.161087682025709, 0.252692223022936, 0.291987309523406, 0.261821263631115, 0.187024873645241, 0.107685822239151, 0.0500888683569783, 0.0187215771007606, 0.00555419921875, 0.00128222225395068, 0.00022375965005079, 2.83285675376592e-05, 2.4543753280309e-06, 1.33718988764832e-07, 4.03417401256972e-09, 5.50705231464865e-11, 2.40313855025477e-13, 1.70694017829534e-16, 3.9683644365105e-21, 9.27021268869184e-30, 6.32661898886074e-06, 0.000809013518041763, 0.00941774473380003, 0.042314963578138, 0.10926588810316, 0.19118905773127, 0.245970895808227, 0.243088000840994, 0.188897029469483, 0.116628654848762, 0.0572749224801692, 0.022216796875, 0.0067059639362299, 0.00153757996019504, 0.000258391365642348, 3.02132056878106e-05, 2.27737347509141e-06, 9.85769901317374e-08, 2.03772916265081e-09, 1.46375082821877e-11, 1.96898076089777e-14, 1.14034550661425e-18, 1.41411740125998e-26, 4.56213988543529e-08, 3.09687414957572e-05, 0.000898082902267424, 0.00764184655568013, 0.0324825433291959, 0.0860666287205646, 0.158867562980241, 0.217220283662159, 0.227805618351656, 0.186699010376653, 0.120464558093831, 0.06109619140625, 0.0241119214088101, 0.00726384132148721, 0.00162033227423026, 0.000255696827992108, 2.66654019758755e-05, 1.65603374576656e-06, 5.18377833251154e-08, 6.12954446481137e-10, 1.56148331041798e-12, 2.25285927739581e-16, 1.48304366150371e-23, 2.39255988312529e-10, 8.62161523379929e-07, 6.22849677259978e-05, 0.00100369083038179, 0.00702283968666459, 0.0281775904474245, 0.0746249487898279, 0.141167437967927, 0.199802553893866, 0.217358219062166, 0.184268616615416, 0.1221923828125, 0.0630521248958567, 0.024956994809878, 0.00738971126189397, 0.00157380592316422, 0.000227069766693002, 2.02329921448119e-05, 9.59055378208266e-07, 1.86675166648635e-08, 9.00597055412447e-11, 3.23689771329516e-14, 1.1311487227898e-20, 9.41062133903801e-13, 1.80017605614997e-08, 3.2397486870372e-06, 9.88696196317595e-05, 0.00113877191122519, 0.00691885416472469, 0.0262902140503835, 0.0688065769220107, 0.131431330023936, 0.189789150322344, 0.211399873165878, 0.18328857421875, 0.123659902081573, 0.0643101455249805, 0.0252762196075358, 0.00726504441774855, 0.00145021287301412, 0.000185401100149014, 1.33076757840149e-05, 4.26389163705595e-07, 3.89569512593986e-09, 3.48806966489056e-12, 6.47063265709083e-18, 2.82016467916686e-15, 2.86379556742025e-10, 1.28392628280272e-07, 7.42038532962183e-06, 0.000140689415694736, 0.001294390118229, 0.00705675250281083, 0.0255520683313883, 0.0658714856249889, 0.126260464838681, 0.184781614478124, 0.20947265625, 0.184781614478124, 0.126260464838681, 0.0658714856249889, 0.0255520683313883, 0.00705675250281082, 0.001294390118229, 0.000140689415694736, 7.42038532962183e-06, 1.28392628280273e-07, 2.86379556742025e-10, 2.82016467916644e-15, 6.47063265709192e-18, 3.48806966489056e-12, 3.89569512593981e-09, 4.26389163705595e-07, 1.33076757840149e-05, 0.000185401100149014, 0.00145021287301412, 0.00726504441774854, 0.0252762196075358, 0.0643101455249805, 0.123659902081573, 0.18328857421875, 0.211399873165878, 0.189789150322344, 0.131431330023936, 0.0688065769220108, 0.0262902140503835, 0.0069188541647247, 0.00113877191122519, 9.88696196317595e-05, 3.23974868703723e-06, 1.80017605614997e-08, 9.41062133903681e-13, 1.13114872279002e-20, 3.23689771329516e-14, 9.00597055412433e-11, 1.86675166648635e-08, 9.59055378208266e-07, 2.02329921448118e-05, 0.000227069766693002, 0.00157380592316421, 0.00738971126189396, 0.024956994809878, 0.0630521248958567, 0.1221923828125, 0.184268616615416, 0.217358219062166, 0.199802553893866, 0.141167437967927, 0.0746249487898278, 0.0281775904474246, 0.00702283968666459, 0.00100369083038179, 6.22849677259983e-05, 8.62161523379929e-07, 2.39255988312503e-10, 1.48304366150402e-23, 2.25285927739581e-16, 1.56148331041796e-12, 6.12954446481137e-10, 5.18377833251154e-08, 1.65603374576655e-06, 2.66654019758756e-05, 0.000255696827992107, 0.00162033227423026, 0.00726384132148721, 0.0241119214088101, 0.06109619140625, 0.120464558093831, 0.186699010376653, 0.227805618351656, 0.21722028366216, 0.158867562980241, 0.0860666287205647, 0.0324825433291959, 0.00764184655568012, 0.00089808290226743, 3.09687414957572e-05, 4.5621398854349e-08, 1.41411740126031e-26, 1.14034550661425e-18, 1.96898076089773e-14, 1.46375082821877e-11, 2.03772916265081e-09, 9.85769901317369e-08, 2.27737347509142e-06, 3.02132056878105e-05, 0.000258391365642348, 0.00153757996019504, 0.0067059639362299, 0.022216796875, 0.0572749224801692, 0.116628654848762, 0.188897029469483, 0.243088000840994, 0.245970895808227, 0.191189057731271, 0.10926588810316, 0.042314963578138, 0.00941774473380008, 0.000809013518041763, 6.32661898886034e-06, 9.2702126886942e-30, 3.9683644365105e-21, 1.70694017829531e-16, 2.40313855025477e-13, 5.50705231464865e-11, 4.0341740125697e-09, 1.33718988764832e-07, 2.45437532803089e-06, 2.83285675376592e-05, 0.00022375965005079, 0.00128222225395068, 0.00555419921875, 0.0187215771007606, 0.0500888683569783, 0.107685822239151, 0.187024873645241, 0.261821263631115, 0.291987309523406, 0.252692223022936, 0.161087682025709, 0.0678969246685068, 0.0145298356673288, 0.000603180740273266, 3.73973272731701e-33, 8.49832384989123e-24, 9.1062960246432e-19, 2.42793525547211e-15, 9.15880005498942e-13, 1.01596871748943e-10, 4.83168423269748e-09, 1.22696388777637e-07, 1.9112516198727e-06, 2.0038835167361e-05, 0.000150873179035241, 0.0008544921875, 0.00376588441489061, 0.0132380436221592, 0.037777965288252, 0.0885486313054255, 0.171503402688596, 0.274417342738071, 0.359621614815066, 0.377378651116914, 0.301231182999323, 0.160587693767394, 0.0353891299920803, 7.00449375706544e-37, 8.4496812439108e-27, 2.25554007703636e-21, 1.13888720430998e-17, 7.0720166583614e-15, 1.18793140908798e-12, 8.10567758609172e-11, 2.84778963936681e-09, 5.98682328926317e-08, 8.33198525429233e-07, 8.24225589225623e-06, 6.103515625e-05, 0.000351703639583216, 0.00162439527197084, 0.00615324091197491, 0.0194647870307544, 0.052158595501911, 0.119741433716321, 0.23762110905339, 0.4104664302037, 0.620490407599725, 0.824041607852556, 0.964001316787059, 

0.966832456016739, 0.836919622692484, 0.644754192350639, 0.441065546633236, 0.267046030681879, 0.142463459639, 0.0665773451126075, 0.0270543588670643, 0.00947092928620572, 0.00282317587248396, 0.000706238707053033, 0.000145575386583443, 2.41586334164511e-05, 3.13303998043345e-06, 3.05400132332104e-07, 2.12435889197437e-08, 9.81985151093342e-10, 2.72621107118977e-11, 3.91112780304942e-13, 2.28732590529286e-15, 3.63116182213787e-18, 7.11343832201248e-22, 2.6448489869235e-27, 2.18335423062133e-37, 0.0326506335319127, 0.149945845834879, 0.287455860480514, 0.371802902039138, 0.369751559423692, 0.297863392122962, 0.199021375373196, 0.111410791318685, 0.0523611124684218, 0.020586837327088, 0.00671443004651047, 0.00179267098195397, 0.000384517224370123, 6.4589864152511e-05, 8.20868505373139e-06, 7.53126083767399e-07, 4.67380920610066e-08, 1.78748455633113e-09, 3.66643875276241e-11, 3.23787614981051e-13, 8.44290756154377e-16, 3.12722154213796e-19, 2.89338525360564e-24, 1.26718458706862e-33, 0.000511937949841585, 0.0124729863518713, 0.0595022626542924, 0.145514991014296, 0.237694549126587, 0.289145272682967, 0.276222018406761, 0.213011275191489, 0.134403462460992, 0.0696990169629195, 0.0296382196067184, 0.0102494024437667, 0.00284147967896714, 0.000618227225050495, 0.000102438517925234, 1.23963209097331e-05, 1.03281457871052e-06, 5.44139734388402e-08, 1.59577693133314e-09, 2.12802995948049e-11, 9.11430979351771e-14, 6.38297361084353e-17, 1.4695926398992e-21, 3.41460823007815e-30, 4.93957600182972e-06, 0.000638488516325527, 0.00757953266299101, 0.0350468777015735, 0.0940318683547364, 0.172727583130858, 0.235919315963333, 0.250625098322503, 0.212304247824229, 0.145214608236939, 0.0805084943113927, 0.0360614460894592, 0.0129217086606106, 0.00364148492297529, 0.000786682726782145, 0.000125563833535738, 1.40449557156094e-05, 1.01935443557453e-06, 4.27411856369872e-08, 8.60680329929623e-10, 6.05483304503645e-12, 8.01740981551131e-15, 4.59340043783723e-19, 5.66224319227701e-27, 3.27668521570125e-08, 2.24702775350313e-05, 0.000663779872702493, 0.00580314780144893, 0.025574291482098, 0.0709381729362428, 0.138529226331693, 0.202730565077974, 0.230557690352577, 0.208001594756071, 0.150350196395994, 0.0872289074483578, 0.0403987602700871, 0.0147462505467656, 0.00415344673118945, 0.000874397737022956, 0.0001313079712174, 1.312842707975e-05, 7.8703428294258e-07, 2.39319848896614e-08, 2.76537009090594e-10, 6.92337444070784e-13, 9.87061810124624e-17, 6.45518742360397e-24, 1.58080053081009e-10, 5.75123461215543e-07, 4.22768900017756e-05, 0.000698835940764187, 0.005058589729438, 0.0211882751000927, 0.0591584271695822, 0.119264503158268, 0.182094925733784, 0.216680746811899, 0.204203695294163, 0.153452874967576, 0.0918572485884654, 0.0434292173335437, 0.0159483213258771, 0.0044284402079883, 0.000892810132074928, 0.00012296951986884, 1.05399375468536e-05, 4.83963784413379e-07, 9.18547569015117e-09, 4.34809334814528e-11, 1.54259419505185e-14, 5.35212805999376e-21, 5.71979795213863e-13, 1.104015054303e-08, 2.01949716509029e-06, 6.31172540507021e-05, 0.00075044102596219, 0.00474648891211971, 0.018947551346308, 0.0526216472641322, 0.107864202861608, 0.16929153630056, 0.208010116571268, 0.202465434263481, 0.15664628187534, 0.0959276179505439, 0.0459285328983717, 0.0168210773930782, 0.00455290294571634, 0.000863860311954118, 0.000105862875892992, 7.34020639231128e-06, 2.28829128328491e-07, 2.04805285985503e-09, 1.8080910634466e-12, 3.32816921773199e-18, 1.5768304235443e-15, 1.61469163183593e-10, 7.3499460562184e-08, 4.34331820513605e-06, 8.48211911590661e-05, 0.000810121254018294, 0.00462370645446157, 0.0176896142605053, 0.0486807791499741, 0.100774547446708, 0.161438088183889, 0.203529533487565, 0.203529533487565, 0.161438088183889, 0.100774547446708, 0.0486807791499741, 0.0176896142605052, 0.00462370645446157, 0.000810121254018292, 8.48211911590661e-05, 4.34331820513605e-06, 7.34994605621831e-08, 1.61469163183593e-10, 1.57683042354404e-15, 3.3281692177326e-18, 1.8080910634466e-12, 2.04805285985506e-09, 2.28829128328491e-07, 7.34020639231128e-06, 0.000105862875892993, 0.000863860311954118, 0.00455290294571635, 0.0168210773930782, 0.0459285328983717, 0.0959276179505439, 0.15664628187534, 0.202465434263482, 0.208010116571268, 0.16929153630056, 0.107864202861608, 0.0526216472641321, 0.018947551346308, 0.0047464889121197, 0.00075044102596219, 6.31172540507021e-05, 2.01949716509026e-06, 1.104015054303e-08, 5.71979795213784e-13, 5.35212805999487e-21, 1.54259419505185e-14, 4.34809334814535e-11, 9.18547569015117e-09, 4.83963784413379e-07, 1.05399375468536e-05, 0.00012296951986884, 0.00089281013207493, 0.00442844020798829, 0.0159483213258771, 0.0434292173335437, 0.0918572485884653, 0.153452874967576, 0.204203695294163, 0.216680746811899, 0.182094925733784, 0.119264503158268, 0.0591584271695821, 0.0211882751000927, 0.005058589729438, 0.000698835940764187, 4.22768900017752e-05, 5.75123461215543e-07, 1.58080053080991e-10, 6.45518742360546e-24, 9.87061810124624e-17, 6.92337444070797e-13, 2.76537009090594e-10, 2.39319848896614e-08, 7.87034282942583e-07, 1.312842707975e-05, 0.0001313079712174, 0.000874397737022956, 0.00415344673118945, 0.0147462505467656, 0.0403987602700871, 0.0872289074483578, 0.150350196395994, 0.208001594756071, 0.230557690352577, 0.202730565077974, 0.138529226331693, 0.0709381729362426, 0.025574291482098, 0.00580314780144893, 0.000663779872702488, 2.24702775350313e-05, 3.27668521570095e-08, 5.66224319227845e-27, 4.59340043783723e-19, 8.01740981551147e-15, 6.05483304503645e-12, 8.60680329929623e-10, 4.27411856369874e-08, 1.01935443557453e-06, 1.40449557156094e-05, 0.000125563833535738, 0.000786682726782145, 0.00364148492297529, 0.0129217086606106, 0.0360614460894593, 0.0805084943113927, 0.145214608236939, 0.212304247824229, 0.250625098322503, 0.235919315963333, 0.172727583130858, 0.0940318683547364, 0.0350468777015735, 0.00757953266299097, 0.000638488516325527, 4.93957600182938e-06, 3.41460823007909e-30, 1.4695926398992e-21, 6.38297361084366e-17, 9.11430979351772e-14, 2.12802995948049e-11, 1.59577693133315e-09, 5.44139734388402e-08, 1.03281457871052e-06, 1.23963209097331e-05, 0.000102438517925234, 0.000618227225050495, 0.00284147967896714, 0.0102494024437667, 0.0296382196067184, 0.0696990169629195, 0.134403462460992, 0.213011275191489, 0.276222018406761, 0.289145272682967, 0.237694549126587, 0.145514991014296, 0.0595022626542922, 0.0124729863518713, 0.000511937949841562, 1.267184587069e-33, 2.89338525360564e-24, 3.12722154213803e-19, 8.44290756154377e-16, 3.23787614981051e-13, 3.66643875276244e-11, 1.78748455633113e-09, 4.67380920610067e-08, 7.53126083767399e-07, 8.20868505373139e-06, 6.4589864152511e-05, 0.000384517224370123, 0.00179267098195397, 0.00671443004651047, 0.020586837327088, 0.0523611124684218, 0.111410791318685, 0.199021375373196, 0.297863392122962, 0.369751559423692, 0.371802902039138, 0.287455860480514, 0.149945845834879, 0.0326506335319119, 2.18335423062203e-37, 2.6448489869235e-27, 7.11343832201266e-22, 3.63116182213787e-18, 2.28732590529286e-15, 3.91112780304945e-13, 2.72621107118977e-11, 9.81985151093345e-10, 2.12435889197437e-08, 3.05400132332104e-07, 3.13303998043345e-06, 2.41586334164511e-05, 0.000145575386583443, 0.000706238707053033, 0.00282317587248396, 0.00947092928620572, 0.0270543588670643, 0.0665773451126075, 0.142463459639, 0.267046030681879, 0.441065546633236, 0.644754192350639, 0.836919622692484, 0.966832456016739, 

3.0517578125e-05, 0.000457763671875, 0.003204345703125, 0.013885498046875, 0.041656494140625, 0.091644287109375, 0.152740478515625, 0.196380615234375, 0.196380615234375, 0.152740478515625, 0.091644287109375, 0.041656494140625, 0.013885498046875, 0.003204345703125, 0.000457763671875, 3.0517578125e-05, 

0.0284100650828888, 7.48615846012771e-11, 0.114186809938135, 4.19080855900623e-09, 0.214173844564466, 1.0948217326904e-07, 0.248680070993976, 1.77056981037351e-06, 0.19990087258965, 1.98235694719846e-05, 0.117839210228682, 0.000162761650605, 0.0526248686958275, 0.00101239124930272, 0.0181295885170811, 0.00485780860226043, 0.00485780860226043, 0.0181295885170811, 0.00101239124930272, 0.0526248686958275, 0.000162761650605, 0.117839210228682, 1.98235694719846e-05, 0.19990087258965, 1.77056981037351e-06, 0.248680070993976, 1.0948217326904e-07, 0.214173844564466, 4.19080855900623e-09, 0.114186809938135, 7.48615846012771e-11, 0.0284100650828888, 

0.166358499999993, 3.0517578125e-05, 6.01111455080482e-15, 0.31695449999929, 0.000457763671875, 7.0988107125947e-13, 0.281809499960878, 0.003204345703125, 3.91221729626957e-11, 0.155109498665298, 0.013885498046875, 1.33470227021191e-09, 0.059104468475734, 0.041656494140625, 3.15242662365708e-08, 0.0165159539819493, 0.091644287109375, 5.46018050780246e-07, 0.00349633534829916, 0.152740478515625, 7.16465170086917e-06, 0.000570976478328454, 0.196380615234375, 7.25235216715537e-05, 7.25235216715537e-05, 0.196380615234375, 0.000570976478328454, 7.16465170086917e-06, 0.152740478515625, 0.00349633534829916, 5.46018050780246e-07, 0.091644287109375, 0.0165159539819493, 3.15242662365708e-08, 0.041656494140625, 0.059104468475734, 1.33470227021191e-09, 0.013885498046875, 0.155109498665298, 3.91221729626957e-11, 0.003204345703125, 0.281809499960878, 7.0988107125947e-13, 0.000457763671875, 0.31695449999929, 6.01111455080482e-15, 3.0517578125e-05, 0.166358499999993, 

0.339799552267194, 0.00246053690414363, 5.99647740444206e-08, 4.20126922498801e-18, 0.380298467548281, 0.0181793728441389, 1.82612165275067e-06, 8.44619799369336e-16, 0.198624642907304, 0.0626808231744762, 2.59519497421622e-05, 7.92407876601644e-14, 0.0642193256807331, 0.133787193497991, 0.00022831494191054, 4.60214573626263e-12, 0.014374657635901, 0.197694029158845, 0.00139058594220832, 1.85042338411039e-10, 0.0023595582581511, 0.214226892512497, 0.00621101761492126, 5.45611197668205e-09, 0.000293420172660483, 0.175865435695377, 0.0210161788649478, 1.21876931213302e-07, 2.81478320967272e-05, 0.111373717564968, 0.0548580632474074, 2.10017490993718e-06, 2.10017490993717e-06, 0.0548580632474074, 0.111373717564968, 2.81478320967274e-05, 1.21876931213301e-07, 0.0210161788649478, 0.175865435695377, 0.000293420172660485, 5.45611197668201e-09, 0.00621101761492125, 0.214226892512497, 0.00235955825815111, 1.85042338411038e-10, 0.00139058594220832, 0.197694029158845, 0.014374657635901, 4.60214573626259e-12, 0.00022831494191054, 0.133787193497991, 0.0642193256807332, 7.92407876601635e-14, 2.59519497421622e-05, 0.0626808231744762, 0.198624642907304, 8.44619799369326e-16, 1.82612165275067e-06, 0.0181793728441389, 0.380298467548282, 4.20126922498796e-18, 5.99647740444206e-08, 0.00246053690414363, 0.339799552267194, 

0.486416352273621, 0.0195381132831772, 3.0517578125e-05, 2.80258531364046e-10, 1.1721742899461e-20, 0.35911346879595, 0.0879195851706524, 0.000457763671875, 1.40132333181659e-08, 3.57232680404995e-18, 0.123726293339032, 0.184627087279188, 0.003204345703125, 3.2698260174637e-07, 5.08062281242289e-16, 0.0263886010990511, 0.240009959525018, 0.013885498046875, 4.72318541585058e-06, 4.47308121187654e-14, 0.00389645703030235, 0.216004235131891, 0.041656494140625, 4.72328880873909e-05, 2.72643890024471e-12, 0.000421914878200759, 0.142559674484549, 0.091644287109375, 0.000346382094952001, 1.21867017344166e-10, 3.46103394160346e-05, 0.0712782769251813, 0.152740478515625, 0.00192438709682842, 4.12669777032907e-09, 2.19019405655867e-06, 0.0274924478477224, 0.196380615234375, 0.00824755381124322, 1.07799032839617e-07, 1.07799032839616e-07, 0.00824755381124322, 0.196380615234375, 0.0274924478477224, 2.19019405655869e-06, 4.12669777032902e-09, 0.00192438709682842, 0.152740478515625, 0.0712782769251813, 3.46103394160349e-05, 1.21867017344165e-10, 0.000346382094952001, 0.091644287109375, 0.142559674484549, 0.000421914878200761, 2.72643890024467e-12, 4.72328880873909e-05, 0.041656494140625, 0.216004235131891, 0.00389645703030237, 4.47308121187647e-14, 4.72318541585058e-06, 0.013885498046875, 0.240009959525018, 0.0263886010990512, 5.08062281242281e-16, 3.2698260174637e-07, 0.003204345703125, 0.184627087279188, 0.123726293339032, 3.57232680404989e-18, 1.40132333181659e-08, 0.000457763671875, 0.0879195851706524, 0.359113468795951, 1.17217428994608e-20, 2.80258531364046e-10, 3.0517578125e-05, 0.0195381132831772, 0.486416352273621, 

0.597365086214042, 0.0617896465056269, 0.000756165934853477, 5.11186054037316e-07, 2.71344238932865e-12, 8.45372612777999e-23, 0.313125414193748, 0.18902270015044, 0.00697224265622141, 1.24740112165074e-05, 1.99574417946766e-10, 3.62870957403657e-20, 0.0765955572716687, 0.269847870799699, 0.0300009259798751, 0.000142049609557274, 6.85008433538222e-09, 7.26880516478538e-18, 0.0115987957390704, 0.238477871182187, 0.079913634491005, 0.00100137793127282, 1.45549602260514e-07, 9.01359215068836e-16, 0.0012159658486113, 0.145907069181504, 0.14736904309762, 0.00488714410262383, 2.14104248299242e-06, 7.73805719259868e-14, 9.34827072325155e-05, 0.0654645229898067, 0.199293470607514, 0.0174909621414682, 2.30962234503435e-05, 4.87155257130132e-12, 5.44461597506702e-06, 0.0222516259229556, 0.204176589765367, 0.047424015454297, 0.000188748161130367, 2.32342640507536e-10, 2.44623933383903e-07, 0.00583462854917643, 0.161366931661228, 0.0991924613698261, 0.0011899266895679, 8.54842621709484e-09, 8.54842621709484e-09, 0.0011899266895679, 0.0991924613698261, 0.161366931661228, 0.00583462854917642, 2.44623933383903e-07, 2.32342640507536e-10, 0.000188748161130368, 0.047424015454297, 0.204176589765367, 0.0222516259229555, 5.44461597506702e-06, 4.87155257130132e-12, 2.30962234503436e-05, 0.0174909621414683, 0.199293470607514, 0.0654645229898066, 9.34827072325155e-05, 7.73805719259868e-14, 2.14104248299243e-06, 0.00488714410262383, 0.14736904309762, 0.145907069181503, 0.0012159658486113, 9.01359215068836e-16, 1.45549602260515e-07, 0.00100137793127282, 0.079913634491005, 0.238477871182187, 0.0115987957390704, 7.26880516478537e-18, 6.85008433538225e-09, 0.000142049609557274, 0.0300009259798751, 0.269847870799699, 0.0765955572716687, 3.62870957403657e-20, 1.99574417946767e-10, 1.24740112165074e-05, 0.00697224265622141, 0.18902270015044, 0.313125414193748, 8.45372612777999e-23, 2.71344238932866e-12, 5.11186054037316e-07, 0.000756165934853477, 0.0617896465056269, 0.597365086214042, 

0.679341791908571, 0.125463934196471, 0.00505373396006408, 3.0517578125e-05, 1.23892423470185e-08, 4.68459796886025e-14, 1.21423867950355e-24, 0.266068813872007, 0.279310367135083, 0.0320380292212002, 0.000457763671875, 4.39717600298301e-07, 4.73463702401688e-12, 6.97558990004279e-22, 0.0486302380636787, 0.290176334642259, 0.0947820268000844, 0.003204345703125, 7.28299029203291e-06, 2.23309826922768e-10, 1.87009900071329e-19, 0.00550228238510904, 0.186621202351443, 0.173584221916815, 0.013885498046875, 7.46740438530169e-05, 6.52008169857646e-09, 3.1036469551121e-17, 0.000431001232437599, 0.0830919847648746, 0.220086629729901, 0.041656494140625, 0.000530064558395223, 1.31794533553989e-07, 3.56598232601684e-15, 2.47580009284883e-05, 0.0271305569059637, 0.204634332376079, 0.091644287109375, 0.00275923880843824, 1.95363390271182e-06, 3.00460568845116e-13, 1.07740430505995e-06, 0.00671095540856776, 0.144141622635054, 0.152740478515625, 0.0108811771581316, 2.19389095657241e-05, 1.91788186547202e-11, 3.6169087985155e-08, 0.00128057705939776, 0.0783242120063952, 0.196380615234375, 0.0331023016884537, 0.000190056449765633, 9.44391218447499e-10, 9.44391218447483e-10, 0.000190056449765633, 0.0331023016884537, 0.196380615234375, 0.0783242120063952, 0.00128057705939776, 3.61690879851556e-08, 1.91788186547198e-11, 2.19389095657241e-05, 0.0108811771581316, 0.152740478515625, 0.144141622635054, 0.00671095540856776, 1.07740430505997e-06, 3.0046056884511e-13, 1.95363390271182e-06, 0.00275923880843824, 0.091644287109375, 0.204634332376079, 0.0271305569059637, 2.47580009284886e-05, 3.56598232601675e-15, 1.31794533553989e-07, 0.000530064558395223, 0.041656494140625, 0.220086629729901, 0.0830919847648746, 0.000431001232437602, 3.10364695511202e-17, 6.52008169857646e-09, 7.46740438530169e-05, 0.013885498046875, 0.173584221916815, 0.186621202351443, 0.00550228238510908, 1.87009900071323e-19, 2.23309826922768e-10, 7.28299029203291e-06, 0.003204345703125, 0.0947820268000844, 0.290176334642259, 0.0486302380636789, 6.97558990004258e-22, 4.73463702401687e-12, 4.39717600298301e-07, 0.000457763671875, 0.0320380292212002, 0.279310367135083, 0.266068813872008, 1.21423867950352e-24, 4.68459796886025e-14, 1.23892423470185e-08, 3.0517578125e-05, 0.00505373396006408, 0.125463934196471, 0.679341791908571, 

0.7402091598677, 0.200245163698839, 0.017213597544238, 0.000381693037008891, 1.46020668670104e-06, 4.24275882129284e-10, 1.28140033358523e-15, 2.93813612196334e-26, 0.224919380132152, 0.339934164417507, 0.0803060042224809, 0.0039505009406115, 3.17438003406225e-05, 2.04623020347898e-08, 1.69837884640094e-13, 2.1756148160997e-23, 0.0318937864334196, 0.269298772906242, 0.174836124303289, 0.0190808133203054, 0.00032204034696819, 4.60540064518311e-07, 1.05048799151481e-11, 7.51794049489384e-21, 0.00279968611356653, 0.132068118846875, 0.235634231092236, 0.0570513142231655, 0.00202248686809648, 6.41659164870719e-06, 4.02227416947779e-10, 1.60819911087884e-18, 0.000170142089390119, 0.0448395005373755, 0.219859253807038, 0.118095563004199, 0.00879347011859424, 6.18928588119689e-05, 1.06623124480584e-08, 2.38166079965579e-16, 7.58255565053893e-06, 0.0111641321089747, 0.150436265524971, 0.179268066655419, 0.0280373071855262, 0.000437802372329464, 2.07268147561836e-07, 2.58655326067139e-14, 2.56003274209922e-07, 0.0021057908603468, 0.0779805702595499, 0.206157128977423, 0.0677233412298479, 0.00234607421766179, 3.05238840947296e-06, 2.12808519980549e-12, 6.66762479760896e-09, 0.000306408794097702, 0.0311828632075365, 0.182889806274228, 0.12619326381158, 0.00969842257156642, 3.46770979692437e-05, 1.35067952658139e-10, 1.35067952658139e-10, 3.46770979692437e-05, 0.00969842257156642, 0.12619326381158, 0.182889806274228, 0.0311828632075365, 0.000306408794097702, 6.66762479760896e-09, 2.12808519980549e-12, 3.05238840947296e-06, 0.00234607421766179, 0.067723341229848, 0.206157128977423, 0.0779805702595499, 0.00210579086034679, 2.56003274209922e-07, 2.58655326067139e-14, 2.07268147561836e-07, 0.000437802372329464, 0.0280373071855262, 0.179268066655419, 0.150436265524971, 0.0111641321089747, 7.58255565053893e-06, 2.38166079965579e-16, 1.06623124480584e-08, 6.18928588119689e-05, 0.00879347011859426, 0.118095563004199, 0.219859253807038, 0.0448395005373755, 0.000170142089390119, 1.60819911087884e-18, 4.02227416947779e-10, 6.41659164870719e-06, 0.00202248686809649, 0.0570513142231655, 0.235634231092236, 0.132068118846875, 0.00279968611356653, 7.51794049489384e-21, 1.05048799151481e-11, 4.60540064518311e-07, 0.000322040346968191, 0.0190808133203054, 0.174836124303289, 0.269298772906242, 0.0318937864334196, 2.1756148160997e-23, 1.69837884640094e-13, 2.04623020347898e-08, 3.17438003406225e-05, 0.0039505009406115, 0.0803060042224809, 0.339934164417507, 0.224919380132152, 2.93813612196334e-26, 1.28140033358523e-15, 4.24275882129284e-10, 1.46020668670105e-06, 0.000381693037008891, 0.017213597544238, 0.200245163698839, 0.7402091598677, 

0.786062132293865, 0.277172788310735, 0.0398625894764617, 0.00206118337064087, 3.0517578125e-05, 8.53705104068412e-08, 1.96770127465014e-11, 5.0812670660812e-17, 1.06929355190458e-27, 0.190746892874607, 0.371298571662064, 0.143290152029633, 0.0157768624399792, 0.000457763671875, 2.5094953029606e-06, 1.23166003230845e-09, 8.53457406998298e-15, 9.91468381361345e-25, 0.0216005520450813, 0.232114754388307, 0.24036651167313, 0.0563548669490269, 0.003204345703125, 3.44248199360551e-05, 3.59773616151514e-08, 6.6895740145303e-13, 4.29010153256092e-22, 0.00151424548123117, 0.0898268713564129, 0.249606353496243, 0.124613839176623, 0.013885498046875, 0.000292335141595097, 6.505667029646e-07, 3.24592986729525e-11, 1.1491595485271e-19, 7.34897684872267e-05, 0.0240662795469785, 0.179447109732589, 0.190765695746516, 0.041656494140625, 0.00171865826086107, 8.14429524150864e-06, 1.09038271431642e-09, 2.13104316485352e-17, 2.61552513696197e-06, 0.00472838756551855, 0.0946060098614465, 0.214158694868979, 0.091644287109375, 0.00740968014008366, 7.47681461372675e-05, 2.68608783618572e-08, 2.89804809895986e-15, 7.0520760328172e-08, 0.000703790248210511, 0.0377856635172749, 0.182136594034051, 0.152740478515625, 0.02420111974832, 0.000520002922945051, 5.01288256961541e-07, 2.98569197357267e-13, 1.46679963650851e-09, 8.08107510438458e-05, 0.011642093948322, 0.119496292287728, 0.196380615234375, 0.0609771581498467, 0.0027899131051741, 7.2168980753576e-06, 2.37290380017112e-11, 2.37290380017105e-11, 7.2168980753576e-06, 0.00278991310517409, 0.0609771581498467, 0.196380615234375, 0.119496292287728, 0.011642093948322, 8.08107510438458e-05, 1.46679963650854e-09, 2.98569197357258e-13, 5.01288256961541e-07, 0.00052000292294505, 0.0242011197483199, 0.152740478515625, 0.182136594034051, 0.0377856635172749, 0.000703790248210511, 7.05207603281735e-08, 2.89804809895976e-15, 2.68608783618572e-08, 7.47681461372673e-05, 0.00740968014008366, 0.091644287109375, 0.214158694868979, 0.0946060098614466, 0.00472838756551854, 2.61552513696202e-06, 2.13104316485343e-17, 1.09038271431642e-09, 8.14429524150861e-06, 0.00171865826086107, 0.041656494140625, 0.190765695746516, 0.179447109732589, 0.0240662795469785, 7.34897684872277e-05, 1.14915954852705e-19, 3.24592986729525e-11, 6.50566702964598e-07, 0.000292335141595097, 0.013885498046875, 0.124613839176623, 0.249606353496243, 0.0898268713564129, 0.00151424548123118, 4.29010153256072e-22, 6.6895740145303e-13, 3.59773616151513e-08, 3.44248199360551e-05, 0.003204345703125, 0.0563548669490269, 0.24036651167313, 0.232114754388307, 0.0216005520450814, 9.91468381361296e-25, 8.53457406998298e-15, 1.23166003230845e-09, 2.5094953029606e-06, 0.000457763671875, 0.0157768624399792, 0.143290152029633, 0.371298571662064, 0.190746892874608, 1.06929355190452e-27, 5.0812670660812e-17, 1.96770127465013e-11, 8.53705104068412e-08, 3.0517578125e-05, 0.00206118337064087, 0.0398625894764617, 0.277172788310735, 0.786062132293865, 

0.821199765271958, 0.35071467810852, 0.0727611263308118, 0.0067614545730708, 0.00024470227306177, 2.71928878900493e-06, 6.07787232823815e-09, 1.18524575837906e-12, 2.73210960864401e-18, 5.40166925948599e-29, 0.162834098377439, 0.380611126372081, 0.208345730622492, 0.0400908708006739, 0.00271925801864037, 5.50586344599844e-05, 2.30636870344894e-07, 9.31334595754981e-11, 5.66438937280603e-16, 6.12934363095771e-26, 0.0150677592314611, 0.19275950317536, 0.278404710136788, 0.11093219986228, 0.0141016396662877, 0.000520238298729387, 4.0842534100564e-06, 3.41515046525276e-09, 5.48043285078344e-14, 3.24568771604203e-23, 0.000863129674036264, 0.0604330028320905, 0.230299295386611, 0.190017595820408, 0.0452702471968233, 0.00304300918427516, 4.47734625728111e-05, 7.75243274263693e-08, 3.28246935385508e-12, 1.06395571389973e-20, 3.42296596268418e-05, 0.0131169150957816, 0.131888763626381, 0.225335267775995, 0.100613272737944, 0.0123226286970933, 0.000339803494532792, 1.21833109520774e-06, 1.36108628041218e-10, 2.41456848442177e-18, 9.95475416773617e-07, 0.00208780852540437, 0.0553891130694775, 0.195959330162372, 0.163983107458787, 0.0365935790730247, 0.00189119549971246, 1.4040871878623e-05, 4.13877730314137e-09, 4.01843483945581e-16, 2.19323196785749e-08, 0.000251753602985472, 0.0176224827320942, 0.129100757878925, 0.20247388537349, 0.0823251408771431, 0.00797390540833972, 0.000122588263448311, 9.53420597204952e-08, 5.06641081291329e-14, 3.72764301823036e-10, 2.34183580919419e-05, 0.00432519304746106, 0.0656126165304324, 0.192856660163799, 0.142874853057652, 0.0259359077625321, 0.000825656547663964, 1.69430940258521e-06, 4.92764704858773e-12, 4.92764704858773e-12, 1.69430940258523e-06, 0.000825656547663964, 0.0259359077625321, 0.142874853057652, 0.192856660163799, 0.0656126165304324, 0.00432519304746106, 2.34183580919418e-05, 3.72764301823036e-10, 5.06641081291329e-14, 9.53420597204959e-08, 0.000122588263448311, 0.00797390540833972, 0.0823251408771432, 0.20247388537349, 0.129100757878925, 0.0176224827320942, 0.000251753602985471, 2.19323196785749e-08, 4.01843483945581e-16, 4.13877730314141e-09, 1.4040871878623e-05, 0.00189119549971246, 0.0365935790730247, 0.163983107458787, 0.195959330162372, 0.0553891130694775, 0.00208780852540436, 9.95475416773617e-07, 2.41456848442177e-18, 1.36108628041219e-10, 1.21833109520774e-06, 0.000339803494532792, 0.0123226286970933, 0.100613272737944, 0.225335267775995, 0.131888763626381, 0.0131169150957815, 3.42296596268418e-05, 1.06395571389973e-20, 3.28246935385511e-12, 7.75243274263693e-08, 4.47734625728111e-05, 0.00304300918427516, 0.0452702471968232, 0.190017595820408, 0.230299295386611, 0.0604330028320903, 0.000863129674036264, 3.24568771604203e-23, 5.4804328507835e-14, 3.41515046525276e-09, 4.0842534100564e-06, 0.000520238298729387, 0.0141016396662877, 0.11093219986228, 0.278404710136788, 0.19275950317536, 0.0150677592314611, 6.12934363095772e-26, 5.6643893728061e-16, 9.31334595754981e-11, 2.30636870344894e-07, 5.50586344599844e-05, 0.00271925801864037, 0.0400908708006739, 0.208345730622492, 0.380611126372081, 0.162834098377439, 5.40166925948599e-29, 2.73210960864404e-18, 1.18524575837906e-12, 6.07787232823815e-09, 2.71928878900493e-06, 0.00024470227306177, 0.0067614545730708, 0.0727611263308118, 0.35071467810852, 0.821199765271958, 

0.84858900714692, 0.418162106335592, 0.113714009496523, 0.0161558168737037, 0.00109461675993688, 3.0517578125e-05, 2.74453329460392e-07, 5.19306975088504e-10, 8.94000958761988e-14, 1.8928528740491e-19, 3.57131388547619e-30, 0.140086849606718, 0.375394074135454, 0.266035850912901, 0.0767172799766803, 0.00944714207023588, 0.000457763671875, 7.15504992972677e-06, 2.46060781677395e-08, 8.59793800808638e-12, 4.74413063096948e-17, 4.86755170366615e-27, 0.0107920541724515, 0.157266757130219, 0.290451176590695, 0.170006001145838, 0.0380492044297812, 0.003204345703125, 8.70489655886162e-05, 5.44085840410165e-07, 3.85884571945627e-10, 5.54885274905712e-15, 3.09599253819959e-24, 0.0005146771913775, 0.0407859430206213, 0.196304462262835, 0.233216549342254, 0.0948669137471182, 0.013885498046875, 0.000655599506962402, 7.4476027858964e-06, 1.07212291589037e-08, 4.0176658971325e-13, 1.2190269157851e-21, 1.69927976198788e-05, 0.00732290233189136, 0.0918515227583979, 0.221489751350261, 0.163750683295863, 0.041656494140625, 0.00341832049583295, 7.05772520312516e-05, 2.06220055527442e-07, 2.01392639743995e-11, 3.32296557010893e-19, 4.11430301512628e-07, 0.000964178408050014, 0.031516934967121, 0.154258580993259, 0.207277850220598, 0.091644287109375, 0.0130703845634953, 0.000490472215219571, 2.90883204643667e-06, 7.4031201232541e-10, 6.64262620229327e-17, 7.54664171102184e-09, 9.61739891214061e-05, 0.00819271145341639, 0.0813900091381503, 0.198769039612445, 0.152740478515625, 0.0378608204884998, 0.0025822015891126, 3.1083682313609e-05, 2.06163636927731e-08, 1.00595801634435e-14, 1.06784178055298e-10, 7.40037246426887e-06, 0.00164288461587122, 0.0331274938688893, 0.14704162811869, 0.196380615234375, 0.0846033182216922, 0.0104872494405899, 0.000256237092023023, 4.42899364846197e-07, 1.1752103759396e-12, 1.17521037593955e-12, 4.42899364846197e-07, 0.000256237092023024, 0.0104872494405899, 0.0846033182216921, 0.196380615234375, 0.147041628118691, 0.0331274938688892, 0.00164288461587121, 7.40037246426887e-06, 1.06784178055302e-10, 1.00595801634431e-14, 2.06163636927731e-08, 3.10836823136091e-05, 0.0025822015891126, 0.0378608204884998, 0.152740478515625, 0.198769039612446, 0.0813900091381502, 0.00819271145341637, 9.61739891214061e-05, 7.54664171102207e-09, 6.64262620229294e-17, 7.4031201232541e-10, 2.90883204643668e-06, 0.000490472215219573, 0.0130703845634953, 0.091644287109375, 0.207277850220598, 0.154258580993259, 0.0315169349671209, 0.000964178408050014, 4.11430301512638e-07, 3.32296557010874e-19, 2.01392639743995e-11, 2.06220055527443e-07, 7.05772520312518e-05, 0.00341832049583294, 0.041656494140625, 0.163750683295863, 0.221489751350261, 0.0918515227583978, 0.00732290233189136, 1.69927976198792e-05, 1.21902691578503e-21, 4.0176658971325e-13, 1.07212291589037e-08, 7.44760278589642e-06, 0.000655599506962401, 0.013885498046875, 0.0948669137471182, 0.233216549342254, 0.196304462262835, 0.0407859430206213, 0.000514677191377508, 3.09599253819938e-24, 5.54885274905712e-15, 3.85884571945629e-10, 5.44085840410167e-07, 8.7048965588616e-05, 0.003204345703125, 0.0380492044297812, 0.170006001145838, 0.290451176590695, 0.157266757130219, 0.0107920541724516, 4.86755170366581e-27, 4.74413063096948e-17, 8.59793800808643e-12, 2.46060781677396e-08, 7.15504992972676e-06, 0.000457763671875, 0.00944714207023588, 0.0767172799766802, 0.266035850912901, 0.375394074135454, 0.140086849606718, 3.57131388547592e-30, 1.8928528740491e-19, 8.94000958761993e-14, 5.19306975088506e-10, 2.74453329460391e-07, 3.0517578125e-05, 0.00109461675993688, 0.0161558168737037, 0.113714009496523, 0.418162106335592, 0.84858900714692, 

0.870283108611144, 0.478580940433974, 0.159878787776102, 0.0312254707432434, 0.00334995578113096, 0.000179138665779747, 4.10140721362125e-06, 3.14081858758606e-08, 5.23339705764674e-11, 8.18886355533607e-15, 1.62426488140105e-20, 2.95624039842695e-31, 0.121475984165508, 0.361487614253412, 0.311777156366101, 0.121773250688862, 0.023223655758743, 0.00208896019549292, 7.91360883619845e-05, 1.01937472128024e-06, 3.01941841102636e-09, 9.44827897572389e-13, 4.83839532409863e-18, 4.76532355608575e-28, 0.00791274334223617, 0.127420183230435, 0.283729516211171, 0.221616241725329, 0.0751326794395197, 0.0113678353602096, 0.000712562641476823, 1.54394436861053e-05, 8.12960964397779e-08, 5.08731421235733e-11, 6.72593438267557e-16, 3.58469178721919e-25, 0.00031907133515706, 0.0278039876261941, 0.159841225640028, 0.249675155665354, 0.150470452401031, 0.0382956498034503, 0.00397187503860237, 0.000144761639645205, 1.3550026489923e-06, 1.69569786706659e-09, 5.78799250348865e-14, 1.66930350614262e-22, 8.90733235511408e-06, 0.00420024965666635, 0.0623407814048606, 0.194736890096023, 0.208628066561768, 0.0893141497417454, 0.0153273565703844, 0.000939668127593556, 1.56354272389053e-05, 3.91297923046847e-08, 3.44827942603073e-12, 5.38168095146173e-20, 1.82351336595724e-07, 0.000465312317956285, 0.0178302366892216, 0.11138393509634, 0.212126861272085, 0.152753974642649, 0.0433750882337611, 0.00447297968069987, 0.000132306380181816, 6.62167769034686e-07, 1.50653202494669e-10, 1.272336585585e-17, 2.82811010420786e-09, 3.90517106557695e-05, 0.00386338548487336, 0.0482639600455502, 0.163397221576405, 0.197920527308259, 0.0929907071834041, 0.0161304106208609, 0.000848160203521935, 8.48896223280053e-06, 4.98632238605171e-09, 2.27883117496284e-15, 3.38360295636923e-11, 2.52831566792342e-06, 0.000645765291769512, 0.0161331461582137, 0.0970933283153717, 0.197826687555914, 0.153792249563296, 0.0448734685985528, 0.00419440839964346, 8.39531285537722e-05, 1.27314555966005e-07, 3.14860375191546e-13, 3.14860375191561e-13, 1.27314555966004e-07, 8.39531285537719e-05, 0.00419440839964345, 0.0448734685985527, 0.153792249563296, 0.197826687555914, 0.0970933283153718, 0.0161331461582138, 0.000645765291769514, 2.52831566792344e-06, 3.38360295636908e-11, 2.27883117496297e-15, 4.98632238605165e-09, 8.4889622328005e-06, 0.000848160203521933, 0.0161304106208609, 0.0929907071834041, 0.197920527308259, 0.163397221576405, 0.0482639600455503, 0.00386338548487337, 3.90517106557698e-05, 2.82811010420776e-09, 1.27233658558508e-17, 1.50653202494667e-10, 6.62167769034682e-07, 0.000132306380181815, 0.00447297968069986, 0.0433750882337611, 0.152753974642649, 0.212126861272085, 0.11138393509634, 0.0178302366892217, 0.000465312317956288, 1.82351336595719e-07, 5.38168095146208e-20, 3.44827942603069e-12, 3.91297923046845e-08, 1.56354272389053e-05, 0.000939668127593554, 0.0153273565703844, 0.0893141497417454, 0.208628066561769, 0.194736890096023, 0.0623407814048607, 0.00420024965666637, 8.90733235511386e-06, 1.66930350614274e-22, 5.78799250348857e-14, 1.69569786706658e-09, 1.35500264899229e-06, 0.000144761639645205, 0.00397187503860237, 0.0382956498034503, 0.150470452401031, 0.249675155665354, 0.159841225640028, 0.0278039876261942, 0.000319071335157054, 3.58469178721947e-25, 6.72593438267547e-16, 5.0873142123573e-11, 8.12960964397776e-08, 1.54394436861053e-05, 0.000712562641476823, 0.0113678353602096, 0.0751326794395197, 0.221616241725329, 0.283729516211171, 0.127420183230435, 0.00791274334223608, 4.76532355608615e-28, 4.83839532409855e-18, 9.44827897572383e-13, 3.01941841102635e-09, 1.01937472128024e-06, 7.91360883619845e-05, 0.00208896019549292, 0.023223655758743, 0.121773250688862, 0.311777156366102, 0.361487614253412, 0.121475984165507, 2.95624039842721e-31, 1.62426488140102e-20, 8.18886355533601e-15, 5.23339705764672e-11, 3.14081858758605e-08, 4.10140721362125e-06, 0.000179138665779747, 0.00334995578113096, 0.0312254707432434, 0.159878787776102, 0.478580940433974, 0.870283108611144, 

0.887720216579797, 0.532004054698147, 0.208615436195097, 0.0520634768410097, 0.00791215810351642, 0.000684784074074981, 3.0517578125e-05, 5.99835694654864e-07, 4.0533904709262e-09, 6.1155502286922e-12, 8.8796209710754e-16, 1.67334231780735e-21, 2.96066485152277e-32, 0.106147127333752, 0.342913190880507, 0.344646785215002, 0.170066164695189, 0.0451877913705061, 0.00642406836628644, 0.000457763671875, 1.43866050533223e-05, 1.59688926808054e-07, 4.212435898772e-10, 1.20934205209195e-13, 5.84114602092941e-19, 5.57108302953681e-29, 0.00592307403582077, 0.103147859881882, 0.265710553695768, 0.259244438908268, 0.12043537077668, 0.0281237635394563, 0.003204345703125, 0.000161024187971517, 2.9358775852152e-06, 1.35405982851253e-08, 7.68618197109522e-12, 9.51520420430929e-17, 4.89211655150606e-26, 0.000204602122452694, 0.0192070341853393, 0.126814068070201, 0.244638631124246, 0.19870603185657, 0.0762185669566084, 0.013885498046875, 0.0011157013836836, 3.34137440655492e-05, 2.6944272379016e-07, 3.02410055072328e-10, 9.59538092784913e-15, 2.65936541847062e-23, 4.89296675666952e-06, 0.00247605082017005, 0.0419010804546192, 0.159823186064324, 0.226969345003489, 0.143003701004886, 0.041656494140625, 0.00535185061760514, 0.000263276137285008, 3.71188252867738e-06, 8.23722538981566e-09, 6.69893070049769e-13, 1.00082557771162e-20, 8.58095889862183e-08, 0.000234077798977032, 0.0101527673650099, 0.0765695255760225, 0.190118677321102, 0.196759269641049, 0.091644287109375, 0.0188261458948538, 0.00152124540449605, 3.74993217709445e-05, 1.64538334805116e-07, 3.42965295171751e-11, 2.76210510735456e-18, 1.14005406439004e-09, 1.67643594803142e-05, 0.00186367301651429, 0.0277906175251121, 0.120644751392928, 0.205092224238245, 0.152740478515625, 0.0501700952960918, 0.00665906309512429, 0.000286997868458189, 2.4898851489918e-06, 1.33021222647934e-09, 5.77494795598038e-16, 1.16845177452494e-11, 9.26209912182102e-07, 0.000263906884175522, 0.00778101330547425, 0.059059232833082, 0.164914524961335, 0.196380615234375, 0.103139293397105, 0.0224865433412524, 0.0016944534769166, 2.90661326844934e-05, 3.98003979614684e-08, 9.31433102287523e-14, 9.31433102287576e-14, 3.98003979614688e-08, 2.90661326844932e-05, 0.0016944534769166, 0.0224865433412524, 0.103139293397105, 0.196380615234375, 0.164914524961335, 0.059059232833082, 0.00778101330547424, 0.000263906884175523, 9.26209912182093e-07, 1.16845177452488e-11, 5.77494795598075e-16, 1.33021222647936e-09, 2.48988514899179e-06, 0.00028699786845819, 0.00665906309512429, 0.0501700952960918, 0.152740478515625, 0.205092224238245, 0.120644751392928, 0.0277906175251121, 0.0018636730165143, 1.6764359480314e-05, 1.14005406439e-09, 2.76210510735475e-18, 3.42965295171755e-11, 1.64538334805115e-07, 3.74993217709446e-05, 0.00152124540449605, 0.0188261458948538, 0.091644287109375, 0.196759269641049, 0.190118677321102, 0.0765695255760224, 0.0101527673650099, 0.00023407779897703, 8.58095889862153e-08, 1.00082557771169e-20, 6.69893070049779e-13, 8.23722538981561e-09, 3.71188252867739e-06, 0.000263276137285008, 0.00535185061760514, 0.041656494140625, 0.143003701004886, 0.226969345003489, 0.159823186064324, 0.0419010804546193, 0.00247605082017004, 4.89296675666939e-06, 2.65936541847085e-23, 9.59538092784929e-15, 3.02410055072326e-10, 2.69442723790161e-07, 3.34137440655492e-05, 0.0011157013836836, 0.013885498046875, 0.0762185669566084, 0.19870603185657, 0.244638631124246, 0.126814068070201, 0.0192070341853392, 0.000204602122452689, 4.8921165515065e-26, 9.51520420430945e-17, 7.68618197109517e-12, 1.35405982851254e-08, 2.9358775852152e-06, 0.000161024187971517, 0.003204345703125, 0.0281237635394563, 0.12043537077668, 0.259244438908267, 0.265710553695769, 0.103147859881881, 0.00592307403582068, 5.57108302953735e-29, 5.84114602092952e-19, 1.20934205209194e-13, 4.21243589877201e-10, 1.59688926808054e-07, 1.43866050533223e-05, 0.000457763671875, 0.00642406836628644, 0.0451877913705061, 0.170066164695189, 0.344646785215003, 0.342913190880507, 0.106147127333752, 2.96066485152308e-32, 1.67334231780738e-21, 8.87962097107533e-16, 6.11555022869223e-12, 4.0533904709262e-09, 5.99835694654864e-07, 3.0517578125e-05, 0.000684784074074981, 0.00791215810351642, 0.0520634768410097, 0.208615436195097, 0.532004054698147, 0.887720216579797, 

0.901923289906664, 0.578928257832783, 0.257837482473798, 0.0780561756387474, 0.0155528001930821, 0.00194436123628978, 0.000142222900177439, 5.49062229493562e-06, 9.564928735563e-08, 5.85242230535399e-10, 8.1586085214371e-13, 1.11598038152608e-16, 2.01869538012205e-22, 3.49182982835857e-33, 0.0934228457005624, 0.322264457617088, 0.365755903821909, 0.216993029567316, 0.0746337028901674, 0.0150543450350835, 0.00171726608154783, 0.000102314226586646, 2.77958107047594e-06, 2.74404846980429e-08, 6.60328586231805e-11, 1.77008362784107e-14, 8.15953943025256e-20, 7.58493910315447e-30, 0.00451589008919373, 0.0837156883910626, 0.24212711027103, 0.281508218466529, 0.167135292961704, 0.0543943207478814, 0.00967636929453132, 0.000889728010147452, 3.76949987373178e-05, 6.00419350966606e-07, 2.49408289378789e-09, 1.31020059192946e-12, 1.53910157548963e-17, 7.68878836571179e-27, 0.000135131840551105, 0.0134624887407161, 0.099224644203938, 0.226079107985048, 0.231699663015415, 0.121666021766525, 0.033752918817633, 0.00478963653715455, 0.000316455157726343, 8.13282899469811e-06, 5.83157313035077e-08, 6.00351852447799e-11, 1.79718579642439e-15, 4.82489396466985e-24, 2.79944009214915e-06, 0.00149879767432466, 0.0281510656045959, 0.125698165871195, 0.222372866552174, 0.188401438635374, 0.0815097182893102, 0.0178503612744265, 0.00183924583316584, 7.62654360662426e-05, 9.43973333333467e-07, 1.90446535181689e-09, 1.45284013762671e-13, 2.09612316178658e-21, 4.25290899974832e-08, 0.000122366374846364, 0.00585695049944788, 0.0512505908473715, 0.15650910679968, 0.213944215051224, 0.144347370028436, 0.0487857390529717, 0.00783914701645774, 0.000524463538774557, 1.12056009306498e-05, 4.43038759979513e-08, 8.61279494740621e-12, 6.67801278909791e-19, 4.89471118378515e-10, 7.56845523255813e-06, 0.00092315438521474, 0.0158305090804166, 0.0834494541281558, 0.184053020802927, 0.193657547570442, 0.101010108013656, 0.0253118510783033, 0.00273230333992717, 0.000100771250132389, 7.80793948353133e-07, 3.86808896863941e-10, 1.61177258614209e-16, 4.34574032234951e-12, 3.61117153615167e-07, 0.000112246508357069, 0.00377212960154372, 0.0343244120769843, 0.122146512469076, 0.200426757151856, 0.161336452128828, 0.0630484949408699, 0.0109809077937952, 0.000699091240773188, 1.06151680562749e-05, 1.34012256926465e-08, 3.00093095228077e-14, 3.00093095228077e-14, 1.34012256926467e-08, 1.06151680562749e-05, 0.000699091240773186, 0.0109809077937952, 0.0630484949408699, 0.161336452128827, 0.200426757151856, 0.122146512469076, 0.0343244120769844, 0.00377212960154373, 0.000112246508357069, 3.61117153615163e-07, 4.34574032234952e-12, 1.61177258614209e-16, 3.86808896863947e-10, 7.80793948353134e-07, 0.000100771250132389, 0.00273230333992716, 0.0253118510783033, 0.101010108013656, 0.193657547570442, 0.184053020802927, 0.0834494541281559, 0.0158305090804167, 0.00092315438521474, 7.56845523255806e-06, 4.89471118378515e-10, 6.67801278909791e-19, 8.61279494740635e-12, 4.43038759979513e-08, 1.12056009306498e-05, 0.000524463538774556, 0.00783914701645774, 0.0487857390529716, 0.144347370028437, 0.213944215051224, 0.15650910679968, 0.0512505908473716, 0.00585695049944788, 0.000122366374846363, 4.25290899974832e-08, 2.09612316178658e-21, 1.45284013762674e-13, 1.90446535181689e-09, 9.43973333333463e-07, 7.62654360662424e-05, 0.00183924583316584, 0.0178503612744265, 0.0815097182893102, 0.188401438635374, 0.222372866552174, 0.125698165871195, 0.0281510656045959, 0.00149879767432465, 2.79944009214915e-06, 4.82489396466985e-24, 1.79718579642442e-15, 6.00351852447799e-11, 5.83157313035074e-08, 8.13282899469809e-06, 0.000316455157726343, 0.00478963653715454, 0.033752918817633, 0.121666021766525, 0.231699663015415, 0.226079107985048, 0.099224644203938, 0.013462488740716, 0.000135131840551105, 7.68878836571179e-27, 1.53910157548966e-17, 1.31020059192946e-12, 2.49408289378788e-09, 6.00419350966604e-07, 3.76949987373178e-05, 0.00088972801014745, 0.00967636929453133, 0.0543943207478814, 0.167135292961705, 0.281508218466529, 0.24212711027103, 0.0837156883910623, 0.00451589008919373, 7.58493910315447e-30, 8.15953943025273e-20, 1.77008362784107e-14, 6.60328586231801e-11, 2.74404846980428e-08, 2.77958107047594e-06, 0.000102314226586646, 0.00171726608154783, 0.0150543450350835, 0.0746337028901674, 0.216993029567316, 0.365755903821909, 0.322264457617087, 0.0934228457005624, 3.49182982835857e-33, 2.0186953801221e-22, 1.11598038152608e-16, 8.15860852143705e-13, 5.85242230535397e-10, 9.564928735563e-08, 5.49062229493561e-06, 0.000142222900177439, 0.00194436123628978, 0.0155528001930821, 0.0780561756387474, 0.257837482473798, 0.578928257832783, 0.901923289906664, 

0.913631886587802, 0.620031522969848, 0.306060834746832, 0.108190035361065, 0.0267348313392566, 0.00445860404485515, 0.000477252144004014, 3.0517578125e-05, 1.04995109978531e-06, 1.65963377272405e-08, 9.37199388231698e-11, 1.22551640751572e-13, 1.59714412652817e-17, 2.79464773434326e-23, 4.74601621925506e-34, 0.0827750983567855, 0.301138245585921, 0.377052166739535, 0.259350633377347, 0.109518043716646, 0.0290632641156829, 0.0047606606607692, 0.000457763671875, 2.36827566728865e-05, 5.72861055827471e-07, 5.14761770133741e-09, 1.15027478017185e-11, 2.91697659453114e-15, 1.29466511200353e-20, 1.17864570819835e-30, 0.00349973324850817, 0.0682534868164369, 0.216771360923293, 0.290131006157374, 0.209363363798658, 0.0884090354727113, 0.0221612036714963, 0.003204345703125, 0.000249288482494905, 9.22769252968322e-06, 1.31943304219628e-07, 5.03837915863884e-10, 2.48615705921586e-13, 2.79894650560937e-18, 1.3659793096545e-27, 9.15997395928153e-05, 0.00957652236401968, 0.0771483114591028, 0.200920862064942, 0.247764884856377, 0.166484180997685, 0.0638621479659089, 0.013885498046875, 0.00162441216241897, 9.2015499697299e-05, 2.09359408935268e-06, 1.36616814061377e-08, 1.3117414293965e-11, 3.74589680492052e-16, 9.80006645744081e-25, 1.65978827262014e-06, 0.000930229201799945, 0.0190085987447646, 0.0963285623511643, 0.202991559189727, 0.217044333820232, 0.12740687259478, 0.041656494140625, 0.00732806660937109, 0.000635225640444369, 2.29983547345272e-05, 2.56458215978986e-07, 4.79145117096473e-10, 3.4706928153403e-14, 4.86757977069627e-22, 2.20552797376276e-08, 6.62633726167489e-05, 0.00343459242201831, 0.033867766018932, 0.121960060209981, 0.207503466965171, 0.186399015917353, 0.091644287109375, 0.0242428687419467, 0.00321585513430468, 0.000185268881395106, 3.53045358750317e-06, 1.28347473519644e-08, 2.35818553301576e-12, 1.77295846034543e-19, 2.22023281947445e-10, 3.57588194886098e-06, 0.000470139109457478, 0.00902078000351879, 0.0555115494434438, 0.150289393138833, 0.206595303140307, 0.152740478515625, 0.0607581694450815, 0.0123336324615909, 0.00113066580821286, 3.68188707984404e-05, 2.60455570529879e-07, 1.21385226628748e-10, 4.89226656060626e-17, 1.72417040202672e-12, 1.48863604041729e-07, 4.96447437236465e-05, 0.00185352032229676, 0.0194914787537288, 0.0839705550879724, 0.176641600950007, 0.196380615234375, 0.117468404806289, 0.0364906204708972, 0.00532306486910819, 0.000296214383614385, 4.07732843999542e-06, 4.82002639027152e-09, 1.04139954473094e-14, 1.04139954473086e-14, 4.82002639027152e-09, 4.0773284399954e-06, 0.000296214383614386, 0.00532306486910819, 0.0364906204708971, 0.117468404806289, 0.196380615234375, 0.176641600950007, 0.0839705550879724, 0.0194914787537288, 0.00185352032229676, 4.96447437236467e-05, 1.48863604041729e-07, 1.72417040202683e-12, 4.89226656060586e-17, 1.21385226628748e-10, 2.60455570529878e-07, 3.68188707984405e-05, 0.00113066580821286, 0.0123336324615909, 0.0607581694450815, 0.152740478515625, 0.206595303140307, 0.150289393138833, 0.0555115494434438, 0.00902078000351876, 0.00047013910945748, 3.57588194886098e-06, 2.22023281947458e-10, 1.77295846034527e-19, 2.35818553301576e-12, 1.28347473519643e-08, 3.53045358750319e-06, 0.000185268881395106, 0.00321585513430468, 0.0242428687419467, 0.091644287109375, 0.186399015917353, 0.207503466965171, 0.121960060209981, 0.0338677660189319, 0.00343459242201832, 6.62633726167489e-05, 2.20552797376286e-08, 4.86757977069578e-22, 3.4706928153403e-14, 4.79145117096469e-10, 2.56458215978987e-07, 2.29983547345272e-05, 0.000635225640444369, 0.00732806660937109, 0.041656494140625, 0.12740687259478, 0.217044333820232, 0.202991559189727, 0.0963285623511642, 0.0190085987447647, 0.000930229201799945, 1.6597882726202e-06, 9.80006645743973e-25, 3.74589680492052e-16, 1.31174142939649e-11, 1.36616814061378e-08, 2.09359408935268e-06, 9.2015499697299e-05, 0.00162441216241897, 0.013885498046875, 0.0638621479659089, 0.166484180997685, 0.247764884856377, 0.200920862064942, 0.0771483114591029, 0.00957652236401968, 9.15997395928179e-05, 1.36597930965434e-27, 2.79894650560937e-18, 2.48615705921583e-13, 5.03837915863887e-10, 1.31943304219628e-07, 9.22769252968322e-06, 0.000249288482494905, 0.003204345703125, 0.0221612036714963, 0.0884090354727113, 0.209363363798658, 0.290131006157374, 0.216771360923293, 0.0682534868164369, 0.00349973324850823, 1.17864570819819e-30, 1.29466511200353e-20, 2.91697659453111e-15, 1.15027478017185e-11, 5.14761770133741e-09, 5.72861055827471e-07, 2.36827566728865e-05, 0.000457763671875, 0.0047606606607692, 0.0290632641156829, 0.109518043716646, 0.259350633377346, 0.377052166739536, 0.301138245585921, 0.0827750983567863, 4.74601621925441e-34, 2.79464773434326e-23, 1.59714412652816e-17, 1.22551640751573e-13, 9.37199388231698e-11, 1.65963377272405e-08, 1.04995109978531e-06, 3.0517578125e-05, 0.000477252144004014, 0.00445860404485515, 0.0267348313392566, 0.108190035361065, 0.306060834746832, 0.620031522969848, 0.913631886587802, 

0.923389285253956, 0.656025336892972, 0.352319770778243, 0.141321368739602, 0.0415651678266352, 0.00872947022011565, 0.00126140804019345, 0.000119079300895812, 6.82635238796068e-06, 2.13802471657506e-07, 3.1213157632586e-09, 1.65048137022457e-11, 2.04776184641819e-14, 2.56464069384784e-18, 4.36649412243805e-24, 7.30404437478048e-35, 0.0737940469184123, 0.280474052653443, 0.380628153467915, 0.295372823787108, 0.147258216630277, 0.0486746086027123, 0.0106061393541997, 0.0014762198150225, 0.000123895766670254, 5.72128398892141e-06, 1.25952166882358e-07, 1.04819756489929e-09, 2.204444987104e-12, 5.34127764747091e-16, 2.29796453143541e-21, 2.05640865920178e-31, 0.00275210250850984, 0.0559592065037129, 0.191898501040046, 0.288097848976207, 0.243464876149874, 0.126655434523959, 0.0416165279282755, 0.00854028896771484, 0.001049375722054, 7.14465183983061e-05, 2.37181254785104e-06, 3.10657932252379e-08, 1.10745442941932e-10, 5.1912334498595e-14, 5.6436561197838e-19, 2.70185616776825e-28, 6.3537766151195e-05, 0.00691153422600411, 0.0598916550064907, 0.173953653324494, 0.24918227851274, 0.204018358035326, 0.101087723622248, 0.0305856812634023, 0.00550211438411429, 0.000552322445822363, 2.76489815512467e-05, 5.69961873846227e-07, 3.44410609460131e-09, 3.12334546352011e-12, 8.58028716728236e-17, 2.19755161949904e-25, 1.01554327548058e-06, 0.000590985105423333, 0.012940772527697, 0.0727153752455005, 0.17656196218287, 0.227516984988488, 0.169992651001648, 0.0758338156125082, 0.0199722675064221, 0.00295599348455377, 0.000223139816833799, 7.23949581048299e-06, 7.41525918023936e-08, 1.30097407793993e-10, 9.03113345721675e-15, 1.23741421806916e-22, 1.19032718914674e-08, 3.7057834218628e-05, 0.00205047990915144, 0.0222905287918027, 0.0917441891494665, 0.186062917253808, 0.20963476338505, 0.137882479384373, 0.0531650908057868, 0.0116015409736315, 0.00132061562655313, 6.74329660683641e-05, 1.17078614730534e-06, 3.97391606396417e-09, 6.97082408588602e-13, 5.10966637246848e-20, 1.05696435520388e-10, 1.76039287260939e-06, 0.000246136999609879, 0.00517655176964802, 0.0361148699654017, 0.115274141556579, 0.19584952715094, 0.189924647487862, 0.107214077822125, 0.0344948255299366, 0.00592109269861316, 0.000475841453165994, 1.40040897057789e-05, 9.1959119680952e-08, 4.07616780955448e-11, 1.59843895835406e-17, 7.2401914305966e-13, 6.45111655832555e-08, 2.2792607195129e-05, 0.000927377322835894, 0.0109670358750959, 0.0550934142537473, 0.141148891526359, 0.201813072134213, 0.166791067674449, 0.0791203039522828, 0.0204796725556824, 0.00259028770022513, 0.000129219457281507, 1.64159734214141e-06, 1.83872045127884e-09, 3.85740542773532e-15, 3.85740542773565e-15, 1.83872045127884e-09, 1.6415973421414e-06, 0.000129219457281507, 0.00259028770022513, 0.0204796725556824, 0.0791203039522829, 0.166791067674449, 0.201813072134213, 0.141148891526359, 0.0550934142537473, 0.0109670358750959, 0.000927377322835891, 2.27926071951291e-05, 6.45111655832555e-08, 7.24019143059607e-13, 1.59843895835421e-17, 4.07616780955448e-11, 9.19591196809513e-08, 1.4004089705779e-05, 0.000475841453165994, 0.00592109269861316, 0.0344948255299366, 0.107214077822126, 0.189924647487861, 0.19584952715094, 0.115274141556579, 0.0361148699654017, 0.00517655176964801, 0.00024613699960988, 1.76039287260939e-06, 1.05696435520382e-10, 5.10966637246901e-20, 6.97082408588601e-13, 3.97391606396414e-09, 1.17078614730534e-06, 6.74329660683641e-05, 0.00132061562655313, 0.0116015409736316, 0.0531650908057868, 0.137882479384373, 0.20963476338505, 0.186062917253808, 0.0917441891494665, 0.0222905287918026, 0.00205047990915145, 3.7057834218628e-05, 1.19032718914667e-08, 1.2374142180693e-22, 9.03113345721675e-15, 1.30097407793992e-10, 7.4152591802394e-08, 7.23949581048299e-06, 0.000223139816833799, 0.00295599348455378, 0.0199722675064221, 0.0758338156125081, 0.169992651001648, 0.227516984988488, 0.17656196218287, 0.0727153752455003, 0.0129407725276971, 0.000590985105423333, 1.01554327548054e-06, 2.19755161949932e-25, 8.58028716728236e-17, 3.12334546352008e-12, 3.44410609460133e-09, 5.69961873846227e-07, 2.76489815512467e-05, 0.000552322445822364, 0.00550211438411428, 0.0305856812634022, 0.101087723622248, 0.204018358035326, 0.24918227851274, 0.173953653324494, 0.0598916550064909, 0.00691153422600411, 6.3537766151193e-05, 2.70185616776862e-28, 5.6436561197838e-19, 5.19123344985944e-14, 1.10745442941933e-10, 3.10657932252379e-08, 2.37181254785104e-06, 7.14465183983062e-05, 0.001049375722054, 0.00854028896771482, 0.0416165279282755, 0.126655434523959, 0.243464876149874, 0.288097848976207, 0.191898501040047, 0.0559592065037129, 0.00275210250850979, 2.05640865920208e-31, 2.29796453143541e-21, 5.34127764747085e-16, 2.20444498710402e-12, 1.04819756489929e-09, 1.25952166882358e-07, 5.72128398892142e-06, 0.000123895766670253, 0.0014762198150225, 0.0106061393541997, 0.0486746086027123, 0.147258216630277, 0.295372823787108, 0.380628153467915, 0.280474052653443, 0.0737940469184115, 7.30404437478163e-35, 4.36649412243805e-24, 2.56464069384781e-18, 2.0477618464182e-14, 1.65048137022457e-11, 3.1213157632586e-09, 2.13802471657506e-07, 6.82635238796066e-06, 0.000119079300895811, 0.00126140804019345, 0.00872947022011565, 0.0415651678266352, 0.141321368739602, 0.352319770778243, 0.656025336892972, 0.923389285253956, 

0.931600689535534, 0.687583708993884, 0.396046743445829, 0.176355363836809, 0.0598447129028883, 0.0151635684653473, 0.00278931620488931, 0.000358431712421671, 3.0517578125e-05, 1.59878115166929e-06, 4.63333548724731e-08, 6.33319322442759e-10, 3.17104501282249e-12, 3.76620673217438e-15, 4.56323577276674e-19, 7.59429674126545e-25, 1.25441693879685e-35, 0.0661609705674206, 0.260792022875746, 0.378389842574495, 0.32442498839537, 0.185379691392499, 0.0732735832961556, 0.020088557022853, 0.00374791608871041, 0.000457763671875, 3.44023496774539e-05, 1.44752233427079e-06, 2.94889454932416e-08, 2.30328966015799e-10, 4.60639365081086e-13, 1.07463851934766e-16, 4.50506805833419e-22, 3.97422418237345e-32, 0.00219270756445648, 0.0461604260583784, 0.168709397283883, 0.278513790049927, 0.267981801785128, 0.165234307695218, 0.0675159705897651, 0.0182885835987682, 0.003204345703125, 0.000345456980761404, 2.11039417828462e-05, 6.40770527432607e-07, 7.80731118815639e-09, 2.6292066585143e-11, 1.18102388062799e-14, 1.24715930310871e-19, 5.87583503500712e-29, 4.49866464471983e-05, 0.00505788990584361, 0.0465653783079346, 0.148014126427974, 0.239812881985828, 0.230662543974593, 0.140471540786699, 0.0552451735555166, 0.013885498046875, 0.00214745413887342, 0.000190469720536565, 8.61925780348323e-06, 1.63824359889652e-07, 9.28993029953034e-10, 8.03487292726546e-13, 2.1373052995378e-17, 5.37787724412304e-26, 6.38977670358737e-07, 0.000383679055444144, 0.00889787201079268, 0.0544576362227137, 0.148572650441549, 0.222922080219439, 0.20233421741395, 0.115533457345836, 0.041656494140625, 0.00924172368740819, 0.00119011099126256, 8.02668778772614e-05, 2.37987762828997e-06, 2.27247620703635e-08, 3.78441280515643e-11, 2.53577287375044e-15, 3.40762136294638e-23, 6.65562998516207e-09, 2.13436277920398e-05, 0.00124683963518382, 0.0146931811442083, 0.0675004486945073, 0.157990335990049, 0.213723239302724, 0.177183233670845, 0.091644287109375, 0.0291664443290135, 0.00545318728977798, 0.000548156157151217, 2.53531659654486e-05, 4.07650200417407e-07, 1.30713191944047e-09, 2.20625428836426e-13, 1.58340935263852e-20, 5.25192755153367e-11, 8.99486094821649e-07, 0.000132361327175114, 0.003003301603014, 0.0232327445499534, 0.0848269842038378, 0.171025248741604, 0.205856007686019, 0.152740478515625, 0.0697332753632748, 0.0189295125309029, 0.00283594818376388, 0.000204614233493506, 5.53990151686061e-06, 3.42031736651714e-08, 1.45420907611496e-11, 5.5739253523792e-18, 3.19701006231835e-13, 2.92426272901658e-08, 1.08394525029291e-05, 0.000473563021442755, 0.00616864950152859, 0.0351344574353183, 0.105575812728513, 0.184501621869361, 0.196380615234375, 0.128615218842363, 0.0506902188790498, 0.0113184773506547, 0.00127389960386032, 5.80780663139564e-05, 6.90413239355092e-07, 7.39424531195182e-10, 1.51364771775961e-15, 1.51364771775947e-15, 7.39424531195195e-10, 6.90413239355092e-07, 5.80780663139566e-05, 0.00127389960386032, 0.0113184773506547, 0.0506902188790498, 0.128615218842363, 0.196380615234375, 0.184501621869361, 0.105575812728513, 0.0351344574353182, 0.00616864950152858, 0.000473563021442753, 1.08394525029291e-05, 2.92426272901653e-08, 3.19701006231861e-13, 5.57392535237861e-18, 1.45420907611499e-11, 3.42031736651714e-08, 5.53990151686064e-06, 0.000204614233493507, 0.00283594818376388, 0.0189295125309029, 0.0697332753632748, 0.152740478515625, 0.205856007686019, 0.171025248741604, 0.0848269842038377, 0.0232327445499533, 0.00300330160301399, 0.000132361327175114, 8.99486094821637e-07, 5.25192755153405e-11, 1.58340935263833e-20, 2.20625428836431e-13, 1.30713191944047e-09, 4.07650200417409e-07, 2.53531659654487e-05, 0.000548156157151218, 0.00545318728977798, 0.0291664443290135, 0.091644287109375, 0.177183233670845, 0.213723239302724, 0.157990335990049, 0.0675004486945072, 0.0146931811442083, 0.00124683963518382, 2.13436277920395e-05, 6.65562998516246e-09, 3.40762136294594e-23, 2.5357728737505e-15, 3.78441280515643e-11, 2.27247620703636e-08, 2.37987762828997e-06, 8.02668778772616e-05, 0.00119011099126256, 0.00924172368740819, 0.041656494140625, 0.115533457345836, 0.20233421741395, 0.222922080219438, 0.148572650441549, 0.0544576362227136, 0.00889787201079268, 0.000383679055444141, 6.38977670358767e-07, 5.37787724412228e-26, 2.13730529953786e-17, 8.03487292726547e-13, 9.28993029953039e-10, 1.63824359889652e-07, 8.61925780348325e-06, 0.000190469720536565, 0.00214745413887342, 0.013885498046875, 0.0552451735555166, 0.140471540786699, 0.230662543974593, 0.239812881985828, 0.148014126427974, 0.0465653783079346, 0.00505788990584358, 4.49866464471999e-05, 5.87583503500622e-29, 1.24715930310875e-19, 1.18102388062799e-14, 2.62920665851432e-11, 7.80731118815642e-09, 6.40770527432609e-07, 2.11039417828462e-05, 0.000345456980761404, 0.003204345703125, 0.0182885835987682, 0.0675159705897651, 0.165234307695218, 0.267981801785128, 0.278513790049926, 0.168709397283883, 0.0461604260583782, 0.00219270756445654, 3.97422418237279e-32, 4.50506805833433e-22, 1.07463851934766e-16, 4.60639365081089e-13, 2.303289660158e-10, 2.94889454932417e-08, 1.44752233427079e-06, 3.44023496774539e-05, 0.000457763671875, 0.00374791608871041, 0.020088557022853, 0.0732735832961556, 0.185379691392498, 0.32442498839537, 0.378389842574495, 0.260792022875746, 0.0661609705674213, 1.25441693879662e-35, 7.59429674126571e-25, 4.56323577276674e-19, 3.76620673217441e-15, 3.17104501282251e-12, 6.33319322442762e-10, 4.63333548724731e-08, 1.59878115166929e-06, 3.0517578125e-05, 0.000358431712421671, 0.00278931620488931, 0.0151635684653473, 0.0598447129028883, 0.176355363836809, 0.396046743445829, 0.687583708993884, 0.931600689535534, 

0.938572652458559, 0.715313568599468, 0.436959404734205, 0.212340362539221, 0.0811615644402857, 0.0240138603988673, 0.00538173576377702, 0.000887202955297686, 0.000103429674997502, 8.08105554999943e-06, 3.92703553442408e-07, 1.06651321339041e-08, 1.37953361745058e-10, 6.59821878589306e-13, 7.55422625875343e-16, 8.90153034663427e-20, 1.45329353276205e-25, 2.37517872646337e-36, 0.0596267376062189, 0.24235101747505, 0.371935177670949, 0.346631193497711, 0.221877580948695, 0.101664952268861, 0.0336369457179196, 0.00795274448081866, 0.00130895469308313, 0.000143671675236529, 9.85719390989183e-06, 3.83932233031755e-07, 7.33171419184216e-09, 5.43058002078601e-11, 1.04120781346229e-13, 2.35299513967788e-17, 9.65133687673311e-23, 8.41212389848502e-33, 0.00176775055170099, 0.0383177511463794, 0.14774071675497, 0.264064190805671, 0.283063072091682, 0.200857161758744, 0.0981109585984009, 0.033267323318131, 0.00773055812728158, 0.00119201302324014, 0.00011546451880022, 6.44985112214474e-06, 1.81838376958821e-07, 2.08579923596436e-09, 6.69717472557033e-12, 2.90257977240869e-15, 2.99108248429386e-20, 1.39034252837557e-29, 3.24432962542629e-05, 0.00375041420867018, 0.0363293146442765, 0.124530415729962, 0.223551231593572, 0.245656035963779, 0.177150564783944, 0.0861475134808328, 0.0282631877240519, 0.00612230416795233, 0.000837274486350311, 6.70762636566749e-05, 2.79183420273842e-06, 4.95932817745731e-08, 2.66667382604323e-10, 2.21651847874888e-13, 5.73843361694702e-18, 1.42253189189365e-26, 4.12219109041038e-07, 0.000254130982361679, 0.00618462491045457, 0.0406574860427393, 0.122227822556518, 0.208001618698451, 0.221445429247693, 0.154442488785684, 0.0715369785581957, 0.0217694753036899, 0.00420326065064266, 0.000482933345143786, 2.96751455514579e-05, 8.16342391513335e-07, 7.35101525563724e-09, 1.17181136375597e-11, 7.62179900115107e-16, 1.0076306587651e-23, 3.8408972951772e-09, 1.26280828130915e-05, 0.000772095376663821, 0.00973435165906274, 0.0490077212590973, 0.129153867608909, 0.202998265021822, 0.203044982700018, 0.132782692132278, 0.0567652358977907, 0.0154741289933712, 0.00254980488825935, 0.000231311656186481, 9.85424320888193e-06, 1.48602520580655e-07, 4.5430286999847e-10, 7.42374502415047e-14, 5.23410174631185e-21, 2.71121112103405e-11, 4.75382615844966e-07, 7.3022148558389e-05, 0.00176562963617961, 0.0148862398596413, 0.0607539033601789, 0.140975615821239, 0.202229171262758, 0.186714658514434, 0.112135468307079, 0.0431570918903814, 0.0101988868674902, 0.00136592938282289, 9.0115661053747e-05, 2.27578429799818e-06, 1.33431793737991e-08, 5.47790721174123e-12, 2.05972394117766e-18, 1.47635126306338e-13, 1.38052695485961e-08, 5.32762909919016e-06, 0.000247051735004989, 0.00348819885611465, 0.0220463488859039, 0.075525114865829, 0.155378549053715, 0.202540127761028, 0.170883163384111, 0.0928525535257361, 0.0314698243663379, 0.00622235372949805, 0.000635730413692028, 2.68863431446898e-05, 3.0232139860186e-07, 3.11818598955633e-10, 6.25275760640007e-16, 6.25275760640007e-16, 3.11818598955633e-10, 3.0232139860186e-07, 2.68863431446897e-05, 0.000635730413692028, 0.00622235372949805, 0.0314698243663379, 0.0928525535257361, 0.170883163384111, 0.202540127761028, 0.155378549053715, 0.075525114865829, 0.0220463488859039, 0.00348819885611465, 0.00024705173500499, 5.32762909919016e-06, 1.38052695485961e-08, 1.47635126306338e-13, 2.05972394117766e-18, 5.47790721174123e-12, 1.33431793737991e-08, 2.27578429799817e-06, 9.0115661053747e-05, 0.00136592938282289, 0.0101988868674902, 0.0431570918903814, 0.112135468307079, 0.186714658514434, 0.202229171262758, 0.140975615821239, 0.0607539033601789, 0.0148862398596413, 0.00176562963617962, 7.3022148558389e-05, 4.75382615844966e-07, 2.71121112103405e-11, 5.23410174631185e-21, 7.42374502415047e-14, 4.5430286999847e-10, 1.48602520580654e-07, 9.85424320888193e-06, 0.000231311656186481, 0.00254980488825935, 0.0154741289933712, 0.0567652358977907, 0.132782692132278, 0.203044982700018, 0.202998265021822, 0.129153867608909, 0.0490077212590973, 0.00973435165906277, 0.000772095376663821, 1.26280828130915e-05, 3.8408972951772e-09, 1.0076306587651e-23, 7.62179900115107e-16, 1.17181136375597e-11, 7.35101525563719e-09, 8.16342391513335e-07, 2.96751455514579e-05, 0.000482933345143786, 0.00420326065064266, 0.0217694753036899, 0.0715369785581957, 0.154442488785684, 0.221445429247693, 0.208001618698451, 0.122227822556518, 0.0406574860427394, 0.00618462491045457, 0.000254130982361679, 4.12219109041038e-07, 1.42253189189365e-26, 5.73843361694702e-18, 2.21651847874888e-13, 2.66667382604321e-10, 4.95932817745731e-08, 2.79183420273842e-06, 6.70762636566749e-05, 0.000837274486350311, 0.00612230416795233, 0.0282631877240519, 0.0861475134808328, 0.177150564783944, 0.245656035963779, 0.223551231593572, 0.124530415729962, 0.0363293146442765, 0.00375041420867018, 3.24432962542629e-05, 1.39034252837557e-29, 2.99108248429386e-20, 2.90257977240869e-15, 6.69717472557029e-12, 2.08579923596436e-09, 1.81838376958821e-07, 6.44985112214474e-06, 0.00011546451880022, 0.00119201302324014, 0.00773055812728158, 0.033267323318131, 0.0981109585984009, 0.200857161758744, 0.283063072091682, 0.264064190805671, 0.14774071675497, 0.0383177511463794, 0.00176775055170099, 8.41212389848502e-33, 9.65133687673311e-23, 2.35299513967788e-17, 1.04120781346228e-13, 5.43058002078601e-11, 7.33171419184216e-09, 3.83932233031755e-07, 9.85719390989183e-06, 0.000143671675236529, 0.00130895469308313, 0.00795274448081866, 0.0336369457179196, 0.101664952268861, 0.221877580948696, 0.346631193497711, 0.371935177670949, 0.24235101747505, 0.0596267376062189, 2.37517872646337e-36, 1.45329353276205e-25, 8.90153034663427e-20, 7.55422625875337e-16, 6.59821878589306e-13, 1.37953361745058e-10, 1.06651321339041e-08, 3.92703553442408e-07, 8.08105554999943e-06, 0.000103429674997502, 0.000887202955297686, 0.00538173576377702, 0.0240138603988673, 0.0811615644402857, 0.212340362539221, 0.436959404734205, 0.715313568599468, 0.938572652458559, 

0.944540181233619, 0.739746519032059, 0.474969324826381, 0.248502265085717, 0.104986894955356, 0.0353646724869089, 0.0093369572607942, 0.00188877486123395, 0.0002840754490929, 3.0517578125e-05, 2.21797870605539e-06, 1.01161878481636e-07, 2.60064790987367e-09, 3.21042863799015e-11, 1.47707584912711e-13, 1.63924006912301e-16, 1.88645884115662e-20, 3.03013290545314e-26, 4.9077794329579e-37, 0.0539953055843802, 0.22525067742465, 0.362539729294824, 0.362556552055586, 0.255335302473448, 0.13239160834298, 0.0512021710121141, 0.014707106330286, 0.00308337636444878, 0.000457763671875, 4.5977680006835e-05, 2.92315850294191e-06, 1.067040914203e-07, 1.92954415448835e-09, 1.36649970607349e-11, 2.52801515445025e-14, 5.56083243246037e-18, 2.23903571032207e-23, 1.93166579131349e-33, 0.00144045053748797, 0.0320078175090363, 0.129137516765806, 0.24684705221276, 0.289796688128563, 0.231290639480034, 0.131032238889606, 0.0534417968440209, 0.0156180265598209, 0.003204345703125, 0.000444778222961199, 3.94180036531643e-05, 2.04308937984851e-06, 5.41194285822988e-08, 5.89960681870964e-10, 1.81938062604194e-12, 7.64960594141938e-16, 7.72088606444238e-21, 3.54801724651174e-30, 2.37883737964071e-05, 0.00281559429365901, 0.0284756281674274, 0.104040921528033, 0.20361043382446, 0.250138023078162, 0.207583105650408, 0.120215074183531, 0.0489722246051592, 0.013885498046875, 0.00266356951033681, 0.000329049279037475, 2.42168536951775e-05, 9.39670821372375e-07, 1.57674206026335e-08, 8.10571847728912e-11, 6.51421932311574e-14, 1.6481522390765e-18, 4.03425655415917e-27, 2.71975832899961e-07, 0.000171468065258225, 0.0043470371612284, 0.0303584498667472, 0.0990388976251295, 0.187283935375395, 0.227669579668481, 0.187212982850201, 0.10630964438792, 0.041656494140625, 0.0110429145498902, 0.0019016317457567, 0.000198722584536849, 1.12952913456281e-05, 2.91740950632542e-07, 2.50010715749002e-09, 3.84047415123377e-12, 2.43571607878876e-16, 3.17570725640976e-24, 2.28032790993275e-09, 7.6576911232263e-06, 0.000486647860572637, 0.00649615562321363, 0.0353275070909286, 0.102830693816878, 0.183113107329288, 0.213803309356348, 0.169237625873408, 0.091644287109375, 0.0335741336106103, 0.00805922573411588, 0.0011958540035049, 9.9568177883056e-05, 3.95854476827324e-06, 5.65492900523694e-08, 1.66038477492385e-10, 2.63971735271809e-14, 1.83323793571794e-21, 1.4484061460184e-11, 2.59082757650019e-07, 4.12726498351354e-05, 0.00105307503537753, 0.00954654569297639, 0.042773134204545, 0.111573209964981, 0.18497751984977, 0.204101996009142, 0.152740478515625, 0.0773307079319541, 0.0258753534273791, 0.0054517403755366, 0.000664920542363681, 4.0691134337563e-05, 9.68995497897421e-07, 5.43824422382309e-09, 2.1672761933812e-12, 8.01721035424734e-19, 7.09707075479524e-14, 6.76199580357498e-09, 2.70026014909722e-06, 0.00013169155750544, 0.00199010155352867, 0.0137250868887533, 0.0524440403940532, 0.123457989725641, 0.189886154472877, 0.196380615234375, 0.137402576793666, 0.0640877434886427, 0.0191729036188828, 0.00342542656285371, 0.000322670864358328, 1.28089072635571e-05, 1.37405587029177e-07, 1.37267212151797e-10, 2.70472703207217e-16, 2.70472703207216e-16, 1.37267212151797e-10, 1.37405587029177e-07, 1.28089072635571e-05, 0.000322670864358327, 0.00342542656285372, 0.0191729036188828, 0.0640877434886426, 0.137402576793666, 0.196380615234375, 0.189886154472877, 0.123457989725642, 0.0524440403940532, 0.0137250868887533, 0.00199010155352868, 0.00013169155750544, 2.70026014909723e-06, 6.76199580357498e-09, 7.09707075479524e-14, 8.01721035424734e-19, 2.1672761933812e-12, 5.43824422382309e-09, 9.68995497897421e-07, 4.06911343375629e-05, 0.000664920542363682, 0.0054517403755366, 0.0258753534273791, 0.0773307079319541, 0.152740478515625, 0.204101996009142, 0.18497751984977, 0.111573209964981, 0.042773134204545, 0.00954654569297641, 0.00105307503537753, 4.12726498351354e-05, 2.59082757650019e-07, 1.4484061460184e-11, 1.83323793571794e-21, 2.63971735271809e-14, 1.66038477492385e-10, 5.65492900523694e-08, 3.95854476827322e-06, 9.95681778830563e-05, 0.0011958540035049, 0.00805922573411587, 0.0335741336106103, 0.091644287109375, 0.169237625873408, 0.213803309356348, 0.183113107329288, 0.102830693816878, 0.0353275070909286, 0.00649615562321363, 0.000486647860572637, 7.6576911232263e-06, 2.28032790993275e-09, 3.17570725640976e-24, 2.43571607878876e-16, 3.84047415123377e-12, 2.50010715749002e-09, 2.91740950632541e-07, 1.12952913456281e-05, 0.000198722584536849, 0.0019016317457567, 0.0110429145498902, 0.041656494140625, 0.10630964438792, 0.187212982850201, 0.227669579668481, 0.187283935375395, 0.0990388976251297, 0.0303584498667472, 0.0043470371612284, 0.000171468065258225, 2.71975832899961e-07, 4.03425655415917e-27, 1.6481522390765e-18, 6.51421932311573e-14, 8.10571847728912e-11, 1.57674206026334e-08, 9.39670821372378e-07, 2.42168536951775e-05, 0.000329049279037475, 0.00266356951033681, 0.013885498046875, 0.0489722246051592, 0.120215074183531, 0.207583105650408, 0.250138023078162, 0.20361043382446, 0.104040921528033, 0.0284756281674274, 0.00281559429365901, 2.37883737964071e-05, 3.54801724651174e-30, 7.72088606444238e-21, 7.64960594141938e-16, 1.81938062604194e-12, 5.89960681870961e-10, 5.4119428582299e-08, 2.04308937984852e-06, 3.94180036531642e-05, 0.000444778222961199, 0.003204345703125, 0.0156180265598209, 0.0534417968440209, 0.131032238889606, 0.231290639480033, 0.289796688128563, 0.24684705221276, 0.129137516765806, 0.0320078175090363, 0.00144045053748797, 1.93166579131349e-33, 2.23903571032207e-23, 5.56083243246037e-18, 2.52801515445025e-14, 1.36649970607348e-11, 1.92954415448836e-09, 1.067040914203e-07, 2.92315850294191e-06, 4.5977680006835e-05, 0.000457763671875, 0.00308337636444878, 0.0147071063302861, 0.0512021710121141, 0.13239160834298, 0.255335302473449, 0.362556552055586, 0.362539729294824, 0.22525067742465, 0.0539953055843802, 4.9077794329579e-37, 3.03013290545314e-26, 1.88645884115662e-20, 1.63924006912301e-16, 1.4770758491271e-13, 3.21042863799016e-11, 2.60064790987367e-09, 1.01161878481636e-07, 2.21797870605539e-06, 3.0517578125e-05, 0.0002840754490929, 0.00188877486123395, 0.0093369572607942, 0.0353646724869089, 0.104986894955356, 0.248502265085717, 0.474969324826381, 0.739746519032059, 0.944540181233619, 

0.949685653980178, 0.7613409704789, 0.510113786212756, 0.284243372819712, 0.13075307108967, 0.0491488435791702, 0.0148916769590573, 0.00357237805500046, 0.000662810576356635, 9.22403766229386e-05, 9.24520355324406e-06, 6.31853485542536e-07, 2.73037883571442e-08, 6.69814430744469e-10, 7.94529521290208e-12, 3.53620748643473e-14, 3.82123323108111e-17, 4.309360840118e-21, 6.82598807727884e-27, 1.09705726041372e-37, 0.0491112624092424, 0.209496231614179, 0.35118937910336, 0.372977373864846, 0.284893285277844, 0.164000187719183, 0.0723161991183711, 0.0244305384139227, 0.00625310641020541, 0.00118689423557701, 0.000161662035447316, 1.50692804066833e-05, 8.98317378679496e-07, 3.10345200041245e-08, 5.35749180132219e-10, 3.65165670340057e-12, 6.55230228586308e-15, 1.40838394794987e-18, 5.58150129058575e-24, 4.77321057141193e-34, 0.00118519305816242, 0.0269017176566363, 0.11282944881438, 0.228392272965666, 0.289680532033897, 0.255377227340343, 0.16388317082597, 0.077967829571508, 0.0275301761121557, 0.00712704916303021, 0.00131918707815141, 0.000167716358322306, 1.37925153241849e-05, 6.71030633137339e-07, 1.68585327060284e-08, 1.75974170283659e-10, 5.24313554540191e-13, 2.14800878506767e-16, 2.12982202848701e-21, 9.69167121705966e-31, 1.77060284581549e-05, 0.00213849314681628, 0.0224402462039108, 0.0865773690401914, 0.182339375526229, 0.246175057121122, 0.229909640279678, 0.154035885209098, 0.075031947259591, 0.0264930248103812, 0.00666390492348025, 0.00115553310211868, 0.000131093514400577, 8.98180698251516e-06, 3.28399198197929e-07, 5.24966956082988e-09, 2.59724131650785e-11, 2.02803337341338e-14, 5.03106185946224e-19, 1.2181781597883e-27, 1.83126997062569e-07, 0.000117688728956476, 0.0030898110752063, 0.0227209517114897, 0.0794585753072719, 0.164287713156918, 0.22329508451479, 0.210682047240544, 0.14157370661107, 0.068179293237232, 0.0233050668436434, 0.00551173736743083, 0.000862617162701495, 8.32308339974813e-05, 4.42877442501863e-06, 1.08421189175016e-07, 8.90702513349477e-10, 1.32560245242486e-12, 8.22763765295049e-17, 1.06003963147226e-24, 1.38894489507346e-09, 4.74966859676009e-06, 0.000311987834509114, 0.00437270399596622, 0.0253923274984874, 0.0804021287695688, 0.159038609483258, 0.211317068383707, 0.195893675065091, 0.128669279695529, 0.0597686353077339, 0.0192795132838202, 0.00416252072712399, 0.000565595832816414, 4.37992283311753e-05, 1.64209315634118e-06, 2.24003332168652e-08, 6.35408362736143e-11, 9.86715800933427e-15, 6.7644863076286e-22, 7.98075037052138e-12, 1.4521711778153e-07, 2.38654409293694e-05, 0.000637528653673307, 0.00614738363237534, 0.0298095952597789, 0.0858127946422748, 0.160571214816146, 0.205345076283004, 0.183959962916298, 0.116124109161762, 0.0510892685700535, 0.015216710994167, 0.00291175094044432, 0.000328152280200942, 1.88411533635781e-05, 4.26778319008328e-07, 2.30737733679573e-09, 8.96468590009083e-13, 3.27019470064119e-19, 3.5375139194142e-14, 3.42505884306061e-09, 1.40830585677282e-06, 7.17042765104015e-05, 0.00114808446898872, 0.00852590189732826, 0.0357188313674406, 0.0941231664095987, 0.166051917000509, 0.202893192971402, 0.174047252040156, 0.104438114866379, 0.0429122113655922, 0.0115637306599523, 0.00189661907220643, 0.000166768068196963, 6.27257608680561e-06, 6.46368284613001e-08, 6.28309739876199e-11, 1.21957389194767e-16, 1.21957389194751e-16, 6.28309739876183e-11, 6.46368284613001e-08, 6.27257608680557e-06, 0.000166768068196963, 0.00189661907220643, 0.0115637306599523, 0.0429122113655922, 0.104438114866379, 0.174047252040156, 0.202893192971402, 0.166051917000509, 0.0941231664095987, 0.0357188313674406, 0.00852590189732824, 0.00114808446898872, 7.17042765104019e-05, 1.40830585677282e-06, 3.42505884306068e-09, 3.5375139194146e-14, 3.27019470064071e-19, 8.96468590009058e-13, 2.30737733679573e-09, 4.26778319008325e-07, 1.88411533635781e-05, 0.000328152280200943, 0.00291175094044432, 0.015216710994167, 0.0510892685700536, 0.116124109161762, 0.183959962916298, 0.205345076283004, 0.160571214816146, 0.0858127946422748, 0.0298095952597788, 0.00614738363237534, 0.00063752865367331, 2.38654409293694e-05, 1.45217117781532e-07, 7.98075037052216e-12, 6.76448630762751e-22, 9.86715800933396e-15, 6.35408362736143e-11, 2.2400333216865e-08, 1.64209315634118e-06, 4.37992283311755e-05, 0.000565595832816414, 0.00416252072712399, 0.0192795132838202, 0.0597686353077339, 0.128669279695529, 0.195893675065091, 0.211317068383707, 0.159038609483258, 0.0804021287695686, 0.0253923274984874, 0.00437270399596624, 0.000311987834509114, 4.74966859676017e-06, 1.38894489507357e-09, 1.06003963147207e-24, 8.22763765295021e-17, 1.32560245242486e-12, 8.9070251334947e-10, 1.08421189175016e-07, 4.42877442501864e-06, 8.32308339974813e-05, 0.000862617162701495, 0.00551173736743083, 0.0233050668436434, 0.068179293237232, 0.14157370661107, 0.210682047240544, 0.22329508451479, 0.164287713156917, 0.0794585753072719, 0.0227209517114897, 0.0030898110752063, 0.000117688728956477, 1.83126997062581e-07, 1.21817815978806e-27, 5.03106185946205e-19, 2.02803337341338e-14, 2.59724131650783e-11, 5.24966956082988e-09, 3.2839919819793e-07, 8.98180698251516e-06, 0.000131093514400577, 0.00115553310211868, 0.00666390492348025, 0.0264930248103812, 0.075031947259591, 0.154035885209098, 0.229909640279678, 0.246175057121122, 0.182339375526229, 0.0865773690401916, 0.0224402462039108, 0.0021384931468163, 1.77060284581558e-05, 9.69167121705763e-31, 2.12982202848693e-21, 2.14800878506767e-16, 5.24313554540187e-13, 1.75974170283659e-10, 1.68585327060285e-08, 6.71030633137339e-07, 1.37925153241849e-05, 0.000167716358322306, 0.00131918707815141, 0.00712704916303021, 0.0275301761121557, 0.077967829571508, 0.16388317082597, 0.255377227340343, 0.289680532033897, 0.228392272965666, 0.11282944881438, 0.0269017176566365, 0.00118519305816246, 4.77321057141085e-34, 5.58150129058551e-24, 1.40838394794987e-18, 6.55230228586302e-15, 3.65165670340057e-12, 5.35749180132221e-10, 3.10345200041245e-08, 8.98317378679496e-07, 1.50692804066833e-05, 0.000161662035447316, 0.00118689423557701, 0.00625310641020541, 0.0244305384139227, 0.0723161991183711, 0.164000187719183, 0.284893285277844, 0.372977373864846, 0.35118937910336, 0.20949623161418, 0.0491112624092431, 1.09705726041346e-37, 6.82598807727852e-27, 4.309360840118e-21, 3.82123323108107e-17, 3.53620748643473e-14, 7.94529521290212e-12, 6.69814430744469e-10, 2.73037883571442e-08, 6.31853485542536e-07, 9.24520355324406e-06, 9.22403766229386e-05, 0.000662810576356635, 0.00357237805500046, 0.0148916769590573, 0.0491488435791702, 0.13075307108967, 0.284243372819712, 0.510113786212756, 0.7613409704789, 0.949685653980178, 

0.954152216238001, 0.780488802607072, 0.542507217326621, 0.319123418945609, 0.157908269437273, 0.065181817875107, 0.0221986064202114, 0.0061484383755995, 0.00135955200643357, 0.000234330177130463, 3.0517578125e-05, 2.88243484188347e-06, 1.86876602308397e-07, 7.7093341879547e-09, 1.81660484339645e-10, 2.08208090293545e-12, 9.00542484149015e-15, 9.51015012166728e-18, 1.05391610888149e-21, 1.64939670833693e-27, 2.633222030724e-38, 0.0448504608828419, 0.195039166482249, 0.33862847969626, 0.378731866597892, 0.310148312017239, 0.195213180101158, 0.0962230873797469, 0.0372740188166733, 0.0112727798210936, 0.00262169137355084, 0.000457763671875, 5.79680475066438e-05, 5.07110085734162e-06, 2.8612644214866e-07, 9.42951617276984e-09, 1.56421861899188e-10, 1.03162575568788e-12, 1.8030041173306e-15, 3.79901143012294e-19, 1.48508901650273e-24, 1.26043586192051e-34, 0.000983836516521524, 0.0227448862255866, 0.0986389004230261, 0.209754748545149, 0.284276363118728, 0.272834059653033, 0.194643383124635, 0.105451896965319, 0.0436187288192293, 0.013688053382975, 0.003204345703125, 0.000544032227669428, 6.42179367253432e-05, 4.95571015866236e-06, 2.2841526929764e-07, 5.48408379708292e-09, 5.51501791399284e-11, 1.59519156821247e-13, 6.39060446855064e-17, 6.24002931113145e-22, 2.8155341768501e-31, 1.33598943375997e-05, 0.00164198718297789, 0.0177867672208171, 0.0719143918388656, 0.161300657268978, 0.236054395431008, 0.243738457972253, 0.184682876713669, 0.104481414277458, 0.0442410955616227, 0.013885498046875, 0.00316070992239508, 0.000503424682919708, 5.3134654285668e-05, 3.42519193784661e-06, 1.19024062928144e-07, 1.82513812144412e-09, 8.73681279056656e-12, 6.65483565571877e-15, 1.62309832969821e-19, 3.89336314322255e-28, 1.25597867549878e-07, 8.20644218015185e-05, 0.00222047034595313, 0.0170694284652471, 0.0633622631132911, 0.141391973133483, 0.211303957512532, 0.223922648360982, 0.1732623648044, 0.0989940775112115, 0.041656494140625, 0.0127128759529146, 0.00273219580153545, 0.000394410962474845, 3.55585342515977e-05, 1.78839981748814e-06, 4.18161169941647e-08, 3.31277829102797e-10, 4.79768674349168e-13, 2.92282079860481e-17, 3.72724705470278e-25, 8.65890419384957e-10, 3.0077483084629e-06, 0.000203279863269566, 0.00297114313049084, 0.0182526804304229, 0.0621067558971868, 0.134336066933119, 0.199099807104868, 0.210703067728917, 0.162440373347902, 0.091644287109375, 0.0374976805546057, 0.0108740308349566, 0.00214694798028164, 0.000270709947388363, 1.97058824989293e-05, 7.02575650546651e-07, 9.2115590245841e-09, 2.53645912109893e-11, 3.85976597592817e-15, 2.61669360658387e-22, 4.52240728267448e-12, 8.35130100680324e-08, 1.4098399442305e-05, 0.000391790802532417, 0.00398335202629534, 0.020667074414468, 0.0646999128487233, 0.134112644238876, 0.194116990081802, 0.201931845217354, 0.152740478515625, 0.0837897837154769, 0.0327865235423619, 0.00885360485094428, 0.00156131541289935, 0.000164495199997237, 8.94269780198103e-06, 1.94043891536702e-07, 1.01589755599144e-09, 3.86140919697001e-13, 1.39169361629292e-19, 1.82209966810049e-14, 1.78880295304519e-09, 7.54294571072282e-07, 3.98547986183756e-05, 0.000670604474463147, 0.00530536027818495, 0.0240386725814711, 0.0696890158285983, 0.137959610121813, 0.193647265385882, 0.196380615234375, 0.144435335186961, 0.0762598415628951, 0.0281653056014931, 0.00694660811438449, 0.00105926906740699, 8.7809142412086e-05, 3.1532799699653e-06, 3.13882919510931e-08, 2.98006954784864e-11, 5.70992122626438e-17, 5.7099212262652e-17, 2.98006954784856e-11, 3.13882919510935e-08, 3.1532799699653e-06, 8.7809142412086e-05, 0.00105926906740699, 0.00694660811438449, 0.0281653056014931, 0.0762598415628951, 0.144435335186961, 0.196380615234375, 0.193647265385882, 0.137959610121813, 0.0696890158285984, 0.0240386725814711, 0.00530536027818495, 0.000670604474463146, 3.98547986183756e-05, 7.54294571072275e-07, 1.78880295304523e-09, 1.82209966810026e-14, 1.39169361629314e-19, 3.8614091969699e-13, 1.01589755599145e-09, 1.94043891536702e-07, 8.94269780198103e-06, 0.000164495199997237, 0.00156131541289935, 0.00885360485094427, 0.0327865235423619, 0.0837897837154769, 0.152740478515625, 0.201931845217354, 0.194116990081802, 0.134112644238876, 0.0646999128487233, 0.020667074414468, 0.00398335202629534, 0.000391790802532417, 1.40983994423049e-05, 8.35130100680341e-08, 4.52240728267399e-12, 2.61669360658433e-22, 3.85976597592804e-15, 2.53645912109896e-11, 9.21155902458411e-09, 7.02575650546651e-07, 1.97058824989293e-05, 0.000270709947388363, 0.00214694798028164, 0.0108740308349566, 0.0374976805546057, 0.091644287109375, 0.162440373347902, 0.210703067728917, 0.199099807104868, 0.134336066933119, 0.0621067558971868, 0.0182526804304229, 0.00297114313049084, 0.000203279863269564, 3.00774830846296e-06, 8.6589041938488e-10, 3.7272470547035e-25, 2.9228207986047e-17, 4.79768674349175e-13, 3.31277829102797e-10, 4.18161169941647e-08, 1.78839981748814e-06, 3.55585342515977e-05, 0.000394410962474844, 0.00273219580153545, 0.0127128759529146, 0.041656494140625, 0.0989940775112115, 0.1732623648044, 0.223922648360982, 0.211303957512532, 0.141391973133483, 0.0633622631132911, 0.0170694284652471, 0.00222047034595312, 8.20644218015196e-05, 1.25597867549869e-07, 3.89336314322338e-28, 1.62309832969815e-19, 6.65483565571888e-15, 8.73681279056657e-12, 1.82513812144412e-09, 1.19024062928144e-07, 3.42519193784661e-06, 5.31346542856678e-05, 0.000503424682919708, 0.00316070992239508, 0.013885498046875, 0.0442410955616227, 0.104481414277458, 0.184682876713669, 0.243738457972253, 0.236054395431008, 0.161300657268978, 0.0719143918388656, 0.017786767220817, 0.00164198718297791, 1.33598943375989e-05, 2.81553417685075e-31, 6.24002931113117e-22, 6.39060446855075e-17, 1.59519156821247e-13, 5.51501791399284e-11, 5.48408379708292e-09, 2.2841526929764e-07, 4.95571015866235e-06, 6.42179367253432e-05, 0.000544032227669428, 0.003204345703125, 0.013688053382975, 0.0436187288192293, 0.105451896965319, 0.194643383124635, 0.272834059653033, 0.284276363118728, 0.209754748545149, 0.0986389004230258, 0.0227448862255868, 0.000983836516521489, 1.26043586192082e-34, 1.48508901650266e-24, 3.79901143012302e-19, 1.8030041173306e-15, 1.03162575568788e-12, 1.56421861899188e-10, 9.42951617276984e-09, 2.86126442148659e-07, 5.07110085734162e-06, 5.79680475066438e-05, 0.000457763671875, 0.00262169137355084, 0.0112727798210936, 0.0372740188166733, 0.0962230873797469, 0.195213180101158, 0.310148312017239, 0.378731866597892, 0.33862847969626, 0.19503916648225, 0.0448504608828411, 2.63322203072471e-38, 1.64939670833684e-27, 1.05391610888151e-21, 9.51015012166728e-18, 9.00542484149015e-15, 2.08208090293545e-12, 1.81660484339645e-10, 7.70933418795468e-09, 1.86876602308397e-07, 2.88243484188347e-06, 3.0517578125e-05, 0.000234330177130463, 0.00135955200643357, 0.0061484383755995, 0.0221986064202114, 0.065181817875107, 0.157908269437273, 0.319123418945609, 0.542507217326621, 0.780488802607072, 0.954152216238001, 

0.958053401619509, 0.797523537376705, 0.572307776681373, 0.35283390471932, 0.185949620691069, 0.0832002624868767, 0.0313207537210301, 0.00980516276852341, 0.00251493203542002, 0.000518562795261523, 8.38917338153065e-05, 1.03185901434408e-05, 9.259248002075e-07, 5.73553365709348e-08, 2.27300779072467e-09, 5.17239466115004e-11, 5.75426522091828e-13, 2.42781060558867e-15, 2.51320096989525e-18, 2.74314910371739e-22, 4.24833430107428e-28, 6.7430768285559e-39, 0.0411129716694896, 0.181802470278104, 0.32540849837338, 0.380632058647193, 0.331035464427035, 0.22501266708977, 0.122024609644615, 0.0531156467976695, 0.0184992455634058, 0.00510126131667517, 0.00109430195573698, 0.000177985603473543, 2.11778573235032e-05, 1.75439986951267e-06, 9.44095169468949e-08, 2.98716320055239e-09, 4.78729425205707e-11, 3.06844325426216e-13, 5.24173044720467e-16, 1.08550715120489e-19, 4.19319376561801e-25, 3.53550515055355e-35, 0.000823331633113064, 0.0193402833104734, 0.0863445469840842, 0.191622807015815, 0.275017626856177, 0.283985404102032, 0.221855106980733, 0.134275544488607, 0.0635021694733057, 0.0234185805861343, 0.00666134553118437, 0.00143270299672254, 0.000226045101790774, 2.50432172524764e-05, 1.82994234880092e-06, 8.05068857516415e-08, 1.85864800724693e-09, 1.80978993667995e-11, 5.10186461732594e-14, 2.00457700629326e-17, 1.93142549478746e-22, 8.65070737605439e-32, 1.02069219070015e-05, 0.00127364953356442, 0.0141828985801512, 0.0597190773243524, 0.141439461746792, 0.221875387478192, 0.249698245795368, 0.210133564483496, 0.134942007131448, 0.0665529979847947, 0.0251021433470754, 0.00713923241887295, 0.00149359290116761, 0.000221297095222281, 2.19575104224586e-05, 1.34317055119594e-06, 4.46712634661471e-08, 6.60788231089097e-10, 3.0740238576878e-12, 2.2915896788358e-15, 5.50725322256075e-20, 1.31031534318069e-28, 8.76019834564301e-08, 5.80679116336085e-05, 0.00161285095803212, 0.0128848135275218, 0.0503593153173968, 0.120011094209994, 0.194563203960616, 0.227663333183433, 0.198520301271409, 0.13094045204588, 0.0654875595213479, 0.0246289574980108, 0.00683232533640664, 0.00135381855706256, 0.000182401306392339, 1.55141666692004e-05, 7.43290323310769e-07, 1.67030425315201e-08, 1.28228539168098e-10, 1.81363600005015e-13, 1.08715455244103e-17, 1.37403940736556e-25, 5.51359056985321e-10, 1.9414396712714e-06, 0.000134500810627063, 0.00203865911067852, 0.0131489315579873, 0.0476030838357721, 0.11117505514526, 0.180880678578402, 0.214172700012045, 0.188921538736053, 0.125287641299308, 0.0623077349715086, 0.0229195592331364, 0.0060736063193436, 0.00111115390670043, 0.000131409623271824, 9.06964206285504e-06, 3.0962092276264e-07, 3.92250568423958e-09, 1.05260353490621e-11, 1.57379788731059e-15, 1.05663252900715e-22, 2.62894291130508e-12, 4.91742405070628e-08, 8.49731339197895e-06, 0.000244363960806845, 0.00260092112216014, 0.0143045713978694, 0.0481260332194159, 0.108872284515432, 0.175044861592883, 0.206497682150945, 0.181586571522644, 0.119416398039427, 0.0582465294575599, 0.0206423378870952, 0.00512798279458982, 0.000843241469703766, 8.38393466967025e-05, 4.3480154947584e-06, 9.09009741436942e-08, 4.62813042529935e-10, 1.72596782690017e-13, 6.15566296700208e-20, 9.66993416774515e-15, 9.60831299740692e-10, 4.14127518257364e-07, 2.259568018112e-05, 0.00039688036933838, 0.00331596800188837, 0.0160712071609108, 0.0505519849686399, 0.110364739209514, 0.174118376112708, 0.203027536273576, 0.176555678697153, 0.114190392459362, 0.054121128879388, 0.018256378072819, 0.00417419239608131, 0.000597862540162801, 4.71028933885903e-05, 1.62505929822042e-06, 1.56979186540335e-08, 1.46019935986641e-11, 2.7664409855254e-17, 2.7664409855254e-17, 1.46019935986641e-11, 1.56979186540333e-08, 1.62505929822043e-06, 4.71028933885905e-05, 0.000597862540162801, 0.00417419239608131, 0.018256378072819, 0.054121128879388, 0.114190392459362, 0.176555678697153, 0.203027536273576, 0.174118376112708, 0.110364739209514, 0.0505519849686399, 0.0160712071609108, 0.00331596800188837, 0.000396880369338379, 2.25956801811199e-05, 4.14127518257368e-07, 9.60831299740692e-10, 9.66993416774515e-15, 6.15566296700208e-20, 1.72596782690017e-13, 4.62813042529929e-10, 9.09009741436949e-08, 4.34801549475842e-06, 8.38393466967025e-05, 0.000843241469703767, 0.00512798279458982, 0.0206423378870952, 0.0582465294575598, 0.119416398039427, 0.181586571522644, 0.206497682150946, 0.175044861592883, 0.108872284515432, 0.0481260332194159, 0.0143045713978694, 0.00260092112216014, 0.000244363960806843, 8.49731339197903e-06, 4.91742405070628e-08, 2.62894291130508e-12, 1.05663252900715e-22, 1.57379788731059e-15, 1.05260353490619e-11, 3.92250568423961e-09, 3.09620922762642e-07, 9.06964206285504e-06, 0.000131409623271824, 0.00111115390670043, 0.0060736063193436, 0.0229195592331364, 0.0623077349715086, 0.125287641299308, 0.188921538736053, 0.214172700012045, 0.180880678578402, 0.11117505514526, 0.0476030838357721, 0.0131489315579872, 0.00203865911067851, 0.000134500810627064, 1.9414396712714e-06, 5.51359056985321e-10, 1.37403940736556e-25, 1.08715455244103e-17, 1.81363600005012e-13, 1.28228539168099e-10, 1.67030425315202e-08, 7.43290323310769e-07, 1.55141666692004e-05, 0.000182401306392339, 0.00135381855706256, 0.00683232533640663, 0.0246289574980108, 0.0654875595213479, 0.13094045204588, 0.198520301271409, 0.227663333183433, 0.194563203960616, 0.120011094209994, 0.0503593153173967, 0.0128848135275217, 0.00161285095803213, 5.80679116336085e-05, 8.76019834564301e-08, 1.31031534318069e-28, 5.50725322256075e-20, 2.29158967883576e-15, 3.07402385768783e-12, 6.60788231089101e-10, 4.46712634661471e-08, 1.34317055119594e-06, 2.19575104224586e-05, 0.000221297095222281, 0.00149359290116761, 0.00713923241887295, 0.0251021433470754, 0.0665529979847947, 0.134942007131448, 0.210133564483496, 0.249698245795368, 0.221875387478192, 0.141439461746792, 0.0597190773243523, 0.0141828985801512, 0.00127364953356442, 1.02069219070015e-05, 8.65070737605439e-32, 1.93142549478746e-22, 2.00457700629322e-17, 5.10186461732599e-14, 1.80978993667997e-11, 1.85864800724693e-09, 8.05068857516415e-08, 1.82994234880092e-06, 2.50432172524764e-05, 0.000226045101790774, 0.00143270299672254, 0.00666134553118437, 0.0234185805861343, 0.0635021694733057, 0.134275544488607, 0.221855106980733, 0.283985404102032, 0.275017626856177, 0.191622807015814, 0.0863445469840845, 0.0193402833104734, 0.000823331633113064, 3.53550515055355e-35, 4.19319376561801e-25, 1.08550715120487e-19, 5.24173044720473e-16, 3.06844325426218e-13, 4.78729425205707e-11, 2.98716320055239e-09, 9.44095169468949e-08, 1.75439986951267e-06, 2.11778573235031e-05, 0.000177985603473543, 0.00109430195573698, 0.00510126131667517, 0.0184992455634058, 0.0531156467976695, 0.122024609644615, 0.22501266708977, 0.331035464427035, 0.380632058647193, 0.32540849837338, 0.181802470278104, 0.0411129716694896, 6.7430768285559e-39, 4.24833430107428e-28, 2.74314910371733e-22, 2.51320096989529e-18, 2.42781060558869e-15, 5.75426522091828e-13, 5.17239466115004e-11, 2.27300779072467e-09, 5.73553365709348e-08, 9.25924800207498e-07, 1.03185901434408e-05, 8.38917338153065e-05, 0.000518562795261523, 0.00251493203542002, 0.00980516276852341, 0.0313207537210301, 0.0832002624868767, 0.185949620691069, 0.35283390471932, 0.572307776681373, 0.797523537376705, 0.958053401619509, 

0.961480132812043, 0.812728534770014, 0.599695008771579, 0.385171920437822, 0.214439791855134, 0.102897487847133, 0.0422382881904282, 0.0146910623944408, 0.00427742861358459, 0.00102672801164893, 0.000199285274844144, 3.0517578125e-05, 3.57195952349942e-06, 3.06560532765748e-07, 1.82507997247992e-08, 6.98418304757437e-10, 1.54165985199662e-11, 1.67105501662778e-13, 6.89916236995542e-16, 7.0182581063587e-19, 7.55931999920574e-23, 1.16003682976217e-28, 1.83190801774679e-39, 0.0378177596252386, 0.169696096238118, 0.311930982422189, 0.379417646488172, 0.347719757973831, 0.252659188037818, 0.148804609672243, 0.0716058695447042, 0.0281371844758549, 0.00896500890482858, 0.00228627547108608, 0.000457763671875, 7.00544455313521e-05, 7.89956988995228e-06, 6.24261497517488e-07, 3.22405700191407e-08, 9.8460266011426e-10, 1.53123886113781e-11, 9.5731506320488e-14, 1.60305693486959e-16, 3.26992031556653e-20, 1.25005163414019e-25, 1.04792620153288e-35, 0.000694157563937473, 0.0165350295886303, 0.0757169955395927, 0.174416357959655, 0.26312380529618, 0.289515754270805, 0.244643252458772, 0.162873647977762, 0.0863744483309061, 0.0365302648323939, 0.012240204814077, 0.003204345703125, 0.00064116772404484, 9.49942745255414e-05, 9.96455666642284e-06, 6.94538925698293e-07, 2.93454131244311e-08, 6.54789817837429e-10, 6.19897949699865e-12, 1.70873745616321e-14, 6.60082759639289e-18, 6.28623927302861e-23, 2.79746406207625e-32, 7.8875909707454e-06, 0.000997383452579351, 0.0113776426709646, 0.0496341923033739, 0.123257958831234, 0.205368279110211, 0.248985557500897, 0.22933856032257, 0.164139835095163, 0.0921465275111847, 0.0405669979761359, 0.013885498046875, 0.00363271779889242, 0.000707156393976604, 9.84630921337968e-05, 9.26220796212855e-06, 5.41431486951624e-07, 1.73334475188864e-08, 2.48490371245439e-10, 1.12752398536031e-12, 8.24866502896636e-16, 1.95694184807213e-20, 4.62298400007692e-29, 6.2048295991606e-08, 4.16503349185608e-05, 0.00118361473885618, 0.00977853650789558, 0.0399732038931458, 0.10085412916163, 0.17543418677816, 0.223564322186017, 0.215944355225072, 0.160917873149305, 0.093079965372227, 0.041656494140625, 0.0142492113641849, 0.00364445566880158, 0.000673578344757413, 8.5512897442904e-05, 6.91585607073791e-06, 3.17663370437356e-07, 6.89601324620421e-09, 5.15080841021227e-11, 7.13621790249765e-14, 4.21758739436127e-18, 5.2890713027247e-26, 3.57945381525274e-10, 1.27548766643776e-06, 9.0296281318684e-05, 0.00141275934967008, 0.00950658142266706, 0.0363208020061083, 0.0906474780287712, 0.15981934217724, 0.208339273559808, 0.20607771020149, 0.156617750462593, 0.091644287109375, 0.0409874992252234, 0.0137737214930981, 0.00337912446422446, 0.000578962109601935, 6.47813225720031e-05, 4.2692418223375e-06, 1.40342120833697e-07, 1.72554555441874e-09, 4.527453137399e-12, 6.66579090951147e-16, 4.43749502764514e-23, 1.56433490586555e-12, 2.95910310535478e-08, 5.21861711718787e-06, 0.000154628159837672, 0.00171279684554972, 0.00990930610838075, 0.0354832419266177, 0.0865530246244168, 0.152274262134983, 0.1999326973196, 0.199641957434218, 0.152740478515625, 0.089317813530936, 0.0394362845361982, 0.0128424040476941, 0.00296957795857398, 0.000459705545779166, 4.34670773248005e-05, 2.16373491079784e-06, 4.37928824047942e-08, 2.17603508624113e-10, 7.98114776807937e-14, 2.82047598192842e-20, 5.27397939529243e-15, 5.29589848652121e-10, 2.32668035838155e-07, 1.3055836562478e-05, 0.000238058151204337, 0.00208557964220622, 0.010714861916599, 0.036160204601487, 0.0858573701634558, 0.149634711279823, 0.196317211511458, 0.196380615234375, 0.150148315635024, 0.0871036602927034, 0.0376516653833985, 0.0117499235198661, 0.00251654902617132, 0.000341401829473144, 2.57345032232918e-05, 8.57385930562969e-07, 8.06814218735442e-09, 7.37182023917589e-12, 1.3829378145427e-17, 1.38293781454293e-17, 7.37182023917589e-12, 8.06814218735431e-09, 8.57385930562969e-07, 2.57345032232918e-05, 0.000341401829473143, 0.00251654902617133, 0.0117499235198661, 0.0376516653833985, 0.0871036602927034, 0.150148315635024, 0.196380615234375, 0.196317211511458, 0.149634711279823, 0.0858573701634558, 0.0361602046014871, 0.010714861916599, 0.00208557964220623, 0.000238058151204337, 1.3055836562478e-05, 2.32668035838158e-07, 5.29589848652121e-10, 5.27397939529165e-15, 2.82047598192896e-20, 7.98114776807937e-14, 2.1760350862411e-10, 4.37928824047942e-08, 2.16373491079784e-06, 4.34670773248003e-05, 0.000459705545779167, 0.00296957795857397, 0.0128424040476941, 0.0394362845361982, 0.089317813530936, 0.152740478515625, 0.199641957434218, 0.1999326973196, 0.152274262134983, 0.0865530246244169, 0.0354832419266177, 0.00990930610838077, 0.00171279684554972, 0.000154628159837672, 5.21861711718793e-06, 2.95910310535478e-08, 1.56433490586535e-12, 4.43749502764608e-23, 6.66579090951147e-16, 4.52745313739892e-12, 1.72554555441874e-09, 1.40342120833697e-07, 4.26924182233748e-06, 6.47813225720033e-05, 0.000578962109601934, 0.00337912446422446, 0.0137737214930981, 0.0409874992252234, 0.091644287109375, 0.156617750462593, 0.20607771020149, 0.208339273559808, 0.15981934217724, 0.0906474780287711, 0.0363208020061084, 0.00950658142266706, 0.00141275934967008, 9.02962813186847e-05, 1.27548766643776e-06, 3.57945381525236e-10, 5.28907130272593e-26, 4.21758739436127e-18, 7.13621790249752e-14, 5.15080841021227e-11, 6.89601324620421e-09, 3.17663370437355e-07, 6.91585607073793e-06, 8.55128974429038e-05, 0.000673578344757413, 0.00364445566880158, 0.0142492113641849, 0.041656494140625, 0.093079965372227, 0.160917873149305, 0.215944355225072, 0.223564322186017, 0.17543418677816, 0.10085412916163, 0.0399732038931458, 0.00977853650789559, 0.00118361473885618, 4.16503349185608e-05, 6.20482959916008e-08, 4.6229840000781e-29, 1.95694184807213e-20, 8.24866502896619e-16, 1.12752398536031e-12, 2.48490371245439e-10, 1.73334475188863e-08, 5.41431486951626e-07, 9.26220796212852e-06, 9.84630921337968e-05, 0.000707156393976604, 0.00363271779889242, 0.013885498046875, 0.0405669979761359, 0.0921465275111847, 0.164139835095163, 0.22933856032257, 0.248985557500897, 0.205368279110212, 0.123257958831234, 0.0496341923033739, 0.0113776426709647, 0.000997383452579351, 7.88759097074489e-06, 2.79746406207702e-32, 6.28623927302861e-23, 6.60082759639275e-18, 1.70873745616321e-14, 6.19897949699865e-12, 6.54789817837425e-10, 2.93454131244312e-08, 6.94538925698291e-07, 9.96455666642284e-06, 9.49942745255414e-05, 0.00064116772404484, 0.003204345703125, 0.012240204814077, 0.0365302648323939, 0.0863744483309061, 0.162873647977762, 0.244643252458771, 0.289515754270805, 0.26312380529618, 0.174416357959655, 0.0757169955395929, 0.0165350295886303, 0.000694157563937443, 1.04792620153319e-35, 1.25005163414019e-25, 3.26992031556645e-20, 1.60305693486959e-16, 9.5731506320488e-14, 1.53123886113781e-11, 9.84602660114264e-10, 3.22405700191406e-08, 6.24261497517488e-07, 7.89956988995228e-06, 7.00544455313521e-05, 0.000457763671875, 0.00228627547108608, 0.00896500890482858, 0.0281371844758549, 0.0716058695447042, 0.148804609672242, 0.252659188037818, 0.347719757973831, 0.379417646488172, 0.31193098242219, 0.169696096238118, 0.0378177596252378, 1.83190801774737e-39, 1.16003682976217e-28, 7.55931999920555e-23, 7.0182581063587e-19, 6.89916236995542e-16, 1.67105501662777e-13, 1.54165985199663e-11, 6.98418304757435e-10, 1.82507997247992e-08, 3.06560532765748e-07, 3.57195952349942e-06, 3.0517578125e-05, 0.000199285274844144, 0.00102672801164893, 0.00427742861358459, 0.0146910623944408, 0.0422382881904282, 0.102897487847133, 0.214439791855134, 0.385171920437822, 0.599695008771579, 0.812728534770014, 0.961480132812043, 

0.964505880061465, 0.826344538991791, 0.624855321665159, 0.41601644779781, 0.243012153093734, 0.123952056266899, 0.0548628499214528, 0.0209051935439101, 0.00678967846087357, 0.00185629838230243, 0.00042060712445552, 7.74502467626258e-05, 1.13055532119933e-05, 1.26712846381173e-06, 1.04593028131317e-07, 6.01412898384116e-09, 2.23194682551009e-10, 4.79685491055688e-12, 5.08203749828531e-14, 2.05857060191579e-16, 2.06221800964635e-19, 2.19540083613573e-23, 3.34195765686887e-29, 5.25400179027687e-40, 0.0348986393291134, 0.158626255510397, 0.298483060282194, 0.375736482531389, 0.360508163822178, 0.277671050581508, 0.17571742786732, 0.0922374798473128, 0.0402187623799823, 0.014503162352723, 0.0042844737389627, 0.00102187709731227, 0.000192796203066868, 2.79886727493259e-05, 3.01210656301179e-06, 2.28441899038539e-07, 1.1381857028135e-08, 3.36978837020112e-10, 5.10438607983134e-12, 3.12220326765192e-14, 5.13741003175986e-17, 1.03408473575984e-20, 3.91714411553222e-26, 3.26715034324658e-36, 0.000589276185551196, 0.0142100551888158, 0.0665375316284986, 0.158366387573812, 0.249579548922438, 0.290278086851659, 0.262638320227731, 0.189918575958948, 0.111177006853287, 0.0528791434840996, 0.0203669091760896, 0.00629189268346891, 0.00153430576130785, 0.000288503271898551, 4.04803919619029e-05, 4.04935233498572e-06, 2.70862691260604e-07, 1.10472823133427e-08, 2.39252203898362e-10, 2.20985288362225e-12, 5.97256196893464e-15, 2.27303022510028e-18, 2.14261893139551e-23, 9.48101435061192e-33, 6.15961181940915e-06, 0.000788025941154857, 0.00918200954796812, 0.0413206089182954, 0.106961366969036, 0.187854653724314, 0.243010704380301, 0.242075880135334, 0.190250282607382, 0.119352129716833, 0.0599344916038701, 0.0239821439238015, 0.00755874009583503, 0.00184095528035876, 0.000336777557791259, 4.44344110970609e-05, 3.99033456475662e-06, 2.2419831050305e-07, 6.94212510643946e-09, 9.68254688116613e-11, 4.29834387810502e-13, 3.09298882900075e-16, 7.25511637913552e-21, 1.70319567548714e-29, 4.45745486340022e-08, 3.02541127561547e-05, 0.000877218842311947, 0.00746396462601457, 0.0317354054231549, 0.0841644755677766, 0.155665321721593, 0.213616478303382, 0.225390081518715, 0.186498391738022, 0.122103378856112, 0.0632839910640677, 0.0257801871897846, 0.00813270262008109, 0.00193972755205927, 0.000337561142467835, 4.06975802392652e-05, 3.14998420189535e-06, 1.39453070819384e-07, 2.9370748308011e-09, 2.14161207554552e-11, 2.91373901594672e-14, 1.70075981505156e-18, 2.11823161007742e-26, 2.3654947623276e-10, 8.51784541553542e-07, 6.14581650211953e-05, 0.000988721227114718, 0.00690498251535326, 0.0276526725596196, 0.0731239712075732, 0.138235442966482, 0.19581489171656, 0.213708322444564, 0.182423155704533, 0.122461942004124, 0.0644798689927353, 0.0263468058761185, 0.00819293957903797, 0.00188055869763963, 0.000304389237125817, 3.24553159950801e-05, 2.0543060930251e-06, 6.53343900412218e-08, 7.8249556160978e-10, 2.01291007386153e-12, 2.92376871444274e-16, 1.93189611753902e-23, 9.51005647922677e-13, 1.81677504496195e-08, 3.26194996911347e-06, 9.92211400526049e-05, 0.00113817013133957, 0.00688290015086574, 0.026022782578, 0.0677688529515331, 0.128879161473527, 0.185521329622141, 0.206470645394519, 0.179528950745398, 0.122176673149938, 0.0646617002069952, 0.0262159040162961, 0.00793683602390469, 0.00172470993497762, 0.000253331606346965, 2.29260003787588e-05, 1.10101881096474e-06, 2.16595299560283e-08, 1.05347483580529e-10, 3.80775600905559e-14, 1.33481218813587e-20, 2.9494424148357e-15, 2.98929156981968e-10, 1.33558250619009e-07, 7.68122146958393e-06, 0.000144726315339537, 0.00132160461771486, 0.007144032427517, 0.0256292903425979, 0.065435798523197, 0.124240153987019, 0.180273705716906, 0.203031565320519, 0.178586309968665, 0.122422709627886, 0.0647121224755586, 0.0258406623830044, 0.00753873639584949, 0.00152541717459844, 0.000197372733569437, 1.43134180837124e-05, 4.62500165046158e-07, 4.25323793508581e-09, 3.82552398726914e-12, 7.11462930986395e-18, 7.11462930986526e-18, 3.82552398726914e-12, 4.25323793508587e-09, 4.62500165046158e-07, 1.43134180837124e-05, 0.000197372733569437, 0.00152541717459844, 0.00753873639584951, 0.0258406623830044, 0.0647121224755586, 0.122422709627886, 0.178586309968665, 0.203031565320519, 0.180273705716906, 0.124240153987019, 0.065435798523197, 0.0256292903425978, 0.007144032427517, 0.00132160461771486, 0.000144726315339537, 7.68122146958393e-06, 1.33558250619007e-07, 2.98929156981968e-10, 2.94944241483522e-15, 1.33481218813615e-20, 3.80775600905559e-14, 1.05347483580531e-10, 2.16595299560283e-08, 1.10101881096474e-06, 2.29260003787589e-05, 0.000253331606346965, 0.00172470993497763, 0.00793683602390469, 0.0262159040162961, 0.0646617002069952, 0.122176673149938, 0.179528950745399, 0.206470645394519, 0.185521329622141, 0.128879161473527, 0.067768852951533, 0.026022782578, 0.00688290015086572, 0.00113817013133957, 9.92211400526049e-05, 3.26194996911343e-06, 1.81677504496195e-08, 9.51005647922546e-13, 1.93189611753947e-23, 2.92376871444274e-16, 2.01291007386156e-12, 7.8249556160978e-10, 6.53343900412218e-08, 2.05430609302511e-06, 3.24553159950801e-05, 0.000304389237125818, 0.00188055869763963, 0.00819293957903797, 0.0263468058761185, 0.0644798689927352, 0.122461942004124, 0.182423155704533, 0.213708322444564, 0.19581489171656, 0.138235442966482, 0.0731239712075732, 0.0276526725596196, 0.00690498251535326, 0.000988721227114718, 6.14581650211947e-05, 8.51784541553542e-07, 2.36549476232732e-10, 2.11823161007796e-26, 1.70075981505156e-18, 2.91373901594678e-14, 2.14161207554552e-11, 2.9370748308011e-09, 1.39453070819384e-07, 3.14998420189535e-06, 4.06975802392653e-05, 0.000337561142467835, 0.00193972755205927, 0.00813270262008109, 0.0257801871897846, 0.0632839910640678, 0.122103378856112, 0.186498391738022, 0.225390081518715, 0.213616478303382, 0.155665321721593, 0.0841644755677765, 0.0317354054231549, 0.00746396462601457, 0.00087721884231194, 3.02541127561547e-05, 4.4574548633998e-08, 1.70319567548761e-29, 7.25511637913552e-21, 3.09298882900082e-16, 4.29834387810502e-13, 9.68254688116613e-11, 6.9421251064395e-09, 2.2419831050305e-07, 3.99033456475664e-06, 4.44344110970609e-05, 0.000336777557791259, 0.00184095528035876, 0.00755874009583502, 0.0239821439238015, 0.0599344916038701, 0.119352129716833, 0.190250282607382, 0.242075880135334, 0.243010704380302, 0.187854653724313, 0.106961366969036, 0.0413206089182954, 0.00918200954796807, 0.000788025941154857, 6.15961181940872e-06, 9.48101435061476e-33, 2.14261893139551e-23, 2.27303022510034e-18, 5.97256196893464e-15, 2.20985288362225e-12, 2.39252203898363e-10, 1.10472823133427e-08, 2.70862691260605e-07, 4.04935233498572e-06, 4.04803919619029e-05, 0.000288503271898551, 0.00153430576130785, 0.00629189268346891, 0.0203669091760896, 0.0528791434840996, 0.111177006853287, 0.189918575958948, 0.262638320227731, 0.290278086851658, 0.249579548922438, 0.158366387573812, 0.0665375316284984, 0.0142100551888158, 0.000589276185551169, 3.26715034324763e-36, 3.91714411553222e-26, 1.03408473575986e-20, 5.13741003175986e-17, 3.12220326765192e-14, 5.10438607983137e-12, 3.36978837020112e-10, 1.1381857028135e-08, 2.28441899038539e-07, 3.01210656301179e-06, 2.79886727493259e-05, 0.000192796203066867, 0.00102187709731227, 0.0042844737389627, 0.014503162352723, 0.0402187623799823, 0.0922374798473128, 0.17571742786732, 0.277671050581508, 0.360508163822178, 0.375736482531389, 0.298483060282194, 0.158626255510397, 0.0348986393291126, 5.25400179027868e-40, 3.34195765686887e-29, 2.19540083613579e-23, 2.06221800964635e-19, 2.05857060191579e-16, 5.08203749828535e-14, 4.79685491055688e-12, 2.2319468255101e-10, 6.01412898384116e-09, 1.04593028131317e-07, 1.26712846381173e-06, 1.13055532119933e-05, 7.74502467626258e-05, 0.00042060712445552, 0.00185629838230243, 0.00678967846087357, 0.0209051935439101, 0.0548628499214528, 0.123952056266899, 0.243012153093734, 0.41601644779781, 0.624855321665159, 0.826344538991791, 0.964505880061465, 

1.52587890625e-05, 0.000244140625, 0.0018310546875, 0.008544921875, 0.02777099609375, 0.066650390625, 0.1221923828125, 0.174560546875, 0.196380615234375, 0.174560546875, 0.1221923828125, 0.066650390625, 0.02777099609375, 0.008544921875, 0.0018310546875, 0.000244140625, 1.52587890625e-05, 

0.0224063119030947, 1.58201142898839e-11, 0.0960600508767053, 9.44663524982291e-10, 0.193044097929793, 2.64414920346827e-08, 0.241388047338119, 4.60511294606363e-07, 0.210209130127017, 5.58561753402337e-06, 0.135180879982039, 5.00299402286948e-05, 0.0664062806427458, 0.000342309511194059, 0.0254192989579689, 0.00182502355384328, 0.00766246570644717, 0.00766246570644717, 0.00182502355384328, 0.0254192989579689, 0.000342309511194059, 0.0664062806427458, 5.00299402286948e-05, 0.135180879982039, 5.58561753402337e-06, 0.210209130127017, 4.60511294606363e-07, 0.241388047338119, 2.64414920346827e-08, 0.193044097929793, 9.44663524982291e-10, 0.0960600508767053, 1.58201142898839e-11, 0.0224063119030947, 

0.147609619999999, 1.52587890625e-05, 6.77462620661197e-16, 0.299982079999914, 0.000244140625, 8.5338430882298e-14, 0.285770399994961, 0.0018310546875, 5.03901033845853e-12, 0.169388799814864, 0.008544921875, 1.85136207554904e-10, 0.0699243952628839, 0.02777099609375, 4.73711640629421e-09, 0.0213157504914276, 0.066650390625, 8.95085725819204e-08, 0.00496366805091436, 0.1221923828125, 1.29194908568047e-06, 0.000900669294806138, 0.174560546875, 1.45307051938717e-05, 0.000128700000000002, 0.196380615234375, 0.000128700000000002, 1.45307051938717e-05, 0.174560546875, 0.000900669294806138, 1.29194908568047e-06, 0.1221923828125, 0.00496366805091436, 8.95085725819204e-08, 0.066650390625, 0.0213157504914276, 4.73711640629421e-09, 0.02777099609375, 0.0699243952628839, 1.85136207554904e-10, 0.008544921875, 0.169388799814864, 5.03901033845853e-12, 0.0018310546875, 0.285770399994961, 8.5338430882298e-14, 0.000244140625, 0.299982079999914, 6.77462620661197e-16, 1.52587890625e-05, 0.147609619999999, 

0.316206642693938, 0.00164853640429671, 1.97889437932342e-08, 2.91701870284115e-19, 0.377486553172095, 0.0129920079975506, 6.42813284018983e-07, 6.25530776752624e-17, 0.211238591595535, 0.0479949227714814, 9.78787359186296e-06, 6.28781031239022e-15, 0.0735513347264596, 0.110321417330293, 9.27336551961714e-05, 3.93274419396389e-13, 0.0178354648619387, 0.176604167668509, 0.000611875388254601, 1.71304410820123e-11, 0.00319378876623027, 0.208770890903881, 0.00298137408325557, 5.51022424318497e-10, 0.000436875950314098, 0.188525080042877, 0.0110968611538215, 1.35394241599016e-08, 4.6566179918108e-05, 0.132656595813894, 0.0321843214715643, 2.59233808259116e-07, 3.90871178558284e-06, 0.073508764839305, 0.073508764839305, 3.90871178558286e-06, 2.59233808259114e-07, 0.0321843214715643, 0.132656595813894, 4.65661799181083e-05, 1.35394241599015e-08, 0.0110968611538215, 0.188525080042877, 0.0004368759503141, 5.51022424318492e-10, 0.00298137408325557, 0.208770890903881, 0.00319378876623029, 1.71304410820121e-11, 0.000611875388254601, 0.176604167668509, 0.0178354648619388, 3.93274419396385e-13, 9.27336551961714e-05, 0.110321417330293, 0.0735513347264598, 6.28781031239015e-15, 9.78787359186296e-06, 0.0479949227714814, 0.211238591595535, 6.25530776752616e-17, 6.42813284018983e-07, 0.0129920079975506, 0.377486553172096, 2.91701870284112e-19, 1.97889437932342e-08, 0.00164853640429671, 0.316206642693938, 

0.463598523719489, 0.0150293938317682, 1.52587890625e-05, 6.46739566646081e-11, 5.498678623474e-22, 0.365085256866114, 0.0721395112225448, 0.000244140625, 3.44935319519101e-09, 1.78750000593817e-19, 0.134768323871747, 0.162310347196133, 0.0018310546875, 8.62357175813947e-08, 2.7237989427946e-17, 0.0309547197400161, 0.227229511907045, 0.008544921875, 1.3414738606008e-06, 2.58255488262846e-15, 0.00495156524115224, 0.221543924402178, 0.02777099609375, 1.45329516164497e-05, 1.70529945106519e-13, 0.000584905918202147, 0.159508133856826, 0.066650390625, 0.000116266158000172, 8.31533261252742e-12, 5.27788251647534e-05, 0.0877275532212843, 0.1221923828125, 0.000710530963538355, 3.09733936461476e-10, 3.71102557271714e-06, 0.0375966997985795, 0.174560546875, 0.00338355484483874, 8.98997499437862e-09, 2.05484343810557e-07, 0.0126886084220429, 0.196380615234375, 0.0126886084220429, 2.05484343810559e-07, 8.98997499437852e-09, 0.00338355484483874, 0.174560546875, 0.0375966997985795, 3.71102557271717e-06, 3.09733936461473e-10, 0.000710530963538355, 0.1221923828125, 0.0877275532212844, 5.27788251647537e-05, 8.31533261252731e-12, 0.000116266158000172, 0.066650390625, 0.159508133856826, 0.000584905918202151, 1.70529945106516e-13, 1.45329516164497e-05, 0.02777099609375, 0.221543924402178, 0.00495156524115226, 2.58255488262842e-15, 1.3414738606008e-06, 0.008544921875, 0.227229511907045, 0.0309547197400162, 2.72379894279455e-17, 8.62357175813947e-08, 0.0018310546875, 0.162310347196134, 0.134768323871748, 1.78750000593814e-19, 3.44935319519101e-09, 0.000244140625, 0.0721395112225448, 0.365085256866114, 5.4986786234739e-22, 6.46739566646081e-11, 1.52587890625e-05, 0.0150293938317682, 0.463598523719489, 

0.577194908978987, 0.0513227703807899, 0.000468300817386027, 1.94603626942925e-07, 4.59644405934548e-13, 2.85442116101245e-24, 0.322722835760882, 0.167470017997392, 0.0046058418794792, 5.06531883351025e-06, 3.60607677343056e-11, 1.3069254418686e-21, 0.0845820453433721, 0.256156466223083, 0.0212341271536772, 6.18021984807321e-05, 1.32613958556684e-09, 2.80494825108911e-19, 0.0137934271798295, 0.243791801890672, 0.0609123451755069, 0.000469187658062044, 3.03451317227266e-08, 3.74579850283471e-17, 0.00156654462183567, 0.161588128584064, 0.121689416143623, 0.00248065183638962, 4.83576730943195e-07, 3.48369840893321e-15, 0.000131383623150556, 0.0790911127790571, 0.17952633916769, 0.00968529672106115, 5.69075179131207e-06, 2.39256953981718e-13, 8.41724351068838e-06, 0.0295716878778799, 0.202317633145938, 0.0288861883886366, 5.11568842501771e-05, 1.2552169107837e-11, 4.20202927741205e-07, 0.0086155908554986, 0.177664157826643, 0.0671317661974838, 0.000358343105083444, 5.13137222434601e-10, 1.65195730589508e-08, 0.00197671738591693, 0.122861685767483, 0.122861685767483, 0.00197671738591692, 1.65195730589508e-08, 5.13137222434601e-10, 0.000358343105083445, 0.0671317661974838, 0.177664157826643, 0.00861559085549858, 4.20202927741205e-07, 1.2552169107837e-11, 5.11568842501773e-05, 0.0288861883886366, 0.202317633145938, 0.0295716878778798, 8.41724351068838e-06, 2.39256953981718e-13, 5.6907517913121e-06, 0.00968529672106115, 0.17952633916769, 0.079091112779057, 0.000131383623150556, 3.48369840893321e-15, 4.83576730943197e-07, 0.00248065183638962, 0.121689416143623, 0.161588128584064, 0.00156654462183567, 3.74579850283471e-17, 3.03451317227267e-08, 0.000469187658062044, 0.0609123451755069, 0.243791801890672, 0.0137934271798295, 2.80494825108911e-19, 1.32613958556684e-09, 6.18021984807321e-05, 0.0212341271536772, 0.256156466223083, 0.0845820453433721, 1.3069254418686e-21, 3.60607677343058e-11, 5.06531883351025e-06, 0.0046058418794792, 0.167470017997392, 0.322722835760882, 2.85442116101245e-24, 4.5964440593455e-13, 1.94603626942925e-07, 0.000468300817386027, 0.0513227703807899, 0.577194908978987, 

0.662055230897051, 0.109249677035572, 0.00355238369205369, 1.52587890625e-05, 3.68056420562075e-09, 6.05411241477398e-15, 3.08975706570544e-26, 0.27658497618431, 0.25942811457438, 0.0240216042881662, 0.000244140625, 1.39338850262363e-07, 6.52669876381256e-13, 1.8933457741544e-23, 0.0541631895937304, 0.288772077772811, 0.076142201608355, 0.0018310546875, 2.47269942541869e-06, 3.29820721192756e-11, 5.43847098697265e-21, 0.00659971823554475, 0.200004088485595, 0.15017386876146, 0.008544921875, 2.7303350905555e-05, 1.03706940703147e-09, 9.72006602441214e-19, 0.000560045274915736, 0.0964715218275859, 0.206271814192516, 0.02777099609375, 0.000209960284969014, 2.27098512214535e-08, 1.2098685674655e-16, 3.50952840025497e-05, 0.0343626988613926, 0.209224861073645, 0.066650390625, 0.00119230190293908, 3.67238864441275e-07, 1.11207749870622e-14, 1.67998180462761e-06, 0.00934987050335014, 0.162112641034529, 0.1221923828125, 0.00517208333378034, 4.53641915575585e-06, 7.80840096110696e-13, 6.2664404954744e-08, 0.00198236878622611, 0.0978770788307965, 0.174560546875, 0.0174825715989004, 4.36654802134324e-05, 4.27218139306309e-11, 1.84072039622301e-09, 0.000330989234291154, 0.0465367103281444, 0.196380615234375, 0.0465367103281444, 0.000330989234291154, 1.84072039622304e-09, 4.27218139306301e-11, 4.36654802134324e-05, 0.0174825715989004, 0.174560546875, 0.0978770788307965, 0.00198236878622611, 6.2664404954745e-08, 7.80840096110679e-13, 4.53641915575585e-06, 0.00517208333378034, 0.1221923828125, 0.162112641034529, 0.00934987050335014, 1.67998180462763e-06, 1.11207749870619e-14, 3.67238864441275e-07, 0.00119230190293908, 0.066650390625, 0.209224861073645, 0.0343626988613926, 3.50952840025501e-05, 1.20986856746547e-16, 2.27098512214535e-08, 0.000209960284969014, 0.02777099609375, 0.206271814192516, 0.0964715218275859, 0.000560045274915741, 9.72006602441187e-19, 1.03706940703147e-09, 2.7303350905555e-05, 0.008544921875, 0.15017386876146, 0.200004088485595, 0.0065997182355448, 5.43847098697249e-21, 3.29820721192756e-11, 2.47269942541869e-06, 0.0018310546875, 0.076142201608355, 0.288772077772811, 0.0541631895937306, 1.89334577415434e-23, 6.52669876381256e-13, 1.39338850262363e-07, 0.000244140625, 0.0240216042881662, 0.25942811457438, 0.276584976184311, 3.08975706570533e-26, 6.05411241477398e-15, 3.68056420562075e-09, 1.52587890625e-05, 0.00355238369205369, 0.109249677035572, 0.662055230897051, 

0.725512253887608, 0.179886886440954, 0.0131299504724956, 0.000225854381397848, 5.96177097578139e-07, 1.00652577662252e-10, 1.30275821835619e-16, 5.83369035164687e-28, 0.235150495681478, 0.325732436126159, 0.0653383531478785, 0.00249341848977669, 1.38244734259664e-05, 5.1779728714725e-09, 1.84179921879938e-14, 4.60767874951499e-25, 0.0357263234461321, 0.276480044393868, 0.152410385170759, 0.0129033688515668, 0.000150266852030231, 1.24863619742275e-07, 1.2205681357108e-12, 1.7059342622584e-22, 0.00337735156295475, 0.146019914995237, 0.221210865487335, 0.0415486164009839, 0.00101630320768927, 1.87351678530037e-06, 5.03300415808059e-11, 3.92995799837132e-20, 0.000222351874663165, 0.0537077516529819, 0.223601611535104, 0.0931722535894643, 0.00478696204739582, 1.95774370426025e-05, 1.44533703265349e-09, 6.30507280856831e-18, 1.08101868567851e-05, 0.014587797752445, 0.166905744498271, 0.154292392998722, 0.0166503954657516, 0.000151071299296054, 3.06505909554184e-08, 7.46999281149288e-16, 4.01472497331094e-07, 0.00302672307778327, 0.0951695098197606, 0.195178790583461, 0.0442404274741919, 0.000890508944169138, 4.96522310079962e-07, 6.76052549357967e-14, 1.16182020068305e-08, 0.000489346141102289, 0.0422848608507417, 0.19238945111488, 0.0915955978479497, 0.00409029972012817, 6.26757020725253e-06, 4.76761580678998e-12, 2.6477233753364e-10, 6.23031794553284e-05, 0.0147952579579886, 0.149341480044216, 0.149341480044216, 0.0147952579579886, 6.23031794553284e-05, 2.6477233753364e-10, 4.76761580678998e-12, 6.26757020725253e-06, 0.00409029972012817, 0.0915955978479499, 0.19238945111488, 0.0422848608507417, 0.000489346141102289, 1.16182020068305e-08, 6.76052549357967e-14, 4.96522310079962e-07, 0.000890508944169138, 0.044240427474192, 0.195178790583461, 0.0951695098197606, 0.00302672307778327, 4.01472497331094e-07, 7.46999281149288e-16, 3.06505909554184e-08, 0.000151071299296054, 0.0166503954657516, 0.154292392998721, 0.166905744498271, 0.014587797752445, 1.08101868567851e-05, 6.30507280856831e-18, 1.44533703265349e-09, 1.95774370426025e-05, 0.00478696204739583, 0.0931722535894642, 0.223601611535104, 0.0537077516529819, 0.000222351874663165, 3.92995799837132e-20, 5.03300415808059e-11, 1.87351678530037e-06, 0.00101630320768927, 0.0415486164009839, 0.221210865487335, 0.146019914995237, 0.00337735156295475, 1.7059342622584e-22, 1.2205681357108e-12, 1.24863619742275e-07, 0.000150266852030232, 0.0129033688515668, 0.152410385170759, 0.276480044393868, 0.0357263234461321, 4.60767874951499e-25, 1.84179921879938e-14, 5.1779728714725e-09, 1.38244734259665e-05, 0.00249341848977669, 0.0653383531478785, 0.325732436126159, 0.235150495681478, 5.83369035164687e-28, 1.30275821835619e-16, 1.00652577662252e-10, 5.96177097578141e-07, 0.000225854381397848, 0.0131299504724956, 0.179886886440954, 0.725512253887608, 

0.773548117281684, 0.254448930721485, 0.0321565815473972, 0.00136476456741709, 1.52587890625e-05, 2.88444150748462e-08, 3.80384762345604e-12, 4.16584867101484e-18, 1.70230252943409e-29, 0.200224240194892, 0.363581721427999, 0.123296126865031, 0.0111427008515805, 0.000244140625, 9.04417525311919e-07, 2.53970641968726e-10, 7.46349151836755e-16, 1.68363284257638e-26, 0.0242933415351681, 0.243525662586522, 0.221600264749326, 0.04264464313298, 0.0018310546875, 1.32928309838454e-05, 7.94850044370216e-09, 6.26789739210882e-14, 7.80547458769753e-24, 0.00183401707631586, 0.101492264667201, 0.247820160093171, 0.101550955774237, 0.008544921875, 0.000121565828401015, 1.54786259876864e-07, 3.27527092945108e-12, 2.25162860262323e-21, 9.642642689812e-05, 0.0294576252572475, 0.193009893682165, 0.168414750440222, 0.02777099609375, 0.000774251624077088, 2.09921146725859e-06, 1.19192564171094e-10, 4.52346026452313e-19, 3.7438346036373e-06, 0.0063137939329371, 0.111007006307089, 0.206254825332318, 0.066650390625, 0.00364150253697041, 2.1023637251407e-05, 3.20316253180193e-09, 6.7107750811827e-17, 1.11036925230204e-07, 0.00103374463099811, 0.0487698480675265, 0.192956006541361, 0.1221923828125, 0.0130830590557773, 0.0001608383880718, 6.57565443233156e-08, 7.60509738740461e-15, 2.5661304212447e-09, 0.000131885380198159, 0.0166960193715904, 0.140660777018743, 0.174560546875, 0.0366267607736208, 0.00095880898377183, 1.05186380973593e-06, 6.71579454834603e-13, 4.67025491167322e-11, 1.32504493647623e-05, 0.00450116610360487, 0.0807492104293699, 0.196380615234375, 0.0807492104293699, 0.00450116610360488, 1.32504493647623e-05, 4.67025491167335e-11, 6.71579454834582e-13, 1.05186380973593e-06, 0.000958808983771828, 0.0366267607736208, 0.174560546875, 0.140660777018743, 0.0166960193715904, 0.000131885380198159, 2.56613042124476e-09, 7.60509738740434e-15, 6.57565443233157e-08, 0.0001608383880718, 0.0130830590557773, 0.1221923828125, 0.192956006541361, 0.0487698480675266, 0.00103374463099811, 1.11036925230206e-07, 6.71077508118244e-17, 3.20316253180193e-09, 2.1023637251407e-05, 0.00364150253697041, 0.066650390625, 0.206254825332318, 0.11100700630709, 0.0063137939329371, 3.74383460363737e-06, 4.52346026452294e-19, 1.19192564171094e-10, 2.09921146725859e-06, 0.000774251624077088, 0.02777099609375, 0.168414750440222, 0.193009893682165, 0.0294576252572475, 9.64264268981214e-05, 2.25162860262313e-21, 3.27527092945108e-12, 1.54786259876864e-07, 0.000121565828401015, 0.008544921875, 0.101550955774237, 0.247820160093171, 0.101492264667201, 0.00183401707631588, 7.80547458769715e-24, 6.26789739210882e-14, 7.94850044370213e-09, 1.32928309838454e-05, 0.0018310546875, 0.04264464313298, 0.221600264749326, 0.243525662586522, 0.0242933415351682, 1.68363284257629e-26, 7.46349151836755e-16, 2.53970641968725e-10, 9.04417525311919e-07, 0.000244140625, 0.0111427008515805, 0.123296126865031, 0.363581721427999, 0.200224240194893, 1.70230252943399e-29, 4.16584867101484e-18, 3.80384762345602e-12, 2.88444150748462e-08, 1.52587890625e-05, 0.00136476456741709, 0.0321565815473972, 0.254448930721485, 0.773548117281684, 

0.810485788943543, 0.32705254915016, 0.0610978658800897, 0.00484591892132691, 0.000140566081105572, 1.15722823402083e-06, 1.72187522753707e-09, 1.89989224675246e-13, 1.84330836213548e-19, 7.04741513910333e-31, 0.171423621254631, 0.37859406333376, 0.186612167211554, 0.0306485704279022, 0.00166617907129917, 2.49929688797456e-05, 6.96959536112173e-08, 1.5924104539261e-11, 4.07644603588873e-17, 8.52991217295194e-28, 0.0169956276097748, 0.205433535973448, 0.267174590893279, 0.0908626881961245, 0.00925772111437913, 0.000253021809081783, 1.32237531067502e-06, 6.25636892559527e-10, 4.22577804555317e-15, 4.83950056346903e-25, 0.00104845372217666, 0.0693608490591653, 0.238010363227568, 0.167612521016915, 0.0320060463530987, 0.00159383581750841, 1.5611600070484e-05, 1.52944969827369e-08, 2.72569454495869e-13, 1.7084491125929e-22, 4.50440990708958e-05, 0.0163092518860747, 0.147663501056849, 0.215329689976661, 0.0770613381397223, 0.0069920703301983, 0.000128356150062171, 2.60390194511582e-07, 1.22440266883087e-11, 4.20029825943965e-20, 1.42907303574385e-06, 0.00283192377992192, 0.0676516410679833, 0.204281600939197, 0.137015261226086, 0.0226514430382226, 0.000779316422355723, 3.27372303783698e-06, 4.06161945679955e-10, 7.62581199192312e-18, 3.46338791992517e-08, 0.000375629137888134, 0.0236762928939706, 0.148041945377797, 0.186093640975609, 0.0560552319579911, 0.00361444122491439, 3.14404994402936e-05, 1.02921092412971e-08, 1.05760196853636e-15, 6.54046123525899e-10, 3.88237526980314e-05, 0.00645668496768579, 0.083598953183547, 0.196949393745679, 0.108092847779197, 0.0130625820406131, 0.000235286745824291, 2.03221694730707e-07, 1.1429281576868e-13, 9.72671467943569e-12, 3.1599943985984e-06, 0.0013866155062756, 0.0371764107293745, 0.164145252363708, 0.164145252363708, 0.0371764107293745, 0.0013866155062756, 3.15999439859838e-06, 9.72671467943569e-12, 1.1429281576868e-13, 2.03221694730709e-07, 0.000235286745824291, 0.0130625820406131, 0.108092847779197, 0.196949393745679, 0.083598953183547, 0.00645668496768579, 3.88237526980312e-05, 6.54046123525899e-10, 1.05760196853636e-15, 1.02921092412972e-08, 3.14404994402936e-05, 0.00361444122491439, 0.0560552319579911, 0.186093640975609, 0.148041945377797, 0.0236762928939706, 0.000375629137888132, 3.46338791992516e-08, 7.62581199192312e-18, 4.06161945679959e-10, 3.27372303783698e-06, 0.000779316422355723, 0.0226514430382226, 0.137015261226086, 0.204281600939197, 0.0676516410679833, 0.0028319237799219, 1.42907303574385e-06, 4.20029825943965e-20, 1.22440266883089e-11, 2.60390194511582e-07, 0.000128356150062171, 0.0069920703301983, 0.0770613381397223, 0.215329689976661, 0.147663501056849, 0.0163092518860746, 4.50440990708958e-05, 1.7084491125929e-22, 2.72569454495871e-13, 1.52944969827369e-08, 1.5611600070484e-05, 0.00159383581750841, 0.0320060463530987, 0.167612521016915, 0.238010363227568, 0.0693608490591652, 0.00104845372217666, 4.83950056346903e-25, 4.22577804555322e-15, 6.25636892559527e-10, 1.32237531067502e-06, 0.000253021809081783, 0.00925772111437913, 0.0908626881961245, 0.267174590893279, 0.205433535973447, 0.0169956276097748, 8.52991217295194e-28, 4.07644603588878e-17, 1.5924104539261e-11, 6.96959536112173e-08, 2.49929688797456e-05, 0.00166617907129917, 0.0306485704279022, 0.186612167211554, 0.37859406333376, 0.171423621254631, 7.04741513910333e-31, 1.84330836213551e-19, 1.89989224675246e-13, 1.72187522753707e-09, 1.15722823402083e-06, 0.000140566081105572, 0.00484591892132691, 0.0610978658800897, 0.32705254915016, 0.810485788943543, 

0.839351546462873, 0.394549035753072, 0.098371260796138, 0.0122711194385087, 0.000694831607984297, 1.52587890625e-05, 1.00238156438005e-07, 1.24868367224982e-10, 1.206221828684e-14, 1.06886941308297e-20, 3.8876147734218e-32, 0.14779937094475, 0.377809129320313, 0.245483979206162, 0.0621551589631201, 0.00639656243124129, 0.000244140625, 2.78744276835819e-06, 6.31101772581636e-09, 1.23740604142974e-12, 2.85754549238528e-18, 5.65190038038716e-29, 0.012199514768119, 0.169584123181285, 0.287156963256991, 0.147574547590041, 0.0276029183275773, 0.0018310546875, 3.63345786751277e-05, 1.49515992398293e-07, 5.9502958753968e-11, 3.58098859284669e-16, 3.85165211008002e-26, 0.000626553335185903, 0.0473634631818382, 0.209007113284418, 0.218017450690946, 0.0741154714301386, 0.008544921875, 0.000294699782655357, 2.20404985099551e-06, 1.78037057619149e-09, 2.79227533183095e-14, 1.63322164385941e-23, 2.24104261558136e-05, 0.00921251674151117, 0.105944730876982, 0.224309482623441, 0.138592372840522, 0.02777099609375, 0.0016646237342197, 2.26272491278502e-05, 3.70987122629923e-08, 1.5163174105685e-12, 4.82302795971497e-21, 5.91929609659602e-07, 0.00132324728242554, 0.0396575187221172, 0.170424446024578, 0.191380491729509, 0.066650390625, 0.00694352862453815, 0.000171541808593165, 5.70867268256632e-07, 6.0806482932714e-11, 1.05177371533154e-18, 1.1943186324403e-08, 0.000145189070353207, 0.0113397089217743, 0.0989113982702969, 0.201876699084161, 0.1221923828125, 0.0221245563576675, 0.000993432591498055, 6.71029546536063e-06, 1.86268681415778e-09, 1.75208446916379e-16, 1.87772018902722e-10, 1.24133032014893e-05, 0.00252661343384564, 0.0447323090724908, 0.165933948993932, 0.174560546875, 0.054932509177046, 0.004482985644403, 6.14622803377339e-05, 4.44621358489702e-08, 2.27430283065618e-14, 2.32483484503422e-12, 8.35778826862303e-07, 0.000443329118666097, 0.0159311400312265, 0.107407563619207, 0.196380615234375, 0.107407563619208, 0.0159311400312264, 0.000443329118666096, 8.35778826862303e-07, 2.32483484503432e-12, 2.27430283065608e-14, 4.44621358489702e-08, 6.14622803377341e-05, 0.00448298564440301, 0.0549325091770459, 0.174560546875, 0.165933948993932, 0.0447323090724907, 0.00252661343384563, 1.24133032014893e-05, 1.87772018902729e-10, 1.75208446916371e-16, 1.86268681415778e-09, 6.71029546536065e-06, 0.000993432591498058, 0.0221245563576675, 0.1221923828125, 0.201876699084161, 0.0989113982702968, 0.0113397089217743, 0.000145189070353207, 1.19431863244034e-08, 1.05177371533148e-18, 6.0806482932714e-11, 5.70867268256635e-07, 0.000171541808593165, 0.00694352862453814, 0.066650390625, 0.191380491729509, 0.170424446024578, 0.0396575187221171, 0.00132324728242554, 5.91929609659618e-07, 4.82302795971467e-21, 1.5163174105685e-12, 3.70987122629925e-08, 2.26272491278503e-05, 0.0016646237342197, 0.02777099609375, 0.138592372840522, 0.224309482623441, 0.105944730876982, 0.00921251674151117, 2.24104261558141e-05, 1.6332216438593e-23, 2.79227533183095e-14, 1.7803705761915e-09, 2.20404985099552e-06, 0.000294699782655356, 0.008544921875, 0.0741154714301387, 0.218017450690946, 0.209007113284418, 0.0473634631818382, 0.000626553335185913, 3.85165211007974e-26, 3.58098859284669e-16, 5.95029587539683e-11, 1.49515992398294e-07, 3.63345786751277e-05, 0.0018310546875, 0.0276029183275773, 0.147574547590041, 0.28715696325699, 0.169584123181285, 0.0121995147681191, 5.65190038038672e-29, 2.85754549238528e-18, 1.23740604142975e-12, 6.31101772581638e-09, 2.78744276835819e-06, 0.000244140625, 0.00639656243124129, 0.0621551589631201, 0.245483979206162, 0.377809129320313, 0.14779937094475, 3.88761477342149e-32, 1.06886941308297e-20, 1.20622182868401e-14, 1.24868367224982e-10, 1.00238156438004e-07, 1.52587890625e-05, 0.000694831607984297, 0.0122711194385087, 0.098371260796138, 0.394549035753072, 0.839351546462873, 

0.862259374336853, 0.45563711362517, 0.141484947015933, 0.0247823751709009, 0.00229108751884099, 0.000100786405745771, 1.79388700428296e-06, 9.92763289216466e-09, 1.07986450189003e-11, 9.42117802735273e-16, 7.78694866049089e-22, 2.72555989806096e-33, 0.128379748388666, 0.367101228940861, 0.294301452162698, 0.103089529157481, 0.0169418921966395, 0.00125363616054362, 3.69203233494125e-05, 3.43688847739135e-07, 6.64565208921073e-10, 1.15947932041613e-13, 2.47423263167382e-19, 4.68637567911414e-30, 0.00895976040907029, 0.138641696970834, 0.286956359708576, 0.201014536829793, 0.0587250545951474, 0.00730941035986622, 0.000356186281775283, 5.57733141219841e-06, 1.91711082213029e-08, 6.68901369026702e-12, 3.68514881190337e-17, 3.77711102727524e-27, 0.000389082582931551, 0.0325797246984291, 0.174094407819557, 0.243885450662721, 0.126657368900084, 0.0265178735750757, 0.00213813143959174, 5.63161530689692e-05, 3.44114009312735e-07, 2.40108027437812e-10, 3.41519139287148e-15, 1.89420910172295e-24, 1.17669461006974e-05, 0.0053318452348817, 0.0735580771465502, 0.206072908007571, 0.190245360678851, 0.0669995100948053, 0.00893857297573633, 0.00039601906110667, 4.3016400657028e-06, 6.00244037909348e-09, 2.20420328112714e-13, 6.61565222876449e-22, 2.62792894691171e-07, 0.000644370337616223, 0.0229511153438333, 0.128583069089102, 0.211020947368418, 0.125006454946053, 0.0275949658834629, 0.00205649226164337, 3.97094310068103e-05, 1.10809478465167e-07, 1.05054853758278e-11, 1.70626033911872e-19, 4.48325732145095e-09, 5.948722892035e-05, 0.00547025304089665, 0.061288200260219, 0.178799893216793, 0.178165431645967, 0.0650761311703476, 0.0081577100021868, 0.000280016390305689, 1.56263000690636e-06, 3.82481816796766e-10, 3.36161612200949e-17, 5.95983504023296e-11, 4.27929732697318e-06, 0.00101594819271531, 0.0227630511609447, 0.118050944722078, 0.197867731496067, 0.119584286175856, 0.0252156385588439, 0.00153862847904201, 1.71710136651064e-05, 1.08509057155514e-08, 5.16073388388636e-15, 6.2391492476375e-13, 2.42421843002013e-07, 0.000148588866734299, 0.00665785976036465, 0.0613793438184061, 0.173052177178754, 0.173052177178754, 0.0613793438184062, 0.00665785976036466, 0.0001485888667343, 2.42421843002015e-07, 6.2391492476372e-13, 5.16073388388664e-15, 1.08509057155513e-08, 1.71710136651063e-05, 0.00153862847904201, 0.0252156385588438, 0.119584286175856, 0.197867731496067, 0.118050944722078, 0.0227630511609448, 0.00101594819271531, 4.27929732697322e-06, 5.95983504023271e-11, 3.36161612200969e-17, 3.82481816796761e-10, 1.56263000690635e-06, 0.000280016390305688, 0.00815771000218678, 0.0650761311703476, 0.178165431645967, 0.178799893216793, 0.0612882002602191, 0.00547025304089667, 5.94872289203504e-05, 4.48325732145079e-09, 1.70626033911883e-19, 1.05054853758277e-11, 1.10809478465166e-07, 3.97094310068102e-05, 0.00205649226164337, 0.0275949658834629, 0.125006454946053, 0.211020947368418, 0.128583069089102, 0.0229511153438334, 0.000644370337616227, 2.62792894691164e-07, 6.61565222876497e-22, 2.20420328112711e-13, 6.00244037909345e-09, 4.30164006570279e-06, 0.000396019061106669, 0.00893857297573633, 0.0669995100948053, 0.190245360678851, 0.206072908007571, 0.0735580771465504, 0.00533184523488173, 1.17669461006972e-05, 1.8942091017231e-24, 3.41519139287143e-15, 2.4010802743781e-10, 3.44114009312734e-07, 5.6316153068969e-05, 0.00213813143959174, 0.0265178735750757, 0.126657368900084, 0.243885450662721, 0.174094407819558, 0.0325797246984292, 0.000389082582931544, 3.77711102727556e-27, 3.68514881190331e-17, 6.68901369026697e-12, 1.91711082213028e-08, 5.5773314121984e-06, 0.000356186281775283, 0.00730941035986622, 0.0587250545951474, 0.201014536829793, 0.286956359708576, 0.138641696970834, 0.00895976040907018, 4.68637567911456e-30, 2.47423263167378e-19, 1.15947932041612e-13, 6.64565208921071e-10, 3.43688847739134e-07, 3.69203233494125e-05, 0.00125363616054362, 0.0169418921966395, 0.103089529157481, 0.294301452162698, 0.367101228940862, 0.128379748388665, 2.72555989806122e-33, 7.78694866049075e-22, 9.42117802735266e-16, 1.07986450189002e-11, 9.92763289216464e-09, 1.79388700428296e-06, 0.000100786405745771, 0.00229108751884099, 0.0247823751709009, 0.141484947015933, 0.45563711362517, 0.862259374336853, 

0.880699705534374, 0.51008506183465, 0.18791849961893, 0.0427532083993999, 0.00573035182899891, 0.000421299129289599, 1.52587890625e-05, 2.30799285307463e-07, 1.1177371137978e-09, 1.09361528948877e-12, 8.80955673322661e-17, 6.89430428176287e-23, 2.34143369765675e-34, 0.112328176726767, 0.350703885815949, 0.331150985218676, 0.148964295065757, 0.0349089003922802, 0.00421575911656611, 0.000244140625, 5.90458254955842e-06, 4.69704537140545e-08, 8.03509590272549e-11, 1.27978644764044e-14, 2.56703883998355e-20, 4.69960082327392e-31, 0.00671569321926812, 0.113026383424441, 0.27354189257995, 0.243297104568329, 0.0996855780219472, 0.0197743535560456, 0.0018310546875, 7.08084713048905e-05, 9.25233011609026e-07, 2.76731652631319e-09, 8.71489658100529e-13, 4.48038890374476e-18, 4.42161941745489e-28, 0.000249826501126211, 0.0226654633893093, 0.14059412100433, 0.247250519525228, 0.177122613373206, 0.0577130889488875, 0.008544921875, 0.00052835613642527, 1.1340259733639e-05, 5.93023803978736e-08, 3.69260187747054e-11, 4.86569076012353e-16, 2.58849460352177e-25, 6.47236115059002e-06, 0.00316538072610189, 0.0503253790167304, 0.174990336039995, 0.219175633963363, 0.11730672874255, 0.02777099609375, 0.00274564809135228, 9.67991321278703e-05, 8.85038158867549e-07, 1.08963065927152e-09, 3.68001742143564e-14, 1.0553335599268e-22, 1.23826859926415e-07, 0.000326448881899632, 0.0133025478146284, 0.0914573889098479, 0.200280382499094, 0.176075694233518, 0.066650390625, 0.010536366557091, 0.000610165722205137, 9.75393251048549e-06, 2.37440076651585e-08, 2.0553374060448e-12, 3.17731384323893e-20, 1.80966076482062e-09, 2.57178471227592e-05, 0.00268604197987441, 0.0365135218680056, 0.139802438274601, 0.201885946281347, 0.1221923828125, 0.0308863836982767, 0.00293801725461338, 8.21159817866287e-05, 3.95238212094184e-07, 8.76892934680514e-11, 7.30736286581944e-18, 2.06081974334956e-11, 1.57875435106209e-06, 0.000422621209354946, 0.0113592373888197, 0.0760416627915494, 0.180373732142636, 0.174560546875, 0.0705510982506717, 0.0110235481394078, 0.000538686582494963, 5.12654003756099e-06, 2.91521466985557e-09, 1.30954901441577e-15, 1.84813377816297e-13, 7.63211794193501e-08, 5.23649078267304e-05, 0.00278288454852637, 0.032571595025671, 0.126908601262204, 0.196380615234375, 0.126908601262204, 0.032571595025671, 0.00278288454852636, 5.23649078267306e-05, 7.63211794193493e-08, 1.84813377816287e-13, 1.30954901441586e-15, 2.9152146698556e-09, 5.12654003756097e-06, 0.000538686582494965, 0.0110235481394078, 0.0705510982506717, 0.174560546875, 0.180373732142636, 0.0760416627915493, 0.0113592373888197, 0.000422621209354948, 1.57875435106208e-06, 2.06081974334946e-11, 7.30736286581995e-18, 8.76892934680526e-11, 3.95238212094182e-07, 8.21159817866289e-05, 0.00293801725461338, 0.0308863836982767, 0.1221923828125, 0.201885946281347, 0.139802438274601, 0.0365135218680056, 0.00268604197987442, 2.5717847122759e-05, 1.80966076482055e-09, 3.17731384323918e-20, 2.05533740604483e-12, 2.37440076651583e-08, 9.75393251048552e-06, 0.000610165722205137, 0.010536366557091, 0.066650390625, 0.176075694233518, 0.200280382499094, 0.0914573889098477, 0.0133025478146284, 0.00032644888189963, 1.23826859926411e-07, 1.05533355992689e-22, 3.6800174214357e-14, 1.08963065927151e-09, 8.85038158867553e-07, 9.67991321278703e-05, 0.00274564809135227, 0.02777099609375, 0.11730672874255, 0.219175633963363, 0.174990336039995, 0.0503253790167305, 0.00316538072610187, 6.47236115058984e-06, 2.58849460352201e-25, 4.86569076012362e-16, 3.69260187747051e-11, 5.93023803978738e-08, 1.1340259733639e-05, 0.00052835613642527, 0.008544921875, 0.0577130889488875, 0.177122613373206, 0.247250519525227, 0.14059412100433, 0.0226654633893093, 0.000249826501126206, 4.42161941745533e-28, 4.48038890374485e-18, 8.71489658100522e-13, 2.7673165263132e-09, 9.25233011609026e-07, 7.08084713048905e-05, 0.0018310546875, 0.0197743535560456, 0.0996855780219472, 0.243297104568328, 0.273541892579951, 0.113026383424441, 0.00671569321926802, 4.69960082327441e-31, 2.5670388399836e-20, 1.27978644764043e-14, 8.03509590272553e-11, 4.69704537140545e-08, 5.90458254955842e-06, 0.000244140625, 0.00421575911656611, 0.0349089003922802, 0.148964295065757, 0.331150985218676, 0.350703885815949, 0.112328176726766, 2.34143369765701e-34, 6.89430428176302e-23, 8.80955673322653e-17, 1.09361528948878e-12, 1.1177371137978e-09, 2.30799285307463e-07, 1.52587890625e-05, 0.000421299129289599, 0.00573035182899891, 0.0427532083993999, 0.18791849961893, 0.51008506183465, 0.880699705534374, 

0.895737813714083, 0.558212723771659, 0.235560493525201, 0.0658518156659966, 0.0117831796420592, 0.00128241547822689, 7.87953941805609e-05, 2.44866669224247e-06, 3.25632083406552e-08, 1.41848484656415e-10, 1.27562738575861e-13, 9.64199711678241e-18, 7.223408486312e-24, 2.39473029619722e-35, 0.098967619081284, 0.33144854497798, 0.356431823177559, 0.195269759564013, 0.0603139288163657, 0.0105911321290063, 0.00101484009595005, 4.86712896430903e-05, 1.0093772642396e-06, 7.09429993406375e-09, 1.10127698170856e-11, 1.63129665657321e-15, 3.11433807241429e-21, 5.54861204063456e-32, 0.00512562249486852, 0.0922515736018485, 0.252808556743582, 0.27142103980843, 0.144715156998596, 0.0410012693131208, 0.00612682793275727, 0.00045347914036999, 1.46663190820106e-05, 1.66316628078865e-07, 4.45667095357302e-10, 1.29371965302986e-13, 6.29405618877097e-19, 6.02633669221881e-29, 0.000165175499646805, 0.0159763279437077, 0.111571323308779, 0.234745646048816, 0.216050829802308, 0.0987637871941373, 0.0230154392179665, 0.00262898006572646, 0.000132597170882979, 2.42609227412053e-06, 1.12219956552013e-08, 6.38400065220985e-12, 7.91481911380207e-17, 4.07256422381593e-26, 3.70698835230171e-06, 0.00192688914581435, 0.0342917760622219, 0.141393082281539, 0.224633455204157, 0.165681778685154, 0.0602114978121411, 0.0106143609350072, 0.000834879825535692, 2.46465160879007e-05, 1.96791439334626e-07, 2.19392738859437e-10, 6.93151156449898e-15, 1.91672175214054e-23, 6.14362493531712e-08, 0.000171618607884495, 0.00778314738537431, 0.0628907333121284, 0.17247288047698, 0.205248334788828, 0.116323503776654, 0.0316466898341476, 0.00388187508484503, 0.000184897756801014, 2.54841521226399e-06, 5.56774655255141e-09, 4.48273216285751e-13, 6.66159279566568e-21, 7.77782845807972e-10, 1.1676218468729e-05, 0.00134943112534143, 0.0213685645207552, 0.101157337258016, 0.194229293023747, 0.171666563151965, 0.0720763727786538, 0.0137876210550048, 0.00105959021593029, 2.52095079259156e-05, 1.07936133981526e-07, 2.2145618963226e-11, 1.76859049030072e-18, 7.6727765680744e-12, 6.1901414766292e-07, 0.000182308415717356, 0.00565750001130209, 0.0462311276386185, 0.143222200372767, 0.197407875658203, 0.127914000061709, 0.0381590581004007, 0.00473156446850454, 0.000194320703265581, 1.63047740483355e-06, 8.524980228844e-10, 3.65878604703477e-16, 5.96070056153239e-14, 2.58433911095485e-08, 1.93960490321121e-05, 0.00117957169037259, 0.0166388055605228, 0.083168049518789, 0.178769654188233, 0.178769654188233, 0.083168049518789, 0.0166388055605228, 0.0011795716903726, 1.93960490321121e-05, 2.58433911095481e-08, 5.96070056153239e-14, 3.65878604703477e-16, 8.52498022884412e-10, 1.63047740483355e-06, 0.00019432070326558, 0.00473156446850453, 0.0381590581004007, 0.127914000061709, 0.197407875658204, 0.143222200372767, 0.0462311276386186, 0.00565750001130211, 0.000182308415717356, 6.19014147662914e-07, 7.6727765680744e-12, 1.76859049030072e-18, 2.21456189632264e-11, 1.07936133981526e-07, 2.52095079259155e-05, 0.00105959021593029, 0.0137876210550048, 0.0720763727786538, 0.171666563151965, 0.194229293023747, 0.101157337258016, 0.0213685645207552, 0.00134943112534143, 1.16762184687289e-05, 7.77782845807972e-10, 6.66159279566568e-21, 4.48273216285758e-13, 5.56774655255141e-09, 2.54841521226398e-06, 0.000184897756801014, 0.00388187508484503, 0.0316466898341476, 0.116323503776654, 0.205248334788828, 0.172472880476981, 0.0628907333121285, 0.00778314738537431, 0.000171618607884494, 6.14362493531712e-08, 1.91672175214054e-23, 6.93151156449911e-15, 2.19392738859437e-10, 1.96791439334626e-07, 2.46465160879007e-05, 0.000834879825535692, 0.0106143609350072, 0.0602114978121411, 0.165681778685154, 0.224633455204157, 0.141393082281539, 0.0342917760622219, 0.00192688914581433, 3.70698835230171e-06, 4.07256422381593e-26, 7.91481911380223e-17, 6.38400065220985e-12, 1.12219956552013e-08, 2.42609227412052e-06, 0.000132597170882979, 0.00262898006572645, 0.0230154392179665, 0.0987637871941374, 0.216050829802309, 0.234745646048816, 0.111571323308779, 0.0159763279437076, 0.000165175499646805, 6.02633669221881e-29, 6.29405618877111e-19, 1.29371965302986e-13, 4.456670953573e-10, 1.66316628078865e-07, 1.46663190820106e-05, 0.000453479140369989, 0.00612682793275727, 0.0410012693131208, 0.144715156998596, 0.27142103980843, 0.252808556743582, 0.0922515736018482, 0.00512562249486852, 5.54861204063456e-32, 3.11433807241436e-21, 1.63129665657321e-15, 1.10127698170855e-11, 7.09429993406372e-09, 1.0093772642396e-06, 4.86712896430902e-05, 0.00101484009595005, 0.0105911321290063, 0.0603139288163658, 0.195269759564013, 0.356431823177559, 0.33144854497798, 0.098967619081284, 2.39473029619722e-35, 7.22340848631218e-24, 9.64199711678241e-18, 1.27562738575861e-13, 1.41848484656415e-10, 3.25632083406552e-08, 2.44866669224247e-06, 7.87953941805609e-05, 0.00128241547822689, 0.0117831796420592, 0.0658518156659966, 0.235560493525201, 0.558212723771659, 0.895737813714083, 

0.908146677380746, 0.600585285949586, 0.282831824851593, 0.0932824076665524, 0.0209998380366774, 0.00310798441761014, 0.000286636228362617, 1.52587890625e-05, 4.19353569761197e-07, 5.02743442774725e-09, 2.01042308682826e-11, 1.68865295919259e-14, 1.2121798187584e-18, 8.76493859052028e-25, 2.84938521135957e-36, 0.0877633473129063, 0.311139792324178, 0.371664158323827, 0.238522043112207, 0.0917598928412673, 0.0216099140359202, 0.00304985465026234, 0.000244140625, 1.00895604803858e-05, 1.85102452791893e-07, 1.1778513272782e-09, 1.69064177855434e-12, 2.36148183144373e-16, 4.33119735750088e-22, 7.54803578742635e-33, 0.00397568200748672, 0.0755575222560317, 0.228936146487582, 0.285889743677224, 0.187945153423662, 0.070431757656062, 0.0152113754091861, 0.0018310546875, 0.000113790349780199, 3.19462005068058e-06, 3.23470566561128e-08, 7.93421690745903e-11, 2.15647013826663e-14, 1.00324810942157e-19, 9.37255539718106e-30, 0.000112061290438856, 0.0114168258261819, 0.087745241315515, 0.213213229012282, 0.239527224282417, 0.142833320126171, 0.0472066676717785, 0.008544921875, 0.000798516940998569, 3.43061332551345e-05, 5.52744691442821e-07, 2.31687209559263e-09, 1.22531515846268e-12, 1.44595322455199e-17, 7.2414843929705e-27, 2.19976444497798e-06, 0.00120140552098745, 0.0234212115609874, 0.110740453969854, 0.212596060507654, 0.201728433580686, 0.102026921930355, 0.02777099609375, 0.00390246859143055, 0.000256567065710009, 6.57795611022155e-06, 4.71168913138749e-08, 4.84873829108565e-11, 1.45136524217027e-15, 3.89649175869917e-24, 3.18878044372745e-08, 9.33601953899354e-05, 0.00461660823687695, 0.0424743099960755, 0.139342444188758, 0.210393627631096, 0.162837379670442, 0.066650390625, 0.0140838885305542, 0.00141696109171796, 5.78076404859554e-05, 7.07585751979455e-07, 1.41689465572266e-09, 1.07578893509681e-13, 1.54827394640193e-21, 3.53104498670299e-10, 5.54196876311549e-06, 0.000695131357774421, 0.0124444743910136, 0.0697656795472266, 0.167620927916779, 0.198528846383797, 0.1221923828125, 0.0388271876725086, 0.00597785168999623, 0.000388069676162698, 8.11730235471279e-06, 3.16283527364135e-08, 6.09126678327427e-12, 4.69950420523711e-19, 3.04678920801911e-12, 2.56346221517259e-07, 8.15588819393484e-05, 0.00284110516373774, 0.0272182850889764, 0.10406014443622, 0.188605198058134, 0.174560546875, 0.0834084049137455, 0.0196513717836417, 0.00202999373853982, 7.25612727468455e-05, 5.50143657301991e-07, 2.68750136889603e-10, 1.11151877927395e-16, 2.07029450319489e-14, 9.33770887654224e-09, 7.53574526552606e-06, 0.000510797335388571, 0.00836238678235908, 0.0508734476851974, 0.141102354084614, 0.196380615234375, 0.141102354084614, 0.0508734476851974, 0.00836238678235908, 0.000510797335388569, 7.53574526552611e-06, 9.33770887654223e-09, 2.07029450319505e-14, 1.11151877927386e-16, 2.68750136889603e-10, 5.50143657301987e-07, 7.25612727468457e-05, 0.00202999373853982, 0.0196513717836417, 0.0834084049137455, 0.174560546875, 0.188605198058134, 0.10406014443622, 0.0272182850889764, 0.00284110516373773, 8.15588819393488e-05, 2.56346221517259e-07, 3.0467892080193e-12, 4.69950420523668e-19, 6.09126678327427e-12, 3.16283527364133e-08, 8.11730235471282e-06, 0.000388069676162698, 0.00597785168999623, 0.0388271876725086, 0.1221923828125, 0.198528846383797, 0.167620927916779, 0.0697656795472266, 0.0124444743910136, 0.000695131357774424, 5.54196876311549e-06, 3.53104498670319e-10, 1.54827394640177e-21, 1.07578893509681e-13, 1.41689465572265e-09, 7.07585751979458e-07, 5.78076404859554e-05, 0.00141696109171796, 0.0140838885305542, 0.066650390625, 0.162837379670442, 0.210393627631096, 0.139342444188758, 0.0424743099960754, 0.00461660823687696, 9.33601953899354e-05, 3.1887804437276e-08, 3.89649175869874e-24, 1.45136524217027e-15, 4.8487382910856e-11, 4.71168913138752e-08, 6.57795611022155e-06, 0.000256567065710009, 0.00390246859143055, 0.02777099609375, 0.102026921930355, 0.201728433580686, 0.212596060507654, 0.110740453969854, 0.0234212115609875, 0.00120140552098745, 2.19976444497807e-06, 7.24148439296963e-27, 1.44595322455199e-17, 1.22531515846267e-12, 2.31687209559264e-09, 5.52744691442821e-07, 3.43061332551344e-05, 0.000798516940998569, 0.008544921875, 0.0472066676717785, 0.142833320126171, 0.239527224282417, 0.213213229012281, 0.0877452413155152, 0.0114168258261819, 0.000112061290438859, 9.37255539717985e-30, 1.00324810942157e-19, 2.15647013826661e-14, 7.93421690745907e-11, 3.23470566561128e-08, 3.19462005068058e-06, 0.000113790349780199, 0.0018310546875, 0.0152113754091861, 0.070431757656062, 0.187945153423663, 0.285889743677224, 0.228936146487582, 0.0755575222560317, 0.00397568200748679, 7.5480357874253e-33, 4.33119735750088e-22, 2.36148183144371e-16, 1.69064177855435e-12, 1.1778513272782e-09, 1.85102452791893e-07, 1.00895604803858e-05, 0.000244140625, 0.00304985465026234, 0.0216099140359202, 0.0917598928412673, 0.238522043112206, 0.371664158323827, 0.311139792324178, 0.0877633473129071, 2.84938521135915e-36, 8.76493859052028e-25, 1.21217981875839e-18, 1.6886529591926e-14, 2.01042308682826e-11, 5.02743442774725e-09, 4.19353569761197e-07, 1.52587890625e-05, 0.000286636228362617, 0.00310798441761014, 0.0209998380366774, 0.0932824076665524, 0.282831824851593, 0.600585285949586, 0.908146677380746, 

0.918495753722746, 0.637845242312638, 0.328649378791009, 0.12403807684013, 0.0336236488106611, 0.00636385702049388, 0.000808312511646715, 6.5196662071817e-05, 3.08888175727219e-06, 7.67974682366851e-08, 8.45850387660093e-10, 3.15344069866842e-12, 2.50436760186354e-15, 1.72303843169785e-19, 1.21006417993496e-25, 3.87080205760852e-37, 0.0782965044993638, 0.29088151328534, 0.378726271795737, 0.276532670391549, 0.127064304255586, 0.0378498111939485, 0.00724952845674774, 0.000862122221183915, 5.97995300910158e-05, 2.19208005473313e-06, 3.6407446009576e-08, 2.13621968057237e-10, 2.87572013797094e-13, 3.82773896108489e-17, 6.79278032711129e-23, 1.1624538166727e-33, 0.00312859160206991, 0.0621810715874956, 0.204578189275294, 0.288987562360245, 0.225083451125322, 0.105523284867085, 0.0304776514079898, 0.00534384186130064, 0.000542669657679411, 2.93296715008728e-05, 7.34561489987044e-07, 6.78341575876503e-09, 1.54787697933538e-11, 3.98594169589536e-15, 1.787425772695e-20, 1.63640852373638e-30, 7.77859023929035e-05, 0.00827076727815593, 0.0687604555955424, 0.18791323685863, 0.24808990088116, 0.183053654748052, 0.0797257757135172, 0.0206102791417428, 0.00306421211511743, 0.000244176297786893, 9.22171330193265e-06, 1.34028290327032e-07, 5.18408103321321e-10, 2.58264722744995e-13, 2.9265367278256e-18, 1.4333533830323e-27, 1.34688182784371e-06, 0.000766143250009676, 0.0160951393404499, 0.0850965935074265, 0.190436936187189, 0.221149054210135, 0.145242123420061, 0.0553593178429448, 0.0120497681623255, 0.00141571681548205, 8.06253579737056e-05, 1.84425555182206e-06, 1.20915980426109e-08, 1.16540215051592e-11, 3.33700242325861e-16, 8.74362249304761e-25, 1.72220947129782e-08, 5.24085373314418e-05, 0.00278213767155076, 0.0284573763677779, 0.107949632135931, 0.197296621858837, 0.195395386997128, 0.109805847136959, 0.0349918124309696, 0.00606145879341515, 0.000520546554731263, 1.87401732691726e-05, 2.08268458465393e-07, 3.88342053328397e-10, 2.80987464815115e-14, 3.938740803838e-22, 1.68218070119636e-10, 2.73857280869788e-06, 0.000367360693227449, 0.00726955343721442, 0.0467435121493711, 0.134457305935621, 0.200801159532067, 0.16637589194057, 0.0776219193586541, 0.0198247681417563, 0.0025673063204677, 0.000145464258522154, 2.74027088562768e-06, 9.88514907280239e-09, 1.8073720543535e-12, 1.35535667451789e-19, 1.2803238756931e-12, 1.1150826782448e-07, 3.77978659262241e-05, 0.0014470419917463, 0.0157718282789594, 0.0714018865070075, 0.160797262727768, 0.19643363434287, 0.134172293081067, 0.0505242181516317, 0.00986634571044766, 0.00087983152363348, 2.80946752051694e-05, 1.96070632023887e-07, 9.0587589855026e-11, 3.63421252374473e-17, 7.67392596457916e-15, 3.57552986397078e-09, 3.06261522325593e-06, 0.000226832404957199, 0.0041907649363626, 0.0298597061871112, 0.10140086248398, 0.182638305632697, 0.182638305632697, 0.10140086248398, 0.0298597061871112, 0.0041907649363626, 0.000226832404957198, 3.06261522325595e-06, 3.57552986397078e-09, 7.67392596457852e-15, 3.63421252374507e-17, 9.05875898550261e-11, 1.96070632023885e-07, 2.80946752051695e-05, 0.00087983152363348, 0.00986634571044765, 0.0505242181516318, 0.134172293081067, 0.19643363434287, 0.160797262727767, 0.0714018865070075, 0.0157718282789594, 0.0014470419917463, 3.77978659262243e-05, 1.1150826782448e-07, 1.28032387569301e-12, 1.35535667451803e-19, 1.8073720543535e-12, 9.88514907280231e-09, 2.74027088562769e-06, 0.000145464258522154, 0.0025673063204677, 0.0198247681417564, 0.0776219193586541, 0.166375891940569, 0.200801159532067, 0.134457305935621, 0.0467435121493711, 0.0072695534372144, 0.000367360693227451, 2.73857280869788e-06, 1.68218070119626e-10, 3.93874080383845e-22, 2.80987464815115e-14, 3.88342053328393e-10, 2.08268458465394e-07, 1.87401732691726e-05, 0.000520546554731263, 0.00606145879341516, 0.0349918124309695, 0.109805847136959, 0.195395386997127, 0.197296621858837, 0.107949632135931, 0.0284573763677778, 0.00278213767155077, 5.24085373314418e-05, 1.72220947129773e-08, 8.74362249304871e-25, 3.33700242325861e-16, 1.16540215051591e-11, 1.2091598042611e-08, 1.84425555182206e-06, 8.06253579737056e-05, 0.00141571681548205, 0.0120497681623255, 0.0553593178429447, 0.145242123420061, 0.221149054210135, 0.190436936187189, 0.0850965935074264, 0.0160951393404499, 0.000766143250009676, 1.34688182784365e-06, 1.43335338303249e-27, 2.92653672782559e-18, 2.58264722744992e-13, 5.18408103321324e-10, 1.34028290327032e-07, 9.22171330193265e-06, 0.000244176297786893, 0.00306421211511743, 0.0206102791417428, 0.0797257757135171, 0.183053654748052, 0.24808990088116, 0.18791323685863, 0.0687604555955426, 0.00827076727815593, 7.7785902392901e-05, 1.63640852373662e-30, 1.787425772695e-20, 3.98594169589532e-15, 1.54787697933539e-11, 6.78341575876503e-09, 7.34561489987044e-07, 2.93296715008729e-05, 0.00054266965767941, 0.00534384186130062, 0.0304776514079898, 0.105523284867085, 0.225083451125322, 0.288987562360244, 0.204578189275294, 0.0621810715874956, 0.00312859160206985, 1.16245381667289e-33, 6.79278032711129e-23, 3.82773896108484e-17, 2.87572013797096e-13, 2.13621968057237e-10, 3.6407446009576e-08, 2.19208005473313e-06, 5.97995300910157e-05, 0.000862122221183913, 0.00724952845674774, 0.0378498111939485, 0.127064304255586, 0.276532670391549, 0.378726271795737, 0.29088151328534, 0.078296504499363, 3.87080205760916e-37, 1.21006417993496e-25, 1.72303843169783e-19, 2.50436760186356e-15, 3.15344069866842e-12, 8.45850387660093e-10, 7.67974682366853e-08, 3.08888175727219e-06, 6.51966620718168e-05, 0.000808312511646715, 0.00636385702049388, 0.0336236488106611, 0.12403807684013, 0.328649378791009, 0.637845242312638, 0.918495753722746, 

0.927210742687717, 0.670626355150675, 0.372331296866457, 0.157089775168795, 0.0496014273053605, 0.0114688932629969, 0.00188450632718153, 0.000211203051617704, 1.52587890625e-05, 6.56712003211304e-07, 1.50298044669401e-08, 1.54311249436169e-10, 5.42770081655608e-13, 4.11431714704847e-16, 2.73248488944918e-20, 1.87292362148032e-26, 5.91114170285222e-38, 0.07023914956507, 0.271317661491349, 0.37944714526995, 0.308249418688218, 0.163892569560446, 0.0591148032376066, 0.0144769580433245, 0.00235565857286347, 0.000244140625, 1.50731063753278e-05, 5.00856806488529e-07, 7.66412916810545e-09, 4.20523988986702e-11, 5.36764002795126e-14, 6.86397965411491e-18, 1.18512070065879e-23, 1.99760927535039e-34, 0.00249414280133913, 0.0514537218208548, 0.181265151071336, 0.283529267001325, 0.253843259436646, 0.142827642087196, 0.0521312708578905, 0.0123158894132072, 0.0018310546875, 0.000162170499604673, 7.82375262550238e-06, 1.78430595185142e-07, 1.52723873638636e-09, 3.28254191855234e-12, 8.08230968072267e-16, 3.51517039411794e-21, 3.16439727633363e-31, 5.51072708519591e-05, 0.00607157048069568, 0.0538794138478079, 0.162270300926761, 0.244634398816335, 0.214720644634253, 0.116805912475258, 0.0400649619317964, 0.008544921875, 0.00108564156590568, 7.60435105895017e-05, 2.58476670210991e-06, 3.45118789003644e-08, 1.24905826167518e-10, 5.92161957824887e-14, 6.48747499818763e-19, 3.11901149804758e-28, 8.47955519926428e-07, 0.000498955561113502, 0.0111534182263626, 0.0646780276999214, 0.164189731790226, 0.224808080837052, 0.182266947602208, 0.0907695679437284, 0.02777099609375, 0.00506148146630023, 0.000514737472730379, 2.60765394320757e-05, 5.43133833132423e-07, 3.3100281847677e-09, 3.0214965346131e-12, 8.33837826071012e-17, 2.14101411028056e-25, 9.63529732453155e-09, 3.02796307488549e-05, 0.00170498669126639, 0.0190371694328724, 0.081377125116415, 0.17381126269328, 0.210028821479341, 0.151860100441726, 0.066650390625, 0.0174259602805857, 0.00257298523748727, 0.000194270314570255, 6.31208721101008e-06, 6.47751709817206e-08, 1.13849618081934e-10, 7.91435211774436e-15, 1.08530040227817e-22, 8.36348654576882e-11, 1.40368440587198e-06, 0.000199096759835134, 0.00428033909095613, 0.0308098004719252, 0.102653581035784, 0.184875798761805, 0.194078438979089, 0.1221923828125, 0.0458295910296289, 0.00982469317068129, 0.00110558750902444, 5.60362826876778e-05, 9.6831272097993e-07, 3.27696081869104e-09, 5.73824831347938e-13, 4.20252776632761e-20, 5.65679095500828e-13, 5.070477977523e-08, 1.81162337786411e-05, 0.000749919248380398, 0.00908941544000033, 0.0472422767005098, 0.126806570321089, 0.193273104740773, 0.174560546875, 0.0939194993594439, 0.0292321812553761, 0.0049027565499968, 0.000387637844145617, 1.12793281514244e-05, 7.34973100651189e-08, 3.24193148378449e-11, 1.26803646944906e-17, 3.01303002523764e-15, 1.44237733319781e-09, 1.29814200488693e-06, 0.000103466888457561, 0.00211170663305682, 0.017121353582563, 0.0684942338458014, 0.151571000905351, 0.196380615234375, 0.151571000905351, 0.0684942338458014, 0.0171213535825629, 0.00211170663305682, 0.00010346688845756, 1.29814200488693e-06, 1.44237733319779e-09, 3.01303002523792e-15, 1.26803646944893e-17, 3.24193148378456e-11, 7.34973100651189e-08, 1.12793281514244e-05, 0.000387637844145618, 0.00490275654999681, 0.0292321812553761, 0.0939194993594439, 0.174560546875, 0.193273104740773, 0.126806570321089, 0.0472422767005098, 0.00908941544000031, 0.000749919248380396, 1.81162337786411e-05, 5.07047797752292e-08, 5.65679095500874e-13, 4.20252776632711e-20, 5.73824831347951e-13, 3.27696081869104e-09, 9.68312720979935e-07, 5.60362826876779e-05, 0.00110558750902445, 0.00982469317068129, 0.0458295910296289, 0.1221923828125, 0.194078438979089, 0.184875798761805, 0.102653581035783, 0.0308098004719251, 0.00428033909095611, 0.000199096759835134, 1.40368440587196e-06, 8.36348654576941e-11, 1.08530040227803e-22, 7.91435211774456e-15, 1.13849618081934e-10, 6.47751709817209e-08, 6.3120872110101e-06, 0.000194270314570255, 0.00257298523748727, 0.0174259602805857, 0.066650390625, 0.151860100441726, 0.210028821479341, 0.17381126269328, 0.0813771251164149, 0.0190371694328723, 0.00170498669126639, 3.02796307488546e-05, 9.63529732453211e-09, 2.14101411028026e-25, 8.33837826071034e-17, 3.0214965346131e-12, 3.31002818476772e-09, 5.43133833132425e-07, 2.60765394320758e-05, 0.000514737472730379, 0.00506148146630023, 0.02777099609375, 0.0907695679437284, 0.182266947602208, 0.224808080837051, 0.164189731790226, 0.0646780276999213, 0.0111534182263626, 0.000498955561113498, 8.47955519926468e-07, 3.1190114980471e-28, 6.48747499818782e-19, 5.92161957824887e-14, 1.24905826167519e-10, 3.45118789003645e-08, 2.58476670210992e-06, 7.60435105895017e-05, 0.00108564156590568, 0.008544921875, 0.0400649619317964, 0.116805912475258, 0.214720644634252, 0.244634398816334, 0.162270300926761, 0.0538794138478079, 0.00607157048069564, 5.5107270851961e-05, 3.16439727633311e-31, 3.51517039411805e-21, 8.08230968072267e-16, 3.28254191855237e-12, 1.52723873638637e-09, 1.78430595185143e-07, 7.82375262550238e-06, 0.000162170499604673, 0.0018310546875, 0.0123158894132072, 0.0521312708578905, 0.142827642087196, 0.253843259436646, 0.283529267001324, 0.181265151071336, 0.0514537218208546, 0.00249414280133919, 1.99760927535004e-34, 1.18512070065883e-23, 6.86397965411491e-18, 5.3676400279513e-14, 4.20523988986704e-11, 7.66412916810548e-09, 5.00856806488529e-07, 1.50731063753278e-05, 0.000244140625, 0.00235565857286347, 0.0144769580433245, 0.0591148032376066, 0.163892569560446, 0.308249418688218, 0.37944714526995, 0.271317661491348, 0.0702391495650709, 5.9111417028511e-38, 1.87292362148038e-26, 2.73248488944918e-20, 4.1143171470485e-16, 5.42770081655611e-13, 1.54311249436169e-10, 1.50298044669401e-08, 6.56712003211304e-07, 1.52587890625e-05, 0.000211203051617704, 0.00188450632718153, 0.0114688932629969, 0.0496014273053605, 0.157089775168795, 0.372331296866457, 0.670626355150675, 0.927210742687717, 

0.934614301334455, 0.699513704460112, 0.41349522357963, 0.191499682451008, 0.0686499834790696, 0.0187280594958175, 0.00379883585759916, 0.000555338579564985, 5.60989635221588e-05, 3.69799198017862e-06, 1.46893468775079e-07, 3.1368757953072e-09, 3.0365546895791e-11, 1.01715817220671e-13, 7.41428576696425e-17, 4.78001201812838e-21, 3.21003841954288e-27, 1.0017116263953e-38, 0.063333617985664, 0.252797826229707, 0.375426898473198, 0.333450881411405, 0.200185295379457, 0.0845728144487967, 0.0253263984988457, 0.00530983001172322, 0.00075729138360549, 7.0129017117133e-05, 3.93296135467727e-06, 1.2045210141755e-07, 1.72140503758827e-09, 8.92969698189816e-12, 1.09004762912912e-14, 1.34776466317143e-18, 2.2739090377066e-24, 3.78425857631906e-35, 0.00201176595727118, 0.0428244430776033, 0.159779682818613, 0.272167937396146, 0.273630932243633, 0.179023509784909, 0.0791475770020145, 0.0237982307586252, 0.00479195216762387, 0.000623405773513735, 4.93603411190551e-05, 2.16806710362241e-06, 4.57431757528252e-08, 3.67473674298645e-10, 7.51212678585149e-13, 1.78131376200445e-16, 7.55052632355849e-22, 6.70131717946563e-32, 3.97618084730776e-05, 0.00451393841854154, 0.0423119695396452, 0.138225309781564, 0.232725367352019, 0.235795150383727, 0.153903086515404, 0.0663673141564479, 0.0188671998965904, 0.00344817584754997, 0.000385462508378915, 2.42815595012007e-05, 7.5633652360053e-07, 9.40938544508291e-09, 3.22126060363111e-11, 1.46491456972443e-14, 1.56000820211345e-19, 7.38388733783218e-29, 5.47307479549094e-07, 0.000331356974420718, 0.00780335757325903, 0.0488894061297633, 0.137847482480228, 0.216289905108006, 0.208417227960712, 0.128896282914875, 0.0517343512322887, 0.0132826451672719, 0.00209634479316977, 0.000189389986247797, 8.70924310925195e-06, 1.67792624401773e-07, 9.61978560799281e-10, 8.38997667983509e-13, 2.24467318021012e-17, 5.66612993372663e-26, 5.56319801349605e-09, 1.79624049476475e-05, 0.00106274153763295, 0.0127693806253337, 0.0602950742283115, 0.146509407575828, 0.208424026486908, 0.184864885118489, 0.104755888428733, 0.0377839725703551, 0.00841920657844905, 0.0010908507374654, 7.40582823024605e-05, 2.20959335427842e-06, 2.12145002721209e-08, 3.54843692370306e-11, 2.3851035240433e-15, 3.21081939620737e-23, 4.3196429063095e-11, 7.43811764223588e-07, 0.000110561518776446, 0.00254773994438881, 0.0201462872723551, 0.0758097330680741, 0.15921799149886, 0.202534331149484, 0.162034716900063, 0.0821033460151241, 0.0258291319218334, 0.00479958668333836, 0.000481057565609438, 2.22270607408414e-05, 3.57380137716192e-07, 1.14641964306136e-09, 1.93593844183266e-13, 1.38987396345678e-20, 2.61355533499669e-13, 2.40006016119405e-08, 8.96274130996574e-06, 0.000396096390712235, 0.00524528071867298, 0.0305664461545889, 0.0947757054501766, 0.172903346958469, 0.195298195318617, 0.139019147537431, 0.0617460215753954, 0.016455189006637, 0.00243489920986742, 0.000174225709921648, 4.69124962725842e-06, 2.88609533643102e-08, 1.22443681351467e-11, 4.68808509464241e-18, 1.24527742554854e-15, 6.09862283759226e-10, 5.72174224668871e-07, 4.84950304587137e-05, 0.0010754569037222, 0.00970544584789525, 0.0444275611002093, 0.116240832779152, 0.185369785788612, 0.185369785788612, 0.116240832779152, 0.0444275611002093, 0.00970544584789525, 0.0010754569037222, 4.84950304587139e-05, 5.72174224668871e-07, 6.09862283759226e-10, 1.24527742554854e-15, 4.68808509464241e-18, 1.22443681351467e-11, 2.88609533643102e-08, 4.69124962725839e-06, 0.000174225709921648, 0.00243489920986742, 0.016455189006637, 0.0617460215753954, 0.139019147537431, 0.195298195318617, 0.172903346958469, 0.0947757054501766, 0.0305664461545889, 0.00524528071867298, 0.000396096390712237, 8.96274130996574e-06, 2.40006016119405e-08, 2.61355533499669e-13, 1.38987396345678e-20, 1.93593844183266e-13, 1.14641964306136e-09, 3.5738013771619e-07, 2.22270607408414e-05, 0.000481057565609438, 0.00479958668333836, 0.0258291319218334, 0.0821033460151241, 0.162034716900063, 0.202534331149484, 0.15921799149886, 0.0758097330680741, 0.0201462872723551, 0.00254773994438882, 0.000110561518776446, 7.43811764223588e-07, 4.3196429063095e-11, 3.21081939620737e-23, 2.3851035240433e-15, 3.54843692370306e-11, 2.12145002721208e-08, 2.20959335427842e-06, 7.40582823024605e-05, 0.0010908507374654, 0.00841920657844905, 0.0377839725703551, 0.104755888428733, 0.184864885118489, 0.208424026486908, 0.146509407575828, 0.0602950742283115, 0.0127693806253338, 0.00106274153763295, 1.79624049476475e-05, 5.56319801349605e-09, 5.66612993372663e-26, 2.24467318021012e-17, 8.38997667983509e-13, 9.61978560799275e-10, 1.67792624401773e-07, 8.70924310925195e-06, 0.000189389986247797, 0.00209634479316977, 0.0132826451672719, 0.0517343512322887, 0.128896282914875, 0.208417227960713, 0.216289905108006, 0.137847482480228, 0.0488894061297634, 0.00780335757325903, 0.000331356974420718, 5.47307479549094e-07, 7.38388733783218e-29, 1.56000820211345e-19, 1.46491456972443e-14, 3.22126060363109e-11, 9.40938544508291e-09, 7.5633652360053e-07, 2.42815595012007e-05, 0.000385462508378915, 0.00344817584754997, 0.0188671998965904, 0.0663673141564479, 0.153903086515404, 0.235795150383727, 0.232725367352019, 0.138225309781565, 0.0423119695396452, 0.00451393841854154, 3.97618084730776e-05, 6.70131717946563e-32, 7.55052632355849e-22, 1.78131376200445e-16, 7.51212678585143e-13, 3.67473674298645e-10, 4.57431757528252e-08, 2.16806710362241e-06, 4.93603411190551e-05, 0.000623405773513735, 0.00479195216762387, 0.0237982307586252, 0.0791475770020145, 0.179023509784909, 0.273630932243633, 0.272167937396146, 0.159779682818613, 0.0428244430776033, 0.00201176595727118, 3.78425857631906e-35, 2.2739090377066e-24, 1.34776466317143e-18, 1.09004762912911e-14, 8.92969698189816e-12, 1.72140503758827e-09, 1.2045210141755e-07, 3.93296135467727e-06, 7.0129017117133e-05, 0.00075729138360549, 0.00530983001172322, 0.0253263984988457, 0.0845728144487967, 0.200185295379457, 0.333450881411406, 0.375426898473198, 0.252797826229707, 0.063333617985664, 1.0017116263953e-38, 3.21003841954288e-27, 4.78001201812838e-21, 7.41428576696418e-17, 1.01715817220671e-13, 3.0365546895791e-11, 3.1368757953072e-09, 1.46893468775079e-07, 3.69799198017862e-06, 5.60989635221588e-05, 0.000555338579564985, 0.00379883585759916, 0.0187280594958175, 0.0686499834790696, 0.191499682451008, 0.41349522357963, 0.699513704460112, 0.934614301334455, 

0.940954160687561, 0.725028578560002, 0.451970337289636, 0.226474360377207, 0.0903394476408069, 0.0283013802499101, 0.00683731720881851, 0.00124334658760721, 0.000164814701684538, 1.52587890625e-05, 9.31153322346743e-07, 3.45688297347333e-08, 6.96231491162907e-10, 6.41210396746884e-12, 2.06077060273875e-14, 1.45306619336275e-17, 9.13462009198251e-22, 6.02872937925183e-28, 1.8632767807848e-39, 0.0573763287369306, 0.235487047552902, 0.367983800587927, 0.352446475336154, 0.234359157032781, 0.113012675791981, 0.039994240831611, 0.010326852378028, 0.00190817195853379, 0.000244140625, 2.05892061393383e-05, 1.06548877995044e-06, 3.04706626993722e-08, 4.11074918598922e-10, 2.03359806216518e-12, 2.39029351965877e-15, 2.87218022437887e-19, 4.75175297865699e-25, 7.82263466424008e-36, 0.0016399791480624, 0.0358525627504326, 0.140439329949143, 0.257103851423535, 0.284988742041727, 0.21153779830398, 0.10966056185983, 0.0402054578070786, 0.0103557212265868, 0.0018310546875, 0.000213402394009643, 1.5394102173907e-05, 6.25102761117108e-07, 1.23532913464149e-08, 9.406799101964e-11, 1.84314010958579e-13, 4.23325242913988e-17, 1.75559042091773e-22, 1.53946565705261e-32, 2.91668423113052e-05, 0.0033964005461752, 0.0333498829882953, 0.116699638491554, 0.215634873824276, 0.246373685141605, 0.187089318732026, 0.097397446735078, 0.0349694425949732, 0.008544921875, 0.00137627268374806, 0.000138390209338644, 7.97933047397891e-06, 2.30988259488991e-07, 2.70747301188682e-09, 8.84323128775033e-12, 3.88223805539714e-15, 4.03587834805977e-20, 1.88509169174001e-29, 3.61257673886627e-07, 0.00022407539956664, 0.00551539295774988, 0.0368898610145788, 0.113628395368943, 0.199837615602433, 0.222292136722547, 0.164318594845121, 0.0822382099869739, 0.02777099609375, 0.00618139181916603, 0.00086642893579931, 7.09345907402787e-05, 3.00797144215028e-06, 5.42703951219017e-08, 2.95488237406376e-10, 2.47951499244589e-13, 6.46144290999406e-18, 1.60757607366551e-26, 3.30424795196912e-09, 1.09168498663845e-05, 0.000673575817331153, 0.00861137313860193, 0.0442163235149517, 0.119698315755424, 0.195041526805026, 0.204716917492353, 0.142819158072607, 0.066650390625, 0.0205019861936501, 0.0040057921405031, 0.000465669252741248, 2.89258008448492e-05, 8.03322093731572e-07, 7.29117113419275e-09, 1.1694433685761e-11, 7.63921682228418e-16, 1.01236813947433e-23, 2.30865145439374e-11, 4.06284906898512e-07, 6.28386297532521e-05, 0.0015355642411328, 0.0131434257983981, 0.0547682712933988, 0.130725487068886, 0.194827809547614, 0.189465212529308, 0.1221923828125, 0.0519440482732689, 0.01414731636672, 0.00233521704598744, 0.000212484506139259, 9.08336221022075e-06, 1.37430959726965e-07, 4.21329478222466e-10, 6.89919396550637e-14, 4.87007441269081e-21, 1.25691131938633e-13, 1.17821504878837e-08, 4.56801426137797e-06, 0.000213365450673218, 0.00304435330052012, 0.0195267763341046, 0.0682737841072616, 0.144480317445741, 0.195854258693314, 0.174560546875, 0.10255012059694, 0.0389332130244094, 0.00912509650695873, 0.0012162690880609, 8.00320753284001e-05, 2.01851690986987e-06, 1.18283732569921e-08, 4.85521424250695e-12, 1.82554797466698e-18, 5.38891664942933e-16, 2.69072308280773e-10, 2.61504254144238e-07, 2.33469830035106e-05, 0.000555305643972204, 0.00548255040163892, 0.028080073667437, 0.0843756223248247, 0.159436267915776, 0.196380615234375, 0.159436267915776, 0.0843756223248248, 0.028080073667437, 0.0054825504016389, 0.000555305643972206, 2.33469830035106e-05, 2.61504254144238e-07, 2.69072308280773e-10, 5.38891664942933e-16, 1.82554797466698e-18, 4.85521424250695e-12, 1.18283732569921e-08, 2.01851690986987e-06, 8.00320753283998e-05, 0.0012162690880609, 0.00912509650695873, 0.0389332130244093, 0.10255012059694, 0.174560546875, 0.195854258693314, 0.144480317445741, 0.0682737841072616, 0.0195267763341046, 0.00304435330052013, 0.000213365450673218, 4.56801426137797e-06, 1.17821504878837e-08, 1.25691131938633e-13, 4.87007441269081e-21, 6.89919396550637e-14, 4.21329478222466e-10, 1.37430959726965e-07, 9.08336221022071e-06, 0.00021248450613926, 0.00233521704598744, 0.01414731636672, 0.0519440482732689, 0.1221923828125, 0.189465212529308, 0.194827809547614, 0.130725487068886, 0.0547682712933987, 0.0131434257983982, 0.0015355642411328, 6.28386297532521e-05, 4.06284906898512e-07, 2.30865145439374e-11, 1.01236813947433e-23, 7.63921682228418e-16, 1.1694433685761e-11, 7.29117113419275e-09, 8.03322093731568e-07, 2.89258008448493e-05, 0.000465669252741248, 0.00400579214050309, 0.0205019861936501, 0.066650390625, 0.142819158072607, 0.204716917492354, 0.195041526805026, 0.119698315755424, 0.0442163235149518, 0.00861137313860193, 0.000673575817331153, 1.09168498663845e-05, 3.30424795196912e-09, 1.60757607366551e-26, 6.46144290999406e-18, 2.47951499244589e-13, 2.95488237406376e-10, 5.42703951219015e-08, 3.00797144215029e-06, 7.09345907402787e-05, 0.000866428935799309, 0.00618139181916603, 0.02777099609375, 0.0822382099869739, 0.164318594845121, 0.222292136722547, 0.199837615602433, 0.113628395368943, 0.0368898610145788, 0.00551539295774988, 0.00022407539956664, 3.61257673886627e-07, 1.88509169174001e-29, 4.03587834805977e-20, 3.88223805539714e-15, 8.84323128775033e-12, 2.70747301188681e-09, 2.30988259488992e-07, 7.97933047397891e-06, 0.000138390209338643, 0.00137627268374806, 0.008544921875, 0.0349694425949732, 0.097397446735078, 0.187089318732026, 0.246373685141605, 0.215634873824276, 0.116699638491554, 0.0333498829882953, 0.0033964005461752, 2.91668423113052e-05, 1.53946565705261e-32, 1.75559042091773e-22, 4.23325242913988e-17, 1.84314010958579e-13, 9.40679910196395e-11, 1.23532913464149e-08, 6.25102761117108e-07, 1.5394102173907e-05, 0.000213402394009643, 0.0018310546875, 0.0103557212265868, 0.0402054578070786, 0.10966056185983, 0.21153779830398, 0.284988742041728, 0.257103851423535, 0.140439329949143, 0.0358525627504326, 0.0016399791480624, 7.82263466424008e-36, 4.75175297865699e-25, 2.87218022437887e-19, 2.39029351965877e-15, 2.03359806216517e-12, 4.11074918598924e-10, 3.04706626993722e-08, 1.06548877995044e-06, 2.05892061393383e-05, 0.000244140625, 0.00190817195853379, 0.010326852378028, 0.039994240831611, 0.113012675791981, 0.234359157032781, 0.352446475336154, 0.367983800587927, 0.235487047552902, 0.0573763287369306, 1.8632767807848e-39, 6.02872937925183e-28, 9.13462009198251e-22, 1.45306619336275e-17, 2.06077060273874e-14, 6.41210396746887e-12, 6.96231491162907e-10, 3.45688297347333e-08, 9.31153322346743e-07, 1.52587890625e-05, 0.000164814701684538, 0.00124334658760721, 0.00683731720881851, 0.0283013802499101, 0.0903394476408069, 0.226474360377207, 0.451970337289636, 0.725028578560002, 0.940954160687561, 

0.946422818591847, 0.747626146553541, 0.487728572160834, 0.261378405540361, 0.114169129955771, 0.0402050732205766, 0.0112496716605756, 0.00245369874267374, 0.000406894723818858, 4.96496058769678e-05, 4.26885014407162e-06, 2.43963100770707e-07, 8.55009820154111e-09, 1.63814170323321e-10, 1.44583047413848e-12, 4.4851150572262e-15, 3.07385786794948e-18, 1.89106759002151e-22, 1.22963597424147e-28, 3.76916007660222e-40, 0.0522053662133039, 0.219437182805739, 0.358163424830747, 0.36583947646961, 0.265343058142375, 0.143100325737498, 0.0582720847757079, 0.0178988689972275, 0.00409465364060444, 0.000681452331935532, 7.9621654546759e-05, 6.20624615634926e-06, 3.00059042489649e-07, 8.09600416673837e-09, 1.03991435820218e-10, 4.94031356913938e-13, 5.62215591085786e-16, 6.59240652978535e-20, 1.07248391677675e-25, 1.74926096053939e-36, 0.00134985267415953, 0.0301909818703945, 0.123289346596273, 0.240022917396691, 0.28907334615494, 0.238749058722229, 0.141488957129159, 0.0612027898321752, 0.01931494897711, 0.00438426139509961, 0.000696133874477838, 7.40073970808473e-05, 4.9360962107636e-06, 1.87556128782458e-07, 3.50605767240612e-09, 2.55080184503501e-11, 4.82018013537613e-14, 1.07726410938651e-17, 4.38476473871034e-23, 3.8054489999255e-33, 2.17171641218054e-05, 0.00258457877355285, 0.0264067762274181, 0.0979851746323271, 0.195953888791061, 0.247849605111429, 0.213761777802431, 0.130215405164558, 0.0566911773716504, 0.0175510423590296, 0.00378703966924426, 0.000549119391341681, 5.05249660787562e-05, 2.70356810908101e-06, 7.3550571960923e-08, 8.19491488744549e-10, 2.5713972178968e-12, 1.09533236026472e-15, 1.11544284641243e-20, 5.1511325537655e-30, 2.43330436752194e-07, 0.000154091573218359, 0.00393896207653449, 0.0278576586057025, 0.0925073635339703, 0.179189011872345, 0.224912783260811, 0.192943474051577, 0.1158814625805, 0.0489312115746786, 0.0143477407688772, 0.00283749438661426, 0.000360167917846351, 2.71406315755474e-05, 1.07455743391872e-06, 1.83353309048998e-08, 9.55326117021495e-11, 7.75615047656747e-14, 1.97617285127649e-18, 4.85597145835346e-27, 2.01334239495495e-09, 6.78415693666204e-06, 0.000433886456977386, 0.00584866482308095, 0.0322497685017411, 0.0956670536085092, 0.17475359062138, 0.211118213445957, 0.174920350962224, 0.100738830579914, 0.0401416360543537, 0.0108275730479044, 0.00189597191781354, 0.000201201153010626, 1.15931403186547e-05, 3.02943011188292e-07, 2.62096977463317e-09, 4.05578023632192e-12, 2.58541590051352e-16, 3.38047248921118e-24, 1.27253294451546e-11, 2.28161874146508e-07, 3.65090542324308e-05, 0.000937991813594839, 0.00858829774277436, 0.0390160784365831, 0.103721375816157, 0.176462124372297, 0.201695823409499, 0.158430223124904, 0.0857900280543086, 0.0315614848356958, 0.00762410675633916, 0.00113938677365762, 9.55438516322673e-05, 3.82351956306462e-06, 5.49291106581463e-08, 1.62006632963048e-10, 2.58384284431306e-14, 1.79766548247074e-21, 6.26730681137761e-14, 5.97930614848534e-09, 2.39378750651465e-06, 0.000117220046117789, 0.00178216581289454, 0.012398962827233, 0.047970136587833, 0.11493117047648, 0.181223283776153, 0.194151025058819, 0.142869352292158, 0.0716876355376998, 0.0238894726204687, 0.00502773533007612, 0.000613571138127486, 3.76033225980863e-05, 8.97023142507398e-07, 5.04256729415731e-09, 2.01215902224486e-12, 7.44904980885885e-19, 2.43076760286006e-16, 1.23398269075211e-10, 1.23600768716673e-07, 1.15360011382903e-05, 0.000291232398471078, 0.00310297061401944, 0.0174712590735691, 0.058948766033157, 0.128227639752846, 0.187366482751634, 0.187366482751634, 0.128227639752846, 0.058948766033157, 0.0174712590735691, 0.00310297061401943, 0.000291232398471078, 1.15360011382904e-05, 1.23600768716673e-07, 1.23398269075214e-10, 2.43076760286037e-16, 7.44904980885777e-19, 2.0121590222448e-12, 5.04256729415731e-09, 8.97023142507392e-07, 3.76033225980863e-05, 0.000613571138127487, 0.00502773533007612, 0.0238894726204687, 0.0716876355376998, 0.142869352292158, 0.194151025058819, 0.181223283776153, 0.11493117047648, 0.047970136587833, 0.0123989628272329, 0.00178216581289454, 0.00011722004611779, 2.39378750651465e-06, 5.97930614848547e-09, 6.26730681137831e-14, 1.79766548247045e-21, 2.58384284431298e-14, 1.62006632963048e-10, 5.49291106581459e-08, 3.82351956306462e-06, 9.55438516322676e-05, 0.00113938677365762, 0.00762410675633916, 0.0315614848356958, 0.0857900280543086, 0.158430223124904, 0.201695823409499, 0.176462124372297, 0.103721375816157, 0.039016078436583, 0.00858829774277436, 0.000937991813594843, 3.65090542324308e-05, 2.28161874146512e-07, 1.27253294451558e-11, 3.38047248921058e-24, 2.58541590051343e-16, 4.05578023632192e-12, 2.62096977463315e-09, 3.02943011188292e-07, 1.15931403186547e-05, 0.000201201153010626, 0.00189597191781354, 0.0108275730479044, 0.0401416360543537, 0.100738830579914, 0.174920350962224, 0.211118213445957, 0.17475359062138, 0.0956670536085091, 0.0322497685017411, 0.00584866482308097, 0.000433886456977386, 6.78415693666214e-06, 2.01334239495511e-09, 4.85597145835252e-27, 1.97617285127642e-18, 7.75615047656747e-14, 9.55326117021488e-11, 1.83353309048997e-08, 1.07455743391872e-06, 2.71406315755474e-05, 0.000360167917846351, 0.00283749438661426, 0.0143477407688772, 0.0489312115746786, 0.1158814625805, 0.192943474051577, 0.224912783260811, 0.179189011872344, 0.0925073635339703, 0.0278576586057026, 0.00393896207653449, 0.00015409157321836, 2.4333043675221e-07, 5.15113255376442e-30, 1.11544284641238e-20, 1.09533236026472e-15, 2.57139721789678e-12, 8.19491488744549e-10, 7.35505719609233e-08, 2.70356810908101e-06, 5.05249660787562e-05, 0.000549119391341681, 0.00378703966924426, 0.0175510423590296, 0.0566911773716504, 0.130215405164558, 0.213761777802431, 0.247849605111429, 0.195953888791061, 0.0979851746323273, 0.0264067762274181, 0.00258457877355287, 2.17171641218065e-05, 3.80544899992464e-33, 4.38476473871016e-23, 1.07726410938651e-17, 4.82018013537608e-14, 2.55080184503501e-11, 3.50605767240613e-09, 1.87556128782458e-07, 4.9360962107636e-06, 7.40073970808473e-05, 0.000696133874477838, 0.00438426139509961, 0.01931494897711, 0.0612027898321752, 0.141488957129159, 0.238749058722229, 0.28907334615494, 0.240022917396691, 0.123289346596273, 0.0301909818703946, 0.00134985267415957, 1.74926096053897e-36, 1.0724839167767e-25, 6.59240652978535e-20, 5.62215591085781e-16, 4.94031356913938e-13, 1.03991435820218e-10, 8.09600416673837e-09, 3.00059042489649e-07, 6.20624615634926e-06, 7.9621654546759e-05, 0.000681452331935532, 0.00409465364060444, 0.0178988689972275, 0.0582720847757079, 0.143100325737498, 0.265343058142375, 0.36583947646961, 0.358163424830747, 0.219437182805739, 0.0522053662133047, 3.76916007660124e-40, 1.22963597424141e-28, 1.89106759002151e-22, 3.07385786794945e-18, 4.4851150572262e-15, 1.44583047413848e-12, 1.63814170323321e-10, 8.55009820154111e-09, 2.43963100770707e-07, 4.26885014407162e-06, 4.96496058769678e-05, 0.000406894723818858, 0.00245369874267374, 0.0112496716605756, 0.0402050732205766, 0.114169129955771, 0.261378405540361, 0.487728572160834, 0.747626146553541, 0.946422818591847, 

0.951171526113385, 0.767699259844556, 0.520833873380316, 0.295725826727182, 0.139625647118079, 0.0543335689538597, 0.0172218879260235, 0.00437873987593309, 0.00087556598279396, 0.000134219856099712, 1.52587890625e-05, 1.23143114090047e-06, 6.65260786159869e-08, 2.21896948662515e-09, 4.07265697207507e-11, 3.46521969554413e-13, 1.04264825260625e-15, 6.97268208074425e-19, 4.21042994246248e-23, 2.70279722952649e-29, 8.22596098329803e-41, 0.0476910419938618, 0.204632684200257, 0.346773503140881, 0.374361475494821, 0.292521957107098, 0.173571982739957, 0.0796274959070065, 0.0283151759946626, 0.00774377637823384, 0.00160176513649202, 0.000244140625, 2.64160592157279e-05, 1.92560837907856e-06, 8.78458352212728e-08, 2.25494263390231e-09, 2.77689429340966e-11, 1.27404425422142e-13, 1.41006110617486e-16, 1.61889889513099e-20, 2.59578997766666e-26, 4.19999371158513e-37, 0.00112087210877165, 0.0255682003560635, 0.108226564013474, 0.22214386657198, 0.287271817834675, 0.25991557025959, 0.172578479735427, 0.0858283305734166, 0.0321039157319946, 0.00896029246471664, 0.0018310546875, 0.000265623935935191, 2.61267440156437e-05, 1.63016777302973e-06, 5.85240596278914e-08, 1.04310782318778e-09, 7.29747285483698e-12, 1.33664871090137e-14, 2.91779172696353e-18, 1.16860278836968e-23, 1.00519869425272e-33, 1.63915805137528e-05, 0.00198779154149908, 0.0210168368599255, 0.082020614904888, 0.175538786738064, 0.242175656938089, 0.232731804566063, 0.161877907805758, 0.0828149469532481, 0.0311882532071889, 0.008544921875, 0.00166192684653939, 0.000220570857128826, 1.88230045720605e-05, 9.45102491323921e-07, 2.43806104095659e-08, 2.60079415423712e-10, 7.88391896537922e-13, 3.27215876930204e-16, 3.27348083581285e-21, 1.49692730041354e-30, 1.66940680701907e-07, 0.000107626222039582, 0.00284234908851021, 0.0210905689145764, 0.0747015721772033, 0.157146696675245, 0.218575467049305, 0.212628306485964, 0.148777079511774, 0.0756025593231272, 0.02777099609375, 0.00724157743832729, 0.00129684344601015, 0.000151363852283475, 1.06291846545837e-05, 3.96859267881488e-07, 6.45529438564941e-09, 3.2384977498518e-11, 2.55558910228519e-14, 6.38600519162894e-19, 1.55248024356267e-27, 1.25554247503139e-09, 4.30321686986228e-06, 0.000283867294625511, 0.00400480569380735, 0.0234754687372438, 0.0753022420065575, 0.151591543121771, 0.206244539188829, 0.197374576545822, 0.135334905660372, 0.066650390625, 0.0233014171973414, 0.00563060229448909, 0.000898841834439164, 8.82772664341118e-05, 4.77041717304648e-06, 1.18318867855769e-07, 9.82365107132506e-10, 1.47392561946249e-12, 9.19976243093628e-17, 1.18899310492034e-24, 7.21324746900935e-12, 1.31431227820233e-07, 2.1656261905405e-05, 0.000580904575995423, 0.005635455129514, 0.027563905380476, 0.0803116827650726, 0.152817830433461, 0.200021456943105, 0.185060335217058, 0.1221923828125, 0.0572745499504894, 0.0186746446866543, 0.00407731791761258, 0.00056005153790643, 4.3803255179893e-05, 1.65661714372216e-06, 2.27631547024814e-08, 6.49367129269569e-11, 1.0124046957908e-14, 6.95605141063344e-22, 3.22916903854403e-14, 3.12798326945525e-09, 1.28739600326147e-06, 6.56581543663494e-05, 0.00105415444651221, 0.00786201954667529, 0.0331545397041211, 0.0882320004982004, 0.157951038839683, 0.197186595901011, 0.174560546875, 0.10969871999182, 0.0482625614016068, 0.014412071205569, 0.00276864731818934, 0.000313412949736695, 1.80738561992107e-05, 4.11010102508916e-07, 2.22928482379906e-09, 8.68144892224706e-13, 3.17107676379719e-19, 1.13841678389377e-16, 5.86247279532184e-11, 6.0268638475413e-08, 5.84417357460806e-06, 0.00015528519660006, 0.00176594856636019, 0.010778487995806, 0.0401170310967211, 0.0982243015489827, 0.165459610383126, 0.196380615234375, 0.165459610383126, 0.0982243015489827, 0.0401170310967212, 0.010778487995806, 0.00176594856636019, 0.00015528519660006, 5.84417357460806e-06, 6.02686384754123e-08, 5.862472795322e-11, 1.1384167838936e-16, 3.1710767637977e-19, 8.68144892224679e-13, 2.22928482379909e-09, 4.11010102508916e-07, 1.80738561992107e-05, 0.000313412949736695, 0.00276864731818934, 0.0144120712055689, 0.0482625614016068, 0.10969871999182, 0.174560546875, 0.197186595901011, 0.157951038839683, 0.0882320004982006, 0.0331545397041211, 0.00786201954667529, 0.00105415444651221, 6.56581543663494e-05, 1.28739600326146e-06, 3.12798326945532e-09, 3.22916903854363e-14, 6.95605141063468e-22, 1.01240469579076e-14, 6.49367129269578e-11, 2.27631547024814e-08, 1.65661714372216e-06, 4.3803255179893e-05, 0.00056005153790643, 0.00407731791761257, 0.0186746446866543, 0.0572745499504894, 0.1221923828125, 0.185060335217058, 0.200021456943105, 0.152817830433461, 0.0803116827650726, 0.027563905380476, 0.005635455129514, 0.000580904575995423, 2.16562619054048e-05, 1.31431227820236e-07, 7.21324746900859e-12, 1.18899310492057e-24, 9.19976243093594e-17, 1.47392561946252e-12, 9.82365107132506e-10, 1.18318867855769e-07, 4.77041717304648e-06, 8.82772664341118e-05, 0.000898841834439162, 0.00563060229448909, 0.0233014171973414, 0.066650390625, 0.135334905660372, 0.197374576545822, 0.206244539188829, 0.151591543121771, 0.0753022420065575, 0.0234754687372438, 0.00400480569380735, 0.000283867294625509, 4.30321686986235e-06, 1.25554247503128e-09, 1.55248024356301e-27, 6.38600519162868e-19, 2.55558910228524e-14, 3.2384977498518e-11, 6.45529438564941e-09, 3.96859267881488e-07, 1.06291846545837e-05, 0.000151363852283475, 0.00129684344601015, 0.00724157743832729, 0.02777099609375, 0.0756025593231272, 0.148777079511774, 0.212628306485964, 0.218575467049305, 0.157146696675245, 0.0747015721772033, 0.0210905689145764, 0.00284234908851019, 0.000107626222039583, 1.66940680701895e-07, 1.49692730041388e-30, 3.27348083581271e-21, 3.2721587693021e-16, 7.88391896537921e-13, 2.60079415423712e-10, 2.43806104095659e-08, 9.45102491323921e-07, 1.88230045720605e-05, 0.000220570857128826, 0.00166192684653939, 0.008544921875, 0.0311882532071889, 0.0828149469532481, 0.161877907805758, 0.232731804566063, 0.242175656938089, 0.175538786738064, 0.082020614904888, 0.0210168368599255, 0.0019877915414991, 1.6391580513752e-05, 1.00519869425297e-33, 1.16860278836963e-23, 2.91779172696359e-18, 1.33664871090137e-14, 7.29747285483698e-12, 1.04310782318778e-09, 5.85240596278914e-08, 1.63016777302973e-06, 2.61267440156437e-05, 0.000265623935935191, 0.0018310546875, 0.00896029246471664, 0.0321039157319946, 0.0858283305734167, 0.172578479735427, 0.25991557025959, 0.287271817834675, 0.22214386657198, 0.108226564013474, 0.0255682003560636, 0.00112087210877161, 4.19999371158625e-37, 2.59578997766653e-26, 1.61889889513102e-20, 1.41006110617486e-16, 1.27404425422142e-13, 2.77689429340966e-11, 2.25494263390231e-09, 8.78458352212725e-08, 1.92560837907856e-06, 2.64160592157279e-05, 0.000244140625, 0.00160176513649202, 0.00774377637823384, 0.0283151759946626, 0.0796274959070065, 0.173571982739957, 0.292521957107098, 0.374361475494821, 0.34677350314088, 0.204632684200258, 0.0476910419938609, 8.22596098330037e-41, 2.70279722952635e-29, 4.21042994246257e-23, 6.97268208074425e-19, 1.04264825260625e-15, 3.46521969554413e-13, 4.07265697207507e-11, 2.21896948662515e-09, 6.65260786159869e-08, 1.23143114090047e-06, 1.52587890625e-05, 0.000134219856099712, 0.00087556598279396, 0.00437873987593309, 0.0172218879260235, 0.0543335689538597, 0.139625647118079, 0.295725826727182, 0.520833873380316, 0.767699259844556, 0.951171526113385, 

0.955320355726391, 0.785584808539912, 0.551406173025779, 0.329160968635737, 0.166221928468476, 0.0704908925389006, 0.0248630470378984, 0.00720363657817013, 0.00168743869271958, 0.00031317573957461, 4.48711411845588e-05, 4.79948958257659e-06, 3.66730838077582e-07, 1.88717462390052e-08, 6.03079157179332e-10, 1.06644328768742e-11, 8.79000657996214e-14, 2.57570304385679e-16, 1.68619979910543e-19, 1.00184232453689e-23, 6.35965070014173e-30, 1.92360242154708e-41, 0.0437287342898956, 0.191019661388689, 0.334425658489516, 0.378766977337335, 0.315643075561486, 0.203349919167616, 0.103323306930107, 0.0416244190456524, 0.013239893483207, 0.00328619289099061, 0.000624329482091964, 8.83056089738271e-05, 8.94710339407869e-06, 6.15737445310873e-07, 2.67188581367254e-08, 6.56952219754019e-10, 7.8004233006753e-12, 3.47238448192479e-14, 3.75132958397554e-17, 4.22874379402192e-21, 6.69558047051659e-27, 1.07581452869447e-37, 0.000938266181699294, 0.0217723018096626, 0.0950755483156655, 0.20430413914753, 0.280960648705139, 0.274976942961038, 0.20127207518112, 0.112742031538963, 0.0486947633831935, 0.0161636438509718, 0.00407194453020614, 0.00076159276048464, 0.000102319583132435, 9.41716811626978e-06, 5.54884699549719e-07, 1.8970163956264e-08, 3.24480365409501e-10, 2.19432576726537e-12, 3.91203463896557e-15, 8.36690142508751e-19, 3.30433815896554e-24, 2.82033551147764e-34, 1.25265286729691e-05, 0.00154410254409956, 0.0168183584420099, 0.0685689880625403, 0.155610982608965, 0.231363088059327, 0.243957553052016, 0.19000675675741, 0.111436008069394, 0.0494687584881812, 0.016524768358688, 0.00408698310025855, 0.000728082488266099, 8.96170408039487e-05, 7.1702305957062e-06, 3.40842625546189e-07, 8.39854766673928e-09, 8.62819430423591e-11, 2.53843284608877e-13, 1.030062196706e-16, 1.01467335247814e-21, 4.60054903484211e-31, 1.16469440856452e-07, 7.62648659341136e-05, 0.00207192938407238, 0.0160270980941539, 0.0600221535080321, 0.135571513719955, 0.20593093576242, 0.223012298472401, 0.177601002300261, 0.10543852685259, 0.0467030762225658, 0.0152742345996515, 0.00360810351780561, 0.000593932998276291, 6.45267922537891e-05, 4.26494367175866e-06, 1.51389773947686e-07, 2.36273660946872e-09, 1.14711047557724e-11, 8.83158850141374e-15, 2.16992440506876e-19, 5.22630958835953e-28, 7.99689005092732e-10, 2.78163898567446e-06, 0.00018849254392908, 0.00276636786210041, 0.0170966405963927, 0.0586638685440899, 0.128368006844163, 0.193293149853223, 0.209022558547882, 0.165956982100599, 0.0974728075341552, 0.0421545009544711, 0.0132039926337678, 0.00290678018673709, 0.000428819879046392, 3.94094685292204e-05, 2.01519357712002e-06, 4.77791682381395e-08, 3.82800673924058e-10, 5.59167707612656e-13, 3.42681638208965e-17, 4.38438296055772e-25, 4.19430929084645e-12, 7.75009829872186e-08, 1.30991644688565e-05, 0.000364749881291969, 0.00371997639457937, 0.0193911312312273, 0.0611254678397284, 0.127977701478164, 0.18791917602767, 0.199536302778376, 0.155400229652203, 0.0888707081741593, 0.0369115047931228, 0.0108671865092316, 0.00217690730628275, 0.000278174969754627, 2.04911906095601e-05, 7.38060652263784e-07, 9.75821392244478e-09, 2.7044286800209e-11, 4.1339693991566e-15, 2.80964870859139e-22, 1.71419532024048e-14, 1.68257403440268e-09, 7.09338511871196e-07, 3.74749371414036e-05, 0.000630710572681237, 0.00499454715051951, 0.0226802647304815, 0.0660256482093243, 0.131646575029919, 0.186942840947339, 0.193054692548612, 0.14599361241275, 0.0804042033413901, 0.0316579344430295, 0.00861123595008708, 0.00153001625967343, 0.000162359663007377, 8.8839487704995e-06, 1.93833349582094e-07, 1.0192236874967e-09, 3.88601261292672e-13, 1.40299489430249e-19, 5.5170982784899e-17, 2.8766810778374e-11, 3.02492106596329e-08, 3.032056078161e-06, 8.42113444103691e-05, 0.0010130704594423, 0.00662711650003002, 0.02682511570179, 0.0726270815103678, 0.137926056159661, 0.188868543429963, 0.188868543429963, 0.137926056159661, 0.0726270815103678, 0.02682511570179, 0.00662711650003002, 0.0010130704594423, 8.42113444103687e-05, 3.03205607816098e-06, 3.02492106596333e-08, 2.8766810778374e-11, 5.5170982784899e-17, 1.40299489430249e-19, 3.88601261292672e-13, 1.01922368749668e-09, 1.93833349582096e-07, 8.88394877049954e-06, 0.000162359663007377, 0.00153001625967343, 0.00861123595008708, 0.0316579344430295, 0.08040420334139, 0.14599361241275, 0.193054692548612, 0.186942840947339, 0.131646575029919, 0.0660256482093243, 0.0226802647304815, 0.00499454715051951, 0.000630710572681234, 3.74749371414033e-05, 7.09338511871203e-07, 1.68257403440268e-09, 1.71419532024048e-14, 2.80964870859139e-22, 4.1339693991566e-15, 2.70442868002086e-11, 9.75821392244486e-09, 7.38060652263788e-07, 2.04911906095601e-05, 0.000278174969754627, 0.00217690730628275, 0.0108671865092316, 0.0369115047931227, 0.0888707081741593, 0.155400229652203, 0.199536302778376, 0.18791917602767, 0.127977701478164, 0.0611254678397284, 0.0193911312312273, 0.00371997639457935, 0.000364749881291967, 1.30991644688566e-05, 7.75009829872186e-08, 4.19430929084645e-12, 4.38438296055772e-25, 3.42681638208965e-17, 5.59167707612647e-13, 3.82800673924062e-10, 4.77791682381398e-08, 2.01519357712002e-06, 3.94094685292204e-05, 0.000428819879046392, 0.00290678018673709, 0.0132039926337678, 0.0421545009544711, 0.0974728075341552, 0.1659569821006, 0.209022558547882, 0.193293149853223, 0.128368006844163, 0.0586638685440899, 0.0170966405963927, 0.0027663678621004, 0.000188492543929081, 2.78163898567446e-06, 7.99689005092732e-10, 5.22630958835953e-28, 2.16992440506876e-19, 8.83158850141358e-15, 1.14711047557725e-11, 2.36273660946873e-09, 1.51389773947686e-07, 4.26494367175865e-06, 6.45267922537891e-05, 0.000593932998276291, 0.0036081035178056, 0.0152742345996515, 0.0467030762225658, 0.10543852685259, 0.177601002300261, 0.223012298472401, 0.20593093576242, 0.135571513719955, 0.060022153508032, 0.0160270980941538, 0.00207192938407239, 7.62648659341136e-05, 1.16469440856452e-07, 4.60054903484211e-31, 1.01467335247814e-21, 1.03006219670597e-16, 2.5384328460888e-13, 8.62819430423597e-11, 8.39854766673928e-09, 3.40842625546189e-07, 7.1702305957062e-06, 8.96170408039487e-05, 0.000728082488266098, 0.00408698310025855, 0.016524768358688, 0.0494687584881812, 0.111436008069394, 0.19000675675741, 0.243957553052016, 0.231363088059327, 0.155610982608965, 0.0685689880625401, 0.01681835844201, 0.00154410254409956, 1.25265286729691e-05, 2.82033551147764e-34, 3.30433815896554e-24, 8.36690142508733e-19, 3.91203463896562e-15, 2.19432576726538e-12, 3.24480365409501e-10, 1.8970163956264e-08, 5.54884699549719e-07, 9.41716811626977e-06, 0.000102319583132435, 0.00076159276048464, 0.00407194453020614, 0.0161636438509718, 0.0486947633831935, 0.112742031538963, 0.20127207518112, 0.274976942961038, 0.280960648705138, 0.204304139147529, 0.0950755483156658, 0.0217723018096626, 0.000938266181699294, 1.07581452869447e-37, 6.69558047051659e-27, 4.22874379402182e-21, 3.75132958397559e-17, 3.47238448192481e-14, 7.8004233006753e-12, 6.56952219754019e-10, 2.67188581367254e-08, 6.15737445310873e-07, 8.94710339407867e-06, 8.83056089738271e-05, 0.000624329482091964, 0.00328619289099061, 0.013239893483207, 0.0416244190456524, 0.103323306930107, 0.203349919167616, 0.315643075561486, 0.378766977337335, 0.334425658489517, 0.191019661388689, 0.0437287342898956, 1.92360242154708e-41, 6.35965070014173e-30, 1.00184232453687e-23, 1.68619979910545e-19, 2.57570304385681e-16, 8.79000657996214e-14, 1.06644328768742e-11, 6.03079157179332e-10, 1.88717462390052e-08, 3.66730838077581e-07, 4.79948958257659e-06, 4.48711411845588e-05, 0.00031317573957461, 0.00168743869271958, 0.00720363657817013, 0.0248630470378984, 0.0704908925389006, 0.166221928468476, 0.329160968635737, 0.551406173025779, 0.785584808539912, 0.955320355726391, 

0.958965542571419, 0.801570776202361, 0.579596556434668, 0.361436155010619, 0.193519946582445, 0.0884229683631035, 0.0342047743442842, 0.0110880901977681, 0.00297345672078356, 0.000648961757088575, 0.000112920698849661, 1.52587890625e-05, 1.54798577043761e-06, 1.12793478842518e-07, 5.56374682366355e-09, 1.7128657316441e-10, 2.93216091315597e-12, 2.35066170254789e-14, 6.73053298746577e-17, 4.32491880329032e-20, 2.53346501940561e-24, 1.59258723206208e-30, 4.79104857806586e-42, 0.0402334438499917, 0.178524137082455, 0.321575237390574, 0.379772246835252, 0.334717524363028, 0.231592311744473, 0.128536221538303, 0.0576475551467623, 0.0208635502848164, 0.0060442600729657, 0.00138183321591173, 0.000244140625, 3.23835800489889e-05, 3.10027286277168e-06, 2.0299284641817e-07, 8.43410770548844e-09, 1.99751001708964e-10, 2.29758215419679e-12, 9.96177451393415e-15, 1.05372259616475e-17, 1.16895575956243e-21, 1.83057753190649e-27, 2.92338715066995e-38, 0.000791248126970899, 0.0186377417865266, 0.0836335789482098, 0.187049320640985, 0.271376631067937, 0.284331166218992, 0.226415215840666, 0.140490292756916, 0.0686208486707157, 0.0263881206913859, 0.00792645464935069, 0.0018310546875, 0.0003175587138834, 3.99445126488307e-05, 3.47164563200363e-06, 1.94668752361962e-07, 6.37868876809685e-09, 1.05267242734549e-10, 6.91138741709397e-13, 1.20341635318331e-15, 2.52826457048604e-19, 9.86311975822852e-25, 8.36148420863304e-35, 9.68241513565938e-06, 0.00121069613557103, 0.0135339411195154, 0.0573237461268958, 0.136902683262589, 0.217205247088996, 0.248159672523674, 0.213038089682458, 0.140433097301493, 0.0716835158796333, 0.0282909706447742, 0.008544921875, 0.00193762053011662, 0.000320228405108345, 3.69432892715715e-05, 2.79575342603507e-06, 1.26741655745847e-07, 3.00096522903839e-09, 2.98359098560156e-11, 8.55167213471824e-14, 3.40245570478686e-17, 3.30663305341019e-22, 1.4880788071433e-31, 8.25146920886049e-08, 5.47713697115467e-05, 0.00152526204543341, 0.0122345943010844, 0.0480981147215226, 0.115556063401608, 0.189423294301648, 0.224980449822289, 0.2001517741508, 0.135614683435931, 0.0703223373090274, 0.02777099609375, 0.00823360447269067, 0.00178788325930429, 0.00027378667840258, 2.79626332139002e-05, 1.75381556663249e-06, 5.95806530811708e-08, 8.96994777949704e-10, 4.23216659706291e-12, 3.18888620118097e-15, 7.72030181805267e-20, 1.84435734390755e-28, 5.19286160487721e-10, 1.82978443168245e-06, 0.000126938255299581, 0.00192829050266323, 0.0124787771264123, 0.0453986611533555, 0.106773491366157, 0.175452751421761, 0.210657678758311, 0.189461953831542, 0.129082279649461, 0.066650390625, 0.0258368256309341, 0.00737133831783476, 0.00149836267505753, 0.000206530952103932, 1.79215820664433e-05, 8.73529218004729e-07, 1.99144549207742e-08, 1.54668669293842e-10, 2.2070564599709e-13, 1.33109924183228e-17, 1.68807635924653e-25, 2.49638983990951e-12, 4.66956524162057e-08, 8.0699488005916e-06, 0.000232159010904296, 0.00247312572868962, 0.0136245932351371, 0.0459752072387686, 0.104521534866079, 0.169365651769251, 0.20219364517948, 0.180996488542905, 0.1221923828125, 0.0619324842772167, 0.0232158037322313, 0.00626400033365977, 0.00116525888008128, 0.000139893959736862, 9.783174626558e-06, 3.37735821535106e-07, 4.3178955847446e-09, 1.1668581348736e-11, 1.75314075643613e-15, 1.18023720071342e-22, 9.35144210767846e-15, 9.28567527815361e-10, 3.99769409870003e-07, 2.17800640513991e-05, 0.000381927463128473, 0.00318613791181724, 0.0154256854911711, 0.0485190064756966, 0.106104525209603, 0.168140957902685, 0.197758061931205, 0.174560546875, 0.115680024817544, 0.0569746450366939, 0.0204054944895012, 0.00512295121948155, 0.000850907019299719, 8.53773558473182e-05, 4.46320005105919e-06, 9.39295946613231e-08, 4.80710046356922e-10, 1.79921747904048e-13, 6.42994171296906e-20, 2.75864194465877e-17, 1.45412285119597e-11, 1.55954855725571e-08, 1.60910106713195e-06, 4.64479063891421e-05, 0.000586754133618054, 0.00407582765563047, 0.0177365269178154, 0.0523471494661081, 0.110110844919126, 0.170156603350311, 0.196380615234375, 0.170156603350311, 0.110110844919126, 0.0523471494661081, 0.0177365269178154, 0.00407582765563046, 0.000586754133618056, 4.64479063891421e-05, 1.60910106713195e-06, 1.55954855725573e-08, 1.45412285119597e-11, 2.7586419446583e-17, 6.42994171297029e-20, 1.79921747904048e-13, 4.80710046356915e-10, 9.39295946613231e-08, 4.46320005105919e-06, 8.53773558473179e-05, 0.000850907019299721, 0.00512295121948154, 0.0204054944895012, 0.0569746450366939, 0.115680024817544, 0.174560546875, 0.197758061931205, 0.168140957902685, 0.106104525209603, 0.0485190064756967, 0.0154256854911711, 0.00318613791181724, 0.000381927463128473, 2.17800640513991e-05, 3.99769409870008e-07, 9.28567527815361e-10, 9.35144210767708e-15, 1.18023720071367e-22, 1.75314075643613e-15, 1.16685813487358e-11, 4.3178955847446e-09, 3.37735821535106e-07, 9.78317462655796e-06, 0.000139893959736863, 0.00116525888008128, 0.00626400033365977, 0.0232158037322313, 0.0619324842772167, 0.1221923828125, 0.180996488542905, 0.20219364517948, 0.169365651769251, 0.104521534866079, 0.0459752072387685, 0.0136245932351372, 0.00247312572868962, 0.000232159010904296, 8.06994880059168e-06, 4.66956524162057e-08, 2.49638983990919e-12, 1.68807635924692e-25, 1.33109924183228e-17, 2.20705645997086e-13, 1.54668669293842e-10, 1.99144549207742e-08, 8.73529218004725e-07, 1.79215820664434e-05, 0.000206530952103932, 0.00149836267505753, 0.00737133831783476, 0.0258368256309341, 0.066650390625, 0.129082279649461, 0.189461953831542, 0.210657678758311, 0.175452751421761, 0.106773491366157, 0.0453986611533555, 0.0124787771264123, 0.00192829050266323, 0.000126938255299582, 1.82978443168245e-06, 5.19286160487665e-10, 1.84435734390802e-28, 7.72030181805267e-20, 3.18888620118091e-15, 4.23216659706291e-12, 8.96994777949704e-10, 5.95806530811705e-08, 1.7538155666325e-06, 2.79626332139001e-05, 0.00027378667840258, 0.00178788325930429, 0.00823360447269067, 0.02777099609375, 0.0703223373090274, 0.135614683435931, 0.2001517741508, 0.224980449822289, 0.189423294301648, 0.115556063401608, 0.0480981147215226, 0.0122345943010844, 0.00152526204543342, 5.47713697115467e-05, 8.25146920885978e-08, 1.48807880714372e-31, 3.30663305341019e-22, 3.40245570478679e-17, 8.55167213471824e-14, 2.98359098560156e-11, 3.00096522903837e-09, 1.26741655745848e-07, 2.79575342603506e-06, 3.69432892715715e-05, 0.000320228405108345, 0.00193762053011662, 0.008544921875, 0.0282909706447742, 0.0716835158796333, 0.140433097301493, 0.213038089682459, 0.248159672523674, 0.217205247088996, 0.136902683262589, 0.0573237461268958, 0.0135339411195155, 0.00121069613557103, 9.68241513565876e-06, 8.36148420863553e-35, 9.86311975822852e-25, 2.52826457048598e-19, 1.20341635318331e-15, 6.91138741709397e-13, 1.05267242734549e-10, 6.37868876809687e-09, 1.94668752361962e-07, 3.47164563200363e-06, 3.99445126488307e-05, 0.0003175587138834, 0.0018310546875, 0.00792645464935069, 0.0263881206913859, 0.0686208486707157, 0.140490292756916, 0.226415215840666, 0.284331166218992, 0.271376631067937, 0.187049320640985, 0.0836335789482101, 0.0186377417865266, 0.000791248126970866, 2.92338715067088e-38, 1.83057753190649e-27, 1.1689557595624e-21, 1.05372259616475e-17, 9.96177451393415e-15, 2.29758215419678e-12, 1.99751001708965e-10, 8.43410770548841e-09, 2.0299284641817e-07, 3.10027286277168e-06, 3.23835800489889e-05, 0.000244140625, 0.00138183321591173, 0.0060442600729657, 0.0208635502848164, 0.0576475551467623, 0.128536221538303, 0.231592311744473, 0.334717524363028, 0.379772246835252, 0.321575237390574, 0.178524137082455, 0.0402334438499909, 4.79104857806748e-42, 1.59258723206208e-30, 2.53346501940555e-24, 4.32491880329032e-20, 6.73053298746577e-17, 2.35066170254787e-14, 2.93216091315599e-12, 1.71286573164409e-10, 5.56374682366355e-09, 1.12793478842518e-07, 1.54798577043761e-06, 1.52587890625e-05, 0.000112920698849661, 0.000648961757088575, 0.00297345672078356, 0.0110880901977681, 0.0342047743442842, 0.0884229683631035, 0.193519946582445, 0.361436155010619, 0.579596556434668, 0.801570776202361, 0.958965542571419, 

0.962184902755307, 0.815903079109018, 0.60557058433353, 0.392389943307502, 0.221141300623195, 0.107845985852969, 0.0452095573413587, 0.016153667483149, 0.00486749844803446, 0.00122055579948932, 0.000250496540866396, 4.12057344608408e-05, 5.29067730057007e-06, 5.12478153432223e-07, 3.58208801356455e-08, 1.70261943831262e-09, 5.07297551939364e-11, 8.44021846881128e-13, 6.60349301647499e-15, 1.85269310038675e-17, 1.17117972913857e-20, 6.77560500720262e-25, 4.22280479359084e-31, 1.264317737593e-42, 0.037135636898524, 0.167063358124364, 0.308555797306067, 0.378024071844923, 0.349933639528624, 0.257697126622888, 0.154452681281506, 0.0760244169721774, 0.0307548802054257, 0.0101718813250098, 0.00272176933742597, 0.000579912196828559, 9.62380145827714e-05, 1.2074404966072e-05, 1.10035436793075e-06, 6.89841527284566e-08, 2.75943883771317e-09, 6.32453290188121e-11, 7.0747011146205e-13, 2.99728206700339e-15, 3.11216005877199e-18, 3.40423165770193e-22, 5.27956737429273e-28, 8.3861737806415e-39, 0.000671837893977337, 0.0160348581504473, 0.0736960024620547, 0.170711321414192, 0.259563014112748, 0.288639954980407, 0.247344313327266, 0.167716711487172, 0.0910884974991654, 0.0397361888842104, 0.0138625198810068, 0.00382567530228393, 0.000820584515164157, 0.000133351344749067, 1.58441947446137e-05, 1.31015404684489e-06, 7.03590649422311e-08, 2.22149072851981e-09, 3.55290628026853e-11, 2.27296645909628e-13, 3.87651602099999e-16, 8.01736051175104e-20, 3.09411853711858e-25, 2.60743064426178e-35, 7.56281771214014e-06, 0.000957622971596715, 0.0109521571957371, 0.0479679004607685, 0.119796861726848, 0.201163339966948, 0.246464245687328, 0.230221084840921, 0.16786438155476, 0.0965865504555493, 0.043931756161113, 0.0157036095678425, 0.00435356965620914, 0.000916377841296625, 0.000141955848321951, 1.5482493567981e-05, 1.11625871699281e-06, 4.85518822714019e-08, 1.1102094610454e-09, 1.07251643650737e-11, 3.00446230245181e-14, 1.17486843766531e-17, 1.12829087690438e-22, 5.0443729773198e-32, 5.92897131811312e-08, 3.9829106930103e-05, 0.00113352730572703, 0.00938675917568366, 0.038505667263886, 0.0976377600046736, 0.17103401903739, 0.220084994808344, 0.215441890376559, 0.163502229886795, 0.096959758891863, 0.0448918445997179, 0.0160858590006604, 0.00438559313722099, 0.000885753724118692, 0.000127419540292305, 1.23334974287999e-05, 7.38999624630142e-07, 2.41603196773603e-08, 3.52445091060155e-10, 1.62169252641233e-12, 1.19901230737618e-15, 2.86537709815481e-20, 6.79638848977228e-29, 3.43243994092066e-10, 1.22330418744779e-06, 8.66347616533581e-05, 0.00135646478160585, 0.00913969592076947, 0.0349956978056688, 0.0876473838193626, 0.155368743030799, 0.204187723956146, 0.204389501833361, 0.158027390999089, 0.0947683443656938, 0.0438905374057257, 0.0154992248549291, 0.0040813192287048, 0.00077438875919554, 0.000100631862936529, 8.30635034695279e-06, 3.88265059396363e-07, 8.55277124001915e-09, 6.4639524354067e-11, 9.03620189725921e-14, 5.37366235780926e-18, 6.76202981987229e-26, 1.51794745190425e-12, 2.87011004884994e-08, 5.05804369203099e-06, 0.00014973783936185, 0.00165717751953135, 0.00958168084859292, 0.0343103862180304, 0.0837851523541537, 0.147828883991226, 0.195174773157676, 0.196744865047093, 0.152823214007226, 0.0914803320701303, 0.0418429034356126, 0.0143654202914758, 0.00359511046851386, 0.000627212883618542, 7.13192003508001e-05, 4.76633030584026e-06, 1.58544959503223e-07, 1.96814903631029e-09, 5.20209649551431e-12, 7.6981994286208e-16, 5.13932592543429e-23, 5.23083538861985e-15, 5.24714615559754e-10, 2.30108940786514e-07, 1.28799781747402e-05, 0.000234135272302793, 0.00204422770398894, 0.0104658084382424, 0.0352071605261417, 0.0833968205234541, 0.14522764891107, 0.190868810834482, 0.192033010264874, 0.148574778528244, 0.0880225955651138, 0.0394000373351399, 0.0130054673853338, 0.00304617573192237, 0.000477159099720492, 4.55932432859626e-05, 2.29012162577195e-06, 4.66958555619071e-08, 2.33362681761904e-10, 8.59346802886104e-14, 3.04365739298852e-20, 1.41950174740594e-17, 7.55437145921359e-12, 8.2439428531896e-09, 8.72467492585171e-07, 2.60504493384313e-05, 0.000343453068442166, 0.00251403036201133, 0.0116505250932864, 0.0370501739575082, 0.0850992029490849, 0.145819999245019, 0.190025994093056, 0.190025994093056, 0.145819999245019, 0.0850992029490849, 0.0370501739575082, 0.0116505250932863, 0.00251403036201133, 0.000343453068442165, 2.60504493384313e-05, 8.72467492585171e-07, 8.24394285318948e-09, 7.55437145921359e-12, 1.41950174740568e-17, 3.04365739298915e-20, 8.59346802886104e-14, 2.33362681761908e-10, 4.66958555619071e-08, 2.29012162577195e-06, 4.55932432859628e-05, 0.000477159099720492, 0.00304617573192237, 0.0130054673853338, 0.0394000373351399, 0.0880225955651138, 0.148574778528244, 0.192033010264874, 0.190868810834482, 0.14522764891107, 0.0833968205234541, 0.0352071605261416, 0.0104658084382424, 0.00204422770398894, 0.000234135272302793, 1.28799781747402e-05, 2.30108940786511e-07, 5.24714615559754e-10, 5.23083538861901e-15, 5.13932592543547e-23, 7.6981994286208e-16, 5.20209649551441e-12, 1.96814903631029e-09, 1.58544959503223e-07, 4.76633030584028e-06, 7.13192003508001e-05, 0.000627212883618544, 0.00359511046851386, 0.0143654202914758, 0.0418429034356126, 0.0914803320701302, 0.152823214007226, 0.196744865047093, 0.195174773157676, 0.147828883991225, 0.0837851523541536, 0.0343103862180304, 0.00958168084859289, 0.00165717751953135, 0.00014973783936185, 5.05804369203094e-06, 2.87011004884994e-08, 1.51794745190404e-12, 6.762029819874e-26, 5.37366235780926e-18, 9.03620189725939e-14, 6.4639524354067e-11, 8.55277124001915e-09, 3.88265059396365e-07, 8.30635034695279e-06, 0.000100631862936529, 0.00077438875919554, 0.0040813192287048, 0.0154992248549291, 0.0438905374057256, 0.0947683443656939, 0.158027390999089, 0.204389501833361, 0.204187723956146, 0.155368743030799, 0.0876473838193626, 0.0349956978056687, 0.00913969592076947, 0.00135646478160585, 8.66347616533573e-05, 1.22330418744779e-06, 3.43243994092027e-10, 6.79638848977416e-29, 2.86537709815481e-20, 1.1990123073762e-15, 1.62169252641233e-12, 3.52445091060156e-10, 2.41603196773604e-08, 7.38999624630142e-07, 1.23334974287999e-05, 0.000127419540292305, 0.000885753724118692, 0.00438559313722099, 0.0160858590006604, 0.0448918445997179, 0.096959758891863, 0.163502229886795, 0.215441890376559, 0.220084994808344, 0.17103401903739, 0.0976377600046734, 0.038505667263886, 0.00938675917568366, 0.00113352730572702, 3.9829106930103e-05, 5.92897131811257e-08, 5.04437297732132e-32, 1.12829087690438e-22, 1.17486843766534e-17, 3.00446230245181e-14, 1.07251643650737e-11, 1.1102094610454e-09, 4.85518822714019e-08, 1.11625871699282e-06, 1.5482493567981e-05, 0.000141955848321951, 0.000916377841296626, 0.00435356965620913, 0.0157036095678425, 0.043931756161113, 0.0965865504555493, 0.16786438155476, 0.230221084840921, 0.246464245687328, 0.201163339966948, 0.119796861726848, 0.0479679004607685, 0.010952157195737, 0.000957622971596715, 7.56281771213962e-06, 2.60743064426262e-35, 3.09411853711858e-25, 8.01736051175125e-20, 3.87651602099999e-16, 2.27296645909628e-13, 3.55290628026856e-11, 2.22149072851981e-09, 7.03590649422313e-08, 1.31015404684489e-06, 1.58441947446137e-05, 0.000133351344749067, 0.000820584515164156, 0.00382567530228394, 0.0138625198810068, 0.0397361888842104, 0.0910884974991654, 0.167716711487172, 0.247344313327266, 0.288639954980406, 0.259563014112748, 0.170711321414192, 0.0736960024620545, 0.0160348581504473, 0.000671837893977306, 8.3861737806444e-39, 5.27956737429273e-28, 3.40423165770202e-22, 3.11216005877199e-18, 2.99728206700339e-15, 7.07470111462055e-13, 6.32453290188121e-11, 2.75943883771318e-09, 6.89841527284566e-08, 1.10035436793075e-06, 1.2074404966072e-05, 9.62380145827712e-05, 0.000579912196828559, 0.00272176933742597, 0.0101718813250098, 0.0307548802054257, 0.0760244169721774, 0.154452681281506, 0.257697126622888, 0.349933639528624, 0.378024071844923, 0.308555797306066, 0.167063358124364, 0.0371356368985232, 1.26431773759346e-42, 4.22280479359084e-31, 6.77560500720281e-25, 1.17117972913857e-20, 1.85269310038675e-17, 6.60349301647504e-15, 8.44021846881128e-13, 5.07297551939366e-11, 1.70261943831262e-09, 3.58208801356455e-08, 5.12478153432223e-07, 5.29067730057006e-06, 4.12057344608408e-05, 0.000250496540866396, 0.00122055579948932, 0.00486749844803446, 0.016153667483149, 0.0452095573413587, 0.107845985852969, 0.221141300623195, 0.392389943307502, 0.60557058433353, 0.815903079109018, 0.962184902755307, 

7.62939453125e-06, 0.00012969970703125, 0.00103759765625, 0.00518798828125, 0.018157958984375, 0.047210693359375, 0.09442138671875, 0.14837646484375, 0.185470581054688, 0.185470581054688, 0.14837646484375, 0.09442138671875, 0.047210693359375, 0.018157958984375, 0.00518798828125, 0.00103759765625, 0.00012969970703125, 7.62939453125e-06, 

0.0176713010559466, 3.34318352300439e-12, 0.0804951844015183, 2.12107823036952e-10, 0.172548957239849, 6.33277737805386e-09, 0.231171768736249, 1.18171234639599e-07, 0.216798010610133, 1.54357368083845e-06, 0.151036214845513, 1.49778080454995e-05, 0.0809400635914176, 0.000111795881223636, 0.0340808673458692, 0.000655643856691286, 0.0114149261033473, 0.00305862023105286, 0.00305862023105286, 0.0114149261033473, 0.000655643856691286, 0.0340808673458692, 0.000111795881223636, 0.0809400635914176, 1.49778080454995e-05, 0.151036214845513, 1.54357368083845e-06, 0.216798010610133, 1.18171234639599e-07, 0.231171768736249, 6.33277737805386e-09, 0.172548957239849, 2.12107823036952e-10, 0.0804951844015183, 3.34318352300439e-12, 0.0176713010559466, 

0.130973769999999, 7.62939453125e-06, 7.63511655807138e-17, 0.282809449999989, 0.00012969970703125, 1.02188947363682e-14, 0.287372079999356, 0.00103759765625, 6.43625504608587e-13, 0.182505199974664, 0.00518798828125, 2.53362643948887e-11, 0.0811341993018484, 0.018157958984375, 6.98151956726232e-10, 0.0267940257089995, 0.047210693359375, 1.42910006939121e-08, 0.00680657497437913, 0.09442138671875, 2.25025620927617e-07, 0.00135857602105339, 0.14837646484375, 2.78397894662345e-06, 0.000215702225146305, 0.185470581054688, 2.73977748536981e-05, 2.73977748536981e-05, 0.185470581054688, 0.000215702225146305, 2.78397894662345e-06, 0.14837646484375, 0.00135857602105339, 2.25025620927617e-07, 0.09442138671875, 0.00680657497437913, 1.42910006939121e-08, 0.047210693359375, 0.0267940257089995, 6.98151956726232e-10, 0.018157958984375, 0.0811341993018484, 2.53362643948887e-11, 0.00518798828125, 0.182505199974664, 6.43625504608587e-13, 0.00103759765625, 0.287372079999356, 1.02188947363682e-14, 0.00012969970703125, 0.282809449999989, 7.63511655807138e-17, 7.62939453125e-06, 0.130973769999999, 

0.294251832342467, 0.00110450376570857, 6.53053901548419e-09, 2.02533988112827e-20, 0.373231775975004, 0.00924855485599848, 2.2539288122175e-07, 4.61462401503815e-18, 0.22278149416278, 0.0364436291311924, 3.66076986438735e-06, 4.94784168119425e-16, 0.083111214894128, 0.0897530833824326, 3.716076769862e-05, 3.31570042629474e-14, 0.0217039204580053, 0.154730231815232, 0.000264055347638559, 1.55536676751434e-12, 0.0042103873397779, 0.198155567353329, 0.00139383241620539, 5.41995460833044e-11, 0.000628293491429971, 0.195206389521006, 0.00565956173681332, 1.45283111006913e-09, 7.36661070871407e-05, 0.151093725142548, 0.0180559229300027, 3.05984383582237e-08, 6.87049846705363e-06, 0.0930281096763387, 0.0458217794645707, 5.12623794602841e-07, 5.12623794602837e-07, 0.0458217794645707, 0.0930281096763387, 6.87049846705368e-06, 3.05984383582235e-08, 0.0180559229300027, 0.151093725142548, 7.36661070871412e-05, 1.45283111006912e-09, 0.00565956173681332, 0.195206389521006, 0.000628293491429974, 5.41995460833039e-11, 0.00139383241620539, 0.198155567353329, 0.00421038733977792, 1.55536676751432e-12, 0.000264055347638558, 0.154730231815232, 0.0217039204580053, 3.31570042629471e-14, 3.716076769862e-05, 0.0897530833824326, 0.0831112148941282, 4.94784168119419e-16, 3.66076986438735e-06, 0.0364436291311924, 0.222781494162781, 4.61462401503809e-18, 2.2539288122175e-07, 0.00924855485599848, 0.373231775975004, 2.02533988112824e-20, 6.53053901548419e-09, 0.00110450376570857, 0.294251832342467, 

0.441851081260504, 0.0115611305798335, 7.62939453125e-06, 1.49245079188059e-11, 2.57943437794053e-23, 0.369706521802748, 0.0589604752828895, 0.00012969970703125, 8.45740628678638e-10, 8.90924981565591e-21, 0.14557250893998, 0.141502043128515, 0.00103759765625, 2.25535771296945e-08, 1.4481010065222e-18, 0.0358246239066669, 0.21224841846885, 0.00518798828125, 3.75901180646097e-07, 1.4710810172575e-16, 0.0061713752217343, 0.222855960963965, 0.018157958984375, 4.38560977529204e-06, 1.04609798951308e-14, 0.000789746243408421, 0.173823844461093, 0.047210693359375, 3.80094500801697e-05, 5.52603265634824e-13, 7.7740948089243e-05, 0.104292023672152, 0.09442138671875, 0.000253401880840146, 2.2454902537558e-11, 6.01279983130494e-06, 0.0491651634811654, 0.14837646484375, 0.00132737224155863, 7.16924713133137e-10, 3.69929552892748e-07, 0.0184365327205247, 0.185470581054688, 0.00553083874333404, 1.82075409716381e-08, 1.82075409716379e-08, 0.00553083874333404, 0.185470581054688, 0.0184365327205247, 3.69929552892751e-07, 7.16924713133129e-10, 0.00132737224155863, 0.14837646484375, 0.0491651634811654, 6.01279983130499e-06, 2.24549025375578e-11, 0.000253401880840146, 0.09442138671875, 0.104292023672152, 7.77409480892435e-05, 5.52603265634816e-13, 3.80094500801697e-05, 0.047210693359375, 0.173823844461093, 0.000789746243408425, 1.04609798951307e-14, 4.38560977529204e-06, 0.018157958984375, 0.222855960963965, 0.00617137522173433, 1.47108101725747e-16, 3.75901180646097e-07, 0.00518798828125, 0.21224841846885, 0.035824623906667, 1.44810100652217e-18, 2.25535771296945e-08, 0.00103759765625, 0.141502043128515, 0.145572508939981, 8.90924981565575e-21, 8.45740628678638e-10, 0.00012969970703125, 0.0589604752828895, 0.369706521802749, 2.57943437794048e-23, 1.49245079188059e-11, 7.62939453125e-06, 0.0115611305798335, 0.441851081260504, 

0.557705782677578, 0.0426289339480105, 0.000290023188636388, 7.40837339364831e-08, 7.78616051469573e-14, 9.63802238359866e-26, 0.331315147123956, 0.14779521935725, 0.00303071968874386, 2.04883818110951e-06, 6.49030761338904e-12, 4.68866959319998e-23, 0.092622926975842, 0.241133398119828, 0.0149038984656224, 2.6664504635961e-05, 2.54594064834485e-10, 1.07337726884271e-20, 0.0161836220665653, 0.24588631799833, 0.0458072282093924, 0.000216889934877677, 6.24182066070632e-09, 1.53580181217503e-18, 0.00197938828129684, 0.1755130450412, 0.0985521682630309, 0.00123493277469182, 1.07120437509116e-07, 1.53821130027863e-16, 0.000179842182869504, 0.0930657200786974, 0.157508377404436, 0.00522339102952599, 1.36564774768316e-06, 1.14446396523005e-14, 1.25692331875683e-05, 0.0379600460499337, 0.19364120616625, 0.0169948919839546, 1.33925012466846e-05, 6.550054236436e-13, 6.90224945492971e-07, 0.0121654553392411, 0.187049499378884, 0.0434459129690458, 0.000103192788362783, 2.94545450247357e-11, 3.01500395838477e-08, 0.00310131139388313, 0.143724461158011, 0.0883476119583458, 0.00063248811284884, 1.05359841639261e-09, 1.05359841639261e-09, 0.000632488112848841, 0.0883476119583458, 0.143724461158011, 0.00310131139388313, 3.01500395838477e-08, 2.94545450247357e-11, 0.000103192788362783, 0.0434459129690458, 0.187049499378884, 0.0121654553392411, 6.90224945492971e-07, 6.550054236436e-13, 1.33925012466846e-05, 0.0169948919839546, 0.19364120616625, 0.0379600460499336, 1.25692331875683e-05, 1.14446396523005e-14, 1.36564774768317e-06, 0.00522339102952599, 0.157508377404436, 0.0930657200786973, 0.000179842182869504, 1.53821130027863e-16, 1.07120437509116e-07, 0.00123493277469182, 0.0985521682630309, 0.1755130450412, 0.00197938828129684, 1.53580181217503e-18, 6.24182066070635e-09, 0.000216889934877677, 0.0458072282093924, 0.24588631799833, 0.0161836220665653, 1.07337726884271e-20, 2.54594064834486e-10, 2.6664504635961e-05, 0.0149038984656224, 0.241133398119828, 0.092622926975842, 4.68866959319998e-23, 6.49030761338907e-12, 2.04883818110951e-06, 0.00303071968874386, 0.14779521935725, 0.331315147123956, 9.63802238359866e-26, 7.78616051469577e-14, 7.40837339364831e-08, 0.000290023188636388, 0.0426289339480105, 0.557705782677578, 

0.645208544474677, 0.0951308597870556, 0.00249705069465291, 7.62939453125e-06, 1.09341253421818e-09, 7.8239962904731e-16, 7.86220937137321e-28, 0.286393669180361, 0.240019893224785, 0.0179406609558133, 0.00012969970703125, 4.39815784138436e-08, 8.96191173573533e-14, 5.1189294523859e-25, 0.0598229441237545, 0.284979828083955, 0.0606583488029068, 0.00103759765625, 8.32527599919341e-07, 4.83074101038185e-12, 1.56839247241215e-22, 0.0078100204123665, 0.211475966959491, 0.128180731766144, 0.00518798828125, 9.84932541110918e-06, 1.62744703623986e-10, 3.00338060233056e-20, 0.000713731057782439, 0.10985149170556, 0.189606381054702, 0.018157958984375, 8.15666024097266e-05, 3.83793851719982e-09, 4.02590973929359e-18, 4.84531844791608e-05, 0.0423892957793371, 0.208347577512328, 0.047210693359375, 0.000501791802629358, 6.72348540082225e-08, 4.00887947616106e-16, 2.53026904890255e-06, 0.0125823885486047, 0.176108618017337, 0.09442138671875, 0.00237460511973535, 9.06040407900501e-07, 3.07070865681106e-14, 1.03818734391611e-07, 0.00293450350318585, 0.11696001419947, 0.14837646484375, 0.0088292514795967, 9.59324016584914e-06, 1.84807195451895e-12, 3.38844253931735e-09, 0.00054440429174817, 0.0617887747661054, 0.185470581054688, 0.0261139002981674, 8.07975952462324e-05, 8.8473764659442e-11, 8.84737646594403e-11, 8.07975952462324e-05, 0.0261139002981674, 0.185470581054688, 0.0617887747661054, 0.00054440429174817, 3.38844253931741e-09, 1.84807195451891e-12, 9.59324016584914e-06, 0.0088292514795967, 0.14837646484375, 0.11696001419947, 0.00293450350318585, 1.03818734391613e-07, 3.07070865681098e-14, 9.06040407900501e-07, 0.00237460511973535, 0.09442138671875, 0.176108618017337, 0.0125823885486047, 2.53026904890258e-06, 4.00887947616096e-16, 6.72348540082225e-08, 0.000501791802629358, 0.047210693359375, 0.208347577512328, 0.0423892957793371, 4.84531844791614e-05, 4.02590973929348e-18, 3.83793851719982e-09, 8.15666024097266e-05, 0.018157958984375, 0.189606381054702, 0.10985149170556, 0.000713731057782445, 3.00338060233047e-20, 1.62744703623986e-10, 9.84932541110918e-06, 0.00518798828125, 0.128180731766144, 0.211475966959491, 0.00781002041236655, 1.5683924724121e-22, 4.83074101038185e-12, 8.32527599919341e-07, 0.00103759765625, 0.0606583488029068, 0.284979828083955, 0.0598229441237547, 5.11892945238572e-25, 8.96191173573533e-14, 4.39815784138436e-08, 0.00012969970703125, 0.0179406609558133, 0.240019893224785, 0.286393669180361, 7.86220937137292e-28, 7.8239962904731e-16, 1.09341253421818e-09, 7.62939453125e-06, 0.00249705069465291, 0.0951308597870556, 0.645208544474677, 

0.711107156030271, 0.161598369297387, 0.0100150824931941, 0.000133641949552819, 2.434087824099e-07, 2.38781929795592e-11, 1.32447208808356e-17, 1.15828340506419e-29, 0.244886663574721, 0.310904791440639, 0.0529527556481251, 0.00156761134136549, 5.99706135786008e-06, 1.30516453960578e-09, 1.98952871623132e-15, 9.72036541893877e-27, 0.0396859046947949, 0.281487375547234, 0.131753956571966, 0.00865316643217796, 6.95315332578342e-05, 3.357145309067e-08, 1.40636703868096e-13, 3.83876401373623e-24, 0.00401964272077382, 0.159283373829086, 0.204889066441133, 0.0298532579979887, 0.000503854495215474, 5.39703246419542e-07, 6.21336924968736e-12, 9.47502261877745e-22, 0.000284994619849309, 0.0630928303279566, 0.22303444577721, 0.0720952167112211, 0.00255579789942523, 6.07348497505819e-06, 1.92155884344519e-10, 1.63706957014209e-19, 1.50103622465575e-05, 0.0185649967674513, 0.180355920198606, 0.129338098755004, 0.0096305964226402, 5.07722250096973e-05, 4.41454061172613e-09, 2.10116094608953e-17, 6.08138267776133e-07, 0.00420210009702481, 0.112187769014555, 0.178485582653037, 0.0279149276410159, 0.000326490897986093, 7.80142598168998e-08, 2.07447474433453e-15, 1.93587870130197e-08, 0.000747313036434671, 0.0548308868251174, 0.193528290105061, 0.0635747232871554, 0.00164960745328976, 1.08324605905335e-06, 1.60924301674409e-13, 4.90195498240095e-10, 0.000105719254299025, 0.0213167207764295, 0.166917220987793, 0.115172241317949, 0.00662987758866017, 1.19645291165949e-05, 9.9300282123357e-12, 9.9300282123357e-12, 1.19645291165949e-05, 0.00662987758866017, 0.115172241317949, 0.166917220987793, 0.0213167207764295, 0.000105719254299025, 4.90195498240095e-10, 1.60924301674409e-13, 1.08324605905335e-06, 0.00164960745328976, 0.0635747232871555, 0.193528290105061, 0.0548308868251174, 0.000747313036434671, 1.93587870130197e-08, 2.07447474433453e-15, 7.80142598168998e-08, 0.000326490897986093, 0.0279149276410159, 0.178485582653037, 0.112187769014555, 0.00420210009702481, 6.08138267776133e-07, 2.10116094608953e-17, 4.41454061172613e-09, 5.07722250096973e-05, 0.00963059642264021, 0.129338098755004, 0.180355920198606, 0.0185649967674513, 1.50103622465575e-05, 1.63706957014209e-19, 1.92155884344519e-10, 6.07348497505819e-06, 0.00255579789942523, 0.0720952167112211, 0.22303444577721, 0.0630928303279566, 0.000284994619849309, 9.47502261877745e-22, 6.21336924968736e-12, 5.39703246419542e-07, 0.000503854495215475, 0.0298532579979887, 0.204889066441133, 0.159283373829086, 0.00401964272077382, 3.83876401373623e-24, 1.40636703868096e-13, 3.357145309067e-08, 6.95315332578343e-05, 0.00865316643217796, 0.131753956571966, 0.281487375547234, 0.0396859046947949, 9.72036541893877e-27, 1.98952871623132e-15, 1.30516453960578e-09, 5.99706135786009e-06, 0.00156761134136549, 0.0529527556481251, 0.310904791440639, 0.244886663574721, 1.15828340506419e-29, 1.32447208808356e-17, 2.38781929795592e-11, 2.434087824099e-07, 0.000133641949552819, 0.0100150824931941, 0.161598369297387, 0.711107156030271, 

0.761233323889896, 0.233588076015323, 0.0259402550209388, 0.000903647075271148, 7.62939453125e-06, 9.74575737037344e-09, 7.35338078441037e-13, 3.41534796815554e-19, 2.7100452411372e-31, 0.209351487660393, 0.354634530004749, 0.105677550949793, 0.00783899736648096, 0.00012969970703125, 3.24677180976037e-07, 5.2164662265255e-11, 6.50133358613879e-17, 2.84784353093862e-28, 0.0270941403734349, 0.253368392100004, 0.202596670754422, 0.0320009783065867, 0.00103759765625, 5.09013151734302e-06, 1.74143315861213e-09, 5.82386110372131e-15, 1.40830516794241e-25, 0.00219156683211105, 0.113136794156934, 0.242751479807405, 0.0816480862206196, 0.00518798828125, 4.98753846550757e-05, 3.63343367212516e-08, 3.26061546700893e-13, 4.35268700796481e-23, 0.000124088661953745, 0.0353633452863351, 0.203605501070058, 0.145823260268337, 0.018157958984375, 0.000342090924411548, 5.30671425952292e-07, 1.2778686036714e-11, 9.41707751586997e-21, 5.21933037387164e-06, 0.00821122813017025, 0.12685933573721, 0.19346967479908, 0.047210693359375, 0.00174301911839207, 5.75757328120325e-06, 3.72030134486263e-10, 1.5134920883966e-18, 1.68870629229071e-07, 0.00146662654964796, 0.060801179729001, 0.197449322176742, 0.09442138671875, 0.00683155228463203, 4.80518256499134e-05, 8.33156690446626e-09, 1.87111643123383e-16, 4.29297248481205e-09, 0.000205823811548608, 0.0228963485898486, 0.158329938179854, 0.14837646484375, 0.0210378469738946, 0.00031509750215308, 1.46602002506748e-07, 1.8175489644503e-14, 8.68115391299151e-11, 2.29766684853289e-05, 0.00685860542731875, 0.100991728440012, 0.185470581054688, 0.0515345579265759, 0.00164359721282379, 2.05195809255541e-06, 1.4043869794679e-12, 1.40438697946786e-12, 2.05195809255541e-06, 0.00164359721282378, 0.0515345579265759, 0.185470581054688, 0.100991728440012, 0.00685860542731876, 2.29766684853289e-05, 8.68115391299175e-11, 1.81754896445024e-14, 1.46602002506748e-07, 0.000315097502153079, 0.0210378469738946, 0.14837646484375, 0.158329938179854, 0.0228963485898487, 0.000205823811548608, 4.29297248481216e-09, 1.87111643123376e-16, 8.33156690446626e-09, 4.80518256499133e-05, 0.00683155228463203, 0.09442138671875, 0.197449322176742, 0.0608011797290011, 0.00146662654964796, 1.68870629229075e-07, 1.51349208839654e-18, 3.72030134486263e-10, 5.75757328120324e-06, 0.00174301911839207, 0.047210693359375, 0.19346967479908, 0.12685933573721, 0.00821122813017025, 5.21933037387173e-06, 9.41707751586955e-21, 1.2778686036714e-11, 5.3067142595229e-07, 0.000342090924411549, 0.018157958984375, 0.145823260268337, 0.203605501070058, 0.0353633452863351, 0.000124088661953747, 4.3526870079646e-23, 3.26061546700893e-13, 3.63343367212515e-08, 4.98753846550757e-05, 0.00518798828125, 0.0816480862206196, 0.242751479807406, 0.113136794156934, 0.00219156683211107, 1.40830516794234e-25, 5.82386110372131e-15, 1.74143315861213e-09, 5.09013151734302e-06, 0.00103759765625, 0.0320009783065867, 0.202596670754422, 0.253368392100004, 0.0270941403734351, 2.84784353093846e-28, 6.50133358613879e-17, 5.21646622652548e-11, 3.24677180976037e-07, 0.00012969970703125, 0.00783899736648096, 0.105677550949793, 0.354634530004749, 0.209351487660394, 2.71004524113704e-31, 3.41534796815554e-19, 7.35338078441033e-13, 9.74575737037344e-09, 7.62939453125e-06, 0.000903647075271148, 0.0259402550209388, 0.233588076015323, 0.761233323889896, 

0.799911595033025, 0.304986864201106, 0.0513041702808366, 0.00347305893107688, 8.07463817567011e-05, 4.9247332281505e-07, 4.87811217328626e-10, 3.04543637785855e-14, 1.24364912270302e-20, 9.19457629799216e-33, 0.179761296478804, 0.375116644133917, 0.166492825187304, 0.0233386198342505, 0.0010169348889308, 1.13008334904983e-05, 2.09790881735435e-08, 2.71209263524323e-12, 2.92220386477081e-18, 1.18242979394098e-29, 0.019010408833936, 0.217116385265628, 0.254260819799779, 0.0738038899631652, 0.00602704299459654, 0.000122033567553851, 4.24582900306999e-07, 1.13658147501772e-10, 3.23120282132376e-16, 7.15583096349387e-27, 0.00125651228571054, 0.0785414441880639, 0.242685249396356, 0.14586911662888, 0.0223252046751657, 0.000823622413694183, 5.37054559229012e-06, 2.97698498699513e-09, 2.23304741808061e-14, 2.70660449781498e-24, 5.81353192639486e-05, 0.0198885538432292, 0.162145670829918, 0.201811306120809, 0.0578874806375895, 0.00389112377648109, 4.75523907265418e-05, 5.45821647221491e-08, 1.08026352197462e-12, 7.16617757109628e-22, 1.99810675477937e-06, 0.003741216420258, 0.0804771594354975, 0.207411550006546, 0.111501100017323, 0.0136561173038234, 0.000312774694322374, 7.43413033061791e-07, 3.88210055831157e-11, 1.40946934652463e-19, 5.28267583821693e-08, 0.000541351202596095, 0.0307253308216243, 0.163974769314634, 0.165207706772597, 0.0368668540006506, 0.0015825138080298, 7.78872254108119e-06, 1.07315016826031e-09, 2.13245734411439e-17, 1.09737202620225e-09, 6.15474450773174e-05, 0.00921690573709039, 0.101855801280224, 0.19232958886954, 0.078200507039813, 0.00629112127645956, 6.41160775047282e-05, 2.33087436073124e-08, 2.53495187960936e-15, 1.81329797397196e-11, 5.56616813667004e-06, 0.00219932338496931, 0.0503280239147569, 0.178105475622643, 0.131946667731028, 0.0198940852407283, 0.000419839237995709, 4.02710171793613e-07, 2.39703543658934e-13, 2.39703543658934e-13, 4.02710171793616e-07, 0.000419839237995709, 0.0198940852407283, 0.131946667731028, 0.178105475622643, 0.0503280239147569, 0.00219932338496931, 5.56616813667e-06, 1.81329797397196e-11, 2.53495187960936e-15, 2.33087436073126e-08, 6.41160775047282e-05, 0.00629112127645956, 0.078200507039813, 0.19232958886954, 0.101855801280224, 0.00921690573709039, 6.15474450773171e-05, 1.09737202620225e-09, 2.13245734411439e-17, 1.07315016826032e-09, 7.78872254108119e-06, 0.0015825138080298, 0.0368668540006506, 0.165207706772597, 0.163974769314634, 0.0307253308216243, 0.000541351202596092, 5.28267583821693e-08, 1.40946934652463e-19, 3.8821005583116e-11, 7.43413033061791e-07, 0.000312774694322374, 0.0136561173038234, 0.111501100017323, 0.207411550006546, 0.0804771594354975, 0.00374121642025798, 1.99810675477937e-06, 7.16617757109628e-22, 1.08026352197463e-12, 5.45821647221491e-08, 4.75523907265417e-05, 0.00389112377648109, 0.0578874806375895, 0.201811306120809, 0.162145670829918, 0.0198885538432291, 5.81353192639486e-05, 2.70660449781498e-24, 2.23304741808063e-14, 2.97698498699513e-09, 5.37054559229012e-06, 0.000823622413694183, 0.0223252046751657, 0.14586911662888, 0.242685249396356, 0.0785414441880637, 0.00125651228571054, 7.15583096349387e-27, 3.2312028213238e-16, 1.13658147501772e-10, 4.24582900306999e-07, 0.000122033567553851, 0.00602704299459654, 0.0738038899631651, 0.254260819799779, 0.217116385265627, 0.019010408833936, 1.18242979394098e-29, 2.92220386477085e-18, 2.71209263524323e-12, 2.09790881735435e-08, 1.13008334904983e-05, 0.0010169348889308, 0.0233386198342505, 0.166492825187304, 0.375116644133916, 0.179761296478804, 9.19457629799216e-33, 1.24364912270303e-20, 3.04543637785855e-14, 4.87811217328626e-10, 4.9247332281505e-07, 8.07463817567011e-05, 0.00347305893107688, 0.0513041702808366, 0.304986864201106, 0.799911595033025, 

0.830214641736034, 0.372269364572094, 0.085098617078643, 0.00932050502003652, 0.000441059356227914, 7.62939453125e-06, 3.660982370243e-08, 3.00248405690594e-11, 1.6274827065159e-15, 6.03576663504965e-22, 4.23192951143029e-34, 0.155327380356271, 0.378754410076634, 0.225634943197415, 0.0501604451140271, 0.00431412827985852, 0.00012969970703125, 1.08168165650477e-06, 1.61233995315068e-09, 1.77390504865509e-13, 1.71446996944521e-19, 6.53700231312275e-31, 0.0136756101802025, 0.181342318609592, 0.28153427767306, 0.127035290274304, 0.0198577544266828, 0.00103759765625, 1.50398102790065e-05, 4.07449310442336e-08, 9.09882731322872e-12, 2.29175607097187e-17, 4.7518193048241e-28, 0.000752532784995346, 0.0542651049793208, 0.219551403424312, 0.201079318305379, 0.0571277650561907, 0.00518798828125, 0.000130696894430691, 6.43532635035827e-07, 2.91689296373008e-10, 1.91463906573119e-15, 2.15884376585456e-25, 2.89869270563785e-05, 0.0113668510951898, 0.119850319473685, 0.222796551367695, 0.115043575881422, 0.018157958984375, 0.000795034945777848, 7.11484764410554e-06, 6.54566241150831e-09, 1.11970464872756e-13, 6.86563245459757e-23, 8.294385831823e-07, 0.00176874407364459, 0.0486012543501561, 0.183381207363691, 0.172100770366078, 0.047210693359375, 0.00359262983732457, 5.84340431600162e-05, 1.09116899424252e-07, 4.86435598726372e-12, 1.62197886192114e-20, 1.82567276709412e-08, 0.000211712486249855, 0.0151604610123533, 0.116106849008923, 0.198043185834786, 0.09442138671875, 0.0124880714282089, 0.000369167038027267, 1.39922346121195e-06, 1.62556323001496e-10, 2.94758594953428e-18, 3.15737590642612e-10, 1.99109781794452e-05, 0.00371571150489661, 0.0577597759281279, 0.179061262892583, 0.14837646484375, 0.0341069531957213, 0.00183250237673814, 1.40976521196856e-05, 4.26822232680941e-09, 4.20874307447653e-16, 4.34355186501973e-12, 1.48954657885824e-06, 0.000724414165801217, 0.0228564368688829, 0.128783062996376, 0.185470581054688, 0.0740978905065711, 0.0072357165234337, 0.000112985280568078, 8.914676077055e-08, 4.78028422671343e-14, 4.78028422671321e-14, 8.914676077055e-08, 0.000112985280568078, 0.00723571652343372, 0.074097890506571, 0.185470581054688, 0.128783062996377, 0.0228564368688829, 0.000724414165801215, 1.48954657885824e-06, 4.34355186501991e-12, 4.20874307447632e-16, 4.26822232680941e-09, 1.40976521196856e-05, 0.00183250237673815, 0.0341069531957212, 0.14837646484375, 0.179061262892583, 0.0577597759281279, 0.0037157115048966, 1.99109781794452e-05, 3.15737590642623e-10, 2.94758594953411e-18, 1.62556323001496e-10, 1.39922346121196e-06, 0.000369167038027268, 0.0124880714282089, 0.09442138671875, 0.198043185834787, 0.116106849008923, 0.0151604610123533, 0.000211712486249855, 1.82567276709418e-08, 1.62197886192104e-20, 4.86435598726372e-12, 1.09116899424253e-07, 5.84340431600164e-05, 0.00359262983732457, 0.047210693359375, 0.172100770366078, 0.183381207363691, 0.048601254350156, 0.00176874407364459, 8.29438583182321e-07, 6.86563245459711e-23, 1.11970464872756e-13, 6.54566241150835e-09, 7.11484764410556e-06, 0.000795034945777847, 0.018157958984375, 0.115043575881422, 0.222796551367695, 0.119850319473685, 0.0113668510951898, 2.8986927056379e-05, 2.1588437658544e-25, 1.91463906573119e-15, 2.9168929637301e-10, 6.43532635035829e-07, 0.000130696894430691, 0.00518798828125, 0.0571277650561907, 0.201079318305379, 0.219551403424312, 0.0542651049793208, 0.000752532784995357, 4.75181930482374e-28, 2.29175607097187e-17, 9.09882731322878e-12, 4.07449310442338e-08, 1.50398102790065e-05, 0.00103759765625, 0.0198577544266828, 0.127035290274304, 0.28153427767306, 0.181342318609592, 0.0136756101802026, 6.53700231312222e-31, 1.71446996944521e-19, 1.77390504865511e-13, 1.61233995315068e-09, 1.08168165650477e-06, 0.00012969970703125, 0.00431412827985852, 0.0501604451140271, 0.225634943197415, 0.378754410076634, 0.155327380356272, 4.23192951142992e-34, 6.03576663504965e-22, 1.62748270651591e-15, 3.00248405690596e-11, 3.66098237024299e-08, 7.62939453125e-06, 0.000441059356227914, 0.00932050502003652, 0.085098617078643, 0.372269364572094, 0.830214641736034, 

0.854309616348057, 0.43379324534826, 0.12520729304087, 0.0196687545293189, 0.00156691083761615, 5.67041154344666e-05, 7.8461621012609e-07, 3.13796840196805e-09, 2.2282034586662e-12, 1.08389393501662e-16, 3.73317001035061e-23, 2.51287979214105e-35, 0.135145885809536, 0.371345760707461, 0.276720117576077, 0.0869315509068933, 0.0123110035808224, 0.000749398935292166, 1.71576035006669e-05, 1.15424296333342e-07, 1.45697506523979e-10, 1.41733829569714e-14, 1.26031738210749e-20, 4.59073287023724e-32, 0.0100607748273744, 0.149594360337636, 0.28780140277432, 0.180808590583439, 0.0455180550248572, 0.00466071588228341, 0.000176561920464671, 1.99796083511591e-06, 4.48322422363729e-09, 8.72170358697937e-13, 2.00227234635415e-18, 3.94669346428512e-29, 0.000468101514526405, 0.0376644811465475, 0.187079024476994, 0.235039422451634, 0.105185034248216, 0.0181164126278249, 0.00113557932773658, 2.16150738268781e-05, 8.62201588025298e-08, 3.35435591180234e-11, 1.9881373760942e-16, 2.12062944813454e-26, 1.52456766166756e-05, 0.00663814595540746, 0.0851246475636382, 0.213875186735847, 0.170146197956601, 0.0492935184966845, 0.00511253097118686, 0.000163690892149045, 1.16071398377027e-06, 9.03056659697618e-10, 1.38187153380708e-14, 7.97616665163783e-24, 3.68857539014836e-07, 0.000869094314538393, 0.0287733786328114, 0.144572401712539, 0.204454111620929, 0.0996351862309582, 0.0170985675924177, 0.00092086848817516, 1.16077198655868e-05, 1.8060349973704e-08, 7.13500455704242e-13, 2.22858372448567e-21, 6.86479026197978e-09, 8.7527327502513e-05, 0.0074814028752383, 0.0751738923273776, 0.188984460968659, 0.154914583218566, 0.0439886014849761, 0.0039849910983059, 8.92946147881223e-05, 2.77839489037231e-07, 2.83385409867704e-11, 4.78983261967999e-19, 1.00383083269804e-10, 6.92604130261523e-06, 0.00152841000966025, 0.0307123698317955, 0.137252730575748, 0.189250274653888, 0.088917087651596, 0.0135494525651158, 0.000539719696075338, 3.35835367685693e-06, 8.84352419241507e-10, 8.08865606942808e-17, 1.1676405176958e-12, 4.35955191548974e-07, 0.00024837739744473, 0.00998102142726313, 0.0792923443147298, 0.183906086111781, 0.142970248559198, 0.0366464162311484, 0.0025949358978701, 3.229046194228e-05, 2.19527341214948e-08, 1.08654513023907e-14, 1.08654513023913e-14, 2.19527341214946e-08, 3.22904619422798e-05, 0.00259493589787009, 0.0366464162311484, 0.142970248559198, 0.183906086111781, 0.0792923443147299, 0.00998102142726315, 0.00024837739744473, 4.35955191548978e-07, 1.16764051769575e-12, 8.08865606942857e-17, 8.84352419241496e-10, 3.35835367685691e-06, 0.000539719696075337, 0.0135494525651158, 0.088917087651596, 0.189250274653888, 0.137252730575748, 0.0307123698317956, 0.00152841000966025, 6.92604130261529e-06, 1.00383083269799e-10, 4.7898326196803e-19, 2.833854098677e-11, 2.7783948903723e-07, 8.92946147881221e-05, 0.00398499109830589, 0.0439886014849761, 0.154914583218566, 0.188984460968659, 0.0751738923273778, 0.00748140287523832, 8.75273275025136e-05, 6.86479026197953e-09, 2.22858372448583e-21, 7.13500455704233e-13, 1.80603499737039e-08, 1.16077198655868e-05, 0.000920868488175159, 0.0170985675924177, 0.0996351862309583, 0.204454111620929, 0.14457240171254, 0.0287733786328114, 0.000869094314538398, 3.68857539014825e-07, 7.97616665163845e-24, 1.38187153380706e-14, 9.03056659697612e-10, 1.16071398377027e-06, 0.000163690892149045, 0.00511253097118686, 0.0492935184966845, 0.170146197956601, 0.213875186735847, 0.0851246475636384, 0.00663814595540749, 1.52456766166752e-05, 2.12062944813472e-26, 1.98813737609417e-16, 3.35435591180232e-11, 8.62201588025295e-08, 2.16150738268781e-05, 0.00113557932773658, 0.0181164126278249, 0.105185034248216, 0.235039422451634, 0.187079024476995, 0.0376644811465476, 0.000468101514526396, 3.94669346428548e-29, 2.00227234635412e-18, 8.72170358697931e-13, 4.48322422363727e-09, 1.9979608351159e-06, 0.000176561920464671, 0.00466071588228341, 0.0455180550248572, 0.180808590583439, 0.287801402774321, 0.149594360337636, 0.0100607748273743, 4.59073287023768e-32, 1.26031738210747e-20, 1.41733829569713e-14, 1.45697506523979e-10, 1.15424296333342e-07, 1.71576035006669e-05, 0.000749398935292166, 0.0123110035808224, 0.0869315509068933, 0.276720117576077, 0.371345760707461, 0.135145885809535, 2.51287979214131e-35, 3.73317001035054e-23, 1.08389393501661e-16, 2.22820345866619e-12, 3.13796840196804e-09, 7.8461621012609e-07, 5.67041154344666e-05, 0.00156691083761615, 0.0196687545293189, 0.12520729304087, 0.43379324534826, 0.854309616348057, 

0.873734716008478, 0.489069149020839, 0.16927492587847, 0.0351078517868548, 0.00415018654259668, 0.000259195508569522, 7.62939453125e-06, 8.8804835345928e-08, 3.08220060347542e-10, 1.95566115341902e-13, 8.74004533400025e-18, 2.84050854530568e-24, 1.85171643379453e-36, 0.118404821940239, 0.357270517834782, 0.316940753587818, 0.129971062413266, 0.0268628098688378, 0.0027557615522413, 0.00012969970703125, 2.41390564934609e-06, 1.37617899086543e-08, 1.52668359604968e-11, 1.34904387397052e-15, 1.12374308262949e-21, 3.94895810664196e-33, 0.00755092665560418, 0.122818886757314, 0.279257345656199, 0.226428008752807, 0.0818231743836789, 0.0137878600728816, 0.00103759765625, 3.08777064764778e-05, 2.89154537300229e-07, 5.60848464047692e-10, 9.79894970576731e-14, 2.09208356737566e-19, 3.96306903492969e-30, 0.000300961631165088, 0.026388405618599, 0.153783996338723, 0.246543548789827, 0.155769070205973, 0.0431153697865174, 0.00518798828125, 0.000246859471678657, 3.79721437928334e-06, 1.28772179955363e-08, 4.44849391061463e-12, 2.43428286708658e-17, 2.48576899138312e-27, 8.39692070858975e-06, 0.00396879973946816, 0.0592810270828713, 0.187912287217823, 0.20757936111522, 0.0943768337799606, 0.018157958984375, 0.0013815054289321, 3.49058535404739e-05, 2.06964853706586e-07, 1.41365851105347e-10, 1.98271867270447e-15, 1.09141001502691e-24, 1.74034069672712e-07, 0.000443415146129197, 0.0169756182414181, 0.106395195769644, 0.205490816575861, 0.153463109896771, 0.047210693359375, 0.00574328939537428, 0.000238361830029527, 2.47102112051255e-06, 3.33719302864927e-09, 1.1996552377978e-13, 3.55975744336043e-22, 2.77463044608567e-09, 3.81082064572315e-05, 0.00373931565861083, 0.0463388770386141, 0.156479450595711, 0.191954913868093, 0.09442138671875, 0.0183664597876759, 0.00125207921952217, 2.26940998720171e-05, 6.06003023273172e-08, 5.58352493623405e-12, 8.9311940736431e-20, 3.47568707154615e-11, 2.57330429390853e-06, 0.000647177344735123, 0.0158574606187629, 0.0936239277307696, 0.188651004890554, 0.14837646484375, 0.0461482093151811, 0.0051676317019548, 0.000163762370254357, 8.64635182857234e-07, 2.04185602094043e-10, 1.760610533869e-17, 3.46331151851268e-13, 1.3822262862128e-07, 8.90983889603563e-05, 0.00431655367778818, 0.0445586237685804, 0.147480424689907, 0.185470581054688, 0.0922358221387009, 0.0169655001687982, 0.000940006024983851, 9.81310360124557e-06, 5.93959917082553e-09, 2.76078402396016e-15, 2.76078402396033e-15, 5.9395991708256e-09, 9.81310360124552e-06, 0.000940006024983854, 0.0169655001687982, 0.0922358221387009, 0.185470581054688, 0.147480424689907, 0.0445586237685804, 0.00431655367778817, 8.90983889603567e-05, 1.38222628621279e-07, 3.46331151851248e-13, 1.76061053386912e-17, 2.04185602094045e-10, 8.6463518285723e-07, 0.000163762370254358, 0.0051676317019548, 0.0461482093151811, 0.14837646484375, 0.188651004890554, 0.0936239277307696, 0.0158574606187629, 0.000647177344735126, 2.57330429390851e-06, 3.47568707154598e-11, 8.93119407364378e-20, 5.58352493623413e-12, 6.06003023273168e-08, 2.26940998720172e-05, 0.00125207921952217, 0.0183664597876759, 0.09442138671875, 0.191954913868093, 0.156479450595711, 0.0463388770386141, 0.00373931565861084, 3.81082064572312e-05, 2.77463044608555e-09, 3.55975744336073e-22, 1.19965523779782e-13, 3.33719302864924e-09, 2.47102112051255e-06, 0.000238361830029527, 0.00574328939537428, 0.047210693359375, 0.153463109896771, 0.205490816575861, 0.106395195769644, 0.0169756182414182, 0.000443415146129194, 1.74034069672706e-07, 1.09141001502701e-24, 1.9827186727045e-15, 1.41365851105346e-10, 2.06964853706587e-07, 3.49058535404739e-05, 0.0013815054289321, 0.018157958984375, 0.0943768337799606, 0.20757936111522, 0.187912287217823, 0.0592810270828714, 0.00396879973946814, 8.39692070858952e-06, 2.48576899138337e-27, 2.43428286708663e-17, 4.4484939106146e-12, 1.28772179955363e-08, 3.79721437928333e-06, 0.000246859471678657, 0.00518798828125, 0.0431153697865174, 0.155769070205973, 0.246543548789827, 0.153783996338723, 0.0263884056185989, 0.000300961631165081, 3.96306903493011e-30, 2.0920835673757e-19, 9.79894970576723e-14, 5.60848464047695e-10, 2.89154537300229e-07, 3.08777064764778e-05, 0.00103759765625, 0.0137878600728816, 0.0818231743836789, 0.226428008752807, 0.279257345656199, 0.122818886757313, 0.00755092665560408, 3.94895810664241e-33, 1.12374308262952e-21, 1.34904387397051e-15, 1.52668359604969e-11, 1.37617899086543e-08, 2.41390564934609e-06, 0.00012969970703125, 0.0027557615522413, 0.0268628098688378, 0.129971062413266, 0.316940753587818, 0.357270517834781, 0.118404821940238, 1.85171643379475e-36, 2.84050854530575e-24, 8.74004533400016e-18, 1.95566115341903e-13, 3.08220060347542e-10, 8.8804835345928e-08, 7.62939453125e-06, 0.000259195508569522, 0.00415018654259668, 0.0351078517868548, 0.16927492587847, 0.489069149020839, 0.873734716008478, 

0.889594758108883, 0.538238444513063, 0.215208221773865, 0.0555556506711015, 0.00892722344229672, 0.000845825059716832, 4.36548132285582e-05, 1.09203806920542e-06, 1.10859428935882e-08, 3.43806231838634e-11, 1.9944886717162e-14, 8.33062210940558e-19, 2.58472034334222e-25, 1.64232894310906e-37, 0.104431945288415, 0.339562747396132, 0.345988619772711, 0.175034804913216, 0.048551255395963, 0.00742203711467096, 0.000597389876184047, 2.306268659163e-05, 3.6511351260014e-07, 1.82695364503338e-09, 1.82950348159789e-12, 1.49751893399311e-16, 1.18403919683622e-22, 4.04312191150242e-34, 0.00576919988359471, 0.100810653143775, 0.261761538827565, 0.259514516988379, 0.124258351771405, 0.030648326179186, 0.00384702180610304, 0.000229204469233227, 5.65879864523545e-06, 4.56859202792748e-08, 7.89725155924442e-11, 1.26680064336778e-14, 2.55246422580525e-20, 4.68397525924736e-31, 0.000199194719614698, 0.0187056513582649, 0.123774127409138, 0.240479973972544, 0.198760797468354, 0.0790988952117545, 0.0154835825884426, 0.00142369278259714, 5.48151482385493e-05, 7.1403129105053e-07, 2.13058429572916e-09, 6.69767771215201e-13, 3.43900862901329e-18, 3.39150424929442e-28, 4.8143548474799e-06, 0.00242961400683071, 0.0409686781303264, 0.155989086803563, 0.222553235520571, 0.142899962333943, 0.0436230776168082, 0.00619024054024747, 0.000371684957417738, 7.81178264633538e-06, 4.02364364995537e-08, 2.47878155726387e-11, 3.24343282135041e-16, 1.71896953024924e-25, 8.64377943780619e-08, 0.00023442667800892, 0.0100734754727059, 0.0751648540679703, 0.185115335340651, 0.191778145461272, 0.0912990907575783, 0.0199942017743811, 0.00187221051753523, 6.34875198183905e-05, 5.6447615883889e-07, 6.81486991633227e-10, 2.27238467857454e-14, 6.47216074949135e-23, 1.19378441119448e-09, 1.73993663215616e-05, 0.00190529997981541, 0.0278607029150898, 0.118442490670142, 0.197980657645802, 0.146985079185363, 0.0496772176479893, 0.00725422503865711, 0.000396901937966093, 6.09155745040353e-06, 1.44123079156292e-08, 1.22465975257147e-12, 1.87450697060629e-20, 1.29542650851773e-11, 1.01466920445928e-06, 0.000283147050404983, 0.00811398068383574, 0.059543905144959, 0.160587249614268, 0.185927957506345, 0.0969784204441761, 0.0220847260728361, 0.00194958747902685, 5.16506432551608e-05, 2.39482698659145e-07, 5.18577521566509e-11, 4.26569179547794e-18, 1.11818850686472e-13, 4.70685582096024e-08, 3.34715703931533e-05, 0.00187971166922227, 0.0238112648008656, 0.103613113774295, 0.187081788890751, 0.150594224575911, 0.0534820908723064, 0.00761759014678858, 0.000348368190370409, 3.16541111194737e-06, 1.74673610843354e-09, 7.72159920250542e-16, 7.72159920250542e-16, 1.74673610843356e-09, 3.16541111194737e-06, 0.000348368190370408, 0.00761759014678857, 0.0534820908723064, 0.150594224575911, 0.187081788890751, 0.103613113774295, 0.0238112648008656, 0.00187971166922228, 3.34715703931533e-05, 4.70685582096018e-08, 1.11818850686472e-13, 4.26569179547794e-18, 5.18577521566517e-11, 2.39482698659145e-07, 5.16506432551606e-05, 0.00194958747902685, 0.0220847260728361, 0.096978420444176, 0.185927957506345, 0.160587249614268, 0.0595439051449591, 0.00811398068383576, 0.000283147050404983, 1.01466920445927e-06, 1.29542650851773e-11, 1.87450697060629e-20, 1.22465975257149e-12, 1.44123079156292e-08, 6.0915574504035e-06, 0.000396901937966092, 0.00725422503865711, 0.0496772176479893, 0.146985079185363, 0.197980657645802, 0.118442490670142, 0.0278607029150898, 0.00190529997981541, 1.73993663215614e-05, 1.19378441119448e-09, 6.47216074949135e-23, 2.27238467857459e-14, 6.81486991633227e-10, 5.64476158838888e-07, 6.34875198183904e-05, 0.00187221051753523, 0.0199942017743811, 0.0912990907575783, 0.191778145461272, 0.185115335340651, 0.0751648540679705, 0.0100734754727059, 0.000234426678008919, 8.64377943780619e-08, 1.71896953024924e-25, 3.24343282135048e-16, 2.47878155726387e-11, 4.02364364995535e-08, 7.81178264633536e-06, 0.000371684957417738, 0.00619024054024746, 0.0436230776168082, 0.142899962333943, 0.222553235520571, 0.155989086803563, 0.0409686781303264, 0.0024296140068307, 4.8143548474799e-06, 3.39150424929442e-28, 3.43900862901336e-18, 6.69767771215201e-13, 2.13058429572915e-09, 7.14031291050528e-07, 5.48151482385493e-05, 0.00142369278259714, 0.0154835825884426, 0.0790988952117544, 0.198760797468355, 0.240479973972544, 0.123774127409138, 0.0187056513582648, 0.000199194719614698, 4.68397525924736e-31, 2.55246422580531e-20, 1.26680064336778e-14, 7.89725155924438e-11, 4.56859202792746e-08, 5.65879864523545e-06, 0.000229204469233227, 0.00384702180610305, 0.030648326179186, 0.124258351771405, 0.259514516988379, 0.261761538827565, 0.100810653143775, 0.00576919988359471, 4.04312191150242e-34, 1.18403919683625e-22, 1.49751893399311e-16, 1.82950348159788e-12, 1.82695364503338e-09, 3.6511351260014e-07, 2.30626865916299e-05, 0.000597389876184047, 0.00742203711467096, 0.048551255395963, 0.175034804913217, 0.345988619772711, 0.339562747396132, 0.104431945288415, 1.64232894310906e-37, 2.58472034334229e-25, 8.33062210940558e-19, 1.99448867171619e-14, 3.43806231838633e-11, 1.10859428935882e-08, 1.09203806920541e-06, 4.36548132285582e-05, 0.000845825059716832, 0.00892722344229672, 0.0555556506711015, 0.215208221773865, 0.538238444513063, 0.889594758108883, 

0.902694399949043, 0.581748947168752, 0.261365820344349, 0.0804289189020854, 0.0164950805924533, 0.00216650033125363, 0.000172152872317438, 7.62939453125e-06, 1.67491054114252e-07, 1.52293218785328e-09, 4.31263724539781e-12, 2.32681406719828e-15, 9.20004581051338e-20, 2.74897431799738e-26, 1.71069707890484e-38, 0.0926887163389483, 0.320217759274191, 0.364922076623139, 0.218509308995939, 0.0765808765518103, 0.0160052294680607, 0.00194621705276805, 0.00012969970703125, 4.28166276599808e-06, 5.95765380781975e-08, 2.68457091589041e-10, 2.47515163920369e-13, 1.90430491311056e-17, 1.44330699698249e-23, 4.81487300896989e-35, 0.00447872144811695, 0.0829461605619895, 0.239768732767412, 0.279362894486244, 0.167312076736289, 0.0556424335608356, 0.0103540281050855, 0.00103759765625, 5.15079619552948e-05, 1.09675854410551e-06, 7.86407954915233e-09, 1.2390333806349e-11, 1.85491516367833e-15, 3.56605319411715e-21, 6.37731143524064e-32, 0.000135257468506673, 0.0134284899742322, 0.0984611662592362, 0.223227408406382, 0.228462152385975, 0.120901125580173, 0.03442765345996, 0.00518798828125, 0.000387272172311318, 1.26190542333291e-05, 1.43979589972211e-07, 3.87653955724267e-10, 1.12925398683384e-13, 5.5067699603497e-19, 5.27922816789307e-29, 2.85934459178474e-06, 0.00152179485146035, 0.028303193683612, 0.12486029387986, 0.218373169849359, 0.18388767100562, 0.0801315504951987, 0.018157958984375, 0.00203824439615431, 0.00010163437651767, 1.84523637372925e-06, 8.48991756123374e-09, 4.81235052807455e-12, 5.95256425573373e-17, 3.05915356842484e-26, 4.49031742848265e-08, 0.000128112157560429, 0.00604381572996613, 0.0518807794098691, 0.15505636411769, 0.20776872955972, 0.138549503275692, 0.047210693359375, 0.00796895778086267, 0.000608078644468089, 1.75674362030572e-05, 1.38123644807967e-07, 1.52344990523918e-10, 4.77987515272984e-15, 1.31685339867981e-23, 5.424306692914e-10, 8.29623848395869e-06, 0.000992758544552415, 0.0165823195024757, 0.0846908636327683, 0.180577819168666, 0.184273569181536, 0.09442138671875, 0.0239664352748449, 0.00279856580426471, 0.000128653442304092, 1.72857900765919e-06, 3.70984487683302e-09, 2.95247114638637e-13, 4.36043911349854e-21, 5.14844502709841e-12, 4.22120807059667e-07, 0.000128127013155513, 0.00416436430285705, 0.0363452931917717, 0.123314251961416, 0.19256873250395, 0.14837646484375, 0.0566330574870503, 0.0101198935547177, 0.000740285232774407, 1.69971101351238e-05, 7.09819575534096e-08, 1.43291167220911e-11, 1.13445604552209e-18, 3.88707831675869e-14, 1.7084711899592e-08, 1.31538576767243e-05, 0.000831893094371381, 0.0124072393243603, 0.066984991975198, 0.160075130243597, 0.185470581054688, 0.106451538582896, 0.0291092980968415, 0.00338838015342911, 0.000132946316918142, 1.08032782482497e-06, 5.53182644987792e-10, 2.34779670538812e-16, 2.34779670538792e-16, 5.53182644987792e-10, 1.08032782482496e-06, 0.000132946316918142, 0.00338838015342911, 0.0291092980968415, 0.106451538582896, 0.185470581054688, 0.160075130243597, 0.066984991975198, 0.0124072393243603, 0.000831893094371378, 1.31538576767243e-05, 1.7084711899592e-08, 3.88707831675898e-14, 1.13445604552198e-18, 1.43291167220911e-11, 7.0981957553409e-08, 1.69971101351238e-05, 0.000740285232774407, 0.0101198935547177, 0.0566330574870503, 0.14837646484375, 0.19256873250395, 0.123314251961416, 0.0363452931917717, 0.00416436430285704, 0.000128127013155513, 4.22120807059667e-07, 5.14844502709874e-12, 4.36043911349809e-21, 2.95247114638637e-13, 3.709844876833e-09, 1.7285790076592e-06, 0.000128653442304092, 0.00279856580426471, 0.0239664352748449, 0.09442138671875, 0.184273569181536, 0.180577819168666, 0.0846908636327683, 0.0165823195024756, 0.000992758544552419, 8.29623848395869e-06, 5.4243066929143e-10, 1.31685339867967e-23, 4.77987515272984e-15, 1.52344990523917e-10, 1.38123644807968e-07, 1.75674362030572e-05, 0.000608078644468089, 0.00796895778086267, 0.047210693359375, 0.138549503275692, 0.20776872955972, 0.15505636411769, 0.051880779409869, 0.00604381572996615, 0.000128112157560429, 4.49031742848286e-08, 3.05915356842447e-26, 5.95256425573373e-17, 4.8123505280745e-12, 8.48991756123378e-09, 1.84523637372925e-06, 0.00010163437651767, 0.00203824439615431, 0.018157958984375, 0.0801315504951987, 0.18388767100562, 0.218373169849359, 0.12486029387986, 0.0283031936836121, 0.00152179485146035, 2.85934459178484e-06, 5.27922816789238e-29, 5.5067699603497e-19, 1.12925398683383e-13, 3.87653955724269e-10, 1.43979589972211e-07, 1.26190542333291e-05, 0.000387272172311318, 0.00518798828125, 0.03442765345996, 0.120901125580173, 0.228462152385975, 0.223227408406382, 0.0984611662592364, 0.0134284899742322, 0.000135257468506677, 6.37731143523975e-32, 3.56605319411715e-21, 1.85491516367831e-15, 1.2390333806349e-11, 7.86407954915233e-09, 1.09675854410551e-06, 5.15079619552948e-05, 0.00103759765625, 0.0103540281050855, 0.0556424335608356, 0.167312076736289, 0.279362894486244, 0.239768732767412, 0.0829461605619895, 0.00447872144811703, 4.81487300896917e-35, 1.44330699698249e-23, 1.90430491311054e-17, 2.47515163920371e-13, 2.68457091589041e-10, 5.95765380781975e-08, 4.28166276599808e-06, 0.00012969970703125, 0.00194621705276805, 0.0160052294680607, 0.0765808765518103, 0.218509308995939, 0.36492207662314, 0.320217759274191, 0.0926887163389492, 1.71069707890457e-38, 2.74897431799738e-26, 9.20004581051327e-20, 2.32681406719829e-15, 4.31263724539781e-12, 1.52293218785328e-09, 1.67491054114252e-07, 7.62939453125e-06, 0.000172152872317438, 0.00216650033125363, 0.0164950805924533, 0.0804289189020854, 0.261365820344349, 0.581748947168752, 0.902694399949043, 

0.913628155620945, 0.620168963393625, 0.306569267858942, 0.10886849344452, 0.0271994513304529, 0.0046393051532459, 0.000517968092532866, 3.56955802841483e-05, 1.39769967446103e-06, 2.75855142451886e-08, 2.2921835936195e-10, 6.02502301414364e-13, 3.06278637637188e-16, 1.15761301153398e-20, 3.35338896264012e-27, 2.05134413215235e-39, 0.0827491677306065, 0.300496741623221, 0.375361885845137, 0.257882917725363, 0.109211357163539, 0.0293173817432156, 0.00493585512493544, 0.000501518390390368, 2.87500954077897e-05, 8.3660321785544e-07, 1.04827444810684e-08, 4.3365952753319e-11, 3.7367512391848e-14, 2.73237112192557e-18, 2.00010149352455e-24, 6.54549064768789e-36, 0.00352694639974012, 0.0685189299396178, 0.216278223502662, 0.287464356525266, 0.206355728864166, 0.0871843412028374, 0.0221341508828722, 0.00331589175694034, 0.000278295242511317, 1.19398547223881e-05, 2.25601335232849e-07, 1.46885910645996e-09, 2.14542201814051e-12, 3.03498842716811e-16, 5.61385515856263e-22, 9.82849351653648e-33, 9.3953746362264e-05, 0.009764755964386, 0.0778852883800214, 0.200274404081724, 0.243694245389329, 0.162043574899295, 0.0620359368975809, 0.0137023117626686, 0.00168365184762675, 0.000106502198226339, 3.03450843376234e-06, 3.10950604340354e-08, 7.69859187383024e-11, 2.1069508729823e-14, 9.84805328734352e-20, 9.22383916692346e-30, 1.75197290191554e-06, 0.00097411505681171, 0.0196334269509806, 0.0976708423631467, 0.20145221988228, 0.210825520531688, 0.121708767640915, 0.039635595183067, 0.00713012002255547, 0.000664991571802107, 2.85715020150456e-05, 4.60787522370762e-07, 1.93378372353156e-09, 1.02388179111185e-12, 1.20930992282018e-17, 6.05946844080303e-27, 2.42686696881971e-08, 7.21879023224537e-05, 0.00367656368498014, 0.0353842277810688, 0.123709811342515, 0.203760430932072, 0.177380423761829, 0.0851691331900382, 0.0224308996932625, 0.00308445908595349, 0.000199840311871481, 5.07242131803101e-06, 3.60835956636951e-08, 3.69615804606505e-11, 1.1031387659146e-15, 2.9570770296901e-24, 2.58595643710655e-10, 4.11505112751109e-06, 0.000529596032766873, 0.00986077747989972, 0.0584376683667744, 0.151486233402561, 0.198859415634869, 0.140778300507974, 0.0542816691678887, 0.0110052150761026, 0.00107520128132895, 4.29523149599271e-05, 5.17926774324557e-07, 1.02637932350916e-09, 7.74068374991202e-14, 1.11006240702805e-21, 2.16501588808659e-12, 1.84310763605998e-07, 5.99393463472901e-05, 0.00215912230767832, 0.0216893363578273, 0.088489376211055, 0.175166591437368, 0.182832693914568, 0.103210609750049, 0.0308519560818184, 0.00454528476476178, 0.000285773847188204, 5.84105864830007e-06, 2.23939088112914e-08, 4.26769281593131e-12, 3.27413665743301e-19, 1.44183757396021e-14, 6.56661461952279e-09, 5.39628215911346e-06, 0.000376061347862988, 0.00640346464550457, 0.0411172885635722, 0.122735943999795, 0.188880605585389, 0.156102860609706, 0.0687990184699444, 0.015284378678749, 0.00151242467873589, 5.23998615006099e-05, 3.88657707036645e-07, 1.87164012422016e-10, 7.68177490473964e-17, 7.68177490474036e-17, 1.87164012422016e-10, 3.88657707036642e-07, 5.23998615006101e-05, 0.00151242467873589, 0.015284378678749, 0.0687990184699445, 0.156102860609706, 0.188880605585389, 0.122735943999795, 0.0411172885635722, 0.00640346464550457, 0.000376061347862986, 5.39628215911349e-06, 6.56661461952279e-09, 1.44183757396009e-14, 3.27413665743335e-19, 4.26769281593131e-12, 2.23939088112912e-08, 5.84105864830009e-06, 0.000285773847188204, 0.00454528476476178, 0.0308519560818184, 0.103210609750049, 0.182832693914568, 0.175166591437368, 0.088489376211055, 0.0216893363578273, 0.00215912230767832, 5.99393463472905e-05, 1.84310763605998e-07, 2.16501588808643e-12, 1.11006240702818e-21, 7.74068374991202e-14, 1.02637932350915e-09, 5.1792677432456e-07, 4.29523149599271e-05, 0.00107520128132895, 0.0110052150761026, 0.0542816691678887, 0.140778300507973, 0.198859415634869, 0.151486233402561, 0.0584376683667744, 0.00986077747989969, 0.000529596032766875, 4.11505112751109e-06, 2.58595643710639e-10, 2.95707702969047e-24, 1.1031387659146e-15, 3.69615804606501e-11, 3.60835956636953e-08, 5.07242131803101e-06, 0.000199840311871481, 0.0030844590859535, 0.0224308996932625, 0.085169133190038, 0.177380423761829, 0.203760430932072, 0.123709811342515, 0.0353842277810687, 0.00367656368498016, 7.21879023224537e-05, 2.42686696881958e-08, 6.05946844080385e-27, 1.20930992282018e-17, 1.02388179111184e-12, 1.93378372353157e-09, 4.60787522370762e-07, 2.85715020150456e-05, 0.000664991571802109, 0.00713012002255546, 0.039635595183067, 0.121708767640915, 0.210825520531688, 0.20145221988228, 0.0976708423631465, 0.0196334269509806, 0.000974115056811709, 1.75197290191547e-06, 9.22383916692482e-30, 9.84805328734351e-20, 2.10695087298228e-14, 7.69859187383029e-11, 3.10950604340354e-08, 3.03450843376234e-06, 0.000106502198226339, 0.00168365184762674, 0.0137023117626686, 0.0620359368975809, 0.162043574899295, 0.243694245389329, 0.200274404081723, 0.0778852883800216, 0.009764755964386, 9.39537463622611e-05, 9.82849351653802e-33, 5.61385515856263e-22, 3.03498842716807e-16, 2.14542201814053e-12, 1.46885910645996e-09, 2.25601335232849e-07, 1.19398547223881e-05, 0.000278295242511316, 0.00331589175694033, 0.0221341508828722, 0.0871843412028374, 0.206355728864166, 0.287464356525266, 0.216278223502663, 0.0685189299396178, 0.00352694639974004, 6.54549064768898e-36, 2.00010149352455e-24, 2.73237112192554e-18, 3.73675123918483e-14, 4.3365952753319e-11, 1.04827444810684e-08, 8.36603217855442e-07, 2.87500954077896e-05, 0.000501518390390366, 0.00493585512493544, 0.0293173817432156, 0.109211357163539, 0.257882917725363, 0.375361885845138, 0.300496741623221, 0.0827491677306056, 2.05134413215271e-39, 3.35338896264012e-27, 1.15761301153397e-20, 3.0627863763719e-16, 6.02502301414364e-13, 2.2921835936195e-10, 2.75855142451887e-08, 1.39769967446103e-06, 3.56955802841482e-05, 0.000517968092532866, 0.0046393051532459, 0.0271994513304529, 0.10886849344452, 0.306569267858942, 0.620168963393625, 0.913628155620945, 

0.922841482421118, 0.654087207622715, 0.350035941263129, 0.139928817166104, 0.0411114277500397, 0.00867444315489512, 0.00127320240385874, 0.000124449727707558, 7.62939453125e-06, 2.69749649419818e-07, 4.87542986982489e-09, 3.7598666042127e-11, 9.29029264325132e-14, 4.49460340078678e-17, 1.63622351394328e-21, 4.61904901982329e-28, 2.78548504492552e-40, 0.0742774245321839, 0.281165507975319, 0.379021045256573, 0.291736286045745, 0.144329992440454, 0.0475056518377301, 0.0103921666964874, 0.00147480650647249, 0.00012969970703125, 6.57836001445527e-06, 1.72624368150958e-07, 1.98411391769871e-09, 7.64774163879262e-12, 6.23025657184864e-15, 4.36706631469324e-19, 3.10544632317954e-25, 1.0001587649085e-36, 0.00281337504562402, 0.0568760588739099, 0.193132372741986, 0.286229770483891, 0.238446901740157, 0.122430612817816, 0.0399168097963594, 0.00822464581755959, 0.00103759765625, 7.54945240746441e-05, 2.87628790994483e-06, 4.92721865873067e-08, 2.96263457528355e-10, 4.06407349801068e-13, 5.48501740082221e-17, 9.82509024974533e-23, 1.68996661392856e-33, 6.66006461350042e-05, 0.00719079594862775, 0.0615073256943086, 0.175516993921384, 0.246210628106878, 0.197203574405029, 0.0958264858795822, 0.0286668109203765, 0.00518798828125, 0.00054149354405326, 2.9953158661456e-05, 7.64745773112605e-07, 7.17303555188095e-09, 1.65690341227913e-11, 4.30572461570173e-15, 1.94280443875144e-20, 1.78470862351942e-30, 1.10363964831121e-06, 0.000636388722759487, 0.0137118689231033, 0.0753393002138922, 0.17795899659535, 0.222350229277971, 0.16103242744131, 0.0699422499888169, 0.018157958984375, 0.00271874925091273, 0.000218348864690286, 8.308648278073e-06, 1.21569860894965e-07, 4.72858141782184e-10, 2.36598795920621e-13, 2.68917871887344e-18, 1.3193334064879e-27, 1.3585682140699e-08, 4.18382286112417e-05, 0.00227076276956427, 0.024023113623613, 0.09555169693886, 0.18623687872325, 0.201023310500099, 0.126766681037752, 0.047210693359375, 0.0101402889330477, 0.00118240035908855, 6.70577485460676e-05, 1.53057339432333e-06, 1.00246646595765e-08, 9.65793134829092e-12, 2.76512996195073e-16, 7.24514530638523e-25, 1.28644804774637e-10, 2.11582989927232e-06, 0.000289270086126243, 0.00589241947924587, 0.0394651272854559, 0.119991486851127, 0.193035039857935, 0.176736922509385, 0.09442138671875, 0.0290929762622306, 0.00492532412137018, 0.00041631706085692, 1.48231003092152e-05, 1.63480321795722e-07, 3.03258055202232e-10, 2.18709716745522e-14, 3.06052751584204e-22, 9.57122894241691e-13, 8.40722868325847e-08, 2.89534242583715e-05, 0.00113559289636423, 0.0128071725546733, 0.0607435031779898, 0.145643305787628, 0.193603902148753, 0.14837646484375, 0.0655829012313077, 0.01612017408093, 0.00203078571199849, 0.000112794671755593, 2.09471895955798e-06, 7.48178504436044e-09, 1.35920592064213e-12, 1.0158044857261e-19, 5.66446013714491e-15, 2.65729848163292e-09, 2.30521645664793e-06, 0.000174087282353063, 0.00330604211665905, 0.0244604590160961, 0.0874098296977797, 0.168700469888202, 0.185470581054688, 0.117600309599684, 0.0419681675665118, 0.00787987552874509, 0.000682737079114944, 2.13501736223293e-05, 1.46829552582927e-07, 6.71920366296178e-11, 2.68187994150768e-17, 2.6818799415074e-17, 6.71920366296192e-11, 1.46829552582927e-07, 2.13501736223294e-05, 0.000682737079114946, 0.0078798755287451, 0.0419681675665118, 0.117600309599684, 0.185470581054688, 0.168700469888202, 0.0874098296977797, 0.024460459016096, 0.00330604211665904, 0.000174087282353062, 2.30521645664793e-06, 2.65729848163287e-09, 5.66446013714544e-15, 1.01580448572598e-19, 1.35920592064216e-12, 7.48178504436044e-09, 2.09471895955799e-06, 0.000112794671755594, 0.0020307857119985, 0.01612017408093, 0.0655829012313077, 0.14837646484375, 0.193603902148753, 0.145643305787628, 0.0607435031779897, 0.0128071725546733, 0.00113559289636422, 2.89534242583715e-05, 8.40722868325834e-08, 9.5712289424177e-13, 3.06052751584164e-22, 2.18709716745527e-14, 3.03258055202232e-10, 1.63480321795723e-07, 1.48231003092153e-05, 0.000416317060856921, 0.00492532412137018, 0.0290929762622306, 0.09442138671875, 0.176736922509385, 0.193035039857935, 0.119991486851126, 0.0394651272854559, 0.00589241947924585, 0.000289270086126243, 2.11582989927229e-06, 1.28644804774646e-10, 7.2451453063842e-25, 2.76512996195081e-16, 9.65793134829092e-12, 1.00246646595766e-08, 1.53057339432333e-06, 6.70577485460678e-05, 0.00118240035908854, 0.0101402889330477, 0.047210693359375, 0.126766681037752, 0.201023310500099, 0.18623687872325, 0.0955516969388598, 0.0240231136236129, 0.00227076276956427, 4.18382286112412e-05, 1.35856821406998e-08, 1.3193334064877e-27, 2.68917871887352e-18, 2.36598795920621e-13, 4.72858141782187e-10, 1.21569860894966e-07, 8.30864827807302e-06, 0.000218348864690286, 0.00271874925091273, 0.018157958984375, 0.0699422499888169, 0.16103242744131, 0.222350229277971, 0.17795899659535, 0.0753393002138921, 0.0137118689231033, 0.000636388722759482, 1.10363964831127e-06, 1.78470862351912e-30, 1.9428044387515e-20, 4.30572461570173e-15, 1.65690341227914e-11, 7.17303555188098e-09, 7.64745773112608e-07, 2.9953158661456e-05, 0.00054149354405326, 0.00518798828125, 0.0286668109203765, 0.0958264858795822, 0.197203574405029, 0.246210628106878, 0.175516993921383, 0.0615073256943087, 0.00719079594862771, 6.66006461350066e-05, 1.68996661392826e-33, 9.82509024974566e-23, 5.48501740082221e-17, 4.06407349801071e-13, 2.96263457528357e-10, 4.92721865873068e-08, 2.87628790994483e-06, 7.54945240746441e-05, 0.00103759765625, 0.00822464581755959, 0.0399168097963594, 0.122430612817816, 0.238446901740157, 0.286229770483891, 0.193132372741986, 0.0568760588739097, 0.00281337504562408, 1.00015876490831e-36, 3.10544632317965e-25, 4.36706631469324e-19, 6.23025657184869e-15, 7.64774163879266e-12, 1.98411391769872e-09, 1.72624368150958e-07, 6.57836001445527e-06, 0.00012969970703125, 0.00147480650647249, 0.0103921666964874, 0.04750565183773, 0.144329992440454, 0.291736286045745, 0.379021045256573, 0.281165507975319, 0.0742774245321848, 2.78548504492496e-40, 4.61904901982347e-28, 1.63622351394328e-21, 4.49460340078682e-17, 9.29029264325137e-14, 3.75986660421271e-11, 4.87542986982489e-09, 2.69749649419818e-07, 7.62939453125e-06, 0.000124449727707558, 0.00127320240385874, 0.00867444315489512, 0.0411114277500397, 0.139928817166104, 0.350035941263129, 0.654087207622715, 0.922841482421118, 

0.930672644222882, 0.684062828118248, 0.391291040015883, 0.172704463439273, 0.0580671437789247, 0.0146057404620968, 0.00268150546708616, 0.000347610359176246, 3.04273769431888e-05, 1.69224733091537e-06, 5.49465136732955e-08, 9.22631771612389e-10, 6.68389973695956e-12, 1.56801521874188e-14, 7.27693764407843e-18, 2.56680750429514e-22, 7.0903409549738e-29, 4.22463442971983e-41, 0.0670081708967356, 0.262664897811688, 0.377471120583698, 0.31951872319949, 0.179908274902464, 0.0700794235732519, 0.0189946166387211, 0.00353137974660857, 0.00043641697184249, 3.40976590374752e-05, 1.56309823673031e-06, 3.76421484028117e-08, 4.02588001700134e-10, 1.46260630556528e-12, 1.13672064043459e-15, 7.68966315508807e-20, 5.33652951698834e-26, 1.69572788634149e-37, 0.00227038570425922, 0.047462340458999, 0.171359672352599, 0.278182706401026, 0.262308811505678, 0.158233534228757, 0.0633174541304195, 0.0168825171267788, 0.00294564098590675, 0.000323315373195828, 2.09253856209143e-05, 7.22705674826684e-07, 1.14112388058993e-08, 6.42015739016121e-11, 8.35602833524986e-14, 1.08408265845501e-17, 1.8901304459147e-23, 3.20305396678047e-34, 4.80785699072463e-05, 0.00536014181142349, 0.0486198408758119, 0.151371446573031, 0.239031225185529, 0.223298884304034, 0.131915665692651, 0.0504440553316488, 0.0124261906870015, 0.00191605585059869, 0.000175081671570074, 8.67218521306025e-06, 2.02155135236513e-07, 1.76134295151759e-09, 3.83907042855335e-12, 9.55206998879769e-16, 4.18412506105408e-21, 3.78139779852995e-31, 7.12691335217918e-07, 0.000423741938819326, 0.00965642747815043, 0.0576575035660418, 0.152473523096729, 0.22058329406672, 0.192383287766186, 0.105506891504133, 0.0366939321560038, 0.00794855187499195, 0.00102542981011513, 7.28439796343921e-05, 2.50688725197446e-06, 3.38251878112908e-08, 1.23466829154385e-10, 5.89156447172089e-14, 6.48359048184528e-19, 3.12491722628382e-28, 7.8479589003343e-09, 2.48846721001937e-05, 0.00142470430588958, 0.0163144715694865, 0.0722502803812811, 0.161869112793746, 0.208422026874339, 0.163929443999831, 0.0804925705841718, 0.0244947586937454, 0.00446145479047788, 0.000454531606193092, 2.30935197163231e-05, 4.82549434656672e-07, 2.94971335091615e-09, 2.69941139487919e-12, 7.46331546018643e-17, 1.91835939267872e-25, 6.6476570903538e-11, 1.12413648461385e-06, 0.000161692411514196, 0.00355096863280592, 0.0263354828843205, 0.0913717625440195, 0.173690687964229, 0.19592495316939, 0.135823209379734, 0.0580650715618487, 0.0149315090579832, 0.00218168054376579, 0.000163644760424325, 5.2954156344755e-06, 5.42083240691769e-08, 9.51402233818284e-11, 6.60852700891896e-15, 9.05895443473398e-23, 4.42430590528209e-13, 3.98998087212419e-08, 1.44184703633476e-05, 0.00060727487053496, 0.00754236741464437, 0.0405251534532921, 0.113729755410585, 0.183987020668277, 0.180076412017713, 0.108148727868111, 0.0392640918619074, 0.00822778394790406, 0.000911126607241839, 4.56586372307247e-05, 7.82738682344903e-07, 2.63465592497758e-09, 4.59771650573917e-13, 3.36117269714046e-20, 2.3422705265354e-15, 1.12651752382124e-09, 1.02273732949271e-06, 8.26112420947997e-05, 0.00171826225887462, 0.0142972562618862, 0.059236179818394, 0.137435836451401, 0.18991315002992, 0.160229778681904, 0.0821301810203311, 0.0246825467042235, 0.00403525256191596, 0.000313156337045097, 8.99048210499301e-06, 5.80362059929372e-08, 2.54445677239694e-11, 9.92016616740086e-18, 9.92016616740086e-18, 2.54445677239694e-11, 5.80362059929372e-08, 8.99048210499296e-06, 0.000313156337045097, 0.00403525256191596, 0.0246825467042235, 0.0821301810203311, 0.160229778681904, 0.18991315002992, 0.137435836451401, 0.059236179818394, 0.0142972562618862, 0.00171826225887462, 8.26112420948e-05, 1.02273732949271e-06, 1.12651752382124e-09, 2.3422705265354e-15, 3.36117269714046e-20, 4.59771650573917e-13, 2.63465592497758e-09, 7.82738682344899e-07, 4.56586372307247e-05, 0.000911126607241839, 0.00822778394790406, 0.0392640918619074, 0.108148727868111, 0.180076412017713, 0.183987020668277, 0.113729755410585, 0.0405251534532921, 0.00754236741464437, 0.000607274870534963, 1.44184703633476e-05, 3.98998087212419e-08, 4.42430590528209e-13, 9.05895443473398e-23, 6.60852700891896e-15, 9.51402233818284e-11, 5.42083240691765e-08, 5.2954156344755e-06, 0.000163644760424325, 0.00218168054376579, 0.0149315090579832, 0.0580650715618487, 0.135823209379734, 0.19592495316939, 0.173690687964229, 0.0913717625440195, 0.0263354828843205, 0.00355096863280593, 0.000161692411514196, 1.12413648461385e-06, 6.6476570903538e-11, 1.91835939267872e-25, 7.46331546018643e-17, 2.69941139487919e-12, 2.94971335091613e-09, 4.82549434656671e-07, 2.30935197163231e-05, 0.000454531606193092, 0.00446145479047788, 0.0244947586937454, 0.0804925705841717, 0.163929443999831, 0.208422026874339, 0.161869112793746, 0.072250280381281, 0.0163144715694865, 0.00142470430588958, 2.48846721001937e-05, 7.8479589003343e-09, 3.12491722628382e-28, 6.48359048184528e-19, 5.89156447172089e-14, 1.23466829154384e-10, 3.38251878112908e-08, 2.50688725197446e-06, 7.28439796343921e-05, 0.00102542981011513, 0.00794855187499195, 0.0366939321560038, 0.105506891504133, 0.192383287766186, 0.22058329406672, 0.152473523096729, 0.057657503566042, 0.00965642747815043, 0.000423741938819326, 7.12691335217918e-07, 3.78139779852995e-31, 4.18412506105408e-21, 9.5520699887977e-16, 3.83907042855332e-12, 1.76134295151759e-09, 2.02155135236513e-07, 8.67218521306025e-06, 0.000175081671570074, 0.00191605585059869, 0.0124261906870015, 0.0504440553316488, 0.131915665692651, 0.223298884304034, 0.239031225185529, 0.151371446573031, 0.0486198408758119, 0.00536014181142349, 4.80785699072463e-05, 3.20305396678047e-34, 1.8901304459147e-23, 1.08408265845501e-17, 8.35602833524979e-14, 6.42015739016121e-11, 1.14112388058993e-08, 7.22705674826684e-07, 2.09253856209143e-05, 0.000323315373195828, 0.00294564098590675, 0.0168825171267788, 0.0633174541304195, 0.158233534228757, 0.262308811505678, 0.278182706401026, 0.171359672352599, 0.047462340458999, 0.00227038570425922, 1.69572788634149e-37, 5.33652951698834e-26, 7.68966315508807e-20, 1.13672064043458e-15, 1.46260630556528e-12, 4.02588001700134e-10, 3.76421484028117e-08, 1.56309823673031e-06, 3.40976590374752e-05, 0.00043641697184249, 0.00353137974660857, 0.0189946166387211, 0.0700794235732519, 0.179908274902464, 0.31951872319949, 0.377471120583698, 0.262664897811688, 0.0670081708967356, 4.22463442971983e-41, 7.0903409549738e-29, 2.56680750429514e-22, 7.27693764407836e-18, 1.56801521874188e-14, 6.68389973695956e-12, 9.22631771612389e-10, 5.49465136732955e-08, 1.69224733091537e-06, 3.04273769431888e-05, 0.000347610359176246, 0.00268150546708616, 0.0146057404620968, 0.0580671437789247, 0.172704463439273, 0.391291040015883, 0.684062828118248, 0.930672644222882, 

0.937381754748496, 0.710603465112022, 0.430085007835775, 0.206399067994705, 0.0777355669344877, 0.0226488206372192, 0.00500686736677097, 0.000818472740527965, 9.56220820141343e-05, 7.62939453125e-06, 3.90917418345912e-07, 1.18127896314808e-08, 1.86391355572032e-10, 1.28067251840145e-12, 2.87512349458689e-15, 1.28803669582291e-18, 4.42317014314987e-23, 1.19947141139735e-29, 7.07407577956153e-42, 0.0607309009641049, 0.245226928615661, 0.372050600715626, 0.341279970502534, 0.214265972007425, 0.096093513415745, 0.0311176473148082, 0.00722285540034708, 0.00117627453439687, 0.00012969970703125, 9.18401036801413e-06, 3.86852681755294e-07, 8.66728230504488e-09, 8.72343346341457e-11, 3.01453903057611e-13, 2.25124629042678e-16, 1.47769152320348e-20, 1.00449298047906e-26, 3.15554459850891e-38, 0.00185158655107083, 0.0398244752743833, 0.151457499272372, 0.265555276337034, 0.277925058719239, 0.19185963690588, 0.0910098685502282, 0.0299954020104612, 0.0068092653723623, 0.00103759765625, 0.000101536169240262, 5.96183317553639e-06, 1.89662374504304e-07, 2.79626213101767e-09, 1.48739523039431e-11, 1.85164978847581e-14, 2.32313786886576e-18, 3.95863059342011e-24, 6.623995107816e-35, 3.52824169994275e-05, 0.00404214588053474, 0.0385353733499514, 0.129145443048194, 0.225310911306928, 0.239416005859823, 0.166360507787896, 0.0778539175211393, 0.0246360934221801, 0.00518798828125, 0.000701599386519998, 5.74240797744578e-05, 2.59393710714209e-06, 5.60206736412627e-08, 4.58682187591578e-10, 9.51863572674825e-13, 2.28268614973598e-16, 9.75041418886278e-22, 8.69051874775904e-32, 4.70620325051015e-07, 0.00028719173937299, 0.00686319597542514, 0.0439644129204287, 0.127860024178924, 0.20913214134244, 0.212867827353476, 0.141450437300094, 0.0623938040510056, 0.018157958984375, 0.00339356105310927, 0.000387174110478633, 2.48333746394131e-05, 7.85627745083791e-07, 9.90137264394848e-09, 3.4252210468577e-11, 1.57005715830303e-14, 1.68112184826438e-19, 7.98122287427791e-29, 4.66324608189209e-09, 1.51578361568009e-05, 0.000908026520244222, 0.0111180538564533, 0.0539004813892021, 0.13570432555793, 0.202336913737621, 0.190912085493168, 0.117386023423097, 0.047210693359375, 0.0121934734470804, 0.00193920569447321, 0.000176610834454474, 8.1844707660931e-06, 1.587757745402e-07, 9.15604259963379e-10, 8.02213611315723e-13, 2.1531814213431e-17, 5.44500747098962e-26, 3.55437001283272e-11, 6.15402307820939e-07, 9.24117752831567e-05, 0.00216278284646547, 0.0174786205139588, 0.0677365768578396, 0.147943831805664, 0.198207095241999, 0.169882234359526, 0.09442138671875, 0.0337020139878477, 0.0074713330091457, 0.000966174547191257, 6.55874941948866e-05, 1.95852771649239e-06, 1.88271096936194e-08, 3.15298015536915e-11, 2.12138113788699e-15, 2.85748638023528e-23, 2.12863690762232e-13, 1.96311473206247e-08, 7.38959681293744e-06, 0.000330568684019618, 0.0044533447027459, 0.0265654666502205, 0.0849930186155372, 0.161684959235349, 0.193172005006207, 0.14837646484375, 0.0731895238256067, 0.0226171021619482, 0.00415296710895466, 0.000412967738317665, 1.89819075274766e-05, 3.04175444104085e-07, 9.73681901813044e-10, 1.64218254517046e-13, 1.1782420216274e-20, 1.01404191680464e-15, 4.98135635972058e-10, 4.70034289256385e-07, 4.01907276560655e-05, 0.000902569885172882, 0.00828756639719672, 0.0388405179585093, 0.104914475528012, 0.174725293465533, 0.185470581054688, 0.126432101486488, 0.0544616999744346, 0.014199621191094, 0.00206836213923233, 0.000146340775663504, 3.90912912834337e-06, 2.39181907938419e-08, 1.0112057447181e-11, 3.86456142089698e-18, 3.86456142089698e-18, 1.0112057447181e-11, 2.39181907938419e-08, 3.90912912834337e-06, 0.000146340775663504, 0.00206836213923234, 0.014199621191094, 0.0544616999744345, 0.126432101486488, 0.185470581054688, 0.174725293465533, 0.104914475528012, 0.0388405179585093, 0.00828756639719671, 0.000902569885172885, 4.01907276560655e-05, 4.70034289256385e-07, 4.98135635972058e-10, 1.01404191680464e-15, 1.1782420216274e-20, 1.64218254517046e-13, 9.73681901813044e-10, 3.04175444104085e-07, 1.89819075274766e-05, 0.000412967738317666, 0.00415296710895467, 0.0226171021619482, 0.0731895238256067, 0.14837646484375, 0.193172005006207, 0.16168495923535, 0.0849930186155372, 0.0265654666502205, 0.00445334470274591, 0.000330568684019618, 7.38959681293744e-06, 1.96311473206247e-08, 2.12863690762232e-13, 2.85748638023528e-23, 2.12138113788699e-15, 3.15298015536915e-11, 1.88271096936194e-08, 1.95852771649238e-06, 6.55874941948868e-05, 0.000966174547191257, 0.00747133300914569, 0.0337020139878477, 0.09442138671875, 0.169882234359526, 0.198207095241999, 0.147943831805664, 0.0677365768578395, 0.0174786205139589, 0.00216278284646547, 9.24117752831567e-05, 6.15402307820939e-07, 3.55437001283272e-11, 5.44500747098962e-26, 2.1531814213431e-17, 8.02213611315723e-13, 9.15604259963379e-10, 1.58775774540199e-07, 8.18447076609312e-06, 0.000176610834454474, 0.00193920569447321, 0.0121934734470804, 0.047210693359375, 0.117386023423097, 0.190912085493168, 0.202336913737621, 0.13570432555793, 0.0539004813892022, 0.0111180538564533, 0.000908026520244222, 1.51578361568009e-05, 4.66324608189209e-09, 7.98122287427791e-29, 1.68112184826438e-19, 1.57005715830303e-14, 3.4252210468577e-11, 9.90137264394842e-09, 7.85627745083794e-07, 2.48333746394131e-05, 0.000387174110478632, 0.00339356105310927, 0.018157958984375, 0.0623938040510056, 0.141450437300094, 0.212867827353476, 0.209132141342439, 0.127860024178925, 0.0439644129204287, 0.00686319597542514, 0.00028719173937299, 4.70620325051015e-07, 8.69051874775904e-32, 9.75041418886278e-22, 2.28268614973598e-16, 9.51863572674825e-13, 4.58682187591575e-10, 5.6020673641263e-08, 2.59393710714209e-06, 5.74240797744576e-05, 0.000701599386519998, 0.00518798828125, 0.0246360934221801, 0.0778539175211393, 0.166360507787896, 0.239416005859823, 0.225310911306928, 0.129145443048194, 0.0385353733499514, 0.00404214588053474, 3.52824169994275e-05, 6.623995107816e-35, 3.95863059342011e-24, 2.32313786886576e-18, 1.85164978847581e-14, 1.4873952303943e-11, 2.79626213101768e-09, 1.89662374504304e-07, 5.96183317553637e-06, 0.000101536169240262, 0.00103759765625, 0.0068092653723623, 0.0299954020104612, 0.0910098685502282, 0.19185963690588, 0.277925058719239, 0.265555276337034, 0.151457499272372, 0.0398244752743833, 0.00185158655107083, 3.15554459850891e-38, 1.00449298047906e-26, 1.47769152320348e-20, 2.25124629042678e-16, 3.01453903057609e-13, 8.72343346341461e-11, 8.66728230504488e-09, 3.86852681755293e-07, 9.18401036801413e-06, 0.00012969970703125, 0.00117627453439687, 0.00722285540034708, 0.0311176473148082, 0.096093513415745, 0.214265972007425, 0.341279970502534, 0.372050600715626, 0.245226928615661, 0.0607309009641049, 7.07407577956153e-42, 1.19947141139735e-29, 4.42317014314987e-23, 1.28803669582291e-18, 2.87512349458687e-15, 1.28067251840145e-12, 1.86391355572032e-10, 1.18127896314807e-08, 3.90917418345912e-07, 7.62939453125e-06, 9.56220820141343e-05, 0.000818472740527965, 0.00500686736677097, 0.0226488206372192, 0.0777355669344877, 0.206399067994705, 0.430085007835775, 0.710603465112022, 0.937381754748496, 

0.943171193328388, 0.734158381965059, 0.466325683663904, 0.240352730848555, 0.0996885971872795, 0.0328888290132017, 0.00849837884737249, 0.00168533045134214, 0.00024978979240449, 2.67245587451907e-05, 1.9710849466528e-06, 9.41958791072484e-08, 2.67743722225522e-09, 4.0063458126592e-11, 2.63102339678068e-13, 5.6886529293672e-16, 2.47265780991905e-19, 8.29853141268126e-24, 2.21507071508325e-30, 1.29497048109361e-42, 0.055277629478792, 0.228951998004193, 0.36384910444781, 0.357436469760714, 0.246169057064362, 0.124376151525373, 0.0467719778244522, 0.0130622609526371, 0.00267078383404424, 0.000389725801240211, 3.906200835612e-05, 2.5460427682788e-06, 9.98352366478601e-08, 2.1037621073444e-09, 2.01063782858269e-11, 6.65762459929211e-14, 4.80520654782788e-17, 3.07373986902099e-21, 2.05272495405409e-27, 6.38555763204517e-39, 0.00152457698274717, 0.033600069815233, 0.133596275478869, 0.250143791905971, 0.286063537695291, 0.221343556565746, 0.1211368979979, 0.0476422988553366, 0.0134382852727838, 0.00267453841153034, 0.000364287996798491, 3.23847501827383e-05, 1.75181996797914e-06, 5.19859385585209e-08, 7.23076178185235e-10, 3.6666565658251e-12, 4.39441600040295e-15, 5.35764636079587e-19, 8.95189529627805e-25, 1.48176337035285e-35, 2.62802398347941e-05, 0.00308188152273696, 0.0306582533178699, 0.109410905718061, 0.207764606401541, 0.246193549930566, 0.196086267075737, 0.10860431477231, 0.0422599511730377, 0.0114714558479128, 0.00212331863804863, 0.00025745149921111, 1.9212112021098e-05, 8.02888370307991e-07, 1.62522792527085e-08, 1.26212155056191e-10, 2.51171461002632e-13, 5.83661430181709e-17, 2.43994054212114e-22, 2.14901228310602e-32, 3.17108095893499e-07, 0.000197874458020234, 0.00492491235398211, 0.0334988221741771, 0.105627904956614, 0.191683396966594, 0.222185620895251, 0.173300370246287, 0.0930276747238825, 0.0344418345581812, 0.00866330336111791, 0.00143267716596326, 0.000147488713760871, 8.68005516751631e-06, 2.55706953449443e-07, 3.04109628446766e-09, 1.00493380625522e-11, 4.45088103056147e-15, 4.65523417827857e-20, 2.18170979235947e-29, 2.84243563436337e-09, 9.43775808981182e-06, 0.000587698939863769, 0.00761910160652801, 0.039892483128302, 0.110865808252828, 0.187020848759106, 0.205426849135015, 0.152125018491606, 0.0768173495026363, 0.0262577298752758, 0.005922520282984, 0.000841100264899328, 6.97100039213186e-05, 2.98865719635508e-06, 5.44332747370432e-08, 2.98682600824673e-10, 2.52136825523834e-13, 6.59795160570483e-18, 1.64535785038004e-26, 1.9598850312283e-11, 3.46261807585481e-07, 5.39470817083879e-05, 0.00133301378567335, 0.0115893778316623, 0.0493250353851212, 0.121093475909033, 0.187314573160181, 0.191357624076423, 0.131791987637816, 0.0612191757367838, 0.0188330830697612, 0.00368971990400638, 0.000430649925687471, 2.68699165101448e-05, 7.49471982226074e-07, 6.82871582647796e-09, 1.09871036851978e-11, 7.19338601934088e-16, 9.54509822909074e-24, 1.06178161787806e-13, 9.98171100719162e-09, 3.89086045129392e-06, 0.000183244169815058, 0.0026454150684112, 0.0172425634550829, 0.0616050219821863, 0.134199401366721, 0.18912787616012, 0.177657418443912, 0.112145649116946, 0.0470544754913509, 0.0127175565590994, 0.0020903465670882, 0.00018981091373385, 8.10794868108739e-06, 1.22668429585319e-07, 3.76179231404948e-10, 6.16200798445635e-14, 4.35075958878323e-21, 4.57567507016447e-16, 2.28886806541823e-10, 2.23222887226221e-07, 2.00373857314796e-05, 0.000480333516886907, 0.00479459168901646, 0.0249302627714123, 0.0764794855541191, 0.148689632824175, 0.1904991551951, 0.163415312224652, 0.0935181311534234, 0.0348681836196219, 0.0080710043675515, 0.00106657502635359, 6.97721246695741e-05, 1.75283864084657e-06, 1.02452314608281e-08, 4.19881282246462e-12, 1.57748463489653e-18, 1.5774846348963e-18, 4.19881282246451e-12, 1.02452314608281e-08, 1.75283864084656e-06, 6.97721246695741e-05, 0.0010665750263536, 0.0080710043675515, 0.0348681836196219, 0.0935181311534234, 0.163415312224652, 0.1904991551951, 0.148689632824175, 0.0764794855541192, 0.0249302627714123, 0.00479459168901645, 0.000480333516886907, 2.00373857314797e-05, 2.23222887226221e-07, 2.28886806541829e-10, 4.57567507016507e-16, 4.35075958878253e-21, 6.16200798445616e-14, 3.76179231404948e-10, 1.22668429585318e-07, 8.10794868108739e-06, 0.000189810913733851, 0.0020903465670882, 0.0127175565590994, 0.0470544754913509, 0.112145649116946, 0.177657418443912, 0.18912787616012, 0.134199401366721, 0.0616050219821863, 0.0172425634550828, 0.0026454150684112, 0.000183244169815059, 3.89086045129392e-06, 9.98171100719183e-09, 1.06178161787818e-13, 9.54509822908904e-24, 7.19338601934063e-16, 1.09871036851978e-11, 6.82871582647791e-09, 7.49471982226074e-07, 2.68699165101449e-05, 0.000430649925687471, 0.00368971990400638, 0.0188330830697612, 0.0612191757367838, 0.131791987637816, 0.191357624076423, 0.187314573160181, 0.121093475909033, 0.0493250353851211, 0.0115893778316623, 0.00133301378567336, 5.39470817083879e-05, 3.46261807585487e-07, 1.95988503122849e-11, 1.64535785037972e-26, 6.59795160570459e-18, 2.