/*###############################################################################
# Linux Management Providers (LMP), Power Supply provider package
# Copyright (C) 2009 Shakhrom RUSTAMOV, TUIT <shahrombek@gmail.com>
#
# This program is being developed under the "OpenDRIM" project.
# The "OpenDRIM" project web page: http://opendrim.sourceforge.net
# The "OpenDRIM" project mailing list: opendrim@googlegroups.com
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; version 2
# of the License.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#################################################################################

#################################################################################
# To contributors, please leave your contact information in this section
# AND comment your changes in the source code.
#
# Modified by <Author(s)>, <Affiliation>, <Year>
###############################################################################*/

#ifndef OPENDRIM_POWERSUPPLYCONFORMSTOPROFILEACCESS_H_
#define OPENDRIM_POWERSUPPLYCONFORMSTOPROFILEACCESS_H_

#include "PowerSupply_Common.h"

#include "OpenDRIM_PowerSupplyConformsToProfile.h"
#include "assocOpenDRIM_PowerSupplyConformsToProfile.h"

int PowerSupply_OpenDRIM_PowerSupplyConformsToProfile_load(const CMPIBroker* broker, string& errorMessage);

int PowerSupply_OpenDRIM_PowerSupplyConformsToProfile_unload(string& errorMessage);

int PowerSupply_OpenDRIM_PowerSupplyConformsToProfile_retrieve(const CMPIBroker* broker, const CMPIContext* ctx, vector<OpenDRIM_PowerSupplyConformsToProfile>& instances, const char** properties, string& errorMessage, const string& discriminant);

int PowerSupply_OpenDRIM_PowerSupplyConformsToProfile_getInstance(const CMPIBroker* broker, const CMPIContext* ctx, OpenDRIM_PowerSupplyConformsToProfile& instance, const char** properties, string& errorMessage);

int PowerSupply_OpenDRIM_PowerSupplyConformsToProfile_setInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_PowerSupplyConformsToProfile& newInstance, const OpenDRIM_PowerSupplyConformsToProfile& oldInstance, const char** properties, string& errorMessage);

int PowerSupply_OpenDRIM_PowerSupplyConformsToProfile_createInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_PowerSupplyConformsToProfile& instance, string& errorMessage);

int PowerSupply_OpenDRIM_PowerSupplyConformsToProfile_deleteInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_PowerSupplyConformsToProfile& instance, string& errorMessage);

int PowerSupply_OpenDRIM_PowerSupplyConformsToProfile_associatorConformantStandardToManagedElement(const CMPIBroker* broker, const CMPIContext* ctx, const Instance& ConformantStandard_instance, const char** properties, vector<Instance>& ManagedElement_associatedInstances, string& errorMessage, const string& discriminant);

int PowerSupply_OpenDRIM_PowerSupplyConformsToProfile_associatorManagedElementToConformantStandard(const CMPIBroker* broker, const CMPIContext* ctx, const Instance& ManagedElement_instance, const char** properties, vector<Instance>& ConformantStandard_associatedInstances, string& errorMessage, const string& discriminant);

int PowerSupply_OpenDRIM_PowerSupplyConformsToProfile_referenceConformantStandardToManagedElement(const CMPIBroker* broker, const CMPIContext* ctx, const Instance& ConformantStandard_instance, const vector<Instance>& ManagedElement_instances, vector<OpenDRIM_PowerSupplyConformsToProfile>& OpenDRIM_PowerSupplyConformsToProfile_instances, const char** properties, string& errorMessage, const string& discriminant);

int PowerSupply_OpenDRIM_PowerSupplyConformsToProfile_referenceManagedElementToConformantStandard(const CMPIBroker* broker, const CMPIContext* ctx, const Instance& ManagedElement_instance, const vector<Instance>& ConformantStandard_instances, vector<OpenDRIM_PowerSupplyConformsToProfile>& OpenDRIM_PowerSupplyConformsToProfile_instances, const char** properties, string& errorMessage, const string& discriminant);

int PowerSupply_OpenDRIM_PowerSupplyConformsToProfile_populate(OpenDRIM_PowerSupplyConformsToProfile& instance, string& errorMessage);

#endif /*OPENDRIM_POWERSUPPLYCONFORMSTOPROFILEACCESS_H_*/
