/*
 *  Copyright (c) 2009 Cyrille Berger <cberger@cberger.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation;
 * either version 2, or (at your option) any later version of the License.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

#include "OpenCTL/templatecompiler/TemplateLexer_p.h"
#include "GTLCore/Token_p.h"

#define TEST_FOR_TOKEN_STRING( str ) \
  { \
    GTLCore::Token tok = lng.nextToken(); \
    GTLTEST_CHECK_EQUAL(tok.type, GTLCore::Token::STRING_CONSTANT ); \
    GTLTEST_CHECK_EQUAL(tok.string, str); \
  }

class TestTemplateLexer : public GTLTest::Case {
  public:
    TestTemplateLexer() : GTLTest::Case("TemplateLexer") {}
    virtual void runTest()
    {
      std::istringstream iss("I am a string @hello(world) kikoo @allchannels@colorchannels@alphachannel(@alpha)@type@min@max@unit@var@out@output@in@input@include=");
      OpenCTL::TemplateLexer lng(&iss);
      TEST_FOR_TOKEN_STRING("I am a string ");
      TEST_FOR_TOKEN_STRING("@hello");
      TEST_FOR_TOKEN(STARTBRACKET);
      TEST_FOR_TOKEN_STRING("world");
      TEST_FOR_TOKEN(ENDBRACKET);
      TEST_FOR_TOKEN_STRING(" kikoo ");
      TEST_FOR_TOKEN(ALLCHANNELS);
      TEST_FOR_TOKEN(COLORCHANNELS);
      TEST_FOR_TOKEN(ALPHACHANNEL);
      TEST_FOR_TOKEN(STARTBRACKET);
      TEST_FOR_TOKEN(ALPHA);
      TEST_FOR_TOKEN(ENDBRACKET);
      TEST_FOR_TOKEN(TYPE);
      TEST_FOR_TOKEN(MIN);
      TEST_FOR_TOKEN(MAX);
      TEST_FOR_TOKEN(UNIT);
      TEST_FOR_TOKEN(VAR);
      TEST_FOR_TOKEN(OUTPUT);
      TEST_FOR_TOKEN(OUTPUT);
      TEST_FOR_TOKEN(INPUT);
      TEST_FOR_TOKEN(INPUT);
      TEST_FOR_TOKEN(INCLUDE);
      TEST_FOR_TOKEN(EQUAL);
    }
};
