//                                               -*- C++ -*-
/**
 *  @file  KrigingResult.hxx
 *  @brief The result of a chaos expansion
 *
 *  Copyright 2005-2015 Airbus-EDF-IMACS-Phimeca
 *
 *  This library is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  along with this library.  If not, see <http://www.gnu.org/licenses/>.
 *
 *  @author dutka
 *  @date   2008-05-21 17:44:02 +0200 (Wed, 21 May 2008)
 */
#ifndef OPENTURNS_KRIGINGRESULT_HXX
#define OPENTURNS_KRIGINGRESULT_HXX

#include "MetaModelResult.hxx"
#include "CovarianceModel.hxx"
#include "NumericalSample.hxx"
#include "Collection.hxx"
#include "PersistentCollection.hxx"
#include "NumericalMathFunction.hxx"
#include "Basis.hxx"

BEGIN_NAMESPACE_OPENTURNS

/**
 * @class KrigingResult
 *
 * The result of a chaos expansion
 */

class OT_API KrigingResult
  : public MetaModelResult
{
  CLASSNAME;

public:

  typedef Collection< CovarianceModel >           CovarianceModelCollection;
  typedef PersistentCollection< CovarianceModel > CovarianceModelPersistentCollection;

  // friend class Factory<KrigingResult>;

  /** Default constructor */
  KrigingResult();

  /** Parameter constructor */
  KrigingResult(const NumericalSample & inputData,
                const NumericalSample & outputData,
                const NumericalMathFunction & metaModel,
                const NumericalPoint & residuals,
                const NumericalPoint & relativeErrors,
                const Basis & basis,
                const NumericalSample & trendCoefficients,
                const CovarianceModelCollection & covarianceModels,
                const NumericalSample & covarianceCoefficients);

  /** Virtual constructor */
  virtual KrigingResult * clone() const;

  /** String converter */
  virtual String __repr__() const;
  virtual String __str__(const String & offset = "") const;

  /** Trend basis accessor */
  virtual Basis getBasis() const;

  /** Trend coefficients accessor */
  virtual NumericalSample getTrendCoefficients() const;

  /** Conditional covariance models accessor */
  virtual CovarianceModelCollection getCovarianceModels() const;

  /** Process coefficients accessor */
  virtual NumericalSample getCovarianceCoefficients() const;

  /** Method save() stores the object through the StorageManager */
  virtual void save(Advocate & adv) const;

  /** Method load() reloads the object from the StorageManager */
  virtual void load(Advocate & adv);


protected:

private:

  /** The trend basis */
  Basis basis_;

  /** The trend coefficients */
  NumericalSample trendCoefficients_;

  /** The marginal covariance models */
  CovarianceModelPersistentCollection covarianceModels_;

  /** The covariance coefficients */
  NumericalSample covarianceCoefficients_;

} ; /* class KrigingResult */


END_NAMESPACE_OPENTURNS

#endif /* OPENTURNS_KRIGINGRESULT_HXX */
