#
# This script was written by Georges Dagousset <georges.dagousset@alert4web.com>
#
# See the Nessus Scripts License for details
#

if(description)
{
   script_id(10760);
   script_cve_id("CVE-2001-1424", "CVE-2001-1425");
   script_bugtraq_id(2568);
   script_version ("$Revision: 7189 $");
   script_tag(name:"cvss_base", value:"7.5");
   script_tag(name:"risk_factor", value:"High");
   name = "Alcatel ADSL modem with firewalling off";
   script_name(name);
 
   desc = "
On the Alcatel Speed Touch Pro ADSL modem, a protection mechanism 
feature is available to ensure that nobody can gain remote access 
to the modem (via the WAN/DSL interface). This mechanism guarantees 
that nobody from outside your network can access the modem and 
change its settings.

The protection is currently not activated on your system.

Solution : Telnet to this modem and adjust the security
settings as follows:
=> ip config firewalling on
=> config save 

More information : http://www.alcatel.com/consumer/dsl/security.htm

Risk factor : High";


   script_description(desc);
 
   summary = "Checks Alcatel ADSL modem protection";
   script_summary(summary);
 
   script_category(ACT_GATHER_INFO);
 
   script_copyright("This script is Copyright (C) 2001 Alert4Web.com");
   script_family("General");
   script_require_ports(23);
 
   exit(0);
}

include('global_settings.inc');

if ( ! thorough_tests && ! ereg(pattern:"^10\.0\.0\..*", string:get_host_ip())) exit(0);

port = 23; # alcatel's ADSL modem telnet module can't bind to something else

if(get_port_state(port))
{
 soc = open_sock_tcp(port);
 if(soc)
 {
   r = recv(socket:soc, length:160);
   if("User : " >< r)
   {
     send(socket:soc, data:string("\r\n"));
     r = recv(socket:soc, length:2048);
     if("ALCATEL ADSL" >< r)
     {
       s = string("ip config\r\n");
       send(socket:soc, data:s);
       r = recv(socket:soc, length:2048);
       if("Firewalling off" >< r)security_hole(port);
     }
   }
   close(soc);
 }
}
