# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 597-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(53288);
 script_cve_id("CVE-2004-1012", "CVE-2004-1013");
 script_version ("$");
 script_tag(name:"cvss_base", value:"10.0");
 script_tag(name:"risk_factor", value:"Critical");
 name = "Debian Security Advisory DSA 597-1 (cyrus-imapd)";
 script_name(name);

 desc = "The remote host is missing an update to cyrus-imapd
announced via advisory DSA 597-1.

Stefan Esser discovered several security related problems in the Cyrus
IMAP daemon.  Due to a bug in the command parser it is possible to
access memory beyond the allocated buffer in two places which could
lead to the execution of arbitrary code.

For the stable distribution (woody) these problems have been fixed in
version 1.5.19-9.2

For the unstable distribution (sid) these problems have been fixed in
version 2.1.17-1.

We recommend that you upgrade your cyrus-imapd package immediately.


Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%20597-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 597-1 (cyrus-imapd)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"cyrus-admin", ver:"1.5.19-9.2", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"cyrus-common", ver:"1.5.19-9.2", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"cyrus-dev", ver:"1.5.19-9.2", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"cyrus-imapd", ver:"1.5.19-9.2", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"cyrus-nntp", ver:"1.5.19-9.2", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"cyrus-pop3d", ver:"1.5.19-9.2", rls:"DEB3.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
