# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 778-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(55116);
 script_cve_id("CVE-2005-2556", "CVE-2005-2557");
 script_version ("$");
 script_tag(name:"cvss_base", value:"7.5");
 script_tag(name:"risk_factor", value:"High");
 name = "Debian Security Advisory DSA 778-1 (mantis)";
 script_name(name);

 desc = "The remote host is missing an update to mantis
announced via advisory DSA 778-1.

Two security related problems have been discovered in Mantis, a
web-based bug tracking system.  The Common Vulnerabilities and
Exposures project identifies the following problems:

CVE-2005-2556

A remote attacker could insert arbitrary SQL code into SQL
statements.

CVE-2005-2557

A remote attacker was able to insert arbitrary HTML code bug
reports, hence, cross site scripting.

The old stable distribution (woody) does not seem to be affected by
these problems.

For the stable distribution (sarge) these problems have been fixed in
version 0.19.2-4.

For the unstable distribution (sid) these problems have been fixed in
version 0.19.2-4.

We recommend that you upgrade your mantis package.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%20778-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 778-1 (mantis)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"mantis", ver:"0.19.2-4", rls:"DEB3.1")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
