# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory FEDORA-2009-3711 (udev)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(63838);
 script_cve_id("CVE-2009-1185", "CVE-2009-1186");
 script_version ("$");
 script_tag(name:"cvss_base", value:"7.2");
 script_tag(name:"risk_factor", value:"High");
 name = "Fedora Core 10 FEDORA-2009-3711 (udev)";
 script_name(name);

 desc = "The remote host is missing an update to udev
announced via advisory FEDORA-2009-3711.

The udev package contains an implementation of devfs in
userspace using sysfs and netlink.

Update Information:

udev provides a user-space API and implements a dynamic device directory,
providing only the devices present on the system. udev replaces devfs in order
to provide greater hot plug functionality. Netlink is a datagram oriented
service, used to transfer information between kernel modules and user-space
processes.

It was discovered that udev did not properly check the origin of
Netlink messages. A local attacker could use this flaw to gain root privileges
via a crafted Netlink message sent to udev, causing it to create a world-
writable block device file for an existing system block device (for example, the
root file system). (CVE-2009-1185)

An integer overflow flaw, potentially
leading to heap-based buffer overflow was found in one of the utilities
providing functionality of the udev device information interface. An attacker
could use this flaw to cause a denial of service, or possibly, to execute
arbitrary code by providing a specially-crafted arguments as input to this
utility. (CVE-2009-1186)

Thanks to Sebastian Krahmer of the SUSE Security Team for responsibly
reporting this flaw.  Users of udev are advised to upgrade to these
updated packages, which contain a backported patch to correct this issue.
After installing the update, the udevd daemon will be restarted automatically.

ChangeLog:

* Thu Apr 16 2009 Harald Hoyer  127-5
- fix for CVE-2009-1186
* Wed Apr 15 2009 Harald Hoyer  127-4
- fix for CVE-2009-1185

References:

[ 1 ] Bug #495051 - CVE-2009-1185 udev: Uncheck origin of NETLINK messages
https://bugzilla.redhat.com/show_bug.cgi?id=495051
[ 2 ] Bug #495052 - CVE-2009-1186 udev: Buffer overflow in path encoding routine
https://bugzilla.redhat.com/show_bug.cgi?id=495052

Solution: Apply the appropriate updates.

This update can be installed with the yum update program.  Use 
su -c 'yum update udev' at the command line.
For more information, refer to Managing Software with yum,
available at http://docs.fedoraproject.org/yum/.

https://secure1.securityspace.com/smysecure/catid.html?in=FEDORA-2009-3711

Risk factor : High";

 script_description(desc);

 summary = "Fedora Core 10 FEDORA-2009-3711 (udev)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 family = "Fedora Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/rpms");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-rpm.inc");
vuln = 0;
if(isrpmvuln(pkg:"libudev-devel", rpm:"libudev-devel~127~5.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libudev0", rpm:"libudev0~127~5.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libvolume_id", rpm:"libvolume_id~127~5.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libvolume_id-devel", rpm:"libvolume_id-devel~127~5.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"udev", rpm:"udev~127~5.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"udev-static", rpm:"udev-static~127~5.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"udev-debuginfo", rpm:"udev-debuginfo~127~5.fc10", rls:"FC10")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
