#
#VID 2a6a966f-1774-11df-b5c1-0026189baca3
# OpenVAS Vulnerability Test
# $
# Description: Auto generated from VID 2a6a966f-1774-11df-b5c1-0026189baca3
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2010 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisories, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(66850);
 script_cve_id("CVE-2010-0562");
 script_bugtraq_id(38088);
 script_version ("$Revision$");
 script_tag(name:"cvss_base", value:"6.8");
 script_tag(name:"risk_factor", value:"High");
 script_name("FreeBSD Ports: fetchmail");

 desc = "The remote host is missing an update to the system
as announced in the referenced advisory.

The following package is affected: fetchmail

CVE-2010-0562
The sdump function in sdump.c in fetchmail 6.3.11, 6.3.12, and 6.3.13,
when running in verbose mode on platforms for which char is signed,
allows remote attackers to cause a denial of service (application
crash) or possibly execute arbitrary code via an SSL X.509 certificate
containing non-printable characters with the high bit set, which
triggers a heap-based buffer overflow during escaping.

Solution:
Update your system with the appropriate patches or
software upgrades.

http://www.fetchmail.info/fetchmail-SA-2010-01.txt
https://lists.berlios.de/pipermail/fetchmail-announce/2010-February/000073.html
http://www.vuxml.org/freebsd/2a6a966f-1774-11df-b5c1-0026189baca3.html

Risk factor : High";

 script_description(desc);

 script_summary("FreeBSD Ports: fetchmail");

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2010 E-Soft Inc. http://www.securityspace.com");
 script_family("FreeBSD Local Security Checks");
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/freebsdrel");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-bsd.inc");
vuln = 0;
bver = portver(pkg:"fetchmail");
if(!isnull(bver) && revcomp(a:bver, b:"6.3.11")>=0 && revcomp(a:bver, b:"6.3.14")<0) {
    security_note(0, data:"Package fetchmail version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
