###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_ibm_db2_mult_vuln_lin_oct09.nasl 5093 2009-10-05 16:03:51Z oct $
#
# IBM DB2 Multiple Vulnerabilities - Oct09 (Linux)
#
# Authors:
# Antu Sanadi <santu@secpod.com>
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(801001);
  script_version("$Revision: 1.0 $");
  script_tag(name:"cvss_base", value:"7.5");
  script_tag(name:"risk_factor", value:"High");
  script_cve_id("CVE-2009-3471", "CVE-2009-3472");
  script_bugtraq_id(36540);
  script_name("IBM DB2 Multiple Vulnerabilities - Oct09 (Linux)");

  desc = "
  Overview: The host is installed with IBM DB2 and is prone to multiple
  vulnerabilities.

  Vulnerability Insight:
  - An unspecified error exists related to a table function when the definer
    loses required privileges.
  - An unspecified error can be exploited to insert, update, or delete rows in
    a table without having required privileges.

  Impact: Unknow impact.

  Impact Level: System/Application

  Affected Software/OS:
  IBM DB2 version 8 prior to Fixpak 18
  IBM DB2 version 9.1 prior to Fixpak 8
  IBM DB2 version 9.5 prior to Fixpak 4

  Fix:Update DB2 8 Fixpak 18 or 9.1 Fixpak 8 or 9.5 Fixpak 4 or later.
  http://www-01.ibm.com/support/docview.wss?rs=71&uid=swg27007053

  References:
  http://secunia.com/advisories/36890
  http://www-01.ibm.com/support/docview.wss?uid=swg21403619
  http://www-01.ibm.com/support/docview.wss?uid=swg21386689

  CVSS Score:
    CVSS Base Score      : 7.5 (AV:N/AC:L/Au:NR/C:P/I:P/A:P)
    CVSS Temporal Score  : 5.5
  Risk factor: High";

  script_description(desc);
  script_summary("Check for the version of IBM DB2");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("General");
  script_dependencies("secpod_ibm_db2_detect_linux_900217.nasl");
  script_require_keys("Linux/IBM-db2/Ver");
  exit(0);
}


include("version_func.inc");

ibmVer = get_kb_item("Linux/IBM-db2/Ver");
if(!ibmVer){
  exit(0);
}

# Check for IBM DB2 version 8 before FP18, 9.1 before FP8, 9.5 before FP4
# 9.1 FP8 =>9.1.0.8, 9.5 FP4 =>9.5.0.4, 8 FP18 =>8.1.18
if(version_in_range(version:ibmVer, test_version:"8.0", test_version2:"8.1.17")||
   version_in_range(version:ibmVer, test_version:"9.1", test_version2:"9.1.0.7")||
   version_in_range(version:ibmVer, test_version:"9.5", test_version2:"9.5.0.3")){
  security_hole(0);
}
