##############################################################################
#
#  dotProject Multiple XSS and SQL Injection Vulnerabilities 
#
#  Copyright: SecPod
#
#  Date Written: 2008/09/02
#
#  Revision: 1.1
#
#  Log: ssharath
#  Issue #0158
#  ------------------------------------------------------------------------
#  This program was written by SecPod and is licensed under the GNU GPL 
#  license. Please refer to the below link for details,
#  http://www.gnu.org/licenses/gpl.html
#  This header contains information regarding licensing terms under the GPL, 
#  and information regarding obtaining source code from the Author. 
#  Consequently, pursuant to section 3(c) of the GPL, you must accompany the 
#  information found in this header with any distribution you make of this 
#  Program.
#  ------------------------------------------------------------------------
##############################################################################

if(description)
{
 script_id(900116);
 script_cve_id("CVE-2008-3886");
 script_bugtraq_id(30924);
 script_copyright("Copyright (C) 2008 SecPod");
 script_version("Revision: 1.1 ");
 script_tag(name:"cvss_base", value:"7.1");
 script_tag(name:"risk_factor", value:"High");
 script_category(ACT_GATHER_INFO);
 script_family("Web application abuses");
 script_name("dotProject Multiple XSS and SQL Injection Vulnerabilities");
 script_summary("Check for the vulnerable version of dotProject");
 desc = "
 Overview : The host is running dotProject, which is prone to multiple Cross
 Site Scripting and SQL injection vulnerabilities.

 Vulnerability Insight :
        The flaws exists due to, 
        - improper sanitisation of input value passed to inactive, date,
          calendar, callback and day_view, public, dialog and ticketsmith
          parameters in index.php before being returned to the user.
        - failing to validate the input passed to the tab and user_id parameter
	  in index.php file, before being used in SQL queries.
 
        Impact: Successful exploitation will allow attackers to steal cookie
        based authentication credentials of user and administrator, and can
        also execute arbitrary code in the browser of an unsuspecting user
        in the context of an affected site.

 Impact Level : Application

 Affected Software/OS: 
        dotProject version 2.1.2 and prior on all platform.

 Fix : Upgrade to dotProject version 2.1.3 or later
 For updates check, http://www.dotproject.net/

 References : http://secunia.com/advisories/31681/
 http://packetstorm.linuxsecurity.com/0808-exploits/dotproject-sqlxss.txt

 CVSS Score :
        CVSS Base Score     : 7.1 (AV:N/AC:M/Au:NR/C:C/I:N/A:N)
        CVSS Temporal Score : 6.4
 Risk factor : High";

 script_description(desc);
 script_dependencies("http_version.nasl");
 script_require_ports("Services/www", 80);
 exit(0);
}


 include("http_func.inc");
 include("http_keepalive.inc");

 port = get_http_port(default:80);
 if(!port){
        exit(0);
 }

 foreach path (make_list("/xampp/dotproject_2_1_2/dotproject", cgi_dirs()))
 {
        sndReq = http_get(item:string(path, "/index.php"), port:port);
        rcvRes = http_keepalive_send_recv(port:port, data:sndReq);
        if(rcvRes == NULL){
                exit(0);
        }

	if(egrep(pattern:"dotProject", string:rcvRes) &&
           egrep(pattern:"^HTTP/.* 200 OK", string:rcvRes))
	{
		if(safe_checks())
		{
			if(egrep(pattern:"Version ([01]\..*|2\.(0(\..*)?|" +
					 "1(\.[0-2])?))[^.0-9]", string:rcvRes)){
				security_warning(port);
			}
			exit(0);
		}

                sndReq = http_get(item:string(path, "/index.php?m=public&a=" +
				  "calendar&dialog=1&callback=setCalendar%22" +
				  "%3E%3Cimg/src/onerror=alert(101010)%3E"),
				  port:port);
                rcvRes = http_keepalive_send_recv(port:port, data:sndReq, bodyonly:1);
                if(rcvRes == NULL){
                        exit(0);
                }

                if('alert(101010)%3E' >< rcvRes){
                        security_warning(port);
                }
                exit(0);
       }
 }
