##############################################################################
#
#  SMB accessible registry
#
#  Copyright: SecPod
#
#  Date Written: 2008/09/09
#
#  Revision: 1.1
#
#  Log: schandan
#  Issue #0003
#  ------------------------------------------------------------------------
#  This program was written by SecPod and is licensed under the GNU GPL 
#  license. Please refer to the below link for details,
#  http://www.gnu.org/licenses/gpl.html
#  This header contains information regarding licensing terms under the GPL, 
#  and information regarding obtaining source code from the Author. 
#  Consequently, pursuant to section 3(c) of the GPL, you must accompany the 
#  information found in this header with any distribution you make of this 
#  Program.
#  ------------------------------------------------------------------------
##############################################################################

if(description)
{
 script_id(10400);
 script_version ("Revision: 1.1 ");
 script_tag(name:"risk_factor", value:"None");
 script_category(ACT_GATHER_INFO);
 script_family("Windows");
 script_name("SMB accessible registry");
 script_summary("Determines whether the remote registry is accessible");
 desc = "
 The remote registry can be accessed remotely using the login/password 
 credentials.

 Risk factor : None";

 script_description(desc);
 script_category(ACT_GATHER_INFO);
 script_copyright("Copyright (C) 2008 SecPod");
 script_dependencies("netbios_name_get.nasl", "smb_login.nasl");
 script_require_keys("SMB/transport", "SMB/name", "SMB/login", "SMB/password");
 script_exclude_keys("SMB/samba");
 script_require_ports(139, 445);
 exit(0);
}


 include("smb_nt.inc");

 port = kb_smb_transport();
 if(!port){
	port = 139;
 }
		 
 samba = get_kb_item("SMB/samba");
 if(samba){
	exit(0);
 }

 name = kb_smb_name();
 if(!name){
	exit(0);
 }

 if(!get_port_state(port)){
	exit(0);
 }

 login = kb_smb_login();
 pass  = kb_smb_password();

 if(!login)login = "";
 if(!pass) pass = "";

 dom = kb_smb_domain();
	  
 soc = open_sock_tcp(port);
 if(!soc){
	exit(0);
 }

 r = smb_session_request(soc:soc,  remote:name);
 if(!r){
	close(soc);
	exit(0);
 }

 prot = smb_neg_prot(soc:soc);
 if(!prot){
	close(soc);
	exit(0);
 }

 r = smb_session_setup(soc:soc, login:login, password:pass, domain:dom, prot:prot);
 if(!r){
	close(soc);
	exit(0);
 }

 uid = session_extract_uid(reply:r);
 r = smb_tconx(soc:soc, name:name, uid:uid, share:"IPC$");
 if(!r){
	close(soc);
	exit(0);
 }

 tid = tconx_extract_tid(reply:r);
 if(!tid){
	close(soc);
	exit(0);
 }

  r = smbntcreatex(soc:soc, uid:uid, tid:tid, name:"\winreg");
 if(!r)
 {
        close(soc);
        exit(0);
 }

 pipe = smbntcreatex_extract_pipe(reply:r);
 if (!pipe)
 {
        close(soc);
        exit(0);
 }

 r = pipe_accessible_registry(soc:soc, uid:uid, tid:tid, pipe:pipe);
 close(soc);

 if(!r)
 {
	security_note(data:"It was not possible to connect to PIPE\winreg on "+
                           "the remote host. If you\nintend to use OpenVAS to "+
                           "perform registry-based checks, the registry "+
                           "checks\nwill not work because the 'Remote "+
                           "Registry Access' service (winreg) has been\n" +
                           "disabled on the remote host");
        exit(0);
 }

 else
 {
	set_kb_item(name:"SMB/registry_access", value:TRUE);
        set_kb_item(name:"SMB/registry_full_access", value:TRUE);
 }
