/*
 * Copyright (c) 2012 Stanford University
 *
 * Permission to use, copy, modify, and distribute this software for any
 * purpose with or without fee is hereby granted, provided that the above
 * copyright notice and this permission notice appear in all copies.
 *
 * THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR(S) DISCLAIM ALL WARRANTIES
 * WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL AUTHORS BE LIABLE FOR
 * ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
 * ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
 * OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 */

#ifndef __ORI_VERSION_H__
#define __ORI_VERSION_H__

#define STR_HELPER(x)  #x
#define STR(x) STR_HELPER(x)

#define ORI_MAJOR_VERSION       0
#define ORI_MINOR_VERSION       8
#define ORI_PATCH_VERSION       1
#define ORI_VERSION_STR \
    "Version " STR(ORI_MAJOR_VERSION) "." STR(ORI_MINOR_VERSION) "." STR(ORI_PATCH_VERSION)

#define ORI_FS_MAJOR_VERSION    1
#define ORI_FS_MINOR_VERSION    1

#define ORI_FS_VERSION_STR \
    "ORI" STR(ORI_FS_MAJOR_VERSION) "." STR(ORI_FS_MINOR_VERSION)

#endif /* __ORI_VERSION_H__ */

