# Try to find the OpenBabel library
#  OPENBABEL_FOUND - system has OpenBabel lib
#  OpenBabel_INCLUDE_DIRS - the include directories needed
#  OpenBabel_LIBRARIES - libraries needed

FIND_PATH(OPENBABEL_INCLUDE_DIR NAMES openbabel/mol.h PATH_SUFFIXES openbabel-2.0)
FIND_LIBRARY(OPENBABEL_LIBRARY NAMES openbabel)

SET(OpenBabel_INCLUDE_DIRS ${OPENBABEL_INCLUDE_DIR})
SET(OpenBabel_LIBRARIES ${OPENBABEL_LIBRARY})

INCLUDE(FindPackageHandleStandardArgs)
FIND_PACKAGE_HANDLE_STANDARD_ARGS(OpenBabel DEFAULT_MSG OPENBABEL_LIBRARY OPENBABEL_INCLUDE_DIR)

MARK_AS_ADVANCED(OPENBABEL_INCLUDE_DIR OPENBABEL_LIBRARY)
