/****************************/
/* THIS IS OPEN SOURCE CODE */
/****************************/

#ifndef _PAPI_POWER6_EVENTS_H
#define _PAPI_POWER6_EVENTS_H

/*
* File:    power6_events.h
* CVS:
* Author:  Corey Ashford
*          cjashfor@us.ibm.com
* Mods:    <your name here>
*          <your email address>
*
* (C) Copyright IBM Corporation, 2007.  All Rights Reserved.
* Contributed by Corey Ashford <cjashfor@us.ibm.com>
*
* This file MUST be kept synchronised with the events file.
*
*/
#include "papiStdEventDefs.h"

#define GROUP_INTS 7
#define PAPI_MAX_NATIVE_EVENTS 1024
#define MAX_GROUPS (GROUP_INTS * 32)
#define MAX_NATNAME_MAP_INDEX 553


enum native_name
{
	PNE_PM_0INST_FETCH = PAPI_NATIVE_MASK,
	PNE_PM_1PLUS_PPC_CMPL,
	PNE_PM_1PLUS_PPC_DISP,
	PNE_PM_BRU_FIN,
	PNE_PM_BR_MPRED_CCACHE,
	PNE_PM_BR_MPRED_COUNT,
	PNE_PM_BR_MPRED_CR,
	PNE_PM_BR_MPRED_TA,
	PNE_PM_BR_PRED,
	PNE_PM_BR_PRED_CCACHE,
	PNE_PM_BR_PRED_CR,
	PNE_PM_BR_PRED_LSTACK,
	PNE_PM_CYC,
	PNE_PM_DATA_FROM_L2,
	PNE_PM_DATA_FROM_L35_MOD,
	PNE_PM_DATA_FROM_MEM_DP,
	PNE_PM_DATA_FROM_RL2L3_MOD,
	PNE_PM_DATA_PTEG_1ST_HALF,
	PNE_PM_DATA_PTEG_2ND_HALF,
	PNE_PM_DATA_PTEG_SECONDARY,
	PNE_PM_DC_INV_L2,
	PNE_PM_DC_PREF_OUT_OF_STREAMS,
	PNE_PM_DC_PREF_STREAM_ALLOC,
	PNE_PM_DFU_ADD,
	PNE_PM_DFU_ADD_SHIFTED_BOTH,
	PNE_PM_DFU_BACK2BACK,
	PNE_PM_DFU_CONV,
	PNE_PM_DFU_ENC_BCD_DPD,
	PNE_PM_DFU_EXP_EQ,
	PNE_PM_DFU_FIN,
	PNE_PM_DFU_SUBNORM,
	PNE_PM_DPU_HELD_COMPLETION,
	PNE_PM_DPU_HELD_CR_LOGICAL,
	PNE_PM_DPU_HELD_CW,
	PNE_PM_DPU_HELD_FPQ,
	PNE_PM_DPU_HELD_FPU_CR,
	PNE_PM_DPU_HELD_FP_FX_MULT,
	PNE_PM_DPU_HELD_FXU_MULTI,
	PNE_PM_DPU_HELD_FXU_SOPS,
	PNE_PM_DPU_HELD_GPR,
	PNE_PM_DPU_HELD_INT,
	PNE_PM_DPU_HELD_ISYNC,
	PNE_PM_DPU_HELD_ITLB_ISLB,
	PNE_PM_DPU_HELD_LLA_END,
	PNE_PM_DPU_HELD_LSU,
	PNE_PM_DPU_HELD_LSU_SOPS,
	PNE_PM_DPU_HELD_MULT_GPR,
	PNE_PM_DPU_HELD_RESTART,
	PNE_PM_DPU_HELD_RU_WQ,
	PNE_PM_DPU_HELD_SMT,
	PNE_PM_DPU_HELD_SPR,
	PNE_PM_DPU_HELD_STCX_CR,
	PNE_PM_DPU_HELD_THERMAL,
	PNE_PM_DPU_HELD_THRD_PRIO,
	PNE_PM_DPU_HELD_XER,
	PNE_PM_DPU_HELD_XTHRD,
	PNE_PM_DSLB_MISS,
	PNE_PM_EE_OFF_EXT_INT,
	PNE_PM_FAB_ADDR_COLLISION,
	PNE_PM_FAB_CMD_ISSUED,
	PNE_PM_FAB_DCLAIM,
	PNE_PM_FAB_DMA,
	PNE_PM_FAB_MMIO,
	PNE_PM_FAB_NODE_PUMP,
	PNE_PM_FAB_RETRY_NODE_PUMP,
	PNE_PM_FAB_RETRY_SYS_PUMP,
	PNE_PM_FAB_SYS_PUMP,
	PNE_PM_FLUSH,
	PNE_PM_FLUSH_ASYNC,
	PNE_PM_FLUSH_FPU,
	PNE_PM_FLUSH_FXU,
	PNE_PM_FPU0_1FLOP,
	PNE_PM_FPU0_DENORM,
	PNE_PM_FPU0_FCONV,
	PNE_PM_FPU0_FEST,
	PNE_PM_FPU0_FIN,
	PNE_PM_FPU0_FLOP,
	PNE_PM_FPU0_FMA,
	PNE_PM_FPU0_FPSCR,
	PNE_PM_FPU0_FRSP,
	PNE_PM_FPU0_FSQRT_FDIV,
	PNE_PM_FPU0_FXDIV,
	PNE_PM_FPU0_FXMULT,
	PNE_PM_FPU0_SINGLE,
	PNE_PM_FPU0_STF,
	PNE_PM_FPU0_ST_FOLDED,
	PNE_PM_FPU1_1FLOP,
	PNE_PM_FPU1_DENORM,
	PNE_PM_FPU1_FCONV,
	PNE_PM_FPU1_FEST,
	PNE_PM_FPU1_FIN,
	PNE_PM_FPU1_FLOP,
	PNE_PM_FPU1_FMA,
	PNE_PM_FPU1_FPSCR,
	PNE_PM_FPU1_FRSP,
	PNE_PM_FPU1_FSQRT_FDIV,
	PNE_PM_FPU1_FXDIV,
	PNE_PM_FPU1_FXMULT,
	PNE_PM_FPU1_SINGLE,
	PNE_PM_FPU1_STF,
	PNE_PM_FPU1_ST_FOLDED,
	PNE_PM_FPU_1FLOP,
	PNE_PM_FPU_FCONV,
	PNE_PM_FPU_FIN,
	PNE_PM_FPU_FLOP,
	PNE_PM_FPU_FXDIV,
	PNE_PM_FPU_FXMULT,
	PNE_PM_FPU_ISSUE_0,
	PNE_PM_FPU_ISSUE_1,
	PNE_PM_FPU_ISSUE_2,
	PNE_PM_FPU_ISSUE_DIV_SQRT_OVERLAP,
	PNE_PM_FPU_ISSUE_OOO,
	PNE_PM_FPU_ISSUE_STALL_FPR,
	PNE_PM_FPU_ISSUE_STALL_ST,
	PNE_PM_FPU_ISSUE_STALL_THRD,
	PNE_PM_FPU_ISSUE_STEERING,
	PNE_PM_FPU_ISSUE_ST_FOLDED,
	PNE_PM_FXU_IDLE,
	PNE_PM_FXU_PIPELINED_MULT_DIV,
	PNE_PM_GCT_EMPTY_CYC,
	PNE_PM_GCT_FULL_CYC,
	PNE_PM_GCT_NOSLOT_CYC,
	PNE_PM_GXI_ADDR_CYC_BUSY,
	PNE_PM_GXI_CYC_BUSY,
	PNE_PM_GXI_DATA_CYC_BUSY,
	PNE_PM_GXO_ADDR_CYC_BUSY,
	PNE_PM_GXO_CYC_BUSY,
	PNE_PM_GXO_DATA_CYC_BUSY,
	PNE_PM_GX_DMA_READ,
	PNE_PM_GX_DMA_WRITE,
	PNE_PM_IBUF_FULL_CYC,
	PNE_PM_IC_DEMAND_L2_BHT_REDIRECT,
	PNE_PM_IC_DEMAND_L2_BR_REDIRECT,
	PNE_PM_IC_PREF_REQ,
	PNE_PM_IC_PREF_WRITE,
	PNE_PM_IC_RELOAD_SHR,
	PNE_PM_IC_REQ,
	PNE_PM_IERAT_MISS,
	PNE_PM_IFU_FIN,
	PNE_PM_INST_CMPL,
	PNE_PM_INST_DISP_LLA,
	PNE_PM_INST_FETCH_CYC,
	PNE_PM_INST_FROM_L1,
	PNE_PM_INST_FROM_L2,
	PNE_PM_INST_FROM_L35_MOD,
	PNE_PM_INST_FROM_MEM_DP,
	PNE_PM_INST_FROM_RL2L3_MOD,
	PNE_PM_INST_IMC_MATCH_CMPL,
	PNE_PM_INST_PTEG_1ST_HALF,
	PNE_PM_INST_PTEG_2ND_HALF,
	PNE_PM_INST_PTEG_SECONDARY,
	PNE_PM_INST_TABLEWALK_CYC,
	PNE_PM_ISLB_MISS,
	PNE_PM_ITLB_REF,
	PNE_PM_L1_ICACHE_MISS,
	PNE_PM_L1_PREF,
	PNE_PM_L1_WRITE_CYC,
	PNE_PM_L2SA_CASTOUT_MOD,
	PNE_PM_L2SA_CASTOUT_SHR,
	PNE_PM_L2SA_DC_INV,
	PNE_PM_L2SA_IC_INV,
	PNE_PM_L2SA_LD_HIT,
	PNE_PM_L2SA_LD_MISS_DATA,
	PNE_PM_L2SA_LD_MISS_INST,
	PNE_PM_L2SA_LD_REQ,
	PNE_PM_L2SA_LD_REQ_DATA,
	PNE_PM_L2SA_LD_REQ_INST,
	PNE_PM_L2SA_MISS,
	PNE_PM_L2SA_ST_HIT,
	PNE_PM_L2SA_ST_MISS,
	PNE_PM_L2SA_ST_REQ,
	PNE_PM_L2SB_CASTOUT_MOD,
	PNE_PM_L2SB_CASTOUT_SHR,
	PNE_PM_L2SB_DC_INV,
	PNE_PM_L2SB_IC_INV,
	PNE_PM_L2SB_LD_HIT,
	PNE_PM_L2SB_LD_MISS_DATA,
	PNE_PM_L2SB_LD_MISS_INST,
	PNE_PM_L2SB_LD_REQ,
	PNE_PM_L2SB_LD_REQ_DATA,
	PNE_PM_L2SB_LD_REQ_INST,
	PNE_PM_L2SB_MISS,
	PNE_PM_L2SB_ST_HIT,
	PNE_PM_L2SB_ST_MISS,
	PNE_PM_L2SB_ST_REQ,
	PNE_PM_L2_CASTOUT_MOD,
	PNE_PM_L2_LD_REQ_DATA,
	PNE_PM_L2_LD_REQ_INST,
	PNE_PM_L2_PREF_LD,
	PNE_PM_L2_PREF_ST,
	PNE_PM_L2_ST_MISS_DATA,
	PNE_PM_L3SA_HIT,
	PNE_PM_L3SA_MISS,
	PNE_PM_L3SA_REF,
	PNE_PM_L3SB_HIT,
	PNE_PM_L3SB_MISS,
	PNE_PM_L3SB_REF,
	PNE_PM_LARX,
	PNE_PM_LARX_L1HIT,
	PNE_PM_LD_MISS_L1,
	PNE_PM_LD_MISS_L1_CYC,
	PNE_PM_LD_REF_L1,
	PNE_PM_LD_REF_L1_BOTH,
	PNE_PM_LD_REQ_L2,
	PNE_PM_LSU0_DERAT_MISS,
	PNE_PM_LSU0_LDF,
	PNE_PM_LSU0_NCLD,
	PNE_PM_LSU0_NCST,
	PNE_PM_LSU0_REJECT,
	PNE_PM_LSU0_REJECT_DERAT_MPRED,
	PNE_PM_LSU0_REJECT_EXTERN,
	PNE_PM_LSU0_REJECT_L2MISS,
	PNE_PM_LSU0_REJECT_L2_CORR,
	PNE_PM_LSU0_REJECT_LHS,
	PNE_PM_LSU0_REJECT_NO_SCRATCH,
	PNE_PM_LSU0_REJECT_PARTIAL_SECTOR,
	PNE_PM_LSU0_REJECT_SET_MPRED,
	PNE_PM_LSU0_REJECT_STQ_FULL,
	PNE_PM_LSU0_REJECT_ULD,
	PNE_PM_LSU0_REJECT_UST,
	PNE_PM_LSU1_DERAT_MISS,
	PNE_PM_LSU1_LDF,
	PNE_PM_LSU1_REJECT,
	PNE_PM_LSU1_REJECT_DERAT_MPRED,
	PNE_PM_LSU1_REJECT_EXTERN,
	PNE_PM_LSU1_REJECT_L2_CORR,
	PNE_PM_LSU1_REJECT_LHS,
	PNE_PM_LSU1_REJECT_NO_SCRATCH,
	PNE_PM_LSU1_REJECT_PARTIAL_SECTOR,
	PNE_PM_LSU1_REJECT_SET_MPRED,
	PNE_PM_LSU1_REJECT_STQ_FULL,
	PNE_PM_LSU1_REJECT_ULD,
	PNE_PM_LSU1_REJECT_UST,
	PNE_PM_LSU_BOTH_BUS,
	PNE_PM_LSU_DERAT_MISS_CYC,
	PNE_PM_LSU_FLUSH_ALIGN,
	PNE_PM_LSU_FLUSH_DSI,
	PNE_PM_LSU_LDF_BOTH,
	PNE_PM_LSU_LMQ_FULL_CYC,
	PNE_PM_LSU_REJECT_L2_CORR,
	PNE_PM_LSU_REJECT_LHS,
	PNE_PM_LSU_REJECT_PARTIAL_SECTOR,
	PNE_PM_LSU_REJECT_STEAL,
	PNE_PM_LSU_REJECT_STQ_FULL,
	PNE_PM_LSU_REJECT_ULD,
	PNE_PM_LSU_REJECT_UST_BOTH,
	PNE_PM_LSU_ST_CHAINED,
	PNE_PM_LWSYNC,
	PNE_PM_MEM0_DP_CL_WR_GLOB,
	PNE_PM_MEM0_DP_CL_WR_LOC,
	PNE_PM_MEM0_DP_RQ_GLOB_LOC,
	PNE_PM_MEM0_DP_RQ_LOC_GLOB,
	PNE_PM_MEM1_DP_CL_WR_GLOB,
	PNE_PM_MEM1_DP_CL_WR_LOC,
	PNE_PM_MEM1_DP_RQ_GLOB_LOC,
	PNE_PM_MEM1_DP_RQ_LOC_GLOB,
	PNE_PM_MEM_DP_CL_WR_LOC,
	PNE_PM_MEM_DP_RQ_GLOB_LOC,
	PNE_PM_MRK_BR_TAKEN,
	PNE_PM_MRK_DATA_FROM_L2,
	PNE_PM_MRK_DATA_FROM_L2MISS,
	PNE_PM_MRK_DATA_FROM_L35_MOD,
	PNE_PM_MRK_DATA_FROM_MEM_DP,
	PNE_PM_MRK_DATA_FROM_RL2L3_MOD,
	PNE_PM_MRK_DTLB_REF,
	PNE_PM_MRK_FPU0_FIN,
	PNE_PM_MRK_FPU1_FIN,
	PNE_PM_MRK_INST_DISP,
	PNE_PM_MRK_INST_ISSUED,
	PNE_PM_MRK_LSU0_REJECT_L2MISS,
	PNE_PM_MRK_LSU0_REJECT_LHS,
	PNE_PM_MRK_LSU0_REJECT_ULD,
	PNE_PM_MRK_LSU0_REJECT_UST,
	PNE_PM_MRK_LSU1_REJECT_LHS,
	PNE_PM_MRK_LSU1_REJECT_ULD,
	PNE_PM_MRK_LSU1_REJECT_UST,
	PNE_PM_MRK_LSU_REJECT_ULD,
	PNE_PM_MRK_PTEG_FROM_L2,
	PNE_PM_MRK_PTEG_FROM_L35_MOD,
	PNE_PM_MRK_PTEG_FROM_MEM_DP,
	PNE_PM_MRK_PTEG_FROM_RL2L3_MOD,
	PNE_PM_MRK_STCX_FAIL,
	PNE_PM_MRK_ST_CMPL,
	PNE_PM_MRK_VMX0_LD_WRBACK,
	PNE_PM_MRK_VMX1_LD_WRBACK,
	PNE_PM_MRK_VMX_COMPLEX_ISSUED,
	PNE_PM_MRK_VMX_FLOAT_ISSUED,
	PNE_PM_MRK_VMX_PERMUTE_ISSUED,
	PNE_PM_MRK_VMX_SIMPLE_ISSUED,
	PNE_PM_MRK_VMX_ST_ISSUED,
	PNE_PM_NO_ITAG_CYC,
	PNE_PM_PMC2_SAVED,
	PNE_PM_PMC4_OVERFLOW,
	PNE_PM_PMC4_REWIND,
	PNE_PM_PMC5_OVERFLOW,
	PNE_PM_PTEG_FROM_L2,
	PNE_PM_PTEG_FROM_L2MISS,
	PNE_PM_PTEG_FROM_L35_MOD,
	PNE_PM_PTEG_FROM_MEM_DP,
	PNE_PM_PTEG_FROM_RL2L3_MOD,
	PNE_PM_PTEG_RELOAD_VALID,
	PNE_PM_PURR,
	PNE_PM_RUN_CYC,
	PNE_PM_SLB_MISS,
	PNE_PM_STCX,
	PNE_PM_STCX_CANCEL,
	PNE_PM_STCX_FAIL,
	PNE_PM_ST_FIN,
	PNE_PM_ST_HIT_L2,
	PNE_PM_ST_MISS_L1,
	PNE_PM_ST_REF_L1,
	PNE_PM_SUSPENDED,
	PNE_PM_SYNC_CYC,
	PNE_PM_TB_BIT_TRANS,
	PNE_PM_THRD_L2MISS,
	PNE_PM_THRD_ONE_RUN_CYC,
	PNE_PM_THRD_PRIO_0_CYC,
	PNE_PM_THRD_PRIO_7_CYC,
	PNE_PM_THRD_PRIO_DIFF_0_CYC,
	PNE_PM_THRD_SEL_T0,
	PNE_PM_TLB_REF,
	PNE_PM_VMX0_INST_ISSUED,
	PNE_PM_VMX0_LD_ISSUED,
	PNE_PM_VMX0_LD_WRBACK,
	PNE_PM_VMX0_STALL,
	PNE_PM_VMX1_INST_ISSUED,
	PNE_PM_VMX1_LD_ISSUED,
	PNE_PM_VMX1_LD_WRBACK,
	PNE_PM_VMX1_STALL,
	PNE_PM_VMX_COMPLEX_ISUED,
	PNE_PM_VMX_FLOAT_ISSUED,
	PNE_PM_VMX_FLOAT_MULTICYCLE,
	PNE_PM_VMX_PERMUTE_ISSUED,
	PNE_PM_VMX_RESULT_SAT_0_1,
	PNE_PM_VMX_RESULT_SAT_1,
	PNE_PM_VMX_SIMPLE_ISSUED,
	PNE_PM_VMX_ST_ISSUED,
	PNE_PM_0INST_FETCH_COUNT,
	PNE_PM_IBUF_FULL_COUNT,
	PNE_PM_GCT_FULL_COUNT,
	PNE_PM_NO_ITAG_COUNT,
	PNE_PM_INST_TABLEWALK_COUNT,
	PNE_PM_SYNC_COUNT,
	PNE_PM_RUN_COUNT,
	PNE_PM_THRD_ONE_RUN_COUNT,
	PNE_PM_LLA_CYC,
	PNE_PM_NOT_LLA_CYC,
	PNE_PM_LLA_COUNT,
	PNE_PM_DPU_HELD_THERMAL_COUNT,
	PNE_PM_GCT_NOSLOT_COUNT,
	PNE_PM_DERAT_REF_4K,
	PNE_PM_DERAT_MISS_4K,
	PNE_PM_IERAT_MISS_16G,
	PNE_PM_MRK_DERAT_REF_64K,
	PNE_PM_MRK_DERAT_MISS_64K,
	PNE_PM_BR_TAKEN,
	PNE_PM_DATA_FROM_DL2L3_SHR_CYC,
	PNE_PM_DATA_FROM_DMEM,
	PNE_PM_DATA_FROM_DMEM_CYC,
	PNE_PM_DATA_FROM_L21,
	PNE_PM_DATA_FROM_L25_SHR_CYC,
	PNE_PM_DATA_FROM_L2MISS,
	PNE_PM_DATA_FROM_L2_CYC,
	PNE_PM_DATA_FROM_L35_SHR,
	PNE_PM_DATA_FROM_L35_SHR_CYC,
	PNE_PM_DATA_FROM_L3_CYC,
	PNE_PM_DATA_FROM_LMEM_CYC,
	PNE_PM_DATA_FROM_RL2L3_SHR,
	PNE_PM_DATA_FROM_RL2L3_SHR_CYC,
	PNE_PM_DPU_HELD,
	PNE_PM_DPU_HELD_POWER,
	PNE_PM_DPU_WT_IC_MISS,
	PNE_PM_EXT_INT,
	PNE_PM_FAB_CMD_RETRIED,
	PNE_PM_FPU_DENORM,
	PNE_PM_FPU_FMA,
	PNE_PM_FPU_FPSCR,
	PNE_PM_FPU_FRSP,
	PNE_PM_FPU_FSQRT_FDIV,
	PNE_PM_FXU_BUSY,
	PNE_PM_HV_CYC,
	PNE_PM_IC_INV_L2,
	PNE_PM_INST_DISP,
	PNE_PM_INST_FROM_DMEM,
	PNE_PM_INST_FROM_L21,
	PNE_PM_INST_FROM_L35_SHR,
	PNE_PM_INST_FROM_RL2L3_SHR,
	PNE_PM_L2_CASTOUT_SHR,
	PNE_PM_L2_LD_MISS_DATA,
	PNE_PM_L2_LD_MISS_INST,
	PNE_PM_L2_MISS,
	PNE_PM_L2_ST_REQ_DATA,
	PNE_PM_LD_HIT_L2,
	PNE_PM_LSU_DERAT_MISS,
	PNE_PM_LSU_LDF,
	PNE_PM_LSU_LMQ_SRQ_EMPTY_CYC,
	PNE_PM_LSU_REJECT_DERAT_MPRED,
	PNE_PM_LSU_REJECT_LHS_BOTH,
	PNE_PM_LSU_REJECT_NO_SCRATCH,
	PNE_PM_LSU_REJECT_SET_MPRED,
	PNE_PM_LSU_REJECT_SLOW,
	PNE_PM_LSU_REJECT_ULD_BOTH,
	PNE_PM_LSU_REJECT_UST,
	PNE_PM_MEM_DP_CL_WR_GLOB,
	PNE_PM_MEM_DP_RQ_LOC_GLOB,
	PNE_PM_MRK_DATA_FROM_DMEM,
	PNE_PM_MRK_DATA_FROM_L21,
	PNE_PM_MRK_DATA_FROM_L35_SHR,
	PNE_PM_MRK_DATA_FROM_RL2L3_SHR,
	PNE_PM_MRK_FPU_FIN,
	PNE_PM_MRK_FXU_FIN,
	PNE_PM_MRK_IFU_FIN,
	PNE_PM_MRK_LD_MISS_L1,
	PNE_PM_MRK_LSU_REJECT_UST,
	PNE_PM_MRK_PTEG_FROM_DMEM,
	PNE_PM_MRK_PTEG_FROM_L21,
	PNE_PM_MRK_PTEG_FROM_L35_SHR,
	PNE_PM_MRK_PTEG_FROM_RL2L3_SHR,
	PNE_PM_MRK_ST_GPS,
	PNE_PM_PMC1_OVERFLOW,
	PNE_PM_PTEG_FROM_DMEM,
	PNE_PM_PTEG_FROM_L21,
	PNE_PM_PTEG_FROM_L35_SHR,
	PNE_PM_PTEG_FROM_RL2L3_SHR,
	PNE_PM_ST_REF_L1_BOTH,
	PNE_PM_ST_REQ_L2,
	PNE_PM_THRD_GRP_CMPL_BOTH_CYC,
	PNE_PM_THRD_PRIO_1_CYC,
	PNE_PM_THRD_PRIO_6_CYC,
	PNE_PM_THRD_PRIO_DIFF_1or2_CYC,
	PNE_PM_THRD_PRIO_DIFF_minus1or2_CYC,
	PNE_PM_HV_COUNT,
	PNE_PM_DPU_HELD_COUNT,
	PNE_PM_DPU_HELD_POWER_COUNT,
	PNE_PM_DPU_WT_IC_MISS_COUNT,
	PNE_PM_GCT_EMPTY_COUNT,
	PNE_PM_LSU_LMQ_SRQ_EMPTY_COUNT,
	PNE_PM_DERAT_REF_64K,
	PNE_PM_DERAT_MISS_64K,
	PNE_PM_IERAT_MISS_16M,
	PNE_PM_MRK_DERAT_REF_4K,
	PNE_PM_MRK_DERAT_MISS_4K,
	PNE_PM_DATA_FROM_DL2L3_SHR,
	PNE_PM_DATA_FROM_L25_MOD,
	PNE_PM_DATA_FROM_L3,
	PNE_PM_DATA_FROM_L3MISS,
	PNE_PM_DATA_FROM_RMEM,
	PNE_PM_DPU_WT,
	PNE_PM_FPU_STF,
	PNE_PM_FPU_ST_FOLDED,
	PNE_PM_FREQ_DOWN,
	PNE_PM_FXU0_BUSY_FXU1_IDLE,
	PNE_PM_FXU0_FIN,
	PNE_PM_INST_FROM_DL2L3_SHR,
	PNE_PM_INST_FROM_L25_MOD,
	PNE_PM_INST_FROM_L3,
	PNE_PM_INST_FROM_L3MISS,
	PNE_PM_INST_FROM_RMEM,
	PNE_PM_L1_DCACHE_RELOAD_VALID,
	PNE_PM_LSU_LMQ_SRQ_EMPTY_BOTH_CYC,
	PNE_PM_LSU_REJECT_EXTERN,
	PNE_PM_LSU_REJECT_FAST,
	PNE_PM_MRK_BR_MPRED,
	PNE_PM_MRK_DATA_FROM_DL2L3_SHR,
	PNE_PM_MRK_DATA_FROM_L25_MOD,
	PNE_PM_MRK_DATA_FROM_L3,
	PNE_PM_MRK_DATA_FROM_L3MISS,
	PNE_PM_MRK_DATA_FROM_RMEM,
	PNE_PM_MRK_DFU_FIN,
	PNE_PM_MRK_INST_FIN,
	PNE_PM_MRK_PTEG_FROM_DL2L3_SHR,
	PNE_PM_MRK_PTEG_FROM_L25_MOD,
	PNE_PM_MRK_PTEG_FROM_L3,
	PNE_PM_MRK_PTEG_FROM_L3MISS,
	PNE_PM_MRK_PTEG_FROM_RMEM,
	PNE_PM_MRK_ST_CMPL_INT,
	PNE_PM_PMC2_OVERFLOW,
	PNE_PM_PMC2_REWIND,
	PNE_PM_PMC4_SAVED,
	PNE_PM_PMC6_OVERFLOW,
	PNE_PM_PTEG_FROM_DL2L3_SHR,
	PNE_PM_PTEG_FROM_L25_MOD,
	PNE_PM_PTEG_FROM_L3,
	PNE_PM_PTEG_FROM_L3MISS,
	PNE_PM_PTEG_FROM_RMEM,
	PNE_PM_THERMAL_MAX,
	PNE_PM_THRD_CONC_RUN_INST,
	PNE_PM_THRD_PRIO_2_CYC,
	PNE_PM_THRD_PRIO_5_CYC,
	PNE_PM_THRD_PRIO_DIFF_3or4_CYC,
	PNE_PM_THRD_PRIO_DIFF_minus3or4_CYC,
	PNE_PM_THRESH_TIMEO,
	PNE_PM_DPU_WT_COUNT,
	PNE_PM_LSU_LMQ_SRQ_EMPTY_BOTH_COUNT,
	PNE_PM_DERAT_REF_16M,
	PNE_PM_DERAT_MISS_16M,
	PNE_PM_IERAT_MISS_64K,
	PNE_PM_MRK_DERAT_REF_16M,
	PNE_PM_MRK_DERAT_MISS_16M,
	PNE_PM_BR_MPRED,
	PNE_PM_DATA_FROM_DL2L3_MOD,
	PNE_PM_DATA_FROM_DL2L3_MOD_CYC,
	PNE_PM_DATA_FROM_L21_CYC,
	PNE_PM_DATA_FROM_L25_SHR,
	PNE_PM_DATA_FROM_L25_MOD_CYC,
	PNE_PM_DATA_FROM_L35_MOD_CYC,
	PNE_PM_DATA_FROM_LMEM,
	PNE_PM_DATA_FROM_MEM_DP_CYC,
	PNE_PM_DATA_FROM_RL2L3_MOD_CYC,
	PNE_PM_DATA_FROM_RMEM_CYC,
	PNE_PM_DPU_WT_BR_MPRED,
	PNE_PM_FPU_FEST,
	PNE_PM_FPU_SINGLE,
	PNE_PM_FREQ_UP,
	PNE_PM_FXU1_BUSY_FXU0_IDLE,
	PNE_PM_FXU1_FIN,
	PNE_PM_INST_FROM_DL2L3_MOD,
	PNE_PM_INST_FROM_L25_SHR,
	PNE_PM_INST_FROM_L2MISS,
	PNE_PM_INST_FROM_LMEM,
	PNE_PM_LSU_REJECT,
	PNE_PM_LSU_SRQ_EMPTY_CYC,
	PNE_PM_MRK_DATA_FROM_DL2L3_MOD,
	PNE_PM_MRK_DATA_FROM_L25_SHR,
	PNE_PM_MRK_DATA_FROM_LMEM,
	PNE_PM_MRK_INST_TIMEO,
	PNE_PM_MRK_LSU_DERAT_MISS,
	PNE_PM_MRK_LSU_FIN,
	PNE_PM_MRK_LSU_REJECT_LHS,
	PNE_PM_MRK_PTEG_FROM_DL2L3_MOD,
	PNE_PM_MRK_PTEG_FROM_L25_SHR,
	PNE_PM_MRK_PTEG_FROM_L2MISS,
	PNE_PM_MRK_PTEG_FROM_LMEM,
	PNE_PM_PMC3_OVERFLOW,
	PNE_PM_PTEG_FROM_DL2L3_MOD,
	PNE_PM_PTEG_FROM_L25_SHR,
	PNE_PM_PTEG_FROM_LMEM,
	PNE_PM_THRD_BOTH_RUN_CYC,
	PNE_PM_THRD_LLA_BOTH_CYC,
	PNE_PM_THRD_PRIO_3_CYC,
	PNE_PM_THRD_PRIO_4_CYC,
	PNE_PM_THRD_PRIO_DIFF_5or6_CYC,
	PNE_PM_THRD_PRIO_DIFF_minus5or6_CYC,
	PNE_PM_THRD_BOTH_RUN_COUNT,
	PNE_PM_DPU_WT_BR_MPRED_COUNT,
	PNE_PM_LSU_SRQ_EMPTY_COUNT,
	PNE_PM_DERAT_REF_16G,
	PNE_PM_DERAT_MISS_16G,
	PNE_PM_IERAT_MISS_4K,
	PNE_PM_MRK_DERAT_REF_16G,
	PNE_PM_MRK_DERAT_MISS_16G,
	PNE_PM_RUN_PURR,
	PNE_PM_RUN_INST_CMPL,
	NATNAME_GUARD,
};

#endif
