<?php
// (c)2012 Rackspace Hosting
// See COPYING for licensing information

// This script generates the /etc/mail/local-host-names file for all
// domains that match the specified MX_HOST. I've found that maintaining
// that file manually is a big pain, so I made this to automatically
// generate it for my mail server.

require_once "php-opencloud.php";

define('AUTHURL', RACKSPACE_US);
define('USERNAME', $_ENV['OS_USERNAME']);
define('TENANT', $_ENV['OS_TENANT_NAME']);
define('APIKEY', $_ENV['NOVA_API_KEY']);

// you should probably change this to match your host name
define('MX_HOST', 'mx1.xlerb.com');

// uncomment for debug output
//setDebug(TRUE);

// establish our credentials
$cloud = new \OpenCloud\Rackspace(AUTHURL,
	array( 'username' => USERNAME,
		   'apiKey' => APIKEY ));

$dns = $cloud->DNS();

// put in a nice header comment
printf("# Generated by %s\n", basename(__FILE__));
printf("# on %s\n", date('Y-m-d H:i:s'));
printf("# %s\n", RAXSDK_USER_AGENT);

// list all domains
$dlist = $dns->DomainList();
while($domain = $dlist->Next()) {
	// find the ones with MX that match the provided host name
	$rlist = $domain->RecordList(array('type'=>'MX', 'data'=>MX_HOST));
	if ($rlist->Size() > 0) {
		printf("%s\n", $domain->Name());
	}
}
