sub sensor_tree()
{
	my $Path = $cgi->param( 'path' );
	if ( ! $Path ) { $Path = '/'; };
	my @Path = split( /\//, $Path );
	for( my $i=1 ; $i<4 ; $i++ )
	{
		if ( ! $Path[$i] ) { $Path[$i] = ''; };
	}

	  # VLAN list :
	my @vlan = ();

	my $sql = 'SELECT analyzerid FROM Prelude_Analyzer WHERE ';
	$sql .= "parent_type='H' GROUP BY analyzerid;";
	my $sth = $dbh->prepare( $sql );
	$sth->execute();
	while( my $AnalyzerId = $sth->fetchrow_array() )
	{
		my $sql = 'SELECT * FROM Prelude_Analyzer WHERE ';
		$sql .= "parent_type='H' AND analyzerid=? ORDER BY ";
		$sql .= 'parent_ident DESC LIMIT 1;';
		my $sth = $dbh->prepare( $sql );
		$sth->execute( $AnalyzerId );
		my $Analyzer = $sth->fetchrow_hashref();
		$sth->finish();

		$sql = 'SELECT * FROM Prelude_Node WHERE ';
		$sql .= "parent_type='H' AND alert_ident=?;";
		$sth = $dbh->prepare( $sql );
		$sth->execute( $Analyzer->{'parent_ident'} );
		my $Node = $sth->fetchrow_hashref();
		$sth->finish();

		$sql = 'SELECT * FROM Prelude_Address WHERE ';
		$sql .= "parent_type='H' AND alert_ident=?;";
		$sth = $dbh->prepare( $sql );
		$sth->execute( $Analyzer->{'parent_ident'} );
		if ( $sth->rows() )
		{
			while ( my $Address = $sth->fetchrow_hashref() )
			{
				tree_add( \@vlan, $Address, $Analyzer, $Node, $Analyzer->{'analyzerid'} );
			}
		}
		else
		{
			  # no Address object for this sensor :
			my $Address = {};
			tree_add( \@vlan, $Address, $Analyzer, $Node, $Analyzer->{'analyzerid'} );
		}
		$sth->finish();
	}
	$sth->finish();

  ################################################################

	my @last = ();
	my $lpath = '/';
	my $Output = cool( '+', \@last,1,'' ).' ';
	$Output .= "<a href=\"Filters$conf{'extension'}\" target=main>ALL</a><br>\n";
	for( my $i = 0 ; $i <= $#vlan ; $i ++ )
	{
		if ( $vlan[$i] )
		{
			if ( $i eq $#vlan ) {$last[0] = 1;} else {$last[0] = 0;};

			if ( $Path[1] ne $i ) {$lpath = '/'.$i;};

			$Output .= cool( '\\+', \@last, ( $Path[1] eq $i ), $lpath );
			$Output .= " $i - ";
			$Output .= make_filter( 'Analyzer.vlan_num', $i, $vlan[$i]->{'name'} );
			$Output .= "<br>\n";

			if ( $Path[1] eq $i )
			{
				$lpath = '/'.$i.'/';

				my @addr_lst = sort keys %{$vlan[$i]->{'addr_lst'}};
				my $cnt = 0;
				foreach my $addr ( @addr_lst )
				{
					if ( $cnt eq $#addr_lst ) {$last[1] = 1;} else {$last[1] = 0;};
					$cnt ++;

					if ( $Path[2] ne $addr ) {$lpath = '/'.$i.'/'.$addr;};

					$Output .= cool( '|\\+', \@last,( $Path[2] eq $addr ), $lpath );
					$Output .= ' ';
					$Output .= make_filter( 'Analyzer.address', $addr, $addr );
					$Output .= "<br>\n";

					if ( $Path[2] eq $addr )
					{
						$lpath = '/'.$i.'/'.$addr.'/';

						my @a_id_lst = sort keys %{$vlan[$i]->{'addr_lst'}->{$addr}};
						my $cnt2 = 0;
						foreach my $a_id ( @a_id_lst )
						{
							if ( $cnt2 eq $#a_id_lst ) {$last[2] = 1;} else {$last[2] = 0;};
							$cnt2 ++;

							if ( $Path[3] ne $a_id ) {$lpath = '/'.$i.'/'.$addr.'/'.$a_id;};

							$Output .= cool( '||\\+', \@last, ( $Path[3] eq $a_id ), $lpath );
							$Output .= ' ';
							$Output .= make_filter( 'Analyzer.analyzerid', $a_id, $a_id );
							$Output .= "<br>\n";

							if ( $Path[3] eq $a_id )
							{
								$lpath = '/'.$i.'/'.$addr.'/'.$a_id;

								my @keys = sort keys %{$vlan[$i]->{'addr_lst'}->{$addr}->{$a_id}};
								my $cnt3 = 0;
								foreach my $key ( @keys )
								{
									if ( $cnt3 eq $#keys )
									{
										$last[3] = 1;
									}
									else
									{
										$last[3] = 0;
									}
									$cnt3 ++;
									$Output .= cool( '|||\\]', \@last,0,'' )." $key = ";
									my $label = $vlan[$i]->{'addr_lst'}->{$addr}->{$a_id}->{$key};
									if ( $key ne 'Location' )
									{
										$label = make_filter( 'Analyzer.'.lc( $key ), $label, $label );
									}
									$Output .= $label;
									$Output .= "<br>\n";
								}
							}
						}
					}
				}
			}
		}
	}

	return $Output;
}

sub tree_add($$$$$)
{
	my $vlan = shift;
	my $Address = shift;
	my $Analyzer = shift;
	my $Node = shift;
	my $AnalyzerId = shift;

	my $Model = $Analyzer->{'model'};
	$Model =~ s/Log Monitoring Lackey/LML/;
	$Model =~ s/\s/&nbsp;/g;

	my $Class = $Analyzer->{'class'};
	$Class =~ s/^Network /N/;
	$Class =~ s/^Host based /H/;
	$Class =~ s/Intrusion Detection System$/IDS/;

	my $Location = ( ( ! $Node->{'location'} )?( $Node->{'name'} ):( $Node->{'location'} ) ) || '&nbsp;';
	if ( ! $Location) {$Location = 'n/a';};

	my $address = $Address->{'address'};
#	my $category = $Address->{'category'};
#	my $netmask = $Address->{'netmask'};
	my $vlan_num = $Address->{'vlan_num'};
	my $vlan_name = $Address->{'vlan_name'};

  ##################################################################

	if ( ! $vlan_num ) {$vlan_num = 0;};
	if ( ! $vlan_name ) {$vlan_name = 'noname';};
	if ( ! $address ) {$address = 'noaddress';};

	if ( ! $vlan->[$vlan_num] )
	{
		$vlan->[$vlan_num]={
			'name' => 'noname',
			'addr_lst' => {}
		}
	}
	$vlan->[$vlan_num]->{'name'} = $vlan_name;

  ##################################################################

	if ( ! $vlan->[$vlan_num]->{'addr_lst'}->{$address} )
	{
		$vlan->[$vlan_num]->{'addr_lst'}->{$address} = {};
	}

	if ( ! $vlan->[$vlan_num]->{'addr_lst'}->{$address}->{$AnalyzerId} )
	{
		$vlan->[$vlan_num]->{'addr_lst'}->{$address}->{$AnalyzerId} = {
			'Class' => $Class,
			'Model' => $Model,
			'Location' => $Location
		}
	}
}

sub cool($$$$)
{
	my $string = shift;
	my $last = shift;
	my $opened = shift;
	my $link = shift;

	my $result = '';

	for( my $i = 0 ; $i < length( $string ) ; $i ++ )
	{
		if ( $last->[$i] )
		{
			if ( substr( $string, $i, 1 ) eq '|' ) {$result .= tree_image( 'empty10' );};
			if ( substr( $string, $i, 1 ) eq '\\' ) {$result .= tree_image( 'inter10' );};
		}
		else
		{
			if ( substr( $string, $i, 1 ) eq '|' ) {$result .= tree_image( 'empty00' );};
			if ( substr( $string, $i, 1 ) eq '\\' ) {$result .= tree_image( 'inter00' );};
		}
	}

	if ( $string =~ m/\]$/ ) {$result .= tree_image( 'leaf10' );};

	if ( $string =~ m/\+$/ )
	{
		if ( $link ) {$result .= "<a href=\"Sensor_Tree.pl?path=$link\">";};

		if ( $opened )
		{
			$result .= tree_image( 'leaf01' );
		}
		else
		{
			$result .= tree_image( 'leaf00' );
		}

		if ( $link ) {$result .= '</a>';};
	}

	return $result;
}

sub tree_image($)
{
	my $image = shift;

	return "<img src=\"images/tree/$image.gif\" border=0>";
}

sub make_filter($$$)
{
	my $file = shift;
	my $value = shift;
	my $label = shift;

	my $link = "<a href=\"Filters$conf{'extension'}?load=";
	$link .= url_encode( 'defaults/eq'.$file );
	$link .= "&amp;valA=".url_encode( $value );
	$link .= "\" target=main>$label</a>";

	return $link;
}

1;
