//----------------------------------------------------------------------------------------
/*!
    \file       splashscreen.h        
    \modified                            
    \copyright  (c) Robert O'Connor ( rob@medicalmnemonics.com )    
    \licence    GPL
    \brief      Describes splashscreen class    
    \author     Robert O'Connor
    \date       2002/02/16     
 */  

// RCS-ID:      $Id: splashscreen.h,v 1.9 2003/03/17 17:43:20 robertoconnor Exp $
//----------------------------------------------------------------------------------------

//----------------------------------------------------------------------------------------
// Begin single inclusion of this .h file condition
//----------------------------------------------------------------------------------------

#ifndef _SPLASHSCREEN_H_
#define _SPLASHSCREEN_H_

//----------------------------------------------------------------------------------------
// GCC interface
//----------------------------------------------------------------------------------------

#if defined(__GNUG__) && ! defined(__APPLE__)
    #pragma interface "splashscreen.h"
#endif

//----------------------------------------------------------------------------------------
// Shared defines
//----------------------------------------------------------------------------------------

#include "plucker_defines.h"

//----------------------------------------------------------------------------------------
// Begin feature removal condition
//----------------------------------------------------------------------------------------

#if ( setupUSE_SPLASHSCREEN )

//----------------------------------------------------------------------------------------
// Headers
//----------------------------------------------------------------------------------------

#include "wx/splash.h"              // wxSplashScreen

//----------------------------------------------------------------------------------------
// Class definition: splashscreen
//----------------------------------------------------------------------------------------

//! Class to manage the splashscreen.
/*!
    Call splashcreen::get() to show it and splashcreen::get()->close() to close it.
    The rest is managed automatically. You don't use the constructor.
    \note Dropped the parent parameters since some warnings on GTK and 
    wxTheApp()-GetTopWindow() is a better solution anyways.
 */
class splashscreen : public wxSplashScreen
{

    // I guess one doesn't use DECLARE_DYNAMIC_CLASS on these.
    
public:

    //! Constructor.
    /*! 
        \param parent Parent window. Autogenerated to be the wxTheApp->GetTopWindow().
            May be NULL.
        \param bitmap Bitmap of the splashscreen.
     */
    splashscreen( wxWindow* parent = NULL,
                  const wxBitmap& bitmap = wxNullBitmap 
                );

    //! Destructor.
    ~splashscreen();

    //! Gets the global object or creates one if none exists.
    /*! 
        \param create_on_demand TRUE to create if not exist. Otherwise
            don't create one [useful if you just want to get() to close it.]
     */
    static splashscreen* get( bool create_on_demand = TRUE );
    
    //!Sets the global object and returns a pointer to previous one (may be NULL).
    static splashscreen* set( splashscreen* desired_splashscreen );

    //! Closes the splashscreen.
    void close();

private:
    
    //! Singleton instance.
    static splashscreen* ms_instance;  
};
  
//----------------------------------------------------------------------------------------
// End feature removal condition
//----------------------------------------------------------------------------------------

#endif  // setupUSE_SPLASHSCREEN

//----------------------------------------------------------------------------------------
// End single inclusion of this .h file condition
//----------------------------------------------------------------------------------------

#endif  //_WRAPPER_SPLASHCREEN_H_

