
#include "image.h"
#include <stdlib.h>


image_t *imagecreate( int width, int height )
{
   int i;
   image_t *image;
   
   image = (image_t*)malloc( sizeof(image_t) );
   image->width  = width;
   image->height = height;
   image->xbytes = (width + 7) / 8;
   image->bitmap = (png_bytep)calloc( image->xbytes + 1, height );
   image->rowps  = (png_bytep*)malloc( sizeof( png_bytep ) * height );
   
   for( i = 0; i < height; i ++ )
   {
      image->rowps[i] = image->bitmap + (i * image->xbytes);
   }
   
   return image;
}


void imagedestroy( image_t *image )
{
   free( image->bitmap );
   free( image->rowps );
   free( image );
   image = NULL;
}
