# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from .proxy_resource import ProxyResource


class Webhook(ProxyResource):
    """Definition of the webhook type.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Fully qualified resource Id for the resource
    :vartype id: str
    :ivar name: The name of the resource
    :vartype name: str
    :ivar type: The type of the resource.
    :vartype type: str
    :param is_enabled: Gets or sets the value of the enabled flag of the
     webhook. Default value: False .
    :type is_enabled: bool
    :param uri: Gets or sets the webhook uri.
    :type uri: str
    :param expiry_time: Gets or sets the expiry time.
    :type expiry_time: datetime
    :param last_invoked_time: Gets or sets the last invoked time.
    :type last_invoked_time: datetime
    :param parameters: Gets or sets the parameters of the job that is created
     when the webhook calls the runbook it is associated with.
    :type parameters: dict[str, str]
    :param runbook: Gets or sets the runbook the webhook is associated with.
    :type runbook: ~azure.mgmt.automation.models.RunbookAssociationProperty
    :param run_on: Gets or sets the name of the hybrid worker group the
     webhook job will run on.
    :type run_on: str
    :param creation_time: Gets or sets the creation time.
    :type creation_time: datetime
    :param last_modified_time: Gets or sets the last modified time.
    :type last_modified_time: datetime
    :param last_modified_by: Details of the user who last modified the Webhook
    :type last_modified_by: str
    :param description: Gets or sets the description.
    :type description: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'is_enabled': {'key': 'properties.isEnabled', 'type': 'bool'},
        'uri': {'key': 'properties.uri', 'type': 'str'},
        'expiry_time': {'key': 'properties.expiryTime', 'type': 'iso-8601'},
        'last_invoked_time': {'key': 'properties.lastInvokedTime', 'type': 'iso-8601'},
        'parameters': {'key': 'properties.parameters', 'type': '{str}'},
        'runbook': {'key': 'properties.runbook', 'type': 'RunbookAssociationProperty'},
        'run_on': {'key': 'properties.runOn', 'type': 'str'},
        'creation_time': {'key': 'properties.creationTime', 'type': 'iso-8601'},
        'last_modified_time': {'key': 'properties.lastModifiedTime', 'type': 'iso-8601'},
        'last_modified_by': {'key': 'properties.lastModifiedBy', 'type': 'str'},
        'description': {'key': 'properties.description', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(Webhook, self).__init__(**kwargs)
        self.is_enabled = kwargs.get('is_enabled', False)
        self.uri = kwargs.get('uri', None)
        self.expiry_time = kwargs.get('expiry_time', None)
        self.last_invoked_time = kwargs.get('last_invoked_time', None)
        self.parameters = kwargs.get('parameters', None)
        self.runbook = kwargs.get('runbook', None)
        self.run_on = kwargs.get('run_on', None)
        self.creation_time = kwargs.get('creation_time', None)
        self.last_modified_time = kwargs.get('last_modified_time', None)
        self.last_modified_by = kwargs.get('last_modified_by', None)
        self.description = kwargs.get('description', None)
