# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class ServerPropertiesForCreate(Model):
    """The properties used to create a new server.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: ServerPropertiesForDefaultCreate,
    ServerPropertiesForRestore, ServerPropertiesForGeoRestore,
    ServerPropertiesForReplica

    All required parameters must be populated in order to send to Azure.

    :param version: Server version. Possible values include: '5.6', '5.7'
    :type version: str or ~azure.mgmt.rdbms.mariadb.models.ServerVersion
    :param ssl_enforcement: Enable ssl enforcement or not when connect to
     server. Possible values include: 'Enabled', 'Disabled'
    :type ssl_enforcement: str or
     ~azure.mgmt.rdbms.mariadb.models.SslEnforcementEnum
    :param storage_profile: Storage profile of a server.
    :type storage_profile: ~azure.mgmt.rdbms.mariadb.models.StorageProfile
    :param create_mode: Required. Constant filled by server.
    :type create_mode: str
    """

    _validation = {
        'create_mode': {'required': True},
    }

    _attribute_map = {
        'version': {'key': 'version', 'type': 'str'},
        'ssl_enforcement': {'key': 'sslEnforcement', 'type': 'SslEnforcementEnum'},
        'storage_profile': {'key': 'storageProfile', 'type': 'StorageProfile'},
        'create_mode': {'key': 'createMode', 'type': 'str'},
    }

    _subtype_map = {
        'create_mode': {'Default': 'ServerPropertiesForDefaultCreate', 'PointInTimeRestore': 'ServerPropertiesForRestore', 'GeoRestore': 'ServerPropertiesForGeoRestore', 'Replica': 'ServerPropertiesForReplica'}
    }

    def __init__(self, **kwargs):
        super(ServerPropertiesForCreate, self).__init__(**kwargs)
        self.version = kwargs.get('version', None)
        self.ssl_enforcement = kwargs.get('ssl_enforcement', None)
        self.storage_profile = kwargs.get('storage_profile', None)
        self.create_mode = None
