# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from typing import Any, Optional, TYPE_CHECKING

from azure.core.pipeline.transport import AsyncHttpResponse, HttpRequest
from azure.mgmt.core import AsyncARMPipelineClient
from msrest import Deserializer, Serializer

if TYPE_CHECKING:
    # pylint: disable=unused-import,ungrouped-imports
    from azure.core.credentials_async import AsyncTokenCredential

from ._configuration import VMwareCloudSimpleConfiguration
from .operations import Operations
from .operations import DedicatedCloudNodesOperations
from .operations import DedicatedCloudServicesOperations
from .operations import SkusAvailabilityOperations
from .operations import PrivateCloudsOperations
from .operations import CustomizationPoliciesOperations
from .operations import ResourcePoolsOperations
from .operations import VirtualMachineTemplatesOperations
from .operations import VirtualNetworksOperations
from .operations import UsagesOperations
from .operations import VirtualMachinesOperations
from .. import models


class VMwareCloudSimple(object):
    """Description of the new service.

    :ivar operations: Operations operations
    :vartype operations: azure.mgmt.vmwarecloudsimple.aio.operations.Operations
    :ivar dedicated_cloud_nodes: DedicatedCloudNodesOperations operations
    :vartype dedicated_cloud_nodes: azure.mgmt.vmwarecloudsimple.aio.operations.DedicatedCloudNodesOperations
    :ivar dedicated_cloud_services: DedicatedCloudServicesOperations operations
    :vartype dedicated_cloud_services: azure.mgmt.vmwarecloudsimple.aio.operations.DedicatedCloudServicesOperations
    :ivar skus_availability: SkusAvailabilityOperations operations
    :vartype skus_availability: azure.mgmt.vmwarecloudsimple.aio.operations.SkusAvailabilityOperations
    :ivar private_clouds: PrivateCloudsOperations operations
    :vartype private_clouds: azure.mgmt.vmwarecloudsimple.aio.operations.PrivateCloudsOperations
    :ivar customization_policies: CustomizationPoliciesOperations operations
    :vartype customization_policies: azure.mgmt.vmwarecloudsimple.aio.operations.CustomizationPoliciesOperations
    :ivar resource_pools: ResourcePoolsOperations operations
    :vartype resource_pools: azure.mgmt.vmwarecloudsimple.aio.operations.ResourcePoolsOperations
    :ivar virtual_machine_templates: VirtualMachineTemplatesOperations operations
    :vartype virtual_machine_templates: azure.mgmt.vmwarecloudsimple.aio.operations.VirtualMachineTemplatesOperations
    :ivar virtual_networks: VirtualNetworksOperations operations
    :vartype virtual_networks: azure.mgmt.vmwarecloudsimple.aio.operations.VirtualNetworksOperations
    :ivar usages: UsagesOperations operations
    :vartype usages: azure.mgmt.vmwarecloudsimple.aio.operations.UsagesOperations
    :ivar virtual_machines: VirtualMachinesOperations operations
    :vartype virtual_machines: azure.mgmt.vmwarecloudsimple.aio.operations.VirtualMachinesOperations
    :param credential: Credential needed for the client to connect to Azure.
    :type credential: ~azure.core.credentials_async.AsyncTokenCredential
    :param subscription_id: The subscription ID.
    :type subscription_id: str
    :param referer: referer url.
    :type referer: str
    :param str base_url: Service URL
    :keyword int polling_interval: Default waiting time between two polls for LRO operations if no Retry-After header is present.
    """

    def __init__(
        self,
        credential: "AsyncTokenCredential",
        subscription_id: str,
        referer: str,
        base_url: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        if not base_url:
            base_url = 'https://management.azure.com'
        self._config = VMwareCloudSimpleConfiguration(credential, subscription_id, referer, **kwargs)
        self._client = AsyncARMPipelineClient(base_url=base_url, config=self._config, **kwargs)

        client_models = {k: v for k, v in models.__dict__.items() if isinstance(v, type)}
        self._serialize = Serializer(client_models)
        self._serialize.client_side_validation = False
        self._deserialize = Deserializer(client_models)

        self.operations = Operations(
            self._client, self._config, self._serialize, self._deserialize)
        self.dedicated_cloud_nodes = DedicatedCloudNodesOperations(
            self._client, self._config, self._serialize, self._deserialize)
        self.dedicated_cloud_services = DedicatedCloudServicesOperations(
            self._client, self._config, self._serialize, self._deserialize)
        self.skus_availability = SkusAvailabilityOperations(
            self._client, self._config, self._serialize, self._deserialize)
        self.private_clouds = PrivateCloudsOperations(
            self._client, self._config, self._serialize, self._deserialize)
        self.customization_policies = CustomizationPoliciesOperations(
            self._client, self._config, self._serialize, self._deserialize)
        self.resource_pools = ResourcePoolsOperations(
            self._client, self._config, self._serialize, self._deserialize)
        self.virtual_machine_templates = VirtualMachineTemplatesOperations(
            self._client, self._config, self._serialize, self._deserialize)
        self.virtual_networks = VirtualNetworksOperations(
            self._client, self._config, self._serialize, self._deserialize)
        self.usages = UsagesOperations(
            self._client, self._config, self._serialize, self._deserialize)
        self.virtual_machines = VirtualMachinesOperations(
            self._client, self._config, self._serialize, self._deserialize)

    async def _send_request(self, http_request: HttpRequest, **kwargs: Any) -> AsyncHttpResponse:
        """Runs the network request through the client's chained policies.

        :param http_request: The network request you want to make. Required.
        :type http_request: ~azure.core.pipeline.transport.HttpRequest
        :keyword bool stream: Whether the response payload will be streamed. Defaults to True.
        :return: The response of your network call. Does not do error handling on your response.
        :rtype: ~azure.core.pipeline.transport.AsyncHttpResponse
        """
        path_format_arguments = {
            'subscriptionId': self._serialize.url("self._config.subscription_id", self._config.subscription_id, 'str'),
        }
        http_request.url = self._client.format_url(http_request.url, **path_format_arguments)
        stream = kwargs.pop("stream", True)
        pipeline_response = await self._client._pipeline.run(http_request, stream=stream, **kwargs)
        return pipeline_response.http_response

    async def close(self) -> None:
        await self._client.close()

    async def __aenter__(self) -> "VMwareCloudSimple":
        await self._client.__aenter__()
        return self

    async def __aexit__(self, *exc_details) -> None:
        await self._client.__aexit__(*exc_details)
