# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class Job(Model):
    """A device job.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: The path ID that uniquely identifies the object.
    :vartype id: str
    :ivar name: The name of the object.
    :vartype name: str
    :ivar type: The hierarchical type of the object.
    :vartype type: str
    :ivar status: The current status of the job. Possible values include:
     'Invalid', 'Running', 'Succeeded', 'Failed', 'Canceled', 'Paused',
     'Scheduled'
    :vartype status: str or ~azure.mgmt.edgegateway.models.JobStatus
    :ivar start_time: The UTC date and time at which the job started.
    :vartype start_time: datetime
    :ivar end_time: The UTC date and time at which the job completed.
    :vartype end_time: datetime
    :ivar percent_complete: The percentage of the job that is complete.
    :vartype percent_complete: int
    :ivar error: The error details.
    :vartype error: ~azure.mgmt.edgegateway.models.JobErrorDetails
    :ivar job_type: The type of the job. Possible values include: 'Invalid',
     'ScanForUpdates', 'DownloadUpdates', 'InstallUpdates', 'RefreshShare'
    :vartype job_type: str or ~azure.mgmt.edgegateway.models.JobType
    :ivar current_stage: Current stage of the update operation. Possible
     values include: 'Unknown', 'Initial', 'ScanStarted', 'ScanComplete',
     'ScanFailed', 'DownloadStarted', 'DownloadComplete', 'DownloadFailed',
     'InstallStarted', 'InstallComplete', 'InstallFailed', 'RebootInitiated',
     'Success', 'Failure', 'RescanStarted', 'RescanComplete', 'RescanFailed'
    :vartype current_stage: str or
     ~azure.mgmt.edgegateway.models.UpdateOperationStage
    :ivar download_progress: The download progress.
    :vartype download_progress:
     ~azure.mgmt.edgegateway.models.UpdateDownloadProgress
    :ivar install_progress: The install progress.
    :vartype install_progress:
     ~azure.mgmt.edgegateway.models.UpdateInstallProgress
    :ivar total_refresh_errors: Total number of errors encountered during the
     refresh process.
    :vartype total_refresh_errors: int
    :ivar error_manifest_file: Local share/remote container relative path to
     the error manifest file of the refresh.
    :vartype error_manifest_file: str
    :ivar share_id: ARM ID of the share that was refreshed.
    :vartype share_id: str
    :param folder: If only subfolders need to be refreshed, then the subfolder
     path inside the share. (The path is empty if there are no subfolders.)
    :type folder: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'status': {'readonly': True},
        'start_time': {'readonly': True},
        'end_time': {'readonly': True},
        'percent_complete': {'readonly': True},
        'error': {'readonly': True},
        'job_type': {'readonly': True},
        'current_stage': {'readonly': True},
        'download_progress': {'readonly': True},
        'install_progress': {'readonly': True},
        'total_refresh_errors': {'readonly': True},
        'error_manifest_file': {'readonly': True},
        'share_id': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'status': {'key': 'status', 'type': 'str'},
        'start_time': {'key': 'startTime', 'type': 'iso-8601'},
        'end_time': {'key': 'endTime', 'type': 'iso-8601'},
        'percent_complete': {'key': 'percentComplete', 'type': 'int'},
        'error': {'key': 'error', 'type': 'JobErrorDetails'},
        'job_type': {'key': 'properties.jobType', 'type': 'str'},
        'current_stage': {'key': 'properties.currentStage', 'type': 'str'},
        'download_progress': {'key': 'properties.downloadProgress', 'type': 'UpdateDownloadProgress'},
        'install_progress': {'key': 'properties.installProgress', 'type': 'UpdateInstallProgress'},
        'total_refresh_errors': {'key': 'properties.totalRefreshErrors', 'type': 'int'},
        'error_manifest_file': {'key': 'properties.errorManifestFile', 'type': 'str'},
        'share_id': {'key': 'properties.shareId', 'type': 'str'},
        'folder': {'key': 'properties.folder', 'type': 'str'},
    }

    def __init__(self, *, folder: str=None, **kwargs) -> None:
        super(Job, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.status = None
        self.start_time = None
        self.end_time = None
        self.percent_complete = None
        self.error = None
        self.job_type = None
        self.current_stage = None
        self.download_progress = None
        self.install_progress = None
        self.total_refresh_errors = None
        self.error_manifest_file = None
        self.share_id = None
        self.folder = folder
