# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from azure.core.exceptions import HttpResponseError
import msrest.serialization


class AccessKeys(msrest.serialization.Model):
    """The Account access keys.

    :param atlas_kafka_primary_endpoint: Gets or sets the primary connection string.
    :type atlas_kafka_primary_endpoint: str
    :param atlas_kafka_secondary_endpoint: Gets or sets the secondary connection string.
    :type atlas_kafka_secondary_endpoint: str
    """

    _attribute_map = {
        'atlas_kafka_primary_endpoint': {'key': 'atlasKafkaPrimaryEndpoint', 'type': 'str'},
        'atlas_kafka_secondary_endpoint': {'key': 'atlasKafkaSecondaryEndpoint', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AccessKeys, self).__init__(**kwargs)
        self.atlas_kafka_primary_endpoint = kwargs.get('atlas_kafka_primary_endpoint', None)
        self.atlas_kafka_secondary_endpoint = kwargs.get('atlas_kafka_secondary_endpoint', None)


class TrackedResource(msrest.serialization.Model):
    """Azure ARM Tracked Resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Gets or sets the identifier.
    :vartype id: str
    :param identity: Identity Info on the tracked resource.
    :type identity: ~azure.mgmt.purview.models.Identity
    :param location: Gets or sets the location.
    :type location: str
    :ivar name: Gets or sets the name.
    :vartype name: str
    :ivar system_data: Metadata pertaining to creation and last modification of the resource.
    :vartype system_data: ~azure.mgmt.purview.models.TrackedResourceSystemData
    :param tags: A set of tags. Tags on the azure resource.
    :type tags: dict[str, str]
    :ivar type: Gets or sets the type.
    :vartype type: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'system_data': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'identity': {'key': 'identity', 'type': 'Identity'},
        'location': {'key': 'location', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'TrackedResourceSystemData'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(TrackedResource, self).__init__(**kwargs)
        self.id = None
        self.identity = kwargs.get('identity', None)
        self.location = kwargs.get('location', None)
        self.name = None
        self.system_data = None
        self.tags = kwargs.get('tags', None)
        self.type = None


class Account(TrackedResource):
    """Account resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Gets or sets the identifier.
    :vartype id: str
    :param identity: Identity Info on the tracked resource.
    :type identity: ~azure.mgmt.purview.models.Identity
    :param location: Gets or sets the location.
    :type location: str
    :ivar name: Gets or sets the name.
    :vartype name: str
    :ivar system_data: Metadata pertaining to creation and last modification of the resource.
    :vartype system_data: ~azure.mgmt.purview.models.TrackedResourceSystemData
    :param tags: A set of tags. Tags on the azure resource.
    :type tags: dict[str, str]
    :ivar type: Gets or sets the type.
    :vartype type: str
    :param sku: Gets or sets the Sku.
    :type sku: ~azure.mgmt.purview.models.AccountSku
    :param cloud_connectors: Cloud connectors.
     External cloud identifier used as part of scanning configuration.
    :type cloud_connectors: ~azure.mgmt.purview.models.CloudConnectors
    :ivar created_at: Gets the time at which the entity was created.
    :vartype created_at: ~datetime.datetime
    :ivar created_by: Gets the creator of the entity.
    :vartype created_by: str
    :ivar created_by_object_id: Gets the creators of the entity's object id.
    :vartype created_by_object_id: str
    :ivar endpoints: The URIs that are the public endpoints of the account.
    :vartype endpoints: ~azure.mgmt.purview.models.AccountPropertiesEndpoints
    :ivar friendly_name: Gets or sets the friendly name.
    :vartype friendly_name: str
    :param managed_resource_group_name: Gets or sets the managed resource group name.
    :type managed_resource_group_name: str
    :ivar managed_resources: Gets the resource identifiers of the managed resources.
    :vartype managed_resources: ~azure.mgmt.purview.models.AccountPropertiesManagedResources
    :ivar private_endpoint_connections: Gets the private endpoint connections information.
    :vartype private_endpoint_connections:
     list[~azure.mgmt.purview.models.PrivateEndpointConnection]
    :ivar provisioning_state: Gets or sets the state of the provisioning. Possible values include:
     "Unknown", "Creating", "Moving", "Deleting", "SoftDeleting", "SoftDeleted", "Failed",
     "Succeeded", "Canceled".
    :vartype provisioning_state: str or ~azure.mgmt.purview.models.ProvisioningState
    :param public_network_access: Gets or sets the public network access. Possible values include:
     "NotSpecified", "Enabled", "Disabled". Default value: "Enabled".
    :type public_network_access: str or ~azure.mgmt.purview.models.PublicNetworkAccess
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'system_data': {'readonly': True},
        'type': {'readonly': True},
        'created_at': {'readonly': True},
        'created_by': {'readonly': True},
        'created_by_object_id': {'readonly': True},
        'endpoints': {'readonly': True},
        'friendly_name': {'readonly': True},
        'managed_resources': {'readonly': True},
        'private_endpoint_connections': {'readonly': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'identity': {'key': 'identity', 'type': 'Identity'},
        'location': {'key': 'location', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'TrackedResourceSystemData'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'type': {'key': 'type', 'type': 'str'},
        'sku': {'key': 'sku', 'type': 'AccountSku'},
        'cloud_connectors': {'key': 'properties.cloudConnectors', 'type': 'CloudConnectors'},
        'created_at': {'key': 'properties.createdAt', 'type': 'iso-8601'},
        'created_by': {'key': 'properties.createdBy', 'type': 'str'},
        'created_by_object_id': {'key': 'properties.createdByObjectId', 'type': 'str'},
        'endpoints': {'key': 'properties.endpoints', 'type': 'AccountPropertiesEndpoints'},
        'friendly_name': {'key': 'properties.friendlyName', 'type': 'str'},
        'managed_resource_group_name': {'key': 'properties.managedResourceGroupName', 'type': 'str'},
        'managed_resources': {'key': 'properties.managedResources', 'type': 'AccountPropertiesManagedResources'},
        'private_endpoint_connections': {'key': 'properties.privateEndpointConnections', 'type': '[PrivateEndpointConnection]'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'public_network_access': {'key': 'properties.publicNetworkAccess', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Account, self).__init__(**kwargs)
        self.sku = kwargs.get('sku', None)
        self.cloud_connectors = kwargs.get('cloud_connectors', None)
        self.created_at = None
        self.created_by = None
        self.created_by_object_id = None
        self.endpoints = None
        self.friendly_name = None
        self.managed_resource_group_name = kwargs.get('managed_resource_group_name', None)
        self.managed_resources = None
        self.private_endpoint_connections = None
        self.provisioning_state = None
        self.public_network_access = kwargs.get('public_network_access', "Enabled")


class AccountEndpoints(msrest.serialization.Model):
    """The account endpoints.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar catalog: Gets the catalog endpoint.
    :vartype catalog: str
    :ivar guardian: Gets the guardian endpoint.
    :vartype guardian: str
    :ivar scan: Gets the scan endpoint.
    :vartype scan: str
    """

    _validation = {
        'catalog': {'readonly': True},
        'guardian': {'readonly': True},
        'scan': {'readonly': True},
    }

    _attribute_map = {
        'catalog': {'key': 'catalog', 'type': 'str'},
        'guardian': {'key': 'guardian', 'type': 'str'},
        'scan': {'key': 'scan', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AccountEndpoints, self).__init__(**kwargs)
        self.catalog = None
        self.guardian = None
        self.scan = None


class AccountList(msrest.serialization.Model):
    """Paged list of account resources.

    All required parameters must be populated in order to send to Azure.

    :param count: Total item count.
    :type count: long
    :param next_link: The Url of next result page.
    :type next_link: str
    :param value: Required. Collection of items of type results.
    :type value: list[~azure.mgmt.purview.models.Account]
    """

    _validation = {
        'value': {'required': True},
    }

    _attribute_map = {
        'count': {'key': 'count', 'type': 'long'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
        'value': {'key': 'value', 'type': '[Account]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AccountList, self).__init__(**kwargs)
        self.count = kwargs.get('count', None)
        self.next_link = kwargs.get('next_link', None)
        self.value = kwargs['value']


class AccountProperties(msrest.serialization.Model):
    """The account properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param cloud_connectors: Cloud connectors.
     External cloud identifier used as part of scanning configuration.
    :type cloud_connectors: ~azure.mgmt.purview.models.CloudConnectors
    :ivar created_at: Gets the time at which the entity was created.
    :vartype created_at: ~datetime.datetime
    :ivar created_by: Gets the creator of the entity.
    :vartype created_by: str
    :ivar created_by_object_id: Gets the creators of the entity's object id.
    :vartype created_by_object_id: str
    :ivar endpoints: The URIs that are the public endpoints of the account.
    :vartype endpoints: ~azure.mgmt.purview.models.AccountPropertiesEndpoints
    :ivar friendly_name: Gets or sets the friendly name.
    :vartype friendly_name: str
    :param managed_resource_group_name: Gets or sets the managed resource group name.
    :type managed_resource_group_name: str
    :ivar managed_resources: Gets the resource identifiers of the managed resources.
    :vartype managed_resources: ~azure.mgmt.purview.models.AccountPropertiesManagedResources
    :ivar private_endpoint_connections: Gets the private endpoint connections information.
    :vartype private_endpoint_connections:
     list[~azure.mgmt.purview.models.PrivateEndpointConnection]
    :ivar provisioning_state: Gets or sets the state of the provisioning. Possible values include:
     "Unknown", "Creating", "Moving", "Deleting", "SoftDeleting", "SoftDeleted", "Failed",
     "Succeeded", "Canceled".
    :vartype provisioning_state: str or ~azure.mgmt.purview.models.ProvisioningState
    :param public_network_access: Gets or sets the public network access. Possible values include:
     "NotSpecified", "Enabled", "Disabled". Default value: "Enabled".
    :type public_network_access: str or ~azure.mgmt.purview.models.PublicNetworkAccess
    """

    _validation = {
        'created_at': {'readonly': True},
        'created_by': {'readonly': True},
        'created_by_object_id': {'readonly': True},
        'endpoints': {'readonly': True},
        'friendly_name': {'readonly': True},
        'managed_resources': {'readonly': True},
        'private_endpoint_connections': {'readonly': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'cloud_connectors': {'key': 'cloudConnectors', 'type': 'CloudConnectors'},
        'created_at': {'key': 'createdAt', 'type': 'iso-8601'},
        'created_by': {'key': 'createdBy', 'type': 'str'},
        'created_by_object_id': {'key': 'createdByObjectId', 'type': 'str'},
        'endpoints': {'key': 'endpoints', 'type': 'AccountPropertiesEndpoints'},
        'friendly_name': {'key': 'friendlyName', 'type': 'str'},
        'managed_resource_group_name': {'key': 'managedResourceGroupName', 'type': 'str'},
        'managed_resources': {'key': 'managedResources', 'type': 'AccountPropertiesManagedResources'},
        'private_endpoint_connections': {'key': 'privateEndpointConnections', 'type': '[PrivateEndpointConnection]'},
        'provisioning_state': {'key': 'provisioningState', 'type': 'str'},
        'public_network_access': {'key': 'publicNetworkAccess', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AccountProperties, self).__init__(**kwargs)
        self.cloud_connectors = kwargs.get('cloud_connectors', None)
        self.created_at = None
        self.created_by = None
        self.created_by_object_id = None
        self.endpoints = None
        self.friendly_name = None
        self.managed_resource_group_name = kwargs.get('managed_resource_group_name', None)
        self.managed_resources = None
        self.private_endpoint_connections = None
        self.provisioning_state = None
        self.public_network_access = kwargs.get('public_network_access', "Enabled")


class AccountPropertiesEndpoints(AccountEndpoints):
    """The URIs that are the public endpoints of the account.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar catalog: Gets the catalog endpoint.
    :vartype catalog: str
    :ivar guardian: Gets the guardian endpoint.
    :vartype guardian: str
    :ivar scan: Gets the scan endpoint.
    :vartype scan: str
    """

    _validation = {
        'catalog': {'readonly': True},
        'guardian': {'readonly': True},
        'scan': {'readonly': True},
    }

    _attribute_map = {
        'catalog': {'key': 'catalog', 'type': 'str'},
        'guardian': {'key': 'guardian', 'type': 'str'},
        'scan': {'key': 'scan', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AccountPropertiesEndpoints, self).__init__(**kwargs)


class ManagedResources(msrest.serialization.Model):
    """The managed resources in customer subscription.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar event_hub_namespace: Gets the managed event hub namespace resource identifier.
    :vartype event_hub_namespace: str
    :ivar resource_group: Gets the managed resource group resource identifier. This resource group
     will host resource dependencies for the account.
    :vartype resource_group: str
    :ivar storage_account: Gets the managed storage account resource identifier.
    :vartype storage_account: str
    """

    _validation = {
        'event_hub_namespace': {'readonly': True},
        'resource_group': {'readonly': True},
        'storage_account': {'readonly': True},
    }

    _attribute_map = {
        'event_hub_namespace': {'key': 'eventHubNamespace', 'type': 'str'},
        'resource_group': {'key': 'resourceGroup', 'type': 'str'},
        'storage_account': {'key': 'storageAccount', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ManagedResources, self).__init__(**kwargs)
        self.event_hub_namespace = None
        self.resource_group = None
        self.storage_account = None


class AccountPropertiesManagedResources(ManagedResources):
    """Gets the resource identifiers of the managed resources.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar event_hub_namespace: Gets the managed event hub namespace resource identifier.
    :vartype event_hub_namespace: str
    :ivar resource_group: Gets the managed resource group resource identifier. This resource group
     will host resource dependencies for the account.
    :vartype resource_group: str
    :ivar storage_account: Gets the managed storage account resource identifier.
    :vartype storage_account: str
    """

    _validation = {
        'event_hub_namespace': {'readonly': True},
        'resource_group': {'readonly': True},
        'storage_account': {'readonly': True},
    }

    _attribute_map = {
        'event_hub_namespace': {'key': 'eventHubNamespace', 'type': 'str'},
        'resource_group': {'key': 'resourceGroup', 'type': 'str'},
        'storage_account': {'key': 'storageAccount', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AccountPropertiesManagedResources, self).__init__(**kwargs)


class AccountSku(msrest.serialization.Model):
    """The Sku.

    :param capacity: Gets or sets the sku capacity. Possible values include: 4, 16.
    :type capacity: int
    :param name: Gets or sets the sku name. Possible values include: "Standard".
    :type name: str or ~azure.mgmt.purview.models.Name
    """

    _attribute_map = {
        'capacity': {'key': 'capacity', 'type': 'int'},
        'name': {'key': 'name', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AccountSku, self).__init__(**kwargs)
        self.capacity = kwargs.get('capacity', None)
        self.name = kwargs.get('name', None)


class AccountUpdateParameters(msrest.serialization.Model):
    """The account update properties.

    :param properties: The account properties.
    :type properties: ~azure.mgmt.purview.models.AccountProperties
    :param tags: A set of tags. Tags on the azure resource.
    :type tags: dict[str, str]
    """

    _attribute_map = {
        'properties': {'key': 'properties', 'type': 'AccountProperties'},
        'tags': {'key': 'tags', 'type': '{str}'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AccountUpdateParameters, self).__init__(**kwargs)
        self.properties = kwargs.get('properties', None)
        self.tags = kwargs.get('tags', None)


class CheckNameAvailabilityRequest(msrest.serialization.Model):
    """The request payload for CheckNameAvailability API.

    :param name: Resource name to verify for availability.
    :type name: str
    :param type: Fully qualified resource type which includes provider namespace.
    :type type: str
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(CheckNameAvailabilityRequest, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.type = kwargs.get('type', None)


class CheckNameAvailabilityResult(msrest.serialization.Model):
    """The response payload for CheckNameAvailability API.

    :param message: Error message.
    :type message: str
    :param name_available: Indicates if name is valid and available.
    :type name_available: bool
    :param reason: The reason the name is not available. Possible values include: "Invalid",
     "AlreadyExists".
    :type reason: str or ~azure.mgmt.purview.models.Reason
    """

    _attribute_map = {
        'message': {'key': 'message', 'type': 'str'},
        'name_available': {'key': 'nameAvailable', 'type': 'bool'},
        'reason': {'key': 'reason', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(CheckNameAvailabilityResult, self).__init__(**kwargs)
        self.message = kwargs.get('message', None)
        self.name_available = kwargs.get('name_available', None)
        self.reason = kwargs.get('reason', None)


class CloudConnectors(msrest.serialization.Model):
    """CloudConnectors.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar aws_external_id: AWS external identifier.
     Configured in AWS to allow use of the role arn used for scanning.
    :vartype aws_external_id: str
    """

    _validation = {
        'aws_external_id': {'readonly': True},
    }

    _attribute_map = {
        'aws_external_id': {'key': 'awsExternalId', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(CloudConnectors, self).__init__(**kwargs)
        self.aws_external_id = None


class CollectionAdminUpdate(msrest.serialization.Model):
    """Collection administrator update.

    :param object_id: Gets or sets the object identifier of the admin.
    :type object_id: str
    """

    _attribute_map = {
        'object_id': {'key': 'objectId', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(CollectionAdminUpdate, self).__init__(**kwargs)
        self.object_id = kwargs.get('object_id', None)


class DefaultAccountPayload(msrest.serialization.Model):
    """Payload to get and set the default account in the given scope.

    :param account_name: The name of the account that is set as the default.
    :type account_name: str
    :param resource_group_name: The resource group name of the account that is set as the default.
    :type resource_group_name: str
    :param scope: The scope object ID. For example, sub ID or tenant ID.
    :type scope: str
    :param scope_tenant_id: The scope tenant in which the default account is set.
    :type scope_tenant_id: str
    :param scope_type: The scope where the default account is set. Possible values include:
     "Tenant", "Subscription".
    :type scope_type: str or ~azure.mgmt.purview.models.ScopeType
    :param subscription_id: The subscription ID of the account that is set as the default.
    :type subscription_id: str
    """

    _attribute_map = {
        'account_name': {'key': 'accountName', 'type': 'str'},
        'resource_group_name': {'key': 'resourceGroupName', 'type': 'str'},
        'scope': {'key': 'scope', 'type': 'str'},
        'scope_tenant_id': {'key': 'scopeTenantId', 'type': 'str'},
        'scope_type': {'key': 'scopeType', 'type': 'str'},
        'subscription_id': {'key': 'subscriptionId', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(DefaultAccountPayload, self).__init__(**kwargs)
        self.account_name = kwargs.get('account_name', None)
        self.resource_group_name = kwargs.get('resource_group_name', None)
        self.scope = kwargs.get('scope', None)
        self.scope_tenant_id = kwargs.get('scope_tenant_id', None)
        self.scope_type = kwargs.get('scope_type', None)
        self.subscription_id = kwargs.get('subscription_id', None)


class DimensionProperties(msrest.serialization.Model):
    """properties for dimension.

    :param display_name: localized display name of the dimension to customer.
    :type display_name: str
    :param name: dimension name.
    :type name: str
    :param to_be_exported_for_customer: flag indicating whether this dimension should be included
     to the customer in Azure Monitor logs (aka Shoebox).
    :type to_be_exported_for_customer: bool
    """

    _attribute_map = {
        'display_name': {'key': 'displayName', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'to_be_exported_for_customer': {'key': 'toBeExportedForCustomer', 'type': 'bool'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(DimensionProperties, self).__init__(**kwargs)
        self.display_name = kwargs.get('display_name', None)
        self.name = kwargs.get('name', None)
        self.to_be_exported_for_customer = kwargs.get('to_be_exported_for_customer', None)


class ErrorModel(msrest.serialization.Model):
    """Default error model.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar code: Gets or sets the code.
    :vartype code: str
    :ivar details: Gets or sets the details.
    :vartype details: list[~azure.mgmt.purview.models.ErrorModel]
    :ivar message: Gets or sets the messages.
    :vartype message: str
    :ivar target: Gets or sets the target.
    :vartype target: str
    """

    _validation = {
        'code': {'readonly': True},
        'details': {'readonly': True},
        'message': {'readonly': True},
        'target': {'readonly': True},
    }

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'details': {'key': 'details', 'type': '[ErrorModel]'},
        'message': {'key': 'message', 'type': 'str'},
        'target': {'key': 'target', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ErrorModel, self).__init__(**kwargs)
        self.code = None
        self.details = None
        self.message = None
        self.target = None


class ErrorResponseModel(msrest.serialization.Model):
    """Default error response model.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar error: Gets or sets the error.
    :vartype error: ~azure.mgmt.purview.models.ErrorResponseModelError
    """

    _validation = {
        'error': {'readonly': True},
    }

    _attribute_map = {
        'error': {'key': 'error', 'type': 'ErrorResponseModelError'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ErrorResponseModel, self).__init__(**kwargs)
        self.error = None


class ErrorResponseModelError(ErrorModel):
    """Gets or sets the error.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar code: Gets or sets the code.
    :vartype code: str
    :ivar details: Gets or sets the details.
    :vartype details: list[~azure.mgmt.purview.models.ErrorModel]
    :ivar message: Gets or sets the messages.
    :vartype message: str
    :ivar target: Gets or sets the target.
    :vartype target: str
    """

    _validation = {
        'code': {'readonly': True},
        'details': {'readonly': True},
        'message': {'readonly': True},
        'target': {'readonly': True},
    }

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'details': {'key': 'details', 'type': '[ErrorModel]'},
        'message': {'key': 'message', 'type': 'str'},
        'target': {'key': 'target', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ErrorResponseModelError, self).__init__(**kwargs)


class Identity(msrest.serialization.Model):
    """The Managed Identity of the resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar principal_id: Service principal object Id.
    :vartype principal_id: str
    :ivar tenant_id: Tenant Id.
    :vartype tenant_id: str
    :param type: Identity Type. Possible values include: "SystemAssigned".
    :type type: str or ~azure.mgmt.purview.models.Type
    """

    _validation = {
        'principal_id': {'readonly': True},
        'tenant_id': {'readonly': True},
    }

    _attribute_map = {
        'principal_id': {'key': 'principalId', 'type': 'str'},
        'tenant_id': {'key': 'tenantId', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Identity, self).__init__(**kwargs)
        self.principal_id = None
        self.tenant_id = None
        self.type = kwargs.get('type', None)


class Operation(msrest.serialization.Model):
    """Operation resource.

    :param display: Properties on the operation.
    :type display: ~azure.mgmt.purview.models.OperationDisplay
    :param is_data_action: Whether operation is a data action.
    :type is_data_action: bool
    :param name: Operation name for display purposes.
    :type name: str
    :param origin: origin of the operation.
    :type origin: str
    :param service_specification: meta service specification.
    :type service_specification: ~azure.mgmt.purview.models.OperationMetaServiceSpecification
    """

    _attribute_map = {
        'display': {'key': 'display', 'type': 'OperationDisplay'},
        'is_data_action': {'key': 'isDataAction', 'type': 'bool'},
        'name': {'key': 'name', 'type': 'str'},
        'origin': {'key': 'origin', 'type': 'str'},
        'service_specification': {'key': 'properties.serviceSpecification', 'type': 'OperationMetaServiceSpecification'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Operation, self).__init__(**kwargs)
        self.display = kwargs.get('display', None)
        self.is_data_action = kwargs.get('is_data_action', None)
        self.name = kwargs.get('name', None)
        self.origin = kwargs.get('origin', None)
        self.service_specification = kwargs.get('service_specification', None)


class OperationDisplay(msrest.serialization.Model):
    """The response model for get operation properties.

    :param description: Description of the operation for display purposes.
    :type description: str
    :param operation: Name of the operation for display purposes.
    :type operation: str
    :param provider: Name of the provider for display purposes.
    :type provider: str
    :param resource: Name of the resource type for display purposes.
    :type resource: str
    """

    _attribute_map = {
        'description': {'key': 'description', 'type': 'str'},
        'operation': {'key': 'operation', 'type': 'str'},
        'provider': {'key': 'provider', 'type': 'str'},
        'resource': {'key': 'resource', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(OperationDisplay, self).__init__(**kwargs)
        self.description = kwargs.get('description', None)
        self.operation = kwargs.get('operation', None)
        self.provider = kwargs.get('provider', None)
        self.resource = kwargs.get('resource', None)


class OperationList(msrest.serialization.Model):
    """Paged list of operation resources.

    All required parameters must be populated in order to send to Azure.

    :param count: Total item count.
    :type count: long
    :param next_link: The Url of next result page.
    :type next_link: str
    :param value: Required. Collection of items of type results.
    :type value: list[~azure.mgmt.purview.models.Operation]
    """

    _validation = {
        'value': {'required': True},
    }

    _attribute_map = {
        'count': {'key': 'count', 'type': 'long'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
        'value': {'key': 'value', 'type': '[Operation]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(OperationList, self).__init__(**kwargs)
        self.count = kwargs.get('count', None)
        self.next_link = kwargs.get('next_link', None)
        self.value = kwargs['value']


class OperationMetaLogSpecification(msrest.serialization.Model):
    """log specifications for operation api.

    :param blob_duration: blob duration of the log.
    :type blob_duration: str
    :param display_name: localized name of the log category.
    :type display_name: str
    :param name: name of the log category.
    :type name: str
    """

    _attribute_map = {
        'blob_duration': {'key': 'blobDuration', 'type': 'str'},
        'display_name': {'key': 'displayName', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(OperationMetaLogSpecification, self).__init__(**kwargs)
        self.blob_duration = kwargs.get('blob_duration', None)
        self.display_name = kwargs.get('display_name', None)
        self.name = kwargs.get('name', None)


class OperationMetaMetricSpecification(msrest.serialization.Model):
    """metric specifications for the operation.

    :param aggregation_type: aggregation type of metric.
    :type aggregation_type: str
    :param dimensions: properties for dimension.
    :type dimensions: list[~azure.mgmt.purview.models.DimensionProperties]
    :param display_description: description of the metric.
    :type display_description: str
    :param display_name: localized name of the metric.
    :type display_name: str
    :param enable_regional_mdm_account: enable regional mdm account.
    :type enable_regional_mdm_account: str
    :param internal_metric_name: internal metric name.
    :type internal_metric_name: str
    :param name: name of the metric.
    :type name: str
    :param resource_id_dimension_name_override: dimension name use to replace resource id if
     specified.
    :type resource_id_dimension_name_override: str
    :param source_mdm_namespace: Metric namespace.
     Only set the namespace if different from the default value,
     leaving it empty makes it use the value from the ARM manifest.
    :type source_mdm_namespace: str
    :param supported_aggregation_types: supported aggregation types.
    :type supported_aggregation_types: list[str]
    :param supported_time_grain_types: supported time grain types.
    :type supported_time_grain_types: list[str]
    :param unit: units for the metric.
    :type unit: str
    """

    _attribute_map = {
        'aggregation_type': {'key': 'aggregationType', 'type': 'str'},
        'dimensions': {'key': 'dimensions', 'type': '[DimensionProperties]'},
        'display_description': {'key': 'displayDescription', 'type': 'str'},
        'display_name': {'key': 'displayName', 'type': 'str'},
        'enable_regional_mdm_account': {'key': 'enableRegionalMdmAccount', 'type': 'str'},
        'internal_metric_name': {'key': 'internalMetricName', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'resource_id_dimension_name_override': {'key': 'resourceIdDimensionNameOverride', 'type': 'str'},
        'source_mdm_namespace': {'key': 'sourceMdmNamespace', 'type': 'str'},
        'supported_aggregation_types': {'key': 'supportedAggregationTypes', 'type': '[str]'},
        'supported_time_grain_types': {'key': 'supportedTimeGrainTypes', 'type': '[str]'},
        'unit': {'key': 'unit', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(OperationMetaMetricSpecification, self).__init__(**kwargs)
        self.aggregation_type = kwargs.get('aggregation_type', None)
        self.dimensions = kwargs.get('dimensions', None)
        self.display_description = kwargs.get('display_description', None)
        self.display_name = kwargs.get('display_name', None)
        self.enable_regional_mdm_account = kwargs.get('enable_regional_mdm_account', None)
        self.internal_metric_name = kwargs.get('internal_metric_name', None)
        self.name = kwargs.get('name', None)
        self.resource_id_dimension_name_override = kwargs.get('resource_id_dimension_name_override', None)
        self.source_mdm_namespace = kwargs.get('source_mdm_namespace', None)
        self.supported_aggregation_types = kwargs.get('supported_aggregation_types', None)
        self.supported_time_grain_types = kwargs.get('supported_time_grain_types', None)
        self.unit = kwargs.get('unit', None)


class OperationMetaServiceSpecification(msrest.serialization.Model):
    """The operation meta service specification.

    :param log_specifications: log specifications for the operation.
    :type log_specifications: list[~azure.mgmt.purview.models.OperationMetaLogSpecification]
    :param metric_specifications: metric specifications for the operation.
    :type metric_specifications: list[~azure.mgmt.purview.models.OperationMetaMetricSpecification]
    """

    _attribute_map = {
        'log_specifications': {'key': 'logSpecifications', 'type': '[OperationMetaLogSpecification]'},
        'metric_specifications': {'key': 'metricSpecifications', 'type': '[OperationMetaMetricSpecification]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(OperationMetaServiceSpecification, self).__init__(**kwargs)
        self.log_specifications = kwargs.get('log_specifications', None)
        self.metric_specifications = kwargs.get('metric_specifications', None)


class PrivateEndpoint(msrest.serialization.Model):
    """A private endpoint class.

    :param id: The private endpoint identifier.
    :type id: str
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PrivateEndpoint, self).__init__(**kwargs)
        self.id = kwargs.get('id', None)


class ProxyResource(msrest.serialization.Model):
    """Proxy Azure Resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Gets or sets the identifier.
    :vartype id: str
    :ivar name: Gets or sets the name.
    :vartype name: str
    :ivar type: Gets or sets the type.
    :vartype type: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ProxyResource, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None


class PrivateEndpointConnection(ProxyResource):
    """A private endpoint connection class.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Gets or sets the identifier.
    :vartype id: str
    :ivar name: Gets or sets the name.
    :vartype name: str
    :ivar type: Gets or sets the type.
    :vartype type: str
    :param private_endpoint: The private endpoint information.
    :type private_endpoint: ~azure.mgmt.purview.models.PrivateEndpoint
    :param private_link_service_connection_state: The private link service connection state.
    :type private_link_service_connection_state:
     ~azure.mgmt.purview.models.PrivateLinkServiceConnectionState
    :ivar provisioning_state: The provisioning state.
    :vartype provisioning_state: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'private_endpoint': {'key': 'properties.privateEndpoint', 'type': 'PrivateEndpoint'},
        'private_link_service_connection_state': {'key': 'properties.privateLinkServiceConnectionState', 'type': 'PrivateLinkServiceConnectionState'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PrivateEndpointConnection, self).__init__(**kwargs)
        self.private_endpoint = kwargs.get('private_endpoint', None)
        self.private_link_service_connection_state = kwargs.get('private_link_service_connection_state', None)
        self.provisioning_state = None


class PrivateEndpointConnectionList(msrest.serialization.Model):
    """Paged list of private endpoint connections.

    All required parameters must be populated in order to send to Azure.

    :param count: Total item count.
    :type count: long
    :param next_link: The Url of next result page.
    :type next_link: str
    :param value: Required. Collection of items of type results.
    :type value: list[~azure.mgmt.purview.models.PrivateEndpointConnection]
    """

    _validation = {
        'value': {'required': True},
    }

    _attribute_map = {
        'count': {'key': 'count', 'type': 'long'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
        'value': {'key': 'value', 'type': '[PrivateEndpointConnection]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PrivateEndpointConnectionList, self).__init__(**kwargs)
        self.count = kwargs.get('count', None)
        self.next_link = kwargs.get('next_link', None)
        self.value = kwargs['value']


class PrivateLinkResource(msrest.serialization.Model):
    """A privately linkable resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The private link resource identifier.
    :vartype id: str
    :ivar name: The private link resource name.
    :vartype name: str
    :ivar properties: The private link resource properties.
    :vartype properties: ~azure.mgmt.purview.models.PrivateLinkResourceProperties
    :ivar type: The private link resource type.
    :vartype type: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'properties': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'properties': {'key': 'properties', 'type': 'PrivateLinkResourceProperties'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PrivateLinkResource, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.properties = None
        self.type = None


class PrivateLinkResourceList(msrest.serialization.Model):
    """Paged list of private link resources.

    All required parameters must be populated in order to send to Azure.

    :param count: Total item count.
    :type count: long
    :param next_link: The Url of next result page.
    :type next_link: str
    :param value: Required. Collection of items of type results.
    :type value: list[~azure.mgmt.purview.models.PrivateLinkResource]
    """

    _validation = {
        'value': {'required': True},
    }

    _attribute_map = {
        'count': {'key': 'count', 'type': 'long'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
        'value': {'key': 'value', 'type': '[PrivateLinkResource]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PrivateLinkResourceList, self).__init__(**kwargs)
        self.count = kwargs.get('count', None)
        self.next_link = kwargs.get('next_link', None)
        self.value = kwargs['value']


class PrivateLinkResourceProperties(msrest.serialization.Model):
    """A privately linkable resource properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar group_id: The private link resource group identifier.
    :vartype group_id: str
    :ivar required_members: This translates to how many Private IPs should be created for each
     privately linkable resource.
    :vartype required_members: list[str]
    :ivar required_zone_names: The required zone names for private link resource.
    :vartype required_zone_names: list[str]
    """

    _validation = {
        'group_id': {'readonly': True},
        'required_members': {'readonly': True},
        'required_zone_names': {'readonly': True},
    }

    _attribute_map = {
        'group_id': {'key': 'groupId', 'type': 'str'},
        'required_members': {'key': 'requiredMembers', 'type': '[str]'},
        'required_zone_names': {'key': 'requiredZoneNames', 'type': '[str]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PrivateLinkResourceProperties, self).__init__(**kwargs)
        self.group_id = None
        self.required_members = None
        self.required_zone_names = None


class PrivateLinkServiceConnectionState(msrest.serialization.Model):
    """The private link service connection state.

    :param actions_required: The required actions.
    :type actions_required: str
    :param description: The description.
    :type description: str
    :param status: The status. Possible values include: "Unknown", "Pending", "Approved",
     "Rejected", "Disconnected".
    :type status: str or ~azure.mgmt.purview.models.Status
    """

    _attribute_map = {
        'actions_required': {'key': 'actionsRequired', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'status': {'key': 'status', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PrivateLinkServiceConnectionState, self).__init__(**kwargs)
        self.actions_required = kwargs.get('actions_required', None)
        self.description = kwargs.get('description', None)
        self.status = kwargs.get('status', None)


class SystemData(msrest.serialization.Model):
    """Metadata pertaining to creation and last modification of the resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar created_at: The timestamp of resource creation (UTC).
    :vartype created_at: ~datetime.datetime
    :ivar created_by: The identity that created the resource.
    :vartype created_by: str
    :ivar created_by_type: The type of identity that created the resource. Possible values include:
     "User", "Application", "ManagedIdentity", "Key".
    :vartype created_by_type: str or ~azure.mgmt.purview.models.CreatedByType
    :ivar last_modified_at: The timestamp of the last modification the resource (UTC).
    :vartype last_modified_at: ~datetime.datetime
    :ivar last_modified_by: The identity that last modified the resource.
    :vartype last_modified_by: str
    :ivar last_modified_by_type: The type of identity that last modified the resource. Possible
     values include: "User", "Application", "ManagedIdentity", "Key".
    :vartype last_modified_by_type: str or ~azure.mgmt.purview.models.LastModifiedByType
    """

    _validation = {
        'created_at': {'readonly': True},
        'created_by': {'readonly': True},
        'created_by_type': {'readonly': True},
        'last_modified_at': {'readonly': True},
        'last_modified_by': {'readonly': True},
        'last_modified_by_type': {'readonly': True},
    }

    _attribute_map = {
        'created_at': {'key': 'createdAt', 'type': 'iso-8601'},
        'created_by': {'key': 'createdBy', 'type': 'str'},
        'created_by_type': {'key': 'createdByType', 'type': 'str'},
        'last_modified_at': {'key': 'lastModifiedAt', 'type': 'iso-8601'},
        'last_modified_by': {'key': 'lastModifiedBy', 'type': 'str'},
        'last_modified_by_type': {'key': 'lastModifiedByType', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SystemData, self).__init__(**kwargs)
        self.created_at = None
        self.created_by = None
        self.created_by_type = None
        self.last_modified_at = None
        self.last_modified_by = None
        self.last_modified_by_type = None


class TrackedResourceSystemData(SystemData):
    """Metadata pertaining to creation and last modification of the resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar created_at: The timestamp of resource creation (UTC).
    :vartype created_at: ~datetime.datetime
    :ivar created_by: The identity that created the resource.
    :vartype created_by: str
    :ivar created_by_type: The type of identity that created the resource. Possible values include:
     "User", "Application", "ManagedIdentity", "Key".
    :vartype created_by_type: str or ~azure.mgmt.purview.models.CreatedByType
    :ivar last_modified_at: The timestamp of the last modification the resource (UTC).
    :vartype last_modified_at: ~datetime.datetime
    :ivar last_modified_by: The identity that last modified the resource.
    :vartype last_modified_by: str
    :ivar last_modified_by_type: The type of identity that last modified the resource. Possible
     values include: "User", "Application", "ManagedIdentity", "Key".
    :vartype last_modified_by_type: str or ~azure.mgmt.purview.models.LastModifiedByType
    """

    _validation = {
        'created_at': {'readonly': True},
        'created_by': {'readonly': True},
        'created_by_type': {'readonly': True},
        'last_modified_at': {'readonly': True},
        'last_modified_by': {'readonly': True},
        'last_modified_by_type': {'readonly': True},
    }

    _attribute_map = {
        'created_at': {'key': 'createdAt', 'type': 'iso-8601'},
        'created_by': {'key': 'createdBy', 'type': 'str'},
        'created_by_type': {'key': 'createdByType', 'type': 'str'},
        'last_modified_at': {'key': 'lastModifiedAt', 'type': 'iso-8601'},
        'last_modified_by': {'key': 'lastModifiedBy', 'type': 'str'},
        'last_modified_by_type': {'key': 'lastModifiedByType', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(TrackedResourceSystemData, self).__init__(**kwargs)
