# pylint: disable=line-too-long,useless-suppression
# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
# pylint: disable=useless-super-delegation

import datetime
from typing import Any, Dict, List, Mapping, Optional, TYPE_CHECKING, Union, overload

from .._utils.model_base import Model as _Model, rest_field

if TYPE_CHECKING:
    from .. import models as _models


class ErrorAdditionalInfo(_Model):
    """The resource management error additional info.

    :ivar type: The additional info type.
    :vartype type: str
    :ivar info: The additional info.
    :vartype info: any
    """

    type: Optional[str] = rest_field(visibility=["read"])
    """The additional info type."""
    info: Optional[Any] = rest_field(visibility=["read"])
    """The additional info."""


class ErrorDetail(_Model):
    """The error detail.

    :ivar code: The error code.
    :vartype code: str
    :ivar message: The error message.
    :vartype message: str
    :ivar target: The error target.
    :vartype target: str
    :ivar details: The error details.
    :vartype details: list[~azure.mgmt.weightsandbiases.models.ErrorDetail]
    :ivar additional_info: The error additional info.
    :vartype additional_info: list[~azure.mgmt.weightsandbiases.models.ErrorAdditionalInfo]
    """

    code: Optional[str] = rest_field(visibility=["read"])
    """The error code."""
    message: Optional[str] = rest_field(visibility=["read"])
    """The error message."""
    target: Optional[str] = rest_field(visibility=["read"])
    """The error target."""
    details: Optional[List["_models.ErrorDetail"]] = rest_field(visibility=["read"])
    """The error details."""
    additional_info: Optional[List["_models.ErrorAdditionalInfo"]] = rest_field(
        name="additionalInfo", visibility=["read"]
    )
    """The error additional info."""


class ErrorResponse(_Model):
    """Common error response for all Azure Resource Manager APIs to return error details for failed
    operations.

    :ivar error: The error object.
    :vartype error: ~azure.mgmt.weightsandbiases.models.ErrorDetail
    """

    error: Optional["_models.ErrorDetail"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The error object."""

    @overload
    def __init__(
        self,
        *,
        error: Optional["_models.ErrorDetail"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class InstanceProperties(_Model):
    """Properties specific to Instance.

    :ivar marketplace: Marketplace details of the resource. Required.
    :vartype marketplace: ~azure.mgmt.weightsandbiases.models.MarketplaceDetails
    :ivar user: Details of the user. Required.
    :vartype user: ~azure.mgmt.weightsandbiases.models.UserDetails
    :ivar provisioning_state: Provisioning state of the resource. Known values are: "Succeeded",
     "Failed", and "Canceled".
    :vartype provisioning_state: str or
     ~azure.mgmt.weightsandbiases.models.ResourceProvisioningState
    :ivar partner_properties: partner properties. Required.
    :vartype partner_properties: ~azure.mgmt.weightsandbiases.models.PartnerProperties
    :ivar single_sign_on_properties: Single sign-on properties.
    :vartype single_sign_on_properties:
     ~azure.mgmt.weightsandbiases.models.SingleSignOnPropertiesV2
    """

    marketplace: "_models.MarketplaceDetails" = rest_field(visibility=["read", "create", "update"])
    """Marketplace details of the resource. Required."""
    user: "_models.UserDetails" = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Details of the user. Required."""
    provisioning_state: Optional[Union[str, "_models.ResourceProvisioningState"]] = rest_field(
        name="provisioningState", visibility=["read"]
    )
    """Provisioning state of the resource. Known values are: \"Succeeded\", \"Failed\", and
     \"Canceled\"."""
    partner_properties: "_models.PartnerProperties" = rest_field(
        name="partnerProperties", visibility=["read", "create", "update", "delete", "query"]
    )
    """partner properties. Required."""
    single_sign_on_properties: Optional["_models.SingleSignOnPropertiesV2"] = rest_field(
        name="singleSignOnProperties", visibility=["read", "create", "update", "delete", "query"]
    )
    """Single sign-on properties."""

    @overload
    def __init__(
        self,
        *,
        marketplace: "_models.MarketplaceDetails",
        user: "_models.UserDetails",
        partner_properties: "_models.PartnerProperties",
        single_sign_on_properties: Optional["_models.SingleSignOnPropertiesV2"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class Resource(_Model):
    """Common fields that are returned in the response for all Azure Resource Manager resources.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.weightsandbiases.models.SystemData
    """

    id: Optional[str] = rest_field(visibility=["read"])
    """Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}."""
    name: Optional[str] = rest_field(visibility=["read"])
    """The name of the resource."""
    type: Optional[str] = rest_field(visibility=["read"])
    """The type of the resource. E.g. \"Microsoft.Compute/virtualMachines\" or
     \"Microsoft.Storage/storageAccounts\"."""
    system_data: Optional["_models.SystemData"] = rest_field(name="systemData", visibility=["read"])
    """Azure Resource Manager metadata containing createdBy and modifiedBy information."""


class TrackedResource(Resource):
    """The resource model definition for an Azure Resource Manager tracked top level resource which
    has 'tags' and a 'location'.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.weightsandbiases.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    """

    tags: Optional[Dict[str, str]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Resource tags."""
    location: str = rest_field(visibility=["read", "create"])
    """The geo-location where the resource lives. Required."""

    @overload
    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class InstanceResource(TrackedResource):
    """Concrete tracked resource types can be created by aliasing this type using a specific property
    type.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.weightsandbiases.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    :ivar properties: The resource-specific properties for this resource.
    :vartype properties: ~azure.mgmt.weightsandbiases.models.InstanceProperties
    :ivar identity: The managed service identities assigned to this resource.
    :vartype identity: ~azure.mgmt.weightsandbiases.models.ManagedServiceIdentity
    """

    properties: Optional["_models.InstanceProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The resource-specific properties for this resource."""
    identity: Optional["_models.ManagedServiceIdentity"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The managed service identities assigned to this resource."""

    @overload
    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        properties: Optional["_models.InstanceProperties"] = None,
        identity: Optional["_models.ManagedServiceIdentity"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class InstanceResourceUpdate(_Model):
    """The type used for update operations of the Instance Resource.

    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar identity: The managed service identities assigned to this resource.
    :vartype identity: ~azure.mgmt.weightsandbiases.models.ManagedServiceIdentity
    """

    tags: Optional[Dict[str, str]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Resource tags."""
    identity: Optional["_models.ManagedServiceIdentity"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The managed service identities assigned to this resource."""

    @overload
    def __init__(
        self,
        *,
        tags: Optional[Dict[str, str]] = None,
        identity: Optional["_models.ManagedServiceIdentity"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ManagedServiceIdentity(_Model):
    """Managed service identity (system assigned and/or user assigned identities).

    :ivar principal_id: The service principal ID of the system assigned identity. This property
     will only be provided for a system assigned identity.
    :vartype principal_id: str
    :ivar tenant_id: The tenant ID of the system assigned identity. This property will only be
     provided for a system assigned identity.
    :vartype tenant_id: str
    :ivar type: The type of managed identity assigned to this resource. Required. Known values are:
     "None", "SystemAssigned", "UserAssigned", and "SystemAssigned,UserAssigned".
    :vartype type: str or ~azure.mgmt.weightsandbiases.models.ManagedServiceIdentityType
    :ivar user_assigned_identities: The identities assigned to this resource by the user.
    :vartype user_assigned_identities: dict[str,
     ~azure.mgmt.weightsandbiases.models.UserAssignedIdentity]
    """

    principal_id: Optional[str] = rest_field(name="principalId", visibility=["read"])
    """The service principal ID of the system assigned identity. This property will only be provided
     for a system assigned identity."""
    tenant_id: Optional[str] = rest_field(name="tenantId", visibility=["read"])
    """The tenant ID of the system assigned identity. This property will only be provided for a system
     assigned identity."""
    type: Union[str, "_models.ManagedServiceIdentityType"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The type of managed identity assigned to this resource. Required. Known values are: \"None\",
     \"SystemAssigned\", \"UserAssigned\", and \"SystemAssigned,UserAssigned\"."""
    user_assigned_identities: Optional[Dict[str, "_models.UserAssignedIdentity"]] = rest_field(
        name="userAssignedIdentities", visibility=["read", "create", "update", "delete", "query"]
    )
    """The identities assigned to this resource by the user."""

    @overload
    def __init__(
        self,
        *,
        type: Union[str, "_models.ManagedServiceIdentityType"],
        user_assigned_identities: Optional[Dict[str, "_models.UserAssignedIdentity"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class MarketplaceDetails(_Model):
    """Marketplace details for an organization.

    :ivar subscription_id: Azure subscription id for the the marketplace offer is purchased from.
    :vartype subscription_id: str
    :ivar subscription_status: Marketplace subscription status. Known values are:
     "PendingFulfillmentStart", "Subscribed", "Suspended", and "Unsubscribed".
    :vartype subscription_status: str or
     ~azure.mgmt.weightsandbiases.models.MarketplaceSubscriptionStatus
    :ivar offer_details: Offer details for the marketplace that is selected by the user. Required.
    :vartype offer_details: ~azure.mgmt.weightsandbiases.models.OfferDetails
    """

    subscription_id: Optional[str] = rest_field(
        name="subscriptionId", visibility=["read", "create", "update", "delete", "query"]
    )
    """Azure subscription id for the the marketplace offer is purchased from."""
    subscription_status: Optional[Union[str, "_models.MarketplaceSubscriptionStatus"]] = rest_field(
        name="subscriptionStatus", visibility=["read"]
    )
    """Marketplace subscription status. Known values are: \"PendingFulfillmentStart\", \"Subscribed\",
     \"Suspended\", and \"Unsubscribed\"."""
    offer_details: "_models.OfferDetails" = rest_field(
        name="offerDetails", visibility=["read", "create", "update", "delete", "query"]
    )
    """Offer details for the marketplace that is selected by the user. Required."""

    @overload
    def __init__(
        self,
        *,
        offer_details: "_models.OfferDetails",
        subscription_id: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class OfferDetails(_Model):
    """Offer details for the marketplace that is selected by the user.

    :ivar publisher_id: Publisher Id for the marketplace offer. Required.
    :vartype publisher_id: str
    :ivar offer_id: Offer Id for the marketplace offer. Required.
    :vartype offer_id: str
    :ivar plan_id: Plan Id for the marketplace offer. Required.
    :vartype plan_id: str
    :ivar plan_name: Plan Name for the marketplace offer.
    :vartype plan_name: str
    :ivar term_unit: Plan Display Name for the marketplace offer.
    :vartype term_unit: str
    :ivar term_id: Plan Display Name for the marketplace offer.
    :vartype term_id: str
    """

    publisher_id: str = rest_field(name="publisherId", visibility=["read", "create", "update", "delete", "query"])
    """Publisher Id for the marketplace offer. Required."""
    offer_id: str = rest_field(name="offerId", visibility=["read", "create", "update", "delete", "query"])
    """Offer Id for the marketplace offer. Required."""
    plan_id: str = rest_field(name="planId", visibility=["read", "create", "update", "delete", "query"])
    """Plan Id for the marketplace offer. Required."""
    plan_name: Optional[str] = rest_field(name="planName", visibility=["read", "create", "update", "delete", "query"])
    """Plan Name for the marketplace offer."""
    term_unit: Optional[str] = rest_field(name="termUnit", visibility=["read", "create", "update", "delete", "query"])
    """Plan Display Name for the marketplace offer."""
    term_id: Optional[str] = rest_field(name="termId", visibility=["read", "create", "update", "delete", "query"])
    """Plan Display Name for the marketplace offer."""

    @overload
    def __init__(
        self,
        *,
        publisher_id: str,
        offer_id: str,
        plan_id: str,
        plan_name: Optional[str] = None,
        term_unit: Optional[str] = None,
        term_id: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class Operation(_Model):
    """Details of a REST API operation, returned from the Resource Provider Operations API.

    :ivar name: The name of the operation, as per Resource-Based Access Control (RBAC). Examples:
     "Microsoft.Compute/virtualMachines/write", "Microsoft.Compute/virtualMachines/capture/action".
    :vartype name: str
    :ivar is_data_action: Whether the operation applies to data-plane. This is "true" for
     data-plane operations and "false" for Azure Resource Manager/control-plane operations.
    :vartype is_data_action: bool
    :ivar display: Localized display information for this particular operation.
    :vartype display: ~azure.mgmt.weightsandbiases.models.OperationDisplay
    :ivar origin: The intended executor of the operation; as in Resource Based Access Control
     (RBAC) and audit logs UX. Default value is "user,system". Known values are: "user", "system",
     and "user,system".
    :vartype origin: str or ~azure.mgmt.weightsandbiases.models.Origin
    :ivar action_type: Extensible enum. Indicates the action type. "Internal" refers to actions
     that are for internal only APIs. "Internal"
    :vartype action_type: str or ~azure.mgmt.weightsandbiases.models.ActionType
    """

    name: Optional[str] = rest_field(visibility=["read"])
    """The name of the operation, as per Resource-Based Access Control (RBAC). Examples:
     \"Microsoft.Compute/virtualMachines/write\",
     \"Microsoft.Compute/virtualMachines/capture/action\"."""
    is_data_action: Optional[bool] = rest_field(name="isDataAction", visibility=["read"])
    """Whether the operation applies to data-plane. This is \"true\" for data-plane operations and
     \"false\" for Azure Resource Manager/control-plane operations."""
    display: Optional["_models.OperationDisplay"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Localized display information for this particular operation."""
    origin: Optional[Union[str, "_models.Origin"]] = rest_field(visibility=["read"])
    """The intended executor of the operation; as in Resource Based Access Control (RBAC) and audit
     logs UX. Default value is \"user,system\". Known values are: \"user\", \"system\", and
     \"user,system\"."""
    action_type: Optional[Union[str, "_models.ActionType"]] = rest_field(name="actionType", visibility=["read"])
    """Extensible enum. Indicates the action type. \"Internal\" refers to actions that are for
     internal only APIs. \"Internal\""""

    @overload
    def __init__(
        self,
        *,
        display: Optional["_models.OperationDisplay"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class OperationDisplay(_Model):
    """Localized display information for and operation.

    :ivar provider: The localized friendly form of the resource provider name, e.g. "Microsoft
     Monitoring Insights" or "Microsoft Compute".
    :vartype provider: str
    :ivar resource: The localized friendly name of the resource type related to this operation.
     E.g. "Virtual Machines" or "Job Schedule Collections".
    :vartype resource: str
    :ivar operation: The concise, localized friendly name for the operation; suitable for
     dropdowns. E.g. "Create or Update Virtual Machine", "Restart Virtual Machine".
    :vartype operation: str
    :ivar description: The short, localized friendly description of the operation; suitable for
     tool tips and detailed views.
    :vartype description: str
    """

    provider: Optional[str] = rest_field(visibility=["read"])
    """The localized friendly form of the resource provider name, e.g. \"Microsoft Monitoring
     Insights\" or \"Microsoft Compute\"."""
    resource: Optional[str] = rest_field(visibility=["read"])
    """The localized friendly name of the resource type related to this operation. E.g. \"Virtual
     Machines\" or \"Job Schedule Collections\"."""
    operation: Optional[str] = rest_field(visibility=["read"])
    """The concise, localized friendly name for the operation; suitable for dropdowns. E.g. \"Create
     or Update Virtual Machine\", \"Restart Virtual Machine\"."""
    description: Optional[str] = rest_field(visibility=["read"])
    """The short, localized friendly description of the operation; suitable for tool tips and detailed
     views."""


class PartnerProperties(_Model):
    """Partner's specific Properties.

    :ivar region: The region of the instance. Required. Known values are: "eastus", "centralus",
     "westus", "westeurope", "japaneast", and "koreacentral".
    :vartype region: str or ~azure.mgmt.weightsandbiases.models.Region
    :ivar subdomain: The subdomain of the instance. Required.
    :vartype subdomain: str
    """

    region: Union[str, "_models.Region"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The region of the instance. Required. Known values are: \"eastus\", \"centralus\", \"westus\",
     \"westeurope\", \"japaneast\", and \"koreacentral\"."""
    subdomain: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The subdomain of the instance. Required."""

    @overload
    def __init__(
        self,
        *,
        region: Union[str, "_models.Region"],
        subdomain: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class SingleSignOnPropertiesV2(_Model):
    """Properties specific to Single Sign On Resource.

    :ivar type: Type of Single Sign-On mechanism being used. Required. Known values are: "Saml" and
     "OpenId".
    :vartype type: str or ~azure.mgmt.weightsandbiases.models.SingleSignOnType
    :ivar state: State of the Single Sign On for the resource. Known values are: "Initial",
     "Enable", and "Disable".
    :vartype state: str or ~azure.mgmt.weightsandbiases.models.SingleSignOnStates
    :ivar enterprise_app_id: AAD enterprise application Id used to setup SSO.
    :vartype enterprise_app_id: str
    :ivar url: URL for SSO to be used by the partner to redirect the user to their system.
    :vartype url: str
    :ivar aad_domains: List of AAD domains fetched from Microsoft Graph for user.
    :vartype aad_domains: list[str]
    """

    type: Union[str, "_models.SingleSignOnType"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Type of Single Sign-On mechanism being used. Required. Known values are: \"Saml\" and
     \"OpenId\"."""
    state: Optional[Union[str, "_models.SingleSignOnStates"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """State of the Single Sign On for the resource. Known values are: \"Initial\", \"Enable\", and
     \"Disable\"."""
    enterprise_app_id: Optional[str] = rest_field(
        name="enterpriseAppId", visibility=["read", "create", "update", "delete", "query"]
    )
    """AAD enterprise application Id used to setup SSO."""
    url: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """URL for SSO to be used by the partner to redirect the user to their system."""
    aad_domains: Optional[List[str]] = rest_field(
        name="aadDomains", visibility=["read", "create", "update", "delete", "query"]
    )
    """List of AAD domains fetched from Microsoft Graph for user."""

    @overload
    def __init__(
        self,
        *,
        type: Union[str, "_models.SingleSignOnType"],
        state: Optional[Union[str, "_models.SingleSignOnStates"]] = None,
        enterprise_app_id: Optional[str] = None,
        url: Optional[str] = None,
        aad_domains: Optional[List[str]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class SystemData(_Model):
    """Metadata pertaining to creation and last modification of the resource.

    :ivar created_by: The identity that created the resource.
    :vartype created_by: str
    :ivar created_by_type: The type of identity that created the resource. Known values are:
     "User", "Application", "ManagedIdentity", and "Key".
    :vartype created_by_type: str or ~azure.mgmt.weightsandbiases.models.CreatedByType
    :ivar created_at: The timestamp of resource creation (UTC).
    :vartype created_at: ~datetime.datetime
    :ivar last_modified_by: The identity that last modified the resource.
    :vartype last_modified_by: str
    :ivar last_modified_by_type: The type of identity that last modified the resource. Known values
     are: "User", "Application", "ManagedIdentity", and "Key".
    :vartype last_modified_by_type: str or ~azure.mgmt.weightsandbiases.models.CreatedByType
    :ivar last_modified_at: The timestamp of resource last modification (UTC).
    :vartype last_modified_at: ~datetime.datetime
    """

    created_by: Optional[str] = rest_field(name="createdBy", visibility=["read", "create", "update", "delete", "query"])
    """The identity that created the resource."""
    created_by_type: Optional[Union[str, "_models.CreatedByType"]] = rest_field(
        name="createdByType", visibility=["read", "create", "update", "delete", "query"]
    )
    """The type of identity that created the resource. Known values are: \"User\", \"Application\",
     \"ManagedIdentity\", and \"Key\"."""
    created_at: Optional[datetime.datetime] = rest_field(
        name="createdAt", visibility=["read", "create", "update", "delete", "query"], format="rfc3339"
    )
    """The timestamp of resource creation (UTC)."""
    last_modified_by: Optional[str] = rest_field(
        name="lastModifiedBy", visibility=["read", "create", "update", "delete", "query"]
    )
    """The identity that last modified the resource."""
    last_modified_by_type: Optional[Union[str, "_models.CreatedByType"]] = rest_field(
        name="lastModifiedByType", visibility=["read", "create", "update", "delete", "query"]
    )
    """The type of identity that last modified the resource. Known values are: \"User\",
     \"Application\", \"ManagedIdentity\", and \"Key\"."""
    last_modified_at: Optional[datetime.datetime] = rest_field(
        name="lastModifiedAt", visibility=["read", "create", "update", "delete", "query"], format="rfc3339"
    )
    """The timestamp of resource last modification (UTC)."""

    @overload
    def __init__(
        self,
        *,
        created_by: Optional[str] = None,
        created_by_type: Optional[Union[str, "_models.CreatedByType"]] = None,
        created_at: Optional[datetime.datetime] = None,
        last_modified_by: Optional[str] = None,
        last_modified_by_type: Optional[Union[str, "_models.CreatedByType"]] = None,
        last_modified_at: Optional[datetime.datetime] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class UserAssignedIdentity(_Model):
    """User assigned identity properties.

    :ivar client_id: The client ID of the assigned identity.
    :vartype client_id: str
    :ivar principal_id: The principal ID of the assigned identity.
    :vartype principal_id: str
    """

    client_id: Optional[str] = rest_field(name="clientId", visibility=["read"])
    """The client ID of the assigned identity."""
    principal_id: Optional[str] = rest_field(name="principalId", visibility=["read"])
    """The principal ID of the assigned identity."""


class UserDetails(_Model):
    """User details for an organization.

    :ivar first_name: First name of the user.
    :vartype first_name: str
    :ivar last_name: Last name of the user.
    :vartype last_name: str
    :ivar email_address: Email address of the user.
    :vartype email_address: str
    :ivar upn: User's principal name.
    :vartype upn: str
    :ivar phone_number: User's phone number.
    :vartype phone_number: str
    """

    first_name: Optional[str] = rest_field(name="firstName", visibility=["read", "create", "update", "delete", "query"])
    """First name of the user."""
    last_name: Optional[str] = rest_field(name="lastName", visibility=["read", "create", "update", "delete", "query"])
    """Last name of the user."""
    email_address: Optional[str] = rest_field(
        name="emailAddress", visibility=["read", "create", "update", "delete", "query"]
    )
    """Email address of the user."""
    upn: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """User's principal name."""
    phone_number: Optional[str] = rest_field(
        name="phoneNumber", visibility=["read", "create", "update", "delete", "query"]
    )
    """User's phone number."""

    @overload
    def __init__(
        self,
        *,
        first_name: Optional[str] = None,
        last_name: Optional[str] = None,
        email_address: Optional[str] = None,
        upn: Optional[str] = None,
        phone_number: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
