#!/usr/bin/python

import os
import sys, os.path
sys.path.insert(0, os.path.realpath(os.path.join(os.path.dirname(__file__), "..")))

import unittest
from lpltk                import LaunchpadService

class TestLaunchpadService(unittest.TestCase):
    # setUp
    #
    def setUp(self):
        pass

    # test__init__
    #
    def test__init__(self):
        # Basic instance creation. 
        #
        try:
            ls = LaunchpadService()
            ls = None
        except:
            self.assertTrue(False)

        # Verify default configuration parameters are set correctly.
        #
        try:
            ls = LaunchpadService()
            self.assertEqual(ls.config['launchpad_client_name'], 'lpltk')
            self.assertEqual(ls.config['launchpad_services_root'], 'production')
            self.assertEqual(ls.config['project_name'], '')
            self.assertEqual(ls.config['read_only'], False)
            self.assertEqual(ls.config['launchpad_cachedir'], os.path.join(os.path.expanduser('~'), '.cache', ls.config['launchpad_client_name']))
            ls = None
        except:
            self.assertTrue(False)

        # Verify that the default configuration parameters will be overridden by
        # the passed in config dictionary.
        #
        try:
            cfg = {}
            cfg['launchpad_client_name']   = 'bilbo'
            cfg['launchpad_services_root'] = 'edge'
            cfg['project_name']            = 'linux'
            cfg['read_only']               = True
            cfg['launchpad_cachedir']      = 'deadEnd'
            ls = LaunchpadService(cfg)
            for k in cfg:
                self.assertEqual(ls.config[k], cfg[k])
            ls = None
        except:
            self.assertTrue(False)

        # Verify that we actually connected to Launchpad by getting back the title
        # or bug #1
        #
        try:
            ls = LaunchpadService()
            self.assertEqual(ls.launchpad.bugs[1].title, 'Microsoft has a majority market share')
            ls = None
        except:
            self.assertTrue(False)

        # Verify that I can connect to Launchpad in "read_only" mode.
        #
        try:
            cfg = {}
            cfg['read_only']               = True
            ls = LaunchpadService(cfg)
            self.assertEqual(ls.launchpad.bugs[1].title, 'Microsoft has a majority market share')
            ls = None
        except:
            self.assertTrue(False)

    # test_get_launchpad_bug
    #
    def test_get_launchpad_bug(self):
        try:
            ls = LaunchpadService()
            b = ls.get_launchpad_bug(1)
            self.assertEqual(b.title, 'Microsoft has a majority market share')
            ls = None
        except:
            self.assertTrue(False)

    # test_load_project
    #
    def test_load_project(self):
        # Verify that a specific projct can be loaded
        #
        try:
            ls = LaunchpadService()
            p = ls.load_project('ubuntu')
            self.assertEqual(p.display_name, 'Ubuntu')
            self.assertEqual(p.owner.display_name, 'Ubuntu Drivers')
            ls = None
        except:
            self.assertTrue(False)

    # test_reset
    #
    def test_reset(self):
        try:
            ls = LaunchpadService()
            ls.reset()
            b = ls.get_launchpad_bug(1)
            self.assertEqual(b.title, 'Microsoft has a majority market share')
            ls = None
        except:
            self.assertTrue(False)

    # test_new_bug
    #
    def test_new_bug(self):
        pass

if __name__ == '__main__':
    unittest.main()

# vi:set ts=4 sw=4 expandtab:
