/***************************************************************************
 *   Copyright (C) 2007 by Anistratov Oleg                                 *
 *   ower86@gmail.com                                                      *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License version 2        *
 *   as published by the Free Software Foundation;                         *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 ***************************************************************************/
#include "qchaticon.h"

#include <QFile>
#include <QDir>
#include <QCoreApplication>
#include <QSvgRenderer>
#include <QPainter>

#include "qchatsettings.h"

QMap<QString, QIcon  > QChatIcon::m_icons;
QMap<QString, QString> QChatIcon::m_iconPaths;

QChatIcon::QChatIcon()
{
}

QChatIcon::~QChatIcon()
{
  qDebug("[~QChatIcon]");
}

const QIcon & QChatIcon::icon(const QString & icon_name)
{
  return m_icons[icon_name];
}

void QChatIcon::initIcons()
{
  QStringList icon_names;
  QStringList icon_types;
  QString     full_path;
  QString     icons_path;

  if(!QDir((icons_path = QChatSettings::settings()->settingsDir() + "/icons/")).exists())
#ifdef Q_OS_LINUX
    icons_path = QCoreApplication::applicationDirPath() + "/../share/qchat/icons/";
#else
    icons_path = QCoreApplication::applicationDirPath() + "/share/icons/";
#endif

  if(!QDir(icons_path).exists())
    icons_path = ":/icons/";

  icon_types.append("svg");
  icon_types.append("png");
  icon_types.append("jpg");
  icon_types.append("gif");
  icon_types.append("");

  icon_names.append("format-text-bold");
  icon_names.append("format-text-italic");
  icon_names.append("format-text-underline");
  icon_names.append("insert-table");
  icon_names.append("application-exit");
  icon_names.append("help-about");
  icon_names.append("configure");
  icon_names.append("tab-new");
  icon_names.append("tab-close");
  icon_names.append("user-male");
  icon_names.append("user-female");
  icon_names.append("personal");
  icon_names.append("emotes");
  icon_names.append("add-profile");
  icon_names.append("remove-profile");
  icon_names.append("edit-rename");
  icon_names.append("send-file");
  icon_names.append("private-message");
  icon_names.append("private-chat");
  icon_names.append("write-settings");
  icon_names.append("animated-new-msg");
  icon_names.append("im-status-message-edit");
  icon_names.append("tray-icon");
  icon_names.append("unknown");
  icon_names.append("message-opened");
  icon_names.append("message-unread");
  icon_names.append("dialog-close");
  icon_names.append("go-next");
  icon_names.append("go-previous");

  icon_names.append("status/user-ready-for-chat");
  icon_names.append("status/user-online");
  icon_names.append("status/user-dnd");
  icon_names.append("status/user-offline");
  icon_names.append("status/user-invisible");
  icon_names.append("status/user-busy");
  icon_names.append("status/user-away");
  icon_names.append("status/user-away-extended");

  foreach(QString in, icon_names)
  {
    if(!in.contains("."))
    {
      foreach(QString it, icon_types)
      {
        full_path = icons_path + in + "." + it;
        if(QFile::exists(full_path))
        {
          m_icons    .insert(in, QIcon(full_path));
          m_iconPaths.insert(in, full_path);
          break;
        }
      }
    }
    else
    {
      full_path = icons_path + in;
      if(QFile::exists(full_path))
      {
         m_icons    .insert(in, QIcon(full_path));
         m_iconPaths.insert(in, full_path);
         break;
      }
    }
  }
}

const QString & QChatIcon::iconPath(const QString & icon_name)
{
  return m_iconPaths[icon_name];
}

QPixmap* QChatIcon::newPixmap(const QString & icon_name, int wd, int he)
{
  QSize sz(wd, he);

  if(wd < 0 || he < 0)
    sz = m_icons[icon_name].actualSize(QSize(-1, -1)); // FIXME sz must be equal size of icon

  QPixmap* pix = new QPixmap(sz);

  drawPixmap(pix, icon_name, QSize(wd, he));

  return pix;
}

QPixmap QChatIcon::pixmap(const QString& icon_name, int wd, int he)
{
  QSize sz(wd, he);

  if(wd < 0 || he < 0)
    sz = m_icons[icon_name].actualSize(QSize(-1, -1)); // FIXME sz must be equal size of icon

  QPixmap pix(sz);

  drawPixmap(&pix, icon_name, QSize(wd, he));

  return pix;
}

void QChatIcon::drawPixmap(QPixmap* pix, const QString & icon_name, const QSize& sz)
{
  if(iconPath(icon_name).contains(".svg"))
  {
    QSvgRenderer svg(iconPath(icon_name));
    QPixmap      tmp(sz);
    QPainter     painter;

    tmp.fill(Qt::black);
    pix->setAlphaChannel(tmp);

    painter.begin(pix);
    svg.render(&painter);
    painter.end();
  }
  else
    *pix = m_icons[icon_name].pixmap(sz);
}
