#include <stdio.h>
#include <string.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <dirent.h>
#include <malloc.h>
#include <fcntl.h>
#include <stdlib.h>
#include <signal.h>
#include <errno.h>
#include <getopt.h>
#include <stdarg.h>
#include <sys/wait.h>
#include <syslog.h>
#include <ctype.h>
#include <unistd.h>
#include <errno.h>

#define SYS_VNIC_INTERFACE_DIR  	"/sys/class/infiniband_qlgc_vnic/interfaces"
#define SYS_PRIMARY_PATH		"primary_path"
#define SYS_SECONDARY_PATH		"secondary_path"
#define SYS_RX_CSUM			"rx_csum"
#define SYS_TX_CSUM			"tx_csum"
#define SYS_IOC_GUID			"ioc_guid"
#define SYS_IOC_STRING			"ioc_string"
#define SYS_DGID			"dgid"
#define SYS_PKEY			"pkey"
#define SYS_HCA_INFO			"hca_info"
#define SYS_VIPORT_STATE		"viport_state"
#define SYS_UMAD_IBDEV			"ibdev"
#define SYS_UMAD_PORT			"port"

#define MAX_PKEY_LENGTH      		4
#define MAX_DGID_LENGTH      		32
#define MAX_IOC_GUID_LENGTH    		16
#define MAX_IOC_STRING_LENGTH  		(512 / 8)
#define MAX_CHECKSUM_LENGTH    		8
#define MAX_HCA_INFO_LENGTH		64
#define MAX_VIPORT_STATE_LENGTH		32
#define MAX_PORT_LENGTH			4

#define MAX_DIR_ENTRY_NAME     		256
#define MAX_IFACE_NAME_LENGTH		16
#define MAX_LINE_LENGTH			256
#define MAX_ECHO_STR_LENGTH 		256

#define IB_DEVICE_DIR			"/dev/infiniband"
#define IB_UMAD_DIR			"/sys/class/infiniband_mad/"
#define UMAD_STRING			"umad"
#define MAX_IBVEXDM_CMD_LENGTH		128
#define MAX_UMAD_DEVICES		256

#define PRIMARY_PATH			0
#define SECONDARY_PATH			1

#define VIPORT_DISCONNECTED     	0
#define VIPORT_CONNECTED		1

#define TRUE						1
#define FALSE						0
#define YES						1
#define NO						0

#define VNIC_UPDATE_DEFAULT_PERIOD 			60
#define VNIC_UPDATE_DEFAULT_VERBOSITY_LEVEL		6
#define VNIC_NON_CRITICAL_UPDATE_DEFAULT_FACTOR 	5

#define SHELL				"/bin/sh"
#define SHELL_COMMAND			"sh"
#define SHELL_OPTION			"-c"
#define FD_READ				0
#define FD_WRITE			1	
#define DAEMON_PID_FILE			"/var/run/ib_qlgc_vnic_update.pid"

enum { 
        REQ_NO_UPDATE = 0,
        REQ_NON_CRIT_UPDATE = 1,
        REQ_CRIT_UPDATE = 2
};

char state_strings[][100] = {
                                "\"Requires no update\"",
                                "\"Requires non critical update\"",
                                "\"Requires critical update\""
                            };

struct netpath {
	struct vnic			*vnic;
	char				pkey[MAX_PKEY_LENGTH+1];
	char				dgid[MAX_DGID_LENGTH+1];
	char 				ioc_guid[MAX_IOC_GUID_LENGTH+1];
	char				ioc_string[MAX_IOC_STRING_LENGTH+1];	
	char				hca[MAX_HCA_INFO_LENGTH+1];
	short int			viport_state;
	short int			port_no;
	short int			wait_count;
	short int 			update_available;
	struct ibvexdm_output		*conn;	
};

struct vnic { 
	char				name[MAX_IFACE_NAME_LENGTH+1];
	struct netpath			*primary_path;
	struct netpath 			*secondary_path;
	char				rx_csum[MAX_CHECKSUM_LENGTH+1];
	char				tx_csum[MAX_CHECKSUM_LENGTH+1];
	short int 			updated;
	short int			update_state;
	struct vnic			*next;
};

struct ibvexdm_output {
	char				pkey[MAX_PKEY_LENGTH+1];
	char				dgid[MAX_DGID_LENGTH+1];
	char				ioc_guid[MAX_IOC_GUID_LENGTH+1];
	char				ioc_string[MAX_IOC_STRING_LENGTH+1];
	struct hca_port_list		*port_list;
	short int			updated;
	struct ibvexdm_output   	*next;
};

struct hca_port_list {
	char				hca[MAX_HCA_INFO_LENGTH+1];
	short int			port_no;
	char				umad_device[MAX_DIR_ENTRY_NAME];
	short int			updated;
	struct hca_port_list		*next;
};

struct vnic *vnic_interfaces = NULL;
struct ibvexdm_output *ibvexdm_op = NULL;

short int is_daemon = FALSE;
short int verbosity_level, OPTIMIZE_BEHAVIOUR;
short int interval, non_critical_path_factor;
struct hca_port_list *umad_device_list[MAX_UMAD_DEVICES];
short int no_of_umad_devices = 0;
volatile static sig_atomic_t vnic_child_started = FALSE;
short int vnic_stop_daemon = FALSE;
pid_t ibvexdm_pid = -1;

void scan_vnic_interfaces(struct ibvexdm_output *conn, struct hca_port_list *port);
/*----------------------------------------------------------------------------------
		Debug information.
  --------------------------------------------------------------------------------*/

/* ------ Debug Levels definitions ------
 * Following is the list of Debug levels for the user of this debug utility
 * Note: The numbers matches the kernel system log levels. Some of the levels
 *                     as indicated are not used by this debug utility
 */
enum _DBG_LEVELS
{
        _DBG_LVL_EMERGENCY,     /* 0, LOG_EMERG,  System is unusable (Not used, reserved for system usage) */
        _DBG_LVL_ALERT,         /* 1, LOG_ALERT,  Action must be taken immediately (Not used, reserved for system usage) */
        _DBG_LVL_FATAL,         /* 2  LOG_CRIT,   Critical conditions */
        _DBG_LVL_ERROR,         /* 3  LOG_ERR,    Error conditions */                
        _DBG_LVL_WARN,          /* 4  LOG_WARNING,Warning conditions */              
        _DBG_LVL_NOTICE,        /* 5, LOG_NOTICE, Normal but significant condition, Not used, resterved for system usage */
    	_DBG_LVL_INFO,          /* 6  LOG_INFO,   Informational */
        _DBG_LVL_PRINT,         /* 7  LOG_DEBUG,  Debug-level messages */
};

/* Default Debug Level */
#define _DBG_LVL_DEFAULT          (_DBG_LVL_NOTICE)

void log_critical(const char *format,...)
{
	va_list ap;

	if (verbosity_level >= _DBG_LVL_FATAL) {
		va_start(ap, format);
		vsyslog(LOG_DAEMON|LOG_CRIT, format, ap);
		va_end(ap);
	}
}

void log_error(const char *format,...)
{
	va_list ap;

	if (verbosity_level >= _DBG_LVL_ERROR) {
		va_start(ap, format);
		vsyslog(LOG_DAEMON|LOG_ERR, format, ap);
		va_end(ap);
	}
}

void log_warning(const char *format,...)
{
	va_list ap;

	if (verbosity_level >= _DBG_LVL_WARN) {
		va_start(ap, format);
		vsyslog(LOG_DAEMON|LOG_WARNING, format, ap);
		va_end(ap);
	}
}

void log_information(const char *format,...)
{
	va_list ap;

	if (verbosity_level >= _DBG_LVL_INFO) {
		va_start(ap, format);
		vsyslog(LOG_DAEMON|LOG_INFO, format, ap);
		va_end(ap);
	}
}

void log_debug(const char *format,...)
{
	va_list ap;

	if (verbosity_level >= _DBG_LVL_PRINT) {
		va_start(ap, format);
		vsyslog(LOG_DAEMON|LOG_INFO, format, ap);
		va_end(ap);
	}
}

void log_notice(const char *format,...)
{
	va_list ap;

	if (verbosity_level >= _DBG_LVL_NOTICE) {
		va_start(ap, format);
		vsyslog(LOG_DAEMON|LOG_NOTICE, format, ap);
		va_end(ap);
	}
}

void log_information_always(const char *format,...)
{
	va_list ap;

	va_start(ap, format);
	vsyslog(LOG_DAEMON|LOG_INFO, format, ap);
	va_end(ap);
}

#define PRINT_CONSOLE(STRING...)                printf(STRING);
#define _DBG_ALWAYS(varParam...)                log_information_always(varParam);
#define _DBG_ASSERT(_exp_)                      {	if(!(_exp_)) 						\
								log_error("ASSERT:"#_exp_"\n");			\
												}

#define _DBG_FATAL(varParam...)                 {	log_critical("FATAL: "varParam);		 	\
							exit(1);						\
						}
#define _DBG_ERROR(varParam...)                 log_error("ERROR: "varParam);    
#define _DBG_WARN(varParam...)                  log_warning("WARN:  "varParam);  
#define _DBG_INFO(varParam...)                  log_information("INFO: "varParam);
#define _DBG_PRINT(varParam...)                 log_debug("DBG: "varParam);

