% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/queryNeighbors.R
\name{queryNeighbors}
\alias{queryNeighbors}
\alias{queryNeighbors,matrix,ANY-method}
\alias{queryNeighbors,BiocNeighborGenericIndex,ANY-method}
\alias{queryNeighbors,missing,ANY-method}
\alias{queryNeighbors,matrix-method}
\alias{queryNeighbors,BiocNeighborGenericIndex-method}
\alias{queryNeighbors,missing-method}
\title{Query neighbors within a threshold distance}
\usage{
queryNeighbors(
  X,
  query,
  threshold,
  get.index = TRUE,
  get.distance = TRUE,
  num.threads = 1,
  subset = NULL,
  transposed = FALSE,
  ...,
  BNPARAM = NULL
)
}
\arguments{
\item{X}{The reference dataset to be queried.
This should be a numeric matrix where rows correspond to reference points and columns correspond to variables (i.e., dimensions).
Alternatively, a prebuilt \linkS4class{BiocNeighborIndex} object from \code{\link{buildIndex}}.}

\item{query}{A numeric matrix of query points, containing the same number of columns as \code{X}.}

\item{threshold}{A positive numeric scalar specifying the maximum distance at which a point is considered a neighbor.
Alternatively, a vector containing a different distance threshold for each query point.}

\item{get.index}{A logical scalar indicating whether the indices of the neighbors should be recorded.}

\item{get.distance}{A logical scalar indicating whether distances to the neighbors should be recorded.}

\item{num.threads}{Integer scalar specifying the number of threads to use for the search.}

\item{subset}{An integer, logical or character vector indicating the rows of \code{query} (or columns, if \code{transposed=TRUE}) for which the nearest neighbors should be identified.}

\item{transposed}{A logical scalar indicating whether \code{X} and \code{query} are transposed, 
in which case both matrices are assumed to contain dimensions in the rows and data points in the columns.}

\item{...}{Further arguments to pass to \code{\link{buildIndex}} when \code{X} is not an external pointer.}

\item{BNPARAM}{A \linkS4class{BiocNeighborParam} object specifying how the index should be constructed.
If \code{NULL}, this defaults to a \linkS4class{KmknnParam}.
Ignored if \code{x} contains a prebuilt index.}
}
\value{
A list is returned containing:
\itemize{
\item \code{index}, if \code{get.index=TRUE}.
This is a list of integer vectors where each entry corresponds to a point (denoted here as \eqn{i}) in \code{query}.
The vector for \eqn{i} contains the set of row indices of all points in \code{X} that lie within \code{threshold} of point \eqn{i}.
Neighbors for \eqn{i} are sorted by increasing distance from \eqn{i}.
\item \code{distance}, if \code{get.distance=TRUE}.
This is a list of numeric vectors where each entry corresponds to a point (as above) and contains the distances of the neighbors from \eqn{i}.
Elements of each vector in \code{distance} match to elements of the corresponding vector in \code{index}.
}

If both \code{get.index=FALSE} and \code{get.distance=FALSE}, an integer vector is returned of length equal to the number of observations.
The \code{i}-th entry contains the number of neighbors of \eqn{i} within \code{threshold}.

If \code{subset} is not \code{NULL}, each entry of the above vector/lists refers to a point in the subset, in the same order as supplied in \code{subset}.
}
\description{
Find all points in a reference dataset that lie within a threshold distance of each point in a query dataset.
}
\details{
This function identifies all points in \code{X} that within \code{threshold} of each point in \code{query}.
For Euclidean distances, this is equivalent to identifying all points in a hypersphere centered around the point of interest.
Not all implementations support this search mode, but we can use \link{KmknnParam} and \linkS4class{VptreeParam}.

If \code{threshold} is a vector, each entry is assumed to specify a (possibly different) threshold for each point in \code{query}.
If \code{subset} is also specified, each entry is assumed to specify a threshold for each point in \code{subset}.
An error will be raised if \code{threshold} is a vector of incorrect length.

If multiple queries are to be performed to the same \code{X}, it may be beneficial to build the index from \code{X} with \code{\link{buildIndex}}.
The resulting pointer object can be supplied as \code{X} to multiple \code{queryKNN} calls, avoiding the need to repeat index construction in each call.
}
\examples{
Y <- matrix(rnorm(100000), ncol=20)
Z <- matrix(rnorm(20000), ncol=20)
out <- queryNeighbors(Y, query=Z, threshold=3)
summary(lengths(out$index))

}
\seealso{
\code{\link{buildIndex}}, to build an index ahead of time.
}
\author{
Aaron Lun
}
