% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{degMB}
\alias{degMB}
\title{Distribution of expression of DE genes compared to the background}
\usage{
degMB(tags, group, counts, pop = 400)
}
\arguments{
\item{tags}{List of genes that are DE.}

\item{group}{Character vector with group name for each sample in the
same order than counts column names.}

\item{counts}{Matrix with counts for each samples and each gene
Should be same length than pvalues vector.}

\item{pop}{number of random samples taken for background comparison}
}
\value{
ggplot2 object
}
\description{
Distribution of expression of DE genes compared to the background
}
\examples{
data(humanGender)
library(DESeq2)
idx <- c(1:10, 75:85)
dds <- DESeqDataSetFromMatrix(assays(humanGender)[[1]][1:1000, idx],
  colData(humanGender)[idx,], design=~group)
dds <- DESeq(dds)
res <- results(dds)
degMB(row.names(res)[1:20], colData(dds)[["group"]],
  counts(dds, normalized = TRUE))
}
