% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/colAlls.R, R/colAnys.R, R/rowAlls.R,
%   R/rowAnys.R
\name{colAlls,DelayedMatrix-method}
\alias{colAlls,DelayedMatrix-method}
\alias{colAnys,DelayedMatrix-method}
\alias{rowAlls,DelayedMatrix-method}
\alias{rowAnys,DelayedMatrix-method}
\title{Check if all elements in a row (column) of a matrix-like object are equal to
a value}
\usage{
\S4method{colAlls}{DelayedMatrix}(
  x,
  rows = NULL,
  cols = NULL,
  value = TRUE,
  na.rm = FALSE,
  force_block_processing = FALSE,
  ...,
  useNames = NA
)

\S4method{colAnys}{DelayedMatrix}(
  x,
  rows = NULL,
  cols = NULL,
  value = TRUE,
  na.rm = FALSE,
  force_block_processing = FALSE,
  ...,
  useNames = NA
)

\S4method{rowAlls}{DelayedMatrix}(
  x,
  rows = NULL,
  cols = NULL,
  value = TRUE,
  na.rm = FALSE,
  force_block_processing = FALSE,
  ...,
  useNames = NA
)

\S4method{rowAnys}{DelayedMatrix}(
  x,
  rows = NULL,
  cols = NULL,
  value = TRUE,
  na.rm = FALSE,
  force_block_processing = FALSE,
  ...,
  useNames = NA
)
}
\arguments{
\item{x}{A NxK \linkS4class{DelayedMatrix}.}

\item{rows}{A \code{\link{vector}} indicating the subset of rows
(and/or columns) to operate over. If \code{\link{NULL}}, no subsetting is
done.}

\item{cols}{A \code{\link{vector}} indicating the subset of rows
(and/or columns) to operate over. If \code{\link{NULL}}, no subsetting is
done.}

\item{value}{The value to search for.}

\item{na.rm}{If \code{\link[base:logical]{TRUE}}, \code{\link{NA}}s
are excluded first, otherwise not.}

\item{force_block_processing}{\code{FALSE} (the default) means that a
seed-aware, optimised method is used (if available). This can be overridden
to use the general block-processing strategy by setting this to \code{TRUE}
(typically not advised). The block-processing strategy loads one or more
(depending on \verb{\link[DelayedArray]\{getAutoBlockSize\}()}) columns (\code{colFoo()})
or rows (\code{rowFoo()}) into memory as an ordinary \link[base:array]{base::array}.}

\item{...}{Additional arguments passed to specific methods.}

\item{useNames}{If \code{\link{NA}}, the default behavior of the function about naming support is remained. If \code{\link{FALSE}}, no naming support is done. Else if \code{\link{TRUE}}, names attributes of result are set. \strong{Only \code{useNames = NA} is currently supported, other values are silently ignored.}}
}
\value{
Returns a \code{\link{logical}} \code{\link{vector}} of length N (K).
}
\description{
Check if all elements in a row (column) of a matrix-like object are equal to
a value.
}
\details{
The S4 methods for \code{x} of type \code{\link{matrix}},
\code{\link{array}}, or \code{\link{numeric}} call
\code{matrixStats::rowAlls}
/ \code{matrixStats::colAlls}.
}
\examples{
# A DelayedMatrix with a 'matrix' seed
dm_matrix <- DelayedArray(matrix(c(rep(1L, 5),
                                   as.integer((0:4) ^ 2),
                                   seq(-5L, -1L, 1L)),
                                 ncol = 3))
# A DelayedMatrix with a 'SolidRleArraySeed' seed
dm_Rle <- RleArray(Rle(c(rep(1L, 5),
                         as.integer((0:4) ^ 2),
                         seq(-5L, -1L, 1L))),
                   dim = c(5, 3))

colAlls(dm_matrix, value = 1)
colAnys(dm_matrix, value = 2)
rowAlls(dm_Rle, value = 1)
rowAnys(dm_Rle, value = 2)
}
\seealso{
\itemize{
\item \code{matrixStats::\link[matrixStats:rowAlls]{rowAlls}()} and
\code{matrixStats::\link[matrixStats:rowAlls]{colAlls}()} which are
used when the input is a \code{matrix} or \code{numeric} vector.
\item For checks if \emph{any} element is equal to a value, see
\code{\link[MatrixGenerics]{rowAnys}()}.
\item \code{base::\link{all}()}.
}
}
\author{
Peter Hickey

Peter Hickey
}
