% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rowCounts.R
\name{rowCounts}
\alias{rowCounts}
\alias{rowCounts,matrix_OR_array_OR_table_OR_numeric-method}
\alias{rowCounts,ANY-method}
\alias{colCounts}
\alias{colCounts,matrix_OR_array_OR_table_OR_numeric-method}
\alias{colCounts,ANY-method}
\title{Count how often an element in a row (column) of a matrix-like object is
equal to a value}
\usage{
rowCounts(x, rows = NULL, cols = NULL, value = TRUE, na.rm = FALSE,
  ..., useNames = NA)

\S4method{rowCounts}{matrix_OR_array_OR_table_OR_numeric}(x, rows = NULL,
  cols = NULL, value = TRUE, na.rm = FALSE, dim. = dim(x), ...,
  useNames = NA)

\S4method{rowCounts}{ANY}(x, rows = NULL, cols = NULL, value = TRUE,
  na.rm = FALSE, ..., useNames = NA)

colCounts(x, rows = NULL, cols = NULL, value = TRUE, na.rm = FALSE,
  ..., useNames = NA)

\S4method{colCounts}{matrix_OR_array_OR_table_OR_numeric}(x, rows = NULL,
  cols = NULL, value = TRUE, na.rm = FALSE, dim. = dim(x), ...,
  useNames = NA)

\S4method{colCounts}{ANY}(x, rows = NULL, cols = NULL, value = TRUE,
  na.rm = FALSE, ..., useNames = NA)
}
\arguments{
\item{x}{An NxK matrix-like object.}

\item{rows, cols}{A \code{\link{vector}} indicating the subset of rows
(and/or columns) to operate over. If \code{\link{NULL}}, no subsetting is
done.}

\item{value}{The value to search for.}

\item{na.rm}{If \code{\link[base:logical]{TRUE}}, \code{\link{NA}}s
are excluded first, otherwise not.}

\item{...}{Additional arguments passed to specific methods.}

\item{useNames}{If \code{\link{NA}}, the default behavior of the function about naming support is remained. If \code{\link{FALSE}}, no naming support is done. Else if \code{\link{TRUE}}, names attributes of result are set.}

\item{dim.}{An \code{\link{integer}} \code{\link{vector}} of length two
specifying the dimension of \code{x}, essential when x is a
\code{\link{numeric}} vector. Note, that this is not a generic
argument and not all methods need provide it.}
}
\value{
Returns a \code{\link{integer}} \code{\link{vector}} of length N (K).
}
\description{
Count how often an element in a row (column) of a matrix-like object is
equal to a value.
}
\details{
The S4 methods for \code{x} of type \code{\link{matrix}},
\code{\link{array}}, or \code{\link{numeric}} call
\code{matrixStats::rowCounts}
/ \code{matrixStats::colCounts}.
}
\examples{
  mat <- matrix(rnorm(15), nrow = 5, ncol = 3)
  mat[2, 1] <- NA
  mat[3, 3] <- Inf
  mat[4, 1] <- 0
  
  print(mat)
  
  rowCounts(mat)
  colCounts(mat)
  
  rowCounts(mat, value = 0)
  colCounts(mat, value = Inf, na.rm = TRUE)
}
\seealso{
\itemize{
\item \code{matrixStats::\link[matrixStats]{rowCounts}()} and
\code{matrixStats::\link[matrixStats:rowCounts]{colCounts}()} which are
used when the input is a \code{matrix} or \code{numeric} vector.
\item For checks if any element is equal to a value, see
\code{\link{rowAnys}()}. To check if all elements are equal, see
\code{\link{rowAlls}()}.
}
}
