% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_coverage.R
\name{read_coverage}
\alias{read_coverage}
\alias{read_coverage_table}
\title{Read a coverage TSV file created by Megadepth}
\usage{
read_coverage(tsv_file, verbose = TRUE)

read_coverage_table(tsv_file)
}
\arguments{
\item{tsv_file}{A \code{character(1)} specifying the path to the tab-separated
(TSV) file created manually using \code{megadepth_shell()} or on a previous
\code{get_coverage()} run.}

\item{verbose}{A \code{logical(1)} controlling whether to suppress messages when
reading the data.}
}
\value{
A \link[GenomicRanges:GRanges-class]{GRanges-class} object with the
coverage summarization across the annotation ranges.

A \code{tibble::tibble()} with columns \code{chr}, \code{start}, \code{end} and \code{score}.
}
\description{
Read an \verb{*annotation.tsv} file created by \code{get_coverage()} or manually by
the user using Megadepth.
}
\section{Functions}{
\itemize{
\item \code{read_coverage_table()}: Read a coverage TSV file created by Megadepth as
a table

}}
\examples{

## Install if necessary
install_megadepth()

## Locate example BigWig and annotation files
example_bw <- system.file("tests", "test.bam.all.bw",
    package = "megadepth", mustWork = TRUE
)
annotation_file <- system.file("tests", "testbw2.bed",
    package = "megadepth", mustWork = TRUE
)

## Compute the coverage
bw_cov <- get_coverage(example_bw, op = "mean", annotation = annotation_file)
bw_cov

## Read in the coverage file again, using read_coverage()
## First, lets locate the tsv file that was generated by get_coverage()
tsv_file <- file.path(tempdir(), "bw.mean.annotation.tsv")
bw_cov_manual <- read_coverage(tsv_file)
stopifnot(identical(bw_cov, bw_cov_manual))

## To get an RleList object, just like the one you would get
## from using rtracklayer::import.bw(as = "RleList") directly on the
## BigWig file, use:
GenomicRanges::coverage(bw_cov_manual)

## The coverage data can also be read as a `tibble::tibble()`
read_coverage_table(tsv_file)
}
\seealso{
Other Coverage functions: 
\code{\link{get_coverage}()}
}
\concept{Coverage functions}
