% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coord-transform.R
\name{coord_transform}
\alias{coord_transform}
\alias{coord_trans}
\title{Transformed Cartesian coordinate system}
\usage{
coord_transform(
  x = "identity",
  y = "identity",
  xlim = NULL,
  ylim = NULL,
  limx = deprecated(),
  limy = deprecated(),
  clip = "on",
  expand = TRUE,
  reverse = "none"
)

coord_trans(...)
}
\arguments{
\item{x, y}{Transformers for x and y axes or their names.}

\item{xlim, ylim}{Limits for the x and y axes.}

\item{limx, limy}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}} use \code{xlim} and \code{ylim} instead.}

\item{clip}{Should drawing be clipped to the extent of the plot panel? A
setting of \code{"on"} (the default) means yes, and a setting of \code{"off"}
means no. In most cases, the default of \code{"on"} should not be changed,
as setting \code{clip = "off"} can cause unexpected results. It allows
drawing of data points anywhere on the plot, including in the plot margins. If
limits are set via \code{xlim} and \code{ylim} and some data points fall outside those
limits, then those data points may show up in places such as the axes, the
legend, the plot title, or the plot margins.}

\item{expand}{If \code{TRUE}, the default, adds a small expansion factor to
the limits to ensure that data and axes don't overlap. If \code{FALSE},
limits are taken exactly from the data or \code{xlim}/\code{ylim}.
Giving a logical vector will separately control the expansion for the four
directions (top, left, bottom and right). The \code{expand} argument will be
recycled to length 4 if necessary. Alternatively, can be a named logical
vector to control a single direction, e.g. \code{expand = c(bottom = FALSE)}.}

\item{reverse}{A string giving which directions to reverse. \code{"none"}
(default) keeps directions as is. \code{"x"} and \code{"y"} can be used to reverse
their respective directions. \code{"xy"} can be used to reverse both
directions.}

\item{...}{Arguments forwarded to \code{coord_transform()}.}
}
\description{
\code{coord_transform()} is different to scale transformations in that it occurs after
statistical transformation and will affect the visual appearance of geoms - there is
no guarantee that straight lines will continue to be straight.
}
\details{
Transformations only work with continuous values: see
\code{\link[scales:new_transform]{scales::new_transform()}} for list of transformations, and instructions
on how to create your own.

The \code{coord_trans()} function is deprecated in favour of \code{coord_transform()}.
}
\examples{
\donttest{
# See ?geom_boxplot for other examples

# Three ways of doing transformation in ggplot:
#  * by transforming the data
ggplot(diamonds, aes(log10(carat), log10(price))) +
  geom_point()
#  * by transforming the scales
ggplot(diamonds, aes(carat, price)) +
  geom_point() +
  scale_x_log10() +
  scale_y_log10()
#  * by transforming the coordinate system:
ggplot(diamonds, aes(carat, price)) +
  geom_point() +
  coord_transform(x = "log10", y = "log10")

# The difference between transforming the scales and
# transforming the coordinate system is that scale
# transformation occurs BEFORE statistics, and coordinate
# transformation afterwards.  Coordinate transformation also
# changes the shape of geoms:

d <- subset(diamonds, carat > 0.5)

ggplot(d, aes(carat, price)) +
  geom_point() +
  geom_smooth(method = "lm") +
  scale_x_log10() +
  scale_y_log10()

ggplot(d, aes(carat, price)) +
  geom_point() +
  geom_smooth(method = "lm") +
  coord_transform(x = "log10", y = "log10")

# Here I used a subset of diamonds so that the smoothed line didn't
# drop below zero, which obviously causes problems on the log-transformed
# scale

# With a combination of scale and coordinate transformation, it's
# possible to do back-transformations:
ggplot(diamonds, aes(carat, price)) +
  geom_point() +
  geom_smooth(method = "lm") +
  scale_x_log10() +
  scale_y_log10() +
  coord_transform(x = scales::transform_exp(10), y = scales::transform_exp(10))

# cf.
ggplot(diamonds, aes(carat, price)) +
  geom_point() +
  geom_smooth(method = "lm")

# Also works with discrete scales
set.seed(1)
df <- data.frame(a = abs(rnorm(26)),letters)
plot <- ggplot(df,aes(a,letters)) + geom_point()

plot + coord_transform(x = "log10")
plot + coord_transform(x = "sqrt")
}
}
\seealso{
The \href{https://ggplot2-book.org/coord#transformations-with-coord_trans}{coord transformations section} of the online ggplot2 book.
}
