% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/haven.R
\name{read_xpt}
\alias{read_xpt}
\alias{write_xpt}
\title{Read and write SAS transport files}
\usage{
read_xpt(file, col_select = NULL, skip = 0, n_max = Inf,
  .name_repair = "unique")

write_xpt(data, path, version = 8, name = NULL)
}
\arguments{
\item{file}{Either a path to a file, a connection, or literal data
(either a single string or a raw vector).

Files ending in \code{.gz}, \code{.bz2}, \code{.xz}, or \code{.zip} will
be automatically uncompressed. Files starting with \code{http://},
\code{https://}, \code{ftp://}, or \code{ftps://} will be automatically
downloaded. Remote gz files can also be automatically downloaded and
decompressed.

Literal data is most useful for examples and tests. It must contain at
least one new line to be recognised as data (instead of a path) or be a
vector of greater than length 1.

Using a value of \code{\link[=clipboard]{clipboard()}} will read from the system clipboard.}

\item{col_select}{One or more selection expressions, like in
\code{\link[dplyr:select]{dplyr::select()}}. Use \code{c()} or \code{list()} to use more than one expression.
See \code{?dplyr::select} for details on available selection options. Only the
specified columns will be read from \code{data_file}.}

\item{skip}{Number of lines to skip before reading data.}

\item{n_max}{Maximum number of lines to read.}

\item{.name_repair}{Treatment of problematic column names:
\itemize{
\item \code{"minimal"}: No name repair or checks, beyond basic existence,
\item \code{"unique"}: Make sure names are unique and not empty,
\item \code{"check_unique"}: (default value), no name repair, but check they are
\code{unique},
\item \code{"universal"}: Make the names \code{unique} and syntactic
\item a function: apply custom name repair (e.g., \code{.name_repair = make.names}
for names in the style of base R).
\item A purrr-style anonymous function, see \code{\link[rlang:as_function]{rlang::as_function()}}
}

See \link{name-repair} for more details on these terms and the strategies used
to enforce them.}

\item{data}{Data frame to write.}

\item{path}{Path to a file where the data will be written.}

\item{version}{Version of transport file specification to use: either 5 or 8.}

\item{name}{Member name to record in file. Defaults to file name sans
extension. Must be <= 8 characters for version 5, and <= 32 characters
for version 8.}
}
\value{
A tibble, data frame variant with nice defaults.

Variable labels are stored in the "label" attribute of each variable.
It is not printed on the console, but the RStudio viewer will show it.

\code{write_xpt()} returns the input \code{data} invisibly.
}
\description{
The SAS transport format is a open format, as is required for submission
of the data to the FDA.
}
\examples{
tmp <- tempfile(fileext = ".xpt")
write_xpt(mtcars, tmp)
read_xpt(tmp)
}
