% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ns_export.R
\name{ns_export}
\alias{ns_export}
\alias{ns_export_status}
\title{Search exports}
\usage{
ns_export(
  text = NULL,
  text_adv = NULL,
  status = NULL,
  location = NULL,
  record_type = NULL,
  record_subtype = NULL,
  modified_since = NULL,
  format = "json",
  lang = "en",
  ...
)

ns_export_status(id, ...)
}
\arguments{
\item{text}{(character) basic text search, equiavalent to \code{text_adv}
with \code{matchAgainst="allNames"} and \code{operator="similarTo"}}

\item{text_adv}{(list) advanced search, must specify the following three
elements: \code{searchToken}, \code{matchAgainst}, and \code{operator}. see
https://explorer.natureserve.org/api-docs/#_advanced_text_search_parameter}

\item{status}{(character) conservation status, one of G1, G2, G3, G4,
G5, GH, GX, GNR, GNA, GU. case insensitive}

\item{location}{(list) location, country and sub-country. specify either
\code{nation} OR \code{nation} and \code{subnation}. each expects a two-letter ISO code}

\item{record_type}{(character) limit results by record type, one of
"species" or "ecosystem"}

\item{record_subtype}{(character) limit results by record sub-type, one of:
"class", "subclass", "formation", "division", "macrogroup", "group",
"alliance", "association", "terrestrial_ecological_system"}

\item{modified_since}{(character) search for records modified since a
given time. value must be a date and time with a UTC offset in ISO 8601
format. optional}

\item{format}{(character) output format, one of "json" or "xlsx"}

\item{lang}{(character) language, one of "en", "es", or "fr"}

\item{...}{Curl options passed on to \code{\link[crul]{verb-GET}}}

\item{id}{(character) a job id, from output of \code{ns_export()}}
}
\value{
\code{ns_export()} returns a single character string (a job id)
\code{ns_export_status()} returns a list of metadata concerning the
status of the export
}
\description{
Search exports
}
\examples{
\dontrun{
x <- ns_export(text = "robin")
res <- ns_export_status(x)
str(res)
res$state
res$data$errorMessage
res$data$url

w <- ns_export(text_adv = list(searchToken = "western",
  matchAgainst="allScientificNames", operator="startsWith"))
m <- ns_export_status(w)
head(jsonlite::fromJSON(m$data$url))
}
}
\references{
https://explorer.natureserve.org/api-docs/
}
