% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bootstrap.R, R/render-table.R
\name{tableOutput}
\alias{tableOutput}
\alias{renderTable}
\title{Table Output}
\usage{
tableOutput(outputId)

renderTable(
  expr,
  striped = FALSE,
  hover = FALSE,
  bordered = FALSE,
  spacing = c("s", "xs", "m", "l"),
  width = "auto",
  align = NULL,
  rownames = FALSE,
  colnames = TRUE,
  digits = NULL,
  na = "NA",
  ...,
  env = parent.frame(),
  quoted = FALSE,
  outputArgs = list()
)
}
\arguments{
\item{outputId}{output variable to read the table from}

\item{expr}{An expression that returns an R object that can be used with
\code{\link[xtable:xtable]{xtable::xtable()}}.}

\item{striped, hover, bordered}{Logicals: if \code{TRUE}, apply the
corresponding Bootstrap table format to the output table.}

\item{spacing}{The spacing between the rows of the table (\code{xs}
stands for "extra small", \code{s} for "small", \code{m} for "medium"
and \code{l} for "large").}

\item{width}{Table width. Must be a valid CSS unit (like "100\%", "400px",
"auto") or a number, which will be coerced to a string and
have "px" appended.}

\item{align}{A string that specifies the column alignment. If equal to
\code{'l'}, \code{'c'} or \code{'r'}, then all columns will be,
respectively, left-, center- or right-aligned. Otherwise, \code{align}
must have the same number of characters as the resulting table (if
\code{rownames = TRUE}, this will be equal to \code{ncol()+1}), with
the \emph{i}-th character specifying the alignment for the
\emph{i}-th column (besides \code{'l'}, \code{'c'} and
\code{'r'}, \code{'?'} is also permitted - \code{'?'} is a placeholder
for that particular column, indicating that it should keep its default
alignment). If \code{NULL}, then all numeric/integer columns (including
the row names, if they are numbers) will be right-aligned and
everything else will be left-aligned (\code{align = '?'} produces the
same result).}

\item{rownames, colnames}{Logicals: include rownames? include colnames
(column headers)?}

\item{digits}{An integer specifying the number of decimal places for
the numeric columns (this will not apply to columns with an integer
class). If \code{digits} is set to a negative value, then the numeric
columns will be displayed in scientific format with a precision of
\code{abs(digits)} digits.}

\item{na}{The string to use in the table cells whose values are missing
(i.e. they either evaluate to \code{NA} or \code{NaN}).}

\item{...}{Arguments to be passed through to \code{\link[xtable:xtable]{xtable::xtable()}}
and \code{\link[xtable:print.xtable]{xtable::print.xtable()}}.}

\item{env}{The parent environment for the reactive expression. By default,
this is the calling environment, the same as when defining an ordinary
non-reactive expression. If \code{expr} is a quosure and \code{quoted} is \code{TRUE},
then \code{env} is ignored.}

\item{quoted}{If it is \code{TRUE}, then the \code{\link[=quote]{quote()}}ed value of \code{expr}
will be used when \code{expr} is evaluated. If \code{expr} is a quosure and you
would like to use its expression as a value for \code{expr}, then you must set
\code{quoted} to \code{TRUE}.}

\item{outputArgs}{A list of arguments to be passed through to the
implicit call to \code{\link[=tableOutput]{tableOutput()}} when \code{renderTable} is
used in an interactive R Markdown document.}
}
\description{
The \code{tableOuptut()}/\code{renderTable()} pair creates a reactive table that is
suitable for display small matrices and data frames. The columns are
formatted with \code{\link[xtable:xtable]{xtable::xtable()}}.

See \code{\link[=renderDataTable]{renderDataTable()}} for data frames that are too big to fit on a single
page.
}
\examples{
## Only run this example in interactive R sessions
if (interactive()) {
  # table example
  shinyApp(
    ui = fluidPage(
      fluidRow(
        column(12,
          tableOutput('table')
        )
      )
    ),
    server = function(input, output) {
      output$table <- renderTable(iris)
    }
  )
}
}
