% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/us_states.R
\docType{data}
\name{us_states}
\alias{us_states}
\title{US states polygons}
\format{
Formal class 'sf' [package "sf"]; the data contains a data.frame with 49 obs. of 7 variables:
\itemize{
    \item{GEOID} {character vector of geographic identifiers}
    \item{NAME} {character vector of state names}
    \item{REGION} {character vector of region names}
    \item{AREA} {area in square kilometers of units class}
    \item{total_pop_10} {numerical vector of total population in 2010}
    \item{total_pop_15} {numerical vector of total population in 2015}
    \item{geometry} {sfc_MULTIPOLYGON}
}
The object is in geographical coordinates using the NAD83 datum.
}
\source{
\url{https://www.census.gov/geographies/mapping-files/time-series/geo/tiger-line-file.html}
}
\usage{
us_states
}
\description{
The object loaded is a \code{sf} object containing the contiguous United States data from the US Census Bureau
with a few variables from American Community Survey (ACS)
}
\examples{
if (requireNamespace("sf", quietly = TRUE)) {
  library(sf)
  data(us_states)

  plot(us_states["REGION"])
}
}
\seealso{
See the tigris package: https://cran.r-project.org/package=tigris
}
\keyword{datasets}
\keyword{sf}
