# Announce: Rakudo Perl 6 compiler, Development Release #92 (“Niceville”)

On behalf of the Rakudo development team, I’m very happy to announce the October
2015 release of Rakudo Perl 6 #92 “Niceville”. Rakudo is an implementation of
Perl 6 on the Moar Virtual Machine[^1] and the Java Virtual Machine.

This is the “Birthday” release of Rakudo Perl 6; It’s the first release
candidate/beta of the compiler for the anticipated 6.0 “Christmas” release.
The “Christmas” release will occur on or about 17 December 2015, assuming
no critical bugs are found between now and then. Please try the release,
your feedback is greatly appreciated.

The tarball for this release is available from <http://rakudo.org/downloads/rakudo/>.

Please note: This announcement is not for the Rakudo Star
distribution[^2] --- it’s announcing a new release of the compiler
only. For the latest Rakudo Star release, see
<http://rakudo.org/downloads/star/>.

The Rakudo Perl compiler follows a monthly release cycle, with each
release named after a Perl Mongers group. This month’s release is named after
the Niceville chapter, because it sounds like a wonderful, magical place.

Some of the changes in this release are outlined below:

+ We are now officially in beta!
+ There is now an infix:<.> operator that does method calls with slightly
  looser precedence than the postfix unary method call.
+ New operator 'infix o' for function composition
+ 'fc' for Unicode-correct case folding implemented
+ grep now accepts :k, :v, :kv, :p attributes
+ 'Supply.throttle' for rate-limiting
+ Array.push is now used for pushing one element (mostly); Array.append
  exists for pushing multiple values. Same for 'unshift'/'prepend'
+ Basic arithmetic operations ('+', '*', '-', '/') on Range objects
  that shift or scale the end points while maintaining exclusions
+ The v notation now allows alphabetic components: v1.2.beta.  (Incompatible
  because method calls on a version must be protected by \ or () now.)
+ 'use v6b+;' notation is now recognized and enforced
+ Many built-in methods that return iterables are now much faster
+ Better error messages when comparing version strings with numbers
+ Several error messages that were lacking line numbers now include them

These are only some of the changes in this release. For a more
detailed list, see “docs/ChangeLog”.

The development team thanks all of our contributors and sponsors for
making Rakudo Perl possible, as well as those people who worked on
the design docs, the Perl 6 test suite, MoarVM and the specification.

The following people contributed to this release:

Elizabeth Mattijsen, Larry Wall, Jonathan Worthington, Pawel Murias, Christian Bartolomäus, Tobias Leich, Stefan Seifert, Will "Coke" Coleda, Pepe Schwarz, Francois Perrad, skids, Rob Hoelz, Faye Niemeyer, Moritz Lenz, Jimmy Zhuo, Timo Paulssen, Stéphane Payrard, cygx, Nick Logan, Solomon Foster, tony-o, Bart Wiegmans, Steve Mynott, diakopter, niner, Tokuhiro Matsuno, Carl Mäsak, Nicholas Clark, thundergnat, Jonathan Scott Duff, Shoichi Kaji, sue spence, David Warring

If you would like to contribute or find out more information, visit
<http://perl6.org>, <http://rakudo.org/how-to-help>, ask on the
<perl6-compiler@perl.org> mailing list, or ask on IRC #perl6 on freenode.

The next release of Rakudo (#93), is scheduled for 19 November 2015.
A list of the other planned release dates and code names for future
releases is available in the “docs/release_guide.pod” file. A Rakudo
development release typically occurs a few days (often two) after the
third Tuesday of each month.

The development team appreciates feedback! If you’re using Rakudo, do
get back to us. Questions, comments, suggestions for improvements, cool
discoveries, incredible hacks, or any other feedback -- get in touch with
us through (the above-mentioned) mailing list or IRC channel. Enjoy!

[^1]: See <http://moarvm.org/>

[^2]: What’s the difference between the Rakudo compiler and the Rakudo
Star distribution?

The Rakudo compiler is a compiler for the Perl 6 language.
Not much more.

The Rakudo Star distribution is the Rakudo compiler plus a selection
of useful Perl 6 modules, a module installer, the most recent
incarnation of the “Using Perl 6” book, and other software that can
be used with the Rakudo compiler to enhance its utility. Rakudo Star
is meant for early adopters who wish to explore what’s possible with
Rakudo Perl 6 and provide feedback on what works, what doesn’t, and
what else they would like to see included in the distribution.
