///
/// This file is part of Rheolef.
///
/// Copyright (C) 2000-2009 Pierre Saramito <Pierre.Saramito@imag.fr>
///
/// Rheolef is free software; you can redistribute it and/or modify
/// it under the terms of the GNU General Public License as published by
/// the Free Software Foundation; either version 2 of the License, or
/// (at your option) any later version.
///
/// Rheolef is distributed in the hope that it will be useful,
/// but WITHOUT ANY WARRANTY; without even the implied warranty of
/// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
/// GNU General Public License for more details.
///
/// You should have received a copy of the GNU General Public License
/// along with Rheolef; if not, write to the Free Software
/// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
///
/// =========================================================================
//
// test cg solver
//
# include "rheolef/skit.h"
# include "rheolef/cg.h"
using namespace rheolef;
using namespace std;

extern
void
check (
    const char* method, 
    int max_iter, 
    const csr<Float>& a, 
    const vec<Float>& x, 
    const vec<Float>& b);

int solve_cg (const csr<Float>& a, const vec<Float>& b)
{
    vec<Float> x(a.ncol());
    x = 0; 
    int max_iter = 100; 
    Float tol = 1e-12;
    int status = cg(a, x, b, basic_diag<Float>(a), max_iter, tol);
    check("cg",max_iter,a,x,b);
    return status;
}

