# Copyright 2015 Google Inc.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#      http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

require 'date'
require 'google/apis/core/base_service'
require 'google/apis/core/json_representation'
require 'google/apis/core/hashable'
require 'google/apis/errors'

module Google
  module Apis
    module ApigeeV1
      
      class GoogleApiHttpBody
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class GoogleCloudApigeeV1Access
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class GoogleCloudApigeeV1AccessGet
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class GoogleCloudApigeeV1AccessRemove
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class GoogleCloudApigeeV1AccessSet
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class GoogleCloudApigeeV1ActivateNatAddressRequest
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class GoogleCloudApigeeV1Alias
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class GoogleCloudApigeeV1AliasRevisionConfig
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class GoogleCloudApigeeV1ApiCategory
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class GoogleCloudApigeeV1ApiCategoryData
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class GoogleCloudApigeeV1ApiProduct
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class GoogleCloudApigeeV1ApiProductRef
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class GoogleCloudApigeeV1ApiProxy
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class GoogleCloudApigeeV1ApiProxyRevision
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class GoogleCloudApigeeV1ApiResponseWrapper
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class GoogleCloudApigeeV1App
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class GoogleCloudApigeeV1AsyncQuery
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class GoogleCloudApigeeV1AsyncQueryResult
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class GoogleCloudApigeeV1AsyncQueryResultView
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class GoogleCloudApigeeV1Attribute
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class GoogleCloudApigeeV1Attributes
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class GoogleCloudApigeeV1CanaryEvaluation
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class GoogleCloudApigeeV1CanaryEvaluationMetricLabels
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class GoogleCloudApigeeV1CertInfo
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class GoogleCloudApigeeV1Certificate
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class GoogleCloudApigeeV1CommonNameConfig
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class GoogleCloudApigeeV1ConfigVersion
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class GoogleCloudApigeeV1Credential
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class GoogleCloudApigeeV1CustomReport
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class GoogleCloudApigeeV1CustomReportMetric
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class GoogleCloudApigeeV1DataCollector
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class GoogleCloudApigeeV1DataCollectorConfig
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class GoogleCloudApigeeV1Datastore
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class GoogleCloudApigeeV1DatastoreConfig
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class GoogleCloudApigeeV1DateRange
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class GoogleCloudApigeeV1DebugMask
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class GoogleCloudApigeeV1DebugSession
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class GoogleCloudApigeeV1DebugSessionTransaction
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class GoogleCloudApigeeV1DeleteCustomReportResponse
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class GoogleCloudApigeeV1Deployment
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class GoogleCloudApigeeV1DeploymentChangeReport
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class GoogleCloudApigeeV1DeploymentChangeReportRoutingChange
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class GoogleCloudApigeeV1DeploymentChangeReportRoutingConflict
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class GoogleCloudApigeeV1DeploymentChangeReportRoutingDeployment
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class GoogleCloudApigeeV1DeploymentConfig
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class GoogleCloudApigeeV1Developer
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class GoogleCloudApigeeV1DeveloperApp
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class GoogleCloudApigeeV1DeveloperAppKey
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class GoogleCloudApigeeV1DimensionMetric
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class GoogleCloudApigeeV1EntityMetadata
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class GoogleCloudApigeeV1Environment
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class GoogleCloudApigeeV1EnvironmentConfig
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class GoogleCloudApigeeV1EnvironmentGroup
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class GoogleCloudApigeeV1EnvironmentGroupAttachment
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class GoogleCloudApigeeV1EnvironmentGroupConfig
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class GoogleCloudApigeeV1Export
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class GoogleCloudApigeeV1ExportRequest
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class GoogleCloudApigeeV1FlowHook
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class GoogleCloudApigeeV1FlowHookConfig
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class GoogleCloudApigeeV1GetSyncAuthorizationRequest
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class GoogleCloudApigeeV1IngressConfig
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class GoogleCloudApigeeV1Instance
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class GoogleCloudApigeeV1InstanceAttachment
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class GoogleCloudApigeeV1InstanceDeploymentStatus
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class GoogleCloudApigeeV1InstanceDeploymentStatusDeployedRevision
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class GoogleCloudApigeeV1InstanceDeploymentStatusDeployedRoute
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class GoogleCloudApigeeV1KeyAliasReference
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class GoogleCloudApigeeV1KeyValueMap
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class GoogleCloudApigeeV1Keystore
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class GoogleCloudApigeeV1KeystoreConfig
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class GoogleCloudApigeeV1ListApiCategoriesResponse
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class GoogleCloudApigeeV1ListApiProductsResponse
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class GoogleCloudApigeeV1ListApiProxiesResponse
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class GoogleCloudApigeeV1ListAppsResponse
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class GoogleCloudApigeeV1ListAsyncQueriesResponse
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class GoogleCloudApigeeV1ListCustomReportsResponse
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class GoogleCloudApigeeV1ListDataCollectorsResponse
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class GoogleCloudApigeeV1ListDatastoresResponse
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class GoogleCloudApigeeV1ListDebugSessionsResponse
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class GoogleCloudApigeeV1ListDeploymentsResponse
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class GoogleCloudApigeeV1ListDeveloperAppsResponse
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class GoogleCloudApigeeV1ListEnvironmentGroupAttachmentsResponse
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class GoogleCloudApigeeV1ListEnvironmentGroupsResponse
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class GoogleCloudApigeeV1ListEnvironmentResourcesResponse
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class GoogleCloudApigeeV1ListExportsResponse
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class GoogleCloudApigeeV1ListHybridIssuersResponse
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class GoogleCloudApigeeV1ListInstanceAttachmentsResponse
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class GoogleCloudApigeeV1ListInstancesResponse
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class GoogleCloudApigeeV1ListNatAddressesResponse
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class GoogleCloudApigeeV1ListOfDevelopersResponse
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class GoogleCloudApigeeV1ListOrganizationsResponse
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class GoogleCloudApigeeV1ListSharedFlowsResponse
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class GoogleCloudApigeeV1Metadata
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class GoogleCloudApigeeV1Metric
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class GoogleCloudApigeeV1NatAddress
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class GoogleCloudApigeeV1Operation
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class GoogleCloudApigeeV1OperationConfig
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class GoogleCloudApigeeV1OperationGroup
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class GoogleCloudApigeeV1OperationMetadata
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class GoogleCloudApigeeV1OptimizedStats
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class GoogleCloudApigeeV1OptimizedStatsNode
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class GoogleCloudApigeeV1OptimizedStatsResponse
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class GoogleCloudApigeeV1Organization
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class GoogleCloudApigeeV1OrganizationProjectMapping
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class GoogleCloudApigeeV1PodStatus
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class GoogleCloudApigeeV1Point
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class GoogleCloudApigeeV1Properties
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class GoogleCloudApigeeV1Property
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class GoogleCloudApigeeV1ProvisionOrganizationRequest
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class GoogleCloudApigeeV1Query
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class GoogleCloudApigeeV1QueryMetadata
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class GoogleCloudApigeeV1QueryMetric
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class GoogleCloudApigeeV1Quota
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class GoogleCloudApigeeV1Reference
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class GoogleCloudApigeeV1ReferenceConfig
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class GoogleCloudApigeeV1ReportInstanceStatusRequest
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class GoogleCloudApigeeV1ReportInstanceStatusResponse
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class GoogleCloudApigeeV1ReportProperty
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class GoogleCloudApigeeV1ResourceConfig
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class GoogleCloudApigeeV1ResourceFile
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class GoogleCloudApigeeV1ResourceFiles
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class GoogleCloudApigeeV1ResourceStatus
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class GoogleCloudApigeeV1Result
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class GoogleCloudApigeeV1RevisionStatus
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class GoogleCloudApigeeV1RoutingRule
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class GoogleCloudApigeeV1RuntimeTraceConfig
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class GoogleCloudApigeeV1RuntimeTraceConfigOverride
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class GoogleCloudApigeeV1RuntimeTraceSamplingConfig
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class GoogleCloudApigeeV1Schema
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class GoogleCloudApigeeV1SchemaSchemaElement
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class GoogleCloudApigeeV1SchemaSchemaProperty
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class GoogleCloudApigeeV1ServiceIssuersMapping
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class GoogleCloudApigeeV1Session
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class GoogleCloudApigeeV1SharedFlow
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class GoogleCloudApigeeV1SharedFlowRevision
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class GoogleCloudApigeeV1Stats
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class GoogleCloudApigeeV1StatsEnvironmentStats
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class GoogleCloudApigeeV1StatsHostStats
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class GoogleCloudApigeeV1Subscription
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class GoogleCloudApigeeV1SyncAuthorization
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class GoogleCloudApigeeV1TargetServer
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class GoogleCloudApigeeV1TargetServerConfig
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class GoogleCloudApigeeV1TestDatastoreResponse
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class GoogleCloudApigeeV1TlsInfo
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class GoogleCloudApigeeV1TlsInfoCommonName
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class GoogleCloudApigeeV1TlsInfoConfig
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class GoogleCloudApigeeV1UpdateError
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class GoogleIamV1AuditConfig
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class GoogleIamV1AuditLogConfig
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class GoogleIamV1Binding
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class GoogleIamV1Policy
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class GoogleIamV1SetIamPolicyRequest
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class GoogleIamV1TestIamPermissionsRequest
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class GoogleIamV1TestIamPermissionsResponse
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class GoogleLongrunningListOperationsResponse
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class GoogleLongrunningOperation
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class GoogleProtobufEmpty
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class GoogleRpcPreconditionFailure
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class GoogleRpcPreconditionFailureViolation
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class GoogleRpcStatus
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class GoogleTypeExpr
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class GoogleApiHttpBody
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :content_type, as: 'contentType'
          property :data, :base64 => true, as: 'data'
          collection :extensions, as: 'extensions'
        end
      end
      
      class GoogleCloudApigeeV1Access
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :get, as: 'Get', class: Google::Apis::ApigeeV1::GoogleCloudApigeeV1AccessGet, decorator: Google::Apis::ApigeeV1::GoogleCloudApigeeV1AccessGet::Representation
      
          property :remove, as: 'Remove', class: Google::Apis::ApigeeV1::GoogleCloudApigeeV1AccessRemove, decorator: Google::Apis::ApigeeV1::GoogleCloudApigeeV1AccessRemove::Representation
      
          property :set, as: 'Set', class: Google::Apis::ApigeeV1::GoogleCloudApigeeV1AccessSet, decorator: Google::Apis::ApigeeV1::GoogleCloudApigeeV1AccessSet::Representation
      
        end
      end
      
      class GoogleCloudApigeeV1AccessGet
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :name, as: 'name'
          property :value, as: 'value'
        end
      end
      
      class GoogleCloudApigeeV1AccessRemove
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :name, as: 'name'
          property :success, as: 'success'
        end
      end
      
      class GoogleCloudApigeeV1AccessSet
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :name, as: 'name'
          property :success, as: 'success'
          property :value, as: 'value'
        end
      end
      
      class GoogleCloudApigeeV1ActivateNatAddressRequest
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
        end
      end
      
      class GoogleCloudApigeeV1Alias
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :alias, as: 'alias'
          property :certs_info, as: 'certsInfo', class: Google::Apis::ApigeeV1::GoogleCloudApigeeV1Certificate, decorator: Google::Apis::ApigeeV1::GoogleCloudApigeeV1Certificate::Representation
      
          property :type, as: 'type'
        end
      end
      
      class GoogleCloudApigeeV1AliasRevisionConfig
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :location, as: 'location'
          property :name, as: 'name'
          property :type, as: 'type'
        end
      end
      
      class GoogleCloudApigeeV1ApiCategory
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :data, as: 'data', class: Google::Apis::ApigeeV1::GoogleCloudApigeeV1ApiCategoryData, decorator: Google::Apis::ApigeeV1::GoogleCloudApigeeV1ApiCategoryData::Representation
      
          property :error_code, as: 'errorCode'
          property :message, as: 'message'
          property :request_id, as: 'requestId'
          property :status, as: 'status'
        end
      end
      
      class GoogleCloudApigeeV1ApiCategoryData
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :id, as: 'id'
          property :name, as: 'name'
          property :site_id, as: 'siteId'
          property :update_time, :numeric_string => true, as: 'updateTime'
        end
      end
      
      class GoogleCloudApigeeV1ApiProduct
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          collection :api_resources, as: 'apiResources'
          property :approval_type, as: 'approvalType'
          collection :attributes, as: 'attributes', class: Google::Apis::ApigeeV1::GoogleCloudApigeeV1Attribute, decorator: Google::Apis::ApigeeV1::GoogleCloudApigeeV1Attribute::Representation
      
          property :created_at, :numeric_string => true, as: 'createdAt'
          property :description, as: 'description'
          property :display_name, as: 'displayName'
          collection :environments, as: 'environments'
          property :last_modified_at, :numeric_string => true, as: 'lastModifiedAt'
          property :name, as: 'name'
          property :operation_group, as: 'operationGroup', class: Google::Apis::ApigeeV1::GoogleCloudApigeeV1OperationGroup, decorator: Google::Apis::ApigeeV1::GoogleCloudApigeeV1OperationGroup::Representation
      
          collection :proxies, as: 'proxies'
          property :quota, as: 'quota'
          property :quota_interval, as: 'quotaInterval'
          property :quota_time_unit, as: 'quotaTimeUnit'
          collection :scopes, as: 'scopes'
        end
      end
      
      class GoogleCloudApigeeV1ApiProductRef
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :apiproduct, as: 'apiproduct'
          property :status, as: 'status'
        end
      end
      
      class GoogleCloudApigeeV1ApiProxy
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :latest_revision_id, as: 'latestRevisionId'
          property :meta_data, as: 'metaData', class: Google::Apis::ApigeeV1::GoogleCloudApigeeV1EntityMetadata, decorator: Google::Apis::ApigeeV1::GoogleCloudApigeeV1EntityMetadata::Representation
      
          property :name, as: 'name'
          collection :revision, as: 'revision'
        end
      end
      
      class GoogleCloudApigeeV1ApiProxyRevision
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          collection :basepaths, as: 'basepaths'
          property :configuration_version, as: 'configurationVersion', class: Google::Apis::ApigeeV1::GoogleCloudApigeeV1ConfigVersion, decorator: Google::Apis::ApigeeV1::GoogleCloudApigeeV1ConfigVersion::Representation
      
          property :context_info, as: 'contextInfo'
          property :created_at, :numeric_string => true, as: 'createdAt'
          property :description, as: 'description'
          property :display_name, as: 'displayName'
          hash :entity_meta_data_as_properties, as: 'entityMetaDataAsProperties'
          property :last_modified_at, :numeric_string => true, as: 'lastModifiedAt'
          property :name, as: 'name'
          collection :policies, as: 'policies'
          collection :proxies, as: 'proxies'
          collection :proxy_endpoints, as: 'proxyEndpoints'
          property :resource_files, as: 'resourceFiles', class: Google::Apis::ApigeeV1::GoogleCloudApigeeV1ResourceFiles, decorator: Google::Apis::ApigeeV1::GoogleCloudApigeeV1ResourceFiles::Representation
      
          collection :resources, as: 'resources'
          property :revision, as: 'revision'
          collection :shared_flows, as: 'sharedFlows'
          property :spec, as: 'spec'
          collection :target_endpoints, as: 'targetEndpoints'
          collection :target_servers, as: 'targetServers'
          collection :targets, as: 'targets'
          collection :teams, as: 'teams'
          property :type, as: 'type'
        end
      end
      
      class GoogleCloudApigeeV1ApiResponseWrapper
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :error_code, as: 'errorCode'
          property :message, as: 'message'
          property :request_id, as: 'requestId'
          property :status, as: 'status'
        end
      end
      
      class GoogleCloudApigeeV1App
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          collection :api_products, as: 'apiProducts', class: Google::Apis::ApigeeV1::GoogleCloudApigeeV1ApiProductRef, decorator: Google::Apis::ApigeeV1::GoogleCloudApigeeV1ApiProductRef::Representation
      
          property :app_id, as: 'appId'
          collection :attributes, as: 'attributes', class: Google::Apis::ApigeeV1::GoogleCloudApigeeV1Attribute, decorator: Google::Apis::ApigeeV1::GoogleCloudApigeeV1Attribute::Representation
      
          property :callback_url, as: 'callbackUrl'
          property :company_name, as: 'companyName'
          property :created_at, :numeric_string => true, as: 'createdAt'
          collection :credentials, as: 'credentials', class: Google::Apis::ApigeeV1::GoogleCloudApigeeV1Credential, decorator: Google::Apis::ApigeeV1::GoogleCloudApigeeV1Credential::Representation
      
          property :developer_id, as: 'developerId'
          property :key_expires_in, :numeric_string => true, as: 'keyExpiresIn'
          property :last_modified_at, :numeric_string => true, as: 'lastModifiedAt'
          property :name, as: 'name'
          collection :scopes, as: 'scopes'
          property :status, as: 'status'
        end
      end
      
      class GoogleCloudApigeeV1AsyncQuery
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :created, as: 'created'
          property :envgroup_hostname, as: 'envgroupHostname'
          property :error, as: 'error'
          property :execution_time, as: 'executionTime'
          property :name, as: 'name'
          property :query_params, as: 'queryParams', class: Google::Apis::ApigeeV1::GoogleCloudApigeeV1QueryMetadata, decorator: Google::Apis::ApigeeV1::GoogleCloudApigeeV1QueryMetadata::Representation
      
          property :report_definition_id, as: 'reportDefinitionId'
          property :result, as: 'result', class: Google::Apis::ApigeeV1::GoogleCloudApigeeV1AsyncQueryResult, decorator: Google::Apis::ApigeeV1::GoogleCloudApigeeV1AsyncQueryResult::Representation
      
          property :result_file_size, as: 'resultFileSize'
          property :result_rows, :numeric_string => true, as: 'resultRows'
          property :self, as: 'self'
          property :state, as: 'state'
          property :updated, as: 'updated'
        end
      end
      
      class GoogleCloudApigeeV1AsyncQueryResult
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :expires, as: 'expires'
          property :self, as: 'self'
        end
      end
      
      class GoogleCloudApigeeV1AsyncQueryResultView
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :code, as: 'code'
          property :error, as: 'error'
          property :metadata, as: 'metadata', class: Google::Apis::ApigeeV1::GoogleCloudApigeeV1QueryMetadata, decorator: Google::Apis::ApigeeV1::GoogleCloudApigeeV1QueryMetadata::Representation
      
          collection :rows, as: 'rows'
          property :state, as: 'state'
        end
      end
      
      class GoogleCloudApigeeV1Attribute
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :name, as: 'name'
          property :value, as: 'value'
        end
      end
      
      class GoogleCloudApigeeV1Attributes
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          collection :attribute, as: 'attribute', class: Google::Apis::ApigeeV1::GoogleCloudApigeeV1Attribute, decorator: Google::Apis::ApigeeV1::GoogleCloudApigeeV1Attribute::Representation
      
        end
      end
      
      class GoogleCloudApigeeV1CanaryEvaluation
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :control, as: 'control'
          property :create_time, as: 'createTime'
          property :end_time, as: 'endTime'
          property :metric_labels, as: 'metricLabels', class: Google::Apis::ApigeeV1::GoogleCloudApigeeV1CanaryEvaluationMetricLabels, decorator: Google::Apis::ApigeeV1::GoogleCloudApigeeV1CanaryEvaluationMetricLabels::Representation
      
          property :name, as: 'name'
          property :start_time, as: 'startTime'
          property :state, as: 'state'
          property :treatment, as: 'treatment'
          property :verdict, as: 'verdict'
        end
      end
      
      class GoogleCloudApigeeV1CanaryEvaluationMetricLabels
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :env, as: 'env'
          property :instance_id, as: 'instance_id'
          property :location, as: 'location'
        end
      end
      
      class GoogleCloudApigeeV1CertInfo
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :basic_constraints, as: 'basicConstraints'
          property :expiry_date, :numeric_string => true, as: 'expiryDate'
          property :is_valid, as: 'isValid'
          property :issuer, as: 'issuer'
          property :public_key, as: 'publicKey'
          property :serial_number, as: 'serialNumber'
          property :sig_alg_name, as: 'sigAlgName'
          property :subject, as: 'subject'
          collection :subject_alternative_names, as: 'subjectAlternativeNames'
          property :valid_from, :numeric_string => true, as: 'validFrom'
          property :version, as: 'version'
        end
      end
      
      class GoogleCloudApigeeV1Certificate
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          collection :cert_info, as: 'certInfo', class: Google::Apis::ApigeeV1::GoogleCloudApigeeV1CertInfo, decorator: Google::Apis::ApigeeV1::GoogleCloudApigeeV1CertInfo::Representation
      
        end
      end
      
      class GoogleCloudApigeeV1CommonNameConfig
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :match_wild_cards, as: 'matchWildCards'
          property :name, as: 'name'
        end
      end
      
      class GoogleCloudApigeeV1ConfigVersion
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :major_version, as: 'majorVersion'
          property :minor_version, as: 'minorVersion'
        end
      end
      
      class GoogleCloudApigeeV1Credential
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          collection :api_products, as: 'apiProducts', class: Google::Apis::ApigeeV1::GoogleCloudApigeeV1ApiProductRef, decorator: Google::Apis::ApigeeV1::GoogleCloudApigeeV1ApiProductRef::Representation
      
          collection :attributes, as: 'attributes', class: Google::Apis::ApigeeV1::GoogleCloudApigeeV1Attribute, decorator: Google::Apis::ApigeeV1::GoogleCloudApigeeV1Attribute::Representation
      
          property :consumer_key, as: 'consumerKey'
          property :consumer_secret, as: 'consumerSecret'
          property :expires_at, :numeric_string => true, as: 'expiresAt'
          property :issued_at, :numeric_string => true, as: 'issuedAt'
          collection :scopes, as: 'scopes'
          property :status, as: 'status'
        end
      end
      
      class GoogleCloudApigeeV1CustomReport
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :chart_type, as: 'chartType'
          collection :comments, as: 'comments'
          property :created_at, :numeric_string => true, as: 'createdAt'
          collection :dimensions, as: 'dimensions'
          property :display_name, as: 'displayName'
          property :environment, as: 'environment'
          property :filter, as: 'filter'
          property :from_time, as: 'fromTime'
          property :last_modified_at, :numeric_string => true, as: 'lastModifiedAt'
          property :last_viewed_at, :numeric_string => true, as: 'lastViewedAt'
          property :limit, as: 'limit'
          collection :metrics, as: 'metrics', class: Google::Apis::ApigeeV1::GoogleCloudApigeeV1CustomReportMetric, decorator: Google::Apis::ApigeeV1::GoogleCloudApigeeV1CustomReportMetric::Representation
      
          property :name, as: 'name'
          property :offset, as: 'offset'
          property :organization, as: 'organization'
          collection :properties, as: 'properties', class: Google::Apis::ApigeeV1::GoogleCloudApigeeV1ReportProperty, decorator: Google::Apis::ApigeeV1::GoogleCloudApigeeV1ReportProperty::Representation
      
          collection :sort_by_cols, as: 'sortByCols'
          property :sort_order, as: 'sortOrder'
          collection :tags, as: 'tags'
          property :time_unit, as: 'timeUnit'
          property :to_time, as: 'toTime'
          property :topk, as: 'topk'
        end
      end
      
      class GoogleCloudApigeeV1CustomReportMetric
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :function, as: 'function'
          property :name, as: 'name'
        end
      end
      
      class GoogleCloudApigeeV1DataCollector
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :created_at, :numeric_string => true, as: 'createdAt'
          property :description, as: 'description'
          property :last_modified_at, :numeric_string => true, as: 'lastModifiedAt'
          property :name, as: 'name'
          property :type, as: 'type'
        end
      end
      
      class GoogleCloudApigeeV1DataCollectorConfig
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :name, as: 'name'
          property :type, as: 'type'
        end
      end
      
      class GoogleCloudApigeeV1Datastore
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :create_time, :numeric_string => true, as: 'createTime'
          property :datastore_config, as: 'datastoreConfig', class: Google::Apis::ApigeeV1::GoogleCloudApigeeV1DatastoreConfig, decorator: Google::Apis::ApigeeV1::GoogleCloudApigeeV1DatastoreConfig::Representation
      
          property :display_name, as: 'displayName'
          property :last_update_time, :numeric_string => true, as: 'lastUpdateTime'
          property :org, as: 'org'
          property :self, as: 'self'
          property :target_type, as: 'targetType'
        end
      end
      
      class GoogleCloudApigeeV1DatastoreConfig
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :bucket_name, as: 'bucketName'
          property :dataset_name, as: 'datasetName'
          property :path, as: 'path'
          property :project_id, as: 'projectId'
          property :table_prefix, as: 'tablePrefix'
        end
      end
      
      class GoogleCloudApigeeV1DateRange
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :end, as: 'end'
          property :start, as: 'start'
        end
      end
      
      class GoogleCloudApigeeV1DebugMask
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          collection :fault_json_paths, as: 'faultJSONPaths'
          collection :fault_x_paths, as: 'faultXPaths'
          property :name, as: 'name'
          hash :namespaces, as: 'namespaces'
          collection :request_json_paths, as: 'requestJSONPaths'
          collection :request_x_paths, as: 'requestXPaths'
          collection :response_json_paths, as: 'responseJSONPaths'
          collection :response_x_paths, as: 'responseXPaths'
          collection :variables, as: 'variables'
        end
      end
      
      class GoogleCloudApigeeV1DebugSession
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :count, as: 'count'
          property :filter, as: 'filter'
          property :name, as: 'name'
          property :timeout, :numeric_string => true, as: 'timeout'
          property :tracesize, as: 'tracesize'
          property :validity, as: 'validity'
        end
      end
      
      class GoogleCloudApigeeV1DebugSessionTransaction
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :completed, as: 'completed'
          collection :point, as: 'point', class: Google::Apis::ApigeeV1::GoogleCloudApigeeV1Point, decorator: Google::Apis::ApigeeV1::GoogleCloudApigeeV1Point::Representation
      
        end
      end
      
      class GoogleCloudApigeeV1DeleteCustomReportResponse
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :message, as: 'message'
        end
      end
      
      class GoogleCloudApigeeV1Deployment
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :api_proxy, as: 'apiProxy'
          property :deploy_start_time, :numeric_string => true, as: 'deployStartTime'
          property :environment, as: 'environment'
          collection :errors, as: 'errors', class: Google::Apis::ApigeeV1::GoogleRpcStatus, decorator: Google::Apis::ApigeeV1::GoogleRpcStatus::Representation
      
          collection :instances, as: 'instances', class: Google::Apis::ApigeeV1::GoogleCloudApigeeV1InstanceDeploymentStatus, decorator: Google::Apis::ApigeeV1::GoogleCloudApigeeV1InstanceDeploymentStatus::Representation
      
          collection :pods, as: 'pods', class: Google::Apis::ApigeeV1::GoogleCloudApigeeV1PodStatus, decorator: Google::Apis::ApigeeV1::GoogleCloudApigeeV1PodStatus::Representation
      
          property :revision, as: 'revision'
          collection :route_conflicts, as: 'routeConflicts', class: Google::Apis::ApigeeV1::GoogleCloudApigeeV1DeploymentChangeReportRoutingConflict, decorator: Google::Apis::ApigeeV1::GoogleCloudApigeeV1DeploymentChangeReportRoutingConflict::Representation
      
          property :state, as: 'state'
        end
      end
      
      class GoogleCloudApigeeV1DeploymentChangeReport
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          collection :routing_changes, as: 'routingChanges', class: Google::Apis::ApigeeV1::GoogleCloudApigeeV1DeploymentChangeReportRoutingChange, decorator: Google::Apis::ApigeeV1::GoogleCloudApigeeV1DeploymentChangeReportRoutingChange::Representation
      
          collection :routing_conflicts, as: 'routingConflicts', class: Google::Apis::ApigeeV1::GoogleCloudApigeeV1DeploymentChangeReportRoutingConflict, decorator: Google::Apis::ApigeeV1::GoogleCloudApigeeV1DeploymentChangeReportRoutingConflict::Representation
      
          property :validation_errors, as: 'validationErrors', class: Google::Apis::ApigeeV1::GoogleRpcPreconditionFailure, decorator: Google::Apis::ApigeeV1::GoogleRpcPreconditionFailure::Representation
      
        end
      end
      
      class GoogleCloudApigeeV1DeploymentChangeReportRoutingChange
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :description, as: 'description'
          property :environment_group, as: 'environmentGroup'
          property :from_deployment, as: 'fromDeployment', class: Google::Apis::ApigeeV1::GoogleCloudApigeeV1DeploymentChangeReportRoutingDeployment, decorator: Google::Apis::ApigeeV1::GoogleCloudApigeeV1DeploymentChangeReportRoutingDeployment::Representation
      
          property :should_sequence_rollout, as: 'shouldSequenceRollout'
          property :to_deployment, as: 'toDeployment', class: Google::Apis::ApigeeV1::GoogleCloudApigeeV1DeploymentChangeReportRoutingDeployment, decorator: Google::Apis::ApigeeV1::GoogleCloudApigeeV1DeploymentChangeReportRoutingDeployment::Representation
      
        end
      end
      
      class GoogleCloudApigeeV1DeploymentChangeReportRoutingConflict
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :conflicting_deployment, as: 'conflictingDeployment', class: Google::Apis::ApigeeV1::GoogleCloudApigeeV1DeploymentChangeReportRoutingDeployment, decorator: Google::Apis::ApigeeV1::GoogleCloudApigeeV1DeploymentChangeReportRoutingDeployment::Representation
      
          property :description, as: 'description'
          property :environment_group, as: 'environmentGroup'
        end
      end
      
      class GoogleCloudApigeeV1DeploymentChangeReportRoutingDeployment
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :api_proxy, as: 'apiProxy'
          property :basepath, as: 'basepath'
          property :environment, as: 'environment'
          property :revision, as: 'revision'
        end
      end
      
      class GoogleCloudApigeeV1DeploymentConfig
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          hash :attributes, as: 'attributes'
          property :base_path, as: 'basePath'
          property :location, as: 'location'
          property :name, as: 'name'
          property :proxy_uid, as: 'proxyUid'
          property :uid, as: 'uid'
        end
      end
      
      class GoogleCloudApigeeV1Developer
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :access_type, as: 'accessType'
          property :app_family, as: 'appFamily'
          collection :apps, as: 'apps'
          collection :attributes, as: 'attributes', class: Google::Apis::ApigeeV1::GoogleCloudApigeeV1Attribute, decorator: Google::Apis::ApigeeV1::GoogleCloudApigeeV1Attribute::Representation
      
          collection :companies, as: 'companies'
          property :created_at, :numeric_string => true, as: 'createdAt'
          property :developer_id, as: 'developerId'
          property :email, as: 'email'
          property :first_name, as: 'firstName'
          property :last_modified_at, :numeric_string => true, as: 'lastModifiedAt'
          property :last_name, as: 'lastName'
          property :organization_name, as: 'organizationName'
          property :status, as: 'status'
          property :user_name, as: 'userName'
        end
      end
      
      class GoogleCloudApigeeV1DeveloperApp
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          collection :api_products, as: 'apiProducts'
          property :app_family, as: 'appFamily'
          property :app_id, as: 'appId'
          collection :attributes, as: 'attributes', class: Google::Apis::ApigeeV1::GoogleCloudApigeeV1Attribute, decorator: Google::Apis::ApigeeV1::GoogleCloudApigeeV1Attribute::Representation
      
          property :callback_url, as: 'callbackUrl'
          property :created_at, :numeric_string => true, as: 'createdAt'
          collection :credentials, as: 'credentials', class: Google::Apis::ApigeeV1::GoogleCloudApigeeV1Credential, decorator: Google::Apis::ApigeeV1::GoogleCloudApigeeV1Credential::Representation
      
          property :developer_id, as: 'developerId'
          property :key_expires_in, :numeric_string => true, as: 'keyExpiresIn'
          property :last_modified_at, :numeric_string => true, as: 'lastModifiedAt'
          property :name, as: 'name'
          collection :scopes, as: 'scopes'
          property :status, as: 'status'
        end
      end
      
      class GoogleCloudApigeeV1DeveloperAppKey
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          collection :api_products, as: 'apiProducts'
          collection :attributes, as: 'attributes', class: Google::Apis::ApigeeV1::GoogleCloudApigeeV1Attribute, decorator: Google::Apis::ApigeeV1::GoogleCloudApigeeV1Attribute::Representation
      
          property :consumer_key, as: 'consumerKey'
          property :consumer_secret, as: 'consumerSecret'
          property :expires_at, :numeric_string => true, as: 'expiresAt'
          property :issued_at, :numeric_string => true, as: 'issuedAt'
          collection :scopes, as: 'scopes'
          property :status, as: 'status'
        end
      end
      
      class GoogleCloudApigeeV1DimensionMetric
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          collection :metrics, as: 'metrics', class: Google::Apis::ApigeeV1::GoogleCloudApigeeV1Metric, decorator: Google::Apis::ApigeeV1::GoogleCloudApigeeV1Metric::Representation
      
          property :name, as: 'name'
        end
      end
      
      class GoogleCloudApigeeV1EntityMetadata
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :created_at, :numeric_string => true, as: 'createdAt'
          property :last_modified_at, :numeric_string => true, as: 'lastModifiedAt'
          property :sub_type, as: 'subType'
        end
      end
      
      class GoogleCloudApigeeV1Environment
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :created_at, :numeric_string => true, as: 'createdAt'
          property :description, as: 'description'
          property :display_name, as: 'displayName'
          property :last_modified_at, :numeric_string => true, as: 'lastModifiedAt'
          property :name, as: 'name'
          property :properties, as: 'properties', class: Google::Apis::ApigeeV1::GoogleCloudApigeeV1Properties, decorator: Google::Apis::ApigeeV1::GoogleCloudApigeeV1Properties::Representation
      
        end
      end
      
      class GoogleCloudApigeeV1EnvironmentConfig
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :create_time, as: 'createTime'
          collection :data_collectors, as: 'dataCollectors', class: Google::Apis::ApigeeV1::GoogleCloudApigeeV1DataCollectorConfig, decorator: Google::Apis::ApigeeV1::GoogleCloudApigeeV1DataCollectorConfig::Representation
      
          property :debug_mask, as: 'debugMask', class: Google::Apis::ApigeeV1::GoogleCloudApigeeV1DebugMask, decorator: Google::Apis::ApigeeV1::GoogleCloudApigeeV1DebugMask::Representation
      
          collection :deployments, as: 'deployments', class: Google::Apis::ApigeeV1::GoogleCloudApigeeV1DeploymentConfig, decorator: Google::Apis::ApigeeV1::GoogleCloudApigeeV1DeploymentConfig::Representation
      
          hash :feature_flags, as: 'featureFlags'
          collection :flowhooks, as: 'flowhooks', class: Google::Apis::ApigeeV1::GoogleCloudApigeeV1FlowHookConfig, decorator: Google::Apis::ApigeeV1::GoogleCloudApigeeV1FlowHookConfig::Representation
      
          collection :keystores, as: 'keystores', class: Google::Apis::ApigeeV1::GoogleCloudApigeeV1KeystoreConfig, decorator: Google::Apis::ApigeeV1::GoogleCloudApigeeV1KeystoreConfig::Representation
      
          property :name, as: 'name'
          property :provider, as: 'provider'
          property :pubsub_topic, as: 'pubsubTopic'
          collection :resource_references, as: 'resourceReferences', class: Google::Apis::ApigeeV1::GoogleCloudApigeeV1ReferenceConfig, decorator: Google::Apis::ApigeeV1::GoogleCloudApigeeV1ReferenceConfig::Representation
      
          collection :resources, as: 'resources', class: Google::Apis::ApigeeV1::GoogleCloudApigeeV1ResourceConfig, decorator: Google::Apis::ApigeeV1::GoogleCloudApigeeV1ResourceConfig::Representation
      
          property :revision_id, :numeric_string => true, as: 'revisionId'
          property :sequence_number, :numeric_string => true, as: 'sequenceNumber'
          collection :targets, as: 'targets', class: Google::Apis::ApigeeV1::GoogleCloudApigeeV1TargetServerConfig, decorator: Google::Apis::ApigeeV1::GoogleCloudApigeeV1TargetServerConfig::Representation
      
          property :trace_config, as: 'traceConfig', class: Google::Apis::ApigeeV1::GoogleCloudApigeeV1RuntimeTraceConfig, decorator: Google::Apis::ApigeeV1::GoogleCloudApigeeV1RuntimeTraceConfig::Representation
      
          property :uid, as: 'uid'
        end
      end
      
      class GoogleCloudApigeeV1EnvironmentGroup
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :created_at, :numeric_string => true, as: 'createdAt'
          collection :hostnames, as: 'hostnames'
          property :last_modified_at, :numeric_string => true, as: 'lastModifiedAt'
          property :name, as: 'name'
        end
      end
      
      class GoogleCloudApigeeV1EnvironmentGroupAttachment
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :created_at, :numeric_string => true, as: 'createdAt'
          property :environment, as: 'environment'
          property :name, as: 'name'
        end
      end
      
      class GoogleCloudApigeeV1EnvironmentGroupConfig
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          collection :hostnames, as: 'hostnames'
          property :name, as: 'name'
          property :revision_id, :numeric_string => true, as: 'revisionId'
          collection :routing_rules, as: 'routingRules', class: Google::Apis::ApigeeV1::GoogleCloudApigeeV1RoutingRule, decorator: Google::Apis::ApigeeV1::GoogleCloudApigeeV1RoutingRule::Representation
      
          property :uid, as: 'uid'
        end
      end
      
      class GoogleCloudApigeeV1Export
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :created, as: 'created'
          property :datastore_name, as: 'datastoreName'
          property :description, as: 'description'
          property :error, as: 'error'
          property :execution_time, as: 'executionTime'
          property :name, as: 'name'
          property :self, as: 'self'
          property :state, as: 'state'
          property :updated, as: 'updated'
        end
      end
      
      class GoogleCloudApigeeV1ExportRequest
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :csv_delimiter, as: 'csvDelimiter'
          property :datastore_name, as: 'datastoreName'
          property :date_range, as: 'dateRange', class: Google::Apis::ApigeeV1::GoogleCloudApigeeV1DateRange, decorator: Google::Apis::ApigeeV1::GoogleCloudApigeeV1DateRange::Representation
      
          property :description, as: 'description'
          property :name, as: 'name'
          property :output_format, as: 'outputFormat'
        end
      end
      
      class GoogleCloudApigeeV1FlowHook
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :continue_on_error, as: 'continueOnError'
          property :description, as: 'description'
          property :flow_hook_point, as: 'flowHookPoint'
          property :shared_flow, as: 'sharedFlow'
        end
      end
      
      class GoogleCloudApigeeV1FlowHookConfig
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :continue_on_error, as: 'continueOnError'
          property :name, as: 'name'
          property :shared_flow_name, as: 'sharedFlowName'
        end
      end
      
      class GoogleCloudApigeeV1GetSyncAuthorizationRequest
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
        end
      end
      
      class GoogleCloudApigeeV1IngressConfig
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          collection :environment_groups, as: 'environmentGroups', class: Google::Apis::ApigeeV1::GoogleCloudApigeeV1EnvironmentGroupConfig, decorator: Google::Apis::ApigeeV1::GoogleCloudApigeeV1EnvironmentGroupConfig::Representation
      
          property :name, as: 'name'
          property :revision_create_time, as: 'revisionCreateTime'
          property :revision_id, :numeric_string => true, as: 'revisionId'
          property :uid, as: 'uid'
        end
      end
      
      class GoogleCloudApigeeV1Instance
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :created_at, :numeric_string => true, as: 'createdAt'
          property :description, as: 'description'
          property :disk_encryption_key_name, as: 'diskEncryptionKeyName'
          property :display_name, as: 'displayName'
          property :host, as: 'host'
          property :last_modified_at, :numeric_string => true, as: 'lastModifiedAt'
          property :location, as: 'location'
          property :name, as: 'name'
          property :port, as: 'port'
          property :state, as: 'state'
        end
      end
      
      class GoogleCloudApigeeV1InstanceAttachment
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :created_at, :numeric_string => true, as: 'createdAt'
          property :environment, as: 'environment'
          property :name, as: 'name'
        end
      end
      
      class GoogleCloudApigeeV1InstanceDeploymentStatus
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          collection :deployed_revisions, as: 'deployedRevisions', class: Google::Apis::ApigeeV1::GoogleCloudApigeeV1InstanceDeploymentStatusDeployedRevision, decorator: Google::Apis::ApigeeV1::GoogleCloudApigeeV1InstanceDeploymentStatusDeployedRevision::Representation
      
          collection :deployed_routes, as: 'deployedRoutes', class: Google::Apis::ApigeeV1::GoogleCloudApigeeV1InstanceDeploymentStatusDeployedRoute, decorator: Google::Apis::ApigeeV1::GoogleCloudApigeeV1InstanceDeploymentStatusDeployedRoute::Representation
      
          property :instance, as: 'instance'
        end
      end
      
      class GoogleCloudApigeeV1InstanceDeploymentStatusDeployedRevision
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :percentage, as: 'percentage'
          property :revision, as: 'revision'
        end
      end
      
      class GoogleCloudApigeeV1InstanceDeploymentStatusDeployedRoute
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :basepath, as: 'basepath'
          property :envgroup, as: 'envgroup'
          property :environment, as: 'environment'
          property :percentage, as: 'percentage'
        end
      end
      
      class GoogleCloudApigeeV1KeyAliasReference
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :alias_id, as: 'aliasId'
          property :reference, as: 'reference'
        end
      end
      
      class GoogleCloudApigeeV1KeyValueMap
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :encrypted, as: 'encrypted'
          property :name, as: 'name'
        end
      end
      
      class GoogleCloudApigeeV1Keystore
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          collection :aliases, as: 'aliases'
          property :name, as: 'name'
        end
      end
      
      class GoogleCloudApigeeV1KeystoreConfig
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          collection :aliases, as: 'aliases', class: Google::Apis::ApigeeV1::GoogleCloudApigeeV1AliasRevisionConfig, decorator: Google::Apis::ApigeeV1::GoogleCloudApigeeV1AliasRevisionConfig::Representation
      
          property :name, as: 'name'
        end
      end
      
      class GoogleCloudApigeeV1ListApiCategoriesResponse
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          collection :data, as: 'data', class: Google::Apis::ApigeeV1::GoogleCloudApigeeV1ApiCategoryData, decorator: Google::Apis::ApigeeV1::GoogleCloudApigeeV1ApiCategoryData::Representation
      
          property :error_code, as: 'errorCode'
          property :message, as: 'message'
          property :request_id, as: 'requestId'
          property :status, as: 'status'
        end
      end
      
      class GoogleCloudApigeeV1ListApiProductsResponse
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          collection :api_product, as: 'apiProduct', class: Google::Apis::ApigeeV1::GoogleCloudApigeeV1ApiProduct, decorator: Google::Apis::ApigeeV1::GoogleCloudApigeeV1ApiProduct::Representation
      
        end
      end
      
      class GoogleCloudApigeeV1ListApiProxiesResponse
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          collection :proxies, as: 'proxies', class: Google::Apis::ApigeeV1::GoogleCloudApigeeV1ApiProxy, decorator: Google::Apis::ApigeeV1::GoogleCloudApigeeV1ApiProxy::Representation
      
        end
      end
      
      class GoogleCloudApigeeV1ListAppsResponse
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          collection :app, as: 'app', class: Google::Apis::ApigeeV1::GoogleCloudApigeeV1App, decorator: Google::Apis::ApigeeV1::GoogleCloudApigeeV1App::Representation
      
        end
      end
      
      class GoogleCloudApigeeV1ListAsyncQueriesResponse
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          collection :queries, as: 'queries', class: Google::Apis::ApigeeV1::GoogleCloudApigeeV1AsyncQuery, decorator: Google::Apis::ApigeeV1::GoogleCloudApigeeV1AsyncQuery::Representation
      
        end
      end
      
      class GoogleCloudApigeeV1ListCustomReportsResponse
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          collection :qualifier, as: 'qualifier', class: Google::Apis::ApigeeV1::GoogleCloudApigeeV1CustomReport, decorator: Google::Apis::ApigeeV1::GoogleCloudApigeeV1CustomReport::Representation
      
        end
      end
      
      class GoogleCloudApigeeV1ListDataCollectorsResponse
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          collection :data_collectors, as: 'dataCollectors', class: Google::Apis::ApigeeV1::GoogleCloudApigeeV1DataCollector, decorator: Google::Apis::ApigeeV1::GoogleCloudApigeeV1DataCollector::Representation
      
          property :next_page_token, as: 'nextPageToken'
        end
      end
      
      class GoogleCloudApigeeV1ListDatastoresResponse
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          collection :datastores, as: 'datastores', class: Google::Apis::ApigeeV1::GoogleCloudApigeeV1Datastore, decorator: Google::Apis::ApigeeV1::GoogleCloudApigeeV1Datastore::Representation
      
        end
      end
      
      class GoogleCloudApigeeV1ListDebugSessionsResponse
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :next_page_token, as: 'nextPageToken'
          collection :sessions, as: 'sessions', class: Google::Apis::ApigeeV1::GoogleCloudApigeeV1Session, decorator: Google::Apis::ApigeeV1::GoogleCloudApigeeV1Session::Representation
      
        end
      end
      
      class GoogleCloudApigeeV1ListDeploymentsResponse
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          collection :deployments, as: 'deployments', class: Google::Apis::ApigeeV1::GoogleCloudApigeeV1Deployment, decorator: Google::Apis::ApigeeV1::GoogleCloudApigeeV1Deployment::Representation
      
        end
      end
      
      class GoogleCloudApigeeV1ListDeveloperAppsResponse
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          collection :app, as: 'app', class: Google::Apis::ApigeeV1::GoogleCloudApigeeV1DeveloperApp, decorator: Google::Apis::ApigeeV1::GoogleCloudApigeeV1DeveloperApp::Representation
      
        end
      end
      
      class GoogleCloudApigeeV1ListEnvironmentGroupAttachmentsResponse
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          collection :environment_group_attachments, as: 'environmentGroupAttachments', class: Google::Apis::ApigeeV1::GoogleCloudApigeeV1EnvironmentGroupAttachment, decorator: Google::Apis::ApigeeV1::GoogleCloudApigeeV1EnvironmentGroupAttachment::Representation
      
          property :next_page_token, as: 'nextPageToken'
        end
      end
      
      class GoogleCloudApigeeV1ListEnvironmentGroupsResponse
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          collection :environment_groups, as: 'environmentGroups', class: Google::Apis::ApigeeV1::GoogleCloudApigeeV1EnvironmentGroup, decorator: Google::Apis::ApigeeV1::GoogleCloudApigeeV1EnvironmentGroup::Representation
      
          property :next_page_token, as: 'nextPageToken'
        end
      end
      
      class GoogleCloudApigeeV1ListEnvironmentResourcesResponse
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          collection :resource_file, as: 'resourceFile', class: Google::Apis::ApigeeV1::GoogleCloudApigeeV1ResourceFile, decorator: Google::Apis::ApigeeV1::GoogleCloudApigeeV1ResourceFile::Representation
      
        end
      end
      
      class GoogleCloudApigeeV1ListExportsResponse
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          collection :exports, as: 'exports', class: Google::Apis::ApigeeV1::GoogleCloudApigeeV1Export, decorator: Google::Apis::ApigeeV1::GoogleCloudApigeeV1Export::Representation
      
        end
      end
      
      class GoogleCloudApigeeV1ListHybridIssuersResponse
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          collection :issuers, as: 'issuers', class: Google::Apis::ApigeeV1::GoogleCloudApigeeV1ServiceIssuersMapping, decorator: Google::Apis::ApigeeV1::GoogleCloudApigeeV1ServiceIssuersMapping::Representation
      
        end
      end
      
      class GoogleCloudApigeeV1ListInstanceAttachmentsResponse
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          collection :attachments, as: 'attachments', class: Google::Apis::ApigeeV1::GoogleCloudApigeeV1InstanceAttachment, decorator: Google::Apis::ApigeeV1::GoogleCloudApigeeV1InstanceAttachment::Representation
      
          property :next_page_token, as: 'nextPageToken'
        end
      end
      
      class GoogleCloudApigeeV1ListInstancesResponse
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          collection :instances, as: 'instances', class: Google::Apis::ApigeeV1::GoogleCloudApigeeV1Instance, decorator: Google::Apis::ApigeeV1::GoogleCloudApigeeV1Instance::Representation
      
          property :next_page_token, as: 'nextPageToken'
        end
      end
      
      class GoogleCloudApigeeV1ListNatAddressesResponse
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          collection :nat_addresses, as: 'natAddresses', class: Google::Apis::ApigeeV1::GoogleCloudApigeeV1NatAddress, decorator: Google::Apis::ApigeeV1::GoogleCloudApigeeV1NatAddress::Representation
      
          property :next_page_token, as: 'nextPageToken'
        end
      end
      
      class GoogleCloudApigeeV1ListOfDevelopersResponse
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          collection :developer, as: 'developer', class: Google::Apis::ApigeeV1::GoogleCloudApigeeV1Developer, decorator: Google::Apis::ApigeeV1::GoogleCloudApigeeV1Developer::Representation
      
        end
      end
      
      class GoogleCloudApigeeV1ListOrganizationsResponse
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          collection :organizations, as: 'organizations', class: Google::Apis::ApigeeV1::GoogleCloudApigeeV1OrganizationProjectMapping, decorator: Google::Apis::ApigeeV1::GoogleCloudApigeeV1OrganizationProjectMapping::Representation
      
        end
      end
      
      class GoogleCloudApigeeV1ListSharedFlowsResponse
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          collection :shared_flows, as: 'sharedFlows', class: Google::Apis::ApigeeV1::GoogleCloudApigeeV1SharedFlow, decorator: Google::Apis::ApigeeV1::GoogleCloudApigeeV1SharedFlow::Representation
      
        end
      end
      
      class GoogleCloudApigeeV1Metadata
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          collection :errors, as: 'errors'
          collection :notices, as: 'notices'
        end
      end
      
      class GoogleCloudApigeeV1Metric
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :name, as: 'name'
          collection :values, as: 'values'
        end
      end
      
      class GoogleCloudApigeeV1NatAddress
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :ip_address, as: 'ipAddress'
          property :name, as: 'name'
          property :state, as: 'state'
        end
      end
      
      class GoogleCloudApigeeV1Operation
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          collection :methods_prop, as: 'methods'
          property :resource, as: 'resource'
        end
      end
      
      class GoogleCloudApigeeV1OperationConfig
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :api_source, as: 'apiSource'
          collection :attributes, as: 'attributes', class: Google::Apis::ApigeeV1::GoogleCloudApigeeV1Attribute, decorator: Google::Apis::ApigeeV1::GoogleCloudApigeeV1Attribute::Representation
      
          collection :operations, as: 'operations', class: Google::Apis::ApigeeV1::GoogleCloudApigeeV1Operation, decorator: Google::Apis::ApigeeV1::GoogleCloudApigeeV1Operation::Representation
      
          property :quota, as: 'quota', class: Google::Apis::ApigeeV1::GoogleCloudApigeeV1Quota, decorator: Google::Apis::ApigeeV1::GoogleCloudApigeeV1Quota::Representation
      
        end
      end
      
      class GoogleCloudApigeeV1OperationGroup
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :operation_config_type, as: 'operationConfigType'
          collection :operation_configs, as: 'operationConfigs', class: Google::Apis::ApigeeV1::GoogleCloudApigeeV1OperationConfig, decorator: Google::Apis::ApigeeV1::GoogleCloudApigeeV1OperationConfig::Representation
      
        end
      end
      
      class GoogleCloudApigeeV1OperationMetadata
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :operation_type, as: 'operationType'
          property :state, as: 'state'
          property :target_resource_name, as: 'targetResourceName'
        end
      end
      
      class GoogleCloudApigeeV1OptimizedStats
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :response, as: 'Response', class: Google::Apis::ApigeeV1::GoogleCloudApigeeV1OptimizedStatsResponse, decorator: Google::Apis::ApigeeV1::GoogleCloudApigeeV1OptimizedStatsResponse::Representation
      
        end
      end
      
      class GoogleCloudApigeeV1OptimizedStatsNode
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          collection :data, as: 'data'
        end
      end
      
      class GoogleCloudApigeeV1OptimizedStatsResponse
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          collection :time_unit, as: 'TimeUnit'
          property :meta_data, as: 'metaData', class: Google::Apis::ApigeeV1::GoogleCloudApigeeV1Metadata, decorator: Google::Apis::ApigeeV1::GoogleCloudApigeeV1Metadata::Representation
      
          property :result_truncated, as: 'resultTruncated'
          property :stats, as: 'stats', class: Google::Apis::ApigeeV1::GoogleCloudApigeeV1OptimizedStatsNode, decorator: Google::Apis::ApigeeV1::GoogleCloudApigeeV1OptimizedStatsNode::Representation
      
        end
      end
      
      class GoogleCloudApigeeV1Organization
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :analytics_region, as: 'analyticsRegion'
          collection :attributes, as: 'attributes'
          property :authorized_network, as: 'authorizedNetwork'
          property :ca_certificate, :base64 => true, as: 'caCertificate'
          property :created_at, :numeric_string => true, as: 'createdAt'
          property :customer_name, as: 'customerName'
          property :description, as: 'description'
          property :display_name, as: 'displayName'
          collection :environments, as: 'environments'
          property :last_modified_at, :numeric_string => true, as: 'lastModifiedAt'
          property :name, as: 'name'
          property :project_id, as: 'projectId'
          property :properties, as: 'properties', class: Google::Apis::ApigeeV1::GoogleCloudApigeeV1Properties, decorator: Google::Apis::ApigeeV1::GoogleCloudApigeeV1Properties::Representation
      
          property :runtime_database_encryption_key_name, as: 'runtimeDatabaseEncryptionKeyName'
          property :runtime_type, as: 'runtimeType'
          property :subscription_type, as: 'subscriptionType'
          property :type, as: 'type'
        end
      end
      
      class GoogleCloudApigeeV1OrganizationProjectMapping
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :organization, as: 'organization'
          collection :project_ids, as: 'projectIds'
        end
      end
      
      class GoogleCloudApigeeV1PodStatus
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :app_version, as: 'appVersion'
          property :deployment_status, as: 'deploymentStatus'
          property :deployment_status_time, :numeric_string => true, as: 'deploymentStatusTime'
          property :deployment_time, :numeric_string => true, as: 'deploymentTime'
          property :pod_name, as: 'podName'
          property :pod_status, as: 'podStatus'
          property :pod_status_time, :numeric_string => true, as: 'podStatusTime'
          property :status_code, as: 'statusCode'
          property :status_code_details, as: 'statusCodeDetails'
        end
      end
      
      class GoogleCloudApigeeV1Point
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :id, as: 'id'
          collection :results, as: 'results', class: Google::Apis::ApigeeV1::GoogleCloudApigeeV1Result, decorator: Google::Apis::ApigeeV1::GoogleCloudApigeeV1Result::Representation
      
        end
      end
      
      class GoogleCloudApigeeV1Properties
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          collection :property, as: 'property', class: Google::Apis::ApigeeV1::GoogleCloudApigeeV1Property, decorator: Google::Apis::ApigeeV1::GoogleCloudApigeeV1Property::Representation
      
        end
      end
      
      class GoogleCloudApigeeV1Property
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :name, as: 'name'
          property :value, as: 'value'
        end
      end
      
      class GoogleCloudApigeeV1ProvisionOrganizationRequest
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :analytics_region, as: 'analyticsRegion'
          property :authorized_network, as: 'authorizedNetwork'
          property :runtime_location, as: 'runtimeLocation'
        end
      end
      
      class GoogleCloudApigeeV1Query
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :csv_delimiter, as: 'csvDelimiter'
          collection :dimensions, as: 'dimensions'
          property :envgroup_hostname, as: 'envgroupHostname'
          property :filter, as: 'filter'
          property :group_by_time_unit, as: 'groupByTimeUnit'
          property :limit, as: 'limit'
          collection :metrics, as: 'metrics', class: Google::Apis::ApigeeV1::GoogleCloudApigeeV1QueryMetric, decorator: Google::Apis::ApigeeV1::GoogleCloudApigeeV1QueryMetric::Representation
      
          property :name, as: 'name'
          property :output_format, as: 'outputFormat'
          property :report_definition_id, as: 'reportDefinitionId'
          property :time_range, as: 'timeRange'
        end
      end
      
      class GoogleCloudApigeeV1QueryMetadata
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          collection :dimensions, as: 'dimensions'
          property :end_timestamp, as: 'endTimestamp'
          collection :metrics, as: 'metrics'
          property :output_format, as: 'outputFormat'
          property :start_timestamp, as: 'startTimestamp'
          property :time_unit, as: 'timeUnit'
        end
      end
      
      class GoogleCloudApigeeV1QueryMetric
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :alias, as: 'alias'
          property :function, as: 'function'
          property :name, as: 'name'
          property :operator, as: 'operator'
          property :value, as: 'value'
        end
      end
      
      class GoogleCloudApigeeV1Quota
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :interval, as: 'interval'
          property :limit, as: 'limit'
          property :time_unit, as: 'timeUnit'
        end
      end
      
      class GoogleCloudApigeeV1Reference
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :description, as: 'description'
          property :name, as: 'name'
          property :refers, as: 'refers'
          property :resource_type, as: 'resourceType'
        end
      end
      
      class GoogleCloudApigeeV1ReferenceConfig
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :name, as: 'name'
          property :resource_name, as: 'resourceName'
        end
      end
      
      class GoogleCloudApigeeV1ReportInstanceStatusRequest
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :instance_uid, as: 'instanceUid'
          property :report_time, as: 'reportTime'
          collection :resources, as: 'resources', class: Google::Apis::ApigeeV1::GoogleCloudApigeeV1ResourceStatus, decorator: Google::Apis::ApigeeV1::GoogleCloudApigeeV1ResourceStatus::Representation
      
        end
      end
      
      class GoogleCloudApigeeV1ReportInstanceStatusResponse
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
        end
      end
      
      class GoogleCloudApigeeV1ReportProperty
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :property, as: 'property'
          collection :value, as: 'value', class: Google::Apis::ApigeeV1::GoogleCloudApigeeV1Attribute, decorator: Google::Apis::ApigeeV1::GoogleCloudApigeeV1Attribute::Representation
      
        end
      end
      
      class GoogleCloudApigeeV1ResourceConfig
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :location, as: 'location'
          property :name, as: 'name'
        end
      end
      
      class GoogleCloudApigeeV1ResourceFile
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :name, as: 'name'
          property :type, as: 'type'
        end
      end
      
      class GoogleCloudApigeeV1ResourceFiles
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          collection :resource_file, as: 'resourceFile', class: Google::Apis::ApigeeV1::GoogleCloudApigeeV1ResourceFile, decorator: Google::Apis::ApigeeV1::GoogleCloudApigeeV1ResourceFile::Representation
      
        end
      end
      
      class GoogleCloudApigeeV1ResourceStatus
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :resource, as: 'resource'
          collection :revisions, as: 'revisions', class: Google::Apis::ApigeeV1::GoogleCloudApigeeV1RevisionStatus, decorator: Google::Apis::ApigeeV1::GoogleCloudApigeeV1RevisionStatus::Representation
      
          property :total_replicas, as: 'totalReplicas'
          property :uid, as: 'uid'
        end
      end
      
      class GoogleCloudApigeeV1Result
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :action_result, as: 'ActionResult'
          collection :access_list, as: 'accessList', class: Google::Apis::ApigeeV1::GoogleCloudApigeeV1Access, decorator: Google::Apis::ApigeeV1::GoogleCloudApigeeV1Access::Representation
      
          property :content, as: 'content'
          collection :headers, as: 'headers', class: Google::Apis::ApigeeV1::GoogleCloudApigeeV1Property, decorator: Google::Apis::ApigeeV1::GoogleCloudApigeeV1Property::Representation
      
          property :properties, as: 'properties', class: Google::Apis::ApigeeV1::GoogleCloudApigeeV1Properties, decorator: Google::Apis::ApigeeV1::GoogleCloudApigeeV1Properties::Representation
      
          property :reason_phrase, as: 'reasonPhrase'
          property :status_code, as: 'statusCode'
          property :timestamp, as: 'timestamp'
          property :u_ri, as: 'uRI'
          property :verb, as: 'verb'
        end
      end
      
      class GoogleCloudApigeeV1RevisionStatus
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          collection :errors, as: 'errors', class: Google::Apis::ApigeeV1::GoogleCloudApigeeV1UpdateError, decorator: Google::Apis::ApigeeV1::GoogleCloudApigeeV1UpdateError::Representation
      
          property :json_spec, as: 'jsonSpec'
          property :replicas, as: 'replicas'
          property :revision_id, as: 'revisionId'
        end
      end
      
      class GoogleCloudApigeeV1RoutingRule
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :basepath, as: 'basepath'
          property :env_group_revision, :numeric_string => true, as: 'envGroupRevision'
          property :environment, as: 'environment'
          property :receiver, as: 'receiver'
          property :update_time, as: 'updateTime'
        end
      end
      
      class GoogleCloudApigeeV1RuntimeTraceConfig
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :endpoint, as: 'endpoint'
          property :exporter, as: 'exporter'
          property :name, as: 'name'
          collection :overrides, as: 'overrides', class: Google::Apis::ApigeeV1::GoogleCloudApigeeV1RuntimeTraceConfigOverride, decorator: Google::Apis::ApigeeV1::GoogleCloudApigeeV1RuntimeTraceConfigOverride::Representation
      
          property :revision_create_time, as: 'revisionCreateTime'
          property :revision_id, as: 'revisionId'
          property :sampling_config, as: 'samplingConfig', class: Google::Apis::ApigeeV1::GoogleCloudApigeeV1RuntimeTraceSamplingConfig, decorator: Google::Apis::ApigeeV1::GoogleCloudApigeeV1RuntimeTraceSamplingConfig::Representation
      
        end
      end
      
      class GoogleCloudApigeeV1RuntimeTraceConfigOverride
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :api_proxy, as: 'apiProxy'
          property :name, as: 'name'
          property :revision_create_time, as: 'revisionCreateTime'
          property :revision_id, as: 'revisionId'
          property :sampling_config, as: 'samplingConfig', class: Google::Apis::ApigeeV1::GoogleCloudApigeeV1RuntimeTraceSamplingConfig, decorator: Google::Apis::ApigeeV1::GoogleCloudApigeeV1RuntimeTraceSamplingConfig::Representation
      
          property :uid, as: 'uid'
        end
      end
      
      class GoogleCloudApigeeV1RuntimeTraceSamplingConfig
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :sampler, as: 'sampler'
          property :sampling_rate, as: 'samplingRate'
        end
      end
      
      class GoogleCloudApigeeV1Schema
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          collection :dimensions, as: 'dimensions', class: Google::Apis::ApigeeV1::GoogleCloudApigeeV1SchemaSchemaElement, decorator: Google::Apis::ApigeeV1::GoogleCloudApigeeV1SchemaSchemaElement::Representation
      
          collection :meta, as: 'meta'
          collection :metrics, as: 'metrics', class: Google::Apis::ApigeeV1::GoogleCloudApigeeV1SchemaSchemaElement, decorator: Google::Apis::ApigeeV1::GoogleCloudApigeeV1SchemaSchemaElement::Representation
      
        end
      end
      
      class GoogleCloudApigeeV1SchemaSchemaElement
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :name, as: 'name'
          property :properties, as: 'properties', class: Google::Apis::ApigeeV1::GoogleCloudApigeeV1SchemaSchemaProperty, decorator: Google::Apis::ApigeeV1::GoogleCloudApigeeV1SchemaSchemaProperty::Representation
      
        end
      end
      
      class GoogleCloudApigeeV1SchemaSchemaProperty
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :create_time, as: 'createTime'
          property :custom, as: 'custom'
          property :type, as: 'type'
        end
      end
      
      class GoogleCloudApigeeV1ServiceIssuersMapping
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          collection :email_ids, as: 'emailIds'
          property :service, as: 'service'
        end
      end
      
      class GoogleCloudApigeeV1Session
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :id, as: 'id'
          property :timestamp_ms, :numeric_string => true, as: 'timestampMs'
        end
      end
      
      class GoogleCloudApigeeV1SharedFlow
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :latest_revision_id, as: 'latestRevisionId'
          property :meta_data, as: 'metaData', class: Google::Apis::ApigeeV1::GoogleCloudApigeeV1EntityMetadata, decorator: Google::Apis::ApigeeV1::GoogleCloudApigeeV1EntityMetadata::Representation
      
          property :name, as: 'name'
          collection :revision, as: 'revision'
        end
      end
      
      class GoogleCloudApigeeV1SharedFlowRevision
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :configuration_version, as: 'configurationVersion', class: Google::Apis::ApigeeV1::GoogleCloudApigeeV1ConfigVersion, decorator: Google::Apis::ApigeeV1::GoogleCloudApigeeV1ConfigVersion::Representation
      
          property :context_info, as: 'contextInfo'
          property :created_at, :numeric_string => true, as: 'createdAt'
          property :description, as: 'description'
          property :display_name, as: 'displayName'
          hash :entity_meta_data_as_properties, as: 'entityMetaDataAsProperties'
          property :last_modified_at, :numeric_string => true, as: 'lastModifiedAt'
          property :name, as: 'name'
          collection :policies, as: 'policies'
          property :resource_files, as: 'resourceFiles', class: Google::Apis::ApigeeV1::GoogleCloudApigeeV1ResourceFiles, decorator: Google::Apis::ApigeeV1::GoogleCloudApigeeV1ResourceFiles::Representation
      
          collection :resources, as: 'resources'
          property :revision, as: 'revision'
          collection :shared_flows, as: 'sharedFlows'
          property :type, as: 'type'
        end
      end
      
      class GoogleCloudApigeeV1Stats
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          collection :environments, as: 'environments', class: Google::Apis::ApigeeV1::GoogleCloudApigeeV1StatsEnvironmentStats, decorator: Google::Apis::ApigeeV1::GoogleCloudApigeeV1StatsEnvironmentStats::Representation
      
          collection :hosts, as: 'hosts', class: Google::Apis::ApigeeV1::GoogleCloudApigeeV1StatsHostStats, decorator: Google::Apis::ApigeeV1::GoogleCloudApigeeV1StatsHostStats::Representation
      
          property :meta_data, as: 'metaData', class: Google::Apis::ApigeeV1::GoogleCloudApigeeV1Metadata, decorator: Google::Apis::ApigeeV1::GoogleCloudApigeeV1Metadata::Representation
      
        end
      end
      
      class GoogleCloudApigeeV1StatsEnvironmentStats
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          collection :dimensions, as: 'dimensions', class: Google::Apis::ApigeeV1::GoogleCloudApigeeV1DimensionMetric, decorator: Google::Apis::ApigeeV1::GoogleCloudApigeeV1DimensionMetric::Representation
      
          collection :metrics, as: 'metrics', class: Google::Apis::ApigeeV1::GoogleCloudApigeeV1Metric, decorator: Google::Apis::ApigeeV1::GoogleCloudApigeeV1Metric::Representation
      
          property :name, as: 'name'
        end
      end
      
      class GoogleCloudApigeeV1StatsHostStats
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          collection :dimensions, as: 'dimensions', class: Google::Apis::ApigeeV1::GoogleCloudApigeeV1DimensionMetric, decorator: Google::Apis::ApigeeV1::GoogleCloudApigeeV1DimensionMetric::Representation
      
          collection :metrics, as: 'metrics', class: Google::Apis::ApigeeV1::GoogleCloudApigeeV1Metric, decorator: Google::Apis::ApigeeV1::GoogleCloudApigeeV1Metric::Representation
      
          property :name, as: 'name'
        end
      end
      
      class GoogleCloudApigeeV1Subscription
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :name, as: 'name'
        end
      end
      
      class GoogleCloudApigeeV1SyncAuthorization
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :etag, :base64 => true, as: 'etag'
          collection :identities, as: 'identities'
        end
      end
      
      class GoogleCloudApigeeV1TargetServer
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :description, as: 'description'
          property :host, as: 'host'
          property :is_enabled, as: 'isEnabled'
          property :name, as: 'name'
          property :port, as: 'port'
          property :s_sl_info, as: 'sSLInfo', class: Google::Apis::ApigeeV1::GoogleCloudApigeeV1TlsInfo, decorator: Google::Apis::ApigeeV1::GoogleCloudApigeeV1TlsInfo::Representation
      
        end
      end
      
      class GoogleCloudApigeeV1TargetServerConfig
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :host, as: 'host'
          property :name, as: 'name'
          property :port, as: 'port'
          property :tls_info, as: 'tlsInfo', class: Google::Apis::ApigeeV1::GoogleCloudApigeeV1TlsInfoConfig, decorator: Google::Apis::ApigeeV1::GoogleCloudApigeeV1TlsInfoConfig::Representation
      
        end
      end
      
      class GoogleCloudApigeeV1TestDatastoreResponse
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :error, as: 'error'
          property :state, as: 'state'
        end
      end
      
      class GoogleCloudApigeeV1TlsInfo
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          collection :ciphers, as: 'ciphers'
          property :client_auth_enabled, as: 'clientAuthEnabled'
          property :common_name, as: 'commonName', class: Google::Apis::ApigeeV1::GoogleCloudApigeeV1TlsInfoCommonName, decorator: Google::Apis::ApigeeV1::GoogleCloudApigeeV1TlsInfoCommonName::Representation
      
          property :enabled, as: 'enabled'
          property :ignore_validation_errors, as: 'ignoreValidationErrors'
          property :key_alias, as: 'keyAlias'
          property :key_store, as: 'keyStore'
          collection :protocols, as: 'protocols'
          property :trust_store, as: 'trustStore'
        end
      end
      
      class GoogleCloudApigeeV1TlsInfoCommonName
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :value, as: 'value'
          property :wildcard_match, as: 'wildcardMatch'
        end
      end
      
      class GoogleCloudApigeeV1TlsInfoConfig
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          collection :ciphers, as: 'ciphers'
          property :client_auth_enabled, as: 'clientAuthEnabled'
          property :common_name, as: 'commonName', class: Google::Apis::ApigeeV1::GoogleCloudApigeeV1CommonNameConfig, decorator: Google::Apis::ApigeeV1::GoogleCloudApigeeV1CommonNameConfig::Representation
      
          property :enabled, as: 'enabled'
          property :ignore_validation_errors, as: 'ignoreValidationErrors'
          property :key_alias, as: 'keyAlias'
          property :key_alias_reference, as: 'keyAliasReference', class: Google::Apis::ApigeeV1::GoogleCloudApigeeV1KeyAliasReference, decorator: Google::Apis::ApigeeV1::GoogleCloudApigeeV1KeyAliasReference::Representation
      
          collection :protocols, as: 'protocols'
          property :trust_store, as: 'trustStore'
        end
      end
      
      class GoogleCloudApigeeV1UpdateError
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :code, as: 'code'
          property :message, as: 'message'
          property :resource, as: 'resource'
          property :type, as: 'type'
        end
      end
      
      class GoogleIamV1AuditConfig
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          collection :audit_log_configs, as: 'auditLogConfigs', class: Google::Apis::ApigeeV1::GoogleIamV1AuditLogConfig, decorator: Google::Apis::ApigeeV1::GoogleIamV1AuditLogConfig::Representation
      
          property :service, as: 'service'
        end
      end
      
      class GoogleIamV1AuditLogConfig
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          collection :exempted_members, as: 'exemptedMembers'
          property :log_type, as: 'logType'
        end
      end
      
      class GoogleIamV1Binding
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :condition, as: 'condition', class: Google::Apis::ApigeeV1::GoogleTypeExpr, decorator: Google::Apis::ApigeeV1::GoogleTypeExpr::Representation
      
          collection :members, as: 'members'
          property :role, as: 'role'
        end
      end
      
      class GoogleIamV1Policy
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          collection :audit_configs, as: 'auditConfigs', class: Google::Apis::ApigeeV1::GoogleIamV1AuditConfig, decorator: Google::Apis::ApigeeV1::GoogleIamV1AuditConfig::Representation
      
          collection :bindings, as: 'bindings', class: Google::Apis::ApigeeV1::GoogleIamV1Binding, decorator: Google::Apis::ApigeeV1::GoogleIamV1Binding::Representation
      
          property :etag, :base64 => true, as: 'etag'
          property :version, as: 'version'
        end
      end
      
      class GoogleIamV1SetIamPolicyRequest
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :policy, as: 'policy', class: Google::Apis::ApigeeV1::GoogleIamV1Policy, decorator: Google::Apis::ApigeeV1::GoogleIamV1Policy::Representation
      
          property :update_mask, as: 'updateMask'
        end
      end
      
      class GoogleIamV1TestIamPermissionsRequest
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          collection :permissions, as: 'permissions'
        end
      end
      
      class GoogleIamV1TestIamPermissionsResponse
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          collection :permissions, as: 'permissions'
        end
      end
      
      class GoogleLongrunningListOperationsResponse
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :next_page_token, as: 'nextPageToken'
          collection :operations, as: 'operations', class: Google::Apis::ApigeeV1::GoogleLongrunningOperation, decorator: Google::Apis::ApigeeV1::GoogleLongrunningOperation::Representation
      
        end
      end
      
      class GoogleLongrunningOperation
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :done, as: 'done'
          property :error, as: 'error', class: Google::Apis::ApigeeV1::GoogleRpcStatus, decorator: Google::Apis::ApigeeV1::GoogleRpcStatus::Representation
      
          hash :metadata, as: 'metadata'
          property :name, as: 'name'
          hash :response, as: 'response'
        end
      end
      
      class GoogleProtobufEmpty
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
        end
      end
      
      class GoogleRpcPreconditionFailure
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          collection :violations, as: 'violations', class: Google::Apis::ApigeeV1::GoogleRpcPreconditionFailureViolation, decorator: Google::Apis::ApigeeV1::GoogleRpcPreconditionFailureViolation::Representation
      
        end
      end
      
      class GoogleRpcPreconditionFailureViolation
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :description, as: 'description'
          property :subject, as: 'subject'
          property :type, as: 'type'
        end
      end
      
      class GoogleRpcStatus
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :code, as: 'code'
          collection :details, as: 'details'
          property :message, as: 'message'
        end
      end
      
      class GoogleTypeExpr
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :description, as: 'description'
          property :expression, as: 'expression'
          property :location, as: 'location'
          property :title, as: 'title'
        end
      end
    end
  end
end
