// This file was generated by gir (https://github.com/gtk-rs/gir)
// from
// from gir-files (https://github.com/gtk-rs/gir-files.git)
// DO NOT EDIT

use crate::{ffi, Sidebar, SidebarItem};
use glib::{
    prelude::*,
    signal::{connect_raw, SignalHandlerId},
    translate::*,
};
use std::boxed::Box as Box_;

glib::wrapper! {
    #[doc(alias = "AdwSidebarSection")]
    pub struct SidebarSection(Object<ffi::AdwSidebarSection, ffi::AdwSidebarSectionClass>) @implements gtk::Buildable;

    match fn {
        type_ => || ffi::adw_sidebar_section_get_type(),
    }
}

impl SidebarSection {
    #[doc(alias = "adw_sidebar_section_new")]
    pub fn new() -> SidebarSection {
        assert_initialized_main_thread!();
        unsafe { from_glib_full(ffi::adw_sidebar_section_new()) }
    }

    #[doc(alias = "adw_sidebar_section_append")]
    pub fn append(&self, item: impl IsA<SidebarItem>) {
        unsafe {
            ffi::adw_sidebar_section_append(self.to_glib_none().0, item.upcast().into_glib_ptr());
        }
    }

    #[doc(alias = "adw_sidebar_section_bind_model")]
    pub fn bind_model<P: Fn(&glib::Object) -> SidebarItem + 'static>(
        &self,
        model: Option<&impl IsA<gio::ListModel>>,
        create_item_func: P,
    ) {
        let create_item_func_data: Box_<P> = Box_::new(create_item_func);
        unsafe extern "C" fn create_item_func_func<
            P: Fn(&glib::Object) -> SidebarItem + 'static,
        >(
            item: *mut glib::gobject_ffi::GObject,
            user_data: glib::ffi::gpointer,
        ) -> *mut ffi::AdwSidebarItem {
            let item = from_glib_borrow(item);
            let callback = &*(user_data as *mut P);
            (*callback)(&item).to_glib_full()
        }
        let create_item_func = Some(create_item_func_func::<P> as _);
        unsafe extern "C" fn user_data_free_func_func<
            P: Fn(&glib::Object) -> SidebarItem + 'static,
        >(
            data: glib::ffi::gpointer,
        ) {
            let _callback = Box_::from_raw(data as *mut P);
        }
        let destroy_call4 = Some(user_data_free_func_func::<P> as _);
        let super_callback0: Box_<P> = create_item_func_data;
        unsafe {
            ffi::adw_sidebar_section_bind_model(
                self.to_glib_none().0,
                model.map(|p| p.as_ref()).to_glib_none().0,
                create_item_func,
                Box_::into_raw(super_callback0) as *mut _,
                destroy_call4,
            );
        }
    }

    #[doc(alias = "adw_sidebar_section_get_item")]
    #[doc(alias = "get_item")]
    pub fn item(&self, index: u32) -> Option<SidebarItem> {
        unsafe {
            from_glib_none(ffi::adw_sidebar_section_get_item(
                self.to_glib_none().0,
                index,
            ))
        }
    }

    #[doc(alias = "adw_sidebar_section_get_items")]
    #[doc(alias = "get_items")]
    pub fn items(&self) -> gio::ListModel {
        unsafe { from_glib_full(ffi::adw_sidebar_section_get_items(self.to_glib_none().0)) }
    }

    #[doc(alias = "adw_sidebar_section_get_sidebar")]
    #[doc(alias = "get_sidebar")]
    pub fn sidebar(&self) -> Option<Sidebar> {
        unsafe { from_glib_none(ffi::adw_sidebar_section_get_sidebar(self.to_glib_none().0)) }
    }

    #[doc(alias = "adw_sidebar_section_get_title")]
    #[doc(alias = "get_title")]
    pub fn title(&self) -> Option<glib::GString> {
        unsafe { from_glib_none(ffi::adw_sidebar_section_get_title(self.to_glib_none().0)) }
    }

    #[doc(alias = "adw_sidebar_section_insert")]
    pub fn insert(&self, item: impl IsA<SidebarItem>, position: i32) {
        unsafe {
            ffi::adw_sidebar_section_insert(
                self.to_glib_none().0,
                item.upcast().into_glib_ptr(),
                position,
            );
        }
    }

    #[doc(alias = "adw_sidebar_section_prepend")]
    pub fn prepend(&self, item: impl IsA<SidebarItem>) {
        unsafe {
            ffi::adw_sidebar_section_prepend(self.to_glib_none().0, item.upcast().into_glib_ptr());
        }
    }

    #[doc(alias = "adw_sidebar_section_remove")]
    pub fn remove(&self, item: &impl IsA<SidebarItem>) {
        unsafe {
            ffi::adw_sidebar_section_remove(self.to_glib_none().0, item.as_ref().to_glib_none().0);
        }
    }

    #[doc(alias = "adw_sidebar_section_remove_all")]
    pub fn remove_all(&self) {
        unsafe {
            ffi::adw_sidebar_section_remove_all(self.to_glib_none().0);
        }
    }

    #[doc(alias = "adw_sidebar_section_set_title")]
    #[doc(alias = "title")]
    pub fn set_title(&self, title: Option<&str>) {
        unsafe {
            ffi::adw_sidebar_section_set_title(self.to_glib_none().0, title.to_glib_none().0);
        }
    }

    #[cfg(feature = "v1_9")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_9")))]
    #[doc(alias = "items")]
    pub fn connect_items_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_items_trampoline<F: Fn(&SidebarSection) + 'static>(
            this: *mut ffi::AdwSidebarSection,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"notify::items".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_items_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[cfg(feature = "v1_9")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_9")))]
    #[doc(alias = "sidebar")]
    pub fn connect_sidebar_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_sidebar_trampoline<F: Fn(&SidebarSection) + 'static>(
            this: *mut ffi::AdwSidebarSection,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"notify::sidebar".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_sidebar_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[cfg(feature = "v1_9")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_9")))]
    #[doc(alias = "title")]
    pub fn connect_title_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_title_trampoline<F: Fn(&SidebarSection) + 'static>(
            this: *mut ffi::AdwSidebarSection,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"notify::title".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_title_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }
}

#[cfg(feature = "v1_9")]
#[cfg_attr(docsrs, doc(cfg(feature = "v1_9")))]
impl Default for SidebarSection {
    fn default() -> Self {
        Self::new()
    }
}
