// Copyright (C) 1999-2012
// Smithsonian Astrophysical Observatory, Cambridge, MA, USA
// For conditions of distribution and use, see copyright notice in "copyright"

#include "colorscaletrue8.h"

ColorScaleTrueColor8::ColorScaleTrueColor8(int s, Visual* visual)
  : ColorScale(s), TrueColor8(visual)
{
  colors_ = new unsigned char[s];

  for (int i=0; i<s; i++)
    colors_[i] =
      ((psColors_[i*3]   & bm_) >> bs_) |  // blue
      ((psColors_[i*3+1] & gm_) >> gs_) |  // green
      ((psColors_[i*3+2] & rm_) >> rs_);   // red
}

ColorScaleTrueColor8::~ColorScaleTrueColor8()
{
  if (colors_)
    delete [] colors_;
}

LinearScaleTrueColor8::LinearScaleTrueColor8(int s, 
					     unsigned short* indexCells,
					     unsigned char* colorCells,
					     int count,
					     Visual* visual)
  : LinearScale(s, indexCells, colorCells, count), 
    ColorScaleTrueColor8(s, visual),
    ColorScale(s) {}

LogScaleTrueColor8::LogScaleTrueColor8(int s,
				       unsigned short* indexCells,
				       unsigned char* colorCells,
				       int count, double exp,
				       Visual* visual)
  : LogScale(s, indexCells, colorCells, count, exp), 
    ColorScaleTrueColor8(s, visual),
    ColorScale(s) {}

PowScaleTrueColor8::PowScaleTrueColor8(int s,
				       unsigned short* indexCells,
				       unsigned char* colorCells,
				       int count, double exp,
				       Visual* visual)
  : PowScale(s, indexCells, colorCells, count, exp), 
    ColorScaleTrueColor8(s, visual),
    ColorScale(s) {}

SqrtScaleTrueColor8::SqrtScaleTrueColor8(int s,
					 unsigned short* indexCells,
					 unsigned char* colorCells,
					 int count,
					 Visual* visual)
  : SqrtScale(s, indexCells, colorCells, count), 
    ColorScaleTrueColor8(s, visual),
    ColorScale(s) {}

SquaredScaleTrueColor8::SquaredScaleTrueColor8(int s,
					       unsigned short* indexCells,
					       unsigned char* colorCells,
					       int count,
					       Visual* visual)
  : SquaredScale(s, indexCells, colorCells, count), 
    ColorScaleTrueColor8(s, visual),
    ColorScale(s) {}

AsinhScaleTrueColor8::AsinhScaleTrueColor8(int s,
					   unsigned short* indexCells,
					   unsigned char* colorCells,
					   int count,
					   Visual* visual)
  : AsinhScale(s, indexCells, colorCells, count), 
    ColorScaleTrueColor8(s, visual),
    ColorScale(s) {}

SinhScaleTrueColor8::SinhScaleTrueColor8(int s,
					 unsigned short* indexCells,
					 unsigned char* colorCells,
					 int count,
					 Visual* visual)
  : SinhScale(s, indexCells, colorCells, count), 
    ColorScaleTrueColor8(s, visual),
    ColorScale(s) {}

IISScaleTrueColor8::IISScaleTrueColor8(unsigned short* indexCells,
				       unsigned char* colorCells,
				       int count,
				       Visual* visual)
  : IISScale(indexCells, colorCells, count), 
    ColorScaleTrueColor8(IISSIZE, visual),
    ColorScale(IISSIZE) {}

HistEquScaleTrueColor8::HistEquScaleTrueColor8(int s, 
					       unsigned short* indexCells,
					       unsigned char* colorCells,
					       int count,
					       double* hist, int histsize,
					       Visual* visual)
  : HistEquScale(s, indexCells, colorCells, count, hist, histsize), 
    ColorScaleTrueColor8(s, visual),
    ColorScale(s) {}


