/*
  scanner.hh, copyright (c) 2006 by Vincent Fourmond: 
  The class doing the actual scanning of a string.
  
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details (in the COPYING file).
  
*/

#ifndef _SCANNER_HH
#define _SCANNER_HH

#include <calc.hh>

namespace SCalc {
  class Scanner {
    char * buffer;
    int cur;
    int len;
    Session * sess;
    void * yyscanner;
    ParserResult * ret;		// The return value for the parser

    int node_mode; // whether some IDs could be nodes
    std::map<std::string, int> node_names;

  public:
    Scanner(const char * str, Session * session);
    int getc(); /* gets the next char or -1 if nothing more */
    ParserResult * scan(); /* does the actual scan */
    
    Session * session() { return sess;};
    ~Scanner();

    void enter_node_mode() { node_mode = 1;};
    void leave_node_mode() 
    { node_mode = 0; node_names.clear();};
    int is_node_mode() { return node_mode;};

    /// returns the node number if the string is a node
    /// and -1 if not.
    int which_node(std::string str);

    /// Convenient function
    int which_node(const char * str) 
    { return which_node(std::string(str));};

    /// returns the node number
    int add_node(std::string str);
    int add_node(const char * str)
    { return add_node(std::string(str));};

    /// returns the number of nodes so far.
    int node_numbers() { return node_names.size();};

    // gets the next token in the list...
    int yy_lex(Expression ** yylval, YYLTYPE * loc);
    void set_ret(ParserResult * r) { ret = r;};

    const char * org_buffer() { return buffer;};
  };
};

#endif
