# -*- coding: utf-8 -*-
#
# SchoolTool - common information systems platform for school administration
# Copyright (c) 2005 Shuttleworth Foundation
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
"""
Unit tests for schooltool.ldap.security
"""

import unittest
import doctest
from schooltool.ldap.security import PersonLDAPPersonPart
from schooltool.ldap.security import LDAPPerson


class TestPersonLDAPPersonPart(unittest.TestCase):

    def setUp(self):
        person = LDAPPerson(None, None)
        self.part = PersonLDAPPersonPart(person)

    def test_oneline(self):
        line = self.part.oneline(['Bob', 'Marley'])
        self.assertEqual(line, u'Bob Marley')
        vejas = [u'Šiaurės', u'Vėjas']
        # data from LDAP comes UTF-8 encoded
        vejas = [s.encode('UTF-8') for s in vejas]
        line = self.part.oneline(vejas)
        self.assertEqual(line, u'Šiaurės Vėjas')


def test_suite():
    return unittest.TestSuite([
        unittest.makeSuite(TestPersonLDAPPersonPart),
        doctest.DocTestSuite(optionflags=doctest.ELLIPSIS),
        doctest.DocFileSuite('../security.txt', optionflags=doctest.ELLIPSIS),
        ])


if __name__ == '__main__':
    unittest.main(defaultTest='test_suite')
