#ifndef OPENGLTESTWIDGET_H
#define OPENGLTESTWIDGET_H

#include <QObject>
#include <QDialog>
#include <QOpenGLBuffer>
#include <QLabel>
#include <QMenu>
#include <QCheckBox>
#include <QToolButton>
#include <QToolBar>
#include <QColorDialog>
#include <QDoubleSpinBox>
#include <QOpenGLVertexArrayObject>
#include <QOpenGLShaderProgram>
#include <QComboBox>
#include "molecule.h"
#include "qpeakview.h"


#if defined (Q_OS_MAC)
#include <QOpenGLWindow>
class PlayOpenGL: public QOpenGLWindow, protected QOpenGLExtraFunctions { //
#else
#include <QOpenGLWidget>
class PlayOpenGL: public QOpenGLWidget, protected QOpenGLExtraFunctions { //
#endif

Q_OBJECT
  public:
    explicit PlayOpenGL( Molecule *externMole);
    virtual ~PlayOpenGL()  override;
    void setMolecule(Molecule *m);
    void setMainWindow(QWidget * parent){ chparent=parent; }
    QColor farbverlaufQC(double wrt, double min, double max);
    inline void __RotateCS( float c, float s, float& X, float& Y );
    inline void __RotateCS( double c, double s, double& X, double& Y );
    void glRotateMat( QMatrix4x4 &mat, const float dang, const float x , const float y, const float z ) ;
    void glRotateMat( Matrix &mat, const float dang, const double x , const double y, const double z );
    unsigned long long frame_cnt=0;

    //QSize sizeHint() const override;
    //QSize minimumSizeHint() const override;
    bool drawBonds = true;
    bool drawAtoms = true;
    bool drawLabels = true;
    bool isMainWindow = true;
    bool isOrtho=true;
    QString theIconPath;
    int ImeanThisAtom;//!< atom index for context menu.
    QMenu *sfacMenu;//!< a sub menu to change the element of a specified atom.
    QMenu *selSfacMenu;
    QList<QVector2D> screenAtoms;
    //CEnvironment theAtoms;
    QList<QImage> altLabels;
     QToolButton *rCenter;
    V3 sumse;
    V3 altemitte;
    int inFocus = -1;
    int rotze = 1;// RotationsZentrum
    double viewAngle = 29.0;
    double previousViewAngle = 29.0;
    float pickradius=256.0f;
    int scrx=0,scry=0;
    int scrx0=0,scry0=0;
    bool rectangle=false;
    void getMVmat(GLdouble mv[16]){
        mv[0]  = static_cast<GLdouble>(mvmat(0,0));
        mv[1]  = static_cast<GLdouble>(mvmat(1,0));
        mv[2]  = static_cast<GLdouble>(mvmat(2,0));
        mv[3]  = static_cast<GLdouble>(mvmat(3,0));

        mv[4]  = static_cast<GLdouble>(mvmat(0,1));
        mv[5]  = static_cast<GLdouble>(mvmat(1,1));
        mv[6]  = static_cast<GLdouble>(mvmat(2,1));
        mv[7]  = static_cast<GLdouble>(mvmat(3,1));

        mv[8]  = static_cast<GLdouble>(mvmat(0,2));
        mv[9]  = static_cast<GLdouble>(mvmat(1,2));
        mv[10] = static_cast<GLdouble>(mvmat(2,2));
        mv[11] = static_cast<GLdouble>(mvmat(3,2));


        mv[12] = static_cast<GLdouble>(mvmat(0,3));
        mv[13] = static_cast<GLdouble>(mvmat(1,3));
        mv[14] = static_cast<GLdouble>(mvmat(2,3));
        mv[15] = static_cast<GLdouble>(mvmat(3,3));

    }

    double envirange;
    QVector4D rotstat;

    QTimer *idl;//! idle rotation timer
    QTimer *idl_end;//! idle rotation timer

    QList<int> lastClicked();


    bool hiddenThings=false;//!< We know that there are hidden objects.
    bool neutrons=false;//!< true if we have neuton scattering factors (negative Fo map is shown if this is true)
    bool atomsClickable=true;
    int SDM_Limit; //!< if the number of atoms in the au exceeds this limit shortest distance is not computed automatically default 350
    bool inRenameMode=false;//!< if true wee are in rename mode
    bool exporting;//!< for exporting bitmaps

    QToolButton *invertMouseZoom=nullptr;//!< inverts the mouse direction that zoom on right click.
    QDoubleSpinBox *pickRadSpin=nullptr;    


    bool altpivot=false;
    QComboBox *pivot1cb=nullptr;
    QComboBox *pivot2cb=nullptr;
    QDoubleSpinBox *axx=nullptr;
    QDoubleSpinBox *axy=nullptr;
    QDoubleSpinBox *axz=nullptr;
    QDoubleSpinBox *orgx=nullptr;
    QDoubleSpinBox *orgy=nullptr;
    QDoubleSpinBox *orgz=nullptr;
    QCheckBox *manualAx=nullptr;
    QCheckBox *freeRot=nullptr;
    QLabel *whyNotSplit=nullptr;
    QSpinBox *angle1=nullptr;
    QSpinBox *angle2=nullptr;
//    void initLists();
    bool canSplitRotate();

    Connection apair;
    bool showPickRad=false;
    QColor labelColor;//!< Color of atom labels.
    QColor selectedLabelColor;
    QColor focusedLabelColor;

    QColor labelBGColor;//!< Color of atom labels.
    QColor selectedLabelBGColor;
    QColor focusedLabelBGColor;
    QColor backGroundColor;//!< Base color of the back groud.
    struct labz{
    int x,y;
    QString l;
    int an;
    };//!< struct labels for exporting bitmaps
    QList<labz> LabelZ;//!< labels for exporting bitmaps


//variables for maps...
    double       lintrans;//!<degree of thansparency for the maps 0-1. 0 is transparent.
    double       linwidth;//!<linewidth of the meshes.
    double       contMin;
    double       contMax;
    QColor       fopc;//!< Fo positive color
    QColor       fomc;//!< Fo negative color
    QColor       dipc;//!< Fo-Fc positive color
    QColor       dimc;//!< Fo-Fc negative color
    QCheckBox   *lighting;//!< enable lighting on the electron density.
    QCheckBox   *niceTrans;//!< draw 6 perspectives for each surface to improve transparent visualization.
    QCheckBox   *fillMap;//!< draw maps in filled style.
    QAction     *foact; //!< QAction toggling Fobs maps.
    QAction     *fofcact;//!< QAction toggling Fobs-Fcalc maps.
    QVector< QVector< float > > fVertexes;
    QVector< QVector< float > > fNormals;
    bool vbyeye(VPoly a,VPoly b);
    int commonFaces(Vert a,Vert b, int f[2]);
    void voronoij(CEnvironment au, int intat);
    QList<VPoly> vtriangles;
    float InversionCenterRadius = 0.15;
    float planeTransparence=0.2;
    float glideVectorThickness=0.04;
    float axisThickness=0.04;
    float planeFrameThinkness=0.04;    
    double legend_sc = 0.6;
    /*
    QList<PPoly> ptriangles;
    QList<V3>  axvecs;
    QList<int> axcols;
    QList<int> axoprs;
    QList<int> invoprs;
    QList<V3>  invvecs;*/
    void setMapsStuff();
    /*void setMapsStuff(QVector< QVector< float > > &_fVertexes,
                      QVector< QVector< float > > &_fNormals,
                      double    *_lintrans,
                      double    *_linwidth,
                      QColor    *_fopc,
                      QColor    *_fomc,
                      QColor    *_dipc,
                      QColor    *_dimc,
                      QCheckBox *_lighting,
                      QCheckBox *_niceTrans,
                      QCheckBox *_fillMap,
                      QAction   *_foact,
                      QAction   *_fofcact
                      );*/


    //QAction *centerSelection;

    QAction *h_bonds=nullptr;
    QAction *adp=nullptr;
    QAction *tubes=nullptr;
    QAction *ballStick=nullptr;
    QAction *QPeakLegend=nullptr;
    QAction *hideHydrogen=nullptr;
    QAction *addBond=nullptr;//!< QAction BIND
    QAction *killBond=nullptr;//!< QAction FREE
    QAction *clearSelection=nullptr;//!< QAction deselect
    QAction *centerSelection=nullptr;//!< QAction center selected atoms
    QAction *hideNotSelection=nullptr;//!< QAction hide non selected atoms
    QAction *unhide=nullptr;//!< QAction show all previous hidden objects
    QAction *invhide=nullptr;//!< QAction show all previous hidden and hide visible objects
    QAction *grow=nullptr;//!< QAction grow
    QAction *fuse=nullptr;//!< QAction fuse
    QAction *shpm1=nullptr;//!< QAction show part -N ghost
    QAction *qPeakBonds=nullptr;//!< QAction Q-Peak binds
    QAction *toggleDockWidgets=nullptr;//!< QAction hide text windows
    QAction *delSelAt=nullptr;//!< QAction delete selected atoms
    QAction *highlightParts=nullptr; //!< QAction highlight atoms in parts != 0
    QAction *centroid=nullptr; //!< QAction create a centroid dummy
    QAction *enviNoQ=nullptr;//!< QAction ENVI only for real atoms
    QAction *enviCova=nullptr;//!< QAction ENVI only for covalent contacts
    QAction *invSelection=nullptr;//!< QAction invert selection
    QAction *cntrPlot=nullptr;
    QAction *nocntrPlot=nullptr;
    QAction *rainbowPlot=nullptr;
    QAction *togUnit=nullptr;
    QAction *toggleOrthoView=nullptr;
    QAction *hideBeLo=nullptr;//!< hide/show  BEDE and LONE objects
    QAction *shortLabels=nullptr;//!< Labels without residue number or symmery flag are considered short
    QAction *atomLegend=nullptr;//!< a key legend for atoms used
    double retinafktr=1.0;
    //float bondStrength = 0.05f;
    float qcutoff= -10.0;
    //int LOD = 8;
    double getScaleing(){ return L; }
    QFont myFont;//!< there is a Font for Labels of atoms
    QFont nonAtomFont;//!< there is a Font for Labels of Q-Peaks
    bool bggradient = true;
    bool shaderInfo = false;
    //QColor bgcolor = QColor("lightskyblue");

    Molecule *mol;
    QToolButton *enviButt;//!< Button to clear the envi -ronment.
    QToolButton *enviSelect;//!< Button to select the envi -ronment.
    QList<V3>enviPositions;//!<List of atom postions of an envi-ronment.
    QList<V3> cont;
    QMap<int,GLfloat> contval;
    QList<int>enviKat;//!< List of categorie:qs of contacts in an envi-ronment.
    V3 enviP0;//!< coordinate used for envi.
    QStringList labs;//!< Labels for an envi-ronment list.
    bool burnGPU = false; // true is to measure FPS
    bool isReady(){ return ready;}
    void makeBonds(const CEnvironment &atoms, const Connection &bonds, const Connection &lbonds, Connection &hbonds);//, float* atomColors
    void makeAtoms(const CEnvironment &atoms);
    void makeClassicAtoms(const CEnvironment &atoms);
    void makeSelectedAtoms();
    void makeBackGround();
    void makeEnvi();
    void makeSplitRot();
    void makeSymmetryElements();
    void makeUnitCell();
    void makeContours();
    void contDestruct();
    void voroDestruct();
    void pushRotStat();
    void popRotStat();
 signals:
    //void message(const QString &);//!< small text messages to the status bar.
    //void qpfoci(double height);//!< when a mouse hovers a Q-Peak the height is emitted to the Q-Peak Legend.

    void no_hw_st();//!< we have no hard ware stereo sorry!
    void message(const QString &);//!< small text messages to the status bar.
    void bigmessage(const QString &);//!< passes HTML strings to the info window.
    void jumpit(int index);//!<An atom has ben left clicked: cursor jump on it.
    void selectionChanged();
    void movedByUser();
    void diffscroll(int numsteps,int diff);//!< to change the iso value of the Fo- or Fo-Fc maps
    void neuemitte(V3 mitte);//!< the rotation center has changet to mitte.
    void inimibas();//!< tells FourXle to initialize the GL display lists.
    void qpfoci(double height);//!< when a mouse hovers a Q-Peak the height is emitted to the Q-Peak Legend.
    void insertDFIX(double value, double esd, QList<MyAtom> selected, QString resiSpec); //!< Insert DFIX restrain to the ins file
    void bindthem();
    void splitable(bool ok);
    void insertDANG(double value, double esd, QList<MyAtom> selected, QString resiSpec); //!< Insert DANG restrain to the ins file
    void insertFLAT(double esd, QList<MyAtom> selected, QString resiSpec); //!< Insert FLAT restrain to the ins file
    void insertEXYZ(QList<MyAtom> selected); //!< Insert EXYZ restrain to the ins file
    void insertEADP(QList<MyAtom> selected); //!< Insert EADP restrain to the ins file
    void insertSADI(int selected); //!< Insert SADI restrain to the ins file
    void insertDELU(double esd1, double esd2, QList<MyAtom> selected, QString resiSpec); //!< Insert DELU restrain to the ins file
    void insertSIMU(double esd1, double st, double dmax, QList<MyAtom> selected, QString resiSpec); //!< Insert SIMU restrain to the ins file
    void insertISOR(double esd1, double esd2, QList<MyAtom> selected, QString resiSpec); //!< Insert ISOR restrain to the ins file
    void insertRIGU(double esd1, double esd2, QList<MyAtom> selected, QString resiSpec); //!< Insert DELU restrain to the ins file
    void insertCHIV(double Vol, double esd1, QList<MyAtom> selected, QString resiSpec); //!< Insert CHIV restrain to the ins file
    void insertANIS(QList<MyAtom> selected); //!< Insert ANIS instruction for selected atoms
    void pivot1Changed(int i);
    void pivot2Changed(int i);
    void initialized();
    void viewAngeleChanged(double);
    void rebuffer(QVector< QVector< float > > &v, QVector< QVector< float > > &n);
public slots:
    void rebuf(){
        emit rebuffer(fVertexes,fNormals);
    }
    void addANIS();
    void addCHIV();
    void addDANG();
    void addDELU();
    void addDFIX();
    void addEADP();
    void addEXYZ();
    void addFLAT();
    void addISOR();
    void addRIGU();
    void addSADI();
    void addSIMU();
    void changeEnviRange();
    void makeLegendAtoms();

    void changeBColor(){//! a color dialog for chosing a new back ground color
        QColor c= QColorDialog::getColor(backGroundColor);
        if(c.isValid()) backGroundColor=c;
        update();
      }
    void changeTColor(){//! a color dialog for chosing a new back ground color
        QColor c= QColorDialog::getColor(backGroundColor);
        if(c.isValid()) labelColor=c;
        update();
      }
    double pickRad(){
        return sqrt(pickradius);
    }

    void setPickRad(double r){
        pickradius = r*r;
        showPickRad=true;
    }

    void changePivot1(int i){pivot=i;splitRotate();emit splitable(canSplitRotate()); }
    void changePivot2(int i){pivot2=i;splitRotate();emit splitable(canSplitRotate());}
    void invertSelection(){
        CEnvironment tempa=mol->selectedatoms;
        //  printf("invert %d %d\n",tempa.size(),mol->selectedatoms.size());
        mol->selectedatoms.clear();

        for (int i=0; i<mol->showatoms.size();i++){
          if (!tempa.contains(mol->showatoms.at(i))) {
            mol->selectedatoms.append(mol->showatoms[i]);
            mol->selectedatoms.last().style=i;
          }
        }
        rehide();
        updateBondActions();
        update();
    }

    void invertHidden(){
        if (!hiddenThings) return; // nothing is hidden => hide everything now? NO!
        hideHydrogen->setVisible(!hideHydrogen->isVisible());
        for (int i=0;i<mol->legendAtoms.size();i++) mol->legendAtoms[i].hidden=1;
        QHash<int,bool> anExists;
        for (int i = 0; i < mol->showatoms.size(); i++){
          mol->showatoms[i].hidden = (mol->showatoms.at(i).hidden!=0)?0:1;
          if (!mol->showatoms.at(i).hidden) anExists[mol->showatoms.at(i).an]=true;
          printf("%-4s %d %d\n",mol->showatoms.at(i).Label.toStdString().c_str(),mol->showatoms.at(i).hidden,mol->showatoms.at(i).an);
        }
        for (int i=0;i<mol->legendAtoms.size();i++) if (anExists.contains(mol->legendAtoms.at(i).an)) mol->legendAtoms[i].hidden=0;
        //frid=-10;
        //hideReason=0;
        mol->selectedatoms.clear();
        //murx=__LINE__;
        makeAtoms(mol->showatoms);
        makeBonds(mol->showatoms, mol->showbonds, mol->lbonds, mol->theH_Bonds);
        updateBondActions();
        update();
    }

    void hideHydrogens(){
        hiddenThings=true;
        //printf("hiddenThings hideHydrogens\n");
        hideHydrogen->setVisible(false);
        for (int i=0;i<mol->showatoms.size();i++) mol->showatoms[i].hidden=
          (mol->showatoms.at(i).an==0)?1:mol->showatoms.at(i).hidden;
        for (int i=0;i<mol->legendAtoms.size();i++) mol->legendAtoms[i].hidden=
            (mol->legendAtoms.at(i).an==0)?1:mol->legendAtoms.at(i).hidden;
        mol->selectedatoms.clear();
        makeAtoms(mol->showatoms);
        makeBonds(mol->showatoms, mol->showbonds, mol->lbonds, mol->theH_Bonds);
        updateBondActions();
        update();
    }
    void hidePartMinusOne(bool b){
        update();
    }
    void clearEnvi();
    void envi();
    void growEnvi();
    void showEnvi();
    void expand();
    void getReady(){ready=true;}
    void hideOtherFragments();
    void hideSelected();
    void hideThisFragment();
    void hideNonSelected(){
        for (int i=0;i<mol->showatoms.size();i++) mol->showatoms[i].hidden=1;
        for(int i=0;i<mol->selectedatoms.size();i++){
          if (mol->selectedatoms.at(i).style < mol->showatoms.size())
            mol->showatoms[mol->selectedatoms.at(i).style].hidden=0;
          //   std::cout<<mol->showatoms.at(mol->selectedatoms.at(i).style).Label.toStdString()<<std::endl;
        }
        hiddenThings=true;
        //hideReason|=HIDE_REASON_SELECT;
        mol->selectedatoms.clear();
        //murx=-__LINE__;

        makeAtoms(mol->showatoms);
        makeBonds(mol->showatoms, mol->showbonds, mol->lbonds, mol->theH_Bonds);
        updateBondActions();
        update();
    }
    void selectEnvi();
    void selectThisFragment();
    void selectResiByNr(int nr){
        //todo
        mol->selectedatoms.clear();
        apair.clear();
        for (int i=0; i<mol->showatoms.size();i++){
          if (mol->showatoms.at(i).resiNr==nr) {
            mol->selectedatoms.append(mol->showatoms[i]);
            mol->selectedatoms.last().style=i;
          }
        }
        //draw();
        if (hiddenThings) hideNonSelected();
        updateBondActions();
        update();
    }

    void showMatrix(){
        //todo
    }

    void setReNaMo(bool b){
        inRenameMode = b;
    }

    void saveOrientation(){
        //todo
    }

    void loadOrientation(){
        //todo
    }

    void fertig(){
     //   habzutun=false;
        update();
        //printf("map veritces ready!\n");
    }
    void setRotationCenter();
    void setRotationCenter(int rz);
    void setLabelSize(int s);
    void setRotationCenter(V3 center);
    void toogleWithSymmetry(bool b);
    void singleBondDistance();

    void zoomOut(){
        //todo
    }

    void wuff(){
      bool beloff=hideBeLo->isChecked();
      for (int i=0;i<mol->showatoms.size();i++) if (mol->showatoms.at(i).an==-42) mol->showatoms[i].hidden=(beloff)?0:1;
      for (int i=0;i<mol->legendAtoms.size();i++) if (mol->legendAtoms.at(i).an==-42) mol->legendAtoms[i].hidden=(beloff)?0:1;
      hiddenThings=hiddenThings||(!hideBeLo->isChecked());
      mol->selectedatoms.clear();
      updateBondActions();
      update();

    }
    void showHidden(){
        printf("show hidden\n");
        int h=0;
        for (int i=0;i<mol->showatoms.size();i++){
          mol->showatoms[i].hidden=0;
          if (mol->showatoms[i].an==0)h++;
        }
        for (int i=0;i<mol->legendAtoms.size();i++) mol->legendAtoms[i].hidden=0;
        if (h) hideHydrogen->setVisible(true);
        hiddenThings=false;
        hideBeLo->setChecked(true);//toggle state is OK this way
        wuff();
        makeAtoms(mol->showatoms);
        makeBonds(mol->showatoms, mol->showbonds, mol->lbonds, mol->theH_Bonds);
        makeLegendAtoms();
        updateBondActions();
        update();
    }//todo!

    void splitRotate();
    void rehide(){

        makeAtoms(mol->showatoms);
        makeBonds(mol->showatoms, mol->showbonds, mol->lbonds, mol->theH_Bonds);
        updateBondActions();
    }//todo!!
    void toggleOrtho(bool b);
    void orthor(){
        setViewAngle(viewAngle);
    }
    void makeMaps(QVector< QVector< float > > &v,QVector< QVector< float > > &n);
    void highliteQPeak(double co);
    void along001();
    void zoom(double speed);
    //bool isFO(){return drawFO;}//!< if Fo map is visible true is returned.
    //bool isDF(){return drawDF;}//!< if Fo-Fc map is visible true is returned.
    //void warFaul(){warfaul=true;}
    void gZoom(double speed);
    void rotZ(double speed=0.01);
    void rotY(double speed=0.01);
    void rotX(double speed=0.01);
    void moveX(double speed);
    void moveY(double speed);
    void makeLabels();
    void renderText(const QVector2D &scpos, const QString &text, int an);    
    void renderText(const QVector2D &scpos, const QString &text, int an, int pts);
    void renderText(const QVector2D &scpos,int i);
    void renderRect();
    void renderText(const V3 &pos, const QString &text, QColor &color, uint bg = Qt::lightGray);
    void renderText(QMatrix4x4 mat, int w, int h, const V3 &pos, const QString &text, QColor &color, uint bg = Qt::lightGray);
    void rotCenter();
    void setAtoms(bool b){drawAtoms = b; update();}
    void setBonds(bool b){drawBonds = b; update();}
    void setBondStrength(double s){ mol->bondStrength = static_cast<float>(s);update();}
    void setLabels(bool b){drawLabels = b; update();}
    void setBGGradient(bool b){bggradient=b; update();}
    void setLOD(int l){mol->LOD=l;update();}
    void homeXY();
    void setViewAngle(double ang);
    void setQpeakCutoff(double cut){
        qcutoff = static_cast<float>(cut);
        update();
    }
    void toggleAutoUpdate(int b){
        burnGPU = (b==Qt::Checked);
        if (burnGPU){
            if (!tmr){
                tmr = new QTimer();
                connect(tmr, &QTimer::timeout, this, &PlayOpenGL::reportFPS);
            }
          tmr->start(1000);
        
        }else{
          if (tmr) tmr->stop();
        }
        printf("burn GPU! %d\n",burnGPU);
        update();
    }
    void updateBondActions();
    void updateSceenAtoms();

    void connectSelection();
    void disConnectSelection(int index);
    void disSelection();
    void reportFPS(){
        if (!burnGPU) return;
      QString s = QString("FPS: %1").arg(frame_cnt / 1.0,0,'f',1);
      frame_cnt = 0;
      emit message(s);
    }
protected:
 void initializeGL() override;
 void resizeGL(int width, int height) override;
 void paintGL() override;
 void mouseMoveEvent(QMouseEvent *event) override;
 void mousePressEvent(QMouseEvent *event) override;
 void wheelEvent(QWheelEvent *event) override; 
 void contextMenuEvent(QMouseEvent *event);// override;
private:
 QWidget *chparent;
 QTimer *tmr = nullptr;
 QMenu *menu = nullptr;
 QMenu *restrMenu = nullptr ;
 QMenu *constrMenu = nullptr;
 QMenu *enviMenu = nullptr;
 bool ready=false;
 int withsymm;

 QList<int> seat;//selected atoms indices for splitrotation
 int pivot;
 int pivot2;
 int ppp=0,pp=0,p=0;//there is no need this should longer GLuint 26.02.2020
 QString glTypeInt2String(int ityp);
 QStringList resis();
 void programInfo(QOpenGLShaderProgram *p, const QString pname);
 double moux, mouy,L;
QOpenGLVertexArrayObject bond_vao;
QOpenGLVertexArrayObject atom_vao;
QOpenGLVertexArrayObject catom_vao;
QOpenGLVertexArrayObject latom_vao;
QOpenGLVertexArrayObject bg_vao;
QOpenGLVertexArrayObject slct_vao;
QOpenGLVertexArrayObject map_vao;
QOpenGLVertexArrayObject voro_vao;
QOpenGLVertexArrayObject envi_vao;
QOpenGLVertexArrayObject uc_vao;
QOpenGLVertexArrayObject cont_vao;
QOpenGLVertexArrayObject symm_vao0;
QOpenGLVertexArrayObject symm_vao1;
QOpenGLVertexArrayObject symm_vao2;
QOpenGLVertexArrayObject splitrot_vao;

QOpenGLBuffer atom_vertexBuffer;
QOpenGLBuffer atom_indexBuffer;

QOpenGLBuffer catom_vertexBuffer;
QOpenGLBuffer catom_indexBuffer;

QOpenGLBuffer latom_vertexBuffer;
QOpenGLBuffer latom_indexBuffer;

QOpenGLBuffer satom_vertexBuffer;
QOpenGLBuffer satom_indexBuffer;

int atom_index_size;
int catom_index_size;

int latom_index_size;

int axend = 0;
int invend = 0;
int planend = 0;
int glend = 0;
QOpenGLBuffer backGround_vertexBuffer;
QOpenGLBuffer bond_vertexBuffer;
QOpenGLBuffer bond_indexBuffer;
QOpenGLBuffer map_vertexBuffer;
QOpenGLBuffer envi_vertexBuffer;
QOpenGLBuffer voro_vertexBuffer;
QOpenGLBuffer uc_vertexBuffer;
QOpenGLBuffer cont_vertexBuffer;
QOpenGLBuffer symm_vertexBuffer0;
QOpenGLBuffer symm_vertexBuffer1;
QOpenGLBuffer symm_vertexBuffer2;
QOpenGLBuffer splitrot_vertexBuffer;
QOpenGLBuffer splitrot_indexBuffer;

QOpenGLShaderProgram  *symm_program0 = nullptr;
QOpenGLShaderProgram  *symm_program1 = nullptr;
QOpenGLShaderProgram  *symm_program2 = nullptr;
QOpenGLShaderProgram  *splitrot_program = nullptr;
QOpenGLShaderProgram  *cont_program = nullptr;
QOpenGLShaderProgram  *uc_program = nullptr;
QOpenGLShaderProgram  *voro_program = nullptr;
QOpenGLShaderProgram    *bg_program = nullptr;
QOpenGLShaderProgram   *map_program = nullptr;
QOpenGLShaderProgram  *bond_program = nullptr;
QOpenGLShaderProgram  *atom_program = nullptr;// let's nuce the code with this name ;-P
QOpenGLShaderProgram  *catom_program = nullptr;
QOpenGLShaderProgram *satom_program = nullptr;
QOpenGLShaderProgram  *envi_program = nullptr;
QList<int> offsets;
QMatrix4x4 pmv;
QMatrix3x3 nm;
QVector4D eye;
int nbondx2=0;

int bondStrengthloc;
int lodloc;
V3 screenRotx=V3(1,0,0);
V3 screenRoty=V3(0,1,0);
V3 SRorg=V3(0,0,0);


QMatrix4x4 pmat, mvmat;
Matrix freeRotMat=Matrix(1,0,0 ,0,1,0, 0,0,1);
double fdx=0.0;
double fdy=0.0;
GLfloat ang;
void findPivot();
};


class OpenGLTestWidget : public QDialog {
    Q_OBJECT
public:
    explicit OpenGLTestWidget(Molecule *externMole, QList<QAction*> &acts, QWidget *parent = nullptr);
    PlayOpenGL *ogl;
    QLabel *fpslabel;
    QLabel *messagelabel;
    QPeakView *qpv;
    QToolBar *vito;
    QDoubleSpinBox *fov;
    QWidget *container;
    QSize sizeHint() const override;
    QSize minimumSizeHint() const override;

public slots:
    void printFPS();
    void updateMessage(QString);
    void setViewAngle(double);
signals:

};

#endif // OPENGLTESTWIDGET_H
